/************************************************************************
* FILE:        I_veda_lang_handler.h
* PROJECT:
* SW-COMPONENT:Vehicle Data
*----------------------------------------------------------------------
*
* DESCRIPTION: Abstract class to control all Language related features
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author                | Modification
* 08.07.2015| RBEI/ECV4 Ravi Deora  | initial version
*
*************************************************************************/

#ifndef _I_VEDA_LANG_MAIN_H_
#define _I_VEDA_LANG_MAIN_H_

#include "veda_AppMain.h"

enum enLangSources {
   HMI = 0,
   METER,
   SDS,
   SYSTEM,
   DIAG,
   SOURCE_LIST_END
};

//! class definition
class Iveda_tclLanguageHandler : public veda_tclBaseIf
{
public:
   Iveda_tclLanguageHandler(veda_tclAppMain* poMainAppl):veda_tclBaseIf(poMainAppl) {}
   virtual ~Iveda_tclLanguageHandler() {}

   virtual const tChar* getIfName() const { return "Iveda_tclLanguageHandler"; };
   virtual tVoid vHandleTraceMessage(const tUChar* /*puchData*/) = 0;
   virtual tVoid _vUpdateLanguageProfile(tVoid) = 0;
};

#endif //! _I_VEDA_LANG_MAIN_H_
