
#pragma once

/*!
  *  \file mcanEnumTypes.h
  *  \brief generated file containing enumeration info for MCAN communication.
  *         generated at  : --.--.2016
  *         generated with: python .\genericCodeGen.py -i .\tmpl\mcanEnumTypes.h.tpl -b .\CanSimu2\config\mcan -o .\enumTest\mcanEnumTypes.h
*/

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include <vector>

#include "mcanGenericTypes.h"
#include "mcanEnumTypes.h"

class tcl_ITM_TCU_Unit_ID
{
public:
   tcl_ITM_TCU_Unit_ID();
   
   tcl_ITM_TCU_e32_Unit_ID_2 eUnit_ID;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Unit_ID const& lhs, tcl_ITM_TCU_Unit_ID const& rhs);
tBool operator!=(tcl_ITM_TCU_Unit_ID const& lhs, tcl_ITM_TCU_Unit_ID const& rhs);

class tcl_ITM_TCU_Msg_Version
{
public:
   tcl_ITM_TCU_Msg_Version();
   
   tcl_MCAN_GenericType_UnsignedInteger uiVersion_Upper_;
   tcl_MCAN_GenericType_UnsignedInteger uiVersion_Middle_;
   tcl_MCAN_GenericType_UnsignedInteger uiVersion_Lower_;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Msg_Version const& lhs, tcl_ITM_TCU_Msg_Version const& rhs);
tBool operator!=(tcl_ITM_TCU_Msg_Version const& lhs, tcl_ITM_TCU_Msg_Version const& rhs);

class tcl_ITM_TCU_Invalid_Parameter
{
public:
   tcl_ITM_TCU_Invalid_Parameter();
   
   tcl_ITM_TCU_e32_Invalid_Parameter eInvalid_Parameter;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Invalid_Parameter const& lhs, tcl_ITM_TCU_Invalid_Parameter const& rhs);
tBool operator!=(tcl_ITM_TCU_Invalid_Parameter const& lhs, tcl_ITM_TCU_Invalid_Parameter const& rhs);

class tcl_ITM_TCU_Service_State
{
public:
   tcl_ITM_TCU_Service_State();
   
   tcl_ITM_TCU_e32_Service_State eService_State;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Service_State const& lhs, tcl_ITM_TCU_Service_State const& rhs);
tBool operator!=(tcl_ITM_TCU_Service_State const& lhs, tcl_ITM_TCU_Service_State const& rhs);

class tcl_ITM_TCU_Location_Info
{
public:
   tcl_ITM_TCU_Location_Info();
   
   tcl_ITM_TCU_e32_Datum eLocation_Type;
   tcl_ITM_TCU_e32_North_South eLattitude_Mode;
   tcl_ITM_TCU_e32_East_West eLongitude_Mode;
   tcl_MCAN_GenericType_UnsignedInteger uiLattitude_DEG;
   tcl_MCAN_GenericType_UnsignedInteger uiLattitude_MIN;
   tcl_MCAN_GenericType_UnsignedInteger uiLattitude_SEC;
   tcl_MCAN_GenericType_UnsignedInteger uiLongitude_DEG;
   tcl_MCAN_GenericType_UnsignedInteger uiLongitude_MIN;
   tcl_MCAN_GenericType_UnsignedInteger uiLongitude_SEC;
   tcl_ITM_TCU_e32_Sign eAltitude_Sign;
   tcl_MCAN_GenericType_UnsignedInteger uiAltitude_Value;
   tcl_MCAN_GenericType_UnsignedInteger uiSatellite_Number;
   tcl_ITM_TCU_e32_Registered_Point eHome;
   tcl_MCAN_GenericType_StreamData aReserve;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Location_Info const& lhs, tcl_ITM_TCU_Location_Info const& rhs);
tBool operator!=(tcl_ITM_TCU_Location_Info const& lhs, tcl_ITM_TCU_Location_Info const& rhs);

class tcl_ITM_TCU_Date_Time
{
public:
   tcl_ITM_TCU_Date_Time();
   
   tcl_MCAN_GenericType_UnsignedInteger uiYear;
   tcl_MCAN_GenericType_UnsignedInteger uiMonth;
   tcl_MCAN_GenericType_UnsignedInteger uiDay;
   tcl_MCAN_GenericType_UnsignedInteger uiHour;
   tcl_MCAN_GenericType_UnsignedInteger uiMinute;
   tcl_MCAN_GenericType_UnsignedInteger uiSecond;
   tcl_MCAN_GenericType_StreamData aReserve;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Date_Time const& lhs, tcl_ITM_TCU_Date_Time const& rhs);
tBool operator!=(tcl_ITM_TCU_Date_Time const& lhs, tcl_ITM_TCU_Date_Time const& rhs);

class tcl_ITM_TCU_Version
{
public:
   tcl_ITM_TCU_Version();
   
   tcl_MCAN_GenericType_UnsignedInteger uiVersion_Upper_;
   tcl_MCAN_GenericType_UnsignedInteger uiVersion_Middle_;
   tcl_MCAN_GenericType_UnsignedInteger uiVersion_Lower_;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Version const& lhs, tcl_ITM_TCU_Version const& rhs);
tBool operator!=(tcl_ITM_TCU_Version const& lhs, tcl_ITM_TCU_Version const& rhs);

class tcl_ITM_TCU_Provision_Service_List
{
public:
   tcl_ITM_TCU_Provision_Service_List();
   
   tcl_ITM_TCU_e32_Available_Disable eOperator_Service;
   tcl_ITM_TCU_e32_Available_Disable eConnected_Search;
   tcl_ITM_TCU_e32_Available_Disable eMobile_Information;
   tcl_MCAN_GenericType_StreamData aReserve_Nissan;
   tcl_ITM_TCU_e32_Available_Disable eInternet_Widget;
   tcl_ITM_TCU_e32_Available_Disable eFuel_Price;
   tcl_ITM_TCU_e32_Available_Disable eLocal_Search;
   tcl_ITM_TCU_e32_Available_Disable eWeb_Pre_Trip;
   tcl_ITM_TCU_e32_Available_Disable eHD_Traffic;
   tcl_ITM_TCU_e32_Available_Disable eSpeed_Trap;
   tcl_ITM_TCU_e32_Available_Disable ePrevent_NAV;
   tcl_ITM_TCU_e32_Available_Disable eWeather;
   tcl_ITM_TCU_e32_Available_Disable eLive_Services;
   tcl_ITM_TCU_e32_Available_Disable eCharging_Spot_Finder;
   tcl_ITM_TCU_e32_Available_Disable eCharging_Scheduler;
   tcl_MCAN_GenericType_StreamData aReserve_Renault;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Provision_Service_List const& lhs, tcl_ITM_TCU_Provision_Service_List const& rhs);
tBool operator!=(tcl_ITM_TCU_Provision_Service_List const& lhs, tcl_ITM_TCU_Provision_Service_List const& rhs);

class tcl_ITM_TCU_VIN
{
public:
   tcl_ITM_TCU_VIN();
   
   tcl_MCAN_GenericType_StreamData strVIN;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_VIN const& lhs, tcl_ITM_TCU_VIN const& rhs);
tBool operator!=(tcl_ITM_TCU_VIN const& lhs, tcl_ITM_TCU_VIN const& rhs);

class tcl_ITM_TCU_Vehicle_Heading
{
public:
   tcl_ITM_TCU_Vehicle_Heading();
   
   tcl_MCAN_GenericType_UnsignedInteger uiVehicle_Heading;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Vehicle_Heading const& lhs, tcl_ITM_TCU_Vehicle_Heading const& rhs);
tBool operator!=(tcl_ITM_TCU_Vehicle_Heading const& lhs, tcl_ITM_TCU_Vehicle_Heading const& rhs);

class tcl_ITM_TCU_Reminder_Info
{
public:
   tcl_ITM_TCU_Reminder_Info();
   
   tcl_ITM_TCU_e32_ON_OFF ePlugin_Mode;
   tcl_ITM_TCU_e32_ON_OFF eStop_Mode;
   tcl_MCAN_GenericType_UnsignedInteger uiRemain_Time;
   tcl_MCAN_GenericType_UnsignedInteger uiReserve;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Reminder_Info const& lhs, tcl_ITM_TCU_Reminder_Info const& rhs);
tBool operator!=(tcl_ITM_TCU_Reminder_Info const& lhs, tcl_ITM_TCU_Reminder_Info const& rhs);

class tcl_ITM_TCU_NAVI_ID
{
public:
   tcl_ITM_TCU_NAVI_ID();
   
   tcl_MCAN_GenericType_StreamData strNAVI_ID;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_NAVI_ID const& lhs, tcl_ITM_TCU_NAVI_ID const& rhs);
tBool operator!=(tcl_ITM_TCU_NAVI_ID const& lhs, tcl_ITM_TCU_NAVI_ID const& rhs);

class tcl_ITM_TCU_TCU_ID
{
public:
   tcl_ITM_TCU_TCU_ID();
   
   tcl_MCAN_GenericType_StreamData strTCU_ID;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_TCU_ID const& lhs, tcl_ITM_TCU_TCU_ID const& rhs);
tBool operator!=(tcl_ITM_TCU_TCU_ID const& lhs, tcl_ITM_TCU_TCU_ID const& rhs);

class tcl_ITM_TCU_ICC_ID
{
public:
   tcl_ITM_TCU_ICC_ID();
   
   tcl_MCAN_GenericType_StreamData strICC_ID;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_ICC_ID const& lhs, tcl_ITM_TCU_ICC_ID const& rhs);
tBool operator!=(tcl_ITM_TCU_ICC_ID const& lhs, tcl_ITM_TCU_ICC_ID const& rhs);

class tcl_ITM_TCU_PIN
{
public:
   tcl_ITM_TCU_PIN();
   
   tcl_MCAN_GenericType_UnsignedInteger uiPIN_ID_Length;
   tcl_MCAN_GenericType_StreamData vstrPIN_ID_Text;
   tcl_MCAN_GenericType_UnsignedInteger uiPIN_Password_Length;
   tcl_MCAN_GenericType_StreamData vstrPIN_Password_Text;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_PIN const& lhs, tcl_ITM_TCU_PIN const& rhs);
tBool operator!=(tcl_ITM_TCU_PIN const& lhs, tcl_ITM_TCU_PIN const& rhs);

class tcl_ITM_TCU_Distance_Unit
{
public:
   tcl_ITM_TCU_Distance_Unit();
   
   tcl_ITM_TCU_e32_Distance_Unit eDistance_Unit;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Distance_Unit const& lhs, tcl_ITM_TCU_Distance_Unit const& rhs);
tBool operator!=(tcl_ITM_TCU_Distance_Unit const& lhs, tcl_ITM_TCU_Distance_Unit const& rhs);

class tcl_ITM_TCU_Distance_Value
{
public:
   tcl_ITM_TCU_Distance_Value();
   
   tcl_MCAN_GenericType_UnsignedInteger uiOil_Filter;
   tcl_MCAN_GenericType_UnsignedInteger uiOil;
   tcl_MCAN_GenericType_UnsignedInteger uiTire;
   tcl_MCAN_GenericType_UnsignedInteger uiUser;
   tcl_MCAN_GenericType_UnsignedInteger uiBattery;
   tcl_MCAN_GenericType_UnsignedInteger uiAir_Conditioner_Filter;
   tcl_MCAN_GenericType_StreamData aReserve;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Distance_Value const& lhs, tcl_ITM_TCU_Distance_Value const& rhs);
tBool operator!=(tcl_ITM_TCU_Distance_Value const& lhs, tcl_ITM_TCU_Distance_Value const& rhs);

class tcl_ITM_TCU_Score_Info
{
public:
   tcl_ITM_TCU_Score_Info();
   
   tcl_MCAN_GenericType_UnsignedInteger uiECO_Score;
   tcl_MCAN_GenericType_UnsignedInteger uiStart_Score;
   tcl_MCAN_GenericType_UnsignedInteger uiCruise_Score;
   tcl_MCAN_GenericType_UnsignedInteger uiSlowdown_Score;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Score_Info const& lhs, tcl_ITM_TCU_Score_Info const& rhs);
tBool operator!=(tcl_ITM_TCU_Score_Info const& lhs, tcl_ITM_TCU_Score_Info const& rhs);

class tcl_ITM_TCU_Map_Version
{
public:
   tcl_ITM_TCU_Map_Version();
   
   tcl_MCAN_GenericType_StreamData strMap_Version;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Map_Version const& lhs, tcl_ITM_TCU_Map_Version const& rhs);
tBool operator!=(tcl_ITM_TCU_Map_Version const& lhs, tcl_ITM_TCU_Map_Version const& rhs);

class tcl_ITM_TCU_PopUp_Flag
{
public:
   tcl_ITM_TCU_PopUp_Flag();
   
   tcl_ITM_TCU_e32_ON_OFF ePopUp_Flag;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_PopUp_Flag const& lhs, tcl_ITM_TCU_PopUp_Flag const& rhs);
tBool operator!=(tcl_ITM_TCU_PopUp_Flag const& lhs, tcl_ITM_TCU_PopUp_Flag const& rhs);

class tcl_ITM_TCU_Information_Channel
{
public:
   tcl_ITM_TCU_Information_Channel();
   
   tcl_MCAN_GenericType_UnsignedInteger uiInformation_Channel;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Information_Channel const& lhs, tcl_ITM_TCU_Information_Channel const& rhs);
tBool operator!=(tcl_ITM_TCU_Information_Channel const& lhs, tcl_ITM_TCU_Information_Channel const& rhs);

class tcl_ITM_TCU_Time_Zone
{
public:
   tcl_ITM_TCU_Time_Zone();
   
   tcl_MCAN_GenericType_UnsignedInteger uiTime_Zone;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Time_Zone const& lhs, tcl_ITM_TCU_Time_Zone const& rhs);
tBool operator!=(tcl_ITM_TCU_Time_Zone const& lhs, tcl_ITM_TCU_Time_Zone const& rhs);

class tcl_ITM_TCU_Permit_Setting
{
public:
   tcl_ITM_TCU_Permit_Setting();
   
   tcl_ITM_TCU_e32_ON_OFF ePermit_Setting;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Permit_Setting const& lhs, tcl_ITM_TCU_Permit_Setting const& rhs);
tBool operator!=(tcl_ITM_TCU_Permit_Setting const& lhs, tcl_ITM_TCU_Permit_Setting const& rhs);

class tcl_ITM_TCU_Service_Type
{
public:
   tcl_ITM_TCU_Service_Type();
   
   tcl_ITM_TCU_e32_Service_Type eService_Type;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Service_Type const& lhs, tcl_ITM_TCU_Service_Type const& rhs);
tBool operator!=(tcl_ITM_TCU_Service_Type const& lhs, tcl_ITM_TCU_Service_Type const& rhs);

class tcl_ITM_TCU_Current_Country
{
public:
   tcl_ITM_TCU_Current_Country();
   
   tcl_MCAN_GenericType_StreamData strCurrent_Country;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Current_Country const& lhs, tcl_ITM_TCU_Current_Country const& rhs);
tBool operator!=(tcl_ITM_TCU_Current_Country const& lhs, tcl_ITM_TCU_Current_Country const& rhs);

class tcl_ITM_TCU_Search_GPS_Position
{
public:
   tcl_ITM_TCU_Search_GPS_Position();
   
   tcl_MCAN_GenericType_StreamData aReserved;
   tcl_ITM_TCU_e32_LocationType eLocationType;
   tcl_ITM_TCU_e32_LattitudeMode eLattitudeMode;
   tcl_ITM_TCU_e32_LongitudeMode eLongitudeMode;
   tcl_MCAN_GenericType_UnsignedInteger uiLattitudeDEG;
   tcl_MCAN_GenericType_UnsignedInteger uiLattitudeMIN;
   tcl_MCAN_GenericType_UnsignedInteger uiLattitudeSEC;
   tcl_MCAN_GenericType_UnsignedInteger uiLongitudeDEG;
   tcl_MCAN_GenericType_UnsignedInteger uiLongitudeMIN;
   tcl_MCAN_GenericType_UnsignedInteger uiLongitudeSEC;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Search_GPS_Position const& lhs, tcl_ITM_TCU_Search_GPS_Position const& rhs);
tBool operator!=(tcl_ITM_TCU_Search_GPS_Position const& lhs, tcl_ITM_TCU_Search_GPS_Position const& rhs);

class tcl_ITM_TCU_ePOI_Type
{
public:
   tcl_ITM_TCU_ePOI_Type();
   
   tcl_ITM_TCU_e32_ePOI_Type eePOI_Type;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_ePOI_Type const& lhs, tcl_ITM_TCU_ePOI_Type const& rhs);
tBool operator!=(tcl_ITM_TCU_ePOI_Type const& lhs, tcl_ITM_TCU_ePOI_Type const& rhs);

class tcl_ITM_TCU_Charge_Receptacle_Type
{
public:
   tcl_ITM_TCU_Charge_Receptacle_Type();
   
   tcl_ITM_TCU_e32_Charge_Receptacle_Type eCharge_Receptacle_Type;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Charge_Receptacle_Type const& lhs, tcl_ITM_TCU_Charge_Receptacle_Type const& rhs);
tBool operator!=(tcl_ITM_TCU_Charge_Receptacle_Type const& lhs, tcl_ITM_TCU_Charge_Receptacle_Type const& rhs);

class tcl_ITM_TCU_Spot_Receptacle_Type
{
public:
   tcl_ITM_TCU_Spot_Receptacle_Type();
   
   tcl_ITM_TCU_e32_Charge_Receptacle_Type eDefault_receptacle_type;
   tcl_ITM_TCU_e32_Charge_Receptacle_Type eUser_receptacle_type_1;
   tcl_ITM_TCU_e32_Charge_Receptacle_Type eUser_receptacle_type_2;
   tcl_ITM_TCU_e32_Charge_Receptacle_Type eUser_receptacle_type_3;
   tcl_MCAN_GenericType_UnsignedInteger uiReserved_1;
   tcl_MCAN_GenericType_UnsignedInteger uiReserved_2;
   tcl_MCAN_GenericType_UnsignedInteger uiReserved_3;
   tcl_MCAN_GenericType_UnsignedInteger uiReserved_4;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Spot_Receptacle_Type const& lhs, tcl_ITM_TCU_Spot_Receptacle_Type const& rhs);
tBool operator!=(tcl_ITM_TCU_Spot_Receptacle_Type const& lhs, tcl_ITM_TCU_Spot_Receptacle_Type const& rhs);

class tcl_ITM_TCU_Vehicle_Autonomy
{
public:
   tcl_ITM_TCU_Vehicle_Autonomy();
   
   tcl_MCAN_GenericType_UnsignedInteger uiVehicle_Autonomy;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Vehicle_Autonomy const& lhs, tcl_ITM_TCU_Vehicle_Autonomy const& rhs);
tBool operator!=(tcl_ITM_TCU_Vehicle_Autonomy const& lhs, tcl_ITM_TCU_Vehicle_Autonomy const& rhs);

class tcl_ITM_TCU_Battery_Identification_Number
{
public:
   tcl_ITM_TCU_Battery_Identification_Number();
   
   tcl_MCAN_GenericType_UnsignedInteger uiBattery_Identification_Number;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Battery_Identification_Number const& lhs, tcl_ITM_TCU_Battery_Identification_Number const& rhs);
tBool operator!=(tcl_ITM_TCU_Battery_Identification_Number const& lhs, tcl_ITM_TCU_Battery_Identification_Number const& rhs);

class tcl_ITM_TCU_Navigation_Language
{
public:
   tcl_ITM_TCU_Navigation_Language();
   
   tcl_MCAN_GenericType_UnsignedInteger uiReserved;
   tcl_ITM_TCU_e32_Language_Family_Type eLanguage_Family_Type;
   tcl_ITM_TCU_e32_Language_Type eLanguage_Type;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Navigation_Language const& lhs, tcl_ITM_TCU_Navigation_Language const& rhs);
tBool operator!=(tcl_ITM_TCU_Navigation_Language const& lhs, tcl_ITM_TCU_Navigation_Language const& rhs);

class tcl_ITM_TCU_Finder_Status
{
public:
   tcl_ITM_TCU_Finder_Status();
   
   tcl_ITM_TCU_e32_Finder_Status eFinder_Status;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Finder_Status const& lhs, tcl_ITM_TCU_Finder_Status const& rhs);
tBool operator!=(tcl_ITM_TCU_Finder_Status const& lhs, tcl_ITM_TCU_Finder_Status const& rhs);

class tcl_ITM_TCU_Total_Station_Number
{
public:
   tcl_ITM_TCU_Total_Station_Number();
   
   tcl_MCAN_GenericType_UnsignedInteger uiTotal_Station_Number;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Total_Station_Number const& lhs, tcl_ITM_TCU_Total_Station_Number const& rhs);
tBool operator!=(tcl_ITM_TCU_Total_Station_Number const& lhs, tcl_ITM_TCU_Total_Station_Number const& rhs);

class tcl_ITM_TCU_Station_List_Number
{
public:
   tcl_ITM_TCU_Station_List_Number();
   
   tcl_MCAN_GenericType_UnsignedInteger uiStation_List_Number;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Station_List_Number const& lhs, tcl_ITM_TCU_Station_List_Number const& rhs);
tBool operator!=(tcl_ITM_TCU_Station_List_Number const& lhs, tcl_ITM_TCU_Station_List_Number const& rhs);

class tcl_ITM_TCU_Charge_Station_ID
{
public:
   tcl_ITM_TCU_Charge_Station_ID();
   
   tcl_MCAN_GenericType_StreamData strCharge_Station_ID;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Charge_Station_ID const& lhs, tcl_ITM_TCU_Charge_Station_ID const& rhs);
tBool operator!=(tcl_ITM_TCU_Charge_Station_ID const& lhs, tcl_ITM_TCU_Charge_Station_ID const& rhs);

class tcl_ITM_TCU_EPOI_GPS_Position
{
public:
   tcl_ITM_TCU_EPOI_GPS_Position();
   
   tcl_MCAN_GenericType_UnsignedInteger uiReserved;
   tcl_ITM_TCU_e32_LocationType eLocationType;
   tcl_ITM_TCU_e32_LattitudeMode eLattitudeMode;
   tcl_ITM_TCU_e32_LongitudeMode eLongitudeMode;
   tcl_MCAN_GenericType_UnsignedInteger uiLattitudeDEG;
   tcl_MCAN_GenericType_UnsignedInteger uiLattitudeMIN;
   tcl_MCAN_GenericType_UnsignedInteger uiLattitudeSEC;
   tcl_MCAN_GenericType_UnsignedInteger uiLongitudeDEG;
   tcl_MCAN_GenericType_UnsignedInteger uiLongitudeMIN;
   tcl_MCAN_GenericType_UnsignedInteger uiLongitudeSEC;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_EPOI_GPS_Position const& lhs, tcl_ITM_TCU_EPOI_GPS_Position const& rhs);
tBool operator!=(tcl_ITM_TCU_EPOI_GPS_Position const& lhs, tcl_ITM_TCU_EPOI_GPS_Position const& rhs);

class tcl_ITM_TCU_Energy_Provider_Name
{
public:
   tcl_ITM_TCU_Energy_Provider_Name();
   
   tcl_MCAN_GenericType_StreamData strEnergy_Provider_Name;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Energy_Provider_Name const& lhs, tcl_ITM_TCU_Energy_Provider_Name const& rhs);
tBool operator!=(tcl_ITM_TCU_Energy_Provider_Name const& lhs, tcl_ITM_TCU_Energy_Provider_Name const& rhs);

class tcl_ITM_TCU_Utility_Aggregator_ID
{
public:
   tcl_ITM_TCU_Utility_Aggregator_ID();
   
   tcl_MCAN_GenericType_StreamData strUtility_Aggregator_ID;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Utility_Aggregator_ID const& lhs, tcl_ITM_TCU_Utility_Aggregator_ID const& rhs);
tBool operator!=(tcl_ITM_TCU_Utility_Aggregator_ID const& lhs, tcl_ITM_TCU_Utility_Aggregator_ID const& rhs);

class tcl_ITM_TCU_Time_Stamp
{
public:
   tcl_ITM_TCU_Time_Stamp();
   
   tcl_MCAN_GenericType_UnsignedInteger uiYear_from_2000_to_2099_;
   tcl_MCAN_GenericType_UnsignedInteger uiMonth;
   tcl_MCAN_GenericType_UnsignedInteger uiDay;
   tcl_MCAN_GenericType_UnsignedInteger uiHour;
   tcl_MCAN_GenericType_UnsignedInteger uiMinute;
   tcl_MCAN_GenericType_UnsignedInteger uiSecond;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Time_Stamp const& lhs, tcl_ITM_TCU_Time_Stamp const& rhs);
tBool operator!=(tcl_ITM_TCU_Time_Stamp const& lhs, tcl_ITM_TCU_Time_Stamp const& rhs);

class tcl_ITM_TCU_Phone_Number
{
public:
   tcl_ITM_TCU_Phone_Number();
   
   tcl_MCAN_GenericType_StreamData strPhone_Number;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Phone_Number const& lhs, tcl_ITM_TCU_Phone_Number const& rhs);
tBool operator!=(tcl_ITM_TCU_Phone_Number const& lhs, tcl_ITM_TCU_Phone_Number const& rhs);

class tcl_ITM_TCU_Opening_Hour
{
public:
   tcl_ITM_TCU_Opening_Hour();
   
   tcl_MCAN_GenericType_UnsignedInteger uiSunday_StartTime_1;
   tcl_MCAN_GenericType_UnsignedInteger uiSunday_EndTime_1;
   tcl_MCAN_GenericType_UnsignedInteger uiSunday_StartTime_2;
   tcl_MCAN_GenericType_UnsignedInteger uiSunday_EndTime_2;
   tcl_MCAN_GenericType_UnsignedInteger uiMonday_StartTime_1;
   tcl_MCAN_GenericType_UnsignedInteger uiMonday_EndTime_1;
   tcl_MCAN_GenericType_UnsignedInteger uiMonday_StartTime_2;
   tcl_MCAN_GenericType_UnsignedInteger uiMonday_EndTime_2;
   tcl_MCAN_GenericType_UnsignedInteger uiTuesday_StartTime_1;
   tcl_MCAN_GenericType_UnsignedInteger uiTuesday_EndTime_1;
   tcl_MCAN_GenericType_UnsignedInteger uiTuesday_StartTime_2;
   tcl_MCAN_GenericType_UnsignedInteger uiTuesday_EndTime_2;
   tcl_MCAN_GenericType_UnsignedInteger uiWednesday_StartTime_1;
   tcl_MCAN_GenericType_UnsignedInteger uiWednesday_EndTime_1;
   tcl_MCAN_GenericType_UnsignedInteger uiWednesday_StartTime_2;
   tcl_MCAN_GenericType_UnsignedInteger uiWednesday_EndTime_2;
   tcl_MCAN_GenericType_UnsignedInteger uiThursday_StartTime_1;
   tcl_MCAN_GenericType_UnsignedInteger uiThursday_EndTime_1;
   tcl_MCAN_GenericType_UnsignedInteger uiThursday_StartTime_2;
   tcl_MCAN_GenericType_UnsignedInteger uiThursday_EndTime_2;
   tcl_MCAN_GenericType_UnsignedInteger uiFriday_StartTime_1;
   tcl_MCAN_GenericType_UnsignedInteger uiFriday_EndTime_1;
   tcl_MCAN_GenericType_UnsignedInteger uiFriday_StartTime_2;
   tcl_MCAN_GenericType_UnsignedInteger uiFriday_EndTime_2;
   tcl_MCAN_GenericType_UnsignedInteger uiSaturday_StartTime_1;
   tcl_MCAN_GenericType_UnsignedInteger uiSaturday_EndTime_1;
   tcl_MCAN_GenericType_UnsignedInteger uiSaturday_StartTime_2;
   tcl_MCAN_GenericType_UnsignedInteger uiSaturday_EndTime_2;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Opening_Hour const& lhs, tcl_ITM_TCU_Opening_Hour const& rhs);
tBool operator!=(tcl_ITM_TCU_Opening_Hour const& lhs, tcl_ITM_TCU_Opening_Hour const& rhs);

class tcl_ITM_TCU_Charge_Station_Accessibility
{
public:
   tcl_ITM_TCU_Charge_Station_Accessibility();
   
   tcl_ITM_TCU_e32_Station_Accessibility eCharge_Station_Accessibility;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Charge_Station_Accessibility const& lhs, tcl_ITM_TCU_Charge_Station_Accessibility const& rhs);
tBool operator!=(tcl_ITM_TCU_Charge_Station_Accessibility const& lhs, tcl_ITM_TCU_Charge_Station_Accessibility const& rhs);

class tcl_ITM_TCU_Payment_Method_Type
{
public:
   tcl_ITM_TCU_Payment_Method_Type();
   
   tcl_ITM_TCU_e32_Payment_Method ePayment_Method_Type;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Payment_Method_Type const& lhs, tcl_ITM_TCU_Payment_Method_Type const& rhs);
tBool operator!=(tcl_ITM_TCU_Payment_Method_Type const& lhs, tcl_ITM_TCU_Payment_Method_Type const& rhs);

class tcl_ITM_TCU_Spot_Total_Number
{
public:
   tcl_ITM_TCU_Spot_Total_Number();
   
   tcl_MCAN_GenericType_UnsignedInteger uiSpot_Total_Number;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Spot_Total_Number const& lhs, tcl_ITM_TCU_Spot_Total_Number const& rhs);
tBool operator!=(tcl_ITM_TCU_Spot_Total_Number const& lhs, tcl_ITM_TCU_Spot_Total_Number const& rhs);

class tcl_ITM_TCU_Number_Available_Batteries
{
public:
   tcl_ITM_TCU_Number_Available_Batteries();
   
   tcl_MCAN_GenericType_UnsignedInteger uiNumber_Available_Batteries;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Number_Available_Batteries const& lhs, tcl_ITM_TCU_Number_Available_Batteries const& rhs);
tBool operator!=(tcl_ITM_TCU_Number_Available_Batteries const& lhs, tcl_ITM_TCU_Number_Available_Batteries const& rhs);

class tcl_ITM_TCU_Full_Address
{
public:
   tcl_ITM_TCU_Full_Address();
   
   tcl_MCAN_GenericType_UnsignedInteger uiLength_of_Text;
   tcl_MCAN_GenericType_StreamData vstrText_Info;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Full_Address const& lhs, tcl_ITM_TCU_Full_Address const& rhs);
tBool operator!=(tcl_ITM_TCU_Full_Address const& lhs, tcl_ITM_TCU_Full_Address const& rhs);

class tcl_ITM_TCU_Charge_Staion_Ranking
{
public:
   tcl_ITM_TCU_Charge_Staion_Ranking();
   
   tcl_MCAN_GenericType_UnsignedInteger uiCharge_Staion_Ranking;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Charge_Staion_Ranking const& lhs, tcl_ITM_TCU_Charge_Staion_Ranking const& rhs);
tBool operator!=(tcl_ITM_TCU_Charge_Staion_Ranking const& lhs, tcl_ITM_TCU_Charge_Staion_Ranking const& rhs);

class tcl_ITM_TCU_Charge_Spot_List
{
public:
   tcl_ITM_TCU_Charge_Spot_List();
   
   tcl_MCAN_GenericType_UnsignedInteger uiTotal_pages_of_lists;
   tcl_MCAN_GenericType_UnsignedInteger uiPage_of_list;
   tcl_MCAN_GenericType_UnsignedInteger uiStation_List_Number;
   tcl_MCAN_GenericType_StreamData strSpot_List1_Charge_Spot_ID;
   tcl_ITM_TCU_e32_Bookable_Information eSpot_List1_Bookable_Information;
   tcl_ITM_TCU_e32_Spot_Availability eSpot_List1_Spot_Availability;
   tcl_MCAN_GenericType_UnsignedInteger uiSpot_List1_Bookable_Free_Text_Length_of_Text;
   tcl_MCAN_GenericType_StreamData vstrSpot_List1_Bookable_Free_Text_Text_Info;
   tcl_MCAN_GenericType_UnsignedInteger uiSpot_List1_Total_Number_Receptacles;
   tcl_ITM_TCU_e32_Charge_Receptacle_Type eSpot_List1_Receptacle1_Charge_Receptacle_Type;
   tcl_MCAN_GenericType_UnsignedInteger uiSpot_List1_Receptacle1_Available_Power;
   tcl_ITM_TCU_e32_Charge_Receptacle_Facility eSpot_List1_Receptacle1_Charge_Receptacle_Facility;
   tcl_ITM_TCU_e32_Charge_Receptacle_Type eSpot_List1_Receptacle2_Charge_Receptacle_Type;
   tcl_MCAN_GenericType_UnsignedInteger uiSpot_List1_Receptacle2_Available_Power;
   tcl_ITM_TCU_e32_Charge_Receptacle_Facility eSpot_List1_Receptacle2_Charge_Receptacle_Facility;
   tcl_ITM_TCU_e32_Charge_Receptacle_Type eSpot_List1_Receptacle3_Charge_Receptacle_Type;
   tcl_MCAN_GenericType_UnsignedInteger uiSpot_List1_Receptacle3_Available_Power;
   tcl_ITM_TCU_e32_Charge_Receptacle_Facility eSpot_List1_Receptacle3_Charge_Receptacle_Facility;
   tcl_ITM_TCU_e32_Charge_Receptacle_Type eSpot_List1_Receptacle4_Charge_Receptacle_Type;
   tcl_MCAN_GenericType_UnsignedInteger uiSpot_List1_Receptacle4_Available_Power;
   tcl_ITM_TCU_e32_Charge_Receptacle_Facility eSpot_List1_Receptacle4_Charge_Receptacle_Facility;
   tcl_ITM_TCU_e32_Charge_Receptacle_Type eSpot_List1_Receptacle5_Charge_Receptacle_Type;
   tcl_MCAN_GenericType_UnsignedInteger uiSpot_List1_Receptacle5_Available_Power;
   tcl_ITM_TCU_e32_Charge_Receptacle_Facility eSpot_List1_Receptacle5_Charge_Receptacle_Facility;
   tcl_ITM_TCU_e32_Charge_Receptacle_Type eSpot_List1_Receptacle6_Charge_Receptacle_Type;
   tcl_MCAN_GenericType_UnsignedInteger uiSpot_List1_Receptacle6_Available_Power;
   tcl_ITM_TCU_e32_Charge_Receptacle_Facility eSpot_List1_Receptacle6_Charge_Receptacle_Facility;
   tcl_ITM_TCU_e32_Charge_Receptacle_Type eSpot_List1_Receptacle7_Charge_Receptacle_Type;
   tcl_MCAN_GenericType_UnsignedInteger uiSpot_List1_Receptacle7_Available_Power;
   tcl_ITM_TCU_e32_Charge_Receptacle_Facility eSpot_List1_Receptacle7_Charge_Receptacle_Facility;
   tcl_ITM_TCU_e32_Charge_Receptacle_Type eSpot_List1_Receptacle8_Charge_Receptacle_Type;
   tcl_MCAN_GenericType_UnsignedInteger uiSpot_List1_Receptacle8_Available_Power;
   tcl_ITM_TCU_e32_Charge_Receptacle_Facility eSpot_List1_Receptacle8_Charge_Receptacle_Facility;
   tcl_ITM_TCU_e32_Charge_Receptacle_Type eSpot_List1_Receptacle9_Charge_Receptacle_Type;
   tcl_MCAN_GenericType_UnsignedInteger uiSpot_List1_Receptacle9_Available_Power;
   tcl_ITM_TCU_e32_Charge_Receptacle_Facility eSpot_List1_Receptacle9_Charge_Receptacle_Facility;
   tcl_ITM_TCU_e32_Charge_Receptacle_Type eSpot_List1_Receptacle10_Charge_Receptacle_Type;
   tcl_MCAN_GenericType_UnsignedInteger uiSpot_List1_Receptacle10_Available_Power;
   tcl_ITM_TCU_e32_Charge_Receptacle_Facility eSpot_List1_Receptacle10_Charge_Receptacle_Facility;
   tcl_MCAN_GenericType_StreamData strSpot_List2_Charge_Spot_ID;
   tcl_ITM_TCU_e32_Bookable_Information eSpot_List2_Bookable_Information;
   tcl_ITM_TCU_e32_Spot_Availability eSpot_List2_Spot_Availability;
   tcl_MCAN_GenericType_UnsignedInteger uiSpot_List2_Bookable_Free_Text_Length_of_Text;
   tcl_MCAN_GenericType_StreamData vstrSpot_List2_Bookable_Free_Text_Text_Info;
   tcl_MCAN_GenericType_UnsignedInteger uiSpot_List2_Total_Number_Receptacles;
   tcl_ITM_TCU_e32_Charge_Receptacle_Type eSpot_List2_Receptacle1_Charge_Receptacle_Type;
   tcl_MCAN_GenericType_UnsignedInteger uiSpot_List2_Receptacle1_Available_Power;
   tcl_ITM_TCU_e32_Charge_Receptacle_Facility eSpot_List2_Receptacle1_Charge_Receptacle_Facility;
   tcl_ITM_TCU_e32_Charge_Receptacle_Type eSpot_List2_Receptacle2_Charge_Receptacle_Type;
   tcl_MCAN_GenericType_UnsignedInteger uiSpot_List2_Receptacle2_Available_Power;
   tcl_ITM_TCU_e32_Charge_Receptacle_Facility eSpot_List2_Receptacle2_Charge_Receptacle_Facility;
   tcl_ITM_TCU_e32_Charge_Receptacle_Type eSpot_List2_Receptacle3_Charge_Receptacle_Type;
   tcl_MCAN_GenericType_UnsignedInteger uiSpot_List2_Receptacle3_Available_Power;
   tcl_ITM_TCU_e32_Charge_Receptacle_Facility eSpot_List2_Receptacle3_Charge_Receptacle_Facility;
   tcl_ITM_TCU_e32_Charge_Receptacle_Type eSpot_List2_Receptacle4_Charge_Receptacle_Type;
   tcl_MCAN_GenericType_UnsignedInteger uiSpot_List2_Receptacle4_Available_Power;
   tcl_ITM_TCU_e32_Charge_Receptacle_Facility eSpot_List2_Receptacle4_Charge_Receptacle_Facility;
   tcl_ITM_TCU_e32_Charge_Receptacle_Type eSpot_List2_Receptacle5_Charge_Receptacle_Type;
   tcl_MCAN_GenericType_UnsignedInteger uiSpot_List2_Receptacle5_Available_Power;
   tcl_ITM_TCU_e32_Charge_Receptacle_Facility eSpot_List2_Receptacle5_Charge_Receptacle_Facility;
   tcl_ITM_TCU_e32_Charge_Receptacle_Type eSpot_List2_Receptacle6_Charge_Receptacle_Type;
   tcl_MCAN_GenericType_UnsignedInteger uiSpot_List2_Receptacle6_Available_Power;
   tcl_ITM_TCU_e32_Charge_Receptacle_Facility eSpot_List2_Receptacle6_Charge_Receptacle_Facility;
   tcl_ITM_TCU_e32_Charge_Receptacle_Type eSpot_List2_Receptacle7_Charge_Receptacle_Type;
   tcl_MCAN_GenericType_UnsignedInteger uiSpot_List2_Receptacle7_Available_Power;
   tcl_ITM_TCU_e32_Charge_Receptacle_Facility eSpot_List2_Receptacle7_Charge_Receptacle_Facility;
   tcl_ITM_TCU_e32_Charge_Receptacle_Type eSpot_List2_Receptacle8_Charge_Receptacle_Type;
   tcl_MCAN_GenericType_UnsignedInteger uiSpot_List2_Receptacle8_Available_Power;
   tcl_ITM_TCU_e32_Charge_Receptacle_Facility eSpot_List2_Receptacle8_Charge_Receptacle_Facility;
   tcl_ITM_TCU_e32_Charge_Receptacle_Type eSpot_List2_Receptacle9_Charge_Receptacle_Type;
   tcl_MCAN_GenericType_UnsignedInteger uiSpot_List2_Receptacle9_Available_Power;
   tcl_ITM_TCU_e32_Charge_Receptacle_Facility eSpot_List2_Receptacle9_Charge_Receptacle_Facility;
   tcl_ITM_TCU_e32_Charge_Receptacle_Type eSpot_List2_Receptacle10_Charge_Receptacle_Type;
   tcl_MCAN_GenericType_UnsignedInteger uiSpot_List2_Receptacle10_Available_Power;
   tcl_ITM_TCU_e32_Charge_Receptacle_Facility eSpot_List2_Receptacle10_Charge_Receptacle_Facility;
   tcl_MCAN_GenericType_StreamData strSpot_List3_Charge_Spot_ID;
   tcl_ITM_TCU_e32_Bookable_Information eSpot_List3_Bookable_Information;
   tcl_ITM_TCU_e32_Spot_Availability eSpot_List3_Spot_Availability;
   tcl_MCAN_GenericType_UnsignedInteger uiSpot_List3_Bookable_Free_Text_Length_of_Text;
   tcl_MCAN_GenericType_StreamData vstrSpot_List3_Bookable_Free_Text_Text_Info;
   tcl_MCAN_GenericType_UnsignedInteger uiSpot_List3_Total_Number_Receptacles;
   tcl_ITM_TCU_e32_Charge_Receptacle_Type eSpot_List3_Receptacle1_Charge_Receptacle_Type;
   tcl_MCAN_GenericType_UnsignedInteger uiSpot_List3_Receptacle1_Available_Power;
   tcl_ITM_TCU_e32_Charge_Receptacle_Facility eSpot_List3_Receptacle1_Charge_Receptacle_Facility;
   tcl_ITM_TCU_e32_Charge_Receptacle_Type eSpot_List3_Receptacle2_Charge_Receptacle_Type;
   tcl_MCAN_GenericType_UnsignedInteger uiSpot_List3_Receptacle2_Available_Power;
   tcl_ITM_TCU_e32_Charge_Receptacle_Facility eSpot_List3_Receptacle2_Charge_Receptacle_Facility;
   tcl_ITM_TCU_e32_Charge_Receptacle_Type eSpot_List3_Receptacle3_Charge_Receptacle_Type;
   tcl_MCAN_GenericType_UnsignedInteger uiSpot_List3_Receptacle3_Available_Power;
   tcl_ITM_TCU_e32_Charge_Receptacle_Facility eSpot_List3_Receptacle3_Charge_Receptacle_Facility;
   tcl_ITM_TCU_e32_Charge_Receptacle_Type eSpot_List3_Receptacle4_Charge_Receptacle_Type;
   tcl_MCAN_GenericType_UnsignedInteger uiSpot_List3_Receptacle4_Available_Power;
   tcl_ITM_TCU_e32_Charge_Receptacle_Facility eSpot_List3_Receptacle4_Charge_Receptacle_Facility;
   tcl_ITM_TCU_e32_Charge_Receptacle_Type eSpot_List3_Receptacle5_Charge_Receptacle_Type;
   tcl_MCAN_GenericType_UnsignedInteger uiSpot_List3_Receptacle5_Available_Power;
   tcl_ITM_TCU_e32_Charge_Receptacle_Facility eSpot_List3_Receptacle5_Charge_Receptacle_Facility;
   tcl_ITM_TCU_e32_Charge_Receptacle_Type eSpot_List3_Receptacle6_Charge_Receptacle_Type;
   tcl_MCAN_GenericType_UnsignedInteger uiSpot_List3_Receptacle6_Available_Power;
   tcl_ITM_TCU_e32_Charge_Receptacle_Facility eSpot_List3_Receptacle6_Charge_Receptacle_Facility;
   tcl_ITM_TCU_e32_Charge_Receptacle_Type eSpot_List3_Receptacle7_Charge_Receptacle_Type;
   tcl_MCAN_GenericType_UnsignedInteger uiSpot_List3_Receptacle7_Available_Power;
   tcl_ITM_TCU_e32_Charge_Receptacle_Facility eSpot_List3_Receptacle7_Charge_Receptacle_Facility;
   tcl_ITM_TCU_e32_Charge_Receptacle_Type eSpot_List3_Receptacle8_Charge_Receptacle_Type;
   tcl_MCAN_GenericType_UnsignedInteger uiSpot_List3_Receptacle8_Available_Power;
   tcl_ITM_TCU_e32_Charge_Receptacle_Facility eSpot_List3_Receptacle8_Charge_Receptacle_Facility;
   tcl_ITM_TCU_e32_Charge_Receptacle_Type eSpot_List3_Receptacle9_Charge_Receptacle_Type;
   tcl_MCAN_GenericType_UnsignedInteger uiSpot_List3_Receptacle9_Available_Power;
   tcl_ITM_TCU_e32_Charge_Receptacle_Facility eSpot_List3_Receptacle9_Charge_Receptacle_Facility;
   tcl_ITM_TCU_e32_Charge_Receptacle_Type eSpot_List3_Receptacle10_Charge_Receptacle_Type;
   tcl_MCAN_GenericType_UnsignedInteger uiSpot_List3_Receptacle10_Available_Power;
   tcl_ITM_TCU_e32_Charge_Receptacle_Facility eSpot_List3_Receptacle10_Charge_Receptacle_Facility;
   tcl_MCAN_GenericType_StreamData strSpot_List4_Charge_Spot_ID;
   tcl_ITM_TCU_e32_Bookable_Information eSpot_List4_Bookable_Information;
   tcl_ITM_TCU_e32_Spot_Availability eSpot_List4_Spot_Availability;
   tcl_MCAN_GenericType_UnsignedInteger uiSpot_List4_Bookable_Free_Text_Length_of_Text;
   tcl_MCAN_GenericType_StreamData vstrSpot_List4_Bookable_Free_Text_Text_Info;
   tcl_MCAN_GenericType_UnsignedInteger uiSpot_List4_Total_Number_Receptacles;
   tcl_ITM_TCU_e32_Charge_Receptacle_Type eSpot_List4_Receptacle1_Charge_Receptacle_Type;
   tcl_MCAN_GenericType_UnsignedInteger uiSpot_List4_Receptacle1_Available_Power;
   tcl_ITM_TCU_e32_Charge_Receptacle_Facility eSpot_List4_Receptacle1_Charge_Receptacle_Facility;
   tcl_ITM_TCU_e32_Charge_Receptacle_Type eSpot_List4_Receptacle2_Charge_Receptacle_Type;
   tcl_MCAN_GenericType_UnsignedInteger uiSpot_List4_Receptacle2_Available_Power;
   tcl_ITM_TCU_e32_Charge_Receptacle_Facility eSpot_List4_Receptacle2_Charge_Receptacle_Facility;
   tcl_ITM_TCU_e32_Charge_Receptacle_Type eSpot_List4_Receptacle3_Charge_Receptacle_Type;
   tcl_MCAN_GenericType_UnsignedInteger uiSpot_List4_Receptacle3_Available_Power;
   tcl_ITM_TCU_e32_Charge_Receptacle_Facility eSpot_List4_Receptacle3_Charge_Receptacle_Facility;
   tcl_ITM_TCU_e32_Charge_Receptacle_Type eSpot_List4_Receptacle4_Charge_Receptacle_Type;
   tcl_MCAN_GenericType_UnsignedInteger uiSpot_List4_Receptacle4_Available_Power;
   tcl_ITM_TCU_e32_Charge_Receptacle_Facility eSpot_List4_Receptacle4_Charge_Receptacle_Facility;
   tcl_ITM_TCU_e32_Charge_Receptacle_Type eSpot_List4_Receptacle5_Charge_Receptacle_Type;
   tcl_MCAN_GenericType_UnsignedInteger uiSpot_List4_Receptacle5_Available_Power;
   tcl_ITM_TCU_e32_Charge_Receptacle_Facility eSpot_List4_Receptacle5_Charge_Receptacle_Facility;
   tcl_ITM_TCU_e32_Charge_Receptacle_Type eSpot_List4_Receptacle6_Charge_Receptacle_Type;
   tcl_MCAN_GenericType_UnsignedInteger uiSpot_List4_Receptacle6_Available_Power;
   tcl_ITM_TCU_e32_Charge_Receptacle_Facility eSpot_List4_Receptacle6_Charge_Receptacle_Facility;
   tcl_ITM_TCU_e32_Charge_Receptacle_Type eSpot_List4_Receptacle7_Charge_Receptacle_Type;
   tcl_MCAN_GenericType_UnsignedInteger uiSpot_List4_Receptacle7_Available_Power;
   tcl_ITM_TCU_e32_Charge_Receptacle_Facility eSpot_List4_Receptacle7_Charge_Receptacle_Facility;
   tcl_ITM_TCU_e32_Charge_Receptacle_Type eSpot_List4_Receptacle8_Charge_Receptacle_Type;
   tcl_MCAN_GenericType_UnsignedInteger uiSpot_List4_Receptacle8_Available_Power;
   tcl_ITM_TCU_e32_Charge_Receptacle_Facility eSpot_List4_Receptacle8_Charge_Receptacle_Facility;
   tcl_ITM_TCU_e32_Charge_Receptacle_Type eSpot_List4_Receptacle9_Charge_Receptacle_Type;
   tcl_MCAN_GenericType_UnsignedInteger uiSpot_List4_Receptacle9_Available_Power;
   tcl_ITM_TCU_e32_Charge_Receptacle_Facility eSpot_List4_Receptacle9_Charge_Receptacle_Facility;
   tcl_ITM_TCU_e32_Charge_Receptacle_Type eSpot_List4_Receptacle10_Charge_Receptacle_Type;
   tcl_MCAN_GenericType_UnsignedInteger uiSpot_List4_Receptacle10_Available_Power;
   tcl_ITM_TCU_e32_Charge_Receptacle_Facility eSpot_List4_Receptacle10_Charge_Receptacle_Facility;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Charge_Spot_List const& lhs, tcl_ITM_TCU_Charge_Spot_List const& rhs);
tBool operator!=(tcl_ITM_TCU_Charge_Spot_List const& lhs, tcl_ITM_TCU_Charge_Spot_List const& rhs);

class tcl_ITM_TCU_Charge_Spot_ID
{
public:
   tcl_ITM_TCU_Charge_Spot_ID();
   
   tcl_MCAN_GenericType_StreamData strCharge_Spot_ID;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Charge_Spot_ID const& lhs, tcl_ITM_TCU_Charge_Spot_ID const& rhs);
tBool operator!=(tcl_ITM_TCU_Charge_Spot_ID const& lhs, tcl_ITM_TCU_Charge_Spot_ID const& rhs);

class tcl_ITM_TCU_Bookable_Free_Text
{
public:
   tcl_ITM_TCU_Bookable_Free_Text();
   
   tcl_MCAN_GenericType_UnsignedInteger uiLength_of_Text;
   tcl_MCAN_GenericType_StreamData vstrText_Info;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Bookable_Free_Text const& lhs, tcl_ITM_TCU_Bookable_Free_Text const& rhs);
tBool operator!=(tcl_ITM_TCU_Bookable_Free_Text const& lhs, tcl_ITM_TCU_Bookable_Free_Text const& rhs);

class tcl_ITM_TCU_Customer_Contract_ID
{
public:
   tcl_ITM_TCU_Customer_Contract_ID();
   
   tcl_MCAN_GenericType_StreamData strCustomer_Contract_ID;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Customer_Contract_ID const& lhs, tcl_ITM_TCU_Customer_Contract_ID const& rhs);
tBool operator!=(tcl_ITM_TCU_Customer_Contract_ID const& lhs, tcl_ITM_TCU_Customer_Contract_ID const& rhs);

class tcl_ITM_TCU_Service_Time_Request
{
public:
   tcl_ITM_TCU_Service_Time_Request();
   
   tcl_MCAN_GenericType_UnsignedInteger uiHour;
   tcl_MCAN_GenericType_UnsignedInteger uiMinute;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Service_Time_Request const& lhs, tcl_ITM_TCU_Service_Time_Request const& rhs);
tBool operator!=(tcl_ITM_TCU_Service_Time_Request const& lhs, tcl_ITM_TCU_Service_Time_Request const& rhs);

class tcl_ITM_TCU_Booking_Status
{
public:
   tcl_ITM_TCU_Booking_Status();
   
   tcl_ITM_TCU_e32_Booking_Status eBooking_Status;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Booking_Status const& lhs, tcl_ITM_TCU_Booking_Status const& rhs);
tBool operator!=(tcl_ITM_TCU_Booking_Status const& lhs, tcl_ITM_TCU_Booking_Status const& rhs);

class tcl_ITM_TCU_Max_Time_To_Arrive
{
public:
   tcl_ITM_TCU_Max_Time_To_Arrive();
   
   tcl_MCAN_GenericType_UnsignedInteger uiHour;
   tcl_MCAN_GenericType_UnsignedInteger uiMinute;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Max_Time_To_Arrive const& lhs, tcl_ITM_TCU_Max_Time_To_Arrive const& rhs);
tBool operator!=(tcl_ITM_TCU_Max_Time_To_Arrive const& lhs, tcl_ITM_TCU_Max_Time_To_Arrive const& rhs);

class tcl_ITM_TCU_Max_Time_To_Unbook
{
public:
   tcl_ITM_TCU_Max_Time_To_Unbook();
   
   tcl_MCAN_GenericType_UnsignedInteger uiHour;
   tcl_MCAN_GenericType_UnsignedInteger uiMinute;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Max_Time_To_Unbook const& lhs, tcl_ITM_TCU_Max_Time_To_Unbook const& rhs);
tBool operator!=(tcl_ITM_TCU_Max_Time_To_Unbook const& lhs, tcl_ITM_TCU_Max_Time_To_Unbook const& rhs);

class tcl_ITM_TCU_Booking_ID
{
public:
   tcl_ITM_TCU_Booking_ID();
   
   tcl_MCAN_GenericType_StreamData strBooking_ID;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Booking_ID const& lhs, tcl_ITM_TCU_Booking_ID const& rhs);
tBool operator!=(tcl_ITM_TCU_Booking_ID const& lhs, tcl_ITM_TCU_Booking_ID const& rhs);

class tcl_ITM_TCU_Charge_Receptacle_Facility_Byte
{
public:
   tcl_ITM_TCU_Charge_Receptacle_Facility_Byte();
   
   tcl_ITM_TCU_e32_Charge_Receptacle_Facility eCharge_Receptacle_Facility_Byte;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Charge_Receptacle_Facility_Byte const& lhs, tcl_ITM_TCU_Charge_Receptacle_Facility_Byte const& rhs);
tBool operator!=(tcl_ITM_TCU_Charge_Receptacle_Facility_Byte const& lhs, tcl_ITM_TCU_Charge_Receptacle_Facility_Byte const& rhs);

class tcl_ITM_TCU_Unbooking_Status
{
public:
   tcl_ITM_TCU_Unbooking_Status();
   
   tcl_ITM_TCU_e32_Unbooking_Status eUnbooking_Status;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Unbooking_Status const& lhs, tcl_ITM_TCU_Unbooking_Status const& rhs);
tBool operator!=(tcl_ITM_TCU_Unbooking_Status const& lhs, tcl_ITM_TCU_Unbooking_Status const& rhs);

class tcl_ITM_TCU_Update_Status
{
public:
   tcl_ITM_TCU_Update_Status();
   
   tcl_ITM_TCU_e32_Update_Status eUpdate_Status;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Update_Status const& lhs, tcl_ITM_TCU_Update_Status const& rhs);
tBool operator!=(tcl_ITM_TCU_Update_Status const& lhs, tcl_ITM_TCU_Update_Status const& rhs);

class tcl_ITM_TCU_Operation_Request
{
public:
   tcl_ITM_TCU_Operation_Request();
   
   tcl_ITM_TCU_e32_copy_Minus_Connect__Cancel eOperation_Request;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Operation_Request const& lhs, tcl_ITM_TCU_Operation_Request const& rhs);
tBool operator!=(tcl_ITM_TCU_Operation_Request const& lhs, tcl_ITM_TCU_Operation_Request const& rhs);

class tcl_ITM_TCU_TCU_Status
{
public:
   tcl_ITM_TCU_TCU_Status();
   
   tcl_ITM_TCU_e32_TCU_State eTCU_Status;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_TCU_Status const& lhs, tcl_ITM_TCU_TCU_Status const& rhs);
tBool operator!=(tcl_ITM_TCU_TCU_Status const& lhs, tcl_ITM_TCU_TCU_Status const& rhs);

class tcl_ITM_TCU_GSM_Status
{
public:
   tcl_ITM_TCU_GSM_Status();
   
   tcl_ITM_TCU_e32_GSM_WCDMA_Status eGSM_Status;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_GSM_Status const& lhs, tcl_ITM_TCU_GSM_Status const& rhs);
tBool operator!=(tcl_ITM_TCU_GSM_Status const& lhs, tcl_ITM_TCU_GSM_Status const& rhs);

class tcl_ITM_TCU_GSM_Data_Mode
{
public:
   tcl_ITM_TCU_GSM_Data_Mode();
   
   tcl_ITM_TCU_e32_GSM_Data_Mode_State eGSM_Data_Mode;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_GSM_Data_Mode const& lhs, tcl_ITM_TCU_GSM_Data_Mode const& rhs);
tBool operator!=(tcl_ITM_TCU_GSM_Data_Mode const& lhs, tcl_ITM_TCU_GSM_Data_Mode const& rhs);

class tcl_ITM_TCU_Modem_Status
{
public:
   tcl_ITM_TCU_Modem_Status();
   
   tcl_ITM_TCU_e32_Modem_State eModem_Status;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Modem_Status const& lhs, tcl_ITM_TCU_Modem_Status const& rhs);
tBool operator!=(tcl_ITM_TCU_Modem_Status const& lhs, tcl_ITM_TCU_Modem_Status const& rhs);

class tcl_ITM_TCU_Wifi_Status
{
public:
   tcl_ITM_TCU_Wifi_Status();
   
   tcl_ITM_TCU_e32_ON_OFF eWifi_Status;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Wifi_Status const& lhs, tcl_ITM_TCU_Wifi_Status const& rhs);
tBool operator!=(tcl_ITM_TCU_Wifi_Status const& lhs, tcl_ITM_TCU_Wifi_Status const& rhs);

class tcl_ITM_TCU_Wifi_HotSpot_Status
{
public:
   tcl_ITM_TCU_Wifi_HotSpot_Status();
   
   tcl_ITM_TCU_e32_Wifi_HotSpot_State eWifi_HotSpot_Status;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Wifi_HotSpot_Status const& lhs, tcl_ITM_TCU_Wifi_HotSpot_Status const& rhs);
tBool operator!=(tcl_ITM_TCU_Wifi_HotSpot_Status const& lhs, tcl_ITM_TCU_Wifi_HotSpot_Status const& rhs);

class tcl_ITM_TCU_Wifi_Client_Status
{
public:
   tcl_ITM_TCU_Wifi_Client_Status();
   
   tcl_ITM_TCU_e32_Wifi_Client_State eWifi_Client_Status;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Wifi_Client_Status const& lhs, tcl_ITM_TCU_Wifi_Client_Status const& rhs);
tBool operator!=(tcl_ITM_TCU_Wifi_Client_Status const& lhs, tcl_ITM_TCU_Wifi_Client_Status const& rhs);

class tcl_ITM_TCU_Wifi_Mode
{
public:
   tcl_ITM_TCU_Wifi_Mode();
   
   tcl_ITM_TCU_e32_Wifi_Mode eWifi_Mode;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Wifi_Mode const& lhs, tcl_ITM_TCU_Wifi_Mode const& rhs);
tBool operator!=(tcl_ITM_TCU_Wifi_Mode const& lhs, tcl_ITM_TCU_Wifi_Mode const& rhs);

class tcl_ITM_TCU_GSM_RSSI_Level
{
public:
   tcl_ITM_TCU_GSM_RSSI_Level();
   
   tcl_MCAN_GenericType_UnsignedInteger uiGSM_RSSI_Level;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_GSM_RSSI_Level const& lhs, tcl_ITM_TCU_GSM_RSSI_Level const& rhs);
tBool operator!=(tcl_ITM_TCU_GSM_RSSI_Level const& lhs, tcl_ITM_TCU_GSM_RSSI_Level const& rhs);

class tcl_ITM_TCU_Wifi_SSID_Name
{
public:
   tcl_ITM_TCU_Wifi_SSID_Name();
   
   tcl_MCAN_GenericType_UnsignedInteger uiCharacter_Set;
   tcl_MCAN_GenericType_UnsignedInteger uiLength_of_Text;
   tcl_MCAN_GenericType_StreamData vstrBody_Text;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Wifi_SSID_Name const& lhs, tcl_ITM_TCU_Wifi_SSID_Name const& rhs);
tBool operator!=(tcl_ITM_TCU_Wifi_SSID_Name const& lhs, tcl_ITM_TCU_Wifi_SSID_Name const& rhs);

class tcl_ITM_TCU_Wifi_PassKey
{
public:
   tcl_ITM_TCU_Wifi_PassKey();
   
   tcl_MCAN_GenericType_UnsignedInteger uiCharacter_Set;
   tcl_MCAN_GenericType_UnsignedInteger uiLength_of_Text;
   tcl_MCAN_GenericType_StreamData vstrBody_Text;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Wifi_PassKey const& lhs, tcl_ITM_TCU_Wifi_PassKey const& rhs);
tBool operator!=(tcl_ITM_TCU_Wifi_PassKey const& lhs, tcl_ITM_TCU_Wifi_PassKey const& rhs);

class tcl_ITM_TCU_Wifi_Security_Mode
{
public:
   tcl_ITM_TCU_Wifi_Security_Mode();
   
   tcl_ITM_TCU_e32_Wifi_Security_Mode eWifi_Security_Mode;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Wifi_Security_Mode const& lhs, tcl_ITM_TCU_Wifi_Security_Mode const& rhs);
tBool operator!=(tcl_ITM_TCU_Wifi_Security_Mode const& lhs, tcl_ITM_TCU_Wifi_Security_Mode const& rhs);

class tcl_ITM_TCU_Wifi_Channel_Number
{
public:
   tcl_ITM_TCU_Wifi_Channel_Number();
   
   tcl_MCAN_GenericType_UnsignedInteger uiWifi_Channel_Number;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Wifi_Channel_Number const& lhs, tcl_ITM_TCU_Wifi_Channel_Number const& rhs);
tBool operator!=(tcl_ITM_TCU_Wifi_Channel_Number const& lhs, tcl_ITM_TCU_Wifi_Channel_Number const& rhs);

class tcl_ITM_TCU_Wifi_Visibility
{
public:
   tcl_ITM_TCU_Wifi_Visibility();
   
   tcl_ITM_TCU_e32_Wifi_Visibility eWifi_Visibility;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Wifi_Visibility const& lhs, tcl_ITM_TCU_Wifi_Visibility const& rhs);
tBool operator!=(tcl_ITM_TCU_Wifi_Visibility const& lhs, tcl_ITM_TCU_Wifi_Visibility const& rhs);

class tcl_ITM_TCU_Wifi_Client_SSID
{
public:
   tcl_ITM_TCU_Wifi_Client_SSID();
   
   tcl_MCAN_GenericType_UnsignedInteger uiWifi_Client_SSID;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Wifi_Client_SSID const& lhs, tcl_ITM_TCU_Wifi_Client_SSID const& rhs);
tBool operator!=(tcl_ITM_TCU_Wifi_Client_SSID const& lhs, tcl_ITM_TCU_Wifi_Client_SSID const& rhs);

class tcl_ITM_TCU_Wifi_Client_Power
{
public:
   tcl_ITM_TCU_Wifi_Client_Power();
   
   tcl_MCAN_GenericType_UnsignedInteger uiWifi_Client_Power;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Wifi_Client_Power const& lhs, tcl_ITM_TCU_Wifi_Client_Power const& rhs);
tBool operator!=(tcl_ITM_TCU_Wifi_Client_Power const& lhs, tcl_ITM_TCU_Wifi_Client_Power const& rhs);

class tcl_ITM_TCU_Wifi_Connection_Status
{
public:
   tcl_ITM_TCU_Wifi_Connection_Status();
   
   tcl_ITM_TCU_e32_Wifi_Connection_State eWifi_Connection_Status;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Wifi_Connection_Status const& lhs, tcl_ITM_TCU_Wifi_Connection_Status const& rhs);
tBool operator!=(tcl_ITM_TCU_Wifi_Connection_Status const& lhs, tcl_ITM_TCU_Wifi_Connection_Status const& rhs);

class tcl_ITM_TCU_Wifi_Scan_SSID_Name
{
public:
   tcl_ITM_TCU_Wifi_Scan_SSID_Name();
   
   tcl_MCAN_GenericType_UnsignedInteger uiCharacter_Set;
   tcl_MCAN_GenericType_UnsignedInteger uiLength_of_Text;
   tcl_MCAN_GenericType_StreamData vstrBody_Text;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Wifi_Scan_SSID_Name const& lhs, tcl_ITM_TCU_Wifi_Scan_SSID_Name const& rhs);
tBool operator!=(tcl_ITM_TCU_Wifi_Scan_SSID_Name const& lhs, tcl_ITM_TCU_Wifi_Scan_SSID_Name const& rhs);

class tcl_ITM_TCU_Wifi_Scan_Power
{
public:
   tcl_ITM_TCU_Wifi_Scan_Power();
   
   tcl_MCAN_GenericType_UnsignedInteger uiWifi_Scan_Power;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Wifi_Scan_Power const& lhs, tcl_ITM_TCU_Wifi_Scan_Power const& rhs);
tBool operator!=(tcl_ITM_TCU_Wifi_Scan_Power const& lhs, tcl_ITM_TCU_Wifi_Scan_Power const& rhs);

class tcl_ITM_TCU_Wifi_Scan_Security
{
public:
   tcl_ITM_TCU_Wifi_Scan_Security();
   
   tcl_ITM_TCU_e32_Wifi_Scan_Security eWifi_Scan_Security;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Wifi_Scan_Security const& lhs, tcl_ITM_TCU_Wifi_Scan_Security const& rhs);
tBool operator!=(tcl_ITM_TCU_Wifi_Scan_Security const& lhs, tcl_ITM_TCU_Wifi_Scan_Security const& rhs);

class tcl_ITM_TCU_Wifi_Connected_Devices
{
public:
   tcl_ITM_TCU_Wifi_Connected_Devices();
   
   tcl_MCAN_GenericType_UnsignedInteger uiWifi_Connected_Devices;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Wifi_Connected_Devices const& lhs, tcl_ITM_TCU_Wifi_Connected_Devices const& rhs);
tBool operator!=(tcl_ITM_TCU_Wifi_Connected_Devices const& lhs, tcl_ITM_TCU_Wifi_Connected_Devices const& rhs);

class tcl_ITM_TCU_Charge_Day1_Start
{
public:
   tcl_ITM_TCU_Charge_Day1_Start();
   
   tcl_MCAN_GenericType_UnsignedInteger uiCharge_Day1_Start;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Charge_Day1_Start const& lhs, tcl_ITM_TCU_Charge_Day1_Start const& rhs);
tBool operator!=(tcl_ITM_TCU_Charge_Day1_Start const& lhs, tcl_ITM_TCU_Charge_Day1_Start const& rhs);

class tcl_ITM_TCU_Charge_Day1_End
{
public:
   tcl_ITM_TCU_Charge_Day1_End();
   
   tcl_MCAN_GenericType_UnsignedInteger uiCharge_Day1_End;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Charge_Day1_End const& lhs, tcl_ITM_TCU_Charge_Day1_End const& rhs);
tBool operator!=(tcl_ITM_TCU_Charge_Day1_End const& lhs, tcl_ITM_TCU_Charge_Day1_End const& rhs);

class tcl_ITM_TCU_Charge_Day2_Start
{
public:
   tcl_ITM_TCU_Charge_Day2_Start();
   
   tcl_MCAN_GenericType_UnsignedInteger uiCharge_Day2_Start;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Charge_Day2_Start const& lhs, tcl_ITM_TCU_Charge_Day2_Start const& rhs);
tBool operator!=(tcl_ITM_TCU_Charge_Day2_Start const& lhs, tcl_ITM_TCU_Charge_Day2_Start const& rhs);

class tcl_ITM_TCU_Charge_Day2_End
{
public:
   tcl_ITM_TCU_Charge_Day2_End();
   
   tcl_MCAN_GenericType_UnsignedInteger uiCharge_Day2_End;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Charge_Day2_End const& lhs, tcl_ITM_TCU_Charge_Day2_End const& rhs);
tBool operator!=(tcl_ITM_TCU_Charge_Day2_End const& lhs, tcl_ITM_TCU_Charge_Day2_End const& rhs);

class tcl_ITM_TCU_Charge_Day3_Start
{
public:
   tcl_ITM_TCU_Charge_Day3_Start();
   
   tcl_MCAN_GenericType_UnsignedInteger uiCharge_Day3_Start;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Charge_Day3_Start const& lhs, tcl_ITM_TCU_Charge_Day3_Start const& rhs);
tBool operator!=(tcl_ITM_TCU_Charge_Day3_Start const& lhs, tcl_ITM_TCU_Charge_Day3_Start const& rhs);

class tcl_ITM_TCU_Charge_Day3_End
{
public:
   tcl_ITM_TCU_Charge_Day3_End();
   
   tcl_MCAN_GenericType_UnsignedInteger uiCharge_Day3_End;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Charge_Day3_End const& lhs, tcl_ITM_TCU_Charge_Day3_End const& rhs);
tBool operator!=(tcl_ITM_TCU_Charge_Day3_End const& lhs, tcl_ITM_TCU_Charge_Day3_End const& rhs);

class tcl_ITM_TCU_Charge_Day4_Start
{
public:
   tcl_ITM_TCU_Charge_Day4_Start();
   
   tcl_MCAN_GenericType_UnsignedInteger uiCharge_Day4_Start;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Charge_Day4_Start const& lhs, tcl_ITM_TCU_Charge_Day4_Start const& rhs);
tBool operator!=(tcl_ITM_TCU_Charge_Day4_Start const& lhs, tcl_ITM_TCU_Charge_Day4_Start const& rhs);

class tcl_ITM_TCU_Charge_Day4_End
{
public:
   tcl_ITM_TCU_Charge_Day4_End();
   
   tcl_MCAN_GenericType_UnsignedInteger uiCharge_Day4_End;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Charge_Day4_End const& lhs, tcl_ITM_TCU_Charge_Day4_End const& rhs);
tBool operator!=(tcl_ITM_TCU_Charge_Day4_End const& lhs, tcl_ITM_TCU_Charge_Day4_End const& rhs);

class tcl_ITM_TCU_Charge_Day5_Start
{
public:
   tcl_ITM_TCU_Charge_Day5_Start();
   
   tcl_MCAN_GenericType_UnsignedInteger uiCharge_Day5_Start;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Charge_Day5_Start const& lhs, tcl_ITM_TCU_Charge_Day5_Start const& rhs);
tBool operator!=(tcl_ITM_TCU_Charge_Day5_Start const& lhs, tcl_ITM_TCU_Charge_Day5_Start const& rhs);

class tcl_ITM_TCU_Charge_Day5_End
{
public:
   tcl_ITM_TCU_Charge_Day5_End();
   
   tcl_MCAN_GenericType_UnsignedInteger uiCharge_Day5_End;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Charge_Day5_End const& lhs, tcl_ITM_TCU_Charge_Day5_End const& rhs);
tBool operator!=(tcl_ITM_TCU_Charge_Day5_End const& lhs, tcl_ITM_TCU_Charge_Day5_End const& rhs);

class tcl_ITM_TCU_Charge_Day6_Start
{
public:
   tcl_ITM_TCU_Charge_Day6_Start();
   
   tcl_MCAN_GenericType_UnsignedInteger uiCharge_Day6_Start;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Charge_Day6_Start const& lhs, tcl_ITM_TCU_Charge_Day6_Start const& rhs);
tBool operator!=(tcl_ITM_TCU_Charge_Day6_Start const& lhs, tcl_ITM_TCU_Charge_Day6_Start const& rhs);

class tcl_ITM_TCU_Charge_Day6_End
{
public:
   tcl_ITM_TCU_Charge_Day6_End();
   
   tcl_MCAN_GenericType_UnsignedInteger uiCharge_Day6_End;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Charge_Day6_End const& lhs, tcl_ITM_TCU_Charge_Day6_End const& rhs);
tBool operator!=(tcl_ITM_TCU_Charge_Day6_End const& lhs, tcl_ITM_TCU_Charge_Day6_End const& rhs);

class tcl_ITM_TCU_Charge_Day7_Start
{
public:
   tcl_ITM_TCU_Charge_Day7_Start();
   
   tcl_MCAN_GenericType_UnsignedInteger uiCharge_Day7_Start;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Charge_Day7_Start const& lhs, tcl_ITM_TCU_Charge_Day7_Start const& rhs);
tBool operator!=(tcl_ITM_TCU_Charge_Day7_Start const& lhs, tcl_ITM_TCU_Charge_Day7_Start const& rhs);

class tcl_ITM_TCU_Charge_Day7_End
{
public:
   tcl_ITM_TCU_Charge_Day7_End();
   
   tcl_MCAN_GenericType_UnsignedInteger uiCharge_Day7_End;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Charge_Day7_End const& lhs, tcl_ITM_TCU_Charge_Day7_End const& rhs);
tBool operator!=(tcl_ITM_TCU_Charge_Day7_End const& lhs, tcl_ITM_TCU_Charge_Day7_End const& rhs);

class tcl_ITM_TCU_Charge_Blocked_Status
{
public:
   tcl_ITM_TCU_Charge_Blocked_Status();
   
   tcl_ITM_TCU_e32_Charge_Blocked_Status eCharge_Blocked_Status;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Charge_Blocked_Status const& lhs, tcl_ITM_TCU_Charge_Blocked_Status const& rhs);
tBool operator!=(tcl_ITM_TCU_Charge_Blocked_Status const& lhs, tcl_ITM_TCU_Charge_Blocked_Status const& rhs);

class tcl_ITM_TCU_Curfew_Warning
{
public:
   tcl_ITM_TCU_Curfew_Warning();
   
   tcl_ITM_TCU_e32_Curfew_Warning eCurfew_Warning;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Curfew_Warning const& lhs, tcl_ITM_TCU_Curfew_Warning const& rhs);
tBool operator!=(tcl_ITM_TCU_Curfew_Warning const& lhs, tcl_ITM_TCU_Curfew_Warning const& rhs);

class tcl_ITM_TCU_Ecall_State_Display
{
public:
   tcl_ITM_TCU_Ecall_State_Display();
   
   tcl_ITM_TCU_e32_ECALL_State_Display eEcall_State_Display;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Ecall_State_Display const& lhs, tcl_ITM_TCU_Ecall_State_Display const& rhs);
tBool operator!=(tcl_ITM_TCU_Ecall_State_Display const& lhs, tcl_ITM_TCU_Ecall_State_Display const& rhs);

class tcl_ITM_TCU_Connecting_Point
{
public:
   tcl_ITM_TCU_Connecting_Point();
   
   tcl_MCAN_GenericType_UnsignedInteger uiConnecting_Point;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Connecting_Point const& lhs, tcl_ITM_TCU_Connecting_Point const& rhs);
tBool operator!=(tcl_ITM_TCU_Connecting_Point const& lhs, tcl_ITM_TCU_Connecting_Point const& rhs);

class tcl_ITM_TCU_Pages_Of_List
{
public:
   tcl_ITM_TCU_Pages_Of_List();
   
   tcl_MCAN_GenericType_UnsignedInteger uiPages_Of_List;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Pages_Of_List const& lhs, tcl_ITM_TCU_Pages_Of_List const& rhs);
tBool operator!=(tcl_ITM_TCU_Pages_Of_List const& lhs, tcl_ITM_TCU_Pages_Of_List const& rhs);

class tcl_ITM_TCU_Sch_Activation_State
{
public:
   tcl_ITM_TCU_Sch_Activation_State();
   
   tcl_ITM_TCU_e32_Sch_Activation_State eSch_Activation_State;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Sch_Activation_State const& lhs, tcl_ITM_TCU_Sch_Activation_State const& rhs);
tBool operator!=(tcl_ITM_TCU_Sch_Activation_State const& lhs, tcl_ITM_TCU_Sch_Activation_State const& rhs);

class tcl_ITM_TCU_Probe_Permit_Setting
{
public:
   tcl_ITM_TCU_Probe_Permit_Setting();
   
   tcl_ITM_TCU_e32_ON_OFF eProbe_Permit_Setting;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Probe_Permit_Setting const& lhs, tcl_ITM_TCU_Probe_Permit_Setting const& rhs);
tBool operator!=(tcl_ITM_TCU_Probe_Permit_Setting const& lhs, tcl_ITM_TCU_Probe_Permit_Setting const& rhs);

class tcl_ITM_TCU_ACNCALL_Service_State
{
public:
   tcl_ITM_TCU_ACNCALL_Service_State();
   
   tcl_ITM_TCU_e32_Service_State eACNCALL_Service_State;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_ACNCALL_Service_State const& lhs, tcl_ITM_TCU_ACNCALL_Service_State const& rhs);
tBool operator!=(tcl_ITM_TCU_ACNCALL_Service_State const& lhs, tcl_ITM_TCU_ACNCALL_Service_State const& rhs);

class tcl_ITM_TCU_ECALL_Service_State
{
public:
   tcl_ITM_TCU_ECALL_Service_State();
   
   tcl_ITM_TCU_e32_Service_State eECALL_Service_State;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_ECALL_Service_State const& lhs, tcl_ITM_TCU_ECALL_Service_State const& rhs);
tBool operator!=(tcl_ITM_TCU_ECALL_Service_State const& lhs, tcl_ITM_TCU_ECALL_Service_State const& rhs);

class tcl_ITM_TCU_Navi_Vehicle_Speed
{
public:
   tcl_ITM_TCU_Navi_Vehicle_Speed();
   
   tcl_MCAN_GenericType_UnsignedInteger uiNavi_Vehicle_Speed;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Navi_Vehicle_Speed const& lhs, tcl_ITM_TCU_Navi_Vehicle_Speed const& rhs);
tBool operator!=(tcl_ITM_TCU_Navi_Vehicle_Speed const& lhs, tcl_ITM_TCU_Navi_Vehicle_Speed const& rhs);

class tcl_ITM_TCU_Navi_Driving_Distance
{
public:
   tcl_ITM_TCU_Navi_Driving_Distance();
   
   tcl_MCAN_GenericType_UnsignedInteger uiNavi_Driving_Distance;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Navi_Driving_Distance const& lhs, tcl_ITM_TCU_Navi_Driving_Distance const& rhs);
tBool operator!=(tcl_ITM_TCU_Navi_Driving_Distance const& lhs, tcl_ITM_TCU_Navi_Driving_Distance const& rhs);

class tcl_ITM_TCU_Navi_Road_Classification
{
public:
   tcl_ITM_TCU_Navi_Road_Classification();
   
   tcl_MCAN_GenericType_UnsignedInteger uiTable_Type;
   tcl_MCAN_GenericType_UnsignedInteger uiRoad_Type;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Navi_Road_Classification const& lhs, tcl_ITM_TCU_Navi_Road_Classification const& rhs);
tBool operator!=(tcl_ITM_TCU_Navi_Road_Classification const& lhs, tcl_ITM_TCU_Navi_Road_Classification const& rhs);

class tcl_ITM_TCU_Wifi_SSID
{
public:
   tcl_ITM_TCU_Wifi_SSID();
   
   tcl_MCAN_GenericType_UnsignedInteger uiCharacter_Set;
   tcl_MCAN_GenericType_UnsignedInteger uiLength_of_Text;
   tcl_MCAN_GenericType_StreamData vstrBody_Text;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Wifi_SSID const& lhs, tcl_ITM_TCU_Wifi_SSID const& rhs);
tBool operator!=(tcl_ITM_TCU_Wifi_SSID const& lhs, tcl_ITM_TCU_Wifi_SSID const& rhs);

class tcl_ITM_TCU_IMEI
{
public:
   tcl_ITM_TCU_IMEI();
   
   tcl_MCAN_GenericType_StreamData strIMEI;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_IMEI const& lhs, tcl_ITM_TCU_IMEI const& rhs);
tBool operator!=(tcl_ITM_TCU_IMEI const& lhs, tcl_ITM_TCU_IMEI const& rhs);

class tcl_ITM_TCU_MCC
{
public:
   tcl_ITM_TCU_MCC();
   
   tcl_MCAN_GenericType_UnsignedInteger uiMCC;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_MCC const& lhs, tcl_ITM_TCU_MCC const& rhs);
tBool operator!=(tcl_ITM_TCU_MCC const& lhs, tcl_ITM_TCU_MCC const& rhs);

class tcl_ITM_TCU_MNC
{
public:
   tcl_ITM_TCU_MNC();
   
   tcl_MCAN_GenericType_UnsignedInteger uiMNC;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_MNC const& lhs, tcl_ITM_TCU_MNC const& rhs);
tBool operator!=(tcl_ITM_TCU_MNC const& lhs, tcl_ITM_TCU_MNC const& rhs);

class tcl_ITM_TCU_Mobile_Network_Name
{
public:
   tcl_ITM_TCU_Mobile_Network_Name();
   
   tcl_MCAN_GenericType_StreamData strMobile_Network_Name;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Mobile_Network_Name const& lhs, tcl_ITM_TCU_Mobile_Network_Name const& rhs);
tBool operator!=(tcl_ITM_TCU_Mobile_Network_Name const& lhs, tcl_ITM_TCU_Mobile_Network_Name const& rhs);

class tcl_ITM_TCU_Roaming_status
{
public:
   tcl_ITM_TCU_Roaming_status();
   
   tcl_ITM_TCU_e32_Roaming_status eRoaming_status;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Roaming_status const& lhs, tcl_ITM_TCU_Roaming_status const& rhs);
tBool operator!=(tcl_ITM_TCU_Roaming_status const& lhs, tcl_ITM_TCU_Roaming_status const& rhs);

class tcl_ITM_TCU_PPP_connection_status
{
public:
   tcl_ITM_TCU_PPP_connection_status();
   
   tcl_ITM_TCU_e32_PPP_connection_status ePPP_connection_status;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_PPP_connection_status const& lhs, tcl_ITM_TCU_PPP_connection_status const& rhs);
tBool operator!=(tcl_ITM_TCU_PPP_connection_status const& lhs, tcl_ITM_TCU_PPP_connection_status const& rhs);

class tcl_ITM_TCU_POI_ID
{
public:
   tcl_ITM_TCU_POI_ID();
   
   tcl_MCAN_GenericType_UnsignedInteger uiPOI_ID;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_POI_ID const& lhs, tcl_ITM_TCU_POI_ID const& rhs);
tBool operator!=(tcl_ITM_TCU_POI_ID const& lhs, tcl_ITM_TCU_POI_ID const& rhs);

class tcl_ITM_TCU_POI_GPS_Position
{
public:
   tcl_ITM_TCU_POI_GPS_Position();
   
   tcl_MCAN_GenericType_StreamData aReserved;
   tcl_ITM_TCU_e32_LocationType eLocationType;
   tcl_ITM_TCU_e32_LattitudeMode eLattitudeMode;
   tcl_ITM_TCU_e32_LongitudeMode eLongitudeMode;
   tcl_MCAN_GenericType_UnsignedInteger uiLattitudeDEG;
   tcl_MCAN_GenericType_UnsignedInteger uiLattitudeMIN;
   tcl_MCAN_GenericType_UnsignedInteger uiLattitudeSEC;
   tcl_MCAN_GenericType_UnsignedInteger uiLongitudeDEG;
   tcl_MCAN_GenericType_UnsignedInteger uiLongitudeMIN;
   tcl_MCAN_GenericType_UnsignedInteger uiLongitudeSEC;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_POI_GPS_Position const& lhs, tcl_ITM_TCU_POI_GPS_Position const& rhs);
tBool operator!=(tcl_ITM_TCU_POI_GPS_Position const& lhs, tcl_ITM_TCU_POI_GPS_Position const& rhs);

class tcl_ITM_TCU_POI_Name
{
public:
   tcl_ITM_TCU_POI_Name();
   
   tcl_MCAN_GenericType_StreamData strPOI_Name;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_POI_Name const& lhs, tcl_ITM_TCU_POI_Name const& rhs);
tBool operator!=(tcl_ITM_TCU_POI_Name const& lhs, tcl_ITM_TCU_POI_Name const& rhs);

class tcl_ITM_TCU_Time_Slot
{
public:
   tcl_ITM_TCU_Time_Slot();
   
   tcl_MCAN_GenericType_UnsignedInteger uiStart_Time_Stamp_Year;
   tcl_MCAN_GenericType_UnsignedInteger uiStart_Time_Stamp_Month;
   tcl_MCAN_GenericType_UnsignedInteger uiStart_Time_Stamp_Day;
   tcl_MCAN_GenericType_UnsignedInteger uiStart_Time_Stamp_Hour;
   tcl_MCAN_GenericType_UnsignedInteger uiStart_Time_Stamp_Minute;
   tcl_MCAN_GenericType_UnsignedInteger uiStart_Time_Stamp_Second;
   tcl_MCAN_GenericType_StreamData aStart_Time_Stamp_Reserve;
   tcl_MCAN_GenericType_UnsignedInteger uiStop_Time_Stamp_Year;
   tcl_MCAN_GenericType_UnsignedInteger uiStop_Time_Stamp_Month;
   tcl_MCAN_GenericType_UnsignedInteger uiStop_Time_Stamp_Day;
   tcl_MCAN_GenericType_UnsignedInteger uiStop_Time_Stamp_Hour;
   tcl_MCAN_GenericType_UnsignedInteger uiStop_Time_Stamp_Minute;
   tcl_MCAN_GenericType_UnsignedInteger uiStop_Time_Stamp_Second;
   tcl_MCAN_GenericType_StreamData aStop_Time_Stamp_Reserve;
   tcl_ITM_TCU_e32_Cycle eCycle;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Time_Slot const& lhs, tcl_ITM_TCU_Time_Slot const& rhs);
tBool operator!=(tcl_ITM_TCU_Time_Slot const& lhs, tcl_ITM_TCU_Time_Slot const& rhs);

class tcl_ITM_TCU_Limited_Vehicle_Speed
{
public:
   tcl_ITM_TCU_Limited_Vehicle_Speed();
   
   tcl_MCAN_GenericType_UnsignedInteger uiLimited_Vehicle_Speed;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Limited_Vehicle_Speed const& lhs, tcl_ITM_TCU_Limited_Vehicle_Speed const& rhs);
tBool operator!=(tcl_ITM_TCU_Limited_Vehicle_Speed const& lhs, tcl_ITM_TCU_Limited_Vehicle_Speed const& rhs);

class tcl_ITM_TCU_Area_Limit_Coordinates
{
public:
   tcl_ITM_TCU_Area_Limit_Coordinates();
   
   tcl_ITM_TCU_e32_Restriction_Area_Type eRestriction_Area_Type;
   tcl_ITM_TCU_e32_Area_Form eArea_Form;
   tcl_ITM_TCU_e32_Location_Type eLocationType;
   tcl_ITM_TCU_e32_North_South eArea_Coordinates_Coordinates_1_Lattitude_Mode;
   tcl_ITM_TCU_e32_East_West eArea_Coordinates_Coordinates_1_Longitude_Mode;
   tcl_MCAN_GenericType_UnsignedInteger uiArea_Coordinates_Coordinates_1_Lattitude_DEG;
   tcl_MCAN_GenericType_UnsignedInteger uiArea_Coordinates_Coordinates_1_Lattitude_MIN;
   tcl_MCAN_GenericType_UnsignedInteger uiArea_Coordinates_Coordinates_1_Lattitude_SEC;
   tcl_MCAN_GenericType_UnsignedInteger uiArea_Coordinates_Coordinates_1_Longitude_DEG;
   tcl_MCAN_GenericType_UnsignedInteger uiArea_Coordinates_Coordinates_1_Longitude_MIN;
   tcl_MCAN_GenericType_UnsignedInteger uiArea_Coordinates_Coordinates_1_Longitude_SEC;
   tcl_MCAN_GenericType_StreamData aArea_Coordinates_Coordinates_1_Reserve;
   tcl_ITM_TCU_e32_North_South eArea_Coordinates_Coordinates_2_Lattitude_Mode;
   tcl_ITM_TCU_e32_East_West eArea_Coordinates_Coordinates_2_Longitude_Mode;
   tcl_MCAN_GenericType_UnsignedInteger uiArea_Coordinates_Coordinates_2_Lattitude_DEG;
   tcl_MCAN_GenericType_UnsignedInteger uiArea_Coordinates_Coordinates_2_Lattitude_MIN;
   tcl_MCAN_GenericType_UnsignedInteger uiArea_Coordinates_Coordinates_2_Lattitude_SEC;
   tcl_MCAN_GenericType_UnsignedInteger uiArea_Coordinates_Coordinates_2_Longitude_DEG;
   tcl_MCAN_GenericType_UnsignedInteger uiArea_Coordinates_Coordinates_2_Longitude_MIN;
   tcl_MCAN_GenericType_UnsignedInteger uiArea_Coordinates_Coordinates_2_Longitude_SEC;
   tcl_MCAN_GenericType_StreamData aArea_Coordinates_Coordinates_2_Reserve;
   tcl_MCAN_GenericType_UnsignedInteger uiRadius;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Area_Limit_Coordinates const& lhs, tcl_ITM_TCU_Area_Limit_Coordinates const& rhs);
tBool operator!=(tcl_ITM_TCU_Area_Limit_Coordinates const& lhs, tcl_ITM_TCU_Area_Limit_Coordinates const& rhs);

class tcl_ITM_TCU_Geofencing_Activation_State
{
public:
   tcl_ITM_TCU_Geofencing_Activation_State();
   
   tcl_ITM_TCU_e32_Geofencing_Activation_State eGeofencing_Activation_State;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Geofencing_Activation_State const& lhs, tcl_ITM_TCU_Geofencing_Activation_State const& rhs);
tBool operator!=(tcl_ITM_TCU_Geofencing_Activation_State const& lhs, tcl_ITM_TCU_Geofencing_Activation_State const& rhs);

class tcl_ITM_TCU_Time_Limit_Restriction
{
public:
   tcl_ITM_TCU_Time_Limit_Restriction();
   
   tcl_MCAN_GenericType_UnsignedInteger uiNumber_Of_Time_Slot;
   class tclTime_Limit_Restriction{
   public:
      tclTime_Limit_Restriction() : uiTime_Slot_Start_Time_Stamp_Year(0x00, 0x10)
         , uiTime_Slot_Start_Time_Stamp_Month(0x00, 0x04)
         , uiTime_Slot_Start_Time_Stamp_Day(0x00, 0x05)
         , uiTime_Slot_Start_Time_Stamp_Hour(0x00, 0x05)
         , uiTime_Slot_Start_Time_Stamp_Minute(0x00, 0x06)
         , uiTime_Slot_Start_Time_Stamp_Second(0x00, 0x06)
         , aTime_Slot_Start_Time_Stamp_Reserve(NULL, 0x06)
         , uiTime_Slot_Stop_Time_Stamp_Year(0x00, 0x10)
         , uiTime_Slot_Stop_Time_Stamp_Month(0x00, 0x04)
         , uiTime_Slot_Stop_Time_Stamp_Day(0x00, 0x05)
         , uiTime_Slot_Stop_Time_Stamp_Hour(0x00, 0x05)
         , uiTime_Slot_Stop_Time_Stamp_Minute(0x00, 0x06)
         , uiTime_Slot_Stop_Time_Stamp_Second(0x00, 0x06)
         , aTime_Slot_Stop_Time_Stamp_Reserve(NULL, 0x06)
         , eTime_Slot_Cycle((tcl_ITM_TCU_e32_Cycle::tenType)0x00, 0x08)
         {};
      ~tclTime_Limit_Restriction() {};
      tcl_MCAN_GenericType_UnsignedInteger uiTime_Slot_Start_Time_Stamp_Year;
      tcl_MCAN_GenericType_UnsignedInteger uiTime_Slot_Start_Time_Stamp_Month;
      tcl_MCAN_GenericType_UnsignedInteger uiTime_Slot_Start_Time_Stamp_Day;
      tcl_MCAN_GenericType_UnsignedInteger uiTime_Slot_Start_Time_Stamp_Hour;
      tcl_MCAN_GenericType_UnsignedInteger uiTime_Slot_Start_Time_Stamp_Minute;
      tcl_MCAN_GenericType_UnsignedInteger uiTime_Slot_Start_Time_Stamp_Second;
      tcl_MCAN_GenericType_StreamData aTime_Slot_Start_Time_Stamp_Reserve;
      tcl_MCAN_GenericType_UnsignedInteger uiTime_Slot_Stop_Time_Stamp_Year;
      tcl_MCAN_GenericType_UnsignedInteger uiTime_Slot_Stop_Time_Stamp_Month;
      tcl_MCAN_GenericType_UnsignedInteger uiTime_Slot_Stop_Time_Stamp_Day;
      tcl_MCAN_GenericType_UnsignedInteger uiTime_Slot_Stop_Time_Stamp_Hour;
      tcl_MCAN_GenericType_UnsignedInteger uiTime_Slot_Stop_Time_Stamp_Minute;
      tcl_MCAN_GenericType_UnsignedInteger uiTime_Slot_Stop_Time_Stamp_Second;
      tcl_MCAN_GenericType_StreamData aTime_Slot_Stop_Time_Stamp_Reserve;
      tcl_ITM_TCU_e32_Cycle eTime_Slot_Cycle;
   };
   ::std::vector < tclTime_Limit_Restriction >  vecTime_Limit_Restriction;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Time_Limit_Restriction const& lhs, tcl_ITM_TCU_Time_Limit_Restriction const& rhs);
tBool operator!=(tcl_ITM_TCU_Time_Limit_Restriction const& lhs, tcl_ITM_TCU_Time_Limit_Restriction const& rhs);

#if 0
class tcl_ITM_TCU_Speed_Limit_Restriction
{
public:
   tcl_ITM_TCU_Speed_Limit_Restriction();
   
   tcl_MCAN_GenericType_UnsignedInteger uiNumber_Of_Speed_Limit;
    Limited_Vehicle_Speed;
   tcl_MCAN_GenericType_UnsignedInteger uiNumber_Of_Time_Slot;
   class tclSpeed_Limit_Restriction{
   public:
      tclSpeed_Limit_Restriction() : uiTime_Slot_Start_Time_Stamp_Year(0x00, 0x10)
         , uiTime_Slot_Start_Time_Stamp_Month(0x00, 0x04)
         , uiTime_Slot_Start_Time_Stamp_Day(0x00, 0x05)
         , uiTime_Slot_Start_Time_Stamp_Hour(0x00, 0x05)
         , uiTime_Slot_Start_Time_Stamp_Minute(0x00, 0x06)
         , uiTime_Slot_Start_Time_Stamp_Second(0x00, 0x06)
         , aTime_Slot_Start_Time_Stamp_Reserve(NULL, 0x06)
         , uiTime_Slot_Stop_Time_Stamp_Year(0x00, 0x10)
         , uiTime_Slot_Stop_Time_Stamp_Month(0x00, 0x04)
         , uiTime_Slot_Stop_Time_Stamp_Day(0x00, 0x05)
         , uiTime_Slot_Stop_Time_Stamp_Hour(0x00, 0x05)
         , uiTime_Slot_Stop_Time_Stamp_Minute(0x00, 0x06)
         , uiTime_Slot_Stop_Time_Stamp_Second(0x00, 0x06)
         , aTime_Slot_Stop_Time_Stamp_Reserve(NULL, 0x06)
         , eTime_Slot_Cycle((tcl_ITM_TCU_e32_Cycle::tenType)0x00, 0x08)
         {};
      ~tclSpeed_Limit_Restriction() {};
      tcl_MCAN_GenericType_UnsignedInteger uiTime_Slot_Start_Time_Stamp_Year;
      tcl_MCAN_GenericType_UnsignedInteger uiTime_Slot_Start_Time_Stamp_Month;
      tcl_MCAN_GenericType_UnsignedInteger uiTime_Slot_Start_Time_Stamp_Day;
      tcl_MCAN_GenericType_UnsignedInteger uiTime_Slot_Start_Time_Stamp_Hour;
      tcl_MCAN_GenericType_UnsignedInteger uiTime_Slot_Start_Time_Stamp_Minute;
      tcl_MCAN_GenericType_UnsignedInteger uiTime_Slot_Start_Time_Stamp_Second;
      tcl_MCAN_GenericType_StreamData aTime_Slot_Start_Time_Stamp_Reserve;
      tcl_MCAN_GenericType_UnsignedInteger uiTime_Slot_Stop_Time_Stamp_Year;
      tcl_MCAN_GenericType_UnsignedInteger uiTime_Slot_Stop_Time_Stamp_Month;
      tcl_MCAN_GenericType_UnsignedInteger uiTime_Slot_Stop_Time_Stamp_Day;
      tcl_MCAN_GenericType_UnsignedInteger uiTime_Slot_Stop_Time_Stamp_Hour;
      tcl_MCAN_GenericType_UnsignedInteger uiTime_Slot_Stop_Time_Stamp_Minute;
      tcl_MCAN_GenericType_UnsignedInteger uiTime_Slot_Stop_Time_Stamp_Second;
      tcl_MCAN_GenericType_StreamData aTime_Slot_Stop_Time_Stamp_Reserve;
      tcl_ITM_TCU_e32_Cycle eTime_Slot_Cycle;
   };
   ::std::vector < tclSpeed_Limit_Restriction >  vecSpeed_Limit_Restriction;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Speed_Limit_Restriction const& lhs, tcl_ITM_TCU_Speed_Limit_Restriction const& rhs);
tBool operator!=(tcl_ITM_TCU_Speed_Limit_Restriction const& lhs, tcl_ITM_TCU_Speed_Limit_Restriction const& rhs);
#endif

class tcl_ITM_TCU_Area_Limit_Restriction
{
public:
   tcl_ITM_TCU_Area_Limit_Restriction();
   
   tcl_MCAN_GenericType_UnsignedInteger uiNumber_Of_Area;
   class tclArea_Limit_Restriction{
   public:
      tclArea_Limit_Restriction() : eArea_Limit_Coordinates_Restriction_Area_Type((tcl_ITM_TCU_e32_Restriction_Area_Type::tenType)0x01, 0x08)
         , eArea_Limit_Coordinates_Area_Form((tcl_ITM_TCU_e32_Area_Form::tenType)0x01, 0x08)
         , eArea_Limit_Coordinates_LocationType((tcl_ITM_TCU_e32_Location_Type::tenType)0x01, 0x08)
         , eArea_Limit_Coordinates_Area_Coordinates_Coordinates_1_Lattitude_Mode((tcl_ITM_TCU_e32_North_South::tenType)0x00, 0x01)
         , eArea_Limit_Coordinates_Area_Coordinates_Coordinates_1_Longitude_Mode((tcl_ITM_TCU_e32_East_West::tenType)0x00, 0x01)
         , uiArea_Limit_Coordinates_Area_Coordinates_Coordinates_1_Lattitude_DEG(0x00, 0x08)
         , uiArea_Limit_Coordinates_Area_Coordinates_Coordinates_1_Lattitude_MIN(0x00, 0x08)
         , uiArea_Limit_Coordinates_Area_Coordinates_Coordinates_1_Lattitude_SEC(0x00, 0x10)
         , uiArea_Limit_Coordinates_Area_Coordinates_Coordinates_1_Longitude_DEG(0x00, 0x08)
         , uiArea_Limit_Coordinates_Area_Coordinates_Coordinates_1_Longitude_MIN(0x00, 0x08)
         , uiArea_Limit_Coordinates_Area_Coordinates_Coordinates_1_Longitude_SEC(0x00, 0x10)
         , aArea_Limit_Coordinates_Area_Coordinates_Coordinates_1_Reserve(NULL, 0x06)
         , eArea_Limit_Coordinates_Area_Coordinates_Coordinates_2_Lattitude_Mode((tcl_ITM_TCU_e32_North_South::tenType)0x00, 0x01)
         , eArea_Limit_Coordinates_Area_Coordinates_Coordinates_2_Longitude_Mode((tcl_ITM_TCU_e32_East_West::tenType)0x00, 0x01)
         , uiArea_Limit_Coordinates_Area_Coordinates_Coordinates_2_Lattitude_DEG(0x00, 0x08)
         , uiArea_Limit_Coordinates_Area_Coordinates_Coordinates_2_Lattitude_MIN(0x00, 0x08)
         , uiArea_Limit_Coordinates_Area_Coordinates_Coordinates_2_Lattitude_SEC(0x00, 0x10)
         , uiArea_Limit_Coordinates_Area_Coordinates_Coordinates_2_Longitude_DEG(0x00, 0x08)
         , uiArea_Limit_Coordinates_Area_Coordinates_Coordinates_2_Longitude_MIN(0x00, 0x08)
         , uiArea_Limit_Coordinates_Area_Coordinates_Coordinates_2_Longitude_SEC(0x00, 0x10)
         , aArea_Limit_Coordinates_Area_Coordinates_Coordinates_2_Reserve(NULL, 0x06)
         , uiArea_Limit_Coordinates_Radius(0x00, 0x10)
         , uiNumber_Of_Time_Slot(0x01, 0x08)
         , uiTime_Slot_Start_Time_Stamp_Year(0x00, 0x10)
         , uiTime_Slot_Start_Time_Stamp_Month(0x00, 0x04)
         , uiTime_Slot_Start_Time_Stamp_Day(0x00, 0x05)
         , uiTime_Slot_Start_Time_Stamp_Hour(0x00, 0x05)
         , uiTime_Slot_Start_Time_Stamp_Minute(0x00, 0x06)
         , uiTime_Slot_Start_Time_Stamp_Second(0x00, 0x06)
         , aTime_Slot_Start_Time_Stamp_Reserve(NULL, 0x06)
         , uiTime_Slot_Stop_Time_Stamp_Year(0x00, 0x10)
         , uiTime_Slot_Stop_Time_Stamp_Month(0x00, 0x04)
         , uiTime_Slot_Stop_Time_Stamp_Day(0x00, 0x05)
         , uiTime_Slot_Stop_Time_Stamp_Hour(0x00, 0x05)
         , uiTime_Slot_Stop_Time_Stamp_Minute(0x00, 0x06)
         , uiTime_Slot_Stop_Time_Stamp_Second(0x00, 0x06)
         , aTime_Slot_Stop_Time_Stamp_Reserve(NULL, 0x06)
         , eTime_Slot_Cycle((tcl_ITM_TCU_e32_Cycle::tenType)0x00, 0x08)
         {};
      ~tclArea_Limit_Restriction() {};
      tcl_ITM_TCU_e32_Restriction_Area_Type eArea_Limit_Coordinates_Restriction_Area_Type;
      tcl_ITM_TCU_e32_Area_Form eArea_Limit_Coordinates_Area_Form;
      tcl_ITM_TCU_e32_Location_Type eArea_Limit_Coordinates_LocationType;
      tcl_ITM_TCU_e32_North_South eArea_Limit_Coordinates_Area_Coordinates_Coordinates_1_Lattitude_Mode;
      tcl_ITM_TCU_e32_East_West eArea_Limit_Coordinates_Area_Coordinates_Coordinates_1_Longitude_Mode;
      tcl_MCAN_GenericType_UnsignedInteger uiArea_Limit_Coordinates_Area_Coordinates_Coordinates_1_Lattitude_DEG;
      tcl_MCAN_GenericType_UnsignedInteger uiArea_Limit_Coordinates_Area_Coordinates_Coordinates_1_Lattitude_MIN;
      tcl_MCAN_GenericType_UnsignedInteger uiArea_Limit_Coordinates_Area_Coordinates_Coordinates_1_Lattitude_SEC;
      tcl_MCAN_GenericType_UnsignedInteger uiArea_Limit_Coordinates_Area_Coordinates_Coordinates_1_Longitude_DEG;
      tcl_MCAN_GenericType_UnsignedInteger uiArea_Limit_Coordinates_Area_Coordinates_Coordinates_1_Longitude_MIN;
      tcl_MCAN_GenericType_UnsignedInteger uiArea_Limit_Coordinates_Area_Coordinates_Coordinates_1_Longitude_SEC;
      tcl_MCAN_GenericType_StreamData aArea_Limit_Coordinates_Area_Coordinates_Coordinates_1_Reserve;
      tcl_ITM_TCU_e32_North_South eArea_Limit_Coordinates_Area_Coordinates_Coordinates_2_Lattitude_Mode;
      tcl_ITM_TCU_e32_East_West eArea_Limit_Coordinates_Area_Coordinates_Coordinates_2_Longitude_Mode;
      tcl_MCAN_GenericType_UnsignedInteger uiArea_Limit_Coordinates_Area_Coordinates_Coordinates_2_Lattitude_DEG;
      tcl_MCAN_GenericType_UnsignedInteger uiArea_Limit_Coordinates_Area_Coordinates_Coordinates_2_Lattitude_MIN;
      tcl_MCAN_GenericType_UnsignedInteger uiArea_Limit_Coordinates_Area_Coordinates_Coordinates_2_Lattitude_SEC;
      tcl_MCAN_GenericType_UnsignedInteger uiArea_Limit_Coordinates_Area_Coordinates_Coordinates_2_Longitude_DEG;
      tcl_MCAN_GenericType_UnsignedInteger uiArea_Limit_Coordinates_Area_Coordinates_Coordinates_2_Longitude_MIN;
      tcl_MCAN_GenericType_UnsignedInteger uiArea_Limit_Coordinates_Area_Coordinates_Coordinates_2_Longitude_SEC;
      tcl_MCAN_GenericType_StreamData aArea_Limit_Coordinates_Area_Coordinates_Coordinates_2_Reserve;
      tcl_MCAN_GenericType_UnsignedInteger uiArea_Limit_Coordinates_Radius;
      tcl_MCAN_GenericType_UnsignedInteger uiNumber_Of_Time_Slot;
      tcl_MCAN_GenericType_UnsignedInteger uiTime_Slot_Start_Time_Stamp_Year;
      tcl_MCAN_GenericType_UnsignedInteger uiTime_Slot_Start_Time_Stamp_Month;
      tcl_MCAN_GenericType_UnsignedInteger uiTime_Slot_Start_Time_Stamp_Day;
      tcl_MCAN_GenericType_UnsignedInteger uiTime_Slot_Start_Time_Stamp_Hour;
      tcl_MCAN_GenericType_UnsignedInteger uiTime_Slot_Start_Time_Stamp_Minute;
      tcl_MCAN_GenericType_UnsignedInteger uiTime_Slot_Start_Time_Stamp_Second;
      tcl_MCAN_GenericType_StreamData aTime_Slot_Start_Time_Stamp_Reserve;
      tcl_MCAN_GenericType_UnsignedInteger uiTime_Slot_Stop_Time_Stamp_Year;
      tcl_MCAN_GenericType_UnsignedInteger uiTime_Slot_Stop_Time_Stamp_Month;
      tcl_MCAN_GenericType_UnsignedInteger uiTime_Slot_Stop_Time_Stamp_Day;
      tcl_MCAN_GenericType_UnsignedInteger uiTime_Slot_Stop_Time_Stamp_Hour;
      tcl_MCAN_GenericType_UnsignedInteger uiTime_Slot_Stop_Time_Stamp_Minute;
      tcl_MCAN_GenericType_UnsignedInteger uiTime_Slot_Stop_Time_Stamp_Second;
      tcl_MCAN_GenericType_StreamData aTime_Slot_Stop_Time_Stamp_Reserve;
      tcl_ITM_TCU_e32_Cycle eTime_Slot_Cycle;
   };
   ::std::vector < tclArea_Limit_Restriction >  vecArea_Limit_Restriction;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Area_Limit_Restriction const& lhs, tcl_ITM_TCU_Area_Limit_Restriction const& rhs);
tBool operator!=(tcl_ITM_TCU_Area_Limit_Restriction const& lhs, tcl_ITM_TCU_Area_Limit_Restriction const& rhs);

class tcl_ITM_TCU_Connection_Type
{
public:
   tcl_ITM_TCU_Connection_Type();
   
   tcl_ITM_TCU_e32_Connection_Type eConnection_Type;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Connection_Type const& lhs, tcl_ITM_TCU_Connection_Type const& rhs);
tBool operator!=(tcl_ITM_TCU_Connection_Type const& lhs, tcl_ITM_TCU_Connection_Type const& rhs);

class tcl_ITM_TCU_XCALL_Type
{
public:
   tcl_ITM_TCU_XCALL_Type();
   
   tcl_ITM_TCU_e32_XCALL_Type eXCALL_Type;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_XCALL_Type const& lhs, tcl_ITM_TCU_XCALL_Type const& rhs);
tBool operator!=(tcl_ITM_TCU_XCALL_Type const& lhs, tcl_ITM_TCU_XCALL_Type const& rhs);

class tcl_ITM_TCU_XCALL_Language
{
public:
   tcl_ITM_TCU_XCALL_Language();
   
   tcl_ITM_TCU_e32_XCALL_Language eXCALL_Language;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_XCALL_Language const& lhs, tcl_ITM_TCU_XCALL_Language const& rhs);
tBool operator!=(tcl_ITM_TCU_XCALL_Language const& lhs, tcl_ITM_TCU_XCALL_Language const& rhs);

class tcl_ITM_TCU_Privacy_Mode_State
{
public:
   tcl_ITM_TCU_Privacy_Mode_State();
   
   tcl_ITM_TCU_e32_Privacy_Manager_State ePrivacy_Mode_State;
  
   tBool bExtractInMsg(tclMcanMsgData* poMcanMsg);
   tVoid vExtractInMsg(tclMcanMsgData* poMcanMsg) { (tVoid) bExtractInMsg(poMcanMsg); }
   tVoid vFillOutMsg(tclMcanMsgData* poMcanMsg);

};
tBool operator==(tcl_ITM_TCU_Privacy_Mode_State const& lhs, tcl_ITM_TCU_Privacy_Mode_State const& rhs);
tBool operator!=(tcl_ITM_TCU_Privacy_Mode_State const& lhs, tcl_ITM_TCU_Privacy_Mode_State const& rhs);



