/*!
  *  \file mcanParameter.cpp
  *  \brief generated file containing enumeration info for MCAN communication.
  *         generated at  : --.--.2016
  *         generated with: python .\genericCodeGen.py -i .\tmpl\mcanParameter.cpp.tpl -b .\CanSimu2\config\mcan -o .\enumTest\mcanParameter.cpp
*/

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FD_CSM_MCAN
#include "trcGenProj/Header/mcanParameterTcu.cpp.trc.h"
#endif

#include "mcanParameterTcu.h"


tcl_ITM_TCU_Unit_ID::tcl_ITM_TCU_Unit_ID() : 
   eUnit_ID((tcl_ITM_TCU_e32_Unit_ID_2::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_TCU_Unit_ID::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eUnit_ID.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Unit_ID::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eUnit_ID.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Unit_ID const& lhs, tcl_ITM_TCU_Unit_ID const& rhs){
   if (lhs.eUnit_ID != rhs.eUnit_ID) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Unit_ID const& lhs, tcl_ITM_TCU_Unit_ID const& rhs){
    if (
         (lhs.eUnit_ID == rhs.eUnit_ID)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Msg_Version::tcl_ITM_TCU_Msg_Version() : 
   uiVersion_Upper_(0x00, 0x08),
   uiVersion_Middle_(0x00, 0x08),
   uiVersion_Lower_(0x00, 0x08)
{
}

tBool tcl_ITM_TCU_Msg_Version::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiVersion_Upper_.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiVersion_Middle_.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiVersion_Lower_.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Msg_Version::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiVersion_Upper_.bUpdateMcanMessage(poMcanMsg);
   uiVersion_Middle_.bUpdateMcanMessage(poMcanMsg);
   uiVersion_Lower_.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Msg_Version const& lhs, tcl_ITM_TCU_Msg_Version const& rhs){
   if (lhs.uiVersion_Upper_ != rhs.uiVersion_Upper_) return FALSE;
   if (lhs.uiVersion_Middle_ != rhs.uiVersion_Middle_) return FALSE;
   if (lhs.uiVersion_Lower_ != rhs.uiVersion_Lower_) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Msg_Version const& lhs, tcl_ITM_TCU_Msg_Version const& rhs){
    if (
         (lhs.uiVersion_Upper_ == rhs.uiVersion_Upper_)
      && (lhs.uiVersion_Middle_ == rhs.uiVersion_Middle_)
      && (lhs.uiVersion_Lower_ == rhs.uiVersion_Lower_)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Invalid_Parameter::tcl_ITM_TCU_Invalid_Parameter() : 
   eInvalid_Parameter((tcl_ITM_TCU_e32_Invalid_Parameter::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_TCU_Invalid_Parameter::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eInvalid_Parameter.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Invalid_Parameter::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eInvalid_Parameter.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Invalid_Parameter const& lhs, tcl_ITM_TCU_Invalid_Parameter const& rhs){
   if (lhs.eInvalid_Parameter != rhs.eInvalid_Parameter) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Invalid_Parameter const& lhs, tcl_ITM_TCU_Invalid_Parameter const& rhs){
    if (
         (lhs.eInvalid_Parameter == rhs.eInvalid_Parameter)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Service_State::tcl_ITM_TCU_Service_State() : 
   eService_State((tcl_ITM_TCU_e32_Service_State::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_TCU_Service_State::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eService_State.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Service_State::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eService_State.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Service_State const& lhs, tcl_ITM_TCU_Service_State const& rhs){
   if (lhs.eService_State != rhs.eService_State) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Service_State const& lhs, tcl_ITM_TCU_Service_State const& rhs){
    if (
         (lhs.eService_State == rhs.eService_State)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Location_Info::tcl_ITM_TCU_Location_Info() : 
   eLocation_Type((tcl_ITM_TCU_e32_Datum::tenType)0x00, 0x01),
   eLattitude_Mode((tcl_ITM_TCU_e32_North_South::tenType)0x00, 0x01),
   eLongitude_Mode((tcl_ITM_TCU_e32_East_West::tenType)0x00, 0x01),
   uiLattitude_DEG(0x00, 0x08),
   uiLattitude_MIN(0x00, 0x08),
   uiLattitude_SEC(0x00, 0x10),
   uiLongitude_DEG(0x00, 0x08),
   uiLongitude_MIN(0x00, 0x08),
   uiLongitude_SEC(0x00, 0x10),
   eAltitude_Sign((tcl_ITM_TCU_e32_Sign::tenType)0x00, 0x01),
   uiAltitude_Value(0x00, 0x10),
   uiSatellite_Number(0x00, 0x08),
   eHome((tcl_ITM_TCU_e32_Registered_Point::tenType)0x00, 0x01),
   aReserve(NULL, 0x03)
{
}

tBool tcl_ITM_TCU_Location_Info::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eLocation_Type.bUpdateData(poMcanMsg);
   if (bRet) bRet = eLattitude_Mode.bUpdateData(poMcanMsg);
   if (bRet) bRet = eLongitude_Mode.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiLattitude_DEG.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiLattitude_MIN.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiLattitude_SEC.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiLongitude_DEG.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiLongitude_MIN.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiLongitude_SEC.bUpdateData(poMcanMsg);
   if (bRet) bRet = eAltitude_Sign.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiAltitude_Value.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiSatellite_Number.bUpdateData(poMcanMsg);
   if (bRet) bRet = eHome.bUpdateData(poMcanMsg);
   if (bRet) bRet = aReserve.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Location_Info::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eLocation_Type.bUpdateMcanMessage(poMcanMsg);
   eLattitude_Mode.bUpdateMcanMessage(poMcanMsg);
   eLongitude_Mode.bUpdateMcanMessage(poMcanMsg);
   uiLattitude_DEG.bUpdateMcanMessage(poMcanMsg);
   uiLattitude_MIN.bUpdateMcanMessage(poMcanMsg);
   uiLattitude_SEC.bUpdateMcanMessage(poMcanMsg);
   uiLongitude_DEG.bUpdateMcanMessage(poMcanMsg);
   uiLongitude_MIN.bUpdateMcanMessage(poMcanMsg);
   uiLongitude_SEC.bUpdateMcanMessage(poMcanMsg);
   eAltitude_Sign.bUpdateMcanMessage(poMcanMsg);
   uiAltitude_Value.bUpdateMcanMessage(poMcanMsg);
   uiSatellite_Number.bUpdateMcanMessage(poMcanMsg);
   eHome.bUpdateMcanMessage(poMcanMsg);
   aReserve.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Location_Info const& lhs, tcl_ITM_TCU_Location_Info const& rhs){
   if (lhs.eLocation_Type != rhs.eLocation_Type) return FALSE;
   if (lhs.eLattitude_Mode != rhs.eLattitude_Mode) return FALSE;
   if (lhs.eLongitude_Mode != rhs.eLongitude_Mode) return FALSE;
   if (lhs.uiLattitude_DEG != rhs.uiLattitude_DEG) return FALSE;
   if (lhs.uiLattitude_MIN != rhs.uiLattitude_MIN) return FALSE;
   if (lhs.uiLattitude_SEC != rhs.uiLattitude_SEC) return FALSE;
   if (lhs.uiLongitude_DEG != rhs.uiLongitude_DEG) return FALSE;
   if (lhs.uiLongitude_MIN != rhs.uiLongitude_MIN) return FALSE;
   if (lhs.uiLongitude_SEC != rhs.uiLongitude_SEC) return FALSE;
   if (lhs.eAltitude_Sign != rhs.eAltitude_Sign) return FALSE;
   if (lhs.uiAltitude_Value != rhs.uiAltitude_Value) return FALSE;
   if (lhs.uiSatellite_Number != rhs.uiSatellite_Number) return FALSE;
   if (lhs.eHome != rhs.eHome) return FALSE;
   if (lhs.aReserve != rhs.aReserve) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Location_Info const& lhs, tcl_ITM_TCU_Location_Info const& rhs){
    if (
         (lhs.eLocation_Type == rhs.eLocation_Type)
      && (lhs.eLattitude_Mode == rhs.eLattitude_Mode)
      && (lhs.eLongitude_Mode == rhs.eLongitude_Mode)
      && (lhs.uiLattitude_DEG == rhs.uiLattitude_DEG)
      && (lhs.uiLattitude_MIN == rhs.uiLattitude_MIN)
      && (lhs.uiLattitude_SEC == rhs.uiLattitude_SEC)
      && (lhs.uiLongitude_DEG == rhs.uiLongitude_DEG)
      && (lhs.uiLongitude_MIN == rhs.uiLongitude_MIN)
      && (lhs.uiLongitude_SEC == rhs.uiLongitude_SEC)
      && (lhs.eAltitude_Sign == rhs.eAltitude_Sign)
      && (lhs.uiAltitude_Value == rhs.uiAltitude_Value)
      && (lhs.uiSatellite_Number == rhs.uiSatellite_Number)
      && (lhs.eHome == rhs.eHome)
      && (lhs.aReserve == rhs.aReserve)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Date_Time::tcl_ITM_TCU_Date_Time() : 
   uiYear(0x00, 0x10),
   uiMonth(0x00, 0x04),
   uiDay(0x00, 0x05),
   uiHour(0x00, 0x05),
   uiMinute(0x00, 0x06),
   uiSecond(0x00, 0x06),
   aReserve(NULL, 0x06)
{
}

tBool tcl_ITM_TCU_Date_Time::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiYear.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiMonth.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiDay.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiHour.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiMinute.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiSecond.bUpdateData(poMcanMsg);
   if (bRet) bRet = aReserve.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Date_Time::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiYear.bUpdateMcanMessage(poMcanMsg);
   uiMonth.bUpdateMcanMessage(poMcanMsg);
   uiDay.bUpdateMcanMessage(poMcanMsg);
   uiHour.bUpdateMcanMessage(poMcanMsg);
   uiMinute.bUpdateMcanMessage(poMcanMsg);
   uiSecond.bUpdateMcanMessage(poMcanMsg);
   aReserve.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Date_Time const& lhs, tcl_ITM_TCU_Date_Time const& rhs){
   if (lhs.uiYear != rhs.uiYear) return FALSE;
   if (lhs.uiMonth != rhs.uiMonth) return FALSE;
   if (lhs.uiDay != rhs.uiDay) return FALSE;
   if (lhs.uiHour != rhs.uiHour) return FALSE;
   if (lhs.uiMinute != rhs.uiMinute) return FALSE;
   if (lhs.uiSecond != rhs.uiSecond) return FALSE;
   if (lhs.aReserve != rhs.aReserve) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Date_Time const& lhs, tcl_ITM_TCU_Date_Time const& rhs){
    if (
         (lhs.uiYear == rhs.uiYear)
      && (lhs.uiMonth == rhs.uiMonth)
      && (lhs.uiDay == rhs.uiDay)
      && (lhs.uiHour == rhs.uiHour)
      && (lhs.uiMinute == rhs.uiMinute)
      && (lhs.uiSecond == rhs.uiSecond)
      && (lhs.aReserve == rhs.aReserve)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Version::tcl_ITM_TCU_Version() : 
   uiVersion_Upper_(0x00, 0x08),
   uiVersion_Middle_(0x00, 0x08),
   uiVersion_Lower_(0x00, 0x08)
{
}

tBool tcl_ITM_TCU_Version::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiVersion_Upper_.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiVersion_Middle_.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiVersion_Lower_.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Version::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiVersion_Upper_.bUpdateMcanMessage(poMcanMsg);
   uiVersion_Middle_.bUpdateMcanMessage(poMcanMsg);
   uiVersion_Lower_.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Version const& lhs, tcl_ITM_TCU_Version const& rhs){
   if (lhs.uiVersion_Upper_ != rhs.uiVersion_Upper_) return FALSE;
   if (lhs.uiVersion_Middle_ != rhs.uiVersion_Middle_) return FALSE;
   if (lhs.uiVersion_Lower_ != rhs.uiVersion_Lower_) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Version const& lhs, tcl_ITM_TCU_Version const& rhs){
    if (
         (lhs.uiVersion_Upper_ == rhs.uiVersion_Upper_)
      && (lhs.uiVersion_Middle_ == rhs.uiVersion_Middle_)
      && (lhs.uiVersion_Lower_ == rhs.uiVersion_Lower_)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Provision_Service_List::tcl_ITM_TCU_Provision_Service_List() : 
   eOperator_Service((tcl_ITM_TCU_e32_Available_Disable::tenType)0x00, 0x01),
   eConnected_Search((tcl_ITM_TCU_e32_Available_Disable::tenType)0x00, 0x01),
   eMobile_Information((tcl_ITM_TCU_e32_Available_Disable::tenType)0x00, 0x01),
   aReserve_Nissan(NULL, 0x09),
   eInternet_Widget((tcl_ITM_TCU_e32_Available_Disable::tenType)0x00, 0x01),
   eFuel_Price((tcl_ITM_TCU_e32_Available_Disable::tenType)0x00, 0x01),
   eLocal_Search((tcl_ITM_TCU_e32_Available_Disable::tenType)0x00, 0x01),
   eWeb_Pre_Trip((tcl_ITM_TCU_e32_Available_Disable::tenType)0x00, 0x01),
   eHD_Traffic((tcl_ITM_TCU_e32_Available_Disable::tenType)0x00, 0x01),
   eSpeed_Trap((tcl_ITM_TCU_e32_Available_Disable::tenType)0x00, 0x01),
   ePrevent_NAV((tcl_ITM_TCU_e32_Available_Disable::tenType)0x00, 0x01),
   eWeather((tcl_ITM_TCU_e32_Available_Disable::tenType)0x00, 0x01),
   eLive_Services((tcl_ITM_TCU_e32_Available_Disable::tenType)0x00, 0x01),
   eCharging_Spot_Finder((tcl_ITM_TCU_e32_Available_Disable::tenType)0x00, 0x01),
   eCharging_Scheduler((tcl_ITM_TCU_e32_Available_Disable::tenType)0x00, 0x01),
   aReserve_Renault(NULL, 0x09)
{
}

tBool tcl_ITM_TCU_Provision_Service_List::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eOperator_Service.bUpdateData(poMcanMsg);
   if (bRet) bRet = eConnected_Search.bUpdateData(poMcanMsg);
   if (bRet) bRet = eMobile_Information.bUpdateData(poMcanMsg);
   if (bRet) bRet = aReserve_Nissan.bUpdateData(poMcanMsg);
   if (bRet) bRet = eInternet_Widget.bUpdateData(poMcanMsg);
   if (bRet) bRet = eFuel_Price.bUpdateData(poMcanMsg);
   if (bRet) bRet = eLocal_Search.bUpdateData(poMcanMsg);
   if (bRet) bRet = eWeb_Pre_Trip.bUpdateData(poMcanMsg);
   if (bRet) bRet = eHD_Traffic.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpeed_Trap.bUpdateData(poMcanMsg);
   if (bRet) bRet = ePrevent_NAV.bUpdateData(poMcanMsg);
   if (bRet) bRet = eWeather.bUpdateData(poMcanMsg);
   if (bRet) bRet = eLive_Services.bUpdateData(poMcanMsg);
   if (bRet) bRet = eCharging_Spot_Finder.bUpdateData(poMcanMsg);
   if (bRet) bRet = eCharging_Scheduler.bUpdateData(poMcanMsg);
   if (bRet) bRet = aReserve_Renault.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Provision_Service_List::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eOperator_Service.bUpdateMcanMessage(poMcanMsg);
   eConnected_Search.bUpdateMcanMessage(poMcanMsg);
   eMobile_Information.bUpdateMcanMessage(poMcanMsg);
   aReserve_Nissan.bUpdateMcanMessage(poMcanMsg);
   eInternet_Widget.bUpdateMcanMessage(poMcanMsg);
   eFuel_Price.bUpdateMcanMessage(poMcanMsg);
   eLocal_Search.bUpdateMcanMessage(poMcanMsg);
   eWeb_Pre_Trip.bUpdateMcanMessage(poMcanMsg);
   eHD_Traffic.bUpdateMcanMessage(poMcanMsg);
   eSpeed_Trap.bUpdateMcanMessage(poMcanMsg);
   ePrevent_NAV.bUpdateMcanMessage(poMcanMsg);
   eWeather.bUpdateMcanMessage(poMcanMsg);
   eLive_Services.bUpdateMcanMessage(poMcanMsg);
   eCharging_Spot_Finder.bUpdateMcanMessage(poMcanMsg);
   eCharging_Scheduler.bUpdateMcanMessage(poMcanMsg);
   aReserve_Renault.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Provision_Service_List const& lhs, tcl_ITM_TCU_Provision_Service_List const& rhs){
   if (lhs.eOperator_Service != rhs.eOperator_Service) return FALSE;
   if (lhs.eConnected_Search != rhs.eConnected_Search) return FALSE;
   if (lhs.eMobile_Information != rhs.eMobile_Information) return FALSE;
   if (lhs.aReserve_Nissan != rhs.aReserve_Nissan) return FALSE;
   if (lhs.eInternet_Widget != rhs.eInternet_Widget) return FALSE;
   if (lhs.eFuel_Price != rhs.eFuel_Price) return FALSE;
   if (lhs.eLocal_Search != rhs.eLocal_Search) return FALSE;
   if (lhs.eWeb_Pre_Trip != rhs.eWeb_Pre_Trip) return FALSE;
   if (lhs.eHD_Traffic != rhs.eHD_Traffic) return FALSE;
   if (lhs.eSpeed_Trap != rhs.eSpeed_Trap) return FALSE;
   if (lhs.ePrevent_NAV != rhs.ePrevent_NAV) return FALSE;
   if (lhs.eWeather != rhs.eWeather) return FALSE;
   if (lhs.eLive_Services != rhs.eLive_Services) return FALSE;
   if (lhs.eCharging_Spot_Finder != rhs.eCharging_Spot_Finder) return FALSE;
   if (lhs.eCharging_Scheduler != rhs.eCharging_Scheduler) return FALSE;
   if (lhs.aReserve_Renault != rhs.aReserve_Renault) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Provision_Service_List const& lhs, tcl_ITM_TCU_Provision_Service_List const& rhs){
    if (
         (lhs.eOperator_Service == rhs.eOperator_Service)
      && (lhs.eConnected_Search == rhs.eConnected_Search)
      && (lhs.eMobile_Information == rhs.eMobile_Information)
      && (lhs.aReserve_Nissan == rhs.aReserve_Nissan)
      && (lhs.eInternet_Widget == rhs.eInternet_Widget)
      && (lhs.eFuel_Price == rhs.eFuel_Price)
      && (lhs.eLocal_Search == rhs.eLocal_Search)
      && (lhs.eWeb_Pre_Trip == rhs.eWeb_Pre_Trip)
      && (lhs.eHD_Traffic == rhs.eHD_Traffic)
      && (lhs.eSpeed_Trap == rhs.eSpeed_Trap)
      && (lhs.ePrevent_NAV == rhs.ePrevent_NAV)
      && (lhs.eWeather == rhs.eWeather)
      && (lhs.eLive_Services == rhs.eLive_Services)
      && (lhs.eCharging_Spot_Finder == rhs.eCharging_Spot_Finder)
      && (lhs.eCharging_Scheduler == rhs.eCharging_Scheduler)
      && (lhs.aReserve_Renault == rhs.aReserve_Renault)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_VIN::tcl_ITM_TCU_VIN() : 
   strVIN(NULL, 0x88)
{
}

tBool tcl_ITM_TCU_VIN::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = strVIN.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_VIN::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   strVIN.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_VIN const& lhs, tcl_ITM_TCU_VIN const& rhs){
   if (lhs.strVIN != rhs.strVIN) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_VIN const& lhs, tcl_ITM_TCU_VIN const& rhs){
    if (
         (lhs.strVIN == rhs.strVIN)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Vehicle_Heading::tcl_ITM_TCU_Vehicle_Heading() : 
   uiVehicle_Heading(0x00, 0x10)
{
}

tBool tcl_ITM_TCU_Vehicle_Heading::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiVehicle_Heading.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Vehicle_Heading::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiVehicle_Heading.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Vehicle_Heading const& lhs, tcl_ITM_TCU_Vehicle_Heading const& rhs){
   if (lhs.uiVehicle_Heading != rhs.uiVehicle_Heading) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Vehicle_Heading const& lhs, tcl_ITM_TCU_Vehicle_Heading const& rhs){
    if (
         (lhs.uiVehicle_Heading == rhs.uiVehicle_Heading)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Reminder_Info::tcl_ITM_TCU_Reminder_Info() : 
   ePlugin_Mode((tcl_ITM_TCU_e32_ON_OFF::tenType)0x00, 0x01),
   eStop_Mode((tcl_ITM_TCU_e32_ON_OFF::tenType)0x00, 0x01),
   uiRemain_Time(0x00, 0x0C),
   uiReserve(0x00, 0x02)
{
}

tBool tcl_ITM_TCU_Reminder_Info::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = ePlugin_Mode.bUpdateData(poMcanMsg);
   if (bRet) bRet = eStop_Mode.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiRemain_Time.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiReserve.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Reminder_Info::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   ePlugin_Mode.bUpdateMcanMessage(poMcanMsg);
   eStop_Mode.bUpdateMcanMessage(poMcanMsg);
   uiRemain_Time.bUpdateMcanMessage(poMcanMsg);
   uiReserve.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Reminder_Info const& lhs, tcl_ITM_TCU_Reminder_Info const& rhs){
   if (lhs.ePlugin_Mode != rhs.ePlugin_Mode) return FALSE;
   if (lhs.eStop_Mode != rhs.eStop_Mode) return FALSE;
   if (lhs.uiRemain_Time != rhs.uiRemain_Time) return FALSE;
   if (lhs.uiReserve != rhs.uiReserve) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Reminder_Info const& lhs, tcl_ITM_TCU_Reminder_Info const& rhs){
    if (
         (lhs.ePlugin_Mode == rhs.ePlugin_Mode)
      && (lhs.eStop_Mode == rhs.eStop_Mode)
      && (lhs.uiRemain_Time == rhs.uiRemain_Time)
      && (lhs.uiReserve == rhs.uiReserve)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_NAVI_ID::tcl_ITM_TCU_NAVI_ID() : 
   strNAVI_ID(NULL, 0xA0)
{
}

tBool tcl_ITM_TCU_NAVI_ID::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = strNAVI_ID.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_NAVI_ID::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   strNAVI_ID.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_NAVI_ID const& lhs, tcl_ITM_TCU_NAVI_ID const& rhs){
   if (lhs.strNAVI_ID != rhs.strNAVI_ID) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_NAVI_ID const& lhs, tcl_ITM_TCU_NAVI_ID const& rhs){
    if (
         (lhs.strNAVI_ID == rhs.strNAVI_ID)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_TCU_ID::tcl_ITM_TCU_TCU_ID() : 
   strTCU_ID(NULL, 0xA0)
{
}

tBool tcl_ITM_TCU_TCU_ID::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = strTCU_ID.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_TCU_ID::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   strTCU_ID.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_TCU_ID const& lhs, tcl_ITM_TCU_TCU_ID const& rhs){
   if (lhs.strTCU_ID != rhs.strTCU_ID) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_TCU_ID const& lhs, tcl_ITM_TCU_TCU_ID const& rhs){
    if (
         (lhs.strTCU_ID == rhs.strTCU_ID)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_ICC_ID::tcl_ITM_TCU_ICC_ID() : 
   strICC_ID(NULL, 0xA0)
{
}

tBool tcl_ITM_TCU_ICC_ID::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = strICC_ID.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_ICC_ID::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   strICC_ID.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_ICC_ID const& lhs, tcl_ITM_TCU_ICC_ID const& rhs){
   if (lhs.strICC_ID != rhs.strICC_ID) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_ICC_ID const& lhs, tcl_ITM_TCU_ICC_ID const& rhs){
    if (
         (lhs.strICC_ID == rhs.strICC_ID)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_PIN::tcl_ITM_TCU_PIN() : 
   uiPIN_ID_Length(0x01, 0x08),
   vstrPIN_ID_Text(NULL, 0),
   uiPIN_Password_Length(0x01, 0x08),
   vstrPIN_Password_Text(NULL, 0)
{
}

tBool tcl_ITM_TCU_PIN::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiPIN_ID_Length.bUpdateData(poMcanMsg);

   if (bRet) bRet = vstrPIN_ID_Text.bUpdateLength(8*uiPIN_ID_Length.u32GetData());
   if (bRet) bRet = vstrPIN_ID_Text.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiPIN_Password_Length.bUpdateData(poMcanMsg);

   if (bRet) bRet = vstrPIN_Password_Text.bUpdateLength(8*uiPIN_Password_Length.u32GetData());
   if (bRet) bRet = vstrPIN_Password_Text.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_PIN::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiPIN_ID_Length.bUpdateMcanMessage(poMcanMsg);
   vstrPIN_ID_Text.bUpdateMcanMessage(poMcanMsg);
   uiPIN_Password_Length.bUpdateMcanMessage(poMcanMsg);
   vstrPIN_Password_Text.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_PIN const& lhs, tcl_ITM_TCU_PIN const& rhs){
   if (lhs.uiPIN_ID_Length != rhs.uiPIN_ID_Length) return FALSE;
   if (lhs.vstrPIN_ID_Text != rhs.vstrPIN_ID_Text) return FALSE;
   if (lhs.uiPIN_Password_Length != rhs.uiPIN_Password_Length) return FALSE;
   if (lhs.vstrPIN_Password_Text != rhs.vstrPIN_Password_Text) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_PIN const& lhs, tcl_ITM_TCU_PIN const& rhs){
    if (
         (lhs.uiPIN_ID_Length == rhs.uiPIN_ID_Length)
      && (lhs.vstrPIN_ID_Text == rhs.vstrPIN_ID_Text)
      && (lhs.uiPIN_Password_Length == rhs.uiPIN_Password_Length)
      && (lhs.vstrPIN_Password_Text == rhs.vstrPIN_Password_Text)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Distance_Unit::tcl_ITM_TCU_Distance_Unit() : 
   eDistance_Unit((tcl_ITM_TCU_e32_Distance_Unit::tenType)0x01, 0x08)
{
}

tBool tcl_ITM_TCU_Distance_Unit::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eDistance_Unit.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Distance_Unit::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eDistance_Unit.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Distance_Unit const& lhs, tcl_ITM_TCU_Distance_Unit const& rhs){
   if (lhs.eDistance_Unit != rhs.eDistance_Unit) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Distance_Unit const& lhs, tcl_ITM_TCU_Distance_Unit const& rhs){
    if (
         (lhs.eDistance_Unit == rhs.eDistance_Unit)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Distance_Value::tcl_ITM_TCU_Distance_Value() : 
   uiOil_Filter(0x00, 0x10),
   uiOil(0x00, 0x10),
   uiTire(0x00, 0x10),
   uiUser(0x00, 0x10),
   uiBattery(0x00, 0x10),
   uiAir_Conditioner_Filter(0x00, 0x10),
   aReserve(NULL, 0x10)
{
}

tBool tcl_ITM_TCU_Distance_Value::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiOil_Filter.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiOil.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiTire.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiUser.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiBattery.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiAir_Conditioner_Filter.bUpdateData(poMcanMsg);
   if (bRet) bRet = aReserve.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Distance_Value::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiOil_Filter.bUpdateMcanMessage(poMcanMsg);
   uiOil.bUpdateMcanMessage(poMcanMsg);
   uiTire.bUpdateMcanMessage(poMcanMsg);
   uiUser.bUpdateMcanMessage(poMcanMsg);
   uiBattery.bUpdateMcanMessage(poMcanMsg);
   uiAir_Conditioner_Filter.bUpdateMcanMessage(poMcanMsg);
   aReserve.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Distance_Value const& lhs, tcl_ITM_TCU_Distance_Value const& rhs){
   if (lhs.uiOil_Filter != rhs.uiOil_Filter) return FALSE;
   if (lhs.uiOil != rhs.uiOil) return FALSE;
   if (lhs.uiTire != rhs.uiTire) return FALSE;
   if (lhs.uiUser != rhs.uiUser) return FALSE;
   if (lhs.uiBattery != rhs.uiBattery) return FALSE;
   if (lhs.uiAir_Conditioner_Filter != rhs.uiAir_Conditioner_Filter) return FALSE;
   if (lhs.aReserve != rhs.aReserve) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Distance_Value const& lhs, tcl_ITM_TCU_Distance_Value const& rhs){
    if (
         (lhs.uiOil_Filter == rhs.uiOil_Filter)
      && (lhs.uiOil == rhs.uiOil)
      && (lhs.uiTire == rhs.uiTire)
      && (lhs.uiUser == rhs.uiUser)
      && (lhs.uiBattery == rhs.uiBattery)
      && (lhs.uiAir_Conditioner_Filter == rhs.uiAir_Conditioner_Filter)
      && (lhs.aReserve == rhs.aReserve)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Score_Info::tcl_ITM_TCU_Score_Info() : 
   uiECO_Score(0x00, 0x08),
   uiStart_Score(0x00, 0x08),
   uiCruise_Score(0x00, 0x08),
   uiSlowdown_Score(0x00, 0x08)
{
}

tBool tcl_ITM_TCU_Score_Info::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiECO_Score.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiStart_Score.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiCruise_Score.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiSlowdown_Score.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Score_Info::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiECO_Score.bUpdateMcanMessage(poMcanMsg);
   uiStart_Score.bUpdateMcanMessage(poMcanMsg);
   uiCruise_Score.bUpdateMcanMessage(poMcanMsg);
   uiSlowdown_Score.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Score_Info const& lhs, tcl_ITM_TCU_Score_Info const& rhs){
   if (lhs.uiECO_Score != rhs.uiECO_Score) return FALSE;
   if (lhs.uiStart_Score != rhs.uiStart_Score) return FALSE;
   if (lhs.uiCruise_Score != rhs.uiCruise_Score) return FALSE;
   if (lhs.uiSlowdown_Score != rhs.uiSlowdown_Score) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Score_Info const& lhs, tcl_ITM_TCU_Score_Info const& rhs){
    if (
         (lhs.uiECO_Score == rhs.uiECO_Score)
      && (lhs.uiStart_Score == rhs.uiStart_Score)
      && (lhs.uiCruise_Score == rhs.uiCruise_Score)
      && (lhs.uiSlowdown_Score == rhs.uiSlowdown_Score)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Map_Version::tcl_ITM_TCU_Map_Version() : 
   strMap_Version(NULL, 0x0200)
{
}

tBool tcl_ITM_TCU_Map_Version::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = strMap_Version.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Map_Version::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   strMap_Version.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Map_Version const& lhs, tcl_ITM_TCU_Map_Version const& rhs){
   if (lhs.strMap_Version != rhs.strMap_Version) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Map_Version const& lhs, tcl_ITM_TCU_Map_Version const& rhs){
    if (
         (lhs.strMap_Version == rhs.strMap_Version)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_PopUp_Flag::tcl_ITM_TCU_PopUp_Flag() : 
   ePopUp_Flag((tcl_ITM_TCU_e32_ON_OFF::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_TCU_PopUp_Flag::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = ePopUp_Flag.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_PopUp_Flag::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   ePopUp_Flag.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_PopUp_Flag const& lhs, tcl_ITM_TCU_PopUp_Flag const& rhs){
   if (lhs.ePopUp_Flag != rhs.ePopUp_Flag) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_PopUp_Flag const& lhs, tcl_ITM_TCU_PopUp_Flag const& rhs){
    if (
         (lhs.ePopUp_Flag == rhs.ePopUp_Flag)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Information_Channel::tcl_ITM_TCU_Information_Channel() : 
   uiInformation_Channel(0x00, 0x10)
{
}

tBool tcl_ITM_TCU_Information_Channel::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiInformation_Channel.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Information_Channel::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiInformation_Channel.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Information_Channel const& lhs, tcl_ITM_TCU_Information_Channel const& rhs){
   if (lhs.uiInformation_Channel != rhs.uiInformation_Channel) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Information_Channel const& lhs, tcl_ITM_TCU_Information_Channel const& rhs){
    if (
         (lhs.uiInformation_Channel == rhs.uiInformation_Channel)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Time_Zone::tcl_ITM_TCU_Time_Zone() : 
   uiTime_Zone(0x00, 0x08)
{
}

tBool tcl_ITM_TCU_Time_Zone::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiTime_Zone.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Time_Zone::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiTime_Zone.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Time_Zone const& lhs, tcl_ITM_TCU_Time_Zone const& rhs){
   if (lhs.uiTime_Zone != rhs.uiTime_Zone) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Time_Zone const& lhs, tcl_ITM_TCU_Time_Zone const& rhs){
    if (
         (lhs.uiTime_Zone == rhs.uiTime_Zone)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Permit_Setting::tcl_ITM_TCU_Permit_Setting() : 
   ePermit_Setting((tcl_ITM_TCU_e32_ON_OFF::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_TCU_Permit_Setting::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = ePermit_Setting.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Permit_Setting::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   ePermit_Setting.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Permit_Setting const& lhs, tcl_ITM_TCU_Permit_Setting const& rhs){
   if (lhs.ePermit_Setting != rhs.ePermit_Setting) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Permit_Setting const& lhs, tcl_ITM_TCU_Permit_Setting const& rhs){
    if (
         (lhs.ePermit_Setting == rhs.ePermit_Setting)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Service_Type::tcl_ITM_TCU_Service_Type() : 
   eService_Type((tcl_ITM_TCU_e32_Service_Type::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_TCU_Service_Type::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eService_Type.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Service_Type::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eService_Type.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Service_Type const& lhs, tcl_ITM_TCU_Service_Type const& rhs){
   if (lhs.eService_Type != rhs.eService_Type) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Service_Type const& lhs, tcl_ITM_TCU_Service_Type const& rhs){
    if (
         (lhs.eService_Type == rhs.eService_Type)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Current_Country::tcl_ITM_TCU_Current_Country() : 
   strCurrent_Country(NULL, 0x10)
{
}

tBool tcl_ITM_TCU_Current_Country::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = strCurrent_Country.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Current_Country::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   strCurrent_Country.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Current_Country const& lhs, tcl_ITM_TCU_Current_Country const& rhs){
   if (lhs.strCurrent_Country != rhs.strCurrent_Country) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Current_Country const& lhs, tcl_ITM_TCU_Current_Country const& rhs){
    if (
         (lhs.strCurrent_Country == rhs.strCurrent_Country)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Search_GPS_Position::tcl_ITM_TCU_Search_GPS_Position() : 
   aReserved(NULL, 0x01),
   eLocationType((tcl_ITM_TCU_e32_LocationType::tenType)0x00, 0x01),
   eLattitudeMode((tcl_ITM_TCU_e32_LattitudeMode::tenType)0x00, 0x01),
   eLongitudeMode((tcl_ITM_TCU_e32_LongitudeMode::tenType)0x00, 0x01),
   uiLattitudeDEG(0x00, 0x08),
   uiLattitudeMIN(0x00, 0x06),
   uiLattitudeSEC(0x00, 0x10),
   uiLongitudeDEG(0x00, 0x08),
   uiLongitudeMIN(0x00, 0x06),
   uiLongitudeSEC(0x00, 0x10)
{
}

tBool tcl_ITM_TCU_Search_GPS_Position::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = aReserved.bUpdateData(poMcanMsg);
   if (bRet) bRet = eLocationType.bUpdateData(poMcanMsg);
   if (bRet) bRet = eLattitudeMode.bUpdateData(poMcanMsg);
   if (bRet) bRet = eLongitudeMode.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiLattitudeDEG.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiLattitudeMIN.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiLattitudeSEC.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiLongitudeDEG.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiLongitudeMIN.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiLongitudeSEC.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Search_GPS_Position::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   aReserved.bUpdateMcanMessage(poMcanMsg);
   eLocationType.bUpdateMcanMessage(poMcanMsg);
   eLattitudeMode.bUpdateMcanMessage(poMcanMsg);
   eLongitudeMode.bUpdateMcanMessage(poMcanMsg);
   uiLattitudeDEG.bUpdateMcanMessage(poMcanMsg);
   uiLattitudeMIN.bUpdateMcanMessage(poMcanMsg);
   uiLattitudeSEC.bUpdateMcanMessage(poMcanMsg);
   uiLongitudeDEG.bUpdateMcanMessage(poMcanMsg);
   uiLongitudeMIN.bUpdateMcanMessage(poMcanMsg);
   uiLongitudeSEC.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Search_GPS_Position const& lhs, tcl_ITM_TCU_Search_GPS_Position const& rhs){
   if (lhs.aReserved != rhs.aReserved) return FALSE;
   if (lhs.eLocationType != rhs.eLocationType) return FALSE;
   if (lhs.eLattitudeMode != rhs.eLattitudeMode) return FALSE;
   if (lhs.eLongitudeMode != rhs.eLongitudeMode) return FALSE;
   if (lhs.uiLattitudeDEG != rhs.uiLattitudeDEG) return FALSE;
   if (lhs.uiLattitudeMIN != rhs.uiLattitudeMIN) return FALSE;
   if (lhs.uiLattitudeSEC != rhs.uiLattitudeSEC) return FALSE;
   if (lhs.uiLongitudeDEG != rhs.uiLongitudeDEG) return FALSE;
   if (lhs.uiLongitudeMIN != rhs.uiLongitudeMIN) return FALSE;
   if (lhs.uiLongitudeSEC != rhs.uiLongitudeSEC) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Search_GPS_Position const& lhs, tcl_ITM_TCU_Search_GPS_Position const& rhs){
    if (
         (lhs.aReserved == rhs.aReserved)
      && (lhs.eLocationType == rhs.eLocationType)
      && (lhs.eLattitudeMode == rhs.eLattitudeMode)
      && (lhs.eLongitudeMode == rhs.eLongitudeMode)
      && (lhs.uiLattitudeDEG == rhs.uiLattitudeDEG)
      && (lhs.uiLattitudeMIN == rhs.uiLattitudeMIN)
      && (lhs.uiLattitudeSEC == rhs.uiLattitudeSEC)
      && (lhs.uiLongitudeDEG == rhs.uiLongitudeDEG)
      && (lhs.uiLongitudeMIN == rhs.uiLongitudeMIN)
      && (lhs.uiLongitudeSEC == rhs.uiLongitudeSEC)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_ePOI_Type::tcl_ITM_TCU_ePOI_Type() : 
   eePOI_Type((tcl_ITM_TCU_e32_ePOI_Type::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_TCU_ePOI_Type::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eePOI_Type.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_ePOI_Type::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eePOI_Type.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_ePOI_Type const& lhs, tcl_ITM_TCU_ePOI_Type const& rhs){
   if (lhs.eePOI_Type != rhs.eePOI_Type) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_ePOI_Type const& lhs, tcl_ITM_TCU_ePOI_Type const& rhs){
    if (
         (lhs.eePOI_Type == rhs.eePOI_Type)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Charge_Receptacle_Type::tcl_ITM_TCU_Charge_Receptacle_Type() : 
   eCharge_Receptacle_Type((tcl_ITM_TCU_e32_Charge_Receptacle_Type::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_TCU_Charge_Receptacle_Type::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eCharge_Receptacle_Type.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Charge_Receptacle_Type::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eCharge_Receptacle_Type.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Charge_Receptacle_Type const& lhs, tcl_ITM_TCU_Charge_Receptacle_Type const& rhs){
   if (lhs.eCharge_Receptacle_Type != rhs.eCharge_Receptacle_Type) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Charge_Receptacle_Type const& lhs, tcl_ITM_TCU_Charge_Receptacle_Type const& rhs){
    if (
         (lhs.eCharge_Receptacle_Type == rhs.eCharge_Receptacle_Type)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Spot_Receptacle_Type::tcl_ITM_TCU_Spot_Receptacle_Type() : 
   eDefault_receptacle_type((tcl_ITM_TCU_e32_Charge_Receptacle_Type::tenType)0x00, 0x08),
   eUser_receptacle_type_1((tcl_ITM_TCU_e32_Charge_Receptacle_Type::tenType)0x00, 0x08),
   eUser_receptacle_type_2((tcl_ITM_TCU_e32_Charge_Receptacle_Type::tenType)0x00, 0x08),
   eUser_receptacle_type_3((tcl_ITM_TCU_e32_Charge_Receptacle_Type::tenType)0x00, 0x08),
   uiReserved_1(0x00, 0x08),
   uiReserved_2(0x00, 0x08),
   uiReserved_3(0x00, 0x08),
   uiReserved_4(0x00, 0x08)
{
}

tBool tcl_ITM_TCU_Spot_Receptacle_Type::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eDefault_receptacle_type.bUpdateData(poMcanMsg);
   if (bRet) bRet = eUser_receptacle_type_1.bUpdateData(poMcanMsg);
   if (bRet) bRet = eUser_receptacle_type_2.bUpdateData(poMcanMsg);
   if (bRet) bRet = eUser_receptacle_type_3.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiReserved_1.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiReserved_2.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiReserved_3.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiReserved_4.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Spot_Receptacle_Type::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eDefault_receptacle_type.bUpdateMcanMessage(poMcanMsg);
   eUser_receptacle_type_1.bUpdateMcanMessage(poMcanMsg);
   eUser_receptacle_type_2.bUpdateMcanMessage(poMcanMsg);
   eUser_receptacle_type_3.bUpdateMcanMessage(poMcanMsg);
   uiReserved_1.bUpdateMcanMessage(poMcanMsg);
   uiReserved_2.bUpdateMcanMessage(poMcanMsg);
   uiReserved_3.bUpdateMcanMessage(poMcanMsg);
   uiReserved_4.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Spot_Receptacle_Type const& lhs, tcl_ITM_TCU_Spot_Receptacle_Type const& rhs){
   if (lhs.eDefault_receptacle_type != rhs.eDefault_receptacle_type) return FALSE;
   if (lhs.eUser_receptacle_type_1 != rhs.eUser_receptacle_type_1) return FALSE;
   if (lhs.eUser_receptacle_type_2 != rhs.eUser_receptacle_type_2) return FALSE;
   if (lhs.eUser_receptacle_type_3 != rhs.eUser_receptacle_type_3) return FALSE;
   if (lhs.uiReserved_1 != rhs.uiReserved_1) return FALSE;
   if (lhs.uiReserved_2 != rhs.uiReserved_2) return FALSE;
   if (lhs.uiReserved_3 != rhs.uiReserved_3) return FALSE;
   if (lhs.uiReserved_4 != rhs.uiReserved_4) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Spot_Receptacle_Type const& lhs, tcl_ITM_TCU_Spot_Receptacle_Type const& rhs){
    if (
         (lhs.eDefault_receptacle_type == rhs.eDefault_receptacle_type)
      && (lhs.eUser_receptacle_type_1 == rhs.eUser_receptacle_type_1)
      && (lhs.eUser_receptacle_type_2 == rhs.eUser_receptacle_type_2)
      && (lhs.eUser_receptacle_type_3 == rhs.eUser_receptacle_type_3)
      && (lhs.uiReserved_1 == rhs.uiReserved_1)
      && (lhs.uiReserved_2 == rhs.uiReserved_2)
      && (lhs.uiReserved_3 == rhs.uiReserved_3)
      && (lhs.uiReserved_4 == rhs.uiReserved_4)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Vehicle_Autonomy::tcl_ITM_TCU_Vehicle_Autonomy() : 
   uiVehicle_Autonomy(0x00, 0x10)
{
}

tBool tcl_ITM_TCU_Vehicle_Autonomy::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiVehicle_Autonomy.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Vehicle_Autonomy::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiVehicle_Autonomy.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Vehicle_Autonomy const& lhs, tcl_ITM_TCU_Vehicle_Autonomy const& rhs){
   if (lhs.uiVehicle_Autonomy != rhs.uiVehicle_Autonomy) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Vehicle_Autonomy const& lhs, tcl_ITM_TCU_Vehicle_Autonomy const& rhs){
    if (
         (lhs.uiVehicle_Autonomy == rhs.uiVehicle_Autonomy)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Battery_Identification_Number::tcl_ITM_TCU_Battery_Identification_Number() : 
   uiBattery_Identification_Number(0x00, 0x20)
{
}

tBool tcl_ITM_TCU_Battery_Identification_Number::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiBattery_Identification_Number.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Battery_Identification_Number::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiBattery_Identification_Number.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Battery_Identification_Number const& lhs, tcl_ITM_TCU_Battery_Identification_Number const& rhs){
   if (lhs.uiBattery_Identification_Number != rhs.uiBattery_Identification_Number) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Battery_Identification_Number const& lhs, tcl_ITM_TCU_Battery_Identification_Number const& rhs){
    if (
         (lhs.uiBattery_Identification_Number == rhs.uiBattery_Identification_Number)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Navigation_Language::tcl_ITM_TCU_Navigation_Language() : 
   uiReserved(0x00, 0x02),
   eLanguage_Family_Type((tcl_ITM_TCU_e32_Language_Family_Type::tenType)0x00, 0x02),
   eLanguage_Type((tcl_ITM_TCU_e32_Language_Type::tenType)0x00, 0x04)
{
}

tBool tcl_ITM_TCU_Navigation_Language::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiReserved.bUpdateData(poMcanMsg);
   if (bRet) bRet = eLanguage_Family_Type.bUpdateData(poMcanMsg);
   if (bRet) bRet = eLanguage_Type.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Navigation_Language::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiReserved.bUpdateMcanMessage(poMcanMsg);
   eLanguage_Family_Type.bUpdateMcanMessage(poMcanMsg);
   eLanguage_Type.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Navigation_Language const& lhs, tcl_ITM_TCU_Navigation_Language const& rhs){
   if (lhs.uiReserved != rhs.uiReserved) return FALSE;
   if (lhs.eLanguage_Family_Type != rhs.eLanguage_Family_Type) return FALSE;
   if (lhs.eLanguage_Type != rhs.eLanguage_Type) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Navigation_Language const& lhs, tcl_ITM_TCU_Navigation_Language const& rhs){
    if (
         (lhs.uiReserved == rhs.uiReserved)
      && (lhs.eLanguage_Family_Type == rhs.eLanguage_Family_Type)
      && (lhs.eLanguage_Type == rhs.eLanguage_Type)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Finder_Status::tcl_ITM_TCU_Finder_Status() : 
   eFinder_Status((tcl_ITM_TCU_e32_Finder_Status::tenType)0x01, 0x08)
{
}

tBool tcl_ITM_TCU_Finder_Status::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eFinder_Status.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Finder_Status::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eFinder_Status.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Finder_Status const& lhs, tcl_ITM_TCU_Finder_Status const& rhs){
   if (lhs.eFinder_Status != rhs.eFinder_Status) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Finder_Status const& lhs, tcl_ITM_TCU_Finder_Status const& rhs){
    if (
         (lhs.eFinder_Status == rhs.eFinder_Status)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Total_Station_Number::tcl_ITM_TCU_Total_Station_Number() : 
   uiTotal_Station_Number(0x00, 0x08)
{
}

tBool tcl_ITM_TCU_Total_Station_Number::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiTotal_Station_Number.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Total_Station_Number::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiTotal_Station_Number.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Total_Station_Number const& lhs, tcl_ITM_TCU_Total_Station_Number const& rhs){
   if (lhs.uiTotal_Station_Number != rhs.uiTotal_Station_Number) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Total_Station_Number const& lhs, tcl_ITM_TCU_Total_Station_Number const& rhs){
    if (
         (lhs.uiTotal_Station_Number == rhs.uiTotal_Station_Number)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Station_List_Number::tcl_ITM_TCU_Station_List_Number() : 
   uiStation_List_Number(0x00, 0x08)
{
}

tBool tcl_ITM_TCU_Station_List_Number::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiStation_List_Number.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Station_List_Number::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiStation_List_Number.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Station_List_Number const& lhs, tcl_ITM_TCU_Station_List_Number const& rhs){
   if (lhs.uiStation_List_Number != rhs.uiStation_List_Number) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Station_List_Number const& lhs, tcl_ITM_TCU_Station_List_Number const& rhs){
    if (
         (lhs.uiStation_List_Number == rhs.uiStation_List_Number)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Charge_Station_ID::tcl_ITM_TCU_Charge_Station_ID() : 
   strCharge_Station_ID(NULL, 0x80)
{
}

tBool tcl_ITM_TCU_Charge_Station_ID::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = strCharge_Station_ID.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Charge_Station_ID::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   strCharge_Station_ID.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Charge_Station_ID const& lhs, tcl_ITM_TCU_Charge_Station_ID const& rhs){
   if (lhs.strCharge_Station_ID != rhs.strCharge_Station_ID) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Charge_Station_ID const& lhs, tcl_ITM_TCU_Charge_Station_ID const& rhs){
    if (
         (lhs.strCharge_Station_ID == rhs.strCharge_Station_ID)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_EPOI_GPS_Position::tcl_ITM_TCU_EPOI_GPS_Position() : 
   uiReserved(0x00, 0x01),
   eLocationType((tcl_ITM_TCU_e32_LocationType::tenType)0x01, 0x01),
   eLattitudeMode((tcl_ITM_TCU_e32_LattitudeMode::tenType)0x01, 0x01),
   eLongitudeMode((tcl_ITM_TCU_e32_LongitudeMode::tenType)0x01, 0x01),
   uiLattitudeDEG(0x00, 0x08),
   uiLattitudeMIN(0x00, 0x06),
   uiLattitudeSEC(0x00, 0x10),
   uiLongitudeDEG(0x00, 0x08),
   uiLongitudeMIN(0x00, 0x06),
   uiLongitudeSEC(0x00, 0x10)
{
}

tBool tcl_ITM_TCU_EPOI_GPS_Position::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiReserved.bUpdateData(poMcanMsg);
   if (bRet) bRet = eLocationType.bUpdateData(poMcanMsg);
   if (bRet) bRet = eLattitudeMode.bUpdateData(poMcanMsg);
   if (bRet) bRet = eLongitudeMode.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiLattitudeDEG.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiLattitudeMIN.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiLattitudeSEC.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiLongitudeDEG.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiLongitudeMIN.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiLongitudeSEC.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_EPOI_GPS_Position::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiReserved.bUpdateMcanMessage(poMcanMsg);
   eLocationType.bUpdateMcanMessage(poMcanMsg);
   eLattitudeMode.bUpdateMcanMessage(poMcanMsg);
   eLongitudeMode.bUpdateMcanMessage(poMcanMsg);
   uiLattitudeDEG.bUpdateMcanMessage(poMcanMsg);
   uiLattitudeMIN.bUpdateMcanMessage(poMcanMsg);
   uiLattitudeSEC.bUpdateMcanMessage(poMcanMsg);
   uiLongitudeDEG.bUpdateMcanMessage(poMcanMsg);
   uiLongitudeMIN.bUpdateMcanMessage(poMcanMsg);
   uiLongitudeSEC.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_EPOI_GPS_Position const& lhs, tcl_ITM_TCU_EPOI_GPS_Position const& rhs){
   if (lhs.uiReserved != rhs.uiReserved) return FALSE;
   if (lhs.eLocationType != rhs.eLocationType) return FALSE;
   if (lhs.eLattitudeMode != rhs.eLattitudeMode) return FALSE;
   if (lhs.eLongitudeMode != rhs.eLongitudeMode) return FALSE;
   if (lhs.uiLattitudeDEG != rhs.uiLattitudeDEG) return FALSE;
   if (lhs.uiLattitudeMIN != rhs.uiLattitudeMIN) return FALSE;
   if (lhs.uiLattitudeSEC != rhs.uiLattitudeSEC) return FALSE;
   if (lhs.uiLongitudeDEG != rhs.uiLongitudeDEG) return FALSE;
   if (lhs.uiLongitudeMIN != rhs.uiLongitudeMIN) return FALSE;
   if (lhs.uiLongitudeSEC != rhs.uiLongitudeSEC) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_EPOI_GPS_Position const& lhs, tcl_ITM_TCU_EPOI_GPS_Position const& rhs){
    if (
         (lhs.uiReserved == rhs.uiReserved)
      && (lhs.eLocationType == rhs.eLocationType)
      && (lhs.eLattitudeMode == rhs.eLattitudeMode)
      && (lhs.eLongitudeMode == rhs.eLongitudeMode)
      && (lhs.uiLattitudeDEG == rhs.uiLattitudeDEG)
      && (lhs.uiLattitudeMIN == rhs.uiLattitudeMIN)
      && (lhs.uiLattitudeSEC == rhs.uiLattitudeSEC)
      && (lhs.uiLongitudeDEG == rhs.uiLongitudeDEG)
      && (lhs.uiLongitudeMIN == rhs.uiLongitudeMIN)
      && (lhs.uiLongitudeSEC == rhs.uiLongitudeSEC)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Energy_Provider_Name::tcl_ITM_TCU_Energy_Provider_Name() : 
   strEnergy_Provider_Name(NULL, 0x40)
{
}

tBool tcl_ITM_TCU_Energy_Provider_Name::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = strEnergy_Provider_Name.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Energy_Provider_Name::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   strEnergy_Provider_Name.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Energy_Provider_Name const& lhs, tcl_ITM_TCU_Energy_Provider_Name const& rhs){
   if (lhs.strEnergy_Provider_Name != rhs.strEnergy_Provider_Name) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Energy_Provider_Name const& lhs, tcl_ITM_TCU_Energy_Provider_Name const& rhs){
    if (
         (lhs.strEnergy_Provider_Name == rhs.strEnergy_Provider_Name)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Utility_Aggregator_ID::tcl_ITM_TCU_Utility_Aggregator_ID() : 
   strUtility_Aggregator_ID(NULL, 0x0100)
{
}

tBool tcl_ITM_TCU_Utility_Aggregator_ID::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = strUtility_Aggregator_ID.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Utility_Aggregator_ID::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   strUtility_Aggregator_ID.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Utility_Aggregator_ID const& lhs, tcl_ITM_TCU_Utility_Aggregator_ID const& rhs){
   if (lhs.strUtility_Aggregator_ID != rhs.strUtility_Aggregator_ID) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Utility_Aggregator_ID const& lhs, tcl_ITM_TCU_Utility_Aggregator_ID const& rhs){
    if (
         (lhs.strUtility_Aggregator_ID == rhs.strUtility_Aggregator_ID)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Time_Stamp::tcl_ITM_TCU_Time_Stamp() : 
   uiYear_from_2000_to_2099_(0x00, 0x08),
   uiMonth(0x01, 0x08),
   uiDay(0x01, 0x08),
   uiHour(0x00, 0x08),
   uiMinute(0x00, 0x08),
   uiSecond(0x00, 0x08)
{
}

tBool tcl_ITM_TCU_Time_Stamp::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiYear_from_2000_to_2099_.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiMonth.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiDay.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiHour.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiMinute.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiSecond.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Time_Stamp::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiYear_from_2000_to_2099_.bUpdateMcanMessage(poMcanMsg);
   uiMonth.bUpdateMcanMessage(poMcanMsg);
   uiDay.bUpdateMcanMessage(poMcanMsg);
   uiHour.bUpdateMcanMessage(poMcanMsg);
   uiMinute.bUpdateMcanMessage(poMcanMsg);
   uiSecond.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Time_Stamp const& lhs, tcl_ITM_TCU_Time_Stamp const& rhs){
   if (lhs.uiYear_from_2000_to_2099_ != rhs.uiYear_from_2000_to_2099_) return FALSE;
   if (lhs.uiMonth != rhs.uiMonth) return FALSE;
   if (lhs.uiDay != rhs.uiDay) return FALSE;
   if (lhs.uiHour != rhs.uiHour) return FALSE;
   if (lhs.uiMinute != rhs.uiMinute) return FALSE;
   if (lhs.uiSecond != rhs.uiSecond) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Time_Stamp const& lhs, tcl_ITM_TCU_Time_Stamp const& rhs){
    if (
         (lhs.uiYear_from_2000_to_2099_ == rhs.uiYear_from_2000_to_2099_)
      && (lhs.uiMonth == rhs.uiMonth)
      && (lhs.uiDay == rhs.uiDay)
      && (lhs.uiHour == rhs.uiHour)
      && (lhs.uiMinute == rhs.uiMinute)
      && (lhs.uiSecond == rhs.uiSecond)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Phone_Number::tcl_ITM_TCU_Phone_Number() : 
   strPhone_Number(NULL, 0x60)
{
}

tBool tcl_ITM_TCU_Phone_Number::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = strPhone_Number.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Phone_Number::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   strPhone_Number.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Phone_Number const& lhs, tcl_ITM_TCU_Phone_Number const& rhs){
   if (lhs.strPhone_Number != rhs.strPhone_Number) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Phone_Number const& lhs, tcl_ITM_TCU_Phone_Number const& rhs){
    if (
         (lhs.strPhone_Number == rhs.strPhone_Number)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Opening_Hour::tcl_ITM_TCU_Opening_Hour() : 
   uiSunday_StartTime_1(0x00, 0x08),
   uiSunday_EndTime_1(0x60, 0x08),
   uiSunday_StartTime_2(0x00, 0x08),
   uiSunday_EndTime_2(0x60, 0x08),
   uiMonday_StartTime_1(0x00, 0x08),
   uiMonday_EndTime_1(0x60, 0x08),
   uiMonday_StartTime_2(0x00, 0x08),
   uiMonday_EndTime_2(0x60, 0x08),
   uiTuesday_StartTime_1(0x00, 0x08),
   uiTuesday_EndTime_1(0x60, 0x08),
   uiTuesday_StartTime_2(0x00, 0x08),
   uiTuesday_EndTime_2(0x60, 0x08),
   uiWednesday_StartTime_1(0x00, 0x08),
   uiWednesday_EndTime_1(0x60, 0x08),
   uiWednesday_StartTime_2(0x00, 0x08),
   uiWednesday_EndTime_2(0x60, 0x08),
   uiThursday_StartTime_1(0x00, 0x08),
   uiThursday_EndTime_1(0x60, 0x08),
   uiThursday_StartTime_2(0x00, 0x08),
   uiThursday_EndTime_2(0x60, 0x08),
   uiFriday_StartTime_1(0x00, 0x08),
   uiFriday_EndTime_1(0x60, 0x08),
   uiFriday_StartTime_2(0x00, 0x08),
   uiFriday_EndTime_2(0x60, 0x08),
   uiSaturday_StartTime_1(0x00, 0x08),
   uiSaturday_EndTime_1(0x60, 0x08),
   uiSaturday_StartTime_2(0x00, 0x08),
   uiSaturday_EndTime_2(0x60, 0x08)
{
}

tBool tcl_ITM_TCU_Opening_Hour::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiSunday_StartTime_1.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiSunday_EndTime_1.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiSunday_StartTime_2.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiSunday_EndTime_2.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiMonday_StartTime_1.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiMonday_EndTime_1.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiMonday_StartTime_2.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiMonday_EndTime_2.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiTuesday_StartTime_1.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiTuesday_EndTime_1.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiTuesday_StartTime_2.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiTuesday_EndTime_2.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiWednesday_StartTime_1.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiWednesday_EndTime_1.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiWednesday_StartTime_2.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiWednesday_EndTime_2.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiThursday_StartTime_1.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiThursday_EndTime_1.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiThursday_StartTime_2.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiThursday_EndTime_2.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiFriday_StartTime_1.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiFriday_EndTime_1.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiFriday_StartTime_2.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiFriday_EndTime_2.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiSaturday_StartTime_1.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiSaturday_EndTime_1.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiSaturday_StartTime_2.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiSaturday_EndTime_2.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Opening_Hour::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiSunday_StartTime_1.bUpdateMcanMessage(poMcanMsg);
   uiSunday_EndTime_1.bUpdateMcanMessage(poMcanMsg);
   uiSunday_StartTime_2.bUpdateMcanMessage(poMcanMsg);
   uiSunday_EndTime_2.bUpdateMcanMessage(poMcanMsg);
   uiMonday_StartTime_1.bUpdateMcanMessage(poMcanMsg);
   uiMonday_EndTime_1.bUpdateMcanMessage(poMcanMsg);
   uiMonday_StartTime_2.bUpdateMcanMessage(poMcanMsg);
   uiMonday_EndTime_2.bUpdateMcanMessage(poMcanMsg);
   uiTuesday_StartTime_1.bUpdateMcanMessage(poMcanMsg);
   uiTuesday_EndTime_1.bUpdateMcanMessage(poMcanMsg);
   uiTuesday_StartTime_2.bUpdateMcanMessage(poMcanMsg);
   uiTuesday_EndTime_2.bUpdateMcanMessage(poMcanMsg);
   uiWednesday_StartTime_1.bUpdateMcanMessage(poMcanMsg);
   uiWednesday_EndTime_1.bUpdateMcanMessage(poMcanMsg);
   uiWednesday_StartTime_2.bUpdateMcanMessage(poMcanMsg);
   uiWednesday_EndTime_2.bUpdateMcanMessage(poMcanMsg);
   uiThursday_StartTime_1.bUpdateMcanMessage(poMcanMsg);
   uiThursday_EndTime_1.bUpdateMcanMessage(poMcanMsg);
   uiThursday_StartTime_2.bUpdateMcanMessage(poMcanMsg);
   uiThursday_EndTime_2.bUpdateMcanMessage(poMcanMsg);
   uiFriday_StartTime_1.bUpdateMcanMessage(poMcanMsg);
   uiFriday_EndTime_1.bUpdateMcanMessage(poMcanMsg);
   uiFriday_StartTime_2.bUpdateMcanMessage(poMcanMsg);
   uiFriday_EndTime_2.bUpdateMcanMessage(poMcanMsg);
   uiSaturday_StartTime_1.bUpdateMcanMessage(poMcanMsg);
   uiSaturday_EndTime_1.bUpdateMcanMessage(poMcanMsg);
   uiSaturday_StartTime_2.bUpdateMcanMessage(poMcanMsg);
   uiSaturday_EndTime_2.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Opening_Hour const& lhs, tcl_ITM_TCU_Opening_Hour const& rhs){
   if (lhs.uiSunday_StartTime_1 != rhs.uiSunday_StartTime_1) return FALSE;
   if (lhs.uiSunday_EndTime_1 != rhs.uiSunday_EndTime_1) return FALSE;
   if (lhs.uiSunday_StartTime_2 != rhs.uiSunday_StartTime_2) return FALSE;
   if (lhs.uiSunday_EndTime_2 != rhs.uiSunday_EndTime_2) return FALSE;
   if (lhs.uiMonday_StartTime_1 != rhs.uiMonday_StartTime_1) return FALSE;
   if (lhs.uiMonday_EndTime_1 != rhs.uiMonday_EndTime_1) return FALSE;
   if (lhs.uiMonday_StartTime_2 != rhs.uiMonday_StartTime_2) return FALSE;
   if (lhs.uiMonday_EndTime_2 != rhs.uiMonday_EndTime_2) return FALSE;
   if (lhs.uiTuesday_StartTime_1 != rhs.uiTuesday_StartTime_1) return FALSE;
   if (lhs.uiTuesday_EndTime_1 != rhs.uiTuesday_EndTime_1) return FALSE;
   if (lhs.uiTuesday_StartTime_2 != rhs.uiTuesday_StartTime_2) return FALSE;
   if (lhs.uiTuesday_EndTime_2 != rhs.uiTuesday_EndTime_2) return FALSE;
   if (lhs.uiWednesday_StartTime_1 != rhs.uiWednesday_StartTime_1) return FALSE;
   if (lhs.uiWednesday_EndTime_1 != rhs.uiWednesday_EndTime_1) return FALSE;
   if (lhs.uiWednesday_StartTime_2 != rhs.uiWednesday_StartTime_2) return FALSE;
   if (lhs.uiWednesday_EndTime_2 != rhs.uiWednesday_EndTime_2) return FALSE;
   if (lhs.uiThursday_StartTime_1 != rhs.uiThursday_StartTime_1) return FALSE;
   if (lhs.uiThursday_EndTime_1 != rhs.uiThursday_EndTime_1) return FALSE;
   if (lhs.uiThursday_StartTime_2 != rhs.uiThursday_StartTime_2) return FALSE;
   if (lhs.uiThursday_EndTime_2 != rhs.uiThursday_EndTime_2) return FALSE;
   if (lhs.uiFriday_StartTime_1 != rhs.uiFriday_StartTime_1) return FALSE;
   if (lhs.uiFriday_EndTime_1 != rhs.uiFriday_EndTime_1) return FALSE;
   if (lhs.uiFriday_StartTime_2 != rhs.uiFriday_StartTime_2) return FALSE;
   if (lhs.uiFriday_EndTime_2 != rhs.uiFriday_EndTime_2) return FALSE;
   if (lhs.uiSaturday_StartTime_1 != rhs.uiSaturday_StartTime_1) return FALSE;
   if (lhs.uiSaturday_EndTime_1 != rhs.uiSaturday_EndTime_1) return FALSE;
   if (lhs.uiSaturday_StartTime_2 != rhs.uiSaturday_StartTime_2) return FALSE;
   if (lhs.uiSaturday_EndTime_2 != rhs.uiSaturday_EndTime_2) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Opening_Hour const& lhs, tcl_ITM_TCU_Opening_Hour const& rhs){
    if (
         (lhs.uiSunday_StartTime_1 == rhs.uiSunday_StartTime_1)
      && (lhs.uiSunday_EndTime_1 == rhs.uiSunday_EndTime_1)
      && (lhs.uiSunday_StartTime_2 == rhs.uiSunday_StartTime_2)
      && (lhs.uiSunday_EndTime_2 == rhs.uiSunday_EndTime_2)
      && (lhs.uiMonday_StartTime_1 == rhs.uiMonday_StartTime_1)
      && (lhs.uiMonday_EndTime_1 == rhs.uiMonday_EndTime_1)
      && (lhs.uiMonday_StartTime_2 == rhs.uiMonday_StartTime_2)
      && (lhs.uiMonday_EndTime_2 == rhs.uiMonday_EndTime_2)
      && (lhs.uiTuesday_StartTime_1 == rhs.uiTuesday_StartTime_1)
      && (lhs.uiTuesday_EndTime_1 == rhs.uiTuesday_EndTime_1)
      && (lhs.uiTuesday_StartTime_2 == rhs.uiTuesday_StartTime_2)
      && (lhs.uiTuesday_EndTime_2 == rhs.uiTuesday_EndTime_2)
      && (lhs.uiWednesday_StartTime_1 == rhs.uiWednesday_StartTime_1)
      && (lhs.uiWednesday_EndTime_1 == rhs.uiWednesday_EndTime_1)
      && (lhs.uiWednesday_StartTime_2 == rhs.uiWednesday_StartTime_2)
      && (lhs.uiWednesday_EndTime_2 == rhs.uiWednesday_EndTime_2)
      && (lhs.uiThursday_StartTime_1 == rhs.uiThursday_StartTime_1)
      && (lhs.uiThursday_EndTime_1 == rhs.uiThursday_EndTime_1)
      && (lhs.uiThursday_StartTime_2 == rhs.uiThursday_StartTime_2)
      && (lhs.uiThursday_EndTime_2 == rhs.uiThursday_EndTime_2)
      && (lhs.uiFriday_StartTime_1 == rhs.uiFriday_StartTime_1)
      && (lhs.uiFriday_EndTime_1 == rhs.uiFriday_EndTime_1)
      && (lhs.uiFriday_StartTime_2 == rhs.uiFriday_StartTime_2)
      && (lhs.uiFriday_EndTime_2 == rhs.uiFriday_EndTime_2)
      && (lhs.uiSaturday_StartTime_1 == rhs.uiSaturday_StartTime_1)
      && (lhs.uiSaturday_EndTime_1 == rhs.uiSaturday_EndTime_1)
      && (lhs.uiSaturday_StartTime_2 == rhs.uiSaturday_StartTime_2)
      && (lhs.uiSaturday_EndTime_2 == rhs.uiSaturday_EndTime_2)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Charge_Station_Accessibility::tcl_ITM_TCU_Charge_Station_Accessibility() : 
   eCharge_Station_Accessibility((tcl_ITM_TCU_e32_Station_Accessibility::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_TCU_Charge_Station_Accessibility::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eCharge_Station_Accessibility.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Charge_Station_Accessibility::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eCharge_Station_Accessibility.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Charge_Station_Accessibility const& lhs, tcl_ITM_TCU_Charge_Station_Accessibility const& rhs){
   if (lhs.eCharge_Station_Accessibility != rhs.eCharge_Station_Accessibility) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Charge_Station_Accessibility const& lhs, tcl_ITM_TCU_Charge_Station_Accessibility const& rhs){
    if (
         (lhs.eCharge_Station_Accessibility == rhs.eCharge_Station_Accessibility)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Payment_Method_Type::tcl_ITM_TCU_Payment_Method_Type() : 
   ePayment_Method_Type((tcl_ITM_TCU_e32_Payment_Method::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_TCU_Payment_Method_Type::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = ePayment_Method_Type.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Payment_Method_Type::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   ePayment_Method_Type.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Payment_Method_Type const& lhs, tcl_ITM_TCU_Payment_Method_Type const& rhs){
   if (lhs.ePayment_Method_Type != rhs.ePayment_Method_Type) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Payment_Method_Type const& lhs, tcl_ITM_TCU_Payment_Method_Type const& rhs){
    if (
         (lhs.ePayment_Method_Type == rhs.ePayment_Method_Type)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Spot_Total_Number::tcl_ITM_TCU_Spot_Total_Number() : 
   uiSpot_Total_Number(0x00, 0x08)
{
}

tBool tcl_ITM_TCU_Spot_Total_Number::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiSpot_Total_Number.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Spot_Total_Number::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiSpot_Total_Number.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Spot_Total_Number const& lhs, tcl_ITM_TCU_Spot_Total_Number const& rhs){
   if (lhs.uiSpot_Total_Number != rhs.uiSpot_Total_Number) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Spot_Total_Number const& lhs, tcl_ITM_TCU_Spot_Total_Number const& rhs){
    if (
         (lhs.uiSpot_Total_Number == rhs.uiSpot_Total_Number)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Number_Available_Batteries::tcl_ITM_TCU_Number_Available_Batteries() : 
   uiNumber_Available_Batteries(0x00, 0x08)
{
}

tBool tcl_ITM_TCU_Number_Available_Batteries::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiNumber_Available_Batteries.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Number_Available_Batteries::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiNumber_Available_Batteries.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Number_Available_Batteries const& lhs, tcl_ITM_TCU_Number_Available_Batteries const& rhs){
   if (lhs.uiNumber_Available_Batteries != rhs.uiNumber_Available_Batteries) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Number_Available_Batteries const& lhs, tcl_ITM_TCU_Number_Available_Batteries const& rhs){
    if (
         (lhs.uiNumber_Available_Batteries == rhs.uiNumber_Available_Batteries)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Full_Address::tcl_ITM_TCU_Full_Address() : 
   uiLength_of_Text(0x01, 0x08),
   vstrText_Info(NULL, 0)
{
}

tBool tcl_ITM_TCU_Full_Address::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiLength_of_Text.bUpdateData(poMcanMsg);

   if (bRet) bRet = vstrText_Info.bUpdateLength(8*uiLength_of_Text.u32GetData());
   if (bRet) bRet = vstrText_Info.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Full_Address::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiLength_of_Text.bUpdateMcanMessage(poMcanMsg);
   vstrText_Info.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Full_Address const& lhs, tcl_ITM_TCU_Full_Address const& rhs){
   if (lhs.uiLength_of_Text != rhs.uiLength_of_Text) return FALSE;
   if (lhs.vstrText_Info != rhs.vstrText_Info) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Full_Address const& lhs, tcl_ITM_TCU_Full_Address const& rhs){
    if (
         (lhs.uiLength_of_Text == rhs.uiLength_of_Text)
      && (lhs.vstrText_Info == rhs.vstrText_Info)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Charge_Staion_Ranking::tcl_ITM_TCU_Charge_Staion_Ranking() : 
   uiCharge_Staion_Ranking(0x00, 0x08)
{
}

tBool tcl_ITM_TCU_Charge_Staion_Ranking::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiCharge_Staion_Ranking.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Charge_Staion_Ranking::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiCharge_Staion_Ranking.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Charge_Staion_Ranking const& lhs, tcl_ITM_TCU_Charge_Staion_Ranking const& rhs){
   if (lhs.uiCharge_Staion_Ranking != rhs.uiCharge_Staion_Ranking) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Charge_Staion_Ranking const& lhs, tcl_ITM_TCU_Charge_Staion_Ranking const& rhs){
    if (
         (lhs.uiCharge_Staion_Ranking == rhs.uiCharge_Staion_Ranking)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Charge_Spot_List::tcl_ITM_TCU_Charge_Spot_List() : 
   uiTotal_pages_of_lists(0x01, 0x08),
   uiPage_of_list(0x01, 0x08),
   uiStation_List_Number(0x00, 0x08),
   strSpot_List1_Charge_Spot_ID(NULL, 0x70),
   eSpot_List1_Bookable_Information((tcl_ITM_TCU_e32_Bookable_Information::tenType)0x00, 0x08),
   eSpot_List1_Spot_Availability((tcl_ITM_TCU_e32_Spot_Availability::tenType)0x00, 0x08),
   uiSpot_List1_Bookable_Free_Text_Length_of_Text(0x01, 0x08),
   vstrSpot_List1_Bookable_Free_Text_Text_Info(NULL, 0),
   uiSpot_List1_Total_Number_Receptacles(0x00, 0x08),
   eSpot_List1_Receptacle1_Charge_Receptacle_Type((tcl_ITM_TCU_e32_Charge_Receptacle_Type::tenType)0x00, 0x08),
   uiSpot_List1_Receptacle1_Available_Power(0x00, 0x10),
   eSpot_List1_Receptacle1_Charge_Receptacle_Facility((tcl_ITM_TCU_e32_Charge_Receptacle_Facility::tenType)0x00, 0x08),
   eSpot_List1_Receptacle2_Charge_Receptacle_Type((tcl_ITM_TCU_e32_Charge_Receptacle_Type::tenType)0x00, 0x08),
   uiSpot_List1_Receptacle2_Available_Power(0x00, 0x10),
   eSpot_List1_Receptacle2_Charge_Receptacle_Facility((tcl_ITM_TCU_e32_Charge_Receptacle_Facility::tenType)0x00, 0x08),
   eSpot_List1_Receptacle3_Charge_Receptacle_Type((tcl_ITM_TCU_e32_Charge_Receptacle_Type::tenType)0x00, 0x08),
   uiSpot_List1_Receptacle3_Available_Power(0x00, 0x10),
   eSpot_List1_Receptacle3_Charge_Receptacle_Facility((tcl_ITM_TCU_e32_Charge_Receptacle_Facility::tenType)0x00, 0x08),
   eSpot_List1_Receptacle4_Charge_Receptacle_Type((tcl_ITM_TCU_e32_Charge_Receptacle_Type::tenType)0x00, 0x08),
   uiSpot_List1_Receptacle4_Available_Power(0x00, 0x10),
   eSpot_List1_Receptacle4_Charge_Receptacle_Facility((tcl_ITM_TCU_e32_Charge_Receptacle_Facility::tenType)0x00, 0x08),
   eSpot_List1_Receptacle5_Charge_Receptacle_Type((tcl_ITM_TCU_e32_Charge_Receptacle_Type::tenType)0x00, 0x08),
   uiSpot_List1_Receptacle5_Available_Power(0x00, 0x10),
   eSpot_List1_Receptacle5_Charge_Receptacle_Facility((tcl_ITM_TCU_e32_Charge_Receptacle_Facility::tenType)0x00, 0x08),
   eSpot_List1_Receptacle6_Charge_Receptacle_Type((tcl_ITM_TCU_e32_Charge_Receptacle_Type::tenType)0x00, 0x08),
   uiSpot_List1_Receptacle6_Available_Power(0x00, 0x10),
   eSpot_List1_Receptacle6_Charge_Receptacle_Facility((tcl_ITM_TCU_e32_Charge_Receptacle_Facility::tenType)0x00, 0x08),
   eSpot_List1_Receptacle7_Charge_Receptacle_Type((tcl_ITM_TCU_e32_Charge_Receptacle_Type::tenType)0x00, 0x08),
   uiSpot_List1_Receptacle7_Available_Power(0x00, 0x10),
   eSpot_List1_Receptacle7_Charge_Receptacle_Facility((tcl_ITM_TCU_e32_Charge_Receptacle_Facility::tenType)0x00, 0x08),
   eSpot_List1_Receptacle8_Charge_Receptacle_Type((tcl_ITM_TCU_e32_Charge_Receptacle_Type::tenType)0x00, 0x08),
   uiSpot_List1_Receptacle8_Available_Power(0x00, 0x10),
   eSpot_List1_Receptacle8_Charge_Receptacle_Facility((tcl_ITM_TCU_e32_Charge_Receptacle_Facility::tenType)0x00, 0x08),
   eSpot_List1_Receptacle9_Charge_Receptacle_Type((tcl_ITM_TCU_e32_Charge_Receptacle_Type::tenType)0x00, 0x08),
   uiSpot_List1_Receptacle9_Available_Power(0x00, 0x10),
   eSpot_List1_Receptacle9_Charge_Receptacle_Facility((tcl_ITM_TCU_e32_Charge_Receptacle_Facility::tenType)0x00, 0x08),
   eSpot_List1_Receptacle10_Charge_Receptacle_Type((tcl_ITM_TCU_e32_Charge_Receptacle_Type::tenType)0x00, 0x08),
   uiSpot_List1_Receptacle10_Available_Power(0x00, 0x10),
   eSpot_List1_Receptacle10_Charge_Receptacle_Facility((tcl_ITM_TCU_e32_Charge_Receptacle_Facility::tenType)0x00, 0x08),
   strSpot_List2_Charge_Spot_ID(NULL, 0x70),
   eSpot_List2_Bookable_Information((tcl_ITM_TCU_e32_Bookable_Information::tenType)0x00, 0x08),
   eSpot_List2_Spot_Availability((tcl_ITM_TCU_e32_Spot_Availability::tenType)0x00, 0x08),
   uiSpot_List2_Bookable_Free_Text_Length_of_Text(0x01, 0x08),
   vstrSpot_List2_Bookable_Free_Text_Text_Info(NULL, 0),
   uiSpot_List2_Total_Number_Receptacles(0x00, 0x08),
   eSpot_List2_Receptacle1_Charge_Receptacle_Type((tcl_ITM_TCU_e32_Charge_Receptacle_Type::tenType)0x00, 0x08),
   uiSpot_List2_Receptacle1_Available_Power(0x00, 0x10),
   eSpot_List2_Receptacle1_Charge_Receptacle_Facility((tcl_ITM_TCU_e32_Charge_Receptacle_Facility::tenType)0x00, 0x08),
   eSpot_List2_Receptacle2_Charge_Receptacle_Type((tcl_ITM_TCU_e32_Charge_Receptacle_Type::tenType)0x00, 0x08),
   uiSpot_List2_Receptacle2_Available_Power(0x00, 0x10),
   eSpot_List2_Receptacle2_Charge_Receptacle_Facility((tcl_ITM_TCU_e32_Charge_Receptacle_Facility::tenType)0x00, 0x08),
   eSpot_List2_Receptacle3_Charge_Receptacle_Type((tcl_ITM_TCU_e32_Charge_Receptacle_Type::tenType)0x00, 0x08),
   uiSpot_List2_Receptacle3_Available_Power(0x00, 0x10),
   eSpot_List2_Receptacle3_Charge_Receptacle_Facility((tcl_ITM_TCU_e32_Charge_Receptacle_Facility::tenType)0x00, 0x08),
   eSpot_List2_Receptacle4_Charge_Receptacle_Type((tcl_ITM_TCU_e32_Charge_Receptacle_Type::tenType)0x00, 0x08),
   uiSpot_List2_Receptacle4_Available_Power(0x00, 0x10),
   eSpot_List2_Receptacle4_Charge_Receptacle_Facility((tcl_ITM_TCU_e32_Charge_Receptacle_Facility::tenType)0x00, 0x08),
   eSpot_List2_Receptacle5_Charge_Receptacle_Type((tcl_ITM_TCU_e32_Charge_Receptacle_Type::tenType)0x00, 0x08),
   uiSpot_List2_Receptacle5_Available_Power(0x00, 0x10),
   eSpot_List2_Receptacle5_Charge_Receptacle_Facility((tcl_ITM_TCU_e32_Charge_Receptacle_Facility::tenType)0x00, 0x08),
   eSpot_List2_Receptacle6_Charge_Receptacle_Type((tcl_ITM_TCU_e32_Charge_Receptacle_Type::tenType)0x00, 0x08),
   uiSpot_List2_Receptacle6_Available_Power(0x00, 0x10),
   eSpot_List2_Receptacle6_Charge_Receptacle_Facility((tcl_ITM_TCU_e32_Charge_Receptacle_Facility::tenType)0x00, 0x08),
   eSpot_List2_Receptacle7_Charge_Receptacle_Type((tcl_ITM_TCU_e32_Charge_Receptacle_Type::tenType)0x00, 0x08),
   uiSpot_List2_Receptacle7_Available_Power(0x00, 0x10),
   eSpot_List2_Receptacle7_Charge_Receptacle_Facility((tcl_ITM_TCU_e32_Charge_Receptacle_Facility::tenType)0x00, 0x08),
   eSpot_List2_Receptacle8_Charge_Receptacle_Type((tcl_ITM_TCU_e32_Charge_Receptacle_Type::tenType)0x00, 0x08),
   uiSpot_List2_Receptacle8_Available_Power(0x00, 0x10),
   eSpot_List2_Receptacle8_Charge_Receptacle_Facility((tcl_ITM_TCU_e32_Charge_Receptacle_Facility::tenType)0x00, 0x08),
   eSpot_List2_Receptacle9_Charge_Receptacle_Type((tcl_ITM_TCU_e32_Charge_Receptacle_Type::tenType)0x00, 0x08),
   uiSpot_List2_Receptacle9_Available_Power(0x00, 0x10),
   eSpot_List2_Receptacle9_Charge_Receptacle_Facility((tcl_ITM_TCU_e32_Charge_Receptacle_Facility::tenType)0x00, 0x08),
   eSpot_List2_Receptacle10_Charge_Receptacle_Type((tcl_ITM_TCU_e32_Charge_Receptacle_Type::tenType)0x00, 0x08),
   uiSpot_List2_Receptacle10_Available_Power(0x00, 0x10),
   eSpot_List2_Receptacle10_Charge_Receptacle_Facility((tcl_ITM_TCU_e32_Charge_Receptacle_Facility::tenType)0x00, 0x08),
   strSpot_List3_Charge_Spot_ID(NULL, 0x70),
   eSpot_List3_Bookable_Information((tcl_ITM_TCU_e32_Bookable_Information::tenType)0x00, 0x08),
   eSpot_List3_Spot_Availability((tcl_ITM_TCU_e32_Spot_Availability::tenType)0x00, 0x08),
   uiSpot_List3_Bookable_Free_Text_Length_of_Text(0x01, 0x08),
   vstrSpot_List3_Bookable_Free_Text_Text_Info(NULL, 0),
   uiSpot_List3_Total_Number_Receptacles(0x00, 0x08),
   eSpot_List3_Receptacle1_Charge_Receptacle_Type((tcl_ITM_TCU_e32_Charge_Receptacle_Type::tenType)0x00, 0x08),
   uiSpot_List3_Receptacle1_Available_Power(0x00, 0x10),
   eSpot_List3_Receptacle1_Charge_Receptacle_Facility((tcl_ITM_TCU_e32_Charge_Receptacle_Facility::tenType)0x00, 0x08),
   eSpot_List3_Receptacle2_Charge_Receptacle_Type((tcl_ITM_TCU_e32_Charge_Receptacle_Type::tenType)0x00, 0x08),
   uiSpot_List3_Receptacle2_Available_Power(0x00, 0x10),
   eSpot_List3_Receptacle2_Charge_Receptacle_Facility((tcl_ITM_TCU_e32_Charge_Receptacle_Facility::tenType)0x00, 0x08),
   eSpot_List3_Receptacle3_Charge_Receptacle_Type((tcl_ITM_TCU_e32_Charge_Receptacle_Type::tenType)0x00, 0x08),
   uiSpot_List3_Receptacle3_Available_Power(0x00, 0x10),
   eSpot_List3_Receptacle3_Charge_Receptacle_Facility((tcl_ITM_TCU_e32_Charge_Receptacle_Facility::tenType)0x00, 0x08),
   eSpot_List3_Receptacle4_Charge_Receptacle_Type((tcl_ITM_TCU_e32_Charge_Receptacle_Type::tenType)0x00, 0x08),
   uiSpot_List3_Receptacle4_Available_Power(0x00, 0x10),
   eSpot_List3_Receptacle4_Charge_Receptacle_Facility((tcl_ITM_TCU_e32_Charge_Receptacle_Facility::tenType)0x00, 0x08),
   eSpot_List3_Receptacle5_Charge_Receptacle_Type((tcl_ITM_TCU_e32_Charge_Receptacle_Type::tenType)0x00, 0x08),
   uiSpot_List3_Receptacle5_Available_Power(0x00, 0x10),
   eSpot_List3_Receptacle5_Charge_Receptacle_Facility((tcl_ITM_TCU_e32_Charge_Receptacle_Facility::tenType)0x00, 0x08),
   eSpot_List3_Receptacle6_Charge_Receptacle_Type((tcl_ITM_TCU_e32_Charge_Receptacle_Type::tenType)0x00, 0x08),
   uiSpot_List3_Receptacle6_Available_Power(0x00, 0x10),
   eSpot_List3_Receptacle6_Charge_Receptacle_Facility((tcl_ITM_TCU_e32_Charge_Receptacle_Facility::tenType)0x00, 0x08),
   eSpot_List3_Receptacle7_Charge_Receptacle_Type((tcl_ITM_TCU_e32_Charge_Receptacle_Type::tenType)0x00, 0x08),
   uiSpot_List3_Receptacle7_Available_Power(0x00, 0x10),
   eSpot_List3_Receptacle7_Charge_Receptacle_Facility((tcl_ITM_TCU_e32_Charge_Receptacle_Facility::tenType)0x00, 0x08),
   eSpot_List3_Receptacle8_Charge_Receptacle_Type((tcl_ITM_TCU_e32_Charge_Receptacle_Type::tenType)0x00, 0x08),
   uiSpot_List3_Receptacle8_Available_Power(0x00, 0x10),
   eSpot_List3_Receptacle8_Charge_Receptacle_Facility((tcl_ITM_TCU_e32_Charge_Receptacle_Facility::tenType)0x00, 0x08),
   eSpot_List3_Receptacle9_Charge_Receptacle_Type((tcl_ITM_TCU_e32_Charge_Receptacle_Type::tenType)0x00, 0x08),
   uiSpot_List3_Receptacle9_Available_Power(0x00, 0x10),
   eSpot_List3_Receptacle9_Charge_Receptacle_Facility((tcl_ITM_TCU_e32_Charge_Receptacle_Facility::tenType)0x00, 0x08),
   eSpot_List3_Receptacle10_Charge_Receptacle_Type((tcl_ITM_TCU_e32_Charge_Receptacle_Type::tenType)0x00, 0x08),
   uiSpot_List3_Receptacle10_Available_Power(0x00, 0x10),
   eSpot_List3_Receptacle10_Charge_Receptacle_Facility((tcl_ITM_TCU_e32_Charge_Receptacle_Facility::tenType)0x00, 0x08),
   strSpot_List4_Charge_Spot_ID(NULL, 0x70),
   eSpot_List4_Bookable_Information((tcl_ITM_TCU_e32_Bookable_Information::tenType)0x00, 0x08),
   eSpot_List4_Spot_Availability((tcl_ITM_TCU_e32_Spot_Availability::tenType)0x00, 0x08),
   uiSpot_List4_Bookable_Free_Text_Length_of_Text(0x01, 0x08),
   vstrSpot_List4_Bookable_Free_Text_Text_Info(NULL, 0),
   uiSpot_List4_Total_Number_Receptacles(0x00, 0x08),
   eSpot_List4_Receptacle1_Charge_Receptacle_Type((tcl_ITM_TCU_e32_Charge_Receptacle_Type::tenType)0x00, 0x08),
   uiSpot_List4_Receptacle1_Available_Power(0x00, 0x10),
   eSpot_List4_Receptacle1_Charge_Receptacle_Facility((tcl_ITM_TCU_e32_Charge_Receptacle_Facility::tenType)0x00, 0x08),
   eSpot_List4_Receptacle2_Charge_Receptacle_Type((tcl_ITM_TCU_e32_Charge_Receptacle_Type::tenType)0x00, 0x08),
   uiSpot_List4_Receptacle2_Available_Power(0x00, 0x10),
   eSpot_List4_Receptacle2_Charge_Receptacle_Facility((tcl_ITM_TCU_e32_Charge_Receptacle_Facility::tenType)0x00, 0x08),
   eSpot_List4_Receptacle3_Charge_Receptacle_Type((tcl_ITM_TCU_e32_Charge_Receptacle_Type::tenType)0x00, 0x08),
   uiSpot_List4_Receptacle3_Available_Power(0x00, 0x10),
   eSpot_List4_Receptacle3_Charge_Receptacle_Facility((tcl_ITM_TCU_e32_Charge_Receptacle_Facility::tenType)0x00, 0x08),
   eSpot_List4_Receptacle4_Charge_Receptacle_Type((tcl_ITM_TCU_e32_Charge_Receptacle_Type::tenType)0x00, 0x08),
   uiSpot_List4_Receptacle4_Available_Power(0x00, 0x10),
   eSpot_List4_Receptacle4_Charge_Receptacle_Facility((tcl_ITM_TCU_e32_Charge_Receptacle_Facility::tenType)0x00, 0x08),
   eSpot_List4_Receptacle5_Charge_Receptacle_Type((tcl_ITM_TCU_e32_Charge_Receptacle_Type::tenType)0x00, 0x08),
   uiSpot_List4_Receptacle5_Available_Power(0x00, 0x10),
   eSpot_List4_Receptacle5_Charge_Receptacle_Facility((tcl_ITM_TCU_e32_Charge_Receptacle_Facility::tenType)0x00, 0x08),
   eSpot_List4_Receptacle6_Charge_Receptacle_Type((tcl_ITM_TCU_e32_Charge_Receptacle_Type::tenType)0x00, 0x08),
   uiSpot_List4_Receptacle6_Available_Power(0x00, 0x10),
   eSpot_List4_Receptacle6_Charge_Receptacle_Facility((tcl_ITM_TCU_e32_Charge_Receptacle_Facility::tenType)0x00, 0x08),
   eSpot_List4_Receptacle7_Charge_Receptacle_Type((tcl_ITM_TCU_e32_Charge_Receptacle_Type::tenType)0x00, 0x08),
   uiSpot_List4_Receptacle7_Available_Power(0x00, 0x10),
   eSpot_List4_Receptacle7_Charge_Receptacle_Facility((tcl_ITM_TCU_e32_Charge_Receptacle_Facility::tenType)0x00, 0x08),
   eSpot_List4_Receptacle8_Charge_Receptacle_Type((tcl_ITM_TCU_e32_Charge_Receptacle_Type::tenType)0x00, 0x08),
   uiSpot_List4_Receptacle8_Available_Power(0x00, 0x10),
   eSpot_List4_Receptacle8_Charge_Receptacle_Facility((tcl_ITM_TCU_e32_Charge_Receptacle_Facility::tenType)0x00, 0x08),
   eSpot_List4_Receptacle9_Charge_Receptacle_Type((tcl_ITM_TCU_e32_Charge_Receptacle_Type::tenType)0x00, 0x08),
   uiSpot_List4_Receptacle9_Available_Power(0x00, 0x10),
   eSpot_List4_Receptacle9_Charge_Receptacle_Facility((tcl_ITM_TCU_e32_Charge_Receptacle_Facility::tenType)0x00, 0x08),
   eSpot_List4_Receptacle10_Charge_Receptacle_Type((tcl_ITM_TCU_e32_Charge_Receptacle_Type::tenType)0x00, 0x08),
   uiSpot_List4_Receptacle10_Available_Power(0x00, 0x10),
   eSpot_List4_Receptacle10_Charge_Receptacle_Facility((tcl_ITM_TCU_e32_Charge_Receptacle_Facility::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_TCU_Charge_Spot_List::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiTotal_pages_of_lists.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiPage_of_list.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiStation_List_Number.bUpdateData(poMcanMsg);
   if (bRet) bRet = strSpot_List1_Charge_Spot_ID.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List1_Bookable_Information.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List1_Spot_Availability.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiSpot_List1_Bookable_Free_Text_Length_of_Text.bUpdateData(poMcanMsg);

   if (bRet) bRet = vstrSpot_List1_Bookable_Free_Text_Text_Info.bUpdateLength(8*uiSpot_List1_Bookable_Free_Text_Length_of_Text.u32GetData());
   if (bRet) bRet = vstrSpot_List1_Bookable_Free_Text_Text_Info.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiSpot_List1_Total_Number_Receptacles.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List1_Receptacle1_Charge_Receptacle_Type.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiSpot_List1_Receptacle1_Available_Power.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List1_Receptacle1_Charge_Receptacle_Facility.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List1_Receptacle2_Charge_Receptacle_Type.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiSpot_List1_Receptacle2_Available_Power.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List1_Receptacle2_Charge_Receptacle_Facility.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List1_Receptacle3_Charge_Receptacle_Type.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiSpot_List1_Receptacle3_Available_Power.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List1_Receptacle3_Charge_Receptacle_Facility.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List1_Receptacle4_Charge_Receptacle_Type.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiSpot_List1_Receptacle4_Available_Power.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List1_Receptacle4_Charge_Receptacle_Facility.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List1_Receptacle5_Charge_Receptacle_Type.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiSpot_List1_Receptacle5_Available_Power.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List1_Receptacle5_Charge_Receptacle_Facility.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List1_Receptacle6_Charge_Receptacle_Type.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiSpot_List1_Receptacle6_Available_Power.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List1_Receptacle6_Charge_Receptacle_Facility.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List1_Receptacle7_Charge_Receptacle_Type.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiSpot_List1_Receptacle7_Available_Power.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List1_Receptacle7_Charge_Receptacle_Facility.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List1_Receptacle8_Charge_Receptacle_Type.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiSpot_List1_Receptacle8_Available_Power.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List1_Receptacle8_Charge_Receptacle_Facility.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List1_Receptacle9_Charge_Receptacle_Type.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiSpot_List1_Receptacle9_Available_Power.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List1_Receptacle9_Charge_Receptacle_Facility.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List1_Receptacle10_Charge_Receptacle_Type.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiSpot_List1_Receptacle10_Available_Power.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List1_Receptacle10_Charge_Receptacle_Facility.bUpdateData(poMcanMsg);
   if (bRet) bRet = strSpot_List2_Charge_Spot_ID.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List2_Bookable_Information.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List2_Spot_Availability.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiSpot_List2_Bookable_Free_Text_Length_of_Text.bUpdateData(poMcanMsg);

   if (bRet) bRet = vstrSpot_List2_Bookable_Free_Text_Text_Info.bUpdateLength(8*uiSpot_List2_Bookable_Free_Text_Length_of_Text.u32GetData());
   if (bRet) bRet = vstrSpot_List2_Bookable_Free_Text_Text_Info.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiSpot_List2_Total_Number_Receptacles.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List2_Receptacle1_Charge_Receptacle_Type.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiSpot_List2_Receptacle1_Available_Power.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List2_Receptacle1_Charge_Receptacle_Facility.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List2_Receptacle2_Charge_Receptacle_Type.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiSpot_List2_Receptacle2_Available_Power.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List2_Receptacle2_Charge_Receptacle_Facility.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List2_Receptacle3_Charge_Receptacle_Type.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiSpot_List2_Receptacle3_Available_Power.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List2_Receptacle3_Charge_Receptacle_Facility.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List2_Receptacle4_Charge_Receptacle_Type.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiSpot_List2_Receptacle4_Available_Power.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List2_Receptacle4_Charge_Receptacle_Facility.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List2_Receptacle5_Charge_Receptacle_Type.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiSpot_List2_Receptacle5_Available_Power.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List2_Receptacle5_Charge_Receptacle_Facility.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List2_Receptacle6_Charge_Receptacle_Type.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiSpot_List2_Receptacle6_Available_Power.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List2_Receptacle6_Charge_Receptacle_Facility.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List2_Receptacle7_Charge_Receptacle_Type.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiSpot_List2_Receptacle7_Available_Power.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List2_Receptacle7_Charge_Receptacle_Facility.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List2_Receptacle8_Charge_Receptacle_Type.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiSpot_List2_Receptacle8_Available_Power.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List2_Receptacle8_Charge_Receptacle_Facility.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List2_Receptacle9_Charge_Receptacle_Type.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiSpot_List2_Receptacle9_Available_Power.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List2_Receptacle9_Charge_Receptacle_Facility.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List2_Receptacle10_Charge_Receptacle_Type.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiSpot_List2_Receptacle10_Available_Power.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List2_Receptacle10_Charge_Receptacle_Facility.bUpdateData(poMcanMsg);
   if (bRet) bRet = strSpot_List3_Charge_Spot_ID.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List3_Bookable_Information.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List3_Spot_Availability.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiSpot_List3_Bookable_Free_Text_Length_of_Text.bUpdateData(poMcanMsg);

   if (bRet) bRet = vstrSpot_List3_Bookable_Free_Text_Text_Info.bUpdateLength(8*uiSpot_List3_Bookable_Free_Text_Length_of_Text.u32GetData());
   if (bRet) bRet = vstrSpot_List3_Bookable_Free_Text_Text_Info.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiSpot_List3_Total_Number_Receptacles.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List3_Receptacle1_Charge_Receptacle_Type.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiSpot_List3_Receptacle1_Available_Power.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List3_Receptacle1_Charge_Receptacle_Facility.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List3_Receptacle2_Charge_Receptacle_Type.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiSpot_List3_Receptacle2_Available_Power.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List3_Receptacle2_Charge_Receptacle_Facility.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List3_Receptacle3_Charge_Receptacle_Type.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiSpot_List3_Receptacle3_Available_Power.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List3_Receptacle3_Charge_Receptacle_Facility.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List3_Receptacle4_Charge_Receptacle_Type.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiSpot_List3_Receptacle4_Available_Power.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List3_Receptacle4_Charge_Receptacle_Facility.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List3_Receptacle5_Charge_Receptacle_Type.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiSpot_List3_Receptacle5_Available_Power.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List3_Receptacle5_Charge_Receptacle_Facility.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List3_Receptacle6_Charge_Receptacle_Type.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiSpot_List3_Receptacle6_Available_Power.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List3_Receptacle6_Charge_Receptacle_Facility.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List3_Receptacle7_Charge_Receptacle_Type.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiSpot_List3_Receptacle7_Available_Power.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List3_Receptacle7_Charge_Receptacle_Facility.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List3_Receptacle8_Charge_Receptacle_Type.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiSpot_List3_Receptacle8_Available_Power.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List3_Receptacle8_Charge_Receptacle_Facility.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List3_Receptacle9_Charge_Receptacle_Type.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiSpot_List3_Receptacle9_Available_Power.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List3_Receptacle9_Charge_Receptacle_Facility.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List3_Receptacle10_Charge_Receptacle_Type.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiSpot_List3_Receptacle10_Available_Power.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List3_Receptacle10_Charge_Receptacle_Facility.bUpdateData(poMcanMsg);
   if (bRet) bRet = strSpot_List4_Charge_Spot_ID.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List4_Bookable_Information.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List4_Spot_Availability.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiSpot_List4_Bookable_Free_Text_Length_of_Text.bUpdateData(poMcanMsg);

   if (bRet) bRet = vstrSpot_List4_Bookable_Free_Text_Text_Info.bUpdateLength(8*uiSpot_List4_Bookable_Free_Text_Length_of_Text.u32GetData());
   if (bRet) bRet = vstrSpot_List4_Bookable_Free_Text_Text_Info.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiSpot_List4_Total_Number_Receptacles.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List4_Receptacle1_Charge_Receptacle_Type.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiSpot_List4_Receptacle1_Available_Power.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List4_Receptacle1_Charge_Receptacle_Facility.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List4_Receptacle2_Charge_Receptacle_Type.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiSpot_List4_Receptacle2_Available_Power.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List4_Receptacle2_Charge_Receptacle_Facility.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List4_Receptacle3_Charge_Receptacle_Type.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiSpot_List4_Receptacle3_Available_Power.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List4_Receptacle3_Charge_Receptacle_Facility.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List4_Receptacle4_Charge_Receptacle_Type.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiSpot_List4_Receptacle4_Available_Power.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List4_Receptacle4_Charge_Receptacle_Facility.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List4_Receptacle5_Charge_Receptacle_Type.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiSpot_List4_Receptacle5_Available_Power.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List4_Receptacle5_Charge_Receptacle_Facility.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List4_Receptacle6_Charge_Receptacle_Type.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiSpot_List4_Receptacle6_Available_Power.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List4_Receptacle6_Charge_Receptacle_Facility.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List4_Receptacle7_Charge_Receptacle_Type.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiSpot_List4_Receptacle7_Available_Power.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List4_Receptacle7_Charge_Receptacle_Facility.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List4_Receptacle8_Charge_Receptacle_Type.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiSpot_List4_Receptacle8_Available_Power.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List4_Receptacle8_Charge_Receptacle_Facility.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List4_Receptacle9_Charge_Receptacle_Type.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiSpot_List4_Receptacle9_Available_Power.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List4_Receptacle9_Charge_Receptacle_Facility.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List4_Receptacle10_Charge_Receptacle_Type.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiSpot_List4_Receptacle10_Available_Power.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpot_List4_Receptacle10_Charge_Receptacle_Facility.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Charge_Spot_List::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiTotal_pages_of_lists.bUpdateMcanMessage(poMcanMsg);
   uiPage_of_list.bUpdateMcanMessage(poMcanMsg);
   uiStation_List_Number.bUpdateMcanMessage(poMcanMsg);
   strSpot_List1_Charge_Spot_ID.bUpdateMcanMessage(poMcanMsg);
   eSpot_List1_Bookable_Information.bUpdateMcanMessage(poMcanMsg);
   eSpot_List1_Spot_Availability.bUpdateMcanMessage(poMcanMsg);
   uiSpot_List1_Bookable_Free_Text_Length_of_Text.bUpdateMcanMessage(poMcanMsg);
   vstrSpot_List1_Bookable_Free_Text_Text_Info.bUpdateMcanMessage(poMcanMsg);
   uiSpot_List1_Total_Number_Receptacles.bUpdateMcanMessage(poMcanMsg);
   eSpot_List1_Receptacle1_Charge_Receptacle_Type.bUpdateMcanMessage(poMcanMsg);
   uiSpot_List1_Receptacle1_Available_Power.bUpdateMcanMessage(poMcanMsg);
   eSpot_List1_Receptacle1_Charge_Receptacle_Facility.bUpdateMcanMessage(poMcanMsg);
   eSpot_List1_Receptacle2_Charge_Receptacle_Type.bUpdateMcanMessage(poMcanMsg);
   uiSpot_List1_Receptacle2_Available_Power.bUpdateMcanMessage(poMcanMsg);
   eSpot_List1_Receptacle2_Charge_Receptacle_Facility.bUpdateMcanMessage(poMcanMsg);
   eSpot_List1_Receptacle3_Charge_Receptacle_Type.bUpdateMcanMessage(poMcanMsg);
   uiSpot_List1_Receptacle3_Available_Power.bUpdateMcanMessage(poMcanMsg);
   eSpot_List1_Receptacle3_Charge_Receptacle_Facility.bUpdateMcanMessage(poMcanMsg);
   eSpot_List1_Receptacle4_Charge_Receptacle_Type.bUpdateMcanMessage(poMcanMsg);
   uiSpot_List1_Receptacle4_Available_Power.bUpdateMcanMessage(poMcanMsg);
   eSpot_List1_Receptacle4_Charge_Receptacle_Facility.bUpdateMcanMessage(poMcanMsg);
   eSpot_List1_Receptacle5_Charge_Receptacle_Type.bUpdateMcanMessage(poMcanMsg);
   uiSpot_List1_Receptacle5_Available_Power.bUpdateMcanMessage(poMcanMsg);
   eSpot_List1_Receptacle5_Charge_Receptacle_Facility.bUpdateMcanMessage(poMcanMsg);
   eSpot_List1_Receptacle6_Charge_Receptacle_Type.bUpdateMcanMessage(poMcanMsg);
   uiSpot_List1_Receptacle6_Available_Power.bUpdateMcanMessage(poMcanMsg);
   eSpot_List1_Receptacle6_Charge_Receptacle_Facility.bUpdateMcanMessage(poMcanMsg);
   eSpot_List1_Receptacle7_Charge_Receptacle_Type.bUpdateMcanMessage(poMcanMsg);
   uiSpot_List1_Receptacle7_Available_Power.bUpdateMcanMessage(poMcanMsg);
   eSpot_List1_Receptacle7_Charge_Receptacle_Facility.bUpdateMcanMessage(poMcanMsg);
   eSpot_List1_Receptacle8_Charge_Receptacle_Type.bUpdateMcanMessage(poMcanMsg);
   uiSpot_List1_Receptacle8_Available_Power.bUpdateMcanMessage(poMcanMsg);
   eSpot_List1_Receptacle8_Charge_Receptacle_Facility.bUpdateMcanMessage(poMcanMsg);
   eSpot_List1_Receptacle9_Charge_Receptacle_Type.bUpdateMcanMessage(poMcanMsg);
   uiSpot_List1_Receptacle9_Available_Power.bUpdateMcanMessage(poMcanMsg);
   eSpot_List1_Receptacle9_Charge_Receptacle_Facility.bUpdateMcanMessage(poMcanMsg);
   eSpot_List1_Receptacle10_Charge_Receptacle_Type.bUpdateMcanMessage(poMcanMsg);
   uiSpot_List1_Receptacle10_Available_Power.bUpdateMcanMessage(poMcanMsg);
   eSpot_List1_Receptacle10_Charge_Receptacle_Facility.bUpdateMcanMessage(poMcanMsg);
   strSpot_List2_Charge_Spot_ID.bUpdateMcanMessage(poMcanMsg);
   eSpot_List2_Bookable_Information.bUpdateMcanMessage(poMcanMsg);
   eSpot_List2_Spot_Availability.bUpdateMcanMessage(poMcanMsg);
   uiSpot_List2_Bookable_Free_Text_Length_of_Text.bUpdateMcanMessage(poMcanMsg);
   vstrSpot_List2_Bookable_Free_Text_Text_Info.bUpdateMcanMessage(poMcanMsg);
   uiSpot_List2_Total_Number_Receptacles.bUpdateMcanMessage(poMcanMsg);
   eSpot_List2_Receptacle1_Charge_Receptacle_Type.bUpdateMcanMessage(poMcanMsg);
   uiSpot_List2_Receptacle1_Available_Power.bUpdateMcanMessage(poMcanMsg);
   eSpot_List2_Receptacle1_Charge_Receptacle_Facility.bUpdateMcanMessage(poMcanMsg);
   eSpot_List2_Receptacle2_Charge_Receptacle_Type.bUpdateMcanMessage(poMcanMsg);
   uiSpot_List2_Receptacle2_Available_Power.bUpdateMcanMessage(poMcanMsg);
   eSpot_List2_Receptacle2_Charge_Receptacle_Facility.bUpdateMcanMessage(poMcanMsg);
   eSpot_List2_Receptacle3_Charge_Receptacle_Type.bUpdateMcanMessage(poMcanMsg);
   uiSpot_List2_Receptacle3_Available_Power.bUpdateMcanMessage(poMcanMsg);
   eSpot_List2_Receptacle3_Charge_Receptacle_Facility.bUpdateMcanMessage(poMcanMsg);
   eSpot_List2_Receptacle4_Charge_Receptacle_Type.bUpdateMcanMessage(poMcanMsg);
   uiSpot_List2_Receptacle4_Available_Power.bUpdateMcanMessage(poMcanMsg);
   eSpot_List2_Receptacle4_Charge_Receptacle_Facility.bUpdateMcanMessage(poMcanMsg);
   eSpot_List2_Receptacle5_Charge_Receptacle_Type.bUpdateMcanMessage(poMcanMsg);
   uiSpot_List2_Receptacle5_Available_Power.bUpdateMcanMessage(poMcanMsg);
   eSpot_List2_Receptacle5_Charge_Receptacle_Facility.bUpdateMcanMessage(poMcanMsg);
   eSpot_List2_Receptacle6_Charge_Receptacle_Type.bUpdateMcanMessage(poMcanMsg);
   uiSpot_List2_Receptacle6_Available_Power.bUpdateMcanMessage(poMcanMsg);
   eSpot_List2_Receptacle6_Charge_Receptacle_Facility.bUpdateMcanMessage(poMcanMsg);
   eSpot_List2_Receptacle7_Charge_Receptacle_Type.bUpdateMcanMessage(poMcanMsg);
   uiSpot_List2_Receptacle7_Available_Power.bUpdateMcanMessage(poMcanMsg);
   eSpot_List2_Receptacle7_Charge_Receptacle_Facility.bUpdateMcanMessage(poMcanMsg);
   eSpot_List2_Receptacle8_Charge_Receptacle_Type.bUpdateMcanMessage(poMcanMsg);
   uiSpot_List2_Receptacle8_Available_Power.bUpdateMcanMessage(poMcanMsg);
   eSpot_List2_Receptacle8_Charge_Receptacle_Facility.bUpdateMcanMessage(poMcanMsg);
   eSpot_List2_Receptacle9_Charge_Receptacle_Type.bUpdateMcanMessage(poMcanMsg);
   uiSpot_List2_Receptacle9_Available_Power.bUpdateMcanMessage(poMcanMsg);
   eSpot_List2_Receptacle9_Charge_Receptacle_Facility.bUpdateMcanMessage(poMcanMsg);
   eSpot_List2_Receptacle10_Charge_Receptacle_Type.bUpdateMcanMessage(poMcanMsg);
   uiSpot_List2_Receptacle10_Available_Power.bUpdateMcanMessage(poMcanMsg);
   eSpot_List2_Receptacle10_Charge_Receptacle_Facility.bUpdateMcanMessage(poMcanMsg);
   strSpot_List3_Charge_Spot_ID.bUpdateMcanMessage(poMcanMsg);
   eSpot_List3_Bookable_Information.bUpdateMcanMessage(poMcanMsg);
   eSpot_List3_Spot_Availability.bUpdateMcanMessage(poMcanMsg);
   uiSpot_List3_Bookable_Free_Text_Length_of_Text.bUpdateMcanMessage(poMcanMsg);
   vstrSpot_List3_Bookable_Free_Text_Text_Info.bUpdateMcanMessage(poMcanMsg);
   uiSpot_List3_Total_Number_Receptacles.bUpdateMcanMessage(poMcanMsg);
   eSpot_List3_Receptacle1_Charge_Receptacle_Type.bUpdateMcanMessage(poMcanMsg);
   uiSpot_List3_Receptacle1_Available_Power.bUpdateMcanMessage(poMcanMsg);
   eSpot_List3_Receptacle1_Charge_Receptacle_Facility.bUpdateMcanMessage(poMcanMsg);
   eSpot_List3_Receptacle2_Charge_Receptacle_Type.bUpdateMcanMessage(poMcanMsg);
   uiSpot_List3_Receptacle2_Available_Power.bUpdateMcanMessage(poMcanMsg);
   eSpot_List3_Receptacle2_Charge_Receptacle_Facility.bUpdateMcanMessage(poMcanMsg);
   eSpot_List3_Receptacle3_Charge_Receptacle_Type.bUpdateMcanMessage(poMcanMsg);
   uiSpot_List3_Receptacle3_Available_Power.bUpdateMcanMessage(poMcanMsg);
   eSpot_List3_Receptacle3_Charge_Receptacle_Facility.bUpdateMcanMessage(poMcanMsg);
   eSpot_List3_Receptacle4_Charge_Receptacle_Type.bUpdateMcanMessage(poMcanMsg);
   uiSpot_List3_Receptacle4_Available_Power.bUpdateMcanMessage(poMcanMsg);
   eSpot_List3_Receptacle4_Charge_Receptacle_Facility.bUpdateMcanMessage(poMcanMsg);
   eSpot_List3_Receptacle5_Charge_Receptacle_Type.bUpdateMcanMessage(poMcanMsg);
   uiSpot_List3_Receptacle5_Available_Power.bUpdateMcanMessage(poMcanMsg);
   eSpot_List3_Receptacle5_Charge_Receptacle_Facility.bUpdateMcanMessage(poMcanMsg);
   eSpot_List3_Receptacle6_Charge_Receptacle_Type.bUpdateMcanMessage(poMcanMsg);
   uiSpot_List3_Receptacle6_Available_Power.bUpdateMcanMessage(poMcanMsg);
   eSpot_List3_Receptacle6_Charge_Receptacle_Facility.bUpdateMcanMessage(poMcanMsg);
   eSpot_List3_Receptacle7_Charge_Receptacle_Type.bUpdateMcanMessage(poMcanMsg);
   uiSpot_List3_Receptacle7_Available_Power.bUpdateMcanMessage(poMcanMsg);
   eSpot_List3_Receptacle7_Charge_Receptacle_Facility.bUpdateMcanMessage(poMcanMsg);
   eSpot_List3_Receptacle8_Charge_Receptacle_Type.bUpdateMcanMessage(poMcanMsg);
   uiSpot_List3_Receptacle8_Available_Power.bUpdateMcanMessage(poMcanMsg);
   eSpot_List3_Receptacle8_Charge_Receptacle_Facility.bUpdateMcanMessage(poMcanMsg);
   eSpot_List3_Receptacle9_Charge_Receptacle_Type.bUpdateMcanMessage(poMcanMsg);
   uiSpot_List3_Receptacle9_Available_Power.bUpdateMcanMessage(poMcanMsg);
   eSpot_List3_Receptacle9_Charge_Receptacle_Facility.bUpdateMcanMessage(poMcanMsg);
   eSpot_List3_Receptacle10_Charge_Receptacle_Type.bUpdateMcanMessage(poMcanMsg);
   uiSpot_List3_Receptacle10_Available_Power.bUpdateMcanMessage(poMcanMsg);
   eSpot_List3_Receptacle10_Charge_Receptacle_Facility.bUpdateMcanMessage(poMcanMsg);
   strSpot_List4_Charge_Spot_ID.bUpdateMcanMessage(poMcanMsg);
   eSpot_List4_Bookable_Information.bUpdateMcanMessage(poMcanMsg);
   eSpot_List4_Spot_Availability.bUpdateMcanMessage(poMcanMsg);
   uiSpot_List4_Bookable_Free_Text_Length_of_Text.bUpdateMcanMessage(poMcanMsg);
   vstrSpot_List4_Bookable_Free_Text_Text_Info.bUpdateMcanMessage(poMcanMsg);
   uiSpot_List4_Total_Number_Receptacles.bUpdateMcanMessage(poMcanMsg);
   eSpot_List4_Receptacle1_Charge_Receptacle_Type.bUpdateMcanMessage(poMcanMsg);
   uiSpot_List4_Receptacle1_Available_Power.bUpdateMcanMessage(poMcanMsg);
   eSpot_List4_Receptacle1_Charge_Receptacle_Facility.bUpdateMcanMessage(poMcanMsg);
   eSpot_List4_Receptacle2_Charge_Receptacle_Type.bUpdateMcanMessage(poMcanMsg);
   uiSpot_List4_Receptacle2_Available_Power.bUpdateMcanMessage(poMcanMsg);
   eSpot_List4_Receptacle2_Charge_Receptacle_Facility.bUpdateMcanMessage(poMcanMsg);
   eSpot_List4_Receptacle3_Charge_Receptacle_Type.bUpdateMcanMessage(poMcanMsg);
   uiSpot_List4_Receptacle3_Available_Power.bUpdateMcanMessage(poMcanMsg);
   eSpot_List4_Receptacle3_Charge_Receptacle_Facility.bUpdateMcanMessage(poMcanMsg);
   eSpot_List4_Receptacle4_Charge_Receptacle_Type.bUpdateMcanMessage(poMcanMsg);
   uiSpot_List4_Receptacle4_Available_Power.bUpdateMcanMessage(poMcanMsg);
   eSpot_List4_Receptacle4_Charge_Receptacle_Facility.bUpdateMcanMessage(poMcanMsg);
   eSpot_List4_Receptacle5_Charge_Receptacle_Type.bUpdateMcanMessage(poMcanMsg);
   uiSpot_List4_Receptacle5_Available_Power.bUpdateMcanMessage(poMcanMsg);
   eSpot_List4_Receptacle5_Charge_Receptacle_Facility.bUpdateMcanMessage(poMcanMsg);
   eSpot_List4_Receptacle6_Charge_Receptacle_Type.bUpdateMcanMessage(poMcanMsg);
   uiSpot_List4_Receptacle6_Available_Power.bUpdateMcanMessage(poMcanMsg);
   eSpot_List4_Receptacle6_Charge_Receptacle_Facility.bUpdateMcanMessage(poMcanMsg);
   eSpot_List4_Receptacle7_Charge_Receptacle_Type.bUpdateMcanMessage(poMcanMsg);
   uiSpot_List4_Receptacle7_Available_Power.bUpdateMcanMessage(poMcanMsg);
   eSpot_List4_Receptacle7_Charge_Receptacle_Facility.bUpdateMcanMessage(poMcanMsg);
   eSpot_List4_Receptacle8_Charge_Receptacle_Type.bUpdateMcanMessage(poMcanMsg);
   uiSpot_List4_Receptacle8_Available_Power.bUpdateMcanMessage(poMcanMsg);
   eSpot_List4_Receptacle8_Charge_Receptacle_Facility.bUpdateMcanMessage(poMcanMsg);
   eSpot_List4_Receptacle9_Charge_Receptacle_Type.bUpdateMcanMessage(poMcanMsg);
   uiSpot_List4_Receptacle9_Available_Power.bUpdateMcanMessage(poMcanMsg);
   eSpot_List4_Receptacle9_Charge_Receptacle_Facility.bUpdateMcanMessage(poMcanMsg);
   eSpot_List4_Receptacle10_Charge_Receptacle_Type.bUpdateMcanMessage(poMcanMsg);
   uiSpot_List4_Receptacle10_Available_Power.bUpdateMcanMessage(poMcanMsg);
   eSpot_List4_Receptacle10_Charge_Receptacle_Facility.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Charge_Spot_List const& lhs, tcl_ITM_TCU_Charge_Spot_List const& rhs){
   if (lhs.uiTotal_pages_of_lists != rhs.uiTotal_pages_of_lists) return FALSE;
   if (lhs.uiPage_of_list != rhs.uiPage_of_list) return FALSE;
   if (lhs.uiStation_List_Number != rhs.uiStation_List_Number) return FALSE;
   if (lhs.strSpot_List1_Charge_Spot_ID != rhs.strSpot_List1_Charge_Spot_ID) return FALSE;
   if (lhs.eSpot_List1_Bookable_Information != rhs.eSpot_List1_Bookable_Information) return FALSE;
   if (lhs.eSpot_List1_Spot_Availability != rhs.eSpot_List1_Spot_Availability) return FALSE;
   if (lhs.uiSpot_List1_Bookable_Free_Text_Length_of_Text != rhs.uiSpot_List1_Bookable_Free_Text_Length_of_Text) return FALSE;
   if (lhs.vstrSpot_List1_Bookable_Free_Text_Text_Info != rhs.vstrSpot_List1_Bookable_Free_Text_Text_Info) return FALSE;
   if (lhs.uiSpot_List1_Total_Number_Receptacles != rhs.uiSpot_List1_Total_Number_Receptacles) return FALSE;
   if (lhs.eSpot_List1_Receptacle1_Charge_Receptacle_Type != rhs.eSpot_List1_Receptacle1_Charge_Receptacle_Type) return FALSE;
   if (lhs.uiSpot_List1_Receptacle1_Available_Power != rhs.uiSpot_List1_Receptacle1_Available_Power) return FALSE;
   if (lhs.eSpot_List1_Receptacle1_Charge_Receptacle_Facility != rhs.eSpot_List1_Receptacle1_Charge_Receptacle_Facility) return FALSE;
   if (lhs.eSpot_List1_Receptacle2_Charge_Receptacle_Type != rhs.eSpot_List1_Receptacle2_Charge_Receptacle_Type) return FALSE;
   if (lhs.uiSpot_List1_Receptacle2_Available_Power != rhs.uiSpot_List1_Receptacle2_Available_Power) return FALSE;
   if (lhs.eSpot_List1_Receptacle2_Charge_Receptacle_Facility != rhs.eSpot_List1_Receptacle2_Charge_Receptacle_Facility) return FALSE;
   if (lhs.eSpot_List1_Receptacle3_Charge_Receptacle_Type != rhs.eSpot_List1_Receptacle3_Charge_Receptacle_Type) return FALSE;
   if (lhs.uiSpot_List1_Receptacle3_Available_Power != rhs.uiSpot_List1_Receptacle3_Available_Power) return FALSE;
   if (lhs.eSpot_List1_Receptacle3_Charge_Receptacle_Facility != rhs.eSpot_List1_Receptacle3_Charge_Receptacle_Facility) return FALSE;
   if (lhs.eSpot_List1_Receptacle4_Charge_Receptacle_Type != rhs.eSpot_List1_Receptacle4_Charge_Receptacle_Type) return FALSE;
   if (lhs.uiSpot_List1_Receptacle4_Available_Power != rhs.uiSpot_List1_Receptacle4_Available_Power) return FALSE;
   if (lhs.eSpot_List1_Receptacle4_Charge_Receptacle_Facility != rhs.eSpot_List1_Receptacle4_Charge_Receptacle_Facility) return FALSE;
   if (lhs.eSpot_List1_Receptacle5_Charge_Receptacle_Type != rhs.eSpot_List1_Receptacle5_Charge_Receptacle_Type) return FALSE;
   if (lhs.uiSpot_List1_Receptacle5_Available_Power != rhs.uiSpot_List1_Receptacle5_Available_Power) return FALSE;
   if (lhs.eSpot_List1_Receptacle5_Charge_Receptacle_Facility != rhs.eSpot_List1_Receptacle5_Charge_Receptacle_Facility) return FALSE;
   if (lhs.eSpot_List1_Receptacle6_Charge_Receptacle_Type != rhs.eSpot_List1_Receptacle6_Charge_Receptacle_Type) return FALSE;
   if (lhs.uiSpot_List1_Receptacle6_Available_Power != rhs.uiSpot_List1_Receptacle6_Available_Power) return FALSE;
   if (lhs.eSpot_List1_Receptacle6_Charge_Receptacle_Facility != rhs.eSpot_List1_Receptacle6_Charge_Receptacle_Facility) return FALSE;
   if (lhs.eSpot_List1_Receptacle7_Charge_Receptacle_Type != rhs.eSpot_List1_Receptacle7_Charge_Receptacle_Type) return FALSE;
   if (lhs.uiSpot_List1_Receptacle7_Available_Power != rhs.uiSpot_List1_Receptacle7_Available_Power) return FALSE;
   if (lhs.eSpot_List1_Receptacle7_Charge_Receptacle_Facility != rhs.eSpot_List1_Receptacle7_Charge_Receptacle_Facility) return FALSE;
   if (lhs.eSpot_List1_Receptacle8_Charge_Receptacle_Type != rhs.eSpot_List1_Receptacle8_Charge_Receptacle_Type) return FALSE;
   if (lhs.uiSpot_List1_Receptacle8_Available_Power != rhs.uiSpot_List1_Receptacle8_Available_Power) return FALSE;
   if (lhs.eSpot_List1_Receptacle8_Charge_Receptacle_Facility != rhs.eSpot_List1_Receptacle8_Charge_Receptacle_Facility) return FALSE;
   if (lhs.eSpot_List1_Receptacle9_Charge_Receptacle_Type != rhs.eSpot_List1_Receptacle9_Charge_Receptacle_Type) return FALSE;
   if (lhs.uiSpot_List1_Receptacle9_Available_Power != rhs.uiSpot_List1_Receptacle9_Available_Power) return FALSE;
   if (lhs.eSpot_List1_Receptacle9_Charge_Receptacle_Facility != rhs.eSpot_List1_Receptacle9_Charge_Receptacle_Facility) return FALSE;
   if (lhs.eSpot_List1_Receptacle10_Charge_Receptacle_Type != rhs.eSpot_List1_Receptacle10_Charge_Receptacle_Type) return FALSE;
   if (lhs.uiSpot_List1_Receptacle10_Available_Power != rhs.uiSpot_List1_Receptacle10_Available_Power) return FALSE;
   if (lhs.eSpot_List1_Receptacle10_Charge_Receptacle_Facility != rhs.eSpot_List1_Receptacle10_Charge_Receptacle_Facility) return FALSE;
   if (lhs.strSpot_List2_Charge_Spot_ID != rhs.strSpot_List2_Charge_Spot_ID) return FALSE;
   if (lhs.eSpot_List2_Bookable_Information != rhs.eSpot_List2_Bookable_Information) return FALSE;
   if (lhs.eSpot_List2_Spot_Availability != rhs.eSpot_List2_Spot_Availability) return FALSE;
   if (lhs.uiSpot_List2_Bookable_Free_Text_Length_of_Text != rhs.uiSpot_List2_Bookable_Free_Text_Length_of_Text) return FALSE;
   if (lhs.vstrSpot_List2_Bookable_Free_Text_Text_Info != rhs.vstrSpot_List2_Bookable_Free_Text_Text_Info) return FALSE;
   if (lhs.uiSpot_List2_Total_Number_Receptacles != rhs.uiSpot_List2_Total_Number_Receptacles) return FALSE;
   if (lhs.eSpot_List2_Receptacle1_Charge_Receptacle_Type != rhs.eSpot_List2_Receptacle1_Charge_Receptacle_Type) return FALSE;
   if (lhs.uiSpot_List2_Receptacle1_Available_Power != rhs.uiSpot_List2_Receptacle1_Available_Power) return FALSE;
   if (lhs.eSpot_List2_Receptacle1_Charge_Receptacle_Facility != rhs.eSpot_List2_Receptacle1_Charge_Receptacle_Facility) return FALSE;
   if (lhs.eSpot_List2_Receptacle2_Charge_Receptacle_Type != rhs.eSpot_List2_Receptacle2_Charge_Receptacle_Type) return FALSE;
   if (lhs.uiSpot_List2_Receptacle2_Available_Power != rhs.uiSpot_List2_Receptacle2_Available_Power) return FALSE;
   if (lhs.eSpot_List2_Receptacle2_Charge_Receptacle_Facility != rhs.eSpot_List2_Receptacle2_Charge_Receptacle_Facility) return FALSE;
   if (lhs.eSpot_List2_Receptacle3_Charge_Receptacle_Type != rhs.eSpot_List2_Receptacle3_Charge_Receptacle_Type) return FALSE;
   if (lhs.uiSpot_List2_Receptacle3_Available_Power != rhs.uiSpot_List2_Receptacle3_Available_Power) return FALSE;
   if (lhs.eSpot_List2_Receptacle3_Charge_Receptacle_Facility != rhs.eSpot_List2_Receptacle3_Charge_Receptacle_Facility) return FALSE;
   if (lhs.eSpot_List2_Receptacle4_Charge_Receptacle_Type != rhs.eSpot_List2_Receptacle4_Charge_Receptacle_Type) return FALSE;
   if (lhs.uiSpot_List2_Receptacle4_Available_Power != rhs.uiSpot_List2_Receptacle4_Available_Power) return FALSE;
   if (lhs.eSpot_List2_Receptacle4_Charge_Receptacle_Facility != rhs.eSpot_List2_Receptacle4_Charge_Receptacle_Facility) return FALSE;
   if (lhs.eSpot_List2_Receptacle5_Charge_Receptacle_Type != rhs.eSpot_List2_Receptacle5_Charge_Receptacle_Type) return FALSE;
   if (lhs.uiSpot_List2_Receptacle5_Available_Power != rhs.uiSpot_List2_Receptacle5_Available_Power) return FALSE;
   if (lhs.eSpot_List2_Receptacle5_Charge_Receptacle_Facility != rhs.eSpot_List2_Receptacle5_Charge_Receptacle_Facility) return FALSE;
   if (lhs.eSpot_List2_Receptacle6_Charge_Receptacle_Type != rhs.eSpot_List2_Receptacle6_Charge_Receptacle_Type) return FALSE;
   if (lhs.uiSpot_List2_Receptacle6_Available_Power != rhs.uiSpot_List2_Receptacle6_Available_Power) return FALSE;
   if (lhs.eSpot_List2_Receptacle6_Charge_Receptacle_Facility != rhs.eSpot_List2_Receptacle6_Charge_Receptacle_Facility) return FALSE;
   if (lhs.eSpot_List2_Receptacle7_Charge_Receptacle_Type != rhs.eSpot_List2_Receptacle7_Charge_Receptacle_Type) return FALSE;
   if (lhs.uiSpot_List2_Receptacle7_Available_Power != rhs.uiSpot_List2_Receptacle7_Available_Power) return FALSE;
   if (lhs.eSpot_List2_Receptacle7_Charge_Receptacle_Facility != rhs.eSpot_List2_Receptacle7_Charge_Receptacle_Facility) return FALSE;
   if (lhs.eSpot_List2_Receptacle8_Charge_Receptacle_Type != rhs.eSpot_List2_Receptacle8_Charge_Receptacle_Type) return FALSE;
   if (lhs.uiSpot_List2_Receptacle8_Available_Power != rhs.uiSpot_List2_Receptacle8_Available_Power) return FALSE;
   if (lhs.eSpot_List2_Receptacle8_Charge_Receptacle_Facility != rhs.eSpot_List2_Receptacle8_Charge_Receptacle_Facility) return FALSE;
   if (lhs.eSpot_List2_Receptacle9_Charge_Receptacle_Type != rhs.eSpot_List2_Receptacle9_Charge_Receptacle_Type) return FALSE;
   if (lhs.uiSpot_List2_Receptacle9_Available_Power != rhs.uiSpot_List2_Receptacle9_Available_Power) return FALSE;
   if (lhs.eSpot_List2_Receptacle9_Charge_Receptacle_Facility != rhs.eSpot_List2_Receptacle9_Charge_Receptacle_Facility) return FALSE;
   if (lhs.eSpot_List2_Receptacle10_Charge_Receptacle_Type != rhs.eSpot_List2_Receptacle10_Charge_Receptacle_Type) return FALSE;
   if (lhs.uiSpot_List2_Receptacle10_Available_Power != rhs.uiSpot_List2_Receptacle10_Available_Power) return FALSE;
   if (lhs.eSpot_List2_Receptacle10_Charge_Receptacle_Facility != rhs.eSpot_List2_Receptacle10_Charge_Receptacle_Facility) return FALSE;
   if (lhs.strSpot_List3_Charge_Spot_ID != rhs.strSpot_List3_Charge_Spot_ID) return FALSE;
   if (lhs.eSpot_List3_Bookable_Information != rhs.eSpot_List3_Bookable_Information) return FALSE;
   if (lhs.eSpot_List3_Spot_Availability != rhs.eSpot_List3_Spot_Availability) return FALSE;
   if (lhs.uiSpot_List3_Bookable_Free_Text_Length_of_Text != rhs.uiSpot_List3_Bookable_Free_Text_Length_of_Text) return FALSE;
   if (lhs.vstrSpot_List3_Bookable_Free_Text_Text_Info != rhs.vstrSpot_List3_Bookable_Free_Text_Text_Info) return FALSE;
   if (lhs.uiSpot_List3_Total_Number_Receptacles != rhs.uiSpot_List3_Total_Number_Receptacles) return FALSE;
   if (lhs.eSpot_List3_Receptacle1_Charge_Receptacle_Type != rhs.eSpot_List3_Receptacle1_Charge_Receptacle_Type) return FALSE;
   if (lhs.uiSpot_List3_Receptacle1_Available_Power != rhs.uiSpot_List3_Receptacle1_Available_Power) return FALSE;
   if (lhs.eSpot_List3_Receptacle1_Charge_Receptacle_Facility != rhs.eSpot_List3_Receptacle1_Charge_Receptacle_Facility) return FALSE;
   if (lhs.eSpot_List3_Receptacle2_Charge_Receptacle_Type != rhs.eSpot_List3_Receptacle2_Charge_Receptacle_Type) return FALSE;
   if (lhs.uiSpot_List3_Receptacle2_Available_Power != rhs.uiSpot_List3_Receptacle2_Available_Power) return FALSE;
   if (lhs.eSpot_List3_Receptacle2_Charge_Receptacle_Facility != rhs.eSpot_List3_Receptacle2_Charge_Receptacle_Facility) return FALSE;
   if (lhs.eSpot_List3_Receptacle3_Charge_Receptacle_Type != rhs.eSpot_List3_Receptacle3_Charge_Receptacle_Type) return FALSE;
   if (lhs.uiSpot_List3_Receptacle3_Available_Power != rhs.uiSpot_List3_Receptacle3_Available_Power) return FALSE;
   if (lhs.eSpot_List3_Receptacle3_Charge_Receptacle_Facility != rhs.eSpot_List3_Receptacle3_Charge_Receptacle_Facility) return FALSE;
   if (lhs.eSpot_List3_Receptacle4_Charge_Receptacle_Type != rhs.eSpot_List3_Receptacle4_Charge_Receptacle_Type) return FALSE;
   if (lhs.uiSpot_List3_Receptacle4_Available_Power != rhs.uiSpot_List3_Receptacle4_Available_Power) return FALSE;
   if (lhs.eSpot_List3_Receptacle4_Charge_Receptacle_Facility != rhs.eSpot_List3_Receptacle4_Charge_Receptacle_Facility) return FALSE;
   if (lhs.eSpot_List3_Receptacle5_Charge_Receptacle_Type != rhs.eSpot_List3_Receptacle5_Charge_Receptacle_Type) return FALSE;
   if (lhs.uiSpot_List3_Receptacle5_Available_Power != rhs.uiSpot_List3_Receptacle5_Available_Power) return FALSE;
   if (lhs.eSpot_List3_Receptacle5_Charge_Receptacle_Facility != rhs.eSpot_List3_Receptacle5_Charge_Receptacle_Facility) return FALSE;
   if (lhs.eSpot_List3_Receptacle6_Charge_Receptacle_Type != rhs.eSpot_List3_Receptacle6_Charge_Receptacle_Type) return FALSE;
   if (lhs.uiSpot_List3_Receptacle6_Available_Power != rhs.uiSpot_List3_Receptacle6_Available_Power) return FALSE;
   if (lhs.eSpot_List3_Receptacle6_Charge_Receptacle_Facility != rhs.eSpot_List3_Receptacle6_Charge_Receptacle_Facility) return FALSE;
   if (lhs.eSpot_List3_Receptacle7_Charge_Receptacle_Type != rhs.eSpot_List3_Receptacle7_Charge_Receptacle_Type) return FALSE;
   if (lhs.uiSpot_List3_Receptacle7_Available_Power != rhs.uiSpot_List3_Receptacle7_Available_Power) return FALSE;
   if (lhs.eSpot_List3_Receptacle7_Charge_Receptacle_Facility != rhs.eSpot_List3_Receptacle7_Charge_Receptacle_Facility) return FALSE;
   if (lhs.eSpot_List3_Receptacle8_Charge_Receptacle_Type != rhs.eSpot_List3_Receptacle8_Charge_Receptacle_Type) return FALSE;
   if (lhs.uiSpot_List3_Receptacle8_Available_Power != rhs.uiSpot_List3_Receptacle8_Available_Power) return FALSE;
   if (lhs.eSpot_List3_Receptacle8_Charge_Receptacle_Facility != rhs.eSpot_List3_Receptacle8_Charge_Receptacle_Facility) return FALSE;
   if (lhs.eSpot_List3_Receptacle9_Charge_Receptacle_Type != rhs.eSpot_List3_Receptacle9_Charge_Receptacle_Type) return FALSE;
   if (lhs.uiSpot_List3_Receptacle9_Available_Power != rhs.uiSpot_List3_Receptacle9_Available_Power) return FALSE;
   if (lhs.eSpot_List3_Receptacle9_Charge_Receptacle_Facility != rhs.eSpot_List3_Receptacle9_Charge_Receptacle_Facility) return FALSE;
   if (lhs.eSpot_List3_Receptacle10_Charge_Receptacle_Type != rhs.eSpot_List3_Receptacle10_Charge_Receptacle_Type) return FALSE;
   if (lhs.uiSpot_List3_Receptacle10_Available_Power != rhs.uiSpot_List3_Receptacle10_Available_Power) return FALSE;
   if (lhs.eSpot_List3_Receptacle10_Charge_Receptacle_Facility != rhs.eSpot_List3_Receptacle10_Charge_Receptacle_Facility) return FALSE;
   if (lhs.strSpot_List4_Charge_Spot_ID != rhs.strSpot_List4_Charge_Spot_ID) return FALSE;
   if (lhs.eSpot_List4_Bookable_Information != rhs.eSpot_List4_Bookable_Information) return FALSE;
   if (lhs.eSpot_List4_Spot_Availability != rhs.eSpot_List4_Spot_Availability) return FALSE;
   if (lhs.uiSpot_List4_Bookable_Free_Text_Length_of_Text != rhs.uiSpot_List4_Bookable_Free_Text_Length_of_Text) return FALSE;
   if (lhs.vstrSpot_List4_Bookable_Free_Text_Text_Info != rhs.vstrSpot_List4_Bookable_Free_Text_Text_Info) return FALSE;
   if (lhs.uiSpot_List4_Total_Number_Receptacles != rhs.uiSpot_List4_Total_Number_Receptacles) return FALSE;
   if (lhs.eSpot_List4_Receptacle1_Charge_Receptacle_Type != rhs.eSpot_List4_Receptacle1_Charge_Receptacle_Type) return FALSE;
   if (lhs.uiSpot_List4_Receptacle1_Available_Power != rhs.uiSpot_List4_Receptacle1_Available_Power) return FALSE;
   if (lhs.eSpot_List4_Receptacle1_Charge_Receptacle_Facility != rhs.eSpot_List4_Receptacle1_Charge_Receptacle_Facility) return FALSE;
   if (lhs.eSpot_List4_Receptacle2_Charge_Receptacle_Type != rhs.eSpot_List4_Receptacle2_Charge_Receptacle_Type) return FALSE;
   if (lhs.uiSpot_List4_Receptacle2_Available_Power != rhs.uiSpot_List4_Receptacle2_Available_Power) return FALSE;
   if (lhs.eSpot_List4_Receptacle2_Charge_Receptacle_Facility != rhs.eSpot_List4_Receptacle2_Charge_Receptacle_Facility) return FALSE;
   if (lhs.eSpot_List4_Receptacle3_Charge_Receptacle_Type != rhs.eSpot_List4_Receptacle3_Charge_Receptacle_Type) return FALSE;
   if (lhs.uiSpot_List4_Receptacle3_Available_Power != rhs.uiSpot_List4_Receptacle3_Available_Power) return FALSE;
   if (lhs.eSpot_List4_Receptacle3_Charge_Receptacle_Facility != rhs.eSpot_List4_Receptacle3_Charge_Receptacle_Facility) return FALSE;
   if (lhs.eSpot_List4_Receptacle4_Charge_Receptacle_Type != rhs.eSpot_List4_Receptacle4_Charge_Receptacle_Type) return FALSE;
   if (lhs.uiSpot_List4_Receptacle4_Available_Power != rhs.uiSpot_List4_Receptacle4_Available_Power) return FALSE;
   if (lhs.eSpot_List4_Receptacle4_Charge_Receptacle_Facility != rhs.eSpot_List4_Receptacle4_Charge_Receptacle_Facility) return FALSE;
   if (lhs.eSpot_List4_Receptacle5_Charge_Receptacle_Type != rhs.eSpot_List4_Receptacle5_Charge_Receptacle_Type) return FALSE;
   if (lhs.uiSpot_List4_Receptacle5_Available_Power != rhs.uiSpot_List4_Receptacle5_Available_Power) return FALSE;
   if (lhs.eSpot_List4_Receptacle5_Charge_Receptacle_Facility != rhs.eSpot_List4_Receptacle5_Charge_Receptacle_Facility) return FALSE;
   if (lhs.eSpot_List4_Receptacle6_Charge_Receptacle_Type != rhs.eSpot_List4_Receptacle6_Charge_Receptacle_Type) return FALSE;
   if (lhs.uiSpot_List4_Receptacle6_Available_Power != rhs.uiSpot_List4_Receptacle6_Available_Power) return FALSE;
   if (lhs.eSpot_List4_Receptacle6_Charge_Receptacle_Facility != rhs.eSpot_List4_Receptacle6_Charge_Receptacle_Facility) return FALSE;
   if (lhs.eSpot_List4_Receptacle7_Charge_Receptacle_Type != rhs.eSpot_List4_Receptacle7_Charge_Receptacle_Type) return FALSE;
   if (lhs.uiSpot_List4_Receptacle7_Available_Power != rhs.uiSpot_List4_Receptacle7_Available_Power) return FALSE;
   if (lhs.eSpot_List4_Receptacle7_Charge_Receptacle_Facility != rhs.eSpot_List4_Receptacle7_Charge_Receptacle_Facility) return FALSE;
   if (lhs.eSpot_List4_Receptacle8_Charge_Receptacle_Type != rhs.eSpot_List4_Receptacle8_Charge_Receptacle_Type) return FALSE;
   if (lhs.uiSpot_List4_Receptacle8_Available_Power != rhs.uiSpot_List4_Receptacle8_Available_Power) return FALSE;
   if (lhs.eSpot_List4_Receptacle8_Charge_Receptacle_Facility != rhs.eSpot_List4_Receptacle8_Charge_Receptacle_Facility) return FALSE;
   if (lhs.eSpot_List4_Receptacle9_Charge_Receptacle_Type != rhs.eSpot_List4_Receptacle9_Charge_Receptacle_Type) return FALSE;
   if (lhs.uiSpot_List4_Receptacle9_Available_Power != rhs.uiSpot_List4_Receptacle9_Available_Power) return FALSE;
   if (lhs.eSpot_List4_Receptacle9_Charge_Receptacle_Facility != rhs.eSpot_List4_Receptacle9_Charge_Receptacle_Facility) return FALSE;
   if (lhs.eSpot_List4_Receptacle10_Charge_Receptacle_Type != rhs.eSpot_List4_Receptacle10_Charge_Receptacle_Type) return FALSE;
   if (lhs.uiSpot_List4_Receptacle10_Available_Power != rhs.uiSpot_List4_Receptacle10_Available_Power) return FALSE;
   if (lhs.eSpot_List4_Receptacle10_Charge_Receptacle_Facility != rhs.eSpot_List4_Receptacle10_Charge_Receptacle_Facility) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Charge_Spot_List const& lhs, tcl_ITM_TCU_Charge_Spot_List const& rhs){
    if (
         (lhs.uiTotal_pages_of_lists == rhs.uiTotal_pages_of_lists)
      && (lhs.uiPage_of_list == rhs.uiPage_of_list)
      && (lhs.uiStation_List_Number == rhs.uiStation_List_Number)
      && (lhs.strSpot_List1_Charge_Spot_ID == rhs.strSpot_List1_Charge_Spot_ID)
      && (lhs.eSpot_List1_Bookable_Information == rhs.eSpot_List1_Bookable_Information)
      && (lhs.eSpot_List1_Spot_Availability == rhs.eSpot_List1_Spot_Availability)
      && (lhs.uiSpot_List1_Bookable_Free_Text_Length_of_Text == rhs.uiSpot_List1_Bookable_Free_Text_Length_of_Text)
      && (lhs.vstrSpot_List1_Bookable_Free_Text_Text_Info == rhs.vstrSpot_List1_Bookable_Free_Text_Text_Info)
      && (lhs.uiSpot_List1_Total_Number_Receptacles == rhs.uiSpot_List1_Total_Number_Receptacles)
      && (lhs.eSpot_List1_Receptacle1_Charge_Receptacle_Type == rhs.eSpot_List1_Receptacle1_Charge_Receptacle_Type)
      && (lhs.uiSpot_List1_Receptacle1_Available_Power == rhs.uiSpot_List1_Receptacle1_Available_Power)
      && (lhs.eSpot_List1_Receptacle1_Charge_Receptacle_Facility == rhs.eSpot_List1_Receptacle1_Charge_Receptacle_Facility)
      && (lhs.eSpot_List1_Receptacle2_Charge_Receptacle_Type == rhs.eSpot_List1_Receptacle2_Charge_Receptacle_Type)
      && (lhs.uiSpot_List1_Receptacle2_Available_Power == rhs.uiSpot_List1_Receptacle2_Available_Power)
      && (lhs.eSpot_List1_Receptacle2_Charge_Receptacle_Facility == rhs.eSpot_List1_Receptacle2_Charge_Receptacle_Facility)
      && (lhs.eSpot_List1_Receptacle3_Charge_Receptacle_Type == rhs.eSpot_List1_Receptacle3_Charge_Receptacle_Type)
      && (lhs.uiSpot_List1_Receptacle3_Available_Power == rhs.uiSpot_List1_Receptacle3_Available_Power)
      && (lhs.eSpot_List1_Receptacle3_Charge_Receptacle_Facility == rhs.eSpot_List1_Receptacle3_Charge_Receptacle_Facility)
      && (lhs.eSpot_List1_Receptacle4_Charge_Receptacle_Type == rhs.eSpot_List1_Receptacle4_Charge_Receptacle_Type)
      && (lhs.uiSpot_List1_Receptacle4_Available_Power == rhs.uiSpot_List1_Receptacle4_Available_Power)
      && (lhs.eSpot_List1_Receptacle4_Charge_Receptacle_Facility == rhs.eSpot_List1_Receptacle4_Charge_Receptacle_Facility)
      && (lhs.eSpot_List1_Receptacle5_Charge_Receptacle_Type == rhs.eSpot_List1_Receptacle5_Charge_Receptacle_Type)
      && (lhs.uiSpot_List1_Receptacle5_Available_Power == rhs.uiSpot_List1_Receptacle5_Available_Power)
      && (lhs.eSpot_List1_Receptacle5_Charge_Receptacle_Facility == rhs.eSpot_List1_Receptacle5_Charge_Receptacle_Facility)
      && (lhs.eSpot_List1_Receptacle6_Charge_Receptacle_Type == rhs.eSpot_List1_Receptacle6_Charge_Receptacle_Type)
      && (lhs.uiSpot_List1_Receptacle6_Available_Power == rhs.uiSpot_List1_Receptacle6_Available_Power)
      && (lhs.eSpot_List1_Receptacle6_Charge_Receptacle_Facility == rhs.eSpot_List1_Receptacle6_Charge_Receptacle_Facility)
      && (lhs.eSpot_List1_Receptacle7_Charge_Receptacle_Type == rhs.eSpot_List1_Receptacle7_Charge_Receptacle_Type)
      && (lhs.uiSpot_List1_Receptacle7_Available_Power == rhs.uiSpot_List1_Receptacle7_Available_Power)
      && (lhs.eSpot_List1_Receptacle7_Charge_Receptacle_Facility == rhs.eSpot_List1_Receptacle7_Charge_Receptacle_Facility)
      && (lhs.eSpot_List1_Receptacle8_Charge_Receptacle_Type == rhs.eSpot_List1_Receptacle8_Charge_Receptacle_Type)
      && (lhs.uiSpot_List1_Receptacle8_Available_Power == rhs.uiSpot_List1_Receptacle8_Available_Power)
      && (lhs.eSpot_List1_Receptacle8_Charge_Receptacle_Facility == rhs.eSpot_List1_Receptacle8_Charge_Receptacle_Facility)
      && (lhs.eSpot_List1_Receptacle9_Charge_Receptacle_Type == rhs.eSpot_List1_Receptacle9_Charge_Receptacle_Type)
      && (lhs.uiSpot_List1_Receptacle9_Available_Power == rhs.uiSpot_List1_Receptacle9_Available_Power)
      && (lhs.eSpot_List1_Receptacle9_Charge_Receptacle_Facility == rhs.eSpot_List1_Receptacle9_Charge_Receptacle_Facility)
      && (lhs.eSpot_List1_Receptacle10_Charge_Receptacle_Type == rhs.eSpot_List1_Receptacle10_Charge_Receptacle_Type)
      && (lhs.uiSpot_List1_Receptacle10_Available_Power == rhs.uiSpot_List1_Receptacle10_Available_Power)
      && (lhs.eSpot_List1_Receptacle10_Charge_Receptacle_Facility == rhs.eSpot_List1_Receptacle10_Charge_Receptacle_Facility)
      && (lhs.strSpot_List2_Charge_Spot_ID == rhs.strSpot_List2_Charge_Spot_ID)
      && (lhs.eSpot_List2_Bookable_Information == rhs.eSpot_List2_Bookable_Information)
      && (lhs.eSpot_List2_Spot_Availability == rhs.eSpot_List2_Spot_Availability)
      && (lhs.uiSpot_List2_Bookable_Free_Text_Length_of_Text == rhs.uiSpot_List2_Bookable_Free_Text_Length_of_Text)
      && (lhs.vstrSpot_List2_Bookable_Free_Text_Text_Info == rhs.vstrSpot_List2_Bookable_Free_Text_Text_Info)
      && (lhs.uiSpot_List2_Total_Number_Receptacles == rhs.uiSpot_List2_Total_Number_Receptacles)
      && (lhs.eSpot_List2_Receptacle1_Charge_Receptacle_Type == rhs.eSpot_List2_Receptacle1_Charge_Receptacle_Type)
      && (lhs.uiSpot_List2_Receptacle1_Available_Power == rhs.uiSpot_List2_Receptacle1_Available_Power)
      && (lhs.eSpot_List2_Receptacle1_Charge_Receptacle_Facility == rhs.eSpot_List2_Receptacle1_Charge_Receptacle_Facility)
      && (lhs.eSpot_List2_Receptacle2_Charge_Receptacle_Type == rhs.eSpot_List2_Receptacle2_Charge_Receptacle_Type)
      && (lhs.uiSpot_List2_Receptacle2_Available_Power == rhs.uiSpot_List2_Receptacle2_Available_Power)
      && (lhs.eSpot_List2_Receptacle2_Charge_Receptacle_Facility == rhs.eSpot_List2_Receptacle2_Charge_Receptacle_Facility)
      && (lhs.eSpot_List2_Receptacle3_Charge_Receptacle_Type == rhs.eSpot_List2_Receptacle3_Charge_Receptacle_Type)
      && (lhs.uiSpot_List2_Receptacle3_Available_Power == rhs.uiSpot_List2_Receptacle3_Available_Power)
      && (lhs.eSpot_List2_Receptacle3_Charge_Receptacle_Facility == rhs.eSpot_List2_Receptacle3_Charge_Receptacle_Facility)
      && (lhs.eSpot_List2_Receptacle4_Charge_Receptacle_Type == rhs.eSpot_List2_Receptacle4_Charge_Receptacle_Type)
      && (lhs.uiSpot_List2_Receptacle4_Available_Power == rhs.uiSpot_List2_Receptacle4_Available_Power)
      && (lhs.eSpot_List2_Receptacle4_Charge_Receptacle_Facility == rhs.eSpot_List2_Receptacle4_Charge_Receptacle_Facility)
      && (lhs.eSpot_List2_Receptacle5_Charge_Receptacle_Type == rhs.eSpot_List2_Receptacle5_Charge_Receptacle_Type)
      && (lhs.uiSpot_List2_Receptacle5_Available_Power == rhs.uiSpot_List2_Receptacle5_Available_Power)
      && (lhs.eSpot_List2_Receptacle5_Charge_Receptacle_Facility == rhs.eSpot_List2_Receptacle5_Charge_Receptacle_Facility)
      && (lhs.eSpot_List2_Receptacle6_Charge_Receptacle_Type == rhs.eSpot_List2_Receptacle6_Charge_Receptacle_Type)
      && (lhs.uiSpot_List2_Receptacle6_Available_Power == rhs.uiSpot_List2_Receptacle6_Available_Power)
      && (lhs.eSpot_List2_Receptacle6_Charge_Receptacle_Facility == rhs.eSpot_List2_Receptacle6_Charge_Receptacle_Facility)
      && (lhs.eSpot_List2_Receptacle7_Charge_Receptacle_Type == rhs.eSpot_List2_Receptacle7_Charge_Receptacle_Type)
      && (lhs.uiSpot_List2_Receptacle7_Available_Power == rhs.uiSpot_List2_Receptacle7_Available_Power)
      && (lhs.eSpot_List2_Receptacle7_Charge_Receptacle_Facility == rhs.eSpot_List2_Receptacle7_Charge_Receptacle_Facility)
      && (lhs.eSpot_List2_Receptacle8_Charge_Receptacle_Type == rhs.eSpot_List2_Receptacle8_Charge_Receptacle_Type)
      && (lhs.uiSpot_List2_Receptacle8_Available_Power == rhs.uiSpot_List2_Receptacle8_Available_Power)
      && (lhs.eSpot_List2_Receptacle8_Charge_Receptacle_Facility == rhs.eSpot_List2_Receptacle8_Charge_Receptacle_Facility)
      && (lhs.eSpot_List2_Receptacle9_Charge_Receptacle_Type == rhs.eSpot_List2_Receptacle9_Charge_Receptacle_Type)
      && (lhs.uiSpot_List2_Receptacle9_Available_Power == rhs.uiSpot_List2_Receptacle9_Available_Power)
      && (lhs.eSpot_List2_Receptacle9_Charge_Receptacle_Facility == rhs.eSpot_List2_Receptacle9_Charge_Receptacle_Facility)
      && (lhs.eSpot_List2_Receptacle10_Charge_Receptacle_Type == rhs.eSpot_List2_Receptacle10_Charge_Receptacle_Type)
      && (lhs.uiSpot_List2_Receptacle10_Available_Power == rhs.uiSpot_List2_Receptacle10_Available_Power)
      && (lhs.eSpot_List2_Receptacle10_Charge_Receptacle_Facility == rhs.eSpot_List2_Receptacle10_Charge_Receptacle_Facility)
      && (lhs.strSpot_List3_Charge_Spot_ID == rhs.strSpot_List3_Charge_Spot_ID)
      && (lhs.eSpot_List3_Bookable_Information == rhs.eSpot_List3_Bookable_Information)
      && (lhs.eSpot_List3_Spot_Availability == rhs.eSpot_List3_Spot_Availability)
      && (lhs.uiSpot_List3_Bookable_Free_Text_Length_of_Text == rhs.uiSpot_List3_Bookable_Free_Text_Length_of_Text)
      && (lhs.vstrSpot_List3_Bookable_Free_Text_Text_Info == rhs.vstrSpot_List3_Bookable_Free_Text_Text_Info)
      && (lhs.uiSpot_List3_Total_Number_Receptacles == rhs.uiSpot_List3_Total_Number_Receptacles)
      && (lhs.eSpot_List3_Receptacle1_Charge_Receptacle_Type == rhs.eSpot_List3_Receptacle1_Charge_Receptacle_Type)
      && (lhs.uiSpot_List3_Receptacle1_Available_Power == rhs.uiSpot_List3_Receptacle1_Available_Power)
      && (lhs.eSpot_List3_Receptacle1_Charge_Receptacle_Facility == rhs.eSpot_List3_Receptacle1_Charge_Receptacle_Facility)
      && (lhs.eSpot_List3_Receptacle2_Charge_Receptacle_Type == rhs.eSpot_List3_Receptacle2_Charge_Receptacle_Type)
      && (lhs.uiSpot_List3_Receptacle2_Available_Power == rhs.uiSpot_List3_Receptacle2_Available_Power)
      && (lhs.eSpot_List3_Receptacle2_Charge_Receptacle_Facility == rhs.eSpot_List3_Receptacle2_Charge_Receptacle_Facility)
      && (lhs.eSpot_List3_Receptacle3_Charge_Receptacle_Type == rhs.eSpot_List3_Receptacle3_Charge_Receptacle_Type)
      && (lhs.uiSpot_List3_Receptacle3_Available_Power == rhs.uiSpot_List3_Receptacle3_Available_Power)
      && (lhs.eSpot_List3_Receptacle3_Charge_Receptacle_Facility == rhs.eSpot_List3_Receptacle3_Charge_Receptacle_Facility)
      && (lhs.eSpot_List3_Receptacle4_Charge_Receptacle_Type == rhs.eSpot_List3_Receptacle4_Charge_Receptacle_Type)
      && (lhs.uiSpot_List3_Receptacle4_Available_Power == rhs.uiSpot_List3_Receptacle4_Available_Power)
      && (lhs.eSpot_List3_Receptacle4_Charge_Receptacle_Facility == rhs.eSpot_List3_Receptacle4_Charge_Receptacle_Facility)
      && (lhs.eSpot_List3_Receptacle5_Charge_Receptacle_Type == rhs.eSpot_List3_Receptacle5_Charge_Receptacle_Type)
      && (lhs.uiSpot_List3_Receptacle5_Available_Power == rhs.uiSpot_List3_Receptacle5_Available_Power)
      && (lhs.eSpot_List3_Receptacle5_Charge_Receptacle_Facility == rhs.eSpot_List3_Receptacle5_Charge_Receptacle_Facility)
      && (lhs.eSpot_List3_Receptacle6_Charge_Receptacle_Type == rhs.eSpot_List3_Receptacle6_Charge_Receptacle_Type)
      && (lhs.uiSpot_List3_Receptacle6_Available_Power == rhs.uiSpot_List3_Receptacle6_Available_Power)
      && (lhs.eSpot_List3_Receptacle6_Charge_Receptacle_Facility == rhs.eSpot_List3_Receptacle6_Charge_Receptacle_Facility)
      && (lhs.eSpot_List3_Receptacle7_Charge_Receptacle_Type == rhs.eSpot_List3_Receptacle7_Charge_Receptacle_Type)
      && (lhs.uiSpot_List3_Receptacle7_Available_Power == rhs.uiSpot_List3_Receptacle7_Available_Power)
      && (lhs.eSpot_List3_Receptacle7_Charge_Receptacle_Facility == rhs.eSpot_List3_Receptacle7_Charge_Receptacle_Facility)
      && (lhs.eSpot_List3_Receptacle8_Charge_Receptacle_Type == rhs.eSpot_List3_Receptacle8_Charge_Receptacle_Type)
      && (lhs.uiSpot_List3_Receptacle8_Available_Power == rhs.uiSpot_List3_Receptacle8_Available_Power)
      && (lhs.eSpot_List3_Receptacle8_Charge_Receptacle_Facility == rhs.eSpot_List3_Receptacle8_Charge_Receptacle_Facility)
      && (lhs.eSpot_List3_Receptacle9_Charge_Receptacle_Type == rhs.eSpot_List3_Receptacle9_Charge_Receptacle_Type)
      && (lhs.uiSpot_List3_Receptacle9_Available_Power == rhs.uiSpot_List3_Receptacle9_Available_Power)
      && (lhs.eSpot_List3_Receptacle9_Charge_Receptacle_Facility == rhs.eSpot_List3_Receptacle9_Charge_Receptacle_Facility)
      && (lhs.eSpot_List3_Receptacle10_Charge_Receptacle_Type == rhs.eSpot_List3_Receptacle10_Charge_Receptacle_Type)
      && (lhs.uiSpot_List3_Receptacle10_Available_Power == rhs.uiSpot_List3_Receptacle10_Available_Power)
      && (lhs.eSpot_List3_Receptacle10_Charge_Receptacle_Facility == rhs.eSpot_List3_Receptacle10_Charge_Receptacle_Facility)
      && (lhs.strSpot_List4_Charge_Spot_ID == rhs.strSpot_List4_Charge_Spot_ID)
      && (lhs.eSpot_List4_Bookable_Information == rhs.eSpot_List4_Bookable_Information)
      && (lhs.eSpot_List4_Spot_Availability == rhs.eSpot_List4_Spot_Availability)
      && (lhs.uiSpot_List4_Bookable_Free_Text_Length_of_Text == rhs.uiSpot_List4_Bookable_Free_Text_Length_of_Text)
      && (lhs.vstrSpot_List4_Bookable_Free_Text_Text_Info == rhs.vstrSpot_List4_Bookable_Free_Text_Text_Info)
      && (lhs.uiSpot_List4_Total_Number_Receptacles == rhs.uiSpot_List4_Total_Number_Receptacles)
      && (lhs.eSpot_List4_Receptacle1_Charge_Receptacle_Type == rhs.eSpot_List4_Receptacle1_Charge_Receptacle_Type)
      && (lhs.uiSpot_List4_Receptacle1_Available_Power == rhs.uiSpot_List4_Receptacle1_Available_Power)
      && (lhs.eSpot_List4_Receptacle1_Charge_Receptacle_Facility == rhs.eSpot_List4_Receptacle1_Charge_Receptacle_Facility)
      && (lhs.eSpot_List4_Receptacle2_Charge_Receptacle_Type == rhs.eSpot_List4_Receptacle2_Charge_Receptacle_Type)
      && (lhs.uiSpot_List4_Receptacle2_Available_Power == rhs.uiSpot_List4_Receptacle2_Available_Power)
      && (lhs.eSpot_List4_Receptacle2_Charge_Receptacle_Facility == rhs.eSpot_List4_Receptacle2_Charge_Receptacle_Facility)
      && (lhs.eSpot_List4_Receptacle3_Charge_Receptacle_Type == rhs.eSpot_List4_Receptacle3_Charge_Receptacle_Type)
      && (lhs.uiSpot_List4_Receptacle3_Available_Power == rhs.uiSpot_List4_Receptacle3_Available_Power)
      && (lhs.eSpot_List4_Receptacle3_Charge_Receptacle_Facility == rhs.eSpot_List4_Receptacle3_Charge_Receptacle_Facility)
      && (lhs.eSpot_List4_Receptacle4_Charge_Receptacle_Type == rhs.eSpot_List4_Receptacle4_Charge_Receptacle_Type)
      && (lhs.uiSpot_List4_Receptacle4_Available_Power == rhs.uiSpot_List4_Receptacle4_Available_Power)
      && (lhs.eSpot_List4_Receptacle4_Charge_Receptacle_Facility == rhs.eSpot_List4_Receptacle4_Charge_Receptacle_Facility)
      && (lhs.eSpot_List4_Receptacle5_Charge_Receptacle_Type == rhs.eSpot_List4_Receptacle5_Charge_Receptacle_Type)
      && (lhs.uiSpot_List4_Receptacle5_Available_Power == rhs.uiSpot_List4_Receptacle5_Available_Power)
      && (lhs.eSpot_List4_Receptacle5_Charge_Receptacle_Facility == rhs.eSpot_List4_Receptacle5_Charge_Receptacle_Facility)
      && (lhs.eSpot_List4_Receptacle6_Charge_Receptacle_Type == rhs.eSpot_List4_Receptacle6_Charge_Receptacle_Type)
      && (lhs.uiSpot_List4_Receptacle6_Available_Power == rhs.uiSpot_List4_Receptacle6_Available_Power)
      && (lhs.eSpot_List4_Receptacle6_Charge_Receptacle_Facility == rhs.eSpot_List4_Receptacle6_Charge_Receptacle_Facility)
      && (lhs.eSpot_List4_Receptacle7_Charge_Receptacle_Type == rhs.eSpot_List4_Receptacle7_Charge_Receptacle_Type)
      && (lhs.uiSpot_List4_Receptacle7_Available_Power == rhs.uiSpot_List4_Receptacle7_Available_Power)
      && (lhs.eSpot_List4_Receptacle7_Charge_Receptacle_Facility == rhs.eSpot_List4_Receptacle7_Charge_Receptacle_Facility)
      && (lhs.eSpot_List4_Receptacle8_Charge_Receptacle_Type == rhs.eSpot_List4_Receptacle8_Charge_Receptacle_Type)
      && (lhs.uiSpot_List4_Receptacle8_Available_Power == rhs.uiSpot_List4_Receptacle8_Available_Power)
      && (lhs.eSpot_List4_Receptacle8_Charge_Receptacle_Facility == rhs.eSpot_List4_Receptacle8_Charge_Receptacle_Facility)
      && (lhs.eSpot_List4_Receptacle9_Charge_Receptacle_Type == rhs.eSpot_List4_Receptacle9_Charge_Receptacle_Type)
      && (lhs.uiSpot_List4_Receptacle9_Available_Power == rhs.uiSpot_List4_Receptacle9_Available_Power)
      && (lhs.eSpot_List4_Receptacle9_Charge_Receptacle_Facility == rhs.eSpot_List4_Receptacle9_Charge_Receptacle_Facility)
      && (lhs.eSpot_List4_Receptacle10_Charge_Receptacle_Type == rhs.eSpot_List4_Receptacle10_Charge_Receptacle_Type)
      && (lhs.uiSpot_List4_Receptacle10_Available_Power == rhs.uiSpot_List4_Receptacle10_Available_Power)
      && (lhs.eSpot_List4_Receptacle10_Charge_Receptacle_Facility == rhs.eSpot_List4_Receptacle10_Charge_Receptacle_Facility)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Charge_Spot_ID::tcl_ITM_TCU_Charge_Spot_ID() : 
   strCharge_Spot_ID(NULL, 0x70)
{
}

tBool tcl_ITM_TCU_Charge_Spot_ID::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = strCharge_Spot_ID.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Charge_Spot_ID::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   strCharge_Spot_ID.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Charge_Spot_ID const& lhs, tcl_ITM_TCU_Charge_Spot_ID const& rhs){
   if (lhs.strCharge_Spot_ID != rhs.strCharge_Spot_ID) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Charge_Spot_ID const& lhs, tcl_ITM_TCU_Charge_Spot_ID const& rhs){
    if (
         (lhs.strCharge_Spot_ID == rhs.strCharge_Spot_ID)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Bookable_Free_Text::tcl_ITM_TCU_Bookable_Free_Text() : 
   uiLength_of_Text(0x01, 0x08),
   vstrText_Info(NULL, 0)
{
}

tBool tcl_ITM_TCU_Bookable_Free_Text::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiLength_of_Text.bUpdateData(poMcanMsg);

   if (bRet) bRet = vstrText_Info.bUpdateLength(8*uiLength_of_Text.u32GetData());
   if (bRet) bRet = vstrText_Info.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Bookable_Free_Text::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiLength_of_Text.bUpdateMcanMessage(poMcanMsg);
   vstrText_Info.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Bookable_Free_Text const& lhs, tcl_ITM_TCU_Bookable_Free_Text const& rhs){
   if (lhs.uiLength_of_Text != rhs.uiLength_of_Text) return FALSE;
   if (lhs.vstrText_Info != rhs.vstrText_Info) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Bookable_Free_Text const& lhs, tcl_ITM_TCU_Bookable_Free_Text const& rhs){
    if (
         (lhs.uiLength_of_Text == rhs.uiLength_of_Text)
      && (lhs.vstrText_Info == rhs.vstrText_Info)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Customer_Contract_ID::tcl_ITM_TCU_Customer_Contract_ID() : 
   strCustomer_Contract_ID(NULL, 0x60)
{
}

tBool tcl_ITM_TCU_Customer_Contract_ID::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = strCustomer_Contract_ID.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Customer_Contract_ID::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   strCustomer_Contract_ID.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Customer_Contract_ID const& lhs, tcl_ITM_TCU_Customer_Contract_ID const& rhs){
   if (lhs.strCustomer_Contract_ID != rhs.strCustomer_Contract_ID) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Customer_Contract_ID const& lhs, tcl_ITM_TCU_Customer_Contract_ID const& rhs){
    if (
         (lhs.strCustomer_Contract_ID == rhs.strCustomer_Contract_ID)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Service_Time_Request::tcl_ITM_TCU_Service_Time_Request() : 
   uiHour(0x00, 0x08),
   uiMinute(0x00, 0x08)
{
}

tBool tcl_ITM_TCU_Service_Time_Request::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiHour.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiMinute.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Service_Time_Request::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiHour.bUpdateMcanMessage(poMcanMsg);
   uiMinute.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Service_Time_Request const& lhs, tcl_ITM_TCU_Service_Time_Request const& rhs){
   if (lhs.uiHour != rhs.uiHour) return FALSE;
   if (lhs.uiMinute != rhs.uiMinute) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Service_Time_Request const& lhs, tcl_ITM_TCU_Service_Time_Request const& rhs){
    if (
         (lhs.uiHour == rhs.uiHour)
      && (lhs.uiMinute == rhs.uiMinute)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Booking_Status::tcl_ITM_TCU_Booking_Status() : 
   eBooking_Status((tcl_ITM_TCU_e32_Booking_Status::tenType)0x01, 0x08)
{
}

tBool tcl_ITM_TCU_Booking_Status::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eBooking_Status.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Booking_Status::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eBooking_Status.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Booking_Status const& lhs, tcl_ITM_TCU_Booking_Status const& rhs){
   if (lhs.eBooking_Status != rhs.eBooking_Status) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Booking_Status const& lhs, tcl_ITM_TCU_Booking_Status const& rhs){
    if (
         (lhs.eBooking_Status == rhs.eBooking_Status)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Max_Time_To_Arrive::tcl_ITM_TCU_Max_Time_To_Arrive() : 
   uiHour(0x00, 0x08),
   uiMinute(0x00, 0x08)
{
}

tBool tcl_ITM_TCU_Max_Time_To_Arrive::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiHour.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiMinute.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Max_Time_To_Arrive::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiHour.bUpdateMcanMessage(poMcanMsg);
   uiMinute.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Max_Time_To_Arrive const& lhs, tcl_ITM_TCU_Max_Time_To_Arrive const& rhs){
   if (lhs.uiHour != rhs.uiHour) return FALSE;
   if (lhs.uiMinute != rhs.uiMinute) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Max_Time_To_Arrive const& lhs, tcl_ITM_TCU_Max_Time_To_Arrive const& rhs){
    if (
         (lhs.uiHour == rhs.uiHour)
      && (lhs.uiMinute == rhs.uiMinute)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Max_Time_To_Unbook::tcl_ITM_TCU_Max_Time_To_Unbook() : 
   uiHour(0x00, 0x08),
   uiMinute(0x00, 0x08)
{
}

tBool tcl_ITM_TCU_Max_Time_To_Unbook::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiHour.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiMinute.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Max_Time_To_Unbook::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiHour.bUpdateMcanMessage(poMcanMsg);
   uiMinute.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Max_Time_To_Unbook const& lhs, tcl_ITM_TCU_Max_Time_To_Unbook const& rhs){
   if (lhs.uiHour != rhs.uiHour) return FALSE;
   if (lhs.uiMinute != rhs.uiMinute) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Max_Time_To_Unbook const& lhs, tcl_ITM_TCU_Max_Time_To_Unbook const& rhs){
    if (
         (lhs.uiHour == rhs.uiHour)
      && (lhs.uiMinute == rhs.uiMinute)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Booking_ID::tcl_ITM_TCU_Booking_ID() : 
   strBooking_ID(NULL, 0x20)
{
}

tBool tcl_ITM_TCU_Booking_ID::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = strBooking_ID.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Booking_ID::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   strBooking_ID.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Booking_ID const& lhs, tcl_ITM_TCU_Booking_ID const& rhs){
   if (lhs.strBooking_ID != rhs.strBooking_ID) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Booking_ID const& lhs, tcl_ITM_TCU_Booking_ID const& rhs){
    if (
         (lhs.strBooking_ID == rhs.strBooking_ID)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Charge_Receptacle_Facility_Byte::tcl_ITM_TCU_Charge_Receptacle_Facility_Byte() : 
   eCharge_Receptacle_Facility_Byte((tcl_ITM_TCU_e32_Charge_Receptacle_Facility::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_TCU_Charge_Receptacle_Facility_Byte::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eCharge_Receptacle_Facility_Byte.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Charge_Receptacle_Facility_Byte::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eCharge_Receptacle_Facility_Byte.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Charge_Receptacle_Facility_Byte const& lhs, tcl_ITM_TCU_Charge_Receptacle_Facility_Byte const& rhs){
   if (lhs.eCharge_Receptacle_Facility_Byte != rhs.eCharge_Receptacle_Facility_Byte) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Charge_Receptacle_Facility_Byte const& lhs, tcl_ITM_TCU_Charge_Receptacle_Facility_Byte const& rhs){
    if (
         (lhs.eCharge_Receptacle_Facility_Byte == rhs.eCharge_Receptacle_Facility_Byte)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Unbooking_Status::tcl_ITM_TCU_Unbooking_Status() : 
   eUnbooking_Status((tcl_ITM_TCU_e32_Unbooking_Status::tenType)0x01, 0x08)
{
}

tBool tcl_ITM_TCU_Unbooking_Status::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eUnbooking_Status.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Unbooking_Status::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eUnbooking_Status.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Unbooking_Status const& lhs, tcl_ITM_TCU_Unbooking_Status const& rhs){
   if (lhs.eUnbooking_Status != rhs.eUnbooking_Status) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Unbooking_Status const& lhs, tcl_ITM_TCU_Unbooking_Status const& rhs){
    if (
         (lhs.eUnbooking_Status == rhs.eUnbooking_Status)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Update_Status::tcl_ITM_TCU_Update_Status() : 
   eUpdate_Status((tcl_ITM_TCU_e32_Update_Status::tenType)0x01, 0x08)
{
}

tBool tcl_ITM_TCU_Update_Status::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eUpdate_Status.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Update_Status::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eUpdate_Status.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Update_Status const& lhs, tcl_ITM_TCU_Update_Status const& rhs){
   if (lhs.eUpdate_Status != rhs.eUpdate_Status) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Update_Status const& lhs, tcl_ITM_TCU_Update_Status const& rhs){
    if (
         (lhs.eUpdate_Status == rhs.eUpdate_Status)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Operation_Request::tcl_ITM_TCU_Operation_Request() : 
   eOperation_Request((tcl_ITM_TCU_e32_copy_Minus_Connect__Cancel::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_TCU_Operation_Request::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eOperation_Request.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Operation_Request::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eOperation_Request.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Operation_Request const& lhs, tcl_ITM_TCU_Operation_Request const& rhs){
   if (lhs.eOperation_Request != rhs.eOperation_Request) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Operation_Request const& lhs, tcl_ITM_TCU_Operation_Request const& rhs){
    if (
         (lhs.eOperation_Request == rhs.eOperation_Request)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_TCU_Status::tcl_ITM_TCU_TCU_Status() : 
   eTCU_Status((tcl_ITM_TCU_e32_TCU_State::tenType)0x01, 0x08)
{
}

tBool tcl_ITM_TCU_TCU_Status::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eTCU_Status.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_TCU_Status::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eTCU_Status.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_TCU_Status const& lhs, tcl_ITM_TCU_TCU_Status const& rhs){
   if (lhs.eTCU_Status != rhs.eTCU_Status) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_TCU_Status const& lhs, tcl_ITM_TCU_TCU_Status const& rhs){
    if (
         (lhs.eTCU_Status == rhs.eTCU_Status)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_GSM_Status::tcl_ITM_TCU_GSM_Status() : 
   eGSM_Status((tcl_ITM_TCU_e32_GSM_WCDMA_Status::tenType)0x01, 0x08)
{
}

tBool tcl_ITM_TCU_GSM_Status::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eGSM_Status.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_GSM_Status::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eGSM_Status.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_GSM_Status const& lhs, tcl_ITM_TCU_GSM_Status const& rhs){
   if (lhs.eGSM_Status != rhs.eGSM_Status) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_GSM_Status const& lhs, tcl_ITM_TCU_GSM_Status const& rhs){
    if (
         (lhs.eGSM_Status == rhs.eGSM_Status)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_GSM_Data_Mode::tcl_ITM_TCU_GSM_Data_Mode() : 
   eGSM_Data_Mode((tcl_ITM_TCU_e32_GSM_Data_Mode_State::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_TCU_GSM_Data_Mode::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eGSM_Data_Mode.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_GSM_Data_Mode::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eGSM_Data_Mode.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_GSM_Data_Mode const& lhs, tcl_ITM_TCU_GSM_Data_Mode const& rhs){
   if (lhs.eGSM_Data_Mode != rhs.eGSM_Data_Mode) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_GSM_Data_Mode const& lhs, tcl_ITM_TCU_GSM_Data_Mode const& rhs){
    if (
         (lhs.eGSM_Data_Mode == rhs.eGSM_Data_Mode)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Modem_Status::tcl_ITM_TCU_Modem_Status() : 
   eModem_Status((tcl_ITM_TCU_e32_Modem_State::tenType)0x01, 0x08)
{
}

tBool tcl_ITM_TCU_Modem_Status::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eModem_Status.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Modem_Status::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eModem_Status.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Modem_Status const& lhs, tcl_ITM_TCU_Modem_Status const& rhs){
   if (lhs.eModem_Status != rhs.eModem_Status) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Modem_Status const& lhs, tcl_ITM_TCU_Modem_Status const& rhs){
    if (
         (lhs.eModem_Status == rhs.eModem_Status)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Wifi_Status::tcl_ITM_TCU_Wifi_Status() : 
   eWifi_Status((tcl_ITM_TCU_e32_ON_OFF::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_TCU_Wifi_Status::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eWifi_Status.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Wifi_Status::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eWifi_Status.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Wifi_Status const& lhs, tcl_ITM_TCU_Wifi_Status const& rhs){
   if (lhs.eWifi_Status != rhs.eWifi_Status) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Wifi_Status const& lhs, tcl_ITM_TCU_Wifi_Status const& rhs){
    if (
         (lhs.eWifi_Status == rhs.eWifi_Status)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Wifi_HotSpot_Status::tcl_ITM_TCU_Wifi_HotSpot_Status() : 
   eWifi_HotSpot_Status((tcl_ITM_TCU_e32_Wifi_HotSpot_State::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_TCU_Wifi_HotSpot_Status::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eWifi_HotSpot_Status.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Wifi_HotSpot_Status::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eWifi_HotSpot_Status.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Wifi_HotSpot_Status const& lhs, tcl_ITM_TCU_Wifi_HotSpot_Status const& rhs){
   if (lhs.eWifi_HotSpot_Status != rhs.eWifi_HotSpot_Status) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Wifi_HotSpot_Status const& lhs, tcl_ITM_TCU_Wifi_HotSpot_Status const& rhs){
    if (
         (lhs.eWifi_HotSpot_Status == rhs.eWifi_HotSpot_Status)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Wifi_Client_Status::tcl_ITM_TCU_Wifi_Client_Status() : 
   eWifi_Client_Status((tcl_ITM_TCU_e32_Wifi_Client_State::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_TCU_Wifi_Client_Status::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eWifi_Client_Status.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Wifi_Client_Status::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eWifi_Client_Status.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Wifi_Client_Status const& lhs, tcl_ITM_TCU_Wifi_Client_Status const& rhs){
   if (lhs.eWifi_Client_Status != rhs.eWifi_Client_Status) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Wifi_Client_Status const& lhs, tcl_ITM_TCU_Wifi_Client_Status const& rhs){
    if (
         (lhs.eWifi_Client_Status == rhs.eWifi_Client_Status)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Wifi_Mode::tcl_ITM_TCU_Wifi_Mode() : 
   eWifi_Mode((tcl_ITM_TCU_e32_Wifi_Mode::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_TCU_Wifi_Mode::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eWifi_Mode.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Wifi_Mode::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eWifi_Mode.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Wifi_Mode const& lhs, tcl_ITM_TCU_Wifi_Mode const& rhs){
   if (lhs.eWifi_Mode != rhs.eWifi_Mode) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Wifi_Mode const& lhs, tcl_ITM_TCU_Wifi_Mode const& rhs){
    if (
         (lhs.eWifi_Mode == rhs.eWifi_Mode)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_GSM_RSSI_Level::tcl_ITM_TCU_GSM_RSSI_Level() : 
   uiGSM_RSSI_Level(0x00, 0x08)
{
}

tBool tcl_ITM_TCU_GSM_RSSI_Level::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiGSM_RSSI_Level.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_GSM_RSSI_Level::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiGSM_RSSI_Level.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_GSM_RSSI_Level const& lhs, tcl_ITM_TCU_GSM_RSSI_Level const& rhs){
   if (lhs.uiGSM_RSSI_Level != rhs.uiGSM_RSSI_Level) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_GSM_RSSI_Level const& lhs, tcl_ITM_TCU_GSM_RSSI_Level const& rhs){
    if (
         (lhs.uiGSM_RSSI_Level == rhs.uiGSM_RSSI_Level)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Wifi_SSID_Name::tcl_ITM_TCU_Wifi_SSID_Name() : 
   uiCharacter_Set(0x01, 0x08),
   uiLength_of_Text(0x01, 0x08),
   vstrBody_Text(NULL, 0)
{
}

tBool tcl_ITM_TCU_Wifi_SSID_Name::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiCharacter_Set.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiLength_of_Text.bUpdateData(poMcanMsg);

   if (bRet) bRet = vstrBody_Text.bUpdateLength(8*uiLength_of_Text.u32GetData());
   if (bRet) bRet = vstrBody_Text.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Wifi_SSID_Name::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiCharacter_Set.bUpdateMcanMessage(poMcanMsg);
   uiLength_of_Text.bUpdateMcanMessage(poMcanMsg);
   vstrBody_Text.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Wifi_SSID_Name const& lhs, tcl_ITM_TCU_Wifi_SSID_Name const& rhs){
   if (lhs.uiCharacter_Set != rhs.uiCharacter_Set) return FALSE;
   if (lhs.uiLength_of_Text != rhs.uiLength_of_Text) return FALSE;
   if (lhs.vstrBody_Text != rhs.vstrBody_Text) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Wifi_SSID_Name const& lhs, tcl_ITM_TCU_Wifi_SSID_Name const& rhs){
    if (
         (lhs.uiCharacter_Set == rhs.uiCharacter_Set)
      && (lhs.uiLength_of_Text == rhs.uiLength_of_Text)
      && (lhs.vstrBody_Text == rhs.vstrBody_Text)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Wifi_PassKey::tcl_ITM_TCU_Wifi_PassKey() : 
   uiCharacter_Set(0x01, 0x08),
   uiLength_of_Text(0x01, 0x08),
   vstrBody_Text(NULL, 0)
{
}

tBool tcl_ITM_TCU_Wifi_PassKey::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiCharacter_Set.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiLength_of_Text.bUpdateData(poMcanMsg);

   if (bRet) bRet = vstrBody_Text.bUpdateLength(8*uiLength_of_Text.u32GetData());
   if (bRet) bRet = vstrBody_Text.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Wifi_PassKey::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiCharacter_Set.bUpdateMcanMessage(poMcanMsg);
   uiLength_of_Text.bUpdateMcanMessage(poMcanMsg);
   vstrBody_Text.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Wifi_PassKey const& lhs, tcl_ITM_TCU_Wifi_PassKey const& rhs){
   if (lhs.uiCharacter_Set != rhs.uiCharacter_Set) return FALSE;
   if (lhs.uiLength_of_Text != rhs.uiLength_of_Text) return FALSE;
   if (lhs.vstrBody_Text != rhs.vstrBody_Text) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Wifi_PassKey const& lhs, tcl_ITM_TCU_Wifi_PassKey const& rhs){
    if (
         (lhs.uiCharacter_Set == rhs.uiCharacter_Set)
      && (lhs.uiLength_of_Text == rhs.uiLength_of_Text)
      && (lhs.vstrBody_Text == rhs.vstrBody_Text)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Wifi_Security_Mode::tcl_ITM_TCU_Wifi_Security_Mode() : 
   eWifi_Security_Mode((tcl_ITM_TCU_e32_Wifi_Security_Mode::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_TCU_Wifi_Security_Mode::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eWifi_Security_Mode.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Wifi_Security_Mode::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eWifi_Security_Mode.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Wifi_Security_Mode const& lhs, tcl_ITM_TCU_Wifi_Security_Mode const& rhs){
   if (lhs.eWifi_Security_Mode != rhs.eWifi_Security_Mode) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Wifi_Security_Mode const& lhs, tcl_ITM_TCU_Wifi_Security_Mode const& rhs){
    if (
         (lhs.eWifi_Security_Mode == rhs.eWifi_Security_Mode)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Wifi_Channel_Number::tcl_ITM_TCU_Wifi_Channel_Number() : 
   uiWifi_Channel_Number(0x00, 0x08)
{
}

tBool tcl_ITM_TCU_Wifi_Channel_Number::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiWifi_Channel_Number.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Wifi_Channel_Number::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiWifi_Channel_Number.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Wifi_Channel_Number const& lhs, tcl_ITM_TCU_Wifi_Channel_Number const& rhs){
   if (lhs.uiWifi_Channel_Number != rhs.uiWifi_Channel_Number) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Wifi_Channel_Number const& lhs, tcl_ITM_TCU_Wifi_Channel_Number const& rhs){
    if (
         (lhs.uiWifi_Channel_Number == rhs.uiWifi_Channel_Number)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Wifi_Visibility::tcl_ITM_TCU_Wifi_Visibility() : 
   eWifi_Visibility((tcl_ITM_TCU_e32_Wifi_Visibility::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_TCU_Wifi_Visibility::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eWifi_Visibility.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Wifi_Visibility::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eWifi_Visibility.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Wifi_Visibility const& lhs, tcl_ITM_TCU_Wifi_Visibility const& rhs){
   if (lhs.eWifi_Visibility != rhs.eWifi_Visibility) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Wifi_Visibility const& lhs, tcl_ITM_TCU_Wifi_Visibility const& rhs){
    if (
         (lhs.eWifi_Visibility == rhs.eWifi_Visibility)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Wifi_Client_SSID::tcl_ITM_TCU_Wifi_Client_SSID() : 
   uiWifi_Client_SSID(0x00, 0x08)
{
}

tBool tcl_ITM_TCU_Wifi_Client_SSID::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiWifi_Client_SSID.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Wifi_Client_SSID::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiWifi_Client_SSID.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Wifi_Client_SSID const& lhs, tcl_ITM_TCU_Wifi_Client_SSID const& rhs){
   if (lhs.uiWifi_Client_SSID != rhs.uiWifi_Client_SSID) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Wifi_Client_SSID const& lhs, tcl_ITM_TCU_Wifi_Client_SSID const& rhs){
    if (
         (lhs.uiWifi_Client_SSID == rhs.uiWifi_Client_SSID)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Wifi_Client_Power::tcl_ITM_TCU_Wifi_Client_Power() : 
   uiWifi_Client_Power(0x00, 0x08)
{
}

tBool tcl_ITM_TCU_Wifi_Client_Power::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiWifi_Client_Power.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Wifi_Client_Power::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiWifi_Client_Power.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Wifi_Client_Power const& lhs, tcl_ITM_TCU_Wifi_Client_Power const& rhs){
   if (lhs.uiWifi_Client_Power != rhs.uiWifi_Client_Power) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Wifi_Client_Power const& lhs, tcl_ITM_TCU_Wifi_Client_Power const& rhs){
    if (
         (lhs.uiWifi_Client_Power == rhs.uiWifi_Client_Power)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Wifi_Connection_Status::tcl_ITM_TCU_Wifi_Connection_Status() : 
   eWifi_Connection_Status((tcl_ITM_TCU_e32_Wifi_Connection_State::tenType)0x01, 0x08)
{
}

tBool tcl_ITM_TCU_Wifi_Connection_Status::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eWifi_Connection_Status.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Wifi_Connection_Status::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eWifi_Connection_Status.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Wifi_Connection_Status const& lhs, tcl_ITM_TCU_Wifi_Connection_Status const& rhs){
   if (lhs.eWifi_Connection_Status != rhs.eWifi_Connection_Status) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Wifi_Connection_Status const& lhs, tcl_ITM_TCU_Wifi_Connection_Status const& rhs){
    if (
         (lhs.eWifi_Connection_Status == rhs.eWifi_Connection_Status)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Wifi_Scan_SSID_Name::tcl_ITM_TCU_Wifi_Scan_SSID_Name() : 
   uiCharacter_Set(0x01, 0x08),
   uiLength_of_Text(0x01, 0x08),
   vstrBody_Text(NULL, 0)
{
}

tBool tcl_ITM_TCU_Wifi_Scan_SSID_Name::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiCharacter_Set.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiLength_of_Text.bUpdateData(poMcanMsg);

   if (bRet) bRet = vstrBody_Text.bUpdateLength(8*uiLength_of_Text.u32GetData());
   if (bRet) bRet = vstrBody_Text.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Wifi_Scan_SSID_Name::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiCharacter_Set.bUpdateMcanMessage(poMcanMsg);
   uiLength_of_Text.bUpdateMcanMessage(poMcanMsg);
   vstrBody_Text.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Wifi_Scan_SSID_Name const& lhs, tcl_ITM_TCU_Wifi_Scan_SSID_Name const& rhs){
   if (lhs.uiCharacter_Set != rhs.uiCharacter_Set) return FALSE;
   if (lhs.uiLength_of_Text != rhs.uiLength_of_Text) return FALSE;
   if (lhs.vstrBody_Text != rhs.vstrBody_Text) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Wifi_Scan_SSID_Name const& lhs, tcl_ITM_TCU_Wifi_Scan_SSID_Name const& rhs){
    if (
         (lhs.uiCharacter_Set == rhs.uiCharacter_Set)
      && (lhs.uiLength_of_Text == rhs.uiLength_of_Text)
      && (lhs.vstrBody_Text == rhs.vstrBody_Text)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Wifi_Scan_Power::tcl_ITM_TCU_Wifi_Scan_Power() : 
   uiWifi_Scan_Power(0x00, 0x08)
{
}

tBool tcl_ITM_TCU_Wifi_Scan_Power::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiWifi_Scan_Power.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Wifi_Scan_Power::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiWifi_Scan_Power.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Wifi_Scan_Power const& lhs, tcl_ITM_TCU_Wifi_Scan_Power const& rhs){
   if (lhs.uiWifi_Scan_Power != rhs.uiWifi_Scan_Power) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Wifi_Scan_Power const& lhs, tcl_ITM_TCU_Wifi_Scan_Power const& rhs){
    if (
         (lhs.uiWifi_Scan_Power == rhs.uiWifi_Scan_Power)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Wifi_Scan_Security::tcl_ITM_TCU_Wifi_Scan_Security() : 
   eWifi_Scan_Security((tcl_ITM_TCU_e32_Wifi_Scan_Security::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_TCU_Wifi_Scan_Security::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eWifi_Scan_Security.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Wifi_Scan_Security::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eWifi_Scan_Security.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Wifi_Scan_Security const& lhs, tcl_ITM_TCU_Wifi_Scan_Security const& rhs){
   if (lhs.eWifi_Scan_Security != rhs.eWifi_Scan_Security) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Wifi_Scan_Security const& lhs, tcl_ITM_TCU_Wifi_Scan_Security const& rhs){
    if (
         (lhs.eWifi_Scan_Security == rhs.eWifi_Scan_Security)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Wifi_Connected_Devices::tcl_ITM_TCU_Wifi_Connected_Devices() : 
   uiWifi_Connected_Devices(0x00, 0x08)
{
}

tBool tcl_ITM_TCU_Wifi_Connected_Devices::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiWifi_Connected_Devices.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Wifi_Connected_Devices::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiWifi_Connected_Devices.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Wifi_Connected_Devices const& lhs, tcl_ITM_TCU_Wifi_Connected_Devices const& rhs){
   if (lhs.uiWifi_Connected_Devices != rhs.uiWifi_Connected_Devices) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Wifi_Connected_Devices const& lhs, tcl_ITM_TCU_Wifi_Connected_Devices const& rhs){
    if (
         (lhs.uiWifi_Connected_Devices == rhs.uiWifi_Connected_Devices)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Charge_Day1_Start::tcl_ITM_TCU_Charge_Day1_Start() : 
   uiCharge_Day1_Start(0x00, 0x08)
{
}

tBool tcl_ITM_TCU_Charge_Day1_Start::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiCharge_Day1_Start.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Charge_Day1_Start::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiCharge_Day1_Start.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Charge_Day1_Start const& lhs, tcl_ITM_TCU_Charge_Day1_Start const& rhs){
   if (lhs.uiCharge_Day1_Start != rhs.uiCharge_Day1_Start) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Charge_Day1_Start const& lhs, tcl_ITM_TCU_Charge_Day1_Start const& rhs){
    if (
         (lhs.uiCharge_Day1_Start == rhs.uiCharge_Day1_Start)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Charge_Day1_End::tcl_ITM_TCU_Charge_Day1_End() : 
   uiCharge_Day1_End(0x00, 0x08)
{
}

tBool tcl_ITM_TCU_Charge_Day1_End::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiCharge_Day1_End.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Charge_Day1_End::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiCharge_Day1_End.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Charge_Day1_End const& lhs, tcl_ITM_TCU_Charge_Day1_End const& rhs){
   if (lhs.uiCharge_Day1_End != rhs.uiCharge_Day1_End) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Charge_Day1_End const& lhs, tcl_ITM_TCU_Charge_Day1_End const& rhs){
    if (
         (lhs.uiCharge_Day1_End == rhs.uiCharge_Day1_End)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Charge_Day2_Start::tcl_ITM_TCU_Charge_Day2_Start() : 
   uiCharge_Day2_Start(0x00, 0x08)
{
}

tBool tcl_ITM_TCU_Charge_Day2_Start::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiCharge_Day2_Start.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Charge_Day2_Start::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiCharge_Day2_Start.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Charge_Day2_Start const& lhs, tcl_ITM_TCU_Charge_Day2_Start const& rhs){
   if (lhs.uiCharge_Day2_Start != rhs.uiCharge_Day2_Start) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Charge_Day2_Start const& lhs, tcl_ITM_TCU_Charge_Day2_Start const& rhs){
    if (
         (lhs.uiCharge_Day2_Start == rhs.uiCharge_Day2_Start)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Charge_Day2_End::tcl_ITM_TCU_Charge_Day2_End() : 
   uiCharge_Day2_End(0x00, 0x08)
{
}

tBool tcl_ITM_TCU_Charge_Day2_End::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiCharge_Day2_End.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Charge_Day2_End::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiCharge_Day2_End.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Charge_Day2_End const& lhs, tcl_ITM_TCU_Charge_Day2_End const& rhs){
   if (lhs.uiCharge_Day2_End != rhs.uiCharge_Day2_End) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Charge_Day2_End const& lhs, tcl_ITM_TCU_Charge_Day2_End const& rhs){
    if (
         (lhs.uiCharge_Day2_End == rhs.uiCharge_Day2_End)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Charge_Day3_Start::tcl_ITM_TCU_Charge_Day3_Start() : 
   uiCharge_Day3_Start(0x00, 0x08)
{
}

tBool tcl_ITM_TCU_Charge_Day3_Start::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiCharge_Day3_Start.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Charge_Day3_Start::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiCharge_Day3_Start.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Charge_Day3_Start const& lhs, tcl_ITM_TCU_Charge_Day3_Start const& rhs){
   if (lhs.uiCharge_Day3_Start != rhs.uiCharge_Day3_Start) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Charge_Day3_Start const& lhs, tcl_ITM_TCU_Charge_Day3_Start const& rhs){
    if (
         (lhs.uiCharge_Day3_Start == rhs.uiCharge_Day3_Start)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Charge_Day3_End::tcl_ITM_TCU_Charge_Day3_End() : 
   uiCharge_Day3_End(0x00, 0x08)
{
}

tBool tcl_ITM_TCU_Charge_Day3_End::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiCharge_Day3_End.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Charge_Day3_End::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiCharge_Day3_End.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Charge_Day3_End const& lhs, tcl_ITM_TCU_Charge_Day3_End const& rhs){
   if (lhs.uiCharge_Day3_End != rhs.uiCharge_Day3_End) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Charge_Day3_End const& lhs, tcl_ITM_TCU_Charge_Day3_End const& rhs){
    if (
         (lhs.uiCharge_Day3_End == rhs.uiCharge_Day3_End)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Charge_Day4_Start::tcl_ITM_TCU_Charge_Day4_Start() : 
   uiCharge_Day4_Start(0x00, 0x08)
{
}

tBool tcl_ITM_TCU_Charge_Day4_Start::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiCharge_Day4_Start.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Charge_Day4_Start::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiCharge_Day4_Start.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Charge_Day4_Start const& lhs, tcl_ITM_TCU_Charge_Day4_Start const& rhs){
   if (lhs.uiCharge_Day4_Start != rhs.uiCharge_Day4_Start) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Charge_Day4_Start const& lhs, tcl_ITM_TCU_Charge_Day4_Start const& rhs){
    if (
         (lhs.uiCharge_Day4_Start == rhs.uiCharge_Day4_Start)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Charge_Day4_End::tcl_ITM_TCU_Charge_Day4_End() : 
   uiCharge_Day4_End(0x00, 0x08)
{
}

tBool tcl_ITM_TCU_Charge_Day4_End::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiCharge_Day4_End.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Charge_Day4_End::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiCharge_Day4_End.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Charge_Day4_End const& lhs, tcl_ITM_TCU_Charge_Day4_End const& rhs){
   if (lhs.uiCharge_Day4_End != rhs.uiCharge_Day4_End) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Charge_Day4_End const& lhs, tcl_ITM_TCU_Charge_Day4_End const& rhs){
    if (
         (lhs.uiCharge_Day4_End == rhs.uiCharge_Day4_End)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Charge_Day5_Start::tcl_ITM_TCU_Charge_Day5_Start() : 
   uiCharge_Day5_Start(0x00, 0x08)
{
}

tBool tcl_ITM_TCU_Charge_Day5_Start::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiCharge_Day5_Start.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Charge_Day5_Start::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiCharge_Day5_Start.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Charge_Day5_Start const& lhs, tcl_ITM_TCU_Charge_Day5_Start const& rhs){
   if (lhs.uiCharge_Day5_Start != rhs.uiCharge_Day5_Start) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Charge_Day5_Start const& lhs, tcl_ITM_TCU_Charge_Day5_Start const& rhs){
    if (
         (lhs.uiCharge_Day5_Start == rhs.uiCharge_Day5_Start)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Charge_Day5_End::tcl_ITM_TCU_Charge_Day5_End() : 
   uiCharge_Day5_End(0x00, 0x08)
{
}

tBool tcl_ITM_TCU_Charge_Day5_End::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiCharge_Day5_End.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Charge_Day5_End::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiCharge_Day5_End.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Charge_Day5_End const& lhs, tcl_ITM_TCU_Charge_Day5_End const& rhs){
   if (lhs.uiCharge_Day5_End != rhs.uiCharge_Day5_End) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Charge_Day5_End const& lhs, tcl_ITM_TCU_Charge_Day5_End const& rhs){
    if (
         (lhs.uiCharge_Day5_End == rhs.uiCharge_Day5_End)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Charge_Day6_Start::tcl_ITM_TCU_Charge_Day6_Start() : 
   uiCharge_Day6_Start(0x00, 0x08)
{
}

tBool tcl_ITM_TCU_Charge_Day6_Start::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiCharge_Day6_Start.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Charge_Day6_Start::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiCharge_Day6_Start.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Charge_Day6_Start const& lhs, tcl_ITM_TCU_Charge_Day6_Start const& rhs){
   if (lhs.uiCharge_Day6_Start != rhs.uiCharge_Day6_Start) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Charge_Day6_Start const& lhs, tcl_ITM_TCU_Charge_Day6_Start const& rhs){
    if (
         (lhs.uiCharge_Day6_Start == rhs.uiCharge_Day6_Start)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Charge_Day6_End::tcl_ITM_TCU_Charge_Day6_End() : 
   uiCharge_Day6_End(0x00, 0x08)
{
}

tBool tcl_ITM_TCU_Charge_Day6_End::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiCharge_Day6_End.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Charge_Day6_End::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiCharge_Day6_End.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Charge_Day6_End const& lhs, tcl_ITM_TCU_Charge_Day6_End const& rhs){
   if (lhs.uiCharge_Day6_End != rhs.uiCharge_Day6_End) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Charge_Day6_End const& lhs, tcl_ITM_TCU_Charge_Day6_End const& rhs){
    if (
         (lhs.uiCharge_Day6_End == rhs.uiCharge_Day6_End)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Charge_Day7_Start::tcl_ITM_TCU_Charge_Day7_Start() : 
   uiCharge_Day7_Start(0x00, 0x08)
{
}

tBool tcl_ITM_TCU_Charge_Day7_Start::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiCharge_Day7_Start.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Charge_Day7_Start::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiCharge_Day7_Start.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Charge_Day7_Start const& lhs, tcl_ITM_TCU_Charge_Day7_Start const& rhs){
   if (lhs.uiCharge_Day7_Start != rhs.uiCharge_Day7_Start) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Charge_Day7_Start const& lhs, tcl_ITM_TCU_Charge_Day7_Start const& rhs){
    if (
         (lhs.uiCharge_Day7_Start == rhs.uiCharge_Day7_Start)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Charge_Day7_End::tcl_ITM_TCU_Charge_Day7_End() : 
   uiCharge_Day7_End(0x00, 0x08)
{
}

tBool tcl_ITM_TCU_Charge_Day7_End::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiCharge_Day7_End.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Charge_Day7_End::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiCharge_Day7_End.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Charge_Day7_End const& lhs, tcl_ITM_TCU_Charge_Day7_End const& rhs){
   if (lhs.uiCharge_Day7_End != rhs.uiCharge_Day7_End) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Charge_Day7_End const& lhs, tcl_ITM_TCU_Charge_Day7_End const& rhs){
    if (
         (lhs.uiCharge_Day7_End == rhs.uiCharge_Day7_End)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Charge_Blocked_Status::tcl_ITM_TCU_Charge_Blocked_Status() : 
   eCharge_Blocked_Status((tcl_ITM_TCU_e32_Charge_Blocked_Status::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_TCU_Charge_Blocked_Status::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eCharge_Blocked_Status.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Charge_Blocked_Status::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eCharge_Blocked_Status.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Charge_Blocked_Status const& lhs, tcl_ITM_TCU_Charge_Blocked_Status const& rhs){
   if (lhs.eCharge_Blocked_Status != rhs.eCharge_Blocked_Status) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Charge_Blocked_Status const& lhs, tcl_ITM_TCU_Charge_Blocked_Status const& rhs){
    if (
         (lhs.eCharge_Blocked_Status == rhs.eCharge_Blocked_Status)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Curfew_Warning::tcl_ITM_TCU_Curfew_Warning() : 
   eCurfew_Warning((tcl_ITM_TCU_e32_Curfew_Warning::tenType)0x01, 0x08)
{
}

tBool tcl_ITM_TCU_Curfew_Warning::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eCurfew_Warning.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Curfew_Warning::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eCurfew_Warning.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Curfew_Warning const& lhs, tcl_ITM_TCU_Curfew_Warning const& rhs){
   if (lhs.eCurfew_Warning != rhs.eCurfew_Warning) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Curfew_Warning const& lhs, tcl_ITM_TCU_Curfew_Warning const& rhs){
    if (
         (lhs.eCurfew_Warning == rhs.eCurfew_Warning)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Ecall_State_Display::tcl_ITM_TCU_Ecall_State_Display() : 
   eEcall_State_Display((tcl_ITM_TCU_e32_ECALL_State_Display::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_TCU_Ecall_State_Display::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eEcall_State_Display.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Ecall_State_Display::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eEcall_State_Display.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Ecall_State_Display const& lhs, tcl_ITM_TCU_Ecall_State_Display const& rhs){
   if (lhs.eEcall_State_Display != rhs.eEcall_State_Display) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Ecall_State_Display const& lhs, tcl_ITM_TCU_Ecall_State_Display const& rhs){
    if (
         (lhs.eEcall_State_Display == rhs.eEcall_State_Display)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Connecting_Point::tcl_ITM_TCU_Connecting_Point() : 
   uiConnecting_Point(0x01, 0x08)
{
}

tBool tcl_ITM_TCU_Connecting_Point::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiConnecting_Point.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Connecting_Point::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiConnecting_Point.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Connecting_Point const& lhs, tcl_ITM_TCU_Connecting_Point const& rhs){
   if (lhs.uiConnecting_Point != rhs.uiConnecting_Point) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Connecting_Point const& lhs, tcl_ITM_TCU_Connecting_Point const& rhs){
    if (
         (lhs.uiConnecting_Point == rhs.uiConnecting_Point)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Pages_Of_List::tcl_ITM_TCU_Pages_Of_List() : 
   uiPages_Of_List(0x00, 0x08)
{
}

tBool tcl_ITM_TCU_Pages_Of_List::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiPages_Of_List.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Pages_Of_List::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiPages_Of_List.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Pages_Of_List const& lhs, tcl_ITM_TCU_Pages_Of_List const& rhs){
   if (lhs.uiPages_Of_List != rhs.uiPages_Of_List) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Pages_Of_List const& lhs, tcl_ITM_TCU_Pages_Of_List const& rhs){
    if (
         (lhs.uiPages_Of_List == rhs.uiPages_Of_List)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Sch_Activation_State::tcl_ITM_TCU_Sch_Activation_State() : 
   eSch_Activation_State((tcl_ITM_TCU_e32_Sch_Activation_State::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_TCU_Sch_Activation_State::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eSch_Activation_State.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Sch_Activation_State::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eSch_Activation_State.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Sch_Activation_State const& lhs, tcl_ITM_TCU_Sch_Activation_State const& rhs){
   if (lhs.eSch_Activation_State != rhs.eSch_Activation_State) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Sch_Activation_State const& lhs, tcl_ITM_TCU_Sch_Activation_State const& rhs){
    if (
         (lhs.eSch_Activation_State == rhs.eSch_Activation_State)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Probe_Permit_Setting::tcl_ITM_TCU_Probe_Permit_Setting() : 
   eProbe_Permit_Setting((tcl_ITM_TCU_e32_ON_OFF::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_TCU_Probe_Permit_Setting::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eProbe_Permit_Setting.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Probe_Permit_Setting::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eProbe_Permit_Setting.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Probe_Permit_Setting const& lhs, tcl_ITM_TCU_Probe_Permit_Setting const& rhs){
   if (lhs.eProbe_Permit_Setting != rhs.eProbe_Permit_Setting) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Probe_Permit_Setting const& lhs, tcl_ITM_TCU_Probe_Permit_Setting const& rhs){
    if (
         (lhs.eProbe_Permit_Setting == rhs.eProbe_Permit_Setting)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_ACNCALL_Service_State::tcl_ITM_TCU_ACNCALL_Service_State() : 
   eACNCALL_Service_State((tcl_ITM_TCU_e32_Service_State::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_TCU_ACNCALL_Service_State::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eACNCALL_Service_State.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_ACNCALL_Service_State::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eACNCALL_Service_State.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_ACNCALL_Service_State const& lhs, tcl_ITM_TCU_ACNCALL_Service_State const& rhs){
   if (lhs.eACNCALL_Service_State != rhs.eACNCALL_Service_State) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_ACNCALL_Service_State const& lhs, tcl_ITM_TCU_ACNCALL_Service_State const& rhs){
    if (
         (lhs.eACNCALL_Service_State == rhs.eACNCALL_Service_State)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_ECALL_Service_State::tcl_ITM_TCU_ECALL_Service_State() : 
   eECALL_Service_State((tcl_ITM_TCU_e32_Service_State::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_TCU_ECALL_Service_State::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eECALL_Service_State.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_ECALL_Service_State::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eECALL_Service_State.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_ECALL_Service_State const& lhs, tcl_ITM_TCU_ECALL_Service_State const& rhs){
   if (lhs.eECALL_Service_State != rhs.eECALL_Service_State) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_ECALL_Service_State const& lhs, tcl_ITM_TCU_ECALL_Service_State const& rhs){
    if (
         (lhs.eECALL_Service_State == rhs.eECALL_Service_State)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Navi_Vehicle_Speed::tcl_ITM_TCU_Navi_Vehicle_Speed() : 
   uiNavi_Vehicle_Speed(0x00, 0x10)
{
}

tBool tcl_ITM_TCU_Navi_Vehicle_Speed::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiNavi_Vehicle_Speed.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Navi_Vehicle_Speed::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiNavi_Vehicle_Speed.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Navi_Vehicle_Speed const& lhs, tcl_ITM_TCU_Navi_Vehicle_Speed const& rhs){
   if (lhs.uiNavi_Vehicle_Speed != rhs.uiNavi_Vehicle_Speed) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Navi_Vehicle_Speed const& lhs, tcl_ITM_TCU_Navi_Vehicle_Speed const& rhs){
    if (
         (lhs.uiNavi_Vehicle_Speed == rhs.uiNavi_Vehicle_Speed)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Navi_Driving_Distance::tcl_ITM_TCU_Navi_Driving_Distance() : 
   uiNavi_Driving_Distance(0x00, 0x20)
{
}

tBool tcl_ITM_TCU_Navi_Driving_Distance::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiNavi_Driving_Distance.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Navi_Driving_Distance::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiNavi_Driving_Distance.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Navi_Driving_Distance const& lhs, tcl_ITM_TCU_Navi_Driving_Distance const& rhs){
   if (lhs.uiNavi_Driving_Distance != rhs.uiNavi_Driving_Distance) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Navi_Driving_Distance const& lhs, tcl_ITM_TCU_Navi_Driving_Distance const& rhs){
    if (
         (lhs.uiNavi_Driving_Distance == rhs.uiNavi_Driving_Distance)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Navi_Road_Classification::tcl_ITM_TCU_Navi_Road_Classification() : 
   uiTable_Type(0x00, 0x08),
   uiRoad_Type(0x00, 0x08)
{
}

tBool tcl_ITM_TCU_Navi_Road_Classification::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiTable_Type.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiRoad_Type.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Navi_Road_Classification::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiTable_Type.bUpdateMcanMessage(poMcanMsg);
   uiRoad_Type.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Navi_Road_Classification const& lhs, tcl_ITM_TCU_Navi_Road_Classification const& rhs){
   if (lhs.uiTable_Type != rhs.uiTable_Type) return FALSE;
   if (lhs.uiRoad_Type != rhs.uiRoad_Type) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Navi_Road_Classification const& lhs, tcl_ITM_TCU_Navi_Road_Classification const& rhs){
    if (
         (lhs.uiTable_Type == rhs.uiTable_Type)
      && (lhs.uiRoad_Type == rhs.uiRoad_Type)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Wifi_SSID::tcl_ITM_TCU_Wifi_SSID() : 
   uiCharacter_Set(0x01, 0x08),
   uiLength_of_Text(0x01, 0x08),
   vstrBody_Text(NULL, 0)
{
}

tBool tcl_ITM_TCU_Wifi_SSID::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiCharacter_Set.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiLength_of_Text.bUpdateData(poMcanMsg);

   if (bRet) bRet = vstrBody_Text.bUpdateLength(8*uiLength_of_Text.u32GetData());
   if (bRet) bRet = vstrBody_Text.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Wifi_SSID::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiCharacter_Set.bUpdateMcanMessage(poMcanMsg);
   uiLength_of_Text.bUpdateMcanMessage(poMcanMsg);
   vstrBody_Text.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Wifi_SSID const& lhs, tcl_ITM_TCU_Wifi_SSID const& rhs){
   if (lhs.uiCharacter_Set != rhs.uiCharacter_Set) return FALSE;
   if (lhs.uiLength_of_Text != rhs.uiLength_of_Text) return FALSE;
   if (lhs.vstrBody_Text != rhs.vstrBody_Text) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Wifi_SSID const& lhs, tcl_ITM_TCU_Wifi_SSID const& rhs){
    if (
         (lhs.uiCharacter_Set == rhs.uiCharacter_Set)
      && (lhs.uiLength_of_Text == rhs.uiLength_of_Text)
      && (lhs.vstrBody_Text == rhs.vstrBody_Text)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_IMEI::tcl_ITM_TCU_IMEI() : 
   strIMEI(NULL, 0x78)
{
}

tBool tcl_ITM_TCU_IMEI::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = strIMEI.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_IMEI::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   strIMEI.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_IMEI const& lhs, tcl_ITM_TCU_IMEI const& rhs){
   if (lhs.strIMEI != rhs.strIMEI) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_IMEI const& lhs, tcl_ITM_TCU_IMEI const& rhs){
    if (
         (lhs.strIMEI == rhs.strIMEI)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_MCC::tcl_ITM_TCU_MCC() : 
   uiMCC(0x00, 0x10)
{
}

tBool tcl_ITM_TCU_MCC::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiMCC.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_MCC::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiMCC.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_MCC const& lhs, tcl_ITM_TCU_MCC const& rhs){
   if (lhs.uiMCC != rhs.uiMCC) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_MCC const& lhs, tcl_ITM_TCU_MCC const& rhs){
    if (
         (lhs.uiMCC == rhs.uiMCC)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_MNC::tcl_ITM_TCU_MNC() : 
   uiMNC(0x00, 0x08)
{
}

tBool tcl_ITM_TCU_MNC::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiMNC.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_MNC::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiMNC.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_MNC const& lhs, tcl_ITM_TCU_MNC const& rhs){
   if (lhs.uiMNC != rhs.uiMNC) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_MNC const& lhs, tcl_ITM_TCU_MNC const& rhs){
    if (
         (lhs.uiMNC == rhs.uiMNC)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Mobile_Network_Name::tcl_ITM_TCU_Mobile_Network_Name() : 
   strMobile_Network_Name(NULL, 0x0190)
{
}

tBool tcl_ITM_TCU_Mobile_Network_Name::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = strMobile_Network_Name.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Mobile_Network_Name::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   strMobile_Network_Name.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Mobile_Network_Name const& lhs, tcl_ITM_TCU_Mobile_Network_Name const& rhs){
   if (lhs.strMobile_Network_Name != rhs.strMobile_Network_Name) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Mobile_Network_Name const& lhs, tcl_ITM_TCU_Mobile_Network_Name const& rhs){
    if (
         (lhs.strMobile_Network_Name == rhs.strMobile_Network_Name)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Roaming_status::tcl_ITM_TCU_Roaming_status() : 
   eRoaming_status((tcl_ITM_TCU_e32_Roaming_status::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_TCU_Roaming_status::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eRoaming_status.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Roaming_status::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eRoaming_status.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Roaming_status const& lhs, tcl_ITM_TCU_Roaming_status const& rhs){
   if (lhs.eRoaming_status != rhs.eRoaming_status) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Roaming_status const& lhs, tcl_ITM_TCU_Roaming_status const& rhs){
    if (
         (lhs.eRoaming_status == rhs.eRoaming_status)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_PPP_connection_status::tcl_ITM_TCU_PPP_connection_status() : 
   ePPP_connection_status((tcl_ITM_TCU_e32_PPP_connection_status::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_TCU_PPP_connection_status::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = ePPP_connection_status.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_PPP_connection_status::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   ePPP_connection_status.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_PPP_connection_status const& lhs, tcl_ITM_TCU_PPP_connection_status const& rhs){
   if (lhs.ePPP_connection_status != rhs.ePPP_connection_status) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_PPP_connection_status const& lhs, tcl_ITM_TCU_PPP_connection_status const& rhs){
    if (
         (lhs.ePPP_connection_status == rhs.ePPP_connection_status)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_POI_ID::tcl_ITM_TCU_POI_ID() : 
   uiPOI_ID(0x00, 0x20)
{
}

tBool tcl_ITM_TCU_POI_ID::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiPOI_ID.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_POI_ID::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiPOI_ID.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_POI_ID const& lhs, tcl_ITM_TCU_POI_ID const& rhs){
   if (lhs.uiPOI_ID != rhs.uiPOI_ID) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_POI_ID const& lhs, tcl_ITM_TCU_POI_ID const& rhs){
    if (
         (lhs.uiPOI_ID == rhs.uiPOI_ID)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_POI_GPS_Position::tcl_ITM_TCU_POI_GPS_Position() : 
   aReserved(NULL, 0x01),
   eLocationType((tcl_ITM_TCU_e32_LocationType::tenType)0x00, 0x01),
   eLattitudeMode((tcl_ITM_TCU_e32_LattitudeMode::tenType)0x00, 0x01),
   eLongitudeMode((tcl_ITM_TCU_e32_LongitudeMode::tenType)0x00, 0x01),
   uiLattitudeDEG(0x00, 0x08),
   uiLattitudeMIN(0x00, 0x06),
   uiLattitudeSEC(0x00, 0x10),
   uiLongitudeDEG(0x00, 0x08),
   uiLongitudeMIN(0x00, 0x06),
   uiLongitudeSEC(0x00, 0x10)
{
}

tBool tcl_ITM_TCU_POI_GPS_Position::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = aReserved.bUpdateData(poMcanMsg);
   if (bRet) bRet = eLocationType.bUpdateData(poMcanMsg);
   if (bRet) bRet = eLattitudeMode.bUpdateData(poMcanMsg);
   if (bRet) bRet = eLongitudeMode.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiLattitudeDEG.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiLattitudeMIN.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiLattitudeSEC.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiLongitudeDEG.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiLongitudeMIN.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiLongitudeSEC.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_POI_GPS_Position::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   aReserved.bUpdateMcanMessage(poMcanMsg);
   eLocationType.bUpdateMcanMessage(poMcanMsg);
   eLattitudeMode.bUpdateMcanMessage(poMcanMsg);
   eLongitudeMode.bUpdateMcanMessage(poMcanMsg);
   uiLattitudeDEG.bUpdateMcanMessage(poMcanMsg);
   uiLattitudeMIN.bUpdateMcanMessage(poMcanMsg);
   uiLattitudeSEC.bUpdateMcanMessage(poMcanMsg);
   uiLongitudeDEG.bUpdateMcanMessage(poMcanMsg);
   uiLongitudeMIN.bUpdateMcanMessage(poMcanMsg);
   uiLongitudeSEC.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_POI_GPS_Position const& lhs, tcl_ITM_TCU_POI_GPS_Position const& rhs){
   if (lhs.aReserved != rhs.aReserved) return FALSE;
   if (lhs.eLocationType != rhs.eLocationType) return FALSE;
   if (lhs.eLattitudeMode != rhs.eLattitudeMode) return FALSE;
   if (lhs.eLongitudeMode != rhs.eLongitudeMode) return FALSE;
   if (lhs.uiLattitudeDEG != rhs.uiLattitudeDEG) return FALSE;
   if (lhs.uiLattitudeMIN != rhs.uiLattitudeMIN) return FALSE;
   if (lhs.uiLattitudeSEC != rhs.uiLattitudeSEC) return FALSE;
   if (lhs.uiLongitudeDEG != rhs.uiLongitudeDEG) return FALSE;
   if (lhs.uiLongitudeMIN != rhs.uiLongitudeMIN) return FALSE;
   if (lhs.uiLongitudeSEC != rhs.uiLongitudeSEC) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_POI_GPS_Position const& lhs, tcl_ITM_TCU_POI_GPS_Position const& rhs){
    if (
         (lhs.aReserved == rhs.aReserved)
      && (lhs.eLocationType == rhs.eLocationType)
      && (lhs.eLattitudeMode == rhs.eLattitudeMode)
      && (lhs.eLongitudeMode == rhs.eLongitudeMode)
      && (lhs.uiLattitudeDEG == rhs.uiLattitudeDEG)
      && (lhs.uiLattitudeMIN == rhs.uiLattitudeMIN)
      && (lhs.uiLattitudeSEC == rhs.uiLattitudeSEC)
      && (lhs.uiLongitudeDEG == rhs.uiLongitudeDEG)
      && (lhs.uiLongitudeMIN == rhs.uiLongitudeMIN)
      && (lhs.uiLongitudeSEC == rhs.uiLongitudeSEC)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_POI_Name::tcl_ITM_TCU_POI_Name() : 
   strPOI_Name(NULL, 0x02C0)
{
}

tBool tcl_ITM_TCU_POI_Name::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = strPOI_Name.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_POI_Name::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   strPOI_Name.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_POI_Name const& lhs, tcl_ITM_TCU_POI_Name const& rhs){
   if (lhs.strPOI_Name != rhs.strPOI_Name) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_POI_Name const& lhs, tcl_ITM_TCU_POI_Name const& rhs){
    if (
         (lhs.strPOI_Name == rhs.strPOI_Name)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Time_Slot::tcl_ITM_TCU_Time_Slot() : 
   uiStart_Time_Stamp_Year(0x00, 0x10),
   uiStart_Time_Stamp_Month(0x00, 0x04),
   uiStart_Time_Stamp_Day(0x00, 0x05),
   uiStart_Time_Stamp_Hour(0x00, 0x05),
   uiStart_Time_Stamp_Minute(0x00, 0x06),
   uiStart_Time_Stamp_Second(0x00, 0x06),
   aStart_Time_Stamp_Reserve(NULL, 0x06),
   uiStop_Time_Stamp_Year(0x00, 0x10),
   uiStop_Time_Stamp_Month(0x00, 0x04),
   uiStop_Time_Stamp_Day(0x00, 0x05),
   uiStop_Time_Stamp_Hour(0x00, 0x05),
   uiStop_Time_Stamp_Minute(0x00, 0x06),
   uiStop_Time_Stamp_Second(0x00, 0x06),
   aStop_Time_Stamp_Reserve(NULL, 0x06),
   eCycle((tcl_ITM_TCU_e32_Cycle::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_TCU_Time_Slot::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiStart_Time_Stamp_Year.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiStart_Time_Stamp_Month.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiStart_Time_Stamp_Day.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiStart_Time_Stamp_Hour.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiStart_Time_Stamp_Minute.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiStart_Time_Stamp_Second.bUpdateData(poMcanMsg);
   if (bRet) bRet = aStart_Time_Stamp_Reserve.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiStop_Time_Stamp_Year.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiStop_Time_Stamp_Month.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiStop_Time_Stamp_Day.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiStop_Time_Stamp_Hour.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiStop_Time_Stamp_Minute.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiStop_Time_Stamp_Second.bUpdateData(poMcanMsg);
   if (bRet) bRet = aStop_Time_Stamp_Reserve.bUpdateData(poMcanMsg);
   if (bRet) bRet = eCycle.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Time_Slot::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiStart_Time_Stamp_Year.bUpdateMcanMessage(poMcanMsg);
   uiStart_Time_Stamp_Month.bUpdateMcanMessage(poMcanMsg);
   uiStart_Time_Stamp_Day.bUpdateMcanMessage(poMcanMsg);
   uiStart_Time_Stamp_Hour.bUpdateMcanMessage(poMcanMsg);
   uiStart_Time_Stamp_Minute.bUpdateMcanMessage(poMcanMsg);
   uiStart_Time_Stamp_Second.bUpdateMcanMessage(poMcanMsg);
   aStart_Time_Stamp_Reserve.bUpdateMcanMessage(poMcanMsg);
   uiStop_Time_Stamp_Year.bUpdateMcanMessage(poMcanMsg);
   uiStop_Time_Stamp_Month.bUpdateMcanMessage(poMcanMsg);
   uiStop_Time_Stamp_Day.bUpdateMcanMessage(poMcanMsg);
   uiStop_Time_Stamp_Hour.bUpdateMcanMessage(poMcanMsg);
   uiStop_Time_Stamp_Minute.bUpdateMcanMessage(poMcanMsg);
   uiStop_Time_Stamp_Second.bUpdateMcanMessage(poMcanMsg);
   aStop_Time_Stamp_Reserve.bUpdateMcanMessage(poMcanMsg);
   eCycle.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Time_Slot const& lhs, tcl_ITM_TCU_Time_Slot const& rhs){
   if (lhs.uiStart_Time_Stamp_Year != rhs.uiStart_Time_Stamp_Year) return FALSE;
   if (lhs.uiStart_Time_Stamp_Month != rhs.uiStart_Time_Stamp_Month) return FALSE;
   if (lhs.uiStart_Time_Stamp_Day != rhs.uiStart_Time_Stamp_Day) return FALSE;
   if (lhs.uiStart_Time_Stamp_Hour != rhs.uiStart_Time_Stamp_Hour) return FALSE;
   if (lhs.uiStart_Time_Stamp_Minute != rhs.uiStart_Time_Stamp_Minute) return FALSE;
   if (lhs.uiStart_Time_Stamp_Second != rhs.uiStart_Time_Stamp_Second) return FALSE;
   if (lhs.aStart_Time_Stamp_Reserve != rhs.aStart_Time_Stamp_Reserve) return FALSE;
   if (lhs.uiStop_Time_Stamp_Year != rhs.uiStop_Time_Stamp_Year) return FALSE;
   if (lhs.uiStop_Time_Stamp_Month != rhs.uiStop_Time_Stamp_Month) return FALSE;
   if (lhs.uiStop_Time_Stamp_Day != rhs.uiStop_Time_Stamp_Day) return FALSE;
   if (lhs.uiStop_Time_Stamp_Hour != rhs.uiStop_Time_Stamp_Hour) return FALSE;
   if (lhs.uiStop_Time_Stamp_Minute != rhs.uiStop_Time_Stamp_Minute) return FALSE;
   if (lhs.uiStop_Time_Stamp_Second != rhs.uiStop_Time_Stamp_Second) return FALSE;
   if (lhs.aStop_Time_Stamp_Reserve != rhs.aStop_Time_Stamp_Reserve) return FALSE;
   if (lhs.eCycle != rhs.eCycle) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Time_Slot const& lhs, tcl_ITM_TCU_Time_Slot const& rhs){
    if (
         (lhs.uiStart_Time_Stamp_Year == rhs.uiStart_Time_Stamp_Year)
      && (lhs.uiStart_Time_Stamp_Month == rhs.uiStart_Time_Stamp_Month)
      && (lhs.uiStart_Time_Stamp_Day == rhs.uiStart_Time_Stamp_Day)
      && (lhs.uiStart_Time_Stamp_Hour == rhs.uiStart_Time_Stamp_Hour)
      && (lhs.uiStart_Time_Stamp_Minute == rhs.uiStart_Time_Stamp_Minute)
      && (lhs.uiStart_Time_Stamp_Second == rhs.uiStart_Time_Stamp_Second)
      && (lhs.aStart_Time_Stamp_Reserve == rhs.aStart_Time_Stamp_Reserve)
      && (lhs.uiStop_Time_Stamp_Year == rhs.uiStop_Time_Stamp_Year)
      && (lhs.uiStop_Time_Stamp_Month == rhs.uiStop_Time_Stamp_Month)
      && (lhs.uiStop_Time_Stamp_Day == rhs.uiStop_Time_Stamp_Day)
      && (lhs.uiStop_Time_Stamp_Hour == rhs.uiStop_Time_Stamp_Hour)
      && (lhs.uiStop_Time_Stamp_Minute == rhs.uiStop_Time_Stamp_Minute)
      && (lhs.uiStop_Time_Stamp_Second == rhs.uiStop_Time_Stamp_Second)
      && (lhs.aStop_Time_Stamp_Reserve == rhs.aStop_Time_Stamp_Reserve)
      && (lhs.eCycle == rhs.eCycle)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Limited_Vehicle_Speed::tcl_ITM_TCU_Limited_Vehicle_Speed() : 
   uiLimited_Vehicle_Speed(0x00, 0x10)
{
}

tBool tcl_ITM_TCU_Limited_Vehicle_Speed::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiLimited_Vehicle_Speed.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Limited_Vehicle_Speed::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiLimited_Vehicle_Speed.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Limited_Vehicle_Speed const& lhs, tcl_ITM_TCU_Limited_Vehicle_Speed const& rhs){
   if (lhs.uiLimited_Vehicle_Speed != rhs.uiLimited_Vehicle_Speed) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Limited_Vehicle_Speed const& lhs, tcl_ITM_TCU_Limited_Vehicle_Speed const& rhs){
    if (
         (lhs.uiLimited_Vehicle_Speed == rhs.uiLimited_Vehicle_Speed)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Area_Limit_Coordinates::tcl_ITM_TCU_Area_Limit_Coordinates() : 
   eRestriction_Area_Type((tcl_ITM_TCU_e32_Restriction_Area_Type::tenType)0x01, 0x08),
   eArea_Form((tcl_ITM_TCU_e32_Area_Form::tenType)0x01, 0x08),
   eLocationType((tcl_ITM_TCU_e32_Location_Type::tenType)0x01, 0x08),
   eArea_Coordinates_Coordinates_1_Lattitude_Mode((tcl_ITM_TCU_e32_North_South::tenType)0x00, 0x01),
   eArea_Coordinates_Coordinates_1_Longitude_Mode((tcl_ITM_TCU_e32_East_West::tenType)0x00, 0x01),
   uiArea_Coordinates_Coordinates_1_Lattitude_DEG(0x00, 0x08),
   uiArea_Coordinates_Coordinates_1_Lattitude_MIN(0x00, 0x08),
   uiArea_Coordinates_Coordinates_1_Lattitude_SEC(0x00, 0x10),
   uiArea_Coordinates_Coordinates_1_Longitude_DEG(0x00, 0x08),
   uiArea_Coordinates_Coordinates_1_Longitude_MIN(0x00, 0x08),
   uiArea_Coordinates_Coordinates_1_Longitude_SEC(0x00, 0x10),
   aArea_Coordinates_Coordinates_1_Reserve(NULL, 0x06),
   eArea_Coordinates_Coordinates_2_Lattitude_Mode((tcl_ITM_TCU_e32_North_South::tenType)0x00, 0x01),
   eArea_Coordinates_Coordinates_2_Longitude_Mode((tcl_ITM_TCU_e32_East_West::tenType)0x00, 0x01),
   uiArea_Coordinates_Coordinates_2_Lattitude_DEG(0x00, 0x08),
   uiArea_Coordinates_Coordinates_2_Lattitude_MIN(0x00, 0x08),
   uiArea_Coordinates_Coordinates_2_Lattitude_SEC(0x00, 0x10),
   uiArea_Coordinates_Coordinates_2_Longitude_DEG(0x00, 0x08),
   uiArea_Coordinates_Coordinates_2_Longitude_MIN(0x00, 0x08),
   uiArea_Coordinates_Coordinates_2_Longitude_SEC(0x00, 0x10),
   aArea_Coordinates_Coordinates_2_Reserve(NULL, 0x06),
   uiRadius(0x00, 0x10)
{
}

tBool tcl_ITM_TCU_Area_Limit_Coordinates::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eRestriction_Area_Type.bUpdateData(poMcanMsg);
   if (bRet) bRet = eArea_Form.bUpdateData(poMcanMsg);
   if (bRet) bRet = eLocationType.bUpdateData(poMcanMsg);
   if (bRet) bRet = eArea_Coordinates_Coordinates_1_Lattitude_Mode.bUpdateData(poMcanMsg);
   if (bRet) bRet = eArea_Coordinates_Coordinates_1_Longitude_Mode.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiArea_Coordinates_Coordinates_1_Lattitude_DEG.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiArea_Coordinates_Coordinates_1_Lattitude_MIN.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiArea_Coordinates_Coordinates_1_Lattitude_SEC.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiArea_Coordinates_Coordinates_1_Longitude_DEG.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiArea_Coordinates_Coordinates_1_Longitude_MIN.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiArea_Coordinates_Coordinates_1_Longitude_SEC.bUpdateData(poMcanMsg);
   if (bRet) bRet = aArea_Coordinates_Coordinates_1_Reserve.bUpdateData(poMcanMsg);
   if (bRet) bRet = eArea_Coordinates_Coordinates_2_Lattitude_Mode.bUpdateData(poMcanMsg);
   if (bRet) bRet = eArea_Coordinates_Coordinates_2_Longitude_Mode.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiArea_Coordinates_Coordinates_2_Lattitude_DEG.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiArea_Coordinates_Coordinates_2_Lattitude_MIN.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiArea_Coordinates_Coordinates_2_Lattitude_SEC.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiArea_Coordinates_Coordinates_2_Longitude_DEG.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiArea_Coordinates_Coordinates_2_Longitude_MIN.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiArea_Coordinates_Coordinates_2_Longitude_SEC.bUpdateData(poMcanMsg);
   if (bRet) bRet = aArea_Coordinates_Coordinates_2_Reserve.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiRadius.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Area_Limit_Coordinates::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eRestriction_Area_Type.bUpdateMcanMessage(poMcanMsg);
   eArea_Form.bUpdateMcanMessage(poMcanMsg);
   eLocationType.bUpdateMcanMessage(poMcanMsg);
   eArea_Coordinates_Coordinates_1_Lattitude_Mode.bUpdateMcanMessage(poMcanMsg);
   eArea_Coordinates_Coordinates_1_Longitude_Mode.bUpdateMcanMessage(poMcanMsg);
   uiArea_Coordinates_Coordinates_1_Lattitude_DEG.bUpdateMcanMessage(poMcanMsg);
   uiArea_Coordinates_Coordinates_1_Lattitude_MIN.bUpdateMcanMessage(poMcanMsg);
   uiArea_Coordinates_Coordinates_1_Lattitude_SEC.bUpdateMcanMessage(poMcanMsg);
   uiArea_Coordinates_Coordinates_1_Longitude_DEG.bUpdateMcanMessage(poMcanMsg);
   uiArea_Coordinates_Coordinates_1_Longitude_MIN.bUpdateMcanMessage(poMcanMsg);
   uiArea_Coordinates_Coordinates_1_Longitude_SEC.bUpdateMcanMessage(poMcanMsg);
   aArea_Coordinates_Coordinates_1_Reserve.bUpdateMcanMessage(poMcanMsg);
   eArea_Coordinates_Coordinates_2_Lattitude_Mode.bUpdateMcanMessage(poMcanMsg);
   eArea_Coordinates_Coordinates_2_Longitude_Mode.bUpdateMcanMessage(poMcanMsg);
   uiArea_Coordinates_Coordinates_2_Lattitude_DEG.bUpdateMcanMessage(poMcanMsg);
   uiArea_Coordinates_Coordinates_2_Lattitude_MIN.bUpdateMcanMessage(poMcanMsg);
   uiArea_Coordinates_Coordinates_2_Lattitude_SEC.bUpdateMcanMessage(poMcanMsg);
   uiArea_Coordinates_Coordinates_2_Longitude_DEG.bUpdateMcanMessage(poMcanMsg);
   uiArea_Coordinates_Coordinates_2_Longitude_MIN.bUpdateMcanMessage(poMcanMsg);
   uiArea_Coordinates_Coordinates_2_Longitude_SEC.bUpdateMcanMessage(poMcanMsg);
   aArea_Coordinates_Coordinates_2_Reserve.bUpdateMcanMessage(poMcanMsg);
   uiRadius.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Area_Limit_Coordinates const& lhs, tcl_ITM_TCU_Area_Limit_Coordinates const& rhs){
   if (lhs.eRestriction_Area_Type != rhs.eRestriction_Area_Type) return FALSE;
   if (lhs.eArea_Form != rhs.eArea_Form) return FALSE;
   if (lhs.eLocationType != rhs.eLocationType) return FALSE;
   if (lhs.eArea_Coordinates_Coordinates_1_Lattitude_Mode != rhs.eArea_Coordinates_Coordinates_1_Lattitude_Mode) return FALSE;
   if (lhs.eArea_Coordinates_Coordinates_1_Longitude_Mode != rhs.eArea_Coordinates_Coordinates_1_Longitude_Mode) return FALSE;
   if (lhs.uiArea_Coordinates_Coordinates_1_Lattitude_DEG != rhs.uiArea_Coordinates_Coordinates_1_Lattitude_DEG) return FALSE;
   if (lhs.uiArea_Coordinates_Coordinates_1_Lattitude_MIN != rhs.uiArea_Coordinates_Coordinates_1_Lattitude_MIN) return FALSE;
   if (lhs.uiArea_Coordinates_Coordinates_1_Lattitude_SEC != rhs.uiArea_Coordinates_Coordinates_1_Lattitude_SEC) return FALSE;
   if (lhs.uiArea_Coordinates_Coordinates_1_Longitude_DEG != rhs.uiArea_Coordinates_Coordinates_1_Longitude_DEG) return FALSE;
   if (lhs.uiArea_Coordinates_Coordinates_1_Longitude_MIN != rhs.uiArea_Coordinates_Coordinates_1_Longitude_MIN) return FALSE;
   if (lhs.uiArea_Coordinates_Coordinates_1_Longitude_SEC != rhs.uiArea_Coordinates_Coordinates_1_Longitude_SEC) return FALSE;
   if (lhs.aArea_Coordinates_Coordinates_1_Reserve != rhs.aArea_Coordinates_Coordinates_1_Reserve) return FALSE;
   if (lhs.eArea_Coordinates_Coordinates_2_Lattitude_Mode != rhs.eArea_Coordinates_Coordinates_2_Lattitude_Mode) return FALSE;
   if (lhs.eArea_Coordinates_Coordinates_2_Longitude_Mode != rhs.eArea_Coordinates_Coordinates_2_Longitude_Mode) return FALSE;
   if (lhs.uiArea_Coordinates_Coordinates_2_Lattitude_DEG != rhs.uiArea_Coordinates_Coordinates_2_Lattitude_DEG) return FALSE;
   if (lhs.uiArea_Coordinates_Coordinates_2_Lattitude_MIN != rhs.uiArea_Coordinates_Coordinates_2_Lattitude_MIN) return FALSE;
   if (lhs.uiArea_Coordinates_Coordinates_2_Lattitude_SEC != rhs.uiArea_Coordinates_Coordinates_2_Lattitude_SEC) return FALSE;
   if (lhs.uiArea_Coordinates_Coordinates_2_Longitude_DEG != rhs.uiArea_Coordinates_Coordinates_2_Longitude_DEG) return FALSE;
   if (lhs.uiArea_Coordinates_Coordinates_2_Longitude_MIN != rhs.uiArea_Coordinates_Coordinates_2_Longitude_MIN) return FALSE;
   if (lhs.uiArea_Coordinates_Coordinates_2_Longitude_SEC != rhs.uiArea_Coordinates_Coordinates_2_Longitude_SEC) return FALSE;
   if (lhs.aArea_Coordinates_Coordinates_2_Reserve != rhs.aArea_Coordinates_Coordinates_2_Reserve) return FALSE;
   if (lhs.uiRadius != rhs.uiRadius) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Area_Limit_Coordinates const& lhs, tcl_ITM_TCU_Area_Limit_Coordinates const& rhs){
    if (
         (lhs.eRestriction_Area_Type == rhs.eRestriction_Area_Type)
      && (lhs.eArea_Form == rhs.eArea_Form)
      && (lhs.eLocationType == rhs.eLocationType)
      && (lhs.eArea_Coordinates_Coordinates_1_Lattitude_Mode == rhs.eArea_Coordinates_Coordinates_1_Lattitude_Mode)
      && (lhs.eArea_Coordinates_Coordinates_1_Longitude_Mode == rhs.eArea_Coordinates_Coordinates_1_Longitude_Mode)
      && (lhs.uiArea_Coordinates_Coordinates_1_Lattitude_DEG == rhs.uiArea_Coordinates_Coordinates_1_Lattitude_DEG)
      && (lhs.uiArea_Coordinates_Coordinates_1_Lattitude_MIN == rhs.uiArea_Coordinates_Coordinates_1_Lattitude_MIN)
      && (lhs.uiArea_Coordinates_Coordinates_1_Lattitude_SEC == rhs.uiArea_Coordinates_Coordinates_1_Lattitude_SEC)
      && (lhs.uiArea_Coordinates_Coordinates_1_Longitude_DEG == rhs.uiArea_Coordinates_Coordinates_1_Longitude_DEG)
      && (lhs.uiArea_Coordinates_Coordinates_1_Longitude_MIN == rhs.uiArea_Coordinates_Coordinates_1_Longitude_MIN)
      && (lhs.uiArea_Coordinates_Coordinates_1_Longitude_SEC == rhs.uiArea_Coordinates_Coordinates_1_Longitude_SEC)
      && (lhs.aArea_Coordinates_Coordinates_1_Reserve == rhs.aArea_Coordinates_Coordinates_1_Reserve)
      && (lhs.eArea_Coordinates_Coordinates_2_Lattitude_Mode == rhs.eArea_Coordinates_Coordinates_2_Lattitude_Mode)
      && (lhs.eArea_Coordinates_Coordinates_2_Longitude_Mode == rhs.eArea_Coordinates_Coordinates_2_Longitude_Mode)
      && (lhs.uiArea_Coordinates_Coordinates_2_Lattitude_DEG == rhs.uiArea_Coordinates_Coordinates_2_Lattitude_DEG)
      && (lhs.uiArea_Coordinates_Coordinates_2_Lattitude_MIN == rhs.uiArea_Coordinates_Coordinates_2_Lattitude_MIN)
      && (lhs.uiArea_Coordinates_Coordinates_2_Lattitude_SEC == rhs.uiArea_Coordinates_Coordinates_2_Lattitude_SEC)
      && (lhs.uiArea_Coordinates_Coordinates_2_Longitude_DEG == rhs.uiArea_Coordinates_Coordinates_2_Longitude_DEG)
      && (lhs.uiArea_Coordinates_Coordinates_2_Longitude_MIN == rhs.uiArea_Coordinates_Coordinates_2_Longitude_MIN)
      && (lhs.uiArea_Coordinates_Coordinates_2_Longitude_SEC == rhs.uiArea_Coordinates_Coordinates_2_Longitude_SEC)
      && (lhs.aArea_Coordinates_Coordinates_2_Reserve == rhs.aArea_Coordinates_Coordinates_2_Reserve)
      && (lhs.uiRadius == rhs.uiRadius)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Geofencing_Activation_State::tcl_ITM_TCU_Geofencing_Activation_State() : 
   eGeofencing_Activation_State((tcl_ITM_TCU_e32_Geofencing_Activation_State::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_TCU_Geofencing_Activation_State::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eGeofencing_Activation_State.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Geofencing_Activation_State::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eGeofencing_Activation_State.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Geofencing_Activation_State const& lhs, tcl_ITM_TCU_Geofencing_Activation_State const& rhs){
   if (lhs.eGeofencing_Activation_State != rhs.eGeofencing_Activation_State) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Geofencing_Activation_State const& lhs, tcl_ITM_TCU_Geofencing_Activation_State const& rhs){
    if (
         (lhs.eGeofencing_Activation_State == rhs.eGeofencing_Activation_State)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Time_Limit_Restriction::tcl_ITM_TCU_Time_Limit_Restriction() : 
   uiNumber_Of_Time_Slot(0x01, 0x08)
{
   vecTime_Limit_Restriction.clear();
}

tBool tcl_ITM_TCU_Time_Limit_Restriction::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiNumber_Of_Time_Slot.bUpdateData(poMcanMsg);
     for (tU32 i=0; bRet==TRUE && i<uiNumber_Of_Time_Slot.u32GetData(); i++) {
        tclTime_Limit_Restriction oNew;
        if (bRet) bRet = oNew.uiTime_Slot_Start_Time_Stamp_Year.bUpdateData(poMcanMsg);
        if (bRet) bRet = oNew.uiTime_Slot_Start_Time_Stamp_Month.bUpdateData(poMcanMsg);
        if (bRet) bRet = oNew.uiTime_Slot_Start_Time_Stamp_Day.bUpdateData(poMcanMsg);
        if (bRet) bRet = oNew.uiTime_Slot_Start_Time_Stamp_Hour.bUpdateData(poMcanMsg);
        if (bRet) bRet = oNew.uiTime_Slot_Start_Time_Stamp_Minute.bUpdateData(poMcanMsg);
        if (bRet) bRet = oNew.uiTime_Slot_Start_Time_Stamp_Second.bUpdateData(poMcanMsg);
        if (bRet) bRet = oNew.aTime_Slot_Start_Time_Stamp_Reserve.bUpdateData(poMcanMsg);
        if (bRet) bRet = oNew.uiTime_Slot_Stop_Time_Stamp_Year.bUpdateData(poMcanMsg);
        if (bRet) bRet = oNew.uiTime_Slot_Stop_Time_Stamp_Month.bUpdateData(poMcanMsg);
        if (bRet) bRet = oNew.uiTime_Slot_Stop_Time_Stamp_Day.bUpdateData(poMcanMsg);
        if (bRet) bRet = oNew.uiTime_Slot_Stop_Time_Stamp_Hour.bUpdateData(poMcanMsg);
        if (bRet) bRet = oNew.uiTime_Slot_Stop_Time_Stamp_Minute.bUpdateData(poMcanMsg);
        if (bRet) bRet = oNew.uiTime_Slot_Stop_Time_Stamp_Second.bUpdateData(poMcanMsg);
        if (bRet) bRet = oNew.aTime_Slot_Stop_Time_Stamp_Reserve.bUpdateData(poMcanMsg);
        if (bRet) bRet = oNew.eTime_Slot_Cycle.bUpdateData(poMcanMsg);
        if (bRet)        vecTime_Limit_Restriction.push_back(oNew);
     }

   return bRet;
}

tVoid tcl_ITM_TCU_Time_Limit_Restriction::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiNumber_Of_Time_Slot.vSetData(vecTime_Limit_Restriction.size());
   uiNumber_Of_Time_Slot.bUpdateMcanMessage(poMcanMsg);
   ::std::vector < tclTime_Limit_Restriction >::iterator it;
   for (it = vecTime_Limit_Restriction.begin(); it != vecTime_Limit_Restriction.end(); ++it){;
       it->uiTime_Slot_Start_Time_Stamp_Year.bUpdateMcanMessage(poMcanMsg);
       it->uiTime_Slot_Start_Time_Stamp_Month.bUpdateMcanMessage(poMcanMsg);
       it->uiTime_Slot_Start_Time_Stamp_Day.bUpdateMcanMessage(poMcanMsg);
       it->uiTime_Slot_Start_Time_Stamp_Hour.bUpdateMcanMessage(poMcanMsg);
       it->uiTime_Slot_Start_Time_Stamp_Minute.bUpdateMcanMessage(poMcanMsg);
       it->uiTime_Slot_Start_Time_Stamp_Second.bUpdateMcanMessage(poMcanMsg);
       it->aTime_Slot_Start_Time_Stamp_Reserve.bUpdateMcanMessage(poMcanMsg);
       it->uiTime_Slot_Stop_Time_Stamp_Year.bUpdateMcanMessage(poMcanMsg);
       it->uiTime_Slot_Stop_Time_Stamp_Month.bUpdateMcanMessage(poMcanMsg);
       it->uiTime_Slot_Stop_Time_Stamp_Day.bUpdateMcanMessage(poMcanMsg);
       it->uiTime_Slot_Stop_Time_Stamp_Hour.bUpdateMcanMessage(poMcanMsg);
       it->uiTime_Slot_Stop_Time_Stamp_Minute.bUpdateMcanMessage(poMcanMsg);
       it->uiTime_Slot_Stop_Time_Stamp_Second.bUpdateMcanMessage(poMcanMsg);
       it->aTime_Slot_Stop_Time_Stamp_Reserve.bUpdateMcanMessage(poMcanMsg);
       it->eTime_Slot_Cycle.bUpdateMcanMessage(poMcanMsg);
   }

}

tBool operator==(tcl_ITM_TCU_Time_Limit_Restriction const& lhs, tcl_ITM_TCU_Time_Limit_Restriction const& rhs){
   if (lhs.uiNumber_Of_Time_Slot != rhs.uiNumber_Of_Time_Slot) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Time_Limit_Restriction const& lhs, tcl_ITM_TCU_Time_Limit_Restriction const& rhs){
    if (
         (lhs.uiNumber_Of_Time_Slot == rhs.uiNumber_Of_Time_Slot)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

#if 0
tcl_ITM_TCU_Speed_Limit_Restriction::tcl_ITM_TCU_Speed_Limit_Restriction() : 
   uiNumber_Of_Speed_Limit(0x01, 0x08),
   Limited_Vehicle_Speed(0x00, 0x10),
   uiNumber_Of_Time_Slot(0x01, 0x08)
{
   vecSpeed_Limit_Restriction.clear();
}

tBool tcl_ITM_TCU_Speed_Limit_Restriction::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiNumber_Of_Speed_Limit.bUpdateData(poMcanMsg);
   if (bRet) bRet = Limited_Vehicle_Speed.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiNumber_Of_Time_Slot.bUpdateData(poMcanMsg);
     for (tU32 i=0; bRet==TRUE && i<uiNumber_Of_Time_Slot.u32GetData(); i++) {
        tclSpeed_Limit_Restriction oNew;
        if (bRet) bRet = oNew.uiTime_Slot_Start_Time_Stamp_Year.bUpdateData(poMcanMsg);
        if (bRet) bRet = oNew.uiTime_Slot_Start_Time_Stamp_Month.bUpdateData(poMcanMsg);
        if (bRet) bRet = oNew.uiTime_Slot_Start_Time_Stamp_Day.bUpdateData(poMcanMsg);
        if (bRet) bRet = oNew.uiTime_Slot_Start_Time_Stamp_Hour.bUpdateData(poMcanMsg);
        if (bRet) bRet = oNew.uiTime_Slot_Start_Time_Stamp_Minute.bUpdateData(poMcanMsg);
        if (bRet) bRet = oNew.uiTime_Slot_Start_Time_Stamp_Second.bUpdateData(poMcanMsg);
        if (bRet) bRet = oNew.aTime_Slot_Start_Time_Stamp_Reserve.bUpdateData(poMcanMsg);
        if (bRet) bRet = oNew.uiTime_Slot_Stop_Time_Stamp_Year.bUpdateData(poMcanMsg);
        if (bRet) bRet = oNew.uiTime_Slot_Stop_Time_Stamp_Month.bUpdateData(poMcanMsg);
        if (bRet) bRet = oNew.uiTime_Slot_Stop_Time_Stamp_Day.bUpdateData(poMcanMsg);
        if (bRet) bRet = oNew.uiTime_Slot_Stop_Time_Stamp_Hour.bUpdateData(poMcanMsg);
        if (bRet) bRet = oNew.uiTime_Slot_Stop_Time_Stamp_Minute.bUpdateData(poMcanMsg);
        if (bRet) bRet = oNew.uiTime_Slot_Stop_Time_Stamp_Second.bUpdateData(poMcanMsg);
        if (bRet) bRet = oNew.aTime_Slot_Stop_Time_Stamp_Reserve.bUpdateData(poMcanMsg);
        if (bRet) bRet = oNew.eTime_Slot_Cycle.bUpdateData(poMcanMsg);
        if (bRet)        vecSpeed_Limit_Restriction.push_back(oNew);
     }

   return bRet;
}

tVoid tcl_ITM_TCU_Speed_Limit_Restriction::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiNumber_Of_Time_Slot.vSetData(vecSpeed_Limit_Restriction.size());
   uiNumber_Of_Speed_Limit.bUpdateMcanMessage(poMcanMsg);
   Limited_Vehicle_Speed.bUpdateMcanMessage(poMcanMsg);
   uiNumber_Of_Time_Slot.bUpdateMcanMessage(poMcanMsg);
   ::std::vector < tclSpeed_Limit_Restriction >::iterator it;
   for (it = vecSpeed_Limit_Restriction.begin(); it != vecSpeed_Limit_Restriction.end(); ++it){;
       it->uiTime_Slot_Start_Time_Stamp_Year.bUpdateMcanMessage(poMcanMsg);
       it->uiTime_Slot_Start_Time_Stamp_Month.bUpdateMcanMessage(poMcanMsg);
       it->uiTime_Slot_Start_Time_Stamp_Day.bUpdateMcanMessage(poMcanMsg);
       it->uiTime_Slot_Start_Time_Stamp_Hour.bUpdateMcanMessage(poMcanMsg);
       it->uiTime_Slot_Start_Time_Stamp_Minute.bUpdateMcanMessage(poMcanMsg);
       it->uiTime_Slot_Start_Time_Stamp_Second.bUpdateMcanMessage(poMcanMsg);
       it->aTime_Slot_Start_Time_Stamp_Reserve.bUpdateMcanMessage(poMcanMsg);
       it->uiTime_Slot_Stop_Time_Stamp_Year.bUpdateMcanMessage(poMcanMsg);
       it->uiTime_Slot_Stop_Time_Stamp_Month.bUpdateMcanMessage(poMcanMsg);
       it->uiTime_Slot_Stop_Time_Stamp_Day.bUpdateMcanMessage(poMcanMsg);
       it->uiTime_Slot_Stop_Time_Stamp_Hour.bUpdateMcanMessage(poMcanMsg);
       it->uiTime_Slot_Stop_Time_Stamp_Minute.bUpdateMcanMessage(poMcanMsg);
       it->uiTime_Slot_Stop_Time_Stamp_Second.bUpdateMcanMessage(poMcanMsg);
       it->aTime_Slot_Stop_Time_Stamp_Reserve.bUpdateMcanMessage(poMcanMsg);
       it->eTime_Slot_Cycle.bUpdateMcanMessage(poMcanMsg);
   }

}

tBool operator==(tcl_ITM_TCU_Speed_Limit_Restriction const& lhs, tcl_ITM_TCU_Speed_Limit_Restriction const& rhs){
   if (lhs.uiNumber_Of_Speed_Limit != rhs.uiNumber_Of_Speed_Limit) return FALSE;
   if (lhs.Limited_Vehicle_Speed != rhs.Limited_Vehicle_Speed) return FALSE;
   if (lhs.uiNumber_Of_Time_Slot != rhs.uiNumber_Of_Time_Slot) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Speed_Limit_Restriction const& lhs, tcl_ITM_TCU_Speed_Limit_Restriction const& rhs){
    if (
         (lhs.uiNumber_Of_Speed_Limit == rhs.uiNumber_Of_Speed_Limit)
      && (lhs.Limited_Vehicle_Speed == rhs.Limited_Vehicle_Speed)
      && (lhs.uiNumber_Of_Time_Slot == rhs.uiNumber_Of_Time_Slot)

    ) {
        return FALSE;
    }
    
    return TRUE;
}
#endif

tcl_ITM_TCU_Area_Limit_Restriction::tcl_ITM_TCU_Area_Limit_Restriction() : 
   uiNumber_Of_Area(0x01, 0x08)
{
   vecArea_Limit_Restriction.clear();
}

tBool tcl_ITM_TCU_Area_Limit_Restriction::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiNumber_Of_Area.bUpdateData(poMcanMsg);
     for (tU32 i=0; bRet==TRUE && i<uiNumber_Of_Area.u32GetData(); i++) {
        tclArea_Limit_Restriction oNew;
        if (bRet) bRet = oNew.eArea_Limit_Coordinates_Restriction_Area_Type.bUpdateData(poMcanMsg);
        if (bRet) bRet = oNew.eArea_Limit_Coordinates_Area_Form.bUpdateData(poMcanMsg);
        if (bRet) bRet = oNew.eArea_Limit_Coordinates_LocationType.bUpdateData(poMcanMsg);
        if (bRet) bRet = oNew.eArea_Limit_Coordinates_Area_Coordinates_Coordinates_1_Lattitude_Mode.bUpdateData(poMcanMsg);
        if (bRet) bRet = oNew.eArea_Limit_Coordinates_Area_Coordinates_Coordinates_1_Longitude_Mode.bUpdateData(poMcanMsg);
        if (bRet) bRet = oNew.uiArea_Limit_Coordinates_Area_Coordinates_Coordinates_1_Lattitude_DEG.bUpdateData(poMcanMsg);
        if (bRet) bRet = oNew.uiArea_Limit_Coordinates_Area_Coordinates_Coordinates_1_Lattitude_MIN.bUpdateData(poMcanMsg);
        if (bRet) bRet = oNew.uiArea_Limit_Coordinates_Area_Coordinates_Coordinates_1_Lattitude_SEC.bUpdateData(poMcanMsg);
        if (bRet) bRet = oNew.uiArea_Limit_Coordinates_Area_Coordinates_Coordinates_1_Longitude_DEG.bUpdateData(poMcanMsg);
        if (bRet) bRet = oNew.uiArea_Limit_Coordinates_Area_Coordinates_Coordinates_1_Longitude_MIN.bUpdateData(poMcanMsg);
        if (bRet) bRet = oNew.uiArea_Limit_Coordinates_Area_Coordinates_Coordinates_1_Longitude_SEC.bUpdateData(poMcanMsg);
        if (bRet) bRet = oNew.aArea_Limit_Coordinates_Area_Coordinates_Coordinates_1_Reserve.bUpdateData(poMcanMsg);
        if (bRet) bRet = oNew.eArea_Limit_Coordinates_Area_Coordinates_Coordinates_2_Lattitude_Mode.bUpdateData(poMcanMsg);
        if (bRet) bRet = oNew.eArea_Limit_Coordinates_Area_Coordinates_Coordinates_2_Longitude_Mode.bUpdateData(poMcanMsg);
        if (bRet) bRet = oNew.uiArea_Limit_Coordinates_Area_Coordinates_Coordinates_2_Lattitude_DEG.bUpdateData(poMcanMsg);
        if (bRet) bRet = oNew.uiArea_Limit_Coordinates_Area_Coordinates_Coordinates_2_Lattitude_MIN.bUpdateData(poMcanMsg);
        if (bRet) bRet = oNew.uiArea_Limit_Coordinates_Area_Coordinates_Coordinates_2_Lattitude_SEC.bUpdateData(poMcanMsg);
        if (bRet) bRet = oNew.uiArea_Limit_Coordinates_Area_Coordinates_Coordinates_2_Longitude_DEG.bUpdateData(poMcanMsg);
        if (bRet) bRet = oNew.uiArea_Limit_Coordinates_Area_Coordinates_Coordinates_2_Longitude_MIN.bUpdateData(poMcanMsg);
        if (bRet) bRet = oNew.uiArea_Limit_Coordinates_Area_Coordinates_Coordinates_2_Longitude_SEC.bUpdateData(poMcanMsg);
        if (bRet) bRet = oNew.aArea_Limit_Coordinates_Area_Coordinates_Coordinates_2_Reserve.bUpdateData(poMcanMsg);
        if (bRet) bRet = oNew.uiArea_Limit_Coordinates_Radius.bUpdateData(poMcanMsg);
        if (bRet) bRet = oNew.uiNumber_Of_Time_Slot.bUpdateData(poMcanMsg);
        if (bRet) bRet = oNew.uiTime_Slot_Start_Time_Stamp_Year.bUpdateData(poMcanMsg);
        if (bRet) bRet = oNew.uiTime_Slot_Start_Time_Stamp_Month.bUpdateData(poMcanMsg);
        if (bRet) bRet = oNew.uiTime_Slot_Start_Time_Stamp_Day.bUpdateData(poMcanMsg);
        if (bRet) bRet = oNew.uiTime_Slot_Start_Time_Stamp_Hour.bUpdateData(poMcanMsg);
        if (bRet) bRet = oNew.uiTime_Slot_Start_Time_Stamp_Minute.bUpdateData(poMcanMsg);
        if (bRet) bRet = oNew.uiTime_Slot_Start_Time_Stamp_Second.bUpdateData(poMcanMsg);
        if (bRet) bRet = oNew.aTime_Slot_Start_Time_Stamp_Reserve.bUpdateData(poMcanMsg);
        if (bRet) bRet = oNew.uiTime_Slot_Stop_Time_Stamp_Year.bUpdateData(poMcanMsg);
        if (bRet) bRet = oNew.uiTime_Slot_Stop_Time_Stamp_Month.bUpdateData(poMcanMsg);
        if (bRet) bRet = oNew.uiTime_Slot_Stop_Time_Stamp_Day.bUpdateData(poMcanMsg);
        if (bRet) bRet = oNew.uiTime_Slot_Stop_Time_Stamp_Hour.bUpdateData(poMcanMsg);
        if (bRet) bRet = oNew.uiTime_Slot_Stop_Time_Stamp_Minute.bUpdateData(poMcanMsg);
        if (bRet) bRet = oNew.uiTime_Slot_Stop_Time_Stamp_Second.bUpdateData(poMcanMsg);
        if (bRet) bRet = oNew.aTime_Slot_Stop_Time_Stamp_Reserve.bUpdateData(poMcanMsg);
        if (bRet) bRet = oNew.eTime_Slot_Cycle.bUpdateData(poMcanMsg);
        if (bRet)        vecArea_Limit_Restriction.push_back(oNew);
     }

   return bRet;
}

tVoid tcl_ITM_TCU_Area_Limit_Restriction::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiNumber_Of_Area.vSetData(vecArea_Limit_Restriction.size());
   uiNumber_Of_Area.bUpdateMcanMessage(poMcanMsg);
   ::std::vector < tclArea_Limit_Restriction >::iterator it;
   for (it = vecArea_Limit_Restriction.begin(); it != vecArea_Limit_Restriction.end(); ++it){;
       it->eArea_Limit_Coordinates_Restriction_Area_Type.bUpdateMcanMessage(poMcanMsg);
       it->eArea_Limit_Coordinates_Area_Form.bUpdateMcanMessage(poMcanMsg);
       it->eArea_Limit_Coordinates_LocationType.bUpdateMcanMessage(poMcanMsg);
       it->eArea_Limit_Coordinates_Area_Coordinates_Coordinates_1_Lattitude_Mode.bUpdateMcanMessage(poMcanMsg);
       it->eArea_Limit_Coordinates_Area_Coordinates_Coordinates_1_Longitude_Mode.bUpdateMcanMessage(poMcanMsg);
       it->uiArea_Limit_Coordinates_Area_Coordinates_Coordinates_1_Lattitude_DEG.bUpdateMcanMessage(poMcanMsg);
       it->uiArea_Limit_Coordinates_Area_Coordinates_Coordinates_1_Lattitude_MIN.bUpdateMcanMessage(poMcanMsg);
       it->uiArea_Limit_Coordinates_Area_Coordinates_Coordinates_1_Lattitude_SEC.bUpdateMcanMessage(poMcanMsg);
       it->uiArea_Limit_Coordinates_Area_Coordinates_Coordinates_1_Longitude_DEG.bUpdateMcanMessage(poMcanMsg);
       it->uiArea_Limit_Coordinates_Area_Coordinates_Coordinates_1_Longitude_MIN.bUpdateMcanMessage(poMcanMsg);
       it->uiArea_Limit_Coordinates_Area_Coordinates_Coordinates_1_Longitude_SEC.bUpdateMcanMessage(poMcanMsg);
       it->aArea_Limit_Coordinates_Area_Coordinates_Coordinates_1_Reserve.bUpdateMcanMessage(poMcanMsg);
       it->eArea_Limit_Coordinates_Area_Coordinates_Coordinates_2_Lattitude_Mode.bUpdateMcanMessage(poMcanMsg);
       it->eArea_Limit_Coordinates_Area_Coordinates_Coordinates_2_Longitude_Mode.bUpdateMcanMessage(poMcanMsg);
       it->uiArea_Limit_Coordinates_Area_Coordinates_Coordinates_2_Lattitude_DEG.bUpdateMcanMessage(poMcanMsg);
       it->uiArea_Limit_Coordinates_Area_Coordinates_Coordinates_2_Lattitude_MIN.bUpdateMcanMessage(poMcanMsg);
       it->uiArea_Limit_Coordinates_Area_Coordinates_Coordinates_2_Lattitude_SEC.bUpdateMcanMessage(poMcanMsg);
       it->uiArea_Limit_Coordinates_Area_Coordinates_Coordinates_2_Longitude_DEG.bUpdateMcanMessage(poMcanMsg);
       it->uiArea_Limit_Coordinates_Area_Coordinates_Coordinates_2_Longitude_MIN.bUpdateMcanMessage(poMcanMsg);
       it->uiArea_Limit_Coordinates_Area_Coordinates_Coordinates_2_Longitude_SEC.bUpdateMcanMessage(poMcanMsg);
       it->aArea_Limit_Coordinates_Area_Coordinates_Coordinates_2_Reserve.bUpdateMcanMessage(poMcanMsg);
       it->uiArea_Limit_Coordinates_Radius.bUpdateMcanMessage(poMcanMsg);
       it->uiNumber_Of_Time_Slot.bUpdateMcanMessage(poMcanMsg);
       it->uiTime_Slot_Start_Time_Stamp_Year.bUpdateMcanMessage(poMcanMsg);
       it->uiTime_Slot_Start_Time_Stamp_Month.bUpdateMcanMessage(poMcanMsg);
       it->uiTime_Slot_Start_Time_Stamp_Day.bUpdateMcanMessage(poMcanMsg);
       it->uiTime_Slot_Start_Time_Stamp_Hour.bUpdateMcanMessage(poMcanMsg);
       it->uiTime_Slot_Start_Time_Stamp_Minute.bUpdateMcanMessage(poMcanMsg);
       it->uiTime_Slot_Start_Time_Stamp_Second.bUpdateMcanMessage(poMcanMsg);
       it->aTime_Slot_Start_Time_Stamp_Reserve.bUpdateMcanMessage(poMcanMsg);
       it->uiTime_Slot_Stop_Time_Stamp_Year.bUpdateMcanMessage(poMcanMsg);
       it->uiTime_Slot_Stop_Time_Stamp_Month.bUpdateMcanMessage(poMcanMsg);
       it->uiTime_Slot_Stop_Time_Stamp_Day.bUpdateMcanMessage(poMcanMsg);
       it->uiTime_Slot_Stop_Time_Stamp_Hour.bUpdateMcanMessage(poMcanMsg);
       it->uiTime_Slot_Stop_Time_Stamp_Minute.bUpdateMcanMessage(poMcanMsg);
       it->uiTime_Slot_Stop_Time_Stamp_Second.bUpdateMcanMessage(poMcanMsg);
       it->aTime_Slot_Stop_Time_Stamp_Reserve.bUpdateMcanMessage(poMcanMsg);
       it->eTime_Slot_Cycle.bUpdateMcanMessage(poMcanMsg);
   }

}

tBool operator==(tcl_ITM_TCU_Area_Limit_Restriction const& lhs, tcl_ITM_TCU_Area_Limit_Restriction const& rhs){
   if (lhs.uiNumber_Of_Area != rhs.uiNumber_Of_Area) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Area_Limit_Restriction const& lhs, tcl_ITM_TCU_Area_Limit_Restriction const& rhs){
    if (
         (lhs.uiNumber_Of_Area == rhs.uiNumber_Of_Area)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Connection_Type::tcl_ITM_TCU_Connection_Type() : 
   eConnection_Type((tcl_ITM_TCU_e32_Connection_Type::tenType)0x01, 0x08)
{
}

tBool tcl_ITM_TCU_Connection_Type::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eConnection_Type.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Connection_Type::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eConnection_Type.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Connection_Type const& lhs, tcl_ITM_TCU_Connection_Type const& rhs){
   if (lhs.eConnection_Type != rhs.eConnection_Type) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Connection_Type const& lhs, tcl_ITM_TCU_Connection_Type const& rhs){
    if (
         (lhs.eConnection_Type == rhs.eConnection_Type)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_XCALL_Type::tcl_ITM_TCU_XCALL_Type() : 
   eXCALL_Type((tcl_ITM_TCU_e32_XCALL_Type::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_TCU_XCALL_Type::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eXCALL_Type.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_XCALL_Type::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eXCALL_Type.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_XCALL_Type const& lhs, tcl_ITM_TCU_XCALL_Type const& rhs){
   if (lhs.eXCALL_Type != rhs.eXCALL_Type) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_XCALL_Type const& lhs, tcl_ITM_TCU_XCALL_Type const& rhs){
    if (
         (lhs.eXCALL_Type == rhs.eXCALL_Type)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_XCALL_Language::tcl_ITM_TCU_XCALL_Language() : 
   eXCALL_Language((tcl_ITM_TCU_e32_XCALL_Language::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_TCU_XCALL_Language::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eXCALL_Language.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_XCALL_Language::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eXCALL_Language.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_XCALL_Language const& lhs, tcl_ITM_TCU_XCALL_Language const& rhs){
   if (lhs.eXCALL_Language != rhs.eXCALL_Language) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_XCALL_Language const& lhs, tcl_ITM_TCU_XCALL_Language const& rhs){
    if (
         (lhs.eXCALL_Language == rhs.eXCALL_Language)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_TCU_Privacy_Mode_State::tcl_ITM_TCU_Privacy_Mode_State() : 
   ePrivacy_Mode_State((tcl_ITM_TCU_e32_Privacy_Manager_State::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_TCU_Privacy_Mode_State::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = ePrivacy_Mode_State.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_TCU_Privacy_Mode_State::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   ePrivacy_Mode_State.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_TCU_Privacy_Mode_State const& lhs, tcl_ITM_TCU_Privacy_Mode_State const& rhs){
   if (lhs.ePrivacy_Mode_State != rhs.ePrivacy_Mode_State) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_TCU_Privacy_Mode_State const& lhs, tcl_ITM_TCU_Privacy_Mode_State const& rhs){
    if (
         (lhs.ePrivacy_Mode_State == rhs.ePrivacy_Mode_State)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

