/*!
  *  \file mcanParameter.cpp
  *  \brief generated file containing enumeration info for MCAN communication.
  *         generated at  : --.--.2016
  *         generated with: python .\genericCodeGen.py -i .\tmpl\mcanParameter.cpp.tpl -b .\CanSimu2\config\mcan -o .\enumTest\mcanParameter.cpp
*/

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FD_CSM_MCAN
#include "trcGenProj/Header/mcanParameterCameraSys.cpp.trc.h"
#endif

#include "mcanParameterCameraSys.h"


tcl_ITM_Camera_System_Msg_Version::tcl_ITM_Camera_System_Msg_Version() : 
   uiVersion_Upper_(0x00, 0x08),
   uiVersion_Middle_(0x00, 0x08),
   aReserve(NULL, 0x08)
{
}

tBool tcl_ITM_Camera_System_Msg_Version::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiVersion_Upper_.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiVersion_Middle_.bUpdateData(poMcanMsg);
   if (bRet) bRet = aReserve.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Camera_System_Msg_Version::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiVersion_Upper_.bUpdateMcanMessage(poMcanMsg);
   uiVersion_Middle_.bUpdateMcanMessage(poMcanMsg);
   aReserve.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Camera_System_Msg_Version const& lhs, tcl_ITM_Camera_System_Msg_Version const& rhs){
   if (lhs.uiVersion_Upper_ != rhs.uiVersion_Upper_) return FALSE;
   if (lhs.uiVersion_Middle_ != rhs.uiVersion_Middle_) return FALSE;
   if (lhs.aReserve != rhs.aReserve) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Camera_System_Msg_Version const& lhs, tcl_ITM_Camera_System_Msg_Version const& rhs){
    if (
         (lhs.uiVersion_Upper_ == rhs.uiVersion_Upper_)
      && (lhs.uiVersion_Middle_ == rhs.uiVersion_Middle_)
      && (lhs.aReserve == rhs.aReserve)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Camera_System_Unit_ID::tcl_ITM_Camera_System_Unit_ID() : 
   eSTR((tcl_ITM_Camera_System_e32_STR::tenType)0x00, 0x02),
   eGear((tcl_ITM_Camera_System_e32_Gear::tenType)0x00, 0x01),
   eSIDEVIEW((tcl_ITM_Camera_System_e32_SIDEVIEW::tenType)0x00, 0x01),
   eLHRH((tcl_ITM_Camera_System_e32_LHRH::tenType)0x00, 0x01),
   eSonar((tcl_ITM_Camera_System_e32_Sonar::tenType)0x00, 0x01),
   eRearWide((tcl_ITM_Camera_System_e32_RearWide::tenType)0x00, 0x01),
   eFrontWide((tcl_ITM_Camera_System_e32_FrontWide::tenType)0x00, 0x01)
{
}

tBool tcl_ITM_Camera_System_Unit_ID::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eSTR.bUpdateData(poMcanMsg);
   if (bRet) bRet = eGear.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSIDEVIEW.bUpdateData(poMcanMsg);
   if (bRet) bRet = eLHRH.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSonar.bUpdateData(poMcanMsg);
   if (bRet) bRet = eRearWide.bUpdateData(poMcanMsg);
   if (bRet) bRet = eFrontWide.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Camera_System_Unit_ID::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eSTR.bUpdateMcanMessage(poMcanMsg);
   eGear.bUpdateMcanMessage(poMcanMsg);
   eSIDEVIEW.bUpdateMcanMessage(poMcanMsg);
   eLHRH.bUpdateMcanMessage(poMcanMsg);
   eSonar.bUpdateMcanMessage(poMcanMsg);
   eRearWide.bUpdateMcanMessage(poMcanMsg);
   eFrontWide.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Camera_System_Unit_ID const& lhs, tcl_ITM_Camera_System_Unit_ID const& rhs){
   if (lhs.eSTR != rhs.eSTR) return FALSE;
   if (lhs.eGear != rhs.eGear) return FALSE;
   if (lhs.eSIDEVIEW != rhs.eSIDEVIEW) return FALSE;
   if (lhs.eLHRH != rhs.eLHRH) return FALSE;
   if (lhs.eSonar != rhs.eSonar) return FALSE;
   if (lhs.eRearWide != rhs.eRearWide) return FALSE;
   if (lhs.eFrontWide != rhs.eFrontWide) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Camera_System_Unit_ID const& lhs, tcl_ITM_Camera_System_Unit_ID const& rhs){
    if (
         (lhs.eSTR == rhs.eSTR)
      && (lhs.eGear == rhs.eGear)
      && (lhs.eSIDEVIEW == rhs.eSIDEVIEW)
      && (lhs.eLHRH == rhs.eLHRH)
      && (lhs.eSonar == rhs.eSonar)
      && (lhs.eRearWide == rhs.eRearWide)
      && (lhs.eFrontWide == rhs.eFrontWide)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Camera_System_Hardware_Version::tcl_ITM_Camera_System_Hardware_Version() : 
   uiVersion__Large_(0x00, 0x08),
   uiVersion__Middle_(0x00, 0x08),
   uiVersion__Small_(0x00, 0x08)
{
}

tBool tcl_ITM_Camera_System_Hardware_Version::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiVersion__Large_.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiVersion__Middle_.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiVersion__Small_.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Camera_System_Hardware_Version::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiVersion__Large_.bUpdateMcanMessage(poMcanMsg);
   uiVersion__Middle_.bUpdateMcanMessage(poMcanMsg);
   uiVersion__Small_.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Camera_System_Hardware_Version const& lhs, tcl_ITM_Camera_System_Hardware_Version const& rhs){
   if (lhs.uiVersion__Large_ != rhs.uiVersion__Large_) return FALSE;
   if (lhs.uiVersion__Middle_ != rhs.uiVersion__Middle_) return FALSE;
   if (lhs.uiVersion__Small_ != rhs.uiVersion__Small_) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Camera_System_Hardware_Version const& lhs, tcl_ITM_Camera_System_Hardware_Version const& rhs){
    if (
         (lhs.uiVersion__Large_ == rhs.uiVersion__Large_)
      && (lhs.uiVersion__Middle_ == rhs.uiVersion__Middle_)
      && (lhs.uiVersion__Small_ == rhs.uiVersion__Small_)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Camera_System_Sonar_Soft_Ver::tcl_ITM_Camera_System_Sonar_Soft_Ver() : 
   uiVersion__Large_(0x00, 0x08),
   uiVersion__Middle_(0x00, 0x08),
   uiVersion__Small_(0x00, 0x08)
{
}

tBool tcl_ITM_Camera_System_Sonar_Soft_Ver::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiVersion__Large_.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiVersion__Middle_.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiVersion__Small_.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Camera_System_Sonar_Soft_Ver::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiVersion__Large_.bUpdateMcanMessage(poMcanMsg);
   uiVersion__Middle_.bUpdateMcanMessage(poMcanMsg);
   uiVersion__Small_.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Camera_System_Sonar_Soft_Ver const& lhs, tcl_ITM_Camera_System_Sonar_Soft_Ver const& rhs){
   if (lhs.uiVersion__Large_ != rhs.uiVersion__Large_) return FALSE;
   if (lhs.uiVersion__Middle_ != rhs.uiVersion__Middle_) return FALSE;
   if (lhs.uiVersion__Small_ != rhs.uiVersion__Small_) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Camera_System_Sonar_Soft_Ver const& lhs, tcl_ITM_Camera_System_Sonar_Soft_Ver const& rhs){
    if (
         (lhs.uiVersion__Large_ == rhs.uiVersion__Large_)
      && (lhs.uiVersion__Middle_ == rhs.uiVersion__Middle_)
      && (lhs.uiVersion__Small_ == rhs.uiVersion__Small_)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Camera_System_Invalid_Parameter::tcl_ITM_Camera_System_Invalid_Parameter() : 
   eInvalid_Parameter((tcl_ITM_Camera_System_e32_Invalid_Parameter::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_Camera_System_Invalid_Parameter::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eInvalid_Parameter.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Camera_System_Invalid_Parameter::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eInvalid_Parameter.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Camera_System_Invalid_Parameter const& lhs, tcl_ITM_Camera_System_Invalid_Parameter const& rhs){
   if (lhs.eInvalid_Parameter != rhs.eInvalid_Parameter) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Camera_System_Invalid_Parameter const& lhs, tcl_ITM_Camera_System_Invalid_Parameter const& rhs){
    if (
         (lhs.eInvalid_Parameter == rhs.eInvalid_Parameter)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Camera_System_Software_Version::tcl_ITM_Camera_System_Software_Version() : 
   uiVersion__Large_(0x00, 0x08),
   uiVersion__Middle_(0x00, 0x08),
   uiVersion__Small_(0x00, 0x08)
{
}

tBool tcl_ITM_Camera_System_Software_Version::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiVersion__Large_.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiVersion__Middle_.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiVersion__Small_.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Camera_System_Software_Version::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiVersion__Large_.bUpdateMcanMessage(poMcanMsg);
   uiVersion__Middle_.bUpdateMcanMessage(poMcanMsg);
   uiVersion__Small_.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Camera_System_Software_Version const& lhs, tcl_ITM_Camera_System_Software_Version const& rhs){
   if (lhs.uiVersion__Large_ != rhs.uiVersion__Large_) return FALSE;
   if (lhs.uiVersion__Middle_ != rhs.uiVersion__Middle_) return FALSE;
   if (lhs.uiVersion__Small_ != rhs.uiVersion__Small_) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Camera_System_Software_Version const& lhs, tcl_ITM_Camera_System_Software_Version const& rhs){
    if (
         (lhs.uiVersion__Large_ == rhs.uiVersion__Large_)
      && (lhs.uiVersion__Middle_ == rhs.uiVersion__Middle_)
      && (lhs.uiVersion__Small_ == rhs.uiVersion__Small_)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Camera_System_Sonar_Hard_Ver::tcl_ITM_Camera_System_Sonar_Hard_Ver() : 
   uiVersion__Large_(0x00, 0x08),
   uiVersion__Middle_(0x00, 0x08),
   uiVersion__Small_(0x00, 0x08)
{
}

tBool tcl_ITM_Camera_System_Sonar_Hard_Ver::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiVersion__Large_.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiVersion__Middle_.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiVersion__Small_.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Camera_System_Sonar_Hard_Ver::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiVersion__Large_.bUpdateMcanMessage(poMcanMsg);
   uiVersion__Middle_.bUpdateMcanMessage(poMcanMsg);
   uiVersion__Small_.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Camera_System_Sonar_Hard_Ver const& lhs, tcl_ITM_Camera_System_Sonar_Hard_Ver const& rhs){
   if (lhs.uiVersion__Large_ != rhs.uiVersion__Large_) return FALSE;
   if (lhs.uiVersion__Middle_ != rhs.uiVersion__Middle_) return FALSE;
   if (lhs.uiVersion__Small_ != rhs.uiVersion__Small_) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Camera_System_Sonar_Hard_Ver const& lhs, tcl_ITM_Camera_System_Sonar_Hard_Ver const& rhs){
    if (
         (lhs.uiVersion__Large_ == rhs.uiVersion__Large_)
      && (lhs.uiVersion__Middle_ == rhs.uiVersion__Middle_)
      && (lhs.uiVersion__Small_ == rhs.uiVersion__Small_)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Camera_System_MCAN_Communication_Error::tcl_ITM_Camera_System_MCAN_Communication_Error() : 
   eBusOff_Status((tcl_ITM_Camera_System_e32_BusOff::tenType)0x00, 0x02),
   uiBusOff_FaultCounter(0x00, 0x06),
   eSend_CMF_to_Master_Status((tcl_ITM_Camera_System_e32_Confirmed_Mute::tenType)0x00, 0x02),
   uiSend_CMF_to_Master_FaultCounter(0x00, 0x06),
   eReceive_CMF_From_Sonar_Status((tcl_ITM_Camera_System_e32_Confirmed_Absent::tenType)0x00, 0x02),
   uiReceive_CMF_From_Sonar_FaultCounter(0x00, 0x06),
   uiReserved_4thByte_(0x00, 0x08),
   uiReserved_5thByte_(0x00, 0x08),
   eSend_MPDT_to_Sonar_Status((tcl_ITM_Camera_System_e32_MPDT_MUTE::tenType)0x00, 0x02),
   uiSend_MPDT_to_Sonar_FaultCounter(0x00, 0x06),
   uiReserved_7thByte_(0x00, 0x08),
   uiReserved_8thByte_(0x00, 0x08)
{
}

tBool tcl_ITM_Camera_System_MCAN_Communication_Error::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eBusOff_Status.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiBusOff_FaultCounter.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSend_CMF_to_Master_Status.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiSend_CMF_to_Master_FaultCounter.bUpdateData(poMcanMsg);
   if (bRet) bRet = eReceive_CMF_From_Sonar_Status.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiReceive_CMF_From_Sonar_FaultCounter.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiReserved_4thByte_.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiReserved_5thByte_.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSend_MPDT_to_Sonar_Status.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiSend_MPDT_to_Sonar_FaultCounter.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiReserved_7thByte_.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiReserved_8thByte_.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Camera_System_MCAN_Communication_Error::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eBusOff_Status.bUpdateMcanMessage(poMcanMsg);
   uiBusOff_FaultCounter.bUpdateMcanMessage(poMcanMsg);
   eSend_CMF_to_Master_Status.bUpdateMcanMessage(poMcanMsg);
   uiSend_CMF_to_Master_FaultCounter.bUpdateMcanMessage(poMcanMsg);
   eReceive_CMF_From_Sonar_Status.bUpdateMcanMessage(poMcanMsg);
   uiReceive_CMF_From_Sonar_FaultCounter.bUpdateMcanMessage(poMcanMsg);
   uiReserved_4thByte_.bUpdateMcanMessage(poMcanMsg);
   uiReserved_5thByte_.bUpdateMcanMessage(poMcanMsg);
   eSend_MPDT_to_Sonar_Status.bUpdateMcanMessage(poMcanMsg);
   uiSend_MPDT_to_Sonar_FaultCounter.bUpdateMcanMessage(poMcanMsg);
   uiReserved_7thByte_.bUpdateMcanMessage(poMcanMsg);
   uiReserved_8thByte_.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Camera_System_MCAN_Communication_Error const& lhs, tcl_ITM_Camera_System_MCAN_Communication_Error const& rhs){
   if (lhs.eBusOff_Status != rhs.eBusOff_Status) return FALSE;
   if (lhs.uiBusOff_FaultCounter != rhs.uiBusOff_FaultCounter) return FALSE;
   if (lhs.eSend_CMF_to_Master_Status != rhs.eSend_CMF_to_Master_Status) return FALSE;
   if (lhs.uiSend_CMF_to_Master_FaultCounter != rhs.uiSend_CMF_to_Master_FaultCounter) return FALSE;
   if (lhs.eReceive_CMF_From_Sonar_Status != rhs.eReceive_CMF_From_Sonar_Status) return FALSE;
   if (lhs.uiReceive_CMF_From_Sonar_FaultCounter != rhs.uiReceive_CMF_From_Sonar_FaultCounter) return FALSE;
   if (lhs.uiReserved_4thByte_ != rhs.uiReserved_4thByte_) return FALSE;
   if (lhs.uiReserved_5thByte_ != rhs.uiReserved_5thByte_) return FALSE;
   if (lhs.eSend_MPDT_to_Sonar_Status != rhs.eSend_MPDT_to_Sonar_Status) return FALSE;
   if (lhs.uiSend_MPDT_to_Sonar_FaultCounter != rhs.uiSend_MPDT_to_Sonar_FaultCounter) return FALSE;
   if (lhs.uiReserved_7thByte_ != rhs.uiReserved_7thByte_) return FALSE;
   if (lhs.uiReserved_8thByte_ != rhs.uiReserved_8thByte_) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Camera_System_MCAN_Communication_Error const& lhs, tcl_ITM_Camera_System_MCAN_Communication_Error const& rhs){
    if (
         (lhs.eBusOff_Status == rhs.eBusOff_Status)
      && (lhs.uiBusOff_FaultCounter == rhs.uiBusOff_FaultCounter)
      && (lhs.eSend_CMF_to_Master_Status == rhs.eSend_CMF_to_Master_Status)
      && (lhs.uiSend_CMF_to_Master_FaultCounter == rhs.uiSend_CMF_to_Master_FaultCounter)
      && (lhs.eReceive_CMF_From_Sonar_Status == rhs.eReceive_CMF_From_Sonar_Status)
      && (lhs.uiReceive_CMF_From_Sonar_FaultCounter == rhs.uiReceive_CMF_From_Sonar_FaultCounter)
      && (lhs.uiReserved_4thByte_ == rhs.uiReserved_4thByte_)
      && (lhs.uiReserved_5thByte_ == rhs.uiReserved_5thByte_)
      && (lhs.eSend_MPDT_to_Sonar_Status == rhs.eSend_MPDT_to_Sonar_Status)
      && (lhs.uiSend_MPDT_to_Sonar_FaultCounter == rhs.uiSend_MPDT_to_Sonar_FaultCounter)
      && (lhs.uiReserved_7thByte_ == rhs.uiReserved_7thByte_)
      && (lhs.uiReserved_8thByte_ == rhs.uiReserved_8thByte_)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Camera_System_SW_Status::tcl_ITM_Camera_System_SW_Status() : 
   eSW_Status((tcl_ITM_Camera_System_e32_SW_Status::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_Camera_System_SW_Status::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eSW_Status.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Camera_System_SW_Status::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eSW_Status.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Camera_System_SW_Status const& lhs, tcl_ITM_Camera_System_SW_Status const& rhs){
   if (lhs.eSW_Status != rhs.eSW_Status) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Camera_System_SW_Status const& lhs, tcl_ITM_Camera_System_SW_Status const& rhs){
    if (
         (lhs.eSW_Status == rhs.eSW_Status)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Camera_System_Disp_Status::tcl_ITM_Camera_System_Disp_Status() : 
   eDisp_Status((tcl_ITM_Camera_System_e32_Disp_Status::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_Camera_System_Disp_Status::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eDisp_Status.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Camera_System_Disp_Status::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eDisp_Status.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Camera_System_Disp_Status const& lhs, tcl_ITM_Camera_System_Disp_Status const& rhs){
   if (lhs.eDisp_Status != rhs.eDisp_Status) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Camera_System_Disp_Status const& lhs, tcl_ITM_Camera_System_Disp_Status const& rhs){
    if (
         (lhs.eDisp_Status == rhs.eDisp_Status)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Camera_System_View_Pattern::tcl_ITM_Camera_System_View_Pattern() : 
   eView_Pattern((tcl_ITM_Camera_System_e32_View_Pattern::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_Camera_System_View_Pattern::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eView_Pattern.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Camera_System_View_Pattern::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eView_Pattern.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Camera_System_View_Pattern const& lhs, tcl_ITM_Camera_System_View_Pattern const& rhs){
   if (lhs.eView_Pattern != rhs.eView_Pattern) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Camera_System_View_Pattern const& lhs, tcl_ITM_Camera_System_View_Pattern const& rhs){
    if (
         (lhs.eView_Pattern == rhs.eView_Pattern)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Camera_System_Caution::tcl_ITM_Camera_System_Caution() : 
   eCaution((tcl_ITM_Camera_System_e32_Caution::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_Camera_System_Caution::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eCaution.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Camera_System_Caution::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eCaution.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Camera_System_Caution const& lhs, tcl_ITM_Camera_System_Caution const& rhs){
   if (lhs.eCaution != rhs.eCaution) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Camera_System_Caution const& lhs, tcl_ITM_Camera_System_Caution const& rhs){
    if (
         (lhs.eCaution == rhs.eCaution)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Camera_System_Disp_SW::tcl_ITM_Camera_System_Disp_SW() : 
   eTop_View((tcl_ITM_Camera_System_e32_Disp_SW::tenType)0x00, 0x02),
   eSide_View((tcl_ITM_Camera_System_e32_Disp_SW::tenType)0x00, 0x02),
   eBuzzer((tcl_ITM_Camera_System_e32_Disp_SW::tenType)0x00, 0x02),
   aReserved_0_fixed_(NULL, 0x02)
{
}

tBool tcl_ITM_Camera_System_Disp_SW::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eTop_View.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSide_View.bUpdateData(poMcanMsg);
   if (bRet) bRet = eBuzzer.bUpdateData(poMcanMsg);
   if (bRet) bRet = aReserved_0_fixed_.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Camera_System_Disp_SW::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eTop_View.bUpdateMcanMessage(poMcanMsg);
   eSide_View.bUpdateMcanMessage(poMcanMsg);
   eBuzzer.bUpdateMcanMessage(poMcanMsg);
   aReserved_0_fixed_.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Camera_System_Disp_SW const& lhs, tcl_ITM_Camera_System_Disp_SW const& rhs){
   if (lhs.eTop_View != rhs.eTop_View) return FALSE;
   if (lhs.eSide_View != rhs.eSide_View) return FALSE;
   if (lhs.eBuzzer != rhs.eBuzzer) return FALSE;
   if (lhs.aReserved_0_fixed_ != rhs.aReserved_0_fixed_) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Camera_System_Disp_SW const& lhs, tcl_ITM_Camera_System_Disp_SW const& rhs){
    if (
         (lhs.eTop_View == rhs.eTop_View)
      && (lhs.eSide_View == rhs.eSide_View)
      && (lhs.eBuzzer == rhs.eBuzzer)
      && (lhs.aReserved_0_fixed_ == rhs.aReserved_0_fixed_)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Camera_System_Buzzer_Status::tcl_ITM_Camera_System_Buzzer_Status() : 
   eBuzzer_Status((tcl_ITM_Camera_System_e32_Buzzer_Status::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_Camera_System_Buzzer_Status::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eBuzzer_Status.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Camera_System_Buzzer_Status::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eBuzzer_Status.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Camera_System_Buzzer_Status const& lhs, tcl_ITM_Camera_System_Buzzer_Status const& rhs){
   if (lhs.eBuzzer_Status != rhs.eBuzzer_Status) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Camera_System_Buzzer_Status const& lhs, tcl_ITM_Camera_System_Buzzer_Status const& rhs){
    if (
         (lhs.eBuzzer_Status == rhs.eBuzzer_Status)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Camera_System_Error_Message::tcl_ITM_Camera_System_Error_Message() : 
   eError_Message((tcl_ITM_Camera_System_e32_Error_Message::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_Camera_System_Error_Message::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eError_Message.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Camera_System_Error_Message::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eError_Message.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Camera_System_Error_Message const& lhs, tcl_ITM_Camera_System_Error_Message const& rhs){
   if (lhs.eError_Message != rhs.eError_Message) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Camera_System_Error_Message const& lhs, tcl_ITM_Camera_System_Error_Message const& rhs){
    if (
         (lhs.eError_Message == rhs.eError_Message)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Camera_System_Camera::tcl_ITM_Camera_System_Camera() : 
   eVehicle_Speed((tcl_ITM_Camera_System_e32_Vehicle_Speed::tenType)0x00, 0x02),
   eView_Line((tcl_ITM_Camera_System_e32_View_Line::tenType)0x00, 0x02),
   ePriority_View((tcl_ITM_Camera_System_e32_Priority_View::tenType)0x00, 0x02),
   eMask_Emphasis((tcl_ITM_Camera_System_e32_Mask_Emphasis::tenType)0x00, 0x02),
   eSide_Sonar_Disp((tcl_ITM_Camera_System_e32_Side_Sonar_Disp::tenType)0x00, 0x02),
   aReserve_6bits(NULL, 0x06)
{
}

tBool tcl_ITM_Camera_System_Camera::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eVehicle_Speed.bUpdateData(poMcanMsg);
   if (bRet) bRet = eView_Line.bUpdateData(poMcanMsg);
   if (bRet) bRet = ePriority_View.bUpdateData(poMcanMsg);
   if (bRet) bRet = eMask_Emphasis.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSide_Sonar_Disp.bUpdateData(poMcanMsg);
   if (bRet) bRet = aReserve_6bits.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Camera_System_Camera::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eVehicle_Speed.bUpdateMcanMessage(poMcanMsg);
   eView_Line.bUpdateMcanMessage(poMcanMsg);
   ePriority_View.bUpdateMcanMessage(poMcanMsg);
   eMask_Emphasis.bUpdateMcanMessage(poMcanMsg);
   eSide_Sonar_Disp.bUpdateMcanMessage(poMcanMsg);
   aReserve_6bits.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Camera_System_Camera const& lhs, tcl_ITM_Camera_System_Camera const& rhs){
   if (lhs.eVehicle_Speed != rhs.eVehicle_Speed) return FALSE;
   if (lhs.eView_Line != rhs.eView_Line) return FALSE;
   if (lhs.ePriority_View != rhs.ePriority_View) return FALSE;
   if (lhs.eMask_Emphasis != rhs.eMask_Emphasis) return FALSE;
   if (lhs.eSide_Sonar_Disp != rhs.eSide_Sonar_Disp) return FALSE;
   if (lhs.aReserve_6bits != rhs.aReserve_6bits) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Camera_System_Camera const& lhs, tcl_ITM_Camera_System_Camera const& rhs){
    if (
         (lhs.eVehicle_Speed == rhs.eVehicle_Speed)
      && (lhs.eView_Line == rhs.eView_Line)
      && (lhs.ePriority_View == rhs.ePriority_View)
      && (lhs.eMask_Emphasis == rhs.eMask_Emphasis)
      && (lhs.eSide_Sonar_Disp == rhs.eSide_Sonar_Disp)
      && (lhs.aReserve_6bits == rhs.aReserve_6bits)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Camera_System_Diag_Menu_List::tcl_ITM_Camera_System_Diag_Menu_List() : 
   eDiag_sensor((tcl_ITM_Camera_System_e32_Diag_sensor::tenType)0x00, 0x01),
   eCalibration((tcl_ITM_Camera_System_e32_Calibration::tenType)0x00, 0x01),
   eView_Line((tcl_ITM_Camera_System_e32_View_Line2::tenType)0x00, 0x01),
   eTop_View_Cal((tcl_ITM_Camera_System_e32_Top_View_Cal::tenType)0x00, 0x01),
   eWide_View_Line((tcl_ITM_Camera_System_e32_Wide_View_Line::tenType)0x00, 0x01),
   aReserve_3bits(NULL, 0x03)
{
}

tBool tcl_ITM_Camera_System_Diag_Menu_List::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eDiag_sensor.bUpdateData(poMcanMsg);
   if (bRet) bRet = eCalibration.bUpdateData(poMcanMsg);
   if (bRet) bRet = eView_Line.bUpdateData(poMcanMsg);
   if (bRet) bRet = eTop_View_Cal.bUpdateData(poMcanMsg);
   if (bRet) bRet = eWide_View_Line.bUpdateData(poMcanMsg);
   if (bRet) bRet = aReserve_3bits.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Camera_System_Diag_Menu_List::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eDiag_sensor.bUpdateMcanMessage(poMcanMsg);
   eCalibration.bUpdateMcanMessage(poMcanMsg);
   eView_Line.bUpdateMcanMessage(poMcanMsg);
   eTop_View_Cal.bUpdateMcanMessage(poMcanMsg);
   eWide_View_Line.bUpdateMcanMessage(poMcanMsg);
   aReserve_3bits.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Camera_System_Diag_Menu_List const& lhs, tcl_ITM_Camera_System_Diag_Menu_List const& rhs){
   if (lhs.eDiag_sensor != rhs.eDiag_sensor) return FALSE;
   if (lhs.eCalibration != rhs.eCalibration) return FALSE;
   if (lhs.eView_Line != rhs.eView_Line) return FALSE;
   if (lhs.eTop_View_Cal != rhs.eTop_View_Cal) return FALSE;
   if (lhs.eWide_View_Line != rhs.eWide_View_Line) return FALSE;
   if (lhs.aReserve_3bits != rhs.aReserve_3bits) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Camera_System_Diag_Menu_List const& lhs, tcl_ITM_Camera_System_Diag_Menu_List const& rhs){
    if (
         (lhs.eDiag_sensor == rhs.eDiag_sensor)
      && (lhs.eCalibration == rhs.eCalibration)
      && (lhs.eView_Line == rhs.eView_Line)
      && (lhs.eTop_View_Cal == rhs.eTop_View_Cal)
      && (lhs.eWide_View_Line == rhs.eWide_View_Line)
      && (lhs.aReserve_3bits == rhs.aReserve_3bits)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Camera_System_Sensor_State::tcl_ITM_Camera_System_Sensor_State() : 
   eSTR_Angle((tcl_ITM_Camera_System_e32_STR_Angle::tenType)0x00, 0x02),
   eReverse((tcl_ITM_Camera_System_e32_Reverse::tenType)0x00, 0x02),
   eSpeed_Sensor((tcl_ITM_Camera_System_e32_Speed_Sensor::tenType)0x00, 0x02),
   eCamera_SW((tcl_ITM_Camera_System_e32_Camera_SW::tenType)0x00, 0x02),
   eIGN((tcl_ITM_Camera_System_e32_IGN::tenType)0x00, 0x02),
   eILL((tcl_ITM_Camera_System_e32_ILL::tenType)0x00, 0x02),
   aReserve_4bits(NULL, 0x04)
{
}

tBool tcl_ITM_Camera_System_Sensor_State::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eSTR_Angle.bUpdateData(poMcanMsg);
   if (bRet) bRet = eReverse.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSpeed_Sensor.bUpdateData(poMcanMsg);
   if (bRet) bRet = eCamera_SW.bUpdateData(poMcanMsg);
   if (bRet) bRet = eIGN.bUpdateData(poMcanMsg);
   if (bRet) bRet = eILL.bUpdateData(poMcanMsg);
   if (bRet) bRet = aReserve_4bits.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Camera_System_Sensor_State::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eSTR_Angle.bUpdateMcanMessage(poMcanMsg);
   eReverse.bUpdateMcanMessage(poMcanMsg);
   eSpeed_Sensor.bUpdateMcanMessage(poMcanMsg);
   eCamera_SW.bUpdateMcanMessage(poMcanMsg);
   eIGN.bUpdateMcanMessage(poMcanMsg);
   eILL.bUpdateMcanMessage(poMcanMsg);
   aReserve_4bits.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Camera_System_Sensor_State const& lhs, tcl_ITM_Camera_System_Sensor_State const& rhs){
   if (lhs.eSTR_Angle != rhs.eSTR_Angle) return FALSE;
   if (lhs.eReverse != rhs.eReverse) return FALSE;
   if (lhs.eSpeed_Sensor != rhs.eSpeed_Sensor) return FALSE;
   if (lhs.eCamera_SW != rhs.eCamera_SW) return FALSE;
   if (lhs.eIGN != rhs.eIGN) return FALSE;
   if (lhs.eILL != rhs.eILL) return FALSE;
   if (lhs.aReserve_4bits != rhs.aReserve_4bits) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Camera_System_Sensor_State const& lhs, tcl_ITM_Camera_System_Sensor_State const& rhs){
    if (
         (lhs.eSTR_Angle == rhs.eSTR_Angle)
      && (lhs.eReverse == rhs.eReverse)
      && (lhs.eSpeed_Sensor == rhs.eSpeed_Sensor)
      && (lhs.eCamera_SW == rhs.eCamera_SW)
      && (lhs.eIGN == rhs.eIGN)
      && (lhs.eILL == rhs.eILL)
      && (lhs.aReserve_4bits == rhs.aReserve_4bits)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Camera_System_View_Calibration_List::tcl_ITM_Camera_System_View_Calibration_List() : 
   eRR_CM((tcl_ITM_Camera_System_e32_RR_CM::tenType)0x00, 0x01),
   eAS_CM((tcl_ITM_Camera_System_e32_AS_CM::tenType)0x00, 0x01),
   eFR_CM((tcl_ITM_Camera_System_e32_FR_CM::tenType)0x00, 0x01),
   eDS_CM((tcl_ITM_Camera_System_e32_DS_CM::tenType)0x00, 0x01),
   eInitializing((tcl_ITM_Camera_System_e32_Initializing::tenType)0x00, 0x01),
   aReserved_0_fixed_(NULL, 0x03)
{
}

tBool tcl_ITM_Camera_System_View_Calibration_List::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eRR_CM.bUpdateData(poMcanMsg);
   if (bRet) bRet = eAS_CM.bUpdateData(poMcanMsg);
   if (bRet) bRet = eFR_CM.bUpdateData(poMcanMsg);
   if (bRet) bRet = eDS_CM.bUpdateData(poMcanMsg);
   if (bRet) bRet = eInitializing.bUpdateData(poMcanMsg);
   if (bRet) bRet = aReserved_0_fixed_.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Camera_System_View_Calibration_List::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eRR_CM.bUpdateMcanMessage(poMcanMsg);
   eAS_CM.bUpdateMcanMessage(poMcanMsg);
   eFR_CM.bUpdateMcanMessage(poMcanMsg);
   eDS_CM.bUpdateMcanMessage(poMcanMsg);
   eInitializing.bUpdateMcanMessage(poMcanMsg);
   aReserved_0_fixed_.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Camera_System_View_Calibration_List const& lhs, tcl_ITM_Camera_System_View_Calibration_List const& rhs){
   if (lhs.eRR_CM != rhs.eRR_CM) return FALSE;
   if (lhs.eAS_CM != rhs.eAS_CM) return FALSE;
   if (lhs.eFR_CM != rhs.eFR_CM) return FALSE;
   if (lhs.eDS_CM != rhs.eDS_CM) return FALSE;
   if (lhs.eInitializing != rhs.eInitializing) return FALSE;
   if (lhs.aReserved_0_fixed_ != rhs.aReserved_0_fixed_) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Camera_System_View_Calibration_List const& lhs, tcl_ITM_Camera_System_View_Calibration_List const& rhs){
    if (
         (lhs.eRR_CM == rhs.eRR_CM)
      && (lhs.eAS_CM == rhs.eAS_CM)
      && (lhs.eFR_CM == rhs.eFR_CM)
      && (lhs.eDS_CM == rhs.eDS_CM)
      && (lhs.eInitializing == rhs.eInitializing)
      && (lhs.aReserved_0_fixed_ == rhs.aReserved_0_fixed_)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Camera_System_Select_Camera::tcl_ITM_Camera_System_Select_Camera() : 
   eSelect_Camera((tcl_ITM_Camera_System_e32_Select_Camera::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_Camera_System_Select_Camera::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eSelect_Camera.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Camera_System_Select_Camera::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eSelect_Camera.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Camera_System_Select_Camera const& lhs, tcl_ITM_Camera_System_Select_Camera const& rhs){
   if (lhs.eSelect_Camera != rhs.eSelect_Camera) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Camera_System_Select_Camera const& lhs, tcl_ITM_Camera_System_Select_Camera const& rhs){
    if (
         (lhs.eSelect_Camera == rhs.eSelect_Camera)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Camera_System_Select_State::tcl_ITM_Camera_System_Select_State() : 
   eSelect_State((tcl_ITM_Camera_System_e32_Select_State::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_Camera_System_Select_State::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eSelect_State.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Camera_System_Select_State::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eSelect_State.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Camera_System_Select_State const& lhs, tcl_ITM_Camera_System_Select_State const& rhs){
   if (lhs.eSelect_State != rhs.eSelect_State) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Camera_System_Select_State const& lhs, tcl_ITM_Camera_System_Select_State const& rhs){
    if (
         (lhs.eSelect_State == rhs.eSelect_State)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Camera_System_Adjust_Item::tcl_ITM_Camera_System_Adjust_Item() : 
   eAdjust_Item((tcl_ITM_Camera_System_e32_Adjust_Item::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_Camera_System_Adjust_Item::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eAdjust_Item.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Camera_System_Adjust_Item::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eAdjust_Item.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Camera_System_Adjust_Item const& lhs, tcl_ITM_Camera_System_Adjust_Item const& rhs){
   if (lhs.eAdjust_Item != rhs.eAdjust_Item) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Camera_System_Adjust_Item const& lhs, tcl_ITM_Camera_System_Adjust_Item const& rhs){
    if (
         (lhs.eAdjust_Item == rhs.eAdjust_Item)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Camera_System_Current_pattern::tcl_ITM_Camera_System_Current_pattern() : 
   uiCurrent_pattern(0x00, 0x08)
{
}

tBool tcl_ITM_Camera_System_Current_pattern::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiCurrent_pattern.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Camera_System_Current_pattern::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiCurrent_pattern.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Camera_System_Current_pattern const& lhs, tcl_ITM_Camera_System_Current_pattern const& rhs){
   if (lhs.uiCurrent_pattern != rhs.uiCurrent_pattern) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Camera_System_Current_pattern const& lhs, tcl_ITM_Camera_System_Current_pattern const& rhs){
    if (
         (lhs.uiCurrent_pattern == rhs.uiCurrent_pattern)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Camera_System_Max_pattern::tcl_ITM_Camera_System_Max_pattern() : 
   uiMax_pattern(0x01, 0x08)
{
}

tBool tcl_ITM_Camera_System_Max_pattern::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiMax_pattern.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Camera_System_Max_pattern::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiMax_pattern.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Camera_System_Max_pattern const& lhs, tcl_ITM_Camera_System_Max_pattern const& rhs){
   if (lhs.uiMax_pattern != rhs.uiMax_pattern) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Camera_System_Max_pattern const& lhs, tcl_ITM_Camera_System_Max_pattern const& rhs){
    if (
         (lhs.uiMax_pattern == rhs.uiMax_pattern)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Camera_System_Coordinate_X::tcl_ITM_Camera_System_Coordinate_X() : 
   iCoordinate_X(0x81, 0x08)
{
}

tBool tcl_ITM_Camera_System_Coordinate_X::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = iCoordinate_X.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Camera_System_Coordinate_X::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   iCoordinate_X.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Camera_System_Coordinate_X const& lhs, tcl_ITM_Camera_System_Coordinate_X const& rhs){
   if (lhs.iCoordinate_X != rhs.iCoordinate_X) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Camera_System_Coordinate_X const& lhs, tcl_ITM_Camera_System_Coordinate_X const& rhs){
    if (
         (lhs.iCoordinate_X == rhs.iCoordinate_X)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Camera_System_Coordinate_Y::tcl_ITM_Camera_System_Coordinate_Y() : 
   iCoordinate_Y(0x81, 0x08)
{
}

tBool tcl_ITM_Camera_System_Coordinate_Y::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = iCoordinate_Y.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Camera_System_Coordinate_Y::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   iCoordinate_Y.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Camera_System_Coordinate_Y const& lhs, tcl_ITM_Camera_System_Coordinate_Y const& rhs){
   if (lhs.iCoordinate_Y != rhs.iCoordinate_Y) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Camera_System_Coordinate_Y const& lhs, tcl_ITM_Camera_System_Coordinate_Y const& rhs){
    if (
         (lhs.iCoordinate_Y == rhs.iCoordinate_Y)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Camera_System_View_Line_List::tcl_ITM_Camera_System_View_Line_List() : 
   eRR_CM((tcl_ITM_Camera_System_e32_RR_CM::tenType)0x00, 0x01),
   eAS_CM((tcl_ITM_Camera_System_e32_AS_CM::tenType)0x00, 0x01),
   eFR_CM((tcl_ITM_Camera_System_e32_FR_CM::tenType)0x00, 0x01),
   aReserved_0_fixed_(NULL, 0x05)
{
}

tBool tcl_ITM_Camera_System_View_Line_List::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eRR_CM.bUpdateData(poMcanMsg);
   if (bRet) bRet = eAS_CM.bUpdateData(poMcanMsg);
   if (bRet) bRet = eFR_CM.bUpdateData(poMcanMsg);
   if (bRet) bRet = aReserved_0_fixed_.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Camera_System_View_Line_List::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eRR_CM.bUpdateMcanMessage(poMcanMsg);
   eAS_CM.bUpdateMcanMessage(poMcanMsg);
   eFR_CM.bUpdateMcanMessage(poMcanMsg);
   aReserved_0_fixed_.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Camera_System_View_Line_List const& lhs, tcl_ITM_Camera_System_View_Line_List const& rhs){
   if (lhs.eRR_CM != rhs.eRR_CM) return FALSE;
   if (lhs.eAS_CM != rhs.eAS_CM) return FALSE;
   if (lhs.eFR_CM != rhs.eFR_CM) return FALSE;
   if (lhs.aReserved_0_fixed_ != rhs.aReserved_0_fixed_) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Camera_System_View_Line_List const& lhs, tcl_ITM_Camera_System_View_Line_List const& rhs){
    if (
         (lhs.eRR_CM == rhs.eRR_CM)
      && (lhs.eAS_CM == rhs.eAS_CM)
      && (lhs.eFR_CM == rhs.eFR_CM)
      && (lhs.aReserved_0_fixed_ == rhs.aReserved_0_fixed_)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Camera_System_Icon::tcl_ITM_Camera_System_Icon() : 
   eIcon((tcl_ITM_Camera_System_e32_Icon::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_Camera_System_Icon::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eIcon.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Camera_System_Icon::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eIcon.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Camera_System_Icon const& lhs, tcl_ITM_Camera_System_Icon const& rhs){
   if (lhs.eIcon != rhs.eIcon) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Camera_System_Icon const& lhs, tcl_ITM_Camera_System_Icon const& rhs){
    if (
         (lhs.eIcon == rhs.eIcon)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Camera_System_Corner_Sonar_Level::tcl_ITM_Camera_System_Corner_Sonar_Level() : 
   eCorner_Sonar_Sensitivity_Setting((tcl_ITM_Camera_System_e32_Corner_Sonar_Sensitivity_Setting::tenType)0x00, 0x01),
   eCorner_Sonar_Sensitivity_Level((tcl_ITM_Camera_System_e32_Corner_Sonar_Sensitivity_Level::tenType)0x00, 0x03),
   areserve(NULL, 0x04)
{
}

tBool tcl_ITM_Camera_System_Corner_Sonar_Level::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eCorner_Sonar_Sensitivity_Setting.bUpdateData(poMcanMsg);
   if (bRet) bRet = eCorner_Sonar_Sensitivity_Level.bUpdateData(poMcanMsg);
   if (bRet) bRet = areserve.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Camera_System_Corner_Sonar_Level::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eCorner_Sonar_Sensitivity_Setting.bUpdateMcanMessage(poMcanMsg);
   eCorner_Sonar_Sensitivity_Level.bUpdateMcanMessage(poMcanMsg);
   areserve.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Camera_System_Corner_Sonar_Level const& lhs, tcl_ITM_Camera_System_Corner_Sonar_Level const& rhs){
   if (lhs.eCorner_Sonar_Sensitivity_Setting != rhs.eCorner_Sonar_Sensitivity_Setting) return FALSE;
   if (lhs.eCorner_Sonar_Sensitivity_Level != rhs.eCorner_Sonar_Sensitivity_Level) return FALSE;
   if (lhs.areserve != rhs.areserve) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Camera_System_Corner_Sonar_Level const& lhs, tcl_ITM_Camera_System_Corner_Sonar_Level const& rhs){
    if (
         (lhs.eCorner_Sonar_Sensitivity_Setting == rhs.eCorner_Sonar_Sensitivity_Setting)
      && (lhs.eCorner_Sonar_Sensitivity_Level == rhs.eCorner_Sonar_Sensitivity_Level)
      && (lhs.areserve == rhs.areserve)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Camera_System_Sonar_Level::tcl_ITM_Camera_System_Sonar_Level() : 
   eSonar_Buzzer_Volume_Setting((tcl_ITM_Camera_System_e32_Sonar_Buzzer_Volume_Setting::tenType)0x00, 0x01),
   eSonar_Buzzer_Volume_Level((tcl_ITM_Camera_System_e32_Sonar_Buzzer_Volume_Level::tenType)0x00, 0x02),
   eSonar_Sensitivity_Setting((tcl_ITM_Camera_System_e32_Sonar_Sensitivity_Setting::tenType)0x00, 0x01),
   eSonar_Sensitivity_Level((tcl_ITM_Camera_System_e32_Sonar_Sensitivity_Level::tenType)0x00, 0x02),
   areserve(NULL, 0x02)
{
}

tBool tcl_ITM_Camera_System_Sonar_Level::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eSonar_Buzzer_Volume_Setting.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSonar_Buzzer_Volume_Level.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSonar_Sensitivity_Setting.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSonar_Sensitivity_Level.bUpdateData(poMcanMsg);
   if (bRet) bRet = areserve.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Camera_System_Sonar_Level::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eSonar_Buzzer_Volume_Setting.bUpdateMcanMessage(poMcanMsg);
   eSonar_Buzzer_Volume_Level.bUpdateMcanMessage(poMcanMsg);
   eSonar_Sensitivity_Setting.bUpdateMcanMessage(poMcanMsg);
   eSonar_Sensitivity_Level.bUpdateMcanMessage(poMcanMsg);
   areserve.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Camera_System_Sonar_Level const& lhs, tcl_ITM_Camera_System_Sonar_Level const& rhs){
   if (lhs.eSonar_Buzzer_Volume_Setting != rhs.eSonar_Buzzer_Volume_Setting) return FALSE;
   if (lhs.eSonar_Buzzer_Volume_Level != rhs.eSonar_Buzzer_Volume_Level) return FALSE;
   if (lhs.eSonar_Sensitivity_Setting != rhs.eSonar_Sensitivity_Setting) return FALSE;
   if (lhs.eSonar_Sensitivity_Level != rhs.eSonar_Sensitivity_Level) return FALSE;
   if (lhs.areserve != rhs.areserve) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Camera_System_Sonar_Level const& lhs, tcl_ITM_Camera_System_Sonar_Level const& rhs){
    if (
         (lhs.eSonar_Buzzer_Volume_Setting == rhs.eSonar_Buzzer_Volume_Setting)
      && (lhs.eSonar_Buzzer_Volume_Level == rhs.eSonar_Buzzer_Volume_Level)
      && (lhs.eSonar_Sensitivity_Setting == rhs.eSonar_Sensitivity_Setting)
      && (lhs.eSonar_Sensitivity_Level == rhs.eSonar_Sensitivity_Level)
      && (lhs.areserve == rhs.areserve)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Camera_System_RR_Camera_State::tcl_ITM_Camera_System_RR_Camera_State() : 
   eRR_View((tcl_ITM_Camera_System_e32_RR_View::tenType)0x00, 0x02),
   eRR_Signal((tcl_ITM_Camera_System_e32_RR_Signal::tenType)0x00, 0x02),
   eRR_Line((tcl_ITM_Camera_System_e32_RR_Line::tenType)0x00, 0x02),
   aReserved(NULL, 0x02)
{
}

tBool tcl_ITM_Camera_System_RR_Camera_State::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eRR_View.bUpdateData(poMcanMsg);
   if (bRet) bRet = eRR_Signal.bUpdateData(poMcanMsg);
   if (bRet) bRet = eRR_Line.bUpdateData(poMcanMsg);
   if (bRet) bRet = aReserved.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Camera_System_RR_Camera_State::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eRR_View.bUpdateMcanMessage(poMcanMsg);
   eRR_Signal.bUpdateMcanMessage(poMcanMsg);
   eRR_Line.bUpdateMcanMessage(poMcanMsg);
   aReserved.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Camera_System_RR_Camera_State const& lhs, tcl_ITM_Camera_System_RR_Camera_State const& rhs){
   if (lhs.eRR_View != rhs.eRR_View) return FALSE;
   if (lhs.eRR_Signal != rhs.eRR_Signal) return FALSE;
   if (lhs.eRR_Line != rhs.eRR_Line) return FALSE;
   if (lhs.aReserved != rhs.aReserved) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Camera_System_RR_Camera_State const& lhs, tcl_ITM_Camera_System_RR_Camera_State const& rhs){
    if (
         (lhs.eRR_View == rhs.eRR_View)
      && (lhs.eRR_Signal == rhs.eRR_Signal)
      && (lhs.eRR_Line == rhs.eRR_Line)
      && (lhs.aReserved == rhs.aReserved)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Camera_System_FR_Camera_State::tcl_ITM_Camera_System_FR_Camera_State() : 
   eFR_View((tcl_ITM_Camera_System_e32_FR_View::tenType)0x00, 0x02),
   eFR_Signal((tcl_ITM_Camera_System_e32_FR_Signal::tenType)0x00, 0x02),
   eFR_Line((tcl_ITM_Camera_System_e32_FR_Line::tenType)0x00, 0x02),
   aReserved(NULL, 0x02)
{
}

tBool tcl_ITM_Camera_System_FR_Camera_State::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eFR_View.bUpdateData(poMcanMsg);
   if (bRet) bRet = eFR_Signal.bUpdateData(poMcanMsg);
   if (bRet) bRet = eFR_Line.bUpdateData(poMcanMsg);
   if (bRet) bRet = aReserved.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Camera_System_FR_Camera_State::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eFR_View.bUpdateMcanMessage(poMcanMsg);
   eFR_Signal.bUpdateMcanMessage(poMcanMsg);
   eFR_Line.bUpdateMcanMessage(poMcanMsg);
   aReserved.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Camera_System_FR_Camera_State const& lhs, tcl_ITM_Camera_System_FR_Camera_State const& rhs){
   if (lhs.eFR_View != rhs.eFR_View) return FALSE;
   if (lhs.eFR_Signal != rhs.eFR_Signal) return FALSE;
   if (lhs.eFR_Line != rhs.eFR_Line) return FALSE;
   if (lhs.aReserved != rhs.aReserved) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Camera_System_FR_Camera_State const& lhs, tcl_ITM_Camera_System_FR_Camera_State const& rhs){
    if (
         (lhs.eFR_View == rhs.eFR_View)
      && (lhs.eFR_Signal == rhs.eFR_Signal)
      && (lhs.eFR_Line == rhs.eFR_Line)
      && (lhs.aReserved == rhs.aReserved)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Camera_System_AS_Camera_State::tcl_ITM_Camera_System_AS_Camera_State() : 
   eAS_View((tcl_ITM_Camera_System_e32_AS_View::tenType)0x00, 0x02),
   eAS_Signal((tcl_ITM_Camera_System_e32_AS_Signal::tenType)0x00, 0x02),
   eAS_Line((tcl_ITM_Camera_System_e32_AS_Line::tenType)0x00, 0x02),
   aReserved(NULL, 0x02)
{
}

tBool tcl_ITM_Camera_System_AS_Camera_State::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eAS_View.bUpdateData(poMcanMsg);
   if (bRet) bRet = eAS_Signal.bUpdateData(poMcanMsg);
   if (bRet) bRet = eAS_Line.bUpdateData(poMcanMsg);
   if (bRet) bRet = aReserved.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Camera_System_AS_Camera_State::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eAS_View.bUpdateMcanMessage(poMcanMsg);
   eAS_Signal.bUpdateMcanMessage(poMcanMsg);
   eAS_Line.bUpdateMcanMessage(poMcanMsg);
   aReserved.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Camera_System_AS_Camera_State const& lhs, tcl_ITM_Camera_System_AS_Camera_State const& rhs){
   if (lhs.eAS_View != rhs.eAS_View) return FALSE;
   if (lhs.eAS_Signal != rhs.eAS_Signal) return FALSE;
   if (lhs.eAS_Line != rhs.eAS_Line) return FALSE;
   if (lhs.aReserved != rhs.aReserved) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Camera_System_AS_Camera_State const& lhs, tcl_ITM_Camera_System_AS_Camera_State const& rhs){
    if (
         (lhs.eAS_View == rhs.eAS_View)
      && (lhs.eAS_Signal == rhs.eAS_Signal)
      && (lhs.eAS_Line == rhs.eAS_Line)
      && (lhs.aReserved == rhs.aReserved)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Camera_System_DS_Camera_State::tcl_ITM_Camera_System_DS_Camera_State() : 
   eDS_View((tcl_ITM_Camera_System_e32_DS_View::tenType)0x00, 0x02),
   eDS_Signal((tcl_ITM_Camera_System_e32_DS_Signal::tenType)0x00, 0x02),
   eDS_Line((tcl_ITM_Camera_System_e32_DS_Line::tenType)0x00, 0x02),
   aReserved(NULL, 0x02)
{
}

tBool tcl_ITM_Camera_System_DS_Camera_State::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eDS_View.bUpdateData(poMcanMsg);
   if (bRet) bRet = eDS_Signal.bUpdateData(poMcanMsg);
   if (bRet) bRet = eDS_Line.bUpdateData(poMcanMsg);
   if (bRet) bRet = aReserved.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Camera_System_DS_Camera_State::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eDS_View.bUpdateMcanMessage(poMcanMsg);
   eDS_Signal.bUpdateMcanMessage(poMcanMsg);
   eDS_Line.bUpdateMcanMessage(poMcanMsg);
   aReserved.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Camera_System_DS_Camera_State const& lhs, tcl_ITM_Camera_System_DS_Camera_State const& rhs){
   if (lhs.eDS_View != rhs.eDS_View) return FALSE;
   if (lhs.eDS_Signal != rhs.eDS_Signal) return FALSE;
   if (lhs.eDS_Line != rhs.eDS_Line) return FALSE;
   if (lhs.aReserved != rhs.aReserved) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Camera_System_DS_Camera_State const& lhs, tcl_ITM_Camera_System_DS_Camera_State const& rhs){
    if (
         (lhs.eDS_View == rhs.eDS_View)
      && (lhs.eDS_Signal == rhs.eDS_Signal)
      && (lhs.eDS_Line == rhs.eDS_Line)
      && (lhs.aReserved == rhs.aReserved)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Camera_System_Camara_Set_State::tcl_ITM_Camera_System_Camara_Set_State() : 
   eSTR_Variation((tcl_ITM_Camera_System_e32_STR_Variation::tenType)0x00, 0x03),
   eSTR_Gear((tcl_ITM_Camera_System_e32_STR_Gear::tenType)0x00, 0x03),
   eLH_RH((tcl_ITM_Camera_System_e32_LH_RH::tenType)0x00, 0x02)
{
}

tBool tcl_ITM_Camera_System_Camara_Set_State::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eSTR_Variation.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSTR_Gear.bUpdateData(poMcanMsg);
   if (bRet) bRet = eLH_RH.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Camera_System_Camara_Set_State::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eSTR_Variation.bUpdateMcanMessage(poMcanMsg);
   eSTR_Gear.bUpdateMcanMessage(poMcanMsg);
   eLH_RH.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Camera_System_Camara_Set_State const& lhs, tcl_ITM_Camera_System_Camara_Set_State const& rhs){
   if (lhs.eSTR_Variation != rhs.eSTR_Variation) return FALSE;
   if (lhs.eSTR_Gear != rhs.eSTR_Gear) return FALSE;
   if (lhs.eLH_RH != rhs.eLH_RH) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Camera_System_Camara_Set_State const& lhs, tcl_ITM_Camera_System_Camara_Set_State const& rhs){
    if (
         (lhs.eSTR_Variation == rhs.eSTR_Variation)
      && (lhs.eSTR_Gear == rhs.eSTR_Gear)
      && (lhs.eLH_RH == rhs.eLH_RH)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Camera_System_Navi_Info_Number::tcl_ITM_Camera_System_Navi_Info_Number() : 
   uiNavi_Info_Number(0x00, 0x08)
{
}

tBool tcl_ITM_Camera_System_Navi_Info_Number::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiNavi_Info_Number.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Camera_System_Navi_Info_Number::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiNavi_Info_Number.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Camera_System_Navi_Info_Number const& lhs, tcl_ITM_Camera_System_Navi_Info_Number const& rhs){
   if (lhs.uiNavi_Info_Number != rhs.uiNavi_Info_Number) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Camera_System_Navi_Info_Number const& lhs, tcl_ITM_Camera_System_Navi_Info_Number const& rhs){
    if (
         (lhs.uiNavi_Info_Number == rhs.uiNavi_Info_Number)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Camera_System_Distance::tcl_ITM_Camera_System_Distance() : 
   eDistance((tcl_ITM_Camera_System_e32_Distance::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_Camera_System_Distance::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eDistance.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Camera_System_Distance::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eDistance.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Camera_System_Distance const& lhs, tcl_ITM_Camera_System_Distance const& rhs){
   if (lhs.eDistance != rhs.eDistance) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Camera_System_Distance const& lhs, tcl_ITM_Camera_System_Distance const& rhs){
    if (
         (lhs.eDistance == rhs.eDistance)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Camera_System_Wide_View_List::tcl_ITM_Camera_System_Wide_View_List() : 
   eRR_CM((tcl_ITM_Camera_System_e32_RR_CM::tenType)0x00, 0x01),
   eAS_CM((tcl_ITM_Camera_System_e32_AS_CM::tenType)0x00, 0x01),
   eFR_CM((tcl_ITM_Camera_System_e32_FR_CM::tenType)0x00, 0x01),
   aReserved_0_fixed_(NULL, 0x05)
{
}

tBool tcl_ITM_Camera_System_Wide_View_List::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eRR_CM.bUpdateData(poMcanMsg);
   if (bRet) bRet = eAS_CM.bUpdateData(poMcanMsg);
   if (bRet) bRet = eFR_CM.bUpdateData(poMcanMsg);
   if (bRet) bRet = aReserved_0_fixed_.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Camera_System_Wide_View_List::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eRR_CM.bUpdateMcanMessage(poMcanMsg);
   eAS_CM.bUpdateMcanMessage(poMcanMsg);
   eFR_CM.bUpdateMcanMessage(poMcanMsg);
   aReserved_0_fixed_.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Camera_System_Wide_View_List const& lhs, tcl_ITM_Camera_System_Wide_View_List const& rhs){
   if (lhs.eRR_CM != rhs.eRR_CM) return FALSE;
   if (lhs.eAS_CM != rhs.eAS_CM) return FALSE;
   if (lhs.eFR_CM != rhs.eFR_CM) return FALSE;
   if (lhs.aReserved_0_fixed_ != rhs.aReserved_0_fixed_) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Camera_System_Wide_View_List const& lhs, tcl_ITM_Camera_System_Wide_View_List const& rhs){
    if (
         (lhs.eRR_CM == rhs.eRR_CM)
      && (lhs.eAS_CM == rhs.eAS_CM)
      && (lhs.eFR_CM == rhs.eFR_CM)
      && (lhs.aReserved_0_fixed_ == rhs.aReserved_0_fixed_)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Camera_System_Disp_SW_08AVM::tcl_ITM_Camera_System_Disp_SW_08AVM() : 
   eSW1((tcl_ITM_Camera_System_e32_SW::tenType)0x00, 0x03),
   eSW1_Status((tcl_ITM_Camera_System_e32_SW1_Status::tenType)0x00, 0x05),
   eSW2((tcl_ITM_Camera_System_e32_SW::tenType)0x00, 0x03),
   eSW2_Status((tcl_ITM_Camera_System_e32_SW1_Status::tenType)0x00, 0x05),
   eSW3((tcl_ITM_Camera_System_e32_SW::tenType)0x00, 0x03),
   eSW3_Status((tcl_ITM_Camera_System_e32_SW1_Status::tenType)0x00, 0x05),
   eSW4((tcl_ITM_Camera_System_e32_SW::tenType)0x00, 0x03),
   eSW4_Status((tcl_ITM_Camera_System_e32_SW1_Status::tenType)0x00, 0x05),
   eSW5((tcl_ITM_Camera_System_e32_SW::tenType)0x00, 0x03),
   eSW5_Status((tcl_ITM_Camera_System_e32_SW1_Status::tenType)0x00, 0x05),
   eSW6((tcl_ITM_Camera_System_e32_SW::tenType)0x00, 0x03),
   eSW6_Status((tcl_ITM_Camera_System_e32_SW1_Status::tenType)0x00, 0x05),
   eSW7((tcl_ITM_Camera_System_e32_SW::tenType)0x00, 0x03),
   eSW7_Status((tcl_ITM_Camera_System_e32_SW1_Status::tenType)0x00, 0x05),
   eSW8((tcl_ITM_Camera_System_e32_SW::tenType)0x00, 0x03),
   eSW8_Status((tcl_ITM_Camera_System_e32_SW1_Status::tenType)0x00, 0x05)
{
}

tBool tcl_ITM_Camera_System_Disp_SW_08AVM::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eSW1.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSW1_Status.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSW2.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSW2_Status.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSW3.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSW3_Status.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSW4.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSW4_Status.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSW5.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSW5_Status.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSW6.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSW6_Status.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSW7.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSW7_Status.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSW8.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSW8_Status.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Camera_System_Disp_SW_08AVM::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eSW1.bUpdateMcanMessage(poMcanMsg);
   eSW1_Status.bUpdateMcanMessage(poMcanMsg);
   eSW2.bUpdateMcanMessage(poMcanMsg);
   eSW2_Status.bUpdateMcanMessage(poMcanMsg);
   eSW3.bUpdateMcanMessage(poMcanMsg);
   eSW3_Status.bUpdateMcanMessage(poMcanMsg);
   eSW4.bUpdateMcanMessage(poMcanMsg);
   eSW4_Status.bUpdateMcanMessage(poMcanMsg);
   eSW5.bUpdateMcanMessage(poMcanMsg);
   eSW5_Status.bUpdateMcanMessage(poMcanMsg);
   eSW6.bUpdateMcanMessage(poMcanMsg);
   eSW6_Status.bUpdateMcanMessage(poMcanMsg);
   eSW7.bUpdateMcanMessage(poMcanMsg);
   eSW7_Status.bUpdateMcanMessage(poMcanMsg);
   eSW8.bUpdateMcanMessage(poMcanMsg);
   eSW8_Status.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Camera_System_Disp_SW_08AVM const& lhs, tcl_ITM_Camera_System_Disp_SW_08AVM const& rhs){
   if (lhs.eSW1 != rhs.eSW1) return FALSE;
   if (lhs.eSW1_Status != rhs.eSW1_Status) return FALSE;
   if (lhs.eSW2 != rhs.eSW2) return FALSE;
   if (lhs.eSW2_Status != rhs.eSW2_Status) return FALSE;
   if (lhs.eSW3 != rhs.eSW3) return FALSE;
   if (lhs.eSW3_Status != rhs.eSW3_Status) return FALSE;
   if (lhs.eSW4 != rhs.eSW4) return FALSE;
   if (lhs.eSW4_Status != rhs.eSW4_Status) return FALSE;
   if (lhs.eSW5 != rhs.eSW5) return FALSE;
   if (lhs.eSW5_Status != rhs.eSW5_Status) return FALSE;
   if (lhs.eSW6 != rhs.eSW6) return FALSE;
   if (lhs.eSW6_Status != rhs.eSW6_Status) return FALSE;
   if (lhs.eSW7 != rhs.eSW7) return FALSE;
   if (lhs.eSW7_Status != rhs.eSW7_Status) return FALSE;
   if (lhs.eSW8 != rhs.eSW8) return FALSE;
   if (lhs.eSW8_Status != rhs.eSW8_Status) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Camera_System_Disp_SW_08AVM const& lhs, tcl_ITM_Camera_System_Disp_SW_08AVM const& rhs){
    if (
         (lhs.eSW1 == rhs.eSW1)
      && (lhs.eSW1_Status == rhs.eSW1_Status)
      && (lhs.eSW2 == rhs.eSW2)
      && (lhs.eSW2_Status == rhs.eSW2_Status)
      && (lhs.eSW3 == rhs.eSW3)
      && (lhs.eSW3_Status == rhs.eSW3_Status)
      && (lhs.eSW4 == rhs.eSW4)
      && (lhs.eSW4_Status == rhs.eSW4_Status)
      && (lhs.eSW5 == rhs.eSW5)
      && (lhs.eSW5_Status == rhs.eSW5_Status)
      && (lhs.eSW6 == rhs.eSW6)
      && (lhs.eSW6_Status == rhs.eSW6_Status)
      && (lhs.eSW7 == rhs.eSW7)
      && (lhs.eSW7_Status == rhs.eSW7_Status)
      && (lhs.eSW8 == rhs.eSW8)
      && (lhs.eSW8_Status == rhs.eSW8_Status)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Camera_System_Camera_08AVM::tcl_ITM_Camera_System_Camera_08AVM() : 
   eVehicle_Speed((tcl_ITM_Camera_System_e32_Vehicle_Speed::tenType)0x00, 0x02),
   eView_Line((tcl_ITM_Camera_System_e32_View_Line::tenType)0x00, 0x02),
   ePriority_View((tcl_ITM_Camera_System_e32_Priority_View::tenType)0x00, 0x02),
   eMask_Emphasis((tcl_ITM_Camera_System_e32_Mask_Emphasis::tenType)0x00, 0x02),
   eSide_Sonar_Disp((tcl_ITM_Camera_System_e32_Side_Sonar_Disp::tenType)0x00, 0x02),
   eAdjust_Topview((tcl_ITM_Camera_System_e32_Adjust_Topview::tenType)0x00, 0x02),
   ePriority_Wide((tcl_ITM_Camera_System_e32_Priority_Wide::tenType)0x00, 0x02),
   eAuto_Cam_Position((tcl_ITM_Camera_System_e32_Auto_Cam_Position::tenType)0x00, 0x02),
   eVolume_Voice((tcl_ITM_Camera_System_e32_Volume_Voice::tenType)0x00, 0x02),
   eSonar_Buzzer((tcl_ITM_Camera_System_e32_Sonar_Buzzer::tenType)0x00, 0x02),
   eRear_Wide_View((tcl_ITM_Camera_System_e32_Rear_Wide_View::tenType)0x00, 0x02),
   eSonar_ON_OFF((tcl_ITM_Camera_System_e32_Sonar_ON_OFF::tenType)0x00, 0x02),
   eMOD_Interrupt((tcl_ITM_Camera_System_e32_MOD_Interrupt::tenType)0x00, 0x02),
   eSonar_Interrupt((tcl_ITM_Camera_System_e32_Sonar_Interrupt::tenType)0x00, 0x02),
   eMOD_Function((tcl_ITM_Camera_System_e32_MOD_Function::tenType)0x00, 0x02),
   eMOD_Night_Use((tcl_ITM_Camera_System_e32_MOD_Night_Use::tenType)0x00, 0x02),
   eBCP_Function((tcl_ITM_Camera_System_e32_BCP_Function::tenType)0x00, 0x02),
   eFront_Sonar_Only((tcl_ITM_Camera_System_e32_Front_Sonar_Only::tenType)0x00, 0x02),
   areserve(NULL, 0x1C)
{
}

tBool tcl_ITM_Camera_System_Camera_08AVM::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eVehicle_Speed.bUpdateData(poMcanMsg);
   if (bRet) bRet = eView_Line.bUpdateData(poMcanMsg);
   if (bRet) bRet = ePriority_View.bUpdateData(poMcanMsg);
   if (bRet) bRet = eMask_Emphasis.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSide_Sonar_Disp.bUpdateData(poMcanMsg);
   if (bRet) bRet = eAdjust_Topview.bUpdateData(poMcanMsg);
   if (bRet) bRet = ePriority_Wide.bUpdateData(poMcanMsg);
   if (bRet) bRet = eAuto_Cam_Position.bUpdateData(poMcanMsg);
   if (bRet) bRet = eVolume_Voice.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSonar_Buzzer.bUpdateData(poMcanMsg);
   if (bRet) bRet = eRear_Wide_View.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSonar_ON_OFF.bUpdateData(poMcanMsg);
   if (bRet) bRet = eMOD_Interrupt.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSonar_Interrupt.bUpdateData(poMcanMsg);
   if (bRet) bRet = eMOD_Function.bUpdateData(poMcanMsg);
   if (bRet) bRet = eMOD_Night_Use.bUpdateData(poMcanMsg);
   if (bRet) bRet = eBCP_Function.bUpdateData(poMcanMsg);
   if (bRet) bRet = eFront_Sonar_Only.bUpdateData(poMcanMsg);
   if (bRet) bRet = areserve.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Camera_System_Camera_08AVM::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eVehicle_Speed.bUpdateMcanMessage(poMcanMsg);
   eView_Line.bUpdateMcanMessage(poMcanMsg);
   ePriority_View.bUpdateMcanMessage(poMcanMsg);
   eMask_Emphasis.bUpdateMcanMessage(poMcanMsg);
   eSide_Sonar_Disp.bUpdateMcanMessage(poMcanMsg);
   eAdjust_Topview.bUpdateMcanMessage(poMcanMsg);
   ePriority_Wide.bUpdateMcanMessage(poMcanMsg);
   eAuto_Cam_Position.bUpdateMcanMessage(poMcanMsg);
   eVolume_Voice.bUpdateMcanMessage(poMcanMsg);
   eSonar_Buzzer.bUpdateMcanMessage(poMcanMsg);
   eRear_Wide_View.bUpdateMcanMessage(poMcanMsg);
   eSonar_ON_OFF.bUpdateMcanMessage(poMcanMsg);
   eMOD_Interrupt.bUpdateMcanMessage(poMcanMsg);
   eSonar_Interrupt.bUpdateMcanMessage(poMcanMsg);
   eMOD_Function.bUpdateMcanMessage(poMcanMsg);
   eMOD_Night_Use.bUpdateMcanMessage(poMcanMsg);
   eBCP_Function.bUpdateMcanMessage(poMcanMsg);
   eFront_Sonar_Only.bUpdateMcanMessage(poMcanMsg);
   areserve.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Camera_System_Camera_08AVM const& lhs, tcl_ITM_Camera_System_Camera_08AVM const& rhs){
   if (lhs.eVehicle_Speed != rhs.eVehicle_Speed) return FALSE;
   if (lhs.eView_Line != rhs.eView_Line) return FALSE;
   if (lhs.ePriority_View != rhs.ePriority_View) return FALSE;
   if (lhs.eMask_Emphasis != rhs.eMask_Emphasis) return FALSE;
   if (lhs.eSide_Sonar_Disp != rhs.eSide_Sonar_Disp) return FALSE;
   if (lhs.eAdjust_Topview != rhs.eAdjust_Topview) return FALSE;
   if (lhs.ePriority_Wide != rhs.ePriority_Wide) return FALSE;
   if (lhs.eAuto_Cam_Position != rhs.eAuto_Cam_Position) return FALSE;
   if (lhs.eVolume_Voice != rhs.eVolume_Voice) return FALSE;
   if (lhs.eSonar_Buzzer != rhs.eSonar_Buzzer) return FALSE;
   if (lhs.eRear_Wide_View != rhs.eRear_Wide_View) return FALSE;
   if (lhs.eSonar_ON_OFF != rhs.eSonar_ON_OFF) return FALSE;
   if (lhs.eMOD_Interrupt != rhs.eMOD_Interrupt) return FALSE;
   if (lhs.eSonar_Interrupt != rhs.eSonar_Interrupt) return FALSE;
   if (lhs.eMOD_Function != rhs.eMOD_Function) return FALSE;
   if (lhs.eMOD_Night_Use != rhs.eMOD_Night_Use) return FALSE;
   if (lhs.eBCP_Function != rhs.eBCP_Function) return FALSE;
   if (lhs.eFront_Sonar_Only != rhs.eFront_Sonar_Only) return FALSE;
   if (lhs.areserve != rhs.areserve) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Camera_System_Camera_08AVM const& lhs, tcl_ITM_Camera_System_Camera_08AVM const& rhs){
    if (
         (lhs.eVehicle_Speed == rhs.eVehicle_Speed)
      && (lhs.eView_Line == rhs.eView_Line)
      && (lhs.ePriority_View == rhs.ePriority_View)
      && (lhs.eMask_Emphasis == rhs.eMask_Emphasis)
      && (lhs.eSide_Sonar_Disp == rhs.eSide_Sonar_Disp)
      && (lhs.eAdjust_Topview == rhs.eAdjust_Topview)
      && (lhs.ePriority_Wide == rhs.ePriority_Wide)
      && (lhs.eAuto_Cam_Position == rhs.eAuto_Cam_Position)
      && (lhs.eVolume_Voice == rhs.eVolume_Voice)
      && (lhs.eSonar_Buzzer == rhs.eSonar_Buzzer)
      && (lhs.eRear_Wide_View == rhs.eRear_Wide_View)
      && (lhs.eSonar_ON_OFF == rhs.eSonar_ON_OFF)
      && (lhs.eMOD_Interrupt == rhs.eMOD_Interrupt)
      && (lhs.eSonar_Interrupt == rhs.eSonar_Interrupt)
      && (lhs.eMOD_Function == rhs.eMOD_Function)
      && (lhs.eMOD_Night_Use == rhs.eMOD_Night_Use)
      && (lhs.eBCP_Function == rhs.eBCP_Function)
      && (lhs.eFront_Sonar_Only == rhs.eFront_Sonar_Only)
      && (lhs.areserve == rhs.areserve)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Camera_System_Priority_Info::tcl_ITM_Camera_System_Priority_Info() : 
   eFirst_Priority((tcl_ITM_Camera_System_e32_First_Priority::tenType)0x00, 0x03),
   eSecond_Priority((tcl_ITM_Camera_System_e32_Second_Priority::tenType)0x00, 0x03),
   eThird_Priority((tcl_ITM_Camera_System_e32_Third_Priority::tenType)0x00, 0x03),
   ePriority_Select((tcl_ITM_Camera_System_e32_Priority_Select::tenType)0x00, 0x03),
   eSelect_Screen((tcl_ITM_Camera_System_e32_Select_Screen::tenType)0x00, 0x04)
{
}

tBool tcl_ITM_Camera_System_Priority_Info::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eFirst_Priority.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSecond_Priority.bUpdateData(poMcanMsg);
   if (bRet) bRet = eThird_Priority.bUpdateData(poMcanMsg);
   if (bRet) bRet = ePriority_Select.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSelect_Screen.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Camera_System_Priority_Info::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eFirst_Priority.bUpdateMcanMessage(poMcanMsg);
   eSecond_Priority.bUpdateMcanMessage(poMcanMsg);
   eThird_Priority.bUpdateMcanMessage(poMcanMsg);
   ePriority_Select.bUpdateMcanMessage(poMcanMsg);
   eSelect_Screen.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Camera_System_Priority_Info const& lhs, tcl_ITM_Camera_System_Priority_Info const& rhs){
   if (lhs.eFirst_Priority != rhs.eFirst_Priority) return FALSE;
   if (lhs.eSecond_Priority != rhs.eSecond_Priority) return FALSE;
   if (lhs.eThird_Priority != rhs.eThird_Priority) return FALSE;
   if (lhs.ePriority_Select != rhs.ePriority_Select) return FALSE;
   if (lhs.eSelect_Screen != rhs.eSelect_Screen) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Camera_System_Priority_Info const& lhs, tcl_ITM_Camera_System_Priority_Info const& rhs){
    if (
         (lhs.eFirst_Priority == rhs.eFirst_Priority)
      && (lhs.eSecond_Priority == rhs.eSecond_Priority)
      && (lhs.eThird_Priority == rhs.eThird_Priority)
      && (lhs.ePriority_Select == rhs.ePriority_Select)
      && (lhs.eSelect_Screen == rhs.eSelect_Screen)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Camera_System_Primary_Setting::tcl_ITM_Camera_System_Primary_Setting() : 
   eAVM_Sonar((tcl_ITM_Camera_System_e32_AVM_Sonar::tenType)0x00, 0x02),
   eDetail_Setting((tcl_ITM_Camera_System_e32_Detail_Setting::tenType)0x00, 0x01),
   eImage_Quality((tcl_ITM_Camera_System_e32_Image_Quality::tenType)0x00, 0x01),
   aReserve_4bits(NULL, 0x04)
{
}

tBool tcl_ITM_Camera_System_Primary_Setting::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eAVM_Sonar.bUpdateData(poMcanMsg);
   if (bRet) bRet = eDetail_Setting.bUpdateData(poMcanMsg);
   if (bRet) bRet = eImage_Quality.bUpdateData(poMcanMsg);
   if (bRet) bRet = aReserve_4bits.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Camera_System_Primary_Setting::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eAVM_Sonar.bUpdateMcanMessage(poMcanMsg);
   eDetail_Setting.bUpdateMcanMessage(poMcanMsg);
   eImage_Quality.bUpdateMcanMessage(poMcanMsg);
   aReserve_4bits.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Camera_System_Primary_Setting const& lhs, tcl_ITM_Camera_System_Primary_Setting const& rhs){
   if (lhs.eAVM_Sonar != rhs.eAVM_Sonar) return FALSE;
   if (lhs.eDetail_Setting != rhs.eDetail_Setting) return FALSE;
   if (lhs.eImage_Quality != rhs.eImage_Quality) return FALSE;
   if (lhs.aReserve_4bits != rhs.aReserve_4bits) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Camera_System_Primary_Setting const& lhs, tcl_ITM_Camera_System_Primary_Setting const& rhs){
    if (
         (lhs.eAVM_Sonar == rhs.eAVM_Sonar)
      && (lhs.eDetail_Setting == rhs.eDetail_Setting)
      && (lhs.eImage_Quality == rhs.eImage_Quality)
      && (lhs.aReserve_4bits == rhs.aReserve_4bits)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Camera_System_Touch_X::tcl_ITM_Camera_System_Touch_X() : 
   uiTouch_X(0x00, 0x10)
{
}

tBool tcl_ITM_Camera_System_Touch_X::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiTouch_X.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Camera_System_Touch_X::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiTouch_X.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Camera_System_Touch_X const& lhs, tcl_ITM_Camera_System_Touch_X const& rhs){
   if (lhs.uiTouch_X != rhs.uiTouch_X) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Camera_System_Touch_X const& lhs, tcl_ITM_Camera_System_Touch_X const& rhs){
    if (
         (lhs.uiTouch_X == rhs.uiTouch_X)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Camera_System_Touch_Y::tcl_ITM_Camera_System_Touch_Y() : 
   uiTouch_Y(0x00, 0x10)
{
}

tBool tcl_ITM_Camera_System_Touch_Y::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiTouch_Y.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Camera_System_Touch_Y::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiTouch_Y.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Camera_System_Touch_Y const& lhs, tcl_ITM_Camera_System_Touch_Y const& rhs){
   if (lhs.uiTouch_Y != rhs.uiTouch_Y) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Camera_System_Touch_Y const& lhs, tcl_ITM_Camera_System_Touch_Y const& rhs){
    if (
         (lhs.uiTouch_Y == rhs.uiTouch_Y)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Camera_System_Voice::tcl_ITM_Camera_System_Voice() : 
   eVoice((tcl_ITM_Camera_System_e32_Voice::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_Camera_System_Voice::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eVoice.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Camera_System_Voice::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eVoice.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Camera_System_Voice const& lhs, tcl_ITM_Camera_System_Voice const& rhs){
   if (lhs.eVoice != rhs.eVoice) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Camera_System_Voice const& lhs, tcl_ITM_Camera_System_Voice const& rhs){
    if (
         (lhs.eVoice == rhs.eVoice)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Camera_System_Gateway_Status::tcl_ITM_Camera_System_Gateway_Status() : 
   eGateway_Status((tcl_ITM_Camera_System_e32_Gateway_Status::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_Camera_System_Gateway_Status::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eGateway_Status.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Camera_System_Gateway_Status::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eGateway_Status.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Camera_System_Gateway_Status const& lhs, tcl_ITM_Camera_System_Gateway_Status const& rhs){
   if (lhs.eGateway_Status != rhs.eGateway_Status) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Camera_System_Gateway_Status const& lhs, tcl_ITM_Camera_System_Gateway_Status const& rhs){
    if (
         (lhs.eGateway_Status == rhs.eGateway_Status)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Camera_System_Back_Sonar_Level::tcl_ITM_Camera_System_Back_Sonar_Level() : 
   eBack_Sonar_Level_7bit((tcl_ITM_Camera_System_e32_Back_Sonar_Level_7bit::tenType)0x00, 0x01),
   eBack_Sonar_Leve_6_4bit((tcl_ITM_Camera_System_e32_Back_Sonar_Leve_6_4bit::tenType)0x00, 0x03),
   aBack_Sonar_Level_3_0bit(NULL, 0x04)
{
}

tBool tcl_ITM_Camera_System_Back_Sonar_Level::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eBack_Sonar_Level_7bit.bUpdateData(poMcanMsg);
   if (bRet) bRet = eBack_Sonar_Leve_6_4bit.bUpdateData(poMcanMsg);
   if (bRet) bRet = aBack_Sonar_Level_3_0bit.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Camera_System_Back_Sonar_Level::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eBack_Sonar_Level_7bit.bUpdateMcanMessage(poMcanMsg);
   eBack_Sonar_Leve_6_4bit.bUpdateMcanMessage(poMcanMsg);
   aBack_Sonar_Level_3_0bit.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Camera_System_Back_Sonar_Level const& lhs, tcl_ITM_Camera_System_Back_Sonar_Level const& rhs){
   if (lhs.eBack_Sonar_Level_7bit != rhs.eBack_Sonar_Level_7bit) return FALSE;
   if (lhs.eBack_Sonar_Leve_6_4bit != rhs.eBack_Sonar_Leve_6_4bit) return FALSE;
   if (lhs.aBack_Sonar_Level_3_0bit != rhs.aBack_Sonar_Level_3_0bit) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Camera_System_Back_Sonar_Level const& lhs, tcl_ITM_Camera_System_Back_Sonar_Level const& rhs){
    if (
         (lhs.eBack_Sonar_Level_7bit == rhs.eBack_Sonar_Level_7bit)
      && (lhs.eBack_Sonar_Leve_6_4bit == rhs.eBack_Sonar_Leve_6_4bit)
      && (lhs.aBack_Sonar_Level_3_0bit == rhs.aBack_Sonar_Level_3_0bit)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

