/*!
  *  \file mcanParameter.cpp
  *  \brief generated file containing enumeration info for MCAN communication.
  *         generated at  : --.--.2016
  *         generated with: python .\genericCodeGen.py -i .\tmpl\mcanParameter.cpp.tpl -b .\CanSimu2\config\mcan -o .\enumTest\mcanParameter.cpp
*/

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FD_CSM_MCAN
#include "trcGenProj/Header/mcanParameterAudio.cpp.trc.h"
#endif

#include "mcanParameterAudio.h"


tcl_ITM_Meter_Audio__Unit_ID::tcl_ITM_Meter_Audio__Unit_ID() : 
   eMeter_Type((tcl_ITM_Meter_Audio__e32_Meter_Type::tenType)0x00, 0x06),
   eAccessory_Power_Type((tcl_ITM_Meter_Audio__e32_Power_Type_List::tenType)0x00, 0x02)
{
}

tBool tcl_ITM_Meter_Audio__Unit_ID::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eMeter_Type.bUpdateData(poMcanMsg);
   if (bRet) bRet = eAccessory_Power_Type.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__Unit_ID::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eMeter_Type.bUpdateMcanMessage(poMcanMsg);
   eAccessory_Power_Type.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__Unit_ID const& lhs, tcl_ITM_Meter_Audio__Unit_ID const& rhs){
   if (lhs.eMeter_Type != rhs.eMeter_Type) return FALSE;
   if (lhs.eAccessory_Power_Type != rhs.eAccessory_Power_Type) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__Unit_ID const& lhs, tcl_ITM_Meter_Audio__Unit_ID const& rhs){
    if (
         (lhs.eMeter_Type == rhs.eMeter_Type)
      && (lhs.eAccessory_Power_Type == rhs.eAccessory_Power_Type)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__Msg_Version::tcl_ITM_Meter_Audio__Msg_Version() : 
   uiVersion_Upper_(0x00, 0x08),
   uiVersion_Middle_(0x00, 0x08),
   uiVersion_Lower_(0x00, 0x08)
{
}

tBool tcl_ITM_Meter_Audio__Msg_Version::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiVersion_Upper_.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiVersion_Middle_.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiVersion_Lower_.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__Msg_Version::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiVersion_Upper_.bUpdateMcanMessage(poMcanMsg);
   uiVersion_Middle_.bUpdateMcanMessage(poMcanMsg);
   uiVersion_Lower_.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__Msg_Version const& lhs, tcl_ITM_Meter_Audio__Msg_Version const& rhs){
   if (lhs.uiVersion_Upper_ != rhs.uiVersion_Upper_) return FALSE;
   if (lhs.uiVersion_Middle_ != rhs.uiVersion_Middle_) return FALSE;
   if (lhs.uiVersion_Lower_ != rhs.uiVersion_Lower_) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__Msg_Version const& lhs, tcl_ITM_Meter_Audio__Msg_Version const& rhs){
    if (
         (lhs.uiVersion_Upper_ == rhs.uiVersion_Upper_)
      && (lhs.uiVersion_Middle_ == rhs.uiVersion_Middle_)
      && (lhs.uiVersion_Lower_ == rhs.uiVersion_Lower_)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__Version::tcl_ITM_Meter_Audio__Version() : 
   uiVersion_Upper_(0x00, 0x08),
   uiVersion_Middle_(0x00, 0x08),
   uiVersion_Lower_(0x00, 0x08)
{
}

tBool tcl_ITM_Meter_Audio__Version::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiVersion_Upper_.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiVersion_Middle_.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiVersion_Lower_.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__Version::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiVersion_Upper_.bUpdateMcanMessage(poMcanMsg);
   uiVersion_Middle_.bUpdateMcanMessage(poMcanMsg);
   uiVersion_Lower_.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__Version const& lhs, tcl_ITM_Meter_Audio__Version const& rhs){
   if (lhs.uiVersion_Upper_ != rhs.uiVersion_Upper_) return FALSE;
   if (lhs.uiVersion_Middle_ != rhs.uiVersion_Middle_) return FALSE;
   if (lhs.uiVersion_Lower_ != rhs.uiVersion_Lower_) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__Version const& lhs, tcl_ITM_Meter_Audio__Version const& rhs){
    if (
         (lhs.uiVersion_Upper_ == rhs.uiVersion_Upper_)
      && (lhs.uiVersion_Middle_ == rhs.uiVersion_Middle_)
      && (lhs.uiVersion_Lower_ == rhs.uiVersion_Lower_)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__Text_Info::tcl_ITM_Meter_Audio__Text_Info() : 
   eCharacter_Set((tcl_ITM_Meter_Audio__e32_Character_Set_List::tenType)0x00, 0x08),
   uiLength(0x01, 0x08),
   vstrText_Body(NULL, 0)
{
}

tBool tcl_ITM_Meter_Audio__Text_Info::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eCharacter_Set.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiLength.bUpdateData(poMcanMsg);

   if (bRet) bRet = vstrText_Body.bUpdateLength(8*uiLength.u32GetData());
   if (bRet) bRet = vstrText_Body.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__Text_Info::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eCharacter_Set.bUpdateMcanMessage(poMcanMsg);
   uiLength.bUpdateMcanMessage(poMcanMsg);
   vstrText_Body.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__Text_Info const& lhs, tcl_ITM_Meter_Audio__Text_Info const& rhs){
   if (lhs.eCharacter_Set != rhs.eCharacter_Set) return FALSE;
   if (lhs.uiLength != rhs.uiLength) return FALSE;
   if (lhs.vstrText_Body != rhs.vstrText_Body) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__Text_Info const& lhs, tcl_ITM_Meter_Audio__Text_Info const& rhs){
    if (
         (lhs.eCharacter_Set == rhs.eCharacter_Set)
      && (lhs.uiLength == rhs.uiLength)
      && (lhs.vstrText_Body == rhs.vstrText_Body)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__Available_Function::tcl_ITM_Meter_Audio__Available_Function() : 
   eAudio((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   eHF((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   eSMS((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   eVR((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   aReserve(NULL, 0x04)
{
}

tBool tcl_ITM_Meter_Audio__Available_Function::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eAudio.bUpdateData(poMcanMsg);
   if (bRet) bRet = eHF.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSMS.bUpdateData(poMcanMsg);
   if (bRet) bRet = eVR.bUpdateData(poMcanMsg);
   if (bRet) bRet = aReserve.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__Available_Function::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eAudio.bUpdateMcanMessage(poMcanMsg);
   eHF.bUpdateMcanMessage(poMcanMsg);
   eSMS.bUpdateMcanMessage(poMcanMsg);
   eVR.bUpdateMcanMessage(poMcanMsg);
   aReserve.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__Available_Function const& lhs, tcl_ITM_Meter_Audio__Available_Function const& rhs){
   if (lhs.eAudio != rhs.eAudio) return FALSE;
   if (lhs.eHF != rhs.eHF) return FALSE;
   if (lhs.eSMS != rhs.eSMS) return FALSE;
   if (lhs.eVR != rhs.eVR) return FALSE;
   if (lhs.aReserve != rhs.aReserve) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__Available_Function const& lhs, tcl_ITM_Meter_Audio__Available_Function const& rhs){
    if (
         (lhs.eAudio == rhs.eAudio)
      && (lhs.eHF == rhs.eHF)
      && (lhs.eSMS == rhs.eSMS)
      && (lhs.eVR == rhs.eVR)
      && (lhs.aReserve == rhs.aReserve)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__Interrupt::tcl_ITM_Meter_Audio__Interrupt() : 
   eInterrupt((tcl_ITM_Meter_Audio__e32_Enable::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_Meter_Audio__Interrupt::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eInterrupt.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__Interrupt::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eInterrupt.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__Interrupt const& lhs, tcl_ITM_Meter_Audio__Interrupt const& rhs){
   if (lhs.eInterrupt != rhs.eInterrupt) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__Interrupt const& lhs, tcl_ITM_Meter_Audio__Interrupt const& rhs){
    if (
         (lhs.eInterrupt == rhs.eInterrupt)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__Audio_Warning_State::tcl_ITM_Meter_Audio__Audio_Warning_State() : 
   eAudio_Warning_State((tcl_ITM_Meter_Audio__e32_Audio_State_List::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_Meter_Audio__Audio_Warning_State::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eAudio_Warning_State.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__Audio_Warning_State::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eAudio_Warning_State.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__Audio_Warning_State const& lhs, tcl_ITM_Meter_Audio__Audio_Warning_State const& rhs){
   if (lhs.eAudio_Warning_State != rhs.eAudio_Warning_State) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__Audio_Warning_State const& lhs, tcl_ITM_Meter_Audio__Audio_Warning_State const& rhs){
    if (
         (lhs.eAudio_Warning_State == rhs.eAudio_Warning_State)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__VR_Info::tcl_ITM_Meter_Audio__VR_Info() : 
   eVR_State((tcl_ITM_Meter_Audio__e32_VR_Status_List::tenType)0x00, 0x08),
   eOn_Off((tcl_ITM_Meter_Audio__e32_VR_On_Off::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_Meter_Audio__VR_Info::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eVR_State.bUpdateData(poMcanMsg);
   if (bRet) bRet = eOn_Off.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__VR_Info::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eVR_State.bUpdateMcanMessage(poMcanMsg);
   eOn_Off.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__VR_Info const& lhs, tcl_ITM_Meter_Audio__VR_Info const& rhs){
   if (lhs.eVR_State != rhs.eVR_State) return FALSE;
   if (lhs.eOn_Off != rhs.eOn_Off) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__VR_Info const& lhs, tcl_ITM_Meter_Audio__VR_Info const& rhs){
    if (
         (lhs.eVR_State == rhs.eVR_State)
      && (lhs.eOn_Off == rhs.eOn_Off)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__Group::tcl_ITM_Meter_Audio__Group() : 
   eUpdate((tcl_ITM_Meter_Audio__e32_Update_List::tenType)0x00, 0x08),
   eLabel((tcl_ITM_Meter_Audio__e32_Disc_Groupe_Label_List::tenType)0x00, 0x08),
   uiNo(0x00, 0x10),
   eText_Info_Character_Set((tcl_ITM_Meter_Audio__e32_Character_Set_List::tenType)0x01, 0x08),
   uiText_Info_Length(0x01, 0x08),
   vstrText_Info_Text_Body(NULL, 0)
{
}

tBool tcl_ITM_Meter_Audio__Group::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eUpdate.bUpdateData(poMcanMsg);
   if (bRet) bRet = eLabel.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiNo.bUpdateData(poMcanMsg);
   if (bRet) bRet = eText_Info_Character_Set.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiText_Info_Length.bUpdateData(poMcanMsg);

   if (bRet) bRet = vstrText_Info_Text_Body.bUpdateLength(8*uiText_Info_Length.u32GetData());
   if (bRet) bRet = vstrText_Info_Text_Body.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__Group::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eUpdate.bUpdateMcanMessage(poMcanMsg);
   eLabel.bUpdateMcanMessage(poMcanMsg);
   uiNo.bUpdateMcanMessage(poMcanMsg);
   eText_Info_Character_Set.bUpdateMcanMessage(poMcanMsg);
   uiText_Info_Length.bUpdateMcanMessage(poMcanMsg);
   vstrText_Info_Text_Body.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__Group const& lhs, tcl_ITM_Meter_Audio__Group const& rhs){
   if (lhs.eUpdate != rhs.eUpdate) return FALSE;
   if (lhs.eLabel != rhs.eLabel) return FALSE;
   if (lhs.uiNo != rhs.uiNo) return FALSE;
   if (lhs.eText_Info_Character_Set != rhs.eText_Info_Character_Set) return FALSE;
   if (lhs.uiText_Info_Length != rhs.uiText_Info_Length) return FALSE;
   if (lhs.vstrText_Info_Text_Body != rhs.vstrText_Info_Text_Body) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__Group const& lhs, tcl_ITM_Meter_Audio__Group const& rhs){
    if (
         (lhs.eUpdate == rhs.eUpdate)
      && (lhs.eLabel == rhs.eLabel)
      && (lhs.uiNo == rhs.uiNo)
      && (lhs.eText_Info_Character_Set == rhs.eText_Info_Character_Set)
      && (lhs.uiText_Info_Length == rhs.uiText_Info_Length)
      && (lhs.vstrText_Info_Text_Body == rhs.vstrText_Info_Text_Body)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__Track::tcl_ITM_Meter_Audio__Track() : 
   eUpdate((tcl_ITM_Meter_Audio__e32_Update_List::tenType)0x00, 0x08),
   eLabel((tcl_ITM_Meter_Audio__e32_Disc_Track_Label_List::tenType)0x00, 0x08),
   uiNo(0x00, 0x18),
   eText_Info_Character_Set((tcl_ITM_Meter_Audio__e32_Character_Set_List::tenType)0x01, 0x08),
   uiText_Info_Length(0x01, 0x08),
   vstrText_Info_Text_Body(NULL, 0)
{
}

tBool tcl_ITM_Meter_Audio__Track::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eUpdate.bUpdateData(poMcanMsg);
   if (bRet) bRet = eLabel.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiNo.bUpdateData(poMcanMsg);
   if (bRet) bRet = eText_Info_Character_Set.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiText_Info_Length.bUpdateData(poMcanMsg);

   if (bRet) bRet = vstrText_Info_Text_Body.bUpdateLength(8*uiText_Info_Length.u32GetData());
   if (bRet) bRet = vstrText_Info_Text_Body.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__Track::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eUpdate.bUpdateMcanMessage(poMcanMsg);
   eLabel.bUpdateMcanMessage(poMcanMsg);
   uiNo.bUpdateMcanMessage(poMcanMsg);
   eText_Info_Character_Set.bUpdateMcanMessage(poMcanMsg);
   uiText_Info_Length.bUpdateMcanMessage(poMcanMsg);
   vstrText_Info_Text_Body.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__Track const& lhs, tcl_ITM_Meter_Audio__Track const& rhs){
   if (lhs.eUpdate != rhs.eUpdate) return FALSE;
   if (lhs.eLabel != rhs.eLabel) return FALSE;
   if (lhs.uiNo != rhs.uiNo) return FALSE;
   if (lhs.eText_Info_Character_Set != rhs.eText_Info_Character_Set) return FALSE;
   if (lhs.uiText_Info_Length != rhs.uiText_Info_Length) return FALSE;
   if (lhs.vstrText_Info_Text_Body != rhs.vstrText_Info_Text_Body) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__Track const& lhs, tcl_ITM_Meter_Audio__Track const& rhs){
    if (
         (lhs.eUpdate == rhs.eUpdate)
      && (lhs.eLabel == rhs.eLabel)
      && (lhs.uiNo == rhs.uiNo)
      && (lhs.eText_Info_Character_Set == rhs.eText_Info_Character_Set)
      && (lhs.uiText_Info_Length == rhs.uiText_Info_Length)
      && (lhs.vstrText_Info_Text_Body == rhs.vstrText_Info_Text_Body)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__Language::tcl_ITM_Meter_Audio__Language() : 
   eDefault((tcl_ITM_Meter_Audio__e32_Language_List::tenType)0x01, 0x08),
   eCurrent((tcl_ITM_Meter_Audio__e32_Language_List::tenType)0x01, 0x08),
   eAvailable_Setting_US_English((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   eAvailable_Setting_Canadian_French((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   eAvailable_Setting_Mexican_Spanish((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   eAvailable_Setting_Japanese((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   eAvailable_Setting_Chinese_Mandarin_((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   eAvailable_Setting_Chinese_Traditional_((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   eAvailable_Setting_Korean((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   eAvailable_Setting_Arabic((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   eAvailable_Setting_Thai((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   eAvailable_Setting_UK_English((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   eAvailable_Setting_French((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   eAvailable_Setting_Spanish((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   eAvailable_Setting_German((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   eAvailable_Setting_Italian((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   eAvailable_Setting_Portuguese_for_Portugal((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   eAvailable_Setting_Portuguese_for_Brazil((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   eAvailable_Setting_Dutch((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   eAvailable_Setting_Turkish((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   eAvailable_Setting_Russian((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   aAvailable_Setting_Reserve(NULL, 0x05)
{
}

tBool tcl_ITM_Meter_Audio__Language::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eDefault.bUpdateData(poMcanMsg);
   if (bRet) bRet = eCurrent.bUpdateData(poMcanMsg);
   if (bRet) bRet = eAvailable_Setting_US_English.bUpdateData(poMcanMsg);
   if (bRet) bRet = eAvailable_Setting_Canadian_French.bUpdateData(poMcanMsg);
   if (bRet) bRet = eAvailable_Setting_Mexican_Spanish.bUpdateData(poMcanMsg);
   if (bRet) bRet = eAvailable_Setting_Japanese.bUpdateData(poMcanMsg);
   if (bRet) bRet = eAvailable_Setting_Chinese_Mandarin_.bUpdateData(poMcanMsg);
   if (bRet) bRet = eAvailable_Setting_Chinese_Traditional_.bUpdateData(poMcanMsg);
   if (bRet) bRet = eAvailable_Setting_Korean.bUpdateData(poMcanMsg);
   if (bRet) bRet = eAvailable_Setting_Arabic.bUpdateData(poMcanMsg);
   if (bRet) bRet = eAvailable_Setting_Thai.bUpdateData(poMcanMsg);
   if (bRet) bRet = eAvailable_Setting_UK_English.bUpdateData(poMcanMsg);
   if (bRet) bRet = eAvailable_Setting_French.bUpdateData(poMcanMsg);
   if (bRet) bRet = eAvailable_Setting_Spanish.bUpdateData(poMcanMsg);
   if (bRet) bRet = eAvailable_Setting_German.bUpdateData(poMcanMsg);
   if (bRet) bRet = eAvailable_Setting_Italian.bUpdateData(poMcanMsg);
   if (bRet) bRet = eAvailable_Setting_Portuguese_for_Portugal.bUpdateData(poMcanMsg);
   if (bRet) bRet = eAvailable_Setting_Portuguese_for_Brazil.bUpdateData(poMcanMsg);
   if (bRet) bRet = eAvailable_Setting_Dutch.bUpdateData(poMcanMsg);
   if (bRet) bRet = eAvailable_Setting_Turkish.bUpdateData(poMcanMsg);
   if (bRet) bRet = eAvailable_Setting_Russian.bUpdateData(poMcanMsg);
   if (bRet) bRet = aAvailable_Setting_Reserve.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__Language::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eDefault.bUpdateMcanMessage(poMcanMsg);
   eCurrent.bUpdateMcanMessage(poMcanMsg);
   eAvailable_Setting_US_English.bUpdateMcanMessage(poMcanMsg);
   eAvailable_Setting_Canadian_French.bUpdateMcanMessage(poMcanMsg);
   eAvailable_Setting_Mexican_Spanish.bUpdateMcanMessage(poMcanMsg);
   eAvailable_Setting_Japanese.bUpdateMcanMessage(poMcanMsg);
   eAvailable_Setting_Chinese_Mandarin_.bUpdateMcanMessage(poMcanMsg);
   eAvailable_Setting_Chinese_Traditional_.bUpdateMcanMessage(poMcanMsg);
   eAvailable_Setting_Korean.bUpdateMcanMessage(poMcanMsg);
   eAvailable_Setting_Arabic.bUpdateMcanMessage(poMcanMsg);
   eAvailable_Setting_Thai.bUpdateMcanMessage(poMcanMsg);
   eAvailable_Setting_UK_English.bUpdateMcanMessage(poMcanMsg);
   eAvailable_Setting_French.bUpdateMcanMessage(poMcanMsg);
   eAvailable_Setting_Spanish.bUpdateMcanMessage(poMcanMsg);
   eAvailable_Setting_German.bUpdateMcanMessage(poMcanMsg);
   eAvailable_Setting_Italian.bUpdateMcanMessage(poMcanMsg);
   eAvailable_Setting_Portuguese_for_Portugal.bUpdateMcanMessage(poMcanMsg);
   eAvailable_Setting_Portuguese_for_Brazil.bUpdateMcanMessage(poMcanMsg);
   eAvailable_Setting_Dutch.bUpdateMcanMessage(poMcanMsg);
   eAvailable_Setting_Turkish.bUpdateMcanMessage(poMcanMsg);
   eAvailable_Setting_Russian.bUpdateMcanMessage(poMcanMsg);
   aAvailable_Setting_Reserve.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__Language const& lhs, tcl_ITM_Meter_Audio__Language const& rhs){
   if (lhs.eDefault != rhs.eDefault) return FALSE;
   if (lhs.eCurrent != rhs.eCurrent) return FALSE;
   if (lhs.eAvailable_Setting_US_English != rhs.eAvailable_Setting_US_English) return FALSE;
   if (lhs.eAvailable_Setting_Canadian_French != rhs.eAvailable_Setting_Canadian_French) return FALSE;
   if (lhs.eAvailable_Setting_Mexican_Spanish != rhs.eAvailable_Setting_Mexican_Spanish) return FALSE;
   if (lhs.eAvailable_Setting_Japanese != rhs.eAvailable_Setting_Japanese) return FALSE;
   if (lhs.eAvailable_Setting_Chinese_Mandarin_ != rhs.eAvailable_Setting_Chinese_Mandarin_) return FALSE;
   if (lhs.eAvailable_Setting_Chinese_Traditional_ != rhs.eAvailable_Setting_Chinese_Traditional_) return FALSE;
   if (lhs.eAvailable_Setting_Korean != rhs.eAvailable_Setting_Korean) return FALSE;
   if (lhs.eAvailable_Setting_Arabic != rhs.eAvailable_Setting_Arabic) return FALSE;
   if (lhs.eAvailable_Setting_Thai != rhs.eAvailable_Setting_Thai) return FALSE;
   if (lhs.eAvailable_Setting_UK_English != rhs.eAvailable_Setting_UK_English) return FALSE;
   if (lhs.eAvailable_Setting_French != rhs.eAvailable_Setting_French) return FALSE;
   if (lhs.eAvailable_Setting_Spanish != rhs.eAvailable_Setting_Spanish) return FALSE;
   if (lhs.eAvailable_Setting_German != rhs.eAvailable_Setting_German) return FALSE;
   if (lhs.eAvailable_Setting_Italian != rhs.eAvailable_Setting_Italian) return FALSE;
   if (lhs.eAvailable_Setting_Portuguese_for_Portugal != rhs.eAvailable_Setting_Portuguese_for_Portugal) return FALSE;
   if (lhs.eAvailable_Setting_Portuguese_for_Brazil != rhs.eAvailable_Setting_Portuguese_for_Brazil) return FALSE;
   if (lhs.eAvailable_Setting_Dutch != rhs.eAvailable_Setting_Dutch) return FALSE;
   if (lhs.eAvailable_Setting_Turkish != rhs.eAvailable_Setting_Turkish) return FALSE;
   if (lhs.eAvailable_Setting_Russian != rhs.eAvailable_Setting_Russian) return FALSE;
   if (lhs.aAvailable_Setting_Reserve != rhs.aAvailable_Setting_Reserve) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__Language const& lhs, tcl_ITM_Meter_Audio__Language const& rhs){
    if (
         (lhs.eDefault == rhs.eDefault)
      && (lhs.eCurrent == rhs.eCurrent)
      && (lhs.eAvailable_Setting_US_English == rhs.eAvailable_Setting_US_English)
      && (lhs.eAvailable_Setting_Canadian_French == rhs.eAvailable_Setting_Canadian_French)
      && (lhs.eAvailable_Setting_Mexican_Spanish == rhs.eAvailable_Setting_Mexican_Spanish)
      && (lhs.eAvailable_Setting_Japanese == rhs.eAvailable_Setting_Japanese)
      && (lhs.eAvailable_Setting_Chinese_Mandarin_ == rhs.eAvailable_Setting_Chinese_Mandarin_)
      && (lhs.eAvailable_Setting_Chinese_Traditional_ == rhs.eAvailable_Setting_Chinese_Traditional_)
      && (lhs.eAvailable_Setting_Korean == rhs.eAvailable_Setting_Korean)
      && (lhs.eAvailable_Setting_Arabic == rhs.eAvailable_Setting_Arabic)
      && (lhs.eAvailable_Setting_Thai == rhs.eAvailable_Setting_Thai)
      && (lhs.eAvailable_Setting_UK_English == rhs.eAvailable_Setting_UK_English)
      && (lhs.eAvailable_Setting_French == rhs.eAvailable_Setting_French)
      && (lhs.eAvailable_Setting_Spanish == rhs.eAvailable_Setting_Spanish)
      && (lhs.eAvailable_Setting_German == rhs.eAvailable_Setting_German)
      && (lhs.eAvailable_Setting_Italian == rhs.eAvailable_Setting_Italian)
      && (lhs.eAvailable_Setting_Portuguese_for_Portugal == rhs.eAvailable_Setting_Portuguese_for_Portugal)
      && (lhs.eAvailable_Setting_Portuguese_for_Brazil == rhs.eAvailable_Setting_Portuguese_for_Brazil)
      && (lhs.eAvailable_Setting_Dutch == rhs.eAvailable_Setting_Dutch)
      && (lhs.eAvailable_Setting_Turkish == rhs.eAvailable_Setting_Turkish)
      && (lhs.eAvailable_Setting_Russian == rhs.eAvailable_Setting_Russian)
      && (lhs.aAvailable_Setting_Reserve == rhs.aAvailable_Setting_Reserve)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__Fuel_Consumption::tcl_ITM_Meter_Audio__Fuel_Consumption() : 
   eDefault((tcl_ITM_Meter_Audio__e32_Unit_Fuel_Consumption_List::tenType)0x01, 0x08),
   eCurrent((tcl_ITM_Meter_Audio__e32_Unit_Fuel_Consumption_List::tenType)0x01, 0x08),
   eAvailable_Setting_km_l((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   eAvailable_Setting_l_100km((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   eAvailable_Setting_MPG_US_((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   eAvailable_Setting_MPG_UK_((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   eAvailable_Setting_km_kwh((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   eAvailable_Setting_kwh_100km((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   eAvailable_Setting_miles_kwh((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   eAvailable_Setting_kwh_mile((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01)
{
}

tBool tcl_ITM_Meter_Audio__Fuel_Consumption::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eDefault.bUpdateData(poMcanMsg);
   if (bRet) bRet = eCurrent.bUpdateData(poMcanMsg);
   if (bRet) bRet = eAvailable_Setting_km_l.bUpdateData(poMcanMsg);
   if (bRet) bRet = eAvailable_Setting_l_100km.bUpdateData(poMcanMsg);
   if (bRet) bRet = eAvailable_Setting_MPG_US_.bUpdateData(poMcanMsg);
   if (bRet) bRet = eAvailable_Setting_MPG_UK_.bUpdateData(poMcanMsg);
   if (bRet) bRet = eAvailable_Setting_km_kwh.bUpdateData(poMcanMsg);
   if (bRet) bRet = eAvailable_Setting_kwh_100km.bUpdateData(poMcanMsg);
   if (bRet) bRet = eAvailable_Setting_miles_kwh.bUpdateData(poMcanMsg);
   if (bRet) bRet = eAvailable_Setting_kwh_mile.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__Fuel_Consumption::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eDefault.bUpdateMcanMessage(poMcanMsg);
   eCurrent.bUpdateMcanMessage(poMcanMsg);
   eAvailable_Setting_km_l.bUpdateMcanMessage(poMcanMsg);
   eAvailable_Setting_l_100km.bUpdateMcanMessage(poMcanMsg);
   eAvailable_Setting_MPG_US_.bUpdateMcanMessage(poMcanMsg);
   eAvailable_Setting_MPG_UK_.bUpdateMcanMessage(poMcanMsg);
   eAvailable_Setting_km_kwh.bUpdateMcanMessage(poMcanMsg);
   eAvailable_Setting_kwh_100km.bUpdateMcanMessage(poMcanMsg);
   eAvailable_Setting_miles_kwh.bUpdateMcanMessage(poMcanMsg);
   eAvailable_Setting_kwh_mile.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__Fuel_Consumption const& lhs, tcl_ITM_Meter_Audio__Fuel_Consumption const& rhs){
   if (lhs.eDefault != rhs.eDefault) return FALSE;
   if (lhs.eCurrent != rhs.eCurrent) return FALSE;
   if (lhs.eAvailable_Setting_km_l != rhs.eAvailable_Setting_km_l) return FALSE;
   if (lhs.eAvailable_Setting_l_100km != rhs.eAvailable_Setting_l_100km) return FALSE;
   if (lhs.eAvailable_Setting_MPG_US_ != rhs.eAvailable_Setting_MPG_US_) return FALSE;
   if (lhs.eAvailable_Setting_MPG_UK_ != rhs.eAvailable_Setting_MPG_UK_) return FALSE;
   if (lhs.eAvailable_Setting_km_kwh != rhs.eAvailable_Setting_km_kwh) return FALSE;
   if (lhs.eAvailable_Setting_kwh_100km != rhs.eAvailable_Setting_kwh_100km) return FALSE;
   if (lhs.eAvailable_Setting_miles_kwh != rhs.eAvailable_Setting_miles_kwh) return FALSE;
   if (lhs.eAvailable_Setting_kwh_mile != rhs.eAvailable_Setting_kwh_mile) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__Fuel_Consumption const& lhs, tcl_ITM_Meter_Audio__Fuel_Consumption const& rhs){
    if (
         (lhs.eDefault == rhs.eDefault)
      && (lhs.eCurrent == rhs.eCurrent)
      && (lhs.eAvailable_Setting_km_l == rhs.eAvailable_Setting_km_l)
      && (lhs.eAvailable_Setting_l_100km == rhs.eAvailable_Setting_l_100km)
      && (lhs.eAvailable_Setting_MPG_US_ == rhs.eAvailable_Setting_MPG_US_)
      && (lhs.eAvailable_Setting_MPG_UK_ == rhs.eAvailable_Setting_MPG_UK_)
      && (lhs.eAvailable_Setting_km_kwh == rhs.eAvailable_Setting_km_kwh)
      && (lhs.eAvailable_Setting_kwh_100km == rhs.eAvailable_Setting_kwh_100km)
      && (lhs.eAvailable_Setting_miles_kwh == rhs.eAvailable_Setting_miles_kwh)
      && (lhs.eAvailable_Setting_kwh_mile == rhs.eAvailable_Setting_kwh_mile)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__Temperature::tcl_ITM_Meter_Audio__Temperature() : 
   eDefault((tcl_ITM_Meter_Audio__e32_Unit_Temperature_List::tenType)0x01, 0x08),
   eCurrent((tcl_ITM_Meter_Audio__e32_Unit_Temperature_List::tenType)0x01, 0x08),
   eAvailable_Setting_deg_C((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   eAvailable_Setting_deg_F((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   aAvailable_Setting_reserve(NULL, 0x06)
{
}

tBool tcl_ITM_Meter_Audio__Temperature::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eDefault.bUpdateData(poMcanMsg);
   if (bRet) bRet = eCurrent.bUpdateData(poMcanMsg);
   if (bRet) bRet = eAvailable_Setting_deg_C.bUpdateData(poMcanMsg);
   if (bRet) bRet = eAvailable_Setting_deg_F.bUpdateData(poMcanMsg);
   if (bRet) bRet = aAvailable_Setting_reserve.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__Temperature::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eDefault.bUpdateMcanMessage(poMcanMsg);
   eCurrent.bUpdateMcanMessage(poMcanMsg);
   eAvailable_Setting_deg_C.bUpdateMcanMessage(poMcanMsg);
   eAvailable_Setting_deg_F.bUpdateMcanMessage(poMcanMsg);
   aAvailable_Setting_reserve.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__Temperature const& lhs, tcl_ITM_Meter_Audio__Temperature const& rhs){
   if (lhs.eDefault != rhs.eDefault) return FALSE;
   if (lhs.eCurrent != rhs.eCurrent) return FALSE;
   if (lhs.eAvailable_Setting_deg_C != rhs.eAvailable_Setting_deg_C) return FALSE;
   if (lhs.eAvailable_Setting_deg_F != rhs.eAvailable_Setting_deg_F) return FALSE;
   if (lhs.aAvailable_Setting_reserve != rhs.aAvailable_Setting_reserve) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__Temperature const& lhs, tcl_ITM_Meter_Audio__Temperature const& rhs){
    if (
         (lhs.eDefault == rhs.eDefault)
      && (lhs.eCurrent == rhs.eCurrent)
      && (lhs.eAvailable_Setting_deg_C == rhs.eAvailable_Setting_deg_C)
      && (lhs.eAvailable_Setting_deg_F == rhs.eAvailable_Setting_deg_F)
      && (lhs.aAvailable_Setting_reserve == rhs.aAvailable_Setting_reserve)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__Pressure::tcl_ITM_Meter_Audio__Pressure() : 
   eDefault((tcl_ITM_Meter_Audio__e32_Unit_Pressure_List::tenType)0x00, 0x08),
   eCurrent((tcl_ITM_Meter_Audio__e32_Unit_Pressure_List::tenType)0x00, 0x08),
   eAvailable_Setting_kPa((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   eAvailable_Setting_PSI((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   eAvailable_Setting_bar((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   eAvailable_Setting_kgf_cm2((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   aAvailable_Setting_reserve(NULL, 0x04)
{
}

tBool tcl_ITM_Meter_Audio__Pressure::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eDefault.bUpdateData(poMcanMsg);
   if (bRet) bRet = eCurrent.bUpdateData(poMcanMsg);
   if (bRet) bRet = eAvailable_Setting_kPa.bUpdateData(poMcanMsg);
   if (bRet) bRet = eAvailable_Setting_PSI.bUpdateData(poMcanMsg);
   if (bRet) bRet = eAvailable_Setting_bar.bUpdateData(poMcanMsg);
   if (bRet) bRet = eAvailable_Setting_kgf_cm2.bUpdateData(poMcanMsg);
   if (bRet) bRet = aAvailable_Setting_reserve.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__Pressure::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eDefault.bUpdateMcanMessage(poMcanMsg);
   eCurrent.bUpdateMcanMessage(poMcanMsg);
   eAvailable_Setting_kPa.bUpdateMcanMessage(poMcanMsg);
   eAvailable_Setting_PSI.bUpdateMcanMessage(poMcanMsg);
   eAvailable_Setting_bar.bUpdateMcanMessage(poMcanMsg);
   eAvailable_Setting_kgf_cm2.bUpdateMcanMessage(poMcanMsg);
   aAvailable_Setting_reserve.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__Pressure const& lhs, tcl_ITM_Meter_Audio__Pressure const& rhs){
   if (lhs.eDefault != rhs.eDefault) return FALSE;
   if (lhs.eCurrent != rhs.eCurrent) return FALSE;
   if (lhs.eAvailable_Setting_kPa != rhs.eAvailable_Setting_kPa) return FALSE;
   if (lhs.eAvailable_Setting_PSI != rhs.eAvailable_Setting_PSI) return FALSE;
   if (lhs.eAvailable_Setting_bar != rhs.eAvailable_Setting_bar) return FALSE;
   if (lhs.eAvailable_Setting_kgf_cm2 != rhs.eAvailable_Setting_kgf_cm2) return FALSE;
   if (lhs.aAvailable_Setting_reserve != rhs.aAvailable_Setting_reserve) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__Pressure const& lhs, tcl_ITM_Meter_Audio__Pressure const& rhs){
    if (
         (lhs.eDefault == rhs.eDefault)
      && (lhs.eCurrent == rhs.eCurrent)
      && (lhs.eAvailable_Setting_kPa == rhs.eAvailable_Setting_kPa)
      && (lhs.eAvailable_Setting_PSI == rhs.eAvailable_Setting_PSI)
      && (lhs.eAvailable_Setting_bar == rhs.eAvailable_Setting_bar)
      && (lhs.eAvailable_Setting_kgf_cm2 == rhs.eAvailable_Setting_kgf_cm2)
      && (lhs.aAvailable_Setting_reserve == rhs.aAvailable_Setting_reserve)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__Artist::tcl_ITM_Meter_Audio__Artist() : 
   eUpdate((tcl_ITM_Meter_Audio__e32_Update_List::tenType)0x00, 0x08),
   eLabel((tcl_ITM_Meter_Audio__e32_Disc_Artist_Label_List::tenType)0x00, 0x08),
   eText_Info_Character_Set((tcl_ITM_Meter_Audio__e32_Character_Set_List::tenType)0x00, 0x08),
   uiText_Info_Length(0x01, 0x08),
   vstrText_Info_Text_Body(NULL, 0)
{
}

tBool tcl_ITM_Meter_Audio__Artist::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eUpdate.bUpdateData(poMcanMsg);
   if (bRet) bRet = eLabel.bUpdateData(poMcanMsg);
   if (bRet) bRet = eText_Info_Character_Set.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiText_Info_Length.bUpdateData(poMcanMsg);

   if (bRet) bRet = vstrText_Info_Text_Body.bUpdateLength(8*uiText_Info_Length.u32GetData());
   if (bRet) bRet = vstrText_Info_Text_Body.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__Artist::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eUpdate.bUpdateMcanMessage(poMcanMsg);
   eLabel.bUpdateMcanMessage(poMcanMsg);
   eText_Info_Character_Set.bUpdateMcanMessage(poMcanMsg);
   uiText_Info_Length.bUpdateMcanMessage(poMcanMsg);
   vstrText_Info_Text_Body.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__Artist const& lhs, tcl_ITM_Meter_Audio__Artist const& rhs){
   if (lhs.eUpdate != rhs.eUpdate) return FALSE;
   if (lhs.eLabel != rhs.eLabel) return FALSE;
   if (lhs.eText_Info_Character_Set != rhs.eText_Info_Character_Set) return FALSE;
   if (lhs.uiText_Info_Length != rhs.uiText_Info_Length) return FALSE;
   if (lhs.vstrText_Info_Text_Body != rhs.vstrText_Info_Text_Body) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__Artist const& lhs, tcl_ITM_Meter_Audio__Artist const& rhs){
    if (
         (lhs.eUpdate == rhs.eUpdate)
      && (lhs.eLabel == rhs.eLabel)
      && (lhs.eText_Info_Character_Set == rhs.eText_Info_Character_Set)
      && (lhs.uiText_Info_Length == rhs.uiText_Info_Length)
      && (lhs.vstrText_Info_Text_Body == rhs.vstrText_Info_Text_Body)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__Invalid_Parameter::tcl_ITM_Meter_Audio__Invalid_Parameter() : 
   eInvalid_Parameter((tcl_ITM_Meter_Audio__e32_Invalid_Parameter::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_Meter_Audio__Invalid_Parameter::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eInvalid_Parameter.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__Invalid_Parameter::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eInvalid_Parameter.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__Invalid_Parameter const& lhs, tcl_ITM_Meter_Audio__Invalid_Parameter const& rhs){
   if (lhs.eInvalid_Parameter != rhs.eInvalid_Parameter) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__Invalid_Parameter const& lhs, tcl_ITM_Meter_Audio__Invalid_Parameter const& rhs){
    if (
         (lhs.eInvalid_Parameter == rhs.eInvalid_Parameter)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__Source_Icon::tcl_ITM_Meter_Audio__Source_Icon() : 
   eSource_Icon((tcl_ITM_Meter_Audio__e32_Source_Icon_List::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_Meter_Audio__Source_Icon::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eSource_Icon.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__Source_Icon::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eSource_Icon.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__Source_Icon const& lhs, tcl_ITM_Meter_Audio__Source_Icon const& rhs){
   if (lhs.eSource_Icon != rhs.eSource_Icon) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__Source_Icon const& lhs, tcl_ITM_Meter_Audio__Source_Icon const& rhs){
    if (
         (lhs.eSource_Icon == rhs.eSource_Icon)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__Radio_Broadcast::tcl_ITM_Meter_Audio__Radio_Broadcast() : 
   eUpdate((tcl_ITM_Meter_Audio__e32_Update_List::tenType)0x00, 0x08),
   eLabel((tcl_ITM_Meter_Audio__e32_Radio_Label_List::tenType)0x00, 0x08),
   uiPreset_Ch(0x00, 0x08),
   eFrequency_val1000_digit((tcl_ITM_Meter_Audio__e32_val0_9_List::tenType)0x0F, 0x04),
   eFrequency_val100_digit((tcl_ITM_Meter_Audio__e32_val0_9_List::tenType)0x0F, 0x04),
   eFrequency_val10_digit((tcl_ITM_Meter_Audio__e32_val0_9_List::tenType)0x0F, 0x04),
   eFrequency_val1_digit((tcl_ITM_Meter_Audio__e32_val0_9_List::tenType)0x0F, 0x04),
   eFrequency_decimal_point((tcl_ITM_Meter_Audio__e32_Enable::tenType)0x00, 0x04),
   eFrequency_val01_digit((tcl_ITM_Meter_Audio__e32_val0_9_List::tenType)0x0F, 0x04),
   eFrequency_val001_digit((tcl_ITM_Meter_Audio__e32_val0_9_List::tenType)0x00, 0x04),
   aFrequency_Reserve(NULL, 0x04),
   eUnit((tcl_ITM_Meter_Audio__e32_Radio_Unit_List::tenType)0x00, 0x08),
   eText_Info_Character_Set((tcl_ITM_Meter_Audio__e32_Character_Set_List::tenType)0x00, 0x08),
   uiText_Info_Length(0x01, 0x08),
   vstrText_Info_Text_Body(NULL, 0)
{
}

tBool tcl_ITM_Meter_Audio__Radio_Broadcast::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eUpdate.bUpdateData(poMcanMsg);
   if (bRet) bRet = eLabel.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiPreset_Ch.bUpdateData(poMcanMsg);
   if (bRet) bRet = eFrequency_val1000_digit.bUpdateData(poMcanMsg);
   if (bRet) bRet = eFrequency_val100_digit.bUpdateData(poMcanMsg);
   if (bRet) bRet = eFrequency_val10_digit.bUpdateData(poMcanMsg);
   if (bRet) bRet = eFrequency_val1_digit.bUpdateData(poMcanMsg);
   if (bRet) bRet = eFrequency_decimal_point.bUpdateData(poMcanMsg);
   if (bRet) bRet = eFrequency_val01_digit.bUpdateData(poMcanMsg);
   if (bRet) bRet = eFrequency_val001_digit.bUpdateData(poMcanMsg);
   if (bRet) bRet = aFrequency_Reserve.bUpdateData(poMcanMsg);
   if (bRet) bRet = eUnit.bUpdateData(poMcanMsg);
   if (bRet) bRet = eText_Info_Character_Set.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiText_Info_Length.bUpdateData(poMcanMsg);

   if (bRet) bRet = vstrText_Info_Text_Body.bUpdateLength(8*uiText_Info_Length.u32GetData());
   if (bRet) bRet = vstrText_Info_Text_Body.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__Radio_Broadcast::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eUpdate.bUpdateMcanMessage(poMcanMsg);
   eLabel.bUpdateMcanMessage(poMcanMsg);
   uiPreset_Ch.bUpdateMcanMessage(poMcanMsg);
   eFrequency_val1000_digit.bUpdateMcanMessage(poMcanMsg);
   eFrequency_val100_digit.bUpdateMcanMessage(poMcanMsg);
   eFrequency_val10_digit.bUpdateMcanMessage(poMcanMsg);
   eFrequency_val1_digit.bUpdateMcanMessage(poMcanMsg);
   eFrequency_decimal_point.bUpdateMcanMessage(poMcanMsg);
   eFrequency_val01_digit.bUpdateMcanMessage(poMcanMsg);
   eFrequency_val001_digit.bUpdateMcanMessage(poMcanMsg);
   aFrequency_Reserve.bUpdateMcanMessage(poMcanMsg);
   eUnit.bUpdateMcanMessage(poMcanMsg);
   eText_Info_Character_Set.bUpdateMcanMessage(poMcanMsg);
   uiText_Info_Length.bUpdateMcanMessage(poMcanMsg);
   vstrText_Info_Text_Body.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__Radio_Broadcast const& lhs, tcl_ITM_Meter_Audio__Radio_Broadcast const& rhs){
   if (lhs.eUpdate != rhs.eUpdate) return FALSE;
   if (lhs.eLabel != rhs.eLabel) return FALSE;
   if (lhs.uiPreset_Ch != rhs.uiPreset_Ch) return FALSE;
   if (lhs.eFrequency_val1000_digit != rhs.eFrequency_val1000_digit) return FALSE;
   if (lhs.eFrequency_val100_digit != rhs.eFrequency_val100_digit) return FALSE;
   if (lhs.eFrequency_val10_digit != rhs.eFrequency_val10_digit) return FALSE;
   if (lhs.eFrequency_val1_digit != rhs.eFrequency_val1_digit) return FALSE;
   if (lhs.eFrequency_decimal_point != rhs.eFrequency_decimal_point) return FALSE;
   if (lhs.eFrequency_val01_digit != rhs.eFrequency_val01_digit) return FALSE;
   if (lhs.eFrequency_val001_digit != rhs.eFrequency_val001_digit) return FALSE;
   if (lhs.aFrequency_Reserve != rhs.aFrequency_Reserve) return FALSE;
   if (lhs.eUnit != rhs.eUnit) return FALSE;
   if (lhs.eText_Info_Character_Set != rhs.eText_Info_Character_Set) return FALSE;
   if (lhs.uiText_Info_Length != rhs.uiText_Info_Length) return FALSE;
   if (lhs.vstrText_Info_Text_Body != rhs.vstrText_Info_Text_Body) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__Radio_Broadcast const& lhs, tcl_ITM_Meter_Audio__Radio_Broadcast const& rhs){
    if (
         (lhs.eUpdate == rhs.eUpdate)
      && (lhs.eLabel == rhs.eLabel)
      && (lhs.uiPreset_Ch == rhs.uiPreset_Ch)
      && (lhs.eFrequency_val1000_digit == rhs.eFrequency_val1000_digit)
      && (lhs.eFrequency_val100_digit == rhs.eFrequency_val100_digit)
      && (lhs.eFrequency_val10_digit == rhs.eFrequency_val10_digit)
      && (lhs.eFrequency_val1_digit == rhs.eFrequency_val1_digit)
      && (lhs.eFrequency_decimal_point == rhs.eFrequency_decimal_point)
      && (lhs.eFrequency_val01_digit == rhs.eFrequency_val01_digit)
      && (lhs.eFrequency_val001_digit == rhs.eFrequency_val001_digit)
      && (lhs.aFrequency_Reserve == rhs.aFrequency_Reserve)
      && (lhs.eUnit == rhs.eUnit)
      && (lhs.eText_Info_Character_Set == rhs.eText_Info_Character_Set)
      && (lhs.uiText_Info_Length == rhs.uiText_Info_Length)
      && (lhs.vstrText_Info_Text_Body == rhs.vstrText_Info_Text_Body)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__Radio_Source::tcl_ITM_Meter_Audio__Radio_Source() : 
   eUpdate((tcl_ITM_Meter_Audio__e32_Update_List::tenType)0x00, 0x08),
   eName((tcl_ITM_Meter_Audio__e32_Radio_Source_List::tenType)0x01, 0x08)
{
}

tBool tcl_ITM_Meter_Audio__Radio_Source::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eUpdate.bUpdateData(poMcanMsg);
   if (bRet) bRet = eName.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__Radio_Source::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eUpdate.bUpdateMcanMessage(poMcanMsg);
   eName.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__Radio_Source const& lhs, tcl_ITM_Meter_Audio__Radio_Source const& rhs){
   if (lhs.eUpdate != rhs.eUpdate) return FALSE;
   if (lhs.eName != rhs.eName) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__Radio_Source const& lhs, tcl_ITM_Meter_Audio__Radio_Source const& rhs){
    if (
         (lhs.eUpdate == rhs.eUpdate)
      && (lhs.eName == rhs.eName)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__TV_Source::tcl_ITM_Meter_Audio__TV_Source() : 
   eUpdate((tcl_ITM_Meter_Audio__e32_Update_List::tenType)0x00, 0x08),
   eName((tcl_ITM_Meter_Audio__e32_TV_Source_List::tenType)0x01, 0x08)
{
}

tBool tcl_ITM_Meter_Audio__TV_Source::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eUpdate.bUpdateData(poMcanMsg);
   if (bRet) bRet = eName.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__TV_Source::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eUpdate.bUpdateMcanMessage(poMcanMsg);
   eName.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__TV_Source const& lhs, tcl_ITM_Meter_Audio__TV_Source const& rhs){
   if (lhs.eUpdate != rhs.eUpdate) return FALSE;
   if (lhs.eName != rhs.eName) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__TV_Source const& lhs, tcl_ITM_Meter_Audio__TV_Source const& rhs){
    if (
         (lhs.eUpdate == rhs.eUpdate)
      && (lhs.eName == rhs.eName)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__TV_Broadcast::tcl_ITM_Meter_Audio__TV_Broadcast() : 
   eUpdate((tcl_ITM_Meter_Audio__e32_Update_List::tenType)0x00, 0x08),
   eLabel((tcl_ITM_Meter_Audio__e32_DTV_Label_List::tenType)0x00, 0x08),
   uiPreset_Ch(0x00, 0x08),
   eCh_val100_digit((tcl_ITM_Meter_Audio__e32_val0_9_List::tenType)0x0F, 0x04),
   eCh_val10_digit((tcl_ITM_Meter_Audio__e32_val0_9_List::tenType)0x0F, 0x04),
   eCh_val1_digit((tcl_ITM_Meter_Audio__e32_val0_9_List::tenType)0x0F, 0x04),
   eCh_hayphen((tcl_ITM_Meter_Audio__e32_Enable::tenType)0x00, 0x04),
   eCh_branch_number((tcl_ITM_Meter_Audio__e32_val0_9_List::tenType)0x0F, 0x04),
   aCh_Reserve(NULL, 0x04),
   eText_Info_Character_Set((tcl_ITM_Meter_Audio__e32_Character_Set_List::tenType)0x00, 0x08),
   uiText_Info_Length(0x01, 0x08),
   vstrText_Info_Text_Body(NULL, 0)
{
}

tBool tcl_ITM_Meter_Audio__TV_Broadcast::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eUpdate.bUpdateData(poMcanMsg);
   if (bRet) bRet = eLabel.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiPreset_Ch.bUpdateData(poMcanMsg);
   if (bRet) bRet = eCh_val100_digit.bUpdateData(poMcanMsg);
   if (bRet) bRet = eCh_val10_digit.bUpdateData(poMcanMsg);
   if (bRet) bRet = eCh_val1_digit.bUpdateData(poMcanMsg);
   if (bRet) bRet = eCh_hayphen.bUpdateData(poMcanMsg);
   if (bRet) bRet = eCh_branch_number.bUpdateData(poMcanMsg);
   if (bRet) bRet = aCh_Reserve.bUpdateData(poMcanMsg);
   if (bRet) bRet = eText_Info_Character_Set.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiText_Info_Length.bUpdateData(poMcanMsg);

   if (bRet) bRet = vstrText_Info_Text_Body.bUpdateLength(8*uiText_Info_Length.u32GetData());
   if (bRet) bRet = vstrText_Info_Text_Body.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__TV_Broadcast::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eUpdate.bUpdateMcanMessage(poMcanMsg);
   eLabel.bUpdateMcanMessage(poMcanMsg);
   uiPreset_Ch.bUpdateMcanMessage(poMcanMsg);
   eCh_val100_digit.bUpdateMcanMessage(poMcanMsg);
   eCh_val10_digit.bUpdateMcanMessage(poMcanMsg);
   eCh_val1_digit.bUpdateMcanMessage(poMcanMsg);
   eCh_hayphen.bUpdateMcanMessage(poMcanMsg);
   eCh_branch_number.bUpdateMcanMessage(poMcanMsg);
   aCh_Reserve.bUpdateMcanMessage(poMcanMsg);
   eText_Info_Character_Set.bUpdateMcanMessage(poMcanMsg);
   uiText_Info_Length.bUpdateMcanMessage(poMcanMsg);
   vstrText_Info_Text_Body.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__TV_Broadcast const& lhs, tcl_ITM_Meter_Audio__TV_Broadcast const& rhs){
   if (lhs.eUpdate != rhs.eUpdate) return FALSE;
   if (lhs.eLabel != rhs.eLabel) return FALSE;
   if (lhs.uiPreset_Ch != rhs.uiPreset_Ch) return FALSE;
   if (lhs.eCh_val100_digit != rhs.eCh_val100_digit) return FALSE;
   if (lhs.eCh_val10_digit != rhs.eCh_val10_digit) return FALSE;
   if (lhs.eCh_val1_digit != rhs.eCh_val1_digit) return FALSE;
   if (lhs.eCh_hayphen != rhs.eCh_hayphen) return FALSE;
   if (lhs.eCh_branch_number != rhs.eCh_branch_number) return FALSE;
   if (lhs.aCh_Reserve != rhs.aCh_Reserve) return FALSE;
   if (lhs.eText_Info_Character_Set != rhs.eText_Info_Character_Set) return FALSE;
   if (lhs.uiText_Info_Length != rhs.uiText_Info_Length) return FALSE;
   if (lhs.vstrText_Info_Text_Body != rhs.vstrText_Info_Text_Body) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__TV_Broadcast const& lhs, tcl_ITM_Meter_Audio__TV_Broadcast const& rhs){
    if (
         (lhs.eUpdate == rhs.eUpdate)
      && (lhs.eLabel == rhs.eLabel)
      && (lhs.uiPreset_Ch == rhs.uiPreset_Ch)
      && (lhs.eCh_val100_digit == rhs.eCh_val100_digit)
      && (lhs.eCh_val10_digit == rhs.eCh_val10_digit)
      && (lhs.eCh_val1_digit == rhs.eCh_val1_digit)
      && (lhs.eCh_hayphen == rhs.eCh_hayphen)
      && (lhs.eCh_branch_number == rhs.eCh_branch_number)
      && (lhs.aCh_Reserve == rhs.aCh_Reserve)
      && (lhs.eText_Info_Character_Set == rhs.eText_Info_Character_Set)
      && (lhs.uiText_Info_Length == rhs.uiText_Info_Length)
      && (lhs.vstrText_Info_Text_Body == rhs.vstrText_Info_Text_Body)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__AUX_Source::tcl_ITM_Meter_Audio__AUX_Source() : 
   eUpdate((tcl_ITM_Meter_Audio__e32_Update_List::tenType)0x00, 0x08),
   eName((tcl_ITM_Meter_Audio__e32_AUX_Source_List::tenType)0x01, 0x08)
{
}

tBool tcl_ITM_Meter_Audio__AUX_Source::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eUpdate.bUpdateData(poMcanMsg);
   if (bRet) bRet = eName.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__AUX_Source::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eUpdate.bUpdateMcanMessage(poMcanMsg);
   eName.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__AUX_Source const& lhs, tcl_ITM_Meter_Audio__AUX_Source const& rhs){
   if (lhs.eUpdate != rhs.eUpdate) return FALSE;
   if (lhs.eName != rhs.eName) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__AUX_Source const& lhs, tcl_ITM_Meter_Audio__AUX_Source const& rhs){
    if (
         (lhs.eUpdate == rhs.eUpdate)
      && (lhs.eName == rhs.eName)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__Radio_Category::tcl_ITM_Meter_Audio__Radio_Category() : 
   eUpdate((tcl_ITM_Meter_Audio__e32_Update_List::tenType)0x00, 0x08),
   eCategory((tcl_ITM_Meter_Audio__e32_Radio_Category_List::tenType)0x00, 0x08),
   eText_Info_Character_Set((tcl_ITM_Meter_Audio__e32_Character_Set_List::tenType)0x01, 0x08),
   uiText_Info_Length(0x01, 0x08),
   vstrText_Info_Text_Body(NULL, 0)
{
}

tBool tcl_ITM_Meter_Audio__Radio_Category::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eUpdate.bUpdateData(poMcanMsg);
   if (bRet) bRet = eCategory.bUpdateData(poMcanMsg);
   if (bRet) bRet = eText_Info_Character_Set.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiText_Info_Length.bUpdateData(poMcanMsg);

   if (bRet) bRet = vstrText_Info_Text_Body.bUpdateLength(8*uiText_Info_Length.u32GetData());
   if (bRet) bRet = vstrText_Info_Text_Body.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__Radio_Category::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eUpdate.bUpdateMcanMessage(poMcanMsg);
   eCategory.bUpdateMcanMessage(poMcanMsg);
   eText_Info_Character_Set.bUpdateMcanMessage(poMcanMsg);
   uiText_Info_Length.bUpdateMcanMessage(poMcanMsg);
   vstrText_Info_Text_Body.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__Radio_Category const& lhs, tcl_ITM_Meter_Audio__Radio_Category const& rhs){
   if (lhs.eUpdate != rhs.eUpdate) return FALSE;
   if (lhs.eCategory != rhs.eCategory) return FALSE;
   if (lhs.eText_Info_Character_Set != rhs.eText_Info_Character_Set) return FALSE;
   if (lhs.uiText_Info_Length != rhs.uiText_Info_Length) return FALSE;
   if (lhs.vstrText_Info_Text_Body != rhs.vstrText_Info_Text_Body) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__Radio_Category const& lhs, tcl_ITM_Meter_Audio__Radio_Category const& rhs){
    if (
         (lhs.eUpdate == rhs.eUpdate)
      && (lhs.eCategory == rhs.eCategory)
      && (lhs.eText_Info_Character_Set == rhs.eText_Info_Character_Set)
      && (lhs.uiText_Info_Length == rhs.uiText_Info_Length)
      && (lhs.vstrText_Info_Text_Body == rhs.vstrText_Info_Text_Body)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__HF_Info::tcl_ITM_Meter_Audio__HF_Info() : 
   eHF_State((tcl_ITM_Meter_Audio__e32_HF_State_List::tenType)0x00, 0x08),
   eText_Info_Character_Set((tcl_ITM_Meter_Audio__e32_Character_Set_List::tenType)0x00, 0x08),
   uiText_Info_Length(0x01, 0x08),
   vstrText_Info_Text_Body(NULL, 0)
{
}

tBool tcl_ITM_Meter_Audio__HF_Info::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eHF_State.bUpdateData(poMcanMsg);
   if (bRet) bRet = eText_Info_Character_Set.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiText_Info_Length.bUpdateData(poMcanMsg);

   if (bRet) bRet = vstrText_Info_Text_Body.bUpdateLength(8*uiText_Info_Length.u32GetData());
   if (bRet) bRet = vstrText_Info_Text_Body.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__HF_Info::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eHF_State.bUpdateMcanMessage(poMcanMsg);
   eText_Info_Character_Set.bUpdateMcanMessage(poMcanMsg);
   uiText_Info_Length.bUpdateMcanMessage(poMcanMsg);
   vstrText_Info_Text_Body.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__HF_Info const& lhs, tcl_ITM_Meter_Audio__HF_Info const& rhs){
   if (lhs.eHF_State != rhs.eHF_State) return FALSE;
   if (lhs.eText_Info_Character_Set != rhs.eText_Info_Character_Set) return FALSE;
   if (lhs.uiText_Info_Length != rhs.uiText_Info_Length) return FALSE;
   if (lhs.vstrText_Info_Text_Body != rhs.vstrText_Info_Text_Body) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__HF_Info const& lhs, tcl_ITM_Meter_Audio__HF_Info const& rhs){
    if (
         (lhs.eHF_State == rhs.eHF_State)
      && (lhs.eText_Info_Character_Set == rhs.eText_Info_Character_Set)
      && (lhs.uiText_Info_Length == rhs.uiText_Info_Length)
      && (lhs.vstrText_Info_Text_Body == rhs.vstrText_Info_Text_Body)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__SMS_Info::tcl_ITM_Meter_Audio__SMS_Info() : 
   eSMS_State((tcl_ITM_Meter_Audio__e32_SMS_State_List::tenType)0x00, 0x08),
   uiMsg_Number(0x00, 0x08),
   eText_Info_Character_Set((tcl_ITM_Meter_Audio__e32_Character_Set_List::tenType)0x00, 0x08),
   uiText_Info_Length(0x01, 0x08),
   vstrText_Info_Text_Body(NULL, 0)
{
}

tBool tcl_ITM_Meter_Audio__SMS_Info::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eSMS_State.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiMsg_Number.bUpdateData(poMcanMsg);
   if (bRet) bRet = eText_Info_Character_Set.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiText_Info_Length.bUpdateData(poMcanMsg);

   if (bRet) bRet = vstrText_Info_Text_Body.bUpdateLength(8*uiText_Info_Length.u32GetData());
   if (bRet) bRet = vstrText_Info_Text_Body.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__SMS_Info::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eSMS_State.bUpdateMcanMessage(poMcanMsg);
   uiMsg_Number.bUpdateMcanMessage(poMcanMsg);
   eText_Info_Character_Set.bUpdateMcanMessage(poMcanMsg);
   uiText_Info_Length.bUpdateMcanMessage(poMcanMsg);
   vstrText_Info_Text_Body.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__SMS_Info const& lhs, tcl_ITM_Meter_Audio__SMS_Info const& rhs){
   if (lhs.eSMS_State != rhs.eSMS_State) return FALSE;
   if (lhs.uiMsg_Number != rhs.uiMsg_Number) return FALSE;
   if (lhs.eText_Info_Character_Set != rhs.eText_Info_Character_Set) return FALSE;
   if (lhs.uiText_Info_Length != rhs.uiText_Info_Length) return FALSE;
   if (lhs.vstrText_Info_Text_Body != rhs.vstrText_Info_Text_Body) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__SMS_Info const& lhs, tcl_ITM_Meter_Audio__SMS_Info const& rhs){
    if (
         (lhs.eSMS_State == rhs.eSMS_State)
      && (lhs.uiMsg_Number == rhs.uiMsg_Number)
      && (lhs.eText_Info_Character_Set == rhs.eText_Info_Character_Set)
      && (lhs.uiText_Info_Length == rhs.uiText_Info_Length)
      && (lhs.vstrText_Info_Text_Body == rhs.vstrText_Info_Text_Body)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__SMS_Menu::tcl_ITM_Meter_Audio__SMS_Menu() : 
   eSW1_Label((tcl_ITM_Meter_Audio__e32_SMS_SW_Label_List1::tenType)0x00, 0x08),
   eSW1_Status((tcl_ITM_Meter_Audio__e32_SW_Status_List::tenType)0x00, 0x08),
   eSW2_Label((tcl_ITM_Meter_Audio__e32_SMS_SW_Label_List2::tenType)0x01, 0x08),
   eSW2_Status((tcl_ITM_Meter_Audio__e32_SW_Status_List::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_Meter_Audio__SMS_Menu::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eSW1_Label.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSW1_Status.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSW2_Label.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSW2_Status.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__SMS_Menu::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eSW1_Label.bUpdateMcanMessage(poMcanMsg);
   eSW1_Status.bUpdateMcanMessage(poMcanMsg);
   eSW2_Label.bUpdateMcanMessage(poMcanMsg);
   eSW2_Status.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__SMS_Menu const& lhs, tcl_ITM_Meter_Audio__SMS_Menu const& rhs){
   if (lhs.eSW1_Label != rhs.eSW1_Label) return FALSE;
   if (lhs.eSW1_Status != rhs.eSW1_Status) return FALSE;
   if (lhs.eSW2_Label != rhs.eSW2_Label) return FALSE;
   if (lhs.eSW2_Status != rhs.eSW2_Status) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__SMS_Menu const& lhs, tcl_ITM_Meter_Audio__SMS_Menu const& rhs){
    if (
         (lhs.eSW1_Label == rhs.eSW1_Label)
      && (lhs.eSW1_Status == rhs.eSW1_Status)
      && (lhs.eSW2_Label == rhs.eSW2_Label)
      && (lhs.eSW2_Status == rhs.eSW2_Status)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__Fuel_Consumption_set::tcl_ITM_Meter_Audio__Fuel_Consumption_set() : 
   eCurrent((tcl_ITM_Meter_Audio__e32_Unit_Fuel_Consumption_List2::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_Meter_Audio__Fuel_Consumption_set::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eCurrent.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__Fuel_Consumption_set::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eCurrent.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__Fuel_Consumption_set const& lhs, tcl_ITM_Meter_Audio__Fuel_Consumption_set const& rhs){
   if (lhs.eCurrent != rhs.eCurrent) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__Fuel_Consumption_set const& lhs, tcl_ITM_Meter_Audio__Fuel_Consumption_set const& rhs){
    if (
         (lhs.eCurrent == rhs.eCurrent)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__Pressure_set::tcl_ITM_Meter_Audio__Pressure_set() : 
   eCurrent((tcl_ITM_Meter_Audio__e32_Unit_Pressure_List2::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_Meter_Audio__Pressure_set::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eCurrent.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__Pressure_set::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eCurrent.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__Pressure_set const& lhs, tcl_ITM_Meter_Audio__Pressure_set const& rhs){
   if (lhs.eCurrent != rhs.eCurrent) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__Pressure_set const& lhs, tcl_ITM_Meter_Audio__Pressure_set const& rhs){
    if (
         (lhs.eCurrent == rhs.eCurrent)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__Temperature_set::tcl_ITM_Meter_Audio__Temperature_set() : 
   eCurrent((tcl_ITM_Meter_Audio__e32_Unit_Temperature_List2::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_Meter_Audio__Temperature_set::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eCurrent.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__Temperature_set::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eCurrent.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__Temperature_set const& lhs, tcl_ITM_Meter_Audio__Temperature_set const& rhs){
   if (lhs.eCurrent != rhs.eCurrent) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__Temperature_set const& lhs, tcl_ITM_Meter_Audio__Temperature_set const& rhs){
    if (
         (lhs.eCurrent == rhs.eCurrent)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__HF_Menu::tcl_ITM_Meter_Audio__HF_Menu() : 
   eSW1_Label((tcl_ITM_Meter_Audio__e32_HF_SW_Label_List1::tenType)0x01, 0x08),
   eSW1_Status((tcl_ITM_Meter_Audio__e32_SW_Status_List::tenType)0x00, 0x08),
   eSW2_Label((tcl_ITM_Meter_Audio__e32_HF_SW_Label_List2::tenType)0x01, 0x08),
   eSW2_Status((tcl_ITM_Meter_Audio__e32_SW_Status_List::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_Meter_Audio__HF_Menu::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eSW1_Label.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSW1_Status.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSW2_Label.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSW2_Status.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__HF_Menu::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eSW1_Label.bUpdateMcanMessage(poMcanMsg);
   eSW1_Status.bUpdateMcanMessage(poMcanMsg);
   eSW2_Label.bUpdateMcanMessage(poMcanMsg);
   eSW2_Status.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__HF_Menu const& lhs, tcl_ITM_Meter_Audio__HF_Menu const& rhs){
   if (lhs.eSW1_Label != rhs.eSW1_Label) return FALSE;
   if (lhs.eSW1_Status != rhs.eSW1_Status) return FALSE;
   if (lhs.eSW2_Label != rhs.eSW2_Label) return FALSE;
   if (lhs.eSW2_Status != rhs.eSW2_Status) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__HF_Menu const& lhs, tcl_ITM_Meter_Audio__HF_Menu const& rhs){
    if (
         (lhs.eSW1_Label == rhs.eSW1_Label)
      && (lhs.eSW1_Status == rhs.eSW1_Status)
      && (lhs.eSW2_Label == rhs.eSW2_Label)
      && (lhs.eSW2_Status == rhs.eSW2_Status)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__Disc_Source::tcl_ITM_Meter_Audio__Disc_Source() : 
   eUpdate((tcl_ITM_Meter_Audio__e32_Update_List::tenType)0x00, 0x08),
   eContents_Type((tcl_ITM_Meter_Audio__e32_Contents_Type_List::tenType)0x00, 0x01),
   eName((tcl_ITM_Meter_Audio__e32_Disc_Category_List::tenType)0x01, 0x07)
{
}

tBool tcl_ITM_Meter_Audio__Disc_Source::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eUpdate.bUpdateData(poMcanMsg);
   if (bRet) bRet = eContents_Type.bUpdateData(poMcanMsg);
   if (bRet) bRet = eName.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__Disc_Source::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eUpdate.bUpdateMcanMessage(poMcanMsg);
   eContents_Type.bUpdateMcanMessage(poMcanMsg);
   eName.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__Disc_Source const& lhs, tcl_ITM_Meter_Audio__Disc_Source const& rhs){
   if (lhs.eUpdate != rhs.eUpdate) return FALSE;
   if (lhs.eContents_Type != rhs.eContents_Type) return FALSE;
   if (lhs.eName != rhs.eName) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__Disc_Source const& lhs, tcl_ITM_Meter_Audio__Disc_Source const& rhs){
    if (
         (lhs.eUpdate == rhs.eUpdate)
      && (lhs.eContents_Type == rhs.eContents_Type)
      && (lhs.eName == rhs.eName)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__Distance_set::tcl_ITM_Meter_Audio__Distance_set() : 
   eCurrent((tcl_ITM_Meter_Audio__e32_Unit_Distance_List::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_Meter_Audio__Distance_set::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eCurrent.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__Distance_set::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eCurrent.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__Distance_set const& lhs, tcl_ITM_Meter_Audio__Distance_set const& rhs){
   if (lhs.eCurrent != rhs.eCurrent) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__Distance_set const& lhs, tcl_ITM_Meter_Audio__Distance_set const& rhs){
    if (
         (lhs.eCurrent == rhs.eCurrent)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__Available_Menu_Item::tcl_ITM_Meter_Audio__Available_Menu_Item() : 
   eMain_Menu_Selection((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   eCar_Symbol_Color((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   eECO_Setting((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   ePopup_Setting((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   eIllumination_Setting((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   eLanguage_Setting((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   eTPMS_Setting((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   eInit_Setting_Reset((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   eTJP_Setting((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   ePro_Pilot_Setting((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   aReserve(NULL, 0x16)
{
}

tBool tcl_ITM_Meter_Audio__Available_Menu_Item::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eMain_Menu_Selection.bUpdateData(poMcanMsg);
   if (bRet) bRet = eCar_Symbol_Color.bUpdateData(poMcanMsg);
   if (bRet) bRet = eECO_Setting.bUpdateData(poMcanMsg);
   if (bRet) bRet = ePopup_Setting.bUpdateData(poMcanMsg);
   if (bRet) bRet = eIllumination_Setting.bUpdateData(poMcanMsg);
   if (bRet) bRet = eLanguage_Setting.bUpdateData(poMcanMsg);
   if (bRet) bRet = eTPMS_Setting.bUpdateData(poMcanMsg);
   if (bRet) bRet = eInit_Setting_Reset.bUpdateData(poMcanMsg);
   if (bRet) bRet = eTJP_Setting.bUpdateData(poMcanMsg);
   if (bRet) bRet = ePro_Pilot_Setting.bUpdateData(poMcanMsg);
   if (bRet) bRet = aReserve.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__Available_Menu_Item::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eMain_Menu_Selection.bUpdateMcanMessage(poMcanMsg);
   eCar_Symbol_Color.bUpdateMcanMessage(poMcanMsg);
   eECO_Setting.bUpdateMcanMessage(poMcanMsg);
   ePopup_Setting.bUpdateMcanMessage(poMcanMsg);
   eIllumination_Setting.bUpdateMcanMessage(poMcanMsg);
   eLanguage_Setting.bUpdateMcanMessage(poMcanMsg);
   eTPMS_Setting.bUpdateMcanMessage(poMcanMsg);
   eInit_Setting_Reset.bUpdateMcanMessage(poMcanMsg);
   eTJP_Setting.bUpdateMcanMessage(poMcanMsg);
   ePro_Pilot_Setting.bUpdateMcanMessage(poMcanMsg);
   aReserve.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__Available_Menu_Item const& lhs, tcl_ITM_Meter_Audio__Available_Menu_Item const& rhs){
   if (lhs.eMain_Menu_Selection != rhs.eMain_Menu_Selection) return FALSE;
   if (lhs.eCar_Symbol_Color != rhs.eCar_Symbol_Color) return FALSE;
   if (lhs.eECO_Setting != rhs.eECO_Setting) return FALSE;
   if (lhs.ePopup_Setting != rhs.ePopup_Setting) return FALSE;
   if (lhs.eIllumination_Setting != rhs.eIllumination_Setting) return FALSE;
   if (lhs.eLanguage_Setting != rhs.eLanguage_Setting) return FALSE;
   if (lhs.eTPMS_Setting != rhs.eTPMS_Setting) return FALSE;
   if (lhs.eInit_Setting_Reset != rhs.eInit_Setting_Reset) return FALSE;
   if (lhs.eTJP_Setting != rhs.eTJP_Setting) return FALSE;
   if (lhs.ePro_Pilot_Setting != rhs.ePro_Pilot_Setting) return FALSE;
   if (lhs.aReserve != rhs.aReserve) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__Available_Menu_Item const& lhs, tcl_ITM_Meter_Audio__Available_Menu_Item const& rhs){
    if (
         (lhs.eMain_Menu_Selection == rhs.eMain_Menu_Selection)
      && (lhs.eCar_Symbol_Color == rhs.eCar_Symbol_Color)
      && (lhs.eECO_Setting == rhs.eECO_Setting)
      && (lhs.ePopup_Setting == rhs.ePopup_Setting)
      && (lhs.eIllumination_Setting == rhs.eIllumination_Setting)
      && (lhs.eLanguage_Setting == rhs.eLanguage_Setting)
      && (lhs.eTPMS_Setting == rhs.eTPMS_Setting)
      && (lhs.eInit_Setting_Reset == rhs.eInit_Setting_Reset)
      && (lhs.eTJP_Setting == rhs.eTJP_Setting)
      && (lhs.ePro_Pilot_Setting == rhs.ePro_Pilot_Setting)
      && (lhs.aReserve == rhs.aReserve)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__Menu_List::tcl_ITM_Meter_Audio__Menu_List() : 
   eITS_Status((tcl_ITM_Meter_Audio__e32_val2bit_ON_OFF_Unavailable::tenType)0x00, 0x02),
   eAverage_Speed((tcl_ITM_Meter_Audio__e32_val2bit_ON_OFF_Unavailable::tenType)0x00, 0x02),
   eDriving_Distance_Time((tcl_ITM_Meter_Audio__e32_val2bit_ON_OFF_Unavailable::tenType)0x00, 0x02),
   eDTE((tcl_ITM_Meter_Audio__e32_val2bit_ON_OFF_Unavailable::tenType)0x00, 0x02),
   eInst_Speed((tcl_ITM_Meter_Audio__e32_val2bit_ON_OFF_Unavailable::tenType)0x00, 0x02),
   eInst_FE_Ave_FE((tcl_ITM_Meter_Audio__e32_val2bit_ON_OFF_Unavailable::tenType)0x00, 0x02),
   eAccel_Guide((tcl_ITM_Meter_Audio__e32_val2bit_ON_OFF_Unavailable::tenType)0x00, 0x02),
   eTPMS((tcl_ITM_Meter_Audio__e32_val2bit_ON_OFF_Unavailable::tenType)0x00, 0x02),
   eAUDIO((tcl_ITM_Meter_Audio__e32_val2bit_ON_OFF_Unavailable::tenType)0x00, 0x02),
   eTBT_Compass((tcl_ITM_Meter_Audio__e32_val2bit_ON_OFF_Unavailable::tenType)0x00, 0x02),
   eval4WD((tcl_ITM_Meter_Audio__e32_val2bit_ON_OFF_Unavailable::tenType)0x00, 0x02),
   eHEV_Energy_Flow((tcl_ITM_Meter_Audio__e32_val2bit_ON_OFF_Unavailable::tenType)0x00, 0x02),
   eSOC((tcl_ITM_Meter_Audio__e32_val2bit_ON_OFF_Unavailable::tenType)0x00, 0x02),
   eEV_Odo((tcl_ITM_Meter_Audio__e32_val2bit_ON_OFF_Unavailable::tenType)0x00, 0x02),
   eWater_Temperature((tcl_ITM_Meter_Audio__e32_val2bit_ON_OFF_Unavailable::tenType)0x00, 0x02),
   eHome_Display((tcl_ITM_Meter_Audio__e32_val2bit_ON_OFF_Unavailable::tenType)0x00, 0x02),
   eIdol_Stop_Time((tcl_ITM_Meter_Audio__e32_val2bit_ON_OFF_Unavailable::tenType)0x00, 0x02),
   eSum_Idol_Stop_Time((tcl_ITM_Meter_Audio__e32_val2bit_ON_OFF_Unavailable::tenType)0x00, 0x02),
   eTorque((tcl_ITM_Meter_Audio__e32_val2bit_ON_OFF_Unavailable::tenType)0x00, 0x02),
   eIDM((tcl_ITM_Meter_Audio__e32_val2bit_ON_OFF_Unavailable::tenType)0x00, 0x02),
   eDriver_Attention_Support((tcl_ITM_Meter_Audio__e32_val2bit_ON_OFF_Unavailable::tenType)0x00, 0x02),
   eAdditional_Menu1_Menu1_Availability((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   eAdditional_Menu1_Menu1_TSR((tcl_ITM_Meter_Audio__e32_val2bit_ON_OFF_Unavailable::tenType)0x00, 0x02),
   eAdditional_Menu1_Menu1_OLS((tcl_ITM_Meter_Audio__e32_val2bit_ON_OFF_Unavailable::tenType)0x00, 0x02),
   eAdditional_Menu1_Menu1_Convenience((tcl_ITM_Meter_Audio__e32_val2bit_ON_OFF_Unavailable::tenType)0x00, 0x02),
   eAdditional_Menu1_Menu1_Drive_Computer((tcl_ITM_Meter_Audio__e32_val2bit_ON_OFF_Unavailable::tenType)0x00, 0x02),
   eAdditional_Menu1_Menu1_TJP((tcl_ITM_Meter_Audio__e32_val2bit_ON_OFF_Unavailable::tenType)0x00, 0x02),
   eAdditional_Menu1_Menu1_VCR((tcl_ITM_Meter_Audio__e32_val2bit_ON_OFF_Unavailable::tenType)0x00, 0x02),
   aReserve(NULL, 0x11)
{
}

tBool tcl_ITM_Meter_Audio__Menu_List::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eITS_Status.bUpdateData(poMcanMsg);
   if (bRet) bRet = eAverage_Speed.bUpdateData(poMcanMsg);
   if (bRet) bRet = eDriving_Distance_Time.bUpdateData(poMcanMsg);
   if (bRet) bRet = eDTE.bUpdateData(poMcanMsg);
   if (bRet) bRet = eInst_Speed.bUpdateData(poMcanMsg);
   if (bRet) bRet = eInst_FE_Ave_FE.bUpdateData(poMcanMsg);
   if (bRet) bRet = eAccel_Guide.bUpdateData(poMcanMsg);
   if (bRet) bRet = eTPMS.bUpdateData(poMcanMsg);
   if (bRet) bRet = eAUDIO.bUpdateData(poMcanMsg);
   if (bRet) bRet = eTBT_Compass.bUpdateData(poMcanMsg);
   if (bRet) bRet = eval4WD.bUpdateData(poMcanMsg);
   if (bRet) bRet = eHEV_Energy_Flow.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSOC.bUpdateData(poMcanMsg);
   if (bRet) bRet = eEV_Odo.bUpdateData(poMcanMsg);
   if (bRet) bRet = eWater_Temperature.bUpdateData(poMcanMsg);
   if (bRet) bRet = eHome_Display.bUpdateData(poMcanMsg);
   if (bRet) bRet = eIdol_Stop_Time.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSum_Idol_Stop_Time.bUpdateData(poMcanMsg);
   if (bRet) bRet = eTorque.bUpdateData(poMcanMsg);
   if (bRet) bRet = eIDM.bUpdateData(poMcanMsg);
   if (bRet) bRet = eDriver_Attention_Support.bUpdateData(poMcanMsg);
   if (bRet) bRet = eAdditional_Menu1_Menu1_Availability.bUpdateData(poMcanMsg);
   if (bRet) bRet = eAdditional_Menu1_Menu1_TSR.bUpdateData(poMcanMsg);
   if (bRet) bRet = eAdditional_Menu1_Menu1_OLS.bUpdateData(poMcanMsg);
   if (bRet) bRet = eAdditional_Menu1_Menu1_Convenience.bUpdateData(poMcanMsg);
   if (bRet) bRet = eAdditional_Menu1_Menu1_Drive_Computer.bUpdateData(poMcanMsg);
   if (bRet) bRet = eAdditional_Menu1_Menu1_TJP.bUpdateData(poMcanMsg);
   if (bRet) bRet = eAdditional_Menu1_Menu1_VCR.bUpdateData(poMcanMsg);
   if (bRet) bRet = aReserve.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__Menu_List::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eITS_Status.bUpdateMcanMessage(poMcanMsg);
   eAverage_Speed.bUpdateMcanMessage(poMcanMsg);
   eDriving_Distance_Time.bUpdateMcanMessage(poMcanMsg);
   eDTE.bUpdateMcanMessage(poMcanMsg);
   eInst_Speed.bUpdateMcanMessage(poMcanMsg);
   eInst_FE_Ave_FE.bUpdateMcanMessage(poMcanMsg);
   eAccel_Guide.bUpdateMcanMessage(poMcanMsg);
   eTPMS.bUpdateMcanMessage(poMcanMsg);
   eAUDIO.bUpdateMcanMessage(poMcanMsg);
   eTBT_Compass.bUpdateMcanMessage(poMcanMsg);
   eval4WD.bUpdateMcanMessage(poMcanMsg);
   eHEV_Energy_Flow.bUpdateMcanMessage(poMcanMsg);
   eSOC.bUpdateMcanMessage(poMcanMsg);
   eEV_Odo.bUpdateMcanMessage(poMcanMsg);
   eWater_Temperature.bUpdateMcanMessage(poMcanMsg);
   eHome_Display.bUpdateMcanMessage(poMcanMsg);
   eIdol_Stop_Time.bUpdateMcanMessage(poMcanMsg);
   eSum_Idol_Stop_Time.bUpdateMcanMessage(poMcanMsg);
   eTorque.bUpdateMcanMessage(poMcanMsg);
   eIDM.bUpdateMcanMessage(poMcanMsg);
   eDriver_Attention_Support.bUpdateMcanMessage(poMcanMsg);
   eAdditional_Menu1_Menu1_Availability.bUpdateMcanMessage(poMcanMsg);
   eAdditional_Menu1_Menu1_TSR.bUpdateMcanMessage(poMcanMsg);
   eAdditional_Menu1_Menu1_OLS.bUpdateMcanMessage(poMcanMsg);
   eAdditional_Menu1_Menu1_Convenience.bUpdateMcanMessage(poMcanMsg);
   eAdditional_Menu1_Menu1_Drive_Computer.bUpdateMcanMessage(poMcanMsg);
   eAdditional_Menu1_Menu1_TJP.bUpdateMcanMessage(poMcanMsg);
   eAdditional_Menu1_Menu1_VCR.bUpdateMcanMessage(poMcanMsg);
   aReserve.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__Menu_List const& lhs, tcl_ITM_Meter_Audio__Menu_List const& rhs){
   if (lhs.eITS_Status != rhs.eITS_Status) return FALSE;
   if (lhs.eAverage_Speed != rhs.eAverage_Speed) return FALSE;
   if (lhs.eDriving_Distance_Time != rhs.eDriving_Distance_Time) return FALSE;
   if (lhs.eDTE != rhs.eDTE) return FALSE;
   if (lhs.eInst_Speed != rhs.eInst_Speed) return FALSE;
   if (lhs.eInst_FE_Ave_FE != rhs.eInst_FE_Ave_FE) return FALSE;
   if (lhs.eAccel_Guide != rhs.eAccel_Guide) return FALSE;
   if (lhs.eTPMS != rhs.eTPMS) return FALSE;
   if (lhs.eAUDIO != rhs.eAUDIO) return FALSE;
   if (lhs.eTBT_Compass != rhs.eTBT_Compass) return FALSE;
   if (lhs.eval4WD != rhs.eval4WD) return FALSE;
   if (lhs.eHEV_Energy_Flow != rhs.eHEV_Energy_Flow) return FALSE;
   if (lhs.eSOC != rhs.eSOC) return FALSE;
   if (lhs.eEV_Odo != rhs.eEV_Odo) return FALSE;
   if (lhs.eWater_Temperature != rhs.eWater_Temperature) return FALSE;
   if (lhs.eHome_Display != rhs.eHome_Display) return FALSE;
   if (lhs.eIdol_Stop_Time != rhs.eIdol_Stop_Time) return FALSE;
   if (lhs.eSum_Idol_Stop_Time != rhs.eSum_Idol_Stop_Time) return FALSE;
   if (lhs.eTorque != rhs.eTorque) return FALSE;
   if (lhs.eIDM != rhs.eIDM) return FALSE;
   if (lhs.eDriver_Attention_Support != rhs.eDriver_Attention_Support) return FALSE;
   if (lhs.eAdditional_Menu1_Menu1_Availability != rhs.eAdditional_Menu1_Menu1_Availability) return FALSE;
   if (lhs.eAdditional_Menu1_Menu1_TSR != rhs.eAdditional_Menu1_Menu1_TSR) return FALSE;
   if (lhs.eAdditional_Menu1_Menu1_OLS != rhs.eAdditional_Menu1_Menu1_OLS) return FALSE;
   if (lhs.eAdditional_Menu1_Menu1_Convenience != rhs.eAdditional_Menu1_Menu1_Convenience) return FALSE;
   if (lhs.eAdditional_Menu1_Menu1_Drive_Computer != rhs.eAdditional_Menu1_Menu1_Drive_Computer) return FALSE;
   if (lhs.eAdditional_Menu1_Menu1_TJP != rhs.eAdditional_Menu1_Menu1_TJP) return FALSE;
   if (lhs.eAdditional_Menu1_Menu1_VCR != rhs.eAdditional_Menu1_Menu1_VCR) return FALSE;
   if (lhs.aReserve != rhs.aReserve) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__Menu_List const& lhs, tcl_ITM_Meter_Audio__Menu_List const& rhs){
    if (
         (lhs.eITS_Status == rhs.eITS_Status)
      && (lhs.eAverage_Speed == rhs.eAverage_Speed)
      && (lhs.eDriving_Distance_Time == rhs.eDriving_Distance_Time)
      && (lhs.eDTE == rhs.eDTE)
      && (lhs.eInst_Speed == rhs.eInst_Speed)
      && (lhs.eInst_FE_Ave_FE == rhs.eInst_FE_Ave_FE)
      && (lhs.eAccel_Guide == rhs.eAccel_Guide)
      && (lhs.eTPMS == rhs.eTPMS)
      && (lhs.eAUDIO == rhs.eAUDIO)
      && (lhs.eTBT_Compass == rhs.eTBT_Compass)
      && (lhs.eval4WD == rhs.eval4WD)
      && (lhs.eHEV_Energy_Flow == rhs.eHEV_Energy_Flow)
      && (lhs.eSOC == rhs.eSOC)
      && (lhs.eEV_Odo == rhs.eEV_Odo)
      && (lhs.eWater_Temperature == rhs.eWater_Temperature)
      && (lhs.eHome_Display == rhs.eHome_Display)
      && (lhs.eIdol_Stop_Time == rhs.eIdol_Stop_Time)
      && (lhs.eSum_Idol_Stop_Time == rhs.eSum_Idol_Stop_Time)
      && (lhs.eTorque == rhs.eTorque)
      && (lhs.eIDM == rhs.eIDM)
      && (lhs.eDriver_Attention_Support == rhs.eDriver_Attention_Support)
      && (lhs.eAdditional_Menu1_Menu1_Availability == rhs.eAdditional_Menu1_Menu1_Availability)
      && (lhs.eAdditional_Menu1_Menu1_TSR == rhs.eAdditional_Menu1_Menu1_TSR)
      && (lhs.eAdditional_Menu1_Menu1_OLS == rhs.eAdditional_Menu1_Menu1_OLS)
      && (lhs.eAdditional_Menu1_Menu1_Convenience == rhs.eAdditional_Menu1_Menu1_Convenience)
      && (lhs.eAdditional_Menu1_Menu1_Drive_Computer == rhs.eAdditional_Menu1_Menu1_Drive_Computer)
      && (lhs.eAdditional_Menu1_Menu1_TJP == rhs.eAdditional_Menu1_Menu1_TJP)
      && (lhs.eAdditional_Menu1_Menu1_VCR == rhs.eAdditional_Menu1_Menu1_VCR)
      && (lhs.aReserve == rhs.aReserve)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__Low_Temperature::tcl_ITM_Meter_Audio__Low_Temperature() : 
   eLow_Temperature((tcl_ITM_Meter_Audio__e32_Meter_Setting_Available::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_Meter_Audio__Low_Temperature::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eLow_Temperature.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__Low_Temperature::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eLow_Temperature.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__Low_Temperature const& lhs, tcl_ITM_Meter_Audio__Low_Temperature const& rhs){
   if (lhs.eLow_Temperature != rhs.eLow_Temperature) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__Low_Temperature const& lhs, tcl_ITM_Meter_Audio__Low_Temperature const& rhs){
    if (
         (lhs.eLow_Temperature == rhs.eLow_Temperature)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__TBT::tcl_ITM_Meter_Audio__TBT() : 
   eTBT((tcl_ITM_Meter_Audio__e32_Meter_Setting_Available::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_Meter_Audio__TBT::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eTBT.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__TBT::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eTBT.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__TBT const& lhs, tcl_ITM_Meter_Audio__TBT const& rhs){
   if (lhs.eTBT != rhs.eTBT) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__TBT const& lhs, tcl_ITM_Meter_Audio__TBT const& rhs){
    if (
         (lhs.eTBT == rhs.eTBT)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__ECO_Accel_Guide::tcl_ITM_Meter_Audio__ECO_Accel_Guide() : 
   eECO_Accel_Guide((tcl_ITM_Meter_Audio__e32_Synchronization_ECO_List::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_Meter_Audio__ECO_Accel_Guide::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eECO_Accel_Guide.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__ECO_Accel_Guide::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eECO_Accel_Guide.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__ECO_Accel_Guide const& lhs, tcl_ITM_Meter_Audio__ECO_Accel_Guide const& rhs){
   if (lhs.eECO_Accel_Guide != rhs.eECO_Accel_Guide) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__ECO_Accel_Guide const& lhs, tcl_ITM_Meter_Audio__ECO_Accel_Guide const& rhs){
    if (
         (lhs.eECO_Accel_Guide == rhs.eECO_Accel_Guide)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__ECO_Drive_Report::tcl_ITM_Meter_Audio__ECO_Drive_Report() : 
   eECO_Drive_Report((tcl_ITM_Meter_Audio__e32_Meter_Setting_Available::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_Meter_Audio__ECO_Drive_Report::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eECO_Drive_Report.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__ECO_Drive_Report::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eECO_Drive_Report.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__ECO_Drive_Report const& lhs, tcl_ITM_Meter_Audio__ECO_Drive_Report const& rhs){
   if (lhs.eECO_Drive_Report != rhs.eECO_Drive_Report) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__ECO_Drive_Report const& lhs, tcl_ITM_Meter_Audio__ECO_Drive_Report const& rhs){
    if (
         (lhs.eECO_Drive_Report == rhs.eECO_Drive_Report)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__Color_List::tcl_ITM_Meter_Audio__Color_List() : 
   eBlue((tcl_ITM_Meter_Audio__e32_val2bit_ON_OFF_Unavailable::tenType)0x00, 0x02),
   eBrown((tcl_ITM_Meter_Audio__e32_val2bit_ON_OFF_Unavailable::tenType)0x00, 0x02),
   eRed((tcl_ITM_Meter_Audio__e32_val2bit_ON_OFF_Unavailable::tenType)0x00, 0x02),
   eBeige((tcl_ITM_Meter_Audio__e32_val2bit_ON_OFF_Unavailable::tenType)0x00, 0x02),
   eBlack((tcl_ITM_Meter_Audio__e32_val2bit_ON_OFF_Unavailable::tenType)0x00, 0x02),
   eGray((tcl_ITM_Meter_Audio__e32_val2bit_ON_OFF_Unavailable::tenType)0x00, 0x02),
   eWhite((tcl_ITM_Meter_Audio__e32_val2bit_ON_OFF_Unavailable::tenType)0x00, 0x02),
   eSilver((tcl_ITM_Meter_Audio__e32_val2bit_ON_OFF_Unavailable::tenType)0x00, 0x02),
   aReserve(NULL, 0x10)
{
}

tBool tcl_ITM_Meter_Audio__Color_List::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eBlue.bUpdateData(poMcanMsg);
   if (bRet) bRet = eBrown.bUpdateData(poMcanMsg);
   if (bRet) bRet = eRed.bUpdateData(poMcanMsg);
   if (bRet) bRet = eBeige.bUpdateData(poMcanMsg);
   if (bRet) bRet = eBlack.bUpdateData(poMcanMsg);
   if (bRet) bRet = eGray.bUpdateData(poMcanMsg);
   if (bRet) bRet = eWhite.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSilver.bUpdateData(poMcanMsg);
   if (bRet) bRet = aReserve.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__Color_List::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eBlue.bUpdateMcanMessage(poMcanMsg);
   eBrown.bUpdateMcanMessage(poMcanMsg);
   eRed.bUpdateMcanMessage(poMcanMsg);
   eBeige.bUpdateMcanMessage(poMcanMsg);
   eBlack.bUpdateMcanMessage(poMcanMsg);
   eGray.bUpdateMcanMessage(poMcanMsg);
   eWhite.bUpdateMcanMessage(poMcanMsg);
   eSilver.bUpdateMcanMessage(poMcanMsg);
   aReserve.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__Color_List const& lhs, tcl_ITM_Meter_Audio__Color_List const& rhs){
   if (lhs.eBlue != rhs.eBlue) return FALSE;
   if (lhs.eBrown != rhs.eBrown) return FALSE;
   if (lhs.eRed != rhs.eRed) return FALSE;
   if (lhs.eBeige != rhs.eBeige) return FALSE;
   if (lhs.eBlack != rhs.eBlack) return FALSE;
   if (lhs.eGray != rhs.eGray) return FALSE;
   if (lhs.eWhite != rhs.eWhite) return FALSE;
   if (lhs.eSilver != rhs.eSilver) return FALSE;
   if (lhs.aReserve != rhs.aReserve) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__Color_List const& lhs, tcl_ITM_Meter_Audio__Color_List const& rhs){
    if (
         (lhs.eBlue == rhs.eBlue)
      && (lhs.eBrown == rhs.eBrown)
      && (lhs.eRed == rhs.eRed)
      && (lhs.eBeige == rhs.eBeige)
      && (lhs.eBlack == rhs.eBlack)
      && (lhs.eGray == rhs.eGray)
      && (lhs.eWhite == rhs.eWhite)
      && (lhs.eSilver == rhs.eSilver)
      && (lhs.aReserve == rhs.aReserve)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__Replace_Time::tcl_ITM_Meter_Audio__Replace_Time() : 
   eOil_Filter((tcl_ITM_Meter_Audio__e32_ON_OFF::tenType)0x00, 0x01),
   eTire((tcl_ITM_Meter_Audio__e32_ON_OFF::tenType)0x00, 0x01),
   eUser((tcl_ITM_Meter_Audio__e32_ON_OFF::tenType)0x00, 0x01),
   eBattery((tcl_ITM_Meter_Audio__e32_ON_OFF::tenType)0x00, 0x01),
   eAir_Conditioner_Filter((tcl_ITM_Meter_Audio__e32_ON_OFF::tenType)0x00, 0x01),
   aReserve(NULL, 0x03)
{
}

tBool tcl_ITM_Meter_Audio__Replace_Time::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eOil_Filter.bUpdateData(poMcanMsg);
   if (bRet) bRet = eTire.bUpdateData(poMcanMsg);
   if (bRet) bRet = eUser.bUpdateData(poMcanMsg);
   if (bRet) bRet = eBattery.bUpdateData(poMcanMsg);
   if (bRet) bRet = eAir_Conditioner_Filter.bUpdateData(poMcanMsg);
   if (bRet) bRet = aReserve.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__Replace_Time::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eOil_Filter.bUpdateMcanMessage(poMcanMsg);
   eTire.bUpdateMcanMessage(poMcanMsg);
   eUser.bUpdateMcanMessage(poMcanMsg);
   eBattery.bUpdateMcanMessage(poMcanMsg);
   eAir_Conditioner_Filter.bUpdateMcanMessage(poMcanMsg);
   aReserve.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__Replace_Time const& lhs, tcl_ITM_Meter_Audio__Replace_Time const& rhs){
   if (lhs.eOil_Filter != rhs.eOil_Filter) return FALSE;
   if (lhs.eTire != rhs.eTire) return FALSE;
   if (lhs.eUser != rhs.eUser) return FALSE;
   if (lhs.eBattery != rhs.eBattery) return FALSE;
   if (lhs.eAir_Conditioner_Filter != rhs.eAir_Conditioner_Filter) return FALSE;
   if (lhs.aReserve != rhs.aReserve) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__Replace_Time const& lhs, tcl_ITM_Meter_Audio__Replace_Time const& rhs){
    if (
         (lhs.eOil_Filter == rhs.eOil_Filter)
      && (lhs.eTire == rhs.eTire)
      && (lhs.eUser == rhs.eUser)
      && (lhs.eBattery == rhs.eBattery)
      && (lhs.eAir_Conditioner_Filter == rhs.eAir_Conditioner_Filter)
      && (lhs.aReserve == rhs.aReserve)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__Illumination_Effect::tcl_ITM_Meter_Audio__Illumination_Effect() : 
   eIllumination_Effect((tcl_ITM_Meter_Audio__e32_ON_OFF::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_Meter_Audio__Illumination_Effect::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eIllumination_Effect.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__Illumination_Effect::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eIllumination_Effect.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__Illumination_Effect const& lhs, tcl_ITM_Meter_Audio__Illumination_Effect const& rhs){
   if (lhs.eIllumination_Effect != rhs.eIllumination_Effect) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__Illumination_Effect const& lhs, tcl_ITM_Meter_Audio__Illumination_Effect const& rhs){
    if (
         (lhs.eIllumination_Effect == rhs.eIllumination_Effect)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__Internet_Audio_Source::tcl_ITM_Meter_Audio__Internet_Audio_Source() : 
   eUpdate((tcl_ITM_Meter_Audio__e32_Update_List::tenType)0x00, 0x08),
   eText_Info_Character_Set((tcl_ITM_Meter_Audio__e32_Character_Set_List::tenType)0x00, 0x08),
   uiText_Info_Length(0x01, 0x08),
   vstrText_Info_Text_Body(NULL, 0)
{
}

tBool tcl_ITM_Meter_Audio__Internet_Audio_Source::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eUpdate.bUpdateData(poMcanMsg);
   if (bRet) bRet = eText_Info_Character_Set.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiText_Info_Length.bUpdateData(poMcanMsg);

   if (bRet) bRet = vstrText_Info_Text_Body.bUpdateLength(8*uiText_Info_Length.u32GetData());
   if (bRet) bRet = vstrText_Info_Text_Body.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__Internet_Audio_Source::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eUpdate.bUpdateMcanMessage(poMcanMsg);
   eText_Info_Character_Set.bUpdateMcanMessage(poMcanMsg);
   uiText_Info_Length.bUpdateMcanMessage(poMcanMsg);
   vstrText_Info_Text_Body.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__Internet_Audio_Source const& lhs, tcl_ITM_Meter_Audio__Internet_Audio_Source const& rhs){
   if (lhs.eUpdate != rhs.eUpdate) return FALSE;
   if (lhs.eText_Info_Character_Set != rhs.eText_Info_Character_Set) return FALSE;
   if (lhs.uiText_Info_Length != rhs.uiText_Info_Length) return FALSE;
   if (lhs.vstrText_Info_Text_Body != rhs.vstrText_Info_Text_Body) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__Internet_Audio_Source const& lhs, tcl_ITM_Meter_Audio__Internet_Audio_Source const& rhs){
    if (
         (lhs.eUpdate == rhs.eUpdate)
      && (lhs.eText_Info_Character_Set == rhs.eText_Info_Character_Set)
      && (lhs.uiText_Info_Length == rhs.uiText_Info_Length)
      && (lhs.vstrText_Info_Text_Body == rhs.vstrText_Info_Text_Body)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__Power_State::tcl_ITM_Meter_Audio__Power_State() : 
   ePower_State((tcl_ITM_Meter_Audio__e32_Power_State_List::tenType)0x01, 0x08)
{
}

tBool tcl_ITM_Meter_Audio__Power_State::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = ePower_State.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__Power_State::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   ePower_State.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__Power_State const& lhs, tcl_ITM_Meter_Audio__Power_State const& rhs){
   if (lhs.ePower_State != rhs.ePower_State) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__Power_State const& lhs, tcl_ITM_Meter_Audio__Power_State const& rhs){
    if (
         (lhs.ePower_State == rhs.ePower_State)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__Selected_Language::tcl_ITM_Meter_Audio__Selected_Language() : 
   eSelected_Language((tcl_ITM_Meter_Audio__e32_Select_Language_List::tenType)0x01, 0x08)
{
}

tBool tcl_ITM_Meter_Audio__Selected_Language::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eSelected_Language.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__Selected_Language::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eSelected_Language.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__Selected_Language const& lhs, tcl_ITM_Meter_Audio__Selected_Language const& rhs){
   if (lhs.eSelected_Language != rhs.eSelected_Language) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__Selected_Language const& lhs, tcl_ITM_Meter_Audio__Selected_Language const& rhs){
    if (
         (lhs.eSelected_Language == rhs.eSelected_Language)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__Change_Language::tcl_ITM_Meter_Audio__Change_Language() : 
   eChange_Language((tcl_ITM_Meter_Audio__e32_Change_Language::tenType)0x01, 0x08)
{
}

tBool tcl_ITM_Meter_Audio__Change_Language::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eChange_Language.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__Change_Language::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eChange_Language.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__Change_Language const& lhs, tcl_ITM_Meter_Audio__Change_Language const& rhs){
   if (lhs.eChange_Language != rhs.eChange_Language) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__Change_Language const& lhs, tcl_ITM_Meter_Audio__Change_Language const& rhs){
    if (
         (lhs.eChange_Language == rhs.eChange_Language)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__Selected_TEL_Menu::tcl_ITM_Meter_Audio__Selected_TEL_Menu() : 
   eSelected_TEL_Menu((tcl_ITM_Meter_Audio__e32_TEL_Menu_List::tenType)0x01, 0x08)
{
}

tBool tcl_ITM_Meter_Audio__Selected_TEL_Menu::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eSelected_TEL_Menu.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__Selected_TEL_Menu::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eSelected_TEL_Menu.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__Selected_TEL_Menu const& lhs, tcl_ITM_Meter_Audio__Selected_TEL_Menu const& rhs){
   if (lhs.eSelected_TEL_Menu != rhs.eSelected_TEL_Menu) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__Selected_TEL_Menu const& lhs, tcl_ITM_Meter_Audio__Selected_TEL_Menu const& rhs){
    if (
         (lhs.eSelected_TEL_Menu == rhs.eSelected_TEL_Menu)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__Language_State::tcl_ITM_Meter_Audio__Language_State() : 
   eLanguage_State((tcl_ITM_Meter_Audio__e32_Available_Set::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_Meter_Audio__Language_State::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eLanguage_State.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__Language_State::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eLanguage_State.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__Language_State const& lhs, tcl_ITM_Meter_Audio__Language_State const& rhs){
   if (lhs.eLanguage_State != rhs.eLanguage_State) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__Language_State const& lhs, tcl_ITM_Meter_Audio__Language_State const& rhs){
    if (
         (lhs.eLanguage_State == rhs.eLanguage_State)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__Artist_Name::tcl_ITM_Meter_Audio__Artist_Name() : 
   eCharacter_Set((tcl_ITM_Meter_Audio__e32_Character_Set_List::tenType)0x00, 0x08),
   uiLength(0x01, 0x08),
   vstrText_Body(NULL, 0)
{
}

tBool tcl_ITM_Meter_Audio__Artist_Name::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eCharacter_Set.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiLength.bUpdateData(poMcanMsg);

   if (bRet) bRet = vstrText_Body.bUpdateLength(8*uiLength.u32GetData());
   if (bRet) bRet = vstrText_Body.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__Artist_Name::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eCharacter_Set.bUpdateMcanMessage(poMcanMsg);
   uiLength.bUpdateMcanMessage(poMcanMsg);
   vstrText_Body.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__Artist_Name const& lhs, tcl_ITM_Meter_Audio__Artist_Name const& rhs){
   if (lhs.eCharacter_Set != rhs.eCharacter_Set) return FALSE;
   if (lhs.uiLength != rhs.uiLength) return FALSE;
   if (lhs.vstrText_Body != rhs.vstrText_Body) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__Artist_Name const& lhs, tcl_ITM_Meter_Audio__Artist_Name const& rhs){
    if (
         (lhs.eCharacter_Set == rhs.eCharacter_Set)
      && (lhs.uiLength == rhs.uiLength)
      && (lhs.vstrText_Body == rhs.vstrText_Body)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__Song_Title::tcl_ITM_Meter_Audio__Song_Title() : 
   eCharacter_Set((tcl_ITM_Meter_Audio__e32_Character_Set_List::tenType)0x00, 0x08),
   uiLength(0x01, 0x08),
   vstrText_Body(NULL, 0)
{
}

tBool tcl_ITM_Meter_Audio__Song_Title::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eCharacter_Set.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiLength.bUpdateData(poMcanMsg);

   if (bRet) bRet = vstrText_Body.bUpdateLength(8*uiLength.u32GetData());
   if (bRet) bRet = vstrText_Body.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__Song_Title::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eCharacter_Set.bUpdateMcanMessage(poMcanMsg);
   uiLength.bUpdateMcanMessage(poMcanMsg);
   vstrText_Body.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__Song_Title const& lhs, tcl_ITM_Meter_Audio__Song_Title const& rhs){
   if (lhs.eCharacter_Set != rhs.eCharacter_Set) return FALSE;
   if (lhs.uiLength != rhs.uiLength) return FALSE;
   if (lhs.vstrText_Body != rhs.vstrText_Body) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__Song_Title const& lhs, tcl_ITM_Meter_Audio__Song_Title const& rhs){
    if (
         (lhs.eCharacter_Set == rhs.eCharacter_Set)
      && (lhs.uiLength == rhs.uiLength)
      && (lhs.vstrText_Body == rhs.vstrText_Body)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__Audio_Source_Kind::tcl_ITM_Meter_Audio__Audio_Source_Kind() : 
   eFM((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   eFM1((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   eFM2((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   eFM_AP((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   eAM((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   eAM_AP((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   eXM1((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   eXM2((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   eXM3((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   eSXM((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   eSXM1((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   eSXM2((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   eSXM3((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   eTA_JPN((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   eDAB((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   eTV((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   eTV1((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   eTV2((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   eMusic_Box((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   eCD((tcl_ITM_Meter_Audio__e32_Available_Connection::tenType)0x00, 0x02),
   eDVD((tcl_ITM_Meter_Audio__e32_Available_Connection::tenType)0x00, 0x02),
   eUSB((tcl_ITM_Meter_Audio__e32_Available_Connection::tenType)0x00, 0x02),
   eUSB1((tcl_ITM_Meter_Audio__e32_Available_Connection::tenType)0x00, 0x02),
   eUSB2((tcl_ITM_Meter_Audio__e32_Available_Connection::tenType)0x00, 0x02),
   eiPod((tcl_ITM_Meter_Audio__e32_Available_Connection::tenType)0x00, 0x02),
   eiPod1((tcl_ITM_Meter_Audio__e32_Available_Connection::tenType)0x00, 0x02),
   eiPod2((tcl_ITM_Meter_Audio__e32_Available_Connection::tenType)0x00, 0x02),
   eAUX((tcl_ITM_Meter_Audio__e32_Available_Connection::tenType)0x00, 0x02),
   eAPPS((tcl_ITM_Meter_Audio__e32_Available_Connection::tenType)0x00, 0x02),
   eRSE((tcl_ITM_Meter_Audio__e32_Available_Connection::tenType)0x00, 0x02),
   eBT_Audio((tcl_ITM_Meter_Audio__e32_Available_Connection::tenType)0x00, 0x02),
   eBlu_ray((tcl_ITM_Meter_Audio__e32_Available_Connection::tenType)0x00, 0x02),
   eDRM((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   aReserve(NULL, 0x02)
{
}

tBool tcl_ITM_Meter_Audio__Audio_Source_Kind::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eFM.bUpdateData(poMcanMsg);
   if (bRet) bRet = eFM1.bUpdateData(poMcanMsg);
   if (bRet) bRet = eFM2.bUpdateData(poMcanMsg);
   if (bRet) bRet = eFM_AP.bUpdateData(poMcanMsg);
   if (bRet) bRet = eAM.bUpdateData(poMcanMsg);
   if (bRet) bRet = eAM_AP.bUpdateData(poMcanMsg);
   if (bRet) bRet = eXM1.bUpdateData(poMcanMsg);
   if (bRet) bRet = eXM2.bUpdateData(poMcanMsg);
   if (bRet) bRet = eXM3.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSXM.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSXM1.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSXM2.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSXM3.bUpdateData(poMcanMsg);
   if (bRet) bRet = eTA_JPN.bUpdateData(poMcanMsg);
   if (bRet) bRet = eDAB.bUpdateData(poMcanMsg);
   if (bRet) bRet = eTV.bUpdateData(poMcanMsg);
   if (bRet) bRet = eTV1.bUpdateData(poMcanMsg);
   if (bRet) bRet = eTV2.bUpdateData(poMcanMsg);
   if (bRet) bRet = eMusic_Box.bUpdateData(poMcanMsg);
   if (bRet) bRet = eCD.bUpdateData(poMcanMsg);
   if (bRet) bRet = eDVD.bUpdateData(poMcanMsg);
   if (bRet) bRet = eUSB.bUpdateData(poMcanMsg);
   if (bRet) bRet = eUSB1.bUpdateData(poMcanMsg);
   if (bRet) bRet = eUSB2.bUpdateData(poMcanMsg);
   if (bRet) bRet = eiPod.bUpdateData(poMcanMsg);
   if (bRet) bRet = eiPod1.bUpdateData(poMcanMsg);
   if (bRet) bRet = eiPod2.bUpdateData(poMcanMsg);
   if (bRet) bRet = eAUX.bUpdateData(poMcanMsg);
   if (bRet) bRet = eAPPS.bUpdateData(poMcanMsg);
   if (bRet) bRet = eRSE.bUpdateData(poMcanMsg);
   if (bRet) bRet = eBT_Audio.bUpdateData(poMcanMsg);
   if (bRet) bRet = eBlu_ray.bUpdateData(poMcanMsg);
   if (bRet) bRet = eDRM.bUpdateData(poMcanMsg);
   if (bRet) bRet = aReserve.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__Audio_Source_Kind::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eFM.bUpdateMcanMessage(poMcanMsg);
   eFM1.bUpdateMcanMessage(poMcanMsg);
   eFM2.bUpdateMcanMessage(poMcanMsg);
   eFM_AP.bUpdateMcanMessage(poMcanMsg);
   eAM.bUpdateMcanMessage(poMcanMsg);
   eAM_AP.bUpdateMcanMessage(poMcanMsg);
   eXM1.bUpdateMcanMessage(poMcanMsg);
   eXM2.bUpdateMcanMessage(poMcanMsg);
   eXM3.bUpdateMcanMessage(poMcanMsg);
   eSXM.bUpdateMcanMessage(poMcanMsg);
   eSXM1.bUpdateMcanMessage(poMcanMsg);
   eSXM2.bUpdateMcanMessage(poMcanMsg);
   eSXM3.bUpdateMcanMessage(poMcanMsg);
   eTA_JPN.bUpdateMcanMessage(poMcanMsg);
   eDAB.bUpdateMcanMessage(poMcanMsg);
   eTV.bUpdateMcanMessage(poMcanMsg);
   eTV1.bUpdateMcanMessage(poMcanMsg);
   eTV2.bUpdateMcanMessage(poMcanMsg);
   eMusic_Box.bUpdateMcanMessage(poMcanMsg);
   eCD.bUpdateMcanMessage(poMcanMsg);
   eDVD.bUpdateMcanMessage(poMcanMsg);
   eUSB.bUpdateMcanMessage(poMcanMsg);
   eUSB1.bUpdateMcanMessage(poMcanMsg);
   eUSB2.bUpdateMcanMessage(poMcanMsg);
   eiPod.bUpdateMcanMessage(poMcanMsg);
   eiPod1.bUpdateMcanMessage(poMcanMsg);
   eiPod2.bUpdateMcanMessage(poMcanMsg);
   eAUX.bUpdateMcanMessage(poMcanMsg);
   eAPPS.bUpdateMcanMessage(poMcanMsg);
   eRSE.bUpdateMcanMessage(poMcanMsg);
   eBT_Audio.bUpdateMcanMessage(poMcanMsg);
   eBlu_ray.bUpdateMcanMessage(poMcanMsg);
   eDRM.bUpdateMcanMessage(poMcanMsg);
   aReserve.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__Audio_Source_Kind const& lhs, tcl_ITM_Meter_Audio__Audio_Source_Kind const& rhs){
   if (lhs.eFM != rhs.eFM) return FALSE;
   if (lhs.eFM1 != rhs.eFM1) return FALSE;
   if (lhs.eFM2 != rhs.eFM2) return FALSE;
   if (lhs.eFM_AP != rhs.eFM_AP) return FALSE;
   if (lhs.eAM != rhs.eAM) return FALSE;
   if (lhs.eAM_AP != rhs.eAM_AP) return FALSE;
   if (lhs.eXM1 != rhs.eXM1) return FALSE;
   if (lhs.eXM2 != rhs.eXM2) return FALSE;
   if (lhs.eXM3 != rhs.eXM3) return FALSE;
   if (lhs.eSXM != rhs.eSXM) return FALSE;
   if (lhs.eSXM1 != rhs.eSXM1) return FALSE;
   if (lhs.eSXM2 != rhs.eSXM2) return FALSE;
   if (lhs.eSXM3 != rhs.eSXM3) return FALSE;
   if (lhs.eTA_JPN != rhs.eTA_JPN) return FALSE;
   if (lhs.eDAB != rhs.eDAB) return FALSE;
   if (lhs.eTV != rhs.eTV) return FALSE;
   if (lhs.eTV1 != rhs.eTV1) return FALSE;
   if (lhs.eTV2 != rhs.eTV2) return FALSE;
   if (lhs.eMusic_Box != rhs.eMusic_Box) return FALSE;
   if (lhs.eCD != rhs.eCD) return FALSE;
   if (lhs.eDVD != rhs.eDVD) return FALSE;
   if (lhs.eUSB != rhs.eUSB) return FALSE;
   if (lhs.eUSB1 != rhs.eUSB1) return FALSE;
   if (lhs.eUSB2 != rhs.eUSB2) return FALSE;
   if (lhs.eiPod != rhs.eiPod) return FALSE;
   if (lhs.eiPod1 != rhs.eiPod1) return FALSE;
   if (lhs.eiPod2 != rhs.eiPod2) return FALSE;
   if (lhs.eAUX != rhs.eAUX) return FALSE;
   if (lhs.eAPPS != rhs.eAPPS) return FALSE;
   if (lhs.eRSE != rhs.eRSE) return FALSE;
   if (lhs.eBT_Audio != rhs.eBT_Audio) return FALSE;
   if (lhs.eBlu_ray != rhs.eBlu_ray) return FALSE;
   if (lhs.eDRM != rhs.eDRM) return FALSE;
   if (lhs.aReserve != rhs.aReserve) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__Audio_Source_Kind const& lhs, tcl_ITM_Meter_Audio__Audio_Source_Kind const& rhs){
    if (
         (lhs.eFM == rhs.eFM)
      && (lhs.eFM1 == rhs.eFM1)
      && (lhs.eFM2 == rhs.eFM2)
      && (lhs.eFM_AP == rhs.eFM_AP)
      && (lhs.eAM == rhs.eAM)
      && (lhs.eAM_AP == rhs.eAM_AP)
      && (lhs.eXM1 == rhs.eXM1)
      && (lhs.eXM2 == rhs.eXM2)
      && (lhs.eXM3 == rhs.eXM3)
      && (lhs.eSXM == rhs.eSXM)
      && (lhs.eSXM1 == rhs.eSXM1)
      && (lhs.eSXM2 == rhs.eSXM2)
      && (lhs.eSXM3 == rhs.eSXM3)
      && (lhs.eTA_JPN == rhs.eTA_JPN)
      && (lhs.eDAB == rhs.eDAB)
      && (lhs.eTV == rhs.eTV)
      && (lhs.eTV1 == rhs.eTV1)
      && (lhs.eTV2 == rhs.eTV2)
      && (lhs.eMusic_Box == rhs.eMusic_Box)
      && (lhs.eCD == rhs.eCD)
      && (lhs.eDVD == rhs.eDVD)
      && (lhs.eUSB == rhs.eUSB)
      && (lhs.eUSB1 == rhs.eUSB1)
      && (lhs.eUSB2 == rhs.eUSB2)
      && (lhs.eiPod == rhs.eiPod)
      && (lhs.eiPod1 == rhs.eiPod1)
      && (lhs.eiPod2 == rhs.eiPod2)
      && (lhs.eAUX == rhs.eAUX)
      && (lhs.eAPPS == rhs.eAPPS)
      && (lhs.eRSE == rhs.eRSE)
      && (lhs.eBT_Audio == rhs.eBT_Audio)
      && (lhs.eBlu_ray == rhs.eBlu_ray)
      && (lhs.eDRM == rhs.eDRM)
      && (lhs.aReserve == rhs.aReserve)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__VR_Digit::tcl_ITM_Meter_Audio__VR_Digit() : 
   uiNumber_of_Digit(0x00, 0x08)
{
   vecVR_Digit.clear();
}

tBool tcl_ITM_Meter_Audio__VR_Digit::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiNumber_of_Digit.bUpdateData(poMcanMsg);
     for (tU32 i=0; bRet==TRUE && i<uiNumber_of_Digit.u32GetData(); i++) {
        tclVR_Digit oNew;
        if (bRet) bRet = oNew.eDigit.bUpdateData(poMcanMsg);
        if (bRet)        vecVR_Digit.push_back(oNew);
     }

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__VR_Digit::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiNumber_of_Digit.vSetData(vecVR_Digit.size());
   uiNumber_of_Digit.bUpdateMcanMessage(poMcanMsg);
   ::std::vector < tclVR_Digit >::iterator it;
   for (it = vecVR_Digit.begin(); it != vecVR_Digit.end(); ++it){;
       it->eDigit.bUpdateMcanMessage(poMcanMsg);
   }

}

tBool operator==(tcl_ITM_Meter_Audio__VR_Digit const& lhs, tcl_ITM_Meter_Audio__VR_Digit const& rhs){
   if (lhs.uiNumber_of_Digit != rhs.uiNumber_of_Digit) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__VR_Digit const& lhs, tcl_ITM_Meter_Audio__VR_Digit const& rhs){
    if (
         (lhs.uiNumber_of_Digit == rhs.uiNumber_of_Digit)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__Selected_Call_Menu::tcl_ITM_Meter_Audio__Selected_Call_Menu() : 
   eSelected_Call_Menu((tcl_ITM_Meter_Audio__e32_Call_Menu_List::tenType)0x01, 0x08)
{
}

tBool tcl_ITM_Meter_Audio__Selected_Call_Menu::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eSelected_Call_Menu.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__Selected_Call_Menu::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eSelected_Call_Menu.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__Selected_Call_Menu const& lhs, tcl_ITM_Meter_Audio__Selected_Call_Menu const& rhs){
   if (lhs.eSelected_Call_Menu != rhs.eSelected_Call_Menu) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__Selected_Call_Menu const& lhs, tcl_ITM_Meter_Audio__Selected_Call_Menu const& rhs){
    if (
         (lhs.eSelected_Call_Menu == rhs.eSelected_Call_Menu)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__Selected_Message_Menu::tcl_ITM_Meter_Audio__Selected_Message_Menu() : 
   eSelected_Message_Menu((tcl_ITM_Meter_Audio__e32_Meesage_Menu_List::tenType)0x01, 0x08)
{
}

tBool tcl_ITM_Meter_Audio__Selected_Message_Menu::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eSelected_Message_Menu.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__Selected_Message_Menu::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eSelected_Message_Menu.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__Selected_Message_Menu const& lhs, tcl_ITM_Meter_Audio__Selected_Message_Menu const& rhs){
   if (lhs.eSelected_Message_Menu != rhs.eSelected_Message_Menu) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__Selected_Message_Menu const& lhs, tcl_ITM_Meter_Audio__Selected_Message_Menu const& rhs){
    if (
         (lhs.eSelected_Message_Menu == rhs.eSelected_Message_Menu)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__Call_State::tcl_ITM_Meter_Audio__Call_State() : 
   eCall_State((tcl_ITM_Meter_Audio__e32_Call_State_List::tenType)0x01, 0x08)
{
}

tBool tcl_ITM_Meter_Audio__Call_State::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eCall_State.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__Call_State::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eCall_State.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__Call_State const& lhs, tcl_ITM_Meter_Audio__Call_State const& rhs){
   if (lhs.eCall_State != rhs.eCall_State) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__Call_State const& lhs, tcl_ITM_Meter_Audio__Call_State const& rhs){
    if (
         (lhs.eCall_State == rhs.eCall_State)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__Mute::tcl_ITM_Meter_Audio__Mute() : 
   eMute((tcl_ITM_Meter_Audio__e32_ON_OFF::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_Meter_Audio__Mute::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eMute.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__Mute::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eMute.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__Mute const& lhs, tcl_ITM_Meter_Audio__Mute const& rhs){
   if (lhs.eMute != rhs.eMute) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__Mute const& lhs, tcl_ITM_Meter_Audio__Mute const& rhs){
    if (
         (lhs.eMute == rhs.eMute)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__Short_Message_State::tcl_ITM_Meter_Audio__Short_Message_State() : 
   eShort_Message_State((tcl_ITM_Meter_Audio__e32_Text_Message_State_List::tenType)0x01, 0x08)
{
}

tBool tcl_ITM_Meter_Audio__Short_Message_State::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eShort_Message_State.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__Short_Message_State::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eShort_Message_State.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__Short_Message_State const& lhs, tcl_ITM_Meter_Audio__Short_Message_State const& rhs){
   if (lhs.eShort_Message_State != rhs.eShort_Message_State) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__Short_Message_State const& lhs, tcl_ITM_Meter_Audio__Short_Message_State const& rhs){
    if (
         (lhs.eShort_Message_State == rhs.eShort_Message_State)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__Multicast_Ch::tcl_ITM_Meter_Audio__Multicast_Ch() : 
   uiMulticast_Ch(0x00, 0x08)
{
}

tBool tcl_ITM_Meter_Audio__Multicast_Ch::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiMulticast_Ch.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__Multicast_Ch::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiMulticast_Ch.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__Multicast_Ch const& lhs, tcl_ITM_Meter_Audio__Multicast_Ch const& rhs){
   if (lhs.uiMulticast_Ch != rhs.uiMulticast_Ch) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__Multicast_Ch const& lhs, tcl_ITM_Meter_Audio__Multicast_Ch const& rhs){
    if (
         (lhs.uiMulticast_Ch == rhs.uiMulticast_Ch)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__HD_Radio_Source::tcl_ITM_Meter_Audio__HD_Radio_Source() : 
   eUpdate((tcl_ITM_Meter_Audio__e32_Update_List::tenType)0x00, 0x08),
   eName((tcl_ITM_Meter_Audio__e32_HD_Radio_Source_List::tenType)0x01, 0x08)
{
}

tBool tcl_ITM_Meter_Audio__HD_Radio_Source::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eUpdate.bUpdateData(poMcanMsg);
   if (bRet) bRet = eName.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__HD_Radio_Source::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eUpdate.bUpdateMcanMessage(poMcanMsg);
   eName.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__HD_Radio_Source const& lhs, tcl_ITM_Meter_Audio__HD_Radio_Source const& rhs){
   if (lhs.eUpdate != rhs.eUpdate) return FALSE;
   if (lhs.eName != rhs.eName) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__HD_Radio_Source const& lhs, tcl_ITM_Meter_Audio__HD_Radio_Source const& rhs){
    if (
         (lhs.eUpdate == rhs.eUpdate)
      && (lhs.eName == rhs.eName)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__Instruction::tcl_ITM_Meter_Audio__Instruction() : 
   uiInstruction(0x00, 0x08)
{
}

tBool tcl_ITM_Meter_Audio__Instruction::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = uiInstruction.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__Instruction::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   uiInstruction.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__Instruction const& lhs, tcl_ITM_Meter_Audio__Instruction const& rhs){
   if (lhs.uiInstruction != rhs.uiInstruction) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__Instruction const& lhs, tcl_ITM_Meter_Audio__Instruction const& rhs){
    if (
         (lhs.uiInstruction == rhs.uiInstruction)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__Selected_Source::tcl_ITM_Meter_Audio__Selected_Source() : 
   eSelected_Source((tcl_ITM_Meter_Audio__e32_Selected_Source_List::tenType)0x01, 0x08)
{
}

tBool tcl_ITM_Meter_Audio__Selected_Source::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eSelected_Source.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__Selected_Source::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eSelected_Source.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__Selected_Source const& lhs, tcl_ITM_Meter_Audio__Selected_Source const& rhs){
   if (lhs.eSelected_Source != rhs.eSelected_Source) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__Selected_Source const& lhs, tcl_ITM_Meter_Audio__Selected_Source const& rhs){
    if (
         (lhs.eSelected_Source == rhs.eSelected_Source)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__VR_Info_Type2::tcl_ITM_Meter_Audio__VR_Info_Type2() : 
   eVR_State((tcl_ITM_Meter_Audio__e32_VR_Status_List::tenType)0x00, 0x08),
   eOn_Off((tcl_ITM_Meter_Audio__e32_VR_On_Off_Type2::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_Meter_Audio__VR_Info_Type2::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eVR_State.bUpdateData(poMcanMsg);
   if (bRet) bRet = eOn_Off.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__VR_Info_Type2::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eVR_State.bUpdateMcanMessage(poMcanMsg);
   eOn_Off.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__VR_Info_Type2 const& lhs, tcl_ITM_Meter_Audio__VR_Info_Type2 const& rhs){
   if (lhs.eVR_State != rhs.eVR_State) return FALSE;
   if (lhs.eOn_Off != rhs.eOn_Off) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__VR_Info_Type2 const& lhs, tcl_ITM_Meter_Audio__VR_Info_Type2 const& rhs){
    if (
         (lhs.eVR_State == rhs.eVR_State)
      && (lhs.eOn_Off == rhs.eOn_Off)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__Audio_Source_Kind_Addition::tcl_ITM_Meter_Audio__Audio_Source_Kind_Addition() : 
   eSD((tcl_ITM_Meter_Audio__e32_Available_Connection::tenType)0x00, 0x02),
   eCarPlay((tcl_ITM_Meter_Audio__e32_Available_Connection::tenType)0x00, 0x02),
   eAndroid_Auto((tcl_ITM_Meter_Audio__e32_Available_Connection::tenType)0x00, 0x02),
   emySPIN((tcl_ITM_Meter_Audio__e32_Available_Connection::tenType)0x00, 0x02),
   eCarLife((tcl_ITM_Meter_Audio__e32_Available_Connection::tenType)0x00, 0x02),
   aReserve(NULL, 0x16)
{
}

tBool tcl_ITM_Meter_Audio__Audio_Source_Kind_Addition::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eSD.bUpdateData(poMcanMsg);
   if (bRet) bRet = eCarPlay.bUpdateData(poMcanMsg);
   if (bRet) bRet = eAndroid_Auto.bUpdateData(poMcanMsg);
   if (bRet) bRet = emySPIN.bUpdateData(poMcanMsg);
   if (bRet) bRet = eCarLife.bUpdateData(poMcanMsg);
   if (bRet) bRet = aReserve.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__Audio_Source_Kind_Addition::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eSD.bUpdateMcanMessage(poMcanMsg);
   eCarPlay.bUpdateMcanMessage(poMcanMsg);
   eAndroid_Auto.bUpdateMcanMessage(poMcanMsg);
   emySPIN.bUpdateMcanMessage(poMcanMsg);
   eCarLife.bUpdateMcanMessage(poMcanMsg);
   aReserve.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__Audio_Source_Kind_Addition const& lhs, tcl_ITM_Meter_Audio__Audio_Source_Kind_Addition const& rhs){
   if (lhs.eSD != rhs.eSD) return FALSE;
   if (lhs.eCarPlay != rhs.eCarPlay) return FALSE;
   if (lhs.eAndroid_Auto != rhs.eAndroid_Auto) return FALSE;
   if (lhs.emySPIN != rhs.emySPIN) return FALSE;
   if (lhs.eCarLife != rhs.eCarLife) return FALSE;
   if (lhs.aReserve != rhs.aReserve) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__Audio_Source_Kind_Addition const& lhs, tcl_ITM_Meter_Audio__Audio_Source_Kind_Addition const& rhs){
    if (
         (lhs.eSD == rhs.eSD)
      && (lhs.eCarPlay == rhs.eCarPlay)
      && (lhs.eAndroid_Auto == rhs.eAndroid_Auto)
      && (lhs.emySPIN == rhs.emySPIN)
      && (lhs.eCarLife == rhs.eCarLife)
      && (lhs.aReserve == rhs.aReserve)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__TJP_Dispaly::tcl_ITM_Meter_Audio__TJP_Dispaly() : 
   eTJP_Dispaly((tcl_ITM_Meter_Audio__e32_ON_OFF::tenType)0x00, 0x08)
{
}

tBool tcl_ITM_Meter_Audio__TJP_Dispaly::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eTJP_Dispaly.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__TJP_Dispaly::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eTJP_Dispaly.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__TJP_Dispaly const& lhs, tcl_ITM_Meter_Audio__TJP_Dispaly const& rhs){
   if (lhs.eTJP_Dispaly != rhs.eTJP_Dispaly) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__TJP_Dispaly const& lhs, tcl_ITM_Meter_Audio__TJP_Dispaly const& rhs){
    if (
         (lhs.eTJP_Dispaly == rhs.eTJP_Dispaly)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__Support_Message_List::tcl_ITM_Meter_Audio__Support_Message_List() : 
   eUnit_Change_ITUnit((tcl_ITM_Meter_Audio__e32_Support_Message::tenType)0x00, 0x01),
   eMeter_Language((tcl_ITM_Meter_Audio__e32_Support_Message::tenType)0x00, 0x01),
   eLanguage_Selection_ITUnit((tcl_ITM_Meter_Audio__e32_Support_Message::tenType)0x00, 0x01),
   eRadio((tcl_ITM_Meter_Audio__e32_Support_Message::tenType)0x00, 0x01),
   eInternet_Audio((tcl_ITM_Meter_Audio__e32_Support_Message::tenType)0x00, 0x01),
   eHD_Radio((tcl_ITM_Meter_Audio__e32_Support_Message::tenType)0x00, 0x01),
   eDisc((tcl_ITM_Meter_Audio__e32_Support_Message::tenType)0x00, 0x01),
   eTV((tcl_ITM_Meter_Audio__e32_Support_Message::tenType)0x00, 0x01),
   eAUX((tcl_ITM_Meter_Audio__e32_Support_Message::tenType)0x00, 0x01),
   eAudio_Warning((tcl_ITM_Meter_Audio__e32_Support_Message::tenType)0x00, 0x01),
   eAvailable_Source_Gen2((tcl_ITM_Meter_Audio__e32_Support_Message::tenType)0x00, 0x01),
   eHF((tcl_ITM_Meter_Audio__e32_Support_Message::tenType)0x00, 0x01),
   eCall_Info((tcl_ITM_Meter_Audio__e32_Support_Message_Call::tenType)0x00, 0x01),
   eSMS((tcl_ITM_Meter_Audio__e32_Support_Message::tenType)0x00, 0x01),
   eSMS_Information((tcl_ITM_Meter_Audio__e32_Support_Message_SMS::tenType)0x00, 0x01),
   eVR((tcl_ITM_Meter_Audio__e32_Support_Message::tenType)0x00, 0x01),
   eVR_Content_Info((tcl_ITM_Meter_Audio__e32_Support_Message::tenType)0x00, 0x01),
   aReserve(NULL, 0x3F)
{
}

tBool tcl_ITM_Meter_Audio__Support_Message_List::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eUnit_Change_ITUnit.bUpdateData(poMcanMsg);
   if (bRet) bRet = eMeter_Language.bUpdateData(poMcanMsg);
   if (bRet) bRet = eLanguage_Selection_ITUnit.bUpdateData(poMcanMsg);
   if (bRet) bRet = eRadio.bUpdateData(poMcanMsg);
   if (bRet) bRet = eInternet_Audio.bUpdateData(poMcanMsg);
   if (bRet) bRet = eHD_Radio.bUpdateData(poMcanMsg);
   if (bRet) bRet = eDisc.bUpdateData(poMcanMsg);
   if (bRet) bRet = eTV.bUpdateData(poMcanMsg);
   if (bRet) bRet = eAUX.bUpdateData(poMcanMsg);
   if (bRet) bRet = eAudio_Warning.bUpdateData(poMcanMsg);
   if (bRet) bRet = eAvailable_Source_Gen2.bUpdateData(poMcanMsg);
   if (bRet) bRet = eHF.bUpdateData(poMcanMsg);
   if (bRet) bRet = eCall_Info.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSMS.bUpdateData(poMcanMsg);
   if (bRet) bRet = eSMS_Information.bUpdateData(poMcanMsg);
   if (bRet) bRet = eVR.bUpdateData(poMcanMsg);
   if (bRet) bRet = eVR_Content_Info.bUpdateData(poMcanMsg);
   if (bRet) bRet = aReserve.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__Support_Message_List::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eUnit_Change_ITUnit.bUpdateMcanMessage(poMcanMsg);
   eMeter_Language.bUpdateMcanMessage(poMcanMsg);
   eLanguage_Selection_ITUnit.bUpdateMcanMessage(poMcanMsg);
   eRadio.bUpdateMcanMessage(poMcanMsg);
   eInternet_Audio.bUpdateMcanMessage(poMcanMsg);
   eHD_Radio.bUpdateMcanMessage(poMcanMsg);
   eDisc.bUpdateMcanMessage(poMcanMsg);
   eTV.bUpdateMcanMessage(poMcanMsg);
   eAUX.bUpdateMcanMessage(poMcanMsg);
   eAudio_Warning.bUpdateMcanMessage(poMcanMsg);
   eAvailable_Source_Gen2.bUpdateMcanMessage(poMcanMsg);
   eHF.bUpdateMcanMessage(poMcanMsg);
   eCall_Info.bUpdateMcanMessage(poMcanMsg);
   eSMS.bUpdateMcanMessage(poMcanMsg);
   eSMS_Information.bUpdateMcanMessage(poMcanMsg);
   eVR.bUpdateMcanMessage(poMcanMsg);
   eVR_Content_Info.bUpdateMcanMessage(poMcanMsg);
   aReserve.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__Support_Message_List const& lhs, tcl_ITM_Meter_Audio__Support_Message_List const& rhs){
   if (lhs.eUnit_Change_ITUnit != rhs.eUnit_Change_ITUnit) return FALSE;
   if (lhs.eMeter_Language != rhs.eMeter_Language) return FALSE;
   if (lhs.eLanguage_Selection_ITUnit != rhs.eLanguage_Selection_ITUnit) return FALSE;
   if (lhs.eRadio != rhs.eRadio) return FALSE;
   if (lhs.eInternet_Audio != rhs.eInternet_Audio) return FALSE;
   if (lhs.eHD_Radio != rhs.eHD_Radio) return FALSE;
   if (lhs.eDisc != rhs.eDisc) return FALSE;
   if (lhs.eTV != rhs.eTV) return FALSE;
   if (lhs.eAUX != rhs.eAUX) return FALSE;
   if (lhs.eAudio_Warning != rhs.eAudio_Warning) return FALSE;
   if (lhs.eAvailable_Source_Gen2 != rhs.eAvailable_Source_Gen2) return FALSE;
   if (lhs.eHF != rhs.eHF) return FALSE;
   if (lhs.eCall_Info != rhs.eCall_Info) return FALSE;
   if (lhs.eSMS != rhs.eSMS) return FALSE;
   if (lhs.eSMS_Information != rhs.eSMS_Information) return FALSE;
   if (lhs.eVR != rhs.eVR) return FALSE;
   if (lhs.eVR_Content_Info != rhs.eVR_Content_Info) return FALSE;
   if (lhs.aReserve != rhs.aReserve) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__Support_Message_List const& lhs, tcl_ITM_Meter_Audio__Support_Message_List const& rhs){
    if (
         (lhs.eUnit_Change_ITUnit == rhs.eUnit_Change_ITUnit)
      && (lhs.eMeter_Language == rhs.eMeter_Language)
      && (lhs.eLanguage_Selection_ITUnit == rhs.eLanguage_Selection_ITUnit)
      && (lhs.eRadio == rhs.eRadio)
      && (lhs.eInternet_Audio == rhs.eInternet_Audio)
      && (lhs.eHD_Radio == rhs.eHD_Radio)
      && (lhs.eDisc == rhs.eDisc)
      && (lhs.eTV == rhs.eTV)
      && (lhs.eAUX == rhs.eAUX)
      && (lhs.eAudio_Warning == rhs.eAudio_Warning)
      && (lhs.eAvailable_Source_Gen2 == rhs.eAvailable_Source_Gen2)
      && (lhs.eHF == rhs.eHF)
      && (lhs.eCall_Info == rhs.eCall_Info)
      && (lhs.eSMS == rhs.eSMS)
      && (lhs.eSMS_Information == rhs.eSMS_Information)
      && (lhs.eVR == rhs.eVR)
      && (lhs.eVR_Content_Info == rhs.eVR_Content_Info)
      && (lhs.aReserve == rhs.aReserve)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__Current_Audio_Title::tcl_ITM_Meter_Audio__Current_Audio_Title() : 
   eIcon_Info((tcl_ITM_Meter_Audio__e32_Icon_Info::tenType)0x00, 0x08),
   eCharacter_Set((tcl_ITM_Meter_Audio__e32_Character_Set_List::tenType)0x00, 0x08),
   uiLength(0x01, 0x08),
   vstrText_Body(NULL, 0)
{
}

tBool tcl_ITM_Meter_Audio__Current_Audio_Title::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eIcon_Info.bUpdateData(poMcanMsg);
   if (bRet) bRet = eCharacter_Set.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiLength.bUpdateData(poMcanMsg);

   if (bRet) bRet = vstrText_Body.bUpdateLength(8*uiLength.u32GetData());
   if (bRet) bRet = vstrText_Body.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__Current_Audio_Title::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eIcon_Info.bUpdateMcanMessage(poMcanMsg);
   eCharacter_Set.bUpdateMcanMessage(poMcanMsg);
   uiLength.bUpdateMcanMessage(poMcanMsg);
   vstrText_Body.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__Current_Audio_Title const& lhs, tcl_ITM_Meter_Audio__Current_Audio_Title const& rhs){
   if (lhs.eIcon_Info != rhs.eIcon_Info) return FALSE;
   if (lhs.eCharacter_Set != rhs.eCharacter_Set) return FALSE;
   if (lhs.uiLength != rhs.uiLength) return FALSE;
   if (lhs.vstrText_Body != rhs.vstrText_Body) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__Current_Audio_Title const& lhs, tcl_ITM_Meter_Audio__Current_Audio_Title const& rhs){
    if (
         (lhs.eIcon_Info == rhs.eIcon_Info)
      && (lhs.eCharacter_Set == rhs.eCharacter_Set)
      && (lhs.uiLength == rhs.uiLength)
      && (lhs.vstrText_Body == rhs.vstrText_Body)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__Current_Phone_Call_Name::tcl_ITM_Meter_Audio__Current_Phone_Call_Name() : 
   eCharacter_Set((tcl_ITM_Meter_Audio__e32_Character_Set_List::tenType)0x00, 0x08),
   uiLength(0x01, 0x08),
   vstrText_Body(NULL, 0)
{
}

tBool tcl_ITM_Meter_Audio__Current_Phone_Call_Name::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eCharacter_Set.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiLength.bUpdateData(poMcanMsg);

   if (bRet) bRet = vstrText_Body.bUpdateLength(8*uiLength.u32GetData());
   if (bRet) bRet = vstrText_Body.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__Current_Phone_Call_Name::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eCharacter_Set.bUpdateMcanMessage(poMcanMsg);
   uiLength.bUpdateMcanMessage(poMcanMsg);
   vstrText_Body.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__Current_Phone_Call_Name const& lhs, tcl_ITM_Meter_Audio__Current_Phone_Call_Name const& rhs){
   if (lhs.eCharacter_Set != rhs.eCharacter_Set) return FALSE;
   if (lhs.uiLength != rhs.uiLength) return FALSE;
   if (lhs.vstrText_Body != rhs.vstrText_Body) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__Current_Phone_Call_Name const& lhs, tcl_ITM_Meter_Audio__Current_Phone_Call_Name const& rhs){
    if (
         (lhs.eCharacter_Set == rhs.eCharacter_Set)
      && (lhs.uiLength == rhs.uiLength)
      && (lhs.vstrText_Body == rhs.vstrText_Body)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__Current_Phone_Call_Number::tcl_ITM_Meter_Audio__Current_Phone_Call_Number() : 
   eCharacter_Set((tcl_ITM_Meter_Audio__e32_Character_Set_List::tenType)0x00, 0x08),
   uiLength(0x01, 0x08),
   vstrText_Body(NULL, 0)
{
}

tBool tcl_ITM_Meter_Audio__Current_Phone_Call_Number::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eCharacter_Set.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiLength.bUpdateData(poMcanMsg);

   if (bRet) bRet = vstrText_Body.bUpdateLength(8*uiLength.u32GetData());
   if (bRet) bRet = vstrText_Body.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__Current_Phone_Call_Number::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eCharacter_Set.bUpdateMcanMessage(poMcanMsg);
   uiLength.bUpdateMcanMessage(poMcanMsg);
   vstrText_Body.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__Current_Phone_Call_Number const& lhs, tcl_ITM_Meter_Audio__Current_Phone_Call_Number const& rhs){
   if (lhs.eCharacter_Set != rhs.eCharacter_Set) return FALSE;
   if (lhs.uiLength != rhs.uiLength) return FALSE;
   if (lhs.vstrText_Body != rhs.vstrText_Body) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__Current_Phone_Call_Number const& lhs, tcl_ITM_Meter_Audio__Current_Phone_Call_Number const& rhs){
    if (
         (lhs.eCharacter_Set == rhs.eCharacter_Set)
      && (lhs.uiLength == rhs.uiLength)
      && (lhs.vstrText_Body == rhs.vstrText_Body)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__Secondary_Audio_Info::tcl_ITM_Meter_Audio__Secondary_Audio_Info() : 
   eIcon_Info((tcl_ITM_Meter_Audio__e32_Icon_Info::tenType)0x00, 0x08),
   eCharacter_Set((tcl_ITM_Meter_Audio__e32_Character_Set_List::tenType)0x00, 0x08),
   uiLength(0x01, 0x08),
   vstrText_Body(NULL, 0)
{
}

tBool tcl_ITM_Meter_Audio__Secondary_Audio_Info::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eIcon_Info.bUpdateData(poMcanMsg);
   if (bRet) bRet = eCharacter_Set.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiLength.bUpdateData(poMcanMsg);

   if (bRet) bRet = vstrText_Body.bUpdateLength(8*uiLength.u32GetData());
   if (bRet) bRet = vstrText_Body.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__Secondary_Audio_Info::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eIcon_Info.bUpdateMcanMessage(poMcanMsg);
   eCharacter_Set.bUpdateMcanMessage(poMcanMsg);
   uiLength.bUpdateMcanMessage(poMcanMsg);
   vstrText_Body.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__Secondary_Audio_Info const& lhs, tcl_ITM_Meter_Audio__Secondary_Audio_Info const& rhs){
   if (lhs.eIcon_Info != rhs.eIcon_Info) return FALSE;
   if (lhs.eCharacter_Set != rhs.eCharacter_Set) return FALSE;
   if (lhs.uiLength != rhs.uiLength) return FALSE;
   if (lhs.vstrText_Body != rhs.vstrText_Body) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__Secondary_Audio_Info const& lhs, tcl_ITM_Meter_Audio__Secondary_Audio_Info const& rhs){
    if (
         (lhs.eIcon_Info == rhs.eIcon_Info)
      && (lhs.eCharacter_Set == rhs.eCharacter_Set)
      && (lhs.uiLength == rhs.uiLength)
      && (lhs.vstrText_Body == rhs.vstrText_Body)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

tcl_ITM_Meter_Audio__Pro_Pilot_Setting_List::tcl_ITM_Meter_Audio__Pro_Pilot_Setting_List() : 
   eTJP_Popup((tcl_ITM_Meter_Audio__e32_ON_OFF_Unavailable::tenType)0x00, 0x08),
   eView_Mode_State((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   eView_Mode_Mode_Set_Auto((tcl_ITM_Meter_Audio__e32_ON_OFF_Unavailable::tenType)0x00, 0x02),
   eView_Mode_Mode_Set_Quarter_View((tcl_ITM_Meter_Audio__e32_ON_OFF_Unavailable::tenType)0x00, 0x02),
   eView_Mode_Mode_Set_Plan_View((tcl_ITM_Meter_Audio__e32_ON_OFF_Unavailable::tenType)0x00, 0x02),
   aView_Mode_Mode_Set_Reserve(NULL, 0x11),
   eLane_Change_Popup((tcl_ITM_Meter_Audio__e32_ON_OFF_Unavailable::tenType)0x00, 0x08),
   eView_Scale_State((tcl_ITM_Meter_Audio__e32_Available::tenType)0x00, 0x01),
   uiView_Scale_Max_Scale(0x01, 0x04),
   uiView_Scale_Current_Scale(0x01, 0x04),
   aView_Scale_Reserve(NULL, 0x07),
   aReserve(NULL, 0x18)
{
}

tBool tcl_ITM_Meter_Audio__Pro_Pilot_Setting_List::bExtractInMsg(tclMcanMsgData* poMcanMsg)
{
   tBool bRet = TRUE;

   if (bRet) bRet = eTJP_Popup.bUpdateData(poMcanMsg);
   if (bRet) bRet = eView_Mode_State.bUpdateData(poMcanMsg);
   if (bRet) bRet = eView_Mode_Mode_Set_Auto.bUpdateData(poMcanMsg);
   if (bRet) bRet = eView_Mode_Mode_Set_Quarter_View.bUpdateData(poMcanMsg);
   if (bRet) bRet = eView_Mode_Mode_Set_Plan_View.bUpdateData(poMcanMsg);
   if (bRet) bRet = aView_Mode_Mode_Set_Reserve.bUpdateData(poMcanMsg);
   if (bRet) bRet = eLane_Change_Popup.bUpdateData(poMcanMsg);
   if (bRet) bRet = eView_Scale_State.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiView_Scale_Max_Scale.bUpdateData(poMcanMsg);
   if (bRet) bRet = uiView_Scale_Current_Scale.bUpdateData(poMcanMsg);
   if (bRet) bRet = aView_Scale_Reserve.bUpdateData(poMcanMsg);
   if (bRet) bRet = aReserve.bUpdateData(poMcanMsg);

   return bRet;
}

tVoid tcl_ITM_Meter_Audio__Pro_Pilot_Setting_List::vFillOutMsg(tclMcanMsgData* poMcanMsg)
{
   // stream parameter to out message
   eTJP_Popup.bUpdateMcanMessage(poMcanMsg);
   eView_Mode_State.bUpdateMcanMessage(poMcanMsg);
   eView_Mode_Mode_Set_Auto.bUpdateMcanMessage(poMcanMsg);
   eView_Mode_Mode_Set_Quarter_View.bUpdateMcanMessage(poMcanMsg);
   eView_Mode_Mode_Set_Plan_View.bUpdateMcanMessage(poMcanMsg);
   aView_Mode_Mode_Set_Reserve.bUpdateMcanMessage(poMcanMsg);
   eLane_Change_Popup.bUpdateMcanMessage(poMcanMsg);
   eView_Scale_State.bUpdateMcanMessage(poMcanMsg);
   uiView_Scale_Max_Scale.bUpdateMcanMessage(poMcanMsg);
   uiView_Scale_Current_Scale.bUpdateMcanMessage(poMcanMsg);
   aView_Scale_Reserve.bUpdateMcanMessage(poMcanMsg);
   aReserve.bUpdateMcanMessage(poMcanMsg);

}

tBool operator==(tcl_ITM_Meter_Audio__Pro_Pilot_Setting_List const& lhs, tcl_ITM_Meter_Audio__Pro_Pilot_Setting_List const& rhs){
   if (lhs.eTJP_Popup != rhs.eTJP_Popup) return FALSE;
   if (lhs.eView_Mode_State != rhs.eView_Mode_State) return FALSE;
   if (lhs.eView_Mode_Mode_Set_Auto != rhs.eView_Mode_Mode_Set_Auto) return FALSE;
   if (lhs.eView_Mode_Mode_Set_Quarter_View != rhs.eView_Mode_Mode_Set_Quarter_View) return FALSE;
   if (lhs.eView_Mode_Mode_Set_Plan_View != rhs.eView_Mode_Mode_Set_Plan_View) return FALSE;
   if (lhs.aView_Mode_Mode_Set_Reserve != rhs.aView_Mode_Mode_Set_Reserve) return FALSE;
   if (lhs.eLane_Change_Popup != rhs.eLane_Change_Popup) return FALSE;
   if (lhs.eView_Scale_State != rhs.eView_Scale_State) return FALSE;
   if (lhs.uiView_Scale_Max_Scale != rhs.uiView_Scale_Max_Scale) return FALSE;
   if (lhs.uiView_Scale_Current_Scale != rhs.uiView_Scale_Current_Scale) return FALSE;
   if (lhs.aView_Scale_Reserve != rhs.aView_Scale_Reserve) return FALSE;
   if (lhs.aReserve != rhs.aReserve) return FALSE;
   return TRUE;
}
tBool operator!=(tcl_ITM_Meter_Audio__Pro_Pilot_Setting_List const& lhs, tcl_ITM_Meter_Audio__Pro_Pilot_Setting_List const& rhs){
    if (
         (lhs.eTJP_Popup == rhs.eTJP_Popup)
      && (lhs.eView_Mode_State == rhs.eView_Mode_State)
      && (lhs.eView_Mode_Mode_Set_Auto == rhs.eView_Mode_Mode_Set_Auto)
      && (lhs.eView_Mode_Mode_Set_Quarter_View == rhs.eView_Mode_Mode_Set_Quarter_View)
      && (lhs.eView_Mode_Mode_Set_Plan_View == rhs.eView_Mode_Mode_Set_Plan_View)
      && (lhs.aView_Mode_Mode_Set_Reserve == rhs.aView_Mode_Mode_Set_Reserve)
      && (lhs.eLane_Change_Popup == rhs.eLane_Change_Popup)
      && (lhs.eView_Scale_State == rhs.eView_Scale_State)
      && (lhs.uiView_Scale_Max_Scale == rhs.uiView_Scale_Max_Scale)
      && (lhs.uiView_Scale_Current_Scale == rhs.uiView_Scale_Current_Scale)
      && (lhs.aView_Scale_Reserve == rhs.aView_Scale_Reserve)
      && (lhs.aReserve == rhs.aReserve)

    ) {
        return FALSE;
    }
    
    return TRUE;
}

