#ifndef __MCAN_MESSAGE_CLASS_H_
   #define __MCAN_MESSAGE_CLASS_H_

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"


#define TR_CLASS_FD_CSM_MCAN (TR_COMP_CSM + 16)

class tclMcanMsgData {

public:
    tclMcanMsgData();
    tclMcanMsgData(const tclMcanMsgData &obj); //copy constructor
    ~tclMcanMsgData();

    tBool bClearOutMessage();
    tBool bFillMessage(tU8* pu8Data, tU16 u16ByteLen);
    tU32  u32GetMessage(tU8* pu8Data, tU16 u16ByteLen);

    inline tBool bIsMessageCreated() { return (_pu8DataBuf!=NULL); }

    tBool bGetData(tU32& r32Data, tU16 u16BitSize);
    tBool bGetStreamData(tU8* pu8Data, tU16 u16ByteLen);
    tBool bSetBitStreamData(tU8* pu8Data, tU16 u16BitLen);

    tBool bSetData(tU32 u32Data, tU16 u16BitSize);
    tBool bSetStreamData(tU8* pu8Data, tU16 u16ByteLen);

    inline tU32 u32GetMsgLen() { return _u32CurBytePos; }

    inline tU32 u32GetCurBitPos()     { return _u32CurBitPos; }
    inline tU32 u32GetCurBytePos()    { return _u32CurBytePos; }
    inline tU32 u32GetRemainingBits() { return _u32RemainingBits; }
    
private:

    tBool _bMsgBufferCreated;


    tU32 _u32CurBitPos;
    tU32 _u32CurBytePos;
    tU32 _u32RemainingBits;

    tU8* _pu8DataBuf;
    tU32 _u32DataLen;
};



#endif // __MCAN_MESSAGE_CLASS_H_
