#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#include "mcanMsg.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FD_CSM_MCAN
#include "trcGenProj/Header/mcanMsg.cpp.trc.h"
#endif

tclMcanMsgData::tclMcanMsgData():
_u32CurBitPos(0),
_u32CurBytePos(0),
_u32RemainingBits(0),
_pu8DataBuf(NULL),
_u32DataLen(0)
{
}

tclMcanMsgData::tclMcanMsgData(const tclMcanMsgData &obj)
{
	_u32CurBitPos = obj._u32CurBitPos;
	_u32CurBytePos = obj._u32CurBytePos;
	_u32RemainingBits = obj._u32RemainingBits;
	_u32DataLen = obj._u32DataLen;
	if (obj._pu8DataBuf != NULL) {
        _pu8DataBuf = new tU8[_u32DataLen];
        memcpy(_pu8DataBuf, obj._pu8DataBuf, _u32DataLen);
	}
}

tclMcanMsgData::~tclMcanMsgData() {
    ETG_TRACE_USR4(("tclMcanMsgData::~tclMcanMsgData(): %08x, %d", _pu8DataBuf, _u32DataLen));
    if (_pu8DataBuf != NULL) {
        //delete buffer
        delete[] _pu8DataBuf;
        
        _pu8DataBuf = NULL;
    }
}

tBool tclMcanMsgData::bClearOutMessage() {
    tBool bRet = FALSE;

    if (_pu8DataBuf != NULL) {
        //delete buffer
        delete[] _pu8DataBuf;

        _pu8DataBuf = NULL;

    }

    if (_pu8DataBuf == NULL) {
        //create buffer for message
        _pu8DataBuf = new tU8[1000];

        if (_pu8DataBuf != NULL) {
            _u32DataLen = 1000;
            _u32CurBitPos = 7;
            _u32CurBytePos = 0;
            _u32RemainingBits = _u32DataLen * 8;
            memset(_pu8DataBuf, 0, 1000);

            bRet = TRUE;
        }
    }

    return bRet;
}

tBool tclMcanMsgData::bFillMessage(tU8* pu8Data, tU16 u16ByteLen) {
    tBool bRet = FALSE;

    ETG_TRACE_USR4(("tclMcanMsgData::bFillMessage(): %08x, %*x", _pu8DataBuf, ETG_LIST_LEN(u16ByteLen), ETG_LIST_PTR_T8((tU8*)pu8Data)));
    if (_pu8DataBuf != NULL) {
        //delete buffer
        delete[] _pu8DataBuf;

        _pu8DataBuf = NULL;

    }

    //ETG_TRACE_FATAL(("tclMcanMsgData::bFillMessage(): %08x, %*x", _pu8DataBuf, ETG_LIST_LEN(u16ByteLen), ETG_LIST_PTR_T8((tU8*)pu8Data)));
    if (_pu8DataBuf == NULL) {
        //create buffer for message
        _pu8DataBuf = new tU8[u16ByteLen];

        //ETG_TRACE_FATAL(("tclMcanMsgData::bFillMessage(): %08x, %d, %*x", _pu8DataBuf, _u32DataLen, ETG_LIST_LEN(u16ByteLen), ETG_LIST_PTR_T8((tU8*)pu8Data)));
        if (_pu8DataBuf != NULL) {
            _u32DataLen = u16ByteLen;
            _u32CurBitPos = 7;
            _u32CurBytePos = 0;
            _u32RemainingBits = _u32DataLen * 8;

            memcpy(_pu8DataBuf, pu8Data, u16ByteLen);

            //ETG_TRACE_FATAL(("tclMcanMsgData::bFillMessage(): %*x", ETG_LIST_LEN(u16ByteLen), ETG_LIST_PTR_T8((tU8*)_pu8DataBuf)));

            bRet = TRUE;
        }
    }

    return bRet;
}

tU32 tclMcanMsgData::u32GetMessage(tU8* pu8Data, tU16 u16ByteLen) {

	tU32 u32Ret = 0;
    if ((_pu8DataBuf != NULL) && (u16ByteLen >= _u32CurBytePos)) {
    	memcpy(pu8Data, _pu8DataBuf, _u32CurBytePos);
    	ETG_TRACE_USR1(("tclMcanMsgData::bGetMessage(): %*x", ETG_LIST_LEN(_u32CurBytePos), ETG_LIST_PTR_T8((tU8*)pu8Data)));
    	u32Ret = _u32CurBytePos;
    }

    return u32Ret;
}


tBool tclMcanMsgData::bGetData(tU32& r32Data, tU16 u16BitSize) {
    tBool bRet = FALSE;
    if (u16BitSize <= _u32RemainingBits) {
        r32Data = 0;
      
        if ( (_u32CurBitPos==7) &&  ((u16BitSize%8) == 0) ) {
            if (u16BitSize == 8) {
                r32Data = _pu8DataBuf[_u32CurBytePos++];
            } else if (u16BitSize == 16) {
                r32Data  = _pu8DataBuf[_u32CurBytePos++] << 8;
                r32Data |= _pu8DataBuf[_u32CurBytePos++] << 0;
            } else if (u16BitSize == 24) {
                r32Data  = _pu8DataBuf[_u32CurBytePos++] << 16;
                r32Data |= _pu8DataBuf[_u32CurBytePos++] << 8;
                r32Data |= _pu8DataBuf[_u32CurBytePos++] << 0;
            } else if (u16BitSize == 32) {
                r32Data  = _pu8DataBuf[_u32CurBytePos++] << 24;
                r32Data |= _pu8DataBuf[_u32CurBytePos++] << 16;
                r32Data |= _pu8DataBuf[_u32CurBytePos++] << 8;
                r32Data |= _pu8DataBuf[_u32CurBytePos++] << 0;
            }
        } else {
            for (tU16 i=0; i<u16BitSize;i++) {
                r32Data = r32Data << 1;
                r32Data |= ((1 << _u32CurBitPos) & _pu8DataBuf[_u32CurBytePos]) >> _u32CurBitPos;
  
                if (_u32CurBitPos == 0) {
                    _u32CurBytePos++;
                    _u32CurBitPos = 7;
                } else {
                    _u32CurBitPos--;
                }
            }
        }
        _u32RemainingBits -= u16BitSize;
        bRet = TRUE;
        ETG_TRACE_USR4(("tclMcanMsgData::bGetData(): 0x%08X", r32Data));
    } else {
        ETG_TRACE_FATAL(("tclMcanMsgData::bGetData(): FAILED; reqBits=%d remBits=%d",u16BitSize,_u32RemainingBits));
    }
    return bRet;

}

tBool tclMcanMsgData::bGetStreamData(tU8* pu8Data, tU16 u16ByteLen){

    tBool bRet = FALSE;
    if ((_u32CurBitPos==7) && (8*u16ByteLen<=_u32RemainingBits) && (NULL != pu8Data)) {
        if (NULL != pu8Data) {
            for (tU16 i=0; i<u16ByteLen; i++) {
                pu8Data[i] = _pu8DataBuf[_u32CurBytePos+i];
            }
        }
        _u32CurBytePos    += u16ByteLen;
        _u32RemainingBits -= 8*u16ByteLen;

        ETG_TRACE_USR4(("tclMcanMsgData::bGetStreamData(): %*x", ETG_LIST_LEN(u16ByteLen), ETG_LIST_PTR_T8((tU8*)pu8Data)));
        bRet = TRUE;
    } else {
        ETG_TRACE_FATAL(("tclMcanMsgData::bGetStreamData(): FAILED; reqBits=%d remBits=%d bitPos=%d buf=0x%08X",8*u16ByteLen,_u32RemainingBits,_u32CurBitPos,pu8Data));
    }
    return bRet;

}

tBool tclMcanMsgData::bSetData(tU32 u32Data, tU16 u16BitSize) {

    ETG_TRACE_USR4(("tclMcanMsgData::bSetData(): %x (%d)", u32Data, u16BitSize));

    if ( (_u32CurBitPos==7) &&  ((u16BitSize%8) == 0) ) {
        if (u16BitSize == 8) {
            _pu8DataBuf[_u32CurBytePos++] = (u32Data & 0x000000ff);
        } else if (u16BitSize == 16) {
            _pu8DataBuf[_u32CurBytePos++] = (u32Data & 0x0000ff00) >> 8;
            _pu8DataBuf[_u32CurBytePos++] = (u32Data & 0x000000ff);
        } else if (u16BitSize == 24) {
            _pu8DataBuf[_u32CurBytePos++] = (u32Data & 0x00ff0000) >> 16;
            _pu8DataBuf[_u32CurBytePos++] = (u32Data & 0x0000ff00) >> 8;
            _pu8DataBuf[_u32CurBytePos++] = (u32Data & 0x000000ff);
        } else if (u16BitSize == 32) {
            _pu8DataBuf[_u32CurBytePos++] = (u32Data & 0xff000000) >> 24;
            _pu8DataBuf[_u32CurBytePos++] = (u32Data & 0x00ff0000) >> 16;
            _pu8DataBuf[_u32CurBytePos++] = (u32Data & 0x0000ff00) >> 8;
            _pu8DataBuf[_u32CurBytePos++] = (u32Data & 0x000000ff);
        }
    } else {
        for (tU16 i=0; i<u16BitSize;i++) {
            _pu8DataBuf[_u32CurBytePos] &= ~(1 << _u32CurBitPos);
            tU8 u8CurBit = (u32Data>>((u16BitSize-i)-1));

            _pu8DataBuf[_u32CurBytePos] |= (u8CurBit << _u32CurBitPos);

            if (_u32CurBitPos == 0) {
                _u32CurBytePos++;
                _u32CurBitPos = 7;
            } else {
                _u32CurBitPos--;
            }
        }
    }

    return TRUE;
}

tBool tclMcanMsgData::bSetBitStreamData(tU8* pu8Data, tU16 u16BitLen){

    tBool bRet = FALSE;

    if (pu8Data != NULL) {
        if (u16BitLen%8 == 0) {
            bRet = bSetStreamData(pu8Data, u16BitLen/8);
        } else {
            tU8 u8RemainingBits = u16BitLen;
            tU8* pCurData = pu8Data;
            while (u8RemainingBits >= 8) {
                bRet = bSetData((tU32)pCurData[0], 8);
                pCurData++;
                u8RemainingBits -= 8;
            }
            if (u8RemainingBits > 0) {
                bRet = bSetData((tU32)pu8Data[0], u8RemainingBits);
            }
        }
    }

    return bRet;
}

tBool tclMcanMsgData::bSetStreamData(tU8* pu8Data, tU16 u16ByteLen){

    tBool bRet = FALSE;
    if (pu8Data != NULL) {
        ETG_TRACE_USR4(("tclMcanMsgData::bSetStreamData(): %d, %*x", u16ByteLen, ETG_LIST_LEN(u16ByteLen), ETG_LIST_PTR_T8((tU8*)pu8Data)));
        if (_u32CurBitPos==7) {
            for (tU16 i=0; i<u16ByteLen;i++) {
                _pu8DataBuf[_u32CurBytePos++] = pu8Data[i];
            }
            bRet = TRUE;
        } else {
            ETG_TRACE_FATAL(("tclMcanMsgData::bSetStreamData(): FAILED"));
        }
    } else {
        ETG_TRACE_FATAL(("tclMcanMsgData::bSetStreamData(): FAILED"));
    }
    return bRet;
}


