#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC		   
#include "osal_if.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tclSrvIf.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
    #define ETG_DEFAULT_TRACE_CLASS DP_FI_TRACE_CLASS
    #include "trcGenProj/Header/dp_tclSrvInterface.cpp.trc.h"
#endif

dp_tclSrvIf::~dp_tclSrvIf() 
{
}
//trace functions
tVoid dp_tclSrvIf::vTracePoolElement() const 
{   
   DP_vTracePoolElement(0xffffffff);
   vTraceNonPoolElements();
}
tVoid dp_tclSrvIf::vTracePoolElement(tU32 u32PoolId) const 
{
   DP_vTracePoolElement(u32PoolId);
   vTraceNonPoolElements(u32PoolId);
}
tVoid dp_tclSrvIf::vTracePoolElementByName(const tChar* pcName) const 
{
   DP_vTracePoolElementByName(pcName);
}
tVoid dp_tclSrvIf::vTracePoolHistory() const 
{
   DP_vTracePoolHistory();
}
//spm,diagnose functions for store, set to default, set/update all coding data, calc hash
tS32 dp_tclSrvIf::s32StoreNow(tU32 u32Timeout) const 
{
   return DP_s32StoreNow(_u16AccessId, u32Timeout);
}
tS32 dp_tclSrvIf::s32SetDefault(tU32 u32DefType, tU32 u32Timeout) const 
{
   return DP_s32SetDefault(_u16AccessId, u32DefType, u32Timeout);
}
tS32 dp_tclSrvIf::s32SetConfig(tU32 u32PoolId, tU32 u32Timeout) const 
{
   return DP_s32SetConfig(u32PoolId,_u16AccessId, u32Timeout);
}

tS32 dp_tclSrvIf::s32CalcHash(tU32* pu32Data, tU32 u32DataLen, tU32 u32Timeout) const 
{
   return DP_s32CalcHash(pu32Data, u32DataLen, _u16AccessId, u32Timeout);
}
//store pool now
tS32 dp_tclSrvIf::s32StorePoolNow(tU32 u32PoolId) const
{
   return DP_s32StorePoolNow(u32PoolId,_u16AccessId);
}

//spm,diagnose and usermanager functions for lock and unlock pool
tS32 dp_tclSrvIf::s32Lock(tU32 u32LockType, tU32 u32Timeout) const 
{
   return DP_s32Lock(_u16AccessId, u32LockType, u32Timeout);
}
tS32 dp_tclSrvIf::s32Unlock(tU32 u32Timeout) const 
{
   return DP_s32Unlock(_u16AccessId, u32Timeout);
}
// user manager functions for manage end user and this banks
tS32 dp_tclSrvIf::s32SetEndUser(tU8 u8EndUser) const 
{
   return DP_s32SetEndUser(u8EndUser,_u16AccessId);
}
tS32 dp_tclSrvIf::s32GetEndUser(tU8& u8EndUser) const 
{
   return DP_s32GetEndUser(u8EndUser);
}
tS32 dp_tclSrvIf::s32CopyEndUser(tU8 u8EndUserFrom,tU8 u8EndUserTo,tU32 u32Timeout) const 
{
   return DP_s32CopyEndUser(u8EndUserFrom,u8EndUserTo,_u16AccessId,u32Timeout);
}
tS32 dp_tclSrvIf::s32LoadBankToCurrentEndUser(tU8 u8Bank, tU32 u32Timeout) const
{
  return DP_s32LoadBankToCurrentEndUser(u8Bank,_u16AccessId,u32Timeout);
}
tS32 dp_tclSrvIf::s32SaveCurrentEndUserToBank(tU8 u8Bank, tU32 u32Timeout) const
{
  return DP_s32SaveCurrentEndUserToBank(u8Bank, _u16AccessId, u32Timeout);
}
tS32 dp_tclSrvIf::s32GetBank(tU8& u8Bank) const
{
  return DP_s32GetBank(u8Bank);
}
tS32 dp_tclSrvIf::s32SetEndUserDefault(tU8 u8EndUser,tU32 u32Timeout) const 
{
   return DP_s32SetEndUserDefault(u8EndUser,_u16AccessId, u32Timeout);
}
tS32 dp_tclSrvIf::s32SetBankDefault(tU8 u8Bank, tU32 u32Timeout) const
{
  return DP_s32SetBankDefault(u8Bank,_u16AccessId, u32Timeout);
}


tVoid dp_tclSrvIf::vTraceNonPoolElements(tU32 u32PoolId) const {
    OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(u32PoolId);
}

//EOF
