/******************************************************************************
* FILE:         db.cpp
* PROJECT:      
* SW-COMPONENT: datapool
*------------------------------------------------------------------------------
*
* DESCRIPTION: 
*              
*------------------------------------------------------------------------------
* COPYRIGHT:    (c) 2011 Robert Bosch GmbH, Hildesheim
* HISTORY:      
* Date      | Author             | Modification
* 24.10.11  | CM-AI/VW32 kollai  | initial version
*
*******************************************************************************/
#define OSAL_S_IMPORT_INTERFACE_GENERIC		   
#include "osal_if.h"


#include "dpElementContext.h"

// --Konstruktor
dp_tclStreamCtxt::dp_tclStreamCtxt(tU8* const pu8Start):
pu8StartPosition(pu8Start),pu8EndPosition(pu8StartPosition+4), pu8Position(pu8Start),bContextIsValid(TRUE) 
{
   //endposition is minimum pu8StartPosition+4 for element length
};

dp_tclOutStreamCtxt::dp_tclOutStreamCtxt(tU8* const pu8Start, tU32 u32Len): dp_tclStreamCtxt(pu8Start) 
{
  pu8Position+=u32WriteAt((tVoid*)&u32Len,sizeof(tU32));
  pu8EndPosition = pu8StartPosition + u32Len;
}

tU32 dp_tclOutStreamCtxt::u32WriteAt(tVoid* pData, tU32 u32Len) {

   if (pu8Position+u32Len<=pu8EndPosition)
   {
      memmove(pu8Position, pData, u32Len);
   }
   else
   {
      u32Len=0;
      Invalidate();
   }
   return u32Len;
}

dp_tclOutStreamCtxt& dp_tclOutStreamCtxt::oWrite(tU8 u8Value) {
  pu8Position+=u32WriteAt((tVoid*)&u8Value, sizeof(tU8));
  return *this;
}

dp_tclOutStreamCtxt& dp_tclOutStreamCtxt::oWrite(tU16 u16Value) {
  pu8Position+=u32WriteAt((tVoid*)&u16Value, sizeof(tU16));
  return *this;
}

dp_tclOutStreamCtxt& dp_tclOutStreamCtxt::oWrite(tU32 u32Value) {
  pu8Position+=u32WriteAt((tVoid*)&u32Value,sizeof(tU32));
  return *this;
}

dp_tclOutStreamCtxt& dp_tclOutStreamCtxt::oWrite(tS32 s32Value) {
  pu8Position+=u32WriteAt((tVoid*)&s32Value,sizeof(tS32));
  return *this;
}

dp_tclOutStreamCtxt& dp_tclOutStreamCtxt::oWrite(tString strValue) {
  pu8Position+=u32WriteAt((tVoid*)strValue,((tU32)strlen(strValue)+1));
  return *this;
}

dp_tclOutStreamCtxt& dp_tclOutStreamCtxt::oWrite(dpCtxtElemWrite* pRef) {
  pu8Position+=u32WriteAt((tVoid*)&pRef->u32Len, sizeof(tU32));
  pu8Position+=u32WriteAt(pRef->pData, pRef->u32Len);
  return *this;
}


dp_tclOutStreamCtxt& dp_tclOutStreamCtxt::operator<<(tU8 u8Value) {
  return oWrite(u8Value);
}

dp_tclOutStreamCtxt& dp_tclOutStreamCtxt::operator<<(tU16 u16Value) {
  return oWrite(u16Value);
}

dp_tclOutStreamCtxt& dp_tclOutStreamCtxt::operator<<(tU32 u32Value) {
  return oWrite(u32Value);
}

dp_tclOutStreamCtxt& dp_tclOutStreamCtxt::operator<<(tS32 s32Value) {
  return oWrite(s32Value);
}

dp_tclOutStreamCtxt& dp_tclOutStreamCtxt::operator<<(tString strValue) {
  return oWrite(strValue);
}

dp_tclOutStreamCtxt& dp_tclOutStreamCtxt::operator<<(dpCtxtElemWrite* pRef) {
  return oWrite(pRef);
}


dp_tclInStreamCtxt::dp_tclInStreamCtxt(tU8* const pu8Start): dp_tclStreamCtxt(pu8Start) 
{
   tU32 u32Len = 0;
   //first get length of element
   pu8Position+=u32ReadAt((tVoid*)&u32Len, sizeof(tU32));
   pu8EndPosition = pu8StartPosition + u32Len;
}

tU32 dp_tclInStreamCtxt::u32ReadAt(tVoid* pData, tU32 u32Len)
{
  if (pu8Position+u32Len<=pu8EndPosition) 
  {
      memmove(pData, pu8Position, u32Len);
  } 
  else
  {
    u32Len=0;
    Invalidate();
  }
  return u32Len;
}
dp_tclInStreamCtxt& dp_tclInStreamCtxt::oRead(tU8& u8Value) {
  // --Lese vom Ende
  pu8Position+=u32ReadAt((tVoid*)&u8Value, sizeof(tU8));
  return *this;
}

dp_tclInStreamCtxt& dp_tclInStreamCtxt::oRead(tU16& u16Value) {
  // --Lese vom Ende
  pu8Position+=u32ReadAt((tVoid*)&u16Value, sizeof(tU16));
  return *this;
}

dp_tclInStreamCtxt& dp_tclInStreamCtxt::oRead(tU32& u32Value) {
  // --Lese vom Ende
  pu8Position+=u32ReadAt((tVoid*)&u32Value, sizeof(tU32));
  return *this;
}

dp_tclInStreamCtxt& dp_tclInStreamCtxt::oRead(tS32& s32Value) {
  // --Lese vom Ende
  pu8Position+=u32ReadAt((tVoid*)&s32Value, sizeof(tS32));
  return *this;
}

dp_tclInStreamCtxt& dp_tclInStreamCtxt::oRead(tString strValue) {
  // --Lese vom Ende
  pu8Position+=u32ReadAt((tVoid*)strValue, ((tU32)strlen((tChar*)pu8Position))+1);
  return *this;
}

dp_tclInStreamCtxt& dp_tclInStreamCtxt::oRead(dpCtxtElemRead* pRef) {

  pu8Position+=u32ReadAt((tVoid*)pRef->pu32Len, sizeof(tU32));
  if (pRef->pData == NULL) {
  } else 
  {
     tU8* pu8Buf;
    try
    {
        pu8Buf = new tU8[*pRef->pu32Len];
    }
    catch(const std::bad_alloc&)
    {
        pu8Buf = NULL;
    }
    if(pu8Buf)
    {
        pu8Position+=u32ReadAt(pu8Buf, *pRef->pu32Len);
        *pRef->pData = (tVoid*)pu8Buf;
    }
  }
  return *this;
}

dp_tclInStreamCtxt& dp_tclInStreamCtxt::operator>>(tU8& u8Value) {
  return oRead(u8Value);
}

dp_tclInStreamCtxt& dp_tclInStreamCtxt::operator>>(tU16& u16Value) {
  return oRead(u16Value);
}

dp_tclInStreamCtxt& dp_tclInStreamCtxt::operator>>(tU32& u32Value) {
  return oRead(u32Value);
}

dp_tclInStreamCtxt& dp_tclInStreamCtxt::operator>>(tS32& s32Value) {
  return oRead(s32Value);
}

dp_tclInStreamCtxt& dp_tclInStreamCtxt::operator>>(tString strValue) {
  return oRead(strValue);
}

dp_tclInStreamCtxt& dp_tclInStreamCtxt::operator>>(dpCtxtElemRead* pRef) {
  return oRead(pRef);
}

//EOF

