/******************************************************************************
* FILE:         db.cpp
* PROJECT:      
* SW-COMPONENT: datapool
*------------------------------------------------------------------------------
*
* DESCRIPTION: 
*              
*------------------------------------------------------------------------------
* COPYRIGHT:    (c) 2005 Robert Bosch GmbH, Hildesheim
* HISTORY:      
* Date      | Author             | Modification
* 24.10.11  | CM-AI/VW32 kollai  | initial version
*
*******************************************************************************/
#define OSAL_S_IMPORT_INTERFACE_GENERIC		   
#include "osal_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#define DP_ELEM_TRACE_CLASS              (tU16)(TR_COMP_DATAPOOL + 0x02) 

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_generic_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS DP_ELEM_TRACE_CLASS
#include "trcGenProj/Header/dpBaseElement.cpp.trc.h"
#endif

dp_tclBaseElement::~dp_tclBaseElement() {

   ETG_TRACE_USR4(("dp_tclBaseElement(): destruct element (buffer to delete: %08x,%08x) '%s'!",_pDataBuffer, _pDefaultDataBuffer, _strElementName));

   if (NULL != _pDataBuffer) 
   {
      delete[] _pDataBuffer;
      _pDataBuffer = NULL;
   }
   if (NULL != _pDefaultDataBuffer) 
   {
      delete[] _pDefaultDataBuffer;
      _pDefaultDataBuffer = NULL;
   }   
   if (_pCallbackList != NULL) 
   {
      ETG_TRACE_USR4(("dp_tclBaseElement(): delete NotCallbackList for element '%s'!", _strElementName));
      delete _pCallbackList;
      _pCallbackList=NULL;
   }

   #ifdef DP_U32_POOL_ID_DPENDUSERMODE 
   _oInitBankKdsAccessList.clear();
   #endif
   _bNotify = FALSE;
   _s32Hash = 0;
}

dp_tclBaseElement::dp_tclBaseElement(){

   memset(_strElementName, 0, DP_MAX_LEN_NAME_ELEMENT);

   _pConfCallBack = NULL;

   _tProperty.u8Version = 0;
   _tProperty.u32StoringIntervall = 0;
   _tProperty.u16AccessType = DP_U8_ACCESS_PRIVATE;
   _tProperty.tElemType = eDpElementTypeRuntime;
   _tProperty.tStoringType = eDpStoringTypeNone;
   _tProperty.bValidated = FALSE;
   _tProperty.bRestore = FALSE;
   _tProperty.bVarSize = FALSE;
   _tProperty.bExport2Registry = FALSE;
   _tProperty.u8VarType = DP_TYPE_STRUCT;
   _tProperty.u32NextStoreTime = DP_U8_NOTHING_TO_STORE_TIME;
   _tProperty.tDefsetType = eDpDefSetNone;
   _tProperty.u32DefSetMode= 0;
   _tProperty.tElemState = eDpElemInit;
   
   _u32DataLength = 0;
   _u32DefDataLength = 0;
   _pDataBuffer = NULL;
   _pDefaultDataBuffer = NULL;

   _u32RdAccessCount = 0;
   _u32WrAccessCount = 0;

   _pCallbackList = NULL;
   #ifdef DP_U32_POOL_ID_DPENDUSERMODE
   _oInitBankKdsAccessList.clear();
   #endif

   _bNotify = FALSE;
   _s32Hash = 0;
}


dp_tclBaseElement::dp_tclBaseElement(const tChar* pcElementName, tS32 s32Hash){

   memset(_strElementName, 0, DP_MAX_LEN_NAME_ELEMENT);
   strncpy(_strElementName, pcElementName,DP_MAX_LEN_NAME_ELEMENT);
   _strElementName[DP_MAX_LEN_NAME_ELEMENT-1]='\0';

   _pConfCallBack = NULL;

   _tProperty.u8Version = 0;
   _tProperty.u32StoringIntervall = 0;
   _tProperty.u16AccessType = DP_U8_ACCESS_PRIVATE;
   _tProperty.tElemType = eDpElementTypeRuntime;
   _tProperty.tStoringType = eDpStoringTypeNone;
   _tProperty.bValidated = FALSE;
   _tProperty.bRestore = FALSE;
   _tProperty.bVarSize = FALSE;
   _tProperty.bExport2Registry = FALSE;
   _tProperty.u8VarType = DP_TYPE_STRUCT;
   _tProperty.u32NextStoreTime = DP_U8_NOTHING_TO_STORE_TIME;
   _tProperty.tDefsetType = eDpDefSetNone;
   _tProperty.u32DefSetMode= 0;
   _tProperty.tElemState = eDpElemInit;
   

   _u32DataLength = 0;
   _u32DefDataLength = 0;
   _pDataBuffer = NULL;
   _pDefaultDataBuffer = NULL;

   _u32RdAccessCount = 0;
   _u32WrAccessCount = 0;

   _pCallbackList = NULL;
   #ifdef DP_U32_POOL_ID_DPENDUSERMODE
   _oInitBankKdsAccessList.clear();
   #endif

   _bNotify = FALSE;
   if (s32Hash == 0) {
      _s32Hash = s32CalcHash(_strElementName);
   } else {
      _s32Hash = s32Hash;
   }

   ETG_TRACE_USR4(("dp_tclBaseElement(): Empty element '%s' created !",_strElementName));

}
dp_tclBaseElement::dp_tclBaseElement(
      const tChar*    pcElementName, 
      tU8             u8Version,
      tU16            u16ElementLength,
      tBool           bVarSize,
      tU16            u16AccessType, 
      EDpElementTypes tElemType, 
      EDpStoringTypes tStoringType, 
      tU32            u32StoringIntervall,
      tU32            u32DefSetMode)
{
   memset(_strElementName, 0, DP_MAX_LEN_NAME_ELEMENT);
   if(pcElementName!=NULL)
   {
     strncpy(_strElementName, pcElementName,DP_MAX_LEN_NAME_ELEMENT);
     _strElementName[DP_MAX_LEN_NAME_ELEMENT-1]='\0';
   }

   _pConfCallBack = NULL;

   _tProperty.u8Version = u8Version;
   _tProperty.u32StoringIntervall = u32StoringIntervall;
   _tProperty.u16AccessType = u16AccessType;
   _tProperty.tElemType = tElemType;
   _tProperty.tStoringType = tStoringType;
   _tProperty.bRestore = FALSE;
   _tProperty.bVarSize = bVarSize;
   _tProperty.bExport2Registry = FALSE;
   _tProperty.u8VarType = DP_TYPE_U8;
   _tProperty.tDefsetType = eDpDefSetNone;
   _tProperty.u32NextStoreTime = DP_U8_NOTHING_TO_STORE_TIME;
   _tProperty.u32DefSetMode= u32DefSetMode;
   _tProperty.tElemState = eDpElemInit;

   _s32Hash = s32CalcHash(_strElementName);
   _bNotify = FALSE;

   _pCallbackList = NULL;
   #ifdef DP_U32_POOL_ID_DPENDUSERMODE
   _oInitBankKdsAccessList.clear();
   #endif

   if (_tProperty.tStoringType != eDpStoringTypeNone) {
      _tProperty.bValidated = FALSE;
   } else {
      _tProperty.bValidated = TRUE;
   }

   _u32DataLength = u16ElementLength;
   _pDataBuffer = NULL;
   _pDefaultDataBuffer = NULL;
   _u32DefDataLength = 0;

   _u32RdAccessCount = 0;
   _u32WrAccessCount = 0;

    if (_u32DataLength) 
    {
        try
        {
          _pDataBuffer = new tU8[_u32DataLength];
          _pDefaultDataBuffer = new tU8[_u32DataLength];
        }
        catch(const std::bad_alloc&)
        {
           _pDataBuffer = NULL;
           _pDefaultDataBuffer = NULL;
        }
        if ((_pDataBuffer!=NULL)&&(_pDefaultDataBuffer!=NULL))
        {
            memset(_pDataBuffer, 0, _u32DataLength);
            memset(_pDefaultDataBuffer, 0, _u32DataLength);
        }
        else
        {
            ETG_TRACE_ERR(("dp_tclBaseElement(): %d length undef element '%s' Creation Error !",_u32DataLength, _strElementName));
        }
    }
    ETG_TRACE_USR4(("dp_tclBaseElement(): undef element '%s' created !",_strElementName));
}

dp_tclBaseElement::dp_tclBaseElement(
                                     const tChar* pcElementName, 
                                     tU8 u8Version,
                                     tS32 s32Hash,
                                     tU16 u16ElementLength,
                                     tBool bVarSize,
                                     tU16 u16AccessType, 
                                     EDpElementTypes tElemType, 
                                     EDpStoringTypes tStoringType, 
                                     tU32 u32StoringIntervall,
                                     tBool bExport2Reg,
                                     tU8 u8VarType,
                                     tU32 u32DefSetMode)
{
   memset(_strElementName, 0, DP_MAX_LEN_NAME_ELEMENT);
   strncpy(_strElementName, pcElementName,DP_MAX_LEN_NAME_ELEMENT);
   _strElementName[DP_MAX_LEN_NAME_ELEMENT-1]='\0';

   _pConfCallBack = NULL;

   _tProperty.u8Version = u8Version;
   _tProperty.u32StoringIntervall = u32StoringIntervall;
   _tProperty.u16AccessType = u16AccessType;
   _tProperty.tElemType = tElemType;
   _tProperty.tStoringType = tStoringType;
   _tProperty.bRestore = FALSE;
   _tProperty.bVarSize = bVarSize;
   _tProperty.bExport2Registry = bExport2Reg;
   _tProperty.u8VarType = u8VarType;
   _tProperty.tDefsetType = eDpDefSetNone;
   _tProperty.u32DefSetMode = u32DefSetMode;
   _tProperty.u32NextStoreTime = DP_U8_NOTHING_TO_STORE_TIME;
   _tProperty.tElemState = eDpElemInit;


   if (s32Hash == 0) {
      _s32Hash = s32CalcHash(_strElementName);
   } else {
      _s32Hash = s32Hash;
   }

   _bNotify = FALSE;

   _pCallbackList = NULL;
   #ifdef DP_U32_POOL_ID_DPENDUSERMODE
   _oInitBankKdsAccessList.clear();
   #endif

   if (_tProperty.tStoringType != eDpStoringTypeNone) {
      _tProperty.bValidated = FALSE;
   } else {
      _tProperty.bValidated = TRUE;
   }

   _u32DataLength = u16ElementLength;
   if (bVarSize){
      // length is with writing first element in buffer
      _u32DataLength = 0;
   }
   _pDataBuffer = NULL;
   _pDefaultDataBuffer = NULL;
   _u32DefDataLength = 0;

   _u32RdAccessCount = 0;
   _u32WrAccessCount = 0;

   if (_u32DataLength) 
   {
        try
        {
             _pDataBuffer = new tU8[_u32DataLength];
             _pDefaultDataBuffer = new tU8[_u32DataLength];
        }
        catch(const std::bad_alloc&)
        {
              _pDataBuffer = NULL;
              _pDefaultDataBuffer = NULL;
        }
        if((_pDataBuffer!=NULL)&&(_pDefaultDataBuffer!=NULL))
        {
            memset(_pDataBuffer, 0, _u32DataLength);
            memset(_pDefaultDataBuffer, 0, _u32DataLength);
        }
        else
            ETG_TRACE_FATAL(("dp_tclBaseElement(): %d length full element '%s' Creation Error !",_u32DataLength, _strElementName));
   }
   ETG_TRACE_USR4(("dp_tclBaseElement(): full element '%s' created !",_strElementName));

}

dp_tclBaseElement::dp_tclBaseElement(const dp_tclBaseElement& oDpElem) {

   _pDataBuffer = NULL;
   _pDefaultDataBuffer = NULL;
   _u32DefDataLength = 0;

   _pConfCallBack = NULL;

   memset(_strElementName, 0, DP_MAX_LEN_NAME_ELEMENT);
   strncpy(_strElementName, oDpElem._strElementName,DP_MAX_LEN_NAME_ELEMENT);
   _strElementName[DP_MAX_LEN_NAME_ELEMENT-1] = '\0';

   memmove(&_tProperty, &oDpElem._tProperty, sizeof(TDpElementProperty));

   _u32DataLength = oDpElem._u32DataLength;
   if (_u32DataLength)
    {
        try
        {
            _pDataBuffer = new tU8[_u32DataLength];
        }
        catch(const std::bad_alloc&)
        {
            _pDataBuffer = NULL;
        }

        if ((_pDataBuffer) && (oDpElem._pDataBuffer))
        {
            memmove(_pDataBuffer, oDpElem._pDataBuffer, _u32DataLength);
        }
        else
        {
            ETG_TRACE_FATAL(("dp_tclBaseElement():  Copy Constructor %d length for  '%s' Creation Error !",_u32DataLength, _strElementName));
        }
   }

   _u32RdAccessCount = 0;
   _u32WrAccessCount = 0;

   _pCallbackList = NULL;
   #ifdef DP_U32_POOL_ID_DPENDUSERMODE
   _oInitBankKdsAccessList.clear();
   #endif

   _bNotify = FALSE;
   _s32Hash = oDpElem._s32Hash;

   ETG_TRACE_USR4(("dp_tclBaseElement(): Copy constructor for '%s' called !",_strElementName));

}

tBool dp_tclBaseElement::bFillData(tVoid* pStreamStart, tU32 u32StreamLength){

   tBool bRet = FALSE;
   _u32WrAccessCount++;

   if (_u32DataLength != u32StreamLength) {
      _u32DataLength = u32StreamLength;
      if (_pDataBuffer != NULL) {
         delete[] _pDataBuffer;
         //OSAL_vMemoryFree(_pDataBuffer);
         _pDataBuffer = NULL;
      }
   }
   if (_pDataBuffer == NULL) {
      _u32DataLength = u32StreamLength;
            try
            {
                _pDataBuffer = new tU8[_u32DataLength];
            }
            catch(const std::bad_alloc&)
            {
                _pDataBuffer = NULL;
                ETG_TRACE_ERR(("bFillData(): Unable to allocate %d bytes for '%s'!",_u32DataLength, _strElementName));
            }
      if (_pDataBuffer) {
         memset(_pDataBuffer, 0, _u32DataLength);
      }
   }

        if ((_pDataBuffer)  &&(pStreamStart != NULL))
        {
            if (memcmp(_pDataBuffer, pStreamStart, _u32DataLength) != 0) {
                memmove(_pDataBuffer, ((tU8*)pStreamStart), _u32DataLength);
                bRet = TRUE;
            } else {
                ETG_TRACE_USR4(("bFillData(): Data are identical -> Don't need to fill '%s'!",_strElementName));
            }
        }

   return bRet;
}


tBool dp_tclBaseElement::bSetDefaultData(tVoid* pStreamStart, tU32 u32StreamLength)
{
  tBool bRet = FALSE;

    if(_u32DefDataLength != u32StreamLength) 
    {
        _u32DefDataLength = u32StreamLength;
        if (_pDefaultDataBuffer != NULL) 
        {
            delete[] _pDefaultDataBuffer;
            _pDefaultDataBuffer = NULL;
        }
    }
    if(_pDefaultDataBuffer == NULL) 
    {
        _u32DefDataLength = u32StreamLength;
        try
        {
        _pDefaultDataBuffer = new tU8[_u32DefDataLength];
        }
        catch(const std::bad_alloc&)
        {
           _pDefaultDataBuffer = NULL;
           ETG_TRACE_ERR(("bSetDefaultData(): Unable to allocate %d bytes for '%s'!",_u32DataLength, _strElementName));
        }
    }
    if((_pDefaultDataBuffer) &&(pStreamStart != NULL))
    {
        memmove(_pDefaultDataBuffer, ((tU8*)pStreamStart), _u32DefDataLength);
        bRet = TRUE;
    }
  
  return bRet;
}

tBool dp_tclBaseElement::bRestoreDefaultData()
{
   return bFillData(_pDefaultDataBuffer, _u32DefDataLength);
}

#ifdef DP_U32_POOL_ID_DPENDUSERMODE
tBool dp_tclBaseElement::bAddInitBankKdsAccessToList(tU16 u16Bank,tCString strConfigElement,tCString strConfigItem,tBool bNormalAssertIfElemNotExist)
{
  tBool VbReturn=TRUE;
  ETG_TRACE_USR4(("dp_tclBaseElement()::bAddInitBankKdsAccessToList: add initial KDS access (bank %d element '%s')", u16Bank, _strElementName));
  //check if default access for bank already exist
  TDpInitBankKdsAccessList::iterator VtDpPos = _oInitBankKdsAccessList.find((tU8)u16Bank);
  if (VtDpPos != _oInitBankKdsAccessList.end()) 
  {
    ETG_TRACE_FATAL(("dp_tclBaseElement()::bAddInitBankKdsAccessToList: error initial KDS access for bank %d multiple defined", u16Bank));
  }
  else
  { //add access KDS entry
    TDpInitBankKdsAccess VtEntry;
    VtEntry.strConfigElement=strConfigElement;
    VtEntry.strConfigItem=strConfigItem;
    VtEntry.bNormalAssertIfElemNotExist=bNormalAssertIfElemNotExist;
    _oInitBankKdsAccessList[(tU8)u16Bank]=VtEntry;
  }
  return(VbReturn);
}

tBool dp_tclBaseElement::bGetInitBankKdsValueFromList(tU16 u16Bank, tU8* pau8Data, tU16 u16Len)
{
  tBool VbReturn=FALSE;
  ETG_TRACE_USR4(("dp_tclBaseElement()::bGetInitBankKdsValueFromList: get initial KDS value from (bank %d element '%s')", u16Bank, _strElementName));
  //check if default access for bank already exist
  TDpInitBankKdsAccessList::iterator VtDpPos = _oInitBankKdsAccessList.find((tU8)u16Bank); 
  if (VtDpPos == _oInitBankKdsAccessList.end()) 
  {
    ETG_TRACE_USR4(("dp_tclBaseElement()::bGetInitBankKdsValueFromList: no KDS bank access defined for bank %d ", u16Bank));
  }
  else
  {     
    if(DP_s32GetConfigItem((const tChar*)VtDpPos->second.strConfigElement.c_str(),(const tChar*)VtDpPos->second.strConfigItem.c_str(),pau8Data,u16Len,VtDpPos->second.bNormalAssertIfElemNotExist)==DP_S32_NO_ERR)
    {
      VbReturn=TRUE;
    }   
  }
  ETG_TRACE_USR4(("dp_tclBaseElement()::bGetInitBankKdsValueFromList: return value %d ", VbReturn));
  return(VbReturn);
}
#endif

dp_tclBaseElement& dp_tclBaseElement::operator=(const dp_tclBaseElement &oDpElem) {
   if (this != &oDpElem) 
   {
      _pConfCallBack = oDpElem._pConfCallBack;//lint !e1555 callback function must be copied directly
      _u32RdAccessCount = oDpElem._u32RdAccessCount;
      _u32WrAccessCount = oDpElem._u32WrAccessCount;
      _bNotify = oDpElem._bNotify;

      memset(_strElementName, 0, DP_MAX_LEN_NAME_ELEMENT);
      strcpy(_strElementName, oDpElem._strElementName);

      _s32Hash = oDpElem._s32Hash;

      memmove(&_tProperty, &oDpElem._tProperty, sizeof(TDpElementProperty));

      if ((_u32DataLength == 0) && (_pDataBuffer == NULL)) 
      {
         _u32DataLength = oDpElem._u32DataLength;
         ETG_TRACE_USR4(("dp_tclBaseElement()::operator: alloc memory (%d) for '%s' !", _u32DataLength, _strElementName));
        try
        {
             _pDataBuffer = new tU8[_u32DataLength]; 
        }
        catch(const std::bad_alloc&)
        {
            _pDataBuffer = NULL;
            ETG_TRACE_ERR(("dp_tclBaseElement()::operator=: NULL Case alloc memory (%d) for '%s'failed !", _u32DataLength, _strElementName));
        }
               
      }

      if (_u32DataLength == oDpElem._u32DataLength) 
      {
         if (_pDataBuffer) {
            memmove(_pDataBuffer, oDpElem._pDataBuffer, _u32DataLength);
         }
      } 
      else if (oDpElem._tProperty.bVarSize)
      {  //size changed -> delete old and allocate new memory
           delete[] _pDataBuffer;
           _pDataBuffer=NULL;/*Bug 123144: Safe handling*/
           _u32DataLength = oDpElem._u32DataLength;
            try
            {
                _pDataBuffer = new tU8[_u32DataLength]; 
            }
            catch(const std::bad_alloc&)
            {
                _pDataBuffer = NULL;
                ETG_TRACE_ERR(("dp_tclBaseElement()::operator=: bVarSize Case alloc memory (%d) for '%s'failed !", _u32DataLength, _strElementName));
            }
         
         if (_pDataBuffer) 
         {
            memmove(_pDataBuffer, oDpElem._pDataBuffer, _u32DataLength);
         }
         ETG_TRACE_USR4(("dp_tclBaseElement()::operator: size changed -> delete old and allocate new memory (%d) for '%s' !", _u32DataLength, _strElementName));
      } 
      else 
      {
         ETG_TRACE_FATAL(("dp_tclBaseElement()::operator: !!!!!!!! Length error: %d , %d -> '%s' !!!!!!!!!", _u32DataLength, oDpElem._u32DataLength,_strElementName));
      }
      if ((_u32DefDataLength == 0) && (_pDefaultDataBuffer == NULL)) 
      {
         _u32DefDataLength = oDpElem._u32DefDataLength;
         ETG_TRACE_USR4(("dp_tclBaseElement()::operator: alloc memory for defset buffer (%d) for '%s' !", _u32DataLength, _strElementName));
         _pDefaultDataBuffer = new tU8[_u32DefDataLength];   
      }
      if (_u32DefDataLength == oDpElem._u32DefDataLength) 
      {
         if (_pDefaultDataBuffer) {
            memmove(_pDefaultDataBuffer, oDpElem._pDefaultDataBuffer, _u32DefDataLength);
         }
      }

      #ifdef DP_U32_POOL_ID_DPENDUSERMODE
      _oInitBankKdsAccessList=oDpElem._oInitBankKdsAccessList;
      #endif

      //copy callbacklist
      if (oDpElem._pCallbackList != NULL) 
      {
         _pCallbackList = new TNotCallbackList;
         if (_pCallbackList) 
         {
            TNotCallbackList::const_iterator  pos;
            TNotCallbackList* tList = (TNotCallbackList*)oDpElem._pCallbackList; //lint !e1773: Attempt to cast away const (or volatile) --> cannot use const, otherwise get stl error
            for (pos = tList->begin();pos != tList->end(); ++pos) 
            {
               _pCallbackList->push_back(*pos);
            }
         }
      }     
   }
   return *this;
}

tVoid dp_tclBaseElement::vCopyElement(const dp_tclBaseElement &oDpElem) {
   if (this != &oDpElem) {

      _pConfCallBack = oDpElem._pConfCallBack;//lint !e1555 callback function must be copied directly
      _u32RdAccessCount = oDpElem._u32RdAccessCount;
      _u32WrAccessCount = oDpElem._u32WrAccessCount;
      _bNotify = oDpElem._bNotify;

      memset(_strElementName, 0, DP_MAX_LEN_NAME_ELEMENT);
      strcpy(_strElementName, oDpElem._strElementName);

      memmove(&_tProperty, &oDpElem._tProperty, sizeof(TDpElementProperty));

      if ((_u32DataLength == 0) && (_pDataBuffer == NULL)) {
          ETG_TRACE_USR4(("dp_tclBaseElement()::operator: alloc memory (%d -> 0x%08x) for '%s' !", _u32DataLength, _pDataBuffer, _strElementName));
         _u32DataLength = oDpElem._u32DataLength;
            try
            {
                if (0 != OSAL_s32StringCompare("SystemState", _strElementName))
                {
                    _pDataBuffer = new tU8[_u32DataLength];
                    //_pDataBuffer = (tU8 *)OSAL_pvMemoryAllocate(_u32DataLength);
                } 
                else 
                {
                    _pDataBuffer = new tU8[_u32DataLength+50];
                    //_pDataBuffer = (tU8 *)OSAL_pvMemoryAllocate(_u32DataLength+50);
                }
            }
            catch(const std::bad_alloc&)
            {
                _pDataBuffer = NULL;
                 ETG_TRACE_ERR(("dp_tclBaseElement()::operator: alloc memory (%d -> 0x%08x) for '%s'failed !", _u32DataLength, _pDataBuffer, _strElementName));
            }		 
      }

      if (_u32DataLength == oDpElem._u32DataLength) {
         if (_pDataBuffer) {
            memmove(_pDataBuffer, oDpElem._pDataBuffer, _u32DataLength);
         }
      } else if (oDpElem._tProperty.bVarSize){
         //size changed -> delete old and allocate new memory
         delete[] _pDataBuffer;
         _pDataBuffer=NULL; /*Bug 123144: Safe handling*/
         //OSAL_vMemoryFree(_pDataBuffer);

         _u32DataLength = oDpElem._u32DataLength;
            try
            {
                _pDataBuffer = new tU8[_u32DataLength];
            }
            catch(const std::bad_alloc&)
            {
                _pDataBuffer = NULL;
            }
         //_pDataBuffer = (tU8 *)OSAL_pvMemoryAllocate(_u32DataLength);

         if (_pDataBuffer) {
            memmove(_pDataBuffer, oDpElem._pDataBuffer, _u32DataLength);
         }
         ETG_TRACE_USR4(("dp_tclBaseElement()::operator: size changed -> delete old and allocate new memory (%d) for '%s' !", _u32DataLength, _strElementName));

      } else {
         ETG_TRACE_FATAL(("dp_tclBaseElement()::operator: !!!!!!!! Length error: %d , %d -> '%s' !!!!!!!!!", _u32DataLength, oDpElem._u32DataLength,_strElementName));
      }

      if ((_u32DefDataLength == 0) && (_pDefaultDataBuffer == NULL)) {
         ETG_TRACE_USR4(("dp_tclBaseElement()::operator: alloc memory for defset buffer (%d-> 0x%08x) for '%s' !", _u32DataLength, _pDefaultDataBuffer, _strElementName));
         _u32DefDataLength = oDpElem._u32DefDataLength;
         
        try
        {
            _pDefaultDataBuffer = new tU8[_u32DefDataLength];
        }
        catch(const std::bad_alloc&)
        {
            _pDefaultDataBuffer = NULL;
            ETG_TRACE_ERR(("dp_tclBaseElement()::operator: alloc memory for defset buffer (%d-> 0x%08x) for '%s' failed!", _u32DataLength, _pDefaultDataBuffer, _strElementName));
        }
         //_pDefaultDataBuffer = (tU8 *)OSAL_pvMemoryAllocate(_u32DefDataLength);
      }

      if (_u32DefDataLength == oDpElem._u32DefDataLength) {
         if (_pDefaultDataBuffer) {
            memmove(_pDefaultDataBuffer, oDpElem._pDefaultDataBuffer, _u32DefDataLength);
         }
      }
   }
   return;
}

tVoid dp_tclBaseElement::vFillElementProperty(dp_tclBaseElement* pElemSrc) {
   memmove(&_tProperty, &pElemSrc->_tProperty, sizeof(TDpElementProperty));
   _tProperty.bValidated = TRUE;
   _tProperty.u32NextStoreTime = 0;
}

tS32 dp_tclBaseElement::s32ConvertElement(dp_tclBaseElement* pElemSrc){
   tS32 s32Ret = DP_S32_ERR_NO_CONVERSION;
   if ((_pConfCallBack != NULL)&&(pElemSrc != NULL)) {
      tU32 s32ResLen=0;
      tU8* pBuf = NULL;
      if (DP_S32_NO_ERR == _pConfCallBack(pElemSrc->u8GetVersion(), _tProperty.u8Version, (tU8 *)pElemSrc->pvGetData(), pElemSrc->u32GetDataLength(), &pBuf, &s32ResLen))
      {
         bFillData(pBuf, s32ResLen);
         if(pBuf != NULL)
         {
             delete[] pBuf;
             pBuf=NULL; /*Bug 123144: Safe handling*/
         }
         s32Ret = DP_S32_NO_ERR;
      }
   }
   return s32Ret;
}


tBool dp_tclBaseElement::bAddNotification(TFuncNotEntry tEntry) 
{
   tBool bRet = TRUE;

   if (_pCallbackList == NULL) 
   {
      _pCallbackList = new TNotCallbackList;
   }
   if (_pCallbackList != NULL) 
   {  //search for alread existing entry
      TNotCallbackList::iterator pos;
      for (pos = _pCallbackList->begin(); (bRet) && (pos != _pCallbackList->end()); ++pos) 
      {
         if ((pos->pCallback == tEntry.pCallback) && (pos->u32Event == tEntry.u32Event)) 
         {
            bRet = FALSE;
         }
      }
      //add notification to list
      if (bRet) 
      {
         _pCallbackList->push_back(tEntry);
         _bNotify = TRUE;
      }
   }
   return bRet;
}

tBool dp_tclBaseElement::bRemoveNotification(TFuncNotEntry tEntry) {
   tBool bRet = FALSE;
   tU32  u32NotCount = 0;

   if (_pCallbackList != NULL) 
   {//search for alread existing entry
     TNotCallbackList::iterator pos;
     for (pos = _pCallbackList->begin();(pos != _pCallbackList->end()); ++pos) 
     {
       if ((pos->pCallback == tEntry.pCallback) && (pos->u32Event == tEntry.u32Event)) 
       {
          bRet = TRUE;
         _pCallbackList->erase(pos);
          break;
       }
     }
   }
   if (_pCallbackList) 
   {
     u32NotCount += ((tU32)_pCallbackList->size());
   }
   //check if at least one notify trigger is set
   if (u32NotCount == 0) 
   {
      _bNotify = FALSE;
   }
   return bRet;
}

tVoid dp_tclBaseElement::vSendNotification() 
{
   if (_pCallbackList != NULL) 
   {
      TNotCallbackList::iterator posCallback;
      for (posCallback = _pCallbackList->begin(); (posCallback != _pCallbackList->end()); ++posCallback) 
      {
         if (posCallback->pCallback != NULL) 
         {
            posCallback->pCallback(posCallback->u32Event);
         }
      }
   }
}

tS32 dp_tclBaseElement::s32CalcHash(tChar* str) {
   tS32 hash = 0;
   tS32 n = ((tS32)strlen(str));
   for (int i=0; i<n; i++) 
   {
      hash = 5*hash + str[i];
   }
   //hash calculation should only be done offline (by generator) --> "s32CalcHash()" called when item requested without using generated interface
   ETG_TRACE_USR4(("s32CalcHash(): called for element (hash: 0x%08x) '%s' ", hash, _strElementName));
   return hash;
}

dp_tclOutStreamCtxt& dp_tclBaseElement::oWrite(dp_tclOutStreamCtxt& oOut)
{
   // to add new item:
   // - change oRead / oWrite
   // - change length calculation in "u32GetStreamLength()" 
   // - change file Version --> DP_U8_FILE_VERSION

   oOut << _tProperty.u8Version;
   oOut << _s32Hash;

   //set name
   oOut << _strElementName;
   {
      //set payload data
      dpCtxtElemWrite tDataRef = {(tVoid*)_pDataBuffer, _u32DataLength};
      oOut << &tDataRef;
   }
   return oOut;
}

dp_tclInStreamCtxt& dp_tclBaseElement::oRead(dp_tclInStreamCtxt& oIn)
{
   // to add new item:
   // - change oRead / oWrite
   // - change length calculation in "u32GetStreamLength()" 
   // - change file Version --> DP_U8_FILE_VERSION

   oIn >> _tProperty.u8Version;
   oIn >> _s32Hash;

   /*check size for name*/
   if((strlen((tChar*)oIn.pu8GetPosition()))>=DP_MAX_LEN_NAME_ELEMENT)
   {
     ETG_TRACE_ERR(("oRead(): size error: read name greater then DP_MAX_LEN_NAME_ELEMENT"));
     oIn.Invalidate();
   }
   else
   {  //set name
     oIn >> _strElementName;
     { //set data
       dpCtxtElemRead tDataRef = {(tVoid**)&_pDataBuffer, &_u32DataLength};
       oIn >> &tDataRef;
     }
   }
   return oIn;
}

tU32 dp_tclBaseElement::u32GetStreamLength() const { 
   tU32 u32Len=4; //first 4 byte is lenght -> set by stream context 

   u32Len += 1; //versiom
   u32Len += 4; //hash
   u32Len += ((tU32)strlen(_strElementName)+1); //name
   u32Len += ((tU32)sizeof(tU32)); //
   u32Len += _u32DataLength; //data

   return u32Len;
};

dp_tclOutStreamCtxt& operator<<(dp_tclOutStreamCtxt& oOutContext, dp_tclBaseElement& oMyRef ) 
{
   return oMyRef.oWrite(oOutContext);
}

dp_tclInStreamCtxt& operator>>(dp_tclInStreamCtxt& oInContext, dp_tclBaseElement& oMyRef) {
   return oMyRef.oRead(oInContext);
}

//EOF
