/******************************************************************************
 * FILE:         dbbase_trace.cpp
 * PROJECT:
 * SW-COMPONENT: datapool
 *------------------------------------------------------------------------------
 *
 * DESCRIPTION:
 *
 *------------------------------------------------------------------------------
 * COPYRIGHT:    (c) 2013 Robert Bosch GmbH, Hildesheim
 * HISTORY:
 * Date      | Author             | Modification
 * 08.03.13  | CM-AI/VW32 kollai  | initial version
 *
 *******************************************************************************/

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC		   
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define DP_S_IMPORT_INTERFACE_BASE
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS DP_TRACE_CLASS
#include "trcGenProj/Header/dpbase_trace.cpp.trc.h"
#endif

extern tVoid vInitDpInternData(tU8 u8Bank=DP_U8_NO_BANK_ACTION);

tVoid dp_tclDpBase::vSetTraceConfiguration() 
{   
   if(_bListTraceElementsLoad==FALSE)
   {
     dp_tclBaseElement myDpElem("TrElements");
     DP_vSetPoolInitCallback(vInitDpInternData, DP_U32_POOL_ID_DPINTERNDATA);
     if (DP_S32_NO_ERR == s32GetElement(DP_U32_POOL_ID_DPINTERNDATA, &myDpElem, DP_U32_POOL_ID_DPINTERNDATA>>16)) 
     {
        ETG_TRACE_ERR(("vSetTraceConfiguration(): element 'TrElements' found."));
        if ((myDpElem.u32GetDataLength() % ((tU32)sizeof(tU32))) == 0) 
	      { 
          tU32 u32Count = myDpElem.u32GetDataLength() / ((tU32)sizeof(tU32));
          ETG_TRACE_ERR(("vSetTraceConfiguration(): element 'TrElements' with %d entries found.", u32Count));
          if (u32Count > 0)   
		      {
            tS32* pu32Array = (tS32*)myDpElem.pvGetData();
            for (tU32 i=0; i<u32Count;i++) 
			      {
              if(pu32Array[i]!=0) //hash value 0 => default value 
			        {
                _oListTraceElements.push_back(pu32Array[i]);
                ETG_TRACE_ERR(("vSetTraceConfiguration(): trace element with hash 0x%08x.", pu32Array[i]));
			        }
            }
          }
		      else 
          {
            _oListTraceElements.clear();
			      //fprintf(stderr, "vSetTraceConfiguration(): call s32SetElement()\n");
			      //save pool only with lenght = 0 if configuration in NOR 
			      // -- if pool not read from persistent(first read), pool is in init state
			      //     => pool will stored. 
            // -- if pool read from persistent, pool is in load state
			      //     =>pool will not be stored
			      s32SetElement(DP_U32_POOL_ID_DPINTERNDATA, &myDpElem, DP_U32_POOL_ID_DPINTERNDATA>>16);			
          }
        }
     }
     _bListTraceElementsLoad=TRUE;
   }
}

tBool dp_tclDpBase::bIsTracingEnabled(dp_tclBaseElement* tDpElement) const 
{
  tBool bTrace = FALSE;
  if (et_bIsTraceActive(DP_TRACE_CLASS, TR_LEVEL_USER_4)) 
  {   
    if (_oListTraceElements.size() == 0) 
	  {
      bTrace = TRUE;
    } 
	  else 
	  {  //check if element is in trace list
		 #ifdef SYSTEM_S_USE_BPSTL
		 bpstl::list<tS32>::const_iterator it;
     #else
     std::list<tS32>::const_iterator it;
     #endif
     for (it = _oListTraceElements.begin(); (it != _oListTraceElements.end()) && !bTrace; ++it) 
		 {
       if (*it == tDpElement->s32GetHash()) 
			 {
         bTrace = TRUE;
       }
     }
    }
  }
  return bTrace;
}

tVoid dp_tclDpBase::vTracePoolHistory() 
{
   TDpPoolHistoryList::iterator posDp;
   for (posDp = oHistoryList.begin(); posDp != oHistoryList.end(); ++posDp) 
   {
      ETG_TRACE_FATAL(("vTracePoolHistory(): Stored at %d:%02d:%02d (H:MM:SS) (TS: %d), Bytes: %d, File: '%s'", (posDp->u32TimeStamp / 1000 / 60 / 60),
                       (posDp->u32TimeStamp/1000/60) % 60,
                       (posDp->u32TimeStamp/1000) % 60,
                        posDp->u32TimeStamp,
                        posDp->u32BytesWritten,
                        posDp->strFileName.c_str()));
      TElementChangeMap::iterator posElement;
      for (posElement = posDp->tElemChangeMap.begin(); posElement != posDp->tElemChangeMap.end(); ++posElement) 
      {
         ETG_TRACE_FATAL(("vTracePoolHistory(): Element changed last at %d: '%s'", posElement->second.u32Timestamp, posElement->second.strElemName.c_str()));
      }
   }
}

tVoid dp_tclDpBase::vTracePoolElement() {
   TDatapool::iterator posDp;
   for (posDp = oDatapool.begin(); posDp != oDatapool.end(); ++posDp) {
      vTracePoolElement(posDp->first);
   }
}

tVoid dp_tclDpBase::vTracePoolElement(const tChar* strName) {
   TDatapool::iterator posDp;
   for (posDp = oDatapool.begin(); posDp != oDatapool.end(); ++posDp) {
      tU32 u32PoolId = posDp->first;
      TDatapool::iterator tDpPos = oDatapool.find(u32PoolId);
      if (tDpPos != oDatapool.end()) {
         TListDatapoolElements::iterator posElement;
         for (posElement = oDatapool[u32PoolId].tDpElementList.begin(); posElement != oDatapool[u32PoolId].tDpElementList.end(); ++posElement) {
            if (NULL != OSAL_ps8StringSubString(posElement->second.pcGetElementName(), strName)) { //lint !e1773: Attempt to cast away const (or volatile) --> in macro
               vTraceElement(&posElement->second, eDpElemTrace);
            }
         }
      }
   }
}

tVoid dp_tclDpBase::vTracePoolElement(tU32 u32PoolId) {
   TDatapool::iterator tDpPos = oDatapool.find(u32PoolId);
   if (tDpPos != oDatapool.end()) {
      ETG_TRACE_FATAL(("vTracePoolElement(): ******************************************************************"));
      ETG_TRACE_FATAL(("vTracePoolElement(): *****     Trace info for Pool: '%s' *****", tDpPos->second.strFileName));
      ETG_TRACE_FATAL(("vTracePoolElement(): ******************************************************************"));

      TListDatapoolElements::iterator posElement;
      for (posElement = oDatapool[u32PoolId].tDpElementList.begin(); posElement != oDatapool[u32PoolId].tDpElementList.end(); ++posElement) {
         vTraceElement(&posElement->second, eDpElemTrace);
      }
   } else {
      ETG_TRACE_FATAL(("Datapool: Trace(): Pool ID %d not found", u32PoolId));
   }
}

tVoid dp_tclDpBase::vTraceElement(dp_tclBaseElement* tDpElement, EDpElementTrace eTraceType) const {
   tU32 u32ElemDataLen = tDpElement->u32GetDataLength();
   tU8* pu8Data = (tU8*) tDpElement->pvGetData();
   tU8 u8VarType = tDpElement->u8GetVarType();

   if (eTraceType != eDpElemTrace) {
      if (bIsTracingEnabled(tDpElement)) {
         ETG_TRACE_USR4(("vTraceElement(): ----------------------------------------------------------"));
         ETG_TRACE_USR4(("vTraceElement(): %u -> Element: '%s'", ETG_ENUM(EDpElementTrace, (tU8)eTraceType), tDpElement->pcGetElementName()));
         ETG_TRACE_USR4(("vTraceElement(): Type: %u, Len: %d, Rx: %d, Wr: %d", ETG_ENUM(EDpElementTypes, (tU8)tDpElement->eGetElementType()), u32ElemDataLen, tDpElement->u32GetRdAccessCount(), tDpElement->u32GetWrAccessCount()));

         if (u32ElemDataLen > 0) {
            if (u8VarType == DP_TYPE_U32) {
               ETG_TRACE_USR4(("vTraceElement(): data: %d", *(tU32*) pu8Data)); //lint !e826: Suspicious pointer-to-pointer conversion (area too small) --> length is checked by type parameter
            } else if (u8VarType == DP_TYPE_U16) {
               ETG_TRACE_USR4(("vTraceElement(): data: %d", *(tU16*) pu8Data)); //lint !e826: Suspicious pointer-to-pointer conversion (area too small) --> length is checked by type parameter
            } else if (u8VarType == DP_TYPE_U8) {
               ETG_TRACE_USR4(("vTraceElement(): data: %d", *(tU8*) pu8Data));
            } else if (u8VarType == DP_TYPE_STRING) {
               //seems to be a string
               ETG_TRACE_USR4(("vTraceElement(): string: '%s'", pu8Data));
            } else {
               ETG_TRACE_USR4(("vTraceElement(): data: %*x", ETG_LIST_LEN(u32ElemDataLen), ETG_LIST_PTR_T8(pu8Data)));
            }
         }
         ETG_TRACE_USR4(("vTraceElement(): ----------------------------------------------------------"));
      }

   } else {
      ETG_TRACE_FATAL(("vTraceElement(): ----------------------------------------------------------"));
      ETG_TRACE_FATAL(("vTraceElement(): Element: '%s'", tDpElement->pcGetElementName()));
      ETG_TRACE_FATAL(("vTraceElement(): Type: %u, Len: %d, Rx: %d, Wr: %d", ETG_ENUM(EDpElementTypes, (tU8)tDpElement->eGetElementType()), u32ElemDataLen, tDpElement->u32GetRdAccessCount(), tDpElement->u32GetWrAccessCount()));

      if (u32ElemDataLen > 0) {
         if (u8VarType == DP_TYPE_U32) {
            ETG_TRACE_FATAL(("vTraceElement(): data: %d", *(tU32*) pu8Data)); //lint !e826: Suspicious pointer-to-pointer conversion (area too small) --> length is checked by type parameter
         } else if (u8VarType == DP_TYPE_U16) {
            ETG_TRACE_FATAL(("vTraceElement(): data: %d", *(tU16*) pu8Data)); //lint !e826: Suspicious pointer-to-pointer conversion (area too small) --> length is checked by type parameter
         } else if (u8VarType == DP_TYPE_U8) {
            ETG_TRACE_FATAL(("vTraceElement(): data: %d", *(tU8*) pu8Data));
         } else if (u8VarType == DP_TYPE_STRING) {
            ETG_TRACE_FATAL(("vTraceElement(): string: '%s'", pu8Data));
         } else {
            ETG_TRACE_FATAL(("vTraceElement(): data: %*x", ETG_LIST_LEN(u32ElemDataLen), ETG_LIST_PTR_T8(pu8Data)));
         }
      }
      ETG_TRACE_FATAL(("vTraceElement(): ----------------------------------------------------------"));
   }
}

//EOF
