#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"


#define DP_S_IMPORT_INTERFACE_BASE
#define DP_S_IMPORT_INTERFACE_DPENDUSER
#include "dp_if.h"

#ifdef DP_FEATURE_UNDEF_ELEMENT

#define DP_UNDEF_TRACE_CLASS              (tU16)(TR_COMP_DATAPOOL + 0x05) 

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS DP_UNDEF_TRACE_CLASS
#include "trcGenProj/Header/dp_InitUndef.cpp.trc.h"
#endif

tVoid dp_tclDpBase::vInitUndef(tU32 Pu32PoolId)
{ 
  /*get pool property from list with u32PoolId and call init */
  TDpUndefPoolProperty::iterator VtDpPos = oDpUndefPoolProperty.find(Pu32PoolId);
  if (VtDpPos == oDpUndefPoolProperty.end()) 
  {/* trace out; pool not found */
    ETG_TRACE_USR4(("vInitUndef(): pool property not available;"));
  }
  else
  {
    tDpUndefElementProperty*  VptDpUndefElementProperty = NULL;
	  dp_tclDpUndef*            VpoMyDpUndef = dp_tclDpUndef::pGetInstance();
	  tS32                      Vs32SizeRead;
	  /*init pool */
	  vInitDp(Pu32PoolId, oDpUndefPoolProperty[Pu32PoolId].strPoolName,oDpUndefPoolProperty[Pu32PoolId].u32PoolVersion,oDpUndefPoolProperty[Pu32PoolId].eLocation);
    /*read not default properties for this pool */
    Vs32SizeRead=VpoMyDpUndef->s32GetElementProperties(Pu32PoolId,oDpUndefPoolProperty[Pu32PoolId].eLocation,&VptDpUndefElementProperty);
	  if(Vs32SizeRead>0)
	  { /* init all elements which not default */
	    tDpUndefElementProperty* VtPosElementPropertiesPos = VptDpUndefElementProperty;
	    tU32                     Vu32Inc;
	    tU32                     Vu32MaxNumber=(((tU32)Vs32SizeRead)/sizeof(tDpUndefElementProperty));
      for (Vu32Inc=0;Vu32Inc < Vu32MaxNumber;Vu32Inc++)
      {
	      dp_tclBaseElement VElementWhichNotDefault
        (
		      VtPosElementPropertiesPos->strElementName, 
		      VtPosElementPropertiesPos->u8Version, 
		      VtPosElementPropertiesPos->u32DataLength,  
          VtPosElementPropertiesPos->bVarSize,
          VtPosElementPropertiesPos->u16AccessType,
          VtPosElementPropertiesPos->tElemType, 
          VtPosElementPropertiesPos->tStoringType, 
          VtPosElementPropertiesPos->u32StoringIntervall,
          VtPosElementPropertiesPos->u32DefSetMode
		    );
		    /*init element*/
	    	vInitElement(Pu32PoolId, &VElementWhichNotDefault);
		    /*increment pointer*/
		    VtPosElementPropertiesPos++;
      }
	    delete[] VptDpUndefElementProperty;
        VptDpUndefElementProperty=NULL; /*Bug 123144: to Prevent Double Free*/
	    ETG_TRACE_USR4(("vInitUndef(): %d elements with not default property",Vu32Inc));
    }
	  /* init elements with default properties*/
    vInitUndefElements(Pu32PoolId);
  }
}
#endif
