/**
 * @copyright    (C) 2012 - 2016 Robert Bosch GmbH.
 *               The reproduction, distribution and utilization of this file as well as the
 *               communication of its contents to others without express authorization is prohibited.
 *               Offenders will be held liable for the payment of damages.
 *               All rights reserved in the event of the grant of a patent, utility model or design.
 * @brief        
 * @addtogroup   Datapool main
 * @{
 */

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC		   
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define DP_S_IMPORT_INTERFACE_BASE
#include "dp_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS DP_TRACE_CLASS
#include "trcGenProj/Header/datapool.cpp.trc.h"
#endif

dp_tclDatapool* dp_tclDatapool::_poInstance = NULL;

//must be called once before using DP
dp_tclDatapool* dp_tclDatapool::pCreateInstance() 
{
   if (_poInstance == NULL) 
   {
      _poInstance = new dp_tclDatapool();
   }
   return _poInstance;
}

dp_tclDatapool* dp_tclDatapool::pGetInstance() 
{
   if (_poInstance == NULL) 
   {
      ETG_TRACE_FATAL(("!!!!!!!!!!!!!!!! dp_tclDatapool::pGetInstance() --> DATAPOOL IS NOT CREATED, interface function 'DP_vCreateDatapool()' must be called first."));
      FATAL_M_ASSERT_ALWAYS();
   }
   return _poInstance;
}

dp_tclDatapool::dp_tclDatapool() : dp_tclDpBase() 
{
}

dp_tclDatapool::~dp_tclDatapool() 
{
  
}


//EOF
