/************************************************************************
* FILE:         FC_VehicleFunctions_dp.h
* PROJECT:      
* SW-COMPONENT:
*----------------------------------------------------------------------
*
* DESCRIPTION: datapool defines (NISSAN's ...)
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author              | Modification
* 17.04.15  | deo2kor RBEI/ECV1   | initial version
*************************************************************************/

#ifndef _FC_VEHICLE_FUNCTIONS_DP_H_
#define _FC_VEHICLE_FUNCTIONS_DP_H_

struct TVehFuncDate {
    tU8     u8Day;
    tU8     u8Month;
    tU16    u16Year;
};

struct TEcoScoreHistory
{
    TVehFuncDate tDate;
    tU8 u8Score;
};

struct THEVConsumptionHistory
{
   tU16 u16AverageEconomy;
   tU16 u16AvgRegeneratedPwr;
};

struct TEcoTripData
{
   tU32 u32ActualECE_PullingAway;
   tF32 f32ActualECE_PullingAway;
   tU32 u32IdealECE_PullingAway;
   tF32 f32IdealECE_PullingAway;
   tU32 u32ActualECE_Cruise;
   tF32 f32ActualECE_Cruise;
   tU32 u32IdealECE_Cruise;
   tF32 f32IdealECE_Cruise;
   tF32 f32ActualECE_CruiseIntermediate;
   tF32 f32IdealECE_CruiseIntermediate;
   tU32 u32ActualECE_Deceleration;
   tF32 f32ActualECE_Deceleration;
   tU32 u32IdealECE_Deceleration;
   tF32 f32IdealECE_Deceleration;
};

struct TDrivingEcoHistory
{
    tU8 u8Score;
	tU32 u32Distance;
	tU16 u16Avg_Speed;
	tU16 u16Avg_Consumption;
	tF32 f32DistWOConsumption;
	tU16 u16VehicleSpeed;
};

struct TEcoData
{
	tU8 u8Acceleration_Score;
	tU8 u8Anticipation_Score;
	tU8 u8GSI_Score;
	tU8 u8EcoScore;
	tF32 f32FreeKM;
};

struct TMainInfoData
{
	tBool bReminderFlag;
	tU32 u32LastResetDistance;
	tU16 u16IntervalSize;
};

struct TEcoChallengeScreenData//A variable of this Type will contain the data required for the Eco Challenge Screen of a particular Category. Each Category ll be Represented by an Variable. Hence 3 Variables are required(Home-Work,Journey,Personal).  
{
	tU32 u32Distance;
	tU16 u16Avg_Speed;
	tU16 u16Avg_Consumption;
	tF32 f32FreeKM;
};
struct TLastResetTime
{
	tU16 u16Year;
	tU8 u8Month;
	tU8 u8Day;
	tU8 u8Hours;
	tU8 u8Minutes;
	tU8 u8Seconds;
};
struct TDistance_WO_Acc_History
{
    TVehFuncDate tDate;
    tU8 u8Distance_WO_Acc_Value; 
};
struct TClinometerAngleData
{
	tU8 u8RollAngle;
	tU16 u16YawAngle;
	tU8 u8PitchAngle;
};
struct TDriverAssistMemDisState
{
	tU8 u8Setting_LaneKeep_State;
	tU8 u8Setting_AutoLane_State;
	tU8 u8Setting_AutoLaneTrigger_State;
	tU8 u8Setting_AutoLaneOvertake_State;
	tU8 u8Setting_AutoLaneNaviRoute_State;
	tU8 u8Setting_AutoLaneConfirm_State;
	tU8 u8Setting_NaviCoopICC_State;
	tU8 u8Setting_ICCCoopTSR_State;
	tU8 u8Setting_Speed_Assist_ICC_Offset;
	tU8 u8Setting_VoiceGuide_State;
	tU8 u8Setting_SafeMode_State;
	tU8 u8Setting_SafeModeSelect_State;
	tU8 u8Setting_DistSetFront_State;
	tU8 u8Setting_DistSetSide_State;
	tU8 u8Setting_DynamicForward_State;
	tU8 u8Setting_NaviCoopDCA_State;
	tU8 u8Setting_WarningForward_State;
	tU8 u8Setting_WarningLane_State;
	tU8 u8Setting_DynamicLane_State;
	tU8 u8Setting_LaneTimingState;
	tU8 u8Setting_WarningBlindSpot_State;
	tU8 u8Setting_BrakeAssist_State;
	tU8 u8Setting_DynamicBlindSpot_State;
	tU8 u8Setting_BlindSpotBrightness_State;
	tU8 u8Setting_Distance_State;
	tU8 u8Setting_AvoidanceBrakeSensitivity_State;
	tU8 u8Setting_AvoidanceBrake_State;
	tU8 u8AEB_Status_Display_State;
	tU8 u8Setting_DriverAttention_State;
	tU8 u8Setting_AccelerationControl_State;
	tU8 u8Setting_RecognitionTraficSign_State;
	tU8 u8Setting_SpeedAssistICC_State;
	tU8 u8Setting_SpeedAssistASL_State;
	tU8 u8Setting_StatusDynamicRear_State;
	tU8 u8Setting_SettingDynamicRear_State;
	tU8 u8Setting_StrgAssist_State;
	tU8 u8Setting_MOD_State;
	tU8 u8Setting_NoEntry_State;
	tU8 u8Setting_WarnRear_State;
	tU8 u8Setting_CallDisp_State;
    //new for 1.4
    tU8 u8Setting_StopSignWarning_State;
    tU8 u8Setting_SignalViolation_State;
    tU8 u8Setting_TSRLinkForOrdinaryRoadSetting_State;
    tU8 u8Setting_OffsetSpeedForOrdinaryRoad_State;
    tU8 u8OffsetSpeedUnit_State;
    tU8 u8Setting_TSRLinkForHighwaySetting_State;
    tU8 u8Setting_CornerSpeedSetting_State;
    tU8 u8Setting_AcceleratorSetting_State;
    tU8 u8Setting_DeceleratorSetting_State;
    tU8 u8Setting_OffsetSpeedForHighway_State;
    tU8 u8Setting_WarningSoundSetting_State;
    tU8 u8Setting_DrivingStyle_State;
    tU8 u8Setting_VehiclePosition_State;
    tU8 u8Setting_LaneChangeSwiftnessSetting_State;
    tU8 u8Setting_AutomaticallyUpdate_State;
    tU8 u8Setting_OvertakingRelativeSpeed_State;
};
struct TVehFuncConsumption
{
    TVehFuncDate tDate;
    tU32 u32Consumption;
};
#endif // _FC_VEHICLE_FUNCTION_DP_H_

