/*****************************************************************************
* FILE:         dispvidctrl_ServiceSyncdisplayIf.h
* PROJECT:      G3G project
* SW-COMPONENT: dispvidctrl
* Template:     ServiceIf.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  
*               Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2018 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#ifndef __dispvidctrl_ServiceSyncdisplayIf__IF__H_
#define __dispvidctrl_ServiceSyncdisplayIf__IF__H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

//include base class
#include "I_dispvidctrl_ServiceSyncdisplayIf.h"
#include "dispvidctrl_AppMain.h"
#include "dispvidctrl_ServiceSyncdisplayCallbackIf.h"

// dispvidctrl_tclServiceSyncdisplayIf_Include: user specific code start
// dispvidctrl_tclServiceSyncdisplayIf_Include: user specific code end

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class Idispvidctrl_tclServiceSyncdisplay;

class dispvidctrl_tclServiceSyncdisplayIf : public Idispvidctrl_tclServiceSyncdisplayIf, public dispvidctrl_tclServiceSyncdisplayCallbackIF
{
public:

   dispvidctrl_tclServiceSyncdisplayIf(tVoid); 
   dispvidctrl_tclServiceSyncdisplayIf(dispvidctrl_tclAppMain* poMainAppl);
   virtual ~dispvidctrl_tclServiceSyncdisplayIf();

   // dispvidctrl_tclServiceSyncdisplayIfDeclarations: user specific code start
   // dispvidctrl_tclServiceSyncdisplayIfDeclarations: user specific code end

   virtual tVoid onServiceAvailable();
   virtual tVoid onServiceUnavailable();
   
   virtual const tChar* getName() const { return "dispvidctrl_tclServiceSyncdisplayIf"; };
   
   virtual tVoid vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();
   
    /***************************************************************************
    * Application specific methods.
    ***************************************************************************/
   virtual tVoid sendEarlyVideoLayerStatusStatus(syncdisplay_fi_tcl_e8_EarlyVideoLayer_Status eEarlyVideoLayerStatus);
   virtual tVoid sendAnimationStatusStatus(syncdisplay_fi_tcl_e8_Animation_Status T_e8_Animation_Status);


   virtual tVoid sendSetFirstScreenReadyMResult();
   virtual tVoid sendSetAnimationRunMResult();
   virtual tVoid sendSetAnimationStopMResult();


   virtual tVoid onSetFirstScreenReadyMStart(tU8 T_tU8_ScreenType);
   virtual tVoid onSetAnimationRunMStart(tU8 T_tU8_PlayRun);
   virtual tVoid onSetAnimationStopMStart(tU8 T_tU8_PlayStop);

   virtual void vGetEarlyVideoLayerStatusMsg(syncdisplay_mainfi_tclMsgEarlyVideoLayerStatusStatus& oStatus) {if (_poServerRef) _poServerRef->vGetEarlyVideoLayerStatusMsg(oStatus);}
   virtual void vGetAnimationStatusMsg(syncdisplay_mainfi_tclMsgAnimationStatusStatus& oStatus) {if (_poServerRef) _poServerRef->vGetAnimationStatusMsg(oStatus);}

private:
   Idispvidctrl_tclServiceSyncdisplay* _poServerRef;

// dispvidctrl_tclServiceSyncdisplayIfDeclarationsPart2: user specific code start
// dispvidctrl_tclServiceSyncdisplayIfDeclarationsPart2: user specific code end

};

#endif // __dispvidctrl_ServiceSyncdisplayIf__IF__H_


