/*****************************************************************************
* FILE:         dispvidctrl_ServiceRvcIf.h
* PROJECT:      G3G project
* SW-COMPONENT: dispvidctrl
* Template:     ServiceIf.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  
*               Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2020 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#ifndef __dispvidctrl_ServiceRvcIf__IF__H_
#define __dispvidctrl_ServiceRvcIf__IF__H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

//include base class
#include "I_dispvidctrl_ServiceRvcIf.h"
#include "dispvidctrl_AppMain.h"
#include "dispvidctrl_ServiceRvcCallbackIf.h"
#include "I_dispvidctrl_tclVideoPlayer.h"

// dispvidctrl_tclServiceRvcIf_Include: user specific code start
class dispvidctrl_tclControl;
class dispvidctrl_tclControl_Avm;
class dispvidctrl_tclControl_Hmi;
class dispvidctrl_tclControl_Rvc;
class dispvidctrl_tclControl_Mvc;
class dispvidctrl_tclControl_Video;
class dispvidctrl_tclControl_HmiAvm3;
class I_dispvidctrl_tclMCanClientAvm;
class I_dispvidctrl_tclVideoPlayer;
// dispvidctrl_tclServiceRvcIf_Include: user specific code end

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class Idispvidctrl_tclServiceRvc;

class dispvidctrl_tclServiceRvcIf : public Idispvidctrl_tclServiceRvcIf, public dispvidctrl_tclServiceRvcCallbackIF
{
public:

   dispvidctrl_tclServiceRvcIf(tVoid); 
   dispvidctrl_tclServiceRvcIf(dispvidctrl_tclAppMain* poMainAppl);
   virtual ~dispvidctrl_tclServiceRvcIf();

   // dispvidctrl_tclServiceRvcIfDeclarations: user specific code start
   virtual tVoid vGetConfiguration(const TConfiguration* pStConfigurationValues);
    
   virtual tVoid vGetIPA_Voice_TextsMsg(rvc_ccafi_tclMsgIPA_Voice_TextsMethodStart& oMethodStart);
   // dispvidctrl_tclServiceRvcIfDeclarations: user specific code end

   virtual tVoid onServiceAvailable();
   virtual tVoid onServiceUnavailable();
   
   virtual const tChar* getName() const { return "dispvidctrl_tclServiceRvcIf"; };
   
   virtual tVoid vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();
   
    /***************************************************************************
    * Application specific methods.
    ***************************************************************************/
   virtual tVoid sendSystemConfigurationsStatus(rvc_fi_tcl_e8_RVC_Camera_System_Type e8CameraSystem, tU8 u8RVCGuideLine, tU8 u8Brightness);
   virtual tVoid sendSystemStatusStatus(rvc_fi_tcl_e8_RVC_SystemStatus e8SystemStatus);
   virtual tVoid sendVideoSignalStatusStatus(rvc_fi_tcl_e8_RVC_SignalStatus e8StatusVideoSignal);
   virtual tVoid sendReverseSignalStatusStatus(rvc_fi_tcl_e8_RVC_ReverseSignalStatus e8StatusReverseSignal);
   virtual tVoid sendCamera_PwrSupplyStatusStatus(tU16 pwrSupplyID, rvc_fi_tcl_e8_Camera_PowerSupplyStatus status, tU32 current);
   virtual tVoid sendMicrophone_PwrSupplyStatusStatus(tU16 pwrSupplyID, rvc_fi_tcl_e8_Microphone_PowerSupplyStatus status, tU32 current);
   virtual tVoid sendTailgate_StatusStatus(rvc_fi_tcl_e8_Tailgate_State State);
   virtual tVoid sendView_Close_AuthorizedStatus(rvc_fi_tcl_e8_Exit_Authorized e8Allowed);
   virtual tVoid sendAvmR_Current_ViewStatus(rvc_fi_tcl_e8_AVM_View_Status e8View);
   virtual tVoid sendAffordable_ITSStatus(rvc_fi_tcl_e8_AffordableIts_Status e8AffordableItsAvailable, rvc_fi_tcl_e8_AffordableIts_StatusFeature e8BswStatus, rvc_fi_tcl_e8_AffordableIts_StatusFeature e8ModStatus, rvc_fi_tcl_e8_AffordableIts_StatusFeature e8LdwStatus);
   virtual tVoid sendIPAConfigurationStatus(rvc_fi_tcl_e8_IPA_AvailabilityStatus e8AvailabilityStatus, rvc_fi_tcl_e8_IPA_RegionalSelection e8RegionalSelection);
   virtual tVoid sendIPAStatusStatus(rvc_fi_tcl_e8_IPA_OperationStatus e8OperationStatus, rvc_fi_tcl_e8_IPA_ModeChangeRequest e8Request);
   virtual tVoid sendIPAPatternRequestStatus(rvc_fi_tcl_e8_IPA_PatternID e8DisplayPattern);
   virtual tVoid sendIPAMessageRequestStatus(rvc_fi_tcl_e8_IPA_MessageID e8MessageID);
   virtual tVoid sendIPASwitchMaskRequestStatus(rvc_fi_tcl_e8_IPA_SwitchMask e8SwitchMask);
   virtual tVoid sendIPASwitchGreyOutRequestStatus(tU8 u8SwitchGreyOut);
   virtual tVoid sendIPADirectionIndicatorStatus(rvc_fi_tcl_e8_IPA_DirectionIndicator e8Direction);
   virtual tVoid sendGdlAdj_SteeringAngleStatus(tBool bShowValues, tU8 u8CentreAdjustmentState, tS32 s32SteeringAngleCentreAdjusted, rvc_fi_tclString SteeringAngleSignalState);
   virtual tVoid sendGdlAdj_CameraAngleStatus(tF32 f32CameraRollAngle, tF32 f32CameraYawAngle, tF32 f32CameraPitchAngle);
   virtual tVoid sendCANFrameStatusStatus(rvc_fi_tcl_e8_RVC_SignalStatus e8StatusCANFrame);
   virtual tVoid sendMvcViewStatusStatus(rvc_fi_tcl_e8_MVCViewingState e8View);
   virtual tVoid sendMvcAlertRequestStatus(tBool bRequest);
   virtual tVoid sendFAPModeStatus(tBool e8State);
   virtual tVoid sendFAPSettingsStatus(std::vector<rvc_fi_tcl_FAP_Settings_State, std::allocator<rvc_fi_tcl_FAP_Settings_State> > arFapSettingState, std::vector<rvc_fi_tcl_AVM_Settings_State, std::allocator<rvc_fi_tcl_AVM_Settings_State> > arAvmSettingState);
   virtual tVoid sendFAPGuidanceStateStatus(tBool e8State);
   virtual tVoid sendAVM3_DispStatusStatus(rvc_fi_tcl_e8_AVMph3_DispStatus e8DispStatus);
   virtual tVoid sendAVM3_ViewSetupStatus(rvc_fi_tcl_e8_AVMph3_ViewPattern e8ViewPattern, rvc_fi_tcl_e8_AVMph3_CautionId e8CautionId, rvc_fi_tcl_AVMph3_SwitchDescriptor Switch1, rvc_fi_tcl_AVMph3_SwitchDescriptor Switch2, rvc_fi_tcl_AVMph3_SwitchDescriptor Switch3, rvc_fi_tcl_AVMph3_SwitchDescriptor Switch4, rvc_fi_tcl_AVMph3_SwitchDescriptor Switch5, rvc_fi_tcl_AVMph3_SwitchDescriptor Switch6, rvc_fi_tcl_AVMph3_SwitchDescriptor Switch7, rvc_fi_tcl_AVMph3_SwitchDescriptor Switch8, rvc_fi_tcl_e8_AVMph3_IconId e8IconId, rvc_fi_tcl_e8_AVMph3_BuzzerStatus e8BuzzerStatus);
   virtual tVoid sendAVM3_ErrorMessageStatus(rvc_fi_tcl_e8_AVMph3_ErrorMessage e8ErrorMessage);
   virtual tVoid sendAVM3_SonarBuzzerStatusStatus(rvc_fi_tcl_e8_AVMph3_BuzzerStatus e8BuzzerStatus);
   virtual tVoid sendAVM3_Settings_DetailedStatus(rvc_fi_tcl_e8_AVMph3_Setting_PrioView e8PriorityView, rvc_fi_tcl_e8_AVMph3_Setting_PrioWide e8PriorityWide, rvc_fi_tcl_e8_AVMph3_Setting_AutoCamPos e8AutoCamPos, rvc_fi_tcl_AVMph3_Setting_CornerSonarSensLvl rCornerSonarSensLvl, rvc_fi_tcl_AVMph3_Setting_SonarSensLvl rSonarSensLvl, rvc_fi_tcl_AVMph3_Setting_BuzzerSoundLvl rBuzzerSoundLvl, std::vector<rvc_fi_tcl_AVMph3_Setting_Option, std::allocator<rvc_fi_tcl_AVMph3_Setting_Option> > arSettingsOption);
   virtual tVoid sendAVM3_Settings_PrimaryStatus(rvc_fi_tcl_e8_AVMph3_SettingOptionState e8AvmSonarBuzzer, tBool bDetailsSettingsAvail, tBool bImageQualitySettingAvail);
   virtual tVoid sendAVM3_ConfigurationStatus(rvc_fi_tcl_e8_AVMph3_ConfigurationStatus e8ConfigStatus, rvc_fi_tcl_AVMph3_Unit_ID rUnit_ID, rvc_fi_tcl_AVMph3_VersionInfo rMsgSetVersion);
   virtual tVoid sendAVM3_Software_VersionStatus(rvc_fi_tcl_AVMph3_VersionInfo rSW_Version_AVM, rvc_fi_tcl_AVMph3_VersionInfo rSW_Version_Sonar);
   virtual tVoid sendAVM3_Hardware_VersionStatus(rvc_fi_tcl_AVMph3_VersionInfo rHW_Version_AVM, rvc_fi_tcl_AVMph3_VersionInfo rHW_Version_Sonar);
   virtual tVoid sendAVM3_CommunicationErrorsStatus(rvc_fi_tcl_AVMph3_MCAN_CommunicationErrors rCommErrors);


   virtual tVoid sendCameraButtonMResult(tBool Result);
   virtual tVoid sendSetStatusHmiMResult(rvc_fi_tcl_e8_RVC_SystemStatus e8SystemStatus);
   virtual tVoid sendSetupLanguageMResult(tBool Result);
   virtual tVoid sendSetupGuideLineMResult(tBool Result);
   virtual tVoid sendSetupVideoControlsMResult(tBool Result);
   virtual tVoid sendSetSystemStatusMResult(tBool Result);
   virtual tVoid sendrunExtDevicePowerSupplyTestMResult(tU16 pwrSupplyID, rvc_fi_tcl_e8_Camera_PowerSupplyStatus status, tU32 current);
   virtual tVoid sendInitializeMResult(tBool Result);
   virtual tVoid sendConfirmSystemStatusMResult(tBool Result);
   virtual tVoid sendSetupUserConfigurationMResult(tBool Result);
   virtual tVoid sendSetMicrophoneStateMResult(tBool Result);
   virtual tVoid sendSetRVCStatusMResult(tBool Result);
   virtual tVoid sendCamera_SetupBeepMResult(rvc_fi_tcl_e8_AVM_StatusBeep e8StatusBeep);
   virtual tVoid sendSetCamerastateMResult(tBool Result);
   virtual tVoid sendChangeViewRequestMResult(tBool Result);
   virtual tVoid sendAffordable_Its_SetupBswMResult(tBool Result);
   virtual tVoid sendAffordable_Its_SetupModMResult(tBool Result);
   virtual tVoid sendAffordable_Its_SetupLdwMResult(tBool Result);
   virtual tVoid sendIPA_SetHMIStatusMResult(tBool Result);
   virtual tVoid sendIPA_SetButtonMResult(tBool Result);
   virtual tVoid sendIPA_Voice_TextsMResult(tBool Result);
   virtual tVoid sendMVC_HMI_ViewRequestMResult(tBool Result);
   virtual tVoid sendGdlAdj_AdjustmentCompleteMResult(tBool Result);
   virtual tVoid sendGdlAdj_AdjustButtonMResult(tBool Result);
   virtual tVoid sendGdlAdj_ConfigurationDataMResult(tBool Result, rvc_fi_tcl_e8_GdlAdj_Request e8Request, std::vector<rvc_fi_tcl_GdlAdj_ConfigParameterData, std::allocator<rvc_fi_tcl_GdlAdj_ConfigParameterData> > arConfigParameterData);
   virtual tVoid sendFAP_SetButtonMResult(tBool Result);
   virtual tVoid sendTouchEventMResult(tBool Result);
   virtual tVoid sendGPSInfoMResult(tBool Result);
   virtual tVoid sendMapMatchedInfoMResult(tBool Result);
   virtual tVoid sendFapLearnParkPositionMResult(tBool Result);
   virtual tVoid sendSetFapGuidanceMResult(tBool Result);
   virtual tVoid sendAVM3_SetSwitchMResult(tBool bResult);
   virtual tVoid sendAVM3_SetSonarBuzzerStatusMResult(tBool bResult);
   virtual tVoid sendAVM3_Settings_Detailed_SendReqMResult(tBool bResult);
   virtual tVoid sendAVM3_Settings_Primary_SendReqMResult(tBool bResult);
   virtual tVoid sendAVM3_GetVersionInfoMResult(tBool bResult);
   virtual tVoid sendAVM3_GetCommunicationErrorsMResult(tBool bResult);
   virtual tVoid sendAVM3_ClearCommunicationErrorsMResult(tBool bResult);
   virtual tVoid sendToggleGpioPinOnOffMResult();


   virtual tVoid onCameraButtonMStart(rvc_fi_tcl_e8_RVC_ButtonState e8ButtonState);
   virtual tVoid onSetStatusHmiMStart(rvc_fi_tcl_e8_RVC_Status e8StatusHmi);
   virtual tVoid onSetupLanguageMStart(rvc_fi_tcl_e8_RVC_Language e8Language);
   virtual tVoid onSetupGuideLineMStart(rvc_fi_tcl_e8_RVC_StatusGuideLine e8GuideLine);
   virtual tVoid onSetupVideoControlsMStart(rvc_fi_tcl_e8_RVC_VideoParameterDimmingMode e8HMIDimmingMode, rvc_fi_tcl_e8_MVCViewingState e8MVCViewingState, std::vector<rvc_fi_tcl_RVC_VideoAnalogLevels, std::allocator<rvc_fi_tcl_RVC_VideoAnalogLevels> > arVideoControlParameter);
   virtual tVoid onSetSystemStatusMStart(rvc_fi_tcl_e8_RVC_SystemStatus e8SystemStatus, rvc_fi_tcl_e8_RVC_StatusGuideLine e8GuideLine, rvc_fi_tcl_e8_RVC_StatusWarningText e8WarningText);
   virtual tVoid onrunExtDevicePowerSupplyTestMStart(tU16 pwrSupplyID);
   virtual tVoid onInitializeMStart(rvc_fi_tcl_e8_RVC_Module e8Module);
   virtual tVoid onConfirmSystemStatusMStart(rvc_fi_tcl_e8_RVC_SystemStatus e8SystemStatus);
   virtual tVoid onSetupUserConfigurationMStart(std::vector<rvc_fi_tcl_ParkAssist_UserConfiguration, std::allocator<rvc_fi_tcl_ParkAssist_UserConfiguration> > arUserConfiguration);
   virtual tVoid onSetMicrophoneStateMStart(rvc_fi_tcl_e8_Set_MicState e8RequestState);
   virtual tVoid onSetRVCStatusMStart(tU8 e8RequestState);
   virtual tVoid onCamera_SetupBeepMStart(rvc_fi_tcl_e8_AVM_StatusBeep e8SetupBeep);
   virtual tVoid onSetCamerastateMStart(rvc_fi_tcl_e8_RVC_CameraState CameraState);
   virtual tVoid onChangeViewRequestMStart(rvc_fi_tcl_e8_AVM_View_Request u8Status);
   virtual tVoid onAffordable_Its_SetupBswMStart(tU8 u8Status);
   virtual tVoid onAffordable_Its_SetupModMStart(tU8 u8Status);
   virtual tVoid onAffordable_Its_SetupLdwMStart(tU8 u8Status);
   virtual tVoid onIPA_SetHMIStatusMStart(rvc_fi_tcl_e8_IPA_HMIStatus e8IPAStatus);
   virtual tVoid onIPA_SetButtonMStart(rvc_fi_tcl_e8_IPA_BUTTON_ID e8ButtonIdentifier, rvc_fi_tcl_e8_RVC_ButtonState e8ButtonStatus);
   virtual tVoid onIPA_Voice_TextsMStart(rvc_fi_tcl_e8_RVC_Language Language, std::vector<rvc_fi_tcl_IPA_Voice_Text_Strings, std::allocator<rvc_fi_tcl_IPA_Voice_Text_Strings> > arTexts);
   virtual tVoid onMVC_HMI_ViewRequestMStart(rvc_fi_tcl_e8_MVCViewingState e8Request);
   virtual tVoid onGdlAdj_AdjustmentCompleteMStart(rvc_fi_tcl_e8_GdlAdj_Completion e8Completion);
   virtual tVoid onGdlAdj_AdjustButtonMStart(rvc_fi_tcl_e8_GdlAdj_AdjustButton e8Button);
   virtual tVoid onGdlAdj_ConfigurationDataMStart(rvc_fi_tcl_e8_GdlAdj_Request e8Request, std::vector<rvc_fi_tcl_GdlAdj_ConfigParameterData, std::allocator<rvc_fi_tcl_GdlAdj_ConfigParameterData> > arConfigParameterData);
   virtual tVoid onFAP_SetButtonMStart(rvc_fi_tcl_e8_IPA_BUTTON_ID e8ButtonIdentifier, rvc_fi_tcl_e8_RVC_ButtonState e8ButtonStatus);
   virtual tVoid onTouchEventMStart(rvc_fi_tcl_Touch_Data arTouchData);
   virtual tVoid onGPSInfoMStart(rvc_fi_tcl_GPS_Data arGpsData);
   virtual tVoid onMapMatchedInfoMStart(rvc_fi_tcl_MapMatched_Data arMapMatchedData);
   virtual tVoid onFapLearnParkPositionMStart(tBool RequestOn);
   virtual tVoid onSetFapGuidanceMStart(tBool Request);
   virtual tVoid onAVM3_SetSwitchMStart(rvc_fi_tcl_e8_AVMph3_SwitchId e8SwitchId);
   virtual tVoid onAVM3_SetSonarBuzzerStatusMStart(rvc_fi_tcl_e8_AVMph3_BuzzerStatus e8BuzzerStatus);
   virtual tVoid onAVM3_Settings_Detailed_SendReqMStart(rvc_fi_tcl_e8_AVMph3_RequestType e8RequestType, std::vector<rvc_fi_tcl_AVMph3_Setting_Item, std::allocator<rvc_fi_tcl_AVMph3_Setting_Item> > arChangedItems);
   virtual tVoid onAVM3_Settings_Primary_SendReqMStart(rvc_fi_tcl_e8_AVMph3_RequestType e8RequestType, rvc_fi_tcl_e8_AVMph3_SettingOptionState e8AvmSonarBuzzer, tBool bDetailsSettingsAvail, tBool bImageQualitySettingAvail);
   virtual tVoid onAVM3_GetVersionInfoMStart(rvc_fi_tcl_e8_AVMph3_VersionInfoType e8VersionType);
   virtual tVoid onAVM3_GetCommunicationErrorsMStart();
   virtual tVoid onAVM3_ClearCommunicationErrorsMStart();
   virtual tVoid onToggleGpioPinOnOffMStart();

   virtual void vGetSystemConfigurationsMsg(rvc_ccafi_tclMsgSystemConfigurationsStatus& oStatus) {if (_poServerRef) _poServerRef->vGetSystemConfigurationsMsg(oStatus);}
   virtual void vGetSystemStatusMsg(rvc_ccafi_tclMsgSystemStatusStatus& oStatus) {if (_poServerRef) _poServerRef->vGetSystemStatusMsg(oStatus);}
   virtual void vGetVideoSignalStatusMsg(rvc_ccafi_tclMsgVideoSignalStatusStatus& oStatus) {if (_poServerRef) _poServerRef->vGetVideoSignalStatusMsg(oStatus);}
   virtual void vGetReverseSignalStatusMsg(rvc_ccafi_tclMsgReverseSignalStatusStatus& oStatus) {if (_poServerRef) _poServerRef->vGetReverseSignalStatusMsg(oStatus);}
   virtual void vGetCamera_PwrSupplyStatusMsg(rvc_ccafi_tclMsgCamera_PwrSupplyStatusStatus& oStatus) {if (_poServerRef) _poServerRef->vGetCamera_PwrSupplyStatusMsg(oStatus);}
   virtual void vGetMicrophone_PwrSupplyStatusMsg(rvc_ccafi_tclMsgMicrophone_PwrSupplyStatusStatus& oStatus) {if (_poServerRef) _poServerRef->vGetMicrophone_PwrSupplyStatusMsg(oStatus);}
   virtual void vGetTailgate_StatusMsg(rvc_ccafi_tclMsgTailgate_StatusStatus& oStatus) {if (_poServerRef) _poServerRef->vGetTailgate_StatusMsg(oStatus);}
   virtual void vGetView_Close_AuthorizedMsg(rvc_ccafi_tclMsgView_Close_AuthorizedStatus& oStatus) {if (_poServerRef) _poServerRef->vGetView_Close_AuthorizedMsg(oStatus);}
   virtual void vGetAvmR_Current_ViewMsg(rvc_ccafi_tclMsgAvmR_Current_ViewStatus& oStatus) {if (_poServerRef) _poServerRef->vGetAvmR_Current_ViewMsg(oStatus);}
   virtual void vGetAffordable_ITSMsg(rvc_ccafi_tclMsgAffordable_ITSStatus& oStatus) {if (_poServerRef) _poServerRef->vGetAffordable_ITSMsg(oStatus);}
   virtual void vGetIPAConfigurationMsg(rvc_ccafi_tclMsgIPAConfigurationStatus& oStatus) {if (_poServerRef) _poServerRef->vGetIPAConfigurationMsg(oStatus);}
   virtual void vGetIPAStatusMsg(rvc_ccafi_tclMsgIPAStatusStatus& oStatus) {if (_poServerRef) _poServerRef->vGetIPAStatusMsg(oStatus);}
   virtual void vGetIPAPatternRequestMsg(rvc_ccafi_tclMsgIPAPatternRequestStatus& oStatus) {if (_poServerRef) _poServerRef->vGetIPAPatternRequestMsg(oStatus);}
   virtual void vGetIPAMessageRequestMsg(rvc_ccafi_tclMsgIPAMessageRequestStatus& oStatus) {if (_poServerRef) _poServerRef->vGetIPAMessageRequestMsg(oStatus);}
   virtual void vGetIPASwitchMaskRequestMsg(rvc_ccafi_tclMsgIPASwitchMaskRequestStatus& oStatus) {if (_poServerRef) _poServerRef->vGetIPASwitchMaskRequestMsg(oStatus);}
   virtual void vGetIPASwitchGreyOutRequestMsg(rvc_ccafi_tclMsgIPASwitchGreyOutRequestStatus& oStatus) {if (_poServerRef) _poServerRef->vGetIPASwitchGreyOutRequestMsg(oStatus);}
   virtual void vGetIPADirectionIndicatorMsg(rvc_ccafi_tclMsgIPADirectionIndicatorStatus& oStatus) {if (_poServerRef) _poServerRef->vGetIPADirectionIndicatorMsg(oStatus);}
   virtual void vGetGdlAdj_SteeringAngleMsg(rvc_ccafi_tclMsgGdlAdj_SteeringAngleStatus& oStatus) {if (_poServerRef) _poServerRef->vGetGdlAdj_SteeringAngleMsg(oStatus);}
   virtual void vGetGdlAdj_CameraAngleMsg(rvc_ccafi_tclMsgGdlAdj_CameraAngleStatus& oStatus) {if (_poServerRef) _poServerRef->vGetGdlAdj_CameraAngleMsg(oStatus);}
   virtual void vGetCANFrameStatusMsg(rvc_ccafi_tclMsgCANFrameStatusStatus& oStatus) {if (_poServerRef) _poServerRef->vGetCANFrameStatusMsg(oStatus);}
   virtual void vGetMvcViewStatusMsg(rvc_ccafi_tclMsgMvcViewStatusStatus& oStatus) {if (_poServerRef) _poServerRef->vGetMvcViewStatusMsg(oStatus);}
   virtual void vGetMvcAlertRequestMsg(rvc_ccafi_tclMsgMvcAlertRequestStatus& oStatus) {if (_poServerRef) _poServerRef->vGetMvcAlertRequestMsg(oStatus);}
   virtual void vGetFAPModeMsg(rvc_ccafi_tclMsgFAPModeStatus& oStatus) {if (_poServerRef) _poServerRef->vGetFAPModeMsg(oStatus);}
   virtual void vGetFAPSettingsMsg(rvc_ccafi_tclMsgFAPSettingsStatus& oStatus) {if (_poServerRef) _poServerRef->vGetFAPSettingsMsg(oStatus);}
   virtual void vGetFAPGuidanceStateMsg(rvc_ccafi_tclMsgFAPGuidanceStateStatus& oStatus) {if (_poServerRef) _poServerRef->vGetFAPGuidanceStateMsg(oStatus);}
   virtual void vGetAVM3_DispStatusMsg(rvc_ccafi_tclMsgAVM3_DispStatusStatus& oStatus) {if (_poServerRef) _poServerRef->vGetAVM3_DispStatusMsg(oStatus);}
   virtual void vGetAVM3_ViewSetupMsg(rvc_ccafi_tclMsgAVM3_ViewSetupStatus& oStatus) {if (_poServerRef) _poServerRef->vGetAVM3_ViewSetupMsg(oStatus);}
   virtual void vGetAVM3_ErrorMessageMsg(rvc_ccafi_tclMsgAVM3_ErrorMessageStatus& oStatus) {if (_poServerRef) _poServerRef->vGetAVM3_ErrorMessageMsg(oStatus);}
   virtual void vGetAVM3_SonarBuzzerStatusMsg(rvc_ccafi_tclMsgAVM3_SonarBuzzerStatusStatus& oStatus) {if (_poServerRef) _poServerRef->vGetAVM3_SonarBuzzerStatusMsg(oStatus);}
   virtual void vGetAVM3_Settings_DetailedMsg(rvc_ccafi_tclMsgAVM3_Settings_DetailedStatus& oStatus) {if (_poServerRef) _poServerRef->vGetAVM3_Settings_DetailedMsg(oStatus);}
   virtual void vGetAVM3_Settings_PrimaryMsg(rvc_ccafi_tclMsgAVM3_Settings_PrimaryStatus& oStatus) {if (_poServerRef) _poServerRef->vGetAVM3_Settings_PrimaryMsg(oStatus);}
   virtual void vGetAVM3_ConfigurationMsg(rvc_ccafi_tclMsgAVM3_ConfigurationStatus& oStatus) {if (_poServerRef) _poServerRef->vGetAVM3_ConfigurationMsg(oStatus);}
   virtual void vGetAVM3_Software_VersionMsg(rvc_ccafi_tclMsgAVM3_Software_VersionStatus& oStatus) {if (_poServerRef) _poServerRef->vGetAVM3_Software_VersionMsg(oStatus);}
   virtual void vGetAVM3_Hardware_VersionMsg(rvc_ccafi_tclMsgAVM3_Hardware_VersionStatus& oStatus) {if (_poServerRef) _poServerRef->vGetAVM3_Hardware_VersionMsg(oStatus);}
   virtual void vGetAVM3_CommunicationErrorsMsg(rvc_ccafi_tclMsgAVM3_CommunicationErrorsStatus& oStatus) {if (_poServerRef) _poServerRef->vGetAVM3_CommunicationErrorsMsg(oStatus);}

private:
   Idispvidctrl_tclServiceRvc* _poServerRef;

// dispvidctrl_tclServiceRvcIfDeclarationsPart2: user specific code start

   dispvidctrl_tclControl*         m_poControl;
   dispvidctrl_tclControl_Avm*     m_poControl_Avm;
   dispvidctrl_tclControl_Hmi*     m_poControl_Hmi;
   dispvidctrl_tclControl_Rvc*     m_poControl_Rvc;
   dispvidctrl_tclControl_Mvc*     m_poControl_Mvc;
   dispvidctrl_tclControl_Video*   m_poControl_Video;
   dispvidctrl_tclControl_HmiAvm3* m_poControl_HmiAvm3;
   I_dispvidctrl_tclMCanClientAvm* m_poClient_Avm3;
   I_dispvidctrl_tclVideoPlayer*      m_poClient_VideoPlayer;
   
   tBool m_bAvmMode;
   tBool m_bRvcMode;
   tBool m_bMvcMode;
   tBool m_bAvmType_Phase3;
// dispvidctrl_tclServiceRvcIfDeclarationsPart2: user specific code end

};

#endif // __dispvidctrl_ServiceRvcIf__IF__H_


