/*****************************************************************************
* FILE:         dispvidctrl_ServiceRvcIf.cpp
* PROJECT:      G3G project
* SW-COMPONENT: dispvidctrl
* Template:     ServiceIf.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  
*               Generated file
*               Do here service handler specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2020 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/



// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETG_S_IMPORT_INTERFACE_GENERIC
#define ETG_S_IMPORT_INTERFACE_PLATFORM
#include "etg_if.h"

// dispvidctrl_tclServiceRvcIfIncludes: user specific code start
#include "dispvidctrl_tclControl.h"
#include "dispvidctrl_tclControl_Hmi.h"
#include "dispvidctrl_tclControl_Rvc.h"
#include "dispvidctrl_tclControl_Video.h"
#include "dispvidctrl_tclControl_Avm.h"
#include "dispvidctrl_tclControl_Mvc.h"
#include "dispvidctrl_tclControl_HmiAvm3.h"
#include "Idispvidctrl_ClientAvm.h"
// dispvidctrl_tclServiceRvcIfIncludes: user specific code end

#include "dispvidctrl_ServiceRvcIf.h"
#include "I_dispvidctrl_ServiceRvc.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DISPVIDCTRL_SERVER_RVC
#include "trcGenProj/Header/dispvidctrl_ServiceRvcIf.cpp.trc.h"
#endif

#define ENABLE 1
/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: dispvidctrl_tclServiceRvcIf::
*             dispvidctrl_tclServiceRvcIf(dispvidctrl_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
dispvidctrl_tclServiceRvcIf::dispvidctrl_tclServiceRvcIf(dispvidctrl_tclAppMain* poMainAppl) : 
Idispvidctrl_tclServiceRvcIf(poMainAppl)
{
   ETG_TRACE_USR4(("dispvidctrl_tclServiceRvcIf() entered."));
   _poServerRef = OSAL_NULL;

   // dispvidctrl_tclServiceRvcIfConstructor: user specific code start
   m_poControl     = OSAL_NULL;
   m_poControl_Avm = OSAL_NULL;
   m_poControl_Hmi = OSAL_NULL;
   m_poControl_Rvc = OSAL_NULL;
   m_poControl_Mvc = OSAL_NULL;
   m_poControl_Video = OSAL_NULL;
   m_poControl_HmiAvm3 = OSAL_NULL;
   m_poClient_Avm3 = OSAL_NULL;
   m_poClient_VideoPlayer = OSAL_NULL;

   m_bRvcMode = FALSE;
   m_bAvmMode = FALSE;
   m_bMvcMode = FALSE;
   m_bAvmType_Phase3 = FALSE;
   // dispvidctrl_tclServiceRvcIfConstructor: user specific code end

   //__PRPPERTY_PARAM_INIT__
}

/*******************************************************************************
*
* FUNCTION: dispvidctrl_tclServiceRvcIf::
*             ~dispvidctrl_tclServiceRvcIf(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
dispvidctrl_tclServiceRvcIf::~dispvidctrl_tclServiceRvcIf(tVoid)
{
   ETG_TRACE_USR4(("~dispvidctrl_tclServiceRvcIf() entered."));
   _poServerRef = OSAL_NULL;
   
   // dispvidctrl_tclServiceRvcIfDestructor: user specific code start
   m_poControl     = OSAL_NULL;
   m_poControl_Avm = OSAL_NULL;
   m_poControl_Hmi = OSAL_NULL;
   m_poControl_Rvc = OSAL_NULL;
   m_poControl_Mvc = OSAL_NULL;
   m_poControl_Video = OSAL_NULL;
   m_poControl_HmiAvm3 = OSAL_NULL;
   m_poClient_Avm3 = OSAL_NULL;
   m_poClient_VideoPlayer  = OSAL_NULL;
   // dispvidctrl_tclServiceRvcIfDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclServiceRvcIf::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'dispvidctrl_ServiceRvcIf.h':
*     Add forward declaration:
*         class Idispvidctrl_tclObject2Get;
*
*     Add declaration of object reference:
*         Idispvidctrl_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Idispvidctrl_tclObject2Get*>(_cpoMain->getHandler("Idispvidctrl_tclObject2Get"));
*     RVC_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclServiceRvcIf::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("dispvidctrl_tclServiceRvcIf::vGetReferences() entered."));

   _poServerRef = dynamic_cast<Idispvidctrl_tclServiceRvc*>(_cpoMain->getHandler("Idispvidctrl_tclServiceRvc"));

   DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);

   _poServerRef->vSetCallbackIf(this);

   //set callback interface

   // dispvidctrl_tclServiceRvcIfvGetReferences: user specific code start
      m_poControl = dynamic_cast<dispvidctrl_tclControl*>(_cpoMain->getHandler("dispvidctrl_tclControl"));
      DISPVIDCTRL_NULL_POINTER_CHECK(m_poControl);
      
      m_poControl_Avm = dynamic_cast<dispvidctrl_tclControl_Avm*>(_cpoMain->getHandler("dispvidctrl_tclControl_Avm"));
      DISPVIDCTRL_NULL_POINTER_CHECK(m_poControl_Avm);
      
      m_poControl_Hmi = dynamic_cast<dispvidctrl_tclControl_Hmi*>(_cpoMain->getHandler("dispvidctrl_tclControl_Hmi"));
      DISPVIDCTRL_NULL_POINTER_CHECK(m_poControl_Hmi);
      
      m_poControl_Rvc = dynamic_cast<dispvidctrl_tclControl_Rvc*>(_cpoMain->getHandler("dispvidctrl_tclControl_Rvc"));
      DISPVIDCTRL_NULL_POINTER_CHECK(m_poControl_Rvc);
      
      m_poControl_Mvc = dynamic_cast<dispvidctrl_tclControl_Mvc*>(_cpoMain->getHandler("dispvidctrl_tclControl_Mvc"));
      DISPVIDCTRL_NULL_POINTER_CHECK(m_poControl_Mvc);
      
      m_poControl_Video = dynamic_cast<dispvidctrl_tclControl_Video*>(_cpoMain->getHandler("dispvidctrl_tclControl_Video"));
      DISPVIDCTRL_NULL_POINTER_CHECK(m_poControl_Video);

      m_poControl_HmiAvm3 = dynamic_cast<dispvidctrl_tclControl_HmiAvm3*>(_cpoMain->getHandler("dispvidctrl_tclControl_HmiAvm3"));
      DISPVIDCTRL_NULL_POINTER_CHECK(m_poControl_HmiAvm3);
      
      m_poClient_Avm3 = dynamic_cast<I_dispvidctrl_tclMCanClientAvm*>(_cpoMain->getHandler("I_dispvidctrl_tclMCanClientAvm"));
      DISPVIDCTRL_NULL_POINTER_CHECK(m_poClient_Avm3);

      m_poClient_VideoPlayer = dynamic_cast<I_dispvidctrl_tclVideoPlayer*>(_cpoMain->getHandler("I_dispvidctrl_tclVideoPlayer"));
      DISPVIDCTRL_NULL_POINTER_CHECK(m_poClient_VideoPlayer);
   // dispvidctrl_tclServiceRvcIfvGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclServiceRvcIf::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclServiceRvcIf::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("dispvidctrl_tclServiceRvcIf::vStartCommunication() entered."));
   // dispvidctrl_tclServiceRvcIfvStartCommunication: user specific code start
   // dispvidctrl_tclServiceRvcIfvStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclServiceRvcIf::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclServiceRvcIf::vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("dispvidctrl_tclServiceRvcIf::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(dispvidctrl_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   // dispvidctrl_tclServiceRvcIfvHandleMessage: user specific code start
   switch (pMsg->eCmd)
   {
      case dispvidctrl_tclBaseIf::eReverseOff:
         {
            rvc_fi_tcl_e8_RVC_ReverseSignalStatus e8StatusReverseSignal;

            e8StatusReverseSignal.enType = rvc_fi_tcl_e8_RVC_ReverseSignalStatus::FI_EN_OFF;
            sendReverseSignalStatusStatus(e8StatusReverseSignal);
         }
         break;
      case dispvidctrl_tclBaseIf::eReverseOn:
         {
            rvc_fi_tcl_e8_RVC_ReverseSignalStatus e8StatusReverseSignal;

            e8StatusReverseSignal.enType = rvc_fi_tcl_e8_RVC_ReverseSignalStatus::FI_EN_ON;
            sendReverseSignalStatusStatus(e8StatusReverseSignal);
         }
         break;
      case dispvidctrl_tclBaseIf::eReverseOnDebounced:
         {
            rvc_fi_tcl_e8_RVC_ReverseSignalStatus e8StatusReverseSignal;

            e8StatusReverseSignal.enType = rvc_fi_tcl_e8_RVC_ReverseSignalStatus::FI_EN_ON_NISSANDEBOUNCED;
            sendReverseSignalStatusStatus(e8StatusReverseSignal);
         }
         break;
      default:
         break;
   }
   // dispvidctrl_tclServiceRvcIfvHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclServiceRvcIf::vHandleTraceMessage()
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclServiceRvcIf::vHandleTraceMessage(const tUChar* puchData)
{
   DISPVIDCTRL_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("dispvidctrl_tclServiceRvcIf::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // dispvidctrl_tclServiceRvcIfvHandleTraceMessage: user specific code start
   // dispvidctrl_tclServiceRvcIfvHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclServiceRvcIf::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclServiceRvcIf::vTraceInfo()
{
   // dispvidctrl_tclServiceRvcIfvTraceInfo: user specific code start
   // dispvidctrl_tclServiceRvcIfvTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclServiceRvcIf::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid dispvidctrl_tclServiceRvcIf::onServiceAvailable()
{
   ETG_TRACE_USR4(("dispvidctrl_tclServiceRvcIf::onServiceAvailable() entered."));

   // dispvidctrl_tclServiceRvcIfvOnServiceAvailable: user specific code start
   // dispvidctrl_tclServiceRvcIfvOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclServiceRvcIf::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid dispvidctrl_tclServiceRvcIf::onServiceUnavailable()
{
   ETG_TRACE_USR4(("dispvidctrl_tclServiceRvcIf::onServiceUnavailable() entered."));

   // dispvidctrl_tclServiceRvcIfvOnServiceUnavailable: user specific code start
   // dispvidctrl_tclServiceRvcIfvOnServiceUnavailable: user specific code end
}


tVoid dispvidctrl_tclServiceRvcIf::onCameraButtonMStart(rvc_fi_tcl_e8_RVC_ButtonState e8ButtonState) {

   // onCameraButtonMStart: user specific code start
      if (m_poControl_Hmi && m_poControl_Avm)
      {
         switch (e8ButtonState.enType)
         {
            case rvc_fi_tcl_e8_RVC_ButtonState::FI_EN_PRESSED:
               ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onCameraButtonMStart -> PRESSED"));
               if (m_bRvcMode) {
                  m_poControl_Hmi->vHandleControl(EN_CONTROL_HMI__TOGGLE_GUIDELINES);
               }
               if (m_bAvmMode) {
                  m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__CAMERA_BUTTON_PRESS, 0);
               }
            break;
            case rvc_fi_tcl_e8_RVC_ButtonState::FI_EN_SHORTPRESSED:
               ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onCameraButtonMStart -> SHORTPRESSED"));
               if (m_bRvcMode) {
                  m_poControl_Hmi->vHandleControl(EN_CONTROL_HMI__TOGGLE_GUIDELINES);
               }
               if (m_bAvmMode) {
                  m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__CAMERA_BUTTON_PRESS, 0);
               }
            break;
            case rvc_fi_tcl_e8_RVC_ButtonState::FI_EN_LONGPRESSED:
               ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onCameraButtonMStart -> LONGPRESSED"));
               if (m_bAvmMode) {
                  m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__CAMERA_BUTTON_LONG_PRESS, (tU32) 0);
               }
            break;
            default:
               ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onCameraButtonMStart -> RELEASED"));
               if (m_bAvmMode) {
                  m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__CAMERA_BUTTON_RELEASE, 0);
               }
            break;
         }
      }
      sendCameraButtonMResult(TRUE);
   // onCameraButtonMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvcIf::onSetStatusHmiMStart(rvc_fi_tcl_e8_RVC_Status e8StatusHmi) {

   // onSetStatusHmiMStart: user specific code start
      rvc_fi_tcl_e8_RVC_SystemStatus e8SystemStatus;

      if (m_poControl)
      {
         if (e8StatusHmi.enType == rvc_fi_tcl_e8_RVC_Status::FI_EN_AVAILABLE)
         {
            ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onSetStatusHmiMStart -> HMI available"));
            m_poControl->vHandleControl(EN_CONTROL__HMI_AVAILABLE, (tU32) TRUE);
         }
         else
         {
            ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onSetStatusHmiMStart -> HMI not available"));
            m_poControl->vHandleControl(EN_CONTROL__HMI_AVAILABLE, (tU32) FALSE);
         }
      }
   // onSetStatusHmiMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvcIf::onSetupLanguageMStart(rvc_fi_tcl_e8_RVC_Language e8Language) {

   // onSetupLanguageMStart: user specific code start
      ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onSetupLanguageMStart -> language: %d", e8Language.enType));

      if(m_poControl_Video)
      {
         m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__USER_SETTING_VALUE__LANGUAGE, (tU32) e8Language.enType);

         // all received values evaluated, now we can update the system
         m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__USER_SETTING_UPDATE__LANGUAGE);
      }
      if(m_poControl_Avm && m_bAvmMode)
      {
         m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__UPDATE_LANGUAGE, (tU32) e8Language.enType);
      }

      sendSetupLanguageMResult(TRUE);
   // onSetupLanguageMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvcIf::onSetupGuideLineMStart(rvc_fi_tcl_e8_RVC_StatusGuideLine e8GuideLine) {

   // onSetupGuideLineMStart: user specific code start
      if (m_poControl_Video && m_poControl_Mvc)
      {
         switch (e8GuideLine.enType)
         {
            case rvc_fi_tcl_e8_RVC_StatusGuideLine::FI_EN_STATICGUIDELINEOFF:         
            {
               ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onSetupGuideLineMStart -> Setting: Static Guideline OFF"));
               /*if (m_bMvcMode) { 
                  m_poControl_Mvc->vHandleControl(EN_CONTROL_MVC__STATIC_GUIDELINE_USER_SETTING_CHANGE, 0); //Removed as HMI user setting is handled in dispvidctrl_tclControl_Video.cpp NCG3D-77436
               }*/
               m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__USER_SETTING_VALUE__GUIDELINE_STATIC_SIDE, 0);
            }
            break;         
            case rvc_fi_tcl_e8_RVC_StatusGuideLine::FI_EN_STATICGUIDELINEON:
            {
               ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onSetupGuideLineMStart -> Setting: Static Guideline ON "));
               /*if (m_bMvcMode) {
                  m_poControl_Mvc->vHandleControl(EN_CONTROL_MVC__STATIC_GUIDELINE_USER_SETTING_CHANGE, 1); //Removed as HMI user setting is handled in dispvidctrl_tclControl_Video.cpp NCG3D-77436
               }*/
               m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__USER_SETTING_VALUE__GUIDELINE_STATIC_SIDE, 1);
            }
            break;            
            case rvc_fi_tcl_e8_RVC_StatusGuideLine::FI_EN_DYNAMICGUIDELINEOFF:         
            {
               ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onSetupGuideLineMStart -> Setting: Dynamic Guideline OFF"));
               m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__USER_SETTING_VALUE__GUIDELINE_DYNAMIC, 0);
            }
            break;         
            case rvc_fi_tcl_e8_RVC_StatusGuideLine::FI_EN_DYNAMICGUIDELINEON:
            {
               ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onSetupGuideLineMStart -> Setting: Dynamic Guideline ON "));
               m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__USER_SETTING_VALUE__GUIDELINE_DYNAMIC, 1);
            }
            break;
            
            default:
               ETG_TRACE_ERR(("dispvidctrl_tclServiceRVCIf::onSetupGuideLineMStart -> Setting: Guideline Status as %u", e8GuideLine.enType));
               break;
         }

         // all received values evaluated, now we can update the system
         m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__USER_SETTING_UPDATE__GUIDELINE);
      }
      sendSetupGuideLineMResult(TRUE);
   // onSetupGuideLineMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvcIf::onSetupVideoControlsMStart(rvc_fi_tcl_e8_RVC_VideoParameterDimmingMode e8HMIDimmingMode, rvc_fi_tcl_e8_MVCViewingState e8MVCViewingState, std::vector<rvc_fi_tcl_RVC_VideoAnalogLevels, std::allocator<rvc_fi_tcl_RVC_VideoAnalogLevels> > arVideoControlParameter) {

   // onSetupVideoControlsMStart: user specific code start
      (tVoid) e8MVCViewingState;
      tBool  bResult = TRUE;
      tU8    u8NumberOfListElements = 0;
      tU8    u8ParameterValue;

      if (m_poControl_Video)
      {
         // Dimming Mode we get via Dimming Client now
         (tVoid) e8HMIDimmingMode;
         //if (e8HMIDimmingMode.enType ==  rvc_fi_tcl_e8_RVC_VideoParameterDimmingMode::FI_EN_NIGHT) {
         //   ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onSetupVideoControlsMStart -> Dimming Mode NIGHT"));
         //   m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__USER_SETTING_VALUE__DISPLAY_DIMMING_MODE, (tU32) DISPVIDCTRL_VIDEO__DISPLAY_DIMMING_MODE_NIGHT);
         //}
         //else if  (e8HMIDimmingMode.enType ==  rvc_fi_tcl_e8_RVC_VideoParameterDimmingMode::FI_EN_DAY) {
         //   ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onSetupVideoControlsMStart -> Dimming Mode DAY"));
         //   m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__USER_SETTING_VALUE__DISPLAY_DIMMING_MODE, (tU32) DISPVIDCTRL_VIDEO__DISPLAY_DIMMING_MODE_DAY);
         //}
         //else {
         //   ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onSetupVideoControlsMStart -> Dimming Mode INFO NOK"));
         //   bResult = FALSE;
         //}

         u8NumberOfListElements = arVideoControlParameter.size();
         if (u8NumberOfListElements > 0)
         {
            for (tU8 i = 0; i < u8NumberOfListElements; i++)
            {
               u8ParameterValue = arVideoControlParameter[i].u8Value;
               if (u8ParameterValue <= 100)
               {
                  switch (arVideoControlParameter[i].e8Type.enType)
                  {
                     case rvc_fi_tcl_e8_RVC_VideoParameterType::FI_EN_BRIGHTNESS:
                     {
                        if (arVideoControlParameter[i].e8DimmingMode.enType ==  rvc_fi_tcl_e8_RVC_VideoParameterDimmingMode::FI_EN_DAY)
                        {
                           ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onSetupVideoControlsMStart -> Brightness DAY value: %d", u8ParameterValue));
                           m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__USER_SETTING_VALUE__BRIGHTNESS_DAY, (tU32) u8ParameterValue);
                        }
                        else if (arVideoControlParameter[i].e8DimmingMode.enType ==  rvc_fi_tcl_e8_RVC_VideoParameterDimmingMode::FI_EN_NIGHT)
                        {
                           ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onSetupVideoControlsMStart -> Brightness NIGHT value: %d", u8ParameterValue));
                           m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__USER_SETTING_VALUE__BRIGHTNESS_NIGHT, (tU32) u8ParameterValue);
                        }
                        else
                        {
                           ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onSetupVideoControlsMStart -> Brightness Data ERROR"));
                           bResult = FALSE;
                        }
                     }
                     break;
                     case rvc_fi_tcl_e8_RVC_VideoParameterType::FI_EN_CONTRAST:
                     {
                        if (arVideoControlParameter[i].e8DimmingMode.enType ==  rvc_fi_tcl_e8_RVC_VideoParameterDimmingMode::FI_EN_DAY)
                        {
                           ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onSetupVideoControlsMStart -> Contrast DAY value: %d", u8ParameterValue));
                           m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__USER_SETTING_VALUE__CONTRAST_DAY, (tU32) u8ParameterValue);
                        }
                        else if (arVideoControlParameter[i].e8DimmingMode.enType == rvc_fi_tcl_e8_RVC_VideoParameterDimmingMode::FI_EN_NIGHT)
                        {
                           ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onSetupVideoControlsMStart -> Contrast NIGHT value: %d", u8ParameterValue));
                           m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__USER_SETTING_VALUE__CONTRAST_NIGHT, (tU32) u8ParameterValue);
                        }
                        else
                        {
                           ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onSetupVideoControlsMStart -> Contrast Data ERROR"));
                           bResult = FALSE;
                        }
                     }
                     break;
                     case rvc_fi_tcl_e8_RVC_VideoParameterType::FI_EN_COLOR:
                     {
                        if (arVideoControlParameter[i].e8DimmingMode.enType ==  rvc_fi_tcl_e8_RVC_VideoParameterDimmingMode::FI_EN_DAY) {
                           ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onSetupVideoControlsMStart -> Color DAY value: %d", u8ParameterValue));
                           m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__USER_SETTING_VALUE__COLOUR_DAY, (tU32) u8ParameterValue);
                        }
                        else if (arVideoControlParameter[i].e8DimmingMode.enType ==  rvc_fi_tcl_e8_RVC_VideoParameterDimmingMode::FI_EN_NIGHT)   {
                           ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onSetupVideoControlsMStart -> Color NIGHT value: %d", u8ParameterValue));
                           m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__USER_SETTING_VALUE__COLOUR_NIGHT, (tU32) u8ParameterValue);
                        }
                        else{
                           ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onSetupVideoControlsMStart -> Color Data ERROR"));
                           bResult = FALSE;
                        }
                     }
                     break;
                     case rvc_fi_tcl_e8_RVC_VideoParameterType::FI_EN_HUE:
                     {
                        if (arVideoControlParameter[i].e8DimmingMode.enType ==  rvc_fi_tcl_e8_RVC_VideoParameterDimmingMode::FI_EN_DAY) {
                           ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onSetupVideoControlsMStart -> Hue DAY value: %d", u8ParameterValue));
                           m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__USER_SETTING_VALUE__HUE_DAY, (tU32) u8ParameterValue);
                        }
                        else if (arVideoControlParameter[i].e8DimmingMode.enType ==  rvc_fi_tcl_e8_RVC_VideoParameterDimmingMode::FI_EN_NIGHT) {
                           ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onSetupVideoControlsMStart -> Hue NIGHT value: %d", u8ParameterValue));
                           m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__USER_SETTING_VALUE__HUE_NIGHT, (tU32) u8ParameterValue);
                        }
                        else {
                           ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onSetupVideoControlsMStart -> Hue Data ERROR"));
                           bResult = FALSE;
                        }
                     }
                     break;
                     case rvc_fi_tcl_e8_RVC_VideoParameterType::FI_EN_BLACKLEVEL:
                     {
                        if (arVideoControlParameter[i].e8DimmingMode.enType ==  rvc_fi_tcl_e8_RVC_VideoParameterDimmingMode::FI_EN_DAY) {
                           ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onSetupVideoControlsMStart -> BlackLevel DAY value: %d", u8ParameterValue));
                           m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__USER_SETTING_VALUE__BLACKLEVEL_DAY, (tU32) u8ParameterValue);
                        }
                        else if (arVideoControlParameter[i].e8DimmingMode.enType ==  rvc_fi_tcl_e8_RVC_VideoParameterDimmingMode::FI_EN_NIGHT) {
                           ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onSetupVideoControlsMStart -> BlackLevel NIGHT value: %d", u8ParameterValue));
                           m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__USER_SETTING_VALUE__BLACKLEVEL_NIGHT, (tU32) u8ParameterValue);
                        }
                        else {
                           ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onSetupVideoControlsMStart -> BlackLevel Data ERROR"));
                           bResult = FALSE;
                        }
                     }
                     break;
                     case rvc_fi_tcl_e8_RVC_VideoParameterType::FI_EN_DIMMING:
                     {
                        if (arVideoControlParameter[i].e8DimmingMode.enType ==  rvc_fi_tcl_e8_RVC_VideoParameterDimmingMode::FI_EN_DAY) {
                           ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onSetupVideoControlsMStart -> Dimming DAY value: %d", u8ParameterValue));
                           m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__USER_SETTING_VALUE__DIMMING_DAY, (tU32) u8ParameterValue);
                        }
                        else if (arVideoControlParameter[i].e8DimmingMode.enType ==  rvc_fi_tcl_e8_RVC_VideoParameterDimmingMode::FI_EN_NIGHT) {
                           ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onSetupVideoControlsMStart -> Dimming NIGHT value: %d", u8ParameterValue));
                           m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__USER_SETTING_VALUE__DIMMING_NIGHT, (tU32) u8ParameterValue);
                        }
                        else {
                           ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onSetupVideoControlsMStart -> Dimming Data ERROR"));
                           bResult = FALSE;
                        }
                     }
                     break;
                     default:
                        ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onSetupVideoControlsMStart -> Data ERROR"));
                        bResult = FALSE;
                     break;
                  } // switch
               } // if (u8ParameterValue <= 100)
               else
               {
                  ETG_TRACE_USR4 (("dispvidctrl_tclServiceRVCIf::onSetupVideoControlsMStart -> Parameter exceeds allowed range (>100)! "));
                  bResult = FALSE;
               }
            } // for loop
         }

         m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__USER_SETTING_UPDATE__VIDEO_CONTROL);
      }

      sendSetupVideoControlsMResult(bResult);
   // onSetupVideoControlsMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvcIf::onSetSystemStatusMStart(rvc_fi_tcl_e8_RVC_SystemStatus e8SystemStatus, rvc_fi_tcl_e8_RVC_StatusGuideLine e8GuideLine, rvc_fi_tcl_e8_RVC_StatusWarningText e8WarningText) {

   // onSetSystemStatusMStart: user specific code start
      (tVoid) e8GuideLine;
      (tVoid) e8WarningText;
      //if (e8GuideLine.enType ==  rvc_fi_tcl_e8_RVC_StatusGuideLine::FI_EN_GUIDELINEON)
      //{
      //   ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onSetSystemStatusMStart -> requested guideline state: ON"));
      //}
      //else
      //{
      //   ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onSetSystemStatusMStart -> requested guideline state: OFF"));
      //}

      //if (e8WarningText.enType ==  rvc_fi_tcl_e8_RVC_StatusWarningText::FI_EN_WARNINGTEXTON)
      //{
      //   ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onSetSystemStatusMStart -> requested warning text state: ON"));
      //}
      //else
      //{
      //   ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onSetSystemStatusMStart -> requested warning text state: OFF"));
      //}

      if (m_poControl_Rvc && m_bRvcMode == TRUE)
      {
         if (e8SystemStatus.enType ==  rvc_fi_tcl_e8_RVC_SystemStatus::FI_EN_VISUALISATION_OFF)
         {
           if((FALSE == dispvidctrl_tclAppMain::theServer()->getReverseGearStatusfromCMA()) && (FALSE == dispvidctrl_tclAppMain::theServer()->getReverseGearStatusfromCAN()) && (FALSE == dispvidctrl_tclAppMain::theServer()->getReverseCamRequest()))
           {
            ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onSetSystemStatusMStart -> requested rvc visualisation state OFF"));

			dispvidctrl_tclAppMain::theServer()->SetCameraStreamingStatus(FALSE);
                        
	//		m_poControl_Video->setGraphicslayerVisibility(1);
            m_poControl_Rvc->vHandleControl(EN_CONTROL_RVC__SERVICE_REQUEST_VISUALISATION_OFF, (tU32) TRUE);
           }
                        
//                        dispvidctrl_tclAppMain::theServer()->SetCameraStreamingStatus(FALSE);
            
			//dispvidctrl_tclAppMain::theServer()->SetCameraStreamingStatus(FALSE);
                        
			//m_poControl_Video->setGraphicslayerVisibility(1);
         }  
         else if (   (e8SystemStatus.enType == rvc_fi_tcl_e8_RVC_SystemStatus::FI_EN_RVC_VISUALISATION_ON)
                  || (e8SystemStatus.enType == rvc_fi_tcl_e8_RVC_SystemStatus::FI_EN_RVC_VISUALISATION_ON_CAMERA_SETTINGS) )
         {
            ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onSetSystemStatusMStart -> requested rvc visualisation state ON: %u", e8SystemStatus.enType));

      //                  dispvidctrl_tclAppMain::theServer()->SetCameraStreamingStatus(TRUE);
			dispvidctrl_tclAppMain::theServer()->SetCameraStreamingStatus(TRUE);
			m_poControl_Video->setGraphicslayerVisibility(0);
            m_poControl_Rvc->vHandleControl(EN_CONTROL_RVC__SERVICE_REQUEST_VISUALISATION_ON, (tU32) e8SystemStatus.enType);
      //                  dispvidctrl_tclAppMain::theServer()->SetCameraStreamingStatus(TRUE);
			//dispvidctrl_tclAppMain::theServer()->SetCameraStreamingStatus(TRUE);
		//	m_poControl_Video->setGraphicslayerVisibility(0);
			//m_poControl_Hmi->vHandleControl(EN_CONTROL_HMI__VIDEO_FORCE_GRAPHICS_OFF);
		  }
         else
         {
         }
      }

      if (m_poControl_HmiAvm3 && m_bAvmType_Phase3 == TRUE)
      {
         if (   (e8SystemStatus.enType == rvc_fi_tcl_e8_RVC_SystemStatus::FI_EN_VISUALISATION_OFF)
             || (e8SystemStatus.enType == rvc_fi_tcl_e8_RVC_SystemStatus::FI_EN_AVM_VISUALISATION_ON)
             || (e8SystemStatus.enType == rvc_fi_tcl_e8_RVC_SystemStatus::FI_EN_AVM_VISUALISATION_ON_CAMERA_SETTINGS) ) {
            ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onSetSystemStatusMStart -> requested AvmPh3 visualisation state: %u", e8SystemStatus.enType));
            m_poControl_HmiAvm3->vHandleControl(EN_CONTROL_HMIAVM3__SERVICE_REQUEST_VISUALISATION, (tU32) e8SystemStatus.enType);
         }
      }      
      else if (m_poControl_Avm && m_bAvmMode == TRUE)
      {
         if  (e8SystemStatus.enType ==  rvc_fi_tcl_e8_RVC_SystemStatus::FI_EN_VISUALISATION_OFF) {
            ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onSetSystemStatusMStart -> requested avm visualisation state: OFF"));
            m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__SERVICE_REQUEST_VISUALISATION_OFF, (tU32) TRUE);
         }
         else if (   (e8SystemStatus.enType == rvc_fi_tcl_e8_RVC_SystemStatus::FI_EN_AVM_VISUALISATION_ON)
                  || (e8SystemStatus.enType == rvc_fi_tcl_e8_RVC_SystemStatus::FI_EN_AVM_VISUALISATION_ON_CAMERA_SETTINGS) ) {
            ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onSetSystemStatusMStart -> requested avm visualisation state: ON %u", e8SystemStatus.enType));
            m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__SERVICE_REQUEST_VISUALISATION_ON, (tU32) e8SystemStatus.enType);
         }
         else
         {
         }
      }

      if (m_poControl_Mvc && m_bMvcMode == TRUE)
      {
         if  (e8SystemStatus.enType ==  rvc_fi_tcl_e8_RVC_SystemStatus::FI_EN_VISUALISATION_OFF) {
            ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onSetSystemStatusMStart -> requested mvc visualisation state: OFF"));
            m_poControl_Mvc->vHandleControl(EN_CONTROL_MVC__SERVICE_REQUEST_VISUALISATION_OFF, (tU32) TRUE);
         }
         else if (   (e8SystemStatus.enType == rvc_fi_tcl_e8_RVC_SystemStatus::FI_EN_MVC_VISUALISATION_ON)
                  || (e8SystemStatus.enType == rvc_fi_tcl_e8_RVC_SystemStatus::FI_EN_MVC_VISUALISATION_ON_CAMERA_SETTINGS) ) {
            ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onSetSystemStatusMStart -> requested mvc visualisation state: ON %u", e8SystemStatus.enType));
            m_poControl_Mvc->vHandleControl(EN_CONTROL_MVC__SERVICE_REQUEST_VISUALISATION_ON, (tU32) e8SystemStatus.enType);
         }
         else 
         {
         }
      }

      if (m_poControl_Video)
      {
         if (e8SystemStatus.enType == rvc_fi_tcl_e8_RVC_SystemStatus::FI_EN_VISUALISATION_OFF)
         {
            m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__GUIDELINE_ADJUSTMENT, (tU32) EN_CTRL_GDLADJ__SERVICE_REQUEST_VISUALISATION_OFF);
         }  
         else if (e8SystemStatus.enType ==  rvc_fi_tcl_e8_RVC_SystemStatus::FI_EN_RVC_VISUALISATION_ON_GUIDELINE_ADJUSTMENT)
         {
            m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__GUIDELINE_ADJUSTMENT, (tU32) EN_CTRL_GDLADJ__SERVICE_REQUEST_VISUALISATION_ON_GUIDELINE_ADJUSTMENT);
         }
         else
         {
         }
      }

      ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onSetSystemStatusMStart -> requested system state: %d", e8SystemStatus.enType));

      sendSetSystemStatusMResult(TRUE);
   // onSetSystemStatusMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvcIf::onrunExtDevicePowerSupplyTestMStart(tU16 pwrSupplyID) {

   // onrunExtDevicePowerSupplyTestMStart: user specific code start
      rvc_fi_tcl_e8_Camera_PowerSupplyStatus status;
      tU32 current;

      ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onrunExtDevicePowerSupplyTestMStart -> pwrSupplyID: %d", pwrSupplyID));

      status.enType =  rvc_fi_tcl_e8_Camera_PowerSupplyStatus::FI_EN_UNKNOWN;
      current = 0;

      sendrunExtDevicePowerSupplyTestMResult(pwrSupplyID, status, current);
   // onrunExtDevicePowerSupplyTestMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvcIf::onInitializeMStart(rvc_fi_tcl_e8_RVC_Module e8Module) {

   // onInitializeMStart: user specific code start
      tBool bResult = FALSE;

      if (e8Module.enType == rvc_fi_tcl_e8_RVC_Module::FI_EN_VIDEOCAPTUREUNIT)
      {
         ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onInitializeMStart -> request to init Video Capture Unit"));
         bResult = TRUE;
      }
      else
      {
         ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onInitializeMStart -> unknown request!"));
      }

      sendInitializeMResult(bResult);
   // onInitializeMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvcIf::onConfirmSystemStatusMStart(rvc_fi_tcl_e8_RVC_SystemStatus e8SystemStatus) {

   // onConfirmSystemStatusMStart: user specific code start
      ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onConfirmSystemStatusMStart -> confirmed status: %d", ETG_ENUM(DISPVIDCTRL_SystemStatus, (tU8) e8SystemStatus.enType)));
      if (m_bAvmType_Phase3) {
         if (m_poControl_HmiAvm3) {
            m_poControl_HmiAvm3->vHandleControl(EN_CONTROL_HMIAVM3__SYSTEMSTATUS_CONFIRMATION, (tU32) e8SystemStatus.enType);
         }
      }
      else {
         if (m_poControl_Hmi) {
            m_poControl_Hmi->vHandleControl(EN_CONTROL_HMI__SYSTEMSTATUS_CONFIRMATION, (tU32) e8SystemStatus.enType);
         }
      }

      sendConfirmSystemStatusMResult(TRUE);
   // onConfirmSystemStatusMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvcIf::onSetupUserConfigurationMStart(std::vector<rvc_fi_tcl_ParkAssist_UserConfiguration, std::allocator<rvc_fi_tcl_ParkAssist_UserConfiguration> > arUserConfiguration) {

   // onSetupUserConfigurationMStart: user specific code start
      tBool  bResult = TRUE;
      tU8    u8NumberOfListElements = 0;

      if (   m_poControl_Video
          && m_poControl_Rvc  )
      {
         u8NumberOfListElements = arUserConfiguration.size();
         if (u8NumberOfListElements > 0)
         {
            for (tU8 i = 0; i < u8NumberOfListElements; i++)
            {
               switch (arUserConfiguration[i].e8Type.enType)
               {
                  case rvc_fi_tcl_e8_ParkAssist_UserConfigurationType::FI_EN_REAR_VIEW_CAMERA:
                  {
                     if (arUserConfiguration[i].e8Mode.enType ==  rvc_fi_tcl_e8_ParkAssist_UserConfigurationMode::FI_EN_OFF)
                     {
                        ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onSetupUserConfigurationMStart -> rear view camera mode: OFF"));
                        m_poControl_Rvc->vHandleControl(EN_CONTROL_RVC__USER_SETTING_VALUE__REAR_VIEW_CAMERA, 0);
                     }
                     else if (arUserConfiguration[i].e8Mode.enType ==  rvc_fi_tcl_e8_ParkAssist_UserConfigurationMode::FI_EN_ON)
                     {
                        ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onSetupUserConfigurationMStart -> rear view camera mode: ON"));
                        m_poControl_Rvc->vHandleControl(EN_CONTROL_RVC__USER_SETTING_VALUE__REAR_VIEW_CAMERA, 1);
                     }
                     else
                     {
                        ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onSetupUserConfigurationMStart -> rear view camera mode data E R R O R "));
                        bResult = FALSE;
                     }
                  }
                  break;
                  case rvc_fi_tcl_e8_ParkAssist_UserConfigurationType::FI_EN_GUIDELINE:
                  {
                     if (arUserConfiguration[i].e8Mode.enType ==  rvc_fi_tcl_e8_ParkAssist_UserConfigurationMode::FI_EN_OFF)
                     {
                        ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onSetupUserConfigurationMStart -> guideline mode: OFF"));
                        //m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__USER_SETTING_VALUE__GUIDELINE, 0);
                        m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__USER_SETTING_VALUE__GUIDELINE_STATIC_SIDE, 0);
                        m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__USER_SETTING_VALUE__GUIDELINE_STATIC_CENTRE, 0);
                        m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__USER_SETTING_VALUE__GUIDELINE_DYNAMIC, 0);
                     }
                     else if (arUserConfiguration[i].e8Mode.enType ==  rvc_fi_tcl_e8_ParkAssist_UserConfigurationMode::FI_EN_ON)
                     {
                        ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onSetupUserConfigurationMStart -> guideline mode: ON"));
                        //m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__USER_SETTING_VALUE__GUIDELINE, 1);
                        m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__USER_SETTING_VALUE__GUIDELINE_STATIC_SIDE, 1);
                        m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__USER_SETTING_VALUE__GUIDELINE_STATIC_CENTRE, 1);
                        m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__USER_SETTING_VALUE__GUIDELINE_DYNAMIC, 1);
                     }
                     else
                     {
                        ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onSetupUserConfigurationMStart -> guideline mode data E R R O R "));
                        bResult = FALSE;
                     }
                  }
                  break;
                  case rvc_fi_tcl_e8_ParkAssist_UserConfigurationType::FI_EN_STATIC_SIDE_GUIDELINE:
                  {
                     if (arUserConfiguration[i].e8Mode.enType ==  rvc_fi_tcl_e8_ParkAssist_UserConfigurationMode::FI_EN_OFF)
                     {
                        ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onSetupUserConfigurationMStart -> static side guideline mode: OFF"));
                        m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__USER_SETTING_VALUE__GUIDELINE_STATIC_SIDE, 0);
                     }
                     else if (arUserConfiguration[i].e8Mode.enType ==  rvc_fi_tcl_e8_ParkAssist_UserConfigurationMode::FI_EN_ON)
                     {
                        ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onSetupUserConfigurationMStart -> static side guideline mode: ON"));
                        m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__USER_SETTING_VALUE__GUIDELINE_STATIC_SIDE, 1);
                     }
                     else
                     {
                        ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onSetupUserConfigurationMStart -> static side guideline mode data E R R O R "));
                        bResult = FALSE;
                     }
                  }
                  break;
                  case rvc_fi_tcl_e8_ParkAssist_UserConfigurationType::FI_EN_STATIC_CENTRE_GUIDELINE:
                  {
                     if (arUserConfiguration[i].e8Mode.enType ==  rvc_fi_tcl_e8_ParkAssist_UserConfigurationMode::FI_EN_OFF)
                     {
                        ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onSetupUserConfigurationMStart -> static centre guideline mode: OFF"));
                        m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__USER_SETTING_VALUE__GUIDELINE_STATIC_CENTRE, 0);
                     }
                     else if (arUserConfiguration[i].e8Mode.enType ==  rvc_fi_tcl_e8_ParkAssist_UserConfigurationMode::FI_EN_ON)
                     {
                        ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onSetupUserConfigurationMStart -> static centre guideline mode: ON"));
                        m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__USER_SETTING_VALUE__GUIDELINE_STATIC_CENTRE, 1);
                     }
                     else
                     {
                        ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onSetupUserConfigurationMStart -> static centre guideline mode data E R R O R "));
                        bResult = FALSE;
                     }
                  }
                  break;
                  case rvc_fi_tcl_e8_ParkAssist_UserConfigurationType::FI_EN_DYNAMIC_GUIDELINE:
                  {
                     if (arUserConfiguration[i].e8Mode.enType ==  rvc_fi_tcl_e8_ParkAssist_UserConfigurationMode::FI_EN_OFF)
                     {
                        ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onSetupUserConfigurationMStart -> static dynamic guideline mode: OFF"));
                        m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__USER_SETTING_VALUE__GUIDELINE_DYNAMIC, 0);
                     }
                     else if (arUserConfiguration[i].e8Mode.enType ==  rvc_fi_tcl_e8_ParkAssist_UserConfigurationMode::FI_EN_ON)
                     {
                        ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onSetupUserConfigurationMStart -> static dynamic guideline mode: ON"));
                        m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__USER_SETTING_VALUE__GUIDELINE_DYNAMIC, 1);
                     }
                     else
                     {
                        ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onSetupUserConfigurationMStart -> static dynamic guideline mode data E R R O R "));
                        bResult = FALSE;
                     }
                  }
                  break;
                  default:
                     ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onSetupUserConfigurationMStart -> Data ERROR"));
                     bResult = FALSE;
                  break;
               } // switch
            } // for loop "NumberOfListElements"

            // all received values evaluated, now we can update the system
            m_poControl_Rvc->vHandleControl(EN_CONTROL_RVC__USER_SETTING_UPDATE__REAR_VIEW_CAMERA);
            m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__USER_SETTING_UPDATE__GUIDELINE);
         }
      }

      sendSetupUserConfigurationMResult(bResult);
   // onSetupUserConfigurationMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvcIf::onSetMicrophoneStateMStart(rvc_fi_tcl_e8_Set_MicState e8RequestState) {

   // onSetMicrophoneStateMStart: user specific code start
    tBool bResult = FALSE;

    if ( m_poControl_Rvc ) {
        bResult = m_poControl_Rvc->bSetMicrophoneVccOn((tBool) e8RequestState.enType);
    }

    sendSetMicrophoneStateMResult(bResult);
   // onSetMicrophoneStateMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvcIf::onSetRVCStatusMStart(tU8 e8RequestState) {

   // onSetRVCStatusMStart: user specific code start
	  ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onSetRVCStatusMStart %d",e8RequestState));
	 if(true == dispvidctrl_tclAppMain::theServer()->getReverseConfiguredStatus())
	 {
         if((e8RequestState == 2) && (FALSE == dispvidctrl_tclAppMain::theServer()->getSafeState()))
         {
                        m_poControl_Video->setGraphicslayerVisibility(ENABLE);
                        dispvidctrl_tclAppMain::theServer()->SetReverseGearStatusViaCMA(true);
                        tChar strIfName[] = "";
                        dispvidctrl_tclAppMain::theServer()->vPostMsgReverseOnDebounced(strIfName);
         }
         else if(e8RequestState == 1)
         {
                 if(true == dispvidctrl_tclAppMain::theServer()->getReverseGearStatusfromCMA())
                 {
                    dispvidctrl_tclAppMain::theServer()->SetReverseGearStatusViaCMA(false);
                    tChar strIfName[] = "";
                    dispvidctrl_tclAppMain::theServer()->vPostMsgReverseOff(strIfName);
                 }
           else{
             ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::getReverseGearStatusfromCMA() received FALSE"));
           }
           
         }
         else
         {
                 ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onSetRVCStatusMStart invalid state %d",e8RequestState));
         }
	 }

   // onSetRVCStatusMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvcIf::onCamera_SetupBeepMStart(rvc_fi_tcl_e8_AVM_StatusBeep e8SetupBeep) {

   // onCamera_SetupBeepMStart: user specific code start
      (tVoid) e8SetupBeep;
      tU32 u32Beeps = TRUE;
      //if (e8SetupBeep.enType == rvc_fi_tcl_e8_AVM_StatusBeep::FI_EN_ALLBEEPTYPESNOTACTIVE)
      //{
      //   ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onCamera_SetupBeepMStart -> ALL BEEPTYPES NOT ACTIVE - AVM_BEEP_OFF"));
      //   u32Beeps = FALSE;
      //}
      //else if (e8SetupBeep.enType == rvc_fi_tcl_e8_AVM_StatusBeep::FI_EN_ONLYOPERATIONBEEPACTIVE)
      //{
      //   ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onCamera_SetupBeepMStart -> ONLY OPERATIONBEEP ACTIVE - AVM_BEEP_ON"));
      //   u32Beeps = FALSE;
      //}
      //else if (e8SetupBeep.enType == rvc_fi_tcl_e8_AVM_StatusBeep::FI_EN_ONLYERRORBEEPACTIVE)
      //{
      //   ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onCamera_SetupBeepMStart -> ONLY ERRORBEEP ACTIVE - AVM_ERROR_BEEP_ON"));
      //   u32Beeps = FALSE;
      //}
      //else if (e8SetupBeep.enType == rvc_fi_tcl_e8_AVM_StatusBeep::FI_EN_ALLBEEPTYPESACTIVE)
      //{
      //   ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onCamera_SetupBeepMStart -> ALL BEEPTYPES ACTIVE - AVM_BEEP_ON"));
      //   u32Beeps = TRUE;
      //}
      //else
      //{
      //   ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onCamera_SetupBeepMStart -> parameter out of range"));
      //}

      ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onCamera_SetupBeepMStart -> BEEPTYPES request %u", u32Beeps));
      if (m_poControl_Avm && m_bAvmMode == TRUE) {
         m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__AVM_BEEPS_STATUS_CHANGE, u32Beeps);
      }

      sendCamera_SetupBeepMResult(e8SetupBeep);
   // onCamera_SetupBeepMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvcIf::onSetCamerastateMStart(rvc_fi_tcl_e8_RVC_CameraState CameraState) {

   // onSetCamerastateMStart: user specific code start
      if (CameraState.enType == rvc_fi_tcl_e8_RVC_CameraState::FI_EN_AVM_VISUALIZATION_OFF)
      {
         ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onSetCamerastateMStart -> AVM_VISUALIZATION_OFF request"));
         if (m_poClient_Avm3 && m_bAvmType_Phase3 == TRUE) {
            m_poClient_Avm3->onAVM3_CameraStateRequest(FALSE);
         } else if (m_poControl_Avm && m_bAvmMode == TRUE) {
            m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__PURPOSE_SWITCH);
         }
      }
      else
      {
         ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onSetCamerastateMStart -> request: %d", CameraState.enType));
      }
      sendSetCamerastateMResult(TRUE);
   // onSetCamerastateMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvcIf::onChangeViewRequestMStart(rvc_fi_tcl_e8_AVM_View_Request u8Status) {

   // onChangeViewRequestMStart: user specific code start
    if (m_poControl_Avm && m_bAvmMode == TRUE) {
       ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onChangeViewRequestMStart Request is %u", \
                                 ETG_ENUM(DISPVIDCTRL_E8_AVM_VIEW_REQUEST, u8Status.enType)));
       m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__VIEW_CHANGE_REQUEST_FROM_HMI, u8Status.enType);
//todo: Result depends on the CAN message posted or not, instead of hardcoding it to Successful always
       sendChangeViewRequestMResult(TRUE);
    }
   // onChangeViewRequestMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvcIf::onAffordable_Its_SetupBswMStart(tU8 u8Status) {

   // onAffordable_Its_SetupBswMStart: user specific code start
      // variant 1 is used
      if (u8Status == 1)
      {
         ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onAffordable_Its_SetupModMStart -> switch press BSW"));
         if (m_poControl_Avm && m_bAvmMode == TRUE) {
            m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__SWITCH_PRESS_BSW);
         }
      }
      else
      {
         ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onAffordable_Its_SetupModMStart -> BSW request: %d", u8Status));
      }
      sendAffordable_Its_SetupBswMResult(TRUE);
   // onAffordable_Its_SetupBswMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvcIf::onAffordable_Its_SetupModMStart(tU8 u8Status) {

   // onAffordable_Its_SetupModMStart: user specific code start
      // variant 1 is used
      if (u8Status == 1)
      {
         ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onAffordable_Its_SetupModMStart -> switch press MOD"));
         if (m_poControl_Avm && m_bAvmMode == TRUE) {
            m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__SWITCH_PRESS_MOD);
         }
      }
      else
      {
         ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onAffordable_Its_SetupModMStart -> MOD request: %d", u8Status));
      }
      sendAffordable_Its_SetupModMResult(TRUE);
   // onAffordable_Its_SetupModMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvcIf::onAffordable_Its_SetupLdwMStart(tU8 u8Status) {

   // onAffordable_Its_SetupLdwMStart: user specific code start
      // variant 1 is used
      if (u8Status == 1)
      {
         ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onAffordable_Its_SetupModMStart -> switch press LDW"));
         if (m_poControl_Avm && m_bAvmMode == TRUE) {
            m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__SWITCH_PRESS_LDW);
         }
      }
      else
      {
         ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onAffordable_Its_SetupModMStart -> LDW request: %d", u8Status));
      }
      sendAffordable_Its_SetupLdwMResult(TRUE);
   // onAffordable_Its_SetupLdwMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvcIf::onIPA_SetHMIStatusMStart(rvc_fi_tcl_e8_IPA_HMIStatus e8IPAStatus) {

   // onIPA_SetHMIStatusMStart: user specific code start
   ETG_TRACE_USR1(("dispvidctrl_tclServiceRVCIf::onIPA_SetHMIStatusMStart e8IPAStatus %u", ETG_ENUM(DISPVIDCTRL_E8_IPA_HMISTATUS, e8IPAStatus.enType)));

   DISPVIDCTRL_NULL_POINTER_CHECK(m_poControl_Avm);
   m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__IPA_ACTIVATION_CHANGE, (tU32) e8IPAStatus.enType);
   sendIPA_SetHMIStatusMResult(TRUE);
   // onIPA_SetHMIStatusMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvcIf::onIPA_SetButtonMStart(rvc_fi_tcl_e8_IPA_BUTTON_ID e8ButtonIdentifier, rvc_fi_tcl_e8_RVC_ButtonState e8ButtonStatus) {

   // onIPA_SetButtonMStart: user specific code start
   ETG_TRACE_USR1(("dispvidctrl_tclServiceRVCIf::onIPA_SetButtonMStart entered"));
   tU32 u32Data = ( ( ((tU8)e8ButtonIdentifier.enType) << 8 ) | ( (tU8) e8ButtonStatus.enType) );

   DISPVIDCTRL_NULL_POINTER_CHECK(m_poControl_Avm);
   m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__IPA_BUTTON_CHANGE, u32Data);
   sendIPA_SetButtonMResult(TRUE);   
   // onIPA_SetButtonMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvcIf::onIPA_Voice_TextsMStart(rvc_fi_tcl_e8_RVC_Language Language, std::vector<rvc_fi_tcl_IPA_Voice_Text_Strings, std::allocator<rvc_fi_tcl_IPA_Voice_Text_Strings> > arTexts) {

   // onIPA_Voice_TextsMStart: user specific code start
   DISPVIDCTRL_NULL_POINTER_CHECK(m_poControl_Avm);
   m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__IPA_VOICE_TEXTS_UPDATE);
   sendIPA_Voice_TextsMResult(TRUE);
   // onIPA_Voice_TextsMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvcIf::onMVC_HMI_ViewRequestMStart(rvc_fi_tcl_e8_MVCViewingState e8Request) {

   // onMVC_HMI_ViewRequestMStart: user specific code start
   if (m_poControl_Mvc && m_bMvcMode == TRUE)
   {
      ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onMVC_HMI_ViewRequestMStart -> requested mvc view %u", e8Request.enType));
      m_poControl_Mvc->vHandleControl(EN_CONTROL_MVC__HMI_VIEW_CHANGE_REQUEST, (tU32) e8Request.enType);
   }
   // onMVC_HMI_ViewRequestMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvcIf::onGdlAdj_AdjustmentCompleteMStart(rvc_fi_tcl_e8_GdlAdj_Completion e8Completion) {

   // onGdlAdj_AdjustmentCompleteMStart: user specific code start

      switch (e8Completion.enType)
      {
         case rvc_fi_tcl_e8_GdlAdj_Completion::FI_EN_CONFIRM:
            ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onGdlAdj_AdjustmentCompleteMStart -> CONFIRM"));
            if (m_poControl_Video) {
               m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__GUIDELINE_ADJUSTMENT, (tU32) EN_CTRL_GDLADJ__ADJUST_COMPLETE_CONFIRM);
            }
            break;
         case rvc_fi_tcl_e8_GdlAdj_Completion::FI_EN_REFUSED:
            ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onGdlAdj_AdjustmentCompleteMStart -> REFUSED"));
            if (m_poControl_Video) {
               m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__GUIDELINE_ADJUSTMENT, (tU32) EN_CTRL_GDLADJ__ADJUST_COMPLETE_REFUSED);
            }
            break;
         case rvc_fi_tcl_e8_GdlAdj_Completion::FI_EN_RESET:
            ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onGdlAdj_AdjustmentCompleteMStart -> RESET"));
            if (m_poControl_Video) {
               m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__GUIDELINE_ADJUSTMENT, (tU32) EN_CTRL_GDLADJ__ADJUST_COMPLETE_RESET);
            }
            break;
         default:
            ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onGdlAdj_AdjustmentCompleteMStart -> parameter out of range"));
            break;
      }

      tBool bResult = TRUE;
      sendGdlAdj_AdjustmentCompleteMResult(bResult);
   // onGdlAdj_AdjustmentCompleteMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvcIf::onGdlAdj_AdjustButtonMStart(rvc_fi_tcl_e8_GdlAdj_AdjustButton e8Button) {

   // onGdlAdj_AdjustButtonMStart: user specific code start

      switch (e8Button.enType)
      {
         case rvc_fi_tcl_e8_GdlAdj_AdjustButton::FI_EN_UP:
            ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onGdlAdj_AdjustButtonMStart -> UP"));
            if (m_poControl_Video) {
               m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__GUIDELINE_ADJUSTMENT, (tU32) EN_CTRL_GDLADJ__ADJUST_BUTTON_UP);
            }
            break;
         case rvc_fi_tcl_e8_GdlAdj_AdjustButton::FI_EN_DOWN:
            ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onGdlAdj_AdjustButtonMStart -> DOWN"));
            if (m_poControl_Video) {
               m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__GUIDELINE_ADJUSTMENT, (tU32) EN_CTRL_GDLADJ__ADJUST_BUTTON_DOWN);
            }
            break;
         case rvc_fi_tcl_e8_GdlAdj_AdjustButton::FI_EN_LEFT:
            ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onGdlAdj_AdjustButtonMStart -> LEFT"));
            if (m_poControl_Video) {
               m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__GUIDELINE_ADJUSTMENT, (tU32) EN_CTRL_GDLADJ__ADJUST_BUTTON_LEFT);
            }
            break;
         case rvc_fi_tcl_e8_GdlAdj_AdjustButton::FI_EN_RIGHT:
            ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onGdlAdj_AdjustButtonMStart -> RIGHT"));
            if (m_poControl_Video) {
               m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__GUIDELINE_ADJUSTMENT, (tU32) EN_CTRL_GDLADJ__ADJUST_BUTTON_RIGHT);
            }
            break;
         case rvc_fi_tcl_e8_GdlAdj_AdjustButton::FI_EN_ROTATION_LEFT:
            ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onGdlAdj_AdjustButtonMStart -> ROTATION_LEFT"));
            if (m_poControl_Video) {
               m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__GUIDELINE_ADJUSTMENT, (tU32) EN_CTRL_GDLADJ__ADJUST_BUTTON_ROTATION_LEFT);
            }
            break;
         case rvc_fi_tcl_e8_GdlAdj_AdjustButton::FI_EN_ROTATION_RIGHT:
            ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onGdlAdj_AdjustButtonMStart -> ROTATION_RIGHT"));
            if (m_poControl_Video) {
               m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__GUIDELINE_ADJUSTMENT, (tU32) EN_CTRL_GDLADJ__ADJUST_BUTTON_ROTATION_RIGHT);
            }
            break;
         default:
            ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onGdlAdj_AdjustButtonMStart -> parameter out of range"));
            break;
      }

      tBool bResult = TRUE;
      sendGdlAdj_AdjustButtonMResult(bResult);
   // onGdlAdj_AdjustButtonMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvcIf::onGdlAdj_ConfigurationDataMStart(rvc_fi_tcl_e8_GdlAdj_Request e8Request, std::vector<rvc_fi_tcl_GdlAdj_ConfigParameterData, std::allocator<rvc_fi_tcl_GdlAdj_ConfigParameterData> > arConfigParameterData) {

   // onGdlAdj_ConfigurationDataMStart: user specific code start

      tBool  bResult = TRUE;
      tU8    u8NumberOfListElements = 0;

      rvc_fi_tcl_GdlAdj_ConfigParameterData oConfigParameterData;
      std::vector<rvc_fi_tcl_GdlAdj_ConfigParameterData, std::allocator<rvc_fi_tcl_GdlAdj_ConfigParameterData> > arConfigParameterDataResult;

      switch (e8Request.enType)
      {
         case rvc_fi_tcl_e8_GdlAdj_Request::FI_EN_GET_ALL:
            if (m_poControl_Video)
            {
               ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onGdlAdj_ConfigurationDataMStart -> GET ALL"));

               tU8  au8ConfigurationDataItem[DISPVIDCTRL_VIDEO__NUMBER_OFF_CONFIGURATION_DATA];
               tF64 af64ConfigurationDataValue[DISPVIDCTRL_VIDEO__NUMBER_OFF_CONFIGURATION_DATA];

               // fill the struct array with the data
               if (TRUE == m_poControl_Video->bGdlAdj_ConfigurationDataGetAll(au8ConfigurationDataItem, af64ConfigurationDataValue))
               {
                  // fill FI data object (list)
                  for (tU8 i=0; i < DISPVIDCTRL_VIDEO__NUMBER_OFF_CONFIGURATION_DATA; i++)
                  {
                     if (au8ConfigurationDataItem[i] != EN_GDLADJ__NONE)
                     {
                        ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onGdlAdj_ConfigurationDataMStart item %d , value %f", ETG_CENUM(tenControl_Video_GdlAdjConfigurationDataItem, au8ConfigurationDataItem[i]), af64ConfigurationDataValue[i]));
                        oConfigParameterData.e8Item.enType = (rvc_fi_tcl_e8_GdlAdj_ConfigurationItem::tenType) au8ConfigurationDataItem[i];
                        oConfigParameterData.f64Value = af64ConfigurationDataValue[i];
                        arConfigParameterDataResult.push_back(oConfigParameterData);
                     }
                  }
               }
               else
               {
                   ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onGdlAdj_ConfigurationDataMStart get return is FALSE"));
               }
            }
            break;
         case rvc_fi_tcl_e8_GdlAdj_Request::FI_EN_GET:
            u8NumberOfListElements = arConfigParameterData.size();
            ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onGdlAdj_ConfigurationDataMStart -> GET req: %d elements", u8NumberOfListElements));
            if (u8NumberOfListElements > 0)
            {
               tU8  u8Item;
               tF64 f64Value = 0;
               for (tU8 i = 0; i < u8NumberOfListElements; i++)
               {
                  if (m_poControl_Video) {
                     ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onGdlAdj_ConfigurationDataMStart -> GET req: %d", ETG_CENUM(tenControl_Video_GdlAdjConfigurationDataItem, arConfigParameterData[i].e8Item.enType)));

                     u8Item = (tU8) arConfigParameterData[i].e8Item.enType;
                     // get the data for the item
                     if (TRUE == m_poControl_Video->bGdlAdj_ConfigurationDataGet(u8Item, f64Value))
                     {
                        ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onGdlAdj_ConfigurationDataMStart .. GET val: %d = %f", ETG_CENUM(tenControl_Video_GdlAdjConfigurationDataItem, u8Item), f64Value));
                        // fill FI data object (list)
                        oConfigParameterData.e8Item.enType = arConfigParameterData[i].e8Item.enType;
                        oConfigParameterData.f64Value = f64Value;
                        arConfigParameterDataResult.push_back(oConfigParameterData);                  
                     }
                  }
               }
            }
            else
            {
               bResult = FALSE;
            }
            break;
         case rvc_fi_tcl_e8_GdlAdj_Request::FI_EN_SET:
            u8NumberOfListElements = arConfigParameterData.size();
            ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onGdlAdj_ConfigurationDataMStart -> SET req: %d elements", u8NumberOfListElements));
            if (u8NumberOfListElements > 0)
            {
               tU8  u8Item;
               tF64 f64Value = 0;

               for (tU8 i = 0; i < u8NumberOfListElements; i++)
               {
                  if (m_poControl_Video) {
                     ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onGdlAdj_ConfigurationDataMStart -> SET req: %d = %f",
                             ETG_CENUM(tenControl_Video_GdlAdjConfigurationDataItem, arConfigParameterData[i].e8Item.enType), arConfigParameterData[i].f64Value));

                     u8Item = (tU8) arConfigParameterData[i].e8Item.enType;
                     f64Value = arConfigParameterData[i].f64Value;
                     // set the data for the item and get back the range corrected value (reference to f64Value as parameter )
                     (tVoid) m_poControl_Video->bGdlAdj_ConfigurationDataSet(u8Item, f64Value);

                     ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onGdlAdj_ConfigurationDataMStart .. SET val: %d = %f",
                             ETG_CENUM(tenControl_Video_GdlAdjConfigurationDataItem, u8Item), f64Value));
                     // fill FI data object (list)
                     oConfigParameterData.e8Item.enType = arConfigParameterData[i].e8Item.enType;
                     oConfigParameterData.f64Value = f64Value; //range corrected value
                     arConfigParameterDataResult.push_back(oConfigParameterData);
                  }
               }
            }
            else
            {
               bResult = FALSE;
            }
            break;
         default:
            break;
      }
 
      sendGdlAdj_ConfigurationDataMResult(bResult, e8Request, arConfigParameterDataResult);
   // onGdlAdj_ConfigurationDataMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvcIf::onFAP_SetButtonMStart(rvc_fi_tcl_e8_IPA_BUTTON_ID e8ButtonIdentifier, rvc_fi_tcl_e8_RVC_ButtonState e8ButtonStatus) {

   // onFAP_SetButtonMStart: user specific code start
	ETG_TRACE_USR1(("dispvidctrl_tclServiceRVCIf::onFAP_SetButtonMStart entered e8ButtonIdentifier %d", e8ButtonIdentifier.enType));
	ETG_TRACE_USR1(("dispvidctrl_tclServiceRVCIf::onFAP_SetButtonMStart entered e8ButtonStatus %d", e8ButtonStatus.enType));
	tU32 u32Data = ( ( ((tU8)e8ButtonIdentifier.enType) << 8 ) | ( (tU8) e8ButtonStatus.enType) );

	DISPVIDCTRL_NULL_POINTER_CHECK(m_poControl_Avm);
	m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__FAP_SETTING_STATUS, u32Data);
	sendFAP_SetButtonMResult(TRUE);
   // onFAP_SetButtonMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvcIf::onTouchEventMStart(rvc_fi_tcl_Touch_Data arTouchData) {

   // onTouchEventMStart: user specific code start
   // onTouchEventMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvcIf::onGPSInfoMStart(rvc_fi_tcl_GPS_Data arGpsData) {

   // onGPSInfoMStart: user specific code start
   // onGPSInfoMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvcIf::onMapMatchedInfoMStart(rvc_fi_tcl_MapMatched_Data arMapMatchedData) {

   // onMapMatchedInfoMStart: user specific code start
   // onMapMatchedInfoMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvcIf::onFapLearnParkPositionMStart(tBool RequestOn) {

   // onFapLearnParkPositionMStart: user specific code start
   // onFapLearnParkPositionMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvcIf::onSetFapGuidanceMStart(tBool Request) {

   // onSetFapGuidanceMStart: user specific code start
   sendSetFapGuidanceMResult(Request);
   sendFAPGuidanceStateStatus(Request);
   // onSetFapGuidanceMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvcIf::onAVM3_SetSwitchMStart(rvc_fi_tcl_e8_AVMph3_SwitchId e8SwitchId) {

   // onAVM3_SetSwitchMStart: user specific code start
   if (m_poClient_Avm3) {
      ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onAVM3_SetSwitchMStart -> SET %u", ETG_CENUM(rvc_fi_tcl_e8_AVMph3_SwitchId::tenType, e8SwitchId.enType) ));
      (rvc_fi_tcl_e8_AVMph3_SwitchId::tenType)e8SwitchId.enType;
      (tVoid) m_poClient_Avm3->onAVM3_SetSwitchMStart((tU8)e8SwitchId.enType);
   }
   sendAVM3_SetSwitchMResult(TRUE);
   // onAVM3_SetSwitchMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvcIf::onAVM3_SetSonarBuzzerStatusMStart(rvc_fi_tcl_e8_AVMph3_BuzzerStatus e8BuzzerStatus) {

   // onAVM3_SetSonarBuzzerStatusMStart: user specific code start
   if (m_poClient_Avm3) {
      ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onAVM3_SetSonarBuzzerStatusMStart -> SET %u", ETG_CENUM(rvc_fi_tcl_e8_AVMph3_BuzzerStatus::tenType, e8BuzzerStatus.enType) ));
      (tVoid) m_poClient_Avm3->onAVM3_SetSonarBuzzerStatusMStart((tU8)e8BuzzerStatus.enType);
   }
   sendAVM3_SetSwitchMResult(TRUE);
   // onAVM3_SetSonarBuzzerStatusMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvcIf::onAVM3_Settings_Detailed_SendReqMStart(rvc_fi_tcl_e8_AVMph3_RequestType e8RequestType, std::vector<rvc_fi_tcl_AVMph3_Setting_Item, std::allocator<rvc_fi_tcl_AVMph3_Setting_Item> > arChangedItems) {

   // onAVM3_Settings_Detailed_SendReqMStart: user specific code start
   if (m_poClient_Avm3) {
      std::vector<I_dispvidctrl_tclMCanClientAvm::tstSettingsItem , std::allocator<I_dispvidctrl_tclMCanClientAvm::tstSettingsItem> > arItems;
      if (rvc_fi_tcl_e8_AVMph3_RequestType::FI_EN_SET == e8RequestType.enType) { 
          ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onAVM3_Settings_Detailed_SendReqMStart: SET; numItems=%u", arChangedItems.size() ));
          for (tU32 u32Idx=0; u32Idx<arChangedItems.size(); ++u32Idx) {
              I_dispvidctrl_tclMCanClientAvm::tstSettingsItem oItem;
              oItem.u8Id    = (tU8)arChangedItems[u32Idx].e8ItemId.enType;
              oItem.u8State =      arChangedItems[u32Idx].u8ItemState;
              arItems.push_back(oItem);
              ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onAVM3_Settings_Detailed_SendReqMStart:   item[%u]: ID=%u state=%u",u32Idx,oItem.u8Id,oItem.u8State));
          }
      } else {
          ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onAVM3_Settings_Detailed_SendReqMStart: GET" ));
      }
      (tVoid) m_poClient_Avm3->onAVM3_Settings_Detailed_SendReqMStart((tU8)e8RequestType.enType, arItems);
   }
   sendAVM3_Settings_Primary_SendReqMResult(TRUE);
   // onAVM3_Settings_Detailed_SendReqMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvcIf::onAVM3_Settings_Primary_SendReqMStart(rvc_fi_tcl_e8_AVMph3_RequestType e8RequestType, rvc_fi_tcl_e8_AVMph3_SettingOptionState e8AvmSonarBuzzer, tBool bDetailsSettingsAvail, tBool bImageQualitySettingAvail) {

   // onAVM3_Settings_Primary_SendReqMStart: user specific code start
   if (m_poClient_Avm3) {
      if (rvc_fi_tcl_e8_AVMph3_RequestType::FI_EN_SET == e8RequestType.enType) { 
          //ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onAVM3_Settings_Primary_SendReqMStart: SET, AvmSonarBuzzer=%u, DetailsSettingAvail=%u, ImageQualitySettingAvail=%u",
                          //ETG_CENUM(rvc_fi_tcl_e8_AVMph3_SettingOptionState::tenType, e8AvmSonarBuzzer), bDetailsSettingsAvail, bImageQualitySettingAvail ));
      } else {
          ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onAVM3_Settings_Primary_SendReqMStart: GET" ));
      }
      (tVoid) m_poClient_Avm3->onAVM3_Settings_Primary_SendReqMStart((tU8)e8RequestType.enType, (tU8)e8AvmSonarBuzzer.enType, bDetailsSettingsAvail, bImageQualitySettingAvail);
   }
   sendAVM3_Settings_Primary_SendReqMResult(TRUE);
   // onAVM3_Settings_Primary_SendReqMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvcIf::onAVM3_GetVersionInfoMStart(rvc_fi_tcl_e8_AVMph3_VersionInfoType e8VersionType) {

   // onAVM3_GetVersionInfoMStart: user specific code start
   if (m_poClient_Avm3) {
      ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onAVM3_GetVersionInfoMStart(%u)", ETG_CENUM(rvc_fi_tcl_e8_AVMph3_VersionInfoType::tenType, e8VersionType.enType) ));
      (tVoid) m_poClient_Avm3->onAVM3_GetVersionInfoMStart((tU8)e8VersionType.enType);
   }
   sendAVM3_GetVersionInfoMResult(TRUE);
   // onAVM3_GetVersionInfoMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvcIf::onAVM3_GetCommunicationErrorsMStart() {

   // onAVM3_GetCommunicationErrorsMStart: user specific code start
   if (m_poClient_Avm3) {
      ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onAVM3_GetCommunicationErrorsMStart()"));
      (tVoid) m_poClient_Avm3->onAVM3_GetCommunicationErrorsMStart();
   }
   sendAVM3_GetCommunicationErrorsMResult(TRUE);
   // onAVM3_GetCommunicationErrorsMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvcIf::onAVM3_ClearCommunicationErrorsMStart() {

   // onAVM3_ClearCommunicationErrorsMStart: user specific code start
   if (m_poClient_Avm3) {
      ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::onAVM3_ClearCommunicationErrorsMStart()"));
      (tVoid) m_poClient_Avm3->onAVM3_ClearCommunicationErrorsMStart();
   }
   sendAVM3_ClearCommunicationErrorsMResult(TRUE);
   // onAVM3_ClearCommunicationErrorsMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvcIf::onToggleGpioPinOnOffMStart() {

   // onToggleGpioPinOnOffMStart: user specific code start
   // onToggleGpioPinOnOffMStart: user specific code end
}

tVoid dispvidctrl_tclServiceRvcIf::sendSystemConfigurationsStatus(rvc_fi_tcl_e8_RVC_Camera_System_Type e8CameraSystem, tU8 u8RVCGuideLine, tU8 u8Brightness) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendSystemConfigurationsStatus(e8CameraSystem, u8RVCGuideLine, u8Brightness);
}

tVoid dispvidctrl_tclServiceRvcIf::sendSystemStatusStatus(rvc_fi_tcl_e8_RVC_SystemStatus e8SystemStatus) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendSystemStatusStatus(e8SystemStatus);
}

tVoid dispvidctrl_tclServiceRvcIf::sendVideoSignalStatusStatus(rvc_fi_tcl_e8_RVC_SignalStatus e8StatusVideoSignal) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendVideoSignalStatusStatus(e8StatusVideoSignal);
}

tVoid dispvidctrl_tclServiceRvcIf::sendReverseSignalStatusStatus(rvc_fi_tcl_e8_RVC_ReverseSignalStatus e8StatusReverseSignal) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendReverseSignalStatusStatus(e8StatusReverseSignal);
}

tVoid dispvidctrl_tclServiceRvcIf::sendCamera_PwrSupplyStatusStatus(tU16 pwrSupplyID, rvc_fi_tcl_e8_Camera_PowerSupplyStatus status, tU32 current) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendCamera_PwrSupplyStatusStatus(pwrSupplyID, status, current);
}

tVoid dispvidctrl_tclServiceRvcIf::sendMicrophone_PwrSupplyStatusStatus(tU16 pwrSupplyID, rvc_fi_tcl_e8_Microphone_PowerSupplyStatus status, tU32 current) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendMicrophone_PwrSupplyStatusStatus(pwrSupplyID, status, current);
}

tVoid dispvidctrl_tclServiceRvcIf::sendTailgate_StatusStatus(rvc_fi_tcl_e8_Tailgate_State State) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendTailgate_StatusStatus(State);
}

tVoid dispvidctrl_tclServiceRvcIf::sendView_Close_AuthorizedStatus(rvc_fi_tcl_e8_Exit_Authorized e8Allowed) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendView_Close_AuthorizedStatus(e8Allowed);
}

tVoid dispvidctrl_tclServiceRvcIf::sendAvmR_Current_ViewStatus(rvc_fi_tcl_e8_AVM_View_Status e8View) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendAvmR_Current_ViewStatus(e8View);
}

tVoid dispvidctrl_tclServiceRvcIf::sendAffordable_ITSStatus(rvc_fi_tcl_e8_AffordableIts_Status e8AffordableItsAvailable, rvc_fi_tcl_e8_AffordableIts_StatusFeature e8BswStatus, rvc_fi_tcl_e8_AffordableIts_StatusFeature e8ModStatus, rvc_fi_tcl_e8_AffordableIts_StatusFeature e8LdwStatus) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendAffordable_ITSStatus(e8AffordableItsAvailable, e8BswStatus, e8ModStatus, e8LdwStatus);
}

tVoid dispvidctrl_tclServiceRvcIf::sendIPAConfigurationStatus(rvc_fi_tcl_e8_IPA_AvailabilityStatus e8AvailabilityStatus, rvc_fi_tcl_e8_IPA_RegionalSelection e8RegionalSelection) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendIPAConfigurationStatus(e8AvailabilityStatus, e8RegionalSelection);
}

tVoid dispvidctrl_tclServiceRvcIf::sendIPAStatusStatus(rvc_fi_tcl_e8_IPA_OperationStatus e8OperationStatus, rvc_fi_tcl_e8_IPA_ModeChangeRequest e8Request) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendIPAStatusStatus(e8OperationStatus, e8Request);
}

tVoid dispvidctrl_tclServiceRvcIf::sendIPAPatternRequestStatus(rvc_fi_tcl_e8_IPA_PatternID e8DisplayPattern) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendIPAPatternRequestStatus(e8DisplayPattern);
}

tVoid dispvidctrl_tclServiceRvcIf::sendIPAMessageRequestStatus(rvc_fi_tcl_e8_IPA_MessageID e8MessageID) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendIPAMessageRequestStatus(e8MessageID);
}

tVoid dispvidctrl_tclServiceRvcIf::sendIPASwitchMaskRequestStatus(rvc_fi_tcl_e8_IPA_SwitchMask e8SwitchMask) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendIPASwitchMaskRequestStatus(e8SwitchMask);
}

tVoid dispvidctrl_tclServiceRvcIf::sendIPASwitchGreyOutRequestStatus(tU8 u8SwitchGreyOut) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendIPASwitchGreyOutRequestStatus(u8SwitchGreyOut);
}

tVoid dispvidctrl_tclServiceRvcIf::sendIPADirectionIndicatorStatus(rvc_fi_tcl_e8_IPA_DirectionIndicator e8Direction) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendIPADirectionIndicatorStatus(e8Direction);
}

tVoid dispvidctrl_tclServiceRvcIf::sendGdlAdj_SteeringAngleStatus(tBool bShowValues, tU8 u8CentreAdjustmentState, tS32 s32SteeringAngleCentreAdjusted, rvc_fi_tclString SteeringAngleSignalState) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendGdlAdj_SteeringAngleStatus(bShowValues, u8CentreAdjustmentState, s32SteeringAngleCentreAdjusted, SteeringAngleSignalState);
}

tVoid dispvidctrl_tclServiceRvcIf::sendGdlAdj_CameraAngleStatus(tF32 f32CameraRollAngle, tF32 f32CameraYawAngle, tF32 f32CameraPitchAngle) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendGdlAdj_CameraAngleStatus(f32CameraRollAngle, f32CameraYawAngle, f32CameraPitchAngle);
}

tVoid dispvidctrl_tclServiceRvcIf::sendCANFrameStatusStatus(rvc_fi_tcl_e8_RVC_SignalStatus e8StatusCANFrame) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendCANFrameStatusStatus(e8StatusCANFrame);
}

tVoid dispvidctrl_tclServiceRvcIf::sendMvcViewStatusStatus(rvc_fi_tcl_e8_MVCViewingState e8View) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendMvcViewStatusStatus(e8View);
}

tVoid dispvidctrl_tclServiceRvcIf::sendMvcAlertRequestStatus(tBool bRequest) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendMvcAlertRequestStatus(bRequest);
}

tVoid dispvidctrl_tclServiceRvcIf::sendFAPModeStatus(tBool e8State) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendFAPModeStatus(e8State);
}

tVoid dispvidctrl_tclServiceRvcIf::sendFAPSettingsStatus(std::vector<rvc_fi_tcl_FAP_Settings_State, std::allocator<rvc_fi_tcl_FAP_Settings_State> > arFapSettingState, std::vector<rvc_fi_tcl_AVM_Settings_State, std::allocator<rvc_fi_tcl_AVM_Settings_State> > arAvmSettingState) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendFAPSettingsStatus(arFapSettingState, arAvmSettingState);
}

tVoid dispvidctrl_tclServiceRvcIf::sendFAPGuidanceStateStatus(tBool e8State) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendFAPGuidanceStateStatus(e8State);
}

tVoid dispvidctrl_tclServiceRvcIf::sendAVM3_DispStatusStatus(rvc_fi_tcl_e8_AVMph3_DispStatus e8DispStatus) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendAVM3_DispStatusStatus(e8DispStatus);
}

tVoid dispvidctrl_tclServiceRvcIf::sendAVM3_ViewSetupStatus(rvc_fi_tcl_e8_AVMph3_ViewPattern e8ViewPattern, rvc_fi_tcl_e8_AVMph3_CautionId e8CautionId, rvc_fi_tcl_AVMph3_SwitchDescriptor Switch1, rvc_fi_tcl_AVMph3_SwitchDescriptor Switch2, rvc_fi_tcl_AVMph3_SwitchDescriptor Switch3, rvc_fi_tcl_AVMph3_SwitchDescriptor Switch4, rvc_fi_tcl_AVMph3_SwitchDescriptor Switch5, rvc_fi_tcl_AVMph3_SwitchDescriptor Switch6, rvc_fi_tcl_AVMph3_SwitchDescriptor Switch7, rvc_fi_tcl_AVMph3_SwitchDescriptor Switch8, rvc_fi_tcl_e8_AVMph3_IconId e8IconId, rvc_fi_tcl_e8_AVMph3_BuzzerStatus e8BuzzerStatus) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendAVM3_ViewSetupStatus(e8ViewPattern, e8CautionId, Switch1, Switch2, Switch3, Switch4, Switch5, Switch6, Switch7, Switch8, e8IconId, e8BuzzerStatus);
}

tVoid dispvidctrl_tclServiceRvcIf::sendAVM3_ErrorMessageStatus(rvc_fi_tcl_e8_AVMph3_ErrorMessage e8ErrorMessage) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendAVM3_ErrorMessageStatus(e8ErrorMessage);
}

tVoid dispvidctrl_tclServiceRvcIf::sendAVM3_SonarBuzzerStatusStatus(rvc_fi_tcl_e8_AVMph3_BuzzerStatus e8BuzzerStatus) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendAVM3_SonarBuzzerStatusStatus(e8BuzzerStatus);
}

tVoid dispvidctrl_tclServiceRvcIf::sendAVM3_Settings_DetailedStatus(rvc_fi_tcl_e8_AVMph3_Setting_PrioView e8PriorityView, rvc_fi_tcl_e8_AVMph3_Setting_PrioWide e8PriorityWide, rvc_fi_tcl_e8_AVMph3_Setting_AutoCamPos e8AutoCamPos, rvc_fi_tcl_AVMph3_Setting_CornerSonarSensLvl rCornerSonarSensLvl, rvc_fi_tcl_AVMph3_Setting_SonarSensLvl rSonarSensLvl, rvc_fi_tcl_AVMph3_Setting_BuzzerSoundLvl rBuzzerSoundLvl, std::vector<rvc_fi_tcl_AVMph3_Setting_Option, std::allocator<rvc_fi_tcl_AVMph3_Setting_Option> > arSettingsOption) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendAVM3_Settings_DetailedStatus(e8PriorityView, e8PriorityWide, e8AutoCamPos, rCornerSonarSensLvl, rSonarSensLvl, rBuzzerSoundLvl, arSettingsOption);
}

tVoid dispvidctrl_tclServiceRvcIf::sendAVM3_Settings_PrimaryStatus(rvc_fi_tcl_e8_AVMph3_SettingOptionState e8AvmSonarBuzzer, tBool bDetailsSettingsAvail, tBool bImageQualitySettingAvail) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendAVM3_Settings_PrimaryStatus(e8AvmSonarBuzzer, bDetailsSettingsAvail, bImageQualitySettingAvail);
}

tVoid dispvidctrl_tclServiceRvcIf::sendAVM3_ConfigurationStatus(rvc_fi_tcl_e8_AVMph3_ConfigurationStatus e8ConfigStatus, rvc_fi_tcl_AVMph3_Unit_ID rUnit_ID, rvc_fi_tcl_AVMph3_VersionInfo rMsgSetVersion) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendAVM3_ConfigurationStatus(e8ConfigStatus, rUnit_ID, rMsgSetVersion);
}

tVoid dispvidctrl_tclServiceRvcIf::sendAVM3_Software_VersionStatus(rvc_fi_tcl_AVMph3_VersionInfo rSW_Version_AVM, rvc_fi_tcl_AVMph3_VersionInfo rSW_Version_Sonar) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendAVM3_Software_VersionStatus(rSW_Version_AVM, rSW_Version_Sonar);
}

tVoid dispvidctrl_tclServiceRvcIf::sendAVM3_Hardware_VersionStatus(rvc_fi_tcl_AVMph3_VersionInfo rHW_Version_AVM, rvc_fi_tcl_AVMph3_VersionInfo rHW_Version_Sonar) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendAVM3_Hardware_VersionStatus(rHW_Version_AVM, rHW_Version_Sonar);
}

tVoid dispvidctrl_tclServiceRvcIf::sendAVM3_CommunicationErrorsStatus(rvc_fi_tcl_AVMph3_MCAN_CommunicationErrors rCommErrors) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendAVM3_CommunicationErrorsStatus(rCommErrors);
}



tVoid dispvidctrl_tclServiceRvcIf::sendCameraButtonMResult(tBool Result) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendCameraButtonMResult(Result);
}

tVoid dispvidctrl_tclServiceRvcIf::sendSetStatusHmiMResult(rvc_fi_tcl_e8_RVC_SystemStatus e8SystemStatus) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendSetStatusHmiMResult(e8SystemStatus);
}

tVoid dispvidctrl_tclServiceRvcIf::sendSetupLanguageMResult(tBool Result) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendSetupLanguageMResult(Result);
}

tVoid dispvidctrl_tclServiceRvcIf::sendSetupGuideLineMResult(tBool Result) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendSetupGuideLineMResult(Result);
}

tVoid dispvidctrl_tclServiceRvcIf::sendSetupVideoControlsMResult(tBool Result) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendSetupVideoControlsMResult(Result);
}

tVoid dispvidctrl_tclServiceRvcIf::sendSetSystemStatusMResult(tBool Result) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendSetSystemStatusMResult(Result);
}

tVoid dispvidctrl_tclServiceRvcIf::sendrunExtDevicePowerSupplyTestMResult(tU16 pwrSupplyID, rvc_fi_tcl_e8_Camera_PowerSupplyStatus status, tU32 current) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendrunExtDevicePowerSupplyTestMResult(pwrSupplyID, status, current);
}

tVoid dispvidctrl_tclServiceRvcIf::sendInitializeMResult(tBool Result) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendInitializeMResult(Result);
}

tVoid dispvidctrl_tclServiceRvcIf::sendConfirmSystemStatusMResult(tBool Result) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendConfirmSystemStatusMResult(Result);
}

tVoid dispvidctrl_tclServiceRvcIf::sendSetupUserConfigurationMResult(tBool Result) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendSetupUserConfigurationMResult(Result);
}

tVoid dispvidctrl_tclServiceRvcIf::sendSetMicrophoneStateMResult(tBool Result) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendSetMicrophoneStateMResult(Result);
}

tVoid dispvidctrl_tclServiceRvcIf::sendSetRVCStatusMResult(tBool Result) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendSetRVCStatusMResult(Result);
}

tVoid dispvidctrl_tclServiceRvcIf::sendCamera_SetupBeepMResult(rvc_fi_tcl_e8_AVM_StatusBeep e8StatusBeep) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendCamera_SetupBeepMResult(e8StatusBeep);
}

tVoid dispvidctrl_tclServiceRvcIf::sendSetCamerastateMResult(tBool Result) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendSetCamerastateMResult(Result);
}

tVoid dispvidctrl_tclServiceRvcIf::sendChangeViewRequestMResult(tBool Result) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendChangeViewRequestMResult(Result);
}

tVoid dispvidctrl_tclServiceRvcIf::sendAffordable_Its_SetupBswMResult(tBool Result) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendAffordable_Its_SetupBswMResult(Result);
}

tVoid dispvidctrl_tclServiceRvcIf::sendAffordable_Its_SetupModMResult(tBool Result) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendAffordable_Its_SetupModMResult(Result);
}

tVoid dispvidctrl_tclServiceRvcIf::sendAffordable_Its_SetupLdwMResult(tBool Result) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendAffordable_Its_SetupLdwMResult(Result);
}

tVoid dispvidctrl_tclServiceRvcIf::sendIPA_SetHMIStatusMResult(tBool Result) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendIPA_SetHMIStatusMResult(Result);
}

tVoid dispvidctrl_tclServiceRvcIf::sendIPA_SetButtonMResult(tBool Result) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendIPA_SetButtonMResult(Result);
}

tVoid dispvidctrl_tclServiceRvcIf::sendIPA_Voice_TextsMResult(tBool Result) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendIPA_Voice_TextsMResult(Result);
}

tVoid dispvidctrl_tclServiceRvcIf::sendMVC_HMI_ViewRequestMResult(tBool Result) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendMVC_HMI_ViewRequestMResult(Result);
}

tVoid dispvidctrl_tclServiceRvcIf::sendGdlAdj_AdjustmentCompleteMResult(tBool Result) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendGdlAdj_AdjustmentCompleteMResult(Result);
}

tVoid dispvidctrl_tclServiceRvcIf::sendGdlAdj_AdjustButtonMResult(tBool Result) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendGdlAdj_AdjustButtonMResult(Result);
}

tVoid dispvidctrl_tclServiceRvcIf::sendGdlAdj_ConfigurationDataMResult(tBool Result, rvc_fi_tcl_e8_GdlAdj_Request e8Request, std::vector<rvc_fi_tcl_GdlAdj_ConfigParameterData, std::allocator<rvc_fi_tcl_GdlAdj_ConfigParameterData> > arConfigParameterData) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendGdlAdj_ConfigurationDataMResult(Result, e8Request, arConfigParameterData);
}

tVoid dispvidctrl_tclServiceRvcIf::sendFAP_SetButtonMResult(tBool Result) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendFAP_SetButtonMResult(Result);
}

tVoid dispvidctrl_tclServiceRvcIf::sendTouchEventMResult(tBool Result) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendTouchEventMResult(Result);
}

tVoid dispvidctrl_tclServiceRvcIf::sendGPSInfoMResult(tBool Result) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendGPSInfoMResult(Result);
}

tVoid dispvidctrl_tclServiceRvcIf::sendMapMatchedInfoMResult(tBool Result) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendMapMatchedInfoMResult(Result);
}

tVoid dispvidctrl_tclServiceRvcIf::sendFapLearnParkPositionMResult(tBool Result) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendFapLearnParkPositionMResult(Result);
}

tVoid dispvidctrl_tclServiceRvcIf::sendSetFapGuidanceMResult(tBool Result) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendSetFapGuidanceMResult(Result);
}

tVoid dispvidctrl_tclServiceRvcIf::sendAVM3_SetSwitchMResult(tBool bResult) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendAVM3_SetSwitchMResult(bResult);
}

tVoid dispvidctrl_tclServiceRvcIf::sendAVM3_SetSonarBuzzerStatusMResult(tBool bResult) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendAVM3_SetSonarBuzzerStatusMResult(bResult);
}

tVoid dispvidctrl_tclServiceRvcIf::sendAVM3_Settings_Detailed_SendReqMResult(tBool bResult) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendAVM3_Settings_Detailed_SendReqMResult(bResult);
}

tVoid dispvidctrl_tclServiceRvcIf::sendAVM3_Settings_Primary_SendReqMResult(tBool bResult) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendAVM3_Settings_Primary_SendReqMResult(bResult);
}

tVoid dispvidctrl_tclServiceRvcIf::sendAVM3_GetVersionInfoMResult(tBool bResult) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendAVM3_GetVersionInfoMResult(bResult);
}

tVoid dispvidctrl_tclServiceRvcIf::sendAVM3_GetCommunicationErrorsMResult(tBool bResult) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendAVM3_GetCommunicationErrorsMResult(bResult);
}

tVoid dispvidctrl_tclServiceRvcIf::sendAVM3_ClearCommunicationErrorsMResult(tBool bResult) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendAVM3_ClearCommunicationErrorsMResult(bResult);
}

tVoid dispvidctrl_tclServiceRvcIf::sendToggleGpioPinOnOffMResult() {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendToggleGpioPinOnOffMResult();
}





// dispvidctrl_tclServiceRvcIfdispvidctrl_ServiceRvcIf: user specific code start
/******************************************************************************/
/* FUNCTION     vGetConfiguration                                             */
/******************************************************************************/
/**
*  \brief       Function to get all configuration values needed by this class.
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclServiceRvcIf::vGetConfiguration(const TConfiguration* pStConfigurationValues)
{
   ETG_TRACE_USR4(("dispvidctrl_tclServiceRVCIf::vGetConfiguration() entered."));

   m_bRvcMode = pStConfigurationValues->bRvcMode;
   m_bAvmMode = pStConfigurationValues->bAvmMode;
   m_bMvcMode = pStConfigurationValues->bMvcMode;
   m_bAvmType_Phase3 = pStConfigurationValues->bAvmType_Phase3;
}

/******************************************************************************/
/* FUNCTION     vGetIPA_Voice_TextsMsg                                        */
/******************************************************************************/
/**
*  \brief       Function to get IPA_Voice_TextsMsg
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclServiceRvcIf::vGetIPA_Voice_TextsMsg(rvc_ccafi_tclMsgIPA_Voice_TextsMethodStart& oMethodStart)
{
   DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->vGetIPA_Voice_TextsMsg(oMethodStart);
}
// dispvidctrl_tclServiceRvcIfdispvidctrl_ServiceRvcIf: user specific code end

//EOF
