/*****************************************************************************
* FILE:         dispvidctrl_ServiceDimmingIf.h
* PROJECT:      G3G project
* SW-COMPONENT: dispvidctrl
* Template:     ServiceIf.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  
*               Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2018 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#ifndef __dispvidctrl_ServiceDimmingIf__IF__H_
#define __dispvidctrl_ServiceDimmingIf__IF__H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

//include base class
#include "I_dispvidctrl_ServiceDimmingIf.h"
#include "dispvidctrl_AppMain.h"
#include "dispvidctrl_ServiceDimmingCallbackIf.h"

// dispvidctrl_tclServiceDimmingIf_Include: user specific code start
#include "I_dispvidctrl_tclDisplaySettings.h"

class I_dispvidctrl_tclClientVcan;
class I_dispvidctrl_tclClientDimming;
class I_dispvidctrl_tclSecondDispIf;
// dispvidctrl_tclServiceDimmingIf_Include: user specific code end

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class Idispvidctrl_tclServiceDimming;

class dispvidctrl_tclServiceDimmingIf : public Idispvidctrl_tclServiceDimmingIf, public dispvidctrl_tclServiceDimmingCallbackIF
{
public:

   dispvidctrl_tclServiceDimmingIf(tVoid); 
   dispvidctrl_tclServiceDimmingIf(dispvidctrl_tclAppMain* poMainAppl);
   virtual ~dispvidctrl_tclServiceDimmingIf();

   // dispvidctrl_tclServiceDimmingIfDeclarations: user specific code start
   // dispvidctrl_tclServiceDimmingIfDeclarations: user specific code end

   virtual tVoid onServiceAvailable();
   virtual tVoid onServiceUnavailable();
   
   virtual const tChar* getName() const { return "dispvidctrl_tclServiceDimmingIf"; };
   
   virtual tVoid vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();
   
    /***************************************************************************
    * Application specific methods.
    ***************************************************************************/
   virtual tVoid sendDIM_INFO_CarIlluminationDataStatus(dimming_fi_tcl_e8_DIM_Status IlluminationSwitch, dimming_fi_tcl_u16_DIM_Permille IlluminationBrightness);
   virtual tVoid sendDIM_INFO_LightSensorBrightnessStatus(dimming_fi_tcl_e8_DIM_Status SensorAvail, dimming_fi_tcl_u16_DIM_Permille SensorBrightness);
   virtual tVoid sendDIM_INFO_DimmingModeStatus(dimming_fi_tcl_e8_DIM_Mode Config, dimming_fi_tcl_e8_DIM_Mode Car, dimming_fi_tcl_e8_DIM_Mode Status);
   virtual tVoid sendDIM_INFO_EmulationModeStatus(dimming_fi_tcl_e8_DIM_EmulationMode EmulationMode);
   virtual tVoid sendDIM_INFO_ITCStatus(tU16 ITC);
   virtual tVoid sendDIM_INFO_PWMBrightnessStatus(dimming_fi_tcl_u16_DIM_Permille PWMBrightness);
   virtual tVoid sendDIM_INFO_CANBrightnessStatus(dimming_fi_tcl_u16_DIM_Permille CANBrightness);
   virtual tVoid sendDIM_KEYB_BrightnessStatus(dimming_fi_tcl_u16_DIM_Permille Brightness);
   virtual tVoid sendDIM_KEYB_HalfclassStatus(dimming_fi_tcl_u8_DIM_Halfclasses Halfclass_A, dimming_fi_tcl_u8_DIM_Halfclasses Halfclass_B, tU8 ADC_CFG_A, tU8 ADC_CFG_B, tU16 ADC_A, tU16 ADC_B, tU16 PWM_HC_A, tU16 PWM_HC_B);
   virtual tVoid sendDIM_DISP_DriverInitalizedStatus(dimming_fi_tcl_e8_DIM_Status DriverInitialized);
   virtual tVoid sendDIM_DISP_ScreenContentAvailableStatus(dimming_fi_tcl_e8_DIM_Status ContentAvailable);
   virtual tVoid sendDIM_DISP_BrightnessStatus(dimming_fi_tcl_u16_DIM_Permille Brightness);
   virtual tVoid sendDIM_DISP_BacklightStatus(dimming_fi_tcl_e8_DIM_Status BacklightStatus);
   virtual tVoid sendDIM_DISP_TemperatureInfoStatus(dimming_fi_tcl_s16_DIM_Temperature PanelTemp, dimming_fi_tcl_s16_DIM_Temperature AmbientTemp, dimming_fi_tcl_e8_DIM_WarningLevel WarningLevel, tU16 CriticalLevelTimeout, tU16 CriticalLevelElapsed);
   virtual tVoid sendDIM_DISP_SizeStatus(dimming_fi_tcl_e8_DIM_DisplaySize Size);
   virtual tVoid sendDIM_DISP_BrightnessLevelStatus(dimming_fi_tcl_e8_DIM_BrightnessLevel BrightnessLevel);
   virtual tVoid sendDIM_DISP_PanelTemperatureStatus(dimming_fi_tcl_s16_DIM_Temperature Temperature);
   virtual tVoid sendDIM_DISP_BrightnessLevelExtendedStatus(tU8 BrightnessLevelExtended);
   virtual tVoid sendDIM_DISP_VideoBrightnessLevelStatus(tU8 VideoBrightnessLevel);
   virtual tVoid sendDIM_DISP_ContrastLevelStatus(tU8 Contrast);
   virtual tVoid sendDIM_DISP_BlackLevelStatus(tU8 BlackLevel);
   virtual tVoid sendDIM_DISP_YCurveLevelStatus(tU8 YCurveLevel);
   virtual tVoid sendDIM_DISP_TintLevelStatus(tU8 TintLevel);
   virtual tVoid sendDIM_DISP_ColorLevelStatus(tU8 Color);
   virtual tVoid sendDIM_DISP_DAY_LUMINOSITY_OFFSETStatus(tU8 DayLuminosityOffset);
   virtual tVoid sendDIM_DISP_NIGHT_LUMINOSITY_OFFSETStatus(tU8 NightLuminosityOffset);
   virtual tVoid sendDIM_DISP_COCKPIT_SLIDER_OFFSETStatus(tU8 CockpitDimmingSliderOffset);
   virtual tVoid sendDIM_DIAG_VariantStatus(tU8 Variant);
   virtual tVoid sendDIM_DIAG_BrightnessInputTypeStatus(dimming_fi_tcl_e8_DIM_InputConfiguration InputConfiguration);
   virtual tVoid sendDIM_DISP_CSCContrastLevelStatus(tU8 ContrastLevel);
   virtual tVoid sendDIM_DISP_CSCBlackLevelStatus(tU8 BlackLevel);
   virtual tVoid sendDIM_DISP_CSCGammaLevelStatus(tU8 GammaLevel);
   virtual tVoid sendDIM_DISP_CSCSaturationLevelStatus(tU8 SaturationLevel);
   virtual tVoid sendDIM_DISP_CSCColorLevelStatus(tU8 ColorLevel);
   virtual tVoid sendDIM_SECOND_DISP_AllDisplayParamStatus(tU8 u8BlackLevel, tU8 u8Brightness, tU8 u8Color, tU8 u8Contrast, tU8 u8Tint, tU16 u8GammaLevel);
   virtual tVoid sendDIM_SECOND_DISP_SelfDiagnosisResultStatus(tU16 u16SelfDiagResult );

   virtual tBool onDIM_DISP_DAY_LUMINOSITY_OFFSETSet(tU8 DayLuminosityOffset, tBool& bPropertyChanged, tU16& u16ErrorCode);
   virtual tBool onDIM_DISP_NIGHT_LUMINOSITY_OFFSETSet(tU8 NightLuminosityOffset, tBool& bPropertyChanged, tU16& u16ErrorCode);
   virtual tBool onDIM_DISP_COCKPIT_SLIDER_OFFSETSet(tU8 CockpitDimmingSliderOffset, tBool& bPropertyChanged, tU16& u16ErrorCode);

   virtual tVoid sendFI_VD_DIMMING_DEFAULTMResult(tU8 DefaultSettingsGroup, tU8 DefaultSettingsStatus);
   virtual tVoid sendDIM_INFO_SetDimmingModeMResult(dimming_fi_tcl_e8_DIM_Mode DimmingMode);
   virtual tVoid sendDIM_INFO_SetEmulationModeMResult(dimming_fi_tcl_e8_DIM_EmulationMode EmulationMode);
   virtual tVoid sendDIM_INFO_SetDimmingStateMResult(tU8 LUN, dimming_fi_tcl_e8_DIM_Status DimmingStatus);
   virtual tVoid sendDIM_INFO_GetDimmingStateMResult(tU8 LUN, dimming_fi_tcl_e8_DIM_Status DimmingState);
   virtual tVoid sendDIM_INFO_SetDimmingBrightnessMResult(dimming_fi_tcl_u8_DIM_LUN LUN, dimming_fi_tcl_u16_DIM_Permille Brightness);
   virtual tVoid sendDIM_INFO_GetDimmingBrightnessMResult(dimming_fi_tcl_u8_DIM_LUN LUN, dimming_fi_tcl_u16_DIM_Permille Brightness);
   virtual tVoid sendDIM_INFO_GetPWMBrightnessMResult(dimming_fi_tcl_u16_DIM_Permille Brightness);
   virtual tVoid sendDIM_KEYB_SetDimmingMResult(dimming_fi_tcl_u16_DIM_Permille Brightness);
   virtual tVoid sendDIM_KEYB_SetDimmingPWMMResult(dimming_fi_tcl_u16_DIM_Permille Brightness);
   virtual tVoid sendDIM_DISP_SetDriverInitalizedMResult(dimming_fi_tcl_e8_DIM_Status SetDriverInitialized);
   virtual tVoid sendDIM_DISP_SetScreenContentAvailableMResult(dimming_fi_tcl_e8_DIM_Status SetScreenContentAvailable);
   virtual tVoid sendDIM_DISP_SetDimmingMResult(dimming_fi_tcl_u16_DIM_Permille Brightness);
   virtual tVoid sendDIM_DISP_SwitchBacklightMResult(dimming_fi_tcl_e8_DIM_Status SwitchBacklight);
   virtual tVoid sendDIM_DISP_SetBrightnessLevelMResult(dimming_fi_tcl_e8_DIM_BrightnessLevel BrightnessLevel);
   virtual tVoid sendDIM_DISP_SetBrightnessLevelExtendedMResult(tU8 BrightnessLevelExtended);
   virtual tVoid sendDIM_DISP_SetVideoBrightnessLevelMResult(tU8 VideoBrightnessLevelDay, tU8 VideoBrightnessLevelNight);
   virtual tVoid sendDIM_DISP_SetContrastLevelMResult(tU8 BrightnessLevelExtended);
   virtual tVoid sendDIM_DISP_SetBlackLevelMResult(tU8 BlackLevel);
   virtual tVoid sendDIM_DISP_SetYCurveLevelMResult(tU8 YCurveLevel);
   virtual tVoid sendDIM_DISP_SetTintLevelMResult(tU8 TintLevel);
   virtual tVoid sendDIM_DISP_SetColorLevelMResult(tU8 ColorLevel);
   virtual tVoid sendDIM_DIAG_SetBrightnessInputTypeMResult(dimming_fi_tcl_e8_DIM_InputConfiguration SetBrightnessInputType);
   virtual tVoid sendDIM_DISP_SetCSCContrastLevelMResult(tU8 ContrastLevel);
   virtual tVoid sendDIM_DISP_SetCSCBlackLevelMResult(tU8 BlackLevel);
   virtual tVoid sendDIM_DISP_SetCSCGammaLevelMResult(tU8 GammaLevel);
   virtual tVoid sendDIM_DISP_SetCSCSaturationLevelMResult(tU8 SaturationLevel);
   virtual tVoid sendDIM_DISP_SetCSCColorLevelMResult(tU8 ColorLevel);
   virtual tVoid sendDIM_SECOND_DISP_SetDispParameterMResult(dimming_fi_tcl_SecondDispFunctionID e16FunctionId, tU16 u16ParameterValue);
   virtual tVoid sendDIM_SECOND_DISP_SetDispOnOffMResult(tU8 u8DisplayState);
   virtual tVoid sendDIM_SECOND_DISP_HardwareVersionMResult(dimming_fi_tcl_SecondDisp_VersionInfo HW_VersionInfo);
   virtual tVoid sendDIM_SECOND_DISP_SoftwareVersionMResult(dimming_fi_tcl_SecondDisp_VersionInfo SW_VersionInfo);
   virtual tVoid sendDIM_SECOND_DISP_GetALLParamMResult();


   virtual tVoid onFI_VD_DIMMING_DEFAULTMStart(tU8 DefaultSettingsGroup, tU8 DefaultSettingsMode);
   virtual tVoid onDIM_INFO_SetDimmingModeMStart(dimming_fi_tcl_e8_DIM_Mode DimmingMode);
   virtual tVoid onDIM_INFO_SetEmulationModeMStart(dimming_fi_tcl_e8_DIM_EmulationMode EmulationMode);
   virtual tVoid onDIM_INFO_SetDimmingStateMStart(tU8 LUN, dimming_fi_tcl_e8_DIM_Status DimmingStatus);
   virtual tVoid onDIM_INFO_GetDimmingStateMStart(tU8 LUN);
   virtual tVoid onDIM_INFO_SetDimmingBrightnessMStart(dimming_fi_tcl_u8_DIM_LUN LUN, dimming_fi_tcl_u16_DIM_Permille Brightness);
   virtual tVoid onDIM_INFO_GetDimmingBrightnessMStart(dimming_fi_tcl_u8_DIM_LUN LUN);
   virtual tVoid onDIM_INFO_GetPWMBrightnessMStart();
   virtual tVoid onDIM_KEYB_SetDimmingMStart(dimming_fi_tcl_u16_DIM_Permille Brightness);
   virtual tVoid onDIM_KEYB_SetDimmingPWMMStart(dimming_fi_tcl_u16_DIM_Permille Brightness);
   virtual tVoid onDIM_DISP_SetDriverInitalizedMStart(dimming_fi_tcl_e8_DIM_Status SetDriverInitialized);
   virtual tVoid onDIM_DISP_SetScreenContentAvailableMStart(dimming_fi_tcl_e8_DIM_Status SetScreenContentAvailable);
   virtual tVoid onDIM_DISP_SetDimmingMStart(dimming_fi_tcl_u16_DIM_Permille Brightness);
   virtual tVoid onDIM_DISP_SwitchBacklightMStart(dimming_fi_tcl_e8_DIM_Status SwitchBacklight);
   virtual tVoid onDIM_DISP_SetBrightnessLevelMStart(dimming_fi_tcl_e8_DIM_BrightnessLevel BrightnessLevel);
   virtual tVoid onDIM_DISP_SetBrightnessLevelExtendedMStart(tU8 BrightnessLevelExtended);
   virtual tVoid onDIM_DISP_SetVideoBrightnessLevelMStart(tU8 VideoBrightnessLevelDay, tU8 VideoBrightnessLevelNight);
   virtual tVoid onDIM_DISP_SetContrastLevelMStart(tU8 Contrast);
   virtual tVoid onDIM_DISP_SetBlackLevelMStart(tU8 BlackLevel);
   virtual tVoid onDIM_DISP_SetYCurveLevelMStart(tU8 YCurveLevel);
   virtual tVoid onDIM_DISP_SetTintLevelMStart(tU8 TintLevel);
   virtual tVoid onDIM_DISP_SetColorLevelMStart(tU8 ColorLevel);
   virtual tVoid onDIM_DIAG_SetBrightnessInputTypeMStart(dimming_fi_tcl_e8_DIM_InputConfiguration SetBrightnessInputType);
   virtual tVoid onDIM_DISP_SetCSCContrastLevelMStart(tU8 ContrastLevel);
   virtual tVoid onDIM_DISP_SetCSCBlackLevelMStart(tU8 BlackLevel);
   virtual tVoid onDIM_DISP_SetCSCGammaLevelMStart(tU8 GammaLevel);
   virtual tVoid onDIM_DISP_SetCSCSaturationLevelMStart(tU8 SaturationLevel);
   virtual tVoid onDIM_DISP_SetCSCColorLevelMStart(tU8 ColorLevel);
   virtual tVoid onDIM_SECOND_DISP_SetDispParameterMStart(dimming_fi_tcl_SecondDispFunctionID e16FunctionId, tU16 u16ParameterValue);
   virtual tVoid onDIM_SECOND_DISP_SetDispOnOffMStart(tU8 u8DisplayState);
   virtual tVoid onDIM_SECOND_DISP_HardwareVersionMStart();
   virtual tVoid onDIM_SECOND_DISP_SoftwareVersionMStart();
   virtual tVoid onDIM_SECOND_DISP_GetALLParamMStart();

   virtual void vGetDIM_INFO_CarIlluminationDataMsg(dimming_mainfi_tclMsgDIM_INFO_CarIlluminationDataStatus& oStatus) {if (_poServerRef) _poServerRef->vGetDIM_INFO_CarIlluminationDataMsg(oStatus);}
   virtual void vGetDIM_INFO_LightSensorBrightnessMsg(dimming_mainfi_tclMsgDIM_INFO_LightSensorBrightnessStatus& oStatus) {if (_poServerRef) _poServerRef->vGetDIM_INFO_LightSensorBrightnessMsg(oStatus);}
   virtual void vGetDIM_INFO_DimmingModeMsg(dimming_mainfi_tclMsgDIM_INFO_DimmingModeStatus& oStatus) {if (_poServerRef) _poServerRef->vGetDIM_INFO_DimmingModeMsg(oStatus);}
   virtual void vGetDIM_INFO_EmulationModeMsg(dimming_mainfi_tclMsgDIM_INFO_EmulationModeStatus& oStatus) {if (_poServerRef) _poServerRef->vGetDIM_INFO_EmulationModeMsg(oStatus);}
   virtual void vGetDIM_INFO_ITCMsg(dimming_mainfi_tclMsgDIM_INFO_ITCStatus& oStatus) {if (_poServerRef) _poServerRef->vGetDIM_INFO_ITCMsg(oStatus);}
   virtual void vGetDIM_INFO_PWMBrightnessMsg(dimming_mainfi_tclMsgDIM_INFO_PWMBrightnessStatus& oStatus) {if (_poServerRef) _poServerRef->vGetDIM_INFO_PWMBrightnessMsg(oStatus);}
   virtual void vGetDIM_INFO_CANBrightnessMsg(dimming_mainfi_tclMsgDIM_INFO_CANBrightnessStatus& oStatus) {if (_poServerRef) _poServerRef->vGetDIM_INFO_CANBrightnessMsg(oStatus);}
   virtual void vGetDIM_KEYB_BrightnessMsg(dimming_mainfi_tclMsgDIM_KEYB_BrightnessStatus& oStatus) {if (_poServerRef) _poServerRef->vGetDIM_KEYB_BrightnessMsg(oStatus);}
   virtual void vGetDIM_KEYB_HalfclassMsg(dimming_mainfi_tclMsgDIM_KEYB_HalfclassStatus& oStatus) {if (_poServerRef) _poServerRef->vGetDIM_KEYB_HalfclassMsg(oStatus);}
   virtual void vGetDIM_DISP_DriverInitalizedMsg(dimming_mainfi_tclMsgDIM_DISP_DriverInitalizedStatus& oStatus) {if (_poServerRef) _poServerRef->vGetDIM_DISP_DriverInitalizedMsg(oStatus);}
   virtual void vGetDIM_DISP_ScreenContentAvailableMsg(dimming_mainfi_tclMsgDIM_DISP_ScreenContentAvailableStatus& oStatus) {if (_poServerRef) _poServerRef->vGetDIM_DISP_ScreenContentAvailableMsg(oStatus);}
   virtual void vGetDIM_DISP_BrightnessMsg(dimming_mainfi_tclMsgDIM_DISP_BrightnessStatus& oStatus) {if (_poServerRef) _poServerRef->vGetDIM_DISP_BrightnessMsg(oStatus);}
   virtual void vGetDIM_DISP_BacklightMsg(dimming_mainfi_tclMsgDIM_DISP_BacklightStatus& oStatus) {if (_poServerRef) _poServerRef->vGetDIM_DISP_BacklightMsg(oStatus);}
   virtual void vGetDIM_DISP_TemperatureInfoMsg(dimming_mainfi_tclMsgDIM_DISP_TemperatureInfoStatus& oStatus) {if (_poServerRef) _poServerRef->vGetDIM_DISP_TemperatureInfoMsg(oStatus);}
   virtual void vGetDIM_DISP_SizeMsg(dimming_mainfi_tclMsgDIM_DISP_SizeStatus& oStatus) {if (_poServerRef) _poServerRef->vGetDIM_DISP_SizeMsg(oStatus);}
   virtual void vGetDIM_DISP_BrightnessLevelMsg(dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelStatus& oStatus) {if (_poServerRef) _poServerRef->vGetDIM_DISP_BrightnessLevelMsg(oStatus);}
   virtual void vGetDIM_DISP_PanelTemperatureMsg(dimming_mainfi_tclMsgDIM_DISP_PanelTemperatureStatus& oStatus) {if (_poServerRef) _poServerRef->vGetDIM_DISP_PanelTemperatureMsg(oStatus);}
   virtual void vGetDIM_DISP_BrightnessLevelExtendedMsg(dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelExtendedStatus& oStatus) {if (_poServerRef) _poServerRef->vGetDIM_DISP_BrightnessLevelExtendedMsg(oStatus);}
   virtual void vGetDIM_DISP_VideoBrightnessLevelMsg(dimming_mainfi_tclMsgDIM_DISP_VideoBrightnessLevelStatus& oStatus) {if (_poServerRef) _poServerRef->vGetDIM_DISP_VideoBrightnessLevelMsg(oStatus);}
   virtual void vGetDIM_DISP_ContrastLevelMsg(dimming_mainfi_tclMsgDIM_DISP_ContrastLevelStatus& oStatus) {if (_poServerRef) _poServerRef->vGetDIM_DISP_ContrastLevelMsg(oStatus);}
   virtual void vGetDIM_DISP_BlackLevelMsg(dimming_mainfi_tclMsgDIM_DISP_BlackLevelStatus& oStatus) {if (_poServerRef) _poServerRef->vGetDIM_DISP_BlackLevelMsg(oStatus);}
   virtual void vGetDIM_DISP_YCurveLevelMsg(dimming_mainfi_tclMsgDIM_DISP_YCurveLevelStatus& oStatus) {if (_poServerRef) _poServerRef->vGetDIM_DISP_YCurveLevelMsg(oStatus);}
   virtual void vGetDIM_DISP_TintLevelMsg(dimming_mainfi_tclMsgDIM_DISP_TintLevelStatus& oStatus) {if (_poServerRef) _poServerRef->vGetDIM_DISP_TintLevelMsg(oStatus);}
   virtual void vGetDIM_DISP_ColorLevelMsg(dimming_mainfi_tclMsgDIM_DISP_ColorLevelStatus& oStatus) {if (_poServerRef) _poServerRef->vGetDIM_DISP_ColorLevelMsg(oStatus);}
   virtual void vGetDIM_DISP_DAY_LUMINOSITY_OFFSETMsg(dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETStatus& oStatus) {if (_poServerRef) _poServerRef->vGetDIM_DISP_DAY_LUMINOSITY_OFFSETMsg(oStatus);}
   virtual void vGetDIM_DISP_NIGHT_LUMINOSITY_OFFSETMsg(dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETStatus& oStatus) {if (_poServerRef) _poServerRef->vGetDIM_DISP_NIGHT_LUMINOSITY_OFFSETMsg(oStatus);}
   virtual void vGetDIM_DISP_COCKPIT_SLIDER_OFFSETMsg(dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETStatus& oStatus) {if (_poServerRef) _poServerRef->vGetDIM_DISP_COCKPIT_SLIDER_OFFSETMsg(oStatus);}
   virtual void vGetDIM_DIAG_VariantMsg(dimming_mainfi_tclMsgDIM_DIAG_VariantStatus& oStatus) {if (_poServerRef) _poServerRef->vGetDIM_DIAG_VariantMsg(oStatus);}
   virtual void vGetDIM_DIAG_BrightnessInputTypeMsg(dimming_mainfi_tclMsgDIM_DIAG_BrightnessInputTypeStatus& oStatus) {if (_poServerRef) _poServerRef->vGetDIM_DIAG_BrightnessInputTypeMsg(oStatus);}
   virtual void vGetDIM_DISP_CSCContrastLevelMsg(dimming_mainfi_tclMsgDIM_DISP_CSCContrastLevelStatus& oStatus) {if (_poServerRef) _poServerRef->vGetDIM_DISP_CSCContrastLevelMsg(oStatus);}
   virtual void vGetDIM_DISP_CSCBlackLevelMsg(dimming_mainfi_tclMsgDIM_DISP_CSCBlackLevelStatus& oStatus) {if (_poServerRef) _poServerRef->vGetDIM_DISP_CSCBlackLevelMsg(oStatus);}
   virtual void vGetDIM_DISP_CSCGammaLevelMsg(dimming_mainfi_tclMsgDIM_DISP_CSCGammaLevelStatus& oStatus) {if (_poServerRef) _poServerRef->vGetDIM_DISP_CSCGammaLevelMsg(oStatus);}
   virtual void vGetDIM_DISP_CSCSaturationLevelMsg(dimming_mainfi_tclMsgDIM_DISP_CSCSaturationLevelStatus& oStatus) {if (_poServerRef) _poServerRef->vGetDIM_DISP_CSCSaturationLevelMsg(oStatus);}
   virtual void vGetDIM_DISP_CSCColorLevelMsg(dimming_mainfi_tclMsgDIM_DISP_CSCColorLevelStatus& oStatus) {if (_poServerRef) _poServerRef->vGetDIM_DISP_CSCColorLevelMsg(oStatus);}
   virtual void vGetDIM_SECOND_DISP_AllDisplayParamMsg(dimming_mainfi_tclMsgDIM_SECOND_DISP_AllDisplayParamStatus& oStatus) {if (_poServerRef) _poServerRef->vGetDIM_SECOND_DISP_AllDisplayParamMsg(oStatus);}
   virtual void vGetDIM_SECOND_DISP_SelfDiagnosisResultMsg(dimming_mainfi_tclMsgDIM_SECOND_DISP_SelfDiagnosisResultStatus& oStatus) {if (_poServerRef) _poServerRef->vGetDIM_SECOND_DISP_SelfDiagnosisResultMsg(oStatus);}

private:
   Idispvidctrl_tclServiceDimming* _poServerRef;

// dispvidctrl_tclServiceDimmingIfDeclarationsPart2: user specific code start
   I_dispvidctrl_tclDisplaySettings* m_poDisplaySettings;
#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1
   I_dispvidctrl_tclClientDimming* m_poClientINCIf;
   I_dispvidctrl_tclClientVcan* _poClientVcan;
#endif

#ifdef VARIANT_S_FTR_ENABLE_AIVI_NPIVI
   I_dispvidctrl_tclSecondDispIf*  _poSecondDispIfRef;
#endif

   tBool m_bDiagLibIoControlActive;
   tBool m_bCcaSrvIoControlActive;
public:
   virtual tBool bSetDimDiagLibIoControl(tBool bActive);
// dispvidctrl_tclServiceDimmingIfDeclarationsPart2: user specific code end

};

#endif // __dispvidctrl_ServiceDimmingIf__IF__H_


