/*****************************************************************************
* FILE:         dispvidctrl_ServiceDimmingIf.cpp
* PROJECT:      G3G project
* SW-COMPONENT: dispvidctrl
* Template:     ServiceIf.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  
*               Generated file
*               Do here service handler specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2018 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/



// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

// dispvidctrl_tclServiceDimmingIfIncludes: user specific code start
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGNOSTICSFI_TYPES
#include "midw_fi_if.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_generic_if.h"
#include "dp_drvass_video_if.h"

#include "Idispvidctrl_ClientDimming.h"
#include "I_dispvidctrl_tclConfigMgr.h"
#include "dispvidctrl_tclTypes.h"
#include "dispvidctrl_ClientVcan.h"

#ifdef VARIANT_S_FTR_ENABLE_AIVI_NPIVI
#include "dispvidctrl_tclSecondDisp.h"
#endif
// dispvidctrl_tclServiceDimmingIfIncludes: user specific code end

#include "dispvidctrl_ServiceDimmingIf.h"
#include "I_dispvidctrl_ServiceDimming.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DISPVIDCTRL_SERVER_DIMMING
#include "trcGenProj/Header/dispvidctrl_ServiceDimmingIf.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: dispvidctrl_tclServiceDimmingIf::
*             dispvidctrl_tclServiceDimmingIf(dispvidctrl_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
dispvidctrl_tclServiceDimmingIf::dispvidctrl_tclServiceDimmingIf(dispvidctrl_tclAppMain* poMainAppl) : 
Idispvidctrl_tclServiceDimmingIf(poMainAppl)
{
   ETG_TRACE_USR4(("dispvidctrl_tclServiceDimmingIf() entered."));
   _poServerRef = OSAL_NULL;

   // dispvidctrl_tclServiceDimmingIfConstructor: user specific code start
   m_poDisplaySettings = OSAL_NULL;
#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1
   m_poClientINCIf = OSAL_NULL;
   _poClientVcan = OSAL_NULL;

#endif

#ifdef VARIANT_S_FTR_ENABLE_AIVI_NPIVI
   _poSecondDispIfRef= NULL;
#endif

   m_bDiagLibIoControlActive = FALSE;
   m_bCcaSrvIoControlActive = FALSE;
   // dispvidctrl_tclServiceDimmingIfConstructor: user specific code end

   //__PRPPERTY_PARAM_INIT__
}

/*******************************************************************************
*
* FUNCTION: dispvidctrl_tclServiceDimmingIf::
*             ~dispvidctrl_tclServiceDimmingIf(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
dispvidctrl_tclServiceDimmingIf::~dispvidctrl_tclServiceDimmingIf(tVoid)
{
   ETG_TRACE_USR4(("~dispvidctrl_tclServiceDimmingIf() entered."));
   _poServerRef = OSAL_NULL;
   
   // dispvidctrl_tclServiceDimmingIfDestructor: user specific code start
   m_poDisplaySettings = OSAL_NULL;
#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1
   m_poClientINCIf = OSAL_NULL;
   _poClientVcan = OSAL_NULL;
#endif
#ifdef VARIANT_S_FTR_ENABLE_AIVI_NPIVI
   _poSecondDispIfRef= NULL;
#endif
   m_bDiagLibIoControlActive = FALSE;
   m_bCcaSrvIoControlActive = FALSE;
   // dispvidctrl_tclServiceDimmingIfDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclServiceDimmingIf::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'dispvidctrl_ServiceDimmingIf.h':
*     Add forward declaration:
*         class Idispvidctrl_tclObject2Get;
*
*     Add declaration of object reference:
*         Idispvidctrl_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Idispvidctrl_tclObject2Get*>(_cpoMain->getHandler("Idispvidctrl_tclObject2Get"));
*     DIMMING_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclServiceDimmingIf::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("dispvidctrl_tclServiceDimmingIf::vGetReferences() entered."));

   _poServerRef = dynamic_cast<Idispvidctrl_tclServiceDimming*>(_cpoMain->getHandler("Idispvidctrl_tclServiceDimming"));

   DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);

   _poServerRef->vSetCallbackIf(this);

   //set callback interface

   // dispvidctrl_tclServiceDimmingIfvGetReferences: user specific code start
   m_poDisplaySettings = dynamic_cast<I_dispvidctrl_tclDisplaySettings*>(_cpoMain->getHandler("I_dispvidctrl_tclDisplaySettings"));

#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1
   m_poClientINCIf = dynamic_cast<I_dispvidctrl_tclClientDimming*>(_cpoMain->getHandler("I_dispvidctrl_tclClientDimming"));
   DISPVIDCTRL_NULL_POINTER_CHECK(m_poClientINCIf);
   //For DimmingReq signal call
   _poClientVcan = dynamic_cast<I_dispvidctrl_tclClientVcan*>(_cpoMain->getHandler("I_dispvidctrl_tclClientVcan"));
   DISPVIDCTRL_NULL_POINTER_CHECK(_poClientVcan);
#endif
#ifdef VARIANT_S_FTR_ENABLE_AIVI_NPIVI
   _poSecondDispIfRef= dynamic_cast<I_dispvidctrl_tclSecondDispIf*>(_cpoMain->getHandler("dispvidctrl_tclSecondDisp"));
#endif
   // dispvidctrl_tclServiceDimmingIfvGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclServiceDimmingIf::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclServiceDimmingIf::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("dispvidctrl_tclServiceDimmingIf::vStartCommunication() entered."));
   // dispvidctrl_tclServiceDimmingIfvStartCommunication: user specific code start
   if (OSAL_NULL != m_poDisplaySettings)
   {
      sendDIM_DISP_CSCContrastLevelStatus(m_poDisplaySettings->u8GetContrastLevel());
      sendDIM_DISP_CSCBlackLevelStatus(m_poDisplaySettings->u8GetBlackLevel());
      sendDIM_DISP_CSCGammaLevelStatus(m_poDisplaySettings->u8GetGammaLevel());
      sendDIM_DISP_CSCSaturationLevelStatus(m_poDisplaySettings->u8GetSaturationLevel());
      sendDIM_DISP_CSCColorLevelStatus(m_poDisplaySettings->u8GetColorLevel());
      // TODO: old staff ... can be remove
      sendDIM_DISP_ContrastLevelStatus(m_poDisplaySettings->u8GetContrastLevel());
      sendDIM_DISP_BlackLevelStatus(m_poDisplaySettings->u8GetBlackLevel());
      sendDIM_DISP_YCurveLevelStatus(m_poDisplaySettings->u8GetGammaLevel());
      sendDIM_DISP_TintLevelStatus(m_poDisplaySettings->u8GetSaturationLevel());
      sendDIM_DISP_ColorLevelStatus(m_poDisplaySettings->u8GetColorLevel());
   }
   if (OSAL_NULL != dispvidctrl_tclAppMain::theServer())
   {
	   dispvidctrl_tclAppMain::theServer()->vPostMsgTriggerSrvDimStartComDone(getName());
   }
//        tChar strIfName[] = "I_dispvidctrl_tclClientDimming";
//    _cpoMain->theServer()->vPostMsgDimModeChanged(strIfName, (tU8)1);
//    sendDIM_INFO_SetDimmingModeMResult(DimmingMode);
   // dispvidctrl_tclServiceDimmingIfvStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclServiceDimmingIf::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclServiceDimmingIf::vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("dispvidctrl_tclServiceDimmingIf::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(dispvidctrl_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   // dispvidctrl_tclServiceDimmingIfvHandleMessage: user specific code start
   switch (pMsg->eCmd)
   {
   case eTriggerSrvDimStartComDone:
	   {
#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1
		   if(OSAL_NULL != _poClientVcan)
		   {
			  TDimmingReq oSlider;
			  dp_tclDimmingDPSLIDER_COCKPIT_Brightness_OFFSET dpDimCockPitSlider_Offset;
			  oSlider.DimmingReq=dpDimCockPitSlider_Offset.tGetData();
			  oSlider.u8TxType=CSM_C_TX_AS_CONFIGURED;
			  _poClientVcan->vSendDimmingReq(oSlider);
		   }
#endif //#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1
	   }
	   break;
   default:
	   {
	   }
	   break;
   }
   // dispvidctrl_tclServiceDimmingIfvHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclServiceDimmingIf::vHandleTraceMessage()
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclServiceDimmingIf::vHandleTraceMessage(const tUChar* puchData)
{
   DISPVIDCTRL_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("dispvidctrl_tclServiceDimmingIf::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // dispvidctrl_tclServiceDimmingIfvHandleTraceMessage: user specific code start
   // dispvidctrl_tclServiceDimmingIfvHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclServiceDimmingIf::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclServiceDimmingIf::vTraceInfo()
{
   // dispvidctrl_tclServiceDimmingIfvTraceInfo: user specific code start
   // dispvidctrl_tclServiceDimmingIfvTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclServiceDimmingIf::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid dispvidctrl_tclServiceDimmingIf::onServiceAvailable()
{
   ETG_TRACE_USR4(("dispvidctrl_tclServiceDimmingIf::onServiceAvailable() entered."));

   // dispvidctrl_tclServiceDimmingIfvOnServiceAvailable: user specific code start

   //Read HMI slider Offset from DataPool and provide to HMI
   dp_tclDimmingDPSLIDER_Screen_DAY_Luminosity_OFFSET dpDayLuminosity_HMISlider;
   dp_tclDimmingDPSLIDER_Screen_NIGHT_Luminosity_OFFSET dpDayNightLuminosity_HMISlider;
   dp_tclDimmingDPSLIDER_COCKPIT_Brightness_OFFSET dpDimCockPitSlider_Offset;
   sendDIM_DISP_DAY_LUMINOSITY_OFFSETStatus(dpDayLuminosity_HMISlider.tGetData());
   sendDIM_DISP_NIGHT_LUMINOSITY_OFFSETStatus(dpDayNightLuminosity_HMISlider.tGetData());
   sendDIM_DISP_COCKPIT_SLIDER_OFFSETStatus(dpDimCockPitSlider_Offset.tGetData());

   // dispvidctrl_tclServiceDimmingIfvOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclServiceDimmingIf::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid dispvidctrl_tclServiceDimmingIf::onServiceUnavailable()
{
   ETG_TRACE_USR4(("dispvidctrl_tclServiceDimmingIf::onServiceUnavailable() entered."));

   // dispvidctrl_tclServiceDimmingIfvOnServiceUnavailable: user specific code start
   // dispvidctrl_tclServiceDimmingIfvOnServiceUnavailable: user specific code end
}

tBool dispvidctrl_tclServiceDimmingIf::onDIM_DISP_DAY_LUMINOSITY_OFFSETSet(tU8 DayLuminosityOffset, tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // onDIM_DISP_DAY_LUMINOSITY_OFFSETSet: user specific code start
#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1
   if (OSAL_NULL != m_poClientINCIf)
   {
      m_poClientINCIf->vLoadDataFromHMI(DayLuminosityOffset);
   }

   (tVoid) bPropertyChanged;
   (tVoid) u16ErrorCode;

   //Also store the offset value in DataPool
   dp_tclDimmingDPSLIDER_Screen_DAY_Luminosity_OFFSET dpDayLuminosity_HMISlider;
   dpDayLuminosity_HMISlider.s32SetData(DayLuminosityOffset);
   sendDIM_DISP_DAY_LUMINOSITY_OFFSETStatus(DayLuminosityOffset);

#else
   (tVoid) DayLuminosityOffset;
   (tVoid) bPropertyChanged;
   (tVoid) u16ErrorCode;
#endif
   // onDIM_DISP_DAY_LUMINOSITY_OFFSETSet: user specific code end
   return _bResult;
}
tBool dispvidctrl_tclServiceDimmingIf::onDIM_DISP_NIGHT_LUMINOSITY_OFFSETSet(tU8 NightLuminosityOffset, tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // onDIM_DISP_NIGHT_LUMINOSITY_OFFSETSet: user specific code start
#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1
   if (OSAL_NULL != m_poClientINCIf)
   {
      m_poClientINCIf->vLoadDataFromHMI(NightLuminosityOffset);
   }

   (tVoid) bPropertyChanged;
   (tVoid) u16ErrorCode;
   //Also store the offset value in DataPool
   dp_tclDimmingDPSLIDER_Screen_NIGHT_Luminosity_OFFSET dpDayNightLuminosity_HMISlider;
   dpDayNightLuminosity_HMISlider.s32SetData(NightLuminosityOffset);
   sendDIM_DISP_NIGHT_LUMINOSITY_OFFSETStatus(NightLuminosityOffset);
#else
   (tVoid) NightLuminosityOffset;
   (tVoid) bPropertyChanged;
   (tVoid) u16ErrorCode;
#endif
   // onDIM_DISP_NIGHT_LUMINOSITY_OFFSETSet: user specific code end
   return _bResult;
}
tBool dispvidctrl_tclServiceDimmingIf::onDIM_DISP_COCKPIT_SLIDER_OFFSETSet(tU8 CockpitDimmingSliderOffset, tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // onDIM_DISP_COCKPIT_SLIDER_OFFSETSet: user specific code start
#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1
   if (OSAL_NULL != m_poClientINCIf)
   {
      m_poClientINCIf->vLoadDataFromHMICockpitSlider(CockpitDimmingSliderOffset);
      m_poClientINCIf->vUpdateOffsetKeyBrightnessLevel(CockpitDimmingSliderOffset);
   }
   (tVoid) bPropertyChanged;
   (tVoid) u16ErrorCode;
   //Also store in Datapool.
   dp_tclDimmingDPSLIDER_COCKPIT_Brightness_OFFSET dpDimCockPitSlider_Offset;
   dpDimCockPitSlider_Offset.s32SetData(CockpitDimmingSliderOffset);
   sendDIM_DISP_COCKPIT_SLIDER_OFFSETStatus(CockpitDimmingSliderOffset);

   ETG_TRACE_USR1(("dispvidctrl_tclServiceDimmingIf::onDIM_DISP_COCKPIT_SLIDER_OFFSETSet: Slider offset = %d .",
   		   CockpitDimmingSliderOffset ));

   TDimmingReq oSlider;
   oSlider.DimmingReq=CockpitDimmingSliderOffset;
   oSlider.u8TxType=CSM_C_TX_AS_CONFIGURED;
   _poClientVcan->vSendDimmingReq(oSlider);

#else
   (tVoid) CockpitDimmingSliderOffset;
   (tVoid) bPropertyChanged;
   (tVoid) u16ErrorCode;
#endif
   // onDIM_DISP_COCKPIT_SLIDER_OFFSETSet: user specific code end
   return _bResult;
}

tVoid dispvidctrl_tclServiceDimmingIf::onFI_VD_DIMMING_DEFAULTMStart(tU8 DefaultSettingsGroup, tU8 DefaultSettingsMode) {

   // onFI_VD_DIMMING_DEFAULTMStart: user specific code start
   ETG_TRACE_USR1(("dispvidctrl_tclServiceDimmingIf::onFI_VD_DIMMING_DEFAULTMStart: method start with group = %d and mode = %d .",
         DefaultSettingsGroup, DefaultSettingsMode ));
   tU8 _u8DefaultSettingsStatus = (tU8)midw_fi_tcl_e8_DefSetServiceStatus::FI_EN_DEFSET_STATE_UNDEFINED;

   if((midw_fi_tcl_e8_DefSetGroups::FI_EN_DEFSET_GROUP__MAINTENANCE == ((midw_fi_tcl_e8_DefSetGroups::tenType)DefaultSettingsGroup))
     && (midw_fi_tcl_e8_DefSetMode::FI_EN_DEFSET_SRC_CODING == ((midw_fi_tcl_e8_DefSetMode::tenType)DefaultSettingsMode)))
   {
      I_dispvidctrl_tclConfigMgr* _poCfgMgr = dynamic_cast<I_dispvidctrl_tclConfigMgr*>(_cpoMain->getHandler("I_dispvidctrl_tclConfigMgr"));
      if (OSAL_NULL != _poCfgMgr)
      {
         _poCfgMgr->vOnLoadSettings();
         _u8DefaultSettingsStatus = (tU8)midw_fi_tcl_e8_DefSetServiceStatus::FI_EN_DEFSET_STATE_CONFIRMED;
      }
   }
   if((midw_fi_tcl_e8_DefSetGroups::FI_EN_DEFSET_GROUP__HMI_OUTLINE__DIMMING == ((midw_fi_tcl_e8_DefSetGroups::tenType)DefaultSettingsGroup))
     && (midw_fi_tcl_e8_DefSetMode::FI_EN_DEFSET_SRC_SET_TEF == ((midw_fi_tcl_e8_DefSetMode::tenType)DefaultSettingsMode)))
   {
		I_dispvidctrl_tclDisplaySettings* _poDimDisplaySettings = dynamic_cast<I_dispvidctrl_tclDisplaySettings*>(dispvidctrl_tclAppMain::theServer()->getHandler("I_dispvidctrl_tclDisplaySettings"));
		if (OSAL_NULL != _poDimDisplaySettings)
		{
			if (0 > _poDimDisplaySettings->s32ResetDisplaySettings())
			{
				ETG_TRACE_ERRMEM(("onFI_VD_DIMMING_DEFAULTMStart() - s32ResetDisplaySettings return negative result "));
			}
			_u8DefaultSettingsStatus = (tU8)midw_fi_tcl_e8_DefSetServiceStatus::FI_EN_DEFSET_STATE_CONFIRMED;
		}
		I_dispvidctrl_tclClientDimming* _poDimINCDimming = dynamic_cast<I_dispvidctrl_tclClientDimming*>(dispvidctrl_tclAppMain::theServer()->getHandler("I_dispvidctrl_tclClientDimming"));
		if (OSAL_NULL != _poDimINCDimming)
		{
			if (0 > _poDimINCDimming->s32ResetDimming())
			{
				ETG_TRACE_ERRMEM(("onFI_VD_DIMMING_DEFAULTMStart() - s32ResetDimming return negative result "));
			}
			_u8DefaultSettingsStatus = (tU8)midw_fi_tcl_e8_DefSetServiceStatus::FI_EN_DEFSET_STATE_CONFIRMED;
		}

   }

   sendFI_VD_DIMMING_DEFAULTMResult(DefaultSettingsGroup, _u8DefaultSettingsStatus);
   // onFI_VD_DIMMING_DEFAULTMStart: user specific code end
}
tVoid dispvidctrl_tclServiceDimmingIf::onDIM_INFO_SetDimmingModeMStart(dimming_fi_tcl_e8_DIM_Mode DimmingMode) {

   // onDIM_INFO_SetDimmingModeMStart: user specific code start
   tChar strIfName[] = "I_dispvidctrl_tclClientDimming";
   _cpoMain->theServer()->vPostMsgDimModeChanged(strIfName, (tU8)DimmingMode.enType );
   sendDIM_INFO_SetDimmingModeMResult(DimmingMode);
   // onDIM_INFO_SetDimmingModeMStart: user specific code end
}
tVoid dispvidctrl_tclServiceDimmingIf::onDIM_INFO_SetEmulationModeMStart(dimming_fi_tcl_e8_DIM_EmulationMode EmulationMode) {

   // onDIM_INFO_SetEmulationModeMStart: user specific code start
   dp_tclDimmingDPINFO_EmulationModeSet _oDpEmulationMode;
   dimming_fi_tcl_e8_DIM_EmulationMode _oEmulationMode;
   _oEmulationMode.enType = (dimming_fi_tcl_e8_DIM_EmulationMode::tenType)_oDpEmulationMode.tGetData();
   if (FALSE == m_bDiagLibIoControlActive)
   {
	   tBool _bActive = m_bCcaSrvIoControlActive;
	   m_bCcaSrvIoControlActive = TRUE;
	   switch (EmulationMode.enType)
	   {
	   case dimming_fi_tcl_e8_DIM_EmulationMode::FI_EN_OFF:
	   case dimming_fi_tcl_e8_DIM_EmulationMode::FI_EN_DISPFREEZE:
	   case dimming_fi_tcl_e8_DIM_EmulationMode::FI_EN_KEYBFREEZE:
	   case dimming_fi_tcl_e8_DIM_EmulationMode::FI_EN_SETUP:
	   case dimming_fi_tcl_e8_DIM_EmulationMode::FI_EN_VERIFY:
	      {
	         // send INC message
	         if (OSAL_NULL != _cpoMain)
	         {
	            tChar strIfName[] = "I_dispvidctrl_tclClientDimming";
	            _cpoMain->theServer()->vPostMsgEmulationModeSet(strIfName, (tU8)EmulationMode.enType );
	            _bActive = (dimming_fi_tcl_e8_DIM_EmulationMode::FI_EN_OFF != EmulationMode.enType);
	         }
	         else
	         {
	            sendDIM_INFO_SetEmulationModeMResult(_oEmulationMode);
	         }
	      }
	      break;
	   default:
	      {
	         // invalid parameter
	         sendDIM_INFO_SetEmulationModeMResult(_oEmulationMode);
	      }
	      break;
	   }
	   m_bCcaSrvIoControlActive = _bActive;
   }
   else
   {
       sendDIM_INFO_SetEmulationModeMResult(_oEmulationMode);
   }
   // onDIM_INFO_SetEmulationModeMStart: user specific code end
}
tVoid dispvidctrl_tclServiceDimmingIf::onDIM_INFO_SetDimmingStateMStart(tU8 LUN, dimming_fi_tcl_e8_DIM_Status DimmingStatus) {

   // onDIM_INFO_SetDimmingStateMStart: user specific code start
   (tVoid) LUN;
   (tVoid) DimmingStatus;
   // onDIM_INFO_SetDimmingStateMStart: user specific code end
}
tVoid dispvidctrl_tclServiceDimmingIf::onDIM_INFO_GetDimmingStateMStart(tU8 LUN) {

   // onDIM_INFO_GetDimmingStateMStart: user specific code start
   (tVoid) LUN;
   // onDIM_INFO_GetDimmingStateMStart: user specific code end
}
tVoid dispvidctrl_tclServiceDimmingIf::onDIM_INFO_SetDimmingBrightnessMStart(dimming_fi_tcl_u8_DIM_LUN LUN, dimming_fi_tcl_u16_DIM_Permille Brightness) {

   // onDIM_INFO_SetDimmingBrightnessMStart: user specific code start
   (tVoid) LUN;
   (tVoid) Brightness;
   // onDIM_INFO_SetDimmingBrightnessMStart: user specific code end
}
tVoid dispvidctrl_tclServiceDimmingIf::onDIM_INFO_GetDimmingBrightnessMStart(dimming_fi_tcl_u8_DIM_LUN LUN) {

   // onDIM_INFO_GetDimmingBrightnessMStart: user specific code start
   (tVoid) LUN;
   // onDIM_INFO_GetDimmingBrightnessMStart: user specific code end
}
tVoid dispvidctrl_tclServiceDimmingIf::onDIM_INFO_GetPWMBrightnessMStart() {

   // onDIM_INFO_GetPWMBrightnessMStart: user specific code start
   if (OSAL_NULL != _cpoMain)
   {
      tChar strIfName[] = "I_dispvidctrl_tclClientDimming";
      _cpoMain->theServer()->vPostMsgPwmBrightnessGet(strIfName);
   }
   else
   {
      sendDIM_INFO_GetPWMBrightnessMResult(0);
   }
   // onDIM_INFO_GetPWMBrightnessMStart: user specific code end
}
tVoid dispvidctrl_tclServiceDimmingIf::onDIM_KEYB_SetDimmingMStart(dimming_fi_tcl_u16_DIM_Permille Brightness) {

   // onDIM_KEYB_SetDimmingMStart: user specific code start
   if (1000 < Brightness.u16Value)
   {
      // invalid parameter
      sendDIM_KEYB_SetDimmingMResult(0);
   }
   else if ((OSAL_NULL != _cpoMain) && (TRUE == m_bCcaSrvIoControlActive))
   {
	   dp_tclDimmingDPINFO_EmulationModeSet _oDpEmulationMode;
	   if (DISPVIDCTRL_C_U8_EMULATIONMODE_KEYBFREEZE == _oDpEmulationMode.tGetData())
	   {
		   tChar strIfName[] = "I_dispvidctrl_tclClientDimming";
		   _cpoMain->theServer()->vPostMsgKeybBrightnessSet(strIfName, Brightness.u16Value );
	   }
	   else
	   {
		   // keyboard brightness could not set
		   sendDIM_KEYB_SetDimmingMResult(0);
	  }
   }
   else
   {
      // no application reference
      sendDIM_KEYB_SetDimmingMResult(0);
   }
   // onDIM_KEYB_SetDimmingMStart: user specific code end
}
tVoid dispvidctrl_tclServiceDimmingIf::onDIM_KEYB_SetDimmingPWMMStart(dimming_fi_tcl_u16_DIM_Permille Brightness) {

   // onDIM_KEYB_SetDimmingPWMMStart: user specific code start
   if (1000 < Brightness.u16Value)
   {
      // invalid parameter
      sendDIM_KEYB_SetDimmingPWMMResult(0);
   }
   else if ((OSAL_NULL != _cpoMain) && (TRUE == m_bCcaSrvIoControlActive))
   {
      dp_tclDimmingDPINFO_EmulationModeSet _oDpEmulationMode;
      if (DISPVIDCTRL_C_U8_EMULATIONMODE_SETUP == _oDpEmulationMode.tGetData())
      {
         tChar strIfName[] = "I_dispvidctrl_tclClientDimming";
         _cpoMain->theServer()->vPostMsgKeybBrightnessSet(strIfName, Brightness.u16Value );
      }
      else
      {
         // keyboard brightness could not set
         sendDIM_KEYB_SetDimmingPWMMResult(0);
      }
   }
   else
   {
      // no application reference
      sendDIM_KEYB_SetDimmingPWMMResult(0);
   }
   // onDIM_KEYB_SetDimmingPWMMStart: user specific code end
}
tVoid dispvidctrl_tclServiceDimmingIf::onDIM_DISP_SetDriverInitalizedMStart(dimming_fi_tcl_e8_DIM_Status SetDriverInitialized) {

   // onDIM_DISP_SetDriverInitalizedMStart: user specific code start
   (tVoid) SetDriverInitialized;
   // onDIM_DISP_SetDriverInitalizedMStart: user specific code end
}
tVoid dispvidctrl_tclServiceDimmingIf::onDIM_DISP_SetScreenContentAvailableMStart(dimming_fi_tcl_e8_DIM_Status SetScreenContentAvailable) {

   // onDIM_DISP_SetScreenContentAvailableMStart: user specific code start
   (tVoid) SetScreenContentAvailable;
   // onDIM_DISP_SetScreenContentAvailableMStart: user specific code end
}
tVoid dispvidctrl_tclServiceDimmingIf::onDIM_DISP_SetDimmingMStart(dimming_fi_tcl_u16_DIM_Permille Brightness) {

   // onDIM_DISP_SetDimmingMStart: user specific code start
   dp_tclDimmingDPINFO_EmulationModeSet _oDpEmulationMode;
   if (1000 < Brightness.u16Value)
   {
      // invalid parameter
      sendDIM_DISP_SetDimmingMResult(0);
   }
   else if ((OSAL_NULL != _cpoMain) && (TRUE == m_bCcaSrvIoControlActive))
   {
      if (DISPVIDCTRL_C_U8_EMULATIONMODE_DISPFREEZE == _oDpEmulationMode.tGetData())
      {
         tChar strIfName[] = "I_dispvidctrl_tclClientDimming";
         _cpoMain->theServer()->vPostMsgDispBrightnessSet(strIfName, Brightness.u16Value );
      }
      else
      {
         // display brightness could not set
         sendDIM_DISP_SetDimmingMResult(0);
      }
   }
   else
   {
      // no application reference
      sendDIM_DISP_SetDimmingMResult(0);
   }
   // onDIM_DISP_SetDimmingMStart: user specific code end
}
tVoid dispvidctrl_tclServiceDimmingIf::onDIM_DISP_SwitchBacklightMStart(dimming_fi_tcl_e8_DIM_Status SwitchBacklight) {

   // onDIM_DISP_SwitchBacklightMStart: user specific code start
   tenBackLightState _enDimState = eBackLight_None;
   dimming_fi_tcl_e8_DIM_Status _oDimState;
   _oDimState.enType = SwitchBacklight.enType;
   switch (SwitchBacklight.enType)
   {
   case dimming_fi_tcl_e8_DIM_Status::FI_EN_OFF:
      {
         _enDimState = eBackLight_Hmi_Off;
      }
      break;
   case dimming_fi_tcl_e8_DIM_Status::FI_EN_ON:
   case dimming_fi_tcl_e8_DIM_Status::FI_EN_AUTOMATIC:
      {
         _enDimState = eBackLight_Hmi_Auto;
      }
      break;
   case dimming_fi_tcl_e8_DIM_Status::FI_EN_OFF_BY_HEATCTRL:
      {
         _enDimState = eBackLight_HC_Off;
      }
      break;
   case dimming_fi_tcl_e8_DIM_Status::FI_EN_ON_BY_HEATCTRL:
      {
         _enDimState = eBackLight_HC_Auto;
      }
      break;
   default:
      {
           ETG_TRACE_FATAL(("dispvidctrl_tclServiceDimmingIf::onDIM_DISP_SwitchBacklightMStart(): unknown DimState %d", SwitchBacklight.enType ));
           _oDimState.enType = dimming_fi_tcl_e8_DIM_Status::FI_EN_UNKNOWN;
      }
      break;
   }
   if (OSAL_NULL != _cpoMain && eBackLight_None != _enDimState)
   {
      const tChar* _cstrIfName = "I_dispvidctrl_tclClientDimming";
      tU32 _u32DimState = (tU32)_enDimState;
      _cpoMain->theServer()->vPostMsgDimStateChanged(_cstrIfName, _u32DimState);

   }
   else
   {
       ETG_TRACE_FATAL(("dispvidctrl_tclServiceDimmingIf::onDIM_DISP_SwitchBacklightMStart(): DimState %d could not set! (poMain: 0x%08x)", SwitchBacklight.enType, _cpoMain ));
   }
   sendDIM_DISP_SwitchBacklightMResult(_oDimState);
   // onDIM_DISP_SwitchBacklightMStart: user specific code end
}
tVoid dispvidctrl_tclServiceDimmingIf::onDIM_DISP_SetBrightnessLevelMStart(dimming_fi_tcl_e8_DIM_BrightnessLevel BrightnessLevel) {

   // onDIM_DISP_SetBrightnessLevelMStart: user specific code start
   (tVoid) BrightnessLevel;
   // onDIM_DISP_SetBrightnessLevelMStart: user specific code end
}
tVoid dispvidctrl_tclServiceDimmingIf::onDIM_DISP_SetBrightnessLevelExtendedMStart(tU8 BrightnessLevelExtended) {

   // onDIM_DISP_SetBrightnessLevelExtendedMStart: user specific code start
   if (OSAL_NULL != _cpoMain)
   {
      tChar _strIfName[] = "I_dispvidctrl_tclClientDimming";
      tU8 _u8Level = BrightnessLevelExtended;
      if (DISPVIDCTRL_C_U8_LEVEL_MAX < _u8Level)
        _u8Level = DISPVIDCTRL_C_U8_LEVEL_MAX;
     _cpoMain->theServer()->vPostMsgDimBrightnessChanged(_strIfName, _u8Level);
   }
   //sendDIM_DISP_SetBrightnessLevelExtendedMResult(BrightnessLevelExtended);
   // onDIM_DISP_SetBrightnessLevelExtendedMStart: user specific code end
}
tVoid dispvidctrl_tclServiceDimmingIf::onDIM_DISP_SetVideoBrightnessLevelMStart(tU8 VideoBrightnessLevelDay, tU8 VideoBrightnessLevelNight) {

   // onDIM_DISP_SetVideoBrightnessLevelMStart: user specific code start
   (tVoid) VideoBrightnessLevelDay;
   (tVoid) VideoBrightnessLevelNight;
   // onDIM_DISP_SetVideoBrightnessLevelMStart: user specific code end
}
tVoid dispvidctrl_tclServiceDimmingIf::onDIM_DISP_SetContrastLevelMStart(tU8 Contrast) {

   // onDIM_DISP_SetContrastLevelMStart: user specific code start
   tU8 _u8Level = Contrast;
   if (DISPVIDCTRL_C_U8_LEVEL_MAX < _u8Level)
      _u8Level = DISPVIDCTRL_C_U8_LEVEL_MAX;

   if (OSAL_NULL != m_poDisplaySettings && 0 <= m_poDisplaySettings->s32SetContrastLevel(_u8Level))
   {
      sendDIM_DISP_SetContrastLevelMResult(m_poDisplaySettings->u8GetContrastLevel());
      sendDIM_DISP_ContrastLevelStatus(m_poDisplaySettings->u8GetContrastLevel());
   }
   else
   {
      sendDIM_DISP_SetContrastLevelMResult(OSAL_C_U8_MAX);
   }
   // onDIM_DISP_SetContrastLevelMStart: user specific code end
}
tVoid dispvidctrl_tclServiceDimmingIf::onDIM_DISP_SetBlackLevelMStart(tU8 BlackLevel) {

   // onDIM_DISP_SetBlackLevelMStart: user specific code start
   tU8 _u8Level = BlackLevel;
   if (DISPVIDCTRL_C_U8_LEVEL_MAX < _u8Level)
      _u8Level = DISPVIDCTRL_C_U8_LEVEL_MAX;

   if (OSAL_NULL != m_poDisplaySettings && 0 <= m_poDisplaySettings->s32SetBlackLevel(_u8Level))
   {
      sendDIM_DISP_SetBlackLevelMResult(m_poDisplaySettings->u8GetBlackLevel());
      sendDIM_DISP_BlackLevelStatus(m_poDisplaySettings->u8GetBlackLevel());
   }
   else
   {
      sendDIM_DISP_SetBlackLevelMResult(OSAL_C_U8_MAX);
   }
   // onDIM_DISP_SetBlackLevelMStart: user specific code end
}
tVoid dispvidctrl_tclServiceDimmingIf::onDIM_DISP_SetYCurveLevelMStart(tU8 YCurveLevel) {

   // onDIM_DISP_SetYCurveLevelMStart: user specific code start
   tU8 _u8Level = YCurveLevel;
   if (DISPVIDCTRL_C_U8_LEVEL_MAX < _u8Level)
      _u8Level = DISPVIDCTRL_C_U8_LEVEL_MAX;

   if (OSAL_NULL != m_poDisplaySettings && 0 <= m_poDisplaySettings->s32SetGammaLevel(_u8Level))
   {
      sendDIM_DISP_SetYCurveLevelMResult(m_poDisplaySettings->u8GetGammaLevel());
      sendDIM_DISP_YCurveLevelStatus(m_poDisplaySettings->u8GetGammaLevel());
   }
   else
   {
      sendDIM_DISP_SetYCurveLevelMResult(OSAL_C_U8_MAX);
   }
   // onDIM_DISP_SetYCurveLevelMStart: user specific code end
}
tVoid dispvidctrl_tclServiceDimmingIf::onDIM_DISP_SetTintLevelMStart(tU8 TintLevel) {

   // onDIM_DISP_SetTintLevelMStart: user specific code start
   tU8 _u8Level = TintLevel;
   if (DISPVIDCTRL_C_U8_LEVEL_MAX < _u8Level)
      _u8Level = DISPVIDCTRL_C_U8_LEVEL_MAX;

   if (OSAL_NULL != m_poDisplaySettings && 0 <= m_poDisplaySettings->s32SetSaturationLevel(_u8Level))
   {
      sendDIM_DISP_SetTintLevelMResult(m_poDisplaySettings->u8GetSaturationLevel());
      sendDIM_DISP_TintLevelStatus(m_poDisplaySettings->u8GetSaturationLevel());
   }
   else
   {
      sendDIM_DISP_SetTintLevelMResult(OSAL_C_U8_MAX);
   }
   // onDIM_DISP_SetTintLevelMStart: user specific code end
}
tVoid dispvidctrl_tclServiceDimmingIf::onDIM_DISP_SetColorLevelMStart(tU8 ColorLevel) {

   // onDIM_DISP_SetColorLevelMStart: user specific code start
   tU8 _u8Level = ColorLevel;
   if (DISPVIDCTRL_C_U8_LEVEL_MAX < _u8Level)
      _u8Level = DISPVIDCTRL_C_U8_LEVEL_MAX;

   if (OSAL_NULL != m_poDisplaySettings && 0 <= m_poDisplaySettings->s32SetColorLevel(_u8Level))
   {
      sendDIM_DISP_SetColorLevelMResult(m_poDisplaySettings->u8GetColorLevel());
      sendDIM_DISP_ColorLevelStatus(m_poDisplaySettings->u8GetColorLevel());
   }
   else
   {
      sendDIM_DISP_SetColorLevelMResult(OSAL_C_U8_MAX);
   }
   // onDIM_DISP_SetColorLevelMStart: user specific code end
}
tVoid dispvidctrl_tclServiceDimmingIf::onDIM_DIAG_SetBrightnessInputTypeMStart(dimming_fi_tcl_e8_DIM_InputConfiguration SetBrightnessInputType) {

   // onDIM_DIAG_SetBrightnessInputTypeMStart: user specific code start
   (tVoid) SetBrightnessInputType;
   // onDIM_DIAG_SetBrightnessInputTypeMStart: user specific code end
}
tVoid dispvidctrl_tclServiceDimmingIf::onDIM_DISP_SetCSCContrastLevelMStart(tU8 ContrastLevel) {

   // onDIM_DISP_SetCSCContrastLevelMStart: user specific code start
   tU8 _u8Level = ContrastLevel;
   if (DISPVIDCTRL_C_U8_LEVEL_MAX < _u8Level)
      _u8Level = DISPVIDCTRL_C_U8_LEVEL_MAX;

   if (OSAL_NULL != m_poDisplaySettings && 0 <= m_poDisplaySettings->s32SetContrastLevel(_u8Level))
   {
      sendDIM_DISP_SetCSCContrastLevelMResult(m_poDisplaySettings->u8GetContrastLevel());
      sendDIM_DISP_CSCContrastLevelStatus(m_poDisplaySettings->u8GetContrastLevel());
   }
   else
   {
      sendDIM_DISP_SetCSCContrastLevelMResult(OSAL_C_U8_MAX);
   }
   // onDIM_DISP_SetCSCContrastLevelMStart: user specific code end
}
tVoid dispvidctrl_tclServiceDimmingIf::onDIM_DISP_SetCSCBlackLevelMStart(tU8 BlackLevel) {

   // onDIM_DISP_SetCSCBlackLevelMStart: user specific code start
   tU8 _u8Level = BlackLevel;
   if (DISPVIDCTRL_C_U8_LEVEL_MAX < _u8Level)
      _u8Level = DISPVIDCTRL_C_U8_LEVEL_MAX;

   if (OSAL_NULL != m_poDisplaySettings && 0 <= m_poDisplaySettings->s32SetBlackLevel(_u8Level))
   {
      sendDIM_DISP_SetCSCBlackLevelMResult(m_poDisplaySettings->u8GetBlackLevel());
      sendDIM_DISP_CSCBlackLevelStatus(m_poDisplaySettings->u8GetBlackLevel());
   }
   else
   {
      sendDIM_DISP_SetCSCBlackLevelMResult(OSAL_C_U8_MAX);
   }
   // onDIM_DISP_SetCSCBlackLevelMStart: user specific code end
}
tVoid dispvidctrl_tclServiceDimmingIf::onDIM_DISP_SetCSCGammaLevelMStart(tU8 GammaLevel) {

   // onDIM_DISP_SetCSCGammaLevelMStart: user specific code start
   tU8 _u8Level = GammaLevel;
   if (DISPVIDCTRL_C_U8_LEVEL_MAX < _u8Level)
      _u8Level = DISPVIDCTRL_C_U8_LEVEL_MAX;

   if (OSAL_NULL != m_poDisplaySettings && 0 <= m_poDisplaySettings->s32SetGammaLevel(_u8Level))
   {
      sendDIM_DISP_SetCSCGammaLevelMResult(m_poDisplaySettings->u8GetGammaLevel());
      sendDIM_DISP_CSCGammaLevelStatus(m_poDisplaySettings->u8GetGammaLevel());
   }
   else
   {
      sendDIM_DISP_SetCSCGammaLevelMResult(OSAL_C_U8_MAX);
   }
   // onDIM_DISP_SetCSCGammaLevelMStart: user specific code end
}
tVoid dispvidctrl_tclServiceDimmingIf::onDIM_DISP_SetCSCSaturationLevelMStart(tU8 SaturationLevel) {

   // onDIM_DISP_SetCSCSaturationLevelMStart: user specific code start
   tU8 _u8Level = SaturationLevel;
   if (DISPVIDCTRL_C_U8_LEVEL_MAX < _u8Level)
      _u8Level = DISPVIDCTRL_C_U8_LEVEL_MAX;

   if (OSAL_NULL != m_poDisplaySettings && 0 <= m_poDisplaySettings->s32SetSaturationLevel(_u8Level))
   {
      sendDIM_DISP_SetCSCSaturationLevelMResult(m_poDisplaySettings->u8GetSaturationLevel());
      sendDIM_DISP_CSCSaturationLevelStatus(m_poDisplaySettings->u8GetSaturationLevel());
   }
   else
   {
      sendDIM_DISP_SetCSCSaturationLevelMResult(OSAL_C_U8_MAX);
   }
   // onDIM_DISP_SetCSCSaturationLevelMStart: user specific code end
}
tVoid dispvidctrl_tclServiceDimmingIf::onDIM_DISP_SetCSCColorLevelMStart(tU8 ColorLevel) {

   // onDIM_DISP_SetCSCColorLevelMStart: user specific code start
   tU8 _u8Level = ColorLevel;
   if (DISPVIDCTRL_C_U8_LEVEL_MAX < _u8Level)
      _u8Level = DISPVIDCTRL_C_U8_LEVEL_MAX;

   if (OSAL_NULL != m_poDisplaySettings && 0 <= m_poDisplaySettings->s32SetColorLevel(_u8Level))
   {
      sendDIM_DISP_SetCSCColorLevelMResult(m_poDisplaySettings->u8GetColorLevel());
      sendDIM_DISP_CSCColorLevelStatus(m_poDisplaySettings->u8GetColorLevel());
   }
   else
   {
      sendDIM_DISP_SetCSCColorLevelMResult(OSAL_C_U8_MAX);
   }
   // onDIM_DISP_SetCSCColorLevelMStart: user specific code end
}
tVoid dispvidctrl_tclServiceDimmingIf::onDIM_SECOND_DISP_SetDispParameterMStart(dimming_fi_tcl_SecondDispFunctionID e16FunctionId, tU16 u16ParameterValue) {

   // onDIM_SECOND_DISP_SetDispParameterMStart: user specific code start
#ifdef VARIANT_S_FTR_ENABLE_AIVI_NPIVI
    if(_poSecondDispIfRef != NULL)
    {
    	_poSecondDispIfRef->requestV850_setDisplayParam((tU16)e16FunctionId.enType, u16ParameterValue);
    }
#endif
   // onDIM_SECOND_DISP_SetDispParameterMStart: user specific code end
}
tVoid dispvidctrl_tclServiceDimmingIf::onDIM_SECOND_DISP_SetDispOnOffMStart(tU8 u8DisplayState) {

   // onDIM_SECOND_DISP_SetDispOnOffMStart: user specific code start
#ifdef VARIANT_S_FTR_ENABLE_AIVI_NPIVI
    if(_poSecondDispIfRef != NULL)
    {
    	_poSecondDispIfRef->requestV850_setDisplayState(u8DisplayState);
    }
#endif
   // onDIM_SECOND_DISP_SetDispOnOffMStart: user specific code end
}
tVoid dispvidctrl_tclServiceDimmingIf::onDIM_SECOND_DISP_HardwareVersionMStart() {

   // onDIM_SECOND_DISP_HardwareVersionMStart: user specific code start
#ifdef VARIANT_S_FTR_ENABLE_AIVI_NPIVI
    if(_poSecondDispIfRef != NULL)
    {
    	_poSecondDispIfRef->requestV850_HWVersionInfo();
    }
#endif
   // onDIM_SECOND_DISP_HardwareVersionMStart: user specific code end
}
tVoid dispvidctrl_tclServiceDimmingIf::onDIM_SECOND_DISP_SoftwareVersionMStart() {

   // onDIM_SECOND_DISP_SoftwareVersionMStart: user specific code start
#ifdef VARIANT_S_FTR_ENABLE_AIVI_NPIVI
    if(_poSecondDispIfRef != NULL)
    {
    	_poSecondDispIfRef->requestV850_SWVersionInfo();
    }
#endif
   // onDIM_SECOND_DISP_SoftwareVersionMStart: user specific code end
}
tVoid dispvidctrl_tclServiceDimmingIf::onDIM_SECOND_DISP_GetALLParamMStart() {

   // onDIM_SECOND_DISP_GetALLParamMStart: user specific code start
#ifdef VARIANT_S_FTR_ENABLE_AIVI_NPIVI
    if(_poSecondDispIfRef != NULL)
    {
    	_poSecondDispIfRef->requestV850_AllDisplayParam();
    }
#endif
   // onDIM_SECOND_DISP_GetALLParamMStart: user specific code end
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_INFO_CarIlluminationDataStatus(dimming_fi_tcl_e8_DIM_Status IlluminationSwitch, dimming_fi_tcl_u16_DIM_Permille IlluminationBrightness) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_INFO_CarIlluminationDataStatus(IlluminationSwitch, IlluminationBrightness);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_INFO_LightSensorBrightnessStatus(dimming_fi_tcl_e8_DIM_Status SensorAvail, dimming_fi_tcl_u16_DIM_Permille SensorBrightness) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_INFO_LightSensorBrightnessStatus(SensorAvail, SensorBrightness);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_INFO_DimmingModeStatus(dimming_fi_tcl_e8_DIM_Mode Config, dimming_fi_tcl_e8_DIM_Mode Car, dimming_fi_tcl_e8_DIM_Mode Status) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_INFO_DimmingModeStatus(Config, Car, Status);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_INFO_EmulationModeStatus(dimming_fi_tcl_e8_DIM_EmulationMode EmulationMode) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_INFO_EmulationModeStatus(EmulationMode);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_INFO_ITCStatus(tU16 ITC) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_INFO_ITCStatus(ITC);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_INFO_PWMBrightnessStatus(dimming_fi_tcl_u16_DIM_Permille PWMBrightness) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_INFO_PWMBrightnessStatus(PWMBrightness);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_INFO_CANBrightnessStatus(dimming_fi_tcl_u16_DIM_Permille CANBrightness) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_INFO_CANBrightnessStatus(CANBrightness);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_KEYB_BrightnessStatus(dimming_fi_tcl_u16_DIM_Permille Brightness) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_KEYB_BrightnessStatus(Brightness);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_KEYB_HalfclassStatus(dimming_fi_tcl_u8_DIM_Halfclasses Halfclass_A, dimming_fi_tcl_u8_DIM_Halfclasses Halfclass_B, tU8 ADC_CFG_A, tU8 ADC_CFG_B, tU16 ADC_A, tU16 ADC_B, tU16 PWM_HC_A, tU16 PWM_HC_B) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_KEYB_HalfclassStatus(Halfclass_A, Halfclass_B, ADC_CFG_A, ADC_CFG_B, ADC_A, ADC_B, PWM_HC_A, PWM_HC_B);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_DISP_DriverInitalizedStatus(dimming_fi_tcl_e8_DIM_Status DriverInitialized) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_DISP_DriverInitalizedStatus(DriverInitialized);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_DISP_ScreenContentAvailableStatus(dimming_fi_tcl_e8_DIM_Status ContentAvailable) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_DISP_ScreenContentAvailableStatus(ContentAvailable);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_DISP_BrightnessStatus(dimming_fi_tcl_u16_DIM_Permille Brightness) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_DISP_BrightnessStatus(Brightness);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_DISP_BacklightStatus(dimming_fi_tcl_e8_DIM_Status BacklightStatus) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_DISP_BacklightStatus(BacklightStatus);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_DISP_TemperatureInfoStatus(dimming_fi_tcl_s16_DIM_Temperature PanelTemp, dimming_fi_tcl_s16_DIM_Temperature AmbientTemp, dimming_fi_tcl_e8_DIM_WarningLevel WarningLevel, tU16 CriticalLevelTimeout, tU16 CriticalLevelElapsed) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_DISP_TemperatureInfoStatus(PanelTemp, AmbientTemp, WarningLevel, CriticalLevelTimeout, CriticalLevelElapsed);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_DISP_SizeStatus(dimming_fi_tcl_e8_DIM_DisplaySize Size) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_DISP_SizeStatus(Size);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_DISP_BrightnessLevelStatus(dimming_fi_tcl_e8_DIM_BrightnessLevel BrightnessLevel) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_DISP_BrightnessLevelStatus(BrightnessLevel);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_DISP_PanelTemperatureStatus(dimming_fi_tcl_s16_DIM_Temperature Temperature) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_DISP_PanelTemperatureStatus(Temperature);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_DISP_BrightnessLevelExtendedStatus(tU8 BrightnessLevelExtended) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_DISP_BrightnessLevelExtendedStatus(BrightnessLevelExtended);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_DISP_VideoBrightnessLevelStatus(tU8 VideoBrightnessLevel) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_DISP_VideoBrightnessLevelStatus(VideoBrightnessLevel);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_DISP_ContrastLevelStatus(tU8 Contrast) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_DISP_ContrastLevelStatus(Contrast);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_DISP_BlackLevelStatus(tU8 BlackLevel) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_DISP_BlackLevelStatus(BlackLevel);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_DISP_YCurveLevelStatus(tU8 YCurveLevel) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_DISP_YCurveLevelStatus(YCurveLevel);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_DISP_TintLevelStatus(tU8 TintLevel) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_DISP_TintLevelStatus(TintLevel);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_DISP_ColorLevelStatus(tU8 Color) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_DISP_ColorLevelStatus(Color);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_DISP_DAY_LUMINOSITY_OFFSETStatus(tU8 DayLuminosityOffset) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_DISP_DAY_LUMINOSITY_OFFSETStatus(DayLuminosityOffset);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_DISP_NIGHT_LUMINOSITY_OFFSETStatus(tU8 NightLuminosityOffset) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_DISP_NIGHT_LUMINOSITY_OFFSETStatus(NightLuminosityOffset);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_DISP_COCKPIT_SLIDER_OFFSETStatus(tU8 CockpitDimmingSliderOffset) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_DISP_COCKPIT_SLIDER_OFFSETStatus(CockpitDimmingSliderOffset);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_DIAG_VariantStatus(tU8 Variant) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_DIAG_VariantStatus(Variant);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_DIAG_BrightnessInputTypeStatus(dimming_fi_tcl_e8_DIM_InputConfiguration InputConfiguration) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_DIAG_BrightnessInputTypeStatus(InputConfiguration);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_DISP_CSCContrastLevelStatus(tU8 ContrastLevel) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_DISP_CSCContrastLevelStatus(ContrastLevel);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_DISP_CSCBlackLevelStatus(tU8 BlackLevel) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_DISP_CSCBlackLevelStatus(BlackLevel);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_DISP_CSCGammaLevelStatus(tU8 GammaLevel) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_DISP_CSCGammaLevelStatus(GammaLevel);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_DISP_CSCSaturationLevelStatus(tU8 SaturationLevel) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_DISP_CSCSaturationLevelStatus(SaturationLevel);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_DISP_CSCColorLevelStatus(tU8 ColorLevel) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_DISP_CSCColorLevelStatus(ColorLevel);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_SECOND_DISP_AllDisplayParamStatus(tU8 u8BlackLevel, tU8 u8Brightness, tU8 u8Color, tU8 u8Contrast, tU8 u8Tint, tU16 u8GammaLevel) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_SECOND_DISP_AllDisplayParamStatus(u8BlackLevel, u8Brightness, u8Color, u8Contrast, u8Tint, u8GammaLevel);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_SECOND_DISP_SelfDiagnosisResultStatus(tU16 u16SelfDiagResult ) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_SECOND_DISP_SelfDiagnosisResultStatus(u16SelfDiagResult );
}



tVoid dispvidctrl_tclServiceDimmingIf::sendFI_VD_DIMMING_DEFAULTMResult(tU8 DefaultSettingsGroup, tU8 DefaultSettingsStatus) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendFI_VD_DIMMING_DEFAULTMResult(DefaultSettingsGroup, DefaultSettingsStatus);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_INFO_SetDimmingModeMResult(dimming_fi_tcl_e8_DIM_Mode DimmingMode) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_INFO_SetDimmingModeMResult(DimmingMode);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_INFO_SetEmulationModeMResult(dimming_fi_tcl_e8_DIM_EmulationMode EmulationMode) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_INFO_SetEmulationModeMResult(EmulationMode);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_INFO_SetDimmingStateMResult(tU8 LUN, dimming_fi_tcl_e8_DIM_Status DimmingStatus) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_INFO_SetDimmingStateMResult(LUN, DimmingStatus);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_INFO_GetDimmingStateMResult(tU8 LUN, dimming_fi_tcl_e8_DIM_Status DimmingState) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_INFO_GetDimmingStateMResult(LUN, DimmingState);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_INFO_SetDimmingBrightnessMResult(dimming_fi_tcl_u8_DIM_LUN LUN, dimming_fi_tcl_u16_DIM_Permille Brightness) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_INFO_SetDimmingBrightnessMResult(LUN, Brightness);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_INFO_GetDimmingBrightnessMResult(dimming_fi_tcl_u8_DIM_LUN LUN, dimming_fi_tcl_u16_DIM_Permille Brightness) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_INFO_GetDimmingBrightnessMResult(LUN, Brightness);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_INFO_GetPWMBrightnessMResult(dimming_fi_tcl_u16_DIM_Permille Brightness) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_INFO_GetPWMBrightnessMResult(Brightness);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_KEYB_SetDimmingMResult(dimming_fi_tcl_u16_DIM_Permille Brightness) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_KEYB_SetDimmingMResult(Brightness);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_KEYB_SetDimmingPWMMResult(dimming_fi_tcl_u16_DIM_Permille Brightness) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_KEYB_SetDimmingPWMMResult(Brightness);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_DISP_SetDriverInitalizedMResult(dimming_fi_tcl_e8_DIM_Status SetDriverInitialized) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_DISP_SetDriverInitalizedMResult(SetDriverInitialized);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_DISP_SetScreenContentAvailableMResult(dimming_fi_tcl_e8_DIM_Status SetScreenContentAvailable) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_DISP_SetScreenContentAvailableMResult(SetScreenContentAvailable);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_DISP_SetDimmingMResult(dimming_fi_tcl_u16_DIM_Permille Brightness) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_DISP_SetDimmingMResult(Brightness);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_DISP_SwitchBacklightMResult(dimming_fi_tcl_e8_DIM_Status SwitchBacklight) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_DISP_SwitchBacklightMResult(SwitchBacklight);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_DISP_SetBrightnessLevelMResult(dimming_fi_tcl_e8_DIM_BrightnessLevel BrightnessLevel) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_DISP_SetBrightnessLevelMResult(BrightnessLevel);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_DISP_SetBrightnessLevelExtendedMResult(tU8 BrightnessLevelExtended) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_DISP_SetBrightnessLevelExtendedMResult(BrightnessLevelExtended);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_DISP_SetVideoBrightnessLevelMResult(tU8 VideoBrightnessLevelDay, tU8 VideoBrightnessLevelNight) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_DISP_SetVideoBrightnessLevelMResult(VideoBrightnessLevelDay, VideoBrightnessLevelNight);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_DISP_SetContrastLevelMResult(tU8 BrightnessLevelExtended) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_DISP_SetContrastLevelMResult(BrightnessLevelExtended);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_DISP_SetBlackLevelMResult(tU8 BlackLevel) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_DISP_SetBlackLevelMResult(BlackLevel);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_DISP_SetYCurveLevelMResult(tU8 YCurveLevel) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_DISP_SetYCurveLevelMResult(YCurveLevel);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_DISP_SetTintLevelMResult(tU8 TintLevel) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_DISP_SetTintLevelMResult(TintLevel);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_DISP_SetColorLevelMResult(tU8 ColorLevel) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_DISP_SetColorLevelMResult(ColorLevel);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_DIAG_SetBrightnessInputTypeMResult(dimming_fi_tcl_e8_DIM_InputConfiguration SetBrightnessInputType) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_DIAG_SetBrightnessInputTypeMResult(SetBrightnessInputType);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_DISP_SetCSCContrastLevelMResult(tU8 ContrastLevel) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_DISP_SetCSCContrastLevelMResult(ContrastLevel);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_DISP_SetCSCBlackLevelMResult(tU8 BlackLevel) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_DISP_SetCSCBlackLevelMResult(BlackLevel);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_DISP_SetCSCGammaLevelMResult(tU8 GammaLevel) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_DISP_SetCSCGammaLevelMResult(GammaLevel);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_DISP_SetCSCSaturationLevelMResult(tU8 SaturationLevel) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_DISP_SetCSCSaturationLevelMResult(SaturationLevel);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_DISP_SetCSCColorLevelMResult(tU8 ColorLevel) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_DISP_SetCSCColorLevelMResult(ColorLevel);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_SECOND_DISP_SetDispParameterMResult(dimming_fi_tcl_SecondDispFunctionID e16FunctionId, tU16 u16ParameterValue) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_SECOND_DISP_SetDispParameterMResult(e16FunctionId, u16ParameterValue);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_SECOND_DISP_SetDispOnOffMResult(tU8 u8DisplayState) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_SECOND_DISP_SetDispOnOffMResult(u8DisplayState);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_SECOND_DISP_HardwareVersionMResult(dimming_fi_tcl_SecondDisp_VersionInfo HW_VersionInfo) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_SECOND_DISP_HardwareVersionMResult(HW_VersionInfo);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_SECOND_DISP_SoftwareVersionMResult(dimming_fi_tcl_SecondDisp_VersionInfo SW_VersionInfo) {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_SECOND_DISP_SoftwareVersionMResult(SW_VersionInfo);
}

tVoid dispvidctrl_tclServiceDimmingIf::sendDIM_SECOND_DISP_GetALLParamMResult() {
    //just forward send request
    DISPVIDCTRL_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDIM_SECOND_DISP_GetALLParamMResult();
}





// dispvidctrl_tclServiceDimmingIfdispvidctrl_ServiceDimmingIf: user specific code start
/*******************************************************************************
*
* FUNCTION:    dispvidctrl_tclServiceDimmingIf::bSetDimDiagLibIoControl(tBool bActive)
*
* DESCRIPTION: activates / deactivates dimming diagnosis io control depending
*              of own dimming io control activation state
*
* PARAMETER:   tBool bActive ... new activation state of dimming diag io control
*
* RETURNVALUE: tBool   ... confirmed activation state of dimming diag io control
*                          !!! should be equal bActive, otherwise ERROR !!!
*
*******************************************************************************/
tBool dispvidctrl_tclServiceDimmingIf::bSetDimDiagLibIoControl(tBool bActive)
{
    ETG_TRACE_USR2(("dispvidctrl_tclServiceDimmingIf::bSetDimDiagLibIoControl(bActive=%u): entered (DiagLibIoControlActive=%u, CcaSrvIoControlAcive=%u)",
    		bActive, m_bDiagLibIoControlActive, m_bCcaSrvIoControlActive ));

    if (FALSE == bActive)
    {
    	// deactivate Dimming DiagLib
    	m_bDiagLibIoControlActive = FALSE;
    }
    else if (FALSE == m_bCcaSrvIoControlActive)
    {
        m_bDiagLibIoControlActive = TRUE;
    }

    ETG_TRACE_USR2(("dispvidctrl_tclServiceDimmingIf::bSetDimDiagLibIoControl(bActive=%u): exit (DiagLibIoControlActive=%u, CcaSrvIoControlAcive=%u)",
    		bActive, m_bDiagLibIoControlActive, m_bCcaSrvIoControlActive ));

    return m_bDiagLibIoControlActive;
}
// dispvidctrl_tclServiceDimmingIfdispvidctrl_ServiceDimmingIf: user specific code end

//EOF
                                                             
