/*****************************************************************************
 * @file:         procstarter-early.cpp
 * @PROJECT:      CMD project
 * @SW-COMPONENT: dispvidctrl
 * @Template:     (none - see comment further down)
 * ----------------------------------------------------------------------------
 *
 * @brief:  main file
 *
 *          copied and manually adapted from generated file procstarter.cpp
 *          any possibly appearing "user specific code start/end" tags in this file here have no meaning/effect
 *
 * ----------------------------------------------------------------------------
 * @copyright   (c) 2018 Robert Bosch GmbH.
 *              The reproduction, distribution and utilization of this file as
 *              well as the communication of its contents to others without express
 *              authorization is prohibited. Offenders will be held liable for the
 *              payment of damages. All rights reserved in the event of the grant
 *              of a patent, utility model or design.
 *****************************************************************************/

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#define SCD_S_IMPORT_INTERFACE_GENERIC
#include "scd_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#ifdef VARIANT_S_FTR_ENABLE_DATAPOOL
#define DP_S_IMPORT_INTERFACE_BASE
#include "dp_if.h"
#endif

#define SPM_S_IMPORT_INTERFACE_SYSTEMIDS
#include "spm_if.h"

#include "buildversion_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DISPVIDCTRL_APPLICATION
#include "trcGenProj/Header/procstarter-early.cpp.trc.h"
#endif

#include "dispvidctrl_AppMain.h"

extern tVoid vAppProxyStarterEarly(dispvidctrl_tclAppMain* _poCcaServer);
extern tVoid vAppProxyStarter(dispvidctrl_tclAppMain* _poCcaServer);

OSAL_tEventHandle  hEvShutdown = 0;
OSAL_tEventMask    hEvRequest  = 0x00000001;

tS32 s32RunEnv(void)
{
    tS32 s32RetVal = OSAL_OK;

    tU32 u32StartTime = OSAL_ClockGetElapsedTime();
     // open Trace ------------------------------
    ET_TRACE_OPEN;

    dispvidctrl_tclAppMain* _poCcaServer = dispvidctrl_tclAppMain::theServer();
    if (_poCcaServer != NULL){
        dispvidctrl_tclAppMain::vWriteStartupLog("[RVC-EARLY]: Main called.", u32StartTime);
        dispvidctrl_tclAppMain::vWriteStartupLog("[RVC-EARLY]: MainApp created: ", OSAL_ClockGetElapsedTime() - u32StartTime);
        vAppProxyStarterEarly(_poCcaServer);
        dispvidctrl_tclAppMain::vWriteStartupLog("[RVC-EARLY]: Subcomponents created: ", OSAL_ClockGetElapsedTime() - u32StartTime);
        _poCcaServer->vGetReferencesEarly();
        _poCcaServer->vStartCommunicationEarly();
        dispvidctrl_tclAppMain::vWriteStartupLog("[RVC-EARLY]: References / StartCommunication called: ", OSAL_ClockGetElapsedTime() - u32StartTime);

        _poCcaServer->vWaitForVideoChainReady(2000);
        dispvidctrl_tclAppMain::vWriteStartupLog("[RVC-EARLY]: proceed starting application.");
    }

    // Initialise AMT framework (tracing, static variables, ...)
    // Must be called before using AMT framework.

    amt_bInit();
    scd_init();

    tBool bRetVal = exh_bInitExceptionHandling();
    if(bRetVal != TRUE) {
    }

#   ifdef BUILDVERSION_DISPLAY_STARTUP_TRACE_ENABLED
    BuildVersion_vDisplayStartupMessage("PROCDISPVIDCTRL");
#   endif

    // create the shutdown event
    if (OSAL_s32EventCreate("PROCDISPVIDCTRL", &hEvShutdown) != OSAL_ERROR) {

#   ifdef VARIANT_S_FTR_ENABLE_DATAPOOL
        DP_vCreateDatapool();
#   endif

        if (_poCcaServer != NULL){

            vAppProxyStarter(_poCcaServer);

            _poCcaServer->vLoadRegistry();
            {
                // !!!!! create SPM msgbox --> process is started before procbase !!!!!!
                OSAL_tMQueueHandle _hSpmInQueue;
                if (OSAL_ERROR == OSAL_s32MessageQueueCreate("mbx_0", SPM_U32_CCA_MBX0_MSG_COUNT, SCD_MAILBOX_MAX_MESSAGE_LENGTH, OSAL_EN_READWRITE, &_hSpmInQueue)){
                        //try to open existing one
                }
            }

            // and new create application instances
            if ( _poCcaServer->bInitInstance(0, CCA_C_U16_APP_DRVASS_VIDEO) == FALSE )
            {
                ETG_TRACE_FATAL(("!!! vStartCCAApplications(): dispvidctrl_tclAppMain bInitInstance FAILED" ));
            }
            _poCcaServer->vStart();
        }

        // Wait for Shutdown-Signal
        ETG_TRACE_FATAL(("Wait for Shutdown-event 'PROCDISPVIDCTRL'!"));
        OSAL_s32EventWait(hEvShutdown, hEvRequest, OSAL_EN_EVENTMASK_OR, OSAL_C_TIMEOUT_FOREVER, &hEvRequest);
        ETG_TRACE_FATAL(("Shutdown-event received -> stop applications!"));

        // Shutdown everything else
        OSAL_s32EventClose(hEvShutdown);
        OSAL_s32EventDelete("PROCDISPVIDCTRL");
    } else {
        ETG_TRACE_FATAL(("Failed to create event 'PROCDISPVIDCTRL'"));
    }

    // end trace
    ET_TRACE_CLOSE;

    return s32RetVal;
}
