/**
  * @swcomponent   Life Cycle Management
  * @{
  * @file          dispvidctrl_ServiceRvcCallbackIF.h
  * @PROJECT:      CMD project
  * @SW-COMPONENT: dispvidctrl
  * @Template:     serviceCallbackIf.h.tpl
  * ----------------------------------------------------------------------------
  *
  * @brief         generated file
  *                service callback interface
  *
  *                Do here client specific implementation
  *                Changes possible only inside tags
  *
  *                //......................: user specific code start 
  *                //......................: user specific code end
  *
  * ----------------------------------------------------------------------------
  * @copyright     (c) 2020 Robert Bosch GmbH.
  *                The reproduction, distribution and utilization of this file as well as the
  *                communication of its contents to others without express authorization is prohibited.
  *                Offenders will be held liable for the payment of damages.
  *                All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#ifndef __rvc_cca_fi_CALLBACKIF_H_
#define __rvc_cca_fi_CALLBACKIF_H_

class dispvidctrl_tclServiceRvcCallbackIF
{
   public:
       virtual ~dispvidctrl_tclServiceRvcCallbackIF() {};

       virtual tVoid onServiceAvailable() = 0;
       virtual tVoid onServiceUnavailable() = 0;


       virtual tVoid onCameraButtonMStart(rvc_fi_tcl_e8_RVC_ButtonState e8ButtonState) = 0;
       virtual tVoid onSetStatusHmiMStart(rvc_fi_tcl_e8_RVC_Status e8StatusHmi) = 0;
       virtual tVoid onSetupLanguageMStart(rvc_fi_tcl_e8_RVC_Language e8Language) = 0;
       virtual tVoid onSetupGuideLineMStart(rvc_fi_tcl_e8_RVC_StatusGuideLine e8GuideLine) = 0;
       virtual tVoid onSetupVideoControlsMStart(rvc_fi_tcl_e8_RVC_VideoParameterDimmingMode e8HMIDimmingMode, rvc_fi_tcl_e8_MVCViewingState e8MVCViewingState, std::vector<rvc_fi_tcl_RVC_VideoAnalogLevels, std::allocator<rvc_fi_tcl_RVC_VideoAnalogLevels> > arVideoControlParameter) = 0;
       virtual tVoid onSetSystemStatusMStart(rvc_fi_tcl_e8_RVC_SystemStatus e8SystemStatus, rvc_fi_tcl_e8_RVC_StatusGuideLine e8GuideLine, rvc_fi_tcl_e8_RVC_StatusWarningText e8WarningText) = 0;
       virtual tVoid onrunExtDevicePowerSupplyTestMStart(tU16 pwrSupplyID) = 0;
       virtual tVoid onInitializeMStart(rvc_fi_tcl_e8_RVC_Module e8Module) = 0;
       virtual tVoid onConfirmSystemStatusMStart(rvc_fi_tcl_e8_RVC_SystemStatus e8SystemStatus) = 0;
       virtual tVoid onSetupUserConfigurationMStart(std::vector<rvc_fi_tcl_ParkAssist_UserConfiguration, std::allocator<rvc_fi_tcl_ParkAssist_UserConfiguration> > arUserConfiguration) = 0;
       virtual tVoid onSetMicrophoneStateMStart(rvc_fi_tcl_e8_Set_MicState e8RequestState) = 0;
       virtual tVoid onSetRVCStatusMStart(tU8 e8RequestState) = 0;
       virtual tVoid onCamera_SetupBeepMStart(rvc_fi_tcl_e8_AVM_StatusBeep e8SetupBeep) = 0;
       virtual tVoid onSetCamerastateMStart(rvc_fi_tcl_e8_RVC_CameraState CameraState) = 0;
       virtual tVoid onChangeViewRequestMStart(rvc_fi_tcl_e8_AVM_View_Request u8Status) = 0;
       virtual tVoid onAffordable_Its_SetupBswMStart(tU8 u8Status) = 0;
       virtual tVoid onAffordable_Its_SetupModMStart(tU8 u8Status) = 0;
       virtual tVoid onAffordable_Its_SetupLdwMStart(tU8 u8Status) = 0;
       virtual tVoid onIPA_SetHMIStatusMStart(rvc_fi_tcl_e8_IPA_HMIStatus e8IPAStatus) = 0;
       virtual tVoid onIPA_SetButtonMStart(rvc_fi_tcl_e8_IPA_BUTTON_ID e8ButtonIdentifier, rvc_fi_tcl_e8_RVC_ButtonState e8ButtonStatus) = 0;
       virtual tVoid onIPA_Voice_TextsMStart(rvc_fi_tcl_e8_RVC_Language Language, std::vector<rvc_fi_tcl_IPA_Voice_Text_Strings, std::allocator<rvc_fi_tcl_IPA_Voice_Text_Strings> > arTexts) = 0;
       virtual tVoid onMVC_HMI_ViewRequestMStart(rvc_fi_tcl_e8_MVCViewingState e8Request) = 0;
       virtual tVoid onGdlAdj_AdjustmentCompleteMStart(rvc_fi_tcl_e8_GdlAdj_Completion e8Completion) = 0;
       virtual tVoid onGdlAdj_AdjustButtonMStart(rvc_fi_tcl_e8_GdlAdj_AdjustButton e8Button) = 0;
       virtual tVoid onGdlAdj_ConfigurationDataMStart(rvc_fi_tcl_e8_GdlAdj_Request e8Request, std::vector<rvc_fi_tcl_GdlAdj_ConfigParameterData, std::allocator<rvc_fi_tcl_GdlAdj_ConfigParameterData> > arConfigParameterData) = 0;
       virtual tVoid onFAP_SetButtonMStart(rvc_fi_tcl_e8_IPA_BUTTON_ID e8ButtonIdentifier, rvc_fi_tcl_e8_RVC_ButtonState e8ButtonStatus) = 0;
       virtual tVoid onTouchEventMStart(rvc_fi_tcl_Touch_Data arTouchData) = 0;
       virtual tVoid onGPSInfoMStart(rvc_fi_tcl_GPS_Data arGpsData) = 0;
       virtual tVoid onMapMatchedInfoMStart(rvc_fi_tcl_MapMatched_Data arMapMatchedData) = 0;
       virtual tVoid onFapLearnParkPositionMStart(tBool RequestOn) = 0;
       virtual tVoid onSetFapGuidanceMStart(tBool Request) = 0;
       virtual tVoid onAVM3_SetSwitchMStart(rvc_fi_tcl_e8_AVMph3_SwitchId e8SwitchId) = 0;
       virtual tVoid onAVM3_SetSonarBuzzerStatusMStart(rvc_fi_tcl_e8_AVMph3_BuzzerStatus e8BuzzerStatus) = 0;
       virtual tVoid onAVM3_Settings_Detailed_SendReqMStart(rvc_fi_tcl_e8_AVMph3_RequestType e8RequestType, std::vector<rvc_fi_tcl_AVMph3_Setting_Item, std::allocator<rvc_fi_tcl_AVMph3_Setting_Item> > arChangedItems) = 0;
       virtual tVoid onAVM3_Settings_Primary_SendReqMStart(rvc_fi_tcl_e8_AVMph3_RequestType e8RequestType, rvc_fi_tcl_e8_AVMph3_SettingOptionState e8AvmSonarBuzzer, tBool bDetailsSettingsAvail, tBool bImageQualitySettingAvail) = 0;
       virtual tVoid onAVM3_GetVersionInfoMStart(rvc_fi_tcl_e8_AVMph3_VersionInfoType e8VersionType) = 0;
       virtual tVoid onAVM3_GetCommunicationErrorsMStart() = 0;
       virtual tVoid onAVM3_ClearCommunicationErrorsMStart() = 0;
       virtual tVoid onToggleGpioPinOnOffMStart() = 0;
};

#endif //__rvc_cca_fi_CALLBACKIF_H_


