/*****************************************************************************
* FILE:         dispvidctrl_ServiceRvc.h
* PROJECT:      G3G project
* SW-COMPONENT: dispvidctrl
* Template:     ServiceHandler.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2020 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#ifndef __dispvidctrl_ServiceRvc_H_
#define __dispvidctrl_ServiceRvc_H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

//include base class
#include "I_dispvidctrl_ServiceRvc.h"
#include "dispvidctrl_AppMain.h"

// dispvidctrl_tclServiceRvc_Include: user specific code start
// dispvidctrl_tclServiceRvc_Include: user specific code end

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class dispvidctrl_tclServiceRvcCallbackIF;

class dispvidctrl_tclServiceRvc : public Idispvidctrl_tclServiceRvc
{
protected:
   class tclMethodResultManager {
   public:

      // Constructors and destructors
      tclMethodResultManager(){
         _bPending = 0;
         _u16SourceAppID = 0;
         _u16RegisterID = 0;
         _u16CmdCounter = 0;
         _u16FctID = 0;      
      };
      ~tclMethodResultManager(){};

      tVoid vInit(tVoid){
         _bPending = 0;
         _u16SourceAppID = 0;
         _u16RegisterID = 0;
         _u16CmdCounter = 0;
         _u16FctID = 0;      
      };

      tVoid vMemorize(tBool bPending, tU16 u16SourceAppID, tU16 u16RegisterID, tU16 u16CmdCounter,  tU16 u16FctID) {
         _bPending = bPending;
         _u16SourceAppID = u16SourceAppID;
         _u16RegisterID = u16RegisterID;
         _u16CmdCounter = u16CmdCounter;
         _u16FctID = u16FctID;

      }

      tBool bIsPending(tVoid) const {return _bPending;};    
      tVoid vSetPending(tVoid) {_bPending = TRUE;};
      tVoid vSetPendingValue(tBool _bPendingValue){_bPending = _bPendingValue;};
      tVoid vClearPending(tVoid){_bPending = FALSE;};
      tBool bGetPending(tVoid) const {return _bPending;};    

      tU16 u16GetSourceAppID(tVoid) const {return _u16SourceAppID;};    
      tU16 u16GetRegisterID(tVoid) const {return _u16RegisterID;};    
      tU16 u16GetCMDCounter(tVoid) const {return _u16CmdCounter;};    
      tU16 u16GetFctID(tVoid) const {return _u16FctID;};    

   private:                    
      tBool _bPending;
      tU16 _u16SourceAppID;
      tU16 _u16RegisterID;
      tU16 _u16CmdCounter;    
      tU16 _u16FctID; 
   };

public:

   dispvidctrl_tclServiceRvc(tVoid); 
   dispvidctrl_tclServiceRvc(dispvidctrl_tclAppMain* poMainAppl);
   virtual ~dispvidctrl_tclServiceRvc();

   virtual tVoid vSetCallbackIf(dispvidctrl_tclServiceRvcCallbackIF* poCallback) {
      _poCallbackIf = poCallback;
   }

   // dispvidctrl_tclServiceRvcDeclarations: user specific code start
   // dispvidctrl_tclServiceRvcDeclarations: user specific code end

   /**************************************************************************
   * Assingment Operater, will not be implemented.
   * Avoids Lint Prio 3 warning: Info 1732: new in constructor for class 
   * 'dispvidctrl_tclServiceRvc' which has no assignment operator.
   * NOTE: This is a technique to disable the assignment operator for this
   * class. So if an attempt for the assignment is made compiler complains.
   **************************************************************************/
   dispvidctrl_tclServiceRvc& operator = (const dispvidctrl_tclServiceRvc &oClientHandler);

   /***************************************************************************
   * Overriding ahl_tclBaseOneThreadClientHandler methods.
   ***************************************************************************/
   virtual tVoid vOnServiceAvailable();
   virtual tVoid vOnServiceUnavailable();
   
   virtual tBool bStatusMessageFactory(tU16 u16FunctionId,
                                        amt_tclServiceData& roOutMsg,
                                        amt_tclServiceData* poInMsg);
   virtual tBool bProcessSet(amt_tclServiceData* poMessage,
                              tBool& bPropertyChanged,
                              tU16& u16Error);
public:
   virtual const tChar* getName() const { return "dispvidctrl_tclServiceRvc"; };
   
   virtual tVoid vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();
   
private:
   dispvidctrl_tclServiceRvcCallbackIF* _poCallbackIf;

public:



    /***************************************************************************
    * Application specific methods.
    ***************************************************************************/
   virtual tVoid sendSystemConfigurationsStatus(rvc_fi_tcl_e8_RVC_Camera_System_Type e8CameraSystem, tU8 u8RVCGuideLine, tU8 u8Brightness);
   virtual tVoid sendSystemStatusStatus(rvc_fi_tcl_e8_RVC_SystemStatus e8SystemStatus);
   virtual tVoid sendVideoSignalStatusStatus(rvc_fi_tcl_e8_RVC_SignalStatus e8StatusVideoSignal);
   virtual tVoid sendReverseSignalStatusStatus(rvc_fi_tcl_e8_RVC_ReverseSignalStatus e8StatusReverseSignal);
   virtual tVoid sendCamera_PwrSupplyStatusStatus(tU16 pwrSupplyID, rvc_fi_tcl_e8_Camera_PowerSupplyStatus status, tU32 current);
   virtual tVoid sendMicrophone_PwrSupplyStatusStatus(tU16 pwrSupplyID, rvc_fi_tcl_e8_Microphone_PowerSupplyStatus status, tU32 current);
   virtual tVoid sendTailgate_StatusStatus(rvc_fi_tcl_e8_Tailgate_State State);
   virtual tVoid sendView_Close_AuthorizedStatus(rvc_fi_tcl_e8_Exit_Authorized e8Allowed);
   virtual tVoid sendAvmR_Current_ViewStatus(rvc_fi_tcl_e8_AVM_View_Status e8View);
   virtual tVoid sendAffordable_ITSStatus(rvc_fi_tcl_e8_AffordableIts_Status e8AffordableItsAvailable, rvc_fi_tcl_e8_AffordableIts_StatusFeature e8BswStatus, rvc_fi_tcl_e8_AffordableIts_StatusFeature e8ModStatus, rvc_fi_tcl_e8_AffordableIts_StatusFeature e8LdwStatus);
   virtual tVoid sendIPAConfigurationStatus(rvc_fi_tcl_e8_IPA_AvailabilityStatus e8AvailabilityStatus, rvc_fi_tcl_e8_IPA_RegionalSelection e8RegionalSelection);
   virtual tVoid sendIPAStatusStatus(rvc_fi_tcl_e8_IPA_OperationStatus e8OperationStatus, rvc_fi_tcl_e8_IPA_ModeChangeRequest e8Request);
   virtual tVoid sendIPAPatternRequestStatus(rvc_fi_tcl_e8_IPA_PatternID e8DisplayPattern);
   virtual tVoid sendIPAMessageRequestStatus(rvc_fi_tcl_e8_IPA_MessageID e8MessageID);
   virtual tVoid sendIPASwitchMaskRequestStatus(rvc_fi_tcl_e8_IPA_SwitchMask e8SwitchMask);
   virtual tVoid sendIPASwitchGreyOutRequestStatus(tU8 u8SwitchGreyOut);
   virtual tVoid sendIPADirectionIndicatorStatus(rvc_fi_tcl_e8_IPA_DirectionIndicator e8Direction);
   virtual tVoid sendGdlAdj_SteeringAngleStatus(tBool bShowValues, tU8 u8CentreAdjustmentState, tS32 s32SteeringAngleCentreAdjusted, rvc_fi_tclString SteeringAngleSignalState);
   virtual tVoid sendGdlAdj_CameraAngleStatus(tF32 f32CameraRollAngle, tF32 f32CameraYawAngle, tF32 f32CameraPitchAngle);
   virtual tVoid sendCANFrameStatusStatus(rvc_fi_tcl_e8_RVC_SignalStatus e8StatusCANFrame);
   virtual tVoid sendMvcViewStatusStatus(rvc_fi_tcl_e8_MVCViewingState e8View);
   virtual tVoid sendMvcAlertRequestStatus(tBool bRequest);
   virtual tVoid sendFAPModeStatus(tBool e8State);
   virtual tVoid sendFAPSettingsStatus(std::vector<rvc_fi_tcl_FAP_Settings_State, std::allocator<rvc_fi_tcl_FAP_Settings_State> > arFapSettingState, std::vector<rvc_fi_tcl_AVM_Settings_State, std::allocator<rvc_fi_tcl_AVM_Settings_State> > arAvmSettingState);
   virtual tVoid sendFAPGuidanceStateStatus(tBool e8State);
   virtual tVoid sendAVM3_DispStatusStatus(rvc_fi_tcl_e8_AVMph3_DispStatus e8DispStatus);
   virtual tVoid sendAVM3_ViewSetupStatus(rvc_fi_tcl_e8_AVMph3_ViewPattern e8ViewPattern, rvc_fi_tcl_e8_AVMph3_CautionId e8CautionId, rvc_fi_tcl_AVMph3_SwitchDescriptor Switch1, rvc_fi_tcl_AVMph3_SwitchDescriptor Switch2, rvc_fi_tcl_AVMph3_SwitchDescriptor Switch3, rvc_fi_tcl_AVMph3_SwitchDescriptor Switch4, rvc_fi_tcl_AVMph3_SwitchDescriptor Switch5, rvc_fi_tcl_AVMph3_SwitchDescriptor Switch6, rvc_fi_tcl_AVMph3_SwitchDescriptor Switch7, rvc_fi_tcl_AVMph3_SwitchDescriptor Switch8, rvc_fi_tcl_e8_AVMph3_IconId e8IconId, rvc_fi_tcl_e8_AVMph3_BuzzerStatus e8BuzzerStatus);
   virtual tVoid sendAVM3_ErrorMessageStatus(rvc_fi_tcl_e8_AVMph3_ErrorMessage e8ErrorMessage);
   virtual tVoid sendAVM3_SonarBuzzerStatusStatus(rvc_fi_tcl_e8_AVMph3_BuzzerStatus e8BuzzerStatus);
   virtual tVoid sendAVM3_Settings_DetailedStatus(rvc_fi_tcl_e8_AVMph3_Setting_PrioView e8PriorityView, rvc_fi_tcl_e8_AVMph3_Setting_PrioWide e8PriorityWide, rvc_fi_tcl_e8_AVMph3_Setting_AutoCamPos e8AutoCamPos, rvc_fi_tcl_AVMph3_Setting_CornerSonarSensLvl rCornerSonarSensLvl, rvc_fi_tcl_AVMph3_Setting_SonarSensLvl rSonarSensLvl, rvc_fi_tcl_AVMph3_Setting_BuzzerSoundLvl rBuzzerSoundLvl, std::vector<rvc_fi_tcl_AVMph3_Setting_Option, std::allocator<rvc_fi_tcl_AVMph3_Setting_Option> > arSettingsOption);
   virtual tVoid sendAVM3_Settings_PrimaryStatus(rvc_fi_tcl_e8_AVMph3_SettingOptionState e8AvmSonarBuzzer, tBool bDetailsSettingsAvail, tBool bImageQualitySettingAvail);
   virtual tVoid sendAVM3_ConfigurationStatus(rvc_fi_tcl_e8_AVMph3_ConfigurationStatus e8ConfigStatus, rvc_fi_tcl_AVMph3_Unit_ID rUnit_ID, rvc_fi_tcl_AVMph3_VersionInfo rMsgSetVersion);
   virtual tVoid sendAVM3_Software_VersionStatus(rvc_fi_tcl_AVMph3_VersionInfo rSW_Version_AVM, rvc_fi_tcl_AVMph3_VersionInfo rSW_Version_Sonar);
   virtual tVoid sendAVM3_Hardware_VersionStatus(rvc_fi_tcl_AVMph3_VersionInfo rHW_Version_AVM, rvc_fi_tcl_AVMph3_VersionInfo rHW_Version_Sonar);
   virtual tVoid sendAVM3_CommunicationErrorsStatus(rvc_fi_tcl_AVMph3_MCAN_CommunicationErrors rCommErrors);


   virtual tVoid onCameraButtonMStart(rvc_fi_tcl_e8_RVC_ButtonState e8ButtonState);
   virtual tVoid vHandleCameraButtonOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onSetStatusHmiMStart(rvc_fi_tcl_e8_RVC_Status e8StatusHmi);
   virtual tVoid vHandleSetStatusHmiOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onSetupLanguageMStart(rvc_fi_tcl_e8_RVC_Language e8Language);
   virtual tVoid vHandleSetupLanguageOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onSetupGuideLineMStart(rvc_fi_tcl_e8_RVC_StatusGuideLine e8GuideLine);
   virtual tVoid vHandleSetupGuideLineOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onSetupVideoControlsMStart(rvc_fi_tcl_e8_RVC_VideoParameterDimmingMode e8HMIDimmingMode, rvc_fi_tcl_e8_MVCViewingState e8MVCViewingState, std::vector<rvc_fi_tcl_RVC_VideoAnalogLevels, std::allocator<rvc_fi_tcl_RVC_VideoAnalogLevels> > arVideoControlParameter);
   virtual tVoid vHandleSetupVideoControlsOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onSetSystemStatusMStart(rvc_fi_tcl_e8_RVC_SystemStatus e8SystemStatus, rvc_fi_tcl_e8_RVC_StatusGuideLine e8GuideLine, rvc_fi_tcl_e8_RVC_StatusWarningText e8WarningText);
   virtual tVoid vHandleSetSystemStatusOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onrunExtDevicePowerSupplyTestMStart(tU16 pwrSupplyID);
   virtual tVoid vHandlerunExtDevicePowerSupplyTestOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onInitializeMStart(rvc_fi_tcl_e8_RVC_Module e8Module);
   virtual tVoid vHandleInitializeOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onConfirmSystemStatusMStart(rvc_fi_tcl_e8_RVC_SystemStatus e8SystemStatus);
   virtual tVoid vHandleConfirmSystemStatusOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onSetupUserConfigurationMStart(std::vector<rvc_fi_tcl_ParkAssist_UserConfiguration, std::allocator<rvc_fi_tcl_ParkAssist_UserConfiguration> > arUserConfiguration);
   virtual tVoid vHandleSetupUserConfigurationOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onSetMicrophoneStateMStart(rvc_fi_tcl_e8_Set_MicState e8RequestState);
   virtual tVoid vHandleSetMicrophoneStateOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onSetRVCStatusMStart(tU8 e8RequestState);
   virtual tVoid vHandleSetRVCStatusOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onCamera_SetupBeepMStart(rvc_fi_tcl_e8_AVM_StatusBeep e8SetupBeep);
   virtual tVoid vHandleCamera_SetupBeepOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onSetCamerastateMStart(rvc_fi_tcl_e8_RVC_CameraState CameraState);
   virtual tVoid vHandleSetCamerastateOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onChangeViewRequestMStart(rvc_fi_tcl_e8_AVM_View_Request u8Status);
   virtual tVoid vHandleChangeViewRequestOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onAffordable_Its_SetupBswMStart(tU8 u8Status);
   virtual tVoid vHandleAffordable_Its_SetupBswOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onAffordable_Its_SetupModMStart(tU8 u8Status);
   virtual tVoid vHandleAffordable_Its_SetupModOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onAffordable_Its_SetupLdwMStart(tU8 u8Status);
   virtual tVoid vHandleAffordable_Its_SetupLdwOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onIPA_SetHMIStatusMStart(rvc_fi_tcl_e8_IPA_HMIStatus e8IPAStatus);
   virtual tVoid vHandleIPA_SetHMIStatusOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onIPA_SetButtonMStart(rvc_fi_tcl_e8_IPA_BUTTON_ID e8ButtonIdentifier, rvc_fi_tcl_e8_RVC_ButtonState e8ButtonStatus);
   virtual tVoid vHandleIPA_SetButtonOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onIPA_Voice_TextsMStart(rvc_fi_tcl_e8_RVC_Language Language, std::vector<rvc_fi_tcl_IPA_Voice_Text_Strings, std::allocator<rvc_fi_tcl_IPA_Voice_Text_Strings> > arTexts);
   virtual tVoid vHandleIPA_Voice_TextsOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onMVC_HMI_ViewRequestMStart(rvc_fi_tcl_e8_MVCViewingState e8Request);
   virtual tVoid vHandleMVC_HMI_ViewRequestOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onGdlAdj_AdjustmentCompleteMStart(rvc_fi_tcl_e8_GdlAdj_Completion e8Completion);
   virtual tVoid vHandleGdlAdj_AdjustmentCompleteOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onGdlAdj_AdjustButtonMStart(rvc_fi_tcl_e8_GdlAdj_AdjustButton e8Button);
   virtual tVoid vHandleGdlAdj_AdjustButtonOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onGdlAdj_ConfigurationDataMStart(rvc_fi_tcl_e8_GdlAdj_Request e8Request, std::vector<rvc_fi_tcl_GdlAdj_ConfigParameterData, std::allocator<rvc_fi_tcl_GdlAdj_ConfigParameterData> > arConfigParameterData);
   virtual tVoid vHandleGdlAdj_ConfigurationDataOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onFAP_SetButtonMStart(rvc_fi_tcl_e8_IPA_BUTTON_ID e8ButtonIdentifier, rvc_fi_tcl_e8_RVC_ButtonState e8ButtonStatus);
   virtual tVoid vHandleFAP_SetButtonOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onTouchEventMStart(rvc_fi_tcl_Touch_Data arTouchData);
   virtual tVoid vHandleTouchEventOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onGPSInfoMStart(rvc_fi_tcl_GPS_Data arGpsData);
   virtual tVoid vHandleGPSInfoOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onMapMatchedInfoMStart(rvc_fi_tcl_MapMatched_Data arMapMatchedData);
   virtual tVoid vHandleMapMatchedInfoOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onFapLearnParkPositionMStart(tBool RequestOn);
   virtual tVoid vHandleFapLearnParkPositionOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onSetFapGuidanceMStart(tBool Request);
   virtual tVoid vHandleSetFapGuidanceOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onAVM3_SetSwitchMStart(rvc_fi_tcl_e8_AVMph3_SwitchId e8SwitchId);
   virtual tVoid vHandleAVM3_SetSwitchOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onAVM3_SetSonarBuzzerStatusMStart(rvc_fi_tcl_e8_AVMph3_BuzzerStatus e8BuzzerStatus);
   virtual tVoid vHandleAVM3_SetSonarBuzzerStatusOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onAVM3_Settings_Detailed_SendReqMStart(rvc_fi_tcl_e8_AVMph3_RequestType e8RequestType, std::vector<rvc_fi_tcl_AVMph3_Setting_Item, std::allocator<rvc_fi_tcl_AVMph3_Setting_Item> > arChangedItems);
   virtual tVoid vHandleAVM3_Settings_Detailed_SendReqOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onAVM3_Settings_Primary_SendReqMStart(rvc_fi_tcl_e8_AVMph3_RequestType e8RequestType, rvc_fi_tcl_e8_AVMph3_SettingOptionState e8AvmSonarBuzzer, tBool bDetailsSettingsAvail, tBool bImageQualitySettingAvail);
   virtual tVoid vHandleAVM3_Settings_Primary_SendReqOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onAVM3_GetVersionInfoMStart(rvc_fi_tcl_e8_AVMph3_VersionInfoType e8VersionType);
   virtual tVoid vHandleAVM3_GetVersionInfoOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onAVM3_GetCommunicationErrorsMStart();
   virtual tVoid vHandleAVM3_GetCommunicationErrorsOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onAVM3_ClearCommunicationErrorsMStart();
   virtual tVoid vHandleAVM3_ClearCommunicationErrorsOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onToggleGpioPinOnOffMStart();
   virtual tVoid vHandleToggleGpioPinOnOffOpMStart(amt_tclServiceData* poMessage);

   virtual tVoid sendCameraButtonMResult(tBool Result);
   virtual tVoid sendSetStatusHmiMResult(rvc_fi_tcl_e8_RVC_SystemStatus e8SystemStatus);
   virtual tVoid sendSetupLanguageMResult(tBool Result);
   virtual tVoid sendSetupGuideLineMResult(tBool Result);
   virtual tVoid sendSetupVideoControlsMResult(tBool Result);
   virtual tVoid sendSetSystemStatusMResult(tBool Result);
   virtual tVoid sendrunExtDevicePowerSupplyTestMResult(tU16 pwrSupplyID, rvc_fi_tcl_e8_Camera_PowerSupplyStatus status, tU32 current);
   virtual tVoid sendInitializeMResult(tBool Result);
   virtual tVoid sendConfirmSystemStatusMResult(tBool Result);
   virtual tVoid sendSetupUserConfigurationMResult(tBool Result);
   virtual tVoid sendSetMicrophoneStateMResult(tBool Result);
   virtual tVoid sendSetRVCStatusMResult(tBool Result);
   virtual tVoid sendCamera_SetupBeepMResult(rvc_fi_tcl_e8_AVM_StatusBeep e8StatusBeep);
   virtual tVoid sendSetCamerastateMResult(tBool Result);
   virtual tVoid sendChangeViewRequestMResult(tBool Result);
   virtual tVoid sendAffordable_Its_SetupBswMResult(tBool Result);
   virtual tVoid sendAffordable_Its_SetupModMResult(tBool Result);
   virtual tVoid sendAffordable_Its_SetupLdwMResult(tBool Result);
   virtual tVoid sendIPA_SetHMIStatusMResult(tBool Result);
   virtual tVoid sendIPA_SetButtonMResult(tBool Result);
   virtual tVoid sendIPA_Voice_TextsMResult(tBool Result);
   virtual tVoid sendMVC_HMI_ViewRequestMResult(tBool Result);
   virtual tVoid sendGdlAdj_AdjustmentCompleteMResult(tBool Result);
   virtual tVoid sendGdlAdj_AdjustButtonMResult(tBool Result);
   virtual tVoid sendGdlAdj_ConfigurationDataMResult(tBool Result, rvc_fi_tcl_e8_GdlAdj_Request e8Request, std::vector<rvc_fi_tcl_GdlAdj_ConfigParameterData, std::allocator<rvc_fi_tcl_GdlAdj_ConfigParameterData> > arConfigParameterData);
   virtual tVoid sendFAP_SetButtonMResult(tBool Result);
   virtual tVoid sendTouchEventMResult(tBool Result);
   virtual tVoid sendGPSInfoMResult(tBool Result);
   virtual tVoid sendMapMatchedInfoMResult(tBool Result);
   virtual tVoid sendFapLearnParkPositionMResult(tBool Result);
   virtual tVoid sendSetFapGuidanceMResult(tBool Result);
   virtual tVoid sendAVM3_SetSwitchMResult(tBool bResult);
   virtual tVoid sendAVM3_SetSonarBuzzerStatusMResult(tBool bResult);
   virtual tVoid sendAVM3_Settings_Detailed_SendReqMResult(tBool bResult);
   virtual tVoid sendAVM3_Settings_Primary_SendReqMResult(tBool bResult);
   virtual tVoid sendAVM3_GetVersionInfoMResult(tBool bResult);
   virtual tVoid sendAVM3_GetCommunicationErrorsMResult(tBool bResult);
   virtual tVoid sendAVM3_ClearCommunicationErrorsMResult(tBool bResult);
   virtual tVoid sendToggleGpioPinOnOffMResult();

   virtual void vGetSystemConfigurationsMsg(rvc_ccafi_tclMsgSystemConfigurationsStatus& oStatus) {
      oStatus.e8CameraSystem = _tSystemConfigurations_e8CameraSystem;
      oStatus.u8RVCGuideLine = _tSystemConfigurations_u8RVCGuideLine;
      oStatus.u8Brightness = _tSystemConfigurations_u8Brightness;
   }
   virtual void vGetSystemStatusMsg(rvc_ccafi_tclMsgSystemStatusStatus& oStatus) {
      oStatus.e8SystemStatus = _tSystemStatus_e8SystemStatus;
   }
   virtual void vGetVideoSignalStatusMsg(rvc_ccafi_tclMsgVideoSignalStatusStatus& oStatus) {
      oStatus.e8StatusVideoSignal = _tVideoSignalStatus_e8StatusVideoSignal;
   }
   virtual void vGetReverseSignalStatusMsg(rvc_ccafi_tclMsgReverseSignalStatusStatus& oStatus) {
      oStatus.e8StatusReverseSignal = _tReverseSignalStatus_e8StatusReverseSignal;
   }
   virtual void vGetCamera_PwrSupplyStatusMsg(rvc_ccafi_tclMsgCamera_PwrSupplyStatusStatus& oStatus) {
      oStatus.pwrSupplyID = _tCamera_PwrSupplyStatus_pwrSupplyID;
      oStatus.status = _tCamera_PwrSupplyStatus_status;
      oStatus.current = _tCamera_PwrSupplyStatus_current;
   }
   virtual void vGetMicrophone_PwrSupplyStatusMsg(rvc_ccafi_tclMsgMicrophone_PwrSupplyStatusStatus& oStatus) {
      oStatus.pwrSupplyID = _tMicrophone_PwrSupplyStatus_pwrSupplyID;
      oStatus.status = _tMicrophone_PwrSupplyStatus_status;
      oStatus.current = _tMicrophone_PwrSupplyStatus_current;
   }
   virtual void vGetTailgate_StatusMsg(rvc_ccafi_tclMsgTailgate_StatusStatus& oStatus) {
      oStatus.State = _tTailgate_Status_State;
   }
   virtual void vGetView_Close_AuthorizedMsg(rvc_ccafi_tclMsgView_Close_AuthorizedStatus& oStatus) {
      oStatus.e8Allowed = _tView_Close_Authorized_e8Allowed;
   }
   virtual void vGetAvmR_Current_ViewMsg(rvc_ccafi_tclMsgAvmR_Current_ViewStatus& oStatus) {
      oStatus.e8View = _tAvmR_Current_View_e8View;
   }
   virtual void vGetAffordable_ITSMsg(rvc_ccafi_tclMsgAffordable_ITSStatus& oStatus) {
      oStatus.e8AffordableItsAvailable = _tAffordable_ITS_e8AffordableItsAvailable;
      oStatus.e8BswStatus = _tAffordable_ITS_e8BswStatus;
      oStatus.e8ModStatus = _tAffordable_ITS_e8ModStatus;
      oStatus.e8LdwStatus = _tAffordable_ITS_e8LdwStatus;
   }
   virtual void vGetIPAConfigurationMsg(rvc_ccafi_tclMsgIPAConfigurationStatus& oStatus) {
      oStatus.e8AvailabilityStatus = _tIPAConfiguration_e8AvailabilityStatus;
      oStatus.e8RegionalSelection = _tIPAConfiguration_e8RegionalSelection;
   }
   virtual void vGetIPAStatusMsg(rvc_ccafi_tclMsgIPAStatusStatus& oStatus) {
      oStatus.e8OperationStatus = _tIPAStatus_e8OperationStatus;
      oStatus.e8Request = _tIPAStatus_e8Request;
   }
   virtual void vGetIPAPatternRequestMsg(rvc_ccafi_tclMsgIPAPatternRequestStatus& oStatus) {
      oStatus.e8DisplayPattern = _tIPAPatternRequest_e8DisplayPattern;
   }
   virtual void vGetIPAMessageRequestMsg(rvc_ccafi_tclMsgIPAMessageRequestStatus& oStatus) {
      oStatus.e8MessageID = _tIPAMessageRequest_e8MessageID;
   }
   virtual void vGetIPASwitchMaskRequestMsg(rvc_ccafi_tclMsgIPASwitchMaskRequestStatus& oStatus) {
      oStatus.e8SwitchMask = _tIPASwitchMaskRequest_e8SwitchMask;
   }
   virtual void vGetIPASwitchGreyOutRequestMsg(rvc_ccafi_tclMsgIPASwitchGreyOutRequestStatus& oStatus) {
      oStatus.u8SwitchGreyOut = _tIPASwitchGreyOutRequest_u8SwitchGreyOut;
   }
   virtual void vGetIPADirectionIndicatorMsg(rvc_ccafi_tclMsgIPADirectionIndicatorStatus& oStatus) {
      oStatus.e8Direction = _tIPADirectionIndicator_e8Direction;
   }
   virtual void vGetGdlAdj_SteeringAngleMsg(rvc_ccafi_tclMsgGdlAdj_SteeringAngleStatus& oStatus) {
      oStatus.bShowValues = _tGdlAdj_SteeringAngle_bShowValues;
      oStatus.u8CentreAdjustmentState = _tGdlAdj_SteeringAngle_u8CentreAdjustmentState;
      oStatus.s32SteeringAngleCentreAdjusted = _tGdlAdj_SteeringAngle_s32SteeringAngleCentreAdjusted;
      oStatus.SteeringAngleSignalState = _tGdlAdj_SteeringAngle_SteeringAngleSignalState;
   }
   virtual void vGetGdlAdj_CameraAngleMsg(rvc_ccafi_tclMsgGdlAdj_CameraAngleStatus& oStatus) {
      oStatus.f32CameraRollAngle = _tGdlAdj_CameraAngle_f32CameraRollAngle;
      oStatus.f32CameraYawAngle = _tGdlAdj_CameraAngle_f32CameraYawAngle;
      oStatus.f32CameraPitchAngle = _tGdlAdj_CameraAngle_f32CameraPitchAngle;
   }
   virtual void vGetCANFrameStatusMsg(rvc_ccafi_tclMsgCANFrameStatusStatus& oStatus) {
      oStatus.e8StatusCANFrame = _tCANFrameStatus_e8StatusCANFrame;
   }
   virtual void vGetMvcViewStatusMsg(rvc_ccafi_tclMsgMvcViewStatusStatus& oStatus) {
      oStatus.e8View = _tMvcViewStatus_e8View;
   }
   virtual void vGetMvcAlertRequestMsg(rvc_ccafi_tclMsgMvcAlertRequestStatus& oStatus) {
      oStatus.bRequest = _tMvcAlertRequest_bRequest;
   }
   virtual void vGetFAPModeMsg(rvc_ccafi_tclMsgFAPModeStatus& oStatus) {
      oStatus.e8State = _tFAPMode_e8State;
   }
   virtual void vGetFAPSettingsMsg(rvc_ccafi_tclMsgFAPSettingsStatus& oStatus) {
      oStatus.arFapSettingState = _tFAPSettings_arFapSettingState;
      oStatus.arAvmSettingState = _tFAPSettings_arAvmSettingState;
   }
   virtual void vGetFAPGuidanceStateMsg(rvc_ccafi_tclMsgFAPGuidanceStateStatus& oStatus) {
      oStatus.e8State = _tFAPGuidanceState_e8State;
   }
   virtual void vGetAVM3_DispStatusMsg(rvc_ccafi_tclMsgAVM3_DispStatusStatus& oStatus) {
      oStatus.e8DispStatus = _tAVM3_DispStatus_e8DispStatus;
   }
   virtual void vGetAVM3_ViewSetupMsg(rvc_ccafi_tclMsgAVM3_ViewSetupStatus& oStatus) {
      oStatus.e8ViewPattern = _tAVM3_ViewSetup_e8ViewPattern;
      oStatus.e8CautionId = _tAVM3_ViewSetup_e8CautionId;
      oStatus.Switch1 = _tAVM3_ViewSetup_Switch1;
      oStatus.Switch2 = _tAVM3_ViewSetup_Switch2;
      oStatus.Switch3 = _tAVM3_ViewSetup_Switch3;
      oStatus.Switch4 = _tAVM3_ViewSetup_Switch4;
      oStatus.Switch5 = _tAVM3_ViewSetup_Switch5;
      oStatus.Switch6 = _tAVM3_ViewSetup_Switch6;
      oStatus.Switch7 = _tAVM3_ViewSetup_Switch7;
      oStatus.Switch8 = _tAVM3_ViewSetup_Switch8;
      oStatus.e8IconId = _tAVM3_ViewSetup_e8IconId;
      oStatus.e8BuzzerStatus = _tAVM3_ViewSetup_e8BuzzerStatus;
   }
   virtual void vGetAVM3_ErrorMessageMsg(rvc_ccafi_tclMsgAVM3_ErrorMessageStatus& oStatus) {
      oStatus.e8ErrorMessage = _tAVM3_ErrorMessage_e8ErrorMessage;
   }
   virtual void vGetAVM3_SonarBuzzerStatusMsg(rvc_ccafi_tclMsgAVM3_SonarBuzzerStatusStatus& oStatus) {
      oStatus.e8BuzzerStatus = _tAVM3_SonarBuzzerStatus_e8BuzzerStatus;
   }
   virtual void vGetAVM3_Settings_DetailedMsg(rvc_ccafi_tclMsgAVM3_Settings_DetailedStatus& oStatus) {
      oStatus.e8PriorityView = _tAVM3_Settings_Detailed_e8PriorityView;
      oStatus.e8PriorityWide = _tAVM3_Settings_Detailed_e8PriorityWide;
      oStatus.e8AutoCamPos = _tAVM3_Settings_Detailed_e8AutoCamPos;
      oStatus.rCornerSonarSensLvl = _tAVM3_Settings_Detailed_rCornerSonarSensLvl;
      oStatus.rSonarSensLvl = _tAVM3_Settings_Detailed_rSonarSensLvl;
      oStatus.rBuzzerSoundLvl = _tAVM3_Settings_Detailed_rBuzzerSoundLvl;
      oStatus.arSettingsOption = _tAVM3_Settings_Detailed_arSettingsOption;
   }
   virtual void vGetAVM3_Settings_PrimaryMsg(rvc_ccafi_tclMsgAVM3_Settings_PrimaryStatus& oStatus) {
      oStatus.e8AvmSonarBuzzer = _tAVM3_Settings_Primary_e8AvmSonarBuzzer;
      oStatus.bDetailsSettingsAvail = _tAVM3_Settings_Primary_bDetailsSettingsAvail;
      oStatus.bImageQualitySettingAvail = _tAVM3_Settings_Primary_bImageQualitySettingAvail;
   }
   virtual void vGetAVM3_ConfigurationMsg(rvc_ccafi_tclMsgAVM3_ConfigurationStatus& oStatus) {
      oStatus.e8ConfigStatus = _tAVM3_Configuration_e8ConfigStatus;
      oStatus.rUnit_ID = _tAVM3_Configuration_rUnit_ID;
      oStatus.rMsgSetVersion = _tAVM3_Configuration_rMsgSetVersion;
   }
   virtual void vGetAVM3_Software_VersionMsg(rvc_ccafi_tclMsgAVM3_Software_VersionStatus& oStatus) {
      oStatus.rSW_Version_AVM = _tAVM3_Software_Version_rSW_Version_AVM;
      oStatus.rSW_Version_Sonar = _tAVM3_Software_Version_rSW_Version_Sonar;
   }
   virtual void vGetAVM3_Hardware_VersionMsg(rvc_ccafi_tclMsgAVM3_Hardware_VersionStatus& oStatus) {
      oStatus.rHW_Version_AVM = _tAVM3_Hardware_Version_rHW_Version_AVM;
      oStatus.rHW_Version_Sonar = _tAVM3_Hardware_Version_rHW_Version_Sonar;
   }
   virtual void vGetAVM3_CommunicationErrorsMsg(rvc_ccafi_tclMsgAVM3_CommunicationErrorsStatus& oStatus) {
      oStatus.rCommErrors = _tAVM3_CommunicationErrors_rCommErrors;
   }
   virtual void vGetCameraButtonMsg(rvc_ccafi_tclMsgCameraButtonMethodStart& oMethodStart) {
      oMethodStart.e8ButtonState = _tCameraButton_e8ButtonState;
   }
   virtual void vGetSetStatusHmiMsg(rvc_ccafi_tclMsgSetStatusHmiMethodStart& oMethodStart) {
      oMethodStart.e8StatusHmi = _tSetStatusHmi_e8StatusHmi;
   }
   virtual void vGetSetupLanguageMsg(rvc_ccafi_tclMsgSetupLanguageMethodStart& oMethodStart) {
      oMethodStart.e8Language = _tSetupLanguage_e8Language;
   }
   virtual void vGetSetupGuideLineMsg(rvc_ccafi_tclMsgSetupGuideLineMethodStart& oMethodStart) {
      oMethodStart.e8GuideLine = _tSetupGuideLine_e8GuideLine;
   }
   virtual void vGetSetupVideoControlsMsg(rvc_ccafi_tclMsgSetupVideoControlsMethodStart& oMethodStart) {
      oMethodStart.e8HMIDimmingMode = _tSetupVideoControls_e8HMIDimmingMode;
      oMethodStart.e8MVCViewingState = _tSetupVideoControls_e8MVCViewingState;
      oMethodStart.arVideoControlParameter = _tSetupVideoControls_arVideoControlParameter;
   }
   virtual void vGetSetSystemStatusMsg(rvc_ccafi_tclMsgSetSystemStatusMethodStart& oMethodStart) {
      oMethodStart.e8SystemStatus = _tSetSystemStatus_e8SystemStatus;
      oMethodStart.e8GuideLine = _tSetSystemStatus_e8GuideLine;
      oMethodStart.e8WarningText = _tSetSystemStatus_e8WarningText;
   }
   virtual void vGetrunExtDevicePowerSupplyTestMsg(rvc_ccafi_tclMsgrunExtDevicePowerSupplyTestMethodStart& oMethodStart) {
      oMethodStart.pwrSupplyID = _trunExtDevicePowerSupplyTest_pwrSupplyID;
   }
   virtual void vGetInitializeMsg(rvc_ccafi_tclMsgInitializeMethodStart& oMethodStart) {
      oMethodStart.e8Module = _tInitialize_e8Module;
   }
   virtual void vGetConfirmSystemStatusMsg(rvc_ccafi_tclMsgConfirmSystemStatusMethodStart& oMethodStart) {
      oMethodStart.e8SystemStatus = _tConfirmSystemStatus_e8SystemStatus;
   }
   virtual void vGetSetupUserConfigurationMsg(rvc_ccafi_tclMsgSetupUserConfigurationMethodStart& oMethodStart) {
      oMethodStart.arUserConfiguration = _tSetupUserConfiguration_arUserConfiguration;
   }
   virtual void vGetSetMicrophoneStateMsg(rvc_ccafi_tclMsgSetMicrophoneStateMethodStart& oMethodStart) {
      oMethodStart.e8RequestState = _tSetMicrophoneState_e8RequestState;
   }
   virtual void vGetSetRVCStatusMsg(rvc_ccafi_tclMsgSetRVCStatusMethodStart& oMethodStart) {
      oMethodStart.e8RequestState = _tSetRVCStatus_e8RequestState;
   }
   virtual void vGetCamera_SetupBeepMsg(rvc_ccafi_tclMsgCamera_SetupBeepMethodStart& oMethodStart) {
      oMethodStart.e8SetupBeep = _tCamera_SetupBeep_e8SetupBeep;
   }
   virtual void vGetSetCamerastateMsg(rvc_ccafi_tclMsgSetCamerastateMethodStart& oMethodStart) {
      oMethodStart.CameraState = _tSetCamerastate_CameraState;
   }
   virtual void vGetChangeViewRequestMsg(rvc_ccafi_tclMsgChangeViewRequestMethodStart& oMethodStart) {
      oMethodStart.u8Status = _tChangeViewRequest_u8Status;
   }
   virtual void vGetAffordable_Its_SetupBswMsg(rvc_ccafi_tclMsgAffordable_Its_SetupBswMethodStart& oMethodStart) {
      oMethodStart.u8Status = _tAffordable_Its_SetupBsw_u8Status;
   }
   virtual void vGetAffordable_Its_SetupModMsg(rvc_ccafi_tclMsgAffordable_Its_SetupModMethodStart& oMethodStart) {
      oMethodStart.u8Status = _tAffordable_Its_SetupMod_u8Status;
   }
   virtual void vGetAffordable_Its_SetupLdwMsg(rvc_ccafi_tclMsgAffordable_Its_SetupLdwMethodStart& oMethodStart) {
      oMethodStart.u8Status = _tAffordable_Its_SetupLdw_u8Status;
   }
   virtual void vGetIPA_SetHMIStatusMsg(rvc_ccafi_tclMsgIPA_SetHMIStatusMethodStart& oMethodStart) {
      oMethodStart.e8IPAStatus = _tIPA_SetHMIStatus_e8IPAStatus;
   }
   virtual void vGetIPA_SetButtonMsg(rvc_ccafi_tclMsgIPA_SetButtonMethodStart& oMethodStart) {
      oMethodStart.e8ButtonIdentifier = _tIPA_SetButton_e8ButtonIdentifier;
      oMethodStart.e8ButtonStatus = _tIPA_SetButton_e8ButtonStatus;
   }
   virtual void vGetIPA_Voice_TextsMsg(rvc_ccafi_tclMsgIPA_Voice_TextsMethodStart& oMethodStart) {
      oMethodStart.Language = _tIPA_Voice_Texts_Language;
      oMethodStart.arTexts = _tIPA_Voice_Texts_arTexts;
   }
   virtual void vGetMVC_HMI_ViewRequestMsg(rvc_ccafi_tclMsgMVC_HMI_ViewRequestMethodStart& oMethodStart) {
      oMethodStart.e8Request = _tMVC_HMI_ViewRequest_e8Request;
   }
   virtual void vGetGdlAdj_AdjustmentCompleteMsg(rvc_ccafi_tclMsgGdlAdj_AdjustmentCompleteMethodStart& oMethodStart) {
      oMethodStart.e8Completion = _tGdlAdj_AdjustmentComplete_e8Completion;
   }
   virtual void vGetGdlAdj_AdjustButtonMsg(rvc_ccafi_tclMsgGdlAdj_AdjustButtonMethodStart& oMethodStart) {
      oMethodStart.e8Button = _tGdlAdj_AdjustButton_e8Button;
   }
   virtual void vGetGdlAdj_ConfigurationDataMsg(rvc_ccafi_tclMsgGdlAdj_ConfigurationDataMethodStart& oMethodStart) {
      oMethodStart.e8Request = _tGdlAdj_ConfigurationData_e8Request;
      oMethodStart.arConfigParameterData = _tGdlAdj_ConfigurationData_arConfigParameterData;
   }
   virtual void vGetFAP_SetButtonMsg(rvc_ccafi_tclMsgFAP_SetButtonMethodStart& oMethodStart) {
      oMethodStart.e8ButtonIdentifier = _tFAP_SetButton_e8ButtonIdentifier;
      oMethodStart.e8ButtonStatus = _tFAP_SetButton_e8ButtonStatus;
   }
   virtual void vGetTouchEventMsg(rvc_ccafi_tclMsgTouchEventMethodStart& oMethodStart) {
      oMethodStart.arTouchData = _tTouchEvent_arTouchData;
   }
   virtual void vGetGPSInfoMsg(rvc_ccafi_tclMsgGPSInfoMethodStart& oMethodStart) {
      oMethodStart.arGpsData = _tGPSInfo_arGpsData;
   }
   virtual void vGetMapMatchedInfoMsg(rvc_ccafi_tclMsgMapMatchedInfoMethodStart& oMethodStart) {
      oMethodStart.arMapMatchedData = _tMapMatchedInfo_arMapMatchedData;
   }
   virtual void vGetFapLearnParkPositionMsg(rvc_ccafi_tclMsgFapLearnParkPositionMethodStart& oMethodStart) {
      oMethodStart.RequestOn = _tFapLearnParkPosition_RequestOn;
   }
   virtual void vGetSetFapGuidanceMsg(rvc_ccafi_tclMsgSetFapGuidanceMethodStart& oMethodStart) {
      oMethodStart.Request = _tSetFapGuidance_Request;
   }
   virtual void vGetAVM3_SetSwitchMsg(rvc_ccafi_tclMsgAVM3_SetSwitchMethodStart& oMethodStart) {
      oMethodStart.e8SwitchId = _tAVM3_SetSwitch_e8SwitchId;
   }
   virtual void vGetAVM3_SetSonarBuzzerStatusMsg(rvc_ccafi_tclMsgAVM3_SetSonarBuzzerStatusMethodStart& oMethodStart) {
      oMethodStart.e8BuzzerStatus = _tAVM3_SetSonarBuzzerStatus_e8BuzzerStatus;
   }
   virtual void vGetAVM3_Settings_Detailed_SendReqMsg(rvc_ccafi_tclMsgAVM3_Settings_Detailed_SendReqMethodStart& oMethodStart) {
      oMethodStart.e8RequestType = _tAVM3_Settings_Detailed_SendReq_e8RequestType;
      oMethodStart.arChangedItems = _tAVM3_Settings_Detailed_SendReq_arChangedItems;
   }
   virtual void vGetAVM3_Settings_Primary_SendReqMsg(rvc_ccafi_tclMsgAVM3_Settings_Primary_SendReqMethodStart& oMethodStart) {
      oMethodStart.e8RequestType = _tAVM3_Settings_Primary_SendReq_e8RequestType;
      oMethodStart.e8AvmSonarBuzzer = _tAVM3_Settings_Primary_SendReq_e8AvmSonarBuzzer;
      oMethodStart.bDetailsSettingsAvail = _tAVM3_Settings_Primary_SendReq_bDetailsSettingsAvail;
      oMethodStart.bImageQualitySettingAvail = _tAVM3_Settings_Primary_SendReq_bImageQualitySettingAvail;
   }
   virtual void vGetAVM3_GetVersionInfoMsg(rvc_ccafi_tclMsgAVM3_GetVersionInfoMethodStart& oMethodStart) {
      oMethodStart.e8VersionType = _tAVM3_GetVersionInfo_e8VersionType;
   }
   virtual void vGetAVM3_GetCommunicationErrorsMsg(rvc_ccafi_tclMsgAVM3_GetCommunicationErrorsMethodStart& oMethodStart) {
	   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(oMethodStart);
   }
   virtual void vGetAVM3_ClearCommunicationErrorsMsg(rvc_ccafi_tclMsgAVM3_ClearCommunicationErrorsMethodStart& oMethodStart) {
	   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(oMethodStart);
   }
   virtual void vGetToggleGpioPinOnOffMsg(rvc_ccafi_tclMsgToggleGpioPinOnOffMethodStart& oMethodStart) {
	   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(oMethodStart);
   }

private:
   // Add status information properties.
   rvc_fi_tcl_e8_RVC_Camera_System_Type _tSystemConfigurations_e8CameraSystem;

   tU8 _tSystemConfigurations_u8RVCGuideLine;

   tU8 _tSystemConfigurations_u8Brightness;

   rvc_fi_tcl_e8_RVC_SystemStatus _tSystemStatus_e8SystemStatus;

   rvc_fi_tcl_e8_RVC_SignalStatus _tVideoSignalStatus_e8StatusVideoSignal;

   rvc_fi_tcl_e8_RVC_ReverseSignalStatus _tReverseSignalStatus_e8StatusReverseSignal;

   tU16 _tCamera_PwrSupplyStatus_pwrSupplyID;

   rvc_fi_tcl_e8_Camera_PowerSupplyStatus _tCamera_PwrSupplyStatus_status;

   tU32 _tCamera_PwrSupplyStatus_current;

   tU16 _tMicrophone_PwrSupplyStatus_pwrSupplyID;

   rvc_fi_tcl_e8_Microphone_PowerSupplyStatus _tMicrophone_PwrSupplyStatus_status;

   tU32 _tMicrophone_PwrSupplyStatus_current;

   rvc_fi_tcl_e8_Tailgate_State _tTailgate_Status_State;

   rvc_fi_tcl_e8_Exit_Authorized _tView_Close_Authorized_e8Allowed;

   rvc_fi_tcl_e8_AVM_View_Status _tAvmR_Current_View_e8View;

   rvc_fi_tcl_e8_AffordableIts_Status _tAffordable_ITS_e8AffordableItsAvailable;

   rvc_fi_tcl_e8_AffordableIts_StatusFeature _tAffordable_ITS_e8BswStatus;

   rvc_fi_tcl_e8_AffordableIts_StatusFeature _tAffordable_ITS_e8ModStatus;

   rvc_fi_tcl_e8_AffordableIts_StatusFeature _tAffordable_ITS_e8LdwStatus;

   rvc_fi_tcl_e8_IPA_AvailabilityStatus _tIPAConfiguration_e8AvailabilityStatus;

   rvc_fi_tcl_e8_IPA_RegionalSelection _tIPAConfiguration_e8RegionalSelection;

   rvc_fi_tcl_e8_IPA_OperationStatus _tIPAStatus_e8OperationStatus;

   rvc_fi_tcl_e8_IPA_ModeChangeRequest _tIPAStatus_e8Request;

   rvc_fi_tcl_e8_IPA_PatternID _tIPAPatternRequest_e8DisplayPattern;

   rvc_fi_tcl_e8_IPA_MessageID _tIPAMessageRequest_e8MessageID;

   rvc_fi_tcl_e8_IPA_SwitchMask _tIPASwitchMaskRequest_e8SwitchMask;

   tU8 _tIPASwitchGreyOutRequest_u8SwitchGreyOut;

   rvc_fi_tcl_e8_IPA_DirectionIndicator _tIPADirectionIndicator_e8Direction;

   tBool _tGdlAdj_SteeringAngle_bShowValues;

   tU8 _tGdlAdj_SteeringAngle_u8CentreAdjustmentState;

   tS32 _tGdlAdj_SteeringAngle_s32SteeringAngleCentreAdjusted;

   rvc_fi_tclString _tGdlAdj_SteeringAngle_SteeringAngleSignalState;

   tF32 _tGdlAdj_CameraAngle_f32CameraRollAngle;

   tF32 _tGdlAdj_CameraAngle_f32CameraYawAngle;

   tF32 _tGdlAdj_CameraAngle_f32CameraPitchAngle;

   rvc_fi_tcl_e8_RVC_SignalStatus _tCANFrameStatus_e8StatusCANFrame;

   rvc_fi_tcl_e8_MVCViewingState _tMvcViewStatus_e8View;

   tBool _tMvcAlertRequest_bRequest;

   tBool _tFAPMode_e8State;

   std::vector<rvc_fi_tcl_FAP_Settings_State, std::allocator<rvc_fi_tcl_FAP_Settings_State> > _tFAPSettings_arFapSettingState;

   std::vector<rvc_fi_tcl_AVM_Settings_State, std::allocator<rvc_fi_tcl_AVM_Settings_State> > _tFAPSettings_arAvmSettingState;

   tBool _tFAPGuidanceState_e8State;

   rvc_fi_tcl_e8_AVMph3_DispStatus _tAVM3_DispStatus_e8DispStatus;

   rvc_fi_tcl_e8_AVMph3_ViewPattern _tAVM3_ViewSetup_e8ViewPattern;

   rvc_fi_tcl_e8_AVMph3_CautionId _tAVM3_ViewSetup_e8CautionId;

   rvc_fi_tcl_AVMph3_SwitchDescriptor _tAVM3_ViewSetup_Switch1;

   rvc_fi_tcl_AVMph3_SwitchDescriptor _tAVM3_ViewSetup_Switch2;

   rvc_fi_tcl_AVMph3_SwitchDescriptor _tAVM3_ViewSetup_Switch3;

   rvc_fi_tcl_AVMph3_SwitchDescriptor _tAVM3_ViewSetup_Switch4;

   rvc_fi_tcl_AVMph3_SwitchDescriptor _tAVM3_ViewSetup_Switch5;

   rvc_fi_tcl_AVMph3_SwitchDescriptor _tAVM3_ViewSetup_Switch6;

   rvc_fi_tcl_AVMph3_SwitchDescriptor _tAVM3_ViewSetup_Switch7;

   rvc_fi_tcl_AVMph3_SwitchDescriptor _tAVM3_ViewSetup_Switch8;

   rvc_fi_tcl_e8_AVMph3_IconId _tAVM3_ViewSetup_e8IconId;

   rvc_fi_tcl_e8_AVMph3_BuzzerStatus _tAVM3_ViewSetup_e8BuzzerStatus;

   rvc_fi_tcl_e8_AVMph3_ErrorMessage _tAVM3_ErrorMessage_e8ErrorMessage;

   rvc_fi_tcl_e8_AVMph3_BuzzerStatus _tAVM3_SonarBuzzerStatus_e8BuzzerStatus;

   rvc_fi_tcl_e8_AVMph3_Setting_PrioView _tAVM3_Settings_Detailed_e8PriorityView;

   rvc_fi_tcl_e8_AVMph3_Setting_PrioWide _tAVM3_Settings_Detailed_e8PriorityWide;

   rvc_fi_tcl_e8_AVMph3_Setting_AutoCamPos _tAVM3_Settings_Detailed_e8AutoCamPos;

   rvc_fi_tcl_AVMph3_Setting_CornerSonarSensLvl _tAVM3_Settings_Detailed_rCornerSonarSensLvl;

   rvc_fi_tcl_AVMph3_Setting_SonarSensLvl _tAVM3_Settings_Detailed_rSonarSensLvl;

   rvc_fi_tcl_AVMph3_Setting_BuzzerSoundLvl _tAVM3_Settings_Detailed_rBuzzerSoundLvl;

   std::vector<rvc_fi_tcl_AVMph3_Setting_Option, std::allocator<rvc_fi_tcl_AVMph3_Setting_Option> > _tAVM3_Settings_Detailed_arSettingsOption;

   rvc_fi_tcl_e8_AVMph3_SettingOptionState _tAVM3_Settings_Primary_e8AvmSonarBuzzer;

   tBool _tAVM3_Settings_Primary_bDetailsSettingsAvail;

   tBool _tAVM3_Settings_Primary_bImageQualitySettingAvail;

   rvc_fi_tcl_e8_AVMph3_ConfigurationStatus _tAVM3_Configuration_e8ConfigStatus;

   rvc_fi_tcl_AVMph3_Unit_ID _tAVM3_Configuration_rUnit_ID;

   rvc_fi_tcl_AVMph3_VersionInfo _tAVM3_Configuration_rMsgSetVersion;

   rvc_fi_tcl_AVMph3_VersionInfo _tAVM3_Software_Version_rSW_Version_AVM;

   rvc_fi_tcl_AVMph3_VersionInfo _tAVM3_Software_Version_rSW_Version_Sonar;

   rvc_fi_tcl_AVMph3_VersionInfo _tAVM3_Hardware_Version_rHW_Version_AVM;

   rvc_fi_tcl_AVMph3_VersionInfo _tAVM3_Hardware_Version_rHW_Version_Sonar;

   rvc_fi_tcl_AVMph3_MCAN_CommunicationErrors _tAVM3_CommunicationErrors_rCommErrors;

   rvc_fi_tcl_e8_RVC_ButtonState _tCameraButton_e8ButtonState;
   rvc_fi_tcl_e8_RVC_Status _tSetStatusHmi_e8StatusHmi;
   rvc_fi_tcl_e8_RVC_Language _tSetupLanguage_e8Language;
   rvc_fi_tcl_e8_RVC_StatusGuideLine _tSetupGuideLine_e8GuideLine;
   rvc_fi_tcl_e8_RVC_VideoParameterDimmingMode _tSetupVideoControls_e8HMIDimmingMode;
   rvc_fi_tcl_e8_MVCViewingState _tSetupVideoControls_e8MVCViewingState;
   std::vector<rvc_fi_tcl_RVC_VideoAnalogLevels, std::allocator<rvc_fi_tcl_RVC_VideoAnalogLevels> > _tSetupVideoControls_arVideoControlParameter;
   rvc_fi_tcl_e8_RVC_SystemStatus _tSetSystemStatus_e8SystemStatus;
   rvc_fi_tcl_e8_RVC_StatusGuideLine _tSetSystemStatus_e8GuideLine;
   rvc_fi_tcl_e8_RVC_StatusWarningText _tSetSystemStatus_e8WarningText;
   tU16 _trunExtDevicePowerSupplyTest_pwrSupplyID;
   rvc_fi_tcl_e8_RVC_Module _tInitialize_e8Module;
   rvc_fi_tcl_e8_RVC_SystemStatus _tConfirmSystemStatus_e8SystemStatus;
   std::vector<rvc_fi_tcl_ParkAssist_UserConfiguration, std::allocator<rvc_fi_tcl_ParkAssist_UserConfiguration> > _tSetupUserConfiguration_arUserConfiguration;
   rvc_fi_tcl_e8_Set_MicState _tSetMicrophoneState_e8RequestState;
   tU8 _tSetRVCStatus_e8RequestState;
   rvc_fi_tcl_e8_AVM_StatusBeep _tCamera_SetupBeep_e8SetupBeep;
   rvc_fi_tcl_e8_RVC_CameraState _tSetCamerastate_CameraState;
   rvc_fi_tcl_e8_AVM_View_Request _tChangeViewRequest_u8Status;
   tU8 _tAffordable_Its_SetupBsw_u8Status;
   tU8 _tAffordable_Its_SetupMod_u8Status;
   tU8 _tAffordable_Its_SetupLdw_u8Status;
   rvc_fi_tcl_e8_IPA_HMIStatus _tIPA_SetHMIStatus_e8IPAStatus;
   rvc_fi_tcl_e8_IPA_BUTTON_ID _tIPA_SetButton_e8ButtonIdentifier;
   rvc_fi_tcl_e8_RVC_ButtonState _tIPA_SetButton_e8ButtonStatus;
   rvc_fi_tcl_e8_RVC_Language _tIPA_Voice_Texts_Language;
   std::vector<rvc_fi_tcl_IPA_Voice_Text_Strings, std::allocator<rvc_fi_tcl_IPA_Voice_Text_Strings> > _tIPA_Voice_Texts_arTexts;
   rvc_fi_tcl_e8_MVCViewingState _tMVC_HMI_ViewRequest_e8Request;
   rvc_fi_tcl_e8_GdlAdj_Completion _tGdlAdj_AdjustmentComplete_e8Completion;
   rvc_fi_tcl_e8_GdlAdj_AdjustButton _tGdlAdj_AdjustButton_e8Button;
   rvc_fi_tcl_e8_GdlAdj_Request _tGdlAdj_ConfigurationData_e8Request;
   std::vector<rvc_fi_tcl_GdlAdj_ConfigParameterData, std::allocator<rvc_fi_tcl_GdlAdj_ConfigParameterData> > _tGdlAdj_ConfigurationData_arConfigParameterData;
   rvc_fi_tcl_e8_IPA_BUTTON_ID _tFAP_SetButton_e8ButtonIdentifier;
   rvc_fi_tcl_e8_RVC_ButtonState _tFAP_SetButton_e8ButtonStatus;
   rvc_fi_tcl_Touch_Data _tTouchEvent_arTouchData;
   rvc_fi_tcl_GPS_Data _tGPSInfo_arGpsData;
   rvc_fi_tcl_MapMatched_Data _tMapMatchedInfo_arMapMatchedData;
   tBool _tFapLearnParkPosition_RequestOn;
   tBool _tSetFapGuidance_Request;
   rvc_fi_tcl_e8_AVMph3_SwitchId _tAVM3_SetSwitch_e8SwitchId;
   rvc_fi_tcl_e8_AVMph3_BuzzerStatus _tAVM3_SetSonarBuzzerStatus_e8BuzzerStatus;
   rvc_fi_tcl_e8_AVMph3_RequestType _tAVM3_Settings_Detailed_SendReq_e8RequestType;
   std::vector<rvc_fi_tcl_AVMph3_Setting_Item, std::allocator<rvc_fi_tcl_AVMph3_Setting_Item> > _tAVM3_Settings_Detailed_SendReq_arChangedItems;
   rvc_fi_tcl_e8_AVMph3_RequestType _tAVM3_Settings_Primary_SendReq_e8RequestType;
   rvc_fi_tcl_e8_AVMph3_SettingOptionState _tAVM3_Settings_Primary_SendReq_e8AvmSonarBuzzer;
   tBool _tAVM3_Settings_Primary_SendReq_bDetailsSettingsAvail;
   tBool _tAVM3_Settings_Primary_SendReq_bImageQualitySettingAvail;
   rvc_fi_tcl_e8_AVMph3_VersionInfoType _tAVM3_GetVersionInfo_e8VersionType;
   tclMethodResultManager _oMemCameraButton;
   tclMethodResultManager _oMemSetStatusHmi;
   tclMethodResultManager _oMemSetupLanguage;
   tclMethodResultManager _oMemSetupGuideLine;
   tclMethodResultManager _oMemSetupVideoControls;
   tclMethodResultManager _oMemSetSystemStatus;
   tclMethodResultManager _oMemrunExtDevicePowerSupplyTest;
   tclMethodResultManager _oMemInitialize;
   tclMethodResultManager _oMemConfirmSystemStatus;
   tclMethodResultManager _oMemSetupUserConfiguration;
   tclMethodResultManager _oMemSetMicrophoneState;
   tclMethodResultManager _oMemSetRVCStatus;
   tclMethodResultManager _oMemCamera_SetupBeep;
   tclMethodResultManager _oMemSetCamerastate;
   tclMethodResultManager _oMemChangeViewRequest;
   tclMethodResultManager _oMemAffordable_Its_SetupBsw;
   tclMethodResultManager _oMemAffordable_Its_SetupMod;
   tclMethodResultManager _oMemAffordable_Its_SetupLdw;
   tclMethodResultManager _oMemIPA_SetHMIStatus;
   tclMethodResultManager _oMemIPA_SetButton;
   tclMethodResultManager _oMemIPA_Voice_Texts;
   tclMethodResultManager _oMemMVC_HMI_ViewRequest;
   tclMethodResultManager _oMemGdlAdj_AdjustmentComplete;
   tclMethodResultManager _oMemGdlAdj_AdjustButton;
   tclMethodResultManager _oMemGdlAdj_ConfigurationData;
   tclMethodResultManager _oMemFAP_SetButton;
   tclMethodResultManager _oMemTouchEvent;
   tclMethodResultManager _oMemGPSInfo;
   tclMethodResultManager _oMemMapMatchedInfo;
   tclMethodResultManager _oMemFapLearnParkPosition;
   tclMethodResultManager _oMemSetFapGuidance;
   tclMethodResultManager _oMemAVM3_SetSwitch;
   tclMethodResultManager _oMemAVM3_SetSonarBuzzerStatus;
   tclMethodResultManager _oMemAVM3_Settings_Detailed_SendReq;
   tclMethodResultManager _oMemAVM3_Settings_Primary_SendReq;
   tclMethodResultManager _oMemAVM3_GetVersionInfo;
   tclMethodResultManager _oMemAVM3_GetCommunicationErrors;
   tclMethodResultManager _oMemAVM3_ClearCommunicationErrors;
   tclMethodResultManager _oMemToggleGpioPinOnOff;
   /***************************************************************************
   * Message map definition macro
   ***************************************************************************/

   DECLARE_MSG_MAP(dispvidctrl_tclServiceRvc) 

// dispvidctrl_tclServiceRvcDeclarationsPart2: user specific code start
public:
   virtual tVoid vGetConfiguration(const TConfiguration* pStConfigurationValues);

// dispvidctrl_tclServiceRvcDeclarationsPart2: user specific code end

};

#endif // __dispvidctrl_ServiceRvc_H_


