/*****************************************************************************
* FILE:         dispvidctrl_ServiceRvc.cpp
* PROJECT:      G3G project
* SW-COMPONENT: dispvidctrl
* Template:     ServiceHandler.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2020 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETG_S_IMPORT_INTERFACE_GENERIC
#define ETG_S_IMPORT_INTERFACE_PLATFORM
#include "etg_if.h"

// dispvidctrl_tclServiceRvcIncludes: user specific code start
#include "dispvidctrl_tclControl_Rvc.h"
// dispvidctrl_tclServiceRvcIncludes: user specific code end

#include "dispvidctrl_ServiceRvc.h"
#include "dispvidctrl_ServiceRvcCallbackIf.h"



#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DISPVIDCTRL_SERVER_RVC
#include "trcGenProj/Header/dispvidctrl_ServiceRvc.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/
#define RVC_SERVICE_ID              65
#define RVC_FI_MAJOR_VERSION        1
#define RVC_FI_MINOR_VERSION        0

/******************************************************************************/
/*                                                                            */
/* CCA MESSAGE MAP                                                            */
/*                                                                            */
/******************************************************************************/

BEGIN_MSG_MAP(dispvidctrl_tclServiceRvc, ahl_tclBaseWork)
   ON_MESSAGE_SVCDATA(RVC_CCAFI_C_U16_CAMERABUTTON, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleCameraButtonOpMStart)
   ON_MESSAGE_SVCDATA(RVC_CCAFI_C_U16_SETSTATUSHMI, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleSetStatusHmiOpMStart)
   ON_MESSAGE_SVCDATA(RVC_CCAFI_C_U16_SETUPLANGUAGE, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleSetupLanguageOpMStart)
   ON_MESSAGE_SVCDATA(RVC_CCAFI_C_U16_SETUPGUIDELINE, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleSetupGuideLineOpMStart)
   ON_MESSAGE_SVCDATA(RVC_CCAFI_C_U16_SETUPVIDEOCONTROLS, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleSetupVideoControlsOpMStart)
   ON_MESSAGE_SVCDATA(RVC_CCAFI_C_U16_SETSYSTEMSTATUS, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleSetSystemStatusOpMStart)
   ON_MESSAGE_SVCDATA(RVC_CCAFI_C_U16_RUNEXTDEVICEPOWERSUPPLYTEST, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandlerunExtDevicePowerSupplyTestOpMStart)
   ON_MESSAGE_SVCDATA(RVC_CCAFI_C_U16_INITIALIZE, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleInitializeOpMStart)
   ON_MESSAGE_SVCDATA(RVC_CCAFI_C_U16_CONFIRMSYSTEMSTATUS, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleConfirmSystemStatusOpMStart)
   ON_MESSAGE_SVCDATA(RVC_CCAFI_C_U16_SETUPUSERCONFIGURATION, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleSetupUserConfigurationOpMStart)
   ON_MESSAGE_SVCDATA(RVC_CCAFI_C_U16_SETMICROPHONESTATE, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleSetMicrophoneStateOpMStart)
   ON_MESSAGE_SVCDATA(RVC_CCAFI_C_U16_SETRVCSTATUS, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleSetRVCStatusOpMStart)
   ON_MESSAGE_SVCDATA(RVC_CCAFI_C_U16_CAMERA_SETUPBEEP, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleCamera_SetupBeepOpMStart)
   ON_MESSAGE_SVCDATA(RVC_CCAFI_C_U16_SETCAMERASTATE, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleSetCamerastateOpMStart)
   ON_MESSAGE_SVCDATA(RVC_CCAFI_C_U16_CHANGEVIEWREQUEST, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleChangeViewRequestOpMStart)
   ON_MESSAGE_SVCDATA(RVC_CCAFI_C_U16_AFFORDABLE_ITS_SETUPBSW, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleAffordable_Its_SetupBswOpMStart)
   ON_MESSAGE_SVCDATA(RVC_CCAFI_C_U16_AFFORDABLE_ITS_SETUPMOD, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleAffordable_Its_SetupModOpMStart)
   ON_MESSAGE_SVCDATA(RVC_CCAFI_C_U16_AFFORDABLE_ITS_SETUPLDW, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleAffordable_Its_SetupLdwOpMStart)
   ON_MESSAGE_SVCDATA(RVC_CCAFI_C_U16_IPA_SETHMISTATUS, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleIPA_SetHMIStatusOpMStart)
   ON_MESSAGE_SVCDATA(RVC_CCAFI_C_U16_IPA_SETBUTTON, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleIPA_SetButtonOpMStart)
   ON_MESSAGE_SVCDATA(RVC_CCAFI_C_U16_IPA_VOICE_TEXTS, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleIPA_Voice_TextsOpMStart)
   ON_MESSAGE_SVCDATA(RVC_CCAFI_C_U16_MVC_HMI_VIEWREQUEST, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleMVC_HMI_ViewRequestOpMStart)
   ON_MESSAGE_SVCDATA(RVC_CCAFI_C_U16_GDLADJ_ADJUSTMENTCOMPLETE, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleGdlAdj_AdjustmentCompleteOpMStart)
   ON_MESSAGE_SVCDATA(RVC_CCAFI_C_U16_GDLADJ_ADJUSTBUTTON, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleGdlAdj_AdjustButtonOpMStart)
   ON_MESSAGE_SVCDATA(RVC_CCAFI_C_U16_GDLADJ_CONFIGURATIONDATA, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleGdlAdj_ConfigurationDataOpMStart)
   ON_MESSAGE_SVCDATA(RVC_CCAFI_C_U16_FAP_SETBUTTON, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleFAP_SetButtonOpMStart)
   ON_MESSAGE_SVCDATA(RVC_CCAFI_C_U16_TOUCHEVENT, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleTouchEventOpMStart)
   ON_MESSAGE_SVCDATA(RVC_CCAFI_C_U16_GPSINFO, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleGPSInfoOpMStart)
   ON_MESSAGE_SVCDATA(RVC_CCAFI_C_U16_MAPMATCHEDINFO, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleMapMatchedInfoOpMStart)
   ON_MESSAGE_SVCDATA(RVC_CCAFI_C_U16_FAPLEARNPARKPOSITION, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleFapLearnParkPositionOpMStart)
   ON_MESSAGE_SVCDATA(RVC_CCAFI_C_U16_SETFAPGUIDANCE, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleSetFapGuidanceOpMStart)
   ON_MESSAGE_SVCDATA(RVC_CCAFI_C_U16_AVM3_SETSWITCH, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleAVM3_SetSwitchOpMStart)
   ON_MESSAGE_SVCDATA(RVC_CCAFI_C_U16_AVM3_SETSONARBUZZERSTATUS, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleAVM3_SetSonarBuzzerStatusOpMStart)
   ON_MESSAGE_SVCDATA(RVC_CCAFI_C_U16_AVM3_SETTINGS_DETAILED_SENDREQ, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleAVM3_Settings_Detailed_SendReqOpMStart)
   ON_MESSAGE_SVCDATA(RVC_CCAFI_C_U16_AVM3_SETTINGS_PRIMARY_SENDREQ, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleAVM3_Settings_Primary_SendReqOpMStart)
   ON_MESSAGE_SVCDATA(RVC_CCAFI_C_U16_AVM3_GETVERSIONINFO, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleAVM3_GetVersionInfoOpMStart)
   ON_MESSAGE_SVCDATA(RVC_CCAFI_C_U16_AVM3_GETCOMMUNICATIONERRORS, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleAVM3_GetCommunicationErrorsOpMStart)
   ON_MESSAGE_SVCDATA(RVC_CCAFI_C_U16_AVM3_CLEARCOMMUNICATIONERRORS, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleAVM3_ClearCommunicationErrorsOpMStart)
   ON_MESSAGE_SVCDATA(RVC_CCAFI_C_U16_TOGGLEGPIOPINONOFF, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleToggleGpioPinOnOffOpMStart)
END_MSG_MAP()

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: dispvidctrl_tclServiceRvc::
*             dispvidctrl_tclServiceRvc(dispvidctrl_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
dispvidctrl_tclServiceRvc::dispvidctrl_tclServiceRvc(dispvidctrl_tclAppMain* poMainAppl) : 
Idispvidctrl_tclServiceRvc(poMainAppl, RVC_SERVICE_ID, RVC_FI_MAJOR_VERSION, RVC_FI_MINOR_VERSION )
{
   ETG_TRACE_USR4(("dispvidctrl_tclServiceRvc() entered."));
   _poCallbackIf = OSAL_NULL;

   _tSystemConfigurations_u8RVCGuideLine = 0;
   _tSystemConfigurations_u8Brightness = 0;
   _tCamera_PwrSupplyStatus_pwrSupplyID = 0;
   _tCamera_PwrSupplyStatus_current = 0;
   _tMicrophone_PwrSupplyStatus_pwrSupplyID = 0;
   _tMicrophone_PwrSupplyStatus_current = 0;
   _tIPASwitchGreyOutRequest_u8SwitchGreyOut = 0;
   _tGdlAdj_SteeringAngle_bShowValues = FALSE;
   _tGdlAdj_SteeringAngle_u8CentreAdjustmentState = 0;
   _tGdlAdj_SteeringAngle_s32SteeringAngleCentreAdjusted = 0;
   _tGdlAdj_CameraAngle_f32CameraRollAngle = 0.0;
   _tGdlAdj_CameraAngle_f32CameraYawAngle = 0.0;
   _tGdlAdj_CameraAngle_f32CameraPitchAngle = 0.0;
   _tMvcAlertRequest_bRequest = FALSE;
   _tFAPMode_e8State = FALSE;
   _tFAPGuidanceState_e8State = FALSE;
   _tAVM3_Settings_Primary_bDetailsSettingsAvail = FALSE;
   _tAVM3_Settings_Primary_bImageQualitySettingAvail = FALSE;
   _trunExtDevicePowerSupplyTest_pwrSupplyID = 0;
   _tSetRVCStatus_e8RequestState = 0;
   _tAffordable_Its_SetupBsw_u8Status = 0;
   _tAffordable_Its_SetupMod_u8Status = 0;
   _tAffordable_Its_SetupLdw_u8Status = 0;
   _tFapLearnParkPosition_RequestOn = FALSE;
   _tSetFapGuidance_Request = FALSE;
   _tAVM3_Settings_Primary_SendReq_bDetailsSettingsAvail = FALSE;
   _tAVM3_Settings_Primary_SendReq_bImageQualitySettingAvail = FALSE;

   // dispvidctrl_tclServiceRvcConstructor: user specific code start

   // default values for property variables
   _tSystemConfigurations_e8CameraSystem.enType = rvc_fi_tcl_e8_RVC_Camera_System_Type::FI_EN_NONE;
   _tSystemConfigurations_u8RVCGuideLine = 0;
   _tSystemConfigurations_u8Brightness = 50;
   _tSystemStatus_e8SystemStatus.enType = rvc_fi_tcl_e8_RVC_SystemStatus::FI_EN_INITIALISATION;
   _tVideoSignalStatus_e8StatusVideoSignal.enType = rvc_fi_tcl_e8_RVC_SignalStatus::FI_EN_SIGNAL_OK;
   _tReverseSignalStatus_e8StatusReverseSignal.enType = rvc_fi_tcl_e8_RVC_ReverseSignalStatus::FI_EN_OFF;
   _tCamera_PwrSupplyStatus_pwrSupplyID = 0;
   _tCamera_PwrSupplyStatus_status.enType = rvc_fi_tcl_e8_Camera_PowerSupplyStatus::FI_EN_UNKNOWN;;
   _tCamera_PwrSupplyStatus_current = 0;
   _tAffordable_ITS_e8AffordableItsAvailable.enType = rvc_fi_tcl_e8_AffordableIts_Status::FI_EN_NOT_AVAILABLE;
   //_tAffordable_ITS_e8BswStatus.enType = rvc_fi_tcl_e8_AffordableIts_StatusFeature::FI_EN_UNKNOWN;
   _tAffordable_ITS_e8ModStatus.enType = rvc_fi_tcl_e8_AffordableIts_StatusFeature::FI_EN_UNKNOWN;
   //_tAffordable_ITS_e8LdwStatus.enType = rvc_fi_tcl_e8_AffordableIts_StatusFeature::FI_EN_UNKNOWN;
   _tMicrophone_PwrSupplyStatus_pwrSupplyID = 0;
   _tMicrophone_PwrSupplyStatus_status.enType = rvc_fi_tcl_e8_Microphone_PowerSupplyStatus::FI_EN_UNKNOWN;
   _tMicrophone_PwrSupplyStatus_current = 0;
   // dispvidctrl_tclServiceRvcConstructor: user specific code end

   //__PRPPERTY_PARAM_INIT__
}

/*******************************************************************************
*
* FUNCTION: dispvidctrl_tclServiceRvc::
*             ~dispvidctrl_tclServiceRvc(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
dispvidctrl_tclServiceRvc::~dispvidctrl_tclServiceRvc(tVoid)
{
   ETG_TRACE_USR4(("~dispvidctrl_tclServiceRvc() entered."));
   _poCallbackIf = OSAL_NULL;
   
   // dispvidctrl_tclServiceRvcDestructor: user specific code start
   // dispvidctrl_tclServiceRvcDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclServiceRvc::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'dispvidctrl_ServiceRvc.h':
*     Add forward declaration:
*         class Idispvidctrl_tclObject2Get;
*
*     Add declaration of object reference:
*         Idispvidctrl_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Idispvidctrl_tclObject2Get*>(_cpoMain->getHandler("Idispvidctrl_tclObject2Get"));
*     RVC_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclServiceRvc::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("dispvidctrl_tclServiceRvc::vGetReferences() entered."));
   // dispvidctrl_tclServiceRvcvGetReferences: user specific code start
   // dispvidctrl_tclServiceRvcvGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclServiceRvc::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclServiceRvc::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("dispvidctrl_tclServiceRvc::vStartCommunication() entered."));
   // dispvidctrl_tclServiceRvcvStartCommunication: user specific code start
   // dispvidctrl_tclServiceRvcvStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclServiceRvc::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   dispvidctrl_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclServiceRvc::vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("dispvidctrl_tclServiceRvc::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(dispvidctrl_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   
   // dispvidctrl_tclServiceRvcvHandleMessage: user specific code start
   // dispvidctrl_tclServiceRvcvHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclServiceRvc::vHandleTraceMessage()
*
* DESCRIPTION: Handle trace message.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclServiceRvc::vHandleTraceMessage(const tUChar* puchData)
{
   DISPVIDCTRL_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("dispvidctrl_tclServiceRvc::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // dispvidctrl_tclServiceRvcvHandleTraceMessage: user specific code start
   // dispvidctrl_tclServiceRvcvHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclServiceRvc::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclServiceRvc::vTraceInfo()
{
   ETG_TRACE_FATAL(("Property support:      SystemConfigurations (RVC_CCAFI_C_U16_SYSTEMCONFIGURATIONS) -> Opcode: UpReg, RelUpReg, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      SystemStatus (RVC_CCAFI_C_U16_SYSTEMSTATUS) -> Opcode: UpReg, RelUpReg, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      VideoSignalStatus (RVC_CCAFI_C_U16_VIDEOSIGNALSTATUS) -> Opcode: UpReg, RelUpReg, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      ReverseSignalStatus (RVC_CCAFI_C_U16_REVERSESIGNALSTATUS) -> Opcode: UpReg, RelUpReg, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      Camera_PwrSupplyStatus (RVC_CCAFI_C_U16_CAMERA_PWRSUPPLYSTATUS) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      Microphone_PwrSupplyStatus (RVC_CCAFI_C_U16_MICROPHONE_PWRSUPPLYSTATUS) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      Tailgate_Status (RVC_CCAFI_C_U16_TAILGATE_STATUS) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      View_Close_Authorized (RVC_CCAFI_C_U16_VIEW_CLOSE_AUTHORIZED) -> Opcode: UpReg, RelUpReg, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      AvmR_Current_View (RVC_CCAFI_C_U16_AVMR_CURRENT_VIEW) -> Opcode: UpReg, RelUpReg, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      Affordable_ITS (RVC_CCAFI_C_U16_AFFORDABLE_ITS) -> Opcode: UpReg, RelUpReg, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      IPAConfiguration (RVC_CCAFI_C_U16_IPACONFIGURATION) -> Opcode: UpReg, RelUpReg, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      IPAStatus (RVC_CCAFI_C_U16_IPASTATUS) -> Opcode: UpReg, RelUpReg, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      IPAPatternRequest (RVC_CCAFI_C_U16_IPAPATTERNREQUEST) -> Opcode: UpReg, RelUpReg, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      IPAMessageRequest (RVC_CCAFI_C_U16_IPAMESSAGEREQUEST) -> Opcode: UpReg, RelUpReg, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      IPASwitchMaskRequest (RVC_CCAFI_C_U16_IPASWITCHMASKREQUEST) -> Opcode: UpReg, RelUpReg, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      IPASwitchGreyOutRequest (RVC_CCAFI_C_U16_IPASWITCHGREYOUTREQUEST) -> Opcode: UpReg, RelUpReg, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      IPADirectionIndicator (RVC_CCAFI_C_U16_IPADIRECTIONINDICATOR) -> Opcode: UpReg, RelUpReg, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      GdlAdj_SteeringAngle (RVC_CCAFI_C_U16_GDLADJ_STEERINGANGLE) -> Opcode: UpReg, RelUpReg, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      GdlAdj_CameraAngle (RVC_CCAFI_C_U16_GDLADJ_CAMERAANGLE) -> Opcode: UpReg, RelUpReg, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      CANFrameStatus (RVC_CCAFI_C_U16_CANFRAMESTATUS) -> Opcode: UpReg, RelUpReg, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      MvcViewStatus (RVC_CCAFI_C_U16_MVCVIEWSTATUS) -> Opcode: UpReg, RelUpReg, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      MvcAlertRequest (RVC_CCAFI_C_U16_MVCALERTREQUEST) -> Opcode: UpReg, RelUpReg, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      FAPMode (RVC_CCAFI_C_U16_FAPMODE) -> Opcode: UpReg, RelUpReg, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      FAPSettings (RVC_CCAFI_C_U16_FAPSETTINGS) -> Opcode: UpReg, RelUpReg, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      FAPGuidanceState (RVC_CCAFI_C_U16_FAPGUIDANCESTATE) -> Opcode: UpReg, RelUpReg, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      AVM3_DispStatus (RVC_CCAFI_C_U16_AVM3_DISPSTATUS) -> Opcode: UpReg, RelUpReg, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      AVM3_ViewSetup (RVC_CCAFI_C_U16_AVM3_VIEWSETUP) -> Opcode: UpReg, RelUpReg, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      AVM3_ErrorMessage (RVC_CCAFI_C_U16_AVM3_ERRORMESSAGE) -> Opcode: UpReg, RelUpReg, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      AVM3_SonarBuzzerStatus (RVC_CCAFI_C_U16_AVM3_SONARBUZZERSTATUS) -> Opcode: UpReg, RelUpReg, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      AVM3_Settings_Detailed (RVC_CCAFI_C_U16_AVM3_SETTINGS_DETAILED) -> Opcode: UpReg, RelUpReg, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      AVM3_Settings_Primary (RVC_CCAFI_C_U16_AVM3_SETTINGS_PRIMARY) -> Opcode: UpReg, RelUpReg, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      AVM3_Configuration (RVC_CCAFI_C_U16_AVM3_CONFIGURATION) -> Opcode: UpReg, RelUpReg, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      AVM3_Software_Version (RVC_CCAFI_C_U16_AVM3_SOFTWARE_VERSION) -> Opcode: UpReg, RelUpReg, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      AVM3_Hardware_Version (RVC_CCAFI_C_U16_AVM3_HARDWARE_VERSION) -> Opcode: UpReg, RelUpReg, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      AVM3_CommunicationErrors (RVC_CCAFI_C_U16_AVM3_COMMUNICATIONERRORS) -> Opcode: UpReg, RelUpReg, Status, Error, "));
   ETG_TRACE_FATAL(("Method   support:      CameraButton (RVC_CCAFI_C_U16_CAMERABUTTON) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      SetStatusHmi (RVC_CCAFI_C_U16_SETSTATUSHMI) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      SetupLanguage (RVC_CCAFI_C_U16_SETUPLANGUAGE) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      SetupGuideLine (RVC_CCAFI_C_U16_SETUPGUIDELINE) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      SetupVideoControls (RVC_CCAFI_C_U16_SETUPVIDEOCONTROLS) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      SetSystemStatus (RVC_CCAFI_C_U16_SETSYSTEMSTATUS) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      runExtDevicePowerSupplyTest (RVC_CCAFI_C_U16_RUNEXTDEVICEPOWERSUPPLYTEST) -> Opcode: MethodStart, MethodResult, "));
   ETG_TRACE_FATAL(("Method   support:      Initialize (RVC_CCAFI_C_U16_INITIALIZE) -> Opcode: MethodStart, MethodResult, "));
   ETG_TRACE_FATAL(("Method   support:      ConfirmSystemStatus (RVC_CCAFI_C_U16_CONFIRMSYSTEMSTATUS) -> Opcode: MethodStart, MethodResult, "));
   ETG_TRACE_FATAL(("Method   support:      SetupUserConfiguration (RVC_CCAFI_C_U16_SETUPUSERCONFIGURATION) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      SetMicrophoneState (RVC_CCAFI_C_U16_SETMICROPHONESTATE) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      SetRVCStatus (RVC_CCAFI_C_U16_SETRVCSTATUS) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      Camera_SetupBeep (RVC_CCAFI_C_U16_CAMERA_SETUPBEEP) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      SetCamerastate (RVC_CCAFI_C_U16_SETCAMERASTATE) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      ChangeViewRequest (RVC_CCAFI_C_U16_CHANGEVIEWREQUEST) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      Affordable_Its_SetupBsw (RVC_CCAFI_C_U16_AFFORDABLE_ITS_SETUPBSW) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      Affordable_Its_SetupMod (RVC_CCAFI_C_U16_AFFORDABLE_ITS_SETUPMOD) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      Affordable_Its_SetupLdw (RVC_CCAFI_C_U16_AFFORDABLE_ITS_SETUPLDW) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      IPA_SetHMIStatus (RVC_CCAFI_C_U16_IPA_SETHMISTATUS) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      IPA_SetButton (RVC_CCAFI_C_U16_IPA_SETBUTTON) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      IPA_Voice_Texts (RVC_CCAFI_C_U16_IPA_VOICE_TEXTS) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      MVC_HMI_ViewRequest (RVC_CCAFI_C_U16_MVC_HMI_VIEWREQUEST) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      GdlAdj_AdjustmentComplete (RVC_CCAFI_C_U16_GDLADJ_ADJUSTMENTCOMPLETE) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      GdlAdj_AdjustButton (RVC_CCAFI_C_U16_GDLADJ_ADJUSTBUTTON) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      GdlAdj_ConfigurationData (RVC_CCAFI_C_U16_GDLADJ_CONFIGURATIONDATA) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      FAP_SetButton (RVC_CCAFI_C_U16_FAP_SETBUTTON) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      TouchEvent (RVC_CCAFI_C_U16_TOUCHEVENT) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      GPSInfo (RVC_CCAFI_C_U16_GPSINFO) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      MapMatchedInfo (RVC_CCAFI_C_U16_MAPMATCHEDINFO) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      FapLearnParkPosition (RVC_CCAFI_C_U16_FAPLEARNPARKPOSITION) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      SetFapGuidance (RVC_CCAFI_C_U16_SETFAPGUIDANCE) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      AVM3_SetSwitch (RVC_CCAFI_C_U16_AVM3_SETSWITCH) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      AVM3_SetSonarBuzzerStatus (RVC_CCAFI_C_U16_AVM3_SETSONARBUZZERSTATUS) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      AVM3_Settings_Detailed_SendReq (RVC_CCAFI_C_U16_AVM3_SETTINGS_DETAILED_SENDREQ) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      AVM3_Settings_Primary_SendReq (RVC_CCAFI_C_U16_AVM3_SETTINGS_PRIMARY_SENDREQ) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      AVM3_GetVersionInfo (RVC_CCAFI_C_U16_AVM3_GETVERSIONINFO) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      AVM3_GetCommunicationErrors (RVC_CCAFI_C_U16_AVM3_GETCOMMUNICATIONERRORS) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      AVM3_ClearCommunicationErrors (RVC_CCAFI_C_U16_AVM3_CLEARCOMMUNICATIONERRORS) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      ToggleGpioPinOnOff (RVC_CCAFI_C_U16_TOGGLEGPIOPINONOFF) -> Opcode: MethodStart, MethodResult, Error, "));

   // dispvidctrl_tclServiceRvcvTraceInfo: user specific code start
   // dispvidctrl_tclServiceRvcvTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclServiceRvc::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid dispvidctrl_tclServiceRvc::vOnServiceAvailable()
{
   ETG_TRACE_USR4(("vOnServiceAvailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceAvailable();

   // dispvidctrl_tclServiceRvcvOnServiceAvailable: user specific code start
   // dispvidctrl_tclServiceRvcvOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclServiceRvc::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid dispvidctrl_tclServiceRvc::vOnServiceUnavailable()
{
   ETG_TRACE_USR4(("vOnServiceUnavailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceUnavailable();

   // dispvidctrl_tclServiceRvcvOnServiceUnavailable: user specific code start
   // dispvidctrl_tclServiceRvcvOnServiceUnavailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tBool dispvidctrl_tclServiceRvc
*                 ::bStatusMessageFactory(tU16 u16FunctionId,
*                                         amt_tclServiceData& roOutMsg,
*                                         amt_tclServiceData* poInMsg)
*
* DESCRIPTION: This function is called by the CCA framework to request ANY
*              property which is offered by this service. For each property
*              accessed via parameter 'u16FunctionId' the user has to prepare
*              the corresponding FI data object which is then copied to the
*              referenced parameter 'roOutMsg'.
*
* PARAMETER: [IN] u16FunctionId = Function ID of the requested property.
*            [OUT] roOutMsg = Reference to the service data object to which the
*                             content of the prepared FI data object should be
*                             copied to.
*            [IN] poInMsg = Selector message which is used to select dedicated
*                           content to be copied to 'roOutMsg' instead of
*                           updating the entire FI data object.
*
* RETURNVALUE: TRUE = Status message for property successfully generated.
*              FALSE = Failed to generate status message for property.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadService::bStatusMessageFactory().
*******************************************************************************/
tBool dispvidctrl_tclServiceRvc
::bStatusMessageFactory(tU16 u16FunctionId,
                        amt_tclServiceData& roOutMsg,
                        amt_tclServiceData* poInMsg)
{
   (tVoid)poInMsg;   // These lines are added to avoid LINT warnings. Please
   (tVoid)roOutMsg;  // remove as soon as variables are used.

   tBool bSuccess = FALSE;

   ETG_TRACE_USR4(("dispvidctrl_tclServiceRvc:bStatusMessageFactory() entered. FID = 0x%04x.", u16FunctionId));

   switch (u16FunctionId)
   {
   case RVC_CCAFI_C_U16_SYSTEMCONFIGURATIONS:
      {
         rvc_ccafi_tclMsgSystemConfigurationsStatus oStatus;

         oStatus.e8CameraSystem = _tSystemConfigurations_e8CameraSystem;
         oStatus.u8RVCGuideLine = _tSystemConfigurations_u8RVCGuideLine;
         oStatus.u8Brightness = _tSystemConfigurations_u8Brightness;

         // CaseSystemConfigurationsStatus_Pre: user specific code start
         // CaseSystemConfigurationsStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, RVC_FI_MAJOR_VERSION);

         // CaseSystemConfigurationsStatus: user specific code start
         // CaseSystemConfigurationsStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case RVC_CCAFI_C_U16_SYSTEMSTATUS:
      {
         rvc_ccafi_tclMsgSystemStatusStatus oStatus;

         oStatus.e8SystemStatus = _tSystemStatus_e8SystemStatus;

         // CaseSystemStatusStatus_Pre: user specific code start
         // CaseSystemStatusStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, RVC_FI_MAJOR_VERSION);

         // CaseSystemStatusStatus: user specific code start
         // CaseSystemStatusStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case RVC_CCAFI_C_U16_VIDEOSIGNALSTATUS:
      {
         rvc_ccafi_tclMsgVideoSignalStatusStatus oStatus;

         oStatus.e8StatusVideoSignal = _tVideoSignalStatus_e8StatusVideoSignal;

         // CaseVideoSignalStatusStatus_Pre: user specific code start
         // CaseVideoSignalStatusStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, RVC_FI_MAJOR_VERSION);

         // CaseVideoSignalStatusStatus: user specific code start
         // CaseVideoSignalStatusStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case RVC_CCAFI_C_U16_REVERSESIGNALSTATUS:
      {
         rvc_ccafi_tclMsgReverseSignalStatusStatus oStatus;

         oStatus.e8StatusReverseSignal = _tReverseSignalStatus_e8StatusReverseSignal;

         // CaseReverseSignalStatusStatus_Pre: user specific code start
         // CaseReverseSignalStatusStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, RVC_FI_MAJOR_VERSION);

         // CaseReverseSignalStatusStatus: user specific code start
         // CaseReverseSignalStatusStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case RVC_CCAFI_C_U16_CAMERA_PWRSUPPLYSTATUS:
      {
         rvc_ccafi_tclMsgCamera_PwrSupplyStatusStatus oStatus;

         oStatus.pwrSupplyID = _tCamera_PwrSupplyStatus_pwrSupplyID;
         oStatus.status = _tCamera_PwrSupplyStatus_status;
         oStatus.current = _tCamera_PwrSupplyStatus_current;

         // CaseCamera_PwrSupplyStatusStatus_Pre: user specific code start
         // CaseCamera_PwrSupplyStatusStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, RVC_FI_MAJOR_VERSION);

         // CaseCamera_PwrSupplyStatusStatus: user specific code start
         // CaseCamera_PwrSupplyStatusStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case RVC_CCAFI_C_U16_MICROPHONE_PWRSUPPLYSTATUS:
      {
         rvc_ccafi_tclMsgMicrophone_PwrSupplyStatusStatus oStatus;

         oStatus.pwrSupplyID = _tMicrophone_PwrSupplyStatus_pwrSupplyID;
         oStatus.status = _tMicrophone_PwrSupplyStatus_status;
         oStatus.current = _tMicrophone_PwrSupplyStatus_current;

         // CaseMicrophone_PwrSupplyStatusStatus_Pre: user specific code start

         // we need to read the microphone power supply status whenever we receive GET request for this property
         // Get opcode is already handled in the framework in a general way, so we cannot really override that for this particular FID
         // since we do not have any other trigger to check the microphone supply status we do it here
         dispvidctrl_tclControl_Rvc* poControlRVC = dynamic_cast<dispvidctrl_tclControl_Rvc*>(dispvidctrl_tclAppMain::theServer()->getHandler("dispvidctrl_tclControl_Rvc"));
         if ( poControlRVC )
         {
             poControlRVC->_vCheckMicCurrentConsumption(oStatus);
         }

         // CaseMicrophone_PwrSupplyStatusStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, RVC_FI_MAJOR_VERSION);

         // CaseMicrophone_PwrSupplyStatusStatus: user specific code start

         // update the member variables with the updated value from _vCheckMicCurrentConsumption function call
         _tMicrophone_PwrSupplyStatus_pwrSupplyID = oStatus.pwrSupplyID;
         _tMicrophone_PwrSupplyStatus_status = oStatus.status;
         _tMicrophone_PwrSupplyStatus_current = oStatus.current;

         //{
         //   tU8* DataPointeroVisitor = oVisitor.pu8GetDataPointer();
         //   ETG_TRACE_USR4(("Visitor data [%x][%x][%x][%x][%x][%x][%x]", *DataPointeroVisitor,*(DataPointeroVisitor+1), *(DataPointeroVisitor+2),*(DataPointeroVisitor+3),*(DataPointeroVisitor+4),*(DataPointeroVisitor+5),*(DataPointeroVisitor+6)));
         //}

         // CaseMicrophone_PwrSupplyStatusStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case RVC_CCAFI_C_U16_TAILGATE_STATUS:
      {
         rvc_ccafi_tclMsgTailgate_StatusStatus oStatus;

         oStatus.State = _tTailgate_Status_State;

         // CaseTailgate_StatusStatus_Pre: user specific code start
         // CaseTailgate_StatusStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, RVC_FI_MAJOR_VERSION);

         // CaseTailgate_StatusStatus: user specific code start
         // CaseTailgate_StatusStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case RVC_CCAFI_C_U16_VIEW_CLOSE_AUTHORIZED:
      {
         rvc_ccafi_tclMsgView_Close_AuthorizedStatus oStatus;

         oStatus.e8Allowed = _tView_Close_Authorized_e8Allowed;

         // CaseView_Close_AuthorizedStatus_Pre: user specific code start
         // CaseView_Close_AuthorizedStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, RVC_FI_MAJOR_VERSION);

         // CaseView_Close_AuthorizedStatus: user specific code start
         // CaseView_Close_AuthorizedStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case RVC_CCAFI_C_U16_AVMR_CURRENT_VIEW:
      {
         rvc_ccafi_tclMsgAvmR_Current_ViewStatus oStatus;

         oStatus.e8View = _tAvmR_Current_View_e8View;

         // CaseAvmR_Current_ViewStatus_Pre: user specific code start
         // CaseAvmR_Current_ViewStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, RVC_FI_MAJOR_VERSION);

         // CaseAvmR_Current_ViewStatus: user specific code start
         // CaseAvmR_Current_ViewStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case RVC_CCAFI_C_U16_AFFORDABLE_ITS:
      {
         rvc_ccafi_tclMsgAffordable_ITSStatus oStatus;

         oStatus.e8AffordableItsAvailable = _tAffordable_ITS_e8AffordableItsAvailable;
         oStatus.e8BswStatus = _tAffordable_ITS_e8BswStatus;
         oStatus.e8ModStatus = _tAffordable_ITS_e8ModStatus;
         oStatus.e8LdwStatus = _tAffordable_ITS_e8LdwStatus;

         // CaseAffordable_ITSStatus_Pre: user specific code start
         // CaseAffordable_ITSStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, RVC_FI_MAJOR_VERSION);

         // CaseAffordable_ITSStatus: user specific code start
         // CaseAffordable_ITSStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case RVC_CCAFI_C_U16_IPACONFIGURATION:
      {
         rvc_ccafi_tclMsgIPAConfigurationStatus oStatus;

         oStatus.e8AvailabilityStatus = _tIPAConfiguration_e8AvailabilityStatus;
         oStatus.e8RegionalSelection = _tIPAConfiguration_e8RegionalSelection;

         // CaseIPAConfigurationStatus_Pre: user specific code start
         // CaseIPAConfigurationStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, RVC_FI_MAJOR_VERSION);

         // CaseIPAConfigurationStatus: user specific code start
         // CaseIPAConfigurationStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case RVC_CCAFI_C_U16_IPASTATUS:
      {
         rvc_ccafi_tclMsgIPAStatusStatus oStatus;

         oStatus.e8OperationStatus = _tIPAStatus_e8OperationStatus;
         oStatus.e8Request = _tIPAStatus_e8Request;

         // CaseIPAStatusStatus_Pre: user specific code start
         // CaseIPAStatusStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, RVC_FI_MAJOR_VERSION);

         // CaseIPAStatusStatus: user specific code start
         // CaseIPAStatusStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case RVC_CCAFI_C_U16_IPAPATTERNREQUEST:
      {
         rvc_ccafi_tclMsgIPAPatternRequestStatus oStatus;

         oStatus.e8DisplayPattern = _tIPAPatternRequest_e8DisplayPattern;

         // CaseIPAPatternRequestStatus_Pre: user specific code start
         // CaseIPAPatternRequestStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, RVC_FI_MAJOR_VERSION);

         // CaseIPAPatternRequestStatus: user specific code start
         // CaseIPAPatternRequestStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case RVC_CCAFI_C_U16_IPAMESSAGEREQUEST:
      {
         rvc_ccafi_tclMsgIPAMessageRequestStatus oStatus;

         oStatus.e8MessageID = _tIPAMessageRequest_e8MessageID;

         // CaseIPAMessageRequestStatus_Pre: user specific code start
         // CaseIPAMessageRequestStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, RVC_FI_MAJOR_VERSION);

         // CaseIPAMessageRequestStatus: user specific code start
         // CaseIPAMessageRequestStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case RVC_CCAFI_C_U16_IPASWITCHMASKREQUEST:
      {
         rvc_ccafi_tclMsgIPASwitchMaskRequestStatus oStatus;

         oStatus.e8SwitchMask = _tIPASwitchMaskRequest_e8SwitchMask;

         // CaseIPASwitchMaskRequestStatus_Pre: user specific code start
         // CaseIPASwitchMaskRequestStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, RVC_FI_MAJOR_VERSION);

         // CaseIPASwitchMaskRequestStatus: user specific code start
         // CaseIPASwitchMaskRequestStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case RVC_CCAFI_C_U16_IPASWITCHGREYOUTREQUEST:
      {
         rvc_ccafi_tclMsgIPASwitchGreyOutRequestStatus oStatus;

         oStatus.u8SwitchGreyOut = _tIPASwitchGreyOutRequest_u8SwitchGreyOut;

         // CaseIPASwitchGreyOutRequestStatus_Pre: user specific code start
         // CaseIPASwitchGreyOutRequestStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, RVC_FI_MAJOR_VERSION);

         // CaseIPASwitchGreyOutRequestStatus: user specific code start
         // CaseIPASwitchGreyOutRequestStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case RVC_CCAFI_C_U16_IPADIRECTIONINDICATOR:
      {
         rvc_ccafi_tclMsgIPADirectionIndicatorStatus oStatus;

         oStatus.e8Direction = _tIPADirectionIndicator_e8Direction;

         // CaseIPADirectionIndicatorStatus_Pre: user specific code start
         // CaseIPADirectionIndicatorStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, RVC_FI_MAJOR_VERSION);

         // CaseIPADirectionIndicatorStatus: user specific code start
         // CaseIPADirectionIndicatorStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case RVC_CCAFI_C_U16_GDLADJ_STEERINGANGLE:
      {
         rvc_ccafi_tclMsgGdlAdj_SteeringAngleStatus oStatus;

         oStatus.bShowValues = _tGdlAdj_SteeringAngle_bShowValues;
         oStatus.u8CentreAdjustmentState = _tGdlAdj_SteeringAngle_u8CentreAdjustmentState;
         oStatus.s32SteeringAngleCentreAdjusted = _tGdlAdj_SteeringAngle_s32SteeringAngleCentreAdjusted;
         oStatus.SteeringAngleSignalState = _tGdlAdj_SteeringAngle_SteeringAngleSignalState;

         // CaseGdlAdj_SteeringAngleStatus_Pre: user specific code start
         // CaseGdlAdj_SteeringAngleStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, RVC_FI_MAJOR_VERSION);

         // CaseGdlAdj_SteeringAngleStatus: user specific code start
         // CaseGdlAdj_SteeringAngleStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case RVC_CCAFI_C_U16_GDLADJ_CAMERAANGLE:
      {
         rvc_ccafi_tclMsgGdlAdj_CameraAngleStatus oStatus;

         oStatus.f32CameraRollAngle = _tGdlAdj_CameraAngle_f32CameraRollAngle;
         oStatus.f32CameraYawAngle = _tGdlAdj_CameraAngle_f32CameraYawAngle;
         oStatus.f32CameraPitchAngle = _tGdlAdj_CameraAngle_f32CameraPitchAngle;

         // CaseGdlAdj_CameraAngleStatus_Pre: user specific code start
         // CaseGdlAdj_CameraAngleStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, RVC_FI_MAJOR_VERSION);

         // CaseGdlAdj_CameraAngleStatus: user specific code start
         // CaseGdlAdj_CameraAngleStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case RVC_CCAFI_C_U16_CANFRAMESTATUS:
      {
         rvc_ccafi_tclMsgCANFrameStatusStatus oStatus;

         oStatus.e8StatusCANFrame = _tCANFrameStatus_e8StatusCANFrame;

         // CaseCANFrameStatusStatus_Pre: user specific code start
         // CaseCANFrameStatusStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, RVC_FI_MAJOR_VERSION);

         // CaseCANFrameStatusStatus: user specific code start
         // CaseCANFrameStatusStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case RVC_CCAFI_C_U16_MVCVIEWSTATUS:
      {
         rvc_ccafi_tclMsgMvcViewStatusStatus oStatus;

         oStatus.e8View = _tMvcViewStatus_e8View;

         // CaseMvcViewStatusStatus_Pre: user specific code start
         // CaseMvcViewStatusStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, RVC_FI_MAJOR_VERSION);

         // CaseMvcViewStatusStatus: user specific code start
         // CaseMvcViewStatusStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case RVC_CCAFI_C_U16_MVCALERTREQUEST:
      {
         rvc_ccafi_tclMsgMvcAlertRequestStatus oStatus;

         oStatus.bRequest = _tMvcAlertRequest_bRequest;

         // CaseMvcAlertRequestStatus_Pre: user specific code start
         // CaseMvcAlertRequestStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, RVC_FI_MAJOR_VERSION);

         // CaseMvcAlertRequestStatus: user specific code start
         // CaseMvcAlertRequestStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case RVC_CCAFI_C_U16_FAPMODE:
      {
         rvc_ccafi_tclMsgFAPModeStatus oStatus;

         oStatus.e8State = _tFAPMode_e8State;

         // CaseFAPModeStatus_Pre: user specific code start
         // CaseFAPModeStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, RVC_FI_MAJOR_VERSION);

         // CaseFAPModeStatus: user specific code start
         // CaseFAPModeStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case RVC_CCAFI_C_U16_FAPSETTINGS:
      {
         rvc_ccafi_tclMsgFAPSettingsStatus oStatus;

         oStatus.arFapSettingState = _tFAPSettings_arFapSettingState;
         oStatus.arAvmSettingState = _tFAPSettings_arAvmSettingState;

         // CaseFAPSettingsStatus_Pre: user specific code start
         // CaseFAPSettingsStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, RVC_FI_MAJOR_VERSION);

         // CaseFAPSettingsStatus: user specific code start
         // CaseFAPSettingsStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case RVC_CCAFI_C_U16_FAPGUIDANCESTATE:
      {
         rvc_ccafi_tclMsgFAPGuidanceStateStatus oStatus;

         oStatus.e8State = _tFAPGuidanceState_e8State;

         // CaseFAPGuidanceStateStatus_Pre: user specific code start
         // CaseFAPGuidanceStateStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, RVC_FI_MAJOR_VERSION);

         // CaseFAPGuidanceStateStatus: user specific code start
         // CaseFAPGuidanceStateStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case RVC_CCAFI_C_U16_AVM3_DISPSTATUS:
      {
         rvc_ccafi_tclMsgAVM3_DispStatusStatus oStatus;

         oStatus.e8DispStatus = _tAVM3_DispStatus_e8DispStatus;

         // CaseAVM3_DispStatusStatus_Pre: user specific code start
         // CaseAVM3_DispStatusStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, RVC_FI_MAJOR_VERSION);

         // CaseAVM3_DispStatusStatus: user specific code start
         // CaseAVM3_DispStatusStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case RVC_CCAFI_C_U16_AVM3_VIEWSETUP:
      {
         rvc_ccafi_tclMsgAVM3_ViewSetupStatus oStatus;

         oStatus.e8ViewPattern = _tAVM3_ViewSetup_e8ViewPattern;
         oStatus.e8CautionId = _tAVM3_ViewSetup_e8CautionId;
         oStatus.Switch1 = _tAVM3_ViewSetup_Switch1;
         oStatus.Switch2 = _tAVM3_ViewSetup_Switch2;
         oStatus.Switch3 = _tAVM3_ViewSetup_Switch3;
         oStatus.Switch4 = _tAVM3_ViewSetup_Switch4;
         oStatus.Switch5 = _tAVM3_ViewSetup_Switch5;
         oStatus.Switch6 = _tAVM3_ViewSetup_Switch6;
         oStatus.Switch7 = _tAVM3_ViewSetup_Switch7;
         oStatus.Switch8 = _tAVM3_ViewSetup_Switch8;
         oStatus.e8IconId = _tAVM3_ViewSetup_e8IconId;
         oStatus.e8BuzzerStatus = _tAVM3_ViewSetup_e8BuzzerStatus;

         // CaseAVM3_ViewSetupStatus_Pre: user specific code start
         // CaseAVM3_ViewSetupStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, RVC_FI_MAJOR_VERSION);

         // CaseAVM3_ViewSetupStatus: user specific code start
         // CaseAVM3_ViewSetupStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case RVC_CCAFI_C_U16_AVM3_ERRORMESSAGE:
      {
         rvc_ccafi_tclMsgAVM3_ErrorMessageStatus oStatus;

         oStatus.e8ErrorMessage = _tAVM3_ErrorMessage_e8ErrorMessage;

         // CaseAVM3_ErrorMessageStatus_Pre: user specific code start
         // CaseAVM3_ErrorMessageStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, RVC_FI_MAJOR_VERSION);

         // CaseAVM3_ErrorMessageStatus: user specific code start
         // CaseAVM3_ErrorMessageStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case RVC_CCAFI_C_U16_AVM3_SONARBUZZERSTATUS:
      {
         rvc_ccafi_tclMsgAVM3_SonarBuzzerStatusStatus oStatus;

         oStatus.e8BuzzerStatus = _tAVM3_SonarBuzzerStatus_e8BuzzerStatus;

         // CaseAVM3_SonarBuzzerStatusStatus_Pre: user specific code start
         // CaseAVM3_SonarBuzzerStatusStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, RVC_FI_MAJOR_VERSION);

         // CaseAVM3_SonarBuzzerStatusStatus: user specific code start
         // CaseAVM3_SonarBuzzerStatusStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case RVC_CCAFI_C_U16_AVM3_SETTINGS_DETAILED:
      {
         rvc_ccafi_tclMsgAVM3_Settings_DetailedStatus oStatus;

         oStatus.e8PriorityView = _tAVM3_Settings_Detailed_e8PriorityView;
         oStatus.e8PriorityWide = _tAVM3_Settings_Detailed_e8PriorityWide;
         oStatus.e8AutoCamPos = _tAVM3_Settings_Detailed_e8AutoCamPos;
         oStatus.rCornerSonarSensLvl = _tAVM3_Settings_Detailed_rCornerSonarSensLvl;
         oStatus.rSonarSensLvl = _tAVM3_Settings_Detailed_rSonarSensLvl;
         oStatus.rBuzzerSoundLvl = _tAVM3_Settings_Detailed_rBuzzerSoundLvl;
         oStatus.arSettingsOption = _tAVM3_Settings_Detailed_arSettingsOption;

         // CaseAVM3_Settings_DetailedStatus_Pre: user specific code start
         // CaseAVM3_Settings_DetailedStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, RVC_FI_MAJOR_VERSION);

         // CaseAVM3_Settings_DetailedStatus: user specific code start
         // CaseAVM3_Settings_DetailedStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case RVC_CCAFI_C_U16_AVM3_SETTINGS_PRIMARY:
      {
         rvc_ccafi_tclMsgAVM3_Settings_PrimaryStatus oStatus;

         oStatus.e8AvmSonarBuzzer = _tAVM3_Settings_Primary_e8AvmSonarBuzzer;
         oStatus.bDetailsSettingsAvail = _tAVM3_Settings_Primary_bDetailsSettingsAvail;
         oStatus.bImageQualitySettingAvail = _tAVM3_Settings_Primary_bImageQualitySettingAvail;

         // CaseAVM3_Settings_PrimaryStatus_Pre: user specific code start
         // CaseAVM3_Settings_PrimaryStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, RVC_FI_MAJOR_VERSION);

         // CaseAVM3_Settings_PrimaryStatus: user specific code start
         // CaseAVM3_Settings_PrimaryStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case RVC_CCAFI_C_U16_AVM3_CONFIGURATION:
      {
         rvc_ccafi_tclMsgAVM3_ConfigurationStatus oStatus;

         oStatus.e8ConfigStatus = _tAVM3_Configuration_e8ConfigStatus;
         oStatus.rUnit_ID = _tAVM3_Configuration_rUnit_ID;
         oStatus.rMsgSetVersion = _tAVM3_Configuration_rMsgSetVersion;

         // CaseAVM3_ConfigurationStatus_Pre: user specific code start
         // CaseAVM3_ConfigurationStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, RVC_FI_MAJOR_VERSION);

         // CaseAVM3_ConfigurationStatus: user specific code start
         // CaseAVM3_ConfigurationStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case RVC_CCAFI_C_U16_AVM3_SOFTWARE_VERSION:
      {
         rvc_ccafi_tclMsgAVM3_Software_VersionStatus oStatus;

         oStatus.rSW_Version_AVM = _tAVM3_Software_Version_rSW_Version_AVM;
         oStatus.rSW_Version_Sonar = _tAVM3_Software_Version_rSW_Version_Sonar;

         // CaseAVM3_Software_VersionStatus_Pre: user specific code start
         // CaseAVM3_Software_VersionStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, RVC_FI_MAJOR_VERSION);

         // CaseAVM3_Software_VersionStatus: user specific code start
         // CaseAVM3_Software_VersionStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case RVC_CCAFI_C_U16_AVM3_HARDWARE_VERSION:
      {
         rvc_ccafi_tclMsgAVM3_Hardware_VersionStatus oStatus;

         oStatus.rHW_Version_AVM = _tAVM3_Hardware_Version_rHW_Version_AVM;
         oStatus.rHW_Version_Sonar = _tAVM3_Hardware_Version_rHW_Version_Sonar;

         // CaseAVM3_Hardware_VersionStatus_Pre: user specific code start
         // CaseAVM3_Hardware_VersionStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, RVC_FI_MAJOR_VERSION);

         // CaseAVM3_Hardware_VersionStatus: user specific code start
         // CaseAVM3_Hardware_VersionStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case RVC_CCAFI_C_U16_AVM3_COMMUNICATIONERRORS:
      {
         rvc_ccafi_tclMsgAVM3_CommunicationErrorsStatus oStatus;

         oStatus.rCommErrors = _tAVM3_CommunicationErrors_rCommErrors;

         // CaseAVM3_CommunicationErrorsStatus_Pre: user specific code start
         // CaseAVM3_CommunicationErrorsStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, RVC_FI_MAJOR_VERSION);

         // CaseAVM3_CommunicationErrorsStatus: user specific code start
         // CaseAVM3_CommunicationErrorsStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;

   default:
      {
         // Case_Default_Status: user specific code start
         // Case_Default_Status: user specific code end
     }
     break;
   } // switch



   if (!bSuccess)
   {
      ETG_TRACE_ERR(("bStatusMessageFactory(). Creation of message with 'FID = %u' failed.", u16FunctionId));

      NORMAL_M_ASSERT_ALWAYS();
   }

   return bSuccess;
} // bStatusMessageFactory


/*******************************************************************************
*
* FUNCTION: tBool dispvidctrl_tclServiceRvc
*                 ::bProcessSet(amt_tclServiceData* poMessage,
*                               tBool& bPropertyChanged,
*                               tU16& u16ErrorCode)
*
* DESCRIPTION: This function is called by the CCA framework when it has
*              received a message for a property with Opcode 'SET' or 'PURESET'
*              and there is no dedicated handler function defined in the
*              message map for this pair of FID and opcode. The user has to
*              set the application specific property to the requested value
*              and the CCA framework then cares about informing the requesting
*              client as well as other registered clients.
*
* PARAMETER: [IN] poMessage = Property to be set.
*            [OUT] bPropertyChanged = Property changed flag to be set to TRUE
*                                     if property has changed. Otherwise to be
*                                     set to FALSE (default).
*            [OUT] u16ErrorCode = Error code to be set if a CCA error occurs,
*                                 otherwise don't touch.
*
* RETURNVALUE: TRUE = Send 'STATUS' message to the requesting client if opcode
*                     was 'SET'. Send 'STATUS' message to other registered
*                     clients as well if [OUT] parameter 'bPropertyChanged'
*                     is set to TRUE.
*              FALSE = Send an error message to the requesting client.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadService::bProcessSet().
*******************************************************************************/
tBool dispvidctrl_tclServiceRvc
::bProcessSet(amt_tclServiceData* poMessage,
              tBool& bPropertyChanged,
              tU16& u16ErrorCode)
{
   (tVoid)bPropertyChanged;  // These lines are added to avoid LINT warnings.
   (tVoid)u16ErrorCode;      // Please remove as soon as variables are used.

   tBool bSuccess = FALSE;

   tU16 u16FunctionId = poMessage->u16GetFunctionID();

   ETG_TRACE_USR4(("dispvidctrl_tclServiceRvc:bProcessSet() entered. FID = 0x%04x.", u16FunctionId));

   fi_tclVisitorMessage oVisitorMsg(poMessage);

   switch (u16FunctionId)
   {

   default:
      {
         // Case_Default_Set: user specific code start
         // Case_Default_Set: user specific code end
      }
      break;
   } //lint !e764: switch statement possibly does not have a case --> generated process function
   return bSuccess;
} // bProcessSet

tVoid dispvidctrl_tclServiceRvc::sendSystemConfigurationsStatus(rvc_fi_tcl_e8_RVC_Camera_System_Type e8CameraSystem, tU8 u8RVCGuideLine, tU8 u8Brightness)
{

   _tSystemConfigurations_e8CameraSystem = e8CameraSystem;
   _tSystemConfigurations_u8RVCGuideLine = u8RVCGuideLine;
   _tSystemConfigurations_u8Brightness = u8Brightness;


   ETG_TRACE_USR4(("sendSystemConfigurationsStatus() called."));
   eUpdateClients(RVC_CCAFI_C_U16_SYSTEMCONFIGURATIONS);
}
tVoid dispvidctrl_tclServiceRvc::sendSystemStatusStatus(rvc_fi_tcl_e8_RVC_SystemStatus e8SystemStatus)
{

   _tSystemStatus_e8SystemStatus = e8SystemStatus;


   ETG_TRACE_USR4(("sendSystemStatusStatus() called."));
   eUpdateClients(RVC_CCAFI_C_U16_SYSTEMSTATUS);
}
tVoid dispvidctrl_tclServiceRvc::sendVideoSignalStatusStatus(rvc_fi_tcl_e8_RVC_SignalStatus e8StatusVideoSignal)
{

   _tVideoSignalStatus_e8StatusVideoSignal = e8StatusVideoSignal;


   ETG_TRACE_USR4(("sendVideoSignalStatusStatus() called."));
   eUpdateClients(RVC_CCAFI_C_U16_VIDEOSIGNALSTATUS);
}
tVoid dispvidctrl_tclServiceRvc::sendReverseSignalStatusStatus(rvc_fi_tcl_e8_RVC_ReverseSignalStatus e8StatusReverseSignal)
{

   _tReverseSignalStatus_e8StatusReverseSignal = e8StatusReverseSignal;


   ETG_TRACE_USR4(("sendReverseSignalStatusStatus() called."));
   eUpdateClients(RVC_CCAFI_C_U16_REVERSESIGNALSTATUS);
}
tVoid dispvidctrl_tclServiceRvc::sendCamera_PwrSupplyStatusStatus(tU16 pwrSupplyID, rvc_fi_tcl_e8_Camera_PowerSupplyStatus status, tU32 current)
{

   _tCamera_PwrSupplyStatus_pwrSupplyID = pwrSupplyID;
   _tCamera_PwrSupplyStatus_status = status;
   _tCamera_PwrSupplyStatus_current = current;


   ETG_TRACE_USR4(("sendCamera_PwrSupplyStatusStatus() called."));
   eUpdateClients(RVC_CCAFI_C_U16_CAMERA_PWRSUPPLYSTATUS);
}
tVoid dispvidctrl_tclServiceRvc::sendMicrophone_PwrSupplyStatusStatus(tU16 pwrSupplyID, rvc_fi_tcl_e8_Microphone_PowerSupplyStatus status, tU32 current)
{

   _tMicrophone_PwrSupplyStatus_pwrSupplyID = pwrSupplyID;
   _tMicrophone_PwrSupplyStatus_status = status;
   _tMicrophone_PwrSupplyStatus_current = current;


   ETG_TRACE_USR4(("sendMicrophone_PwrSupplyStatusStatus() called."));
   eUpdateClients(RVC_CCAFI_C_U16_MICROPHONE_PWRSUPPLYSTATUS);
}
tVoid dispvidctrl_tclServiceRvc::sendTailgate_StatusStatus(rvc_fi_tcl_e8_Tailgate_State State)
{

   _tTailgate_Status_State = State;


   ETG_TRACE_USR4(("sendTailgate_StatusStatus() called."));
   eUpdateClients(RVC_CCAFI_C_U16_TAILGATE_STATUS);
}
tVoid dispvidctrl_tclServiceRvc::sendView_Close_AuthorizedStatus(rvc_fi_tcl_e8_Exit_Authorized e8Allowed)
{

   _tView_Close_Authorized_e8Allowed = e8Allowed;


   ETG_TRACE_USR4(("sendView_Close_AuthorizedStatus() called."));
   eUpdateClients(RVC_CCAFI_C_U16_VIEW_CLOSE_AUTHORIZED);
}
tVoid dispvidctrl_tclServiceRvc::sendAvmR_Current_ViewStatus(rvc_fi_tcl_e8_AVM_View_Status e8View)
{

   _tAvmR_Current_View_e8View = e8View;


   ETG_TRACE_USR4(("sendAvmR_Current_ViewStatus() called."));
   eUpdateClients(RVC_CCAFI_C_U16_AVMR_CURRENT_VIEW);
}
tVoid dispvidctrl_tclServiceRvc::sendAffordable_ITSStatus(rvc_fi_tcl_e8_AffordableIts_Status e8AffordableItsAvailable, rvc_fi_tcl_e8_AffordableIts_StatusFeature e8BswStatus, rvc_fi_tcl_e8_AffordableIts_StatusFeature e8ModStatus, rvc_fi_tcl_e8_AffordableIts_StatusFeature e8LdwStatus)
{

   _tAffordable_ITS_e8AffordableItsAvailable = e8AffordableItsAvailable;
   _tAffordable_ITS_e8BswStatus = e8BswStatus;
   _tAffordable_ITS_e8ModStatus = e8ModStatus;
   _tAffordable_ITS_e8LdwStatus = e8LdwStatus;


   ETG_TRACE_USR4(("sendAffordable_ITSStatus() called."));
   eUpdateClients(RVC_CCAFI_C_U16_AFFORDABLE_ITS);
}
tVoid dispvidctrl_tclServiceRvc::sendIPAConfigurationStatus(rvc_fi_tcl_e8_IPA_AvailabilityStatus e8AvailabilityStatus, rvc_fi_tcl_e8_IPA_RegionalSelection e8RegionalSelection)
{

   _tIPAConfiguration_e8AvailabilityStatus = e8AvailabilityStatus;
   _tIPAConfiguration_e8RegionalSelection = e8RegionalSelection;


   ETG_TRACE_USR4(("sendIPAConfigurationStatus() called."));
   eUpdateClients(RVC_CCAFI_C_U16_IPACONFIGURATION);
}
tVoid dispvidctrl_tclServiceRvc::sendIPAStatusStatus(rvc_fi_tcl_e8_IPA_OperationStatus e8OperationStatus, rvc_fi_tcl_e8_IPA_ModeChangeRequest e8Request)
{

   _tIPAStatus_e8OperationStatus = e8OperationStatus;
   _tIPAStatus_e8Request = e8Request;


   ETG_TRACE_USR4(("sendIPAStatusStatus() called."));
   eUpdateClients(RVC_CCAFI_C_U16_IPASTATUS);
}
tVoid dispvidctrl_tclServiceRvc::sendIPAPatternRequestStatus(rvc_fi_tcl_e8_IPA_PatternID e8DisplayPattern)
{

   _tIPAPatternRequest_e8DisplayPattern = e8DisplayPattern;


   ETG_TRACE_USR4(("sendIPAPatternRequestStatus() called."));
   eUpdateClients(RVC_CCAFI_C_U16_IPAPATTERNREQUEST);
}
tVoid dispvidctrl_tclServiceRvc::sendIPAMessageRequestStatus(rvc_fi_tcl_e8_IPA_MessageID e8MessageID)
{

   _tIPAMessageRequest_e8MessageID = e8MessageID;


   ETG_TRACE_USR4(("sendIPAMessageRequestStatus() called."));
   eUpdateClients(RVC_CCAFI_C_U16_IPAMESSAGEREQUEST);
}
tVoid dispvidctrl_tclServiceRvc::sendIPASwitchMaskRequestStatus(rvc_fi_tcl_e8_IPA_SwitchMask e8SwitchMask)
{

   _tIPASwitchMaskRequest_e8SwitchMask = e8SwitchMask;


   ETG_TRACE_USR4(("sendIPASwitchMaskRequestStatus() called."));
   eUpdateClients(RVC_CCAFI_C_U16_IPASWITCHMASKREQUEST);
}
tVoid dispvidctrl_tclServiceRvc::sendIPASwitchGreyOutRequestStatus(tU8 u8SwitchGreyOut)
{

   _tIPASwitchGreyOutRequest_u8SwitchGreyOut = u8SwitchGreyOut;


   ETG_TRACE_USR4(("sendIPASwitchGreyOutRequestStatus() called."));
   eUpdateClients(RVC_CCAFI_C_U16_IPASWITCHGREYOUTREQUEST);
}
tVoid dispvidctrl_tclServiceRvc::sendIPADirectionIndicatorStatus(rvc_fi_tcl_e8_IPA_DirectionIndicator e8Direction)
{

   _tIPADirectionIndicator_e8Direction = e8Direction;


   ETG_TRACE_USR4(("sendIPADirectionIndicatorStatus() called."));
   eUpdateClients(RVC_CCAFI_C_U16_IPADIRECTIONINDICATOR);
}
tVoid dispvidctrl_tclServiceRvc::sendGdlAdj_SteeringAngleStatus(tBool bShowValues, tU8 u8CentreAdjustmentState, tS32 s32SteeringAngleCentreAdjusted, rvc_fi_tclString SteeringAngleSignalState)
{

   _tGdlAdj_SteeringAngle_bShowValues = bShowValues;
   _tGdlAdj_SteeringAngle_u8CentreAdjustmentState = u8CentreAdjustmentState;
   _tGdlAdj_SteeringAngle_s32SteeringAngleCentreAdjusted = s32SteeringAngleCentreAdjusted;
   _tGdlAdj_SteeringAngle_SteeringAngleSignalState = SteeringAngleSignalState;


   ETG_TRACE_USR4(("sendGdlAdj_SteeringAngleStatus() called."));
   eUpdateClients(RVC_CCAFI_C_U16_GDLADJ_STEERINGANGLE);
}
tVoid dispvidctrl_tclServiceRvc::sendGdlAdj_CameraAngleStatus(tF32 f32CameraRollAngle, tF32 f32CameraYawAngle, tF32 f32CameraPitchAngle)
{

   _tGdlAdj_CameraAngle_f32CameraRollAngle = f32CameraRollAngle;
   _tGdlAdj_CameraAngle_f32CameraYawAngle = f32CameraYawAngle;
   _tGdlAdj_CameraAngle_f32CameraPitchAngle = f32CameraPitchAngle;


   ETG_TRACE_USR4(("sendGdlAdj_CameraAngleStatus() called."));
   eUpdateClients(RVC_CCAFI_C_U16_GDLADJ_CAMERAANGLE);
}
tVoid dispvidctrl_tclServiceRvc::sendCANFrameStatusStatus(rvc_fi_tcl_e8_RVC_SignalStatus e8StatusCANFrame)
{

   _tCANFrameStatus_e8StatusCANFrame = e8StatusCANFrame;


   ETG_TRACE_USR4(("sendCANFrameStatusStatus() called."));
   eUpdateClients(RVC_CCAFI_C_U16_CANFRAMESTATUS);
}
tVoid dispvidctrl_tclServiceRvc::sendMvcViewStatusStatus(rvc_fi_tcl_e8_MVCViewingState e8View)
{

   _tMvcViewStatus_e8View = e8View;


   ETG_TRACE_USR4(("sendMvcViewStatusStatus() called."));
   eUpdateClients(RVC_CCAFI_C_U16_MVCVIEWSTATUS);
}
tVoid dispvidctrl_tclServiceRvc::sendMvcAlertRequestStatus(tBool bRequest)
{

   _tMvcAlertRequest_bRequest = bRequest;


   ETG_TRACE_USR4(("sendMvcAlertRequestStatus() called."));
   eUpdateClients(RVC_CCAFI_C_U16_MVCALERTREQUEST);
}
tVoid dispvidctrl_tclServiceRvc::sendFAPModeStatus(tBool e8State)
{

   _tFAPMode_e8State = e8State;


   ETG_TRACE_USR4(("sendFAPModeStatus() called."));
   eUpdateClients(RVC_CCAFI_C_U16_FAPMODE);
}
tVoid dispvidctrl_tclServiceRvc::sendFAPSettingsStatus(std::vector<rvc_fi_tcl_FAP_Settings_State, std::allocator<rvc_fi_tcl_FAP_Settings_State> > arFapSettingState, std::vector<rvc_fi_tcl_AVM_Settings_State, std::allocator<rvc_fi_tcl_AVM_Settings_State> > arAvmSettingState)
{

   _tFAPSettings_arFapSettingState = arFapSettingState;
   _tFAPSettings_arAvmSettingState = arAvmSettingState;


   ETG_TRACE_USR4(("sendFAPSettingsStatus() called."));
   eUpdateClients(RVC_CCAFI_C_U16_FAPSETTINGS);
}
tVoid dispvidctrl_tclServiceRvc::sendFAPGuidanceStateStatus(tBool e8State)
{

   _tFAPGuidanceState_e8State = e8State;


   ETG_TRACE_USR4(("sendFAPGuidanceStateStatus() called."));
   eUpdateClients(RVC_CCAFI_C_U16_FAPGUIDANCESTATE);
}
tVoid dispvidctrl_tclServiceRvc::sendAVM3_DispStatusStatus(rvc_fi_tcl_e8_AVMph3_DispStatus e8DispStatus)
{

   _tAVM3_DispStatus_e8DispStatus = e8DispStatus;


   ETG_TRACE_USR4(("sendAVM3_DispStatusStatus() called."));
   eUpdateClients(RVC_CCAFI_C_U16_AVM3_DISPSTATUS);
}
tVoid dispvidctrl_tclServiceRvc::sendAVM3_ViewSetupStatus(rvc_fi_tcl_e8_AVMph3_ViewPattern e8ViewPattern, rvc_fi_tcl_e8_AVMph3_CautionId e8CautionId, rvc_fi_tcl_AVMph3_SwitchDescriptor Switch1, rvc_fi_tcl_AVMph3_SwitchDescriptor Switch2, rvc_fi_tcl_AVMph3_SwitchDescriptor Switch3, rvc_fi_tcl_AVMph3_SwitchDescriptor Switch4, rvc_fi_tcl_AVMph3_SwitchDescriptor Switch5, rvc_fi_tcl_AVMph3_SwitchDescriptor Switch6, rvc_fi_tcl_AVMph3_SwitchDescriptor Switch7, rvc_fi_tcl_AVMph3_SwitchDescriptor Switch8, rvc_fi_tcl_e8_AVMph3_IconId e8IconId, rvc_fi_tcl_e8_AVMph3_BuzzerStatus e8BuzzerStatus)
{

   _tAVM3_ViewSetup_e8ViewPattern = e8ViewPattern;
   _tAVM3_ViewSetup_e8CautionId = e8CautionId;
   _tAVM3_ViewSetup_Switch1 = Switch1;
   _tAVM3_ViewSetup_Switch2 = Switch2;
   _tAVM3_ViewSetup_Switch3 = Switch3;
   _tAVM3_ViewSetup_Switch4 = Switch4;
   _tAVM3_ViewSetup_Switch5 = Switch5;
   _tAVM3_ViewSetup_Switch6 = Switch6;
   _tAVM3_ViewSetup_Switch7 = Switch7;
   _tAVM3_ViewSetup_Switch8 = Switch8;
   _tAVM3_ViewSetup_e8IconId = e8IconId;
   _tAVM3_ViewSetup_e8BuzzerStatus = e8BuzzerStatus;


   ETG_TRACE_USR4(("sendAVM3_ViewSetupStatus() called."));
   eUpdateClients(RVC_CCAFI_C_U16_AVM3_VIEWSETUP);
}
tVoid dispvidctrl_tclServiceRvc::sendAVM3_ErrorMessageStatus(rvc_fi_tcl_e8_AVMph3_ErrorMessage e8ErrorMessage)
{

   _tAVM3_ErrorMessage_e8ErrorMessage = e8ErrorMessage;


   ETG_TRACE_USR4(("sendAVM3_ErrorMessageStatus() called."));
   eUpdateClients(RVC_CCAFI_C_U16_AVM3_ERRORMESSAGE);
}
tVoid dispvidctrl_tclServiceRvc::sendAVM3_SonarBuzzerStatusStatus(rvc_fi_tcl_e8_AVMph3_BuzzerStatus e8BuzzerStatus)
{

   _tAVM3_SonarBuzzerStatus_e8BuzzerStatus = e8BuzzerStatus;


   ETG_TRACE_USR4(("sendAVM3_SonarBuzzerStatusStatus() called."));
   eUpdateClients(RVC_CCAFI_C_U16_AVM3_SONARBUZZERSTATUS);
}
tVoid dispvidctrl_tclServiceRvc::sendAVM3_Settings_DetailedStatus(rvc_fi_tcl_e8_AVMph3_Setting_PrioView e8PriorityView, rvc_fi_tcl_e8_AVMph3_Setting_PrioWide e8PriorityWide, rvc_fi_tcl_e8_AVMph3_Setting_AutoCamPos e8AutoCamPos, rvc_fi_tcl_AVMph3_Setting_CornerSonarSensLvl rCornerSonarSensLvl, rvc_fi_tcl_AVMph3_Setting_SonarSensLvl rSonarSensLvl, rvc_fi_tcl_AVMph3_Setting_BuzzerSoundLvl rBuzzerSoundLvl, std::vector<rvc_fi_tcl_AVMph3_Setting_Option, std::allocator<rvc_fi_tcl_AVMph3_Setting_Option> > arSettingsOption)
{

   _tAVM3_Settings_Detailed_e8PriorityView = e8PriorityView;
   _tAVM3_Settings_Detailed_e8PriorityWide = e8PriorityWide;
   _tAVM3_Settings_Detailed_e8AutoCamPos = e8AutoCamPos;
   _tAVM3_Settings_Detailed_rCornerSonarSensLvl = rCornerSonarSensLvl;
   _tAVM3_Settings_Detailed_rSonarSensLvl = rSonarSensLvl;
   _tAVM3_Settings_Detailed_rBuzzerSoundLvl = rBuzzerSoundLvl;
   _tAVM3_Settings_Detailed_arSettingsOption = arSettingsOption;


   ETG_TRACE_USR4(("sendAVM3_Settings_DetailedStatus() called."));
   eUpdateClients(RVC_CCAFI_C_U16_AVM3_SETTINGS_DETAILED);
}
tVoid dispvidctrl_tclServiceRvc::sendAVM3_Settings_PrimaryStatus(rvc_fi_tcl_e8_AVMph3_SettingOptionState e8AvmSonarBuzzer, tBool bDetailsSettingsAvail, tBool bImageQualitySettingAvail)
{

   _tAVM3_Settings_Primary_e8AvmSonarBuzzer = e8AvmSonarBuzzer;
   _tAVM3_Settings_Primary_bDetailsSettingsAvail = bDetailsSettingsAvail;
   _tAVM3_Settings_Primary_bImageQualitySettingAvail = bImageQualitySettingAvail;


   ETG_TRACE_USR4(("sendAVM3_Settings_PrimaryStatus() called."));
   eUpdateClients(RVC_CCAFI_C_U16_AVM3_SETTINGS_PRIMARY);
}
tVoid dispvidctrl_tclServiceRvc::sendAVM3_ConfigurationStatus(rvc_fi_tcl_e8_AVMph3_ConfigurationStatus e8ConfigStatus, rvc_fi_tcl_AVMph3_Unit_ID rUnit_ID, rvc_fi_tcl_AVMph3_VersionInfo rMsgSetVersion)
{

   _tAVM3_Configuration_e8ConfigStatus = e8ConfigStatus;
   _tAVM3_Configuration_rUnit_ID = rUnit_ID;
   _tAVM3_Configuration_rMsgSetVersion = rMsgSetVersion;


   ETG_TRACE_USR4(("sendAVM3_ConfigurationStatus() called."));
   eUpdateClients(RVC_CCAFI_C_U16_AVM3_CONFIGURATION);
}
tVoid dispvidctrl_tclServiceRvc::sendAVM3_Software_VersionStatus(rvc_fi_tcl_AVMph3_VersionInfo rSW_Version_AVM, rvc_fi_tcl_AVMph3_VersionInfo rSW_Version_Sonar)
{

   _tAVM3_Software_Version_rSW_Version_AVM = rSW_Version_AVM;
   _tAVM3_Software_Version_rSW_Version_Sonar = rSW_Version_Sonar;


   ETG_TRACE_USR4(("sendAVM3_Software_VersionStatus() called."));
   eUpdateClients(RVC_CCAFI_C_U16_AVM3_SOFTWARE_VERSION);
}
tVoid dispvidctrl_tclServiceRvc::sendAVM3_Hardware_VersionStatus(rvc_fi_tcl_AVMph3_VersionInfo rHW_Version_AVM, rvc_fi_tcl_AVMph3_VersionInfo rHW_Version_Sonar)
{

   _tAVM3_Hardware_Version_rHW_Version_AVM = rHW_Version_AVM;
   _tAVM3_Hardware_Version_rHW_Version_Sonar = rHW_Version_Sonar;


   ETG_TRACE_USR4(("sendAVM3_Hardware_VersionStatus() called."));
   eUpdateClients(RVC_CCAFI_C_U16_AVM3_HARDWARE_VERSION);
}
tVoid dispvidctrl_tclServiceRvc::sendAVM3_CommunicationErrorsStatus(rvc_fi_tcl_AVMph3_MCAN_CommunicationErrors rCommErrors)
{

   _tAVM3_CommunicationErrors_rCommErrors = rCommErrors;


   ETG_TRACE_USR4(("sendAVM3_CommunicationErrorsStatus() called."));
   eUpdateClients(RVC_CCAFI_C_U16_AVM3_COMMUNICATIONERRORS);
}



tVoid dispvidctrl_tclServiceRvc::vHandleCameraButtonOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         rvc_ccafi_tclMsgCameraButtonMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, RVC_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tCameraButton_e8ButtonState = oMStart.e8ButtonState;



            // Remember that we have to send an answer to this request
            _oMemCameraButton.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onCameraButtonMStart(oMStart.e8ButtonState);
            if (_poCallbackIf) _poCallbackIf->onCameraButtonMStart(oMStart.e8ButtonState);
            // vHandleCameraButtonOpMStart: user specific code start
            // vHandleCameraButtonOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleCameraButtonOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceRvc::onCameraButtonMStart(rvc_fi_tcl_e8_RVC_ButtonState e8ButtonState) {

   // onCameraButtonMStart: user specific code start
   (tVoid) e8ButtonState;
   // onCameraButtonMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvc::sendCameraButtonMResult(tBool Result) {
   if (_oMemCameraButton.bIsPending() == TRUE) {
      rvc_ccafi_tclMsgCameraButtonMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemCameraButton.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemCameraButton.u16GetSourceAppID(), 
         _oMemCameraButton.u16GetRegisterID(), 
         _oMemCameraButton.u16GetCMDCounter(), 
         (tU16) RVC_CCAFI_C_U16_CAMERABUTTON, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendCameraButtonMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", RVC_CCAFI_C_U16_CAMERABUTTON, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceRvc::vHandleSetStatusHmiOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         rvc_ccafi_tclMsgSetStatusHmiMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, RVC_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tSetStatusHmi_e8StatusHmi = oMStart.e8StatusHmi;



            // Remember that we have to send an answer to this request
            _oMemSetStatusHmi.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onSetStatusHmiMStart(oMStart.e8StatusHmi);
            if (_poCallbackIf) _poCallbackIf->onSetStatusHmiMStart(oMStart.e8StatusHmi);
            // vHandleSetStatusHmiOpMStart: user specific code start
            // vHandleSetStatusHmiOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleSetStatusHmiOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceRvc::onSetStatusHmiMStart(rvc_fi_tcl_e8_RVC_Status e8StatusHmi) {

   // onSetStatusHmiMStart: user specific code start
   (tVoid) e8StatusHmi;
   // onSetStatusHmiMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvc::sendSetStatusHmiMResult(rvc_fi_tcl_e8_RVC_SystemStatus e8SystemStatus) {
   if (_oMemSetStatusHmi.bIsPending() == TRUE) {
      rvc_ccafi_tclMsgSetStatusHmiMethodResult  oMResult;
      //the data content

      oMResult.e8SystemStatus = e8SystemStatus;


      _oMemSetStatusHmi.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemSetStatusHmi.u16GetSourceAppID(), 
         _oMemSetStatusHmi.u16GetRegisterID(), 
         _oMemSetStatusHmi.u16GetCMDCounter(), 
         (tU16) RVC_CCAFI_C_U16_SETSTATUSHMI, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendSetStatusHmiMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", RVC_CCAFI_C_U16_SETSTATUSHMI, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceRvc::vHandleSetupLanguageOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         rvc_ccafi_tclMsgSetupLanguageMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, RVC_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tSetupLanguage_e8Language = oMStart.e8Language;



            // Remember that we have to send an answer to this request
            _oMemSetupLanguage.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onSetupLanguageMStart(oMStart.e8Language);
            if (_poCallbackIf) _poCallbackIf->onSetupLanguageMStart(oMStart.e8Language);
            // vHandleSetupLanguageOpMStart: user specific code start
            // vHandleSetupLanguageOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleSetupLanguageOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceRvc::onSetupLanguageMStart(rvc_fi_tcl_e8_RVC_Language e8Language) {

   // onSetupLanguageMStart: user specific code start
   (tVoid) e8Language;
   // onSetupLanguageMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvc::sendSetupLanguageMResult(tBool Result) {
   if (_oMemSetupLanguage.bIsPending() == TRUE) {
      rvc_ccafi_tclMsgSetupLanguageMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemSetupLanguage.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemSetupLanguage.u16GetSourceAppID(), 
         _oMemSetupLanguage.u16GetRegisterID(), 
         _oMemSetupLanguage.u16GetCMDCounter(), 
         (tU16) RVC_CCAFI_C_U16_SETUPLANGUAGE, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendSetupLanguageMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", RVC_CCAFI_C_U16_SETUPLANGUAGE, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceRvc::vHandleSetupGuideLineOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         rvc_ccafi_tclMsgSetupGuideLineMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, RVC_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tSetupGuideLine_e8GuideLine = oMStart.e8GuideLine;



            // Remember that we have to send an answer to this request
            _oMemSetupGuideLine.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onSetupGuideLineMStart(oMStart.e8GuideLine);
            if (_poCallbackIf) _poCallbackIf->onSetupGuideLineMStart(oMStart.e8GuideLine);
            // vHandleSetupGuideLineOpMStart: user specific code start
            // vHandleSetupGuideLineOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleSetupGuideLineOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceRvc::onSetupGuideLineMStart(rvc_fi_tcl_e8_RVC_StatusGuideLine e8GuideLine) {

   // onSetupGuideLineMStart: user specific code start
   (tVoid) e8GuideLine;
   // onSetupGuideLineMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvc::sendSetupGuideLineMResult(tBool Result) {
   if (_oMemSetupGuideLine.bIsPending() == TRUE) {
      rvc_ccafi_tclMsgSetupGuideLineMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemSetupGuideLine.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemSetupGuideLine.u16GetSourceAppID(), 
         _oMemSetupGuideLine.u16GetRegisterID(), 
         _oMemSetupGuideLine.u16GetCMDCounter(), 
         (tU16) RVC_CCAFI_C_U16_SETUPGUIDELINE, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendSetupGuideLineMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", RVC_CCAFI_C_U16_SETUPGUIDELINE, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceRvc::vHandleSetupVideoControlsOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         rvc_ccafi_tclMsgSetupVideoControlsMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, RVC_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tSetupVideoControls_e8HMIDimmingMode = oMStart.e8HMIDimmingMode;
            _tSetupVideoControls_e8MVCViewingState = oMStart.e8MVCViewingState;
            _tSetupVideoControls_arVideoControlParameter = oMStart.arVideoControlParameter;



            // Remember that we have to send an answer to this request
            _oMemSetupVideoControls.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onSetupVideoControlsMStart(oMStart.e8HMIDimmingMode, oMStart.e8MVCViewingState, oMStart.arVideoControlParameter);
            if (_poCallbackIf) _poCallbackIf->onSetupVideoControlsMStart(oMStart.e8HMIDimmingMode, oMStart.e8MVCViewingState, oMStart.arVideoControlParameter);
            // vHandleSetupVideoControlsOpMStart: user specific code start
            // vHandleSetupVideoControlsOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleSetupVideoControlsOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceRvc::onSetupVideoControlsMStart(rvc_fi_tcl_e8_RVC_VideoParameterDimmingMode e8HMIDimmingMode, rvc_fi_tcl_e8_MVCViewingState e8MVCViewingState, std::vector<rvc_fi_tcl_RVC_VideoAnalogLevels, std::allocator<rvc_fi_tcl_RVC_VideoAnalogLevels> > arVideoControlParameter) {

   // onSetupVideoControlsMStart: user specific code start
   (tVoid) e8HMIDimmingMode;
   (tVoid) arVideoControlParameter;
   (tVoid) e8MVCViewingState;
   (tVoid) arVideoControlParameter;
   // onSetupVideoControlsMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvc::sendSetupVideoControlsMResult(tBool Result) {
   if (_oMemSetupVideoControls.bIsPending() == TRUE) {
      rvc_ccafi_tclMsgSetupVideoControlsMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemSetupVideoControls.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemSetupVideoControls.u16GetSourceAppID(), 
         _oMemSetupVideoControls.u16GetRegisterID(), 
         _oMemSetupVideoControls.u16GetCMDCounter(), 
         (tU16) RVC_CCAFI_C_U16_SETUPVIDEOCONTROLS, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendSetupVideoControlsMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", RVC_CCAFI_C_U16_SETUPVIDEOCONTROLS, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceRvc::vHandleSetSystemStatusOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         rvc_ccafi_tclMsgSetSystemStatusMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, RVC_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tSetSystemStatus_e8SystemStatus = oMStart.e8SystemStatus;
            _tSetSystemStatus_e8GuideLine = oMStart.e8GuideLine;
            _tSetSystemStatus_e8WarningText = oMStart.e8WarningText;



            // Remember that we have to send an answer to this request
            _oMemSetSystemStatus.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onSetSystemStatusMStart(oMStart.e8SystemStatus, oMStart.e8GuideLine, oMStart.e8WarningText);
            if (_poCallbackIf) _poCallbackIf->onSetSystemStatusMStart(oMStart.e8SystemStatus, oMStart.e8GuideLine, oMStart.e8WarningText);
            // vHandleSetSystemStatusOpMStart: user specific code start
            // vHandleSetSystemStatusOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleSetSystemStatusOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceRvc::onSetSystemStatusMStart(rvc_fi_tcl_e8_RVC_SystemStatus e8SystemStatus, rvc_fi_tcl_e8_RVC_StatusGuideLine e8GuideLine, rvc_fi_tcl_e8_RVC_StatusWarningText e8WarningText) {

   // onSetSystemStatusMStart: user specific code start
   (tVoid) e8SystemStatus;
   (tVoid) e8GuideLine;
   (tVoid) e8WarningText;
   // onSetSystemStatusMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvc::sendSetSystemStatusMResult(tBool Result) {
   if (_oMemSetSystemStatus.bIsPending() == TRUE) {
      rvc_ccafi_tclMsgSetSystemStatusMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemSetSystemStatus.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemSetSystemStatus.u16GetSourceAppID(), 
         _oMemSetSystemStatus.u16GetRegisterID(), 
         _oMemSetSystemStatus.u16GetCMDCounter(), 
         (tU16) RVC_CCAFI_C_U16_SETSYSTEMSTATUS, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendSetSystemStatusMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", RVC_CCAFI_C_U16_SETSYSTEMSTATUS, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceRvc::vHandlerunExtDevicePowerSupplyTestOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         rvc_ccafi_tclMsgrunExtDevicePowerSupplyTestMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, RVC_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _trunExtDevicePowerSupplyTest_pwrSupplyID = oMStart.pwrSupplyID;



            // Remember that we have to send an answer to this request
            _oMemrunExtDevicePowerSupplyTest.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onrunExtDevicePowerSupplyTestMStart(oMStart.pwrSupplyID);
            if (_poCallbackIf) _poCallbackIf->onrunExtDevicePowerSupplyTestMStart(oMStart.pwrSupplyID);
            // vHandlerunExtDevicePowerSupplyTestOpMStart: user specific code start
            // vHandlerunExtDevicePowerSupplyTestOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandlerunExtDevicePowerSupplyTestOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceRvc::onrunExtDevicePowerSupplyTestMStart(tU16 pwrSupplyID) {

   // onrunExtDevicePowerSupplyTestMStart: user specific code start
   (tVoid) pwrSupplyID;
   // onrunExtDevicePowerSupplyTestMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvc::sendrunExtDevicePowerSupplyTestMResult(tU16 pwrSupplyID, rvc_fi_tcl_e8_Camera_PowerSupplyStatus status, tU32 current) {
   if (_oMemrunExtDevicePowerSupplyTest.bIsPending() == TRUE) {
      rvc_ccafi_tclMsgrunExtDevicePowerSupplyTestMethodResult  oMResult;
      //the data content

      oMResult.pwrSupplyID = pwrSupplyID;
      oMResult.status = status;
      oMResult.current = current;


      _oMemrunExtDevicePowerSupplyTest.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemrunExtDevicePowerSupplyTest.u16GetSourceAppID(), 
         _oMemrunExtDevicePowerSupplyTest.u16GetRegisterID(), 
         _oMemrunExtDevicePowerSupplyTest.u16GetCMDCounter(), 
         (tU16) RVC_CCAFI_C_U16_RUNEXTDEVICEPOWERSUPPLYTEST, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendrunExtDevicePowerSupplyTestMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", RVC_CCAFI_C_U16_RUNEXTDEVICEPOWERSUPPLYTEST, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceRvc::vHandleInitializeOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         rvc_ccafi_tclMsgInitializeMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, RVC_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tInitialize_e8Module = oMStart.e8Module;



            // Remember that we have to send an answer to this request
            _oMemInitialize.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onInitializeMStart(oMStart.e8Module);
            if (_poCallbackIf) _poCallbackIf->onInitializeMStart(oMStart.e8Module);
            // vHandleInitializeOpMStart: user specific code start
            // vHandleInitializeOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleInitializeOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceRvc::onInitializeMStart(rvc_fi_tcl_e8_RVC_Module e8Module) {

   // onInitializeMStart: user specific code start
   (tVoid) e8Module;
   // onInitializeMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvc::sendInitializeMResult(tBool Result) {
   if (_oMemInitialize.bIsPending() == TRUE) {
      rvc_ccafi_tclMsgInitializeMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemInitialize.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemInitialize.u16GetSourceAppID(), 
         _oMemInitialize.u16GetRegisterID(), 
         _oMemInitialize.u16GetCMDCounter(), 
         (tU16) RVC_CCAFI_C_U16_INITIALIZE, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendInitializeMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", RVC_CCAFI_C_U16_INITIALIZE, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceRvc::vHandleConfirmSystemStatusOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         rvc_ccafi_tclMsgConfirmSystemStatusMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, RVC_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tConfirmSystemStatus_e8SystemStatus = oMStart.e8SystemStatus;



            // Remember that we have to send an answer to this request
            _oMemConfirmSystemStatus.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onConfirmSystemStatusMStart(oMStart.e8SystemStatus);
            if (_poCallbackIf) _poCallbackIf->onConfirmSystemStatusMStart(oMStart.e8SystemStatus);
            // vHandleConfirmSystemStatusOpMStart: user specific code start
            // vHandleConfirmSystemStatusOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleConfirmSystemStatusOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceRvc::onConfirmSystemStatusMStart(rvc_fi_tcl_e8_RVC_SystemStatus e8SystemStatus) {

   // onConfirmSystemStatusMStart: user specific code start
   (tVoid) e8SystemStatus;
   // onConfirmSystemStatusMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvc::sendConfirmSystemStatusMResult(tBool Result) {
   if (_oMemConfirmSystemStatus.bIsPending() == TRUE) {
      rvc_ccafi_tclMsgConfirmSystemStatusMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemConfirmSystemStatus.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemConfirmSystemStatus.u16GetSourceAppID(), 
         _oMemConfirmSystemStatus.u16GetRegisterID(), 
         _oMemConfirmSystemStatus.u16GetCMDCounter(), 
         (tU16) RVC_CCAFI_C_U16_CONFIRMSYSTEMSTATUS, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendConfirmSystemStatusMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", RVC_CCAFI_C_U16_CONFIRMSYSTEMSTATUS, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceRvc::vHandleSetupUserConfigurationOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         rvc_ccafi_tclMsgSetupUserConfigurationMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, RVC_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tSetupUserConfiguration_arUserConfiguration = oMStart.arUserConfiguration;



            // Remember that we have to send an answer to this request
            _oMemSetupUserConfiguration.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onSetupUserConfigurationMStart(oMStart.arUserConfiguration);
            if (_poCallbackIf) _poCallbackIf->onSetupUserConfigurationMStart(oMStart.arUserConfiguration);
            // vHandleSetupUserConfigurationOpMStart: user specific code start
            // vHandleSetupUserConfigurationOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleSetupUserConfigurationOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceRvc::onSetupUserConfigurationMStart(std::vector<rvc_fi_tcl_ParkAssist_UserConfiguration, std::allocator<rvc_fi_tcl_ParkAssist_UserConfiguration> > arUserConfiguration) {

   // onSetupUserConfigurationMStart: user specific code start
   (tVoid) arUserConfiguration;
   // onSetupUserConfigurationMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvc::sendSetupUserConfigurationMResult(tBool Result) {
   if (_oMemSetupUserConfiguration.bIsPending() == TRUE) {
      rvc_ccafi_tclMsgSetupUserConfigurationMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemSetupUserConfiguration.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemSetupUserConfiguration.u16GetSourceAppID(), 
         _oMemSetupUserConfiguration.u16GetRegisterID(), 
         _oMemSetupUserConfiguration.u16GetCMDCounter(), 
         (tU16) RVC_CCAFI_C_U16_SETUPUSERCONFIGURATION, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendSetupUserConfigurationMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", RVC_CCAFI_C_U16_SETUPUSERCONFIGURATION, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceRvc::vHandleSetMicrophoneStateOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         rvc_ccafi_tclMsgSetMicrophoneStateMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, RVC_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tSetMicrophoneState_e8RequestState = oMStart.e8RequestState;



            // Remember that we have to send an answer to this request
            _oMemSetMicrophoneState.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onSetMicrophoneStateMStart(oMStart.e8RequestState);
            if (_poCallbackIf) _poCallbackIf->onSetMicrophoneStateMStart(oMStart.e8RequestState);
            // vHandleSetMicrophoneStateOpMStart: user specific code start
            // vHandleSetMicrophoneStateOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleSetMicrophoneStateOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceRvc::onSetMicrophoneStateMStart(rvc_fi_tcl_e8_Set_MicState e8RequestState) {

   // onSetMicrophoneStateMStart: user specific code start
   (tVoid) e8RequestState;
   // onSetMicrophoneStateMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvc::sendSetMicrophoneStateMResult(tBool Result) {
   if (_oMemSetMicrophoneState.bIsPending() == TRUE) {
      rvc_ccafi_tclMsgSetMicrophoneStateMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemSetMicrophoneState.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemSetMicrophoneState.u16GetSourceAppID(), 
         _oMemSetMicrophoneState.u16GetRegisterID(), 
         _oMemSetMicrophoneState.u16GetCMDCounter(), 
         (tU16) RVC_CCAFI_C_U16_SETMICROPHONESTATE, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendSetMicrophoneStateMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", RVC_CCAFI_C_U16_SETMICROPHONESTATE, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceRvc::vHandleSetRVCStatusOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         rvc_ccafi_tclMsgSetRVCStatusMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, RVC_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tSetRVCStatus_e8RequestState = oMStart.e8RequestState;



            // Remember that we have to send an answer to this request
            _oMemSetRVCStatus.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onSetRVCStatusMStart(oMStart.e8RequestState);
            if (_poCallbackIf) _poCallbackIf->onSetRVCStatusMStart(oMStart.e8RequestState);
            // vHandleSetRVCStatusOpMStart: user specific code start
            // vHandleSetRVCStatusOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleSetRVCStatusOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceRvc::onSetRVCStatusMStart(tU8 e8RequestState) {

   // onSetRVCStatusMStart: user specific code start
   // onSetRVCStatusMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvc::sendSetRVCStatusMResult(tBool Result) {
   if (_oMemSetRVCStatus.bIsPending() == TRUE) {
      rvc_ccafi_tclMsgSetRVCStatusMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemSetRVCStatus.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemSetRVCStatus.u16GetSourceAppID(), 
         _oMemSetRVCStatus.u16GetRegisterID(), 
         _oMemSetRVCStatus.u16GetCMDCounter(), 
         (tU16) RVC_CCAFI_C_U16_SETRVCSTATUS, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendSetRVCStatusMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", RVC_CCAFI_C_U16_SETRVCSTATUS, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceRvc::vHandleCamera_SetupBeepOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         rvc_ccafi_tclMsgCamera_SetupBeepMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, RVC_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tCamera_SetupBeep_e8SetupBeep = oMStart.e8SetupBeep;



            // Remember that we have to send an answer to this request
            _oMemCamera_SetupBeep.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onCamera_SetupBeepMStart(oMStart.e8SetupBeep);
            if (_poCallbackIf) _poCallbackIf->onCamera_SetupBeepMStart(oMStart.e8SetupBeep);
            // vHandleCamera_SetupBeepOpMStart: user specific code start
            // vHandleCamera_SetupBeepOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleCamera_SetupBeepOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceRvc::onCamera_SetupBeepMStart(rvc_fi_tcl_e8_AVM_StatusBeep e8SetupBeep) {

   // onCamera_SetupBeepMStart: user specific code start
   (tVoid) e8SetupBeep;
   // onCamera_SetupBeepMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvc::sendCamera_SetupBeepMResult(rvc_fi_tcl_e8_AVM_StatusBeep e8StatusBeep) {
   if (_oMemCamera_SetupBeep.bIsPending() == TRUE) {
      rvc_ccafi_tclMsgCamera_SetupBeepMethodResult  oMResult;
      //the data content

      oMResult.e8StatusBeep = e8StatusBeep;


      _oMemCamera_SetupBeep.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemCamera_SetupBeep.u16GetSourceAppID(), 
         _oMemCamera_SetupBeep.u16GetRegisterID(), 
         _oMemCamera_SetupBeep.u16GetCMDCounter(), 
         (tU16) RVC_CCAFI_C_U16_CAMERA_SETUPBEEP, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendCamera_SetupBeepMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", RVC_CCAFI_C_U16_CAMERA_SETUPBEEP, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceRvc::vHandleSetCamerastateOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         rvc_ccafi_tclMsgSetCamerastateMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, RVC_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tSetCamerastate_CameraState = oMStart.CameraState;



            // Remember that we have to send an answer to this request
            _oMemSetCamerastate.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onSetCamerastateMStart(oMStart.CameraState);
            if (_poCallbackIf) _poCallbackIf->onSetCamerastateMStart(oMStart.CameraState);
            // vHandleSetCamerastateOpMStart: user specific code start
            // vHandleSetCamerastateOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleSetCamerastateOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceRvc::onSetCamerastateMStart(rvc_fi_tcl_e8_RVC_CameraState CameraState) {

   // onSetCamerastateMStart: user specific code start
   (tVoid) CameraState;
   // onSetCamerastateMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvc::sendSetCamerastateMResult(tBool Result) {
   if (_oMemSetCamerastate.bIsPending() == TRUE) {
      rvc_ccafi_tclMsgSetCamerastateMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemSetCamerastate.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemSetCamerastate.u16GetSourceAppID(), 
         _oMemSetCamerastate.u16GetRegisterID(), 
         _oMemSetCamerastate.u16GetCMDCounter(), 
         (tU16) RVC_CCAFI_C_U16_SETCAMERASTATE, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendSetCamerastateMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", RVC_CCAFI_C_U16_SETCAMERASTATE, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceRvc::vHandleChangeViewRequestOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         rvc_ccafi_tclMsgChangeViewRequestMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, RVC_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tChangeViewRequest_u8Status = oMStart.u8Status;



            // Remember that we have to send an answer to this request
            _oMemChangeViewRequest.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onChangeViewRequestMStart(oMStart.u8Status);
            if (_poCallbackIf) _poCallbackIf->onChangeViewRequestMStart(oMStart.u8Status);
            // vHandleChangeViewRequestOpMStart: user specific code start
            // vHandleChangeViewRequestOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleChangeViewRequestOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceRvc::onChangeViewRequestMStart(rvc_fi_tcl_e8_AVM_View_Request u8Status) {

   // onChangeViewRequestMStart: user specific code start
   (tVoid) u8Status;
   // onChangeViewRequestMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvc::sendChangeViewRequestMResult(tBool Result) {
   if (_oMemChangeViewRequest.bIsPending() == TRUE) {
      rvc_ccafi_tclMsgChangeViewRequestMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemChangeViewRequest.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemChangeViewRequest.u16GetSourceAppID(), 
         _oMemChangeViewRequest.u16GetRegisterID(), 
         _oMemChangeViewRequest.u16GetCMDCounter(), 
         (tU16) RVC_CCAFI_C_U16_CHANGEVIEWREQUEST, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendChangeViewRequestMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", RVC_CCAFI_C_U16_CHANGEVIEWREQUEST, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceRvc::vHandleAffordable_Its_SetupBswOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         rvc_ccafi_tclMsgAffordable_Its_SetupBswMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, RVC_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tAffordable_Its_SetupBsw_u8Status = oMStart.u8Status;



            // Remember that we have to send an answer to this request
            _oMemAffordable_Its_SetupBsw.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onAffordable_Its_SetupBswMStart(oMStart.u8Status);
            if (_poCallbackIf) _poCallbackIf->onAffordable_Its_SetupBswMStart(oMStart.u8Status);
            // vHandleAffordable_Its_SetupBswOpMStart: user specific code start
            // vHandleAffordable_Its_SetupBswOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleAffordable_Its_SetupBswOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceRvc::onAffordable_Its_SetupBswMStart(tU8 u8Status) {

   // onAffordable_Its_SetupBswMStart: user specific code start
   (tVoid) u8Status;
   // onAffordable_Its_SetupBswMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvc::sendAffordable_Its_SetupBswMResult(tBool Result) {
   if (_oMemAffordable_Its_SetupBsw.bIsPending() == TRUE) {
      rvc_ccafi_tclMsgAffordable_Its_SetupBswMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemAffordable_Its_SetupBsw.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemAffordable_Its_SetupBsw.u16GetSourceAppID(), 
         _oMemAffordable_Its_SetupBsw.u16GetRegisterID(), 
         _oMemAffordable_Its_SetupBsw.u16GetCMDCounter(), 
         (tU16) RVC_CCAFI_C_U16_AFFORDABLE_ITS_SETUPBSW, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendAffordable_Its_SetupBswMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", RVC_CCAFI_C_U16_AFFORDABLE_ITS_SETUPBSW, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceRvc::vHandleAffordable_Its_SetupModOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         rvc_ccafi_tclMsgAffordable_Its_SetupModMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, RVC_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tAffordable_Its_SetupMod_u8Status = oMStart.u8Status;



            // Remember that we have to send an answer to this request
            _oMemAffordable_Its_SetupMod.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onAffordable_Its_SetupModMStart(oMStart.u8Status);
            if (_poCallbackIf) _poCallbackIf->onAffordable_Its_SetupModMStart(oMStart.u8Status);
            // vHandleAffordable_Its_SetupModOpMStart: user specific code start
            // vHandleAffordable_Its_SetupModOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleAffordable_Its_SetupModOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceRvc::onAffordable_Its_SetupModMStart(tU8 u8Status) {

   // onAffordable_Its_SetupModMStart: user specific code start
   (tVoid) u8Status;
   // onAffordable_Its_SetupModMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvc::sendAffordable_Its_SetupModMResult(tBool Result) {
   if (_oMemAffordable_Its_SetupMod.bIsPending() == TRUE) {
      rvc_ccafi_tclMsgAffordable_Its_SetupModMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemAffordable_Its_SetupMod.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemAffordable_Its_SetupMod.u16GetSourceAppID(), 
         _oMemAffordable_Its_SetupMod.u16GetRegisterID(), 
         _oMemAffordable_Its_SetupMod.u16GetCMDCounter(), 
         (tU16) RVC_CCAFI_C_U16_AFFORDABLE_ITS_SETUPMOD, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendAffordable_Its_SetupModMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", RVC_CCAFI_C_U16_AFFORDABLE_ITS_SETUPMOD, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceRvc::vHandleAffordable_Its_SetupLdwOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         rvc_ccafi_tclMsgAffordable_Its_SetupLdwMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, RVC_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tAffordable_Its_SetupLdw_u8Status = oMStart.u8Status;



            // Remember that we have to send an answer to this request
            _oMemAffordable_Its_SetupLdw.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onAffordable_Its_SetupLdwMStart(oMStart.u8Status);
            if (_poCallbackIf) _poCallbackIf->onAffordable_Its_SetupLdwMStart(oMStart.u8Status);
            // vHandleAffordable_Its_SetupLdwOpMStart: user specific code start
            // vHandleAffordable_Its_SetupLdwOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleAffordable_Its_SetupLdwOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceRvc::onAffordable_Its_SetupLdwMStart(tU8 u8Status) {

   // onAffordable_Its_SetupLdwMStart: user specific code start
   (tVoid) u8Status;
   // onAffordable_Its_SetupLdwMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvc::sendAffordable_Its_SetupLdwMResult(tBool Result) {
   if (_oMemAffordable_Its_SetupLdw.bIsPending() == TRUE) {
      rvc_ccafi_tclMsgAffordable_Its_SetupLdwMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemAffordable_Its_SetupLdw.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemAffordable_Its_SetupLdw.u16GetSourceAppID(), 
         _oMemAffordable_Its_SetupLdw.u16GetRegisterID(), 
         _oMemAffordable_Its_SetupLdw.u16GetCMDCounter(), 
         (tU16) RVC_CCAFI_C_U16_AFFORDABLE_ITS_SETUPLDW, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendAffordable_Its_SetupLdwMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", RVC_CCAFI_C_U16_AFFORDABLE_ITS_SETUPLDW, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceRvc::vHandleIPA_SetHMIStatusOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         rvc_ccafi_tclMsgIPA_SetHMIStatusMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, RVC_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tIPA_SetHMIStatus_e8IPAStatus = oMStart.e8IPAStatus;



            // Remember that we have to send an answer to this request
            _oMemIPA_SetHMIStatus.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onIPA_SetHMIStatusMStart(oMStart.e8IPAStatus);
            if (_poCallbackIf) _poCallbackIf->onIPA_SetHMIStatusMStart(oMStart.e8IPAStatus);
            // vHandleIPA_SetHMIStatusOpMStart: user specific code start
            // vHandleIPA_SetHMIStatusOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleIPA_SetHMIStatusOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceRvc::onIPA_SetHMIStatusMStart(rvc_fi_tcl_e8_IPA_HMIStatus e8IPAStatus) {

   // onIPA_SetHMIStatusMStart: user specific code start
   (tVoid) e8IPAStatus;
   // onIPA_SetHMIStatusMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvc::sendIPA_SetHMIStatusMResult(tBool Result) {
   if (_oMemIPA_SetHMIStatus.bIsPending() == TRUE) {
      rvc_ccafi_tclMsgIPA_SetHMIStatusMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemIPA_SetHMIStatus.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemIPA_SetHMIStatus.u16GetSourceAppID(), 
         _oMemIPA_SetHMIStatus.u16GetRegisterID(), 
         _oMemIPA_SetHMIStatus.u16GetCMDCounter(), 
         (tU16) RVC_CCAFI_C_U16_IPA_SETHMISTATUS, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendIPA_SetHMIStatusMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", RVC_CCAFI_C_U16_IPA_SETHMISTATUS, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceRvc::vHandleIPA_SetButtonOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         rvc_ccafi_tclMsgIPA_SetButtonMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, RVC_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tIPA_SetButton_e8ButtonIdentifier = oMStart.e8ButtonIdentifier;
            _tIPA_SetButton_e8ButtonStatus = oMStart.e8ButtonStatus;



            // Remember that we have to send an answer to this request
            _oMemIPA_SetButton.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onIPA_SetButtonMStart(oMStart.e8ButtonIdentifier, oMStart.e8ButtonStatus);
            if (_poCallbackIf) _poCallbackIf->onIPA_SetButtonMStart(oMStart.e8ButtonIdentifier, oMStart.e8ButtonStatus);
            // vHandleIPA_SetButtonOpMStart: user specific code start
            // vHandleIPA_SetButtonOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleIPA_SetButtonOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceRvc::onIPA_SetButtonMStart(rvc_fi_tcl_e8_IPA_BUTTON_ID e8ButtonIdentifier, rvc_fi_tcl_e8_RVC_ButtonState e8ButtonStatus) {

   // onIPA_SetButtonMStart: user specific code start
   (tVoid) e8ButtonIdentifier;
   (tVoid) e8ButtonStatus;
   // onIPA_SetButtonMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvc::sendIPA_SetButtonMResult(tBool Result) {
   if (_oMemIPA_SetButton.bIsPending() == TRUE) {
      rvc_ccafi_tclMsgIPA_SetButtonMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemIPA_SetButton.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemIPA_SetButton.u16GetSourceAppID(), 
         _oMemIPA_SetButton.u16GetRegisterID(), 
         _oMemIPA_SetButton.u16GetCMDCounter(), 
         (tU16) RVC_CCAFI_C_U16_IPA_SETBUTTON, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendIPA_SetButtonMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", RVC_CCAFI_C_U16_IPA_SETBUTTON, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceRvc::vHandleIPA_Voice_TextsOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         rvc_ccafi_tclMsgIPA_Voice_TextsMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, RVC_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tIPA_Voice_Texts_Language = oMStart.Language;
            _tIPA_Voice_Texts_arTexts = oMStart.arTexts;



            // Remember that we have to send an answer to this request
            _oMemIPA_Voice_Texts.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onIPA_Voice_TextsMStart(oMStart.Language, oMStart.arTexts);
            if (_poCallbackIf) _poCallbackIf->onIPA_Voice_TextsMStart(oMStart.Language, oMStart.arTexts);
            // vHandleIPA_Voice_TextsOpMStart: user specific code start
            // vHandleIPA_Voice_TextsOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleIPA_Voice_TextsOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceRvc::onIPA_Voice_TextsMStart(rvc_fi_tcl_e8_RVC_Language Language, std::vector<rvc_fi_tcl_IPA_Voice_Text_Strings, std::allocator<rvc_fi_tcl_IPA_Voice_Text_Strings> > arTexts) {

   // onIPA_Voice_TextsMStart: user specific code start
   // onIPA_Voice_TextsMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvc::sendIPA_Voice_TextsMResult(tBool Result) {
   if (_oMemIPA_Voice_Texts.bIsPending() == TRUE) {
      rvc_ccafi_tclMsgIPA_Voice_TextsMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemIPA_Voice_Texts.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemIPA_Voice_Texts.u16GetSourceAppID(), 
         _oMemIPA_Voice_Texts.u16GetRegisterID(), 
         _oMemIPA_Voice_Texts.u16GetCMDCounter(), 
         (tU16) RVC_CCAFI_C_U16_IPA_VOICE_TEXTS, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendIPA_Voice_TextsMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", RVC_CCAFI_C_U16_IPA_VOICE_TEXTS, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceRvc::vHandleMVC_HMI_ViewRequestOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         rvc_ccafi_tclMsgMVC_HMI_ViewRequestMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, RVC_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tMVC_HMI_ViewRequest_e8Request = oMStart.e8Request;



            // Remember that we have to send an answer to this request
            _oMemMVC_HMI_ViewRequest.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onMVC_HMI_ViewRequestMStart(oMStart.e8Request);
            if (_poCallbackIf) _poCallbackIf->onMVC_HMI_ViewRequestMStart(oMStart.e8Request);
            // vHandleMVC_HMI_ViewRequestOpMStart: user specific code start
            // vHandleMVC_HMI_ViewRequestOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleMVC_HMI_ViewRequestOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceRvc::onMVC_HMI_ViewRequestMStart(rvc_fi_tcl_e8_MVCViewingState e8Request) {

   // onMVC_HMI_ViewRequestMStart: user specific code start
   // onMVC_HMI_ViewRequestMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvc::sendMVC_HMI_ViewRequestMResult(tBool Result) {
   if (_oMemMVC_HMI_ViewRequest.bIsPending() == TRUE) {
      rvc_ccafi_tclMsgMVC_HMI_ViewRequestMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemMVC_HMI_ViewRequest.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemMVC_HMI_ViewRequest.u16GetSourceAppID(), 
         _oMemMVC_HMI_ViewRequest.u16GetRegisterID(), 
         _oMemMVC_HMI_ViewRequest.u16GetCMDCounter(), 
         (tU16) RVC_CCAFI_C_U16_MVC_HMI_VIEWREQUEST, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendMVC_HMI_ViewRequestMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", RVC_CCAFI_C_U16_MVC_HMI_VIEWREQUEST, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceRvc::vHandleGdlAdj_AdjustmentCompleteOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         rvc_ccafi_tclMsgGdlAdj_AdjustmentCompleteMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, RVC_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tGdlAdj_AdjustmentComplete_e8Completion = oMStart.e8Completion;



            // Remember that we have to send an answer to this request
            _oMemGdlAdj_AdjustmentComplete.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onGdlAdj_AdjustmentCompleteMStart(oMStart.e8Completion);
            if (_poCallbackIf) _poCallbackIf->onGdlAdj_AdjustmentCompleteMStart(oMStart.e8Completion);
            // vHandleGdlAdj_AdjustmentCompleteOpMStart: user specific code start
            // vHandleGdlAdj_AdjustmentCompleteOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleGdlAdj_AdjustmentCompleteOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceRvc::onGdlAdj_AdjustmentCompleteMStart(rvc_fi_tcl_e8_GdlAdj_Completion e8Completion) {

   // onGdlAdj_AdjustmentCompleteMStart: user specific code start
   (tVoid) e8Completion;
   // onGdlAdj_AdjustmentCompleteMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvc::sendGdlAdj_AdjustmentCompleteMResult(tBool Result) {
   if (_oMemGdlAdj_AdjustmentComplete.bIsPending() == TRUE) {
      rvc_ccafi_tclMsgGdlAdj_AdjustmentCompleteMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemGdlAdj_AdjustmentComplete.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemGdlAdj_AdjustmentComplete.u16GetSourceAppID(), 
         _oMemGdlAdj_AdjustmentComplete.u16GetRegisterID(), 
         _oMemGdlAdj_AdjustmentComplete.u16GetCMDCounter(), 
         (tU16) RVC_CCAFI_C_U16_GDLADJ_ADJUSTMENTCOMPLETE, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendGdlAdj_AdjustmentCompleteMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", RVC_CCAFI_C_U16_GDLADJ_ADJUSTMENTCOMPLETE, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceRvc::vHandleGdlAdj_AdjustButtonOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         rvc_ccafi_tclMsgGdlAdj_AdjustButtonMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, RVC_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tGdlAdj_AdjustButton_e8Button = oMStart.e8Button;



            // Remember that we have to send an answer to this request
            _oMemGdlAdj_AdjustButton.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onGdlAdj_AdjustButtonMStart(oMStart.e8Button);
            if (_poCallbackIf) _poCallbackIf->onGdlAdj_AdjustButtonMStart(oMStart.e8Button);
            // vHandleGdlAdj_AdjustButtonOpMStart: user specific code start
            // vHandleGdlAdj_AdjustButtonOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleGdlAdj_AdjustButtonOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceRvc::onGdlAdj_AdjustButtonMStart(rvc_fi_tcl_e8_GdlAdj_AdjustButton e8Button) {

   // onGdlAdj_AdjustButtonMStart: user specific code start
   (tVoid) e8Button;
   // onGdlAdj_AdjustButtonMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvc::sendGdlAdj_AdjustButtonMResult(tBool Result) {
   if (_oMemGdlAdj_AdjustButton.bIsPending() == TRUE) {
      rvc_ccafi_tclMsgGdlAdj_AdjustButtonMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemGdlAdj_AdjustButton.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemGdlAdj_AdjustButton.u16GetSourceAppID(), 
         _oMemGdlAdj_AdjustButton.u16GetRegisterID(), 
         _oMemGdlAdj_AdjustButton.u16GetCMDCounter(), 
         (tU16) RVC_CCAFI_C_U16_GDLADJ_ADJUSTBUTTON, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendGdlAdj_AdjustButtonMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", RVC_CCAFI_C_U16_GDLADJ_ADJUSTBUTTON, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceRvc::vHandleGdlAdj_ConfigurationDataOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         rvc_ccafi_tclMsgGdlAdj_ConfigurationDataMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, RVC_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tGdlAdj_ConfigurationData_e8Request = oMStart.e8Request;
            _tGdlAdj_ConfigurationData_arConfigParameterData = oMStart.arConfigParameterData;



            // Remember that we have to send an answer to this request
            _oMemGdlAdj_ConfigurationData.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onGdlAdj_ConfigurationDataMStart(oMStart.e8Request, oMStart.arConfigParameterData);
            if (_poCallbackIf) _poCallbackIf->onGdlAdj_ConfigurationDataMStart(oMStart.e8Request, oMStart.arConfigParameterData);
            // vHandleGdlAdj_ConfigurationDataOpMStart: user specific code start
            // vHandleGdlAdj_ConfigurationDataOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleGdlAdj_ConfigurationDataOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceRvc::onGdlAdj_ConfigurationDataMStart(rvc_fi_tcl_e8_GdlAdj_Request e8Request, std::vector<rvc_fi_tcl_GdlAdj_ConfigParameterData, std::allocator<rvc_fi_tcl_GdlAdj_ConfigParameterData> > arConfigParameterData) {

   // onGdlAdj_ConfigurationDataMStart: user specific code start
   (tVoid) e8Request;
   (tVoid) arConfigParameterData;
   // onGdlAdj_ConfigurationDataMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvc::sendGdlAdj_ConfigurationDataMResult(tBool Result, rvc_fi_tcl_e8_GdlAdj_Request e8Request, std::vector<rvc_fi_tcl_GdlAdj_ConfigParameterData, std::allocator<rvc_fi_tcl_GdlAdj_ConfigParameterData> > arConfigParameterData) {
   if (_oMemGdlAdj_ConfigurationData.bIsPending() == TRUE) {
      rvc_ccafi_tclMsgGdlAdj_ConfigurationDataMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;
      oMResult.e8Request = e8Request;
      oMResult.arConfigParameterData = arConfigParameterData;


      _oMemGdlAdj_ConfigurationData.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemGdlAdj_ConfigurationData.u16GetSourceAppID(), 
         _oMemGdlAdj_ConfigurationData.u16GetRegisterID(), 
         _oMemGdlAdj_ConfigurationData.u16GetCMDCounter(), 
         (tU16) RVC_CCAFI_C_U16_GDLADJ_CONFIGURATIONDATA, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendGdlAdj_ConfigurationDataMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", RVC_CCAFI_C_U16_GDLADJ_CONFIGURATIONDATA, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceRvc::vHandleFAP_SetButtonOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         rvc_ccafi_tclMsgFAP_SetButtonMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, RVC_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tFAP_SetButton_e8ButtonIdentifier = oMStart.e8ButtonIdentifier;
            _tFAP_SetButton_e8ButtonStatus = oMStart.e8ButtonStatus;



            // Remember that we have to send an answer to this request
            _oMemFAP_SetButton.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onFAP_SetButtonMStart(oMStart.e8ButtonIdentifier, oMStart.e8ButtonStatus);
            if (_poCallbackIf) _poCallbackIf->onFAP_SetButtonMStart(oMStart.e8ButtonIdentifier, oMStart.e8ButtonStatus);
            // vHandleFAP_SetButtonOpMStart: user specific code start
            // vHandleFAP_SetButtonOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleFAP_SetButtonOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceRvc::onFAP_SetButtonMStart(rvc_fi_tcl_e8_IPA_BUTTON_ID e8ButtonIdentifier, rvc_fi_tcl_e8_RVC_ButtonState e8ButtonStatus) {

   // onFAP_SetButtonMStart: user specific code start
   // onFAP_SetButtonMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvc::sendFAP_SetButtonMResult(tBool Result) {
   if (_oMemFAP_SetButton.bIsPending() == TRUE) {
      rvc_ccafi_tclMsgFAP_SetButtonMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemFAP_SetButton.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemFAP_SetButton.u16GetSourceAppID(), 
         _oMemFAP_SetButton.u16GetRegisterID(), 
         _oMemFAP_SetButton.u16GetCMDCounter(), 
         (tU16) RVC_CCAFI_C_U16_FAP_SETBUTTON, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendFAP_SetButtonMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", RVC_CCAFI_C_U16_FAP_SETBUTTON, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceRvc::vHandleTouchEventOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         rvc_ccafi_tclMsgTouchEventMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, RVC_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tTouchEvent_arTouchData = oMStart.arTouchData;



            // Remember that we have to send an answer to this request
            _oMemTouchEvent.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onTouchEventMStart(oMStart.arTouchData);
            if (_poCallbackIf) _poCallbackIf->onTouchEventMStart(oMStart.arTouchData);
            // vHandleTouchEventOpMStart: user specific code start
            // vHandleTouchEventOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleTouchEventOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceRvc::onTouchEventMStart(rvc_fi_tcl_Touch_Data arTouchData) {

   // onTouchEventMStart: user specific code start
   // onTouchEventMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvc::sendTouchEventMResult(tBool Result) {
   if (_oMemTouchEvent.bIsPending() == TRUE) {
      rvc_ccafi_tclMsgTouchEventMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemTouchEvent.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemTouchEvent.u16GetSourceAppID(), 
         _oMemTouchEvent.u16GetRegisterID(), 
         _oMemTouchEvent.u16GetCMDCounter(), 
         (tU16) RVC_CCAFI_C_U16_TOUCHEVENT, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendTouchEventMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", RVC_CCAFI_C_U16_TOUCHEVENT, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceRvc::vHandleGPSInfoOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         rvc_ccafi_tclMsgGPSInfoMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, RVC_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tGPSInfo_arGpsData = oMStart.arGpsData;



            // Remember that we have to send an answer to this request
            _oMemGPSInfo.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onGPSInfoMStart(oMStart.arGpsData);
            if (_poCallbackIf) _poCallbackIf->onGPSInfoMStart(oMStart.arGpsData);
            // vHandleGPSInfoOpMStart: user specific code start
            // vHandleGPSInfoOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleGPSInfoOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceRvc::onGPSInfoMStart(rvc_fi_tcl_GPS_Data arGpsData) {

   // onGPSInfoMStart: user specific code start
   // onGPSInfoMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvc::sendGPSInfoMResult(tBool Result) {
   if (_oMemGPSInfo.bIsPending() == TRUE) {
      rvc_ccafi_tclMsgGPSInfoMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemGPSInfo.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemGPSInfo.u16GetSourceAppID(), 
         _oMemGPSInfo.u16GetRegisterID(), 
         _oMemGPSInfo.u16GetCMDCounter(), 
         (tU16) RVC_CCAFI_C_U16_GPSINFO, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendGPSInfoMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", RVC_CCAFI_C_U16_GPSINFO, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceRvc::vHandleMapMatchedInfoOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         rvc_ccafi_tclMsgMapMatchedInfoMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, RVC_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tMapMatchedInfo_arMapMatchedData = oMStart.arMapMatchedData;



            // Remember that we have to send an answer to this request
            _oMemMapMatchedInfo.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onMapMatchedInfoMStart(oMStart.arMapMatchedData);
            if (_poCallbackIf) _poCallbackIf->onMapMatchedInfoMStart(oMStart.arMapMatchedData);
            // vHandleMapMatchedInfoOpMStart: user specific code start
            // vHandleMapMatchedInfoOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleMapMatchedInfoOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceRvc::onMapMatchedInfoMStart(rvc_fi_tcl_MapMatched_Data arMapMatchedData) {

   // onMapMatchedInfoMStart: user specific code start
   // onMapMatchedInfoMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvc::sendMapMatchedInfoMResult(tBool Result) {
   if (_oMemMapMatchedInfo.bIsPending() == TRUE) {
      rvc_ccafi_tclMsgMapMatchedInfoMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemMapMatchedInfo.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemMapMatchedInfo.u16GetSourceAppID(), 
         _oMemMapMatchedInfo.u16GetRegisterID(), 
         _oMemMapMatchedInfo.u16GetCMDCounter(), 
         (tU16) RVC_CCAFI_C_U16_MAPMATCHEDINFO, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendMapMatchedInfoMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", RVC_CCAFI_C_U16_MAPMATCHEDINFO, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceRvc::vHandleFapLearnParkPositionOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         rvc_ccafi_tclMsgFapLearnParkPositionMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, RVC_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tFapLearnParkPosition_RequestOn = oMStart.RequestOn;



            // Remember that we have to send an answer to this request
            _oMemFapLearnParkPosition.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onFapLearnParkPositionMStart(oMStart.RequestOn);
            if (_poCallbackIf) _poCallbackIf->onFapLearnParkPositionMStart(oMStart.RequestOn);
            // vHandleFapLearnParkPositionOpMStart: user specific code start
            // vHandleFapLearnParkPositionOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleFapLearnParkPositionOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceRvc::onFapLearnParkPositionMStart(tBool RequestOn) {

   // onFapLearnParkPositionMStart: user specific code start
   // onFapLearnParkPositionMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvc::sendFapLearnParkPositionMResult(tBool Result) {
   if (_oMemFapLearnParkPosition.bIsPending() == TRUE) {
      rvc_ccafi_tclMsgFapLearnParkPositionMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemFapLearnParkPosition.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemFapLearnParkPosition.u16GetSourceAppID(), 
         _oMemFapLearnParkPosition.u16GetRegisterID(), 
         _oMemFapLearnParkPosition.u16GetCMDCounter(), 
         (tU16) RVC_CCAFI_C_U16_FAPLEARNPARKPOSITION, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendFapLearnParkPositionMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", RVC_CCAFI_C_U16_FAPLEARNPARKPOSITION, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceRvc::vHandleSetFapGuidanceOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         rvc_ccafi_tclMsgSetFapGuidanceMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, RVC_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tSetFapGuidance_Request = oMStart.Request;



            // Remember that we have to send an answer to this request
            _oMemSetFapGuidance.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onSetFapGuidanceMStart(oMStart.Request);
            if (_poCallbackIf) _poCallbackIf->onSetFapGuidanceMStart(oMStart.Request);
            // vHandleSetFapGuidanceOpMStart: user specific code start
            // vHandleSetFapGuidanceOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleSetFapGuidanceOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceRvc::onSetFapGuidanceMStart(tBool Request) {

   // onSetFapGuidanceMStart: user specific code start
   // onSetFapGuidanceMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvc::sendSetFapGuidanceMResult(tBool Result) {
   if (_oMemSetFapGuidance.bIsPending() == TRUE) {
      rvc_ccafi_tclMsgSetFapGuidanceMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemSetFapGuidance.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemSetFapGuidance.u16GetSourceAppID(), 
         _oMemSetFapGuidance.u16GetRegisterID(), 
         _oMemSetFapGuidance.u16GetCMDCounter(), 
         (tU16) RVC_CCAFI_C_U16_SETFAPGUIDANCE, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendSetFapGuidanceMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", RVC_CCAFI_C_U16_SETFAPGUIDANCE, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceRvc::vHandleAVM3_SetSwitchOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         rvc_ccafi_tclMsgAVM3_SetSwitchMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, RVC_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tAVM3_SetSwitch_e8SwitchId = oMStart.e8SwitchId;



            // Remember that we have to send an answer to this request
            _oMemAVM3_SetSwitch.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onAVM3_SetSwitchMStart(oMStart.e8SwitchId);
            if (_poCallbackIf) _poCallbackIf->onAVM3_SetSwitchMStart(oMStart.e8SwitchId);
            // vHandleAVM3_SetSwitchOpMStart: user specific code start
            // vHandleAVM3_SetSwitchOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleAVM3_SetSwitchOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceRvc::onAVM3_SetSwitchMStart(rvc_fi_tcl_e8_AVMph3_SwitchId e8SwitchId) {

   // onAVM3_SetSwitchMStart: user specific code start
   // onAVM3_SetSwitchMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvc::sendAVM3_SetSwitchMResult(tBool bResult) {
   if (_oMemAVM3_SetSwitch.bIsPending() == TRUE) {
      rvc_ccafi_tclMsgAVM3_SetSwitchMethodResult  oMResult;
      //the data content

      oMResult.bResult = bResult;


      _oMemAVM3_SetSwitch.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemAVM3_SetSwitch.u16GetSourceAppID(), 
         _oMemAVM3_SetSwitch.u16GetRegisterID(), 
         _oMemAVM3_SetSwitch.u16GetCMDCounter(), 
         (tU16) RVC_CCAFI_C_U16_AVM3_SETSWITCH, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendAVM3_SetSwitchMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", RVC_CCAFI_C_U16_AVM3_SETSWITCH, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceRvc::vHandleAVM3_SetSonarBuzzerStatusOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         rvc_ccafi_tclMsgAVM3_SetSonarBuzzerStatusMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, RVC_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tAVM3_SetSonarBuzzerStatus_e8BuzzerStatus = oMStart.e8BuzzerStatus;



            // Remember that we have to send an answer to this request
            _oMemAVM3_SetSonarBuzzerStatus.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onAVM3_SetSonarBuzzerStatusMStart(oMStart.e8BuzzerStatus);
            if (_poCallbackIf) _poCallbackIf->onAVM3_SetSonarBuzzerStatusMStart(oMStart.e8BuzzerStatus);
            // vHandleAVM3_SetSonarBuzzerStatusOpMStart: user specific code start
            // vHandleAVM3_SetSonarBuzzerStatusOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleAVM3_SetSonarBuzzerStatusOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceRvc::onAVM3_SetSonarBuzzerStatusMStart(rvc_fi_tcl_e8_AVMph3_BuzzerStatus e8BuzzerStatus) {

   // onAVM3_SetSonarBuzzerStatusMStart: user specific code start
   // onAVM3_SetSonarBuzzerStatusMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvc::sendAVM3_SetSonarBuzzerStatusMResult(tBool bResult) {
   if (_oMemAVM3_SetSonarBuzzerStatus.bIsPending() == TRUE) {
      rvc_ccafi_tclMsgAVM3_SetSonarBuzzerStatusMethodResult  oMResult;
      //the data content

      oMResult.bResult = bResult;


      _oMemAVM3_SetSonarBuzzerStatus.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemAVM3_SetSonarBuzzerStatus.u16GetSourceAppID(), 
         _oMemAVM3_SetSonarBuzzerStatus.u16GetRegisterID(), 
         _oMemAVM3_SetSonarBuzzerStatus.u16GetCMDCounter(), 
         (tU16) RVC_CCAFI_C_U16_AVM3_SETSONARBUZZERSTATUS, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendAVM3_SetSonarBuzzerStatusMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", RVC_CCAFI_C_U16_AVM3_SETSONARBUZZERSTATUS, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceRvc::vHandleAVM3_Settings_Detailed_SendReqOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         rvc_ccafi_tclMsgAVM3_Settings_Detailed_SendReqMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, RVC_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tAVM3_Settings_Detailed_SendReq_e8RequestType = oMStart.e8RequestType;
            _tAVM3_Settings_Detailed_SendReq_arChangedItems = oMStart.arChangedItems;



            // Remember that we have to send an answer to this request
            _oMemAVM3_Settings_Detailed_SendReq.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onAVM3_Settings_Detailed_SendReqMStart(oMStart.e8RequestType, oMStart.arChangedItems);
            if (_poCallbackIf) _poCallbackIf->onAVM3_Settings_Detailed_SendReqMStart(oMStart.e8RequestType, oMStart.arChangedItems);
            // vHandleAVM3_Settings_Detailed_SendReqOpMStart: user specific code start
            // vHandleAVM3_Settings_Detailed_SendReqOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleAVM3_Settings_Detailed_SendReqOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceRvc::onAVM3_Settings_Detailed_SendReqMStart(rvc_fi_tcl_e8_AVMph3_RequestType e8RequestType, std::vector<rvc_fi_tcl_AVMph3_Setting_Item, std::allocator<rvc_fi_tcl_AVMph3_Setting_Item> > arChangedItems) {

   // onAVM3_Settings_Detailed_SendReqMStart: user specific code start
   // onAVM3_Settings_Detailed_SendReqMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvc::sendAVM3_Settings_Detailed_SendReqMResult(tBool bResult) {
   if (_oMemAVM3_Settings_Detailed_SendReq.bIsPending() == TRUE) {
      rvc_ccafi_tclMsgAVM3_Settings_Detailed_SendReqMethodResult  oMResult;
      //the data content

      oMResult.bResult = bResult;


      _oMemAVM3_Settings_Detailed_SendReq.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemAVM3_Settings_Detailed_SendReq.u16GetSourceAppID(), 
         _oMemAVM3_Settings_Detailed_SendReq.u16GetRegisterID(), 
         _oMemAVM3_Settings_Detailed_SendReq.u16GetCMDCounter(), 
         (tU16) RVC_CCAFI_C_U16_AVM3_SETTINGS_DETAILED_SENDREQ, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendAVM3_Settings_Detailed_SendReqMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", RVC_CCAFI_C_U16_AVM3_SETTINGS_DETAILED_SENDREQ, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceRvc::vHandleAVM3_Settings_Primary_SendReqOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         rvc_ccafi_tclMsgAVM3_Settings_Primary_SendReqMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, RVC_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tAVM3_Settings_Primary_SendReq_e8RequestType = oMStart.e8RequestType;
            _tAVM3_Settings_Primary_SendReq_e8AvmSonarBuzzer = oMStart.e8AvmSonarBuzzer;
            _tAVM3_Settings_Primary_SendReq_bDetailsSettingsAvail = oMStart.bDetailsSettingsAvail;
            _tAVM3_Settings_Primary_SendReq_bImageQualitySettingAvail = oMStart.bImageQualitySettingAvail;



            // Remember that we have to send an answer to this request
            _oMemAVM3_Settings_Primary_SendReq.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onAVM3_Settings_Primary_SendReqMStart(oMStart.e8RequestType, oMStart.e8AvmSonarBuzzer, oMStart.bDetailsSettingsAvail, oMStart.bImageQualitySettingAvail);
            if (_poCallbackIf) _poCallbackIf->onAVM3_Settings_Primary_SendReqMStart(oMStart.e8RequestType, oMStart.e8AvmSonarBuzzer, oMStart.bDetailsSettingsAvail, oMStart.bImageQualitySettingAvail);
            // vHandleAVM3_Settings_Primary_SendReqOpMStart: user specific code start
            // vHandleAVM3_Settings_Primary_SendReqOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleAVM3_Settings_Primary_SendReqOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceRvc::onAVM3_Settings_Primary_SendReqMStart(rvc_fi_tcl_e8_AVMph3_RequestType e8RequestType, rvc_fi_tcl_e8_AVMph3_SettingOptionState e8AvmSonarBuzzer, tBool bDetailsSettingsAvail, tBool bImageQualitySettingAvail) {

   // onAVM3_Settings_Primary_SendReqMStart: user specific code start
   // onAVM3_Settings_Primary_SendReqMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvc::sendAVM3_Settings_Primary_SendReqMResult(tBool bResult) {
   if (_oMemAVM3_Settings_Primary_SendReq.bIsPending() == TRUE) {
      rvc_ccafi_tclMsgAVM3_Settings_Primary_SendReqMethodResult  oMResult;
      //the data content

      oMResult.bResult = bResult;


      _oMemAVM3_Settings_Primary_SendReq.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemAVM3_Settings_Primary_SendReq.u16GetSourceAppID(), 
         _oMemAVM3_Settings_Primary_SendReq.u16GetRegisterID(), 
         _oMemAVM3_Settings_Primary_SendReq.u16GetCMDCounter(), 
         (tU16) RVC_CCAFI_C_U16_AVM3_SETTINGS_PRIMARY_SENDREQ, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendAVM3_Settings_Primary_SendReqMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", RVC_CCAFI_C_U16_AVM3_SETTINGS_PRIMARY_SENDREQ, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceRvc::vHandleAVM3_GetVersionInfoOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         rvc_ccafi_tclMsgAVM3_GetVersionInfoMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, RVC_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tAVM3_GetVersionInfo_e8VersionType = oMStart.e8VersionType;



            // Remember that we have to send an answer to this request
            _oMemAVM3_GetVersionInfo.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onAVM3_GetVersionInfoMStart(oMStart.e8VersionType);
            if (_poCallbackIf) _poCallbackIf->onAVM3_GetVersionInfoMStart(oMStart.e8VersionType);
            // vHandleAVM3_GetVersionInfoOpMStart: user specific code start
            // vHandleAVM3_GetVersionInfoOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleAVM3_GetVersionInfoOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceRvc::onAVM3_GetVersionInfoMStart(rvc_fi_tcl_e8_AVMph3_VersionInfoType e8VersionType) {

   // onAVM3_GetVersionInfoMStart: user specific code start
   // onAVM3_GetVersionInfoMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvc::sendAVM3_GetVersionInfoMResult(tBool bResult) {
   if (_oMemAVM3_GetVersionInfo.bIsPending() == TRUE) {
      rvc_ccafi_tclMsgAVM3_GetVersionInfoMethodResult  oMResult;
      //the data content

      oMResult.bResult = bResult;


      _oMemAVM3_GetVersionInfo.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemAVM3_GetVersionInfo.u16GetSourceAppID(), 
         _oMemAVM3_GetVersionInfo.u16GetRegisterID(), 
         _oMemAVM3_GetVersionInfo.u16GetCMDCounter(), 
         (tU16) RVC_CCAFI_C_U16_AVM3_GETVERSIONINFO, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendAVM3_GetVersionInfoMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", RVC_CCAFI_C_U16_AVM3_GETVERSIONINFO, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceRvc::vHandleAVM3_GetCommunicationErrorsOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         rvc_ccafi_tclMsgAVM3_GetCommunicationErrorsMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, RVC_FI_MAJOR_VERSION) != OSAL_ERROR) {



            // Remember that we have to send an answer to this request
            _oMemAVM3_GetCommunicationErrors.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onAVM3_GetCommunicationErrorsMStart();
            if (_poCallbackIf) _poCallbackIf->onAVM3_GetCommunicationErrorsMStart();
            // vHandleAVM3_GetCommunicationErrorsOpMStart: user specific code start
            // vHandleAVM3_GetCommunicationErrorsOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleAVM3_GetCommunicationErrorsOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceRvc::onAVM3_GetCommunicationErrorsMStart() {

   // onAVM3_GetCommunicationErrorsMStart: user specific code start
   // onAVM3_GetCommunicationErrorsMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvc::sendAVM3_GetCommunicationErrorsMResult(tBool bResult) {
   if (_oMemAVM3_GetCommunicationErrors.bIsPending() == TRUE) {
      rvc_ccafi_tclMsgAVM3_GetCommunicationErrorsMethodResult  oMResult;
      //the data content

      oMResult.bResult = bResult;


      _oMemAVM3_GetCommunicationErrors.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemAVM3_GetCommunicationErrors.u16GetSourceAppID(), 
         _oMemAVM3_GetCommunicationErrors.u16GetRegisterID(), 
         _oMemAVM3_GetCommunicationErrors.u16GetCMDCounter(), 
         (tU16) RVC_CCAFI_C_U16_AVM3_GETCOMMUNICATIONERRORS, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendAVM3_GetCommunicationErrorsMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", RVC_CCAFI_C_U16_AVM3_GETCOMMUNICATIONERRORS, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceRvc::vHandleAVM3_ClearCommunicationErrorsOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         rvc_ccafi_tclMsgAVM3_ClearCommunicationErrorsMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, RVC_FI_MAJOR_VERSION) != OSAL_ERROR) {



            // Remember that we have to send an answer to this request
            _oMemAVM3_ClearCommunicationErrors.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onAVM3_ClearCommunicationErrorsMStart();
            if (_poCallbackIf) _poCallbackIf->onAVM3_ClearCommunicationErrorsMStart();
            // vHandleAVM3_ClearCommunicationErrorsOpMStart: user specific code start
            // vHandleAVM3_ClearCommunicationErrorsOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleAVM3_ClearCommunicationErrorsOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceRvc::onAVM3_ClearCommunicationErrorsMStart() {

   // onAVM3_ClearCommunicationErrorsMStart: user specific code start
   // onAVM3_ClearCommunicationErrorsMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvc::sendAVM3_ClearCommunicationErrorsMResult(tBool bResult) {
   if (_oMemAVM3_ClearCommunicationErrors.bIsPending() == TRUE) {
      rvc_ccafi_tclMsgAVM3_ClearCommunicationErrorsMethodResult  oMResult;
      //the data content

      oMResult.bResult = bResult;


      _oMemAVM3_ClearCommunicationErrors.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemAVM3_ClearCommunicationErrors.u16GetSourceAppID(), 
         _oMemAVM3_ClearCommunicationErrors.u16GetRegisterID(), 
         _oMemAVM3_ClearCommunicationErrors.u16GetCMDCounter(), 
         (tU16) RVC_CCAFI_C_U16_AVM3_CLEARCOMMUNICATIONERRORS, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendAVM3_ClearCommunicationErrorsMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", RVC_CCAFI_C_U16_AVM3_CLEARCOMMUNICATIONERRORS, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid dispvidctrl_tclServiceRvc::vHandleToggleGpioPinOnOffOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         rvc_ccafi_tclMsgToggleGpioPinOnOffMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, RVC_FI_MAJOR_VERSION) != OSAL_ERROR) {



            // Remember that we have to send an answer to this request
            _oMemToggleGpioPinOnOff.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onToggleGpioPinOnOffMStart();
            if (_poCallbackIf) _poCallbackIf->onToggleGpioPinOnOffMStart();
            // vHandleToggleGpioPinOnOffOpMStart: user specific code start
            // vHandleToggleGpioPinOnOffOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleToggleGpioPinOnOffOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclServiceRvc::onToggleGpioPinOnOffMStart() {

   // onToggleGpioPinOnOffMStart: user specific code start
   // onToggleGpioPinOnOffMStart: user specific code end
}
tVoid dispvidctrl_tclServiceRvc::sendToggleGpioPinOnOffMResult() {
   if (_oMemToggleGpioPinOnOff.bIsPending() == TRUE) {
      rvc_ccafi_tclMsgToggleGpioPinOnOffMethodResult  oMResult;
      //the data content



      _oMemToggleGpioPinOnOff.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemToggleGpioPinOnOff.u16GetSourceAppID(), 
         _oMemToggleGpioPinOnOff.u16GetRegisterID(), 
         _oMemToggleGpioPinOnOff.u16GetCMDCounter(), 
         (tU16) RVC_CCAFI_C_U16_TOGGLEGPIOPINONOFF, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendToggleGpioPinOnOffMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", RVC_CCAFI_C_U16_TOGGLEGPIOPINONOFF, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}




// dispvidctrl_tclServiceRvcdispvidctrl_ServiceRvc: user specific code start
/******************************************************************************/
/* FUNCTION     vGetConfiguration                                             */
/******************************************************************************/
/**
*  \brief       Function to get all configuration values needed by this class.
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclServiceRvc::vGetConfiguration(const TConfiguration* pStConfigurationValues)
{
   ETG_TRACE_USR4(("dispvidctrl_tclServiceRvc::vGetConfiguration() entered."));

   if (pStConfigurationValues->bRvcMode) {
       if (pStConfigurationValues->bRvcType_Renault) {
         _tSystemConfigurations_e8CameraSystem.enType = rvc_fi_tcl_e8_RVC_Camera_System_Type::FI_EN_RVC_RENAULT;
       } else {
         _tSystemConfigurations_e8CameraSystem.enType = rvc_fi_tcl_e8_RVC_Camera_System_Type::FI_EN_RVC;
       }
   }
   else if (pStConfigurationValues->bAvmMode) {
      if (pStConfigurationValues->bAvmType_Entry)
      {
          if (pStConfigurationValues->bAvmType_Renault) {
            _tSystemConfigurations_e8CameraSystem.enType = rvc_fi_tcl_e8_RVC_Camera_System_Type::FI_EN_AVM_ENTRY_RENAULT;
          } else {
            _tSystemConfigurations_e8CameraSystem.enType = rvc_fi_tcl_e8_RVC_Camera_System_Type::FI_EN_AVM_ENTRY;
          }
      }
      else if (pStConfigurationValues->bAvmType_Ipa)
      {
         _tSystemConfigurations_e8CameraSystem.enType = rvc_fi_tcl_e8_RVC_Camera_System_Type::FI_EN_AVM_IPA;
      }
      else if (pStConfigurationValues->bAvmType_Phase3)
      {
         // eis2hi: Currently, we never get here even if AVM phase3 is configured, because as of now, the old (VCAN) AVM and new (MCAN) AVMph3 appl implementations
         // can only co-exist peacefully if pStConfigurationValues->bAvmMode==FALSE (but pStConfigurationValues->bAvmType_Phase3==TRUE) in the AVM phase3 case.
         // To inform HMI correctly about a configured AVM phase3 nonetheless, see the comment on the workaround a few lines further downfurther down.
         _tSystemConfigurations_e8CameraSystem.enType = rvc_fi_tcl_e8_RVC_Camera_System_Type::FI_EN_AVM_PHASE3;
      }
      else if (pStConfigurationValues->bAvmType_Fap)
      {
         _tSystemConfigurations_e8CameraSystem.enType = rvc_fi_tcl_e8_RVC_Camera_System_Type::FI_EN_AVM_FAP;
      }
      else
      {
         _tSystemConfigurations_e8CameraSystem.enType = rvc_fi_tcl_e8_RVC_Camera_System_Type::FI_EN_AVM_HIGH;
      }
   }
   else if (pStConfigurationValues->bMvcMode) {
       _tSystemConfigurations_e8CameraSystem.enType = rvc_fi_tcl_e8_RVC_Camera_System_Type::FI_EN_MVC;
   }
   else if ( (!pStConfigurationValues->bRvcMode && !pStConfigurationValues->bAvmMode && !pStConfigurationValues->bMvcMode) && pStConfigurationValues->bAvmType_Phase3 ) {
         // eis2hi: WORKAROUND (read the comment on "else if (pStConfigurationValues->bAvmType_Phase3)" a few lines further up first)
         // The conditions above reflect what we currently end up with if we configure an AVM phase3, so that we can inform HMI correctly.
         // Once the appl AVM/AVM3 implementation has been adapted so that old (VCAN) AVM and new (MCAN) AVMph3 appl implementations
         // don't interfere anymore if pStConfigurationValues->bAvmMode==TRUE, we can finally set pStConfigurationValues->bAvmMode to TRUE for AVMph3 as well
         // in dispvidctrl_tclAppMain::_vDetermineConfiguration(), and then this "if else" branch can be safely removed again, as well as the according comment
         // inside the "else if (pStConfigurationValues->bAvmType_Phase3)" branch further up.
         _tSystemConfigurations_e8CameraSystem.enType = rvc_fi_tcl_e8_RVC_Camera_System_Type::FI_EN_AVM_PHASE3;
   }
   else {
   }

//todo: Check if we have Static Guidelines config item as well ?
   if (pStConfigurationValues->bAnticipatoryLine)
   {
      // Considered as both Static and Dynamic Guidelines are available
      _tSystemConfigurations_u8RVCGuideLine = 2;
   }
   else
   {
      _tSystemConfigurations_u8RVCGuideLine = 1; // Only Static Guidelines Available
   }

   _tSystemConfigurations_u8Brightness = pStConfigurationValues->u8BrightnessDay;
}

// dispvidctrl_tclServiceRvcdispvidctrl_ServiceRvc: user specific code end

//EOF
