/*****************************************************************************
* FILE:         dispvidctrl_AppMain_trace.cpp        
* PROJECT:      G3G project
* SW-COMPONENT: dispvidctrl
* Template:     applMain_trace.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end
*
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2018 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/


#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

#include "dispvidctrl_AppMain.h"


// dispvidctrl_AppMain_traceInclude: user specific code start
#include "I_dispvidctrl_ServiceRvcIf.h"
#include "I_dispvidctrl_ProfileManager.h"
// dispvidctrl_AppMain_traceInclude: user specific code end


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DISPVIDCTRL_APPLICATION
#include "trcGenProj/Header/dispvidctrl_AppMain_trace.cpp.trc.h"
#endif

tVoid dispvidctrl_tclAppMain::vHandleTraceMessage(const tUChar* puchData) {
    tU32 u32MsgCode = (puchData[1]<<8) | puchData[2];
    
    ETG_TRACE_USR1(("dispvidctrl_tclAppMain::vHandleTraceMessage(): process command: %d.", u32MsgCode));
    
    switch (u32MsgCode) {

    case DISPVIDCTRL_DISPVIDCTRL_CMDHELP:
        {

            etg_vTraceBinary(((0xFFFFu & (etg_tU16)(TR_CLASS_DISPVIDCTRL_APPLICATION)) << 16) | (etg_tU16)(TR_LEVEL_FATAL) , 0, 0, 2/* one ETG_EN_T16 only */, 0x3000 );
            etg_vTraceBinary(((0xFFFFu & (etg_tU16)(TR_CLASS_DISPVIDCTRL_APPLICATION)) << 16) | (etg_tU16)(TR_LEVEL_FATAL) , 0, 0, 2/* one ETG_EN_T16 only */, 0x3001 );
            etg_vTraceBinary(((0xFFFFu & (etg_tU16)(TR_CLASS_DISPVIDCTRL_APPLICATION)) << 16) | (etg_tU16)(TR_LEVEL_FATAL) , 0, 0, 2/* one ETG_EN_T16 only */, 0x3002 );
            etg_vTraceBinary(((0xFFFFu & (etg_tU16)(TR_CLASS_DISPVIDCTRL_APPLICATION)) << 16) | (etg_tU16)(TR_LEVEL_FATAL) , 0, 0, 2/* one ETG_EN_T16 only */, 0x3003 );
            etg_vTraceBinary(((0xFFFFu & (etg_tU16)(TR_CLASS_DISPVIDCTRL_APPLICATION)) << 16) | (etg_tU16)(TR_LEVEL_FATAL) , 0, 0, 2/* one ETG_EN_T16 only */, 0x3004 );
            etg_vTraceBinary(((0xFFFFu & (etg_tU16)(TR_CLASS_DISPVIDCTRL_APPLICATION)) << 16) | (etg_tU16)(TR_LEVEL_FATAL) , 0, 0, 2/* one ETG_EN_T16 only */, 0x3005 );
            etg_vTraceBinary(((0xFFFFu & (etg_tU16)(TR_CLASS_DISPVIDCTRL_APPLICATION)) << 16) | (etg_tU16)(TR_LEVEL_FATAL) , 0, 0, 2/* one ETG_EN_T16 only */, 0x3006 );
            etg_vTraceBinary(((0xFFFFu & (etg_tU16)(TR_CLASS_DISPVIDCTRL_APPLICATION)) << 16) | (etg_tU16)(TR_LEVEL_FATAL) , 0, 0, 2/* one ETG_EN_T16 only */, 0x3007 );

        }
        break;
#ifndef _CCA_APPLICATION_WO_SERVICE
    case DISPVIDCTRL_DISPVIDCTRL_POSTBROADCASTCMD:
        {
            // Post an internal message to all application object handler.
            tU16 param1 = (tU16)(((tU16)puchData[3]<<8) | (tU16)puchData[4]);

            dispvidctrl_tclBaseIf::TMsg oMsg;
            (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
            oMsg.eCmd = (dispvidctrl_tclBaseIf::ECmdTypes)param1;
            oMsg.strClassName[0]=0;
            oMsg.u.u32Data = 0;

            // DISPVIDCTRL_PostBroadcastCmd: user specific code start
            // DISPVIDCTRL_PostBroadcastCmd: user specific code end
            _poMainAppInstance->vPostInternalMessage(&oMsg);            
        }
        break;

    case DISPVIDCTRL_DISPVIDCTRL_POSTBROADCASTCMDPARAM:
        {
            // Post an internal message with parameter to all application object handler.
            tU16 param1 = (tU16)(((tU16)puchData[3]<<8) | (tU16)puchData[4]);
            tU32 param2 = (tU32)(((tU32)puchData[5]<<24) | ((tU32)puchData[6]<<16) | ((tU32)puchData[7] << 8) | (tU32)puchData[8]);

            dispvidctrl_tclBaseIf::TMsg oMsg;
            (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
            oMsg.eCmd = (dispvidctrl_tclBaseIf::ECmdTypes)param1;
            oMsg.strClassName[0]=0;
            oMsg.u.u32Data = param2;

            // DISPVIDCTRL_PostBroadcastCmdParam: user specific code start
            // DISPVIDCTRL_PostBroadcastCmdParam: user specific code end
            _poMainAppInstance->vPostInternalMessage(&oMsg);            
        }
        break;

    case DISPVIDCTRL_DISPVIDCTRL_POSTCMDTOCLASS:
        {
            // Post an internal message with parameter to a specific application object handler.
            tU16 param1 = (tU16)(((tU16)puchData[3]<<8) | (tU16)puchData[4]);
            tU32 param2 = (tU32)(((tU32)puchData[5]<<24) | ((tU32)puchData[6]<<16) | ((tU32)puchData[7] << 8) | (tU32)puchData[8]);
            const tChar* pString3 = (const tChar*)&puchData[9];

            dispvidctrl_tclBaseIf::TMsg oMsg;
            (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
            oMsg.eCmd = (dispvidctrl_tclBaseIf::ECmdTypes)param1;
            OSAL_szStringNCopy(oMsg.strClassName, pString3, sizeof(oMsg.strClassName)-1);
            oMsg.u.u32Data = param2;
            // DISPVIDCTRL_PostCmdToClass: user specific code start
            // DISPVIDCTRL_PostCmdToClass: user specific code end
            _poMainAppInstance->vPostInternalMessage(&oMsg);            
        }
        break;
#endif
    case DISPVIDCTRL_DISPVIDCTRL_TRACEINFO:
        {
            // Printout information of an object of the given interface name. Set interface name tp '\\0' every information is shown.
            const tChar* pString1 = (const tChar*)&puchData[3];
    
            // VDDIMMING_VDDIM_TRACEINFO: user specific code start
            // VDDIMMING_VDDIM_TRACEINFO: user specific code end
            std::set<dispvidctrl_tclBaseIf*>::iterator iter;
            for (iter = _poMainAppInstance->_oObjList.begin(); iter != _poMainAppInstance->_oObjList.end(); iter++) {
               // then check for specific implementation
               if (pString1[0] != 0) 
               {
                  if (0 == OSAL_s32StringCompare((*iter)->getIfName(), pString1)) {
                     (*iter)->vTraceInfo();
                  }
               } else {
                  (*iter)->vTraceInfo();
               }
            }
            
        }
        break;


    case DISPVIDCTRL_DISPVIDCTRL_STARTUPINVESTIGATION:
        {
            // Trace all logged startup traces.
    

            // DISPVIDCTRL_DISPVIDCTRL_STARTUPINVESTIGATION: user specific code start
            TMapStartupInvest::iterator iter;
            for (iter = _poMainAppInstance->_oStartupInvestMap.begin(); iter != _poMainAppInstance->_oStartupInvestMap.end(); iter++) {
                if (iter->u32Data != 0xffffffff) {
                    ETG_TRACE_FATAL(("[%08d]: %80s --> duration: %dms", iter->u32TimeStamp, iter->strInfo.c_str(), iter->u32Data));
                } else {
                    ETG_TRACE_FATAL(("[%08d]: %s", iter->u32TimeStamp, iter->strInfo.c_str()));
                }
            }
            // DISPVIDCTRL_DISPVIDCTRL_STARTUPINVESTIGATION: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_STIMULATE_CONTROL:
        {
            // Stimulate tclControl, Parameter = control name and u32Data value
            tU8 param1 = puchData[3];
            tU32 param2 = ((tU32)puchData[4] << 24) | ((tU32)puchData[5] << 16) | ((tU32)puchData[6] <<  8) | (tU32)puchData[7];
    

            // DISPVIDCTRL_DISPVIDCTRL_STIMULATE_CONTROL: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param2);
            // DISPVIDCTRL_DISPVIDCTRL_STIMULATE_CONTROL: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_STIMULATE_CONTROL_AVM:
        {
            // Stimulate tclControl_Avm, Parameter = control name and u32Data value
            tU8 param1 = puchData[3];
            tU32 param2 = ((tU32)puchData[4] << 24) | ((tU32)puchData[5] << 16) | ((tU32)puchData[6] <<  8) | (tU32)puchData[7];
    

            // DISPVIDCTRL_DISPVIDCTRL_STIMULATE_CONTROL_AVM: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param2);
            // DISPVIDCTRL_DISPVIDCTRL_STIMULATE_CONTROL_AVM: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_STIMULATE_CONTROL_HMI:
        {
            // Stimulate tclControl_Hmi, Parameter = control name and u32Data value
            tU8 param1 = puchData[3];
            tU32 param2 = ((tU32)puchData[4] << 24) | ((tU32)puchData[5] << 16) | ((tU32)puchData[6] <<  8) | (tU32)puchData[7];
    

            // DISPVIDCTRL_DISPVIDCTRL_STIMULATE_CONTROL_HMI: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param2);
            // DISPVIDCTRL_DISPVIDCTRL_STIMULATE_CONTROL_HMI: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_STIMULATE_CONTROL_RVC:
        {
            // Stimulate tclControl_Rvc, Parameter = control name and u32Data value
            tU8 param1 = puchData[3];
            tU32 param2 = ((tU32)puchData[4] << 24) | ((tU32)puchData[5] << 16) | ((tU32)puchData[6] <<  8) | (tU32)puchData[7];
    

            // DISPVIDCTRL_DISPVIDCTRL_STIMULATE_CONTROL_RVC: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param2);
            // DISPVIDCTRL_DISPVIDCTRL_STIMULATE_CONTROL_RVC: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_STIMULATE_CONTROL_VIDEO:
        {
            // Stimulate tclControl_Video, Parameter = control name and u32Data value
            tU8 param1 = puchData[3];
            tU32 param2 = ((tU32)puchData[4] << 24) | ((tU32)puchData[5] << 16) | ((tU32)puchData[6] <<  8) | (tU32)puchData[7];
    

            // DISPVIDCTRL_DISPVIDCTRL_STIMULATE_CONTROL_VIDEO: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param2);
            // DISPVIDCTRL_DISPVIDCTRL_STIMULATE_CONTROL_VIDEO: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_STIMULATE_CONTROL_HMIAVM3:
        {
            // Stimulate tclControl_HmiAvm3, Parameter = control name and u32Data value
            tU8 param1 = puchData[3];
            tU32 param2 = ((tU32)puchData[4] << 24) | ((tU32)puchData[5] << 16) | ((tU32)puchData[6] <<  8) | (tU32)puchData[7];
    

            // DISPVIDCTRL_DISPVIDCTRL_STIMULATE_CONTROL_HMIAVM3: user specific code start
            // DISPVIDCTRL_DISPVIDCTRL_STIMULATE_CONTROL_HMIAVM3: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_STIMULATE_FSM_AVM:
        {
            // Stimulate FSM Avm, Parameter = trigger
            tU32 param1 = ((tU32)puchData[3] << 24) | ((tU32)puchData[4] << 16) | ((tU32)puchData[5] <<  8) | (tU32)puchData[6];
    

            // DISPVIDCTRL_DISPVIDCTRL_STIMULATE_FSM_AVM: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            // DISPVIDCTRL_DISPVIDCTRL_STIMULATE_FSM_AVM: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_STIMULATE_FSM_HMI:
        {
            // Stimulate FSM Hmi, Parameter = trigger
            tU32 param1 = ((tU32)puchData[3] << 24) | ((tU32)puchData[4] << 16) | ((tU32)puchData[5] <<  8) | (tU32)puchData[6];
    

            // DISPVIDCTRL_DISPVIDCTRL_STIMULATE_FSM_HMI: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            // DISPVIDCTRL_DISPVIDCTRL_STIMULATE_FSM_HMI: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_STIMULATE_FSM_CAMERASUPPLY:
        {
            // Stimulate FSM CameraSupply, Parameter = trigger
            tU32 param1 = ((tU32)puchData[3] << 24) | ((tU32)puchData[4] << 16) | ((tU32)puchData[5] <<  8) | (tU32)puchData[6];
    

            // DISPVIDCTRL_DISPVIDCTRL_STIMULATE_FSM_CAMERASUPPLY: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            // DISPVIDCTRL_DISPVIDCTRL_STIMULATE_FSM_CAMERASUPPLY: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_STIMULATE_FSM_CAMERASUPPLYSUPERVISION:
        {
            // Stimulate FSM CameraSupplySupervision, Parameter = trigger
            tU32 param1 = ((tU32)puchData[3] << 24) | ((tU32)puchData[4] << 16) | ((tU32)puchData[5] <<  8) | (tU32)puchData[6];
    

            // DISPVIDCTRL_DISPVIDCTRL_STIMULATE_FSM_CAMERASUPPLYSUPERVISION: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            // DISPVIDCTRL_DISPVIDCTRL_STIMULATE_FSM_CAMERASUPPLYSUPERVISION: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_STIMULATE_FSM_ONOFF:
        {
            // Stimulate FSM OnOff, Parameter = trigger
            tU32 param1 = ((tU32)puchData[3] << 24) | ((tU32)puchData[4] << 16) | ((tU32)puchData[5] <<  8) | (tU32)puchData[6];
    

            // DISPVIDCTRL_DISPVIDCTRL_STIMULATE_FSM_ONOFF: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            // DISPVIDCTRL_DISPVIDCTRL_STIMULATE_FSM_ONOFF: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_STIMULATE_FSM_REVERSESIGNAL:
        {
            // Stimulate FSM ReverseSignal, Parameter = trigger
            tU32 param1 = ((tU32)puchData[3] << 24) | ((tU32)puchData[4] << 16) | ((tU32)puchData[5] <<  8) | (tU32)puchData[6];
    

            // DISPVIDCTRL_DISPVIDCTRL_STIMULATE_FSM_REVERSESIGNAL: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            // DISPVIDCTRL_DISPVIDCTRL_STIMULATE_FSM_REVERSESIGNAL: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_STIMULATE_FSM_HMIAVM3:
        {
            // Stimulate FSM HmiAvm3, Parameter = trigger
            tU32 param1 = ((tU32)puchData[3] << 24) | ((tU32)puchData[4] << 16) | ((tU32)puchData[5] <<  8) | (tU32)puchData[6];
    

            // DISPVIDCTRL_DISPVIDCTRL_STIMULATE_FSM_HMIAVM3: user specific code start
            // DISPVIDCTRL_DISPVIDCTRL_STIMULATE_FSM_HMIAVM3: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_STIMULATE_FSMOUT_AVM:
        {
            // Stimulate FSM Out Event for FSM Avm, Parameter = event, data
            tU8 param1 = puchData[3];
            tU32 param2 = ((tU32)puchData[4] << 24) | ((tU32)puchData[5] << 16) | ((tU32)puchData[6] <<  8) | (tU32)puchData[7];
    

            // DISPVIDCTRL_DISPVIDCTRL_STIMULATE_FSMOUT_AVM: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param2);
            // DISPVIDCTRL_DISPVIDCTRL_STIMULATE_FSMOUT_AVM: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_STIMULATE_FSMOUT_HMI:
        {
            // Stimulate FSM Out Event for FSM Hmi, Parameter = event, data
            tU8 param1 = puchData[3];
            tU32 param2 = ((tU32)puchData[4] << 24) | ((tU32)puchData[5] << 16) | ((tU32)puchData[6] <<  8) | (tU32)puchData[7];
    

            // DISPVIDCTRL_DISPVIDCTRL_STIMULATE_FSMOUT_HMI: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param2);
            // DISPVIDCTRL_DISPVIDCTRL_STIMULATE_FSMOUT_HMI: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_STIMULATE_FSMOUT_CAMERASUPPLY:
        {
            // Stimulate FSM Out Event for FSM CameraSupply, Parameter = event, data
            tU8 param1 = puchData[3];
            tU32 param2 = ((tU32)puchData[4] << 24) | ((tU32)puchData[5] << 16) | ((tU32)puchData[6] <<  8) | (tU32)puchData[7];
    

            // DISPVIDCTRL_DISPVIDCTRL_STIMULATE_FSMOUT_CAMERASUPPLY: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param2);
            // DISPVIDCTRL_DISPVIDCTRL_STIMULATE_FSMOUT_CAMERASUPPLY: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_STIMULATE_FSMOUT_CAMERASUPPLYSUPERVISION:
        {
            // Stimulate FSM Out Event for FSM CameraSupplySupervision, Parameter = event, data
            tU8 param1 = puchData[3];
            tU32 param2 = ((tU32)puchData[4] << 24) | ((tU32)puchData[5] << 16) | ((tU32)puchData[6] <<  8) | (tU32)puchData[7];
    

            // DISPVIDCTRL_DISPVIDCTRL_STIMULATE_FSMOUT_CAMERASUPPLYSUPERVISION: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param2);
            // DISPVIDCTRL_DISPVIDCTRL_STIMULATE_FSMOUT_CAMERASUPPLYSUPERVISION: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_STIMULATE_FSMOUT_ONOFF:
        {
            // Stimulate FSM Out Event for FSM OnOff, Parameter = event, data
            tU8 param1 = puchData[3];
            tU32 param2 = ((tU32)puchData[4] << 24) | ((tU32)puchData[5] << 16) | ((tU32)puchData[6] <<  8) | (tU32)puchData[7];
    

            // DISPVIDCTRL_DISPVIDCTRL_STIMULATE_FSMOUT_ONOFF: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param2);
            // DISPVIDCTRL_DISPVIDCTRL_STIMULATE_FSMOUT_ONOFF: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_STIMULATE_FSMOUT_REVERSESIGNAL:
        {
            // Stimulate FSM Out Event for FSM ReverseSignal, Parameter = event, data
            tU8 param1 = puchData[3];
            tU32 param2 = ((tU32)puchData[4] << 24) | ((tU32)puchData[5] << 16) | ((tU32)puchData[6] <<  8) | (tU32)puchData[7];
    

            // DISPVIDCTRL_DISPVIDCTRL_STIMULATE_FSMOUT_REVERSESIGNAL: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param2);
            // DISPVIDCTRL_DISPVIDCTRL_STIMULATE_FSMOUT_REVERSESIGNAL: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_STIMULATE_FSMOUT_HMIAVM3:
        {
            // Stimulate FSM Out Event for FSM HmiAvm3, Parameter = event, data
            tU8 param1 = puchData[3];
            tU32 param2 = ((tU32)puchData[4] << 24) | ((tU32)puchData[5] << 16) | ((tU32)puchData[6] <<  8) | (tU32)puchData[7];
    

            // DISPVIDCTRL_DISPVIDCTRL_STIMULATE_FSMOUT_HMIAVM3: user specific code start
            // DISPVIDCTRL_DISPVIDCTRL_STIMULATE_FSMOUT_HMIAVM3: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_SWITCH_REVERSEGEAR:
        {
            // simulates switching the reverse gear (GPIO Pin)
            tU8 param1 = puchData[3];
    

            // DISPVIDCTRL_DISPVIDCTRL_SWITCH_REVERSEGEAR: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            // DISPVIDCTRL_DISPVIDCTRL_SWITCH_REVERSEGEAR: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_SWITCH_CAMERASUPPLYVOLTAGE:
        {
            // Switch camera supply voltage (GPIO Pin)
            tU8 param1 = puchData[3];
    

            // DISPVIDCTRL_DISPVIDCTRL_SWITCH_CAMERASUPPLYVOLTAGE: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            // DISPVIDCTRL_DISPVIDCTRL_SWITCH_CAMERASUPPLYVOLTAGE: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_CCA_GET_REGISTEREDCLIENTS:
        {
            // get infos about registered clients for each property 
    

            // DISPVIDCTRL_DISPVIDCTRL_CCA_GET_REGISTEREDCLIENTS: user specific code start
            // DISPVIDCTRL_DISPVIDCTRL_CCA_GET_REGISTEREDCLIENTS: user specific code end
            
        }
        break;
    case DISPVIDCTRL_RVC_CCA_PROPERTY_AFFORDABLEITS:
        {
            // set values of property AffordableIts, P1 = Availability, P2 = Status BSW, P3 = Status MOD, P4 = Status LDW
            tU8 param1 = puchData[3];
            tU8 param2 = puchData[4];
            tU8 param3 = puchData[5];
            tU8 param4 = puchData[6];
    

            // DISPVIDCTRL_RVC_CCA_PROPERTY_AFFORDABLEITS: user specific code start
            rvc_fi_tcl_e8_AffordableIts_Status        e8AffordableItsAvailable;
            rvc_fi_tcl_e8_AffordableIts_StatusFeature e8BswStatus;
            rvc_fi_tcl_e8_AffordableIts_StatusFeature e8ModStatus;
            rvc_fi_tcl_e8_AffordableIts_StatusFeature e8LdwStatus;

            e8AffordableItsAvailable.enType = (rvc_fi_tcl_e8_AffordableIts_Status::tenType) param1;
            e8BswStatus.enType = (rvc_fi_tcl_e8_AffordableIts_StatusFeature::tenType) param2;
            e8ModStatus.enType = (rvc_fi_tcl_e8_AffordableIts_StatusFeature::tenType) param3;
            e8LdwStatus.enType = (rvc_fi_tcl_e8_AffordableIts_StatusFeature::tenType) param4;

            switch (param1)
            {
               case rvc_fi_tcl_e8_AffordableIts_Status::FI_EN_NOT_AVAILABLE:
               case rvc_fi_tcl_e8_AffordableIts_Status::FI_EN_INITIALISING:
               case rvc_fi_tcl_e8_AffordableIts_Status::FI_EN_AVAILABLE:
               break;
               default:
               {
                  ETG_TRACE_FATAL(("RVC_CCA_PROPERTY_AFFORDABLEITS - parameter_1 out of range"));
               }
               break;
            }
            switch (param2)
            {
               case rvc_fi_tcl_e8_AffordableIts_StatusFeature::FI_EN_UNKNOWN:
               case rvc_fi_tcl_e8_AffordableIts_StatusFeature::FI_EN_OFF:
               case rvc_fi_tcl_e8_AffordableIts_StatusFeature::FI_EN_ON:
               break;
               default:
                   ETG_TRACE_FATAL(("RVC_CCA_PROPERTY_AFFORDABLEITS - parameter_2 out of range"));
               break;
            }
            switch (param3)
            {
               case rvc_fi_tcl_e8_AffordableIts_StatusFeature::FI_EN_UNKNOWN:
               case rvc_fi_tcl_e8_AffordableIts_StatusFeature::FI_EN_OFF:
               case rvc_fi_tcl_e8_AffordableIts_StatusFeature::FI_EN_ON:
               break;
               default:
                  ETG_TRACE_FATAL(("RVC_CCA_PROPERTY_AFFORDABLEITS - parameter_3 out of range"));
               break;
            }
            switch (param4)
            {
               case rvc_fi_tcl_e8_AffordableIts_StatusFeature::FI_EN_UNKNOWN:
               case rvc_fi_tcl_e8_AffordableIts_StatusFeature::FI_EN_OFF:
               case rvc_fi_tcl_e8_AffordableIts_StatusFeature::FI_EN_ON:
               break;
               default:
                  ETG_TRACE_FATAL(("RVC_CCA_PROPERTY_AFFORDABLEITS - parameter_4 out of range"));
               break;
            }

            Idispvidctrl_tclServiceRvcIf* poRvcServiceIf = dynamic_cast<Idispvidctrl_tclServiceRvcIf*>(_poMainAppInstance->getHandler("Idispvidctrl_tclServiceRvcIf"));
            DISPVIDCTRL_NULL_POINTER_CHECK(poRvcServiceIf);
            poRvcServiceIf->sendAffordable_ITSStatus(e8AffordableItsAvailable, e8BswStatus, e8ModStatus, e8LdwStatus);
            // DISPVIDCTRL_RVC_CCA_PROPERTY_AFFORDABLEITS: user specific code end
            
        }
        break;
    case DISPVIDCTRL_RVC_CCA_PROPERTY_CAMERA_PWRSUPPLYSTATUS:
        {
            // set values of property Camera_PwrSupplyStatus, P1 = PowerSupplyId [tU16], P2 = PowerSupplyStatus [enumeration], P3 = Current [tU32]
            tU16 param1 = ((tU16)puchData[3] <<  8) | (tU16)puchData[4];
            tU8 param2 = puchData[5];
            tU32 param3 = ((tU32)puchData[6] << 24) | ((tU32)puchData[7] << 16) | ((tU32)puchData[8] <<  8) | (tU32)puchData[9];
    

            // DISPVIDCTRL_RVC_CCA_PROPERTY_CAMERA_PWRSUPPLYSTATUS: user specific code start
            tU16 pwrSupplyID;
            rvc_fi_tcl_e8_Camera_PowerSupplyStatus status;
            tU32 current;

            pwrSupplyID = (tU16) param1;
            status.enType = (rvc_fi_tcl_e8_Camera_PowerSupplyStatus::tenType) param2;
            current = (tU32) param3;

            Idispvidctrl_tclServiceRvcIf* poRvcServiceIf = dynamic_cast<Idispvidctrl_tclServiceRvcIf*>(_poMainAppInstance->getHandler("Idispvidctrl_tclServiceRvcIf"));
            DISPVIDCTRL_NULL_POINTER_CHECK(poRvcServiceIf);
            poRvcServiceIf->sendCamera_PwrSupplyStatusStatus(pwrSupplyID, status, current);
            // DISPVIDCTRL_RVC_CCA_PROPERTY_CAMERA_PWRSUPPLYSTATUS: user specific code end
            
        }
        break;
    case DISPVIDCTRL_RVC_CCA_PROPERTY_SYSTEMCONFIGURATIONS:
        {
            // set values of property SystemConfigurations, P1 = Camera Configuration, P2 = Guideline Configuration, P3 = Brightness Configuration
            tU8 param1 = puchData[3];
            tU8 param2 = puchData[4];
            tU8 param3 = puchData[5];
    

            // DISPVIDCTRL_RVC_CCA_PROPERTY_SYSTEMCONFIGURATIONS: user specific code start
            rvc_fi_tcl_e8_RVC_Camera_System_Type e8CameraSystem;
            tU8 u8RVCGuideLine;
            tU8 u8Brightness;
            
            e8CameraSystem.enType = (rvc_fi_tcl_e8_RVC_Camera_System_Type::tenType) param1;
            u8RVCGuideLine = param2;
            u8Brightness   = param3;
            
            switch (param1)
            {
               case rvc_fi_tcl_e8_RVC_Camera_System_Type::FI_EN_NONE:
               case rvc_fi_tcl_e8_RVC_Camera_System_Type::FI_EN_AVM_ENTRY:
               case rvc_fi_tcl_e8_RVC_Camera_System_Type::FI_EN_RVC:
               case rvc_fi_tcl_e8_RVC_Camera_System_Type::FI_EN_AVM_LOW:
               case rvc_fi_tcl_e8_RVC_Camera_System_Type::FI_EN_AVM_HIGH:
               case rvc_fi_tcl_e8_RVC_Camera_System_Type::FI_EN_RVC_TAILGATE:
               case rvc_fi_tcl_e8_RVC_Camera_System_Type::FI_EN_AVM_IPA:
               case rvc_fi_tcl_e8_RVC_Camera_System_Type::FI_EN_AVM_PHASE3:
               break;
               default:
                  ETG_TRACE_FATAL(("RVC_CCA_PROPERTY_SYSTEMCONFIGURATIONS - parameter_1 out of range"));
               break;
            }
            // range check parameter 2 (guideline configuration value)
            // todo
            if ( u8Brightness <= 100 )
            {
               ETG_TRACE_FATAL(("RVC_CCA_PROPERTY_PROPERTYSYSTEMCONFIGURATIONS - parameter_3 out of range"));
            }
            
            Idispvidctrl_tclServiceRvcIf* poRvcServiceIf = dynamic_cast<Idispvidctrl_tclServiceRvcIf*>(_poMainAppInstance->getHandler("Idispvidctrl_tclServiceRvcIf"));
            DISPVIDCTRL_NULL_POINTER_CHECK(poRvcServiceIf);
            poRvcServiceIf->sendSystemConfigurationsStatus(e8CameraSystem, u8RVCGuideLine, u8Brightness);
            // DISPVIDCTRL_RVC_CCA_PROPERTY_SYSTEMCONFIGURATIONS: user specific code end
            
        }
        break;
    case DISPVIDCTRL_RVC_CCA_PROPERTY_SYSTEMSTATUS:
        {
            // set value of property SystemStatus
            tU8 param1 = puchData[3];
    

            // DISPVIDCTRL_RVC_CCA_PROPERTY_SYSTEMSTATUS: user specific code start
            rvc_fi_tcl_e8_RVC_SystemStatus e8SystemStatus;
            e8SystemStatus.enType = (rvc_fi_tcl_e8_RVC_SystemStatus::tenType) param1;

            switch (param1)
            {
               case rvc_fi_tcl_e8_RVC_SystemStatus::FI_EN_INITIALISATION:
               case rvc_fi_tcl_e8_RVC_SystemStatus::FI_EN_VISUALISATION_OFF:
               case rvc_fi_tcl_e8_RVC_SystemStatus::FI_EN_VISUALISATION_OFF_VIDEO_SIGNAL_FAILURE:
               case rvc_fi_tcl_e8_RVC_SystemStatus::FI_EN_RVC_EARLY_VISUALISATION_BLACK_IN:
               case rvc_fi_tcl_e8_RVC_SystemStatus::FI_EN_RVC_EARLY_VISUALISATION_ON:
               case rvc_fi_tcl_e8_RVC_SystemStatus::FI_EN_RVC_EARLY_VISUALISATION_BLACK_OUT:
               case rvc_fi_tcl_e8_RVC_SystemStatus::FI_EN_RVC_VISUALISATION_BLACK_IN:
               case rvc_fi_tcl_e8_RVC_SystemStatus::FI_EN_RVC_VISUALISATION_ON:
               case rvc_fi_tcl_e8_RVC_SystemStatus::FI_EN_RVC_VISUALISATION_ON_CAMERA_SETTINGS:
               case rvc_fi_tcl_e8_RVC_SystemStatus::FI_EN_RVC_VISUALISATION_BLACK_OUT:
               case rvc_fi_tcl_e8_RVC_SystemStatus::FI_EN_AVM_EARLY_VISUALISATION_BLACK_IN:
               case rvc_fi_tcl_e8_RVC_SystemStatus::FI_EN_AVM_EARLY_VISUALISATION_ON:
               case rvc_fi_tcl_e8_RVC_SystemStatus::FI_EN_AVM_EARLY_VISUALISATION_BLACK_OUT:
               case rvc_fi_tcl_e8_RVC_SystemStatus::FI_EN_AVM_VISUALISATION_BLACK_IN:
               case rvc_fi_tcl_e8_RVC_SystemStatus::FI_EN_AVM_VISUALISATION_ON:
               case rvc_fi_tcl_e8_RVC_SystemStatus::FI_EN_AVM_VISUALISATION_ON_CAMERA_SETTINGS:
               case rvc_fi_tcl_e8_RVC_SystemStatus::FI_EN_AVM_VISUALISATION_BLACK_OUT:
               break;
               default:
                  ETG_TRACE_FATAL(("RVC_CCA_PROPERTY_SYSTEMSTATUS - parameter out of range"));
               break;
            }

            Idispvidctrl_tclServiceRvcIf* poRvcServiceIf = dynamic_cast<Idispvidctrl_tclServiceRvcIf*>(_poMainAppInstance->getHandler("Idispvidctrl_tclServiceRvcIf"));
            DISPVIDCTRL_NULL_POINTER_CHECK(poRvcServiceIf);
            poRvcServiceIf->sendSystemStatusStatus(e8SystemStatus);
            // DISPVIDCTRL_RVC_CCA_PROPERTY_SYSTEMSTATUS: user specific code end
            
        }
        break;
    case DISPVIDCTRL_RVC_CCA_PROPERTY_VIDEOSIGNALSTATUS:
        {
            // set values of property VideoSignalStatus
            tU8 param1 = puchData[3];
    

            // DISPVIDCTRL_RVC_CCA_PROPERTY_VIDEOSIGNALSTATUS: user specific code start
            rvc_fi_tcl_e8_RVC_SignalStatus e8StatusSignal;
            e8StatusSignal.enType = (rvc_fi_tcl_e8_RVC_SignalStatus::tenType) param1;

            switch (param1)
            {
               case rvc_fi_tcl_e8_RVC_SignalStatus::FI_EN_SIGNAL_OK:
               case rvc_fi_tcl_e8_RVC_SignalStatus::FI_EN_CONFIRMED_FAILURE:
               case rvc_fi_tcl_e8_RVC_SignalStatus::FI_EN_CURRENT_FAILURE:
               break;
               default:
                  ETG_TRACE_FATAL(("RVC_CCA_PROPERTY_VIDEOSIGNALSTATUS - parameter out of range"));
               break;
            }

            Idispvidctrl_tclServiceRvcIf* poRvcServiceIf = dynamic_cast<Idispvidctrl_tclServiceRvcIf*>(_poMainAppInstance->getHandler("Idispvidctrl_tclServiceRvcIf"));
            DISPVIDCTRL_NULL_POINTER_CHECK(poRvcServiceIf);
            poRvcServiceIf->sendVideoSignalStatusStatus(e8StatusSignal);
            // DISPVIDCTRL_RVC_CCA_PROPERTY_VIDEOSIGNALSTATUS: user specific code end
            
        }
        break;
    case DISPVIDCTRL_RVC_CCA_PROPERTY_REVERSESIGNALSTATUS:
        {
            // set values of property ReverseSignalStatus
            tU8 param1 = puchData[3];
    

            // DISPVIDCTRL_RVC_CCA_PROPERTY_REVERSESIGNALSTATUS: user specific code start
            rvc_fi_tcl_e8_RVC_ReverseSignalStatus e8StatusReverseSignal;
            e8StatusReverseSignal.enType = (rvc_fi_tcl_e8_RVC_ReverseSignalStatus::tenType) param1;

            switch (param1)
            {
               case rvc_fi_tcl_e8_RVC_ReverseSignalStatus::FI_EN_OFF:
               case rvc_fi_tcl_e8_RVC_ReverseSignalStatus::FI_EN_ON:
               case rvc_fi_tcl_e8_RVC_ReverseSignalStatus::FI_EN_ON_NISSANDEBOUNCED:
               break;
               default:
                  ETG_TRACE_FATAL(("RVC_CCA_PROPERTY_REVERSESIGNALSTATUS - parameter out of range"));
               break;
            }

            Idispvidctrl_tclServiceRvcIf* poRvcServiceIf = dynamic_cast<Idispvidctrl_tclServiceRvcIf*>(_poMainAppInstance->getHandler("Idispvidctrl_tclServiceRvcIf"));
            DISPVIDCTRL_NULL_POINTER_CHECK(poRvcServiceIf);
            poRvcServiceIf->sendReverseSignalStatusStatus(e8StatusReverseSignal);
            // DISPVIDCTRL_RVC_CCA_PROPERTY_REVERSESIGNALSTATUS: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_VIDEO_GUARDTIMEREMAINING:
        {
            // If reverse gear is switched off, RVC has to be shown for a further period of time. In case early video is active, the early video component informs the system about the time left.
            tU8 param1 = puchData[3];
            tU32 param2 = ((tU32)puchData[4] << 24) | ((tU32)puchData[5] << 16) | ((tU32)puchData[6] <<  8) | (tU32)puchData[7];
    

            // DISPVIDCTRL_DISPVIDCTRL_VIDEO_GUARDTIMEREMAINING: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param2);
            // DISPVIDCTRL_DISPVIDCTRL_VIDEO_GUARDTIMEREMAINING: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_VIDEO_GUIDELINEBLACKWARNINGTEXTBACKGROUND:
        {
            // GuidelineBlackWarningTextBackground
            tU8 param1 = puchData[3];
            tU32 param2 = ((tU32)puchData[4] << 24) | ((tU32)puchData[5] << 16) | ((tU32)puchData[6] <<  8) | (tU32)puchData[7];
    

            // DISPVIDCTRL_DISPVIDCTRL_VIDEO_GUIDELINEBLACKWARNINGTEXTBACKGROUND: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param2);
            // DISPVIDCTRL_DISPVIDCTRL_VIDEO_GUIDELINEBLACKWARNINGTEXTBACKGROUND: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_VIDEO_GUIDELINECAMERASYSTEMTYPE:
        {
            // GuidelineCameraSystemType
            tU8 param1 = puchData[3];
            tU32 param2 = ((tU32)puchData[4] << 24) | ((tU32)puchData[5] << 16) | ((tU32)puchData[6] <<  8) | (tU32)puchData[7];
    

            // DISPVIDCTRL_DISPVIDCTRL_VIDEO_GUIDELINECAMERASYSTEMTYPE: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param2);
            // DISPVIDCTRL_DISPVIDCTRL_VIDEO_GUIDELINECAMERASYSTEMTYPE: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_VIDEO_GUIDELINECAMERATYPE:
        {
            // GuidelineCameraType
            tU8 param1 = puchData[3];
            tU32 param2 = ((tU32)puchData[4] << 24) | ((tU32)puchData[5] << 16) | ((tU32)puchData[6] <<  8) | (tU32)puchData[7];
    

            // DISPVIDCTRL_DISPVIDCTRL_VIDEO_GUIDELINECAMERATYPE: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param2);
            // DISPVIDCTRL_DISPVIDCTRL_VIDEO_GUIDELINECAMERATYPE: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_VIDEO_GUIDELINEVISIBILITY:
        {
            // GuidelineVisibility - true or false
            tU8 param1 = puchData[3];
            tU32 param2 = ((tU32)puchData[4] << 24) | ((tU32)puchData[5] << 16) | ((tU32)puchData[6] <<  8) | (tU32)puchData[7];
    

            // DISPVIDCTRL_DISPVIDCTRL_VIDEO_GUIDELINEVISIBILITY: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param2);
            // DISPVIDCTRL_DISPVIDCTRL_VIDEO_GUIDELINEVISIBILITY: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_VIDEO_GUIDELINEWARNINGLANGUAGE:
        {
            // GuidelineWarningLanguage
            tU8 param1 = puchData[3];
            tU32 param2 = ((tU32)puchData[4] << 24) | ((tU32)puchData[5] << 16) | ((tU32)puchData[6] <<  8) | (tU32)puchData[7];
    

            // DISPVIDCTRL_DISPVIDCTRL_VIDEO_GUIDELINEWARNINGLANGUAGE: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param2);
            // DISPVIDCTRL_DISPVIDCTRL_VIDEO_GUIDELINEWARNINGLANGUAGE: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_VIDEO_GUIDELINEWARNINGTEXT:
        {
            // GuidelineWarningText  true is ON, false is OFF
            tU8 param1 = puchData[3];
            tU32 param2 = ((tU32)puchData[4] << 24) | ((tU32)puchData[5] << 16) | ((tU32)puchData[6] <<  8) | (tU32)puchData[7];
    

            // DISPVIDCTRL_DISPVIDCTRL_VIDEO_GUIDELINEWARNINGTEXT: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param2);
            // DISPVIDCTRL_DISPVIDCTRL_VIDEO_GUIDELINEWARNINGTEXT: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_VIDEO_LATEVIDEOMODE:
        {
            // Switches the Reverse Camera from Early Mode to Late Mode
            tU8 param1 = puchData[3];
    

            // DISPVIDCTRL_DISPVIDCTRL_VIDEO_LATEVIDEOMODE: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            // DISPVIDCTRL_DISPVIDCTRL_VIDEO_LATEVIDEOMODE: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_VIDEO_RVCBLACKLEVEL:
        {
            // Sets the BlackLevel setting for the RVC. 0 to 100 percent
            tU8 param1 = puchData[3];
            tU32 param2 = ((tU32)puchData[4] << 24) | ((tU32)puchData[5] << 16) | ((tU32)puchData[6] <<  8) | (tU32)puchData[7];
    

            // DISPVIDCTRL_DISPVIDCTRL_VIDEO_RVCBLACKLEVEL: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param2);
            // DISPVIDCTRL_DISPVIDCTRL_VIDEO_RVCBLACKLEVEL: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_VIDEO_RVCBRIGHTNESS:
        {
            // Sets the Brightness setting for the RVC. 0 to 100 percent
            tU8 param1 = puchData[3];
            tU32 param2 = ((tU32)puchData[4] << 24) | ((tU32)puchData[5] << 16) | ((tU32)puchData[6] <<  8) | (tU32)puchData[7];
    

            // DISPVIDCTRL_DISPVIDCTRL_VIDEO_RVCBRIGHTNESS: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param2);
            // DISPVIDCTRL_DISPVIDCTRL_VIDEO_RVCBRIGHTNESS: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_VIDEO_RVCCOLOUR:
        {
            // Sets the Colour setting for the RVC. 0 to 100 percent
            tU8 param1 = puchData[3];
            tU32 param2 = ((tU32)puchData[4] << 24) | ((tU32)puchData[5] << 16) | ((tU32)puchData[6] <<  8) | (tU32)puchData[7];
    

            // DISPVIDCTRL_DISPVIDCTRL_VIDEO_RVCCOLOUR: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param2);
            // DISPVIDCTRL_DISPVIDCTRL_VIDEO_RVCCOLOUR: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_VIDEO_RVCCONTRAST:
        {
            // Sets the Contrast setting for the RVC. 0 to 100 percent
            tU8 param1 = puchData[3];
            tU32 param2 = ((tU32)puchData[4] << 24) | ((tU32)puchData[5] << 16) | ((tU32)puchData[6] <<  8) | (tU32)puchData[7];
    

            // DISPVIDCTRL_DISPVIDCTRL_VIDEO_RVCCONTRAST: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param2);
            // DISPVIDCTRL_DISPVIDCTRL_VIDEO_RVCCONTRAST: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_VIDEO_RVCHUE:
        {
            // Sets the Hue/Tint setting for the RVC. 0 to 100 percent
            tU8 param1 = puchData[3];
            tU32 param2 = ((tU32)puchData[4] << 24) | ((tU32)puchData[5] << 16) | ((tU32)puchData[6] <<  8) | (tU32)puchData[7];
    

            // DISPVIDCTRL_DISPVIDCTRL_VIDEO_RVCHUE: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param2);
            // DISPVIDCTRL_DISPVIDCTRL_VIDEO_RVCHUE: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_VIDEO_RVCHIGHSPEEDTHRESHOLD:
        {
            // [km/h * 100] threshold for Parking System Darken Screen
            tU8 param1 = puchData[3];
            tU32 param2 = ((tU32)puchData[4] << 24) | ((tU32)puchData[5] << 16) | ((tU32)puchData[6] <<  8) | (tU32)puchData[7];
    

            // DISPVIDCTRL_DISPVIDCTRL_VIDEO_RVCHIGHSPEEDTHRESHOLD: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param2);
            // DISPVIDCTRL_DISPVIDCTRL_VIDEO_RVCHIGHSPEEDTHRESHOLD: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_VIDEO_RVCLOWSPEEDTHRESHOLD:
        {
            // [km/h * 100] threshold for Parking System Normal Screen (Un-Darken Screen)
            tU8 param1 = puchData[3];
            tU32 param2 = ((tU32)puchData[4] << 24) | ((tU32)puchData[5] << 16) | ((tU32)puchData[6] <<  8) | (tU32)puchData[7];
    

            // DISPVIDCTRL_DISPVIDCTRL_VIDEO_RVCLOWSPEEDTHRESHOLD: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param2);
            // DISPVIDCTRL_DISPVIDCTRL_VIDEO_RVCLOWSPEEDTHRESHOLD: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_VIDEO_RVCREVERSEOFFGUARDTIME:
        {
            // [ms] follow-up time for camera screen after reverse gear off
            tU8 param1 = puchData[3];
            tU32 param2 = ((tU32)puchData[4] << 24) | ((tU32)puchData[5] << 16) | ((tU32)puchData[6] <<  8) | (tU32)puchData[7];
    

            // DISPVIDCTRL_DISPVIDCTRL_VIDEO_RVCREVERSEOFFGUARDTIME: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param2);
            // DISPVIDCTRL_DISPVIDCTRL_VIDEO_RVCREVERSEOFFGUARDTIME: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_VIDEO_RVCSTATUSINFO:
        {
            // 
            tU8 param1 = puchData[3];
            tU8 param2 = puchData[4];
            tU32 param3 = ((tU32)puchData[5] << 24) | ((tU32)puchData[6] << 16) | ((tU32)puchData[7] <<  8) | (tU32)puchData[8];
    

            // DISPVIDCTRL_DISPVIDCTRL_VIDEO_RVCSTATUSINFO: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param2);
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param3);
            // DISPVIDCTRL_DISPVIDCTRL_VIDEO_RVCSTATUSINFO: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_VIDEO_SPMAUTOMODE:
        {
            // Indicates that the user switched off during the last power cycle.
            tU8 param1 = puchData[3];
            tU32 param2 = ((tU32)puchData[4] << 24) | ((tU32)puchData[5] << 16) | ((tU32)puchData[6] <<  8) | (tU32)puchData[7];
    

            // DISPVIDCTRL_DISPVIDCTRL_VIDEO_SPMAUTOMODE: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param2);
            // DISPVIDCTRL_DISPVIDCTRL_VIDEO_SPMAUTOMODE: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_VIDEO_VIDEOCAPTURE:
        {
            // Controls the Reverse Video Camera - Start/Stop Video Picture Capture
            tU8 param1 = puchData[3];
    

            // DISPVIDCTRL_DISPVIDCTRL_VIDEO_VIDEOCAPTURE: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            // DISPVIDCTRL_DISPVIDCTRL_VIDEO_VIDEOCAPTURE: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_VIDEO_VEHICLECONFIG:
        {
            // Selects hardcoded vehicle configuration within guideline calculation software part
            const tChar* pString1 = (const tChar*)&puchData[3];
    

            // DISPVIDCTRL_DISPVIDCTRL_VIDEO_VEHICLECONFIG: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(pString1);
            // DISPVIDCTRL_DISPVIDCTRL_VIDEO_VEHICLECONFIG: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_VIDEO_RESETCONFIG:
        {
            // Command to reset the early and RVC configuration back to its initial values
            tU32 param1 = ((tU32)puchData[3] << 24) | ((tU32)puchData[4] << 16) | ((tU32)puchData[5] <<  8) | (tU32)puchData[6];
    

            // DISPVIDCTRL_DISPVIDCTRL_VIDEO_RESETCONFIG: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            // DISPVIDCTRL_DISPVIDCTRL_VIDEO_RESETCONFIG: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_VIDEO_PRINTCONFIG:
        {
            // Command to list the current early and RVC configuration values
            tU32 param1 = ((tU32)puchData[3] << 24) | ((tU32)puchData[4] << 16) | ((tU32)puchData[5] <<  8) | (tU32)puchData[6];
    

            // DISPVIDCTRL_DISPVIDCTRL_VIDEO_PRINTCONFIG: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            // DISPVIDCTRL_DISPVIDCTRL_VIDEO_PRINTCONFIG: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_VIDEO_STEERINGWHEELANGLE:
        {
            // Command to change steering wheel angle
            tU32 param1 = ((tU32)puchData[3] << 24) | ((tU32)puchData[4] << 16) | ((tU32)puchData[5] <<  8) | (tU32)puchData[6];
    

            // DISPVIDCTRL_DISPVIDCTRL_VIDEO_STEERINGWHEELANGLE: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            // DISPVIDCTRL_DISPVIDCTRL_VIDEO_STEERINGWHEELANGLE: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_VIDEO_REARWHEELANGLE:
        {
            // Command to change rear wheel angle
            tU32 param1 = ((tU32)puchData[3] << 24) | ((tU32)puchData[4] << 16) | ((tU32)puchData[5] <<  8) | (tU32)puchData[6];
    

            // DISPVIDCTRL_DISPVIDCTRL_VIDEO_REARWHEELANGLE: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            // DISPVIDCTRL_DISPVIDCTRL_VIDEO_REARWHEELANGLE: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_VIDEO_ADV_REGISTER_READ:
        {
            // read a value from ADV register.
            tU8 param1 = puchData[3];
            tU8 param2 = puchData[4];
    

            // DISPVIDCTRL_DISPVIDCTRL_VIDEO_ADV_REGISTER_READ: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param2);
            // DISPVIDCTRL_DISPVIDCTRL_VIDEO_ADV_REGISTER_READ: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_VIDEO_ADV_REGISTER_WRITE:
        {
            // write a value into ADV register (parameter register, value).
            tU8 param1 = puchData[3];
            tU8 param2 = puchData[4];
    

            // DISPVIDCTRL_DISPVIDCTRL_VIDEO_ADV_REGISTER_WRITE: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param2);
            // DISPVIDCTRL_DISPVIDCTRL_VIDEO_ADV_REGISTER_WRITE: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_VIDEO_SET_CROPPING_PARAMETER:
        {
            // CropUp, CropDown, CropLeft, CropRight - all 0-100 percent
            tU32 param1 = ((tU32)puchData[3] << 24) | ((tU32)puchData[4] << 16) | ((tU32)puchData[5] <<  8) | (tU32)puchData[6];
            tU32 param2 = ((tU32)puchData[7] << 24) | ((tU32)puchData[8] << 16) | ((tU32)puchData[9] <<  8) | (tU32)puchData[10];
            tU32 param3 = ((tU32)puchData[11] << 24) | ((tU32)puchData[12] << 16) | ((tU32)puchData[13] <<  8) | (tU32)puchData[14];
            tU32 param4 = ((tU32)puchData[15] << 24) | ((tU32)puchData[16] << 16) | ((tU32)puchData[17] <<  8) | (tU32)puchData[18];
    

            // DISPVIDCTRL_DISPVIDCTRL_VIDEO_SET_CROPPING_PARAMETER: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param2);
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param3);
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param4);
            // DISPVIDCTRL_DISPVIDCTRL_VIDEO_SET_CROPPING_PARAMETER: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_VIDEO_SET_CAMERAIMAGEMIRROR:
        {
            // set Mirroring (0-None, 1 - Vertical, 2 - Horizontal, 3 - Horizontal + Vertical).
            tU8 param1 = puchData[3];
    

            // DISPVIDCTRL_DISPVIDCTRL_VIDEO_SET_CAMERAIMAGEMIRROR: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            // DISPVIDCTRL_DISPVIDCTRL_VIDEO_SET_CAMERAIMAGEMIRROR: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_VIDEO_LAYER_OR_SURFACE_SETTING:
        {
            // kind of setting, layer or_surface id, scaling: x, y, width, hight.
            tU8 param1 = puchData[3];
            tU32 param2 = ((tU32)puchData[4] << 24) | ((tU32)puchData[5] << 16) | ((tU32)puchData[6] <<  8) | (tU32)puchData[7];
            tU32 param3 = ((tU32)puchData[8] << 24) | ((tU32)puchData[9] << 16) | ((tU32)puchData[10] <<  8) | (tU32)puchData[11];
            tU32 param4 = ((tU32)puchData[12] << 24) | ((tU32)puchData[13] << 16) | ((tU32)puchData[14] <<  8) | (tU32)puchData[15];
            tU32 param5 = ((tU32)puchData[16] << 24) | ((tU32)puchData[17] << 16) | ((tU32)puchData[18] <<  8) | (tU32)puchData[19];
            tU32 param6 = ((tU32)puchData[20] << 24) | ((tU32)puchData[21] << 16) | ((tU32)puchData[22] <<  8) | (tU32)puchData[23];
    

            // DISPVIDCTRL_DISPVIDCTRL_VIDEO_LAYER_OR_SURFACE_SETTING: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param2);
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param3);
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param4);
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param5);
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param6);
            // DISPVIDCTRL_DISPVIDCTRL_VIDEO_LAYER_OR_SURFACE_SETTING: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_CMDSETBRIGHTNESS:
        {
            // 
            tU8 param1 = puchData[3];
    

            // DISPVIDCTRL_DISPVIDCTRL_CMDSETBRIGHTNESS: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            // DISPVIDCTRL_DISPVIDCTRL_CMDSETBRIGHTNESS: user specific code end
            
        }
        break;
    case DISPVIDCTRL_EARLYCONFIG_CMDGETCONFIG:
        {
            // Prints the early config information.
    

            // DISPVIDCTRL_EARLYCONFIG_CMDGETCONFIG: user specific code start
            // DISPVIDCTRL_EARLYCONFIG_CMDGETCONFIG: user specific code end
            
        }
        break;
    case DISPVIDCTRL_EARLYCONFIG_CMDWRITECONFIG:
        {
            // Writes the early config information.
    

            // DISPVIDCTRL_EARLYCONFIG_CMDWRITECONFIG: user specific code start
            // DISPVIDCTRL_EARLYCONFIG_CMDWRITECONFIG: user specific code end
            
        }
        break;
    case DISPVIDCTRL_EARLYCONFIG_CMDLOADCONFIG:
        {
            // Loads the early config information.
    

            // DISPVIDCTRL_EARLYCONFIG_CMDLOADCONFIG: user specific code start
            // DISPVIDCTRL_EARLYCONFIG_CMDLOADCONFIG: user specific code end
            
        }
        break;
    case DISPVIDCTRL_EARLYCONFIG_CMDSETDISPLAYRESOLUTION:
        {
            // Writes the early config display resolution information (max. 31 char) directly without validation. Please use '\\0' to reset manually settings.
            const tChar* pString1 = (const tChar*)&puchData[3];
    

            // DISPVIDCTRL_EARLYCONFIG_CMDSETDISPLAYRESOLUTION: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(pString1);
            // DISPVIDCTRL_EARLYCONFIG_CMDSETDISPLAYRESOLUTION: user specific code end
            
        }
        break;
    case DISPVIDCTRL_EARLYCONFIG_CMDSETBACKWARDCOMP:
        {
            // Writes the early config display backward comp configuration (possible values: -1, 0, 1). Please use an undefined value to reset mannually settings. 
            tU32 param1 = ((tU32)puchData[3] << 24) | ((tU32)puchData[4] << 16) | ((tU32)puchData[5] <<  8) | (tU32)puchData[6];
    

            // DISPVIDCTRL_EARLYCONFIG_CMDSETBACKWARDCOMP: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            // DISPVIDCTRL_EARLYCONFIG_CMDSETBACKWARDCOMP: user specific code end
            
        }
        break;
    case DISPVIDCTRL_EARLYCONFIG_CMDSETLOWFREQUENCY:
        {
            // Writes the early config display low frequence configuration (possible values: -1, 0, 1). Please use an undefined value to reset mannually settings. 
            tU32 param1 = ((tU32)puchData[3] << 24) | ((tU32)puchData[4] << 16) | ((tU32)puchData[5] <<  8) | (tU32)puchData[6];
    

            // DISPVIDCTRL_EARLYCONFIG_CMDSETLOWFREQUENCY: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            // DISPVIDCTRL_EARLYCONFIG_CMDSETLOWFREQUENCY: user specific code end
            
        }
        break;
    case DISPVIDCTRL_EARLYCONFIG_CMDSETRTCDRIVER:
        {
            // Writes the early config RTC driver name (max. 63 char) directly without validation. Please use '\\0' to reset manually settings.
            const tChar* pString1 = (const tChar*)&puchData[3];
    

            // DISPVIDCTRL_EARLYCONFIG_CMDSETRTCDRIVER: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(pString1);
            // DISPVIDCTRL_EARLYCONFIG_CMDSETRTCDRIVER: user specific code end
            
        }
        break;
    case DISPVIDCTRL_EARLYCONFIG_CMDSETTOUCHDRIVER:
        {
            // Writes the early config driver name (max. 63 char) of first touch device directly without validation. Please use '\\0' to reset manually settings.
            const tChar* pString1 = (const tChar*)&puchData[3];
    

            // DISPVIDCTRL_EARLYCONFIG_CMDSETTOUCHDRIVER: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(pString1);
            // DISPVIDCTRL_EARLYCONFIG_CMDSETTOUCHDRIVER: user specific code end
            
        }
        break;
    case DISPVIDCTRL_EARLYCONFIG_CMDSETTOUCHCONFIGFILE:
        {
            // Writes the early config configuration file name (max. 63 char) of first touch device directly without validation. Please use '\\0' to reset manually settings.
            const tChar* pString1 = (const tChar*)&puchData[3];
    

            // DISPVIDCTRL_EARLYCONFIG_CMDSETTOUCHCONFIGFILE: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(pString1);
            // DISPVIDCTRL_EARLYCONFIG_CMDSETTOUCHCONFIGFILE: user specific code end
            
        }
        break;
    case DISPVIDCTRL_EARLYCONFIG_CMDSETTOUCHI2CADDRESS:
        {
            // Writes the early config I2C address (max. 11 char, e.g. 'i2c-6/') of first touch device directly without validation. Please use '\\0' to reset manually settings.
            const tChar* pString1 = (const tChar*)&puchData[3];
    

            // DISPVIDCTRL_EARLYCONFIG_CMDSETTOUCHI2CADDRESS: user specific code start
            // DISPVIDCTRL_EARLYCONFIG_CMDSETTOUCHI2CADDRESS: user specific code end
            
        }
        break;
    case DISPVIDCTRL_EARLYCONFIG_CMDSETTOUCHDRIVER2:
        {
            // Writes the early config driver name (max. 63 char) of second touch device directly without validation. Please use '\\0' to reset manually settings.
            const tChar* pString1 = (const tChar*)&puchData[3];
    

            // DISPVIDCTRL_EARLYCONFIG_CMDSETTOUCHDRIVER2: user specific code start
            // DISPVIDCTRL_EARLYCONFIG_CMDSETTOUCHDRIVER2: user specific code end
            
        }
        break;
    case DISPVIDCTRL_EARLYCONFIG_CMDSETTOUCHCONFIGFILE2:
        {
            // Writes the early config configuration file name (max. 63 char) of second touch device directly without validation. Please use '\\0' to reset manually settings.
            const tChar* pString1 = (const tChar*)&puchData[3];
    

            // DISPVIDCTRL_EARLYCONFIG_CMDSETTOUCHCONFIGFILE2: user specific code start
            // DISPVIDCTRL_EARLYCONFIG_CMDSETTOUCHCONFIGFILE2: user specific code end
            
        }
        break;
    case DISPVIDCTRL_EARLYCONFIG_CMDSETTOUCHI2CADDRESS2:
        {
            // Writes the early config I2C address (max. 11 char, e.g. 'i2c-6/') of second touch device directly without validation. Please use '\\0' to reset manually settings.
            const tChar* pString1 = (const tChar*)&puchData[3];
    

            // DISPVIDCTRL_EARLYCONFIG_CMDSETTOUCHI2CADDRESS2: user specific code start
            // DISPVIDCTRL_EARLYCONFIG_CMDSETTOUCHI2CADDRESS2: user specific code end
            
        }
        break;
    case DISPVIDCTRL_EARLYCONFIG_CMDSETTIMINGLVDS1:
        {
            // Writes the early config LVDS 1 timing configuration (max. 31 char) directly without validation. Please use '\\0' to reset manually settings.
            const tChar* pString1 = (const tChar*)&puchData[3];
    

            // DISPVIDCTRL_EARLYCONFIG_CMDSETTIMINGLVDS1: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(pString1);
            // DISPVIDCTRL_EARLYCONFIG_CMDSETTIMINGLVDS1: user specific code end
            
        }
        break;
    case DISPVIDCTRL_EARLYCONFIG_CMDSETCLOCKEDGELVDS1:
        {
            // Writes the early config LVDS 1 clock edge configuration (possible values: -1, 0, 1). Please use an undefined value to reset mannually settings. 
            tU32 param1 = ((tU32)puchData[3] << 24) | ((tU32)puchData[4] << 16) | ((tU32)puchData[5] <<  8) | (tU32)puchData[6];
    

            // DISPVIDCTRL_EARLYCONFIG_CMDSETCLOCKEDGELVDS1: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            // DISPVIDCTRL_EARLYCONFIG_CMDSETCLOCKEDGELVDS1: user specific code end
            
        }
        break;
    case DISPVIDCTRL_EARLYCONFIG_CMDSETCLOCKGENERATIONLVDS1:
        {
            // Writes the early config LVDS 1 spread spectrum clock generation configuration (possible values: -1, 0, 8-15). Please use an undefined value to reset mannually settings. 
            tU32 param1 = ((tU32)puchData[3] << 24) | ((tU32)puchData[4] << 16) | ((tU32)puchData[5] <<  8) | (tU32)puchData[6];
    

            // DISPVIDCTRL_EARLYCONFIG_CMDSETCLOCKGENERATIONLVDS1: user specific code start
            // DISPVIDCTRL_EARLYCONFIG_CMDSETCLOCKGENERATIONLVDS1: user specific code end
            
        }
        break;
    case DISPVIDCTRL_EARLYCONFIG_CMDSETTIMINGLVDS2:
        {
            // Writes the early config LVDS 2 timing configuration (max. 31 char) directly without validation. Please use '\\0' to reset manually settings.
            const tChar* pString1 = (const tChar*)&puchData[3];
    

            // DISPVIDCTRL_EARLYCONFIG_CMDSETTIMINGLVDS2: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(pString1);
            // DISPVIDCTRL_EARLYCONFIG_CMDSETTIMINGLVDS2: user specific code end
            
        }
        break;
    case DISPVIDCTRL_EARLYCONFIG_CMDSETCLOCKGENERATIONLVDS2:
        {
            // Writes the early config LVDS 2 spread spectrum clock generation configuration (possible values: -1, 0, 8-15). Please use an undefined value to reset mannually settings. 
            tU32 param1 = ((tU32)puchData[3] << 24) | ((tU32)puchData[4] << 16) | ((tU32)puchData[5] <<  8) | (tU32)puchData[6];
    

            // DISPVIDCTRL_EARLYCONFIG_CMDSETCLOCKGENERATIONLVDS2: user specific code start
            // DISPVIDCTRL_EARLYCONFIG_CMDSETCLOCKGENERATIONLVDS2: user specific code end
            
        }
        break;
    case DISPVIDCTRL_EARLYCONFIG_CMDSETCLOCKEDGELVDS2:
        {
            // Writes the early config LVDS 1 clock edge configuration (possible values: -1, 0, 1). Please use an undefined value to reset mannually settings. 
            tU32 param1 = ((tU32)puchData[3] << 24) | ((tU32)puchData[4] << 16) | ((tU32)puchData[5] <<  8) | (tU32)puchData[6];
    

            // DISPVIDCTRL_EARLYCONFIG_CMDSETCLOCKEDGELVDS2: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            // DISPVIDCTRL_EARLYCONFIG_CMDSETCLOCKEDGELVDS2: user specific code end
            
        }
        break;
    case DISPVIDCTRL_EARLYCONFIG_CMDSETDISPLAYORDER:
        {
            // Writes the early config display order configuration directly without validation. Please use 'UNDEF' to reset manually settings.
            tU8 param1 = puchData[3];
            tU8 param2 = puchData[4];
            tU8 param3 = puchData[5];
            tU8 param4 = puchData[6];
    

            // DISPVIDCTRL_EARLYCONFIG_CMDSETDISPLAYORDER: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param2);
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param3);
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param4);
            // DISPVIDCTRL_EARLYCONFIG_CMDSETDISPLAYORDER: user specific code end
            
        }
        break;
    case DISPVIDCTRL_EARLYCONFIG_CMDSETFLUSHDESIGNCONFIGFILE:
        {
            // Writes the early config flush design configuration file name (max. 63 char) directly without validation. Please use '\\0' to reset manually settings.
            const tChar* pString1 = (const tChar*)&puchData[3];
    

            // DISPVIDCTRL_EARLYCONFIG_CMDSETFLUSHDESIGNCONFIGFILE: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(pString1);
            // DISPVIDCTRL_EARLYCONFIG_CMDSETFLUSHDESIGNCONFIGFILE: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DIMMING_CMDGETPDDCONFIG:
        {
            // Prints the PDD dimming config information.
    

            // DISPVIDCTRL_DIMMING_CMDGETPDDCONFIG: user specific code start
            // DISPVIDCTRL_DIMMING_CMDGETPDDCONFIG: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DIMMING_CMDSETPDDCONFIG:
        {
            // Writes the PDD dimming config information.
    

            // DISPVIDCTRL_DIMMING_CMDSETPDDCONFIG: user specific code start
            // DISPVIDCTRL_DIMMING_CMDSETPDDCONFIG: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DIMMING_CMDLOADPDDCONFIG:
        {
            // Loads the PDD dimming config information.
    

            // DISPVIDCTRL_DIMMING_CMDLOADPDDCONFIG: user specific code start
            // DISPVIDCTRL_DIMMING_CMDLOADPDDCONFIG: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_VIDEO_DEVVIDEO_READ:
        {
            // read a value via dev video interface (parameter is control).
            tU32 param1 = ((tU32)puchData[3] << 24) | ((tU32)puchData[4] << 16) | ((tU32)puchData[5] <<  8) | (tU32)puchData[6];
    

            // DISPVIDCTRL_DISPVIDCTRL_VIDEO_DEVVIDEO_READ: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            // DISPVIDCTRL_DISPVIDCTRL_VIDEO_DEVVIDEO_READ: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_VIDEO_DEVVIDEO_WRITE:
        {
            // write a value via dev video (parameter are control and value).
            tU32 param1 = ((tU32)puchData[3] << 24) | ((tU32)puchData[4] << 16) | ((tU32)puchData[5] <<  8) | (tU32)puchData[6];
            tU8 param2 = puchData[7];
            tU32 param3 = ((tU32)puchData[8] << 24) | ((tU32)puchData[9] << 16) | ((tU32)puchData[10] <<  8) | (tU32)puchData[11];
    

            // DISPVIDCTRL_DISPVIDCTRL_VIDEO_DEVVIDEO_WRITE: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param2);
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param3);
            // DISPVIDCTRL_DISPVIDCTRL_VIDEO_DEVVIDEO_WRITE: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DIMMING_GETDISPLAYSETTINGS:
        {
            // Prints display settings properties and states.
    

            // DISPVIDCTRL_DIMMING_GETDISPLAYSETTINGS: user specific code start
            // DISPVIDCTRL_DIMMING_GETDISPLAYSETTINGS: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DIMMING_RESETDISPLAYSETTINGS:
        {
            // Resets display settings properties and states to default values.
    

            // DISPVIDCTRL_DIMMING_RESETDISPLAYSETTINGS: user specific code start
            // DISPVIDCTRL_DIMMING_RESETDISPLAYSETTINGS: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DIMMING_SETCSCCONTRASTLEVEL:
        {
            // Set the contrast level (0 ... 32) of color space conversion.
            tU8 param1 = puchData[3];
    

            // DISPVIDCTRL_DIMMING_SETCSCCONTRASTLEVEL: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            // DISPVIDCTRL_DIMMING_SETCSCCONTRASTLEVEL: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DIMMING_SETCSCCONTRAST:
        {
            // Set the contrast in percent (0 ... 100) of color space conversion.
            tU8 param1 = puchData[3];
    

            // DISPVIDCTRL_DIMMING_SETCSCCONTRAST: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            // DISPVIDCTRL_DIMMING_SETCSCCONTRAST: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DIMMING_SETCSCSATURATIONLEVEL:
        {
            // Set the saturation level (0 ... 32) of color space conversion.
            tU8 param1 = puchData[3];
    

            // DISPVIDCTRL_DIMMING_SETCSCSATURATIONLEVEL: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            // DISPVIDCTRL_DIMMING_SETCSCSATURATIONLEVEL: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DIMMING_SETCSCSATURATION:
        {
            // Set the saturation in percent (0 ... 100) of color space conversion.
            tU8 param1 = puchData[3];
    

            // DISPVIDCTRL_DIMMING_SETCSCSATURATION: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            // DISPVIDCTRL_DIMMING_SETCSCSATURATION: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DIMMING_SETCSCSATURATIONOFFSET:
        {
            // Set the saturation offset in percent (0 ... 100) of color space conversion.
            tU8 param1 = puchData[3];
    

            // DISPVIDCTRL_DIMMING_SETCSCSATURATIONOFFSET: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            // DISPVIDCTRL_DIMMING_SETCSCSATURATIONOFFSET: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DIMMING_SETCSCCOLORLEVEL:
        {
            // Set the color level (0 ... 32) of color space conversion.
            tU8 param1 = puchData[3];
    

            // DISPVIDCTRL_DIMMING_SETCSCCOLORLEVEL: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            // DISPVIDCTRL_DIMMING_SETCSCCOLORLEVEL: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DIMMING_SETCSCCOLOR:
        {
            // Set the color / hue in degree (-180 ... 180) of color space conversion.
            tU16 param1 = ((tU16)puchData[3] <<  8) | (tU16)puchData[4];
    

            // DISPVIDCTRL_DIMMING_SETCSCCOLOR: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            // DISPVIDCTRL_DIMMING_SETCSCCOLOR: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DIMMING_SETCSCCOLOROFFSET:
        {
            // Set the color offset / hue offset in degree (-180 ... 180) of color space conversion.
            tU16 param1 = ((tU16)puchData[3] <<  8) | (tU16)puchData[4];
    

            // DISPVIDCTRL_DIMMING_SETCSCCOLOROFFSET: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            // DISPVIDCTRL_DIMMING_SETCSCCOLOROFFSET: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DIMMING_SETCSCBRIGHTNESS:
        {
            // Set the brightness in percent (0 ... 100) of color space conversion.
            tU8 param1 = puchData[3];
    

            // DISPVIDCTRL_DIMMING_SETCSCBRIGHTNESS: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            // DISPVIDCTRL_DIMMING_SETCSCBRIGHTNESS: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DIMMING_SETCSCBRIGHTNESSOFFSET:
        {
            // Set the brightness offset in percent (0 ... 100) of color space conversion.
            tU8 param1 = puchData[3];
    

            // DISPVIDCTRL_DIMMING_SETCSCBRIGHTNESSOFFSET: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            // DISPVIDCTRL_DIMMING_SETCSCBRIGHTNESSOFFSET: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DIMMING_SETCSCBLACKLEVEL:
        {
            // Set the black level (0 ... 32) of color space conversion.
            tU8 param1 = puchData[3];
    

            // DISPVIDCTRL_DIMMING_SETCSCBLACKLEVEL: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            // DISPVIDCTRL_DIMMING_SETCSCBLACKLEVEL: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DIMMING_SETCSCGAMMALEVEL:
        {
            // Set the gamma adjustment level (0 ... 32) of color space conversion.
            tU8 param1 = puchData[3];
    

            // DISPVIDCTRL_DIMMING_SETCSCGAMMALEVEL: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            // DISPVIDCTRL_DIMMING_SETCSCGAMMALEVEL: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DIMMING_SETCSCGAMMA:
        {
            // Set the gamma adjustment (500 = 0.500 ... 2500 = 2.500) of color space conversion.
            tU16 param1 = ((tU16)puchData[3] <<  8) | (tU16)puchData[4];
    

            // DISPVIDCTRL_DIMMING_SETCSCGAMMA: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            // DISPVIDCTRL_DIMMING_SETCSCGAMMA: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DIMMING_GETGENERALSTATUSINFO:
        {
            // Get the general dimming status information.
    

            // DISPVIDCTRL_DIMMING_GETGENERALSTATUSINFO: user specific code start
            // DISPVIDCTRL_DIMMING_GETGENERALSTATUSINFO: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DIMMING_GETBERR_STATE:
        {
            // Get the backlight error detetction status information.
    

            // DISPVIDCTRL_DIMMING_GETBERR_STATE: user specific code start
            // DISPVIDCTRL_DIMMING_GETBERR_STATE: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DIMMING_SETBERR:
        {
            // Set the state of specified backlight error.
            tU8 param1 = puchData[3];
            tU8 param2 = puchData[4];
    

            // DISPVIDCTRL_DIMMING_SETBERR: user specific code start
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param1);
            OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(param2);
            // DISPVIDCTRL_DIMMING_SETBERR: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_SET_DEFAULT_EARLY_CONFIG:
        {
            // Set the early configuration value to default in the data pool
    

            // DISPVIDCTRL_DISPVIDCTRL_SET_DEFAULT_EARLY_CONFIG: user specific code start

            // DISPVIDCTRL_DISPVIDCTRL_SET_DEFAULT_EARLY_CONFIG: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_PROFILE_PREPARE_TRIGGER:
        {
            // 
    

            // DISPVIDCTRL_DISPVIDCTRL_PROFILE_PREPARE_TRIGGER: user specific code start
        	I_dispvidctrl_tclProfileManagerIf* pProfileMgrAppl = dynamic_cast<I_dispvidctrl_tclProfileManagerIf*> (dispvidctrl_tclAppMain::_poMainAppInstance->getHandler("dispvidctrl_tclProfileManager"));
            if(pProfileMgrAppl != NULL)
            {
            	pProfileMgrAppl->vHandlePrepareTrigger();
            }
            ETG_TRACE_USR4((": DISPVIDCTRL_DISPVIDCTRL_PROFILE_PREPARE_TRIGGER TTFIS command, Call: pProfileMgrAppl->vHandlePrepareTrigger(); "));
            // DISPVIDCTRL_DISPVIDCTRL_PROFILE_PREPARE_TRIGGER: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_PROFILE_USERCHANGE_TRIGGER:
        {
            // 
            tU8 param1 = puchData[3];
    

            // DISPVIDCTRL_DISPVIDCTRL_PROFILE_USERCHANGE_TRIGGER: user specific code start
        	I_dispvidctrl_tclProfileManagerIf* pProfileMgrAppl = dynamic_cast<I_dispvidctrl_tclProfileManagerIf*> (dispvidctrl_tclAppMain::_poMainAppInstance->getHandler("dispvidctrl_tclProfileManager"));
            if(pProfileMgrAppl != NULL)
            {
            	if(puchData[3] != 0)
            	{
            		pProfileMgrAppl->vHandleProfileChangeTrigger();
            		ETG_TRACE_USR4((": DISPVIDCTRL_DISPVIDCTRL_PROFILE_USERCHANGE_TRIGGER (ID: %d) TTFIS, Call: pProfileMgrAppl->vHandlePrepareTrigger();", puchData[3]));
            	}
            	else
            	{
            		pProfileMgrAppl->vHandleResetProfileTrigger();
            		ETG_TRACE_USR4((": DISPVIDCTRL_DISPVIDCTRL_PROFILE_USERCHANGE_TRIGGER (ID: %d) TTFIS, Call: pProfileMgrAppl->vHandleResetProfileTrigger();", puchData[3]));
            	}
            }

            // DISPVIDCTRL_DISPVIDCTRL_PROFILE_USERCHANGE_TRIGGER: user specific code end
            
        }
        break;
    case DISPVIDCTRL_DIMMING_TOUCHDRIVERCONTROL:
        {
            // Trouch driver control of specified touch driver.
            tU8 param1 = puchData[3];
            tU8 param2 = puchData[4];
    

            // DISPVIDCTRL_DIMMING_TOUCHDRIVERCONTROL: user specific code start
            // DISPVIDCTRL_DIMMING_TOUCHDRIVERCONTROL: user specific code end
            
        }
        break;


    default:
        ETG_TRACE_USR4(("dispvidctrl_tclAppMain::vHandleTraceMessage(): unknown command %d.", u32MsgCode));
        break;
    }
    // dispvidctrl_tclAppMainFunction_vHandleTraceMessage: user specific code start
    // dispvidctrl_tclAppMainFunction_vHandleTraceMessage: user specific code end
    
    return;
}
// dispvidctrl_AppMain_trace: user specific code start
// dispvidctrl_AppMain_trace: user specific code end
