/**
  * @swcomponent   Life Cycle Management
  * @{
  * @file          dispvidctrl_ClientAvmSink.h
  * @PROJECT:      CMD project
  * @SW-COMPONENT: dispvidctrl
  * @Template:     MCanSink.h.tpl
  * ----------------------------------------------------------------------------
  *
  * @brief         generated file
  *                Tx Interface for MCAN communication
  *
  *                Do here client specific implementation
  *                Changes possible only inside tags
  *
  *                //......................: user specific code start 
  *                //......................: user specific code end
  *
  * ----------------------------------------------------------------------------
  * @copyright     (c) 2018 Robert Bosch GmbH.
  *                The reproduction, distribution and utilization of this file as well as the
  *                communication of its contents to others without express authorization is prohibited.
  *                Offenders will be held liable for the payment of damages.
  *                All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#ifndef AVMMCAN_CLIENT_SINK_H_
#define AVMMCAN_CLIENT_SINK_H_

#define MIDW_COMMON_S_IMPORT_INTERFACE_CSM
#define MIDW_COMMON_S_IMPORT_INTERFACE_MCAN
#include "midw_common_if.h"

#include "Idispvidctrl_ClientAvmSink.h"

class dispvidctrl_tclClientAvmSink : public TxSinkItf, public I_dispvidctrl_tclClientAvmSink
{
private:
   CSMInterface*  _poCSMInterface;

public:
   virtual const tChar* getName() const { return "dispvidctrl_tclClientAvmSink"; }

   virtual tVoid vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData) {};
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();

public:
   dispvidctrl_tclClientAvmSink(dispvidctrl_tclAppMain* baseRef);
   virtual ~dispvidctrl_tclClientAvmSink();

   virtual tVoid vSendSpeedLimit( tU8 _u8SpeedLimitValue );
   virtual tS32 DataReq(void *pvHandle, tU32 dwProtocolType, const void *pvAddressField, const tU8 *pbData, tU16 wDataLength);
   virtual tS32 ApplCallbackInit(void *pvHandle, tU32 dwProtocolType, void *pvAddressField, void *pvCallBackFkt);
   virtual tS32 CommunicationReq(void *pvHandle, tU8 bBus, tU32 dwProtocolType, const void *pvAddressField, tU8 bAction, tU16 wApplID);

// dispvidctrl_tclClientAvmSink::ClassImplementation: user specific code start
public:
    virtual tVoid vGetReferencesEarly(tVoid);
    virtual tVoid vStartCommunicationEarly(tVoid);
// dispvidctrl_tclClientAvmSink::ClassImplementation: user specific code end
};


#endif /* AVMMCAN_CLIENT_SINK_H_ */
