/*****************************************************************************
 * @file:         dispvidctrl_ClientAvmAdaptor.cpp
 * @PROJECT:      CMD project
 * @SW-COMPONENT: dispvidctrl
 * @Template:     MCanAdaptor.cpp.tpl
 * ----------------------------------------------------------------------------
 *
 * @brief:  generated file
 *          MCAN adapter
 *
 *          Do here client specific implementation
 *          Changes possible only inside tags
 *
 *          //......................: user specific code start 
 *          //......................: user specific code end
 *
 * ----------------------------------------------------------------------------
 * @copyright   (c) 2018 Robert Bosch GmbH.
 *              The reproduction, distribution and utilization of this file as
 *              well as the communication of its contents to others without express
 *              authorization is prohibited. Offenders will be held liable for the
 *              payment of damages. All rights reserved in the event of the grant
 *              of a patent, utility model or design.
 *****************************************************************************/

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

// tstdbusclient_ClientTestclIncludePart: user specific code start
// tstdbusclient_ClientTestclIncludePart: user specific code end

#include "dispvidctrl_ClientAvmAdaptor.h"
#include "dispvidctrl_ClientAvmSink.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DISPVIDCTRL_CLIENT_AVM
#include "trcGenProj/Header/dispvidctrl_ClientAvmAdaptor.cpp.trc.h"
#endif



#define DISPVIDCTRLC_AVAILABLE_FUNCTION  (0 )  





dispvidctrl_tclClientAvmAdaptor*    dispvidctrl_tclClientAvmAdaptor::_poMyOwnRef = NULL;  // my own static object


dispvidctrl_tclClientAvmAdaptor::dispvidctrl_tclClientAvmAdaptor(dispvidctrl_tclAppMain* baseRef)
: I_dispvidctrl_tclClientAvmAdaptor
( 
 baseRef, 
 0,
 NULL,
 0x00,//CSM_C_ADDRESS_FIELD_RN_MPDT_MAS, 
 0x01,//CSM_C_ADDRESS_FIELD_RN_MPDT_AVM3,
 FALSE,
 DISPVIDCTRLC_AVAILABLE_FUNCTION 
 )
, _pClientCallback(NULL)
{
   ETG_TRACE_USR1( ( "dispvidctrl_tclClientAvmAdaptor() entered" ) );
   _poMyOwnRef      = this;
   
  _u16MessageInSending = 0;   

   // tstdbusclient_ClientTestcldispvidctrl_tclClientAvmAdaptor: user specific code start
   // tstdbusclient_ClientTestcldispvidctrl_tclClientAvmAdaptor: user specific code end
}

dispvidctrl_tclClientAvmAdaptor::~dispvidctrl_tclClientAvmAdaptor(){
   ETG_TRACE_USR1( ( "~dispvidctrl_tclClientAvmAdaptor() entered" ) );
}

tVoid dispvidctrl_tclClientAvmAdaptor::vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg) {
    ETG_TRACE_USR4(("dispvidctrl_tclClientAvmAdaptor::vHandleMessage() entered %u.", ETG_CENUM(dispvidctrl_tclBaseIf::ECmdTypes, pMsg->eCmd)));
   // tstdbusclient_ClientTestclvHandleMessage: user specific code start
   // tstdbusclient_ClientTestclvHandleMessage: user specific code end

    if (pMsg->eCmd == dispvidctrl_tclBaseIf::eCmdMCanDataInd) {
        vHandleUnitSpecificDataIndCtxt(pMsg->u.tMCanMsg.u16MsgId, pMsg->u.tMCanMsg.u8Opcode, pMsg->tDataTrailer.pu8Data, pMsg->tDataTrailer.u32Len);
    }   
}

tVoid dispvidctrl_tclClientAvmAdaptor::vGetReferences() {
   // tstdbusclient_ClientTestclvGetReferences: user specific code start
   // tstdbusclient_ClientTestclvGetReferences: user specific code end
}

tVoid dispvidctrl_tclClientAvmAdaptor::vStartCommunication() {
   // tstdbusclient_ClientTestclvStartCommunication: user specific code start
   // tstdbusclient_ClientTestclvStartCommunication: user specific code end
}

tVoid dispvidctrl_tclClientAvmAdaptor::vTraceInfo() {
   // tstdbusclient_ClientTestclvTraceInfo: user specific code start
   // tstdbusclient_ClientTestclvTraceInfo: user specific code end
   std::vector < TMsgHistory >::iterator it;
   for (it = _vecMsgHistory.begin(); it != _vecMsgHistory.end(); ++it){
       if (it->bTxDirection) {
           ETG_TRACE_FATAL(("dispvidctrl_tclClientAvmAdaptor::vTraceInfo(): MSG TX: %04x, OPCODE: %02x, TS: %dms.", ETG_ENUM(tenAvmMessageName, it->u16MsgId), ETG_ENUM(eMcanOpcode, it->u8MsgOpcode), it->u32Timestamp));
       } else {
           ETG_TRACE_FATAL(("dispvidctrl_tclClientAvmAdaptor::vTraceInfo(): MSG RX: %04x, OPCODE: %02x, TS: %dms.", ETG_ENUM(tenAvmMessageName, it->u16MsgId), ETG_ENUM(eMcanOpcode, it->u8MsgOpcode), it->u32Timestamp));
       }
   }
   
}

tVoid dispvidctrl_tclClientAvmAdaptor::vHandleTraceMessage(const tUChar* puchData)
{
   DISPVIDCTRL_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("dispvidctrl_tclClientAvmAdaptor::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // dispvidctrl_tclClientAvmAdaptor::vHandleTraceMessage: user specific code start
   // dispvidctrl_tclClientAvmAdaptor::vHandleTraceMessage: user specific code end
}
/*************************************************************************
* FUNCTION: dispvidctrl_tclClientAvmAdaptor::vShowCommunicationState()
*
* DESCRIPTION: debug function to trace out the current communication state
*
* PARAMETER: None
*
* RETURNVALUE: None
*************************************************************************/
tVoid  dispvidctrl_tclClientAvmAdaptor::vShowCommunicationState()
{
    ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::vShowCommunicationState() entered"));
}

/*************************************************************************
* FUNCTION: dispvidctrl_tclClientAvmAdaptor::bUnitShouldBeAvailable()
*
* DESCRIPTION: call back function called by MCAN interface to check the unit availablity
*
* PARAMETER: None
*
* RETURNVALUE: success : true/false 
*************************************************************************/
tBool  dispvidctrl_tclClientAvmAdaptor::bUnitShouldBeAvailable()
{
    ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::bUnitShouldBeAvailable() entered"));
    tBool bRetVal = TRUE;

    /*
    if ( _poMainAppl && _poMainAppl->_poConfigHandler )
    {
    bRetVal = _poMainAppl->_poConfigHandler->bIsUnitConfigured();
    }
    */

    return bRetVal;
}

/*************************************************************************
* FUNCTION: dispvidctrl_tclClientAvmAdaptor::vShowVersioninfo()
*
* DESCRIPTION: debug function to trace out all version information
*
* PARAMETER: None
*
* RETURNVALUE: None
*************************************************************************/

tVoid  dispvidctrl_tclClientAvmAdaptor::vShowVersioninfo()
{
    ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::vShowVersioninfo() entered"));
}

/*************************************************************************
* FUNCTION: dispvidctrl_tclClientAvmAdaptor::bOnInit( CSMInterface* poCSMInterface )
*
* DESCRIPTION: setup and start the MCAN interface
*
* PARAMETER: poCSMInterface
*
* RETURNVALUE: success: true / false
*************************************************************************/
tBool dispvidctrl_tclClientAvmAdaptor::bOnInit()
{
    ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::bOnInit() entered"));
    tBool bRetVal = FALSE;

    // TO DO:
    // check for any validation

    TxSinkItf* pTxCsmInterface = dynamic_cast<TxSinkItf*>(_cpoMain->getHandler("I_dispvidctrl_tclClientAvmSink"));

    //fill with default values and overwrite these (if registry entry exists)
    tU32 u32MyPrio  = 80;
    tU32 u32MyStack = 1000;

    bRetVal = bOnStart( pTxCsmInterface, (tS32)u32MyStack, u32MyPrio );
    ETG_TRACE_USR4(("dispvidctrl_tclClientAvmAdaptor::bOnInit() returned : %d", bRetVal));

    return bRetVal;
}


/*************************************************************************
* FUNCTION: dispvidctrl_tclClientAvmAdaptor::vTraceError()
*
* DESCRIPTION: Print error information
*
* PARAMETER: enErrorCode
*
* RETURNVALUE: None
*************************************************************************/
tVoid dispvidctrl_tclClientAvmAdaptor::vTraceError( MCAN_tenErrorCode enErrorCode )
{
    ETG_TRACE_USR4(("dispvidctrl_tclClientAvmAdaptor::vTraceError() entered"));

    tU8 u8ErrorCode = AvmEnums::DISPVIDCTRLTRACE_ERROR_CODE_MAX;

    switch ( enErrorCode )
    {
    case MCAN_EN_ERROR_CODE_DELETE_COMMUNICATION_TEST_TIMER:
        {
            u8ErrorCode = AvmEnums::DISPVIDCTRLTRACE_ERROR_CODE_DELETE_COMMUNICATION_TEST_TIMER;
        }
        break;
    case MCAN_EN_ERROR_CODE_DELETE_CONFIGURATION_GET_TIMER:
        {
            u8ErrorCode = AvmEnums::DISPVIDCTRLTRACE_ERROR_CODE_DELETE_CONFIGURATION_GET_TIMER;
        }
        break;
    case MCAN_EN_ERROR_CODE_DELETE_HARDWARE_VERSION_GET_TIMER:
        {
            u8ErrorCode = AvmEnums::DISPVIDCTRLTRACE_ERROR_CODE_DELETE_HARDWARE_VERSION_GET_TIMER;
        }
        break;
    case MCAN_EN_ERROR_CODE_DELETE_SOFTWARE_VERSION_GET_TIMER:
        {
            u8ErrorCode = AvmEnums::DISPVIDCTRLTRACE_ERROR_CODE_DELETE_SOFTWARE_VERSION_GET_TIMER;
        }
        break;
    case MCAN_EN_ERROR_CODE_ACCESS_WORKER_EVENTS:
        {
            u8ErrorCode = AvmEnums::DISPVIDCTRLTRACE_ERROR_CODE_ACCESS_WORKER_EVENTS;
        }
        break;
    case MCAN_EN_ERROR_CODE_CREATE_WORKER_EVENTS:
        {
            u8ErrorCode = AvmEnums::DISPVIDCTRLTRACE_ERROR_CODE_CREATE_WORKER_EVENTS;
        }
        break;
    case MCAN_EN_ERROR_CODE_CREATE_WORKER_ACCESS_SEMAPHORE:
        {
            u8ErrorCode = AvmEnums::DISPVIDCTRLTRACE_ERROR_CODE_CREATE_WORKER_ACCESS_SEMAPHORE;
        }
        break;
    case MCAN_EN_ERROR_CODE_SPAWN_WORKER_THREAD:
        {
            u8ErrorCode = AvmEnums::DISPVIDCTRLTRACE_ERROR_CODE_SPAWN_WORKER_THREAD;
        }
        break;
    case MCAN_EN_ERROR_CODE_DELETE_WORKER_THREAD:
        {
            u8ErrorCode = AvmEnums::DISPVIDCTRLTRACE_ERROR_CODE_DELETE_WORKER_THREAD;
        }
        break;
    case MCAN_EN_ERROR_CODE_CLOSE_WORKER_ACCESS_SEMAPHORE:
        {
            u8ErrorCode = AvmEnums::DISPVIDCTRLTRACE_ERROR_CODE_CLOSE_WORKER_ACCESS_SEMAPHORE;
        }
        break;
    case MCAN_EN_ERROR_CODE_DELETE_WORKER_ACCESS_SEMAPHORE:
        {
            u8ErrorCode = AvmEnums::DISPVIDCTRLTRACE_ERROR_CODE_DELETE_WORKER_ACCESS_SEMAPHORE;
        }
        break;
    case MCAN_EN_ERROR_CODE_CLOSE_WORKER_EVENTS:
        {
            u8ErrorCode = AvmEnums::DISPVIDCTRLTRACE_ERROR_CODE_CLOSE_WORKER_EVENTS;
        }
        break;
    case MCAN_EN_ERROR_CODE_DELETE_WORKER_EVENTS:
        {
            u8ErrorCode = AvmEnums::DISPVIDCTRLTRACE_ERROR_CODE_DELETE_WORKER_EVENTS;
        }
        break;
    case MCAN_EN_ERROR_CODE_CREATE_COMMUNICATION_TEST_TIMER:
        {
            u8ErrorCode = AvmEnums::DISPVIDCTRLTRACE_ERROR_CODE_CREATE_COMMUNICATION_TEST_TIMER;
        }
        break;
    case MCAN_EN_ERROR_CODE_CREATE_CONFIGURATION_GET_TIMER:
        {
            u8ErrorCode = AvmEnums::DISPVIDCTRLTRACE_ERROR_CODE_CREATE_CONFIGURATION_GET_TIMER;
        }
        break;
    case MCAN_EN_ERROR_CODE_CREATE_HARDWARE_VERSION_GET_TIMER:
        {
            u8ErrorCode = AvmEnums::DISPVIDCTRLTRACE_ERROR_CODE_CREATE_HARDWARE_VERSION_GET_TIMER;
        }
        break;
    case MCAN_EN_ERROR_CODE_CREATE_SOFTWARE_VERSION_GET_TIMER:
        {
            u8ErrorCode = AvmEnums::DISPVIDCTRLTRACE_ERROR_CODE_CREATE_SOFTWARE_VERSION_GET_TIMER;
        }
        break;
    case MCAN_EN_ERROR_CODE_SET_COMMUNICATION_TEST_TIMER:
        {
            u8ErrorCode = AvmEnums::DISPVIDCTRLTRACE_ERROR_CODE_SET_COMMUNICATION_TEST_TIMER;
        }
        break;
    case MCAN_EN_ERROR_CODE_SET_CONFIGURATION_GET_TIMER:
        {
            u8ErrorCode = AvmEnums::DISPVIDCTRLTRACE_ERROR_CODE_SET_CONFIGURATION_GET_TIMER;
        }
        break;
    case MCAN_EN_ERROR_CODE_SET_HARDWARE_VERSION_GET_TIMER:
        {
            u8ErrorCode = AvmEnums::DISPVIDCTRLTRACE_ERROR_CODE_SET_HARDWARE_VERSION_GET_TIMER;
        }
        break;
    case MCAN_EN_ERROR_CODE_SET_SOFTWARE_VERSION_GET_TIMER:
        {
            u8ErrorCode = AvmEnums::DISPVIDCTRLTRACE_ERROR_CODE_SET_SOFTWARE_VERSION_GET_TIMER;
        }
        break;
    default:
        break;
    }

    if ( u8ErrorCode < AvmEnums::DISPVIDCTRLTRACE_ERROR_CODE_MAX )
    {
        ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::vTraceError()::ERROR_CODE = %d", ETG_ENUM(AvmEnums::TRACE_ERROR_CODE, u8ErrorCode)));
    }
}


/*************************************************************************
* FUNCTION: dispvidctrl_tclClientAvmAdaptor::vTraceIncomingMessage( tU16 u16MsgId, tU8 u8OpTypeCode, tU8* pu8Data, tU16 u16DataLength )
*
* DESCRIPTION: print incoming MCAN Message
*
* PARAMETER: u16MsgId
*            u8OpTypeCode
*            pu8Data
*            u16DataLength
*
* RETURNVALUE: None
*************************************************************************/
tVoid dispvidctrl_tclClientAvmAdaptor::vTraceIncomingMessage( tU16 u16MsgId, tU8 u8OpTypeCode, tU8* pu8Data, tU16 u16DataLength )
{
    ETG_TRACE_USR4(("dispvidctrl_tclClientAvmAdaptor::vTraceIncomingMessage() entered"));
    if ( pu8Data && ( u16DataLength > 0 ) )
    {
        //std::string message;
        std::basic_string<tU8> mcanData(pu8Data, u16DataLength);

        ETG_TRACE_USR4(("dispvidctrl_tclClientAvmAdaptor::vTraceIncomingMessage() : Length - %d | MsgId - %d | OpTypeCode - %d | Data - %s", u16DataLength, u16MsgId, u8OpTypeCode, mcanData.c_str()));
    }
    else
    {
        ETG_TRACE_USR4(("dispvidctrl_tclClientAvmAdaptor::vTraceIncomingMessage() : MsgId - %d | OpTypeCode - %d ", u16MsgId, u8OpTypeCode));
    }
}


/*************************************************************************
* FUNCTION: dispvidctrl_tclClientAvmAdaptor::vTraceConnectionStateConnected()
*
* DESCRIPTION:  debug function to trace out the connection state connected
*
* PARAMETER: None
*
* RETURNVALUE: None
*************************************************************************/
tVoid dispvidctrl_tclClientAvmAdaptor::vTraceConnectionStateConnected()
{
    ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::vTraceConnectionStateConnected() entered"));
    ETG_TRACE_USR4(("dispvidctrl_tclClientAvmAdaptor::vTraceConnectionStateConnected()::CommStatus - %d ", ETG_CENUM(AvmEnums::MCAN_tenComStatus, enGetCommStatus())));
}


/*************************************************************************
* FUNCTION: dispvidctrl_tclClientAvmAdaptor::vTraceConnectionStateDisconnected( tBool bInfoFromIndication )
*
* DESCRIPTION: debug function to trace out the connection state disconnected
*
* PARAMETER: bInfoFromIndication
*
* RETURNVALUE: None
*************************************************************************/
tVoid dispvidctrl_tclClientAvmAdaptor::vTraceConnectionStateDisconnected( tBool bInfoFromIndication )
{
    ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::vTraceConnectionStateDisconnected() entered"));
    ETG_TRACE_USR4(("dispvidctrl_tclClientAvmAdaptor::vTraceConnectionStateDisconnected()::bInfoFromIndication - %d ", ETG_CENUM(AvmEnums::BOOL, bInfoFromIndication)));
    ETG_TRACE_USR4(("dispvidctrl_tclClientAvmAdaptor::vTraceConnectionStateDisconnected()::CommStatus - %d ", ETG_CENUM(AvmEnums::MCAN_tenComStatus, enGetCommStatus())));
}


/*************************************************************************
* FUNCTION: dispvidctrl_tclClientAvmAdaptor::vTraceCommunicationRequestConnect()
*
* DESCRIPTION: debug function to trace out the communication request connect
*
* PARAMETER: None
*
* RETURNVALUE: None
*************************************************************************/
tVoid dispvidctrl_tclClientAvmAdaptor::vTraceCommunicationRequestConnect()
{
    ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::vTraceCommunicationRequestConnect() entered"));
}


/*************************************************************************
* FUNCTION: dispvidctrl_tclClientAvmAdaptor::vTraceCommunicationRequestDisconnect()
*
* DESCRIPTION: debug function to trace out the communication request disconnect
*
* PARAMETER: None
*
* RETURNVALUE: None
*************************************************************************/
tVoid dispvidctrl_tclClientAvmAdaptor::vTraceCommunicationRequestDisconnect()
{
    ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::vTraceCommunicationRequestDisconnect() entered"));
}


/*************************************************************************
* FUNCTION: dispvidctrl_tclClientAvmAdaptor::vTraceSendingConfigurationGet()
*
* DESCRIPTION: debug function to trace out configuration get
*
* PARAMETER: None
*
* RETURNVALUE: None
*************************************************************************/
tVoid dispvidctrl_tclClientAvmAdaptor::vTraceSendingConfigurationGet()
{
    ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::vTraceSendingConfigurationGet() entered"));
}


/*************************************************************************
* FUNCTION: dispvidctrl_tclClientAvmAdaptor::vTraceSendingConfigurationStatus()
*
* DESCRIPTION: debug function to trace out configuration status
*
* PARAMETER: None
*
* RETURNVALUE: None
*************************************************************************/
tVoid dispvidctrl_tclClientAvmAdaptor::vTraceSendingConfigurationStatus()
{
    ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::vTraceSendingConfigurationStatus() entered"));
}


/*************************************************************************
* FUNCTION: dispvidctrl_tclClientAvmAdaptor::vTraceSendingHardwareVersionGet()
*
* DESCRIPTION: debug function to trace out hardware version get
*
* PARAMETER: None
*
* RETURNVALUE: None
*************************************************************************/
tVoid dispvidctrl_tclClientAvmAdaptor::vTraceSendingHardwareVersionGet()
{
    ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::vTraceSendingHardwareVersionGet() entered"));
}


/*************************************************************************
* FUNCTION: dispvidctrl_tclClientAvmAdaptor::vTraceSendingSoftwareVersionGet()
*
* DESCRIPTION: debug function to trace out software version get
*
* PARAMETER: None
*
* RETURNVALUE: None
*************************************************************************/
tVoid dispvidctrl_tclClientAvmAdaptor::vTraceSendingSoftwareVersionGet()
{
    ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::vTraceSendingSoftwareVersionGet() entered"));
}


/*************************************************************************
* FUNCTION: dispvidctrl_tclClientAvmAdaptor::vTraceBasicTimerEvent( MCAN_tenBasicTimer enTimer )
*
* DESCRIPTION: Trace Basic Timer Event Handler
*
* PARAMETER: enTimer
*
* RETURNVALUE: None
*************************************************************************/
tVoid dispvidctrl_tclClientAvmAdaptor::vTraceBasicTimerEvent( MCAN_tenBasicTimer enTimer )
{
    ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::vTraceBasicTimerEvent() entered"));
    tU8 u8TraceID = 0;

    switch ( enTimer )
    {
    case MCAN_EN_BASIC_TIMER_COMMUNICATION_TEST:
        {
            u8TraceID = AvmEnums::DISPVIDCTRLTRACE_MCAN_EV_COMMUNICATION_TEST_TIMER;
        }
        break;
    case MCAN_EN_BASIC_TIMER_CONFIGURATION_GET:
        {
            u8TraceID = AvmEnums::DISPVIDCTRLTRACE_MCAN_EV_CONFIGURATION_GET_TIMER;
        }
        break;
    case MCAN_EN_BASIC_TIMER_HARDWARE_VERSION_GET:
        {
            u8TraceID = AvmEnums::DISPVIDCTRLTRACE_MCAN_EV_HARDWARE_VERSION_GET_TIMER;
        }
        break;
    case MCAN_EN_BASIC_TIMER_SOFTWARE_VERSION_GET:
        {
            u8TraceID = AvmEnums::DISPVIDCTRLTRACE_MCAN_EV_SOFTWARE_VERSION_GET_TIMER;
        }
        break;
    default:
        break;
    }

    if ( 0 != u8TraceID )
    {
        ETG_TRACE_USR4(("dispvidctrl_tclClientAvmAdaptor::vTraceBasicTimerEvent()::Timer Expired = %d",ETG_ENUM(AvmEnums::TRACE_TIMER_CODE, u8TraceID)));
    }

}



/*******************************************************************************
* FUNCTION   : dispvidctrl_tclClientAvmAdaptor::vTraceBasicTimerSet( MCAN_tenBasicTimer enTimer, OSAL_tMSecond msTimeout )
*
* DESCRIPTION: Trace Basic Timer Event Setting
*
* PARAMETER  : enTimer
*`             msTimeout
*
* RETURNVALUE: None
*******************************************************************************/

tVoid dispvidctrl_tclClientAvmAdaptor::vTraceBasicTimerSet( MCAN_tenBasicTimer enTimer, OSAL_tMSecond msTimeout )
{
    ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::vTraceBasicTimerSet() entered"));
    tU8 u8TraceID = 0;

    switch ( enTimer )
    {
    case MCAN_EN_BASIC_TIMER_COMMUNICATION_TEST:
        {
            u8TraceID = AvmEnums::DISPVIDCTRLTRACE_MCAN_SET_COMMUNICATION_TEST_TIMER;
        }
        break;
    case MCAN_EN_BASIC_TIMER_CONFIGURATION_GET:
        {
            u8TraceID = AvmEnums::DISPVIDCTRLTRACE_MCAN_SET_CONFIGURATION_GET_TIMER;
        }
        break;
    case MCAN_EN_BASIC_TIMER_HARDWARE_VERSION_GET:
        {
            u8TraceID = AvmEnums::DISPVIDCTRLTRACE_MCAN_SET_HARDWARE_VERSION_GET_TIMER;
        }
        break;
    case MCAN_EN_BASIC_TIMER_SOFTWARE_VERSION_GET:
        {
            u8TraceID = AvmEnums::DISPVIDCTRLTRACE_MCAN_SET_SOFTWARE_VERSION_GET_TIMER;
        }
        break;
    default:
        break;
    }

    if ( 0 != u8TraceID )
    {
        ETG_TRACE_USR4(("dispvidctrl_tclClientAvmAdaptor::vTraceBasicTimerSet()::Timer Expired = %d, msTimeout = %u",ETG_ENUM(AvmEnums::TRACE_TIMER_CODE, u8TraceID), msTimeout));

        // for lint
        (void) msTimeout;
    }

}

/*******************************************************************************
* FUNCTION   : dispvidctrl_tclClientAvmAdaptor::vDoActionsAfterChangeToOn()
*
* DESCRIPTION: function called when the system changes to ON without change of connection
*              -> retrigger all messages that were blocked during "not ON"
*
* PARAMETER  : None.
*
* RETURNVALUE: None
*******************************************************************************/
tVoid dispvidctrl_tclClientAvmAdaptor::vDoActionsAfterChangeToOn()
{
    ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::vDoActionsAfterChangeToOn() entered"));
    // TO DO 
    // no requirements are defined as of now

    // trigger worker thread to evaluate trigger flags
    vSetChangedEvent();
}


/*******************************************************************************
* FUNCTION   : dispvidctrl_tclClientAvmAdaptor::vDoActionsAfterLeavingOn()
*
* DESCRIPTION: function called when the system leaves ON without change of connection
*
* PARAMETER  : None.
*
* RETURNVALUE: None
*******************************************************************************/
tVoid dispvidctrl_tclClientAvmAdaptor::vDoActionsAfterLeavingOn()
{
    ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::vDoActionsAfterLeavingOn() entered"));
    // TO DO 
    // no requirements are defined as of now
    _poMyOwnRef->vHandleCDataCon( 0 );
    
    vSetChangedEvent();                         // trigger worker thread
}


/*******************************************************************************
* FUNCTION   : dispvidctrl_tclClientAvmAdaptor::csm_callback_vCommunicationCon ( tVoid* pvHandle,
tU8 u8Bus,
tU32 u32ProtocolType, 
const tVoid* pvAddressfield, 
tU8 u8ConnectState, 
tU16 u16ApplId )
*
* DESCRIPTION: callbacks for the CSM interface Communication Con
*
* PARAMETER  : 
*
* RETURNVALUE: None
*******************************************************************************/
tVoid  dispvidctrl_tclClientAvmAdaptor::csm_callback_vCommunicationCon ( tVoid* pvHandle,
                                                                      tU8 u8Bus,
                                                                      tU32 u32ProtocolType, 
                                                                      const tVoid* pvAddressfield, 
                                                                      tU8 u8ConnectState, 
                                                                      tU16 u16ApplId )
{
    ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::csm_callback_vCommunicationCon() entered: state --> '%d'", u8ConnectState ));
    if ( _poMyOwnRef )
    {
        _poMyOwnRef->vHandleCommunicationCon( u8ConnectState );
    }

    // for future use?
    (tVoid)pvHandle;
    (tVoid)u8Bus;
    (tVoid)u32ProtocolType;
    (tVoid)pvAddressfield;
    (tVoid)u16ApplId;
}


/*******************************************************************************
* FUNCTION   : dispvidctrl_tclClientAvmAdaptor::csm_callback_vCommunicationInd( tVoid* pvHandle,
tU8 u8Bus,
tU32 u32ProtocolType, 
const tVoid* pvAddressfield, 
tU8 u8ConnectState, 
tU16 u16ApplId )
*
* DESCRIPTION: callbacks for the CSM interface Communication Ind
*
* PARAMETER  : 
*
* RETURNVALUE: None
*******************************************************************************/
tVoid  dispvidctrl_tclClientAvmAdaptor::csm_callback_vCommunicationInd ( tVoid* pvHandle,
                                                                      tU8 u8Bus, 
                                                                      tU32 u32ProtocolType, 
                                                                      const tVoid* pvAddressfield, 
                                                                      tU8 u8ConnectState, 
                                                                      tU16 u16ApplId )
{
    ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::csm_callback_vCommunicationInd() entered"));
    if ( _poMyOwnRef )
    {
        _poMyOwnRef->vHandleCommunicationInd( u8ConnectState );
    }

    // for future use?
    (tVoid)pvHandle;
    (tVoid)u8Bus;
    (tVoid)u32ProtocolType;
    (tVoid)pvAddressfield;
    (tVoid)u16ApplId;
}


/*******************************************************************************
* FUNCTION   : dispvidctrl_tclClientAvmAdaptor::csm_callback_vCDataCon( tVoid* pvHandle,
tU8 u8Bus,
tU32 u32ProtocolType, 
const tVoid* pvAddressfield, 
tU8 u8ConnectState, 
tU16 u16ApplId )
*
* DESCRIPTION: callbacks for the CSM interface CData Con
*
* PARAMETER  : 
*
* RETURNVALUE: None
*******************************************************************************/
tVoid  dispvidctrl_tclClientAvmAdaptor::csm_callback_vCDataCon ( tVoid* pvHandle, 
                                                              tU32 u32ProtocolType, 
                                                              const tVoid* pvAddressfield, 
                                                              tU8 u8State )
{
    ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::csm_callback_vCDataCon() entered"));
    if ( _poMyOwnRef )
    {
        _poMyOwnRef->_cpoMain->theServer()->vPostMsgAvmUpdate("I_dispvidctrl_tclMCanClientAvmFsm");
        _poMyOwnRef->_cpoMain->theServer()->vPostMsgAvmMsgSend("I_dispvidctrl_tclMCanClientAvmFsm", _poMyOwnRef->_u16MessageInSending);
        _poMyOwnRef->vHandleCDataCon( u8State );
    }

    // for future use?
    (tVoid)pvHandle;
    (tVoid)u32ProtocolType;
    (tVoid)pvAddressfield;
    (tVoid)u8State;
}

/*******************************************************************************
* FUNCTION   : dispvidctrl_tclClientAvmAdaptor::csm_callback_vCDataInd(  tVoid* pvHandle,
tU32 u32ProtocolType, 
const tVoid* pvAddressfield, 
tU8* pu8Data, 
tU16 u16Length )
*
* DESCRIPTION: callbacks for the CSM interface CData Ind
*
* PARAMETER  : 
*
* RETURNVALUE: None
*******************************************************************************/

tVoid  dispvidctrl_tclClientAvmAdaptor::csm_callback_vCDataInd ( tVoid* pvHandle, 
                                                              tU32 u32ProtocolType, 
                                                              const tVoid* pvAddressfield, 
                                                              tU8* pu8Data, 
                                                              tU16 u16Length )
{
    ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::csm_callback_vCDataInd() entered"));
    if ( _poMyOwnRef )
    {
        _poMyOwnRef->vHandleDataInd( pu8Data, u16Length );
    }

    // for future use?
    (tVoid)pvHandle;
    (tVoid)u32ProtocolType;
    (tVoid)pvAddressfield;
}


/*******************************************************************************
* FUNCTION   : dispvidctrl_tclClientAvmAdaptor::csm_callback_vCDataCon( tVoid* pvHandle,
tU32 u32ProtocolType, 
const tVoid* pvAddressfield, 
tU8 u8State )
*
* DESCRIPTION:  callbacks for the CSM interface CData Con
*
* PARAMETER  : 
*
* RETURNVALUE: None
*******************************************************************************/
tVoid  dispvidctrl_tclClientAvmAdaptor::csm_callback_vDDataCon ( tVoid* pvHandle, 
                                                              tU32 u32ProtocolType, 
                                                              const tVoid* pvAddressfield, 
                                                              tU8 u8State )
{
    ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::csm_callback_vDDataCon() entered"));
    if ( _poMyOwnRef )
    {
        _poMyOwnRef->_cpoMain->theServer()->vPostMsgAvmUpdate("I_dispvidctrl_tclMCanClientAvmFsm");
        _poMyOwnRef->_cpoMain->theServer()->vPostMsgAvmMsgSend("I_dispvidctrl_tclMCanClientAvmFsm", _poMyOwnRef->_u16MessageInSending);
        _poMyOwnRef->vHandleDDataCon( u8State );
    }

    // for future use?
    (tVoid)pvHandle;
    (tVoid)u32ProtocolType;
    (tVoid)pvAddressfield;
    (tVoid)u8State;
}



/*******************************************************************************
* FUNCTION   : dispvidctrl_tclClientAvmAdaptor::csm_callback_vCDataInd(  tVoid* pvHandle,
tU32 u32ProtocolType, 
const tVoid* pvAddressfield, 
tU8* pu8Data, 
tU16 u16Length )
*
* DESCRIPTION:   callbacks for the CSM interface CData Ind
*
* PARAMETER  : 
*
* RETURNVALUE: None
*******************************************************************************/
tVoid  dispvidctrl_tclClientAvmAdaptor::csm_callback_vDDataInd ( tVoid* pvHandle, 
                                                              tU32 u32ProtocolType, 
                                                              const tVoid* pvAddressfield, 
                                                              tU8* pu8Data, 
                                                              tU16 u16Length )
{
    ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::csm_callback_vDDataInd() entered"));
    if ( _poMyOwnRef )
    {
        _poMyOwnRef->vHandleDataInd( pu8Data, u16Length );
    }

    // for future use?
    (tVoid)pvHandle;
    (tVoid)u32ProtocolType;
    (tVoid)pvAddressfield;
}

/*************************************************************************
* FUNCTION: dispvidctrl_tclClientAvmAdaptor::vSendConnection()
*
* DESCRIPTION: send Connect
*
* PARAMETER: None
*
* RETURNVALUE: None
*************************************************************************/
tVoid  dispvidctrl_tclClientAvmAdaptor::vSendConnection()
{

    ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::vSendConnection() entered"));
    // dispvidctrl_tclMCanClientAvm::vSendConnection: user specific code start
    // dispvidctrl_tclMCanClientAvm::vSendConnection: user specific code end
}


/*************************************************************************
* FUNCTION:  dispvidctrl_tclClientAvmAdaptor::vSendConfiguration()
*
* DESCRIPTION: send Configuration
*
* PARAMETER: None
*
* RETURNVALUE: None
*************************************************************************/
tVoid  dispvidctrl_tclClientAvmAdaptor::vSendConfiguration()
{
    ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::vSendConfiguration() entered"));
    // dispvidctrl_tclMCanClientAvm::vSendConfiguration: user specific code start
    // dispvidctrl_tclMCanClientAvm::vSendConfiguration: user specific code end
    
}

/*************************************************************************
* FUNCTION:  dispvidctrl_tclClientAvmAdaptor::vSendHardwareVersion()
*
* DESCRIPTION: send Hardware version
*
* PARAMETER: None
*
* RETURNVALUE: None
*************************************************************************/
tVoid  dispvidctrl_tclClientAvmAdaptor::vSendHardwareVersion()
{
    ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::vSendHardwareVersion() entered"));
    // dispvidctrl_tclMCanClientAvm::vSendHardwareVersion: user specific code start
    // dispvidctrl_tclMCanClientAvm::vSendHardwareVersion: user specific code end

}

/*************************************************************************
* FUNCTION: dispvidctrl_tclClientAvmAdaptor::vSendSoftwareVersion()
*
* DESCRIPTION:  send Software version
*
* PARAMETER: None
*
* RETURNVALUE: None
*************************************************************************/
tVoid  dispvidctrl_tclClientAvmAdaptor::vSendSoftwareVersion()
{
    ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::vSendSoftwareVersion() entered"));
    // dispvidctrl_tclMCanClientAvm::vSendSoftwareVersion: user specific code start
    // dispvidctrl_tclMCanClientAvm::vSendSoftwareVersion: user specific code end
}


/*************************************************************************
* FUNCTION:  dispvidctrl_tclClientAvmAdaptor::vSendDataTransmission()
*
* DESCRIPTION: send Data Transmisition
*
* PARAMETER: None
*
* RETURNVALUE: None
*************************************************************************/
tVoid  dispvidctrl_tclClientAvmAdaptor::vSendDataTransmission()
{
    ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::vSendDataTransmission() entered"));
    // dispvidctrl_tclMCanClientAvm::vSendDataTransmission: user specific code start
    // dispvidctrl_tclMCanClientAvm::vSendDataTransmission: user specific code end

}


/*************************************************************************
* FUNCTION: dispvidctrl_tclClientAvmAdaptor::vSendCurrentCommTestResult()
*
* DESCRIPTION: send Communication test result
*
* PARAMETER: None
*
* RETURNVALUE: None
*************************************************************************/
tVoid  dispvidctrl_tclClientAvmAdaptor::vSendCurrentCommTestResult()
{
    ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::vSendCurrentCommTestResult() entered"));

    _cpoMain->theServer()->vPostMsgAvmCommTestResult("I_dispvidctrl_tclMCanClientAvm");
}


/*************************************************************************
* FUNCTION: tVoid  dispvidctrl_tclClientAvmAdaptor::vSendCurrentCDataConfTestResult()
*
* DESCRIPTION:  send CData test result
*
* PARAMETER: None
*
* RETURNVALUE: None
*************************************************************************/
tVoid  dispvidctrl_tclClientAvmAdaptor::vSendCurrentCDataConfTestResult()
{
    ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::vSendCurrentCDataConfTestResult() entered"));

    _cpoMain->theServer()->vPostMsgAvmCDataConfTestResult("I_dispvidctrl_tclMCanClientAvm");
}


/*************************************************************************
* FUNCTION: dispvidctrl_tclClientAvmAdaptor::vSendCurrentDDataConfTestResult()
*
* DESCRIPTION: send DData test result
*
* PARAMETER: None
*
* RETURNVALUE: None
*************************************************************************/
tVoid  dispvidctrl_tclClientAvmAdaptor::vSendCurrentDDataConfTestResult()
{
    ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::vSendCurrentDDataConfTestResult() entered"));

    _cpoMain->theServer()->vPostMsgAvmDDataConfTestResult("I_dispvidctrl_tclMCanClientAvm");
}

/*******************************************************************************
* FUNCTION   : dispvidctrl_tclClientAvmAdaptor::vDoActionsWhenInitializationIncomplete()
*
* DESCRIPTION: call back funciton from CSM inteface to perform operation when initialization is incomplete
*
* PARAMETER  : None
*
* RETURNVALUE: None
*******************************************************************************/
tVoid dispvidctrl_tclClientAvmAdaptor::vDoActionsWhenInitializationIncomplete()
{
    ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::vDoActionsWhenInitializationIncomplete() entered"));

    // dispvidctrl_tclMCanClientAvm::vDoActionsWhenInitializationIncomplete: user specific code start
    // dispvidctrl_tclMCanClientAvm::vDoActionsWhenInitializationIncomplete: user specific code end

    _cpoMain->theServer()->vPostMsgAvmConnected("I_dispvidctrl_tclMCanClientAvmFsm", FALSE);

    vSetChangedEvent();           // trigger worker thread
}


/*******************************************************************************
* FUNCTION   : dispvidctrl_tclClientAvmAdaptor::vDoActionsAfterInitializationComplete()
*
* DESCRIPTION: call back funciton from CSM inteface to perform operation when initialization is complete
*
* PARAMETER  : None
*
* RETURNVALUE: None
*******************************************************************************/
tVoid dispvidctrl_tclClientAvmAdaptor::vDoActionsAfterInitializationComplete()
{
    ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::vDoActionsAfterInitializationComplete() entered"));

    // dispvidctrl_tclMCanClientAvm::vDoActionsAfterInitializationComplete: user specific code start
    // dispvidctrl_tclMCanClientAvm::vDoActionsAfterInitializationComplete: user specific code end

    _cpoMain->theServer()->vPostMsgAvmConnected("I_dispvidctrl_tclMCanClientAvmFsm", TRUE);
    
    vSetChangedEvent();           // trigger worker thread
}

/*******************************************************************************
* FUNCTION   : dispvidctrl_tclClientAvmAdaptor::vHandleUnitSpecificDataInd(tU16 u16MsgId, tU8 u8OpTypeCode, tU8* pu8Data, tU16 u16Length )
*
* DESCRIPTION: Handles incoming MCAN Messages, The function decodes and processes the information
*
* PARAMETER  : 
*
* RETURNVALUE: None
*******************************************************************************/
tVoid dispvidctrl_tclClientAvmAdaptor::vHandleUnitSpecificDataInd( tU16 u16MsgId, tU8 u8OpTypeCode, tU8* pu8Data, tU16 u16Length ) {

    ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::vHandleUnitSpecificDataInd() entered --> just switch context for msg %04x, opcode: %02x.", ETG_ENUM(tenAvmMessageName, u16MsgId), ETG_ENUM(eMcanOpcode, u8OpTypeCode)));
    
    //send internal message to inform about free MCAN channel
    dispvidctrl_tclBaseIf::TMsg oMsg;
    memset(&oMsg, 0, sizeof(dispvidctrl_tclBaseIf::TMsg));

    oMsg.eCmd = dispvidctrl_tclBaseIf::eCmdMCanDataInd;

    OSAL_szStringNCopy(oMsg.strClassName, "I_dispvidctrl_tclClientAvmAdaptor", 50);

    oMsg.tDataTrailer.pu8Data = pu8Data;
    oMsg.tDataTrailer.u32Len = (tU32)u16Length;

    oMsg.u.tMCanMsg.u16MsgId = u16MsgId;
    oMsg.u.tMCanMsg.u8Opcode = u8OpTypeCode;

    _cpoMain->theServer()->vPostInternalMessage(&oMsg);
}

tVoid dispvidctrl_tclClientAvmAdaptor::vHandleUnitSpecificDataIndCtxt( tU16 u16MsgId, tU8 u8OpTypeCode, tU8* pu8Data, tU16 u16Length )
{
    ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::vHandleUnitSpecificDataIndCtxt() entered for msg %04x, opcode: %02x, length: %d, dataPtr: 0x%08X.", ETG_ENUM(tenAvmMessageName, u16MsgId), ETG_ENUM(eMcanOpcode, u8OpTypeCode), u16Length, pu8Data));
    vLogNewMsg( u16MsgId, u8OpTypeCode, FALSE);
    
    tBool bDataOk = TRUE;
    if ( pu8Data ) {     
        switch ( u16MsgId ) {

        case ::Avm_fi::eFctSoftware_Version:
            if (_pClientCallback && (u8OpTypeCode ==  MCAN_C_OP_TYPE_STATUS)) {
               
               tcl_ITM_Camera_System_Software_Version_StatusIn oMsg;
               if ( TRUE == (bDataOk = oMsg.bExtractInMsg(pu8Data, (tU32)u16Length)) ) {
                  _pClientCallback->onSoftware_VersionStatusIn(oMsg);
               }
            }
            break;
        case ::Avm_fi::eFctHardware_Version:
            if (_pClientCallback && (u8OpTypeCode ==  MCAN_C_OP_TYPE_STATUS)) {
               
               tcl_ITM_Camera_System_Hardware_Version_StatusIn oMsg;
               if ( TRUE == (bDataOk = oMsg.bExtractInMsg(pu8Data, (tU32)u16Length)) ) {
                  _pClientCallback->onHardware_VersionStatusIn(oMsg);
               }
            }
            break;
        case ::Avm_fi::eFctSW_Signal:
            break;
        case ::Avm_fi::eFctExtra_SW:
            if (_pClientCallback && (u8OpTypeCode ==  MCAN_C_OP_TYPE_INDICATION)) {
               
               tcl_ITM_Camera_System_Extra_SW_IndicationIn oMsg;
               if ( TRUE == (bDataOk = oMsg.bExtractInMsg(pu8Data, (tU32)u16Length)) ) {
                  _pClientCallback->onExtra_SWIndicationIn(oMsg);
               }
            }
            break;
        case ::Avm_fi::eFctView_Change_08AVM:
            if (_pClientCallback && (u8OpTypeCode ==  MCAN_C_OP_TYPE_SET)) {
               
               tcl_ITM_Camera_System_View_Change_08AVM_SetIn oMsg;
               if ( TRUE == (bDataOk = oMsg.bExtractInMsg(pu8Data, (tU32)u16Length)) ) {
                  _pClientCallback->onView_Change_08AVMSetIn(oMsg);
               }
            }
            break;
        case ::Avm_fi::eFctBlanking_OFF:
            if (_pClientCallback && (u8OpTypeCode ==  MCAN_C_OP_TYPE_INDICATION)) {
               
               tcl_ITM_Camera_System_Blanking_OFF_IndicationIn oMsg;
               if ( TRUE == (bDataOk = oMsg.bExtractInMsg(pu8Data, (tU32)u16Length)) ) {
                  _pClientCallback->onBlanking_OFFIndicationIn(oMsg);
               }
            }
            break;
        case ::Avm_fi::eFctBlanking_less_Change_08AVM:
            if (_pClientCallback && (u8OpTypeCode ==  MCAN_C_OP_TYPE_INDICATION)) {
               
               tcl_ITM_Camera_System_Blanking_less_Change_08AVM_IndicationIn oMsg;
               if ( TRUE == (bDataOk = oMsg.bExtractInMsg(pu8Data, (tU32)u16Length)) ) {
                  _pClientCallback->onBlanking_less_Change_08AVMIndicationIn(oMsg);
               }
            }
            break;
        case ::Avm_fi::eFctDirect_Camera_OFF:
            break;
        case ::Avm_fi::eFctAVM_Sonar_Buzzer:
            if (_pClientCallback && (u8OpTypeCode ==  MCAN_C_OP_TYPE_STATUS)) {
               
               tcl_ITM_Camera_System_AVM_Sonar_Buzzer_StatusIn oMsg;
               if ( TRUE == (bDataOk = oMsg.bExtractInMsg(pu8Data, (tU32)u16Length)) ) {
                  _pClientCallback->onAVM_Sonar_BuzzerStatusIn(oMsg);
               }
            }
            if (_pClientCallback && (u8OpTypeCode ==  MCAN_C_OP_TYPE_INDICATION)) {
               
               tcl_ITM_Camera_System_AVM_Sonar_Buzzer_IndicationIn oMsg;
               if ( TRUE == (bDataOk = oMsg.bExtractInMsg(pu8Data, (tU32)u16Length)) ) {
                  _pClientCallback->onAVM_Sonar_BuzzerIndicationIn(oMsg);
               }
            }
            break;
        case ::Avm_fi::eFctCamera_Setting_08AVM:
            if (_pClientCallback && (u8OpTypeCode ==  MCAN_C_OP_TYPE_STATUS)) {
               
               tcl_ITM_Camera_System_Camera_Setting_08AVM_StatusIn oMsg;
               if ( TRUE == (bDataOk = oMsg.bExtractInMsg(pu8Data, (tU32)u16Length)) ) {
                  _pClientCallback->onCamera_Setting_08AVMStatusIn(oMsg);
               }
            }
            if (_pClientCallback && (u8OpTypeCode ==  MCAN_C_OP_TYPE_INDICATION)) {
               
               tcl_ITM_Camera_System_Camera_Setting_08AVM_IndicationIn oMsg;
               if ( TRUE == (bDataOk = oMsg.bExtractInMsg(pu8Data, (tU32)u16Length)) ) {
                  _pClientCallback->onCamera_Setting_08AVMIndicationIn(oMsg);
               }
            }
            break;
        case ::Avm_fi::eFctCamera_Primary_Setting:
            if (_pClientCallback && (u8OpTypeCode ==  MCAN_C_OP_TYPE_STATUS)) {
               
               tcl_ITM_Camera_System_Camera_Primary_Setting_StatusIn oMsg;
               if ( TRUE == (bDataOk = oMsg.bExtractInMsg(pu8Data, (tU32)u16Length)) ) {
                  _pClientCallback->onCamera_Primary_SettingStatusIn(oMsg);
               }
            }
            break;
        case ::Avm_fi::eFctMCAN_Communication_Error:
            if (_pClientCallback && (u8OpTypeCode ==  MCAN_C_OP_TYPE_STATUS)) {
               
               tcl_ITM_Camera_System_MCAN_Communication_Error_StatusIn oMsg;
               if ( TRUE == (bDataOk = oMsg.bExtractInMsg(pu8Data, (tU32)u16Length)) ) {
                  _pClientCallback->onMCAN_Communication_ErrorStatusIn(oMsg);
               }
            }
            break;
        case ::Avm_fi::eFctMCAN_Communication_Error_Clear:
            if (_pClientCallback && (u8OpTypeCode ==  MCAN_C_OP_TYPE_STATUS)) {
               
               tcl_ITM_Camera_System_MCAN_Communication_Error_Clear_StatusIn oMsg;
               if ( TRUE == (bDataOk = oMsg.bExtractInMsg(pu8Data, (tU32)u16Length)) ) {
                  _pClientCallback->onMCAN_Communication_Error_ClearStatusIn(oMsg);
               }
            }
            break;
        case ::Avm_fi::eFctCamera_Diag_Sensor:
            if (_pClientCallback && (u8OpTypeCode ==  MCAN_C_OP_TYPE_STATUS)) {
               
               tcl_ITM_Camera_System_Camera_Diag_Sensor_StatusIn oMsg;
               if ( TRUE == (bDataOk = oMsg.bExtractInMsg(pu8Data, (tU32)u16Length)) ) {
                  _pClientCallback->onCamera_Diag_SensorStatusIn(oMsg);
               }
            }
            if (_pClientCallback && (u8OpTypeCode ==  MCAN_C_OP_TYPE_INDICATION)) {
               
               tcl_ITM_Camera_System_Camera_Diag_Sensor_IndicationIn oMsg;
               if ( TRUE == (bDataOk = oMsg.bExtractInMsg(pu8Data, (tU32)u16Length)) ) {
                  _pClientCallback->onCamera_Diag_SensorIndicationIn(oMsg);
               }
            }
            break;

        default:
            break;
        }
    }
    if (!bDataOk) {
        ETG_TRACE_FATAL(("dispvidctrl_tclClientAvmAdaptor::vHandleUnitSpecificDataIndCtxt(): message extraction FAILED - msg %04x, opcode: %02x, length: %d, dataPtr: 0x%08X.", ETG_ENUM(tenAvmMessageName, u16MsgId), ETG_ENUM(eMcanOpcode, u8OpTypeCode), u16Length, pu8Data));
    }
}

/*******************************************************************************
* FUNCTION   : dispvidctrl_tclClientAvmAdaptor::vCheckForUnitSpecificDataRequests()
*
* DESCRIPTION: processes the MCAN Data Request
*
* PARAMETER  : None
*
* RETURNVALUE: None
*******************************************************************************/
tVoid dispvidctrl_tclClientAvmAdaptor::vCheckForUnitSpecificDataRequests( tVoid )
{
    ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::vCheckForUnitSpecificDataRequests() entered %d", bIsAllowedToSendCData()));
    _cpoMain->theServer()->vPostMsgAvmUpdate("I_dispvidctrl_tclMCanClientAvm");
}


/*******************************************************************************
* FUNCTION   : dispvidctrl_tclClientAvmAdaptor::vCreateUnitSpecificTimers()
*
* DESCRIPTION: Creates Unit Specific Timers
*
* PARAMETER  : None
*
* RETURNVALUE: None
*******************************************************************************/
tVoid dispvidctrl_tclClientAvmAdaptor::vCreateUnitSpecificTimers()
{
    ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::vCreateUnitSpecificTimers() entered"));

    // needed timer
}

/*******************************************************************************
* FUNCTION   : dispvidctrl_tclClientAvmAdaptor::hHandleUnitSpecificEvents()
*
* DESCRIPTION: handles unit specific events
*
* PARAMETER  : None
*
* RETURNVALUE: None
*******************************************************************************/
OSAL_tEventMask dispvidctrl_tclClientAvmAdaptor::hHandleUnitSpecificEvents( OSAL_tEventMask hEvents )
{
    ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::hHandleUnitSpecificEvents() entered"));

    OSAL_tEventMask hEvRequest = hEvents;

    return hEvRequest;
}


tBool dispvidctrl_tclClientAvmAdaptor::sendSoftware_VersionGetOut(tcl_ITM_Camera_System_Software_Version_GetOut& oOutMsg){
    tBool bRet = TRUE;
     
    ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::sendSoftware_VersionGetOut(): "));

    if (bIsConnected() && bIsAllowedToSendCData()) {

        tU16 u16Command = MCAN_ASSEMBLE_COMMAND( (tU16)::Avm_fi::eFctSoftware_Version, MCAN_C_OP_TYPE_GET );

        tU32 u32Len = oOutMsg.u32PrepareOutMsg();

        tU8* pu8DataBuf = new tU8[u32Len + 2]; // +2 byte for header information
        
        pu8DataBuf[0] = CSM_M_GET_HIBYTE( u16Command );
        pu8DataBuf[1] = CSM_M_GET_LOBYTE( u16Command );

        oOutMsg.u32FillOutMsg(&pu8DataBuf[2], u32Len);

        _u16MessageInSending = (tU16)::Avm_fi::eFctSoftware_Version;
        
        ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::sendSoftware_VersionGetOut: eFctSoftware_Version, Opcode: MCAN_C_OP_TYPE_GET, data: %02x ", ETG_LIST_LEN(u32Len), ETG_LIST_PTR_T8((tU8*)&pu8DataBuf[2]) ));        
        
        bDoCDataReq( pu8DataBuf, u32Len+2);
        
        delete[] pu8DataBuf;

        vLogNewMsg( (tU16)::Avm_fi::eFctSoftware_Version, MCAN_C_OP_TYPE_GET, TRUE);
    } else {
        ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::sendSoftware_VersionGetOut: Sending currently not possible --> try later (Connect: %d, Allowed: %d)!", bIsConnected(), bIsAllowedToSendCData()));
        bRet = FALSE;
    }
    
    return bRet;
}

tBool dispvidctrl_tclClientAvmAdaptor::sendHardware_VersionGetOut(tcl_ITM_Camera_System_Hardware_Version_GetOut& oOutMsg){
    tBool bRet = TRUE;
     
    ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::sendHardware_VersionGetOut(): "));

    if (bIsConnected() && bIsAllowedToSendCData()) {

        tU16 u16Command = MCAN_ASSEMBLE_COMMAND( (tU16)::Avm_fi::eFctHardware_Version, MCAN_C_OP_TYPE_GET );

        tU32 u32Len = oOutMsg.u32PrepareOutMsg();

        tU8* pu8DataBuf = new tU8[u32Len + 2]; // +2 byte for header information
        
        pu8DataBuf[0] = CSM_M_GET_HIBYTE( u16Command );
        pu8DataBuf[1] = CSM_M_GET_LOBYTE( u16Command );

        oOutMsg.u32FillOutMsg(&pu8DataBuf[2], u32Len);

        _u16MessageInSending = (tU16)::Avm_fi::eFctHardware_Version;
        
        ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::sendHardware_VersionGetOut: eFctHardware_Version, Opcode: MCAN_C_OP_TYPE_GET, data: %02x ", ETG_LIST_LEN(u32Len), ETG_LIST_PTR_T8((tU8*)&pu8DataBuf[2]) ));        
        
        bDoCDataReq( pu8DataBuf, u32Len+2);
        
        delete[] pu8DataBuf;

        vLogNewMsg( (tU16)::Avm_fi::eFctHardware_Version, MCAN_C_OP_TYPE_GET, TRUE);
    } else {
        ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::sendHardware_VersionGetOut: Sending currently not possible --> try later (Connect: %d, Allowed: %d)!", bIsConnected(), bIsAllowedToSendCData()));
        bRet = FALSE;
    }
    
    return bRet;
}

tBool dispvidctrl_tclClientAvmAdaptor::sendSW_SignalIndicationOut(tcl_ITM_Camera_System_SW_Signal_IndicationOut& oOutMsg){
    tBool bRet = TRUE;
     
    ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::sendSW_SignalIndicationOut(): "));

    if (bIsConnected() && bIsAllowedToSendCData()) {

        tU16 u16Command = MCAN_ASSEMBLE_COMMAND( (tU16)::Avm_fi::eFctSW_Signal, MCAN_C_OP_TYPE_INDICATION );

        tU32 u32Len = oOutMsg.u32PrepareOutMsg();

        tU8* pu8DataBuf = new tU8[u32Len + 2]; // +2 byte for header information
        
        pu8DataBuf[0] = CSM_M_GET_HIBYTE( u16Command );
        pu8DataBuf[1] = CSM_M_GET_LOBYTE( u16Command );

        oOutMsg.u32FillOutMsg(&pu8DataBuf[2], u32Len);

        _u16MessageInSending = (tU16)::Avm_fi::eFctSW_Signal;
        
        ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::sendSW_SignalIndicationOut: eFctSW_Signal, Opcode: MCAN_C_OP_TYPE_INDICATION, data: %02x ", ETG_LIST_LEN(u32Len), ETG_LIST_PTR_T8((tU8*)&pu8DataBuf[2]) ));        
        
        bDoCDataReq( pu8DataBuf, u32Len+2);
        
        delete[] pu8DataBuf;

        vLogNewMsg( (tU16)::Avm_fi::eFctSW_Signal, MCAN_C_OP_TYPE_INDICATION, TRUE);
    } else {
        ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::sendSW_SignalIndicationOut: Sending currently not possible --> try later (Connect: %d, Allowed: %d)!", bIsConnected(), bIsAllowedToSendCData()));
        bRet = FALSE;
    }
    
    return bRet;
}

tBool dispvidctrl_tclClientAvmAdaptor::sendView_Change_08AVMStatusOut(tcl_ITM_Camera_System_View_Change_08AVM_StatusOut& oOutMsg){
    tBool bRet = TRUE;
     
    ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::sendView_Change_08AVMStatusOut(): "));

    if (bIsConnected() && bIsAllowedToSendCData()) {

        tU16 u16Command = MCAN_ASSEMBLE_COMMAND( (tU16)::Avm_fi::eFctView_Change_08AVM, MCAN_C_OP_TYPE_STATUS );

        tU32 u32Len = oOutMsg.u32PrepareOutMsg();

        tU8* pu8DataBuf = new tU8[u32Len + 2]; // +2 byte for header information
        
        pu8DataBuf[0] = CSM_M_GET_HIBYTE( u16Command );
        pu8DataBuf[1] = CSM_M_GET_LOBYTE( u16Command );

        oOutMsg.u32FillOutMsg(&pu8DataBuf[2], u32Len);

        _u16MessageInSending = (tU16)::Avm_fi::eFctView_Change_08AVM;
        
        ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::sendView_Change_08AVMStatusOut: eFctView_Change_08AVM, Opcode: MCAN_C_OP_TYPE_STATUS, data: %02x ", ETG_LIST_LEN(u32Len), ETG_LIST_PTR_T8((tU8*)&pu8DataBuf[2]) ));        
        
        bDoCDataReq( pu8DataBuf, u32Len+2);
        
        delete[] pu8DataBuf;

        vLogNewMsg( (tU16)::Avm_fi::eFctView_Change_08AVM, MCAN_C_OP_TYPE_STATUS, TRUE);
    } else {
        ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::sendView_Change_08AVMStatusOut: Sending currently not possible --> try later (Connect: %d, Allowed: %d)!", bIsConnected(), bIsAllowedToSendCData()));
        bRet = FALSE;
    }
    
    return bRet;
}

tBool dispvidctrl_tclClientAvmAdaptor::sendDirect_Camera_OFFIndicationOut(tcl_ITM_Camera_System_Direct_Camera_OFF_IndicationOut& oOutMsg){
    tBool bRet = TRUE;
     
    ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::sendDirect_Camera_OFFIndicationOut(): "));

    if (bIsConnected() && bIsAllowedToSendCData()) {

        tU16 u16Command = MCAN_ASSEMBLE_COMMAND( (tU16)::Avm_fi::eFctDirect_Camera_OFF, MCAN_C_OP_TYPE_INDICATION );

        tU32 u32Len = oOutMsg.u32PrepareOutMsg();

        tU8* pu8DataBuf = new tU8[u32Len + 2]; // +2 byte for header information
        
        pu8DataBuf[0] = CSM_M_GET_HIBYTE( u16Command );
        pu8DataBuf[1] = CSM_M_GET_LOBYTE( u16Command );

        oOutMsg.u32FillOutMsg(&pu8DataBuf[2], u32Len);

        _u16MessageInSending = (tU16)::Avm_fi::eFctDirect_Camera_OFF;
        
        ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::sendDirect_Camera_OFFIndicationOut: eFctDirect_Camera_OFF, Opcode: MCAN_C_OP_TYPE_INDICATION, data: %02x ", ETG_LIST_LEN(u32Len), ETG_LIST_PTR_T8((tU8*)&pu8DataBuf[2]) ));        
        
        bDoCDataReq( pu8DataBuf, u32Len+2);
        
        delete[] pu8DataBuf;

        vLogNewMsg( (tU16)::Avm_fi::eFctDirect_Camera_OFF, MCAN_C_OP_TYPE_INDICATION, TRUE);
    } else {
        ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::sendDirect_Camera_OFFIndicationOut: Sending currently not possible --> try later (Connect: %d, Allowed: %d)!", bIsConnected(), bIsAllowedToSendCData()));
        bRet = FALSE;
    }
    
    return bRet;
}

tBool dispvidctrl_tclClientAvmAdaptor::sendAVM_Sonar_BuzzerSetOut(tcl_ITM_Camera_System_AVM_Sonar_Buzzer_SetOut& oOutMsg){
    tBool bRet = TRUE;
     
    ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::sendAVM_Sonar_BuzzerSetOut(): "));

    if (bIsConnected() && bIsAllowedToSendCData()) {

        tU16 u16Command = MCAN_ASSEMBLE_COMMAND( (tU16)::Avm_fi::eFctAVM_Sonar_Buzzer, MCAN_C_OP_TYPE_SET );

        tU32 u32Len = oOutMsg.u32PrepareOutMsg();

        tU8* pu8DataBuf = new tU8[u32Len + 2]; // +2 byte for header information
        
        pu8DataBuf[0] = CSM_M_GET_HIBYTE( u16Command );
        pu8DataBuf[1] = CSM_M_GET_LOBYTE( u16Command );

        oOutMsg.u32FillOutMsg(&pu8DataBuf[2], u32Len);

        _u16MessageInSending = (tU16)::Avm_fi::eFctAVM_Sonar_Buzzer;
        
        ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::sendAVM_Sonar_BuzzerSetOut: eFctAVM_Sonar_Buzzer, Opcode: MCAN_C_OP_TYPE_SET, data: %02x ", ETG_LIST_LEN(u32Len), ETG_LIST_PTR_T8((tU8*)&pu8DataBuf[2]) ));        
        
        bDoCDataReq( pu8DataBuf, u32Len+2);
        
        delete[] pu8DataBuf;

        vLogNewMsg( (tU16)::Avm_fi::eFctAVM_Sonar_Buzzer, MCAN_C_OP_TYPE_SET, TRUE);
    } else {
        ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::sendAVM_Sonar_BuzzerSetOut: Sending currently not possible --> try later (Connect: %d, Allowed: %d)!", bIsConnected(), bIsAllowedToSendCData()));
        bRet = FALSE;
    }
    
    return bRet;
}

tBool dispvidctrl_tclClientAvmAdaptor::sendCamera_Setting_08AVMSetOut(tcl_ITM_Camera_System_Camera_Setting_08AVM_SetOut& oOutMsg){
    tBool bRet = TRUE;
     
    ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::sendCamera_Setting_08AVMSetOut(): "));

    if (bIsConnected() && bIsAllowedToSendCData()) {

        tU16 u16Command = MCAN_ASSEMBLE_COMMAND( (tU16)::Avm_fi::eFctCamera_Setting_08AVM, MCAN_C_OP_TYPE_SET );

        tU32 u32Len = oOutMsg.u32PrepareOutMsg();

        tU8* pu8DataBuf = new tU8[u32Len + 2]; // +2 byte for header information
        
        pu8DataBuf[0] = CSM_M_GET_HIBYTE( u16Command );
        pu8DataBuf[1] = CSM_M_GET_LOBYTE( u16Command );

        oOutMsg.u32FillOutMsg(&pu8DataBuf[2], u32Len);

        _u16MessageInSending = (tU16)::Avm_fi::eFctCamera_Setting_08AVM;
        
        ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::sendCamera_Setting_08AVMSetOut: eFctCamera_Setting_08AVM, Opcode: MCAN_C_OP_TYPE_SET, data: %02x ", ETG_LIST_LEN(u32Len), ETG_LIST_PTR_T8((tU8*)&pu8DataBuf[2]) ));        
        
        bDoCDataReq( pu8DataBuf, u32Len+2);
        
        delete[] pu8DataBuf;

        vLogNewMsg( (tU16)::Avm_fi::eFctCamera_Setting_08AVM, MCAN_C_OP_TYPE_SET, TRUE);
    } else {
        ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::sendCamera_Setting_08AVMSetOut: Sending currently not possible --> try later (Connect: %d, Allowed: %d)!", bIsConnected(), bIsAllowedToSendCData()));
        bRet = FALSE;
    }
    
    return bRet;
}

tBool dispvidctrl_tclClientAvmAdaptor::sendCamera_Setting_08AVMGetOut(tcl_ITM_Camera_System_Camera_Setting_08AVM_GetOut& oOutMsg){
    tBool bRet = TRUE;
     
    ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::sendCamera_Setting_08AVMGetOut(): "));

    if (bIsConnected() && bIsAllowedToSendCData()) {

        tU16 u16Command = MCAN_ASSEMBLE_COMMAND( (tU16)::Avm_fi::eFctCamera_Setting_08AVM, MCAN_C_OP_TYPE_GET );

        tU32 u32Len = oOutMsg.u32PrepareOutMsg();

        tU8* pu8DataBuf = new tU8[u32Len + 2]; // +2 byte for header information
        
        pu8DataBuf[0] = CSM_M_GET_HIBYTE( u16Command );
        pu8DataBuf[1] = CSM_M_GET_LOBYTE( u16Command );

        oOutMsg.u32FillOutMsg(&pu8DataBuf[2], u32Len);

        _u16MessageInSending = (tU16)::Avm_fi::eFctCamera_Setting_08AVM;
        
        ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::sendCamera_Setting_08AVMGetOut: eFctCamera_Setting_08AVM, Opcode: MCAN_C_OP_TYPE_GET, data: %02x ", ETG_LIST_LEN(u32Len), ETG_LIST_PTR_T8((tU8*)&pu8DataBuf[2]) ));        
        
        bDoCDataReq( pu8DataBuf, u32Len+2);
        
        delete[] pu8DataBuf;

        vLogNewMsg( (tU16)::Avm_fi::eFctCamera_Setting_08AVM, MCAN_C_OP_TYPE_GET, TRUE);
    } else {
        ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::sendCamera_Setting_08AVMGetOut: Sending currently not possible --> try later (Connect: %d, Allowed: %d)!", bIsConnected(), bIsAllowedToSendCData()));
        bRet = FALSE;
    }
    
    return bRet;
}

tBool dispvidctrl_tclClientAvmAdaptor::sendCamera_Primary_SettingSetOut(tcl_ITM_Camera_System_Camera_Primary_Setting_SetOut& oOutMsg){
    tBool bRet = TRUE;
     
    ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::sendCamera_Primary_SettingSetOut(): "));

    if (bIsConnected() && bIsAllowedToSendCData()) {

        tU16 u16Command = MCAN_ASSEMBLE_COMMAND( (tU16)::Avm_fi::eFctCamera_Primary_Setting, MCAN_C_OP_TYPE_SET );

        tU32 u32Len = oOutMsg.u32PrepareOutMsg();

        tU8* pu8DataBuf = new tU8[u32Len + 2]; // +2 byte for header information
        
        pu8DataBuf[0] = CSM_M_GET_HIBYTE( u16Command );
        pu8DataBuf[1] = CSM_M_GET_LOBYTE( u16Command );

        oOutMsg.u32FillOutMsg(&pu8DataBuf[2], u32Len);

        _u16MessageInSending = (tU16)::Avm_fi::eFctCamera_Primary_Setting;
        
        ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::sendCamera_Primary_SettingSetOut: eFctCamera_Primary_Setting, Opcode: MCAN_C_OP_TYPE_SET, data: %02x ", ETG_LIST_LEN(u32Len), ETG_LIST_PTR_T8((tU8*)&pu8DataBuf[2]) ));        
        
        bDoCDataReq( pu8DataBuf, u32Len+2);
        
        delete[] pu8DataBuf;

        vLogNewMsg( (tU16)::Avm_fi::eFctCamera_Primary_Setting, MCAN_C_OP_TYPE_SET, TRUE);
    } else {
        ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::sendCamera_Primary_SettingSetOut: Sending currently not possible --> try later (Connect: %d, Allowed: %d)!", bIsConnected(), bIsAllowedToSendCData()));
        bRet = FALSE;
    }
    
    return bRet;
}

tBool dispvidctrl_tclClientAvmAdaptor::sendCamera_Primary_SettingGetOut(tcl_ITM_Camera_System_Camera_Primary_Setting_GetOut& oOutMsg){
    tBool bRet = TRUE;
     
    ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::sendCamera_Primary_SettingGetOut(): "));

    if (bIsConnected() && bIsAllowedToSendCData()) {

        tU16 u16Command = MCAN_ASSEMBLE_COMMAND( (tU16)::Avm_fi::eFctCamera_Primary_Setting, MCAN_C_OP_TYPE_GET );

        tU32 u32Len = oOutMsg.u32PrepareOutMsg();

        tU8* pu8DataBuf = new tU8[u32Len + 2]; // +2 byte for header information
        
        pu8DataBuf[0] = CSM_M_GET_HIBYTE( u16Command );
        pu8DataBuf[1] = CSM_M_GET_LOBYTE( u16Command );

        oOutMsg.u32FillOutMsg(&pu8DataBuf[2], u32Len);

        _u16MessageInSending = (tU16)::Avm_fi::eFctCamera_Primary_Setting;
        
        ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::sendCamera_Primary_SettingGetOut: eFctCamera_Primary_Setting, Opcode: MCAN_C_OP_TYPE_GET, data: %02x ", ETG_LIST_LEN(u32Len), ETG_LIST_PTR_T8((tU8*)&pu8DataBuf[2]) ));        
        
        bDoCDataReq( pu8DataBuf, u32Len+2);
        
        delete[] pu8DataBuf;

        vLogNewMsg( (tU16)::Avm_fi::eFctCamera_Primary_Setting, MCAN_C_OP_TYPE_GET, TRUE);
    } else {
        ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::sendCamera_Primary_SettingGetOut: Sending currently not possible --> try later (Connect: %d, Allowed: %d)!", bIsConnected(), bIsAllowedToSendCData()));
        bRet = FALSE;
    }
    
    return bRet;
}

tBool dispvidctrl_tclClientAvmAdaptor::sendMCAN_Communication_ErrorGetOut(tcl_ITM_Camera_System_MCAN_Communication_Error_GetOut& oOutMsg){
    tBool bRet = TRUE;
     
    ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::sendMCAN_Communication_ErrorGetOut(): "));

    if (bIsConnected() && bIsAllowedToSendCData()) {

        tU16 u16Command = MCAN_ASSEMBLE_COMMAND( (tU16)::Avm_fi::eFctMCAN_Communication_Error, MCAN_C_OP_TYPE_GET );

        tU32 u32Len = oOutMsg.u32PrepareOutMsg();

        tU8* pu8DataBuf = new tU8[u32Len + 2]; // +2 byte for header information
        
        pu8DataBuf[0] = CSM_M_GET_HIBYTE( u16Command );
        pu8DataBuf[1] = CSM_M_GET_LOBYTE( u16Command );

        oOutMsg.u32FillOutMsg(&pu8DataBuf[2], u32Len);

        _u16MessageInSending = (tU16)::Avm_fi::eFctMCAN_Communication_Error;
        
        ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::sendMCAN_Communication_ErrorGetOut: eFctMCAN_Communication_Error, Opcode: MCAN_C_OP_TYPE_GET, data: %02x ", ETG_LIST_LEN(u32Len), ETG_LIST_PTR_T8((tU8*)&pu8DataBuf[2]) ));        
        
        bDoCDataReq( pu8DataBuf, u32Len+2);
        
        delete[] pu8DataBuf;

        vLogNewMsg( (tU16)::Avm_fi::eFctMCAN_Communication_Error, MCAN_C_OP_TYPE_GET, TRUE);
    } else {
        ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::sendMCAN_Communication_ErrorGetOut: Sending currently not possible --> try later (Connect: %d, Allowed: %d)!", bIsConnected(), bIsAllowedToSendCData()));
        bRet = FALSE;
    }
    
    return bRet;
}

tBool dispvidctrl_tclClientAvmAdaptor::sendMCAN_Communication_Error_ClearSetOut(tcl_ITM_Camera_System_MCAN_Communication_Error_Clear_SetOut& oOutMsg){
    tBool bRet = TRUE;
     
    ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::sendMCAN_Communication_Error_ClearSetOut(): "));

    if (bIsConnected() && bIsAllowedToSendCData()) {

        tU16 u16Command = MCAN_ASSEMBLE_COMMAND( (tU16)::Avm_fi::eFctMCAN_Communication_Error_Clear, MCAN_C_OP_TYPE_SET );

        tU32 u32Len = oOutMsg.u32PrepareOutMsg();

        tU8* pu8DataBuf = new tU8[u32Len + 2]; // +2 byte for header information
        
        pu8DataBuf[0] = CSM_M_GET_HIBYTE( u16Command );
        pu8DataBuf[1] = CSM_M_GET_LOBYTE( u16Command );

        oOutMsg.u32FillOutMsg(&pu8DataBuf[2], u32Len);

        _u16MessageInSending = (tU16)::Avm_fi::eFctMCAN_Communication_Error_Clear;
        
        ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::sendMCAN_Communication_Error_ClearSetOut: eFctMCAN_Communication_Error_Clear, Opcode: MCAN_C_OP_TYPE_SET, data: %02x ", ETG_LIST_LEN(u32Len), ETG_LIST_PTR_T8((tU8*)&pu8DataBuf[2]) ));        
        
        bDoCDataReq( pu8DataBuf, u32Len+2);
        
        delete[] pu8DataBuf;

        vLogNewMsg( (tU16)::Avm_fi::eFctMCAN_Communication_Error_Clear, MCAN_C_OP_TYPE_SET, TRUE);
    } else {
        ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::sendMCAN_Communication_Error_ClearSetOut: Sending currently not possible --> try later (Connect: %d, Allowed: %d)!", bIsConnected(), bIsAllowedToSendCData()));
        bRet = FALSE;
    }
    
    return bRet;
}

tBool dispvidctrl_tclClientAvmAdaptor::sendCamera_Diag_SensorSetOut(tcl_ITM_Camera_System_Camera_Diag_Sensor_SetOut& oOutMsg){
    tBool bRet = TRUE;
     
    ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::sendCamera_Diag_SensorSetOut(): "));

    if (bIsConnected() && bIsAllowedToSendCData()) {

        tU16 u16Command = MCAN_ASSEMBLE_COMMAND( (tU16)::Avm_fi::eFctCamera_Diag_Sensor, MCAN_C_OP_TYPE_SET );

        tU32 u32Len = oOutMsg.u32PrepareOutMsg();

        tU8* pu8DataBuf = new tU8[u32Len + 2]; // +2 byte for header information
        
        pu8DataBuf[0] = CSM_M_GET_HIBYTE( u16Command );
        pu8DataBuf[1] = CSM_M_GET_LOBYTE( u16Command );

        oOutMsg.u32FillOutMsg(&pu8DataBuf[2], u32Len);

        _u16MessageInSending = (tU16)::Avm_fi::eFctCamera_Diag_Sensor;
        
        ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::sendCamera_Diag_SensorSetOut: eFctCamera_Diag_Sensor, Opcode: MCAN_C_OP_TYPE_SET, data: %02x ", ETG_LIST_LEN(u32Len), ETG_LIST_PTR_T8((tU8*)&pu8DataBuf[2]) ));        
        
        bDoCDataReq( pu8DataBuf, u32Len+2);
        
        delete[] pu8DataBuf;

        vLogNewMsg( (tU16)::Avm_fi::eFctCamera_Diag_Sensor, MCAN_C_OP_TYPE_SET, TRUE);
    } else {
        ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::sendCamera_Diag_SensorSetOut: Sending currently not possible --> try later (Connect: %d, Allowed: %d)!", bIsConnected(), bIsAllowedToSendCData()));
        bRet = FALSE;
    }
    
    return bRet;
}

tBool dispvidctrl_tclClientAvmAdaptor::sendCamera_Diag_SensorGetOut(tcl_ITM_Camera_System_Camera_Diag_Sensor_GetOut& oOutMsg){
    tBool bRet = TRUE;
     
    ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::sendCamera_Diag_SensorGetOut(): "));

    if (bIsConnected() && bIsAllowedToSendCData()) {

        tU16 u16Command = MCAN_ASSEMBLE_COMMAND( (tU16)::Avm_fi::eFctCamera_Diag_Sensor, MCAN_C_OP_TYPE_GET );

        tU32 u32Len = oOutMsg.u32PrepareOutMsg();

        tU8* pu8DataBuf = new tU8[u32Len + 2]; // +2 byte for header information
        
        pu8DataBuf[0] = CSM_M_GET_HIBYTE( u16Command );
        pu8DataBuf[1] = CSM_M_GET_LOBYTE( u16Command );

        oOutMsg.u32FillOutMsg(&pu8DataBuf[2], u32Len);

        _u16MessageInSending = (tU16)::Avm_fi::eFctCamera_Diag_Sensor;
        
        ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::sendCamera_Diag_SensorGetOut: eFctCamera_Diag_Sensor, Opcode: MCAN_C_OP_TYPE_GET, data: %02x ", ETG_LIST_LEN(u32Len), ETG_LIST_PTR_T8((tU8*)&pu8DataBuf[2]) ));        
        
        bDoCDataReq( pu8DataBuf, u32Len+2);
        
        delete[] pu8DataBuf;

        vLogNewMsg( (tU16)::Avm_fi::eFctCamera_Diag_Sensor, MCAN_C_OP_TYPE_GET, TRUE);
    } else {
        ETG_TRACE_USR1(("dispvidctrl_tclClientAvmAdaptor::sendCamera_Diag_SensorGetOut: Sending currently not possible --> try later (Connect: %d, Allowed: %d)!", bIsConnected(), bIsAllowedToSendCData()));
        bRet = FALSE;
    }
    
    return bRet;
}

// tstdbusclient_ClientTestclDefinitioPart: user specific code start
// tstdbusclient_ClientTestclDefinitioPart: user specific code end


