/**
  * @swcomponent   Life Cycle Management
  * @{
  * @file          Idispvidctrl_ClientAvmAdaptor.h
  * @PROJECT:      CMD project
  * @SW-COMPONENT: dispvidctrl
  * @Template:     IMCanAdaptor.h.tpl
  * ----------------------------------------------------------------------------
  *
  * @brief         generated file
  *                Csm adapter interface
  *
  *                Do here client specific implementation
  *                Changes possible only inside tags
  *
  *                //......................: user specific code start 
  *                //......................: user specific code end
  *
  * ----------------------------------------------------------------------------
  * @copyright     (c) 2018 Robert Bosch GmbH.
  *                The reproduction, distribution and utilization of this file as well as the
  *                communication of its contents to others without express authorization is prohibited.
  *                Offenders will be held liable for the payment of damages.
  *                All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#ifndef _I_AVMMCAN_CLIENT_ADAPTOR_H_
#define _I_AVMMCAN_CLIENT_ADAPTOR_H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/
//include base class
#include "dispvidctrl_AppMain.h"

#define MIDW_COMMON_S_IMPORT_INTERFACE_MCAN
#include "midw_common_if.h"

#include "mcanMessage.h"

// I_dispvidctrl_tclClientAvmAdaptor_Include: user specific code start
// I_dispvidctrl_tclClientAvmAdaptor_Include: user specific code end

namespace Avm_fi {

    typedef enum {
        //message IDs
        eFctSoftware_Version     = 0x0011,
        eFctHardware_Version     = 0x0010,
        eFctSW_Signal            = 0x0120,
        eFctExtra_SW             = 0x0121,
        eFctView_Change_08AVM    = 0x0124,
        eFctBlanking_OFF         = 0x0123,
        eFctBlanking_less_Change_08AVM = 0x0141,
        eFctDirect_Camera_OFF    = 0x0130,
        eFctAVM_Sonar_Buzzer     = 0x0150,
        eFctCamera_Setting_08AVM = 0x0201,
        eFctCamera_Primary_Setting = 0x0250,
        eFctMCAN_Communication_Error = 0x0022,
        eFctMCAN_Communication_Error_Clear = 0x0023,
        eFctCamera_Diag_Sensor   = 0x0310,
    }EMessageIds;
}

class AvmMCanAvmCallbackIf
{
    public:
        virtual ~AvmMCanAvmCallbackIf() {};
        virtual void onSoftware_VersionStatusIn(tcl_ITM_Camera_System_Software_Version_StatusIn& oIn_Software_Version) = 0;
        virtual void onHardware_VersionStatusIn(tcl_ITM_Camera_System_Hardware_Version_StatusIn& oIn_Hardware_Version) = 0;
        virtual void onExtra_SWIndicationIn(tcl_ITM_Camera_System_Extra_SW_IndicationIn& oIn_Extra_SW) = 0;
        virtual void onView_Change_08AVMSetIn(tcl_ITM_Camera_System_View_Change_08AVM_SetIn& oIn_View_Change_08AVM) = 0;
        virtual void onBlanking_OFFIndicationIn(tcl_ITM_Camera_System_Blanking_OFF_IndicationIn& oIn_Blanking_OFF) = 0;
        virtual void onBlanking_less_Change_08AVMIndicationIn(tcl_ITM_Camera_System_Blanking_less_Change_08AVM_IndicationIn& oIn_Blanking_less_Change_08AVM) = 0;
        virtual void onAVM_Sonar_BuzzerStatusIn(tcl_ITM_Camera_System_AVM_Sonar_Buzzer_StatusIn& oIn_AVM_Sonar_Buzzer) = 0;
        virtual void onAVM_Sonar_BuzzerIndicationIn(tcl_ITM_Camera_System_AVM_Sonar_Buzzer_IndicationIn& oIn_AVM_Sonar_Buzzer) = 0;
        virtual void onCamera_Setting_08AVMStatusIn(tcl_ITM_Camera_System_Camera_Setting_08AVM_StatusIn& oIn_Camera_Setting_08AVM) = 0;
        virtual void onCamera_Setting_08AVMIndicationIn(tcl_ITM_Camera_System_Camera_Setting_08AVM_IndicationIn& oIn_Camera_Setting_08AVM) = 0;
        virtual void onCamera_Primary_SettingStatusIn(tcl_ITM_Camera_System_Camera_Primary_Setting_StatusIn& oIn_Camera_Primary_Setting) = 0;
        virtual void onMCAN_Communication_ErrorStatusIn(tcl_ITM_Camera_System_MCAN_Communication_Error_StatusIn& oIn_MCAN_Communication_Error) = 0;
        virtual void onMCAN_Communication_Error_ClearStatusIn(tcl_ITM_Camera_System_MCAN_Communication_Error_Clear_StatusIn& oIn_MCAN_Communication_Error_Clear) = 0;
        virtual void onCamera_Diag_SensorStatusIn(tcl_ITM_Camera_System_Camera_Diag_Sensor_StatusIn& oIn_Camera_Diag_Sensor) = 0;
        virtual void onCamera_Diag_SensorIndicationIn(tcl_ITM_Camera_System_Camera_Diag_Sensor_IndicationIn& oIn_Camera_Diag_Sensor) = 0;
};

class I_dispvidctrl_tclClientAvmAdaptor : public dispvidctrl_tclBaseIf, public tclMCANInterface
{
public:
    I_dispvidctrl_tclClientAvmAdaptor(
        dispvidctrl_tclAppMain*       poMainAppl,
        tU16                           u16EventMask,
        tVoid*                         pvCallbacks,
        tU8                            u8LocCompID, 
        tU8                            u8RemCompID,
        tBool                          bUseAvailableFunctionForConfiguration,
        tU8                            u8AvailableFunctionForConfiguration
        )
        : dispvidctrl_tclBaseIf(poMainAppl),
        tclMCANInterface
        ( 
        u16EventMask,
        pvCallbacks,
        u8LocCompID, 
        u8RemCompID,
        bUseAvailableFunctionForConfiguration,
        u8AvailableFunctionForConfiguration 
        )

    {;}


    virtual ~I_dispvidctrl_tclClientAvmAdaptor() {;}
    virtual const tChar* getIfName() const { return "I_dispvidctrl_tclClientAvmAdaptor"; };

    virtual tBool bOnInit( ) = 0;

    virtual tVoid vShowCommunicationState() = 0;
    virtual tVoid vShowVersioninfo() = 0;

    virtual tBool bAllowedToSend() = 0;
    virtual tU8   u8GetUnitId() const = 0;
    virtual tBool bIsConnectionAvailable() = 0;

    virtual tVoid vSetCallbackIf(AvmMCanAvmCallbackIf* pCallback) = 0;

    virtual tBool sendSoftware_VersionGetOut(tcl_ITM_Camera_System_Software_Version_GetOut& oIn_Software_Version) = 0;
    virtual tBool sendHardware_VersionGetOut(tcl_ITM_Camera_System_Hardware_Version_GetOut& oIn_Hardware_Version) = 0;
    virtual tBool sendSW_SignalIndicationOut(tcl_ITM_Camera_System_SW_Signal_IndicationOut& oIn_SW_Signal) = 0;
    virtual tBool sendView_Change_08AVMStatusOut(tcl_ITM_Camera_System_View_Change_08AVM_StatusOut& oIn_View_Change_08AVM) = 0;
    virtual tBool sendDirect_Camera_OFFIndicationOut(tcl_ITM_Camera_System_Direct_Camera_OFF_IndicationOut& oIn_Direct_Camera_OFF) = 0;
    virtual tBool sendAVM_Sonar_BuzzerSetOut(tcl_ITM_Camera_System_AVM_Sonar_Buzzer_SetOut& oIn_AVM_Sonar_Buzzer) = 0;
    virtual tBool sendCamera_Setting_08AVMSetOut(tcl_ITM_Camera_System_Camera_Setting_08AVM_SetOut& oIn_Camera_Setting_08AVM) = 0;
    virtual tBool sendCamera_Setting_08AVMGetOut(tcl_ITM_Camera_System_Camera_Setting_08AVM_GetOut& oIn_Camera_Setting_08AVM) = 0;
    virtual tBool sendCamera_Primary_SettingSetOut(tcl_ITM_Camera_System_Camera_Primary_Setting_SetOut& oIn_Camera_Primary_Setting) = 0;
    virtual tBool sendCamera_Primary_SettingGetOut(tcl_ITM_Camera_System_Camera_Primary_Setting_GetOut& oIn_Camera_Primary_Setting) = 0;
    virtual tBool sendMCAN_Communication_ErrorGetOut(tcl_ITM_Camera_System_MCAN_Communication_Error_GetOut& oIn_MCAN_Communication_Error) = 0;
    virtual tBool sendMCAN_Communication_Error_ClearSetOut(tcl_ITM_Camera_System_MCAN_Communication_Error_Clear_SetOut& oIn_MCAN_Communication_Error_Clear) = 0;
    virtual tBool sendCamera_Diag_SensorSetOut(tcl_ITM_Camera_System_Camera_Diag_Sensor_SetOut& oIn_Camera_Diag_Sensor) = 0;
    virtual tBool sendCamera_Diag_SensorGetOut(tcl_ITM_Camera_System_Camera_Diag_Sensor_GetOut& oIn_Camera_Diag_Sensor) = 0;

    // I_dispvidctrl_tclClientAvmAdaptorIfDeclarations: user specific code start
    // I_dispvidctrl_tclClientAvmAdaptorIfDeclarations: user specific code end
};

#endif // _I_AVMMCAN_CLIENT_ADAPTOR_H_


