/*****************************************************************************
* FILE:         dispvidctrl_ClientEarlyIncAdaptor.cpp
* PROJECT:      G3G project
* SW-COMPONENT: dispvidctrl
* Template:     incAdaptor.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2018 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

//include base class
#include "dispvidctrl_AppMain.h"

#include "Early_incCallbackIf.h"
#include "dispvidctrl_ClientEarlyIncAdaptor.h"

#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <errno.h>
#include <stdio.h>
#include <dirent.h>
#include <mntent.h>

#include "inc.h"
#include "inc_ports.h"
#include "dgram_service.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DISPVIDCTRL_CLIENT_EARLY
#include "trcGenProj/Header/dispvidctrl_ClientEarlyIncAdaptor.cpp.trc.h"
#endif

// dispvidctrl_tclClientEarlyIncAdaptorIncludes: user specific code start
// dispvidctrl_tclClientEarlyIncAdaptorIncludes: user specific code end

/* ---------------- */
/* public functions */
/* ---------------- */

dispvidctrl_tclClientEarlyIncAdaptor::dispvidctrl_tclClientEarlyIncAdaptor(dispvidctrl_tclAppMain* poMainAppl) : 
I_dispvidctrl_tclClientEarlyIncAdaptor(poMainAppl)
{

    ETG_TRACE_USR4(("dispvidctrl_tclClientEarlyIncAdaptor::dispvidctrl_tclClientEarlyIncAdaptor(): Called.... ."));

   _poDatagramSocket = new DatagramSocket(this, 8000, 100, EARLY_APP_PORT, AF_BOSCH_INC_AUTOSAR, TRUE);
   _poCallbackIf     = OSAL_NULL;
   
   // dispvidctrl_tclClientEarlyIncAdaptor::dispvidctrl_tclClientEarlyIncAdaptor: user specific code start
   // dispvidctrl_tclClientEarlyIncAdaptor::dispvidctrl_tclClientEarlyIncAdaptor: user specific code end   
}

dispvidctrl_tclClientEarlyIncAdaptor::~dispvidctrl_tclClientEarlyIncAdaptor()
{

   ETG_TRACE_USR4(("dispvidctrl_tclClientEarlyIncAdaptor::~dispvidctrl_tclClientEarlyIncAdaptor(): Called.... ."));

   if( OSAL_NULL != _poDatagramSocket) {
      OSAL_DELETE _poDatagramSocket;
   }
   
   _poDatagramSocket = OSAL_NULL;
   _poCallbackIf     = OSAL_NULL;
}

tVoid dispvidctrl_tclClientEarlyIncAdaptor::vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientEarlyIncAdaptor::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(dispvidctrl_tclBaseIf::ECmdTypes, pMsg->eCmd), pMsg->u.u32Data));
   if (pMsg->eCmd == dispvidctrl_tclBaseIf::eCmdIncMsgReceived) {
       vDispatchMessage(pMsg->u.au8Data, DISPVIDCTRLINTERNAL_MSG_LEN);
   }
   // dispvidctrl_tclClientEarlyIncAdaptor::vHandleMessage: user specific code start
   // dispvidctrl_tclClientEarlyIncAdaptor::vHandleMessage: user specific code end
}

tVoid dispvidctrl_tclClientEarlyIncAdaptor::vHandleTraceMessage(const tUChar* puchData)
{
    DISPVIDCTRL_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("dispvidctrl_tclClientEarlyIncAdaptor::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // dispvidctrl_tclClientEarlyIncAdaptor::vHandleTraceMessage: user specific code start
   // dispvidctrl_tclClientEarlyIncAdaptor::vHandleTraceMessage: user specific code end
}

tVoid dispvidctrl_tclClientEarlyIncAdaptor::vGetReferences() {
   // dispvidctrl_tclClientEarlyIncAdaptor::vGetReferences: user specific code start
   // dispvidctrl_tclClientEarlyIncAdaptor::vGetReferences: user specific code end
}


tVoid dispvidctrl_tclClientEarlyIncAdaptor::vTraceInfo()
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientEarlyIncAdaptor::vTraceInfo() entered."));
   // dispvidctrl_tclClientEarlyIncAdaptor::vTraceInfo: user specific code start
   // dispvidctrl_tclClientEarlyIncAdaptor::vTraceInfo: user specific code end

}


tVoid dispvidctrl_tclClientEarlyIncAdaptor::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientEarlyIncAdaptor::vStartCommunication() entered."));
   // dispvidctrl_tclClientEarlyIncAdaptor::vStartCommunication: user specific code start
   // dispvidctrl_tclClientEarlyIncAdaptor::vStartCommunication: user specific code end
}

tBool dispvidctrl_tclClientEarlyIncAdaptor::sendMessage(tU8* u8buf, tU32 ulen) {

    tBool bRet = FALSE;
    ETG_TRACE_USR1(("dispvidctrl_tclClientEarlyIncAdaptor::sendMessage(): Called.... ."));
    if (_poDatagramSocket) {
        ETG_TRACE_USR1(("dispvidctrl_tclClientEarlyIncAdaptor::sendMessage():  Send message ID: %02x, datalen %d.", (tU8)u8buf[0], ulen));

        if (0 != _poDatagramSocket->sendMessage((void*)u8buf, ulen)) {
            bRet = TRUE;
        }
    }
    return bRet;
}

void dispvidctrl_tclClientEarlyIncAdaptor::onNewDatagramMessage(void* data, size_t length)
{
    dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = dispvidctrl_tclBaseIf::eCmdIncMsgReceived;
    memset(oMsg.strClassName, 0, 50);
    OSAL_szStringNCopy(oMsg.strClassName, "I_dispvidctrl_tclClientEarlyIncAdaptor", strlen("I_dispvidctrl_tclClientEarlyIncAdaptor"));

    if (length <= DISPVIDCTRLINTERNAL_MSG_LEN) {
        (tVoid)OSAL_pvMemoryCopy(oMsg.u.au8Data, data, length);
        _cpoMain->theServer()->vPostInternalMessage(&oMsg);
    } else {
        ETG_TRACE_FATAL(("dispvidctrl_tclClientEarlyIncAdaptor::onNewDatagramMessage(): message too long."));
        // dispvidctrl_tclClientEarlyIncAdaptor::onNewDatagramMessage: user specific code start
        ETG_TRACE_FATAL(("dispvidctrl_tclClientEarlyIncAdaptor::onNewDatagramMessage(): message data: %*x", ETG_LIST_LEN(length), ETG_LIST_PTR_T8((tU8*)data)));
        // dispvidctrl_tclClientEarlyIncAdaptor::onNewDatagramMessage: user specific code end        
    }

}

void dispvidctrl_tclClientEarlyIncAdaptor::vDispatchMessage(void* data, size_t length)
{
   tU8* pu8Data = (tU8*)data;
   ETG_TRACE_USR1(("dispvidctrl_tclClientEarlyIncAdaptor::vDispatchMessage() entered -> data: %*x", ETG_LIST_LEN(length), ETG_LIST_PTR_T8((tU8*)data)));

   // dispvidctrl_tclClientEarlyIncAdaptor::vDispatchMessage: user specific code start
   if ( (tU8) ::early_inc_fi::eSCC_EARLY_R_COMMUNICATION_CTRL == pu8Data[0] ) {  // need to pass parameters, but generated standard code further down doesn't have any
      if (_poCallbackIf) {
          _poCallbackIf->onCOMMUNICATION_CTRL(pu8Data[1], &pu8Data[2]);
      }
      return;
   }
   if ( (tU8) ::early_inc_fi::eSCC_EARLY_R_UPDATE_SIGNALS == pu8Data[0] ) {  // need to pass parameters, but generated standard code further down doesn't have any
      if (_poCallbackIf) {
          _poCallbackIf->onUPDATE_SIGNALS(pu8Data[1], &pu8Data[2]);
      }
      return;
   }
   // dispvidctrl_tclClientEarlyIncAdaptor::vDispatchMessage: user specific code end

   switch (pu8Data[0]) {
       case (tU8) ::early_inc_fi::eSCC_EARLY_R_COMPONENT_STATUS:
           if (_poCallbackIf) {
               _poCallbackIf->onCOMPONENT_STATUS((::early_inc_fi::EApplicationStatus)pu8Data[1], (tU8)pu8Data[2]);
           }
           break;
       case (tU8) ::early_inc_fi::eSCC_EARLY_R_REJECT:
           if (_poCallbackIf) {
               _poCallbackIf->onREJECT((::early_inc_fi::ERejectReason)pu8Data[1], (tU8)pu8Data[2]);
           }
           break;
       case (tU8) ::early_inc_fi::eSCC_EARLY_R_COMMUNICATION_CTRL:
           if (_poCallbackIf) {
               _poCallbackIf->onCOMMUNICATION_CTRL();
           }
           break;
       case (tU8) ::early_inc_fi::eSCC_EARLY_R_GET_SIGNALS:
           if (_poCallbackIf) {
               _poCallbackIf->onGET_SIGNALS();
           }
           break;
       case (tU8) ::early_inc_fi::eSCC_EARLY_R_UPDATE_SIGNALS:
           if (_poCallbackIf) {
               _poCallbackIf->onUPDATE_SIGNALS();
           }
           break;
       default:
           break;
   }
}

tBool dispvidctrl_tclClientEarlyIncAdaptor::sendCOMPONENT_STATUS(::early_inc_fi::EApplicationStatus ApplicationStatus, tU8 ApplicationVersion) {
    tU8 au8Data[] = {(tU8)::early_inc_fi::eSCC_EARLY_C_COMPONENT_STATUS, (tU8)ApplicationStatus, (tU8)ApplicationVersion};
    ETG_TRACE_USR4(("dispvidctrl_tclClientEarlyIncAdaptor::sendCOMPONENT_STATUS(): INC interface is valid. Send now."));
    // dispvidctrl_tclClientEarlyIncAdaptor::sendCOMPONENT_STATUS: user specific code start
    // dispvidctrl_tclClientEarlyIncAdaptor::sendCOMPONENT_STATUS: user specific code end
    return sendMessage(au8Data, sizeof(au8Data));
}
tBool dispvidctrl_tclClientEarlyIncAdaptor::sendCOMMUNICATION_CTRL(tU8 u8InitComm, tU8 u8AutoMode) {
    tU8 au8Data[] = {(tU8)::early_inc_fi::eSCC_EARLY_C_COMMUNICATION_CTRL, (tU8)u8InitComm, (tU8)u8AutoMode};
    ETG_TRACE_USR4(("dispvidctrl_tclClientEarlyIncAdaptor::sendCOMMUNICATION_CTRL(): INC interface is valid. Send now."));
    // dispvidctrl_tclClientEarlyIncAdaptor::sendCOMMUNICATION_CTRL: user specific code start
    // dispvidctrl_tclClientEarlyIncAdaptor::sendCOMMUNICATION_CTRL: user specific code end
    return sendMessage(au8Data, sizeof(au8Data));
}
tBool dispvidctrl_tclClientEarlyIncAdaptor::sendGET_SIGNALS(tU8 u8InitSig, tU16 u16Signal) {
    tU8 au8Data[] = {(tU8)::early_inc_fi::eSCC_EARLY_C_GET_SIGNALS, (tU8)u8InitSig, (tU8)((0x00FF & ((tU16)u16Signal)) >> 0), (tU8)((0xFF00 & ((tU16)u16Signal)) >> 8)};
    ETG_TRACE_USR4(("dispvidctrl_tclClientEarlyIncAdaptor::sendGET_SIGNALS(): INC interface is valid. Send now."));
    // dispvidctrl_tclClientEarlyIncAdaptor::sendGET_SIGNALS: user specific code start
    // dispvidctrl_tclClientEarlyIncAdaptor::sendGET_SIGNALS: user specific code end
    return sendMessage(au8Data, sizeof(au8Data));
}
tBool dispvidctrl_tclClientEarlyIncAdaptor::sendUPDATE_SIGNALS() {
    tU8 au8Data[] = {(tU8)::early_inc_fi::eSCC_EARLY_C_UPDATE_SIGNALS};
    ETG_TRACE_USR4(("dispvidctrl_tclClientEarlyIncAdaptor::sendUPDATE_SIGNALS(): INC interface is valid. Send now."));
    // dispvidctrl_tclClientEarlyIncAdaptor::sendUPDATE_SIGNALS: user specific code start
    // dispvidctrl_tclClientEarlyIncAdaptor::sendUPDATE_SIGNALS: user specific code end
    return sendMessage(au8Data, sizeof(au8Data));
}
tBool dispvidctrl_tclClientEarlyIncAdaptor::sendACTION(::early_inc_fi::EAction Action, tU8 u8Parameter) {
    tU8 au8Data[] = {(tU8)::early_inc_fi::eSCC_EARLY_C_ACTION, (tU8)Action, (tU8)u8Parameter};
    ETG_TRACE_USR4(("dispvidctrl_tclClientEarlyIncAdaptor::sendACTION(): INC interface is valid. Send now."));
    // dispvidctrl_tclClientEarlyIncAdaptor::sendACTION: user specific code start
    // note: this message needs one extra byte inside the message (namely the length of the action parameter(s); here: 1), so we have to use a "dirty trick":
    if (&au8Data[0]) {  // "morally" equivalent to "if(1)", but (hopefully) compiler and/or lint won't complain about unreachable code further down
       tU8 au8DataPlusLenByte[] = {(tU8)::early_inc_fi::eSCC_EARLY_C_ACTION, (tU8)Action, 1, (tU8)u8Parameter};
       ETG_TRACE_USR4(("dispvidctrl_tclClientEarlyIncAdaptor::sendACTION()Action %d, Parameter %d", ETG_CENUM(early_inc_fi::EAction, Action), u8Parameter));
       return sendMessage(au8DataPlusLenByte, sizeof(au8DataPlusLenByte));
    }
    // dispvidctrl_tclClientEarlyIncAdaptor::sendACTION: user specific code end
	//CID: 90907
		// Commenting the below func call its never gets executed 
		
  //  return sendMessage(au8Data, sizeof(au8Data));
}

// dispvidctrl_EARLYAdaptorAddClassPart: user specific code start

/******************************************************************************/
/* FUNCTION     vGetReferences                                                */
/******************************************************************************/
/**
*  \brief       Function to get all reference needed by this class.
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclClientEarlyIncAdaptor::vGetReferencesEarly(tVoid)
{
   ETG_TRACE_USR1(("dispvidctrl_tclClientEarlyIncAdaptor::vGetReferencesEarly() entered."));
}


/******************************************************************************/
/* FUNCTION     vStartCommunication                                           */
/******************************************************************************/
/**
*  \brief       Function to start all dynamic objects e.g. threads, ...
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclClientEarlyIncAdaptor::vStartCommunicationEarly(tVoid)
{
   ETG_TRACE_USR1(("[%d ms] dispvidctrl_tclClientEarlyIncAdaptor::vStartCommunicationEarly() entered.", OSAL_ClockGetElapsedTime()));
   //sendCOMPONENT_STATUS( ::early_inc_fi::eACTIVE, 1);
}

// dispvidctrl_EARLYAdaptorAddClassPart: user specific code end
