#ifndef _EARLYINCCALLBACKIF_H_
#define _EARLYINCCALLBACKIF_H_

/**
  * @swcomponent   Life Cycle Management
  * @{
  * @file          Early_incCallbackIf.h
  * @PROJECT:      CMD project
  * @SW-COMPONENT: dispvidctrl
  * @Template:     incCallbackIf.h.tpl
  * ----------------------------------------------------------------------------
  *
  * @brief         generated file
  *                INC adapter
  *
  *                Do here client specific implementation
  *                Changes possible only inside tags
  *         
  *                //......................: user specific code start 
  *                //......................: user specific code end 
  * ----------------------------------------------------------------------------
  * @copyright     (c) 2018 Robert Bosch GmbH.
  *                The reproduction, distribution and utilization of this file as well as the
  *                communication of its contents to others without express authorization is prohibited.
  *                Offenders will be held liable for the payment of damages.
  *                All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#include "dispvidctrl_ClientEarlyIncFiDef.h"

class EarlyIncCallbackIf
{
   public:
       virtual ~EarlyIncCallbackIf() {};
       virtual void onCOMPONENT_STATUS(::early_inc_fi::EApplicationStatus ApplicationStatus, tU8 ApplicationVersion) = 0;
       virtual void onREJECT(::early_inc_fi::ERejectReason RejectReason, tU8 RejectedMsgID) = 0;
       virtual void onCOMMUNICATION_CTRL() = 0;
       virtual void onGET_SIGNALS() = 0;
       virtual void onUPDATE_SIGNALS() = 0;

    // EarlyIncCallbackIf_AddClassPart: user specific code start
       virtual void onCOMMUNICATION_CTRL(tU8 u8NumSignals, tU8* p8Data) = 0;
       virtual void onUPDATE_SIGNALS(tU8 u8NumSignals, tU8* p8Data) = 0;
    // EarlyIncCallbackIf_AddClassPart: user specific code end
};


#endif //_EARLYINCCALLBACKIF_H_

