/*****************************************************************************
* FILE:         dispvidctrl_ClientDimmingIncAdaptor.h
* PROJECT:      G3G project
* SW-COMPONENT: dispvidctrl
* Template:     incAdaptor.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2018 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#ifndef _DIMMINGINCADAPTOR_H_
#define _DIMMINGINCADAPTOR_H_


/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/
#include <list>

#include "I_dispvidctrl_ClientDimmingIncAdaptor.h"

class DimmingIncCallbackIf;

class dispvidctrl_tclClientDimmingIncAdaptor : public I_dispvidctrl_tclClientDimmingIncAdaptor
{
private: 
    DatagramSocket*          _poDatagramSocket;
    DimmingIncCallbackIf*   _poCallbackIf;
public:
    dispvidctrl_tclClientDimmingIncAdaptor(dispvidctrl_tclAppMain* poMainAppl);
    dispvidctrl_tclClientDimmingIncAdaptor(const dispvidctrl_tclClientDimmingIncAdaptor& objRef);
    dispvidctrl_tclClientDimmingIncAdaptor& operator=(const dispvidctrl_tclClientDimmingIncAdaptor& objRef);
    virtual ~dispvidctrl_tclClientDimmingIncAdaptor();

    virtual const tChar* getName() const { return "dispvidctrl_tclClientDimmingIncAdaptor"; };
   
    virtual tVoid vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg);
    virtual tVoid vHandleTraceMessage(const tUChar* puchData);
    virtual tVoid vGetReferences();
    virtual tVoid vStartCommunication();
    virtual tVoid vTraceInfo();

    virtual tVoid vSetCallbackIf(DimmingIncCallbackIf* poCallback) {
      _poCallbackIf = poCallback;
    }

    virtual tBool sendMessage(tU8* u8buf, tU32 ulen);

    // methods to send INC messages
    virtual tBool sendCOMPONENT_STATUS(::dimming_inc_fi::EApplicationStatus ApplicationStatus, tU8 ApplicationVersion);
    virtual tBool sendREJECT(::dimming_inc_fi::ERejectReason RejectReason, tU8 RejectedMsgID);
    virtual tBool sendDISPLAY_REQ(::dimming_inc_fi::EDisplayRequest DisplayRequest);
    virtual tBool sendDISPLAY_READY(::dimming_inc_fi::EDisplayReady DisplayReady);
    virtual tBool sendDISP_SET_BRIGHTNESS_LEVEL(tU8 DimmingModeAndDispBrightnessLevel);
    virtual tBool sendDISP_SET_DIMMING(tU32 DispBrightness);
    virtual tBool sendKEY_SET_BRIGHTNESS_LEVEL(tU8 KeyBrightnessLevel);
    virtual tBool sendINFO_SET_DIMMINGMODE_CONFIG(::dimming_inc_fi::EDimmingMode DimmingMode);
    virtual tBool sendINFO_GET_DIMMINGMODE_STATE();
    virtual tBool sendDIAG_DISP_READ_BRIGHT_VAL();
    virtual tBool sendDIAG_KEYB_READ_BRIGHT_VAL();
    virtual tBool sendDIAG_KEYB_SET_DIMMING(tU8 KeyB_Brightness);
    virtual tBool sendDIAG_SESSION(::dimming_inc_fi::ESessionType Session_Type);
    virtual tBool sendDIAG_READ_BRIGHTNESS_VAL(::dimming_inc_fi::EDeviceType Device_Type);
    virtual tBool sendDIAG_SET_BRIGHTNESS_VAL(::dimming_inc_fi::EDeviceType Device_Type, tU16 Brightness);
    virtual tBool sendGET_DIMMING_INFO_PRJ();
    virtual tBool sendSECOND_DISP_GET_HW_VERSION();
    virtual tBool sendSECOND_DISP_GET_SW_VERSION();
    virtual tBool sendSECOND_DISP_SET_DISPLAY_PARAMETERS(::dimming_inc_fi::ESecondDisplayParamID e16SecondDisplayParamID, tU16 u16ParameterValue);
    virtual tBool sendSECOND_DISP_GET_DIMMING_PARAMETERS();
    virtual tBool sendSEND_POWERMODE_TO_V850(tU8 u8PowerMode);
    virtual tBool sendSECOND_DISP_GET_SELF_DIAGNOSTIC_RESULT();

private:

    virtual void onNewDatagramMessage(void* data, size_t length);
    virtual void vDispatchMessage(void* data, size_t length);
    
    // dispvidctrl_DIMMINGAdaptorAddClassPart: user specific code start
private:
    ::dimming_inc_fi::EApplicationStatus _tAppState;
    tU8                                  _u8AppVersion;
    tBool                                _bDimState;
public:
    virtual tVoid vGetReferencesEarly();
    virtual tVoid vStartCommunicationEarly();

    virtual tBool bIsBacklightActive() { return _bDimState;};

    virtual tVoid getComponentStatus(::dimming_inc_fi::EApplicationStatus& ApplicationStatus, tU8& ApplicationVersion) {
        ApplicationStatus  = _tAppState;
        ApplicationVersion = _u8AppVersion;
    };

    // dispvidctrl_DIMMINGAdaptorAddClassPart: user specific code end

};

#endif // _DIMMINGINCADAPTOR_H_

