#ifndef _DIMMINGINCCALLBACKIF_H_
#define _DIMMINGINCCALLBACKIF_H_

/**
  * @swcomponent   Life Cycle Management
  * @{
  * @file          Dimming_incCallbackIf.h
  * @PROJECT:      CMD project
  * @SW-COMPONENT: dispvidctrl
  * @Template:     incCallbackIf.h.tpl
  * ----------------------------------------------------------------------------
  *
  * @brief         generated file
  *                INC adapter
  *
  *                Do here client specific implementation
  *                Changes possible only inside tags
  *         
  *                //......................: user specific code start 
  *                //......................: user specific code end 
  * ----------------------------------------------------------------------------
  * @copyright     (c) 2018 Robert Bosch GmbH.
  *                The reproduction, distribution and utilization of this file as well as the
  *                communication of its contents to others without express authorization is prohibited.
  *                Offenders will be held liable for the payment of damages.
  *                All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#include "dispvidctrl_ClientDimmingIncFiDef.h"

class DimmingIncCallbackIf
{
   public:
       virtual ~DimmingIncCallbackIf() {};
       virtual void onCOMPONENT_STATUS(::dimming_inc_fi::EApplicationStatus ApplicationStatus, tU8 ApplicationVersion) = 0;
       virtual void onREJECT(::dimming_inc_fi::ERejectReason RejectReason, tU8 RejectedMsgID) = 0;
       virtual void onDISPLAY_REQ(::dimming_inc_fi::EDisplayRequest DisplayRequest) = 0;
       virtual void onDISPLAY_READY(::dimming_inc_fi::EDisplayReady DisplayReady) = 0;
       virtual void onDISP_SET_BRIGHTNESS_LEVEL(tU8 DimmingModeAndDispBrightnessLevel, tU8 errorCode) = 0;
       virtual void onDISP_SET_DIMMING(tU32 DispBrightness, tU8 errorCode) = 0;
       virtual void onINFO_SET_DIMMINGMODE_CONFIG(::dimming_inc_fi::EDimmingMode DimmingMode) = 0;
       virtual void onINFO_GET_DIMMINGMODE_STATE(::dimming_inc_fi::EDimmingModeStatus DimmingMode, tS8 DispBrightnessOffset) = 0;
       virtual void onDIAG_DISP_READ_BRIGHT_VAL(tU8 DispBrightness) = 0;
       virtual void onDIAG_KEYB_READ_BRIGHT_VAL(tU8 KeyB_Brightness) = 0;
       virtual void onDIAG_KEYB_SET_DIMMING(tU8 KeyB_Brightness) = 0;
       virtual void onDIAG_SESSION(::dimming_inc_fi::ESessionType Session_Type) = 0;
       virtual void onDIAG_READ_BRIGHTNESS_VAL(::dimming_inc_fi::EDeviceType Device_Type, tU16 Brightness) = 0;
       virtual void onDIAG_SET_BRIGHTNESS_VAL(::dimming_inc_fi::EDeviceType Device_Type, tU16 Brightness) = 0;
       virtual void onGET_DIMMING_INFO_PRJ(tU32 DimInfoPrj) = 0;
       virtual void onSECOND_DISP_GET_HW_VERSION(tU32 HWVersion) = 0;
       virtual void onSECOND_DISP_GET_SW_VERSION(tU32 SWVersion) = 0;
       virtual void onSECOND_DISP_SET_DISPLAY_PARAMETERS(tU16 u16FunctionId, tU16 u16ParameterValue, tU8 u8ErrorCode) = 0;
       virtual void onSECOND_DISP_GET_DIMMING_PARAMETERS(tU8 u8BlackLevel, tU8 u8Brightness, tU8 u8Color, tU8 u8Contrast, tU8 u8Tint, tU16 u8GammaLevel) = 0;
       virtual void onSEND_POWERMODE_TO_V850(tU8 u8PowerState, tU8 u8ErrorCode) = 0;
       virtual void onSECOND_DISP_GET_SELF_DIAGNOSTIC_RESULT(tU16 u16SelfDiagResult ) = 0;

    // DimmingIncCallbackIf_AddClassPart: user specific code start
    // DimmingIncCallbackIf_AddClassPart: user specific code end
};


#endif //_DIMMINGINCCALLBACKIF_H_

