/*****************************************************************************
* FILE:         dispvidctrl_ClientVideomanager.h
* PROJECT:      G3G project
* SW-COMPONENT: dispvidctrl
* Template:     ClientHandler.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2018 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#ifndef __dispvidctrl_ClientVideomanager_H_
#define __dispvidctrl_ClientVideomanager_H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

//include base class
#include "Idispvidctrl_ClientVideomanager.h"
#include "dispvidctrl_AppMain.h"

// dispvidctrl_tclClientVideomanager_Include: user specific code start
#include "I_dispvidctrl_tclVideoPlayer.h"
// dispvidctrl_tclClientVideomanager_Include: user specific code end

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class dispvidctrl_tclClientVideomanagerCallbackIF;

class ahl_tclBaseOneThreadClientHandler;

class dispvidctrl_tclClientVideomanager : public Idispvidctrl_tclClientVideomanager
{

public:
   virtual const tChar* getName() const { return "dispvidctrl_tclClientVideomanager"; };
   
   virtual tVoid vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();

   dispvidctrl_tclClientVideomanager(tVoid); 
   dispvidctrl_tclClientVideomanager(dispvidctrl_tclAppMain* poMainAppl);
   virtual ~dispvidctrl_tclClientVideomanager();

   virtual tVoid vSetCallbackIf(dispvidctrl_tclClientVideomanagerCallbackIF* poCallback) {
      _poCallbackIf = poCallback;
   }

   // dispvidctrl_tclClientVideomanagerDeclarations: user specific code start
   virtual tBool bGetRVCAActiveState() {
       return m_bVideoManagerRVCAActive;
   }
   virtual tBool bGetRVCDActiveState() {
       return m_bVideoManagerRVCDActive;
   }
   virtual tVoid vSetRVCStateActive();
   virtual tVoid vSetRVCStateInactive();
   virtual tVoid vGetReferencesEarly();
   virtual tBool bVideoManagerIsAvailable() {
       return m_bVideoManagerIsAvailable;
   }
   // dispvidctrl_tclClientVideomanagerDeclarations: user specific code end

   /**************************************************************************
   * Assingment Operater, will not be implemented.
   * Avoids Lint Prio 3 warning: Info 1732: new in constructor for class 
   * 'dispvidctrl_tclClientVideomanager' which has no assignment operator.
   * NOTE: This is a technique to disable the assignment operator for this
   * class. So if an attempt for the assignment is made compiler complains.
   **************************************************************************/
   dispvidctrl_tclClientVideomanager& operator = (const dispvidctrl_tclClientVideomanager &oClientHandler);

   /***************************************************************************
   * Overriding ahl_tclBaseOneThreadClientHandler methods.
   ***************************************************************************/
   virtual tVoid vOnServiceAvailable();
   virtual tVoid vOnServiceUnavailable();
   
private:
   dispvidctrl_tclClientVideomanagerCallbackIF* _poCallbackIf;

public:

   /***************************************************************************
   * all public methods to send / getCurrentState.
   ***************************************************************************/
   virtual tBool sendRVCASet();
   virtual tBool sendRVCDSet();


   virtual tBool sendRVCAGet();
   virtual tVoid getRVCAStatus(videomanager_fi_tcl_e8_vdmSourceState& rRVCA_StateInfo) {
      rRVCA_StateInfo       = _RVCA_StateInfo_RVCAStatus;
   }

   virtual tBool sendRVCDGet();
   virtual tVoid getRVCDStatus(videomanager_fi_tcl_e8_vdmSourceState& rRVCD_StateInfo) {
      rRVCD_StateInfo       = _RVCD_StateInfo_RVCDStatus;
   }

   virtual tBool sendRequestVideoSourceStateMStart(videomanager_fi_tcl_e8_vdmVideoSource tVideoSource, videomanager_fi_tcl_e8_vdmRequestedSourceState tRequestedState);

private:
   /***************************************************************************
   * handling of incomming messages
   ***************************************************************************/
   virtual tVoid vHandleRVCAOpStatus(amt_tclServiceData* poMessage);
   virtual tVoid vHandleRVCDOpStatus(amt_tclServiceData* poMessage);

   virtual tVoid vHandleRequestVideoSourceStateOpMResult(amt_tclServiceData* poMessage);

   virtual tVoid onRVCAStatus(videomanager_fi_tcl_e8_vdmSourceState RVCA_StateInfo);
   virtual tVoid onRVCDStatus(videomanager_fi_tcl_e8_vdmSourceState RVCD_StateInfo);

   virtual tVoid onRequestVideoSourceStateMResult(tBool bSourceChangeGranted);

private:
   /***************************************************************************
   * value of each received status
   ***************************************************************************/

   videomanager_fi_tcl_e8_vdmSourceState    _RVCA_StateInfo_RVCAStatus;
   videomanager_fi_tcl_e8_vdmSourceState    _RVCD_StateInfo_RVCDStatus;

   /***************************************************************************
   * Message map definition macro
   ***************************************************************************/

   DECLARE_MSG_MAP(dispvidctrl_tclClientVideomanager) 

// dispvidctrl_tclClientVideomanagerDeclarationsPart2: user specific code start
   I_dispvidctrl_tclVideoPlayer*      m_poClient_VideoPlayer;
   tBool m_bVideoManagerRVCAActive;
   tBool m_bVideoManagerRVCDActive;
   tBool m_bVideoManagerRVCASynchronized;
   tBool m_bVideoManagerRVCDSynchronized;
   tBool m_bVideoManagerIsAvailable;
// dispvidctrl_tclClientVideomanagerDeclarationsPart2: user specific code end

};

#endif // __dispvidctrl_ClientVideomanager_H_


