

/*****************************************************************************
* FILE:         dispvidctrl_ClientVideomanager.cpp
* PROJECT:      G3G project
* SW-COMPONENT: dispvidctrl
* Template:     ClientHandler.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2018 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

// dispvidctrl_tclClientVideomanagerIncludes: user specific code start
#include "dispvidctrl_datapool.h"
// dispvidctrl_tclClientVideomanagerIncludes: user specific code end

#include "dispvidctrl_ClientVideomanager.h"
#include "dispvidctrl_ClientVideomanagerCallbackIf.h"



#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DISPVIDCTRL_CLIENT_VIDEOMANAGER
#include "trcGenProj/Header/dispvidctrl_ClientVideomanager.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/
#define VIDEOMANAGER_SERVICE_ID              229
#define VIDEOMANAGER_FI_MAJOR_VERSION        1
#define VIDEOMANAGER_FI_MINOR_VERSION        0

/******************************************************************************/
/*                                                                            */
/* CCA MESSAGE MAP                                                            */
/*                                                                            */
/******************************************************************************/

BEGIN_MSG_MAP(dispvidctrl_tclClientVideomanager, ahl_tclBaseWork)
   ON_MESSAGE_SVCDATA(VIDEOMANAGER_MAINFI_C_U16_RVCA, AMT_C_U8_CCAMSG_OPCODE_STATUS, vHandleRVCAOpStatus)
   ON_MESSAGE_SVCDATA(VIDEOMANAGER_MAINFI_C_U16_RVCD, AMT_C_U8_CCAMSG_OPCODE_STATUS, vHandleRVCDOpStatus)
   ON_MESSAGE_SVCDATA(VIDEOMANAGER_MAINFI_C_U16_REQUESTVIDEOSOURCESTATE, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT, vHandleRequestVideoSourceStateOpMResult)
   // dispvidctrl_tclClientVideomanager_MsgMap: user specific code start
   // dispvidctrl_tclClientVideomanager_MsgMap: user specific code end
END_MSG_MAP()

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: dispvidctrl_tclClientVideomanager::
*             dispvidctrl_tclClientVideomanager(dispvidctrl_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
dispvidctrl_tclClientVideomanager::dispvidctrl_tclClientVideomanager(dispvidctrl_tclAppMain* poMainAppl) : 
Idispvidctrl_tclClientVideomanager(poMainAppl, VIDEOMANAGER_SERVICE_ID, VIDEOMANAGER_FI_MAJOR_VERSION, VIDEOMANAGER_FI_MINOR_VERSION )
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientVideomanager() entered."));
   _poCallbackIf = OSAL_NULL;
   
   // dispvidctrl_tclClientVideomanagerConstructor: user specific code start
   m_poClient_VideoPlayer = NULL;
   m_bVideoManagerRVCAActive = false;
   m_bVideoManagerRVCDActive = false;
   m_bVideoManagerRVCASynchronized = false;
   m_bVideoManagerRVCDSynchronized = false;
   m_bVideoManagerIsAvailable = false;
   // dispvidctrl_tclClientVideomanagerConstructor: user specific code end
   vAddAutoRegisterForProperty(VIDEOMANAGER_MAINFI_C_U16_RVCA);
   vAddAutoRegisterForProperty(VIDEOMANAGER_MAINFI_C_U16_RVCD);
}

/*******************************************************************************
*
* FUNCTION: dispvidctrl_tclClientVideomanager::
*             ~dispvidctrl_tclClientVideomanager(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
dispvidctrl_tclClientVideomanager::~dispvidctrl_tclClientVideomanager(tVoid)
{
   ETG_TRACE_USR4(("~dispvidctrl_tclClientVideomanager() entered."));
   _poCallbackIf = OSAL_NULL;

   // dispvidctrl_tclClientVideomanagerDestructor: user specific code start
   m_poClient_VideoPlayer = NULL;
   // dispvidctrl_tclClientVideomanagerDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientVideomanager::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'dispvidctrl_ClientVideomanager.h':
*     Add forward declaration:
*         class Idispvidctrl_tclObject2Get;
*
*     Add declaration of object reference:
*         Idispvidctrl_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Idispvidctrl_tclObject2Get*>(_cpoMain->getHandler("Idispvidctrl_tclObject2Get"));
*     VIDEOMANAGER_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientVideomanager::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientVideomanager::vGetReferences() entered."));
   
   // dispvidctrl_tclClientVideomanagervGetReferences: user specific code start
   // dispvidctrl_tclClientVideomanagervGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientVideomanager::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientVideomanager::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientVideomanager::vStartCommunication() entered."));
   // dispvidctrl_tclClientVideomanagervStartCommunication: user specific code start
   // dispvidctrl_tclClientVideomanagervStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientVideomanager::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   dispvidctrl_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientVideomanager::vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientVideomanager::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(dispvidctrl_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   // dispvidctrl_tclClientVideomanagervHandleMessage: user specific code start
   // dispvidctrl_tclClientVideomanagervHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientVideomanager::vHandleTraceMessage()
*
* DESCRIPTION: Handle trace message.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientVideomanager::vHandleTraceMessage(const tUChar* puchData)
{
   DISPVIDCTRL_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("dispvidctrl_tclClientVideomanager::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // dispvidctrl_tclClientVideomanagervHandleTraceMessage: user specific code start
   // dispvidctrl_tclClientVideomanagervHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientVideomanager::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientVideomanager::vTraceInfo()
{
   ETG_TRACE_FATAL(("Property support:      RVCA (VIDEOMANAGER_MAINFI_C_U16_RVCA) -> Opcode: UpReg, RelUpReg, Get, Set, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      RVCD (VIDEOMANAGER_MAINFI_C_U16_RVCD) -> Opcode: UpReg, RelUpReg, Get, Set, Status, Error, "));
   ETG_TRACE_FATAL(("Method   support:      RequestVideoSourceState (VIDEOMANAGER_MAINFI_C_U16_REQUESTVIDEOSOURCESTATE) -> Opcode: MethodStart, MethodResult, MethodAbort, Error, "));

   // dispvidctrl_tclClientVideomanagervTraceInfo: user specific code start
   // dispvidctrl_tclClientVideomanagervTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientVideomanager::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid dispvidctrl_tclClientVideomanager::vOnServiceAvailable()
{
   ETG_TRACE_USR4(("vOnServiceAvailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceAvailable();

   // dispvidctrl_tclClientVideomanagervOnServiceAvailable: user specific code start
   //Handle scenario where RVC is already active when videomanager starts

   m_bVideoManagerIsAvailable = true;

   tBool bVideoActive;
   tBool bRvcErrorVal;
   videomanager_fi_tcl_e8_vdmVideoSource oVideoSource;
   videomanager_fi_tcl_e8_vdmRequestedSourceState oSourceState;

   if(m_poClient_VideoPlayer != NULL) {
      m_poClient_VideoPlayer->vGetRvcState(bVideoActive, bRvcErrorVal);
      if(bVideoActive == true) {
         tU8 u8CameraConnectionType = m_poClient_VideoPlayer->u8GetCameraConnectionType();
         if(u8CameraConnectionType == DISPVIDCTRL_AllianceCameraConnectionType_LVDS) {
            ETG_TRACE_FATAL(("dispvidctrl_tclClientVideomanager::vOnServiceAvailable() sendRequestVideoSourceStateMStart to videomanager - LVDS active"));
            oVideoSource.enType = videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_RVCD;
            oSourceState.enType = videomanager_fi_tcl_e8_vdmRequestedSourceState::FI_EN_ACTIVE;
            sendRequestVideoSourceStateMStart(oVideoSource, oSourceState);
         }
         else {
            ETG_TRACE_FATAL(("dispvidctrl_tclClientVideomanager::vOnServiceAvailable() sendRequestVideoSourceStateMStart to videomanager - CVBS active"));
            oVideoSource.enType = videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_RVCA;
            oSourceState.enType = videomanager_fi_tcl_e8_vdmRequestedSourceState::FI_EN_ACTIVE;
            sendRequestVideoSourceStateMStart(oVideoSource, oSourceState);
         }
      }
   }
   else {
      ETG_TRACE_FATAL(("dispvidctrl_tclClientVideomanager::vOnServiceAvailable() ERROR - m_poClient_VideoPlayer is NULL"));
   }

   // dispvidctrl_tclClientVideomanagervOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientVideomanager::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid dispvidctrl_tclClientVideomanager::vOnServiceUnavailable()
{
   ETG_TRACE_USR4(("vOnServiceUnavailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceUnavailable();

   // dispvidctrl_tclClientVideomanagervOnServiceUnavailable: user specific code start
   // dispvidctrl_tclClientVideomanagervOnServiceUnavailable: user specific code end
}


/*******************************************************************************
* Handling of property VIDEOMANAGER_MAINFI_C_U16_RVCA
*******************************************************************************/

tVoid dispvidctrl_tclClientVideomanager::vHandleRVCAOpStatus(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         videomanager_mainfi_tclMsgRVCAStatus  oStatus;

         if (oInMsg.s32GetData(oStatus, VIDEOMANAGER_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _RVCA_StateInfo_RVCAStatus = oStatus.RVCA_StateInfo;

            ETG_TRACE_USR1(("dispvidctrl_tclClientVideomanager::vHandleRVCAOpStatus(): Status update message received for 'VIDEOMANAGER_MAINFI_C_U16_RVCA' (FID: 0x0001)!"));

            onRVCAStatus(oStatus.RVCA_StateInfo);

            // vHandleRVCAOpStatus: user specific code start
            ETG_TRACE_FATAL(("dispvidctrl_tclClientVideomanager::vHandleRVCAOpStatus(): Status changed to %d", _RVCA_StateInfo_RVCAStatus.enType));

            switch(_RVCA_StateInfo_RVCAStatus.enType)
            {
                case videomanager_fi_tcl_e8_vdmSourceState::FI_EN_UNKNOWN:
                {
                    //Ignored
                    break;
                }
                case videomanager_fi_tcl_e8_vdmSourceState::FI_EN_INACTIVE:
                {
                    //RVCA Source is deactivated
                    m_bVideoManagerRVCAActive = false;
                    ETG_TRACE_FATAL(("dispvidctrl_tclClientVideomanager::vHandleRVCAOpStatus(): Status is now INACTIVE"));
                    break;
                }
                case videomanager_fi_tcl_e8_vdmSourceState::FI_EN_ACTIVATING:
                {
                    //Ignored
                    break;
                }
                case videomanager_fi_tcl_e8_vdmSourceState::FI_EN_ACTIVE:
                {
                    //RVCA Source is active - VideoManager has said it is ok to proceed
                    m_bVideoManagerRVCAActive = true;
                    ETG_TRACE_FATAL(("dispvidctrl_tclClientVideomanager::vHandleRVCAOpStatus(): Status is now ACTIVE"));
				    if(m_bVideoManagerRVCASynchronized == TRUE) {
                        //If already synchronized then set pipeline objects and start RVC playing
                        if(m_poClient_VideoPlayer) {
                            //it is necessary to set all the pipeline parameters in case they have been reset by another device, e.g Digital TV
                            m_poClient_VideoPlayer->vSetAllRvcObjects();
                            m_poClient_VideoPlayer->vStartRVCPlaying();
                        }
                    }
                    break;
                }
                case videomanager_fi_tcl_e8_vdmSourceState::FI_EN_BLOCKED:
                {
                    //Ignored
                    break;
                }
                case videomanager_fi_tcl_e8_vdmSourceState::FI_EN_RESTRICTED:
                {
                    //Ignored
                    break;
                }
                default:
                {
                    break;
                }
            }

            m_bVideoManagerRVCASynchronized = TRUE;

            // vHandleRVCAOpStatus: user specific code end
         } else {
            ETG_TRACE_ERR(("dispvidctrl_tclClientVideomanager::vHandleRVCAOpStatus: Received message is invalid!"));
         }

         oStatus.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclClientVideomanager::onRVCAStatus(videomanager_fi_tcl_e8_vdmSourceState RVCA_StateInfo) {

   if (_poCallbackIf) _poCallbackIf->onRVCAStatus(RVCA_StateInfo); 

   // onRVCAStatus: user specific code start
   // onRVCAStatus: user specific code end

}

/*******************************************************************************
* Handling of property VIDEOMANAGER_MAINFI_C_U16_RVCD
*******************************************************************************/

tVoid dispvidctrl_tclClientVideomanager::vHandleRVCDOpStatus(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         videomanager_mainfi_tclMsgRVCDStatus  oStatus;

         if (oInMsg.s32GetData(oStatus, VIDEOMANAGER_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _RVCD_StateInfo_RVCDStatus = oStatus.RVCD_StateInfo;

            ETG_TRACE_USR1(("dispvidctrl_tclClientVideomanager::vHandleRVCDOpStatus(): Status update message received for 'VIDEOMANAGER_MAINFI_C_U16_RVCD' (FID: 0x0002)!"));

            onRVCDStatus(oStatus.RVCD_StateInfo);

            // vHandleRVCDOpStatus: user specific code start
            ETG_TRACE_FATAL(("dispvidctrl_tclClientVideomanager::vHandleRVCDOpStatus(): Status changed to %d", _RVCD_StateInfo_RVCDStatus.enType));

            switch(_RVCD_StateInfo_RVCDStatus.enType)
            {
                case videomanager_fi_tcl_e8_vdmSourceState::FI_EN_UNKNOWN:
                {
                    //Ignored
                    break;
                }
                case videomanager_fi_tcl_e8_vdmSourceState::FI_EN_INACTIVE:
                {
                    //RVCA Source is deactivated
                    m_bVideoManagerRVCAActive = false;
                    if (m_poClient_VideoPlayer) {
                        //it is necessary to set all the pipeline parameters in case they have been reset by another device, e.g Digital TV
                        m_poClient_VideoPlayer->vSetAllRvcObjects();
                        m_poClient_VideoPlayer->vActivateRvc(0);
                    }
                    ETG_TRACE_FATAL(("dispvidctrl_tclClientVideomanager::vHandleRVCDOpStatus(): Status is now INACTIVE"));
                    break;
                }
                case videomanager_fi_tcl_e8_vdmSourceState::FI_EN_ACTIVATING:
                {
                    //Ignored
                    break;
                }
                case videomanager_fi_tcl_e8_vdmSourceState::FI_EN_ACTIVE:
                {
                    //RVCD Source is active - VideoManager has said it is ok to proceed
                    m_bVideoManagerRVCDActive = true;
                    ETG_TRACE_FATAL(("dispvidctrl_tclClientVideomanager::vHandleRVCDOpStatus(): Status is now ACTIVE"));
				    if(m_bVideoManagerRVCDSynchronized == TRUE) {
                        //If already synchronized then set pipeline objects and start RVC playing
                        if(m_poClient_VideoPlayer) {
                            //it is necessary to set all the pipeline parameters in case they have been reset by another device, e.g Digital TV
                            m_poClient_VideoPlayer->vSetAllRvcObjects();
                            m_poClient_VideoPlayer->vActivateRvc(1);
                        }
                    }
                    break;
                }
                case videomanager_fi_tcl_e8_vdmSourceState::FI_EN_BLOCKED:
                {
                    //Ignored
                    break;
                }
                case videomanager_fi_tcl_e8_vdmSourceState::FI_EN_RESTRICTED:
                {
                    //Ignored
                    break;
                }
                default:
                {
                    break;
                }
            }

            m_bVideoManagerRVCDSynchronized = TRUE;
            // vHandleRVCDOpStatus: user specific code end
         } else {
            ETG_TRACE_ERR(("dispvidctrl_tclClientVideomanager::vHandleRVCDOpStatus: Received message is invalid!"));
         }

         oStatus.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclClientVideomanager::onRVCDStatus(videomanager_fi_tcl_e8_vdmSourceState RVCD_StateInfo) {

   if (_poCallbackIf) _poCallbackIf->onRVCDStatus(RVCD_StateInfo); 

   // onRVCDStatus: user specific code start
   // onRVCDStatus: user specific code end

}



/*******************************************************************************
* Handling of property VIDEOMANAGER_MAINFI_C_U16_REQUESTVIDEOSOURCESTATE
*******************************************************************************/

tVoid dispvidctrl_tclClientVideomanager::vHandleRequestVideoSourceStateOpMResult(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODRESULT ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         videomanager_mainfi_tclMsgRequestVideoSourceStateMethodResult  oMResult;

         if (oInMsg.s32GetData(oMResult, VIDEOMANAGER_FI_MAJOR_VERSION) != OSAL_ERROR) {
            ETG_TRACE_USR1(("dispvidctrl_tclClientVideomanager::vHandleRequestVideoSourceStateOpMResult(): Method result update message received for 'VIDEOMANAGER_MAINFI_C_U16_REQUESTVIDEOSOURCESTATE' (FID: 0x1001)!"));

            onRequestVideoSourceStateMResult(oMResult.bSourceChangeGranted);

            // vHandleRequestVideoSourceStateOpMResult: user specific code start
            // vHandleRequestVideoSourceStateOpMResult: user specific code end
         } else {
            ETG_TRACE_ERR(("dispvidctrl_tclClientVideomanager::vHandleRequestVideoSourceStateOpMResult: Received message is invalid!"));
         }

         oMResult.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclClientVideomanager::onRequestVideoSourceStateMResult(tBool bSourceChangeGranted) {

   if (_poCallbackIf) _poCallbackIf->onRequestVideoSourceStateMResult(bSourceChangeGranted); 

   // onRequestVideoSourceStateMResult: user specific code start
   // onRequestVideoSourceStateMResult: user specific code end

}



tBool dispvidctrl_tclClientVideomanager::sendRVCASet() {
   tBool bRetVal = FALSE;
   if (u16GetRegID() != AMT_C_U16_REGID_INVALID) {
      videomanager_mainfi_tclMsgRVCASet  oSet;
      //the data content


      fi_tclVisitorMessage oOutMessage(oSet);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, (tU16) 0, (tU16) VIDEOMANAGER_MAINFI_C_U16_RVCA, (tU8) AMT_C_U8_CCAMSG_OPCODE_SET);
      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "dispvidctrl_tclClientVideomanager::sendRVCASet(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VIDEOMANAGER_MAINFI_C_U16_RVCA, (tU32)enResult));
      } else {
         bRetVal = TRUE;
      }

      // Always destroy the FI data object before leaving its creation scope
      oSet.vDestroy();
   }
   return bRetVal;
}
tBool dispvidctrl_tclClientVideomanager::sendRVCDSet() {
   tBool bRetVal = FALSE;
   if (u16GetRegID() != AMT_C_U16_REGID_INVALID) {
      videomanager_mainfi_tclMsgRVCDSet  oSet;
      //the data content


      fi_tclVisitorMessage oOutMessage(oSet);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, (tU16) 0, (tU16) VIDEOMANAGER_MAINFI_C_U16_RVCD, (tU8) AMT_C_U8_CCAMSG_OPCODE_SET);
      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "dispvidctrl_tclClientVideomanager::sendRVCDSet(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VIDEOMANAGER_MAINFI_C_U16_RVCD, (tU32)enResult));
      } else {
         bRetVal = TRUE;
      }

      // Always destroy the FI data object before leaving its creation scope
      oSet.vDestroy();
   }
   return bRetVal;
}

tBool dispvidctrl_tclClientVideomanager::sendRVCAGet() {
   tBool bRetVal = FALSE;
   if (u16GetRegID() != AMT_C_U16_REGID_INVALID) {
      videomanager_mainfi_tclMsgRVCAGet  oGet;
      //the data content


      fi_tclVisitorMessage oOutMessage(oGet);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, (tU16) 0, (tU16) VIDEOMANAGER_MAINFI_C_U16_RVCA, (tU8) AMT_C_U8_CCAMSG_OPCODE_GET);
      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "dispvidctrl_tclClientVideomanager::sendRVCAGet(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VIDEOMANAGER_MAINFI_C_U16_RVCA, (tU32)enResult));
      } else {
         bRetVal = TRUE;
      }

      // Always destroy the FI data object before leaving its creation scope
      oGet.vDestroy();
   }
   return bRetVal;
}
tBool dispvidctrl_tclClientVideomanager::sendRVCDGet() {
   tBool bRetVal = FALSE;
   if (u16GetRegID() != AMT_C_U16_REGID_INVALID) {
      videomanager_mainfi_tclMsgRVCDGet  oGet;
      //the data content


      fi_tclVisitorMessage oOutMessage(oGet);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, (tU16) 0, (tU16) VIDEOMANAGER_MAINFI_C_U16_RVCD, (tU8) AMT_C_U8_CCAMSG_OPCODE_GET);
      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "dispvidctrl_tclClientVideomanager::sendRVCDGet(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VIDEOMANAGER_MAINFI_C_U16_RVCD, (tU32)enResult));
      } else {
         bRetVal = TRUE;
      }

      // Always destroy the FI data object before leaving its creation scope
      oGet.vDestroy();
   }
   return bRetVal;
}

tBool dispvidctrl_tclClientVideomanager::sendRequestVideoSourceStateMStart(videomanager_fi_tcl_e8_vdmVideoSource tVideoSource, videomanager_fi_tcl_e8_vdmRequestedSourceState tRequestedState) {
   tBool bRetVal = FALSE;
   if (u16GetRegID() != AMT_C_U16_REGID_INVALID) {
      videomanager_mainfi_tclMsgRequestVideoSourceStateMethodStart  oMStart;
      //the data content
      oMStart.tVideoSource = tVideoSource;
      oMStart.tRequestedState = tRequestedState;


      fi_tclVisitorMessage oOutMessage(oMStart);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, (tU16) 0, (tU16) VIDEOMANAGER_MAINFI_C_U16_REQUESTVIDEOSOURCESTATE, (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODSTART);
      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "dispvidctrl_tclClientVideomanager::sendRequestVideoSourceStateMStart(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VIDEOMANAGER_MAINFI_C_U16_REQUESTVIDEOSOURCESTATE, (tU32)enResult));
      } else {
         bRetVal = TRUE;
      }

      // Always destroy the FI data object before leaving its creation scope
      oMStart.vDestroy();
   }
   return bRetVal;
}

// dispvidctrl_tclClientVideomanagerdispvidctrl_ClientVideomanager: user specific code start
tVoid dispvidctrl_tclClientVideomanager::vSetRVCStateActive() {
   videomanager_fi_tcl_e8_vdmVideoSource oVideoSource;
   videomanager_fi_tcl_e8_vdmRequestedSourceState oSourceState;

   if(m_poClient_VideoPlayer != 0) {
      tU8 u8CameraConnectionType = m_poClient_VideoPlayer->u8GetCameraConnectionType();
      if(u8CameraConnectionType == DISPVIDCTRL_AllianceCameraConnectionType_LVDS) {
         ETG_TRACE_FATAL(("dispvidctrl_tclClientVideomanager::vSetRVCStateActive() sendRequestVideoSourceStateMStart to videomanager - LVDS active"));
         oVideoSource.enType = videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_RVCD;
         oSourceState.enType = videomanager_fi_tcl_e8_vdmRequestedSourceState::FI_EN_ACTIVE;
         sendRequestVideoSourceStateMStart(oVideoSource, oSourceState);
      }
      else {
         ETG_TRACE_FATAL(("dispvidctrl_tclClientVideomanager::vSetRVCStateActive() sendRequestVideoSourceStateMStart to videomanager - CVBS active"));
         oVideoSource.enType = videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_RVCA;
         oSourceState.enType = videomanager_fi_tcl_e8_vdmRequestedSourceState::FI_EN_ACTIVE;
         sendRequestVideoSourceStateMStart(oVideoSource, oSourceState);
      }
   }
   else {
      ETG_TRACE_FATAL(("dispvidctrl_tclClientVideomanager::vSetRVCStateActive() ERROR - m_poClient_VideoPlayer is NULL"));
   }
}

tVoid dispvidctrl_tclClientVideomanager::vSetRVCStateInactive() {
   videomanager_fi_tcl_e8_vdmVideoSource oVideoSource;
   videomanager_fi_tcl_e8_vdmRequestedSourceState oSourceState;

   if(m_poClient_VideoPlayer != 0) {
      tU8 u8CameraConnectionType = m_poClient_VideoPlayer->u8GetCameraConnectionType();
      if(u8CameraConnectionType == DISPVIDCTRL_AllianceCameraConnectionType_LVDS) {
         ETG_TRACE_FATAL(("dispvidctrl_tclClientVideomanager::vSetRVCStateInactive() sendRequestVideoSourceStateMStart to videomanager - LVDS inactive"));
         oVideoSource.enType = videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_RVCD;
         oSourceState.enType = videomanager_fi_tcl_e8_vdmRequestedSourceState::FI_EN_INACTIVE;
         sendRequestVideoSourceStateMStart(oVideoSource, oSourceState);
      }
      else {
         ETG_TRACE_FATAL(("dispvidctrl_tclClientVideomanager::vSetRVCStateInactive() sendRequestVideoSourceStateMStart to videomanager - CVBS inactive"));
         oVideoSource.enType = videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_RVCA;
         oSourceState.enType = videomanager_fi_tcl_e8_vdmRequestedSourceState::FI_EN_INACTIVE;
         sendRequestVideoSourceStateMStart(oVideoSource, oSourceState);
      }
   }
   else {
      ETG_TRACE_FATAL(("dispvidctrl_tclClientVideomanager::vSetRVCStateInactive() ERROR - m_poClient_VideoPlayer is NULL"));
   }
}

tVoid dispvidctrl_tclClientVideomanager::vGetReferencesEarly(tVoid)
{
   ETG_TRACE_FATAL(("dispvidctrl_tclClientVideomanager::vGetReferencesEarly() entered."));

   m_poClient_VideoPlayer = dynamic_cast<I_dispvidctrl_tclVideoPlayer*>(_cpoMain->getHandler("I_dispvidctrl_tclVideoPlayer"));
   //DISPVIDCTRL_NULL_POINTER_CHECK(m_poClient_VideoPlayer);
   if(m_poClient_VideoPlayer == 0) {
      ETG_TRACE_FATAL(("dispvidctrl_tclClientVideomanager::vGetReferences() ERROR - m_poClient_VideoPlayer is NULL"));
   }
}
// dispvidctrl_tclClientVideomanagerdispvidctrl_ClientVideomanager: user specific code end

//EOF
