/*****************************************************************************
* FILE:         dispvidctrl_ClientVehicledata.h
* PROJECT:      G3G project
* SW-COMPONENT: dispvidctrl
* Template:     ClientHandler.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2019 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#ifndef __dispvidctrl_ClientVehicledata_H_
#define __dispvidctrl_ClientVehicledata_H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

//include base class
#include "Idispvidctrl_ClientVehicledata.h"
#include "dispvidctrl_AppMain.h"

// dispvidctrl_tclClientVehicledata_Include: user specific code start
// dispvidctrl_tclClientVehicledata_Include: user specific code end

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class dispvidctrl_tclClientVehicledataCallbackIF;

class ahl_tclBaseOneThreadClientHandler;

class dispvidctrl_tclClientVehicledata : public Idispvidctrl_tclClientVehicledata
{

public:
   virtual const tChar* getName() const { return "dispvidctrl_tclClientVehicledata"; };
   
   virtual tVoid vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();

   dispvidctrl_tclClientVehicledata(tVoid); 
   dispvidctrl_tclClientVehicledata(dispvidctrl_tclAppMain* poMainAppl);
   virtual ~dispvidctrl_tclClientVehicledata();

   virtual tVoid vSetCallbackIf(dispvidctrl_tclClientVehicledataCallbackIF* poCallback) {
      _poCallbackIf = poCallback;
   }

   // dispvidctrl_tclClientVehicledataDeclarations: user specific code start
   // dispvidctrl_tclClientVehicledataDeclarations: user specific code end

   /**************************************************************************
   * Assingment Operater, will not be implemented.
   * Avoids Lint Prio 3 warning: Info 1732: new in constructor for class 
   * 'dispvidctrl_tclClientVehicledata' which has no assignment operator.
   * NOTE: This is a technique to disable the assignment operator for this
   * class. So if an attempt for the assignment is made compiler complains.
   **************************************************************************/
   dispvidctrl_tclClientVehicledata& operator = (const dispvidctrl_tclClientVehicledata &oClientHandler);

   /***************************************************************************
   * Overriding ahl_tclBaseOneThreadClientHandler methods.
   ***************************************************************************/
   virtual tVoid vOnServiceAvailable();
   virtual tVoid vOnServiceUnavailable();
   
private:
   dispvidctrl_tclClientVehicledataCallbackIF* _poCallbackIf;

public:

   /***************************************************************************
   * all public methods to send / getCurrentState.
   ***************************************************************************/


   virtual tBool sendReverseGearGet();
   virtual tVoid getReverseGearStatus(tU8& rState) {
      rState                = _State_ReverseGearStatus;
   }

   virtual tBool sendCamTxtGet();
   virtual tVoid getCamTxtStatus(tU64& rCamTxtValue) {
      rCamTxtValue          = _CamTxtValue_CamTxtStatus;
   }


private:
   /***************************************************************************
   * handling of incomming messages
   ***************************************************************************/
   virtual tVoid vHandleReverseGearOpStatus(amt_tclServiceData* poMessage);
   virtual tVoid vHandleCamTxtOpStatus(amt_tclServiceData* poMessage);


   virtual tVoid onReverseGearStatus(tU8 State);
   virtual tVoid onCamTxtStatus(tU64 CamTxtValue);


private:
   /***************************************************************************
   * value of each received status
   ***************************************************************************/

   tU8                                      _State_ReverseGearStatus;
   tU64                                     _CamTxtValue_CamTxtStatus;

   /***************************************************************************
   * Message map definition macro
   ***************************************************************************/

   DECLARE_MSG_MAP(dispvidctrl_tclClientVehicledata) 

// dispvidctrl_tclClientVehicledataDeclarationsPart2: user specific code start
// dispvidctrl_tclClientVehicledataDeclarationsPart2: user specific code end

};

#endif // __dispvidctrl_ClientVehicledata_H_


