#ifndef __spm_core_fi_CALLBACKIF_H_
#define __spm_core_fi_CALLBACKIF_H_

/**
  * @swcomponent   Life Cycle Management
  * @{
  * @file          dispvidctrl_ClientSpmCallbackIf.h
  * @PROJECT:      CMD project
  * @SW-COMPONENT: dispvidctrl
  * @Template:     ClientCallbackIf.h.tpl
  * ----------------------------------------------------------------------------
  *
  * @brief         client callback interface
  *
  *                Generated file
  *                DO NOT CHANGE !!!!
  *               
  *                If necessary --> Changes possible only inside tags
  *
  *                //......................: user specific code start 
  *                //......................: user specific code end 
  *
  * ----------------------------------------------------------------------------
  * @copyright     (C) 2018 Robert Bosch GmbH.
  *                The reproduction, distribution and utilization of this file as well as the
  *                communication of its contents to others without express authorization is prohibited.
  *                Offenders will be held liable for the payment of damages.
  *                All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

class dispvidctrl_tclClientSpmCallbackIF
{
   public:
       virtual ~dispvidctrl_tclClientSpmCallbackIF() {};

       virtual tVoid onServiceAvailable() = 0;
       virtual tVoid onServiceUnavailable() = 0;

       virtual tVoid onActiveOnOffTriggerStatus(std::vector<spm_fi_tcl_SPM_e32_SubStateType, std::allocator<spm_fi_tcl_SPM_e32_SubStateType> > tOnOffTriggerList) = 0;
       virtual tVoid onSysPwrModeStatus(spm_fi_tcl_SPM_e32_SYSPWRMODE SysPwrMode) = 0;
       virtual tVoid onCvmEventStatus(spm_fi_tcl_SPM_e32_CVM_EVENT CvmEvent) = 0;
       virtual tVoid onHmiStateStatus(spm_fi_tcl_SPM_e32_HMI_STATE HmiState) = 0;
       virtual tVoid onDimmingStateStatus(spm_fi_tcl_SPM_b32_DIM_STATE DimState) = 0;

       virtual tVoid onOnOffTriggerMResult() = 0;
};

#endif //__spm_core_fi_CALLBACKIF_H_


