

/*****************************************************************************
* FILE:         dispvidctrl_ClientSpm.cpp
* PROJECT:      G3G project
* SW-COMPONENT: dispvidctrl
* Template:     ClientHandler.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2018 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

// dispvidctrl_tclClientSpmIncludes: user specific code start
// dispvidctrl_tclClientSpmIncludes: user specific code end

#include "dispvidctrl_ClientSpm.h"
#include "dispvidctrl_ClientSpmCallbackIf.h"



#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DISPVIDCTRL_CLIENT_SPM
#include "trcGenProj/Header/dispvidctrl_ClientSpm.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/
#define SPM_SERVICE_ID              256
#define SPM_FI_MAJOR_VERSION        1
#define SPM_FI_MINOR_VERSION        3

/******************************************************************************/
/*                                                                            */
/* CCA MESSAGE MAP                                                            */
/*                                                                            */
/******************************************************************************/

BEGIN_MSG_MAP(dispvidctrl_tclClientSpm, ahl_tclBaseWork)
   ON_MESSAGE_SVCDATA(SPM_COREFI_C_U16_ACTIVEONOFFTRIGGER, AMT_C_U8_CCAMSG_OPCODE_STATUS, vHandleActiveOnOffTriggerOpStatus)
   ON_MESSAGE_SVCDATA(SPM_COREFI_C_U16_SYSPWRMODE, AMT_C_U8_CCAMSG_OPCODE_STATUS, vHandleSysPwrModeOpStatus)
   ON_MESSAGE_SVCDATA(SPM_COREFI_C_U16_CVMEVENT, AMT_C_U8_CCAMSG_OPCODE_STATUS, vHandleCvmEventOpStatus)
   ON_MESSAGE_SVCDATA(SPM_COREFI_C_U16_HMISTATE, AMT_C_U8_CCAMSG_OPCODE_STATUS, vHandleHmiStateOpStatus)
   ON_MESSAGE_SVCDATA(SPM_COREFI_C_U16_DIMMINGSTATE, AMT_C_U8_CCAMSG_OPCODE_STATUS, vHandleDimmingStateOpStatus)
   ON_MESSAGE_SVCDATA(SPM_COREFI_C_U16_ONOFFTRIGGER, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT, vHandleOnOffTriggerOpMResult)
   // dispvidctrl_tclClientSpm_MsgMap: user specific code start
   // dispvidctrl_tclClientSpm_MsgMap: user specific code end
END_MSG_MAP()

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: dispvidctrl_tclClientSpm::
*             dispvidctrl_tclClientSpm(dispvidctrl_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
dispvidctrl_tclClientSpm::dispvidctrl_tclClientSpm(dispvidctrl_tclAppMain* poMainAppl) : 
Idispvidctrl_tclClientSpm(poMainAppl, SPM_SERVICE_ID, SPM_FI_MAJOR_VERSION, SPM_FI_MINOR_VERSION )
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientSpm() entered."));
   _poCallbackIf = OSAL_NULL;
   
   // dispvidctrl_tclClientSpmConstructor: user specific code start
   _CvmEvent_CvmEventStatus.enType = spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_NO_EVENT;
   // dispvidctrl_tclClientSpmConstructor: user specific code end
   vAddAutoRegisterForProperty(SPM_COREFI_C_U16_ACTIVEONOFFTRIGGER);
   vAddAutoRegisterForProperty(SPM_COREFI_C_U16_SYSPWRMODE);
   vAddAutoRegisterForProperty(SPM_COREFI_C_U16_CVMEVENT);
   vAddAutoRegisterForProperty(SPM_COREFI_C_U16_HMISTATE);
   vAddAutoRegisterForProperty(SPM_COREFI_C_U16_DIMMINGSTATE);
}

/*******************************************************************************
*
* FUNCTION: dispvidctrl_tclClientSpm::
*             ~dispvidctrl_tclClientSpm(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
dispvidctrl_tclClientSpm::~dispvidctrl_tclClientSpm(tVoid)
{
   ETG_TRACE_USR4(("~dispvidctrl_tclClientSpm() entered."));
   _poCallbackIf = OSAL_NULL;

   // dispvidctrl_tclClientSpmDestructor: user specific code start
   // dispvidctrl_tclClientSpmDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientSpm::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'dispvidctrl_ClientSpm.h':
*     Add forward declaration:
*         class Idispvidctrl_tclObject2Get;
*
*     Add declaration of object reference:
*         Idispvidctrl_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Idispvidctrl_tclObject2Get*>(_cpoMain->getHandler("Idispvidctrl_tclObject2Get"));
*     SPM_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientSpm::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientSpm::vGetReferences() entered."));
   
   // dispvidctrl_tclClientSpmvGetReferences: user specific code start
   // dispvidctrl_tclClientSpmvGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientSpm::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientSpm::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientSpm::vStartCommunication() entered."));
   // dispvidctrl_tclClientSpmvStartCommunication: user specific code start
   // dispvidctrl_tclClientSpmvStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientSpm::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   dispvidctrl_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientSpm::vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientSpm::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(dispvidctrl_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   // dispvidctrl_tclClientSpmvHandleMessage: user specific code start
   // dispvidctrl_tclClientSpmvHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientSpm::vHandleTraceMessage()
*
* DESCRIPTION: Handle trace message.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientSpm::vHandleTraceMessage(const tUChar* puchData)
{
   DISPVIDCTRL_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("dispvidctrl_tclClientSpm::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // dispvidctrl_tclClientSpmvHandleTraceMessage: user specific code start
   // dispvidctrl_tclClientSpmvHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientSpm::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientSpm::vTraceInfo()
{
   ETG_TRACE_FATAL(("Property support:      ActiveOnOffTrigger (SPM_COREFI_C_U16_ACTIVEONOFFTRIGGER) -> Opcode: Status, UpReg, RelUpReg, Get, Error, "));
   ETG_TRACE_FATAL(("Property support:      SysPwrMode (SPM_COREFI_C_U16_SYSPWRMODE) -> Opcode: Status, UpReg, RelUpReg, Get, Error, "));
   ETG_TRACE_FATAL(("Property support:      CvmEvent (SPM_COREFI_C_U16_CVMEVENT) -> Opcode: Status, UpReg, RelUpReg, Get, Error, "));
   ETG_TRACE_FATAL(("Property support:      HmiState (SPM_COREFI_C_U16_HMISTATE) -> Opcode: Status, UpReg, RelUpReg, Get, Error, "));
   ETG_TRACE_FATAL(("Property support:      DimmingState (SPM_COREFI_C_U16_DIMMINGSTATE) -> Opcode: Status, UpReg, RelUpReg, Get, Error, "));
   ETG_TRACE_FATAL(("Method   support:      OnOffTrigger (SPM_COREFI_C_U16_ONOFFTRIGGER) -> Opcode: MethodStart, MethodResult, Error, "));

   // dispvidctrl_tclClientSpmvTraceInfo: user specific code start
   // dispvidctrl_tclClientSpmvTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientSpm::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid dispvidctrl_tclClientSpm::vOnServiceAvailable()
{
   ETG_TRACE_USR4(("vOnServiceAvailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceAvailable();

   // dispvidctrl_tclClientSpmvOnServiceAvailable: user specific code start
   // dispvidctrl_tclClientSpmvOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientSpm::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid dispvidctrl_tclClientSpm::vOnServiceUnavailable()
{
   ETG_TRACE_USR4(("vOnServiceUnavailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceUnavailable();

   // dispvidctrl_tclClientSpmvOnServiceUnavailable: user specific code start
   // dispvidctrl_tclClientSpmvOnServiceUnavailable: user specific code end
}


/*******************************************************************************
* Handling of property SPM_COREFI_C_U16_ACTIVEONOFFTRIGGER
*******************************************************************************/

tVoid dispvidctrl_tclClientSpm::vHandleActiveOnOffTriggerOpStatus(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         spm_corefi_tclMsgActiveOnOffTriggerStatus  oStatus;

         if (oInMsg.s32GetData(oStatus, SPM_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tOnOffTriggerList_ActiveOnOffTriggerStatus = oStatus.tOnOffTriggerList;

            ETG_TRACE_USR1(("dispvidctrl_tclClientSpm::vHandleActiveOnOffTriggerOpStatus(): Status update message received for 'SPM_COREFI_C_U16_ACTIVEONOFFTRIGGER' (FID: 0x110f)!"));

            onActiveOnOffTriggerStatus(oStatus.tOnOffTriggerList);

            // vHandleActiveOnOffTriggerOpStatus: user specific code start
            // vHandleActiveOnOffTriggerOpStatus: user specific code end
         } else {
            ETG_TRACE_ERR(("dispvidctrl_tclClientSpm::vHandleActiveOnOffTriggerOpStatus: Received message is invalid!"));
         }

         oStatus.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclClientSpm::onActiveOnOffTriggerStatus(std::vector<spm_fi_tcl_SPM_e32_SubStateType, std::allocator<spm_fi_tcl_SPM_e32_SubStateType> > tOnOffTriggerList) {

   if (_poCallbackIf) _poCallbackIf->onActiveOnOffTriggerStatus(tOnOffTriggerList); 

   // onActiveOnOffTriggerStatus: user specific code start
   // onActiveOnOffTriggerStatus: user specific code end

}

/*******************************************************************************
* Handling of property SPM_COREFI_C_U16_SYSPWRMODE
*******************************************************************************/

tVoid dispvidctrl_tclClientSpm::vHandleSysPwrModeOpStatus(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         spm_corefi_tclMsgSysPwrModeStatus  oStatus;

         if (oInMsg.s32GetData(oStatus, SPM_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _SysPwrMode_SysPwrModeStatus = oStatus.SysPwrMode;

            ETG_TRACE_USR1(("dispvidctrl_tclClientSpm::vHandleSysPwrModeOpStatus(): Status update message received for 'SPM_COREFI_C_U16_SYSPWRMODE' (FID: 0x0204)!"));

            onSysPwrModeStatus(oStatus.SysPwrMode);

            // vHandleSysPwrModeOpStatus: user specific code start
            // vHandleSysPwrModeOpStatus: user specific code end
         } else {
            ETG_TRACE_ERR(("dispvidctrl_tclClientSpm::vHandleSysPwrModeOpStatus: Received message is invalid!"));
         }

         oStatus.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclClientSpm::onSysPwrModeStatus(spm_fi_tcl_SPM_e32_SYSPWRMODE SysPwrMode) {

   if (_poCallbackIf) _poCallbackIf->onSysPwrModeStatus(SysPwrMode); 

   // onSysPwrModeStatus: user specific code start
   // onSysPwrModeStatus: user specific code end

}

/*******************************************************************************
* Handling of property SPM_COREFI_C_U16_CVMEVENT
*******************************************************************************/

tVoid dispvidctrl_tclClientSpm::vHandleCvmEventOpStatus(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         spm_corefi_tclMsgCvmEventStatus  oStatus;

         if (oInMsg.s32GetData(oStatus, SPM_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _CvmEvent_CvmEventStatus = oStatus.CvmEvent;

            ETG_TRACE_USR1(("dispvidctrl_tclClientSpm::vHandleCvmEventOpStatus(): Status update message received for 'SPM_COREFI_C_U16_CVMEVENT' (FID: 0x38)!"));

            onCvmEventStatus(oStatus.CvmEvent);

            // vHandleCvmEventOpStatus: user specific code start
            // vHandleCvmEventOpStatus: user specific code end
         } else {
            ETG_TRACE_ERR(("dispvidctrl_tclClientSpm::vHandleCvmEventOpStatus: Received message is invalid!"));
         }

         oStatus.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclClientSpm::onCvmEventStatus(spm_fi_tcl_SPM_e32_CVM_EVENT CvmEvent) {

   if (_poCallbackIf) _poCallbackIf->onCvmEventStatus(CvmEvent); 

   // onCvmEventStatus: user specific code start
   // onCvmEventStatus: user specific code end

}

/*******************************************************************************
* Handling of property SPM_COREFI_C_U16_HMISTATE
*******************************************************************************/

tVoid dispvidctrl_tclClientSpm::vHandleHmiStateOpStatus(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         spm_corefi_tclMsgHmiStateStatus  oStatus;

         if (oInMsg.s32GetData(oStatus, SPM_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _HmiState_HmiStateStatus = oStatus.HmiState;

            ETG_TRACE_USR1(("dispvidctrl_tclClientSpm::vHandleHmiStateOpStatus(): Status update message received for 'SPM_COREFI_C_U16_HMISTATE' (FID: 0x10)!"));

            onHmiStateStatus(oStatus.HmiState);

            // vHandleHmiStateOpStatus: user specific code start
            // vHandleHmiStateOpStatus: user specific code end
         } else {
            ETG_TRACE_ERR(("dispvidctrl_tclClientSpm::vHandleHmiStateOpStatus: Received message is invalid!"));
         }

         oStatus.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclClientSpm::onHmiStateStatus(spm_fi_tcl_SPM_e32_HMI_STATE HmiState) {

   if (_poCallbackIf) _poCallbackIf->onHmiStateStatus(HmiState); 

   // onHmiStateStatus: user specific code start
   // onHmiStateStatus: user specific code end

}

/*******************************************************************************
* Handling of property SPM_COREFI_C_U16_DIMMINGSTATE
*******************************************************************************/

tVoid dispvidctrl_tclClientSpm::vHandleDimmingStateOpStatus(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         spm_corefi_tclMsgDimmingStateStatus  oStatus;

         if (oInMsg.s32GetData(oStatus, SPM_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _DimState_DimmingStateStatus = oStatus.DimState;

            ETG_TRACE_USR1(("dispvidctrl_tclClientSpm::vHandleDimmingStateOpStatus(): Status update message received for 'SPM_COREFI_C_U16_DIMMINGSTATE' (FID: 0x1011)!"));

            onDimmingStateStatus(oStatus.DimState);

            // vHandleDimmingStateOpStatus: user specific code start
            // vHandleDimmingStateOpStatus: user specific code end
         } else {
            ETG_TRACE_ERR(("dispvidctrl_tclClientSpm::vHandleDimmingStateOpStatus: Received message is invalid!"));
         }

         oStatus.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclClientSpm::onDimmingStateStatus(spm_fi_tcl_SPM_b32_DIM_STATE DimState) {

   if (_poCallbackIf) _poCallbackIf->onDimmingStateStatus(DimState); 

   // onDimmingStateStatus: user specific code start
   // onDimmingStateStatus: user specific code end

}



/*******************************************************************************
* Handling of property SPM_COREFI_C_U16_ONOFFTRIGGER
*******************************************************************************/

tVoid dispvidctrl_tclClientSpm::vHandleOnOffTriggerOpMResult(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODRESULT ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         spm_corefi_tclMsgOnOffTriggerMethodResult  oMResult;

         if (oInMsg.s32GetData(oMResult, SPM_FI_MAJOR_VERSION) != OSAL_ERROR) {
            ETG_TRACE_USR1(("dispvidctrl_tclClientSpm::vHandleOnOffTriggerOpMResult(): Method result update message received for 'SPM_COREFI_C_U16_ONOFFTRIGGER' (FID: 0x100f)!"));

            onOnOffTriggerMResult();

            // vHandleOnOffTriggerOpMResult: user specific code start
            // vHandleOnOffTriggerOpMResult: user specific code end
         } else {
            ETG_TRACE_ERR(("dispvidctrl_tclClientSpm::vHandleOnOffTriggerOpMResult: Received message is invalid!"));
         }

         oMResult.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclClientSpm::onOnOffTriggerMResult() {

   if (_poCallbackIf) _poCallbackIf->onOnOffTriggerMResult(); 

   // onOnOffTriggerMResult: user specific code start
   // onOnOffTriggerMResult: user specific code end

}




tBool dispvidctrl_tclClientSpm::sendActiveOnOffTriggerGet() {
   tBool bRetVal = FALSE;
   if (u16GetRegID() != AMT_C_U16_REGID_INVALID) {
      spm_corefi_tclMsgActiveOnOffTriggerGet  oGet;
      //the data content


      fi_tclVisitorMessage oOutMessage(oGet);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, (tU16) 0, (tU16) SPM_COREFI_C_U16_ACTIVEONOFFTRIGGER, (tU8) AMT_C_U8_CCAMSG_OPCODE_GET);
      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "dispvidctrl_tclClientSpm::sendActiveOnOffTriggerGet(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", SPM_COREFI_C_U16_ACTIVEONOFFTRIGGER, (tU32)enResult));
      } else {
         bRetVal = TRUE;
      }

      // Always destroy the FI data object before leaving its creation scope
      oGet.vDestroy();
   }
   return bRetVal;
}
tBool dispvidctrl_tclClientSpm::sendSysPwrModeGet() {
   tBool bRetVal = FALSE;
   if (u16GetRegID() != AMT_C_U16_REGID_INVALID) {
      spm_corefi_tclMsgSysPwrModeGet  oGet;
      //the data content


      fi_tclVisitorMessage oOutMessage(oGet);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, (tU16) 0, (tU16) SPM_COREFI_C_U16_SYSPWRMODE, (tU8) AMT_C_U8_CCAMSG_OPCODE_GET);
      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "dispvidctrl_tclClientSpm::sendSysPwrModeGet(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", SPM_COREFI_C_U16_SYSPWRMODE, (tU32)enResult));
      } else {
         bRetVal = TRUE;
      }

      // Always destroy the FI data object before leaving its creation scope
      oGet.vDestroy();
   }
   return bRetVal;
}
tBool dispvidctrl_tclClientSpm::sendCvmEventGet() {
   tBool bRetVal = FALSE;
   if (u16GetRegID() != AMT_C_U16_REGID_INVALID) {
      spm_corefi_tclMsgCvmEventGet  oGet;
      //the data content


      fi_tclVisitorMessage oOutMessage(oGet);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, (tU16) 0, (tU16) SPM_COREFI_C_U16_CVMEVENT, (tU8) AMT_C_U8_CCAMSG_OPCODE_GET);
      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "dispvidctrl_tclClientSpm::sendCvmEventGet(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", SPM_COREFI_C_U16_CVMEVENT, (tU32)enResult));
      } else {
         bRetVal = TRUE;
      }

      // Always destroy the FI data object before leaving its creation scope
      oGet.vDestroy();
   }
   return bRetVal;
}
tBool dispvidctrl_tclClientSpm::sendHmiStateGet() {
   tBool bRetVal = FALSE;
   if (u16GetRegID() != AMT_C_U16_REGID_INVALID) {
      spm_corefi_tclMsgHmiStateGet  oGet;
      //the data content


      fi_tclVisitorMessage oOutMessage(oGet);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, (tU16) 0, (tU16) SPM_COREFI_C_U16_HMISTATE, (tU8) AMT_C_U8_CCAMSG_OPCODE_GET);
      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "dispvidctrl_tclClientSpm::sendHmiStateGet(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", SPM_COREFI_C_U16_HMISTATE, (tU32)enResult));
      } else {
         bRetVal = TRUE;
      }

      // Always destroy the FI data object before leaving its creation scope
      oGet.vDestroy();
   }
   return bRetVal;
}
tBool dispvidctrl_tclClientSpm::sendDimmingStateGet() {
   tBool bRetVal = FALSE;
   if (u16GetRegID() != AMT_C_U16_REGID_INVALID) {
      spm_corefi_tclMsgDimmingStateGet  oGet;
      //the data content


      fi_tclVisitorMessage oOutMessage(oGet);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, (tU16) 0, (tU16) SPM_COREFI_C_U16_DIMMINGSTATE, (tU8) AMT_C_U8_CCAMSG_OPCODE_GET);
      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "dispvidctrl_tclClientSpm::sendDimmingStateGet(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", SPM_COREFI_C_U16_DIMMINGSTATE, (tU32)enResult));
      } else {
         bRetVal = TRUE;
      }

      // Always destroy the FI data object before leaving its creation scope
      oGet.vDestroy();
   }
   return bRetVal;
}

tBool dispvidctrl_tclClientSpm::sendOnOffTriggerMStart(spm_fi_tcl_SPM_e32_SubStateType eSwitchOnTrigger, tBool bState) {
   tBool bRetVal = FALSE;
   if (u16GetRegID() != AMT_C_U16_REGID_INVALID) {
      spm_corefi_tclMsgOnOffTriggerMethodStart  oMStart;
      //the data content
      oMStart.eSwitchOnTrigger = eSwitchOnTrigger;
      oMStart.bState = bState;


      fi_tclVisitorMessage oOutMessage(oMStart);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, (tU16) 0, (tU16) SPM_COREFI_C_U16_ONOFFTRIGGER, (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODSTART);
      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "dispvidctrl_tclClientSpm::sendOnOffTriggerMStart(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", SPM_COREFI_C_U16_ONOFFTRIGGER, (tU32)enResult));
      } else {
         bRetVal = TRUE;
      }

      // Always destroy the FI data object before leaving its creation scope
      oMStart.vDestroy();
   }
   return bRetVal;
}

// dispvidctrl_tclClientSpmdispvidctrl_ClientSpm: user specific code start
// dispvidctrl_tclClientSpmdispvidctrl_ClientSpm: user specific code end

//EOF
