/*****************************************************************************
* FILE:         dispvidctrl_ClientSds_tts.h
* PROJECT:      G3G project
* SW-COMPONENT: dispvidctrl
* Template:     ClientHandler.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2018 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#ifndef __dispvidctrl_ClientSds_tts_H_
#define __dispvidctrl_ClientSds_tts_H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

//include base class
#include "Idispvidctrl_ClientSds_tts.h"
#include "dispvidctrl_AppMain.h"

// dispvidctrl_tclClientSds_tts_Include: user specific code start
// dispvidctrl_tclClientSds_tts_Include: user specific code end

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class dispvidctrl_tclClientSds_ttsCallbackIF;

class ahl_tclBaseOneThreadClientHandler;

class dispvidctrl_tclClientSds_tts : public Idispvidctrl_tclClientSds_tts
{

public:
   virtual const tChar* getName() const { return "dispvidctrl_tclClientSds_tts"; };
   
   virtual tVoid vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();

   dispvidctrl_tclClientSds_tts(tVoid); 
   dispvidctrl_tclClientSds_tts(dispvidctrl_tclAppMain* poMainAppl);
   virtual ~dispvidctrl_tclClientSds_tts();

   virtual tVoid vSetCallbackIf(dispvidctrl_tclClientSds_ttsCallbackIF* poCallback) {
      _poCallbackIf = poCallback;
   }

   // dispvidctrl_tclClientSds_ttsDeclarations: user specific code start
   // dispvidctrl_tclClientSds_ttsDeclarations: user specific code end

   /**************************************************************************
   * Assingment Operater, will not be implemented.
   * Avoids Lint Prio 3 warning: Info 1732: new in constructor for class 
   * 'dispvidctrl_tclClientSds_tts' which has no assignment operator.
   * NOTE: This is a technique to disable the assignment operator for this
   * class. So if an attempt for the assignment is made compiler complains.
   **************************************************************************/
   dispvidctrl_tclClientSds_tts& operator = (const dispvidctrl_tclClientSds_tts &oClientHandler);

   /***************************************************************************
   * Overriding ahl_tclBaseOneThreadClientHandler methods.
   ***************************************************************************/
   virtual tVoid vOnServiceAvailable();
   virtual tVoid vOnServiceUnavailable();
   
private:
   dispvidctrl_tclClientSds_ttsCallbackIF* _poCallbackIf;

public:

   /***************************************************************************
   * all public methods to send / getCurrentState.
   ***************************************************************************/


   virtual tBool sendTTSStatusGet();
   virtual tVoid getTTSStatusStatus(sds_fi_tcl_e8_TTSStatus& rTTSStatus) {
      rTTSStatus            = _TTSStatus_TTSStatusStatus;
   }

   virtual tBool sendSynthesizeSpeakMStart(sds_fi_tclString TextAndTags, sds_fi_tcl_e8_TextStyleOption TextStyle, sds_fi_tcl_b8_AudioOutputLocation AudioOutputLocation, sds_fi_tcl_e8_StatusInfoOption StatusInfo, tU32 ExpDate, tBool LastPackage);
   virtual tBool sendPrepareVoiceOutputMStart(sds_fi_tclString Device);
   virtual tBool sendAbortPromptMStart(sds_fi_tcl_e8_PromptAbortOption AbortPromptOption);

private:
   /***************************************************************************
   * handling of incomming messages
   ***************************************************************************/
   virtual tVoid vHandleTTSStatusOpStatus(amt_tclServiceData* poMessage);

   virtual tVoid vHandlePrepareVoiceOutputOpMResult(amt_tclServiceData* poMessage);
   virtual tVoid vHandleAbortPromptOpMResult(amt_tclServiceData* poMessage);

   virtual tVoid onTTSStatusStatus(sds_fi_tcl_e8_TTSStatus TTSStatus);

   virtual tVoid onPrepareVoiceOutputMResult();
   virtual tVoid onAbortPromptMResult();

private:
   /***************************************************************************
   * value of each received status
   ***************************************************************************/

   sds_fi_tcl_e8_TTSStatus                  _TTSStatus_TTSStatusStatus;

   /***************************************************************************
   * Message map definition macro
   ***************************************************************************/

   DECLARE_MSG_MAP(dispvidctrl_tclClientSds_tts) 

// dispvidctrl_tclClientSds_ttsDeclarationsPart2: user specific code start
private:
   virtual tVoid vHandlePrepareVoiceOutputOpMError(amt_tclServiceData* poMessage);
// dispvidctrl_tclClientSds_ttsDeclarationsPart2: user specific code end

};

#endif // __dispvidctrl_ClientSds_tts_H_


