/*****************************************************************************
* FILE:         dispvidctrl_ClientProfile.h
* PROJECT:      G3G project
* SW-COMPONENT: dispvidctrl
* Template:     ClientHandler.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2018 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#ifndef __dispvidctrl_ClientProfile_H_
#define __dispvidctrl_ClientProfile_H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

//include base class
#include "Idispvidctrl_ClientProfile.h"
#include "dispvidctrl_AppMain.h"

// dispvidctrl_tclClientProfile_Include: user specific code start
// dispvidctrl_tclClientProfile_Include: user specific code end

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class dispvidctrl_tclClientProfileCallbackIF;

class ahl_tclBaseOneThreadClientHandler;

class dispvidctrl_tclClientProfile : public Idispvidctrl_tclClientProfile
{

public:
   virtual const tChar* getName() const { return "dispvidctrl_tclClientProfile"; };
   
   virtual tVoid vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();

   dispvidctrl_tclClientProfile(tVoid); 
   dispvidctrl_tclClientProfile(dispvidctrl_tclAppMain* poMainAppl);
   virtual ~dispvidctrl_tclClientProfile();

   virtual tVoid vSetCallbackIf(dispvidctrl_tclClientProfileCallbackIF* poCallback) {
      _poCallbackIf = poCallback;
   }

   // dispvidctrl_tclClientProfileDeclarations: user specific code start
   // dispvidctrl_tclClientProfileDeclarations: user specific code end

   /**************************************************************************
   * Assingment Operater, will not be implemented.
   * Avoids Lint Prio 3 warning: Info 1732: new in constructor for class 
   * 'dispvidctrl_tclClientProfile' which has no assignment operator.
   * NOTE: This is a technique to disable the assignment operator for this
   * class. So if an attempt for the assignment is made compiler complains.
   **************************************************************************/
   dispvidctrl_tclClientProfile& operator = (const dispvidctrl_tclClientProfile &oClientHandler);

   /***************************************************************************
   * Overriding ahl_tclBaseOneThreadClientHandler methods.
   ***************************************************************************/
   virtual tVoid vOnServiceAvailable();
   virtual tVoid vOnServiceUnavailable();
   
private:
   dispvidctrl_tclClientProfileCallbackIF* _poCallbackIf;

public:

   /***************************************************************************
   * all public methods to send / getCurrentState.
   ***************************************************************************/


   virtual tBool sendactiveProfileGet();
   virtual tVoid getactiveProfileStatus(tU8& rID) {
      rID                   = _ID_activeProfileStatus;
   }

   virtual tBool sendstatusGet();
   virtual tVoid getstatusStatus(profile_fi_tcl_e8_profileStatus& rstatus) {
      rstatus               = _status_statusStatus;
   }
   virtual tVoid getcopyProfileStatus(tU8& rsourceID, tU8& rdestinationID) {
      rsourceID             = _sourceID_copyProfileStatus;
      rdestinationID        = _destinationID_copyProfileStatus;
   }
   virtual tVoid getdeleteProfileStatus(tU8& rProfileID) {
      rProfileID            = _ProfileID_deleteProfileStatus;
   }
   virtual tVoid getdataChangedStatus(profile_fi_tcl_e8_changeProfile& rreason) {
      rreason               = _reason_dataChangedStatus;
   }
   virtual tVoid getcreateProfileStatus(tU8& rID) {
      rID                   = _ID_createProfileStatus;
   }

   virtual tBool sendonDataChangedMStart(profile_fi_tcl_e8_DataChangedResponse result);
   virtual tBool sendonProfileCreatedMStart(profile_fi_tcl_e8_ClientResponse result);
   virtual tBool sendonProfileCopiedMStart(profile_fi_tcl_e8_ClientResponse result);
   virtual tBool sendonProfileDeletedMStart(profile_fi_tcl_e8_ClientResponse result);
   virtual tBool sendRegisterClientMStart();

private:
   /***************************************************************************
   * handling of incomming messages
   ***************************************************************************/
   virtual tVoid vHandleactiveProfileOpStatus(amt_tclServiceData* poMessage);
   virtual tVoid vHandlestatusOpStatus(amt_tclServiceData* poMessage);
   virtual tVoid vHandlecopyProfileOpStatus(amt_tclServiceData* poMessage);
   virtual tVoid vHandledeleteProfileOpStatus(amt_tclServiceData* poMessage);
   virtual tVoid vHandledataChangedOpStatus(amt_tclServiceData* poMessage);
   virtual tVoid vHandlecreateProfileOpStatus(amt_tclServiceData* poMessage);

   virtual tVoid vHandleRegisterClientOpMResult(amt_tclServiceData* poMessage);

   virtual tVoid onactiveProfileStatus(tU8 ID);
   virtual tVoid onstatusStatus(profile_fi_tcl_e8_profileStatus status);
   virtual tVoid oncopyProfileStatus(tU8 sourceID, tU8 destinationID);
   virtual tVoid ondeleteProfileStatus(tU8 ProfileID);
   virtual tVoid ondataChangedStatus(profile_fi_tcl_e8_changeProfile reason);
   virtual tVoid oncreateProfileStatus(tU8 ID);

   virtual tVoid onRegisterClientMResult(tBool bReloadData);

private:
   /***************************************************************************
   * value of each received status
   ***************************************************************************/

   tU8                                      _ID_activeProfileStatus;
   profile_fi_tcl_e8_profileStatus          _status_statusStatus;
   tU8                                      _sourceID_copyProfileStatus;
   tU8                                      _destinationID_copyProfileStatus;
   tU8                                      _ProfileID_deleteProfileStatus;
   profile_fi_tcl_e8_changeProfile          _reason_dataChangedStatus;
   tU8                                      _ID_createProfileStatus;

   /***************************************************************************
   * Message map definition macro
   ***************************************************************************/

   DECLARE_MSG_MAP(dispvidctrl_tclClientProfile) 

// dispvidctrl_tclClientProfileDeclarationsPart2: user specific code start
// dispvidctrl_tclClientProfileDeclarationsPart2: user specific code end

};

#endif // __dispvidctrl_ClientProfile_H_


