

/*****************************************************************************
* FILE:         dispvidctrl_ClientProfile.cpp
* PROJECT:      G3G project
* SW-COMPONENT: dispvidctrl
* Template:     ClientHandler.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2018 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

// dispvidctrl_tclClientProfileIncludes: user specific code start
// dispvidctrl_tclClientProfileIncludes: user specific code end

#include "dispvidctrl_ClientProfile.h"
#include "dispvidctrl_ClientProfileCallbackIf.h"



#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DISPVIDCTRL_CLIENT_PROFILE
#include "trcGenProj/Header/dispvidctrl_ClientProfile.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/
#define PROFILE_SERVICE_ID              214
#define PROFILE_FI_MAJOR_VERSION        1
#define PROFILE_FI_MINOR_VERSION        1

/******************************************************************************/
/*                                                                            */
/* CCA MESSAGE MAP                                                            */
/*                                                                            */
/******************************************************************************/

BEGIN_MSG_MAP(dispvidctrl_tclClientProfile, ahl_tclBaseWork)
   ON_MESSAGE_SVCDATA(PROFILE_MAINFI_C_U16_ACTIVEPROFILE, AMT_C_U8_CCAMSG_OPCODE_STATUS, vHandleactiveProfileOpStatus)
   ON_MESSAGE_SVCDATA(PROFILE_MAINFI_C_U16_STATUS, AMT_C_U8_CCAMSG_OPCODE_STATUS, vHandlestatusOpStatus)
   ON_MESSAGE_SVCDATA(PROFILE_MAINFI_C_U16_COPYPROFILE, AMT_C_U8_CCAMSG_OPCODE_STATUS, vHandlecopyProfileOpStatus)
   ON_MESSAGE_SVCDATA(PROFILE_MAINFI_C_U16_DELETEPROFILE, AMT_C_U8_CCAMSG_OPCODE_STATUS, vHandledeleteProfileOpStatus)
   ON_MESSAGE_SVCDATA(PROFILE_MAINFI_C_U16_DATACHANGED, AMT_C_U8_CCAMSG_OPCODE_STATUS, vHandledataChangedOpStatus)
   ON_MESSAGE_SVCDATA(PROFILE_MAINFI_C_U16_CREATEPROFILE, AMT_C_U8_CCAMSG_OPCODE_STATUS, vHandlecreateProfileOpStatus)
   ON_MESSAGE_SVCDATA(PROFILE_MAINFI_C_U16_REGISTERCLIENT, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT, vHandleRegisterClientOpMResult)
   // dispvidctrl_tclClientProfile_MsgMap: user specific code start
   // dispvidctrl_tclClientProfile_MsgMap: user specific code end
END_MSG_MAP()

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: dispvidctrl_tclClientProfile::
*             dispvidctrl_tclClientProfile(dispvidctrl_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
dispvidctrl_tclClientProfile::dispvidctrl_tclClientProfile(dispvidctrl_tclAppMain* poMainAppl) : 
Idispvidctrl_tclClientProfile(poMainAppl, PROFILE_SERVICE_ID, PROFILE_FI_MAJOR_VERSION, PROFILE_FI_MINOR_VERSION )
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientProfile() entered."));
   _poCallbackIf = OSAL_NULL;
   _ID_activeProfileStatus = 0;
   _sourceID_copyProfileStatus = 0;
   _destinationID_copyProfileStatus = 0;
   _ProfileID_deleteProfileStatus = 0;
   _ID_createProfileStatus = 0;
   
   // dispvidctrl_tclClientProfileConstructor: user specific code start
   // dispvidctrl_tclClientProfileConstructor: user specific code end
   vAddAutoRegisterForProperty(PROFILE_MAINFI_C_U16_ACTIVEPROFILE);
   vAddAutoRegisterForProperty(PROFILE_MAINFI_C_U16_STATUS);
   vAddAutoRegisterForProperty(PROFILE_MAINFI_C_U16_COPYPROFILE);
   vAddAutoRegisterForProperty(PROFILE_MAINFI_C_U16_DELETEPROFILE);
   vAddAutoRegisterForProperty(PROFILE_MAINFI_C_U16_DATACHANGED);
   vAddAutoRegisterForProperty(PROFILE_MAINFI_C_U16_CREATEPROFILE);
}

/*******************************************************************************
*
* FUNCTION: dispvidctrl_tclClientProfile::
*             ~dispvidctrl_tclClientProfile(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
dispvidctrl_tclClientProfile::~dispvidctrl_tclClientProfile(tVoid)
{
   ETG_TRACE_USR4(("~dispvidctrl_tclClientProfile() entered."));
   _poCallbackIf = OSAL_NULL;

   // dispvidctrl_tclClientProfileDestructor: user specific code start
   // dispvidctrl_tclClientProfileDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientProfile::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'dispvidctrl_ClientProfile.h':
*     Add forward declaration:
*         class Idispvidctrl_tclObject2Get;
*
*     Add declaration of object reference:
*         Idispvidctrl_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Idispvidctrl_tclObject2Get*>(_cpoMain->getHandler("Idispvidctrl_tclObject2Get"));
*     PROFILE_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientProfile::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientProfile::vGetReferences() entered."));
   
   // dispvidctrl_tclClientProfilevGetReferences: user specific code start
   // dispvidctrl_tclClientProfilevGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientProfile::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientProfile::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientProfile::vStartCommunication() entered."));
   // dispvidctrl_tclClientProfilevStartCommunication: user specific code start
   // dispvidctrl_tclClientProfilevStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientProfile::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   dispvidctrl_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientProfile::vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientProfile::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(dispvidctrl_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   // dispvidctrl_tclClientProfilevHandleMessage: user specific code start
   // dispvidctrl_tclClientProfilevHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientProfile::vHandleTraceMessage()
*
* DESCRIPTION: Handle trace message.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientProfile::vHandleTraceMessage(const tUChar* puchData)
{
   DISPVIDCTRL_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("dispvidctrl_tclClientProfile::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // dispvidctrl_tclClientProfilevHandleTraceMessage: user specific code start
   // dispvidctrl_tclClientProfilevHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientProfile::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientProfile::vTraceInfo()
{
   ETG_TRACE_FATAL(("Property support:      activeProfile (PROFILE_MAINFI_C_U16_ACTIVEPROFILE) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      status (PROFILE_MAINFI_C_U16_STATUS) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      copyProfile (PROFILE_MAINFI_C_U16_COPYPROFILE) -> Opcode: UpReg, RelUpReg, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      deleteProfile (PROFILE_MAINFI_C_U16_DELETEPROFILE) -> Opcode: UpReg, RelUpReg, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      dataChanged (PROFILE_MAINFI_C_U16_DATACHANGED) -> Opcode: UpReg, RelUpReg, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      createProfile (PROFILE_MAINFI_C_U16_CREATEPROFILE) -> Opcode: UpReg, RelUpReg, Status, Error, "));
   ETG_TRACE_FATAL(("Method   support:      onDataChanged (PROFILE_MAINFI_C_U16_ONDATACHANGED) -> Opcode: MethodStart, Error, "));
   ETG_TRACE_FATAL(("Method   support:      onProfileCreated (PROFILE_MAINFI_C_U16_ONPROFILECREATED) -> Opcode: MethodStart, Error, "));
   ETG_TRACE_FATAL(("Method   support:      onProfileCopied (PROFILE_MAINFI_C_U16_ONPROFILECOPIED) -> Opcode: MethodStart, Error, "));
   ETG_TRACE_FATAL(("Method   support:      onProfileDeleted (PROFILE_MAINFI_C_U16_ONPROFILEDELETED) -> Opcode: MethodStart, Error, "));
   ETG_TRACE_FATAL(("Method   support:      RegisterClient (PROFILE_MAINFI_C_U16_REGISTERCLIENT) -> Opcode: MethodStart, Error, MethodResult, "));

   // dispvidctrl_tclClientProfilevTraceInfo: user specific code start
   // dispvidctrl_tclClientProfilevTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientProfile::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid dispvidctrl_tclClientProfile::vOnServiceAvailable()
{
   ETG_TRACE_USR4(("vOnServiceAvailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceAvailable();

   // dispvidctrl_tclClientProfilevOnServiceAvailable: user specific code start
   // dispvidctrl_tclClientProfilevOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientProfile::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid dispvidctrl_tclClientProfile::vOnServiceUnavailable()
{
   ETG_TRACE_USR4(("vOnServiceUnavailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceUnavailable();

   // dispvidctrl_tclClientProfilevOnServiceUnavailable: user specific code start
   // dispvidctrl_tclClientProfilevOnServiceUnavailable: user specific code end
}


/*******************************************************************************
* Handling of property PROFILE_MAINFI_C_U16_ACTIVEPROFILE
*******************************************************************************/

tVoid dispvidctrl_tclClientProfile::vHandleactiveProfileOpStatus(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         profile_mainfi_tclMsgactiveProfileStatus  oStatus;

         if (oInMsg.s32GetData(oStatus, PROFILE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _ID_activeProfileStatus = oStatus.ID;

            ETG_TRACE_USR1(("dispvidctrl_tclClientProfile::vHandleactiveProfileOpStatus(): Status update message received for 'PROFILE_MAINFI_C_U16_ACTIVEPROFILE' (FID: 0x0001)!"));

            onactiveProfileStatus(oStatus.ID);

            // vHandleactiveProfileOpStatus: user specific code start
            // vHandleactiveProfileOpStatus: user specific code end
         } else {
            ETG_TRACE_ERR(("dispvidctrl_tclClientProfile::vHandleactiveProfileOpStatus: Received message is invalid!"));
         }

         oStatus.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclClientProfile::onactiveProfileStatus(tU8 ID) {

   if (_poCallbackIf) _poCallbackIf->onactiveProfileStatus(ID); 

   // onactiveProfileStatus: user specific code start
   // onactiveProfileStatus: user specific code end

}

/*******************************************************************************
* Handling of property PROFILE_MAINFI_C_U16_STATUS
*******************************************************************************/

tVoid dispvidctrl_tclClientProfile::vHandlestatusOpStatus(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         profile_mainfi_tclMsgstatusStatus  oStatus;

         if (oInMsg.s32GetData(oStatus, PROFILE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _status_statusStatus = oStatus.status;

            ETG_TRACE_USR1(("dispvidctrl_tclClientProfile::vHandlestatusOpStatus(): Status update message received for 'PROFILE_MAINFI_C_U16_STATUS' (FID: 0x0002)!"));

            onstatusStatus(oStatus.status);

            // vHandlestatusOpStatus: user specific code start
            // vHandlestatusOpStatus: user specific code end
         } else {
            ETG_TRACE_ERR(("dispvidctrl_tclClientProfile::vHandlestatusOpStatus: Received message is invalid!"));
         }

         oStatus.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclClientProfile::onstatusStatus(profile_fi_tcl_e8_profileStatus status) {

   if (_poCallbackIf) _poCallbackIf->onstatusStatus(status); 

   // onstatusStatus: user specific code start
   // onstatusStatus: user specific code end

}

/*******************************************************************************
* Handling of property PROFILE_MAINFI_C_U16_COPYPROFILE
*******************************************************************************/

tVoid dispvidctrl_tclClientProfile::vHandlecopyProfileOpStatus(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         profile_mainfi_tclMsgcopyProfileStatus  oStatus;

         if (oInMsg.s32GetData(oStatus, PROFILE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _sourceID_copyProfileStatus = oStatus.sourceID;
            _destinationID_copyProfileStatus = oStatus.destinationID;

            ETG_TRACE_USR1(("dispvidctrl_tclClientProfile::vHandlecopyProfileOpStatus(): Status update message received for 'PROFILE_MAINFI_C_U16_COPYPROFILE' (FID: 0x0003)!"));

            oncopyProfileStatus(oStatus.sourceID, oStatus.destinationID);

            // vHandlecopyProfileOpStatus: user specific code start
            // vHandlecopyProfileOpStatus: user specific code end
         } else {
            ETG_TRACE_ERR(("dispvidctrl_tclClientProfile::vHandlecopyProfileOpStatus: Received message is invalid!"));
         }

         oStatus.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclClientProfile::oncopyProfileStatus(tU8 sourceID, tU8 destinationID) {

   if (_poCallbackIf) _poCallbackIf->oncopyProfileStatus(sourceID, destinationID); 

   // oncopyProfileStatus: user specific code start
   // oncopyProfileStatus: user specific code end

}

/*******************************************************************************
* Handling of property PROFILE_MAINFI_C_U16_DELETEPROFILE
*******************************************************************************/

tVoid dispvidctrl_tclClientProfile::vHandledeleteProfileOpStatus(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         profile_mainfi_tclMsgdeleteProfileStatus  oStatus;

         if (oInMsg.s32GetData(oStatus, PROFILE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _ProfileID_deleteProfileStatus = oStatus.ProfileID;

            ETG_TRACE_USR1(("dispvidctrl_tclClientProfile::vHandledeleteProfileOpStatus(): Status update message received for 'PROFILE_MAINFI_C_U16_DELETEPROFILE' (FID: 0x0004)!"));

            ondeleteProfileStatus(oStatus.ProfileID);

            // vHandledeleteProfileOpStatus: user specific code start
            // vHandledeleteProfileOpStatus: user specific code end
         } else {
            ETG_TRACE_ERR(("dispvidctrl_tclClientProfile::vHandledeleteProfileOpStatus: Received message is invalid!"));
         }

         oStatus.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclClientProfile::ondeleteProfileStatus(tU8 ProfileID) {

   if (_poCallbackIf) _poCallbackIf->ondeleteProfileStatus(ProfileID); 

   // ondeleteProfileStatus: user specific code start
   // ondeleteProfileStatus: user specific code end

}

/*******************************************************************************
* Handling of property PROFILE_MAINFI_C_U16_DATACHANGED
*******************************************************************************/

tVoid dispvidctrl_tclClientProfile::vHandledataChangedOpStatus(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         profile_mainfi_tclMsgdataChangedStatus  oStatus;

         if (oInMsg.s32GetData(oStatus, PROFILE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _reason_dataChangedStatus = oStatus.reason;

            ETG_TRACE_USR1(("dispvidctrl_tclClientProfile::vHandledataChangedOpStatus(): Status update message received for 'PROFILE_MAINFI_C_U16_DATACHANGED' (FID: 0x0005)!"));

            ondataChangedStatus(oStatus.reason);

            // vHandledataChangedOpStatus: user specific code start
            // vHandledataChangedOpStatus: user specific code end
         } else {
            ETG_TRACE_ERR(("dispvidctrl_tclClientProfile::vHandledataChangedOpStatus: Received message is invalid!"));
         }

         oStatus.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclClientProfile::ondataChangedStatus(profile_fi_tcl_e8_changeProfile reason) {

   if (_poCallbackIf) _poCallbackIf->ondataChangedStatus(reason); 

   // ondataChangedStatus: user specific code start
   // ondataChangedStatus: user specific code end

}

/*******************************************************************************
* Handling of property PROFILE_MAINFI_C_U16_CREATEPROFILE
*******************************************************************************/

tVoid dispvidctrl_tclClientProfile::vHandlecreateProfileOpStatus(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         profile_mainfi_tclMsgcreateProfileStatus  oStatus;

         if (oInMsg.s32GetData(oStatus, PROFILE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _ID_createProfileStatus = oStatus.ID;

            ETG_TRACE_USR1(("dispvidctrl_tclClientProfile::vHandlecreateProfileOpStatus(): Status update message received for 'PROFILE_MAINFI_C_U16_CREATEPROFILE' (FID: 0x0006)!"));

            oncreateProfileStatus(oStatus.ID);

            // vHandlecreateProfileOpStatus: user specific code start
            // vHandlecreateProfileOpStatus: user specific code end
         } else {
            ETG_TRACE_ERR(("dispvidctrl_tclClientProfile::vHandlecreateProfileOpStatus: Received message is invalid!"));
         }

         oStatus.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclClientProfile::oncreateProfileStatus(tU8 ID) {

   if (_poCallbackIf) _poCallbackIf->oncreateProfileStatus(ID); 

   // oncreateProfileStatus: user specific code start
   // oncreateProfileStatus: user specific code end

}



/*******************************************************************************
* Handling of property PROFILE_MAINFI_C_U16_REGISTERCLIENT
*******************************************************************************/

tVoid dispvidctrl_tclClientProfile::vHandleRegisterClientOpMResult(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODRESULT ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         profile_mainfi_tclMsgRegisterClientMethodResult  oMResult;

         if (oInMsg.s32GetData(oMResult, PROFILE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            ETG_TRACE_USR1(("dispvidctrl_tclClientProfile::vHandleRegisterClientOpMResult(): Method result update message received for 'PROFILE_MAINFI_C_U16_REGISTERCLIENT' (FID: 0x0300)!"));

            onRegisterClientMResult(oMResult.bReloadData);

            // vHandleRegisterClientOpMResult: user specific code start
            // vHandleRegisterClientOpMResult: user specific code end
         } else {
            ETG_TRACE_ERR(("dispvidctrl_tclClientProfile::vHandleRegisterClientOpMResult: Received message is invalid!"));
         }

         oMResult.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclClientProfile::onRegisterClientMResult(tBool bReloadData) {

   if (_poCallbackIf) _poCallbackIf->onRegisterClientMResult(bReloadData); 

   // onRegisterClientMResult: user specific code start
   // onRegisterClientMResult: user specific code end

}




tBool dispvidctrl_tclClientProfile::sendactiveProfileGet() {
   tBool bRetVal = FALSE;
   if (u16GetRegID() != AMT_C_U16_REGID_INVALID) {
      profile_mainfi_tclMsgactiveProfileGet  oGet;
      //the data content


      fi_tclVisitorMessage oOutMessage(oGet);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, (tU16) 0, (tU16) PROFILE_MAINFI_C_U16_ACTIVEPROFILE, (tU8) AMT_C_U8_CCAMSG_OPCODE_GET);
      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "dispvidctrl_tclClientProfile::sendactiveProfileGet(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", PROFILE_MAINFI_C_U16_ACTIVEPROFILE, (tU32)enResult));
      } else {
         bRetVal = TRUE;
      }

      // Always destroy the FI data object before leaving its creation scope
      oGet.vDestroy();
   }
   return bRetVal;
}
tBool dispvidctrl_tclClientProfile::sendstatusGet() {
   tBool bRetVal = FALSE;
   if (u16GetRegID() != AMT_C_U16_REGID_INVALID) {
      profile_mainfi_tclMsgstatusGet  oGet;
      //the data content


      fi_tclVisitorMessage oOutMessage(oGet);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, (tU16) 0, (tU16) PROFILE_MAINFI_C_U16_STATUS, (tU8) AMT_C_U8_CCAMSG_OPCODE_GET);
      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "dispvidctrl_tclClientProfile::sendstatusGet(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", PROFILE_MAINFI_C_U16_STATUS, (tU32)enResult));
      } else {
         bRetVal = TRUE;
      }

      // Always destroy the FI data object before leaving its creation scope
      oGet.vDestroy();
   }
   return bRetVal;
}

tBool dispvidctrl_tclClientProfile::sendonDataChangedMStart(profile_fi_tcl_e8_DataChangedResponse result) {
   tBool bRetVal = FALSE;
   if (u16GetRegID() != AMT_C_U16_REGID_INVALID) {
      profile_mainfi_tclMsgonDataChangedMethodStart  oMStart;
      //the data content
      oMStart.result = result;


      fi_tclVisitorMessage oOutMessage(oMStart);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, (tU16) 0, (tU16) PROFILE_MAINFI_C_U16_ONDATACHANGED, (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODSTART);
      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "dispvidctrl_tclClientProfile::sendonDataChangedMStart(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", PROFILE_MAINFI_C_U16_ONDATACHANGED, (tU32)enResult));
      } else {
         bRetVal = TRUE;
      }

      // Always destroy the FI data object before leaving its creation scope
      oMStart.vDestroy();
   }
   return bRetVal;
}
tBool dispvidctrl_tclClientProfile::sendonProfileCreatedMStart(profile_fi_tcl_e8_ClientResponse result) {
   tBool bRetVal = FALSE;
   if (u16GetRegID() != AMT_C_U16_REGID_INVALID) {
      profile_mainfi_tclMsgonProfileCreatedMethodStart  oMStart;
      //the data content
      oMStart.result = result;


      fi_tclVisitorMessage oOutMessage(oMStart);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, (tU16) 0, (tU16) PROFILE_MAINFI_C_U16_ONPROFILECREATED, (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODSTART);
      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "dispvidctrl_tclClientProfile::sendonProfileCreatedMStart(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", PROFILE_MAINFI_C_U16_ONPROFILECREATED, (tU32)enResult));
      } else {
         bRetVal = TRUE;
      }

      // Always destroy the FI data object before leaving its creation scope
      oMStart.vDestroy();
   }
   return bRetVal;
}
tBool dispvidctrl_tclClientProfile::sendonProfileCopiedMStart(profile_fi_tcl_e8_ClientResponse result) {
   tBool bRetVal = FALSE;
   if (u16GetRegID() != AMT_C_U16_REGID_INVALID) {
      profile_mainfi_tclMsgonProfileCopiedMethodStart  oMStart;
      //the data content
      oMStart.result = result;


      fi_tclVisitorMessage oOutMessage(oMStart);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, (tU16) 0, (tU16) PROFILE_MAINFI_C_U16_ONPROFILECOPIED, (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODSTART);
      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "dispvidctrl_tclClientProfile::sendonProfileCopiedMStart(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", PROFILE_MAINFI_C_U16_ONPROFILECOPIED, (tU32)enResult));
      } else {
         bRetVal = TRUE;
      }

      // Always destroy the FI data object before leaving its creation scope
      oMStart.vDestroy();
   }
   return bRetVal;
}
tBool dispvidctrl_tclClientProfile::sendonProfileDeletedMStart(profile_fi_tcl_e8_ClientResponse result) {
   tBool bRetVal = FALSE;
   if (u16GetRegID() != AMT_C_U16_REGID_INVALID) {
      profile_mainfi_tclMsgonProfileDeletedMethodStart  oMStart;
      //the data content
      oMStart.result = result;


      fi_tclVisitorMessage oOutMessage(oMStart);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, (tU16) 0, (tU16) PROFILE_MAINFI_C_U16_ONPROFILEDELETED, (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODSTART);
      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "dispvidctrl_tclClientProfile::sendonProfileDeletedMStart(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", PROFILE_MAINFI_C_U16_ONPROFILEDELETED, (tU32)enResult));
      } else {
         bRetVal = TRUE;
      }

      // Always destroy the FI data object before leaving its creation scope
      oMStart.vDestroy();
   }
   return bRetVal;
}
tBool dispvidctrl_tclClientProfile::sendRegisterClientMStart() {
   tBool bRetVal = FALSE;
   if (u16GetRegID() != AMT_C_U16_REGID_INVALID) {
      profile_mainfi_tclMsgRegisterClientMethodStart  oMStart;
      //the data content


      fi_tclVisitorMessage oOutMessage(oMStart);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, (tU16) 0, (tU16) PROFILE_MAINFI_C_U16_REGISTERCLIENT, (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODSTART);
      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "dispvidctrl_tclClientProfile::sendRegisterClientMStart(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", PROFILE_MAINFI_C_U16_REGISTERCLIENT, (tU32)enResult));
      } else {
         bRetVal = TRUE;
      }

      // Always destroy the FI data object before leaving its creation scope
      oMStart.vDestroy();
   }
   return bRetVal;
}

// dispvidctrl_tclClientProfiledispvidctrl_ClientProfile: user specific code start
// dispvidctrl_tclClientProfiledispvidctrl_ClientProfile: user specific code end

//EOF
