

/*****************************************************************************
* FILE:         dispvidctrl_ClientDiaglog.cpp
* PROJECT:      G3G project
* SW-COMPONENT: dispvidctrl
* Template:     ClientHandler.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2018 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

// dispvidctrl_tclClientDiaglogIncludes: user specific code start
// dispvidctrl_tclClientDiaglogIncludes: user specific code end

#include "dispvidctrl_ClientDiaglog.h"
#include "dispvidctrl_ClientDiaglogCallbackIf.h"



#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DISPVIDCTRL_CLIENT_DIAGLOG
#include "trcGenProj/Header/dispvidctrl_ClientDiaglog.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/
#define DIAGLOG_SERVICE_ID              112
#define DIAGLOG_FI_MAJOR_VERSION        1
#define DIAGLOG_FI_MINOR_VERSION        6

/******************************************************************************/
/*                                                                            */
/* CCA MESSAGE MAP                                                            */
/*                                                                            */
/******************************************************************************/

BEGIN_MSG_MAP(dispvidctrl_tclClientDiaglog, ahl_tclBaseWork)
   ON_MESSAGE_SVCDATA(MIDW_DIAGLOGFI_C_U16_SENDNEXTTESTRESULT, AMT_C_U8_CCAMSG_OPCODE_STATUS, vHandleSendNextTestResultOpStatus)
   ON_MESSAGE_SVCDATA(MIDW_DIAGLOGFI_C_U16_SAVETESTRESULT, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT, vHandleSaveTestResultOpMResult)
   // dispvidctrl_tclClientDiaglog_MsgMap: user specific code start
   // dispvidctrl_tclClientDiaglog_MsgMap: user specific code end
END_MSG_MAP()

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: dispvidctrl_tclClientDiaglog::
*             dispvidctrl_tclClientDiaglog(dispvidctrl_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
dispvidctrl_tclClientDiaglog::dispvidctrl_tclClientDiaglog(dispvidctrl_tclAppMain* poMainAppl) : 
Idispvidctrl_tclClientDiaglog(poMainAppl, DIAGLOG_SERVICE_ID, DIAGLOG_FI_MAJOR_VERSION, DIAGLOG_FI_MINOR_VERSION )
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientDiaglog() entered."));
   _poCallbackIf = OSAL_NULL;
   _Status_SendNextTestResultStatus = FALSE;
   
   // dispvidctrl_tclClientDiaglogConstructor: user specific code start
   // dispvidctrl_tclClientDiaglogConstructor: user specific code end
   vAddAutoRegisterForProperty(MIDW_DIAGLOGFI_C_U16_SENDNEXTTESTRESULT);
}

/*******************************************************************************
*
* FUNCTION: dispvidctrl_tclClientDiaglog::
*             ~dispvidctrl_tclClientDiaglog(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
dispvidctrl_tclClientDiaglog::~dispvidctrl_tclClientDiaglog(tVoid)
{
   ETG_TRACE_USR4(("~dispvidctrl_tclClientDiaglog() entered."));
   _poCallbackIf = OSAL_NULL;

   // dispvidctrl_tclClientDiaglogDestructor: user specific code start
   // dispvidctrl_tclClientDiaglogDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientDiaglog::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'dispvidctrl_ClientDiaglog.h':
*     Add forward declaration:
*         class Idispvidctrl_tclObject2Get;
*
*     Add declaration of object reference:
*         Idispvidctrl_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Idispvidctrl_tclObject2Get*>(_cpoMain->getHandler("Idispvidctrl_tclObject2Get"));
*     DIAGLOG_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientDiaglog::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientDiaglog::vGetReferences() entered."));
   
   // dispvidctrl_tclClientDiaglogvGetReferences: user specific code start
   // dispvidctrl_tclClientDiaglogvGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientDiaglog::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientDiaglog::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientDiaglog::vStartCommunication() entered."));
   // dispvidctrl_tclClientDiaglogvStartCommunication: user specific code start
   // dispvidctrl_tclClientDiaglogvStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientDiaglog::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   dispvidctrl_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientDiaglog::vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientDiaglog::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(dispvidctrl_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   // dispvidctrl_tclClientDiaglogvHandleMessage: user specific code start
   // dispvidctrl_tclClientDiaglogvHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientDiaglog::vHandleTraceMessage()
*
* DESCRIPTION: Handle trace message.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientDiaglog::vHandleTraceMessage(const tUChar* puchData)
{
   DISPVIDCTRL_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("dispvidctrl_tclClientDiaglog::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // dispvidctrl_tclClientDiaglogvHandleTraceMessage: user specific code start
   // dispvidctrl_tclClientDiaglogvHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientDiaglog::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientDiaglog::vTraceInfo()
{
   ETG_TRACE_FATAL(("Property support:      SendNextTestResult (MIDW_DIAGLOGFI_C_U16_SENDNEXTTESTRESULT) -> Opcode: UpReg, RelUpReg, Status, Error, "));
   ETG_TRACE_FATAL(("Method   support:      SaveTestResult (MIDW_DIAGLOGFI_C_U16_SAVETESTRESULT) -> Opcode: MethodStart, MethodResult, Error, "));

   // dispvidctrl_tclClientDiaglogvTraceInfo: user specific code start
   // dispvidctrl_tclClientDiaglogvTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientDiaglog::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid dispvidctrl_tclClientDiaglog::vOnServiceAvailable()
{
   ETG_TRACE_USR4(("vOnServiceAvailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceAvailable();

   // dispvidctrl_tclClientDiaglogvOnServiceAvailable: user specific code start
   // dispvidctrl_tclClientDiaglogvOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientDiaglog::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid dispvidctrl_tclClientDiaglog::vOnServiceUnavailable()
{
   ETG_TRACE_USR4(("vOnServiceUnavailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceUnavailable();

   // dispvidctrl_tclClientDiaglogvOnServiceUnavailable: user specific code start
   // dispvidctrl_tclClientDiaglogvOnServiceUnavailable: user specific code end
}


/*******************************************************************************
* Handling of property MIDW_DIAGLOGFI_C_U16_SENDNEXTTESTRESULT
*******************************************************************************/

tVoid dispvidctrl_tclClientDiaglog::vHandleSendNextTestResultOpStatus(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         midw_diaglogfi_tclMsgSendNextTestResultStatus  oStatus;

         if (oInMsg.s32GetData(oStatus, DIAGLOG_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _NextTestResultStruct_SendNextTestResultStatus = oStatus.NextTestResultStruct;
            _Status_SendNextTestResultStatus = oStatus.Status;

            ETG_TRACE_USR1(("dispvidctrl_tclClientDiaglog::vHandleSendNextTestResultOpStatus(): Status update message received for 'MIDW_DIAGLOGFI_C_U16_SENDNEXTTESTRESULT' (FID: 0x000A)!"));

            onSendNextTestResultStatus(oStatus.NextTestResultStruct, oStatus.Status);

            // vHandleSendNextTestResultOpStatus: user specific code start
            // vHandleSendNextTestResultOpStatus: user specific code end
         } else {
            ETG_TRACE_ERR(("dispvidctrl_tclClientDiaglog::vHandleSendNextTestResultOpStatus: Received message is invalid!"));
         }

         oStatus.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclClientDiaglog::onSendNextTestResultStatus(midw_fi_tcl_SendNextTestResultStructure NextTestResultStruct, tBool Status) {

   if (_poCallbackIf) _poCallbackIf->onSendNextTestResultStatus(NextTestResultStruct, Status); 

   // onSendNextTestResultStatus: user specific code start
   // onSendNextTestResultStatus: user specific code end

}



/*******************************************************************************
* Handling of property MIDW_DIAGLOGFI_C_U16_SAVETESTRESULT
*******************************************************************************/

tVoid dispvidctrl_tclClientDiaglog::vHandleSaveTestResultOpMResult(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODRESULT ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         midw_diaglogfi_tclMsgSaveTestResultMethodResult  oMResult;

         if (oInMsg.s32GetData(oMResult, DIAGLOG_FI_MAJOR_VERSION) != OSAL_ERROR) {
            ETG_TRACE_USR1(("dispvidctrl_tclClientDiaglog::vHandleSaveTestResultOpMResult(): Method result update message received for 'MIDW_DIAGLOGFI_C_U16_SAVETESTRESULT' (FID: 0x0001)!"));

            onSaveTestResultMResult(oMResult.Status);

            // vHandleSaveTestResultOpMResult: user specific code start
            // vHandleSaveTestResultOpMResult: user specific code end
         } else {
            ETG_TRACE_ERR(("dispvidctrl_tclClientDiaglog::vHandleSaveTestResultOpMResult: Received message is invalid!"));
         }

         oMResult.vDestroy();
      }
   }  
}

tVoid dispvidctrl_tclClientDiaglog::onSaveTestResultMResult(midw_fi_tcl_e8_MethodResultReply Status) {

   if (_poCallbackIf) _poCallbackIf->onSaveTestResultMResult(Status); 

   // onSaveTestResultMResult: user specific code start
   // onSaveTestResultMResult: user specific code end

}





tBool dispvidctrl_tclClientDiaglog::sendSaveTestResultMStart(midw_fi_tcl_TestResultList TestResultList) {
   tBool bRetVal = FALSE;
   if (u16GetRegID() != AMT_C_U16_REGID_INVALID) {
      midw_diaglogfi_tclMsgSaveTestResultMethodStart  oMStart;
      //the data content
      oMStart.TestResultList = TestResultList;


      fi_tclVisitorMessage oOutMessage(oMStart);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, (tU16) 0, (tU16) MIDW_DIAGLOGFI_C_U16_SAVETESTRESULT, (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODSTART);
      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "dispvidctrl_tclClientDiaglog::sendSaveTestResultMStart(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", MIDW_DIAGLOGFI_C_U16_SAVETESTRESULT, (tU32)enResult));
      } else {
         bRetVal = TRUE;
      }

      // Always destroy the FI data object before leaving its creation scope
      oMStart.vDestroy();
   }
   return bRetVal;
}

// dispvidctrl_tclClientDiaglogdispvidctrl_ClientDiaglog: user specific code start
// dispvidctrl_tclClientDiaglogdispvidctrl_ClientDiaglog: user specific code end

//EOF
