/*****************************************************************************
* FILE:         dispvidctrl_ClientVcanCanAdaptor.cpp
* PROJECT:      G3G project
* SW-COMPONENT: dispvidctrl
* Template:     csmAdaptor.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  Generated file
*               DO NOT CHANGE --> 
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2018 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#define MIDW_COMMON_S_IMPORT_INTERFACE_CSM
#ifdef VARIANT_S_FTR_ENABLE_SMART
#define CSM_C_PROJECT_USERSPACE_SMART_HU
#else
#define CSM_C_PROJECT_USERSPACE_INF4CV
#endif
#include "midw_common_if.h"



// dispvidctrl_tclClientVcanCanAdaptor::Include: user specific code start
// dispvidctrl_tclClientVcanCanAdaptor::Include: user specific code end

//include base class
#include "dispvidctrl_AppMain.h"

#include "dispvidctrl_ClientVcanCanAdaptor.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DISPVIDCTRL_CLIENT_VCAN
#include "trcGenProj/Header/dispvidctrl_ClientVcanCanAdaptor.cpp.trc.h"
#endif


dispvidctrl_tclClientVcanCanAdaptor* dispvidctrl_tclClientVcanCanAdaptor::_pMyStaticRef = 0;

/* ---------------- */
/* public functions */
/* ---------------- */

dispvidctrl_tclClientVcanCanAdaptor::dispvidctrl_tclClientVcanCanAdaptor(dispvidctrl_tclAppMain* poMainAppl):
I_dispvidctrl_tclClientVcanCanAdaptor(poMainAppl)
{
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::dispvidctrl_tclClientVcanCanAdaptor() entered."));

    _pMyStaticRef = this;
    _pCallbackIf = NULL;
    _poMyCSMInterface = NULL;
    _tFAP_Setting01.u32Status=0;
    _tFAP_Setting01.FAP_Setting01=0;
	_tFAP_Setting02.u32Status=0;
    _tFAP_Setting02.FAP_Setting02=0;
	_tFAP_Setting03.u32Status=0;
    _tFAP_Setting03.FAP_Setting03=0;
	_tFAP_Setting04.u32Status=0;
    _tFAP_Setting04.FAP_Setting04=0;
	_tFAP_Setting05.u32Status=0;
    _tFAP_Setting05.FAP_Setting05=0;
	_tFAP_Setting06.u32Status=0;
    _tFAP_Setting06.FAP_Setting06=0;
	_tFAP_Setting07.u32Status=0;
    _tFAP_Setting07.FAP_Setting07=0;
	_tFAP_Setting08.u32Status=0;
    _tFAP_Setting08.FAP_Setting08=0;
	_tFAP_Setting09.u32Status=0;
    _tFAP_Setting09.FAP_Setting09=0;
	_tFAP_Setting10.u32Status=0;
    _tFAP_Setting10.FAP_Setting10=0;
	_tAVM_Setting_1.u32Status=0;
    _tAVM_Setting_1.AVM_Setting_1=0;
	_tAVM_Setting_2.u32Status=0;
    _tAVM_Setting_2.AVM_Setting_2=0;
	_tAVM_Setting_3.u32Status=0;
    _tAVM_Setting_3.AVM_Setting_3=0;
	_tAVM_Setting_4.u32Status=0;
    _tAVM_Setting_4.AVM_Setting_4=0;
	_tAVM_Setting_5.u32Status=0;
    _tAVM_Setting_5.AVM_Setting_5=0;
    _tAVM_Setting_6.u32Status=0;
    _tAVM_Setting_6.AVM_Setting_6=0;
	_tAVM_Setting_7.u32Status=0;
    _tAVM_Setting_7.AVM_Setting_7=0;
	_tAVM_Setting_8.u32Status=0;
    _tAVM_Setting_8.AVM_Setting_8=0;
	_tAVM_Setting_9.u32Status=0;
    _tAVM_Setting_9.AVM_Setting_9=0;

    // dispvidctrl_tclClientVcanCanAdaptor::dispvidctrl_tclClientVcanCanAdaptor: user specific code start
    tS32 s32CanActive = CSMInterface::CSM_s32WaitForCAN(200);
    if (s32CanActive < 0) {
       ETG_TRACE_FATAL(("dispvidctrl_tclClientVcanCanAdaptor::dispvidctrl_tclClientVcanCanAdaptor() CAN currently not active."));
    } else {
        ETG_TRACE_FATAL(("dispvidctrl_tclClientVcanCanAdaptor::dispvidctrl_tclClientVcanCanAdaptor() Waiting for CAN: %d ms.", s32CanActive));
    }
    // dispvidctrl_tclClientVcanCanAdaptor::dispvidctrl_tclClientVcanCanAdaptor: user specific code end

    return;
}

dispvidctrl_tclClientVcanCanAdaptor::~dispvidctrl_tclClientVcanCanAdaptor()
{
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::~dispvidctrl_tclClientVcanCanAdaptor() entered."));
    
    _pCallbackIf = OSAL_NULL;
    
    if (OSAL_NULL != _poMyCSMInterface) {
        OSAL_DELETE _poMyCSMInterface;
    }
    _poMyCSMInterface = OSAL_NULL;
}

tVoid dispvidctrl_tclClientVcanCanAdaptor::vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(dispvidctrl_tclBaseIf::ECmdTypes, pMsg->eCmd), pMsg->u.u32Data));
   if (pMsg->eCmd == dispvidctrl_tclBaseIf::eCmdCsmSignalReceived) {
       vSignalIndSync(pMsg->u.u32Data);
   }

   // dispvidctrl_tclClientVcanCanAdaptor::vHandleMessage: user specific code start
   // dispvidctrl_tclClientVcanCanAdaptor::vHandleMessage: user specific code end
}

tVoid dispvidctrl_tclClientVcanCanAdaptor::vHandleTraceMessage(const tUChar* puchData)
{
   DISPVIDCTRL_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // dispvidctrl_tclClientVcanCanAdaptor::vHandleTraceMessage: user specific code start
   // dispvidctrl_tclClientVcanCanAdaptor::vHandleTraceMessage: user specific code end
}

tVoid dispvidctrl_tclClientVcanCanAdaptor::vGetReferences() {
   // dispvidctrl_tclClientVcanCanAdaptor::vGetReferences: user specific code start
   // dispvidctrl_tclClientVcanCanAdaptor::vGetReferences: user specific code end
}


tVoid dispvidctrl_tclClientVcanCanAdaptor::vTraceInfo()
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vTraceInfo() entered."));
   // dispvidctrl_tclClientVcanCanAdaptor::vTraceInfo: user specific code start
   // dispvidctrl_tclClientVcanCanAdaptor::vTraceInfo: user specific code end

}


tVoid dispvidctrl_tclClientVcanCanAdaptor::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vStartCommunication() entered."));

   // dispvidctrl_tclClientVcanCanAdaptor::vStartCommunication: user specific code start
   // dispvidctrl_tclClientVcanCanAdaptor::vStartCommunication: user specific code end
}


tVoid dispvidctrl_tclClientVcanCanAdaptor::vConnect()
{

   tU32 u32CsmHandle;
   ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vConnect() entered."));

   // dispvidctrl_tclClientVcanCanAdaptor::vConnect: user specific code start
   //ETG_TRACE_FATAL(("[%d ms] dispvidctrl_tclClientVcanCanAdaptor::vConnect() entered.",OSAL_ClockGetElapsedTime()));

   tS32 s32CanActive = CSMInterface::CSM_s32WaitForCAN(1000);
   if (s32CanActive < 0) {
       ETG_TRACE_FATAL(("dispvidctrl_tclClientVcanCanAdaptor::vConnect() CAN currently not active."));
   } else {
       ETG_TRACE_FATAL(("dispvidctrl_tclClientVcanCanAdaptor::vConnect() Waiting for CAN: %d ms.", s32CanActive));
   }
   // dispvidctrl_tclClientVcanCanAdaptor::vConnect: user specific code end

   _poMyCSMInterface = new CSMInterface();
   DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
#ifdef VARIANT_S_FTR_ENABLE_SMART
if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_RearGearEngaged_MM_GW_RearCamInfo, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_SIG_RX_RearGearEngaged_MM_GW_RearCamInfo'."));
   }
   vReadRearGearEngaged();
   
if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_SwaSensorInternalStatus_MM_GW_RearCamInfo, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_SIG_RX_SwaSensorInternalStatus_MM_GW_RearCamInfo'."));
   }
   vReadSwaSensorInternalStatus();
    if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_SteeringWheelAngle_MM_GW_RearCamInfo, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_SIG_RX_SteeringWheelAngle_MM_GW_RearCamInfo'."));
   }
   
   vReadSteering_Angle();   
   #else
   ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Install Callback now."));
    if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_RearCamReq_SystemEnvironment, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_SIG_RX_RearCamReq_SystemEnvironment'."));
   }
   vReadRearGearEngaged();
   #endif

   /*if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_VehicleSpeed_CruiseControl, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_ASIG_RX_UPA_RX_Initializing'."));
   }*/
   //vReadUPA_RX_Initializing();
   /*if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_UPA_View_Change_Request, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_ASIG_RX_UPA_View_Change_Request'."));
   }
   vReadUPA_View_Change_Request();
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_UPA_BEEP_Sound_Request, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_ASIG_RX_UPA_BEEP_Sound_Request'."));
   }
   vReadUPA_BEEP_Sound_Request();
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_UPA_AOD_Beep1_Request, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_ASIG_RX_UPA_AOD_Beep1_Request'."));
   }
   vReadUPA_AOD_Beep1_Request();
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_UPA_Setting_ITS, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_ASIG_RX_UPA_Setting_ITS'."));
   }
   vReadUPA_Setting_ITS();
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_UPA_MOD_Status, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_ASIG_RX_UPA_MOD_Status'."));
   }
   vReadUPA_MOD_Status();
   vReadUPA_BEEP_Sound_Type();
   vReadSteering_Angle();
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_Calibration_Flag, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_ASIG_RX_Calibration_Flag'."));
   }
   vReadCalibration_Flag();
   vReadSteering_Sensor_Fail_Flag();
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_SwaSensorInternalStatus, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_ASIG_RX_SwaSensorInternalStatus'."));
   }
   vReadSwaSensorInternalStatus();
   vReadFRONT_STEER_PINION_ANGLE();
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_ACTIVE_STEER_FAIL, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_ASIG_RX_ACTIVE_STEER_FAIL'."));
   }
   vReadACTIVE_STEER_FAIL();
   vReadVehicleSpeed();
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_IPA_Mode_Change_Request, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_ASIG_RX_IPA_Mode_Change_Request'."));
   }
   vReadIPA_Mode_Change_Request();
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_IPA_Switch_Display_Request, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_ASIG_RX_IPA_Switch_Display_Request'."));
   }
   vReadIPA_Switch_Display_Request();
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_IPA_Switch_mask_Request, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_ASIG_RX_IPA_Switch_mask_Request'."));
   }
   vReadIPA_Switch_mask_Request();
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_IPA_Switch_Gray_Out_Request_01, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_ASIG_RX_IPA_Switch_Gray_Out_Request_01'."));
   }
   vReadIPA_Switch_Gray_Out_Request_01();
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_IPA_Switch_Gray_Out_Request_02, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_ASIG_RX_IPA_Switch_Gray_Out_Request_02'."));
   }
   vReadIPA_Switch_Gray_Out_Request_02();
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_IPA_Switch_Gray_Out_Request_03, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_ASIG_RX_IPA_Switch_Gray_Out_Request_03'."));
   }
   vReadIPA_Switch_Gray_Out_Request_03();
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_IPA_Switch_Gray_Out_Request_04, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_ASIG_RX_IPA_Switch_Gray_Out_Request_04'."));
   }
   vReadIPA_Switch_Gray_Out_Request_04();
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_IPA_Switch_Gray_Out_Request_05, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_ASIG_RX_IPA_Switch_Gray_Out_Request_05'."));
   }
   vReadIPA_Switch_Gray_Out_Request_05();
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_IPA_Switch_Gray_Out_Request_06, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_ASIG_RX_IPA_Switch_Gray_Out_Request_06'."));
   }
   vReadIPA_Switch_Gray_Out_Request_06();
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_IPA_mode_selection, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_ASIG_RX_IPA_mode_selection'."));
   }
   vReadIPA_mode_selection();
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_IPA_Message_Display_Request, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_ASIG_RX_IPA_Message_Display_Request'."));
   }
   vReadIPA_Message_Display_Request();
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_IPA_Sound_Output_Request, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_ASIG_RX_IPA_Sound_Output_Request'."));
   }
   vReadIPA_Sound_Output_Request();
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_IPA_Voice_Output_Request, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_ASIG_RX_IPA_Voice_Output_Request'."));
   }
   vReadIPA_Voice_Output_Request();
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_IPA_region_selection, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_ASIG_RX_IPA_region_selection'."));
   }
   vReadIPA_region_selection();
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_IPA_Camera_Indicator_Request, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_ASIG_RX_IPA_Camera_Indicator_Request'."));
   }
   vReadIPA_Camera_Indicator_Request();
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_IPA_Mulfunction, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_ASIG_RX_IPA_Mulfunction'."));
   }
   vReadIPA_Mulfunction();
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_RearGearEngaged, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_ASIG_RX_RearGearEngaged'."));
   }
   vReadRearGearEngaged();
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_MVC_ViewModeStatus, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_ASIG_RX_MVC_ViewModeStatus'."));
   }
   vReadMVC_ViewModeStatus();
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_MVC_WarningDisplayRequest, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_ASIG_RX_MVC_WarningDisplayRequest'."));
   }
   vReadMVC_WarningDisplayRequest();
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_TailGateStatus, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_ASIG_RX_TailGateStatus'."));
   }
   vReadTailGateStatus();
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_AVM_ChangeViewStatus, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_ASIG_RX_AVM_ChangeViewStatus'."));
   }
   vReadAVM_ChangeViewStatus();
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_AVM_ClosingAuthorization, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_ASIG_RX_AVM_ClosingAuthorization'."));
   }
   vReadAVM_ClosingAuthorization();
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_MOD_ActivationState, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_ASIG_RX_MOD_ActivationState'."));
   }
   vReadMOD_ActivationState();
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_FAP_ModeChangeRequest, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_ASIG_RX_FAP_ModeChangeRequest'."));
   }
   vReadFAP_ModeChangeRequest();
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_Camerasetting_availability, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_ASIG_RX_Camerasetting_availability'."));
   }
   vReadCamerasetting_availability();
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_FAP_Setting01, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_ASIG_RX_FAP_Setting01'."));
   }
   vReadFAP_Setting01();
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_FAP_Setting02, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_ASIG_RX_FAP_Setting02'."));
   }
   vReadFAP_Setting02();
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_FAP_Setting03, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_ASIG_RX_FAP_Setting03'."));
   }
   vReadFAP_Setting03();
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_FAP_Setting04, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_ASIG_RX_FAP_Setting04'."));
   }
   vReadFAP_Setting04();
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_FAP_Setting05, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_ASIG_RX_FAP_Setting05'."));
   }
   vReadFAP_Setting05();
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_FAP_Setting06, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_ASIG_RX_FAP_Setting06'."));
   }
   vReadFAP_Setting06();
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_FAP_Setting07, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_ASIG_RX_FAP_Setting07'."));
   }
   vReadFAP_Setting07();
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_FAP_Setting08, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_ASIG_RX_FAP_Setting08'."));
   }
   vReadFAP_Setting08();
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_FAP_Setting09, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_ASIG_RX_FAP_Setting09'."));
   }
   vReadFAP_Setting09();
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_FAP_Setting10, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_ASIG_RX_FAP_Setting10'."));
   }
   vReadFAP_Setting10();
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_AVM_Setting_1, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_ASIG_RX_AVM_Setting_1'."));
   }
   vReadAVM_Setting_1();
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_AVM_Setting_2, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_ASIG_RX_AVM_Setting_2'."));
   }
   vReadAVM_Setting_2();
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_AVM_Setting_3, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_ASIG_RX_AVM_Setting_3'."));
   }
   vReadAVM_Setting_3();
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_AVM_Setting_4, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_ASIG_RX_AVM_Setting_4'."));
   }
   vReadAVM_Setting_4();
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_AVM_Setting_5, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_ASIG_RX_AVM_Setting_5'."));
   }
   vReadAVM_Setting_5();
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_AVM_Setting_6, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_ASIG_RX_AVM_Setting_6'."));
   }
   vReadAVM_Setting_6();
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_AVM_Setting_7, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_ASIG_RX_AVM_Setting_7'."));
   }
   vReadAVM_Setting_7();
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_AVM_Setting_8, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_ASIG_RX_AVM_Setting_8'."));
   }
   vReadAVM_Setting_8();
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_AVM_Setting_9, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_ASIG_RX_AVM_Setting_9'."));
   }
   vReadAVM_Setting_9();
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_FAP_PurposeSwitchAvailability, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_ASIG_RX_FAP_PurposeSwitchAvailability'."));
   }
   vReadFAP_PurposeSwitchAvailability();
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_FAP_ChangeViewRequest, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_ASIG_RX_FAP_ChangeViewRequest'."));
   }
   vReadFAP_ChangeViewRequest();
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_FAP_SoundDirection, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_ASIG_RX_FAP_SoundDirection'."));
   }
   vReadFAP_SoundDirection();
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_FAP_SoundLevelControl, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_ASIG_RX_FAP_SoundLevelControl'."));
   }
   vReadFAP_SoundLevelControl();
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_FAP_SoundPatternRequest, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_ASIG_RX_FAP_SoundPatternRequest'."));
   }
   vReadFAP_SoundPatternRequest();
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_FAP_VoicePatternRequest, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_ASIG_RX_FAP_VoicePatternRequest'."));
   }
   vReadFAP_VoicePatternRequest();
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_DayRheostatedLightMaxPercent, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_ASIG_RX_DayRheostatedLightMaxPercent'."));
   }
   vReadDayRheostatedLightMaxPercent();
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_NightRheostatedLightMaxPercent, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_ASIG_RX_NightRheostatedLightMaxPercent'."));
   }
   vReadNightRheostatedLightMaxPercent();
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_DimmingState, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_ASIG_RX_DimmingState'."));
   }
   vReadDimmingState();
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_STATUS_DYNAMIC_REAR, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_ASIG_RX_STATUS_DYNAMIC_REAR'."));
   }
   vReadSTATUS_DYNAMIC_REAR();*/
}

tVoid dispvidctrl_tclClientVcanCanAdaptor::vSignalIndCallback(tVoid* pHandle, tU32 u32SignalId, tU32 u32SignalStatus)
{
    // lint
    (tVoid)pHandle;
    (tVoid)u32SignalStatus;

     dispvidctrl_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));

     oMsg.eCmd = dispvidctrl_tclBaseIf::eCmdCsmSignalReceived;
     OSAL_szStringNCopy(oMsg.strClassName, "dispvidctrl_tclClientVcanCanAdaptor", sizeof(oMsg.strClassName)-1);
     oMsg.u.u32Data = u32SignalId;

     _pMyStaticRef->_cpoMain->theServer()->vPostInternalMessage(&oMsg);

}

tVoid dispvidctrl_tclClientVcanCanAdaptor::vSignalIndSync(tU32 u32SignalId)
{
    /* Check which signal is changed ! */
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vSignalInd(): Signal Indication received: ID 0x%08x", u32SignalId));

    switch(u32SignalId)
    {
		#ifdef VARIANT_S_FTR_ENABLE_SMART
		case CSM_C_SIG_RX_RearGearEngaged_MM_GW_RearCamInfo:
        vReadRearGearEngaged();
        break;
		case CSM_C_SIG_RX_SwaSensorInternalStatus_MM_GW_RearCamInfo:
        vReadSwaSensorInternalStatus();
        break;
		case CSM_C_SIG_RX_SteeringWheelAngle_MM_GW_RearCamInfo:
        vReadSteering_Angle();
        break;
		#else
	case CSM_C_SIG_RX_RearCamReq_SystemEnvironment:
		 vReadRearGearEngaged();
        break;
		#endif
   /* case CSM_C_ASIG_RX_UPA_RX_Initializing:
        vReadUPA_RX_Initializing();
        break;
    case CSM_C_ASIG_RX_UPA_View_Change_Request:
        vReadUPA_View_Change_Request();
        break;
    case CSM_C_ASIG_RX_UPA_BEEP_Sound_Request:
        vReadUPA_BEEP_Sound_Request();
        break;
    case CSM_C_ASIG_RX_UPA_AOD_Beep1_Request:
        vReadUPA_AOD_Beep1_Request();
        break;
    case CSM_C_ASIG_RX_UPA_Setting_ITS:
        vReadUPA_Setting_ITS();
        break;
    case CSM_C_ASIG_RX_UPA_MOD_Status:
        vReadUPA_MOD_Status();
        break;
    case CSM_C_ASIG_RX_UPA_BEEP_Sound_Type:
        vReadUPA_BEEP_Sound_Type();
        break;
    case CSM_C_ASIG_RX_Steering_Angle:
        vReadSteering_Angle();
        break;
    case CSM_C_ASIG_RX_Calibration_Flag:
        vReadCalibration_Flag();
        break;
    case CSM_C_ASIG_RX_Steering_Sensor_Fail_Flag:
        vReadSteering_Sensor_Fail_Flag();
        break;
    case CSM_C_ASIG_RX_SwaSensorInternalStatus:
        vReadSwaSensorInternalStatus();
        break;
    case CSM_C_ASIG_RX_FRONT_STEER_PINION_ANGLE:
        vReadFRONT_STEER_PINION_ANGLE();
        break;
    case CSM_C_ASIG_RX_ACTIVE_STEER_FAIL:
        vReadACTIVE_STEER_FAIL();
        break;
    case CSM_C_ASIG_RX_VehicleSpeed:
        vReadVehicleSpeed();
        break;
    case CSM_C_ASIG_RX_IPA_Mode_Change_Request:
        vReadIPA_Mode_Change_Request();
        break;
    case CSM_C_ASIG_RX_IPA_Switch_Display_Request:
        vReadIPA_Switch_Display_Request();
        break;
    case CSM_C_ASIG_RX_IPA_Switch_mask_Request:
        vReadIPA_Switch_mask_Request();
        break;
    case CSM_C_ASIG_RX_IPA_Switch_Gray_Out_Request_01:
        vReadIPA_Switch_Gray_Out_Request_01();
        break;
    case CSM_C_ASIG_RX_IPA_Switch_Gray_Out_Request_02:
        vReadIPA_Switch_Gray_Out_Request_02();
        break;
    case CSM_C_ASIG_RX_IPA_Switch_Gray_Out_Request_03:
        vReadIPA_Switch_Gray_Out_Request_03();
        break;
    case CSM_C_ASIG_RX_IPA_Switch_Gray_Out_Request_04:
        vReadIPA_Switch_Gray_Out_Request_04();
        break;
    case CSM_C_ASIG_RX_IPA_Switch_Gray_Out_Request_05:
        vReadIPA_Switch_Gray_Out_Request_05();
        break;
    case CSM_C_ASIG_RX_IPA_Switch_Gray_Out_Request_06:
        vReadIPA_Switch_Gray_Out_Request_06();
        break;
    case CSM_C_ASIG_RX_IPA_mode_selection:
        vReadIPA_mode_selection();
        break;
    case CSM_C_ASIG_RX_IPA_Message_Display_Request:
        vReadIPA_Message_Display_Request();
        break;
    case CSM_C_ASIG_RX_IPA_Sound_Output_Request:
        vReadIPA_Sound_Output_Request();
        break;
    case CSM_C_ASIG_RX_IPA_Voice_Output_Request:
        vReadIPA_Voice_Output_Request();
        break;
    case CSM_C_ASIG_RX_IPA_region_selection:
        vReadIPA_region_selection();
        break;
    case CSM_C_ASIG_RX_IPA_Camera_Indicator_Request:
        vReadIPA_Camera_Indicator_Request();
        break;
    case CSM_C_ASIG_RX_IPA_Mulfunction:
        vReadIPA_Mulfunction();
        break;
    case CSM_C_ASIG_RX_RearGearEngaged:
        vReadRearGearEngaged();
        break;
    case CSM_C_ASIG_RX_MVC_ViewModeStatus:
        vReadMVC_ViewModeStatus();
        break;
    case CSM_C_ASIG_RX_MVC_WarningDisplayRequest:
        vReadMVC_WarningDisplayRequest();
        break;
    case CSM_C_ASIG_RX_TailGateStatus:
        vReadTailGateStatus();
        break;
    case CSM_C_ASIG_RX_AVM_ChangeViewStatus:
        vReadAVM_ChangeViewStatus();
        break;
    case CSM_C_ASIG_RX_AVM_ClosingAuthorization:
        vReadAVM_ClosingAuthorization();
        break;
    case CSM_C_ASIG_RX_MOD_ActivationState:
        vReadMOD_ActivationState();
        break;
    case CSM_C_ASIG_RX_FAP_ModeChangeRequest:
        vReadFAP_ModeChangeRequest();
        break;
    case CSM_C_ASIG_RX_Camerasetting_availability:
        vReadCamerasetting_availability();
        break;
    case CSM_C_ASIG_RX_FAP_Setting01:
        vReadFAP_Setting01();
        break;
    case CSM_C_ASIG_RX_FAP_Setting02:
        vReadFAP_Setting02();
        break;
    case CSM_C_ASIG_RX_FAP_Setting03:
        vReadFAP_Setting03();
        break;
    case CSM_C_ASIG_RX_FAP_Setting04:
        vReadFAP_Setting04();
        break;
    case CSM_C_ASIG_RX_FAP_Setting05:
        vReadFAP_Setting05();
        break;
    case CSM_C_ASIG_RX_FAP_Setting06:
        vReadFAP_Setting06();
        break;
    case CSM_C_ASIG_RX_FAP_Setting07:
        vReadFAP_Setting07();
        break;
    case CSM_C_ASIG_RX_FAP_Setting08:
        vReadFAP_Setting08();
        break;
    case CSM_C_ASIG_RX_FAP_Setting09:
        vReadFAP_Setting09();
        break;
    case CSM_C_ASIG_RX_FAP_Setting10:
        vReadFAP_Setting10();
        break;
    case CSM_C_ASIG_RX_AVM_Setting_1:
        vReadAVM_Setting_1();
        break;
    case CSM_C_ASIG_RX_AVM_Setting_2:
        vReadAVM_Setting_2();
        break;
    case CSM_C_ASIG_RX_AVM_Setting_3:
        vReadAVM_Setting_3();
        break;
    case CSM_C_ASIG_RX_AVM_Setting_4:
        vReadAVM_Setting_4();
        break;
    case CSM_C_ASIG_RX_AVM_Setting_5:
        vReadAVM_Setting_5();
        break;
    case CSM_C_ASIG_RX_AVM_Setting_6:
        vReadAVM_Setting_6();
        break;
    case CSM_C_ASIG_RX_AVM_Setting_7:
        vReadAVM_Setting_7();
        break;
    case CSM_C_ASIG_RX_AVM_Setting_8:
        vReadAVM_Setting_8();
        break;
    case CSM_C_ASIG_RX_AVM_Setting_9:
        vReadAVM_Setting_9();
        break;
    case CSM_C_ASIG_RX_FAP_PurposeSwitchAvailability:
        vReadFAP_PurposeSwitchAvailability();
        break;
    case CSM_C_ASIG_RX_FAP_ChangeViewRequest:
        vReadFAP_ChangeViewRequest();
        break;
    case CSM_C_ASIG_RX_FAP_SoundDirection:
        vReadFAP_SoundDirection();
        break;
    case CSM_C_ASIG_RX_FAP_SoundLevelControl:
        vReadFAP_SoundLevelControl();
        break;
    case CSM_C_ASIG_RX_FAP_SoundPatternRequest:
        vReadFAP_SoundPatternRequest();
        break;
    case CSM_C_ASIG_RX_FAP_VoicePatternRequest:
        vReadFAP_VoicePatternRequest();
        break;
    case CSM_C_ASIG_RX_DayRheostatedLightMaxPercent:
        vReadDayRheostatedLightMaxPercent();
        break;
    case CSM_C_ASIG_RX_NightRheostatedLightMaxPercent:
        vReadNightRheostatedLightMaxPercent();
        break;
    case CSM_C_ASIG_RX_DimmingState:
        vReadDimmingState();
        break;
    case CSM_C_ASIG_RX_STATUS_DYNAMIC_REAR:
        vReadSTATUS_DYNAMIC_REAR();
        break;*/

    default:
        break;
    }
}

/* ------------------------------------------------------------------------- */
tVoid dispvidctrl_tclClientVcanCanAdaptor::vSendCsmBroadcastSignal(tU8* pabData, tU8 u8Len, tU32 u32CsmSignal, tU8 u8TxType)
/*!
* \fn
*  \brief
*  
*  \param
*
*  \return
*
*  \note
*  \version
*    1.0   - Initial
******
*/
{

    tU32 u32CsmHandle;
    tS32 s32Ret;

    // dispvidctrl_tclClientVcanCanAdaptor_vSendCsmBroadcastSignal: user specific code start
    if ( OSAL_NULL == _poMyCSMInterface ) {
        ETG_TRACE_FATAL(("dispvidctrl_tclClientVcanCanAdaptor::vSendCsmBroadcastSignal(): !!!!!! Error: _poMyCSMInterface==NULL - to be analysed and fixed properly asap! For now, bailing out - signal 0x%08X not sent!", u32CsmSignal));
        return;
    }
    // dispvidctrl_tclClientVcanCanAdaptor_vSendCsmBroadcastSignal: user specific code end

    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);

    s32Ret = _poMyCSMInterface->CSM_lSignalWrite((tVoid *)&u32CsmHandle,u32CsmSignal,
        pabData,
        u8Len,
        u8TxType);

    if(CSM_C_NO_ERROR > s32Ret) {
        ETG_TRACE_ERR(("dispvidctrl_tclClientVcanCanAdaptor::vSendCsmBroadcastSignal(): !!!!!! Error detected !!!!!!"));
    }

    return;

}

tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadUPA_RX_Initializing()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadUPA_RX_Initializing(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

    if(/* CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_UPA_RX_Initializing,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead) */0)/** Jayashree:commented as it is aivi-relavant **/
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

    if(_tUPA_RX_Initializing.u32Status != u32StatusRead) {
        _tUPA_RX_Initializing.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	
	//CID: 172337


    // if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        // if(memcmp(&_tUPA_RX_Initializing.UPA_RX_Initializing, &au8Data_ReadBuffer[0], 1) != 0) {
            // memcpy(&_tUPA_RX_Initializing.UPA_RX_Initializing, &au8Data_ReadBuffer[0], 1);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadUPA_RX_Initializing(): Called!"));
        _pCallbackIf->onUPA_RX_InitializingStatus(_tUPA_RX_Initializing);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadUPA_View_Change_Request()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadUPA_View_Change_Request(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

    if(/* CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_UPA_View_Change_Request,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead) */0)/** Jayashree:commented as it is aivi-relavant **/
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

    if(_tUPA_View_Change_Request.u32Status != u32StatusRead) {
        _tUPA_View_Change_Request.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

//CID: 172314

    // if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        // if(memcmp(&_tUPA_View_Change_Request.UPA_View_Change_Request, &au8Data_ReadBuffer[0], 1) != 0) {
            // memcpy(&_tUPA_View_Change_Request.UPA_View_Change_Request, &au8Data_ReadBuffer[0], 1);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadUPA_View_Change_Request(): Called!"));
        _pCallbackIf->onUPA_View_Change_RequestStatus(_tUPA_View_Change_Request);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadUPA_BEEP_Sound_Request()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadUPA_BEEP_Sound_Request(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

    if(/* CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_UPA_BEEP_Sound_Request,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead) */0)/** Jayashree:commented as it is aivi-relavant **/
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

    if(_tUPA_BEEP_Sound_Request.u32Status != u32StatusRead) {
        _tUPA_BEEP_Sound_Request.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

	//CID: 172375

    // if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        // if(memcmp(&_tUPA_BEEP_Sound_Request.UPA_BEEP_Sound_Request, &au8Data_ReadBuffer[0], 1) != 0) {
            // memcpy(&_tUPA_BEEP_Sound_Request.UPA_BEEP_Sound_Request, &au8Data_ReadBuffer[0], 1);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadUPA_BEEP_Sound_Request(): Called!"));
        _pCallbackIf->onUPA_BEEP_Sound_RequestStatus(_tUPA_BEEP_Sound_Request);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadUPA_AOD_Beep1_Request()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadUPA_AOD_Beep1_Request(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

    if(/* CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_UPA_AOD_Beep1_Request,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead) */0)/** Jayashree:commented as it is aivi-relavant **/
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

    if(_tUPA_AOD_Beep1_Request.u32Status != u32StatusRead) {
        _tUPA_AOD_Beep1_Request.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

	//CID: 172368

    // if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        // if(memcmp(&_tUPA_AOD_Beep1_Request.UPA_AOD_Beep1_Request, &au8Data_ReadBuffer[0], 1) != 0) {
            // memcpy(&_tUPA_AOD_Beep1_Request.UPA_AOD_Beep1_Request, &au8Data_ReadBuffer[0], 1);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadUPA_AOD_Beep1_Request(): Called!"));
        _pCallbackIf->onUPA_AOD_Beep1_RequestStatus(_tUPA_AOD_Beep1_Request);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadUPA_Setting_ITS()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadUPA_Setting_ITS(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

    if(/* CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_UPA_Setting_ITS,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead) */0)/** Jayashree:commented as it is aivi-relavant **/
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

    if(_tUPA_Setting_ITS.u32Status != u32StatusRead) {
        _tUPA_Setting_ITS.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

	// CID: 172389

    // if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        // if(memcmp(&_tUPA_Setting_ITS.UPA_Setting_ITS, &au8Data_ReadBuffer[0], 1) != 0) {
            // memcpy(&_tUPA_Setting_ITS.UPA_Setting_ITS, &au8Data_ReadBuffer[0], 1);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadUPA_Setting_ITS(): Called!"));
        _pCallbackIf->onUPA_Setting_ITSStatus(_tUPA_Setting_ITS);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadUPA_MOD_Status()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadUPA_MOD_Status(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

    if(/* CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_UPA_MOD_Status,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead) */0)/** Jayashree:commented as it is aivi-relavant **/
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

    if(_tUPA_MOD_Status.u32Status != u32StatusRead) {
        _tUPA_MOD_Status.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

	//CID: 172354

    // if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        // if(memcmp(&_tUPA_MOD_Status.UPA_MOD_Status, &au8Data_ReadBuffer[0], 1) != 0) {
            // memcpy(&_tUPA_MOD_Status.UPA_MOD_Status, &au8Data_ReadBuffer[0], 1);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadUPA_MOD_Status(): Called!"));
        _pCallbackIf->onUPA_MOD_StatusStatus(_tUPA_MOD_Status);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadUPA_BEEP_Sound_Type()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadUPA_BEEP_Sound_Type(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

    if(/* CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_UPA_BEEP_Sound_Type,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead) */0)/** Jayashree:commented as it is aivi-relavant **/
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

    if(_tUPA_BEEP_Sound_Type.u32Status != u32StatusRead) {
        _tUPA_BEEP_Sound_Type.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

    //CID: 172370

	// if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        // if(memcmp(&_tUPA_BEEP_Sound_Type.UPA_BEEP_Sound_Type, &au8Data_ReadBuffer[0], 1) != 0) {
            // memcpy(&_tUPA_BEEP_Sound_Type.UPA_BEEP_Sound_Type, &au8Data_ReadBuffer[0], 1);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadUPA_BEEP_Sound_Type(): Called!"));
        _pCallbackIf->onUPA_BEEP_Sound_TypeStatus(_tUPA_BEEP_Sound_Type);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadSteering_Angle()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadSteering_Angle(): Called!"));
    tU8  au8Data_ReadBuffer[2];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;
#ifdef VARIANT_S_FTR_ENABLE_SMART
if( CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_SteeringWheelAngle_MM_GW_RearCamInfo,
        &au8Data_ReadBuffer[0],
        2,
        &u32StatusRead))
#else
    if(/* CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_Steering_Angle,
        &au8Data_ReadBuffer[0],
        2,
        &u32StatusRead) */0)/** Jayashree:commented as it is aivi-relavant **/
#endif
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

    if(_tSteering_Angle.u32Status != u32StatusRead) {
        _tSteering_Angle.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

    // if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        // if(memcmp(&_tSteering_Angle.Steering_Angle[0], &au8Data_ReadBuffer[0], 2) != 0) {
            // memcpy(&_tSteering_Angle.Steering_Angle[0], &au8Data_ReadBuffer[0], 2);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadSteering_Angle(): Called!"));
        _pCallbackIf->onSteering_AngleStatus(_tSteering_Angle);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadCalibration_Flag()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadCalibration_Flag(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

    if(/* CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_Calibration_Flag,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead) */0)/** Jayashree:commented as it is aivi-relavant **/
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

    if(_tCalibration_Flag.u32Status != u32StatusRead) {
        _tCalibration_Flag.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

	//CID: 172382
 
    // if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        // if(memcmp(&_tCalibration_Flag.Calibration_Flag, &au8Data_ReadBuffer[0], 1) != 0) {
            // memcpy(&_tCalibration_Flag.Calibration_Flag, &au8Data_ReadBuffer[0], 1);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadCalibration_Flag(): Called!"));
        _pCallbackIf->onCalibration_FlagStatus(_tCalibration_Flag);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadSteering_Sensor_Fail_Flag()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadSteering_Sensor_Fail_Flag(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

    if(/* CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_Steering_Sensor_Fail_Flag,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead) */0)/** Jayashree:commented as it is aivi-relavant **/
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

    if(_tSteering_Sensor_Fail_Flag.u32Status != u32StatusRead) {
        _tSteering_Sensor_Fail_Flag.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	//CID: 172310


    // if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        // if(memcmp(&_tSteering_Sensor_Fail_Flag.Steering_Sensor_Fail_Flag, &au8Data_ReadBuffer[0], 1) != 0) {
            // memcpy(&_tSteering_Sensor_Fail_Flag.Steering_Sensor_Fail_Flag, &au8Data_ReadBuffer[0], 1);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadSteering_Sensor_Fail_Flag(): Called!"));
        _pCallbackIf->onSteering_Sensor_Fail_FlagStatus(_tSteering_Sensor_Fail_Flag);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadSwaSensorInternalStatus()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadSwaSensorInternalStatus(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;
#ifdef VARIANT_S_FTR_ENABLE_SMART

if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_SwaSensorInternalStatus_MM_GW_RearCamInfo,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead))
#else
    if(/*CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_SwaSensorInternalStatus,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead)*/0)/** Jayashree:commented as it is aivi-relavant **/
#endif
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

    if(_tSwaSensorInternalStatus.u32Status != u32StatusRead) {
        _tSwaSensorInternalStatus.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	
	//CID: 172710
    // if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        // if(memcmp(&_tSwaSensorInternalStatus.SwaSensorInternalStatus, &au8Data_ReadBuffer[0], 1) != 0) {
            // memcpy(&_tSwaSensorInternalStatus.SwaSensorInternalStatus, &au8Data_ReadBuffer[0], 1);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadSwaSensorInternalStatus(): Called!"));
        _pCallbackIf->onSwaSensorInternalStatusStatus(_tSwaSensorInternalStatus);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadFRONT_STEER_PINION_ANGLE()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadFRONT_STEER_PINION_ANGLE(): Called!"));
    tU8  au8Data_ReadBuffer[2];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

    if(/* CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_FRONT_STEER_PINION_ANGLE,
        &au8Data_ReadBuffer[0],
        2,
        &u32StatusRead) */0)/** Jayashree:commented as it is aivi-relavant **/
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

    if(_tFRONT_STEER_PINION_ANGLE.u32Status != u32StatusRead) {
        _tFRONT_STEER_PINION_ANGLE.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

//CID: 172330

    // if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        // if(memcmp(&_tFRONT_STEER_PINION_ANGLE.FRONT_STEER_PINION_ANGLE[0], &au8Data_ReadBuffer[0], 2) != 0) {
            // memcpy(&_tFRONT_STEER_PINION_ANGLE.FRONT_STEER_PINION_ANGLE[0], &au8Data_ReadBuffer[0], 2);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadFRONT_STEER_PINION_ANGLE(): Called!"));
        _pCallbackIf->onFRONT_STEER_PINION_ANGLEStatus(_tFRONT_STEER_PINION_ANGLE);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadACTIVE_STEER_FAIL()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadACTIVE_STEER_FAIL(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

    if(/* CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_ACTIVE_STEER_FAIL,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead) */0)/** Jayashree:commented as it is aivi-relavant **/
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

    if(_tACTIVE_STEER_FAIL.u32Status != u32StatusRead) {
        _tACTIVE_STEER_FAIL.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

	//CID: 172339

    // if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        // if(memcmp(&_tACTIVE_STEER_FAIL.ACTIVE_STEER_FAIL, &au8Data_ReadBuffer[0], 1) != 0) {
            // memcpy(&_tACTIVE_STEER_FAIL.ACTIVE_STEER_FAIL, &au8Data_ReadBuffer[0], 1);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadACTIVE_STEER_FAIL(): Called!"));
        _pCallbackIf->onACTIVE_STEER_FAILStatus(_tACTIVE_STEER_FAIL);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadVehicleSpeed()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadVehicleSpeed(): Called!"));
    tU8  au8Data_ReadBuffer[2];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

    if(/* CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_VehicleSpeed,
        &au8Data_ReadBuffer[0],
        2,
        &u32StatusRead) */0)/** Jayashree:commented as it is aivi-relavant **/
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

    if(_tVehicleSpeed.u32Status != u32StatusRead) {
        _tVehicleSpeed.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
//CID: 172374
    // if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        // if(memcmp(&_tVehicleSpeed.VehicleSpeed[0], &au8Data_ReadBuffer[0], 2) != 0) {
            // memcpy(&_tVehicleSpeed.VehicleSpeed[0], &au8Data_ReadBuffer[0], 2);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadVehicleSpeed(): Called!"));
        _pCallbackIf->onVehicleSpeedStatus(_tVehicleSpeed);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadIPA_Mode_Change_Request()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadIPA_Mode_Change_Request(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

    if(/* CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_IPA_Mode_Change_Request,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead) */0)
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

    if(_tIPA_Mode_Change_Request.u32Status != u32StatusRead) {
        _tIPA_Mode_Change_Request.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

	//CID: 172349

    // if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        // if(memcmp(&_tIPA_Mode_Change_Request.IPA_Mode_Change_Request, &au8Data_ReadBuffer[0], 1) != 0) {
            // memcpy(&_tIPA_Mode_Change_Request.IPA_Mode_Change_Request, &au8Data_ReadBuffer[0], 1);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadIPA_Mode_Change_Request(): Called!"));
        _pCallbackIf->onIPA_Mode_Change_RequestStatus(_tIPA_Mode_Change_Request);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadIPA_Switch_Display_Request()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadIPA_Switch_Display_Request(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

    if(/* CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_IPA_Switch_Display_Request,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead) */0)
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

    if(_tIPA_Switch_Display_Request.u32Status != u32StatusRead) {
        _tIPA_Switch_Display_Request.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
//CID: 172290

    // if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        // if(memcmp(&_tIPA_Switch_Display_Request.IPA_Switch_Display_Request, &au8Data_ReadBuffer[0], 1) != 0) {
            // memcpy(&_tIPA_Switch_Display_Request.IPA_Switch_Display_Request, &au8Data_ReadBuffer[0], 1);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadIPA_Switch_Display_Request(): Called!"));
        _pCallbackIf->onIPA_Switch_Display_RequestStatus(_tIPA_Switch_Display_Request);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadIPA_Switch_mask_Request()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadIPA_Switch_mask_Request(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

    if(/* CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_IPA_Switch_mask_Request,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead) */0)
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

    if(_tIPA_Switch_mask_Request.u32Status != u32StatusRead) {
        _tIPA_Switch_mask_Request.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	
	//CID: 172307


    // if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        // if(memcmp(&_tIPA_Switch_mask_Request.IPA_Switch_mask_Request, &au8Data_ReadBuffer[0], 1) != 0) {
            // memcpy(&_tIPA_Switch_mask_Request.IPA_Switch_mask_Request, &au8Data_ReadBuffer[0], 1);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadIPA_Switch_mask_Request(): Called!"));
        _pCallbackIf->onIPA_Switch_mask_RequestStatus(_tIPA_Switch_mask_Request);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadIPA_Switch_Gray_Out_Request_01()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadIPA_Switch_Gray_Out_Request_01(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

    if(/* CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_IPA_Switch_Gray_Out_Request_01,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead) */0)
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

    if(_tIPA_Switch_Gray_Out_Request_01.u32Status != u32StatusRead) {
        _tIPA_Switch_Gray_Out_Request_01.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

//CID: 172289

    // if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        // if(memcmp(&_tIPA_Switch_Gray_Out_Request_01.IPA_Switch_Gray_Out_Request_01, &au8Data_ReadBuffer[0], 1) != 0) {
            // memcpy(&_tIPA_Switch_Gray_Out_Request_01.IPA_Switch_Gray_Out_Request_01, &au8Data_ReadBuffer[0], 1);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadIPA_Switch_Gray_Out_Request_01(): Called!"));
        _pCallbackIf->onIPA_Switch_Gray_Out_Request_01Status(_tIPA_Switch_Gray_Out_Request_01);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadIPA_Switch_Gray_Out_Request_02()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadIPA_Switch_Gray_Out_Request_02(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

    if(/* CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_IPA_Switch_Gray_Out_Request_02,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead) */0)/** Jayashree:commented as it is aivi-relavant **/
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

    if(_tIPA_Switch_Gray_Out_Request_02.u32Status != u32StatusRead) {
        _tIPA_Switch_Gray_Out_Request_02.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

//CID:172324

    // if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        // if(memcmp(&_tIPA_Switch_Gray_Out_Request_02.IPA_Switch_Gray_Out_Request_02, &au8Data_ReadBuffer[0], 1) != 0) {
            // memcpy(&_tIPA_Switch_Gray_Out_Request_02.IPA_Switch_Gray_Out_Request_02, &au8Data_ReadBuffer[0], 1);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadIPA_Switch_Gray_Out_Request_02(): Called!"));
        _pCallbackIf->onIPA_Switch_Gray_Out_Request_02Status(_tIPA_Switch_Gray_Out_Request_02);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadIPA_Switch_Gray_Out_Request_03()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadIPA_Switch_Gray_Out_Request_03(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

    if(/* CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_IPA_Switch_Gray_Out_Request_03,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead) */0)/** Jayashree:commented as it is aivi-relavant **/
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

    if(_tIPA_Switch_Gray_Out_Request_03.u32Status != u32StatusRead) {
        _tIPA_Switch_Gray_Out_Request_03.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	//CID: 172295


    // if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        // if(memcmp(&_tIPA_Switch_Gray_Out_Request_03.IPA_Switch_Gray_Out_Request_03, &au8Data_ReadBuffer[0], 1) != 0) {
            // memcpy(&_tIPA_Switch_Gray_Out_Request_03.IPA_Switch_Gray_Out_Request_03, &au8Data_ReadBuffer[0], 1);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadIPA_Switch_Gray_Out_Request_03(): Called!"));
        _pCallbackIf->onIPA_Switch_Gray_Out_Request_03Status(_tIPA_Switch_Gray_Out_Request_03);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadIPA_Switch_Gray_Out_Request_04()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadIPA_Switch_Gray_Out_Request_04(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

    if(/* CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_IPA_Switch_Gray_Out_Request_04,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead) */0)/** Jayashree:commented as it is aivi-relavant **/
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

    if(_tIPA_Switch_Gray_Out_Request_04.u32Status != u32StatusRead) {
        _tIPA_Switch_Gray_Out_Request_04.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

//CID: 172284

    // if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        // if(memcmp(&_tIPA_Switch_Gray_Out_Request_04.IPA_Switch_Gray_Out_Request_04, &au8Data_ReadBuffer[0], 1) != 0) {
            // memcpy(&_tIPA_Switch_Gray_Out_Request_04.IPA_Switch_Gray_Out_Request_04, &au8Data_ReadBuffer[0], 1);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadIPA_Switch_Gray_Out_Request_04(): Called!"));
        _pCallbackIf->onIPA_Switch_Gray_Out_Request_04Status(_tIPA_Switch_Gray_Out_Request_04);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadIPA_Switch_Gray_Out_Request_05()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadIPA_Switch_Gray_Out_Request_05(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

    if(/* CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_IPA_Switch_Gray_Out_Request_05,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead) */0)/** Jayashree:commented as it is aivi-relavant **/
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

    if(_tIPA_Switch_Gray_Out_Request_05.u32Status != u32StatusRead) {
        _tIPA_Switch_Gray_Out_Request_05.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	
	//CID: 172304


    // if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        // if(memcmp(&_tIPA_Switch_Gray_Out_Request_05.IPA_Switch_Gray_Out_Request_05, &au8Data_ReadBuffer[0], 1) != 0) {
            // memcpy(&_tIPA_Switch_Gray_Out_Request_05.IPA_Switch_Gray_Out_Request_05, &au8Data_ReadBuffer[0], 1);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadIPA_Switch_Gray_Out_Request_05(): Called!"));
        _pCallbackIf->onIPA_Switch_Gray_Out_Request_05Status(_tIPA_Switch_Gray_Out_Request_05);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadIPA_Switch_Gray_Out_Request_06()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadIPA_Switch_Gray_Out_Request_06(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

    if(/* CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_IPA_Switch_Gray_Out_Request_06,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead) */0)/** Jayashree:commented as it is aivi-relavant **/
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

    if(_tIPA_Switch_Gray_Out_Request_06.u32Status != u32StatusRead) {
        _tIPA_Switch_Gray_Out_Request_06.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

	//CID: 172359

    // if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        // if(memcmp(&_tIPA_Switch_Gray_Out_Request_06.IPA_Switch_Gray_Out_Request_06, &au8Data_ReadBuffer[0], 1) != 0) {
            // memcpy(&_tIPA_Switch_Gray_Out_Request_06.IPA_Switch_Gray_Out_Request_06, &au8Data_ReadBuffer[0], 1);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadIPA_Switch_Gray_Out_Request_06(): Called!"));
        _pCallbackIf->onIPA_Switch_Gray_Out_Request_06Status(_tIPA_Switch_Gray_Out_Request_06);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadIPA_mode_selection()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadIPA_mode_selection(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

    if(/* CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_IPA_mode_selection,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead) */0)/** Jayashree:commented as it is aivi-relavant **/
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

    if(_tIPA_mode_selection.u32Status != u32StatusRead) {
        _tIPA_mode_selection.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

	//CID: 172361

    // if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        // if(memcmp(&_tIPA_mode_selection.IPA_mode_selection, &au8Data_ReadBuffer[0], 1) != 0) {
            // memcpy(&_tIPA_mode_selection.IPA_mode_selection, &au8Data_ReadBuffer[0], 1);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadIPA_mode_selection(): Called!"));
        _pCallbackIf->onIPA_mode_selectionStatus(_tIPA_mode_selection);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadIPA_Message_Display_Request()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadIPA_Message_Display_Request(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

    if(/* CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_IPA_Message_Display_Request,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead) */0)/** Jayashree:commented as it is aivi-relavant **/
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

    if(_tIPA_Message_Display_Request.u32Status != u32StatusRead) {
        _tIPA_Message_Display_Request.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

	//CID: 172305

    // if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        // if(memcmp(&_tIPA_Message_Display_Request.IPA_Message_Display_Request, &au8Data_ReadBuffer[0], 1) != 0) {
            // memcpy(&_tIPA_Message_Display_Request.IPA_Message_Display_Request, &au8Data_ReadBuffer[0], 1);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadIPA_Message_Display_Request(): Called!"));
        _pCallbackIf->onIPA_Message_Display_RequestStatus(_tIPA_Message_Display_Request);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadIPA_Sound_Output_Request()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadIPA_Sound_Output_Request(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

    if(/* CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_IPA_Sound_Output_Request,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead) */0)/** Jayashree:commented as it is aivi-relavant **/
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

    if(_tIPA_Sound_Output_Request.u32Status != u32StatusRead) {
        _tIPA_Sound_Output_Request.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	//CID: 172313


    // if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        // if(memcmp(&_tIPA_Sound_Output_Request.IPA_Sound_Output_Request, &au8Data_ReadBuffer[0], 1) != 0) {
            // memcpy(&_tIPA_Sound_Output_Request.IPA_Sound_Output_Request, &au8Data_ReadBuffer[0], 1);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadIPA_Sound_Output_Request(): Called!"));
        _pCallbackIf->onIPA_Sound_Output_RequestStatus(_tIPA_Sound_Output_Request);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadIPA_Voice_Output_Request()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadIPA_Voice_Output_Request(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

    if(/* CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_IPA_Voice_Output_Request,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead) */0)/** Jayashree:commented as it is aivi-relavant **/
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

    if(_tIPA_Voice_Output_Request.u32Status != u32StatusRead) {
        _tIPA_Voice_Output_Request.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
//CID: 172302

    // if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        // if(memcmp(&_tIPA_Voice_Output_Request.IPA_Voice_Output_Request, &au8Data_ReadBuffer[0], 1) != 0) {
            // memcpy(&_tIPA_Voice_Output_Request.IPA_Voice_Output_Request, &au8Data_ReadBuffer[0], 1);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadIPA_Voice_Output_Request(): Called!"));
        _pCallbackIf->onIPA_Voice_Output_RequestStatus(_tIPA_Voice_Output_Request);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadIPA_region_selection()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadIPA_region_selection(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

    if(/* CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_IPA_region_selection,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead) */0)/** Jayashree:commented as it is aivi-relavant **/
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

    if(_tIPA_region_selection.u32Status != u32StatusRead) {
        _tIPA_region_selection.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

	//CID : 172336

    // if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        // if(memcmp(&_tIPA_region_selection.IPA_region_selection, &au8Data_ReadBuffer[0], 1) != 0) {
            // memcpy(&_tIPA_region_selection.IPA_region_selection, &au8Data_ReadBuffer[0], 1);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadIPA_region_selection(): Called!"));
        _pCallbackIf->onIPA_region_selectionStatus(_tIPA_region_selection);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadIPA_Camera_Indicator_Request()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadIPA_Camera_Indicator_Request(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

    if(/* CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_IPA_Camera_Indicator_Request,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead) */0)/** Jayashree:commented as it is aivi-relavant **/
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

    if(_tIPA_Camera_Indicator_Request.u32Status != u32StatusRead) {
        _tIPA_Camera_Indicator_Request.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	//CID: 172301


    // if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        // if(memcmp(&_tIPA_Camera_Indicator_Request.IPA_Camera_Indicator_Request, &au8Data_ReadBuffer[0], 1) != 0) {
            // memcpy(&_tIPA_Camera_Indicator_Request.IPA_Camera_Indicator_Request, &au8Data_ReadBuffer[0], 1);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadIPA_Camera_Indicator_Request(): Called!"));
        _pCallbackIf->onIPA_Camera_Indicator_RequestStatus(_tIPA_Camera_Indicator_Request);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadIPA_Mulfunction()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadIPA_Mulfunction(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

    if(/* CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_IPA_Mulfunction,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead) */0)/** Jayashree:commented as it is aivi-relavant **/
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

    if(_tIPA_Mulfunction.u32Status != u32StatusRead) {
        _tIPA_Mulfunction.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

	//CID: 172385

    // if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        // if(memcmp(&_tIPA_Mulfunction.IPA_Mulfunction, &au8Data_ReadBuffer[0], 1) != 0) {
            // memcpy(&_tIPA_Mulfunction.IPA_Mulfunction, &au8Data_ReadBuffer[0], 1);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadIPA_Mulfunction(): Called!"));
        _pCallbackIf->onIPA_MulfunctionStatus(_tIPA_Mulfunction);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadRearGearEngaged()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadRearGearEngaged(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;
#ifdef VARIANT_S_FTR_ENABLE_SMART
 if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_RearGearEngaged_MM_GW_RearCamInfo,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead))
#else
    if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_RearCamReq_SystemEnvironment,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead))
		#endif
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }
	ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadRearGearEngaged(): u32StatusRead is %d",u32StatusRead));
    if(_tRearGearEngaged.u32Status != u32StatusRead) {
        _tRearGearEngaged.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

    if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tRearGearEngaged.RearGearEngaged, &au8Data_ReadBuffer[0], 1) != 0) {
            memcpy(&_tRearGearEngaged.RearGearEngaged, &au8Data_ReadBuffer[0], 1);
            bChanged = TRUE;
        }
    }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadRearGearEngaged(): Called!"));
        _pCallbackIf->onRearGearEngagedStatus(_tRearGearEngaged);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadMVC_ViewModeStatus()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadMVC_ViewModeStatus(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;
	

    if(/* CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_MVC_ViewModeStatus,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead) */0)/** Jayashree:commented as it is aivi-relavant **/
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

    if(_tMVC_ViewModeStatus.u32Status != u32StatusRead) {
        _tMVC_ViewModeStatus.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	// CID: 172387

    // if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        // if(memcmp(&_tMVC_ViewModeStatus.MVC_ViewModeStatus, &au8Data_ReadBuffer[0], 1) != 0) {
            // memcpy(&_tMVC_ViewModeStatus.MVC_ViewModeStatus, &au8Data_ReadBuffer[0], 1);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadMVC_ViewModeStatus(): Called!"));
        _pCallbackIf->onMVC_ViewModeStatusStatus(_tMVC_ViewModeStatus);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadMVC_WarningDisplayRequest()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadMVC_WarningDisplayRequest(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

    if(/* CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_MVC_WarningDisplayRequest,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead) */0)/** Jayashree:commented as it is aivi-relavant **/
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

    if(_tMVC_WarningDisplayRequest.u32Status != u32StatusRead) {
        _tMVC_WarningDisplayRequest.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

//CID: 172303

    // if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        // if(memcmp(&_tMVC_WarningDisplayRequest.MVC_WarningDisplayRequest, &au8Data_ReadBuffer[0], 1) != 0) {
            // memcpy(&_tMVC_WarningDisplayRequest.MVC_WarningDisplayRequest, &au8Data_ReadBuffer[0], 1);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadMVC_WarningDisplayRequest(): Called!"));
        _pCallbackIf->onMVC_WarningDisplayRequestStatus(_tMVC_WarningDisplayRequest);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadTailGateStatus()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadTailGateStatus(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

    if(/* CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_TailGateStatus,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead) */0)/** Jayashree:commented as it is aivi-relavant **/
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

    if(_tTailGateStatus.u32Status != u32StatusRead) {
        _tTailGateStatus.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
//CID:172384
    // if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        // if(memcmp(&_tTailGateStatus.TailGateStatus, &au8Data_ReadBuffer[0], 1) != 0) {
            // memcpy(&_tTailGateStatus.TailGateStatus, &au8Data_ReadBuffer[0], 1);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadTailGateStatus(): Called!"));
        _pCallbackIf->onTailGateStatusStatus(_tTailGateStatus);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadAVM_ChangeViewStatus()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadAVM_ChangeViewStatus(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

    if(/* CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_AVM_ChangeViewStatus,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead) */0)/** Jayashree:commented as it is aivi-relavant **/
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

    if(_tAVM_ChangeViewStatus.u32Status != u32StatusRead) {
        _tAVM_ChangeViewStatus.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

	//CID: 172377

    // if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        // if(memcmp(&_tAVM_ChangeViewStatus.AVM_ChangeViewStatus, &au8Data_ReadBuffer[0], 1) != 0) {
            // memcpy(&_tAVM_ChangeViewStatus.AVM_ChangeViewStatus, &au8Data_ReadBuffer[0], 1);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadAVM_ChangeViewStatus(): Called!"));
        _pCallbackIf->onAVM_ChangeViewStatusStatus(_tAVM_ChangeViewStatus);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadAVM_ClosingAuthorization()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadAVM_ClosingAuthorization(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

    if(/* CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_AVM_ClosingAuthorization,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead) */0)/** Jayashree:commented as it is aivi-relavant **/
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

    if(_tAVM_ClosingAuthorization.u32Status != u32StatusRead) {
        _tAVM_ClosingAuthorization.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

//CID: 172320

    // if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        // if(memcmp(&_tAVM_ClosingAuthorization.AVM_ClosingAuthorization, &au8Data_ReadBuffer[0], 1) != 0) {
            // memcpy(&_tAVM_ClosingAuthorization.AVM_ClosingAuthorization, &au8Data_ReadBuffer[0], 1);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadAVM_ClosingAuthorization(): Called!"));
        _pCallbackIf->onAVM_ClosingAuthorizationStatus(_tAVM_ClosingAuthorization);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadMOD_ActivationState()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadMOD_ActivationState(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

    /*if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_MOD_ActivationState,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }*/

    if(_tMOD_ActivationState.u32Status != u32StatusRead) {
        _tMOD_ActivationState.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

	//CID: 172355

    // if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        // if(memcmp(&_tMOD_ActivationState.MOD_ActivationState, &au8Data_ReadBuffer[0], 1) != 0) {
            // memcpy(&_tMOD_ActivationState.MOD_ActivationState, &au8Data_ReadBuffer[0], 1);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadMOD_ActivationState(): Called!"));
        _pCallbackIf->onMOD_ActivationStateStatus(_tMOD_ActivationState);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadFAP_ModeChangeRequest()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadFAP_ModeChangeRequest(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

    if(/* CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_FAP_ModeChangeRequest,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead) */0)/** Jayashree:commented as it is aivi-relavant **/
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

    if(_tFAP_ModeChangeRequest.u32Status != u32StatusRead) {
        _tFAP_ModeChangeRequest.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

	//CID: 172346

    // if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        // if(memcmp(&_tFAP_ModeChangeRequest.FAP_ModeChangeRequest, &au8Data_ReadBuffer[0], 1) != 0) {
            // memcpy(&_tFAP_ModeChangeRequest.FAP_ModeChangeRequest, &au8Data_ReadBuffer[0], 1);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadFAP_ModeChangeRequest(): Called!"));
        _pCallbackIf->onFAP_ModeChangeRequestStatus(_tFAP_ModeChangeRequest);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadCamerasetting_availability()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadCamerasetting_availability(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

    if(/* CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_Camerasetting_availability,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead) */0)/** Jayashree:commented as it is aivi-relavant **/
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

    if(_tCamerasetting_availability.u32Status != u32StatusRead) {
        _tCamerasetting_availability.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

//CID: 172299

    // if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        // if(memcmp(&_tCamerasetting_availability.Camerasetting_availability, &au8Data_ReadBuffer[0], 1) != 0) {
            // memcpy(&_tCamerasetting_availability.Camerasetting_availability, &au8Data_ReadBuffer[0], 1);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadCamerasetting_availability(): Called!"));
        _pCallbackIf->onCamerasetting_availabilityStatus(_tCamerasetting_availability);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadFAP_Setting01()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadFAP_Setting01(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

    if(/* CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_FAP_Setting01,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead) */0)/** Jayashree:commented as it is aivi-relavant **/
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

    if(_tFAP_Setting01.u32Status != u32StatusRead) {
        _tFAP_Setting01.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

	//CID: 172344

    // if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        // if(memcmp(&_tFAP_Setting01.FAP_Setting01, &au8Data_ReadBuffer[0], 1) != 0) {
            // memcpy(&_tFAP_Setting01.FAP_Setting01, &au8Data_ReadBuffer[0], 1);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadFAP_Setting01(): Called!"));
        _pCallbackIf->onFAP_Setting01Status(_tFAP_Setting01);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadFAP_Setting02()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadFAP_Setting02(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

    if(/* CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_FAP_Setting02,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead) */0)/** Jayashree:commented as it is aivi-relavant **/
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

    if(_tFAP_Setting02.u32Status != u32StatusRead) {
        _tFAP_Setting02.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

//CID: 172388

    // if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        // if(memcmp(&_tFAP_Setting02.FAP_Setting02, &au8Data_ReadBuffer[0], 1) != 0) {
            // memcpy(&_tFAP_Setting02.FAP_Setting02, &au8Data_ReadBuffer[0], 1);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadFAP_Setting02(): Called!"));
        _pCallbackIf->onFAP_Setting02Status(_tFAP_Setting02);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadFAP_Setting03()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadFAP_Setting03(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

    if(/* CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_FAP_Setting03,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead) */0)/** Jayashree:commented as it is aivi-relavant **/
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

    if(_tFAP_Setting03.u32Status != u32StatusRead) {
        _tFAP_Setting03.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

	//CID: 172386

    // if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        // if(memcmp(&_tFAP_Setting03.FAP_Setting03, &au8Data_ReadBuffer[0], 1) != 0) {
            // memcpy(&_tFAP_Setting03.FAP_Setting03, &au8Data_ReadBuffer[0], 1);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadFAP_Setting03(): Called!"));
        _pCallbackIf->onFAP_Setting03Status(_tFAP_Setting03);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadFAP_Setting04()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadFAP_Setting04(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

    if(/* CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_FAP_Setting04,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead) */0)/** Jayashree:commented as it is aivi-relavant **/
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

    if(_tFAP_Setting04.u32Status != u32StatusRead) {
        _tFAP_Setting04.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

	//CID: 172347

    // if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        // if(memcmp(&_tFAP_Setting04.FAP_Setting04, &au8Data_ReadBuffer[0], 1) != 0) {
            // memcpy(&_tFAP_Setting04.FAP_Setting04, &au8Data_ReadBuffer[0], 1);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadFAP_Setting04(): Called!"));
        _pCallbackIf->onFAP_Setting04Status(_tFAP_Setting04);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadFAP_Setting05()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadFAP_Setting05(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

    if(/* CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_FAP_Setting05,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead) */0)/** Jayashree:commented as it is aivi-relavant **/
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

    if(_tFAP_Setting05.u32Status != u32StatusRead) {
        _tFAP_Setting05.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

	//CID: 172383

    // if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        // if(memcmp(&_tFAP_Setting05.FAP_Setting05, &au8Data_ReadBuffer[0], 1) != 0) {
            // memcpy(&_tFAP_Setting05.FAP_Setting05, &au8Data_ReadBuffer[0], 1);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadFAP_Setting05(): Called!"));
        _pCallbackIf->onFAP_Setting05Status(_tFAP_Setting05);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadFAP_Setting06()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadFAP_Setting06(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

    if(/* CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_FAP_Setting06,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead) */0)/** Jayashree:commented as it is aivi-relavant **/
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

    if(_tFAP_Setting06.u32Status != u32StatusRead) {
        _tFAP_Setting06.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

//CID: 172333

    // if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        // if(memcmp(&_tFAP_Setting06.FAP_Setting06, &au8Data_ReadBuffer[0], 1) != 0) {
            // memcpy(&_tFAP_Setting06.FAP_Setting06, &au8Data_ReadBuffer[0], 1);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadFAP_Setting06(): Called!"));
        _pCallbackIf->onFAP_Setting06Status(_tFAP_Setting06);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadFAP_Setting07()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadFAP_Setting07(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

    if(/* CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_FAP_Setting07,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead) */0)/** Jayashree:commented as it is aivi-relavant **/
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

    if(_tFAP_Setting07.u32Status != u32StatusRead) {
        _tFAP_Setting07.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	//CID: 172332


    // if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        // if(memcmp(&_tFAP_Setting07.FAP_Setting07, &au8Data_ReadBuffer[0], 1) != 0) {
            // memcpy(&_tFAP_Setting07.FAP_Setting07, &au8Data_ReadBuffer[0], 1);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadFAP_Setting07(): Called!"));
        _pCallbackIf->onFAP_Setting07Status(_tFAP_Setting07);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadFAP_Setting08()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadFAP_Setting08(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

    if(/* CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_FAP_Setting08,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead) */0)/** Jayashree:commented as it is aivi-relavant **/
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

    if(_tFAP_Setting08.u32Status != u32StatusRead) {
        _tFAP_Setting08.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

	//CID: 172381

    // if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        // if(memcmp(&_tFAP_Setting08.FAP_Setting08, &au8Data_ReadBuffer[0], 1) != 0) {
            // memcpy(&_tFAP_Setting08.FAP_Setting08, &au8Data_ReadBuffer[0], 1);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadFAP_Setting08(): Called!"));
        _pCallbackIf->onFAP_Setting08Status(_tFAP_Setting08);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadFAP_Setting09()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadFAP_Setting09(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

    if(/* CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_FAP_Setting09,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead) */0)/** Jayashree:commented as it is aivi-relavant **/
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

    if(_tFAP_Setting09.u32Status != u32StatusRead) {
        _tFAP_Setting09.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

	//CID:172372

    // if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        // if(memcmp(&_tFAP_Setting09.FAP_Setting09, &au8Data_ReadBuffer[0], 1) != 0) {
            // memcpy(&_tFAP_Setting09.FAP_Setting09, &au8Data_ReadBuffer[0], 1);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadFAP_Setting09(): Called!"));
        _pCallbackIf->onFAP_Setting09Status(_tFAP_Setting09);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadFAP_Setting10()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadFAP_Setting10(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

    if(/* CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_FAP_Setting10,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead) */0)/** Jayashree:commented as it is aivi-relavant **/
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

    if(_tFAP_Setting10.u32Status != u32StatusRead) {
        _tFAP_Setting10.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

	//CID: 172358

    // if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        // if(memcmp(&_tFAP_Setting10.FAP_Setting10, &au8Data_ReadBuffer[0], 1) != 0) {
            // memcpy(&_tFAP_Setting10.FAP_Setting10, &au8Data_ReadBuffer[0], 1);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadFAP_Setting10(): Called!"));
        _pCallbackIf->onFAP_Setting10Status(_tFAP_Setting10);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadAVM_Setting_1()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadAVM_Setting_1(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

    if(/* CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_AVM_Setting_1,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead) */0)/** Jayashree:commented as it is aivi-relavant **/
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

    if(_tAVM_Setting_1.u32Status != u32StatusRead) {
        _tAVM_Setting_1.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

	//CID: 172379

    // if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        // if(memcmp(&_tAVM_Setting_1.AVM_Setting_1, &au8Data_ReadBuffer[0], 1) != 0) {
            // memcpy(&_tAVM_Setting_1.AVM_Setting_1, &au8Data_ReadBuffer[0], 1);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadAVM_Setting_1(): Called!"));
        _pCallbackIf->onAVM_Setting_1Status(_tAVM_Setting_1);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadAVM_Setting_2()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadAVM_Setting_2(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

    if(/* CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_AVM_Setting_2,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead) */0)/** Jayashree:commented as it is aivi-relavant **/
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

    if(_tAVM_Setting_2.u32Status != u32StatusRead) {
        _tAVM_Setting_2.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	// CID: 172335

    // if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        // if(memcmp(&_tAVM_Setting_2.AVM_Setting_2, &au8Data_ReadBuffer[0], 1) != 0) {
            // memcpy(&_tAVM_Setting_2.AVM_Setting_2, &au8Data_ReadBuffer[0], 1);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadAVM_Setting_2(): Called!"));
        _pCallbackIf->onAVM_Setting_2Status(_tAVM_Setting_2);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadAVM_Setting_3()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadAVM_Setting_3(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

    if(/* CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_AVM_Setting_3,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead) */0)/** Jayashree:commented as it is aivi-relavant **/
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

    if(_tAVM_Setting_3.u32Status != u32StatusRead) {
        _tAVM_Setting_3.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

//CID: 172329

    // if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        // if(memcmp(&_tAVM_Setting_3.AVM_Setting_3, &au8Data_ReadBuffer[0], 1) != 0) {
            // memcpy(&_tAVM_Setting_3.AVM_Setting_3, &au8Data_ReadBuffer[0], 1);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadAVM_Setting_3(): Called!"));
        _pCallbackIf->onAVM_Setting_3Status(_tAVM_Setting_3);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadAVM_Setting_4()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadAVM_Setting_4(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

    if(/* CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_AVM_Setting_4,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead) */0)/** Jayashree:commented as it is aivi-relavant **/
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

    if(_tAVM_Setting_4.u32Status != u32StatusRead) {
        _tAVM_Setting_4.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

	//CID: 172353

    // if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        // if(memcmp(&_tAVM_Setting_4.AVM_Setting_4, &au8Data_ReadBuffer[0], 1) != 0) {
            // memcpy(&_tAVM_Setting_4.AVM_Setting_4, &au8Data_ReadBuffer[0], 1);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadAVM_Setting_4(): Called!"));
        _pCallbackIf->onAVM_Setting_4Status(_tAVM_Setting_4);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadAVM_Setting_5()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadAVM_Setting_5(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

    if(/* CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_AVM_Setting_5,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead) */0)/** Jayashree:commented as it is aivi-relavant **/
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

    if(_tAVM_Setting_5.u32Status != u32StatusRead) {
        _tAVM_Setting_5.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	//CID: 172380

    // if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        // if(memcmp(&_tAVM_Setting_5.AVM_Setting_5, &au8Data_ReadBuffer[0], 1) != 0) {
            // memcpy(&_tAVM_Setting_5.AVM_Setting_5, &au8Data_ReadBuffer[0], 1);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadAVM_Setting_5(): Called!"));
        _pCallbackIf->onAVM_Setting_5Status(_tAVM_Setting_5);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadAVM_Setting_6()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadAVM_Setting_6(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

    if(/* CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_AVM_Setting_6,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead) */0)/** Jayashree:commented as it is aivi-relavant **/
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

    if(_tAVM_Setting_6.u32Status != u32StatusRead) {
        _tAVM_Setting_6.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	
	
	//CID: 172369

    // if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        // if(memcmp(&_tAVM_Setting_6.AVM_Setting_6, &au8Data_ReadBuffer[0], 1) != 0) {
            // memcpy(&_tAVM_Setting_6.AVM_Setting_6, &au8Data_ReadBuffer[0], 1);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadAVM_Setting_6(): Called!"));
        _pCallbackIf->onAVM_Setting_6Status(_tAVM_Setting_6);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadAVM_Setting_7()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadAVM_Setting_7(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

    if(/* CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_AVM_Setting_7,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead) */0)/** Jayashree:commented as it is aivi-relavant **/
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

    if(_tAVM_Setting_7.u32Status != u32StatusRead) {
        _tAVM_Setting_7.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

	//CID: 172357

    // if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        // if(memcmp(&_tAVM_Setting_7.AVM_Setting_7, &au8Data_ReadBuffer[0], 1) != 0) {
            // memcpy(&_tAVM_Setting_7.AVM_Setting_7, &au8Data_ReadBuffer[0], 1);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadAVM_Setting_7(): Called!"));
        _pCallbackIf->onAVM_Setting_7Status(_tAVM_Setting_7);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadAVM_Setting_8()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadAVM_Setting_8(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

    if(/* CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_AVM_Setting_8,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead) */0)/** Jayashree:commented as it is aivi-relavant **/
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

    if(_tAVM_Setting_8.u32Status != u32StatusRead) {
        _tAVM_Setting_8.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

	//CID: 172356

    // if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        // if(memcmp(&_tAVM_Setting_8.AVM_Setting_8, &au8Data_ReadBuffer[0], 1) != 0) {
            // memcpy(&_tAVM_Setting_8.AVM_Setting_8, &au8Data_ReadBuffer[0], 1);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadAVM_Setting_8(): Called!"));
        _pCallbackIf->onAVM_Setting_8Status(_tAVM_Setting_8);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadAVM_Setting_9()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadAVM_Setting_9(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

    if(/* CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_AVM_Setting_9,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead) */0)/** Jayashree:commented as it is aivi-relavant **/
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

    if(_tAVM_Setting_9.u32Status != u32StatusRead) {
        _tAVM_Setting_9.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

	//CID: 172351

    // if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        // if(memcmp(&_tAVM_Setting_9.AVM_Setting_9, &au8Data_ReadBuffer[0], 1) != 0) {
            // memcpy(&_tAVM_Setting_9.AVM_Setting_9, &au8Data_ReadBuffer[0], 1);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadAVM_Setting_9(): Called!"));
        _pCallbackIf->onAVM_Setting_9Status(_tAVM_Setting_9);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadFAP_PurposeSwitchAvailability()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadFAP_PurposeSwitchAvailability(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

    if(/* CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_FAP_PurposeSwitchAvailability,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead) */0)/** Jayashree:commented as it is aivi-relavant **/
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

    if(_tFAP_PurposeSwitchAvailability.u32Status != u32StatusRead) {
        _tFAP_PurposeSwitchAvailability.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
//CID: 172286

    // if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        // if(memcmp(&_tFAP_PurposeSwitchAvailability.FAP_PurposeSwitchAvailability, &au8Data_ReadBuffer[0], 1) != 0) {
            // memcpy(&_tFAP_PurposeSwitchAvailability.FAP_PurposeSwitchAvailability, &au8Data_ReadBuffer[0], 1);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadFAP_PurposeSwitchAvailability(): Called!"));
        _pCallbackIf->onFAP_PurposeSwitchAvailabilityStatus(_tFAP_PurposeSwitchAvailability);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadFAP_ChangeViewRequest()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadFAP_ChangeViewRequest(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

    if(/* CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_FAP_ChangeViewRequest,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead) */0)/** Jayashree:commented as it is aivi-relavant **/
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

    if(_tFAP_ChangeViewRequest.u32Status != u32StatusRead) {
        _tFAP_ChangeViewRequest.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

	//CID :172364

    // if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        // if(memcmp(&_tFAP_ChangeViewRequest.FAP_ChangeViewRequest, &au8Data_ReadBuffer[0], 1) != 0) {
            // memcpy(&_tFAP_ChangeViewRequest.FAP_ChangeViewRequest, &au8Data_ReadBuffer[0], 1);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadFAP_ChangeViewRequest(): Called!"));
        _pCallbackIf->onFAP_ChangeViewRequestStatus(_tFAP_ChangeViewRequest);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadFAP_SoundDirection()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadFAP_SoundDirection(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

    if(/* CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_FAP_SoundDirection,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead) */0)/** Jayashree:commented as it is aivi-relavant **/
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

    if(_tFAP_SoundDirection.u32Status != u32StatusRead) {
        _tFAP_SoundDirection.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

//CID: 172327

    // if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        // if(memcmp(&_tFAP_SoundDirection.FAP_SoundDirection, &au8Data_ReadBuffer[0], 1) != 0) {
            // memcpy(&_tFAP_SoundDirection.FAP_SoundDirection, &au8Data_ReadBuffer[0], 1);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadFAP_SoundDirection(): Called!"));
        _pCallbackIf->onFAP_SoundDirectionStatus(_tFAP_SoundDirection);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadFAP_SoundLevelControl()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadFAP_SoundLevelControl(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

    if(/* CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_FAP_SoundLevelControl,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead) */0)/** Jayashree:commented as it is aivi-relavant **/
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

    if(_tFAP_SoundLevelControl.u32Status != u32StatusRead) {
        _tFAP_SoundLevelControl.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	
	//CID: 172331

    // if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        // if(memcmp(&_tFAP_SoundLevelControl.FAP_SoundLevelControl, &au8Data_ReadBuffer[0], 1) != 0) {
            // memcpy(&_tFAP_SoundLevelControl.FAP_SoundLevelControl, &au8Data_ReadBuffer[0], 1);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadFAP_SoundLevelControl(): Called!"));
        _pCallbackIf->onFAP_SoundLevelControlStatus(_tFAP_SoundLevelControl);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadFAP_SoundPatternRequest()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadFAP_SoundPatternRequest(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

    if(/* CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_FAP_SoundPatternRequest,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead) */0)/** Jayashree:commented as it is aivi-relavant **/
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

    if(_tFAP_SoundPatternRequest.u32Status != u32StatusRead) {
        _tFAP_SoundPatternRequest.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

	//CID: 172371

    // if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        // if(memcmp(&_tFAP_SoundPatternRequest.FAP_SoundPatternRequest, &au8Data_ReadBuffer[0], 1) != 0) {
            // memcpy(&_tFAP_SoundPatternRequest.FAP_SoundPatternRequest, &au8Data_ReadBuffer[0], 1);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadFAP_SoundPatternRequest(): Called!"));
        _pCallbackIf->onFAP_SoundPatternRequestStatus(_tFAP_SoundPatternRequest);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadFAP_VoicePatternRequest()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadFAP_VoicePatternRequest(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

    if(/* CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_FAP_VoicePatternRequest,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead) */0)/** Jayashree:commented as it is aivi-relavant **/
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

    if(_tFAP_VoicePatternRequest.u32Status != u32StatusRead) {
        _tFAP_VoicePatternRequest.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

//CID: 172334

    // if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        // if(memcmp(&_tFAP_VoicePatternRequest.FAP_VoicePatternRequest, &au8Data_ReadBuffer[0], 1) != 0) {
            // memcpy(&_tFAP_VoicePatternRequest.FAP_VoicePatternRequest, &au8Data_ReadBuffer[0], 1);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadFAP_VoicePatternRequest(): Called!"));
        _pCallbackIf->onFAP_VoicePatternRequestStatus(_tFAP_VoicePatternRequest);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadDayRheostatedLightMaxPercent()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadDayRheostatedLightMaxPercent(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

    if(/* CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_DayRheostatedLightMaxPercent,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead) */0)/** Jayashree:commented as it is aivi-relavant **/
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

    if(_tDayRheostatedLightMaxPercent.u32Status != u32StatusRead) {
        _tDayRheostatedLightMaxPercent.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

//CID: 172309

    // if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        // if(memcmp(&_tDayRheostatedLightMaxPercent.DayRheostatedLightMaxPercent, &au8Data_ReadBuffer[0], 1) != 0) {
            // memcpy(&_tDayRheostatedLightMaxPercent.DayRheostatedLightMaxPercent, &au8Data_ReadBuffer[0], 1);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadDayRheostatedLightMaxPercent(): Called!"));
        _pCallbackIf->onDayRheostatedLightMaxPercentStatus(_tDayRheostatedLightMaxPercent);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadNightRheostatedLightMaxPercent()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadNightRheostatedLightMaxPercent(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

    if(/* CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_NightRheostatedLightMaxPercent,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead) */0)/** Jayashree:commented as it is aivi-relavant **/
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

    if(_tNightRheostatedLightMaxPercent.u32Status != u32StatusRead) {
        _tNightRheostatedLightMaxPercent.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

	//CID: 172363

    // if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        // if(memcmp(&_tNightRheostatedLightMaxPercent.NightRheostatedLightMaxPercent, &au8Data_ReadBuffer[0], 1) != 0) {
            // memcpy(&_tNightRheostatedLightMaxPercent.NightRheostatedLightMaxPercent, &au8Data_ReadBuffer[0], 1);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadNightRheostatedLightMaxPercent(): Called!"));
        _pCallbackIf->onNightRheostatedLightMaxPercentStatus(_tNightRheostatedLightMaxPercent);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadDimmingState()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadDimmingState(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

  /*  if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_DimmingState,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }*/

    if(_tDimmingState.u32Status != u32StatusRead) {
        _tDimmingState.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

    // if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
         // if(memcmp(&_tDimmingState.DimmingState, &au8Data_ReadBuffer[0], 1) != 0) {
            // memcpy(&_tDimmingState.DimmingState, &au8Data_ReadBuffer[0], 1);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadDimmingState(): Called!"));
        _pCallbackIf->onDimmingStateStatus(_tDimmingState);
    }
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vReadSTATUS_DYNAMIC_REAR()
{
    DISPVIDCTRL_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadSTATUS_DYNAMIC_REAR(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

  /*  if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_STATUS_DYNAMIC_REAR,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }*/

    if(_tSTATUS_DYNAMIC_REAR.u32Status != u32StatusRead) {
        _tSTATUS_DYNAMIC_REAR.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

	//CID: 172341

    // if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        // if(memcmp(&_tSTATUS_DYNAMIC_REAR.STATUS_DYNAMIC_REAR, &au8Data_ReadBuffer[0], 1) != 0) {
            // memcpy(&_tSTATUS_DYNAMIC_REAR.STATUS_DYNAMIC_REAR, &au8Data_ReadBuffer[0], 1);
            // bChanged = TRUE;
        // }
    // }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("dispvidctrl_tclClientVcanCanAdaptor::vReadSTATUS_DYNAMIC_REAR(): Called!"));
        _pCallbackIf->onSTATUS_DYNAMIC_REARStatus(_tSTATUS_DYNAMIC_REAR);
    }
}

// dispvidctrl_tclClientVcanCanAdaptor::ClassImplementation: user specific code start
tVoid dispvidctrl_tclClientVcanCanAdaptor::vInvalidate_UPA_RX_Initializing(tVoid)
{
   _tUPA_RX_Initializing.u32Status = CSM_C_SIGNAL_DATA_INVALID;
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vInvalidate_UPA_View_Change_Request(tVoid)
{
   _tUPA_View_Change_Request.u32Status = CSM_C_SIGNAL_DATA_INVALID;
}
tVoid dispvidctrl_tclClientVcanCanAdaptor::vInvalidate_FAP_ChangeViewRequest(tVoid)
{
   _tFAP_ChangeViewRequest.u32Status = CSM_C_SIGNAL_DATA_INVALID;
}
// dispvidctrl_tclClientVcanCanAdaptor::ClassImplementation: user specific code end

//EOF
