/**
  * @swcomponent   Life Cycle Management
  * @{
  * @file          I_dispvidctrl_ClientVcanCanAdaptor.h
  * @PROJECT:      CMD project
  * @SW-COMPONENT: dispvidctrl
  * @Template:     IcsmAdaptor.h.tpl
  * ----------------------------------------------------------------------------
  *
  * @brief         generated file
  *                Csm adapter interface
  *
  *                Do here client specific implementation
  *                Changes possible only inside tags
  *
  *                //......................: user specific code start 
  *                //......................: user specific code end 
  *
  * ----------------------------------------------------------------------------
  * @copyright     (c) 2018 Robert Bosch GmbH.
  *                The reproduction, distribution and utilization of this file as well as the
  *                communication of its contents to others without express authorization is prohibited.
  *                Offenders will be held liable for the payment of damages.
  *                All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#ifndef _I_VCANCANADAPTOR_H_
#define _I_VCANCANADAPTOR_H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/
#define CSM_S_IMPORT_INTERFACE_GENERIC_USER
#ifdef VARIANT_S_FTR_ENABLE_SMART
#define CSM_C_PROJECT_USERSPACE_SMART_HU
#else
#define CSM_C_PROJECT_USERSPACE_INF4CV
#endif
#include "csm_if.h"




// I_dispvidctrl_tclClientVcanCanAdaptor::Include: user specific code start
// I_dispvidctrl_tclClientVcanCanAdaptor::Include: user specific code end

//include base class
#include "dispvidctrl_AppMain.h"

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
typedef struct  {
    tU32 u32Status;
    tU8   UPA_RX_Initializing;
}TUPA_RX_Initializing;
typedef struct  {
    tU32 u32Status;
    tU8   UPA_View_Change_Request;
}TUPA_View_Change_Request;
typedef struct  {
    tU32 u32Status;
    tU8   UPA_BEEP_Sound_Request;
}TUPA_BEEP_Sound_Request;
typedef struct  {
    tU32 u32Status;
    tU8   UPA_AOD_Beep1_Request;
}TUPA_AOD_Beep1_Request;
typedef struct  {
    tU32 u32Status;
    tU8   UPA_Setting_ITS;
}TUPA_Setting_ITS;
typedef struct  {
    tU32 u32Status;
    tU8   UPA_MOD_Status;
}TUPA_MOD_Status;
typedef struct  {
    tU32 u32Status;
    tU8   UPA_BEEP_Sound_Type;
}TUPA_BEEP_Sound_Type;
typedef struct  {
    tU32 u32Status;
    tU8   Steering_Angle[2];
}TSteering_Angle;
typedef struct  {
    tU32 u32Status;
    tU8   Calibration_Flag;
}TCalibration_Flag;
typedef struct  {
    tU32 u32Status;
    tU8   Steering_Sensor_Fail_Flag;
}TSteering_Sensor_Fail_Flag;
typedef struct  {
    tU32 u32Status;
    tU8   SwaSensorInternalStatus;
}TSwaSensorInternalStatus;
typedef struct  {
    tU32 u32Status;
    tU8   FRONT_STEER_PINION_ANGLE[2];
}TFRONT_STEER_PINION_ANGLE;
typedef struct  {
    tU32 u32Status;
    tU8   ACTIVE_STEER_FAIL;
}TACTIVE_STEER_FAIL;
typedef struct  {
    tU32 u32Status;
    tU8   VehicleSpeed[2];
}TVehicleSpeed;
typedef struct  {
    tU32 u32Status;
    tU8   IPA_Mode_Change_Request;
}TIPA_Mode_Change_Request;
typedef struct  {
    tU32 u32Status;
    tU8   IPA_Switch_Display_Request;
}TIPA_Switch_Display_Request;
typedef struct  {
    tU32 u32Status;
    tU8   IPA_Switch_mask_Request;
}TIPA_Switch_mask_Request;
typedef struct  {
    tU32 u32Status;
    tU8   IPA_Switch_Gray_Out_Request_01;
}TIPA_Switch_Gray_Out_Request_01;
typedef struct  {
    tU32 u32Status;
    tU8   IPA_Switch_Gray_Out_Request_02;
}TIPA_Switch_Gray_Out_Request_02;
typedef struct  {
    tU32 u32Status;
    tU8   IPA_Switch_Gray_Out_Request_03;
}TIPA_Switch_Gray_Out_Request_03;
typedef struct  {
    tU32 u32Status;
    tU8   IPA_Switch_Gray_Out_Request_04;
}TIPA_Switch_Gray_Out_Request_04;
typedef struct  {
    tU32 u32Status;
    tU8   IPA_Switch_Gray_Out_Request_05;
}TIPA_Switch_Gray_Out_Request_05;
typedef struct  {
    tU32 u32Status;
    tU8   IPA_Switch_Gray_Out_Request_06;
}TIPA_Switch_Gray_Out_Request_06;
typedef struct  {
    tU32 u32Status;
    tU8   IPA_mode_selection;
}TIPA_mode_selection;
typedef struct  {
    tU32 u32Status;
    tU8   IPA_Message_Display_Request;
}TIPA_Message_Display_Request;
typedef struct  {
    tU32 u32Status;
    tU8   IPA_Sound_Output_Request;
}TIPA_Sound_Output_Request;
typedef struct  {
    tU32 u32Status;
    tU8   IPA_Voice_Output_Request;
}TIPA_Voice_Output_Request;
typedef struct  {
    tU32 u32Status;
    tU8   IPA_region_selection;
}TIPA_region_selection;
typedef struct  {
    tU32 u32Status;
    tU8   IPA_Camera_Indicator_Request;
}TIPA_Camera_Indicator_Request;
typedef struct  {
    tU32 u32Status;
    tU8   IPA_Mulfunction;
}TIPA_Mulfunction;
typedef struct  {
    tU32 u32Status;
    tU8   RearGearEngaged;
}TRearGearEngaged;
typedef struct  {
    tU32 u32Status;
    tU8   MVC_ViewModeStatus;
}TMVC_ViewModeStatus;
typedef struct  {
    tU32 u32Status;
    tU8   MVC_WarningDisplayRequest;
}TMVC_WarningDisplayRequest;
typedef struct  {
    tU32 u32Status;
    tU8   TailGateStatus;
}TTailGateStatus;
typedef struct  {
    tU32 u32Status;
    tU8   AVM_ChangeViewStatus;
}TAVM_ChangeViewStatus;
typedef struct  {
    tU32 u32Status;
    tU8   AVM_ClosingAuthorization;
}TAVM_ClosingAuthorization;
typedef struct  {
    tU32 u32Status;
    tU8   MOD_ActivationState;
}TMOD_ActivationState;
typedef struct  {
    tU32 u32Status;
    tU8   FAP_ModeChangeRequest;
}TFAP_ModeChangeRequest;
typedef struct  {
    tU32 u32Status;
    tU8   Camerasetting_availability;
}TCamerasetting_availability;
typedef struct  {
    tU32 u32Status;
    tU8   FAP_Setting01;
}TFAP_Setting01;
typedef struct  {
    tU32 u32Status;
    tU8   FAP_Setting02;
}TFAP_Setting02;
typedef struct  {
    tU32 u32Status;
    tU8   FAP_Setting03;
}TFAP_Setting03;
typedef struct  {
    tU32 u32Status;
    tU8   FAP_Setting04;
}TFAP_Setting04;
typedef struct  {
    tU32 u32Status;
    tU8   FAP_Setting05;
}TFAP_Setting05;
typedef struct  {
    tU32 u32Status;
    tU8   FAP_Setting06;
}TFAP_Setting06;
typedef struct  {
    tU32 u32Status;
    tU8   FAP_Setting07;
}TFAP_Setting07;
typedef struct  {
    tU32 u32Status;
    tU8   FAP_Setting08;
}TFAP_Setting08;
typedef struct  {
    tU32 u32Status;
    tU8   FAP_Setting09;
}TFAP_Setting09;
typedef struct  {
    tU32 u32Status;
    tU8   FAP_Setting10;
}TFAP_Setting10;
typedef struct  {
    tU32 u32Status;
    tU8   AVM_Setting_1;
}TAVM_Setting_1;
typedef struct  {
    tU32 u32Status;
    tU8   AVM_Setting_2;
}TAVM_Setting_2;
typedef struct  {
    tU32 u32Status;
    tU8   AVM_Setting_3;
}TAVM_Setting_3;
typedef struct  {
    tU32 u32Status;
    tU8   AVM_Setting_4;
}TAVM_Setting_4;
typedef struct  {
    tU32 u32Status;
    tU8   AVM_Setting_5;
}TAVM_Setting_5;
typedef struct  {
    tU32 u32Status;
    tU8   AVM_Setting_6;
}TAVM_Setting_6;
typedef struct  {
    tU32 u32Status;
    tU8   AVM_Setting_7;
}TAVM_Setting_7;
typedef struct  {
    tU32 u32Status;
    tU8   AVM_Setting_8;
}TAVM_Setting_8;
typedef struct  {
    tU32 u32Status;
    tU8   AVM_Setting_9;
}TAVM_Setting_9;
typedef struct  {
    tU32 u32Status;
    tU8   FAP_PurposeSwitchAvailability;
}TFAP_PurposeSwitchAvailability;
typedef struct  {
    tU32 u32Status;
    tU8   FAP_ChangeViewRequest;
}TFAP_ChangeViewRequest;
typedef struct  {
    tU32 u32Status;
    tU8   FAP_SoundDirection;
}TFAP_SoundDirection;
typedef struct  {
    tU32 u32Status;
    tU8   FAP_SoundLevelControl;
}TFAP_SoundLevelControl;
typedef struct  {
    tU32 u32Status;
    tU8   FAP_SoundPatternRequest;
}TFAP_SoundPatternRequest;
typedef struct  {
    tU32 u32Status;
    tU8   FAP_VoicePatternRequest;
}TFAP_VoicePatternRequest;
typedef struct  {
    tU32 u32Status;
    tU8   DayRheostatedLightMaxPercent;
}TDayRheostatedLightMaxPercent;
typedef struct  {
    tU32 u32Status;
    tU8   NightRheostatedLightMaxPercent;
}TNightRheostatedLightMaxPercent;
typedef struct  {
    tU32 u32Status;
    tU8   DimmingState;
}TDimmingState;
typedef struct  {
    tU32 u32Status;
    tU8   STATUS_DYNAMIC_REAR;
}TSTATUS_DYNAMIC_REAR;

typedef struct  {
    tU8 u8TxType;
    tU8  UPA_TX_Initializing;
}TUPA_TX_Initializing;
typedef struct  {
    tU8 u8TxType;
    tU8  UPA_Camera_Switch_Press;
}TUPA_Camera_Switch_Press;
typedef struct  {
    tU8 u8TxType;
    tU8  UPA_Camera_Switch_Keep;
}TUPA_Camera_Switch_Keep;
typedef struct  {
    tU8 u8TxType;
    tU8  UPA_Camera_OFF_Request;
}TUPA_Camera_OFF_Request;
typedef struct  {
    tU8 u8TxType;
    tU8  UPA_Setting_Language_Request;
}TUPA_Setting_Language_Request;
typedef struct  {
    tU8 u8TxType;
    tU8  UPA_MOD_Switch_Press;
}TUPA_MOD_Switch_Press;
typedef struct  {
    tU8 u8TxType;
    tU8  IPA_Activation_flug;
}TIPA_Activation_flug;
typedef struct  {
    tU8 u8TxType;
    tU8  IPA_SW_Long_Press;
}TIPA_SW_Long_Press;
typedef struct  {
    tU8 u8TxType;
    tU8  IPA_SW_Operation_Status;
}TIPA_SW_Operation_Status;
typedef struct  {
    tU8 u8TxType;
    tU8  MVC_ViewModeRequest;
}TMVC_ViewModeRequest;
typedef struct  {
    tU8 u8TxType;
    tU8  FAP_SwitchOperationStatus;
}TFAP_SwitchOperationStatus;
typedef struct  {
    tU8 u8TxType;
    tU8  FAP_Screen_Activation_flag;
}TFAP_Screen_Activation_flag;
typedef struct  {
    tU8 u8TxType;
    tU8  FAP_ScreenPressCoordinateX;
}TFAP_ScreenPressCoordinateX;
typedef struct  {
    tU8 u8TxType;
    tU8  FAP_ScreenPressCoordinateY;
}TFAP_ScreenPressCoordinateY;
typedef struct  {
    tU8 u8TxType;
    tU8  FAP_ScreenPressDetected;
}TFAP_ScreenPressDetected;
typedef struct  {
    tU8 u8TxType;
    tU8  HorizontalDilutionOfPrecision;
}THorizontalDilutionOfPrecision;
typedef struct  {
    tU8 u8TxType;
    tU8  VerticalDilutionOfPrecision;
}TVerticalDilutionOfPrecision;
typedef struct  {
    tU8 u8TxType;
    tU8  SatNUM;
}TSatNUM;
typedef struct  {
    tU8 u8TxType;
    tU8  GroundSpeed;
}TGroundSpeed;
typedef struct  {
    tU8 u8TxType;
    tU8  SatelliteGPSCount;
}TSatelliteGPSCount;
typedef struct  {
    tU8 u8TxType;
    tU8  FAP_ActivationRequest;
}TFAP_ActivationRequest;
typedef struct  {
    tU8 u8TxType;
    tU8  SwitchRequest_AVM;
}TSwitchRequest_AVM;
typedef struct  {
    tU8 u8TxType;
    tU8  ChangeViewRequest_AVM;
}TChangeViewRequest_AVM;
typedef struct  {
    tU8 u8TxType;
    tU8  MOD_ActivationRequest2;
}TMOD_ActivationRequest2;
typedef struct  {
    tU8 u8TxType;
    tU8  DimmingReq;
}TDimmingReq;
typedef struct  {
    tU8 u8TxType;
    tU8  Driver_Assistance_SW_flag;
}TDriver_Assistance_SW_flag;


class CsmCallbackIF {
public:
    virtual ~CsmCallbackIF() {}
    virtual void onUPA_RX_InitializingStatus(TUPA_RX_Initializing tUPA_RX_Initializing) = 0;
    virtual void onUPA_View_Change_RequestStatus(TUPA_View_Change_Request tUPA_View_Change_Request) = 0;
    virtual void onUPA_BEEP_Sound_RequestStatus(TUPA_BEEP_Sound_Request tUPA_BEEP_Sound_Request) = 0;
    virtual void onUPA_AOD_Beep1_RequestStatus(TUPA_AOD_Beep1_Request tUPA_AOD_Beep1_Request) = 0;
    virtual void onUPA_Setting_ITSStatus(TUPA_Setting_ITS tUPA_Setting_ITS) = 0;
    virtual void onUPA_MOD_StatusStatus(TUPA_MOD_Status tUPA_MOD_Status) = 0;
    virtual void onUPA_BEEP_Sound_TypeStatus(TUPA_BEEP_Sound_Type tUPA_BEEP_Sound_Type) = 0;
    virtual void onSteering_AngleStatus(TSteering_Angle tSteering_Angle) = 0;
    virtual void onCalibration_FlagStatus(TCalibration_Flag tCalibration_Flag) = 0;
    virtual void onSteering_Sensor_Fail_FlagStatus(TSteering_Sensor_Fail_Flag tSteering_Sensor_Fail_Flag) = 0;
    virtual void onSwaSensorInternalStatusStatus(TSwaSensorInternalStatus tSwaSensorInternalStatus) = 0;
    virtual void onFRONT_STEER_PINION_ANGLEStatus(TFRONT_STEER_PINION_ANGLE tFRONT_STEER_PINION_ANGLE) = 0;
    virtual void onACTIVE_STEER_FAILStatus(TACTIVE_STEER_FAIL tACTIVE_STEER_FAIL) = 0;
    virtual void onVehicleSpeedStatus(TVehicleSpeed tVehicleSpeed) = 0;
    virtual void onIPA_Mode_Change_RequestStatus(TIPA_Mode_Change_Request tIPA_Mode_Change_Request) = 0;
    virtual void onIPA_Switch_Display_RequestStatus(TIPA_Switch_Display_Request tIPA_Switch_Display_Request) = 0;
    virtual void onIPA_Switch_mask_RequestStatus(TIPA_Switch_mask_Request tIPA_Switch_mask_Request) = 0;
    virtual void onIPA_Switch_Gray_Out_Request_01Status(TIPA_Switch_Gray_Out_Request_01 tIPA_Switch_Gray_Out_Request_01) = 0;
    virtual void onIPA_Switch_Gray_Out_Request_02Status(TIPA_Switch_Gray_Out_Request_02 tIPA_Switch_Gray_Out_Request_02) = 0;
    virtual void onIPA_Switch_Gray_Out_Request_03Status(TIPA_Switch_Gray_Out_Request_03 tIPA_Switch_Gray_Out_Request_03) = 0;
    virtual void onIPA_Switch_Gray_Out_Request_04Status(TIPA_Switch_Gray_Out_Request_04 tIPA_Switch_Gray_Out_Request_04) = 0;
    virtual void onIPA_Switch_Gray_Out_Request_05Status(TIPA_Switch_Gray_Out_Request_05 tIPA_Switch_Gray_Out_Request_05) = 0;
    virtual void onIPA_Switch_Gray_Out_Request_06Status(TIPA_Switch_Gray_Out_Request_06 tIPA_Switch_Gray_Out_Request_06) = 0;
    virtual void onIPA_mode_selectionStatus(TIPA_mode_selection tIPA_mode_selection) = 0;
    virtual void onIPA_Message_Display_RequestStatus(TIPA_Message_Display_Request tIPA_Message_Display_Request) = 0;
    virtual void onIPA_Sound_Output_RequestStatus(TIPA_Sound_Output_Request tIPA_Sound_Output_Request) = 0;
    virtual void onIPA_Voice_Output_RequestStatus(TIPA_Voice_Output_Request tIPA_Voice_Output_Request) = 0;
    virtual void onIPA_region_selectionStatus(TIPA_region_selection tIPA_region_selection) = 0;
    virtual void onIPA_Camera_Indicator_RequestStatus(TIPA_Camera_Indicator_Request tIPA_Camera_Indicator_Request) = 0;
    virtual void onIPA_MulfunctionStatus(TIPA_Mulfunction tIPA_Mulfunction) = 0;
    virtual void onRearGearEngagedStatus(TRearGearEngaged tRearGearEngaged) = 0;
    virtual void onMVC_ViewModeStatusStatus(TMVC_ViewModeStatus tMVC_ViewModeStatus) = 0;
    virtual void onMVC_WarningDisplayRequestStatus(TMVC_WarningDisplayRequest tMVC_WarningDisplayRequest) = 0;
    virtual void onTailGateStatusStatus(TTailGateStatus tTailGateStatus) = 0;
    virtual void onAVM_ChangeViewStatusStatus(TAVM_ChangeViewStatus tAVM_ChangeViewStatus) = 0;
    virtual void onAVM_ClosingAuthorizationStatus(TAVM_ClosingAuthorization tAVM_ClosingAuthorization) = 0;
    virtual void onMOD_ActivationStateStatus(TMOD_ActivationState tMOD_ActivationState) = 0;
    virtual void onFAP_ModeChangeRequestStatus(TFAP_ModeChangeRequest tFAP_ModeChangeRequest) = 0;
    virtual void onCamerasetting_availabilityStatus(TCamerasetting_availability tCamerasetting_availability) = 0;
    virtual void onFAP_Setting01Status(TFAP_Setting01 tFAP_Setting01) = 0;
    virtual void onFAP_Setting02Status(TFAP_Setting02 tFAP_Setting02) = 0;
    virtual void onFAP_Setting03Status(TFAP_Setting03 tFAP_Setting03) = 0;
    virtual void onFAP_Setting04Status(TFAP_Setting04 tFAP_Setting04) = 0;
    virtual void onFAP_Setting05Status(TFAP_Setting05 tFAP_Setting05) = 0;
    virtual void onFAP_Setting06Status(TFAP_Setting06 tFAP_Setting06) = 0;
    virtual void onFAP_Setting07Status(TFAP_Setting07 tFAP_Setting07) = 0;
    virtual void onFAP_Setting08Status(TFAP_Setting08 tFAP_Setting08) = 0;
    virtual void onFAP_Setting09Status(TFAP_Setting09 tFAP_Setting09) = 0;
    virtual void onFAP_Setting10Status(TFAP_Setting10 tFAP_Setting10) = 0;
    virtual void onAVM_Setting_1Status(TAVM_Setting_1 tAVM_Setting_1) = 0;
    virtual void onAVM_Setting_2Status(TAVM_Setting_2 tAVM_Setting_2) = 0;
    virtual void onAVM_Setting_3Status(TAVM_Setting_3 tAVM_Setting_3) = 0;
    virtual void onAVM_Setting_4Status(TAVM_Setting_4 tAVM_Setting_4) = 0;
    virtual void onAVM_Setting_5Status(TAVM_Setting_5 tAVM_Setting_5) = 0;
    virtual void onAVM_Setting_6Status(TAVM_Setting_6 tAVM_Setting_6) = 0;
    virtual void onAVM_Setting_7Status(TAVM_Setting_7 tAVM_Setting_7) = 0;
    virtual void onAVM_Setting_8Status(TAVM_Setting_8 tAVM_Setting_8) = 0;
    virtual void onAVM_Setting_9Status(TAVM_Setting_9 tAVM_Setting_9) = 0;
    virtual void onFAP_PurposeSwitchAvailabilityStatus(TFAP_PurposeSwitchAvailability tFAP_PurposeSwitchAvailability) = 0;
    virtual void onFAP_ChangeViewRequestStatus(TFAP_ChangeViewRequest tFAP_ChangeViewRequest) = 0;
    virtual void onFAP_SoundDirectionStatus(TFAP_SoundDirection tFAP_SoundDirection) = 0;
    virtual void onFAP_SoundLevelControlStatus(TFAP_SoundLevelControl tFAP_SoundLevelControl) = 0;
    virtual void onFAP_SoundPatternRequestStatus(TFAP_SoundPatternRequest tFAP_SoundPatternRequest) = 0;
    virtual void onFAP_VoicePatternRequestStatus(TFAP_VoicePatternRequest tFAP_VoicePatternRequest) = 0;
    virtual void onDayRheostatedLightMaxPercentStatus(TDayRheostatedLightMaxPercent tDayRheostatedLightMaxPercent) = 0;
    virtual void onNightRheostatedLightMaxPercentStatus(TNightRheostatedLightMaxPercent tNightRheostatedLightMaxPercent) = 0;
    virtual void onDimmingStateStatus(TDimmingState tDimmingState) = 0;
    virtual void onSTATUS_DYNAMIC_REARStatus(TSTATUS_DYNAMIC_REAR tSTATUS_DYNAMIC_REAR) = 0;
};


class I_dispvidctrl_tclClientVcanCanAdaptor : public dispvidctrl_tclBaseIf
{
public:
    I_dispvidctrl_tclClientVcanCanAdaptor(dispvidctrl_tclAppMain* poMainAppl): dispvidctrl_tclBaseIf(poMainAppl) {;}
    virtual ~I_dispvidctrl_tclClientVcanCanAdaptor() {;}

    virtual const tChar* getIfName() const { return "I_dispvidctrl_tclClientVcanCanAdaptor"; };

    virtual tVoid vSendCsmBroadcastSignal(tU8* pabData, tU8 u8Len, tU32 u32CsmSignal, tU8 u8TxType) = 0;
    virtual tVoid vConnect() = 0;

    virtual tVoid vSetCallbackIf(CsmCallbackIF* poCallback) = 0;
    virtual tVoid vGetUPA_RX_Initializing(TUPA_RX_Initializing& tUPA_RX_Initializing) = 0;
    virtual tVoid vGetUPA_View_Change_Request(TUPA_View_Change_Request& tUPA_View_Change_Request) = 0;
    virtual tVoid vGetUPA_BEEP_Sound_Request(TUPA_BEEP_Sound_Request& tUPA_BEEP_Sound_Request) = 0;
    virtual tVoid vGetUPA_AOD_Beep1_Request(TUPA_AOD_Beep1_Request& tUPA_AOD_Beep1_Request) = 0;
    virtual tVoid vGetUPA_Setting_ITS(TUPA_Setting_ITS& tUPA_Setting_ITS) = 0;
    virtual tVoid vGetUPA_MOD_Status(TUPA_MOD_Status& tUPA_MOD_Status) = 0;
    virtual tVoid vGetUPA_BEEP_Sound_Type(TUPA_BEEP_Sound_Type& tUPA_BEEP_Sound_Type) = 0;
    virtual tVoid vGetSteering_Angle(TSteering_Angle& tSteering_Angle) = 0;
    virtual tVoid vGetCalibration_Flag(TCalibration_Flag& tCalibration_Flag) = 0;
    virtual tVoid vGetSteering_Sensor_Fail_Flag(TSteering_Sensor_Fail_Flag& tSteering_Sensor_Fail_Flag) = 0;
    virtual tVoid vGetSwaSensorInternalStatus(TSwaSensorInternalStatus& tSwaSensorInternalStatus) = 0;
    virtual tVoid vGetFRONT_STEER_PINION_ANGLE(TFRONT_STEER_PINION_ANGLE& tFRONT_STEER_PINION_ANGLE) = 0;
    virtual tVoid vGetACTIVE_STEER_FAIL(TACTIVE_STEER_FAIL& tACTIVE_STEER_FAIL) = 0;
    virtual tVoid vGetVehicleSpeed(TVehicleSpeed& tVehicleSpeed) = 0;
    virtual tVoid vGetIPA_Mode_Change_Request(TIPA_Mode_Change_Request& tIPA_Mode_Change_Request) = 0;
    virtual tVoid vGetIPA_Switch_Display_Request(TIPA_Switch_Display_Request& tIPA_Switch_Display_Request) = 0;
    virtual tVoid vGetIPA_Switch_mask_Request(TIPA_Switch_mask_Request& tIPA_Switch_mask_Request) = 0;
    virtual tVoid vGetIPA_Switch_Gray_Out_Request_01(TIPA_Switch_Gray_Out_Request_01& tIPA_Switch_Gray_Out_Request_01) = 0;
    virtual tVoid vGetIPA_Switch_Gray_Out_Request_02(TIPA_Switch_Gray_Out_Request_02& tIPA_Switch_Gray_Out_Request_02) = 0;
    virtual tVoid vGetIPA_Switch_Gray_Out_Request_03(TIPA_Switch_Gray_Out_Request_03& tIPA_Switch_Gray_Out_Request_03) = 0;
    virtual tVoid vGetIPA_Switch_Gray_Out_Request_04(TIPA_Switch_Gray_Out_Request_04& tIPA_Switch_Gray_Out_Request_04) = 0;
    virtual tVoid vGetIPA_Switch_Gray_Out_Request_05(TIPA_Switch_Gray_Out_Request_05& tIPA_Switch_Gray_Out_Request_05) = 0;
    virtual tVoid vGetIPA_Switch_Gray_Out_Request_06(TIPA_Switch_Gray_Out_Request_06& tIPA_Switch_Gray_Out_Request_06) = 0;
    virtual tVoid vGetIPA_mode_selection(TIPA_mode_selection& tIPA_mode_selection) = 0;
    virtual tVoid vGetIPA_Message_Display_Request(TIPA_Message_Display_Request& tIPA_Message_Display_Request) = 0;
    virtual tVoid vGetIPA_Sound_Output_Request(TIPA_Sound_Output_Request& tIPA_Sound_Output_Request) = 0;
    virtual tVoid vGetIPA_Voice_Output_Request(TIPA_Voice_Output_Request& tIPA_Voice_Output_Request) = 0;
    virtual tVoid vGetIPA_region_selection(TIPA_region_selection& tIPA_region_selection) = 0;
    virtual tVoid vGetIPA_Camera_Indicator_Request(TIPA_Camera_Indicator_Request& tIPA_Camera_Indicator_Request) = 0;
    virtual tVoid vGetIPA_Mulfunction(TIPA_Mulfunction& tIPA_Mulfunction) = 0;
    virtual tVoid vGetRearGearEngaged(TRearGearEngaged& tRearGearEngaged) = 0;
    virtual tVoid vGetMVC_ViewModeStatus(TMVC_ViewModeStatus& tMVC_ViewModeStatus) = 0;
    virtual tVoid vGetMVC_WarningDisplayRequest(TMVC_WarningDisplayRequest& tMVC_WarningDisplayRequest) = 0;
    virtual tVoid vGetTailGateStatus(TTailGateStatus& tTailGateStatus) = 0;
    virtual tVoid vGetAVM_ChangeViewStatus(TAVM_ChangeViewStatus& tAVM_ChangeViewStatus) = 0;
    virtual tVoid vGetAVM_ClosingAuthorization(TAVM_ClosingAuthorization& tAVM_ClosingAuthorization) = 0;
    virtual tVoid vGetMOD_ActivationState(TMOD_ActivationState& tMOD_ActivationState) = 0;
    virtual tVoid vGetFAP_ModeChangeRequest(TFAP_ModeChangeRequest& tFAP_ModeChangeRequest) = 0;
    virtual tVoid vGetCamerasetting_availability(TCamerasetting_availability& tCamerasetting_availability) = 0;
    virtual tVoid vGetFAP_Setting01(TFAP_Setting01& tFAP_Setting01) = 0;
    virtual tVoid vGetFAP_Setting02(TFAP_Setting02& tFAP_Setting02) = 0;
    virtual tVoid vGetFAP_Setting03(TFAP_Setting03& tFAP_Setting03) = 0;
    virtual tVoid vGetFAP_Setting04(TFAP_Setting04& tFAP_Setting04) = 0;
    virtual tVoid vGetFAP_Setting05(TFAP_Setting05& tFAP_Setting05) = 0;
    virtual tVoid vGetFAP_Setting06(TFAP_Setting06& tFAP_Setting06) = 0;
    virtual tVoid vGetFAP_Setting07(TFAP_Setting07& tFAP_Setting07) = 0;
    virtual tVoid vGetFAP_Setting08(TFAP_Setting08& tFAP_Setting08) = 0;
    virtual tVoid vGetFAP_Setting09(TFAP_Setting09& tFAP_Setting09) = 0;
    virtual tVoid vGetFAP_Setting10(TFAP_Setting10& tFAP_Setting10) = 0;
    virtual tVoid vGetAVM_Setting_1(TAVM_Setting_1& tAVM_Setting_1) = 0;
    virtual tVoid vGetAVM_Setting_2(TAVM_Setting_2& tAVM_Setting_2) = 0;
    virtual tVoid vGetAVM_Setting_3(TAVM_Setting_3& tAVM_Setting_3) = 0;
    virtual tVoid vGetAVM_Setting_4(TAVM_Setting_4& tAVM_Setting_4) = 0;
    virtual tVoid vGetAVM_Setting_5(TAVM_Setting_5& tAVM_Setting_5) = 0;
    virtual tVoid vGetAVM_Setting_6(TAVM_Setting_6& tAVM_Setting_6) = 0;
    virtual tVoid vGetAVM_Setting_7(TAVM_Setting_7& tAVM_Setting_7) = 0;
    virtual tVoid vGetAVM_Setting_8(TAVM_Setting_8& tAVM_Setting_8) = 0;
    virtual tVoid vGetAVM_Setting_9(TAVM_Setting_9& tAVM_Setting_9) = 0;
    virtual tVoid vGetFAP_PurposeSwitchAvailability(TFAP_PurposeSwitchAvailability& tFAP_PurposeSwitchAvailability) = 0;
    virtual tVoid vGetFAP_ChangeViewRequest(TFAP_ChangeViewRequest& tFAP_ChangeViewRequest) = 0;
    virtual tVoid vGetFAP_SoundDirection(TFAP_SoundDirection& tFAP_SoundDirection) = 0;
    virtual tVoid vGetFAP_SoundLevelControl(TFAP_SoundLevelControl& tFAP_SoundLevelControl) = 0;
    virtual tVoid vGetFAP_SoundPatternRequest(TFAP_SoundPatternRequest& tFAP_SoundPatternRequest) = 0;
    virtual tVoid vGetFAP_VoicePatternRequest(TFAP_VoicePatternRequest& tFAP_VoicePatternRequest) = 0;
    virtual tVoid vGetDayRheostatedLightMaxPercent(TDayRheostatedLightMaxPercent& tDayRheostatedLightMaxPercent) = 0;
    virtual tVoid vGetNightRheostatedLightMaxPercent(TNightRheostatedLightMaxPercent& tNightRheostatedLightMaxPercent) = 0;
    virtual tVoid vGetDimmingState(TDimmingState& tDimmingState) = 0;
    virtual tVoid vGetSTATUS_DYNAMIC_REAR(TSTATUS_DYNAMIC_REAR& tSTATUS_DYNAMIC_REAR) = 0;

    virtual tVoid vSendUPA_TX_Initializing(TUPA_TX_Initializing tTxSignal) = 0;
    virtual tVoid vSendUPA_Camera_Switch_Press(TUPA_Camera_Switch_Press tTxSignal) = 0;
    virtual tVoid vSendUPA_Camera_Switch_Keep(TUPA_Camera_Switch_Keep tTxSignal) = 0;
    virtual tVoid vSendUPA_Camera_OFF_Request(TUPA_Camera_OFF_Request tTxSignal) = 0;
    virtual tVoid vSendUPA_Setting_Language_Request(TUPA_Setting_Language_Request tTxSignal) = 0;
    virtual tVoid vSendUPA_MOD_Switch_Press(TUPA_MOD_Switch_Press tTxSignal) = 0;
    virtual tVoid vSendIPA_Activation_flug(TIPA_Activation_flug tTxSignal) = 0;
    virtual tVoid vSendIPA_SW_Long_Press(TIPA_SW_Long_Press tTxSignal) = 0;
    virtual tVoid vSendIPA_SW_Operation_Status(TIPA_SW_Operation_Status tTxSignal) = 0;
    virtual tVoid vSendMVC_ViewModeRequest(TMVC_ViewModeRequest tTxSignal) = 0;
    virtual tVoid vSendFAP_SwitchOperationStatus(TFAP_SwitchOperationStatus tTxSignal) = 0;
    virtual tVoid vSendFAP_Screen_Activation_flag(TFAP_Screen_Activation_flag tTxSignal) = 0;
    virtual tVoid vSendFAP_ScreenPressCoordinateX(TFAP_ScreenPressCoordinateX tTxSignal) = 0;
    virtual tVoid vSendFAP_ScreenPressCoordinateY(TFAP_ScreenPressCoordinateY tTxSignal) = 0;
    virtual tVoid vSendFAP_ScreenPressDetected(TFAP_ScreenPressDetected tTxSignal) = 0;
    virtual tVoid vSendHorizontalDilutionOfPrecision(THorizontalDilutionOfPrecision tTxSignal) = 0;
    virtual tVoid vSendVerticalDilutionOfPrecision(TVerticalDilutionOfPrecision tTxSignal) = 0;
    virtual tVoid vSendSatNUM(TSatNUM tTxSignal) = 0;
    virtual tVoid vSendGroundSpeed(TGroundSpeed tTxSignal) = 0;
    virtual tVoid vSendSatelliteGPSCount(TSatelliteGPSCount tTxSignal) = 0;
    virtual tVoid vSendFAP_ActivationRequest(TFAP_ActivationRequest tTxSignal) = 0;
    virtual tVoid vSendSwitchRequest_AVM(TSwitchRequest_AVM tTxSignal) = 0;
    virtual tVoid vSendChangeViewRequest_AVM(TChangeViewRequest_AVM tTxSignal) = 0;
    virtual tVoid vSendMOD_ActivationRequest2(TMOD_ActivationRequest2 tTxSignal) = 0;
    virtual tVoid vSendDimmingReq(TDimmingReq tTxSignal) = 0;
    virtual tVoid vSendDriver_Assistance_SW_flag(TDriver_Assistance_SW_flag tTxSignal) = 0;
    // I_dispvidctrl_tclClientVcanCanAdaptor::ClassImplementation: user specific code start
    virtual tVoid vInvalidate_UPA_RX_Initializing(tVoid) = 0;
    virtual tVoid vInvalidate_UPA_View_Change_Request(tVoid) = 0;
    virtual tVoid vInvalidate_FAP_ChangeViewRequest(tVoid) = 0;
    // I_dispvidctrl_tclClientVcanCanAdaptor::ClassImplementation: user specific code end
};

#endif // _I_VCANCANADAPTOR_H_
