/*****************************************************************************
* FILE:         dispvidctrl_Starter-early.cpp
* PROJECT:      G3G project
* SW-COMPONENT: dispvidctrl
* Template:     (none - see comment further down)
*----------------------------------------------------------------------------
*
* DESCRIPTION:  Create application specific objects here
*
*               copied and manually adapted from generated file dispvidctrl_Starter.cpp
*               any possibly appearing "user specific code start/end" tags in this file here have no meaning/effect
*
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2018 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

#include "dispvidctrl_AppMain.h"

// AsfClientStarterIncludeTop: user specific code start
// AsfClientStarterIncludeTop: user specific code end

#include "dispvidctrl_ServiceDimming.h"
#include "dispvidctrl_ServiceDimmingIf.h"
#include "dispvidctrl_ServiceSyncdisplay.h"
#include "dispvidctrl_ServiceSyncdisplayIf.h"
#include "dispvidctrl_ServiceRvc.h"
#include "dispvidctrl_ServiceRvcIf.h"
#include "dispvidctrl_ClientSpm.h"
#include "dispvidctrl_ClientSpmIf.h"
#include "dispvidctrl_ClientDiaglog.h"
#include "dispvidctrl_ClientDiaglogIf.h"
#include "dispvidctrl_ClientAudio.h"
#include "dispvidctrl_ClientAudioIf.h"
#include "dispvidctrl_ClientVideomanager.h"
#include "dispvidctrl_ClientVideomanagerIf.h"
#include "dispvidctrl_ClientSds_tts.h"
#include "dispvidctrl_ClientSds_ttsIf.h"
#include "dispvidctrl_ClientProfile.h"
#include "dispvidctrl_ClientProfileIf.h"
#include "dispvidctrl_ClientDimming.h"
#include "dispvidctrl_ClientDimmingIncAdaptor.h"
#include "dispvidctrl_ClientEarly.h"
#include "dispvidctrl_ClientEarlyIncAdaptor.h"
#include "dispvidctrl_ClientVcan.h"
#include "dispvidctrl_ClientVcanCanAdaptor.h"
//#include "dispvidctrl_ClientAvm.h"
#include "dispvidctrl_ClientAvmAdaptor.h"
#include "dispvidctrl_ClientAvmSink.h"
#include "dispvidctrl_ClientAvmFsm.h"
#include "dispvidctrl_ClientAvm.h"
#include "dispvidctrl_ClientVehicledata.h"
#include "dispvidctrl_ClientVehicledataIf.h"


// AsfClientStarterInclude: user specific code start
#include "dispvidctrl_tclControl_HmiAvm3.h"
#include "dispvidctrl_tclControl.h"
#include "dispvidctrl_tclControl_Avm.h"
#include "dispvidctrl_tclControl_Hmi.h"
#include "dispvidctrl_tclControl_Rvc.h"
#include "dispvidctrl_tclControl_Mvc.h"
#include "dispvidctrl_tclControl_Video.h"
#include "dispvidctrl_tclConfigMgr.h"
#include "dispvidctrl_tclDisplaySettings.h"
#include "dispvidctrl_tclEarlyIf.h"
#include "dispvidctrl_tclSyncHandler.h"
#include "dispvidctrl_tclVideoPlayer.h"
#include "dispvidctrl_tclClient_DevVideo.h"
#include "dispvidctrl_tclPersistentData.h"
#include "dispvidctrl_tclBacklightError.h"
#include "dispvidctrl_tclAudioRouting.h"
#include "dispvidctrl_InputHandler.h"
#include "dispvidctrl_EventObserver.h"
#include "dispvidctrl_TouchDataHandler.h"
#ifdef VARIANT_S_FTR_ENABLE_AIVI_NPIVI
#include "dispvidctrl_tclSecondDisp.h"
#endif
#include"dispvidctrl_ProfileManager.h"
#include "dispvidctrl_tclTouchDriverControl.h"
#include "dispvidctrl_tclLvdsMonitor.h"
#include "dispvidctrl_LvdsObserver.h"
#include "dispvidctrl_tclAudioPlayer.h"
// AsfClientStarterInclude: user specific code end


void vAppProxyStarterEarly(dispvidctrl_tclAppMain *poServer){
    poServer->vAddObj(new dispvidctrl_tclClientDimmingIncAdaptor(poServer));

    poServer->vAddObj(new dispvidctrl_tclClientEarlyIncAdaptor(poServer));
    poServer->vAddObj(new dispvidctrl_tclClientEarly(poServer));
    
    poServer->vAddObj(new dispvidctrl_tclSyncHandler(poServer));
    poServer->vAddObj(new dispvidctrl_tclVideoPlayer(poServer));

    poServer->vAddObj(new dispvidctrl_tclClientAvmAdaptor(poServer));
    poServer->vAddObj(new dispvidctrl_tclClientAvmSink(poServer));
    poServer->vAddObj(new dispvidctrl_tclMCanClientAvm(poServer));
    poServer->vAddObj(new dispvidctrl_tclMCanClientAvmFsm(poServer));
    poServer->vAddObj(new dispvidctrl_tclControl_HmiAvm3(poServer));

    poServer->vAddObj(new dispvidctrl_tclClientVideomanager(poServer));
    poServer->vAddObj(new dispvidctrl_tclClientVideomanagerIf(poServer));
}

void vAppProxyStarter(dispvidctrl_tclAppMain *poServer){

    {
        // AsfClientStarterdispvidctrl_tclServiceDimming: user specific code start
        // AsfClientStarterdispvidctrl_tclServiceDimming: user specific code end
        {
            dispvidctrl_tclServiceDimming *poCcaProxy = new dispvidctrl_tclServiceDimming(poServer);
            poServer->vAddObj(poCcaProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
        {
            dispvidctrl_tclServiceDimmingIf *poCcaProxy = new dispvidctrl_tclServiceDimmingIf(poServer);
            poServer->vAddObj(poCcaProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
        // AsfClientStarterdispvidctrl_tclServiceSyncdisplay: user specific code start
        // AsfClientStarterdispvidctrl_tclServiceSyncdisplay: user specific code end
        {
            dispvidctrl_tclServiceSyncdisplay *poCcaProxy = new dispvidctrl_tclServiceSyncdisplay(poServer);
            poServer->vAddObj(poCcaProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
        {
            dispvidctrl_tclServiceSyncdisplayIf *poCcaProxy = new dispvidctrl_tclServiceSyncdisplayIf(poServer);
            poServer->vAddObj(poCcaProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
        // AsfClientStarterdispvidctrl_tclServiceRvc: user specific code start
        // AsfClientStarterdispvidctrl_tclServiceRvc: user specific code end
        {
            dispvidctrl_tclServiceRvc *poCcaProxy = new dispvidctrl_tclServiceRvc(poServer);
            poServer->vAddObj(poCcaProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
        {
            dispvidctrl_tclServiceRvcIf *poCcaProxy = new dispvidctrl_tclServiceRvcIf(poServer);
            poServer->vAddObj(poCcaProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
        // AsfClientStarterdispvidctrl_tclClientSpm: user specific code start
        // AsfClientStarterdispvidctrl_tclClientSpm: user specific code end
        {
            dispvidctrl_tclClientSpm *poCcaProxy = new dispvidctrl_tclClientSpm(poServer);
            poServer->vAddObj(poCcaProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
        {
            dispvidctrl_tclClientSpmIf *poCcaProxy = new dispvidctrl_tclClientSpmIf(poServer);
            poServer->vAddObj(poCcaProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
        // AsfClientStarterdispvidctrl_tclClientDiaglog: user specific code start
        // AsfClientStarterdispvidctrl_tclClientDiaglog: user specific code end
        {
            dispvidctrl_tclClientDiaglog *poCcaProxy = new dispvidctrl_tclClientDiaglog(poServer);
            poServer->vAddObj(poCcaProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
        {
            dispvidctrl_tclClientDiaglogIf *poCcaProxy = new dispvidctrl_tclClientDiaglogIf(poServer);
            poServer->vAddObj(poCcaProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
        // AsfClientStarterdispvidctrl_tclClientAudio: user specific code start
        // AsfClientStarterdispvidctrl_tclClientAudio: user specific code end
        {
            dispvidctrl_tclClientAudio *poCcaProxy = new dispvidctrl_tclClientAudio(poServer);
            poServer->vAddObj(poCcaProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
        {
            dispvidctrl_tclClientAudioIf *poCcaProxy = new dispvidctrl_tclClientAudioIf(poServer);
            poServer->vAddObj(poCcaProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
        // AsfClientStarterdispvidctrl_tclClientSds_tts: user specific code start
        // AsfClientStarterdispvidctrl_tclClientSds_tts: user specific code end
        {
            dispvidctrl_tclClientSds_tts *poCcaProxy = new dispvidctrl_tclClientSds_tts(poServer);
            poServer->vAddObj(poCcaProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
        {
            dispvidctrl_tclClientSds_ttsIf *poCcaProxy = new dispvidctrl_tclClientSds_ttsIf(poServer);
            poServer->vAddObj(poCcaProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
        // AsfClientStarterdispvidctrl_tclClientProfile: user specific code start
        // AsfClientStarterdispvidctrl_tclClientProfile: user specific code end
        {
            dispvidctrl_tclClientProfile *poCcaProxy = new dispvidctrl_tclClientProfile(poServer);
            poServer->vAddObj(poCcaProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
        {
            dispvidctrl_tclClientProfileIf *poCcaProxy = new dispvidctrl_tclClientProfileIf(poServer);
            poServer->vAddObj(poCcaProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
        {
            dispvidctrl_tclClientDimming *poIncProxy = new dispvidctrl_tclClientDimming(poServer);
            poServer->vAddObj(poIncProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
        // AsfClientStarterdispvidctrl_tclClientVcanCanAdaptor: user specific code start
        // AsfClientStarterdispvidctrl_tclClientVcanCanAdaptor: user specific code end
        {
            dispvidctrl_tclClientVcanCanAdaptor *poCanProxy = new dispvidctrl_tclClientVcanCanAdaptor(poServer);
            poServer->vAddObj(poCanProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
		// AsfClientStarterdispvidctrl_tclClientVehicledata: user specific code start
        // AsfClientStarterdispvidctrl_tclClientVehicledata: user specific code end
        {
            dispvidctrl_tclClientVehicledata *poCcaProxy = new dispvidctrl_tclClientVehicledata(poServer);
            poServer->vAddObj(poCcaProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
        {
            dispvidctrl_tclClientVehicledataIf *poCcaProxy = new dispvidctrl_tclClientVehicledataIf(poServer);
            poServer->vAddObj(poCcaProxy);
        } //lint
        {
            dispvidctrl_tclClientVcan *poCanProxy = new dispvidctrl_tclClientVcan(poServer);
            poServer->vAddObj(poCanProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
    }

    // AsfClientProxyStarter: user specific code start
    {
    poServer->vAddObj(new dispvidctrl_tclConfigMgr(poServer));
    poServer->vAddObj(new dispvidctrl_tclDisplaySettings(poServer));
    poServer->vAddObj(new dispvidctrl_tclControl_Avm(poServer));
    poServer->vAddObj(new dispvidctrl_tclControl_Hmi(poServer));
    poServer->vAddObj(new dispvidctrl_tclControl_Rvc(poServer));
    poServer->vAddObj(new dispvidctrl_tclControl_Mvc(poServer));
    poServer->vAddObj(new dispvidctrl_tclPersistentData(poServer));
    poServer->vAddObj(new dispvidctrl_tclControl_Video(poServer));
    poServer->vAddObj(new dispvidctrl_tclClient_DevVideo(poServer));
    poServer->vAddObj(new dispvidctrl_tclBacklightError(poServer));
    poServer->vAddObj(new dispvidctrl_tclAudio_Routing(poServer));
    poServer->vAddObj(new dispvidctrl_tclInputHandler(poServer));
    poServer->vAddObj(new dispvidctrl_tclTouchDataHandler(poServer));
    poServer->vAddObj(new dispvidctrl_tclEventObserver(poServer));
    poServer->vAddObj(new dispvidctrl_tclAudioPlayer(poServer));

//For PIVI Second Screen Disp If Object created only for PIVI Variant.
#ifdef VARIANT_S_FTR_ENABLE_AIVI_NPIVI
    poServer->vAddObj(new dispvidctrl_tclSecondDisp(poServer));
#endif

    poServer->vAddObj(new dispvidctrl_tclProfileManager(poServer));
        poServer->vAddObj(new dispvidctrl_tclTouchDriverControl(poServer));
        poServer->vAddObj(new dispvidctrl_tclLvdsObserver(poServer));
        poServer->vAddObj(new dispvidctrl_tclLvdsMonitor(poServer));

    //
    //  I M P O R T A N T :
    //    
    // tclControl must be added as last object, so that "vStartCommunication" call will be the last one of all.
    poServer->vAddObj(new dispvidctrl_tclControl(poServer));
    } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list

    // AsfClientProxyStarter: user specific code end
}
