/*****************************************************************************
* FILE:         dispvidctrl_MCanClientAvm.h
* PROJECT:      G3G project
* SW-COMPONENT: dispvidctrl
* Template:     MCanClientFsm.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2018 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/
#pragma once

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

//include base class
#include "Idispvidctrl_ClientAvmFsm.h"
#include "dispvidctrl_fsm.h"

// dispvidctrl_tclMCanClientAvmFsmInc::ClassIncludes: user specific code start

#include "Idispvidctrl_ClientAvm.h"

#define RVC_FI_S_IMPORT_INTERFACE_FI_TYPES
#include "rvc_fi_if.h"
// dispvidctrl_tclMCanClientAvmFsmInc::ClassIncludes: user specific code end


class dispvidctrl_tclMCanClientAvmFsm : 
    public dispvidctrl_tclFsmBase, 
    public I_dispvidctrl_tclMCanClientAvmFsm
{
private:
    tVoid vFsmInfo();

    virtual tVoid vStartFsmStateTimer(tU32 u32Time);

    virtual tVoid vStateChangeDetected(tVoid);
    virtual tVoid vTransitionAction(tU32 u32ActionId);
    
    static OSAL_tpfCallback vStateTimer(tVoid *pArg);

    OSAL_tTimerHandle    _hStateTimer;
    tBool                _bFsmDeactivated;
    tBool                _bChannelRequested;

    static TStateTransitions _aFsmStateTransitionTable[];
    static TFsmStateConf     _aFsmStateTable[eStateFsmMax];

    static tVoid             vEntryDeactivated(tVoid);
    static tVoid             vEntryInitalizing(tVoid);
    static tVoid             vEntryConnected(tVoid);

    // I_dispvidctrl_tclMCanClientAvmFsmStateFunc::ClassImplementation: user specific code start
    static tVoid             vEntryAvmIdle(tVoid);
    static tVoid             vExitAvmIdle(tVoid);
    
    static tVoid             vEntryAvmVideo(tVoid);
    static tVoid             vExitAvmVideo(tVoid);
    
    static tVoid             vEntryAvmBlankOth2Vid(tVoid);
    static tVoid             vExitAvmBlankOth2Vid(tVoid);
    
    static tVoid             vEntryAvmBlankVid2Oth(tVoid);
    static tVoid             vExitAvmBlankVid2Oth(tVoid);
    
    static tVoid             vEntryAvmBlankVid2Vid(tVoid);
    static tVoid             vExitAvmBlankVid2Vid(tVoid);


    typedef enum {
       eTimerNone = 0,
       eTimerBlankOth2Vid,
       eTimerBlankVid2Oth,
       eTimerBlankVid2Vid,
    } tenTimerId;
    OSAL_tTimerHandle        _hTimerBlankOth2Vid;
    OSAL_tTimerHandle        _hTimerBlankVid2Oth;
    OSAL_tTimerHandle        _hTimerBlankVid2Vid;
    static OSAL_tpfCallback  vCallbk_TimeOutBlankOth2Vid(tVoid *pArg);
    static OSAL_tpfCallback  vCallbk_TimeOutBlankVid2Oth(tVoid *pArg);
    static OSAL_tpfCallback  vCallbk_TimeOutBlankVid2Vid(tVoid *pArg);

    tVoid vSetTimer(tU32 u32TimerId, tU32 u32MilliSec);
    
    // I_dispvidctrl_tclMCanClientAvmFsmStateFunc::ClassImplementation: user specific code end

    static dispvidctrl_tclMCanClientAvmFsm*   _poMyStaticRef;
    
public:
   dispvidctrl_tclMCanClientAvmFsm(dispvidctrl_tclAppMain* poMainAppl);
   virtual ~dispvidctrl_tclMCanClientAvmFsm();

   virtual const tChar* getName() const { return "dispvidctrl_tclMCanClientAvmFsm"; };
   
   virtual tVoid vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();

   virtual tVoid vNewTrigger(eFsmTrigger eTrigger, tBool bTriggerState) const;
   virtual tU32  u32GetState()  const { return u32GetFsmState(); }
   virtual tBool bIsAccActive() const { return ( 0 != (u32GetTrigger() & eEventAcc)); }
   
// dispvidctrl_tclMCanClientAvmFsm::ClassImplementation: user specific code start

   virtual tVoid vGetReferencesEarly(tVoid);
   virtual tVoid vStartCommunicationEarly(tVoid);

   virtual tBool bIsIgnActive() const { return ( 0 != (u32GetTrigger() & eEventIgnition)); }
   virtual tBool bIsRevActive() const { return ( 0 != (u32GetTrigger() & eEventReverseGear)); }
   
private:
   I_dispvidctrl_tclMCanClientAvm* _pMcanClientAvm;

   tBool   _bAvmPhase3Configured;
   tBool   _bEarlyPhaseOver;
   tBool   _bAcceptUndebouncedRevGear;
   
   virtual tVoid vFinishCfgSeq();

   virtual tVoid vSendUnitConfiguration(tU8 u8UnitId, tU8 u8VersHi, tU8 u8VersMid, tU8 u8VersLo);
   virtual tVoid vSendNormalBeep(tVoid);
   virtual tVoid vSendErrorBeep(tVoid);
   virtual tVoid vSendFsmOutEvent(tU32 u32EventId, const void* pvData=OSAL_NULL);
   virtual tVoid vSendFsmLoopbackEvent(tU32 u32EventId, tBool bEventState);
   
   virtual tVoid vHandleSwitchInput(tU32 u32SwitchId);
   virtual tVoid vSendSW_Signal(tU32 u32SW_Status, tU32 u32Disp_Status);
   virtual tVoid vSendSW_Signal(tU32 u32SW_Status);  // determine u32Disp_Status automatically from FSM state(s)
   virtual tVoid vSendBciSwitch(tU32 u32SwitchId);
   
// dispvidctrl_tclMCanClientAvmFsm::ClassImplementation: user specific code end


};


