/*****************************************************************************
* FILE:         dispvidctrl_MCanClientAvm.cpp
* PROJECT:      G3G project
* SW-COMPONENT: dispvidctrl
* Template:     MCanClient.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2018 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

#include "dispvidctrl_ClientAvm.h"
#include "Idispvidctrl_ClientAvmFsm.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DISPVIDCTRL_CLIENT_AVM
#include "trcGenProj/Header/dispvidctrl_ClientAvm.cpp.trc.h"
#endif

// dispvidctrl_tclMCanClientAvm::ClassIncludes: user specific code start

#include "I_dispvidctrl_ClientAudioIf.h"
#include "dispvidctrl_tclControl_HmiAvm3.h"
#include "I_dispvidctrl_ServiceRvcIf.h"
#include "Idispvidctrl_ClientVcan.h"
#include "dispvidctrl_tclControl_Video.h"


#define MCAN_MAPMSG(funcname,opcode)              _mapMsgs[Avm_ASSEMBLE_KEY(eFct ## funcname, MCAN_C_OP_TYPE_ ## opcode)]
#define MCAN_MAPMSG_SET_CHANGED(funcname,opcode)  MCAN_MAPMSG(funcname,opcode).vDataChanged()
#define MCAN_MAPMSG_CLR_CHANGED(funcname,opcode)  MCAN_MAPMSG(funcname,opcode).vClearDataChanged()

// little helpers
#define DISPVIDCTRL_TY_VECTOR(TypeName)  std::vector<TypeName, std::allocator<TypeName> >

// defines for the Rx VCAN signal STATUS_DYNAMIC_REAR carrying the current BCI status:
#define DISPVIDCTRL_AVM3_BCISTATE_OFF                    0x01
#define DISPVIDCTRL_AVM3_BCISTATE_ON                     0x02
#define DISPVIDCTRL_AVM3_BCISTATE_TEMP_OFF               0x03
#define DISPVIDCTRL_AVM3_BCISTATE_TEMP_FAIL              0x04
#define DISPVIDCTRL_AVM3_BCISTATE_SYS_FAIL               0x05

// defines for the handling of the Tx VCAN signal Driver_Assistance_SW_flag used to send the BCI button presses to CAN:
#define DISPVIDCTRL_AVM3_DRVASSISTSW_SIGVAL_NO_OP        0x00  // 00000b - CAN MsgCat: "No operation"
#define DISPVIDCTRL_AVM3_DRVASSISTSW_SIGVAL_BCI_TEMP_SW  0x1B  // 11011b - CAN MsgCat: "BCI Temp SW back SW is pushed"
#define DISPVIDCTRL_AVM3_DRVASSISTSW_RESET_TIME_MS       500   // to reset the signal value DISPVIDCTRL_DRV_ASS_SW_SIGVAL_BCI_TEMP_SW back to ..._NONE

#define DISPVIDCTRL_USE_DUMMY_COMMANDS  // intended mainly for injecting messages via TTFis command DISPVIDCTRL_PostCmdToClass MsgNo u32Param InterfaceName

// dispvidctrl_tclMCanClientAvm::ClassIncludes: user specific code end

#define MCAN_LOCAL_ASSEMBLE_KEY(msgId, msgOpcode)   (((tU16)msgId) << 16 | msgOpcode)

#define MCAN_DEFAULT_TIME                0xffffffff
#define MCAN_QUEUE_DELAY_TIME            4000
  
#ifndef MCAN_ACC_DEBOUNCE_TIME
#define MCAN_ACC_DEBOUNCE_TIME      50
#endif

dispvidctrl_tclMCanClientAvm::dispvidctrl_tclMCanClientAvm(dispvidctrl_tclAppMain* poMainAppl):
I_dispvidctrl_tclMCanClientAvm(poMainAppl),
_pCsmBase(NULL)
{
   ETG_TRACE_USR4(("dispvidctrl_tclMCanClientAvm::dispvidctrl_tclMCanClientAvm() entered."));
   
   if ( OSAL_OK != OSAL_s32TimerCreate( (OSAL_tpfCallback) vCallbackAvmTimeoutTimer, (tPVoid)this, &_hAvmTimeoutTimer ) ) {
       _hAvmTimeoutTimer = OSAL_C_INVALID_HANDLE;
   }
   
   _u32SequenceMsgQueueChangedTime      = MCAN_DEFAULT_TIME;
   _u32SequenceBlockMsgQueueChangedTime = MCAN_DEFAULT_TIME;
   
   _u32AccOffDetected                   = MCAN_DEFAULT_TIME;
      
   tclMCanClientMsgInfo oNewMsg;
   memset((tVoid*)&oNewMsg, 0, sizeof(tclMCanClientMsgInfo));
   oNewMsg.vSetMsgConfigured(TRUE);   
      
   oNewMsg.vSetMsgEnabled(TRUE);
   oNewMsg.pFuncSendMsg = dispvidctrl_tclMCanClientAvm::sendSoftware_VersionGetOut;
   oNewMsg.pFuncTimeoutMsg = NULL;
   _mapMsgs[Avm_ASSEMBLE_KEY(eFctSoftware_Version,MCAN_C_OP_TYPE_GET)] = oNewMsg;
   _mapMsgs[Avm_ASSEMBLE_KEY(eFctSoftware_Version,MCAN_C_OP_TYPE_GET)]._vecStateBlockedIn.push_back(I_dispvidctrl_tclMCanClientAvmFsm::eStateDeactivated);
   _mapMsgs[Avm_ASSEMBLE_KEY(eFctSoftware_Version,MCAN_C_OP_TYPE_GET)]._vecStateBlockedIn.push_back(I_dispvidctrl_tclMCanClientAvmFsm::eStateInitalizing);
   
   oNewMsg.vSetMsgEnabled(TRUE);
   oNewMsg.pFuncSendMsg = NULL;
   oNewMsg.pFuncTimeoutMsg = dispvidctrl_tclMCanClientAvm::wrapSoftware_VersionStatusInTimeout;
   _mapMsgs[Avm_ASSEMBLE_KEY(eFctSoftware_Version,MCAN_C_OP_TYPE_STATUS)] = oNewMsg;
   

   oNewMsg.vSetMsgEnabled(TRUE);
   oNewMsg.pFuncSendMsg = dispvidctrl_tclMCanClientAvm::sendHardware_VersionGetOut;
   oNewMsg.pFuncTimeoutMsg = NULL;
   _mapMsgs[Avm_ASSEMBLE_KEY(eFctHardware_Version,MCAN_C_OP_TYPE_GET)] = oNewMsg;
   _mapMsgs[Avm_ASSEMBLE_KEY(eFctHardware_Version,MCAN_C_OP_TYPE_GET)]._vecStateBlockedIn.push_back(I_dispvidctrl_tclMCanClientAvmFsm::eStateDeactivated);
   _mapMsgs[Avm_ASSEMBLE_KEY(eFctHardware_Version,MCAN_C_OP_TYPE_GET)]._vecStateBlockedIn.push_back(I_dispvidctrl_tclMCanClientAvmFsm::eStateInitalizing);
   
   oNewMsg.vSetMsgEnabled(TRUE);
   oNewMsg.pFuncSendMsg = NULL;
   oNewMsg.pFuncTimeoutMsg = dispvidctrl_tclMCanClientAvm::wrapHardware_VersionStatusInTimeout;
   _mapMsgs[Avm_ASSEMBLE_KEY(eFctHardware_Version,MCAN_C_OP_TYPE_STATUS)] = oNewMsg;
   

   oNewMsg.vSetMsgEnabled(TRUE);
   oNewMsg.pFuncSendMsg = dispvidctrl_tclMCanClientAvm::sendSW_SignalIndicationOut;
   oNewMsg.pFuncTimeoutMsg = NULL;
   _mapMsgs[Avm_ASSEMBLE_KEY(eFctSW_Signal,MCAN_C_OP_TYPE_INDICATION)] = oNewMsg;
   _mapMsgs[Avm_ASSEMBLE_KEY(eFctSW_Signal,MCAN_C_OP_TYPE_INDICATION)]._vecStateBlockedIn.push_back(I_dispvidctrl_tclMCanClientAvmFsm::eStateDeactivated);
   _mapMsgs[Avm_ASSEMBLE_KEY(eFctSW_Signal,MCAN_C_OP_TYPE_INDICATION)]._vecStateBlockedIn.push_back(I_dispvidctrl_tclMCanClientAvmFsm::eStateInitalizing);
   

   oNewMsg.vSetMsgEnabled(TRUE);
   oNewMsg.pFuncSendMsg = NULL;
   oNewMsg.pFuncTimeoutMsg = NULL;
   _mapMsgs[Avm_ASSEMBLE_KEY(eFctExtra_SW,MCAN_C_OP_TYPE_INDICATION)] = oNewMsg;
   

   oNewMsg.vSetMsgEnabled(FALSE);
   oNewMsg.pFuncSendMsg = dispvidctrl_tclMCanClientAvm::sendView_Change_08AVMStatusOut;
   oNewMsg.pFuncTimeoutMsg = NULL;
   _mapMsgs[Avm_ASSEMBLE_KEY(eFctView_Change_08AVM,MCAN_C_OP_TYPE_STATUS)] = oNewMsg;
   _mapMsgs[Avm_ASSEMBLE_KEY(eFctView_Change_08AVM,MCAN_C_OP_TYPE_STATUS)]._vecStateBlockedIn.push_back(I_dispvidctrl_tclMCanClientAvmFsm::eStateDeactivated);
   _mapMsgs[Avm_ASSEMBLE_KEY(eFctView_Change_08AVM,MCAN_C_OP_TYPE_STATUS)]._vecStateBlockedIn.push_back(I_dispvidctrl_tclMCanClientAvmFsm::eStateInitalizing);
   
   oNewMsg.vSetMsgEnabled(TRUE);
   oNewMsg.pFuncSendMsg = NULL;
   oNewMsg.pFuncTimeoutMsg = NULL;
   _mapMsgs[Avm_ASSEMBLE_KEY(eFctView_Change_08AVM,MCAN_C_OP_TYPE_SET)] = oNewMsg;
   

   oNewMsg.vSetMsgEnabled(TRUE);
   oNewMsg.pFuncSendMsg = NULL;
   oNewMsg.pFuncTimeoutMsg = NULL;
   _mapMsgs[Avm_ASSEMBLE_KEY(eFctBlanking_OFF,MCAN_C_OP_TYPE_INDICATION)] = oNewMsg;
   

   oNewMsg.vSetMsgEnabled(TRUE);
   oNewMsg.pFuncSendMsg = NULL;
   oNewMsg.pFuncTimeoutMsg = NULL;
   _mapMsgs[Avm_ASSEMBLE_KEY(eFctBlanking_less_Change_08AVM,MCAN_C_OP_TYPE_INDICATION)] = oNewMsg;
   

   oNewMsg.vSetMsgEnabled(TRUE);
   oNewMsg.pFuncSendMsg = dispvidctrl_tclMCanClientAvm::sendDirect_Camera_OFFIndicationOut;
   oNewMsg.pFuncTimeoutMsg = NULL;
   _mapMsgs[Avm_ASSEMBLE_KEY(eFctDirect_Camera_OFF,MCAN_C_OP_TYPE_INDICATION)] = oNewMsg;
   _mapMsgs[Avm_ASSEMBLE_KEY(eFctDirect_Camera_OFF,MCAN_C_OP_TYPE_INDICATION)]._vecStateBlockedIn.push_back(I_dispvidctrl_tclMCanClientAvmFsm::eStateDeactivated);
   _mapMsgs[Avm_ASSEMBLE_KEY(eFctDirect_Camera_OFF,MCAN_C_OP_TYPE_INDICATION)]._vecStateBlockedIn.push_back(I_dispvidctrl_tclMCanClientAvmFsm::eStateInitalizing);
   

   oNewMsg.vSetMsgEnabled(TRUE);
   oNewMsg.pFuncSendMsg = dispvidctrl_tclMCanClientAvm::sendAVM_Sonar_BuzzerSetOut;
   oNewMsg.pFuncTimeoutMsg = NULL;
   _mapMsgs[Avm_ASSEMBLE_KEY(eFctAVM_Sonar_Buzzer,MCAN_C_OP_TYPE_SET)] = oNewMsg;
   _mapMsgs[Avm_ASSEMBLE_KEY(eFctAVM_Sonar_Buzzer,MCAN_C_OP_TYPE_SET)]._vecStateBlockedIn.push_back(I_dispvidctrl_tclMCanClientAvmFsm::eStateDeactivated);
   _mapMsgs[Avm_ASSEMBLE_KEY(eFctAVM_Sonar_Buzzer,MCAN_C_OP_TYPE_SET)]._vecStateBlockedIn.push_back(I_dispvidctrl_tclMCanClientAvmFsm::eStateInitalizing);
   
   oNewMsg.vSetMsgEnabled(TRUE);
   oNewMsg.pFuncSendMsg = NULL;
   oNewMsg.pFuncTimeoutMsg = dispvidctrl_tclMCanClientAvm::wrapAVM_Sonar_BuzzerStatusInTimeout;
   _mapMsgs[Avm_ASSEMBLE_KEY(eFctAVM_Sonar_Buzzer,MCAN_C_OP_TYPE_STATUS)] = oNewMsg;
   
   oNewMsg.vSetMsgEnabled(TRUE);
   oNewMsg.pFuncSendMsg = NULL;
   oNewMsg.pFuncTimeoutMsg = NULL;
   _mapMsgs[Avm_ASSEMBLE_KEY(eFctAVM_Sonar_Buzzer,MCAN_C_OP_TYPE_INDICATION)] = oNewMsg;
   

   oNewMsg.vSetMsgEnabled(TRUE);
   oNewMsg.pFuncSendMsg = dispvidctrl_tclMCanClientAvm::sendCamera_Setting_08AVMSetOut;
   oNewMsg.pFuncTimeoutMsg = NULL;
   _mapMsgs[Avm_ASSEMBLE_KEY(eFctCamera_Setting_08AVM,MCAN_C_OP_TYPE_SET)] = oNewMsg;
   _mapMsgs[Avm_ASSEMBLE_KEY(eFctCamera_Setting_08AVM,MCAN_C_OP_TYPE_SET)]._vecStateBlockedIn.push_back(I_dispvidctrl_tclMCanClientAvmFsm::eStateDeactivated);
   _mapMsgs[Avm_ASSEMBLE_KEY(eFctCamera_Setting_08AVM,MCAN_C_OP_TYPE_SET)]._vecStateBlockedIn.push_back(I_dispvidctrl_tclMCanClientAvmFsm::eStateInitalizing);
   
   oNewMsg.vSetMsgEnabled(TRUE);
   oNewMsg.pFuncSendMsg = dispvidctrl_tclMCanClientAvm::sendCamera_Setting_08AVMGetOut;
   oNewMsg.pFuncTimeoutMsg = NULL;
   _mapMsgs[Avm_ASSEMBLE_KEY(eFctCamera_Setting_08AVM,MCAN_C_OP_TYPE_GET)] = oNewMsg;
   _mapMsgs[Avm_ASSEMBLE_KEY(eFctCamera_Setting_08AVM,MCAN_C_OP_TYPE_GET)]._vecStateBlockedIn.push_back(I_dispvidctrl_tclMCanClientAvmFsm::eStateDeactivated);
   _mapMsgs[Avm_ASSEMBLE_KEY(eFctCamera_Setting_08AVM,MCAN_C_OP_TYPE_GET)]._vecStateBlockedIn.push_back(I_dispvidctrl_tclMCanClientAvmFsm::eStateInitalizing);
   
   oNewMsg.vSetMsgEnabled(TRUE);
   oNewMsg.pFuncSendMsg = NULL;
   oNewMsg.pFuncTimeoutMsg = dispvidctrl_tclMCanClientAvm::wrapCamera_Setting_08AVMStatusInTimeout;
   _mapMsgs[Avm_ASSEMBLE_KEY(eFctCamera_Setting_08AVM,MCAN_C_OP_TYPE_STATUS)] = oNewMsg;
   
   oNewMsg.vSetMsgEnabled(TRUE);
   oNewMsg.pFuncSendMsg = NULL;
   oNewMsg.pFuncTimeoutMsg = NULL;
   _mapMsgs[Avm_ASSEMBLE_KEY(eFctCamera_Setting_08AVM,MCAN_C_OP_TYPE_INDICATION)] = oNewMsg;
   

   oNewMsg.vSetMsgEnabled(TRUE);
   oNewMsg.pFuncSendMsg = dispvidctrl_tclMCanClientAvm::sendCamera_Primary_SettingSetOut;
   oNewMsg.pFuncTimeoutMsg = NULL;
   _mapMsgs[Avm_ASSEMBLE_KEY(eFctCamera_Primary_Setting,MCAN_C_OP_TYPE_SET)] = oNewMsg;
   _mapMsgs[Avm_ASSEMBLE_KEY(eFctCamera_Primary_Setting,MCAN_C_OP_TYPE_SET)]._vecStateBlockedIn.push_back(I_dispvidctrl_tclMCanClientAvmFsm::eStateDeactivated);
   _mapMsgs[Avm_ASSEMBLE_KEY(eFctCamera_Primary_Setting,MCAN_C_OP_TYPE_SET)]._vecStateBlockedIn.push_back(I_dispvidctrl_tclMCanClientAvmFsm::eStateInitalizing);
   
   oNewMsg.vSetMsgEnabled(TRUE);
   oNewMsg.pFuncSendMsg = dispvidctrl_tclMCanClientAvm::sendCamera_Primary_SettingGetOut;
   oNewMsg.pFuncTimeoutMsg = NULL;
   _mapMsgs[Avm_ASSEMBLE_KEY(eFctCamera_Primary_Setting,MCAN_C_OP_TYPE_GET)] = oNewMsg;
   _mapMsgs[Avm_ASSEMBLE_KEY(eFctCamera_Primary_Setting,MCAN_C_OP_TYPE_GET)]._vecStateBlockedIn.push_back(I_dispvidctrl_tclMCanClientAvmFsm::eStateDeactivated);
   _mapMsgs[Avm_ASSEMBLE_KEY(eFctCamera_Primary_Setting,MCAN_C_OP_TYPE_GET)]._vecStateBlockedIn.push_back(I_dispvidctrl_tclMCanClientAvmFsm::eStateInitalizing);
   
   oNewMsg.vSetMsgEnabled(TRUE);
   oNewMsg.pFuncSendMsg = NULL;
   oNewMsg.pFuncTimeoutMsg = dispvidctrl_tclMCanClientAvm::wrapCamera_Primary_SettingStatusInTimeout;
   _mapMsgs[Avm_ASSEMBLE_KEY(eFctCamera_Primary_Setting,MCAN_C_OP_TYPE_STATUS)] = oNewMsg;
   

   oNewMsg.vSetMsgEnabled(TRUE);
   oNewMsg.pFuncSendMsg = dispvidctrl_tclMCanClientAvm::sendMCAN_Communication_ErrorGetOut;
   oNewMsg.pFuncTimeoutMsg = NULL;
   _mapMsgs[Avm_ASSEMBLE_KEY(eFctMCAN_Communication_Error,MCAN_C_OP_TYPE_GET)] = oNewMsg;
   _mapMsgs[Avm_ASSEMBLE_KEY(eFctMCAN_Communication_Error,MCAN_C_OP_TYPE_GET)]._vecStateBlockedIn.push_back(I_dispvidctrl_tclMCanClientAvmFsm::eStateDeactivated);
   _mapMsgs[Avm_ASSEMBLE_KEY(eFctMCAN_Communication_Error,MCAN_C_OP_TYPE_GET)]._vecStateBlockedIn.push_back(I_dispvidctrl_tclMCanClientAvmFsm::eStateInitalizing);
   
   oNewMsg.vSetMsgEnabled(TRUE);
   oNewMsg.pFuncSendMsg = NULL;
   oNewMsg.pFuncTimeoutMsg = dispvidctrl_tclMCanClientAvm::wrapMCAN_Communication_ErrorStatusInTimeout;
   _mapMsgs[Avm_ASSEMBLE_KEY(eFctMCAN_Communication_Error,MCAN_C_OP_TYPE_STATUS)] = oNewMsg;
   

   oNewMsg.vSetMsgEnabled(TRUE);
   oNewMsg.pFuncSendMsg = dispvidctrl_tclMCanClientAvm::sendMCAN_Communication_Error_ClearSetOut;
   oNewMsg.pFuncTimeoutMsg = NULL;
   _mapMsgs[Avm_ASSEMBLE_KEY(eFctMCAN_Communication_Error_Clear,MCAN_C_OP_TYPE_SET)] = oNewMsg;
   _mapMsgs[Avm_ASSEMBLE_KEY(eFctMCAN_Communication_Error_Clear,MCAN_C_OP_TYPE_SET)]._vecStateBlockedIn.push_back(I_dispvidctrl_tclMCanClientAvmFsm::eStateDeactivated);
   _mapMsgs[Avm_ASSEMBLE_KEY(eFctMCAN_Communication_Error_Clear,MCAN_C_OP_TYPE_SET)]._vecStateBlockedIn.push_back(I_dispvidctrl_tclMCanClientAvmFsm::eStateInitalizing);
   
   oNewMsg.vSetMsgEnabled(TRUE);
   oNewMsg.pFuncSendMsg = NULL;
   oNewMsg.pFuncTimeoutMsg = dispvidctrl_tclMCanClientAvm::wrapMCAN_Communication_Error_ClearStatusInTimeout;
   _mapMsgs[Avm_ASSEMBLE_KEY(eFctMCAN_Communication_Error_Clear,MCAN_C_OP_TYPE_STATUS)] = oNewMsg;
   

   oNewMsg.vSetMsgEnabled(TRUE);
   oNewMsg.pFuncSendMsg = dispvidctrl_tclMCanClientAvm::sendCamera_Diag_SensorSetOut;
   oNewMsg.pFuncTimeoutMsg = NULL;
   _mapMsgs[Avm_ASSEMBLE_KEY(eFctCamera_Diag_Sensor,MCAN_C_OP_TYPE_SET)] = oNewMsg;
   _mapMsgs[Avm_ASSEMBLE_KEY(eFctCamera_Diag_Sensor,MCAN_C_OP_TYPE_SET)]._vecStateBlockedIn.push_back(I_dispvidctrl_tclMCanClientAvmFsm::eStateDeactivated);
   _mapMsgs[Avm_ASSEMBLE_KEY(eFctCamera_Diag_Sensor,MCAN_C_OP_TYPE_SET)]._vecStateBlockedIn.push_back(I_dispvidctrl_tclMCanClientAvmFsm::eStateInitalizing);
   
   oNewMsg.vSetMsgEnabled(TRUE);
   oNewMsg.pFuncSendMsg = dispvidctrl_tclMCanClientAvm::sendCamera_Diag_SensorGetOut;
   oNewMsg.pFuncTimeoutMsg = NULL;
   _mapMsgs[Avm_ASSEMBLE_KEY(eFctCamera_Diag_Sensor,MCAN_C_OP_TYPE_GET)] = oNewMsg;
   _mapMsgs[Avm_ASSEMBLE_KEY(eFctCamera_Diag_Sensor,MCAN_C_OP_TYPE_GET)]._vecStateBlockedIn.push_back(I_dispvidctrl_tclMCanClientAvmFsm::eStateDeactivated);
   _mapMsgs[Avm_ASSEMBLE_KEY(eFctCamera_Diag_Sensor,MCAN_C_OP_TYPE_GET)]._vecStateBlockedIn.push_back(I_dispvidctrl_tclMCanClientAvmFsm::eStateInitalizing);
   
   oNewMsg.vSetMsgEnabled(TRUE);
   oNewMsg.pFuncSendMsg = NULL;
   oNewMsg.pFuncTimeoutMsg = dispvidctrl_tclMCanClientAvm::wrapCamera_Diag_SensorStatusInTimeout;
   _mapMsgs[Avm_ASSEMBLE_KEY(eFctCamera_Diag_Sensor,MCAN_C_OP_TYPE_STATUS)] = oNewMsg;
   
   oNewMsg.vSetMsgEnabled(TRUE);
   oNewMsg.pFuncSendMsg = NULL;
   oNewMsg.pFuncTimeoutMsg = NULL;
   _mapMsgs[Avm_ASSEMBLE_KEY(eFctCamera_Diag_Sensor,MCAN_C_OP_TYPE_INDICATION)] = oNewMsg;
   

   
   // dispvidctrl_tclMCanClientAvm::dispvidctrl_tclMCanClientAvm: user specific code start

   _pMcanClientAvmFsm = OSAL_NULL;
   _pControl_HmiAvm3 = OSAL_NULL;
   _pClientAudio = OSAL_NULL;
   _pServiceRvc = OSAL_NULL;

   if ( OSAL_OK != OSAL_s32TimerCreate( (OSAL_tpfCallback) pfCallbackTimer_BciSwitchReset, (tPVoid)this, &_hTimerHandle_BciSwitchReset ) ) {
       _hTimerHandle_BciSwitchReset = OSAL_C_INVALID_HANDLE;
   }   

   // init some Rx-parameter related member variables   
   _oRxParam_UnitConfiguration.u8Unit_ID      = 0x00;
   _oRxParam_UnitConfiguration.u8MsgVersHigh  = 0;
   _oRxParam_UnitConfiguration.u8MsgVersMid   = 0;
   _oRxParam_UnitConfiguration.u8MsgVersLow   = 0;
   _bRxParamsValid_View_Change_08AVM          = FALSE;
   _bRxParamsValid_Blanking_less_Change_08AVM = FALSE;
      
   // Status Rx-expected timeouts (after sending Get/Set/Increment/Decrement)
   MCAN_MAPMSG(Software_Version,STATUS).vSetTimeout(1500);
   MCAN_MAPMSG(Hardware_Version,STATUS).vSetTimeout(1500);
   MCAN_MAPMSG(AVM_Sonar_Buzzer,STATUS).vSetTimeout(1500);
   MCAN_MAPMSG(Camera_Setting_08AVM,STATUS).vSetTimeout(1500);
   MCAN_MAPMSG(Camera_Primary_Setting,STATUS).vSetTimeout(1500);
   MCAN_MAPMSG(MCAN_Communication_Error,STATUS).vSetTimeout(1500);
   MCAN_MAPMSG(MCAN_Communication_Error_Clear,STATUS).vSetTimeout(1500);
   MCAN_MAPMSG(Camera_Diag_Sensor,STATUS).vSetTimeout(1500);
   
   // Status Tx-allowed timeouts (after reception of Get/Set/Increment/Decrement)
   MCAN_MAPMSG(View_Change_08AVM,STATUS).vSetTimeout(1500);

   _bConfigDetermined      = FALSE;
   _bAvmPhase3Configured   = FALSE;
   _bEarlyPhaseOver        = FALSE;
   _bDiagVideoActive       = FALSE;
   _bActivatingVidSettings = FALSE;

   _u8BciSwitchId        = (tU8)rvc_fi_tcl_e8_AVMph3_SwitchId::FI_EN_NONE;
   _u8BciSwitchStatus    = (tU8)rvc_fi_tcl_e8_AVMph3_SwitchStatus::FI_EN_NORMAL;

   _u8BeepTriggerSwitchId = 0x00;
   
   // dispvidctrl_tclMCanClientAvm::dispvidctrl_tclMCanClientAvm: user specific code end
   return;
}

dispvidctrl_tclMCanClientAvm::~dispvidctrl_tclMCanClientAvm()
{
   ETG_TRACE_USR4(("dispvidctrl_tclMCanClientAvm::~dispvidctrl_tclMCanClientAvm() entered."));
   _pCsmBase = OSAL_NULL;
   if ( OSAL_OK == OSAL_s32TimerDelete( _hAvmTimeoutTimer ) ) {
       _hAvmTimeoutTimer = OSAL_C_INVALID_HANDLE;
   }
   
   // dispvidctrl_tclMCanClientAvm::~dispvidctrl_tclMCanClientAvm: user specific code start
   _pMcanClientAvmFsm = OSAL_NULL;
   _pControl_HmiAvm3 = OSAL_NULL;
   _pClientAudio = OSAL_NULL;
   _pServiceRvc = OSAL_NULL;
   
   //stop and delete all timer
   if (OSAL_C_INVALID_HANDLE  !=  _hTimerHandle_BciSwitchReset) {
      (void) OSAL_s32TimerSetTime(_hTimerHandle_BciSwitchReset, 0, 0);
      (void) OSAL_s32TimerDelete (_hTimerHandle_BciSwitchReset);
      _hTimerHandle_BciSwitchReset = OSAL_C_INVALID_HANDLE;
   }
   // dispvidctrl_tclMCanClientAvm::~dispvidctrl_tclMCanClientAvm: user specific code end
   return;
}

tVoid dispvidctrl_tclMCanClientAvm::vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("dispvidctrl_tclMCanClientAvm::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(dispvidctrl_tclBaseIf::ECmdTypes, pMsg->eCmd), pMsg->u.u32Data));

   // dispvidctrl_tclMCanClientAvm::vHandleMessageEntry: user specific code start
   if (!_bAvmPhase3Configured) {
       ETG_TRACE_USR4(("dispvidctrl_tclMCanClientAvm::vHandleMessage(): AVM phase 3 not configured, doing nothing"));
       return;
   }
   // dispvidctrl_tclMCanClientAvm::vHandleMessageEntry: user specific code end
   
   if (pMsg->eCmd == dispvidctrl_tclBaseIf::eAvmUpdate) {
       vCheck4Messages2Send();
   }

   if (pMsg->eCmd == dispvidctrl_tclBaseIf::eAccChanged) {
       if (FALSE == pMsg->u.bData) {
           //start debouncing
           _u32AccOffDetected = OSAL_ClockGetElapsedTime();
       } else {
           _u32AccOffDetected = MCAN_DEFAULT_TIME;
       }
       vCheck4Messages2Send();
   }

   if (pMsg->eCmd == dispvidctrl_tclBaseIf::eAvmCommTestResult) {
       DISPVIDCTRL_NULL_POINTER_CHECK(_pCsmBase);
       MCAN_tenTestResult oTestResult = _pCsmBase->enGetCommTestResult();

       if (MCAN_EN_TEST_RESULT_PASSED == oTestResult) {
       	   ETG_TRACE_USR1(("dispvidctrl_tclMCanClientAvm::vHandleMessage(): CommTestResult PASSED" ));
           // dispvidctrl_tclMCanClientAvm::vHandleMessageCommTestResultPassed: user specific code start
           // dispvidctrl_tclMCanClientAvm::vHandleMessageCommTestResultPassed: user specific code end
       } else if (MCAN_EN_TEST_RESULT_FAILED == oTestResult) {
       	   ETG_TRACE_USR1(("dispvidctrl_tclMCanClientAvm::vHandleMessage(): CommTestResult FAILED" ));
           // dispvidctrl_tclMCanClientAvm::vHandleMessageCommTestResultFailed: user specific code start
           // dispvidctrl_tclMCanClientAvm::vHandleMessageCommTestResultFailed: user specific code end
       }
   }

   if (pMsg->eCmd == dispvidctrl_tclBaseIf::eAvmCDataConfTestResult) {
       DISPVIDCTRL_NULL_POINTER_CHECK(_pCsmBase);
       MCAN_tenTestResult oTestResult = _pCsmBase->enGetCDataConfTestResult();

       if (MCAN_EN_TEST_RESULT_PASSED == oTestResult) {
       	   ETG_TRACE_USR1(("dispvidctrl_tclMCanClientAvm::vHandleMessage(): CDataConfTestResult PASSED" ));
           // dispvidctrl_tclMCanClientAvm::vHandleMessageCDataConfTestResultPassed: user specific code start
           // dispvidctrl_tclMCanClientAvm::vHandleMessageCDataConfTestResultPassed: user specific code end
       } else if (MCAN_EN_TEST_RESULT_FAILED == oTestResult) {
       	   ETG_TRACE_USR1(("dispvidctrl_tclMCanClientAvm::vHandleMessage(): CDataConfTestResult FAILED" ));
           // dispvidctrl_tclMCanClientAvm::vHandleMessageCDataConfTestResultFailed: user specific code start
           // dispvidctrl_tclMCanClientAvm::vHandleMessageCDataConfTestResultFailed: user specific code end
       }
   }

   if (pMsg->eCmd == dispvidctrl_tclBaseIf::eAvmDDataConfTestResult) {
       DISPVIDCTRL_NULL_POINTER_CHECK(_pCsmBase);
       MCAN_tenTestResult oTestResult = _pCsmBase->enGetDDataConfTestResult();

       if (MCAN_EN_TEST_RESULT_PASSED == oTestResult) {
       	   ETG_TRACE_USR1(("dispvidctrl_tclMCanClientAvm::vHandleMessage(): DDataConfTestResult PASSED" ));
           // dispvidctrl_tclMCanClientAvm::vHandleMessageDDataConfTestResultPassed: user specific code start
           // dispvidctrl_tclMCanClientAvm::vHandleMessageDDataConfTestResultPassed: user specific code end
       } else if (MCAN_EN_TEST_RESULT_FAILED == oTestResult) {
       	   ETG_TRACE_USR1(("dispvidctrl_tclMCanClientAvm::vHandleMessage(): DDataConfTestResult FAILED" ));
           // dispvidctrl_tclMCanClientAvm::vHandleMessageDDataConfTestResultFailed: user specific code start
           // dispvidctrl_tclMCanClientAvm::vHandleMessageDDataConfTestResultFailed: user specific code end
       }
   }
   // dispvidctrl_tclMCanClientAvm::vHandleMessage: user specific code start
   
   if (pMsg->eCmd == dispvidctrl_tclBaseIf::eClientMcanAvm3) {
       vHandleControlOutput((tenControlOutputEvent)(pMsg->u.u32Data));
   }

#ifdef DISPVIDCTRL_USE_DUMMY_COMMANDS
   if        (pMsg->eCmd == 200 /* 0xC8 */ ) {
      vSendSwitchInputToFsm(rvc_fi_tcl_e8_AVMph3_SwitchId::FI_EN_CAMERA);
   } else if (pMsg->eCmd == 201 /* 0xC9 */ ) {
      vFillAndSendMsg_Direct_Camera_Off_Indication();
   } else if (pMsg->eCmd == 202 /* 0xCA */ ) {
      vSendSwitchInputToFsm(pMsg->u.u32Data);
   } else if (pMsg->eCmd == 203 /* 0xCB */ ) {
      vFillAndSendMsg_SW_Signal_Indication((tU8)(pMsg->u.u32Data), tcl_ITM_Camera_System_e32_Disp_Status::FI_EN_EXCEPT_FOR_CAMERA_DISPLAY);
   } else if (pMsg->eCmd == 204 /* 0xCC */ ) {
      vFillAndSendMsg_SW_Signal_Indication((tU8)(pMsg->u.u32Data), tcl_ITM_Camera_System_e32_Disp_Status::FI_EN_CAMERA_DISPLAY);
   } else if (pMsg->eCmd == 205 /* 0xCD */ ) {
      vHandleControlOutput(eServiceReqShowVideo,pMsg->u.u32Data);
   } else if (pMsg->eCmd == 206 /* 0xCE */ ) {
      if (pMsg->u.u32Data)
         vSendEventToControl(EN_CONTROL_HMIAVM3__SERVICE_REQUEST_VISUALISATION, rvc_fi_tcl_e8_RVC_SystemStatus::FI_EN_AVM_VISUALISATION_ON_CAMERA_SETTINGS);
      else
         vSendEventToControl(EN_CONTROL_HMIAVM3__SERVICE_REQUEST_VISUALISATION, rvc_fi_tcl_e8_RVC_SystemStatus::FI_EN_VISUALISATION_OFF);
   }
#endif
   
   // dispvidctrl_tclMCanClientAvm::vHandleMessage: user specific code end
}

tVoid dispvidctrl_tclMCanClientAvm::vHandleTraceMessage(const tUChar* puchData)
{
   DISPVIDCTRL_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("dispvidctrl_tclMCanClientAvm::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // dispvidctrl_tclMCanClientAvm::vHandleTraceMessage: user specific code start
   // dispvidctrl_tclMCanClientAvm::vHandleTraceMessage: user specific code end
}

tVoid dispvidctrl_tclMCanClientAvm::vGetReferences() {

   _pCsmBase = dynamic_cast<I_dispvidctrl_tclClientAvmAdaptor*>(_cpoMain->getHandler("I_dispvidctrl_tclClientAvmAdaptor"));
   DISPVIDCTRL_NULL_POINTER_CHECK(_pCsmBase);
   _pCsmBase->vSetCallbackIf(this);

   // dispvidctrl_tclMCanClientAvm::vGetReferences: user specific code start
   
   _pMcanClientAvmFsm = dynamic_cast<I_dispvidctrl_tclMCanClientAvmFsm*>(_cpoMain->getHandler("I_dispvidctrl_tclMCanClientAvmFsm"));
   DISPVIDCTRL_NULL_POINTER_CHECK(_pMcanClientAvmFsm);

    _pControl_HmiAvm3 = dynamic_cast<dispvidctrl_tclControl_HmiAvm3*>(_cpoMain->getHandler("dispvidctrl_tclControl_HmiAvm3"));
    DISPVIDCTRL_NULL_POINTER_CHECK(_pControl_HmiAvm3);

   _pClientAudio = dynamic_cast<Idispvidctrl_tclClientAudioIf*>(_cpoMain->getHandler("Idispvidctrl_tclClientAudioIf"));
   DISPVIDCTRL_NULL_POINTER_CHECK(_pClientAudio);
   
   _pServiceRvc = dynamic_cast<Idispvidctrl_tclServiceRvcIf*>(_cpoMain->getHandler("Idispvidctrl_tclServiceRvcIf"));
   DISPVIDCTRL_NULL_POINTER_CHECK(_pServiceRvc);
   
    
   _bEarlyPhaseOver = TRUE;
   // dispvidctrl_tclMCanClientAvm::vGetReferences: user specific code end
}


tVoid dispvidctrl_tclMCanClientAvm::vTraceInfo()
{
   ETG_TRACE_USR4(("dispvidctrl_tclMCanClientAvm::vTraceInfo() entered."));
   // dispvidctrl_tclMCanClientAvm::vTraceInfo: user specific code start
   // dispvidctrl_tclMCanClientAvm::vTraceInfo: user specific code end

   I_dispvidctrl_tclMCanClientAvmFsm* pFsm = dynamic_cast<I_dispvidctrl_tclMCanClientAvmFsm*>(_cpoMain->getHandler("I_dispvidctrl_tclMCanClientAvmFsm"));
   DISPVIDCTRL_NULL_POINTER_CHECK(pFsm);

   tU32 u32CurState = pFsm->u32GetState();

   tU32 u32RemainingTime = 0;
   tU32 u32IntervalTime  = 0;
   (tVoid)OSAL_s32TimerGetTime(_hAvmTimeoutTimer, &u32RemainingTime, &u32IntervalTime);

   ETG_TRACE_FATAL(("dispvidctrl_tclMCanClientAvm::vTraceInfo(): CurrentState: %d, Send Allowed: %d, Time to next Check: %dms.", ETG_CENUM(I_dispvidctrl_tclMCanClientAvmFsm::tenFsmState, u32CurState), _pCsmBase->bAllowedToSend(), u32RemainingTime));


   std::vector < TMsgHeader >::iterator itForce;
   for (itForce = _vecForceSendMsgQueue.begin(); itForce != _vecForceSendMsgQueue.end(); ++itForce){
       tclMCanClientMsgInfo*  pMcanMsgObj = &_mapMsgs[MCAN_LOCAL_ASSEMBLE_KEY(itForce->u16MsgId,itForce->u8MsgOpcode)];
       ETG_TRACE_USR1(("dispvidctrl_tclMCanClientAvm::vTraceInfo(): Forced to send message: MsgInfo: ID: 0x%04x, Opcode: 0x%02x",
               ETG_ENUM(tenAvmMessageName, itForce->u16MsgId), ETG_ENUM(eMcanOpcode, itForce->u8MsgOpcode)))
   }

   std::vector < TMsgHeader >::iterator itSequence;
   for (itSequence = _vecSequenceMsgBlockAllOtherQueue.begin(); itSequence != _vecSequenceMsgBlockAllOtherQueue.end(); ++itSequence){
       tclMCanClientMsgInfo*  pMcanMsgObj = &_mapMsgs[MCAN_LOCAL_ASSEMBLE_KEY(itSequence->u16MsgId,itSequence->u8MsgOpcode)];
       ETG_TRACE_USR1(("dispvidctrl_tclMCanClientAvm::vTraceInfo(): send message of sequence(and block all other msgs): MsgInfo: ID: 0x%04x, Opcode: 0x%02x",
               ETG_ENUM(tenAvmMessageName, itSequence->u16MsgId),  ETG_ENUM(eMcanOpcode, itSequence->u8MsgOpcode)));
   }

   //we are waiting for a sequence of signals
   itSequence = _vecSequenceMsgQueue.begin();
   for (itSequence = _vecSequenceMsgQueue.begin(); itSequence != _vecSequenceMsgQueue.end(); ++itSequence){
       tclMCanClientMsgInfo*  pMcanMsgObj = &_mapMsgs[MCAN_LOCAL_ASSEMBLE_KEY(itSequence->u16MsgId,itSequence->u8MsgOpcode)];
       ETG_TRACE_USR1(("dispvidctrl_tclMCanClientAvm::vTraceInfo(): send message of sequence: MsgInfo: ID: 0x%04x, Opcode: 0x%02x",
               ETG_ENUM(tenAvmMessageName, itSequence->u16MsgId),  ETG_ENUM(eMcanOpcode, itSequence->u8MsgOpcode)));
   }
   
   std::map < tU32, tclMCanClientMsgInfo >::iterator it;
   for (it = _mapMsgs.begin(); it != _mapMsgs.end(); ++it){
       tU16 u16MsgId    = Avm_GET_MSG_ID(it->first);
       tU8  u8MsgOpcode = Avm_GET_MSG_OPCODE(it->first);
       ETG_TRACE_FATAL(("dispvidctrl_tclMCanClientAvm::vTraceInfo(): MsgInfo: %04x, Opcode: %02x, TS send: %dms, TS: rcv: %dms, TS timeout: %dms, DataChanged: %d, Cfg: %d, Enabled: %d.",
               ETG_ENUM(tenAvmMessageName, u16MsgId), ETG_ENUM(eMcanOpcode, u8MsgOpcode),
               it->second.u32GetLastSendTimestamp(), it->second.u32GetLastRcvTimestamp(),
               it->second.u32MsgTimeout(), it->second.bIsDataChanged(),
               it->second.bIsMsgConfigured(), it->second.bIsMsgEnabled()
               ));

   }
   

}


tVoid dispvidctrl_tclMCanClientAvm::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("dispvidctrl_tclMCanClientAvm::vStartCommunication() entered."));
   // dispvidctrl_tclMCanClientAvm::vStartCommunication: user specific code start
   // dispvidctrl_tclMCanClientAvm::vStartCommunication: user specific code end
}

OSAL_tpfCallback dispvidctrl_tclMCanClientAvm::vCallbackAvmTimeoutTimer(tVoid* pvArg) {
    dispvidctrl_tclMCanClientAvm* poMyRef = (dispvidctrl_tclMCanClientAvm*) pvArg;
    if (poMyRef) {
        poMyRef->_cpoMain->theServer()->vPostMsgAvmUpdate("I_dispvidctrl_tclMCanClientAvm");
    }
    return 0;
}

tVoid dispvidctrl_tclMCanClientAvm::vConnectionUp() {


   //add message to queue
   // dispvidctrl_tclMCanClientAvm::vConnectionUp: user specific code start
   // dispvidctrl_tclMCanClientAvm::vConnectionUp: user specific code end
   _cpoMain->theServer()->vPostMsgAvmUpdate("I_dispvidctrl_tclMCanClientAvm");

}

tVoid dispvidctrl_tclMCanClientAvm::vCheck4Messages2Send(tVoid) {
    DISPVIDCTRL_NULL_POINTER_CHECK(_pCsmBase);

    ETG_TRACE_USR4(("dispvidctrl_tclMCanClientAvm::vCheck4Messages2Send()"));

    // dispvidctrl_tclMCanClientAvm::vCheck4Messages2Start: user specific code start
    // dispvidctrl_tclMCanClientAvm::vCheck4Messages2Start: user specific code end
    
    tU32 u32RemainingTime, u32IntervalTime;
    if (OSAL_s32TimerGetTime(_hAvmTimeoutTimer, &u32RemainingTime, &u32IntervalTime) == OSAL_OK) {
        if (u32RemainingTime == 0) {
            OSAL_s32TimerSetTime( _hAvmTimeoutTimer, 1000, 0 );
        }
    }
    
    I_dispvidctrl_tclMCanClientAvmFsm* pFsm = dynamic_cast<I_dispvidctrl_tclMCanClientAvmFsm*>(_cpoMain->getHandler("I_dispvidctrl_tclMCanClientAvmFsm"));
    DISPVIDCTRL_NULL_POINTER_CHECK(pFsm);

    tU32 u32CurState        = pFsm->u32GetState();
    tU32 u32CurrentTime     = OSAL_ClockGetElapsedTime();
    tU32 u32EarliestTimeout = MCAN_DEFAULT_TIME;

    if ( (_u32AccOffDetected == MCAN_DEFAULT_TIME) && !pFsm->bIsAccActive()) {
        //ACC is off and debounce is inactive
        _u32AccOffDetected = u32CurrentTime;
    }

    ETG_TRACE_USR1(("dispvidctrl_tclMCanClientAvm::vCheck4Messages2Send(): Current time: %dms / Acc Off detected: %dms.", u32CurrentTime, _u32AccOffDetected));
    if (_u32AccOffDetected != MCAN_DEFAULT_TIME) {

        if ((_u32AccOffDetected + MCAN_ACC_DEBOUNCE_TIME)  <= u32CurrentTime) {
            //we are waiting for ACC (debounce)
            _cpoMain->theServer()->vPostMsgAvmAccOffDecounced("I_dispvidctrl_tclMCanClientAvmFsm");
            _u32AccOffDetected = MCAN_DEFAULT_TIME;
        } else {
            u32EarliestTimeout = _u32AccOffDetected + MCAN_ACC_DEBOUNCE_TIME;
        }
    }

    if ( (_u32SequenceMsgQueueChangedTime != MCAN_DEFAULT_TIME) && ((_u32SequenceMsgQueueChangedTime + MCAN_QUEUE_DELAY_TIME) < u32CurrentTime)) {
        ETG_TRACE_USR1(("dispvidctrl_tclMCanClientAvm::vCheck4Messages2Send(): Clear sequence message queue!"));
        _u32SequenceMsgQueueChangedTime = MCAN_DEFAULT_TIME;
        _vecSequenceMsgQueue.clear();
    }
    if ( (_u32SequenceBlockMsgQueueChangedTime != MCAN_DEFAULT_TIME) && ((_u32SequenceBlockMsgQueueChangedTime + MCAN_QUEUE_DELAY_TIME) < u32CurrentTime)) {
        ETG_TRACE_USR1(("dispvidctrl_tclMCanClientAvm::vCheck4Messages2Send(): Clear sequence (block) message queue!"));
        _u32SequenceBlockMsgQueueChangedTime = MCAN_DEFAULT_TIME;
        _vecSequenceMsgBlockAllOtherQueue.clear();
    }
    
    if (_pCsmBase->bAllowedToSend()) {    
        
        // dispvidctrl_tclMCanClientAvm::vCheck4Messages2SendStart: user specific code start
        // dispvidctrl_tclMCanClientAvm::vCheck4Messages2SendStart: user specific code end
        
        //check if some messages should be send in force mode e.g. for initialization purposes
        std::vector < TMsgHeader >::iterator itForce;
        for (itForce = _vecForceSendMsgQueue.begin(); itForce != _vecForceSendMsgQueue.end(); ++itForce){        
            tclMCanClientMsgInfo*  pMcanMsgObj = &_mapMsgs[MCAN_LOCAL_ASSEMBLE_KEY(itForce->u16MsgId,itForce->u8MsgOpcode)];
            if (pMcanMsgObj->bIsMsgConfigured() && pMcanMsgObj->bIsMsgEnabled()) {
                ETG_TRACE_USR1(("dispvidctrl_tclMCanClientAvm::vCheck4Messages2Send(): Forced to send message: MsgInfo: ID: 0x%04x, Opcode: 0x%02x", 
                ETG_ENUM(tenAvmMessageName, itForce->u16MsgId), ETG_ENUM(eMcanOpcode, itForce->u8MsgOpcode)))
                pMcanMsgObj->pFuncSendMsg(this);
            }
            _vecForceSendMsgQueue.erase(itForce);
            //send only one message and wait until channel is free again!!!!
            return;
        }
        _vecForceSendMsgQueue.clear();
            
        //we are waiting for a sequence of signals
        std::vector < TMsgHeader >::iterator itSequence = _vecSequenceMsgBlockAllOtherQueue.begin();
        if (itSequence != _vecSequenceMsgBlockAllOtherQueue.end()) {
            tclMCanClientMsgInfo*  pMcanMsgObj = &_mapMsgs[MCAN_LOCAL_ASSEMBLE_KEY(itSequence->u16MsgId,itSequence->u8MsgOpcode)];
            if (pMcanMsgObj->bIsMsgConfigured() && pMcanMsgObj->bIsMsgEnabled()&& pMcanMsgObj->bIsDataChanged()) {
                ETG_TRACE_USR1(("dispvidctrl_tclMCanClientAvm::vCheck4Messages2Send(): send message of sequence(and block all other msgs): MsgInfo: ID: 0x%04x, Opcode: 0x%02x",
                        ETG_ENUM(tenAvmMessageName, itSequence->u16MsgId),  ETG_ENUM(eMcanOpcode, itSequence->u8MsgOpcode)));
                pMcanMsgObj->pFuncSendMsg(this);
                _vecSequenceMsgBlockAllOtherQueue.erase(itSequence);
            }
            //send only one message and wait until channel is free again!!!!
            return;
        }

        //we are waiting for a sequence of signals
        itSequence = _vecSequenceMsgQueue.begin();
        if (itSequence != _vecSequenceMsgQueue.end()) {
            tclMCanClientMsgInfo*  pMcanMsgObj = &_mapMsgs[MCAN_LOCAL_ASSEMBLE_KEY(itSequence->u16MsgId,itSequence->u8MsgOpcode)];
            if (pMcanMsgObj->bIsMsgConfigured() && pMcanMsgObj->bIsMsgEnabled()&& pMcanMsgObj->bIsDataChanged()) {
                ETG_TRACE_USR1(("dispvidctrl_tclMCanClientAvm::vCheck4Messages2Send(): send message of sequence: MsgInfo: ID: 0x%04x, Opcode: 0x%02x",
                        ETG_ENUM(tenAvmMessageName, itSequence->u16MsgId),  ETG_ENUM(eMcanOpcode, itSequence->u8MsgOpcode)));
                pMcanMsgObj->pFuncSendMsg(this);
                _vecSequenceMsgQueue.erase(itSequence);
            }
            //send only one message and wait until channel is free again!!!!
            return;
        }
            
        std::map < tU32, tclMCanClientMsgInfo >::iterator it;
        //iteration to check current status of message map
        for (it = _mapMsgs.begin(); it != _mapMsgs.end(); ++it){
            tU16 u16MsgId    = Avm_GET_MSG_ID(it->first);
            tU8  u8MsgOpcode = Avm_GET_MSG_OPCODE(it->first);
            if (it->second.bIsMsgConfigured() && it->second.bIsMsgEnabled() && it->second.bIsDataChanged()) {
                if (OSAL_ClockGetElapsedTime() < it->second.u32MsgTimeout()) {
                    ETG_TRACE_USR1(("dispvidctrl_tclMCanClientAvm::vCheck4Messages2Send(): Debounce active for MsgInfo: ID: 0x%04x, Opcode: 0x%02x, TS send: %dms,  TS timeout: %dms."
                            , ETG_ENUM(tenAvmMessageName, u16MsgId), ETG_ENUM(eMcanOpcode, u8MsgOpcode), it->second.u32GetLastSendTimestamp(), it->second.u32MsgTimeout()
                            ));
                    if (u32EarliestTimeout > it->second.u32MsgTimeout() ){
                        u32EarliestTimeout = it->second.u32MsgTimeout();
                    }
                } else if ((u8MsgOpcode == MCAN_C_OP_TYPE_STATUS) && (OSAL_ClockGetElapsedTime() > it->second.u32GetMsgSendPeriodTimeout())) {
                    ETG_TRACE_USR1(("dispvidctrl_tclMCanClientAvm::vCheck4Messages2Send(): Send period over for MsgInfo: ID: 0x%04x, Opcode: 0x%02x, TS timeout: %dms."
                            , ETG_ENUM(tenAvmMessageName, u16MsgId), ETG_ENUM(eMcanOpcode, u8MsgOpcode), it->second.u32GetMsgSendPeriodTimeout()
                            ));
                    it->second.vSetMsgEnabled(FALSE);
                }
            } else if (it->second.bSendingInProgress()) {
                tU32 u32MsgTo = it->second.u32MsgTimeout();
                if (u32MsgTo < OSAL_ClockGetElapsedTime()) {
                    if (NULL != it->second.pFuncTimeoutMsg) {
                        //timeout for message detected --> call callbackfunction
                        ETG_TRACE_USR1(("dispvidctrl_tclMCanClientAvm::vCheck4Messages2Send(): TIMEOUT --> MsgInfo: ID: 0x%04x, Opcode: 0x%02x", ETG_ENUM(tenAvmMessageName, u16MsgId), ETG_ENUM(eMcanOpcode, u8MsgOpcode) ));
                        it->second.pFuncTimeoutMsg(this);
    
                        //just to reset insending
                        it->second.vMsgReceived(TRUE);
                    }
                } else if (u32EarliestTimeout > u32MsgTo ){
                    u32EarliestTimeout = u32MsgTo;
                }
            }
        }
        
        //and now check if a message has to be send
        tBool bMsgFound = FALSE;
        for (it = _mapMsgs.begin(); (it != _mapMsgs.end()) && !bMsgFound && (_vecSequenceMsgBlockAllOtherQueue.size() == 0); ++it){
            tU16 u16MsgId    = Avm_GET_MSG_ID(it->first);
            tU8  u8MsgOpcode = Avm_GET_MSG_OPCODE(it->first);
            if (it->second.bIsMsgConfigured() && it->second.bIsMsgEnabled() && it->second.bIsDataChanged() && (OSAL_ClockGetElapsedTime() >= it->second.u32MsgTimeout())) {

                ETG_TRACE_USR1(("dispvidctrl_tclMCanClientAvm::vCheck4Messages2Send(): MsgInfo: ID: 0x%04x, Opcode: 0x%02x, TS send: %dms, TS: rcv: %dms, TS timeout: %dms."
                        , ETG_ENUM(tenAvmMessageName, u16MsgId), ETG_ENUM(eMcanOpcode, u8MsgOpcode), it->second.u32GetLastSendTimestamp(), it->second.u32GetLastRcvTimestamp(), it->second.u32MsgTimeout()));
                //check if this message should be send in a special order
                tBool bIsInSequenceQueue = FALSE;
                std::vector < TMsgHeader >::iterator itSequenceWoBlock = _vecSequenceMsgQueue.begin();
                for (itSequenceWoBlock = _vecSequenceMsgQueue.begin(); !bIsInSequenceQueue && (itSequenceWoBlock != _vecSequenceMsgQueue.end()); ++itSequenceWoBlock){
                    if (  (itSequenceWoBlock->u16MsgId == u16MsgId)
                       && (itSequenceWoBlock->u8MsgOpcode == u8MsgOpcode)
                        ) {
                        bIsInSequenceQueue = TRUE;
                    }
                }


                //check if we are allowed to send in current state
                if ( !(std::find(it->second._vecStateBlockedIn.begin(), it->second._vecStateBlockedIn.end(), u32CurState) != it->second._vecStateBlockedIn.end())
                    && !bIsInSequenceQueue
                   ) {
                    ETG_TRACE_USR1(("dispvidctrl_tclMCanClientAvm::vCheck4Messages2Send(): MsgInfo: ID: 0x%04x, Opcode: 0x%02x, TS send: %dms, TS: rcv: %dms, TS timeout: %dms."
                            , ETG_ENUM(tenAvmMessageName, u16MsgId), ETG_ENUM(eMcanOpcode, u8MsgOpcode), it->second.u32GetLastSendTimestamp(), it->second.u32GetLastRcvTimestamp(), it->second.u32MsgTimeout()
                    ));
                    if (NULL != it->second.pFuncSendMsg) {
                        ETG_TRACE_USR1(("dispvidctrl_tclMCanClientAvm::vCheck4Messages2Send(): FunPointer to call:0x%08x", it->second.pFuncSendMsg));
                        it->second.pFuncSendMsg(this);
                        //send only one message and wait until channel is free again!!!!
                        bMsgFound = TRUE;

                        //check for messages with cyclic send and retrigger timer if needed
                        if (it->second.bIsDataChanged()){
                            if (u32EarliestTimeout > it->second.u32MsgTimeout() ){
                                u32EarliestTimeout = it->second.u32MsgTimeout();
                            }
                        }
                                                
                    }
                } else {
                    ETG_TRACE_USR1(("dispvidctrl_tclMCanClientAvm::vCheck4Messages2Send(): Blocked MsgInfo: ID: 0x%04x, Opcode: 0x%02x, %d, %d."
                            , ETG_ENUM(tenAvmMessageName, u16MsgId), ETG_ENUM(eMcanOpcode, u8MsgOpcode), u32CurState, bIsInSequenceQueue));
                }
            }
        }
                
        if ((u32EarliestTimeout != 0xffffffff) && (u32EarliestTimeout > OSAL_ClockGetElapsedTime())){
            //retrigger timer
            ETG_TRACE_USR1(("dispvidctrl_tclMCanClientAvm::vCheck4Messages2Send(): Calculated timeout: %d (%d).", u32EarliestTimeout - OSAL_ClockGetElapsedTime(), u32EarliestTimeout));
            if ( OSAL_s32TimerSetTime( _hAvmTimeoutTimer, u32EarliestTimeout - OSAL_ClockGetElapsedTime(), 0 ) != OSAL_OK ) {
            }
        }
        // dispvidctrl_tclMCanClientAvm::vCheck4Messages2SendEndSend: user specific code start
        // dispvidctrl_tclMCanClientAvm::vCheck4Messages2SendEndSen: user specific code end
     }
     // dispvidctrl_tclMCanClientAvm::vCheck4Messages2SendEnd: user specific code start
     // dispvidctrl_tclMCanClientAvm::vCheck4Messages2SendEnd: user specific code end
}
void dispvidctrl_tclMCanClientAvm::onSoftware_VersionStatusIn(tcl_ITM_Camera_System_Software_Version_StatusIn& oIn_Software_Version) {
    ETG_TRACE_USR4(("dispvidctrl_tclMCanClientAvm::onSoftware_VersionStatusIn(): called"));
    _mapMsgs[Avm_ASSEMBLE_KEY(eFctSoftware_Version,MCAN_C_OP_TYPE_STATUS)].vMsgReceived();
    
    if (_mapMsgs[Avm_ASSEMBLE_KEY(eFctSoftware_Version,MCAN_C_OP_TYPE_STATUS)].bIsMsgConfigured()) {
         // dispvidctrl_tclMCanClientAvm::onSoftware_VersionStatusIn: user specific code start
         _oRxParam_Software_Version = oIn_Software_Version.oSoftware_Version;
         _oRxParam_Sonar_Soft_Ver   = oIn_Software_Version.oSonar_Soft_Ver;
         vSendSoftwareVersionInfoToServer();
         // dispvidctrl_tclMCanClientAvm::onSoftware_VersionStatusIn: user specific code end
    } else {
         ETG_TRACE_FATAL(("dispvidctrl_tclMCanClientAvm::onSoftware_VersionStatusIn(): Received not configured MCAN message!"));
         // dispvidctrl_tclMCanClientAvm::onSoftware_VersionStatusInnCfg: user specific code start
         // dispvidctrl_tclMCanClientAvm::onSoftware_VersionStatusInnCfg: user specific code end
    }
}
void dispvidctrl_tclMCanClientAvm::onSoftware_VersionStatusInTimeout(tVoid) {
    ETG_TRACE_USR1(("dispvidctrl_tclMCanClientAvm::onSoftware_VersionStatusInTimeout(): called"));
    
    // dispvidctrl_tclMCanClientAvm::onSoftware_VersionStatusInTimeout: user specific code start
    // dispvidctrl_tclMCanClientAvm::onSoftware_VersionStatusInTimeout: user specific code end
}
void dispvidctrl_tclMCanClientAvm::onHardware_VersionStatusIn(tcl_ITM_Camera_System_Hardware_Version_StatusIn& oIn_Hardware_Version) {
    ETG_TRACE_USR4(("dispvidctrl_tclMCanClientAvm::onHardware_VersionStatusIn(): called"));
    _mapMsgs[Avm_ASSEMBLE_KEY(eFctHardware_Version,MCAN_C_OP_TYPE_STATUS)].vMsgReceived();
    
    if (_mapMsgs[Avm_ASSEMBLE_KEY(eFctHardware_Version,MCAN_C_OP_TYPE_STATUS)].bIsMsgConfigured()) {
         // dispvidctrl_tclMCanClientAvm::onHardware_VersionStatusIn: user specific code start
         _oRxParam_Hardware_Version = oIn_Hardware_Version.oHardware_Version;
         _oRxParam_Sonar_Hard_Ver   = oIn_Hardware_Version.oSonar_Hard_Ver;
         vSendHardwareVersionInfoToServer();
         // dispvidctrl_tclMCanClientAvm::onHardware_VersionStatusIn: user specific code end
    } else {
         ETG_TRACE_FATAL(("dispvidctrl_tclMCanClientAvm::onHardware_VersionStatusIn(): Received not configured MCAN message!"));
         // dispvidctrl_tclMCanClientAvm::onHardware_VersionStatusInnCfg: user specific code start
         // dispvidctrl_tclMCanClientAvm::onHardware_VersionStatusInnCfg: user specific code end
    }
}
void dispvidctrl_tclMCanClientAvm::onHardware_VersionStatusInTimeout(tVoid) {
    ETG_TRACE_USR1(("dispvidctrl_tclMCanClientAvm::onHardware_VersionStatusInTimeout(): called"));
    
    // dispvidctrl_tclMCanClientAvm::onHardware_VersionStatusInTimeout: user specific code start
    // dispvidctrl_tclMCanClientAvm::onHardware_VersionStatusInTimeout: user specific code end
}
void dispvidctrl_tclMCanClientAvm::onExtra_SWIndicationIn(tcl_ITM_Camera_System_Extra_SW_IndicationIn& oIn_Extra_SW) {
    ETG_TRACE_USR4(("dispvidctrl_tclMCanClientAvm::onExtra_SWIndicationIn(): called"));
    _mapMsgs[Avm_ASSEMBLE_KEY(eFctExtra_SW,MCAN_C_OP_TYPE_INDICATION)].vMsgReceived();
    
    if (_mapMsgs[Avm_ASSEMBLE_KEY(eFctExtra_SW,MCAN_C_OP_TYPE_INDICATION)].bIsMsgConfigured()) {
         // dispvidctrl_tclMCanClientAvm::onExtra_SWIndicationIn: user specific code start
         vSendSwitchInputToFsm(rvc_fi_tcl_e8_AVMph3_SwitchId::FI_EN_CAMERA);
         // dispvidctrl_tclMCanClientAvm::onExtra_SWIndicationIn: user specific code end
    } else {
         ETG_TRACE_FATAL(("dispvidctrl_tclMCanClientAvm::onExtra_SWIndicationIn(): Received not configured MCAN message!"));
         // dispvidctrl_tclMCanClientAvm::onExtra_SWIndicationInnCfg: user specific code start
         // dispvidctrl_tclMCanClientAvm::onExtra_SWIndicationInnCfg: user specific code end
    }
}
void dispvidctrl_tclMCanClientAvm::onView_Change_08AVMSetIn(tcl_ITM_Camera_System_View_Change_08AVM_SetIn& oIn_View_Change_08AVM) {
    ETG_TRACE_USR4(("dispvidctrl_tclMCanClientAvm::onView_Change_08AVMSetIn(): called"));
    _mapMsgs[Avm_ASSEMBLE_KEY(eFctView_Change_08AVM,MCAN_C_OP_TYPE_SET)].vMsgReceived();
    
    if (_mapMsgs[Avm_ASSEMBLE_KEY(eFctView_Change_08AVM,MCAN_C_OP_TYPE_SET)].bIsMsgConfigured()) {
         _mapMsgs[Avm_ASSEMBLE_KEY(eFctView_Change_08AVM,MCAN_C_OP_TYPE_STATUS)].vStartStatusSendPeriod();
         // dispvidctrl_tclMCanClientAvm::onView_Change_08AVMSetIn: user specific code start

         _bRxParamsValid_View_Change_08AVM = bIsValidMsg_View_Change_08AVM_SetIn(oIn_View_Change_08AVM);
         vSaveRxParams_View_Change_08AVM_Set(oIn_View_Change_08AVM);
         _u8BeepTriggerSwitchId = 0x00;
         
         if (_bRxParamsValid_View_Change_08AVM) {
             tBool bReqCamDisplay = (tcl_ITM_Camera_System_e32_Disp_Status::FI_EN_CAMERA_DISPLAY == _oRxParam_Disp_Status.eDisp_Status.enType) ? TRUE : FALSE;
             vSendTriggerToFsm(I_dispvidctrl_tclMCanClientAvmFsm::eEventVideoScreenReq, bReqCamDisplay);    
         }

         vFillAndSendMsg_View_Change_08AVM_Status();
         // dispvidctrl_tclMCanClientAvm::onView_Change_08AVMSetIn: user specific code end
    } else {
         ETG_TRACE_FATAL(("dispvidctrl_tclMCanClientAvm::onView_Change_08AVMSetIn(): Received not configured MCAN message!"));
         // dispvidctrl_tclMCanClientAvm::onView_Change_08AVMSetInnCfg: user specific code start
         // dispvidctrl_tclMCanClientAvm::onView_Change_08AVMSetInnCfg: user specific code end
    }
}
void dispvidctrl_tclMCanClientAvm::onBlanking_OFFIndicationIn(tcl_ITM_Camera_System_Blanking_OFF_IndicationIn& oIn_Blanking_OFF) {
    ETG_TRACE_USR4(("dispvidctrl_tclMCanClientAvm::onBlanking_OFFIndicationIn(): called"));
    _mapMsgs[Avm_ASSEMBLE_KEY(eFctBlanking_OFF,MCAN_C_OP_TYPE_INDICATION)].vMsgReceived();
    
    if (_mapMsgs[Avm_ASSEMBLE_KEY(eFctBlanking_OFF,MCAN_C_OP_TYPE_INDICATION)].bIsMsgConfigured()) {
         // dispvidctrl_tclMCanClientAvm::onBlanking_OFFIndicationIn: user specific code start
         vSendTriggerToFsm(I_dispvidctrl_tclMCanClientAvmFsm::eEventBlankingOffReq, FALSE);  // "FALSE" because it's a "ping-only" event
         // dispvidctrl_tclMCanClientAvm::onBlanking_OFFIndicationIn: user specific code end
    } else {
         ETG_TRACE_FATAL(("dispvidctrl_tclMCanClientAvm::onBlanking_OFFIndicationIn(): Received not configured MCAN message!"));
         // dispvidctrl_tclMCanClientAvm::onBlanking_OFFIndicationInnCfg: user specific code start
         // dispvidctrl_tclMCanClientAvm::onBlanking_OFFIndicationInnCfg: user specific code end
    }
}
void dispvidctrl_tclMCanClientAvm::onBlanking_less_Change_08AVMIndicationIn(tcl_ITM_Camera_System_Blanking_less_Change_08AVM_IndicationIn& oIn_Blanking_less_Change_08AVM) {
    ETG_TRACE_USR4(("dispvidctrl_tclMCanClientAvm::onBlanking_less_Change_08AVMIndicationIn(): called"));
    _mapMsgs[Avm_ASSEMBLE_KEY(eFctBlanking_less_Change_08AVM,MCAN_C_OP_TYPE_INDICATION)].vMsgReceived();
    
    if (_mapMsgs[Avm_ASSEMBLE_KEY(eFctBlanking_less_Change_08AVM,MCAN_C_OP_TYPE_INDICATION)].bIsMsgConfigured()) {
         // dispvidctrl_tclMCanClientAvm::onBlanking_less_Change_08AVMIndicationIn: user specific code start
         
         _bRxParamsValid_Blanking_less_Change_08AVM = bIsValidMsg_Blanking_less_Change_08AVM_IndicationIn(oIn_Blanking_less_Change_08AVM);
         vSaveRxParams_Blanking_less_Change_08AVM_Indication(oIn_Blanking_less_Change_08AVM);
         
         if (_bRxParamsValid_Blanking_less_Change_08AVM) {
             tcl_ITM_Camera_System_e32_Error_Message::tenType eErrMsg = oIn_Blanking_less_Change_08AVM.oError_Message.eError_Message.enType;
             if (tcl_ITM_Camera_System_e32_Error_Message::FI_EN_ONLY_BEEP                                  == eErrMsg ||
                 tcl_ITM_Camera_System_e32_Error_Message::FI_EN_IN_CASE_OF_SONAR_OFF_POP_UP_AND_ERROR_BEEP == eErrMsg  ) {
                 vSendErrorBeepReq(TRUE);
             }
             vSendEventToControl(EN_CONTROL_HMIAVM3__BLANKLESS_CHG_REQ);
             vSendViewContentToServer(FALSE,TRUE);
         }
         
         // dispvidctrl_tclMCanClientAvm::onBlanking_less_Change_08AVMIndicationIn: user specific code end
    } else {
         ETG_TRACE_FATAL(("dispvidctrl_tclMCanClientAvm::onBlanking_less_Change_08AVMIndicationIn(): Received not configured MCAN message!"));
         // dispvidctrl_tclMCanClientAvm::onBlanking_less_Change_08AVMIndicationInnCfg: user specific code start
         // dispvidctrl_tclMCanClientAvm::onBlanking_less_Change_08AVMIndicationInnCfg: user specific code end
    }
}
void dispvidctrl_tclMCanClientAvm::onAVM_Sonar_BuzzerStatusIn(tcl_ITM_Camera_System_AVM_Sonar_Buzzer_StatusIn& oIn_AVM_Sonar_Buzzer) {
    ETG_TRACE_USR4(("dispvidctrl_tclMCanClientAvm::onAVM_Sonar_BuzzerStatusIn(): called"));
    _mapMsgs[Avm_ASSEMBLE_KEY(eFctAVM_Sonar_Buzzer,MCAN_C_OP_TYPE_STATUS)].vMsgReceived();
    
    if (_mapMsgs[Avm_ASSEMBLE_KEY(eFctAVM_Sonar_Buzzer,MCAN_C_OP_TYPE_STATUS)].bIsMsgConfigured()) {
         // dispvidctrl_tclMCanClientAvm::onAVM_Sonar_BuzzerStatusIn: user specific code start
         if (tcl_ITM_Camera_System_e32_Invalid_Parameter::FI_EN_NORMAL == oIn_AVM_Sonar_Buzzer.oInvalid_Parameter.eInvalid_Parameter.enType)
         {
             _oRxParam_Buzzer_Status_2 = oIn_AVM_Sonar_Buzzer.oBuzzer_Status;
             vSendBuzzerStatusToServer();
         }
         // dispvidctrl_tclMCanClientAvm::onAVM_Sonar_BuzzerStatusIn: user specific code end
    } else {
         ETG_TRACE_FATAL(("dispvidctrl_tclMCanClientAvm::onAVM_Sonar_BuzzerStatusIn(): Received not configured MCAN message!"));
         // dispvidctrl_tclMCanClientAvm::onAVM_Sonar_BuzzerStatusInnCfg: user specific code start
         // dispvidctrl_tclMCanClientAvm::onAVM_Sonar_BuzzerStatusInnCfg: user specific code end
    }
}
void dispvidctrl_tclMCanClientAvm::onAVM_Sonar_BuzzerStatusInTimeout(tVoid) {
    ETG_TRACE_USR1(("dispvidctrl_tclMCanClientAvm::onAVM_Sonar_BuzzerStatusInTimeout(): called"));
    
    // dispvidctrl_tclMCanClientAvm::onAVM_Sonar_BuzzerStatusInTimeout: user specific code start
    // dispvidctrl_tclMCanClientAvm::onAVM_Sonar_BuzzerStatusInTimeout: user specific code end
}
void dispvidctrl_tclMCanClientAvm::onAVM_Sonar_BuzzerIndicationIn(tcl_ITM_Camera_System_AVM_Sonar_Buzzer_IndicationIn& oIn_AVM_Sonar_Buzzer) {
    ETG_TRACE_USR4(("dispvidctrl_tclMCanClientAvm::onAVM_Sonar_BuzzerIndicationIn(): called"));
    _mapMsgs[Avm_ASSEMBLE_KEY(eFctAVM_Sonar_Buzzer,MCAN_C_OP_TYPE_INDICATION)].vMsgReceived();
    
    if (_mapMsgs[Avm_ASSEMBLE_KEY(eFctAVM_Sonar_Buzzer,MCAN_C_OP_TYPE_INDICATION)].bIsMsgConfigured()) {
         // dispvidctrl_tclMCanClientAvm::onAVM_Sonar_BuzzerIndicationIn: user specific code start
         _oRxParam_Buzzer_Status_2 = oIn_AVM_Sonar_Buzzer.oBuzzer_Status;
         vSendBuzzerStatusToServer();
         // dispvidctrl_tclMCanClientAvm::onAVM_Sonar_BuzzerIndicationIn: user specific code end
    } else {
         ETG_TRACE_FATAL(("dispvidctrl_tclMCanClientAvm::onAVM_Sonar_BuzzerIndicationIn(): Received not configured MCAN message!"));
         // dispvidctrl_tclMCanClientAvm::onAVM_Sonar_BuzzerIndicationInnCfg: user specific code start
         // dispvidctrl_tclMCanClientAvm::onAVM_Sonar_BuzzerIndicationInnCfg: user specific code end
    }
}
void dispvidctrl_tclMCanClientAvm::onCamera_Setting_08AVMStatusIn(tcl_ITM_Camera_System_Camera_Setting_08AVM_StatusIn& oIn_Camera_Setting_08AVM) {
    ETG_TRACE_USR4(("dispvidctrl_tclMCanClientAvm::onCamera_Setting_08AVMStatusIn(): called"));
    _mapMsgs[Avm_ASSEMBLE_KEY(eFctCamera_Setting_08AVM,MCAN_C_OP_TYPE_STATUS)].vMsgReceived();
    
    if (_mapMsgs[Avm_ASSEMBLE_KEY(eFctCamera_Setting_08AVM,MCAN_C_OP_TYPE_STATUS)].bIsMsgConfigured()) {
         // dispvidctrl_tclMCanClientAvm::onCamera_Setting_08AVMStatusIn: user specific code start
         if (tcl_ITM_Camera_System_e32_Invalid_Parameter::FI_EN_NORMAL == oIn_Camera_Setting_08AVM.oInvalid_Parameter.eInvalid_Parameter.enType)
         {
             vSaveRxParams_Camera_Setting_08AVM_Status(oIn_Camera_Setting_08AVM);
             vSetInvalidRxCamSettingsToDefault();
             vSendDetailSettingsToServer();
         }
         // dispvidctrl_tclMCanClientAvm::onCamera_Setting_08AVMStatusIn: user specific code end
    } else {
         ETG_TRACE_FATAL(("dispvidctrl_tclMCanClientAvm::onCamera_Setting_08AVMStatusIn(): Received not configured MCAN message!"));
         // dispvidctrl_tclMCanClientAvm::onCamera_Setting_08AVMStatusInnCfg: user specific code start
         // dispvidctrl_tclMCanClientAvm::onCamera_Setting_08AVMStatusInnCfg: user specific code end
    }
}
void dispvidctrl_tclMCanClientAvm::onCamera_Setting_08AVMStatusInTimeout(tVoid) {
    ETG_TRACE_USR1(("dispvidctrl_tclMCanClientAvm::onCamera_Setting_08AVMStatusInTimeout(): called"));
    
    // dispvidctrl_tclMCanClientAvm::onCamera_Setting_08AVMStatusInTimeout: user specific code start
    // dispvidctrl_tclMCanClientAvm::onCamera_Setting_08AVMStatusInTimeout: user specific code end
}
void dispvidctrl_tclMCanClientAvm::onCamera_Setting_08AVMIndicationIn(tcl_ITM_Camera_System_Camera_Setting_08AVM_IndicationIn& oIn_Camera_Setting_08AVM) {
    ETG_TRACE_USR4(("dispvidctrl_tclMCanClientAvm::onCamera_Setting_08AVMIndicationIn(): called"));
    _mapMsgs[Avm_ASSEMBLE_KEY(eFctCamera_Setting_08AVM,MCAN_C_OP_TYPE_INDICATION)].vMsgReceived();
    
    if (_mapMsgs[Avm_ASSEMBLE_KEY(eFctCamera_Setting_08AVM,MCAN_C_OP_TYPE_INDICATION)].bIsMsgConfigured()) {
         // dispvidctrl_tclMCanClientAvm::onCamera_Setting_08AVMIndicationIn: user specific code start
         vSaveRxParams_Camera_Setting_08AVM_Indication(oIn_Camera_Setting_08AVM);
         vSetInvalidRxCamSettingsToDefault();
         vSendDetailSettingsToServer();
         // dispvidctrl_tclMCanClientAvm::onCamera_Setting_08AVMIndicationIn: user specific code end
    } else {
         ETG_TRACE_FATAL(("dispvidctrl_tclMCanClientAvm::onCamera_Setting_08AVMIndicationIn(): Received not configured MCAN message!"));
         // dispvidctrl_tclMCanClientAvm::onCamera_Setting_08AVMIndicationInnCfg: user specific code start
         // dispvidctrl_tclMCanClientAvm::onCamera_Setting_08AVMIndicationInnCfg: user specific code end
    }
}
void dispvidctrl_tclMCanClientAvm::onCamera_Primary_SettingStatusIn(tcl_ITM_Camera_System_Camera_Primary_Setting_StatusIn& oIn_Camera_Primary_Setting) {
    ETG_TRACE_USR4(("dispvidctrl_tclMCanClientAvm::onCamera_Primary_SettingStatusIn(): called"));
    _mapMsgs[Avm_ASSEMBLE_KEY(eFctCamera_Primary_Setting,MCAN_C_OP_TYPE_STATUS)].vMsgReceived();
    
    if (_mapMsgs[Avm_ASSEMBLE_KEY(eFctCamera_Primary_Setting,MCAN_C_OP_TYPE_STATUS)].bIsMsgConfigured()) {
         // dispvidctrl_tclMCanClientAvm::onCamera_Primary_SettingStatusIn: user specific code start
         vSaveRxParams_Camera_Primary_Setting_Status(oIn_Camera_Primary_Setting);
         if (0x02 < (tU32)_oRxParam_Primary_Setting.eAVM_Sonar.enType ) {  // reserved/undefined value
             _oRxParam_Primary_Setting.eAVM_Sonar.enType = (tcl_ITM_Camera_System_e32_AVM_Sonar::tenType)0x00; // map to "function unavailable"
         }
         vSendPrimarySettingsToServer();
         // dispvidctrl_tclMCanClientAvm::onCamera_Primary_SettingStatusIn: user specific code end
    } else {
         ETG_TRACE_FATAL(("dispvidctrl_tclMCanClientAvm::onCamera_Primary_SettingStatusIn(): Received not configured MCAN message!"));
         // dispvidctrl_tclMCanClientAvm::onCamera_Primary_SettingStatusInnCfg: user specific code start
         // dispvidctrl_tclMCanClientAvm::onCamera_Primary_SettingStatusInnCfg: user specific code end
    }
}
void dispvidctrl_tclMCanClientAvm::onCamera_Primary_SettingStatusInTimeout(tVoid) {
    ETG_TRACE_USR1(("dispvidctrl_tclMCanClientAvm::onCamera_Primary_SettingStatusInTimeout(): called"));
    
    // dispvidctrl_tclMCanClientAvm::onCamera_Primary_SettingStatusInTimeout: user specific code start
    // dispvidctrl_tclMCanClientAvm::onCamera_Primary_SettingStatusInTimeout: user specific code end
}
void dispvidctrl_tclMCanClientAvm::onMCAN_Communication_ErrorStatusIn(tcl_ITM_Camera_System_MCAN_Communication_Error_StatusIn& oIn_MCAN_Communication_Error) {
    ETG_TRACE_USR4(("dispvidctrl_tclMCanClientAvm::onMCAN_Communication_ErrorStatusIn(): called"));
    _mapMsgs[Avm_ASSEMBLE_KEY(eFctMCAN_Communication_Error,MCAN_C_OP_TYPE_STATUS)].vMsgReceived();
    
    if (_mapMsgs[Avm_ASSEMBLE_KEY(eFctMCAN_Communication_Error,MCAN_C_OP_TYPE_STATUS)].bIsMsgConfigured()) {
         // dispvidctrl_tclMCanClientAvm::onMCAN_Communication_ErrorStatusIn: user specific code start
         _oRxParam_MCAN_Communication_Error = oIn_MCAN_Communication_Error.oMCAN_Communication_Error;
         vSendMcanCommErrorInfoToServer();
         // dispvidctrl_tclMCanClientAvm::onMCAN_Communication_ErrorStatusIn: user specific code end
    } else {
         ETG_TRACE_FATAL(("dispvidctrl_tclMCanClientAvm::onMCAN_Communication_ErrorStatusIn(): Received not configured MCAN message!"));
         // dispvidctrl_tclMCanClientAvm::onMCAN_Communication_ErrorStatusInnCfg: user specific code start
         // dispvidctrl_tclMCanClientAvm::onMCAN_Communication_ErrorStatusInnCfg: user specific code end
    }
}
void dispvidctrl_tclMCanClientAvm::onMCAN_Communication_ErrorStatusInTimeout(tVoid) {
    ETG_TRACE_USR1(("dispvidctrl_tclMCanClientAvm::onMCAN_Communication_ErrorStatusInTimeout(): called"));
    
    // dispvidctrl_tclMCanClientAvm::onMCAN_Communication_ErrorStatusInTimeout: user specific code start
    // dispvidctrl_tclMCanClientAvm::onMCAN_Communication_ErrorStatusInTimeout: user specific code end
}
void dispvidctrl_tclMCanClientAvm::onMCAN_Communication_Error_ClearStatusIn(tcl_ITM_Camera_System_MCAN_Communication_Error_Clear_StatusIn& oIn_MCAN_Communication_Error_Clear) {
    ETG_TRACE_USR4(("dispvidctrl_tclMCanClientAvm::onMCAN_Communication_Error_ClearStatusIn(): called"));
    _mapMsgs[Avm_ASSEMBLE_KEY(eFctMCAN_Communication_Error_Clear,MCAN_C_OP_TYPE_STATUS)].vMsgReceived();
    
    if (_mapMsgs[Avm_ASSEMBLE_KEY(eFctMCAN_Communication_Error_Clear,MCAN_C_OP_TYPE_STATUS)].bIsMsgConfigured()) {
         // dispvidctrl_tclMCanClientAvm::onMCAN_Communication_Error_ClearStatusIn: user specific code start
         _oRxParam_MCAN_Communication_Error = oIn_MCAN_Communication_Error_Clear.oMCAN_Communication_Error;
         vSendMcanCommErrorInfoToServer();
         // dispvidctrl_tclMCanClientAvm::onMCAN_Communication_Error_ClearStatusIn: user specific code end
    } else {
         ETG_TRACE_FATAL(("dispvidctrl_tclMCanClientAvm::onMCAN_Communication_Error_ClearStatusIn(): Received not configured MCAN message!"));
         // dispvidctrl_tclMCanClientAvm::onMCAN_Communication_Error_ClearStatusInnCfg: user specific code start
         // dispvidctrl_tclMCanClientAvm::onMCAN_Communication_Error_ClearStatusInnCfg: user specific code end
    }
}
void dispvidctrl_tclMCanClientAvm::onMCAN_Communication_Error_ClearStatusInTimeout(tVoid) {
    ETG_TRACE_USR1(("dispvidctrl_tclMCanClientAvm::onMCAN_Communication_Error_ClearStatusInTimeout(): called"));
    
    // dispvidctrl_tclMCanClientAvm::onMCAN_Communication_Error_ClearStatusInTimeout: user specific code start
    // dispvidctrl_tclMCanClientAvm::onMCAN_Communication_Error_ClearStatusInTimeout: user specific code end
}
void dispvidctrl_tclMCanClientAvm::onCamera_Diag_SensorStatusIn(tcl_ITM_Camera_System_Camera_Diag_Sensor_StatusIn& oIn_Camera_Diag_Sensor) {
    ETG_TRACE_USR4(("dispvidctrl_tclMCanClientAvm::onCamera_Diag_SensorStatusIn(): called"));
    _mapMsgs[Avm_ASSEMBLE_KEY(eFctCamera_Diag_Sensor,MCAN_C_OP_TYPE_STATUS)].vMsgReceived();
    
    if (_mapMsgs[Avm_ASSEMBLE_KEY(eFctCamera_Diag_Sensor,MCAN_C_OP_TYPE_STATUS)].bIsMsgConfigured()) {
         // dispvidctrl_tclMCanClientAvm::onCamera_Diag_SensorStatusIn: user specific code start
         vSaveRxParams_Camera_Diag_Sensor_Status(oIn_Camera_Diag_Sensor);
         // dispvidctrl_tclMCanClientAvm::onCamera_Diag_SensorStatusIn: user specific code end
    } else {
         ETG_TRACE_FATAL(("dispvidctrl_tclMCanClientAvm::onCamera_Diag_SensorStatusIn(): Received not configured MCAN message!"));
         // dispvidctrl_tclMCanClientAvm::onCamera_Diag_SensorStatusInnCfg: user specific code start
         // dispvidctrl_tclMCanClientAvm::onCamera_Diag_SensorStatusInnCfg: user specific code end
    }
}
void dispvidctrl_tclMCanClientAvm::onCamera_Diag_SensorStatusInTimeout(tVoid) {
    ETG_TRACE_USR1(("dispvidctrl_tclMCanClientAvm::onCamera_Diag_SensorStatusInTimeout(): called"));
    
    // dispvidctrl_tclMCanClientAvm::onCamera_Diag_SensorStatusInTimeout: user specific code start
    // dispvidctrl_tclMCanClientAvm::onCamera_Diag_SensorStatusInTimeout: user specific code end
}
void dispvidctrl_tclMCanClientAvm::onCamera_Diag_SensorIndicationIn(tcl_ITM_Camera_System_Camera_Diag_Sensor_IndicationIn& oIn_Camera_Diag_Sensor) {
    ETG_TRACE_USR4(("dispvidctrl_tclMCanClientAvm::onCamera_Diag_SensorIndicationIn(): called"));
    _mapMsgs[Avm_ASSEMBLE_KEY(eFctCamera_Diag_Sensor,MCAN_C_OP_TYPE_INDICATION)].vMsgReceived();
    
    if (_mapMsgs[Avm_ASSEMBLE_KEY(eFctCamera_Diag_Sensor,MCAN_C_OP_TYPE_INDICATION)].bIsMsgConfigured()) {
         // dispvidctrl_tclMCanClientAvm::onCamera_Diag_SensorIndicationIn: user specific code start
         vSaveRxParams_Camera_Diag_Sensor_Indication(oIn_Camera_Diag_Sensor);
         // dispvidctrl_tclMCanClientAvm::onCamera_Diag_SensorIndicationIn: user specific code end
    } else {
         ETG_TRACE_FATAL(("dispvidctrl_tclMCanClientAvm::onCamera_Diag_SensorIndicationIn(): Received not configured MCAN message!"));
         // dispvidctrl_tclMCanClientAvm::onCamera_Diag_SensorIndicationInnCfg: user specific code start
         // dispvidctrl_tclMCanClientAvm::onCamera_Diag_SensorIndicationInnCfg: user specific code end
    }
}
tVoid dispvidctrl_tclMCanClientAvm::setSoftware_VersionGetOutUpdate(tVoid) {
    _mapMsgs[Avm_ASSEMBLE_KEY(eFctSoftware_Version,MCAN_C_OP_TYPE_GET)].vDataChanged();
}
tVoid dispvidctrl_tclMCanClientAvm::setHardware_VersionGetOutUpdate(tVoid) {
    _mapMsgs[Avm_ASSEMBLE_KEY(eFctHardware_Version,MCAN_C_OP_TYPE_GET)].vDataChanged();
}
tVoid dispvidctrl_tclMCanClientAvm::setSW_SignalIndicationOutSW_Status(const tcl_ITM_Camera_System_SW_Status& oSW_Status, ESendMode eSendMode) {
    if ((eSendMode == eOnChange) && (_oSW_SignalIndicationOut.oSW_Status != oSW_Status)) {
       _mapMsgs[Avm_ASSEMBLE_KEY(eFctSW_Signal,MCAN_C_OP_TYPE_INDICATION)].vDataChanged();
    } else if (eSendMode == eForce) {
        _mapMsgs[Avm_ASSEMBLE_KEY(eFctSW_Signal,MCAN_C_OP_TYPE_INDICATION)].vDataChanged();    
    }
    _oSW_SignalIndicationOut.oSW_Status = oSW_Status;    
    
   // dispvidctrl_tclMCanClientAvm::setSW_SignalIndicationOutSW_Status: user specific code start
   // dispvidctrl_tclMCanClientAvm::setSW_SignalIndicationOutSW_Status: user specific code end
}
tVoid dispvidctrl_tclMCanClientAvm::setSW_SignalIndicationOutDisp_Status(const tcl_ITM_Camera_System_Disp_Status& oDisp_Status, ESendMode eSendMode) {
    if ((eSendMode == eOnChange) && (_oSW_SignalIndicationOut.oDisp_Status != oDisp_Status)) {
       _mapMsgs[Avm_ASSEMBLE_KEY(eFctSW_Signal,MCAN_C_OP_TYPE_INDICATION)].vDataChanged();
    } else if (eSendMode == eForce) {
        _mapMsgs[Avm_ASSEMBLE_KEY(eFctSW_Signal,MCAN_C_OP_TYPE_INDICATION)].vDataChanged();    
    }
    _oSW_SignalIndicationOut.oDisp_Status = oDisp_Status;    
    
   // dispvidctrl_tclMCanClientAvm::setSW_SignalIndicationOutDisp_Status: user specific code start
   // dispvidctrl_tclMCanClientAvm::setSW_SignalIndicationOutDisp_Status: user specific code end
}
tVoid dispvidctrl_tclMCanClientAvm::setView_Change_08AVMStatusOutInvalid_Parameter(const tcl_ITM_Camera_System_Invalid_Parameter& oInvalid_Parameter, ESendMode eSendMode) {
    if ((eSendMode == eOnChange) && (_oView_Change_08AVMStatusOut.oInvalid_Parameter != oInvalid_Parameter)) {
       _mapMsgs[Avm_ASSEMBLE_KEY(eFctView_Change_08AVM,MCAN_C_OP_TYPE_STATUS)].vDataChanged();
    } else if (eSendMode == eForce) {
        _mapMsgs[Avm_ASSEMBLE_KEY(eFctView_Change_08AVM,MCAN_C_OP_TYPE_STATUS)].vDataChanged();    
    }
    _oView_Change_08AVMStatusOut.oInvalid_Parameter = oInvalid_Parameter;    
    
   // dispvidctrl_tclMCanClientAvm::setView_Change_08AVMStatusOutInvalid_Parameter: user specific code start
   // dispvidctrl_tclMCanClientAvm::setView_Change_08AVMStatusOutInvalid_Parameter: user specific code end
}
tVoid dispvidctrl_tclMCanClientAvm::setView_Change_08AVMStatusOutDisp_Status(const tcl_ITM_Camera_System_Disp_Status& oDisp_Status, ESendMode eSendMode) {
    if ((eSendMode == eOnChange) && (_oView_Change_08AVMStatusOut.oDisp_Status != oDisp_Status)) {
       _mapMsgs[Avm_ASSEMBLE_KEY(eFctView_Change_08AVM,MCAN_C_OP_TYPE_STATUS)].vDataChanged();
    } else if (eSendMode == eForce) {
        _mapMsgs[Avm_ASSEMBLE_KEY(eFctView_Change_08AVM,MCAN_C_OP_TYPE_STATUS)].vDataChanged();    
    }
    _oView_Change_08AVMStatusOut.oDisp_Status = oDisp_Status;    
    
   // dispvidctrl_tclMCanClientAvm::setView_Change_08AVMStatusOutDisp_Status: user specific code start
   // dispvidctrl_tclMCanClientAvm::setView_Change_08AVMStatusOutDisp_Status: user specific code end
}
tVoid dispvidctrl_tclMCanClientAvm::setView_Change_08AVMStatusOutView_Pattern(const tcl_ITM_Camera_System_View_Pattern& oView_Pattern, ESendMode eSendMode) {
    if ((eSendMode == eOnChange) && (_oView_Change_08AVMStatusOut.oView_Pattern != oView_Pattern)) {
       _mapMsgs[Avm_ASSEMBLE_KEY(eFctView_Change_08AVM,MCAN_C_OP_TYPE_STATUS)].vDataChanged();
    } else if (eSendMode == eForce) {
        _mapMsgs[Avm_ASSEMBLE_KEY(eFctView_Change_08AVM,MCAN_C_OP_TYPE_STATUS)].vDataChanged();    
    }
    _oView_Change_08AVMStatusOut.oView_Pattern = oView_Pattern;    
    
   // dispvidctrl_tclMCanClientAvm::setView_Change_08AVMStatusOutView_Pattern: user specific code start
   // dispvidctrl_tclMCanClientAvm::setView_Change_08AVMStatusOutView_Pattern: user specific code end
}
tVoid dispvidctrl_tclMCanClientAvm::setView_Change_08AVMStatusOutCaution(const tcl_ITM_Camera_System_Caution& oCaution, ESendMode eSendMode) {
    if ((eSendMode == eOnChange) && (_oView_Change_08AVMStatusOut.oCaution != oCaution)) {
       _mapMsgs[Avm_ASSEMBLE_KEY(eFctView_Change_08AVM,MCAN_C_OP_TYPE_STATUS)].vDataChanged();
    } else if (eSendMode == eForce) {
        _mapMsgs[Avm_ASSEMBLE_KEY(eFctView_Change_08AVM,MCAN_C_OP_TYPE_STATUS)].vDataChanged();    
    }
    _oView_Change_08AVMStatusOut.oCaution = oCaution;    
    
   // dispvidctrl_tclMCanClientAvm::setView_Change_08AVMStatusOutCaution: user specific code start
   // dispvidctrl_tclMCanClientAvm::setView_Change_08AVMStatusOutCaution: user specific code end
}
tVoid dispvidctrl_tclMCanClientAvm::setView_Change_08AVMStatusOutDisp_SW_08AVM(const tcl_ITM_Camera_System_Disp_SW_08AVM& oDisp_SW_08AVM, ESendMode eSendMode) {
    if ((eSendMode == eOnChange) && (_oView_Change_08AVMStatusOut.oDisp_SW_08AVM != oDisp_SW_08AVM)) {
       _mapMsgs[Avm_ASSEMBLE_KEY(eFctView_Change_08AVM,MCAN_C_OP_TYPE_STATUS)].vDataChanged();
    } else if (eSendMode == eForce) {
        _mapMsgs[Avm_ASSEMBLE_KEY(eFctView_Change_08AVM,MCAN_C_OP_TYPE_STATUS)].vDataChanged();    
    }
    _oView_Change_08AVMStatusOut.oDisp_SW_08AVM = oDisp_SW_08AVM;    
    
   // dispvidctrl_tclMCanClientAvm::setView_Change_08AVMStatusOutDisp_SW_08AVM: user specific code start
   // dispvidctrl_tclMCanClientAvm::setView_Change_08AVMStatusOutDisp_SW_08AVM: user specific code end
}
tVoid dispvidctrl_tclMCanClientAvm::setView_Change_08AVMStatusOutIcon(const tcl_ITM_Camera_System_Icon& oIcon, ESendMode eSendMode) {
    if ((eSendMode == eOnChange) && (_oView_Change_08AVMStatusOut.oIcon != oIcon)) {
       _mapMsgs[Avm_ASSEMBLE_KEY(eFctView_Change_08AVM,MCAN_C_OP_TYPE_STATUS)].vDataChanged();
    } else if (eSendMode == eForce) {
        _mapMsgs[Avm_ASSEMBLE_KEY(eFctView_Change_08AVM,MCAN_C_OP_TYPE_STATUS)].vDataChanged();    
    }
    _oView_Change_08AVMStatusOut.oIcon = oIcon;    
    
   // dispvidctrl_tclMCanClientAvm::setView_Change_08AVMStatusOutIcon: user specific code start
   // dispvidctrl_tclMCanClientAvm::setView_Change_08AVMStatusOutIcon: user specific code end
}
tVoid dispvidctrl_tclMCanClientAvm::setView_Change_08AVMStatusOutBuzzer_Status(const tcl_ITM_Camera_System_Buzzer_Status& oBuzzer_Status, ESendMode eSendMode) {
    if ((eSendMode == eOnChange) && (_oView_Change_08AVMStatusOut.oBuzzer_Status != oBuzzer_Status)) {
       _mapMsgs[Avm_ASSEMBLE_KEY(eFctView_Change_08AVM,MCAN_C_OP_TYPE_STATUS)].vDataChanged();
    } else if (eSendMode == eForce) {
        _mapMsgs[Avm_ASSEMBLE_KEY(eFctView_Change_08AVM,MCAN_C_OP_TYPE_STATUS)].vDataChanged();    
    }
    _oView_Change_08AVMStatusOut.oBuzzer_Status = oBuzzer_Status;    
    
   // dispvidctrl_tclMCanClientAvm::setView_Change_08AVMStatusOutBuzzer_Status: user specific code start
   // dispvidctrl_tclMCanClientAvm::setView_Change_08AVMStatusOutBuzzer_Status: user specific code end
}
tVoid dispvidctrl_tclMCanClientAvm::setDirect_Camera_OFFIndicationOutUpdate(tVoid) {
    _mapMsgs[Avm_ASSEMBLE_KEY(eFctDirect_Camera_OFF,MCAN_C_OP_TYPE_INDICATION)].vDataChanged();
}
tVoid dispvidctrl_tclMCanClientAvm::setAVM_Sonar_BuzzerSetOutBuzzer_Status(const tcl_ITM_Camera_System_Buzzer_Status& oBuzzer_Status, ESendMode eSendMode) {
    if ((eSendMode == eOnChange) && (_oAVM_Sonar_BuzzerSetOut.oBuzzer_Status != oBuzzer_Status)) {
       _mapMsgs[Avm_ASSEMBLE_KEY(eFctAVM_Sonar_Buzzer,MCAN_C_OP_TYPE_SET)].vDataChanged();
    } else if (eSendMode == eForce) {
        _mapMsgs[Avm_ASSEMBLE_KEY(eFctAVM_Sonar_Buzzer,MCAN_C_OP_TYPE_SET)].vDataChanged();    
    }
    _oAVM_Sonar_BuzzerSetOut.oBuzzer_Status = oBuzzer_Status;    
    
   // dispvidctrl_tclMCanClientAvm::setAVM_Sonar_BuzzerSetOutBuzzer_Status: user specific code start
   // dispvidctrl_tclMCanClientAvm::setAVM_Sonar_BuzzerSetOutBuzzer_Status: user specific code end
}
tVoid dispvidctrl_tclMCanClientAvm::setCamera_Setting_08AVMSetOutCamera_08AVM(const tcl_ITM_Camera_System_Camera_08AVM& oCamera_08AVM, ESendMode eSendMode) {
    if ((eSendMode == eOnChange) && (_oCamera_Setting_08AVMSetOut.oCamera_08AVM != oCamera_08AVM)) {
       _mapMsgs[Avm_ASSEMBLE_KEY(eFctCamera_Setting_08AVM,MCAN_C_OP_TYPE_SET)].vDataChanged();
    } else if (eSendMode == eForce) {
        _mapMsgs[Avm_ASSEMBLE_KEY(eFctCamera_Setting_08AVM,MCAN_C_OP_TYPE_SET)].vDataChanged();    
    }
    _oCamera_Setting_08AVMSetOut.oCamera_08AVM = oCamera_08AVM;    
    
   // dispvidctrl_tclMCanClientAvm::setCamera_Setting_08AVMSetOutCamera_08AVM: user specific code start
   // dispvidctrl_tclMCanClientAvm::setCamera_Setting_08AVMSetOutCamera_08AVM: user specific code end
}
tVoid dispvidctrl_tclMCanClientAvm::setCamera_Setting_08AVMSetOutCorner_Sonar_Level(const tcl_ITM_Camera_System_Corner_Sonar_Level& oCorner_Sonar_Level, ESendMode eSendMode) {
    if ((eSendMode == eOnChange) && (_oCamera_Setting_08AVMSetOut.oCorner_Sonar_Level != oCorner_Sonar_Level)) {
       _mapMsgs[Avm_ASSEMBLE_KEY(eFctCamera_Setting_08AVM,MCAN_C_OP_TYPE_SET)].vDataChanged();
    } else if (eSendMode == eForce) {
        _mapMsgs[Avm_ASSEMBLE_KEY(eFctCamera_Setting_08AVM,MCAN_C_OP_TYPE_SET)].vDataChanged();    
    }
    _oCamera_Setting_08AVMSetOut.oCorner_Sonar_Level = oCorner_Sonar_Level;    
    
   // dispvidctrl_tclMCanClientAvm::setCamera_Setting_08AVMSetOutCorner_Sonar_Level: user specific code start
   // dispvidctrl_tclMCanClientAvm::setCamera_Setting_08AVMSetOutCorner_Sonar_Level: user specific code end
}
tVoid dispvidctrl_tclMCanClientAvm::setCamera_Setting_08AVMSetOutSonar_Level(const tcl_ITM_Camera_System_Sonar_Level& oSonar_Level, ESendMode eSendMode) {
    if ((eSendMode == eOnChange) && (_oCamera_Setting_08AVMSetOut.oSonar_Level != oSonar_Level)) {
       _mapMsgs[Avm_ASSEMBLE_KEY(eFctCamera_Setting_08AVM,MCAN_C_OP_TYPE_SET)].vDataChanged();
    } else if (eSendMode == eForce) {
        _mapMsgs[Avm_ASSEMBLE_KEY(eFctCamera_Setting_08AVM,MCAN_C_OP_TYPE_SET)].vDataChanged();    
    }
    _oCamera_Setting_08AVMSetOut.oSonar_Level = oSonar_Level;    
    
   // dispvidctrl_tclMCanClientAvm::setCamera_Setting_08AVMSetOutSonar_Level: user specific code start
   // dispvidctrl_tclMCanClientAvm::setCamera_Setting_08AVMSetOutSonar_Level: user specific code end
}
tVoid dispvidctrl_tclMCanClientAvm::setCamera_Setting_08AVMGetOutUpdate(tVoid) {
    _mapMsgs[Avm_ASSEMBLE_KEY(eFctCamera_Setting_08AVM,MCAN_C_OP_TYPE_GET)].vDataChanged();
}
tVoid dispvidctrl_tclMCanClientAvm::setCamera_Primary_SettingSetOutPrimary_Setting(const tcl_ITM_Camera_System_Primary_Setting& oPrimary_Setting, ESendMode eSendMode) {
    if ((eSendMode == eOnChange) && (_oCamera_Primary_SettingSetOut.oPrimary_Setting != oPrimary_Setting)) {
       _mapMsgs[Avm_ASSEMBLE_KEY(eFctCamera_Primary_Setting,MCAN_C_OP_TYPE_SET)].vDataChanged();
    } else if (eSendMode == eForce) {
        _mapMsgs[Avm_ASSEMBLE_KEY(eFctCamera_Primary_Setting,MCAN_C_OP_TYPE_SET)].vDataChanged();    
    }
    _oCamera_Primary_SettingSetOut.oPrimary_Setting = oPrimary_Setting;    
    
   // dispvidctrl_tclMCanClientAvm::setCamera_Primary_SettingSetOutPrimary_Setting: user specific code start
   // dispvidctrl_tclMCanClientAvm::setCamera_Primary_SettingSetOutPrimary_Setting: user specific code end
}
tVoid dispvidctrl_tclMCanClientAvm::setCamera_Primary_SettingGetOutUpdate(tVoid) {
    _mapMsgs[Avm_ASSEMBLE_KEY(eFctCamera_Primary_Setting,MCAN_C_OP_TYPE_GET)].vDataChanged();
}
tVoid dispvidctrl_tclMCanClientAvm::setMCAN_Communication_ErrorGetOutUpdate(tVoid) {
    _mapMsgs[Avm_ASSEMBLE_KEY(eFctMCAN_Communication_Error,MCAN_C_OP_TYPE_GET)].vDataChanged();
}
tVoid dispvidctrl_tclMCanClientAvm::setMCAN_Communication_Error_ClearSetOutUpdate(tVoid) {
    _mapMsgs[Avm_ASSEMBLE_KEY(eFctMCAN_Communication_Error_Clear,MCAN_C_OP_TYPE_SET)].vDataChanged();
}
tVoid dispvidctrl_tclMCanClientAvm::setCamera_Diag_SensorSetOutUpdate(tVoid) {
    _mapMsgs[Avm_ASSEMBLE_KEY(eFctCamera_Diag_Sensor,MCAN_C_OP_TYPE_SET)].vDataChanged();
}
tVoid dispvidctrl_tclMCanClientAvm::setCamera_Diag_SensorGetOutUpdate(tVoid) {
    _mapMsgs[Avm_ASSEMBLE_KEY(eFctCamera_Diag_Sensor,MCAN_C_OP_TYPE_GET)].vDataChanged();
}

tVoid dispvidctrl_tclMCanClientAvm::addMsgToSequenceWoBlocking(tU16 u16MsgId, tU8  u8MsgOpcode) {
    TMsgHeader tMsg;
    tMsg.u16MsgId = u16MsgId;
    tMsg.u8MsgOpcode = u8MsgOpcode;

    _vecSequenceMsgQueue.push_back(tMsg);

    _u32SequenceMsgQueueChangedTime = OSAL_ClockGetElapsedTime();
    ETG_TRACE_USR1( ( "dispvidctrl_tclMCanClientAvm::addMsgToSequenceWoBlocking(): %d!", _vecSequenceMsgQueue.size() ) );
    
}

tVoid dispvidctrl_tclMCanClientAvm::addMsgToSequence(tU16 u16MsgId, tU8  u8MsgOpcode) {
    TMsgHeader tMsg;
    tMsg.u16MsgId = u16MsgId;
    tMsg.u8MsgOpcode = u8MsgOpcode;

    _vecSequenceMsgBlockAllOtherQueue.push_back(tMsg);

    _u32SequenceBlockMsgQueueChangedTime = OSAL_ClockGetElapsedTime();
    ETG_TRACE_USR1( ( "dispvidctrl_tclMCanClientAvm::addMsgToSequence(): %d!", _vecSequenceMsgBlockAllOtherQueue.size() ) );
    
}

tVoid dispvidctrl_tclMCanClientAvm::clearMsgSequences() {
    _vecSequenceMsgQueue.clear();
    _vecSequenceMsgBlockAllOtherQueue.clear();

    _u32SequenceMsgQueueChangedTime = MCAN_DEFAULT_TIME;
    _u32SequenceBlockMsgQueueChangedTime = MCAN_DEFAULT_TIME;

}

// dispvidctrl_tclMCanClientAvm::ClassImplementation: user specific code start
/*

     X   X   XXX   XXXXX  XXXX        XXX    XXX   XXXX   XXXXX       XXX   XXXXX   XXX   XXXXX  XXX   XXX   X   X
     X   X  X   X  X      X   X      X   X  X   X  X   X  X          X   X  X      X   X    X     X   X   X  X   X
     X   X  X      X      X   X      X      X   X  X   X  X          X      X      X        X     X   X   X  XX  X
     X   X   XXX   XXXX   XXXX       X      X   X  X   X  XXXX        XXX   XXXX   X        X     X   X   X  X X X
     X   X      X  X      X X        X      X   X  X   X  X              X  X      X        X     X   X   X  X  XX
     X   X  X   X  X      X  X       X   X  X   X  X   X  X          X   X  X      X   X    X     X   X   X  X   X
      XXX    XXX   XXXXX  X   X       XXX    XXX   XXXX   XXXXX       XXX   XXXXX   XXX     X    XXX   XXX   X   X

*/

/////// methods for the start-up

tVoid dispvidctrl_tclMCanClientAvm::vGetReferencesEarly(tVoid)
{
    ETG_TRACE_FATAL( ( "dispvidctrl_tclMCanClientAvm::vGetReferencesEarly() Entered") );

    vDetermineConfiguration();
 
    _pCsmBase = dynamic_cast<I_dispvidctrl_tclClientAvmAdaptor*>(_cpoMain->getHandler("I_dispvidctrl_tclClientAvmAdaptor"));
    DISPVIDCTRL_NULL_POINTER_CHECK(_pCsmBase);
    _pCsmBase->vSetCallbackIf(this);
    
    _pMcanClientAvmFsm = dynamic_cast<I_dispvidctrl_tclMCanClientAvmFsm*>(_cpoMain->getHandler("I_dispvidctrl_tclMCanClientAvmFsm"));
    DISPVIDCTRL_NULL_POINTER_CHECK(_pMcanClientAvmFsm);

    _pControl_HmiAvm3 = dynamic_cast<dispvidctrl_tclControl_HmiAvm3*>(_cpoMain->getHandler("dispvidctrl_tclControl_HmiAvm3"));
    DISPVIDCTRL_NULL_POINTER_CHECK(_pControl_HmiAvm3);
}

tVoid dispvidctrl_tclMCanClientAvm::vStartCommunicationEarly(tVoid)
{
    ETG_TRACE_FATAL( ( "dispvidctrl_tclMCanClientAvm::vStartCommunicationEarly() Entered") );
    
    I_dispvidctrl_tclClientAvmAdaptor* pMcanAvm = dynamic_cast<I_dispvidctrl_tclClientAvmAdaptor*>(_cpoMain->getHandler("I_dispvidctrl_tclClientAvmAdaptor"));
    DISPVIDCTRL_NULL_POINTER_CHECK(pMcanAvm);

    if ( FALSE == pMcanAvm->bOnInit() ) {
    }
    pMcanAvm->vOnNewAppState(AMT_C_U32_STATE_NORMAL, AMT_C_U32_STATE_NORMAL);

}

tVoid dispvidctrl_tclMCanClientAvm::vDetermineConfiguration(tVoid)
{
    if (!_bConfigDetermined) {        
        TEarlyConfiguration rEarlyConfig;
        _cpoMain->vGetEarlyConfig(rEarlyConfig);
        _bAvmPhase3Configured = (rEarlyConfig.tEarlyNorForce.u32GuidelineCameraSystemType == CAMERA_TYPE_AVM_PHASE3) ? TRUE : FALSE;

        ETG_TRACE_FATAL(( "dispvidctrl_tclMCanClientAvm::vDetermineConfiguration(): u32GuidelineCameraSystemType=%u => _bAvmPhase3Configured=%u",
                          rEarlyConfig.tEarlyNorForce.u32GuidelineCameraSystemType, _bAvmPhase3Configured));
        _bConfigDetermined = TRUE;
    }
}


/////// methods to save the parameters of incoming MCAN messages

tVoid dispvidctrl_tclMCanClientAvm::vSaveRxParams_View_Change_08AVM_Set(const tcl_ITM_Camera_System_View_Change_08AVM_SetIn& oViewChgSet)
{
    _oRxParam_Disp_Status   = oViewChgSet.oDisp_Status;
    _oRxParam_View_Pattern  = oViewChgSet.oView_Pattern;
    _oRxParam_Caution       = oViewChgSet.oCaution;
    _oRxParam_Buzzer_Status = oViewChgSet.oBuzzer_Status;
    _oRxParam_Icon          = oViewChgSet.oIcon;
    _oRxParam_Disp_SW_08AVM = oViewChgSet.oDisp_SW_08AVM;
}

tVoid dispvidctrl_tclMCanClientAvm::vSaveRxParams_Blanking_less_Change_08AVM_Indication(const tcl_ITM_Camera_System_Blanking_less_Change_08AVM_IndicationIn& oBlnklsChgInd)
{
    _oRxParam_Error_Message = oBlnklsChgInd.oError_Message;
    _oRxParam_View_Pattern  = oBlnklsChgInd.oView_Pattern;
    _oRxParam_Caution       = oBlnklsChgInd.oCaution;
    _oRxParam_Buzzer_Status = oBlnklsChgInd.oBuzzer_Status;
    _oRxParam_Icon          = oBlnklsChgInd.oIcon;
    _oRxParam_Disp_SW_08AVM = oBlnklsChgInd.oDisp_SW_08AVM;    
}

tVoid dispvidctrl_tclMCanClientAvm::vSaveRxParams_Camera_Primary_Setting_Status(const tcl_ITM_Camera_System_Camera_Primary_Setting_StatusIn& oCamPrimSetStat)
{
    _oRxParam_Primary_Setting = oCamPrimSetStat.oPrimary_Setting;
}

tVoid dispvidctrl_tclMCanClientAvm::vSaveRxParams_Camera_Setting_08AVM_Status(const tcl_ITM_Camera_System_Camera_Setting_08AVM_StatusIn& oCamSettingStat)
{
    _oRxParam_Camera_08AVM       = oCamSettingStat.oCamera_08AVM;
    _oRxParam_Corner_Sonar_Level = oCamSettingStat.oCorner_Sonar_Level;
    _oRxParam_Sonar_Level        = oCamSettingStat.oSonar_Level;
}

tVoid dispvidctrl_tclMCanClientAvm::vSaveRxParams_Camera_Setting_08AVM_Indication(const tcl_ITM_Camera_System_Camera_Setting_08AVM_IndicationIn& oCamSettingInd)
{
    _oRxParam_Camera_08AVM       = oCamSettingInd.oCamera_08AVM;
    _oRxParam_Corner_Sonar_Level = oCamSettingInd.oCorner_Sonar_Level;
    _oRxParam_Sonar_Level        = oCamSettingInd.oSonar_Level;
}

tVoid dispvidctrl_tclMCanClientAvm::vSaveRxParams_Camera_Diag_Sensor_Status(const tcl_ITM_Camera_System_Camera_Diag_Sensor_StatusIn& oCamDiaSensStat)
{
    _oRxParam_Sensor_State     = oCamDiaSensStat.oSensor_State;
    _oRxParam_Camara_Set_State = oCamDiaSensStat.oCamara_Set_State;
    _oRxParam_RR_Camera_State  = oCamDiaSensStat.oRR_Camera_State;
    _oRxParam_FR_Camera_State  = oCamDiaSensStat.oFR_Camera_State;
    _oRxParam_AS_Camera_State  = oCamDiaSensStat.oAS_Camera_State;
    _oRxParam_DS_Camera_State  = oCamDiaSensStat.oDS_Camera_State;
}

tVoid dispvidctrl_tclMCanClientAvm::vSaveRxParams_Camera_Diag_Sensor_Indication(const tcl_ITM_Camera_System_Camera_Diag_Sensor_IndicationIn& oCamDiaSensInd)
{
    _oRxParam_Sensor_State     = oCamDiaSensInd.oSensor_State;
    _oRxParam_Camara_Set_State = oCamDiaSensInd.oCamara_Set_State;
    _oRxParam_RR_Camera_State  = oCamDiaSensInd.oRR_Camera_State;
    _oRxParam_FR_Camera_State  = oCamDiaSensInd.oFR_Camera_State;
    _oRxParam_AS_Camera_State  = oCamDiaSensInd.oAS_Camera_State;
    _oRxParam_DS_Camera_State  = oCamDiaSensInd.oDS_Camera_State;
}

/////// methods for mapping certain incoming message parameters to other values (e.g. invalid values to default values)

tVoid dispvidctrl_tclMCanClientAvm::vSetInvalidRxCamSettingsToDefault(tVoid)
{
    // (a) for most settings, the received value is undefined/invalid if it is greater than some max value => set to 0x00 ("function unavailable")
    #define SET_INVALID_CAMSETTING_TO_UNAVAIL(SettingName,MaxValidVal)  \
    if ((MaxValidVal) < (tU32)_oRxParam_Camera_08AVM.e##SettingName.enType)  \
        _oRxParam_Camera_08AVM.e##SettingName.enType = (tcl_ITM_Camera_System_e32_##SettingName::tenType)0x00
    SET_INVALID_CAMSETTING_TO_UNAVAIL(Vehicle_Speed    , 0x02); 
    SET_INVALID_CAMSETTING_TO_UNAVAIL(View_Line        , 0x02);
    SET_INVALID_CAMSETTING_TO_UNAVAIL(Priority_View    , 0x03); // for Priority_View, all possible values 0x00..0x03 are defined/valid
    SET_INVALID_CAMSETTING_TO_UNAVAIL(Mask_Emphasis    , 0x02);
    SET_INVALID_CAMSETTING_TO_UNAVAIL(Side_Sonar_Disp  , 0x02);
    SET_INVALID_CAMSETTING_TO_UNAVAIL(Adjust_Topview   , 0x02);
    SET_INVALID_CAMSETTING_TO_UNAVAIL(Priority_Wide    , 0x02);
    SET_INVALID_CAMSETTING_TO_UNAVAIL(Auto_Cam_Position, 0x01);  // for Auto_Cam_Position, only values 0x00 and 0x01 are defined/valid
    SET_INVALID_CAMSETTING_TO_UNAVAIL(Volume_Voice     , 0x02);
    SET_INVALID_CAMSETTING_TO_UNAVAIL(Sonar_Buzzer     , 0x02);
    SET_INVALID_CAMSETTING_TO_UNAVAIL(Rear_Wide_View   , 0x02);
    SET_INVALID_CAMSETTING_TO_UNAVAIL(Sonar_ON_OFF     , 0x02);
    SET_INVALID_CAMSETTING_TO_UNAVAIL(MOD_Interrupt    , 0x02);
    SET_INVALID_CAMSETTING_TO_UNAVAIL(Sonar_Interrupt  , 0x02);
    SET_INVALID_CAMSETTING_TO_UNAVAIL(MOD_Function     , 0x02);
    SET_INVALID_CAMSETTING_TO_UNAVAIL(MOD_Night_Use    , 0x02);
    SET_INVALID_CAMSETTING_TO_UNAVAIL(BCP_Function     , 0x02);
    SET_INVALID_CAMSETTING_TO_UNAVAIL(Front_Sonar_Only , 0x02);
    #undef SET_INVALID_CAMSETTING_TO_UNAVAIL
    
    // (b) some settings require special treatment:
    if (  tcl_ITM_Camera_System_e32_Corner_Sonar_Sensitivity_Level::FI_EN_LEVEL_1 != _oRxParam_Corner_Sonar_Level.eCorner_Sonar_Sensitivity_Level.enType
       && tcl_ITM_Camera_System_e32_Corner_Sonar_Sensitivity_Level::FI_EN_LEVEL_2 != _oRxParam_Corner_Sonar_Level.eCorner_Sonar_Sensitivity_Level.enType
       && tcl_ITM_Camera_System_e32_Corner_Sonar_Sensitivity_Level::FI_EN_LEVEL_3 != _oRxParam_Corner_Sonar_Level.eCorner_Sonar_Sensitivity_Level.enType
       && tcl_ITM_Camera_System_e32_Corner_Sonar_Sensitivity_Level::FI_EN_LEVEL_4 != _oRxParam_Corner_Sonar_Level.eCorner_Sonar_Sensitivity_Level.enType ) {
        _oRxParam_Corner_Sonar_Level.eCorner_Sonar_Sensitivity_Setting.enType = (tcl_ITM_Camera_System_e32_Corner_Sonar_Sensitivity_Setting::tenType)0x00;  // "function unavailable"
        _oRxParam_Corner_Sonar_Level.eCorner_Sonar_Sensitivity_Level.enType   = (tcl_ITM_Camera_System_e32_Corner_Sonar_Sensitivity_Level::tenType)  0x00;
    }    
    if (  tcl_ITM_Camera_System_e32_Sonar_Buzzer_Volume_Level::FI_EN_HIGH   != _oRxParam_Sonar_Level.eSonar_Buzzer_Volume_Level.enType
       && tcl_ITM_Camera_System_e32_Sonar_Buzzer_Volume_Level::FI_EN_MIDDLE != _oRxParam_Sonar_Level.eSonar_Buzzer_Volume_Level.enType
       && tcl_ITM_Camera_System_e32_Sonar_Buzzer_Volume_Level::FI_EN_LOW    != _oRxParam_Sonar_Level.eSonar_Buzzer_Volume_Level.enType ) {
        _oRxParam_Sonar_Level.eSonar_Buzzer_Volume_Setting.enType = (tcl_ITM_Camera_System_e32_Sonar_Buzzer_Volume_Setting::tenType)0x00;  // "function unavailable"
        _oRxParam_Sonar_Level.eSonar_Buzzer_Volume_Level.enType   = (tcl_ITM_Camera_System_e32_Sonar_Buzzer_Volume_Level::tenType)  0x00;
    }
    if (  tcl_ITM_Camera_System_e32_Sonar_Sensitivity_Level::FI_EN_FAR    != _oRxParam_Sonar_Level.eSonar_Sensitivity_Level.enType
       && tcl_ITM_Camera_System_e32_Sonar_Sensitivity_Level::FI_EN_MIDDLE != _oRxParam_Sonar_Level.eSonar_Sensitivity_Level.enType
       && tcl_ITM_Camera_System_e32_Sonar_Sensitivity_Level::FI_EN_NEAR   != _oRxParam_Sonar_Level.eSonar_Sensitivity_Level.enType ) {
        _oRxParam_Sonar_Level.eSonar_Sensitivity_Setting.enType = (tcl_ITM_Camera_System_e32_Sonar_Sensitivity_Setting::tenType)0x00;  // "function unavailable"
        _oRxParam_Sonar_Level.eSonar_Sensitivity_Level.enType   = (tcl_ITM_Camera_System_e32_Sonar_Sensitivity_Level::tenType)  0x00;
    }    
}
    
/////// methods for checking the validity of the contents of certain incoming messages

tBool dispvidctrl_tclMCanClientAvm::bIsValidMsg_View_Change_08AVM_SetIn(const tcl_ITM_Camera_System_View_Change_08AVM_SetIn& oViewChgSet)
{
    return (  bIsValidPar_Disp_Status  (oViewChgSet.oDisp_Status)
           && bIsValidPar_View_Pattern (oViewChgSet.oView_Pattern)
           && bIsValidPar_Caution      (oViewChgSet.oCaution)
           && bIsValidPar_Disp_SW_08AVM(oViewChgSet.oDisp_SW_08AVM)
           && bIsValidPar_Icon         (oViewChgSet.oIcon)
           && bIsValidPar_Buzzer_Status(oViewChgSet.oBuzzer_Status)
           ) ? TRUE : FALSE;
}

tBool dispvidctrl_tclMCanClientAvm::bIsValidMsg_Blanking_less_Change_08AVM_IndicationIn(const tcl_ITM_Camera_System_Blanking_less_Change_08AVM_IndicationIn& oBlnklsChgInd)
{
    return (  bIsValidPar_Error_Message(oBlnklsChgInd.oError_Message)
           && bIsValidPar_View_Pattern (oBlnklsChgInd.oView_Pattern)
           && bIsValidPar_Caution      (oBlnklsChgInd.oCaution)
           && bIsValidPar_Disp_SW_08AVM(oBlnklsChgInd.oDisp_SW_08AVM)
           && bIsValidPar_Icon         (oBlnklsChgInd.oIcon)
           && bIsValidPar_Buzzer_Status(oBlnklsChgInd.oBuzzer_Status)
           ) ? TRUE : FALSE;
}

/////// methods for checking the validity of the values of certain input parameters

tBool dispvidctrl_tclMCanClientAvm::bIsValidPar_Disp_Status(const tcl_ITM_Camera_System_Disp_Status& oDisp_Status)
{
    tBool bRet = (  (tcl_ITM_Camera_System_e32_Disp_Status::FI_EN_EXCEPT_FOR_CAMERA_DISPLAY == oDisp_Status.eDisp_Status.enType)
                 || (tcl_ITM_Camera_System_e32_Disp_Status::FI_EN_CAMERA_DISPLAY            == oDisp_Status.eDisp_Status.enType) ) ? TRUE : FALSE;
    if (!bRet) {
        ETG_TRACE_USR4( ( "dispvidctrl_tclMCanClientAvm::bIsValidPar_Disp_Status(): value %u is invalid", oDisp_Status.eDisp_Status.enType) );
    }
    return bRet;
}

tBool dispvidctrl_tclMCanClientAvm::bIsValidPar_View_Pattern(const tcl_ITM_Camera_System_View_Pattern& oView_Pattern)
{
    tBool bRet = (     (      tcl_ITM_Camera_System_e32_View_Pattern::FI_EN_NO_PATTERN  ==       oView_Pattern.eView_Pattern.enType) 
                 ||    (      tcl_ITM_Camera_System_e32_View_Pattern::FI_EN_PATTERN1_1  ==       oView_Pattern.eView_Pattern.enType) 
                 ||    (      tcl_ITM_Camera_System_e32_View_Pattern::FI_EN_PATTERN2_1  ==       oView_Pattern.eView_Pattern.enType) 
                 ||    (      tcl_ITM_Camera_System_e32_View_Pattern::FI_EN_PATTERN3_1  ==       oView_Pattern.eView_Pattern.enType) 
                 ||    (      tcl_ITM_Camera_System_e32_View_Pattern::FI_EN_PATTERN3_2  ==       oView_Pattern.eView_Pattern.enType) 
                 || (  ((tU32)tcl_ITM_Camera_System_e32_View_Pattern::FI_EN_PATTERN4_1  <= (tU32)oView_Pattern.eView_Pattern.enType) 
                    && ((tU32)tcl_ITM_Camera_System_e32_View_Pattern::FI_EN_PATTERN10_1 >= (tU32)oView_Pattern.eView_Pattern.enType) ) ) ? TRUE : FALSE;
    if (!bRet) {
        ETG_TRACE_USR4( ( "dispvidctrl_tclMCanClientAvm::bIsValidPar_View_Pattern(): value %u is invalid", oView_Pattern.eView_Pattern.enType) );
    }
    return bRet;
}

tBool dispvidctrl_tclMCanClientAvm::bIsValidPar_Caution(const tcl_ITM_Camera_System_Caution& oCaution)
{
    tBool bRet = (     (      tcl_ITM_Camera_System_e32_Caution::FI_EN_WITHOUT_DISPLAYING       ==       oCaution.eCaution.enType)
                 || (  ((tU32)tcl_ITM_Camera_System_e32_Caution::FI_EN_DISPLAY_CAUTION_PATTERN1 <= (tU32)oCaution.eCaution.enType)
                    && ((tU32)tcl_ITM_Camera_System_e32_Caution::FI_EN_DISPLAY_CAUTION_PATTERN4 >= (tU32)oCaution.eCaution.enType) ) ) ? TRUE : FALSE;
    if (!bRet) {
        ETG_TRACE_USR4( ( "dispvidctrl_tclMCanClientAvm::bIsValidPar_Caution(): value %u is invalid", oCaution.eCaution.enType) );
    }
    return bRet;
}

tBool dispvidctrl_tclMCanClientAvm::bIsValidPar_Disp_SW_08AVM(const tcl_ITM_Camera_System_Disp_SW_08AVM& oDisp_SW_08AVM)
{
    tBool bRet = (  bIsValidSubPar_Disp_SW_08AVM_SWx(oDisp_SW_08AVM.eSW1) && bIsValidSubPar_Disp_SW_08AVM_SWx_Status(oDisp_SW_08AVM.eSW1_Status)
                 && bIsValidSubPar_Disp_SW_08AVM_SWx(oDisp_SW_08AVM.eSW2) && bIsValidSubPar_Disp_SW_08AVM_SWx_Status(oDisp_SW_08AVM.eSW2_Status)
                 && bIsValidSubPar_Disp_SW_08AVM_SWx(oDisp_SW_08AVM.eSW3) && bIsValidSubPar_Disp_SW_08AVM_SWx_Status(oDisp_SW_08AVM.eSW3_Status)
                 && bIsValidSubPar_Disp_SW_08AVM_SWx(oDisp_SW_08AVM.eSW4) && bIsValidSubPar_Disp_SW_08AVM_SWx_Status(oDisp_SW_08AVM.eSW4_Status)
                 && bIsValidSubPar_Disp_SW_08AVM_SWx(oDisp_SW_08AVM.eSW5) && bIsValidSubPar_Disp_SW_08AVM_SWx_Status(oDisp_SW_08AVM.eSW5_Status)
                 && bIsValidSubPar_Disp_SW_08AVM_SWx(oDisp_SW_08AVM.eSW6) && bIsValidSubPar_Disp_SW_08AVM_SWx_Status(oDisp_SW_08AVM.eSW6_Status)
                 && bIsValidSubPar_Disp_SW_08AVM_SWx(oDisp_SW_08AVM.eSW7) && bIsValidSubPar_Disp_SW_08AVM_SWx_Status(oDisp_SW_08AVM.eSW7_Status)
                 && bIsValidSubPar_Disp_SW_08AVM_SWx(oDisp_SW_08AVM.eSW8) && bIsValidSubPar_Disp_SW_08AVM_SWx_Status(oDisp_SW_08AVM.eSW8_Status)
                 ) ? TRUE : FALSE;
    if (!bRet) {
        ETG_TRACE_USR4( ( "dispvidctrl_tclMCanClientAvm::bIsValidPar_Disp_SW_08AVM(): some sub-parameter value is invalid") );
    }
    return bRet;
}
tBool dispvidctrl_tclMCanClientAvm::bIsValidSubPar_Disp_SW_08AVM_SWx(const tcl_ITM_Camera_System_e32_SW& eSW)
{ 
    tBool bRet = (  (tcl_ITM_Camera_System_e32_SW::FI_EN_NORMAL     == eSW.enType)
                 || (tcl_ITM_Camera_System_e32_SW::FI_EN_MASK       == eSW.enType)
                 || (tcl_ITM_Camera_System_e32_SW::FI_EN_PUSH       == eSW.enType)
                 || (tcl_ITM_Camera_System_e32_SW::FI_EN_HIGH_LIGHT == eSW.enType) ) ? TRUE : FALSE;
    return bRet;
}
tBool dispvidctrl_tclMCanClientAvm::bIsValidSubPar_Disp_SW_08AVM_SWx_Status(const tcl_ITM_Camera_System_e32_SW1_Status& eSW_Status)
{
    tBool bRet = (     (      tcl_ITM_Camera_System_e32_SW1_Status::FI_EN_WITHOUT_SW         ==       eSW_Status.enType)
                 || (  ((tU32)tcl_ITM_Camera_System_e32_SW1_Status::FI_EN_HIGH_ANGLE_VIEW_SW <= (tU32)eSW_Status.enType)
                    && ((tU32)tcl_ITM_Camera_System_e32_SW1_Status::FI_EN_RESERVE_SW         >= (tU32)eSW_Status.enType) ) ) ? TRUE : FALSE;
    return bRet;
}

tBool dispvidctrl_tclMCanClientAvm::bIsValidPar_Icon(const tcl_ITM_Camera_System_Icon& oIcon)
{
    tBool bRet = (     (      tcl_ITM_Camera_System_e32_Icon::FI_EN_DISPLAYING_ICON_OFF              ==       oIcon.eIcon.enType)
                 || (  ((tU32)tcl_ITM_Camera_System_e32_Icon::FI_EN_DISPLAY_A_REAR_VIEW_ICON         <= (tU32)oIcon.eIcon.enType)
                    && ((tU32)tcl_ITM_Camera_System_e32_Icon::FI_EN_DISPLAY_A_FRONT_CORNER_VIEW_ICON >= (tU32)oIcon.eIcon.enType) ) ) ? TRUE : FALSE;
    if (!bRet) {
        ETG_TRACE_USR4( ( "dispvidctrl_tclMCanClientAvm::bIsValidPar_Icon(): value %u is invalid", oIcon.eIcon.enType) );
    }
    return bRet;
} 

tBool dispvidctrl_tclMCanClientAvm::bIsValidPar_Buzzer_Status(const tcl_ITM_Camera_System_Buzzer_Status& oBuzzer_Status)
{
    tBool bRet = (  (tcl_ITM_Camera_System_e32_Buzzer_Status::FI_EN_BUZZER_OFF == oBuzzer_Status.eBuzzer_Status.enType)
                 || (tcl_ITM_Camera_System_e32_Buzzer_Status::FI_EN_BUZZER_ON  == oBuzzer_Status.eBuzzer_Status.enType) ) ? TRUE : FALSE;
    if (!bRet) {
        ETG_TRACE_USR4( ( "dispvidctrl_tclMCanClientAvm::bIsValidPar_Buzzer_Status(): value %u is invalid", oBuzzer_Status.eBuzzer_Status.enType) );
    }
    return bRet;
}

tBool dispvidctrl_tclMCanClientAvm::bIsValidPar_Error_Message(const tcl_ITM_Camera_System_Error_Message& oError_Message)
{
    tBool bRet = (     (      tcl_ITM_Camera_System_e32_Error_Message::FI_EN_NO_DISPLAY                         ==       oError_Message.eError_Message.enType)
                 || (  ((tU32)tcl_ITM_Camera_System_e32_Error_Message::FI_EN_ONLY_BEEP                          <= (tU32)oError_Message.eError_Message.enType)
                    && ((tU32)tcl_ITM_Camera_System_e32_Error_Message::FI_EN_IN_CASE_OF_SONAR_OFF_DELETE_POP_UP >= (tU32)oError_Message.eError_Message.enType) ) ) ? TRUE : FALSE;
    if (!bRet) {
        ETG_TRACE_USR4( ( "dispvidctrl_tclMCanClientAvm::bIsValidPar_Error_Message(): value %u is invalid", oError_Message.eError_Message.enType) );
    }
    return bRet;
}

/////// methods to send messages to MCAN

tVoid dispvidctrl_tclMCanClientAvm::vFillAndSendMsg_View_Change_08AVM_Status(tVoid)
{
    // for the parameter Invalid_Parameter, we will construct the value on-the-fly:
    tcl_ITM_Camera_System_Invalid_Parameter oInvalid_Parameter;
    oInvalid_Parameter.eInvalid_Parameter.enType = _bRxParamsValid_View_Change_08AVM
                                                 ? tcl_ITM_Camera_System_e32_Invalid_Parameter::FI_EN_NORMAL
                                                 : tcl_ITM_Camera_System_e32_Invalid_Parameter::FI_EN_OUT_OF_RANGE;                                                 
    setView_Change_08AVMStatusOutInvalid_Parameter(oInvalid_Parameter);
    
    // for all other parameters, we copy the last received values into the output MCAN parameter objects:
    setView_Change_08AVMStatusOutDisp_Status(_oRxParam_Disp_Status);
    setView_Change_08AVMStatusOutView_Pattern(_oRxParam_View_Pattern);
    setView_Change_08AVMStatusOutCaution(_oRxParam_Caution);
    setView_Change_08AVMStatusOutDisp_SW_08AVM(_oRxParam_Disp_SW_08AVM);
    setView_Change_08AVMStatusOutBuzzer_Status(_oRxParam_Buzzer_Status);
    setView_Change_08AVMStatusOutIcon(_oRxParam_Icon);

    ETG_TRACE_USR4(("dispvidctrl_tclMCanClientAvm::vFillAndSendMsg_View_Change_08AVM_Status(): sending message"));
    MCAN_MAPMSG_SET_CHANGED(View_Change_08AVM,STATUS);
    vCheck4Messages2Send();         
}

tVoid dispvidctrl_tclMCanClientAvm::vFillAndSendMsg_Direct_Camera_Off_Indication(tVoid) {
    ETG_TRACE_USR4(( "dispvidctrl_tclMCanClientAvm::vFillAndSendMsg_Direct_Camera_Off_Ind(): sending indication" ));
    MCAN_MAPMSG_SET_CHANGED(Direct_Camera_OFF,INDICATION);
    vCheck4Messages2Send();
}

tVoid dispvidctrl_tclMCanClientAvm::vFillAndSendMsg_SW_Signal_Indication(tU8 u8SW_Status, tU8 u8Disp_Status)
{
    _bActivatingVidSettings = FALSE;
    
    tcl_ITM_Camera_System_SW_Status oSW_Status;
    oSW_Status.eSW_Status.enType = (tcl_ITM_Camera_System_e32_SW_Status::tenType)u8SW_Status;
    setSW_SignalIndicationOutSW_Status(oSW_Status);

    tcl_ITM_Camera_System_Disp_Status oDisp_Status;
    oDisp_Status.eDisp_Status.enType = (tcl_ITM_Camera_System_e32_Disp_Status::tenType)u8Disp_Status;
    setSW_SignalIndicationOutDisp_Status(oDisp_Status);

    switch(u8SW_Status) {
       // after sending a press of the MOD_IND_ON button, beep if we receive the toggled button state
       // (i.e. a Blanking_less_Change_08AVM message with a request to show the MOD_IND_OFF button), and vice versa:
       case tcl_ITM_Camera_System_e32_SW_Status::FI_EN_MOD_IND_ON_SW:
         _u8BeepTriggerSwitchId = tcl_ITM_Camera_System_e32_SW_Status::FI_EN_MOD_IND_OFF_SW;
         break;
       case tcl_ITM_Camera_System_e32_SW_Status::FI_EN_MOD_IND_OFF_SW:
         _u8BeepTriggerSwitchId = tcl_ITM_Camera_System_e32_SW_Status::FI_EN_MOD_IND_ON_SW;
         break;
       // same logic for the SONAR_IND_ON / SONAR_IND_OFF buttons:
       case tcl_ITM_Camera_System_e32_SW_Status::FI_EN_SONAR_IND_ON_SW_DISPLAY_SW_:
         _u8BeepTriggerSwitchId = tcl_ITM_Camera_System_e32_SW_Status::FI_EN_SONAR_IND_OFF_SW_DISPLAY_SW_;
         break;
       case tcl_ITM_Camera_System_e32_SW_Status::FI_EN_SONAR_IND_OFF_SW_DISPLAY_SW_:
         _u8BeepTriggerSwitchId = tcl_ITM_Camera_System_e32_SW_Status::FI_EN_SONAR_IND_ON_SW_DISPLAY_SW_;
         break;
       // same logic for the MOD_SONAR_IND_ON / MOD_SONAR_IND_OFF buttons:         
       case tcl_ITM_Camera_System_e32_SW_Status::FI_EN_MOD_SONAR_IND_ON_SW_DISPLAY_SW_:
         _u8BeepTriggerSwitchId = tcl_ITM_Camera_System_e32_SW_Status::FI_EN_MOD_SONAR_IND_OFF_SW_DISPLAY_SW_;
         break;
       case tcl_ITM_Camera_System_e32_SW_Status::FI_EN_MOD_SONAR_IND_OFF_SW_DISPLAY_SW_:
         _u8BeepTriggerSwitchId = tcl_ITM_Camera_System_e32_SW_Status::FI_EN_MOD_SONAR_IND_ON_SW_DISPLAY_SW_;
         break;
       // else make sure we won't beep on reception of a Blanking_less_Change_08AVM message:
       default:
         _u8BeepTriggerSwitchId = 0x00;
         break;
    }
    
    ETG_TRACE_USR1(( "dispvidctrl_tclMCanClientAvm::vFillAndSendMsg_SW_Signal_Indication(): sending SW_Status=%u Disp_Status=%u",
                      ETG_ENUM(tenAvmMcanEnum_SW_Status,u8SW_Status), ETG_ENUM(tenAvmMcanEnum_Disp_Status,u8Disp_Status) ));
    MCAN_MAPMSG_SET_CHANGED(SW_Signal,INDICATION);
    vCheck4Messages2Send();
}

tVoid dispvidctrl_tclMCanClientAvm::vFillAndSendMsg_AVM_Sonar_Buzzer_Set(tU8 u8Buzzer_Status)
{
    tcl_ITM_Camera_System_Buzzer_Status oBuzzer_Status;
    oBuzzer_Status.eBuzzer_Status.enType = (tcl_ITM_Camera_System_e32_Buzzer_Status::tenType)u8Buzzer_Status;
    setAVM_Sonar_BuzzerSetOutBuzzer_Status(oBuzzer_Status);
    
    ETG_TRACE_USR4(("dispvidctrl_tclMCanClientAvm::vFillAndSendMsg_AVM_Sonar_Buzzer_Set(): sending message"));
    MCAN_MAPMSG_SET_CHANGED(AVM_Sonar_Buzzer,SET);
    vCheck4Messages2Send();
}

tVoid dispvidctrl_tclMCanClientAvm::vFillAndSendMsg_Camera_Primary_Setting_Get(tVoid)
{
    ETG_TRACE_USR4(("dispvidctrl_tclMCanClientAvm::vFillAndSendMsg_Camera_Primary_Setting_Get(): sending message"));
    MCAN_MAPMSG_SET_CHANGED(Camera_Primary_Setting,GET);
    vCheck4Messages2Send();
}

tVoid dispvidctrl_tclMCanClientAvm::vFillAndSendMsg_Camera_Primary_Setting_Set(tU8 u8AVM_Sonar, tBool bDetail_Setting, tBool bImage_Quality)
{
    tcl_ITM_Camera_System_Primary_Setting oPrimary_Setting;
    oPrimary_Setting.eAVM_Sonar.enType      = (tcl_ITM_Camera_System_e32_AVM_Sonar::tenType)     u8AVM_Sonar;
    oPrimary_Setting.eDetail_Setting.enType = (tcl_ITM_Camera_System_e32_Detail_Setting::tenType)bDetail_Setting;
    oPrimary_Setting.eImage_Quality.enType  = (tcl_ITM_Camera_System_e32_Image_Quality::tenType) bImage_Quality;
    setCamera_Primary_SettingSetOutPrimary_Setting(oPrimary_Setting);    
    
    ETG_TRACE_USR4(("dispvidctrl_tclMCanClientAvm::vFillAndSendMsg_Camera_Primary_Setting_Set(): sending message"));
    MCAN_MAPMSG_SET_CHANGED(Camera_Primary_Setting,SET);
    vCheck4Messages2Send();
}

tVoid dispvidctrl_tclMCanClientAvm::vFillAndSendMsg_Camera_Setting_08AVM_Get(tVoid)
{
    ETG_TRACE_USR4(("dispvidctrl_tclMCanClientAvm::vFillAndSendMsg_Camera_Setting_08AVM_Get(): sending message"));
    MCAN_MAPMSG_SET_CHANGED(Camera_Setting_08AVM,GET);
    vCheck4Messages2Send();
}

tVoid dispvidctrl_tclMCanClientAvm::vFillAndSendMsg_Camera_Setting_08AVM_Set(DISPVIDCTRL_TY_VECTOR(tstSettingsItem) arChangedItems)
{
    tcl_ITM_Camera_System_Camera_08AVM       _oCamera08AVM       = _oRxParam_Camera_08AVM;
    tcl_ITM_Camera_System_Corner_Sonar_Level _oCornerSonarLevel  = _oRxParam_Corner_Sonar_Level;
    tcl_ITM_Camera_System_Sonar_Level        _oSonarLevelSetting = _oRxParam_Sonar_Level;
    
    for (tU32 u32Idx=0; u32Idx<arChangedItems.size(); ++u32Idx) {
        tU8 u8ItemId    = arChangedItems[u32Idx].u8Id;
        tU8 u8ItemState = arChangedItems[u32Idx].u8State;
        
        #define CASE___SETUP_MCAN_PARAM(FiIdName,LocVarName,McanParamName) \
            case rvc_fi_tcl_e8_AVMph3_SettingItemId::FiIdName: \
                LocVarName.e##McanParamName.enType = (tcl_ITM_Camera_System_e32_##McanParamName::tenType)u8ItemState;  \
                break;    
        switch ((rvc_fi_tcl_e8_AVMph3_SettingItemId::tenType)u8ItemId) {
            CASE___SETUP_MCAN_PARAM(FI_EN_VEHICLE_SPEED,     _oCamera08AVM, Vehicle_Speed)
            CASE___SETUP_MCAN_PARAM(FI_EN_VIEW_LINE,         _oCamera08AVM, View_Line)
            CASE___SETUP_MCAN_PARAM(FI_EN_PRIORITY_VIEW,     _oCamera08AVM, Priority_View)
            CASE___SETUP_MCAN_PARAM(FI_EN_MASK_EMPHASIS,     _oCamera08AVM, Mask_Emphasis)
            CASE___SETUP_MCAN_PARAM(FI_EN_SIDE_SONAR_DISP,   _oCamera08AVM, Side_Sonar_Disp)
            CASE___SETUP_MCAN_PARAM(FI_EN_ADJUST_TOPVIEW,    _oCamera08AVM, Adjust_Topview)
            CASE___SETUP_MCAN_PARAM(FI_EN_PRIORITY_WIDE,     _oCamera08AVM, Priority_Wide)
            CASE___SETUP_MCAN_PARAM(FI_EN_AUTO_CAM_POSITION, _oCamera08AVM, Auto_Cam_Position)
            CASE___SETUP_MCAN_PARAM(FI_EN_VOLUME_VOICE,      _oCamera08AVM, Volume_Voice)
            CASE___SETUP_MCAN_PARAM(FI_EN_SONAR_BUZZER,      _oCamera08AVM, Sonar_Buzzer)
            CASE___SETUP_MCAN_PARAM(FI_EN_REAR_WIDE_VIEW,    _oCamera08AVM, Rear_Wide_View)
            CASE___SETUP_MCAN_PARAM(FI_EN_SONAR_ON_OFF,      _oCamera08AVM, Sonar_ON_OFF)
            CASE___SETUP_MCAN_PARAM(FI_EN_MOD_INTERRUPT,     _oCamera08AVM, MOD_Interrupt)
            CASE___SETUP_MCAN_PARAM(FI_EN_SONAR_INTERRUPT,   _oCamera08AVM, Sonar_Interrupt)
            CASE___SETUP_MCAN_PARAM(FI_EN_MOD_FUNCTION,      _oCamera08AVM, MOD_Function)
            CASE___SETUP_MCAN_PARAM(FI_EN_MOD_NIGHT_USE,     _oCamera08AVM, MOD_Night_Use)
            CASE___SETUP_MCAN_PARAM(FI_EN_BCP_FUNCTION,      _oCamera08AVM, BCP_Function)
            CASE___SETUP_MCAN_PARAM(FI_EN_FRONT_SONAR_ONLY,  _oCamera08AVM, Front_Sonar_Only)

            CASE___SETUP_MCAN_PARAM(FI_EN_CORNER_SONAR_SENSITIVITY, _oCornerSonarLevel, Corner_Sonar_Sensitivity_Level)

            CASE___SETUP_MCAN_PARAM(FI_EN_BUZZER_SOUND_LEVEL,      _oSonarLevelSetting, Sonar_Buzzer_Volume_Level)
            CASE___SETUP_MCAN_PARAM(FI_EN_SONAR_SENSITIVITY_LEVEL, _oSonarLevelSetting, Sonar_Sensitivity_Level)
    
            default:
                break;
        }
        #undef CASE___SETUP_MCAN_PARAM
    }
    
    setCamera_Setting_08AVMSetOutCamera_08AVM      (_oCamera08AVM);
    setCamera_Setting_08AVMSetOutCorner_Sonar_Level(_oCornerSonarLevel);
    setCamera_Setting_08AVMSetOutSonar_Level       (_oSonarLevelSetting);

    ETG_TRACE_USR4(("dispvidctrl_tclMCanClientAvm::vFillAndSendMsg_Camera_Setting_08AVM_Set(): sending message"));
    MCAN_MAPMSG_SET_CHANGED(Camera_Setting_08AVM,SET);
    vCheck4Messages2Send();
}

tVoid dispvidctrl_tclMCanClientAvm::vFillAndSendMsg_Software_Version_Get(tVoid)
{
    ETG_TRACE_USR4(("dispvidctrl_tclMCanClientAvm::vFillAndSendMsg_Software_Version_Get(): sending message"));
    MCAN_MAPMSG_SET_CHANGED(Software_Version,GET);
    vCheck4Messages2Send();
}

tVoid dispvidctrl_tclMCanClientAvm::vFillAndSendMsg_Hardware_Version_Get(tVoid)
{
    ETG_TRACE_USR4(("dispvidctrl_tclMCanClientAvm::vFillAndSendMsg_Hardware_Version_Get(): sending message"));
    MCAN_MAPMSG_SET_CHANGED(Hardware_Version,GET);
    vCheck4Messages2Send();
}

tVoid dispvidctrl_tclMCanClientAvm::vFillAndSendMsg_MCAN_Communication_Error_Get(tVoid)
{
    ETG_TRACE_USR4(("dispvidctrl_tclMCanClientAvm::vFillAndSendMsg_MCAN_Communication_Error_Get(): sending message"));
    MCAN_MAPMSG_SET_CHANGED(MCAN_Communication_Error,GET);
    vCheck4Messages2Send();
}

tVoid dispvidctrl_tclMCanClientAvm::vFillAndSendMsg_MCAN_Communication_Error_Clear_Set(tVoid)
{
    ETG_TRACE_USR4(("dispvidctrl_tclMCanClientAvm::vFillAndSendMsg_MCAN_Communication_Error_Clear_Set(): sending message"));
    MCAN_MAPMSG_SET_CHANGED(MCAN_Communication_Error_Clear,SET);
    vCheck4Messages2Send();
}

tVoid dispvidctrl_tclMCanClientAvm::vFillAndSendMsg_Camera_Diag_Sensor_Get(tVoid)
{
    ETG_TRACE_USR4(("dispvidctrl_tclMCanClientAvm::vFillAndSendMsg_Camera_Diag_Sensor_Get(): sending message"));
    MCAN_MAPMSG_SET_CHANGED(Camera_Diag_Sensor,GET);
    vCheck4Messages2Send();
}

tVoid dispvidctrl_tclMCanClientAvm::vFillAndSendMsg_Camera_Diag_Sensor_Set(tVoid)
{
    ETG_TRACE_USR4(("dispvidctrl_tclMCanClientAvm::vFillAndSendMsg_Camera_Diag_Sensor_Set(): sending message"));
    MCAN_MAPMSG_SET_CHANGED(Camera_Diag_Sensor,SET);
    vCheck4Messages2Send();
}

tVoid dispvidctrl_tclMCanClientAvm::vClearAllPendingMcanMsg(tVoid)
{
    clearMsgSequences();

    MCAN_MAPMSG_CLR_CHANGED(Software_Version,GET);
    MCAN_MAPMSG_CLR_CHANGED(Hardware_Version,GET);
    MCAN_MAPMSG_CLR_CHANGED(SW_Signal,INDICATION);
    
    MCAN_MAPMSG_CLR_CHANGED(View_Change_08AVM,STATUS);
    MCAN_MAPMSG_CLR_CHANGED(Direct_Camera_OFF,INDICATION);    
    MCAN_MAPMSG_CLR_CHANGED(AVM_Sonar_Buzzer,SET);
    
    MCAN_MAPMSG_CLR_CHANGED(Camera_Setting_08AVM,GET);
    MCAN_MAPMSG_CLR_CHANGED(Camera_Setting_08AVM,SET);
    MCAN_MAPMSG_CLR_CHANGED(Camera_Primary_Setting,GET);
    MCAN_MAPMSG_CLR_CHANGED(Camera_Primary_Setting,SET);
    
    MCAN_MAPMSG_CLR_CHANGED(MCAN_Communication_Error,GET);
    MCAN_MAPMSG_CLR_CHANGED(MCAN_Communication_Error_Clear,SET);
    MCAN_MAPMSG_CLR_CHANGED(Camera_Diag_Sensor,GET);
    MCAN_MAPMSG_CLR_CHANGED(Camera_Diag_Sensor,SET);
}


/////// method to receive (synchronously processable) output from the AVM FSM and the AVM3 Control

tVoid dispvidctrl_tclMCanClientAvm::vHandleFsmOutput(tenFsmOutputEvent eEvent, const void* pvData)
{
    ETG_TRACE_USR1( ( "dispvidctrl_tclMCanClientAvm::vHandleFsmOutput(): event=%u", ETG_CENUM(I_dispvidctrl_tclMCanClientAvm::tenFsmOutputEvent,eEvent) ) );    
    if (!_bAvmPhase3Configured) {
        ETG_TRACE_USR4(("dispvidctrl_tclMCanClientAvm::vHandleFsmOutput(): AVM phase 3 not configured, doing nothing"));
        return;
    }
    
    switch(eEvent)
    {
        case eHandleCommEstablished:
            vClearAllPendingMcanMsg();
            break;
            
        case eSetUnitConfig:
            _oRxParam_UnitConfiguration = *(const tstUnitConfiguration*)pvData;
            vSendConfigurationInfoToServer();
            break;
        case eNormalBeep:
            vSendNormalBeepReq(*(const tBool*)pvData);
            break;
        case eErrorBeep:
            vSendErrorBeepReq(*(const tBool*)pvData);
            break;
        case eSendSwitchToAvm:
            if (!_bDiagVideoActive) {
               const tU32* pu32Data = (const tU32*)pvData;
               vFillAndSendMsg_SW_Signal_Indication( (tU8)pu32Data[0], (tU8)pu32Data[1] );
            }
            break;
        case eSendBciSwitch:
            vSendBciSwitch(*(const tU32*)pvData);
            break;

        case eVisOn_BlankOn:
            if (_bActivatingVidSettings) {
                               vSendEventToControl(EN_CONTROL_HMIAVM3__VISUALISATION_ON_VIDEO_SETTINGS);  break;
                               //CID:172490
							  // _bActivatingVidSettings = FALSE;
            } else {
                               vSendEventToControl(EN_CONTROL_HMIAVM3__VISUALISATION_ON);       break;
            }
        case eVisOn_BlankOff:  vSendEventToControl(EN_CONTROL_HMIAVM3__BLANKOFFREQ_BLACK_IN);   break;
        case eVisChg_BlankOn:  vSendEventToControl(EN_CONTROL_HMIAVM3__VISUALISATION_ON);       break;
        case eVisChg_BlankOff: vSendEventToControl(EN_CONTROL_HMIAVM3__BLANKOFFREQ_BLACK_IN);   break;
        case eVisOff_BlankOn:  vSendEventToControl(EN_CONTROL_HMIAVM3__VISUALISATION_OFF);      break;
        case eVisOff_BlankOff: vSendEventToControl(EN_CONTROL_HMIAVM3__BLANKOFFREQ_BLACK_OUT);  break;

        case eHandleCommLost:  vSendEventToControl(EN_CONTROL_HMIAVM3__VISUALISATION_OFF);      break;
        
        default:
            break;
    }
}

tVoid dispvidctrl_tclMCanClientAvm::vHandleControlOutput(tenControlOutputEvent eEvent, tU32 u32Data)
{
    ETG_TRACE_USR1( ( "dispvidctrl_tclMCanClientAvm::vHandleControlOutput(): event=%u data=0x%08X", ETG_CENUM(I_dispvidctrl_tclMCanClientAvm::tenControlOutputEvent,eEvent), u32Data ) );
    if (!_bAvmPhase3Configured) {
        ETG_TRACE_USR4(("dispvidctrl_tclMCanClientAvm::vHandleControlOutput(): AVM phase 3 not configured, doing nothing"));
        return;
    }
    
    switch(eEvent)
    {
        case eHmiReqShowRvc:
            vShowRvcRequest(u32Data);
            break;

        case eHmiReqViewSetup:
            vSendViewContentToServer(TRUE,FALSE);
            vSendEventToControl(EN_CONTROL_HMIAVM3__CONF_VIEW_SETUP);
            break;

        case eHmiReqDirectCamOff:
            vFillAndSendMsg_Direct_Camera_Off_Indication();
            if (_pMcanClientAvmFsm)
            {
               // during switch-off sequence after CommLost, AVM won't respond to Direct_Camera_Off with Blanking_Off anymore, so we do it ourselves:
               if (I_dispvidctrl_tclMCanClientAvmFsm::eStateDeactivated == _pMcanClientAvmFsm->u32GetState() ||
                   I_dispvidctrl_tclMCanClientAvmFsm::eStateInitalizing == _pMcanClientAvmFsm->u32GetState() ||
                   I_dispvidctrl_tclMCanClientAvmFsm::eStateConnected   == _pMcanClientAvmFsm->u32GetState()  )
               {
                  vSendEventToControl(EN_CONTROL_HMIAVM3__BLANKOFFREQ_BLACK_OUT,0,TRUE); // 3rd param == TRUE means "as message"
               }
            }
            break;
            
        case eDiagReqShowVideo:
            vDiagVideoRequest(u32Data);
            break;
        
        case eServiceReqShowVideo:
            vCamSettingsVideoRequest(u32Data);
            break;
        
        default:
            break;
    }
    (tVoid)u32Data;
}

tVoid dispvidctrl_tclMCanClientAvm::vHandleDataEvent(tenDataEvent eEvent, tU32 u32Data1, tU32 u32Data2)
{
    ETG_TRACE_USR1( ( "dispvidctrl_tclMCanClientAvm::vHandleDataEvent(): event=%u data1=0x%08X data2=0x%08X", ETG_CENUM(I_dispvidctrl_tclMCanClientAvm::tenDataEvent,eEvent),u32Data1,u32Data2 ) );
    if (!_bAvmPhase3Configured) {
        ETG_TRACE_USR4(("dispvidctrl_tclMCanClientAvm::vHandleDataEvent(): AVM phase 3 not configured, doing nothing"));
        return;
    }

    switch(eEvent)
    {
        case eIndBciState:
            vHandleBciState((tU8)u32Data1, (tBool)u32Data2);
            break;
        default:
            break;
    }
}

/////// other utility methods

tVoid dispvidctrl_tclMCanClientAvm::vSendNormalBeepReq(tBool bBeepOn)
{
    if (bBeepOn) {
        vSendBeepReq(midw_fi_tcl_e8_AudioBeepType::FI_EN_AUDIO_BEEP_AVM_OPERATION);
    }
}


tVoid dispvidctrl_tclMCanClientAvm::vSendErrorBeepReq(tBool bBeepOn)
{
    if (bBeepOn) {
        vSendBeepReq(midw_fi_tcl_e8_AudioBeepType::FI_EN_AUDIO_BEEP_AVM_ERROR);
    }
}


tVoid dispvidctrl_tclMCanClientAvm::vSendBeepReq(midw_fi_tcl_e8_AudioBeepType::tenType eBeepType)
{
    if (_pClientAudio) {
        ETG_TRACE_USR4(("dispvidctrl_tclMCanClientAvm::vSendBeepReq(): %u", ETG_CENUM(midw_fi_tcl_e8_AudioBeepType::tenType,eBeepType) ));
        midw_fi_tcl_e8_AudioBeepType oBeepType;
        oBeepType.enType = eBeepType;
        midw_fi_tcl_e8_ResourceNo oAudioResource;
        oAudioResource.enType = midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_LS;
        (tVoid)_pClientAudio->sendBeepMStart(oBeepType,oAudioResource);
    }
}


tVoid dispvidctrl_tclMCanClientAvm::vSendTriggerToFsm(tU32 u32FsmTriggerId, tBool bFsmTriggerState)
{
    ETG_TRACE_USR1( ( "dispvidctrl_tclMCanClientAvm::vSendTriggerToFsm(): triggerID=%u, triggerState=%d",
                        ETG_CENUM(I_dispvidctrl_tclMCanClientAvmFsm::eFsmTrigger,u32FsmTriggerId),bFsmTriggerState) );
    tU32 u32TriggerIdAndState = (FALSE == bFsmTriggerState) ? u32FsmTriggerId : (u32FsmTriggerId | 0x80000000);
    _cpoMain->theServer()->vPostMsgAvm3FsmTrigger("I_dispvidctrl_tclMCanClientAvmFsm", u32TriggerIdAndState);
}

tVoid dispvidctrl_tclMCanClientAvm::vSendSwitchInputToFsm(tU32 u32SwitchId)
{
    ETG_TRACE_USR4( ( "dispvidctrl_tclMCanClientAvm::vSendSwitchInputToFsm(): switchID=%u", u32SwitchId) );    
    _cpoMain->theServer()->vPostMsgAvm3SwitchInput("I_dispvidctrl_tclMCanClientAvmFsm", u32SwitchId);
}

tVoid dispvidctrl_tclMCanClientAvm::vSendEventToControl(tenControl_HmiAvm3 eEvent, tU32 u32Value, tBool bAsMsg)
{
    if (_pControl_HmiAvm3) {
        ETG_TRACE_USR1( ( "dispvidctrl_tclMCanClientAvm::vSendEventToControl(): event=%u value=%X asMsg=%d", ETG_CENUM(tenControl_HmiAvm3,eEvent), u32Value, bAsMsg) );
        if (bAsMsg) {
           _cpoMain->theServer()->vPostMsgControlHmiAvm3("dispvidctrl_tclControl_HmiAvm3", (tU32)eEvent);
        } else {
           _pControl_HmiAvm3->vHandleControl(eEvent, u32Value);
        }
    }
}

tVoid dispvidctrl_tclMCanClientAvm::vShowRvcRequest(tU32 u32Data)
{
   tenControl_Video_BlackScreenType eBlkScrType = EN_CONTROL_VIDEO__BLACKSCREENTYPE_NONE;
   
   if (  (tcl_ITM_Camera_System_e32_Disp_Status::FI_EN_CAMERA_DISPLAY == _oRxParam_Disp_Status.eDisp_Status.enType)
      && (  (tcl_ITM_Camera_System_e32_Caution::FI_EN_DISPLAY_CAUTION_PATTERN2 == _oRxParam_Caution.eCaution.enType)
         || (tcl_ITM_Camera_System_e32_Caution::FI_EN_DISPLAY_CAUTION_PATTERN3 == _oRxParam_Caution.eCaution.enType)
         || (tcl_ITM_Camera_System_e32_Caution::FI_EN_DISPLAY_CAUTION_PATTERN4 == _oRxParam_Caution.eCaution.enType)
         )
      )
   {
      switch (_oRxParam_View_Pattern.eView_Pattern.enType)
      {
         default:
            // eBlkScrType = EN_CONTROL_VIDEO__BLACKSCREENTYPE_NONE;
            break;
         
         case tcl_ITM_Camera_System_e32_View_Pattern::FI_EN_PATTERN2_1: // "standard" LHD
         case tcl_ITM_Camera_System_e32_View_Pattern::FI_EN_PATTERN6_3: // parking guide LHD
         case tcl_ITM_Camera_System_e32_View_Pattern::FI_EN_PATTERN7_2: // 11AVM LHD
         case tcl_ITM_Camera_System_e32_View_Pattern::FI_EN_PATTERN9_2: // parking guide 11AVM LHD
            eBlkScrType = EN_CONTROL_VIDEO__BLACKSCREENTYPE_LHD;
            break;
         
         case tcl_ITM_Camera_System_e32_View_Pattern::FI_EN_PATTERN1_1: // "standard" RHD
         case tcl_ITM_Camera_System_e32_View_Pattern::FI_EN_PATTERN6_1: // parking guide RHD (#1)
         case tcl_ITM_Camera_System_e32_View_Pattern::FI_EN_PATTERN6_2: // parking guide RHD (#2)
         case tcl_ITM_Camera_System_e32_View_Pattern::FI_EN_PATTERN7_1: // 11AVM RHD
         case tcl_ITM_Camera_System_e32_View_Pattern::FI_EN_PATTERN9_1: // parking guide 11AVM RHD
            eBlkScrType = EN_CONTROL_VIDEO__BLACKSCREENTYPE_RHD;
            break;
         
         case tcl_ITM_Camera_System_e32_View_Pattern::FI_EN_PATTERN3_1: // rear wide system RHD
         case tcl_ITM_Camera_System_e32_View_Pattern::FI_EN_PATTERN3_2: // rear wide system LHD
         case tcl_ITM_Camera_System_e32_View_Pattern::FI_EN_PATTERN4_1: // wide view RHD
         case tcl_ITM_Camera_System_e32_View_Pattern::FI_EN_PATTERN5_1: // wide view LHD
         case tcl_ITM_Camera_System_e32_View_Pattern::FI_EN_PATTERN8_1: // wide 11AVM RHD
         case tcl_ITM_Camera_System_e32_View_Pattern::FI_EN_PATTERN8_2: // wide 11AVM LHD
            eBlkScrType = EN_CONTROL_VIDEO__BLACKSCREENTYPE_NONE;
            break;
         
         case tcl_ITM_Camera_System_e32_View_Pattern::FI_EN_PATTERN4_2: // corner split view RHD
            eBlkScrType = EN_CONTROL_VIDEO__BLACKSCREENTYPE_NONE;
            break;
         
         case tcl_ITM_Camera_System_e32_View_Pattern::FI_EN_PATTERN5_2: // corner split view LHD
            eBlkScrType = EN_CONTROL_VIDEO__BLACKSCREENTYPE_NONE;
            break;
         
         case tcl_ITM_Camera_System_e32_View_Pattern::FI_EN_PATTERN10_1: // calibration screen
            eBlkScrType = EN_CONTROL_VIDEO__BLACKSCREENTYPE_NONE;
            break;
      }
   }
   ETG_TRACE_USR4(( "dispvidctrl_tclMCanClientAvm::vShowRvcRequest(): data=%d, masking request = %u", u32Data, ETG_CENUM(tenControl_Video_BlackScreenType,eBlkScrType) ));

   if (EN_CONTROL_VIDEO__BLACKSCREENTYPE_NONE == eBlkScrType) {
      vSendControlEventToVideoControl((tU32)EN_CONTROL_VIDEO__SHOW_RVC);
   } else if (EN_CONTROL_VIDEO__BLACKSCREENTYPE_FULL == eBlkScrType) {
      // currently, we can't get here because EN_CONTROL_VIDEO__BLACKSCREENTYPE_FULL (intentionally) doesn't get set anywhere yet
			//CID: 139770
			// As mentioned , EN_CONTROL_VIDEO__BLACKSCREENTYPE_FULL doesnt get set anywhere. hence the below code will be logically dead code.
	 // vSendControlEventToVideoControl((tU32)EN_CONTROL_VIDEO__BLACK_SCREEN_ON, (tU32)EN_CONTROL_VIDEO__BLACKSCREENTYPE_FULL);
   } else {
      vSendControlEventToVideoControl((tU32)EN_CONTROL_VIDEO__SHOW_RVC);
      vSendControlEventToVideoControl((tU32)EN_CONTROL_VIDEO__BLACK_SCREEN_ON, (tU32)eBlkScrType);
   }
}

tVoid dispvidctrl_tclMCanClientAvm::vSendControlEventToVideoControl(tU32 u32ControlEventId, tU32 u32Value)
{
   dispvidctrl_tclControl_Video* pVidCtrl = dynamic_cast<dispvidctrl_tclControl_Video*>(_cpoMain->getHandler("dispvidctrl_tclControl_Video"));
   if (pVidCtrl) {
      pVidCtrl->vHandleControl((tenControl_Video)u32ControlEventId, u32Value);
   }
}

tVoid dispvidctrl_tclMCanClientAvm::vDiagVideoRequest(tU32 u32Data)
{
   tenControl_HmiAvm3 eControlEvt;
   tU8                u8SwitchId, u8DispState;
   
   if ( 0 != u32Data ) {
      _bDiagVideoActive = TRUE;
      eControlEvt = EN_CONTROL_HMIAVM3__VISUALISATION_ON_CAMERA_DIAG;
      u8SwitchId  = tcl_ITM_Camera_System_e32_SW_Status::FI_EN_REVERSE_SW_ON;
      u8DispState = tcl_ITM_Camera_System_e32_Disp_Status::FI_EN_EXCEPT_FOR_CAMERA_DISPLAY;
   } else {
      _bDiagVideoActive = FALSE;
      eControlEvt = EN_CONTROL_HMIAVM3__VISUALISATION_OFF;
      u8SwitchId  = tcl_ITM_Camera_System_e32_SW_Status::FI_EN_REVERSE_SW_OFF;
      u8DispState = tcl_ITM_Camera_System_e32_Disp_Status::FI_EN_CAMERA_DISPLAY;      
   }
   vSendEventToControl(eControlEvt,0,TRUE);  // 3rd param == TRUE means "as message"
   vFillAndSendMsg_SW_Signal_Indication(u8SwitchId,u8DispState);
}

tVoid dispvidctrl_tclMCanClientAvm::vCamSettingsVideoRequest(tU32 u32Data)
{
   if ( 0 != u32Data ) {  // activation request?
      if ((I_dispvidctrl_tclMCanClientAvmFsm::eStateAvmIdle == _pMcanClientAvmFsm->u32GetState()) && !_bActivatingVidSettings) {
         vFillAndSendMsg_SW_Signal_Indication(tcl_ITM_Camera_System_e32_SW_Status::FI_EN_REVERSE_SW_ON,
                                              tcl_ITM_Camera_System_e32_Disp_Status::FI_EN_EXCEPT_FOR_CAMERA_DISPLAY);
         _bActivatingVidSettings = TRUE;  // vFillAndSendMsg_SW_Signal_Indication() clears _bActivatingVidSettings, so set it only after the call
      }
   } else {               // deactivation request
      if ((I_dispvidctrl_tclMCanClientAvmFsm::eStateAvmVideo == _pMcanClientAvmFsm->u32GetState())                           ) {
         vFillAndSendMsg_SW_Signal_Indication(tcl_ITM_Camera_System_e32_SW_Status::FI_EN_REVERSE_SW_OFF,
                                              tcl_ITM_Camera_System_e32_Disp_Status::FI_EN_CAMERA_DISPLAY);
      }
   }
}


/////// methods for outgoing CCA messages

tVoid dispvidctrl_tclMCanClientAvm::vSendViewContentToServer(tBool bSendDispStat, tBool bSendErrMsg)
{
    // tbd: what to send to whom in the early phase? 
    // - ViewPattern (<=> general layout mask), CautionId (<=> warning text and/or masking), IconId ?
    // - to SyncHandler ? and if so: also in late phase?
    
    if (_pServiceRvc) {
        ETG_TRACE_USR4( ( "dispvidctrl_tclMCanClientAvm::vSendViewContentToServer() called, bSendDispStat=%d, bSendErrMsg=%d", bSendDispStat,bSendErrMsg) );

        // first send the "core" property describing the screen
        rvc_fi_tcl_e8_AVMph3_ViewPattern   oViewPattern;
        rvc_fi_tcl_e8_AVMph3_CautionId     oCautionId;
        rvc_fi_tcl_e8_AVMph3_IconId        oIconId;
        rvc_fi_tcl_e8_AVMph3_BuzzerStatus  oBuzzerStatus;
        oViewPattern.enType   = (rvc_fi_tcl_e8_AVMph3_ViewPattern ::tenType)_oRxParam_View_Pattern.eView_Pattern.enType;
        if (_bDiagVideoActive) {
            oCautionId.enType =  rvc_fi_tcl_e8_AVMph3_CautionId   ::FI_EN_NONE;
            oIconId.enType    =  rvc_fi_tcl_e8_AVMph3_IconId      ::FI_EN_NONE;
        } else {
            oCautionId.enType = (rvc_fi_tcl_e8_AVMph3_CautionId   ::tenType)_oRxParam_Caution.eCaution.enType;
            oIconId.enType    = (rvc_fi_tcl_e8_AVMph3_IconId      ::tenType)_oRxParam_Icon.eIcon.enType;
        }
        oBuzzerStatus.enType  = (rvc_fi_tcl_e8_AVMph3_BuzzerStatus::tenType)_oRxParam_Buzzer_Status.eBuzzer_Status.enType;
        
        rvc_fi_tcl_AVMph3_SwitchDescriptor aoSw[8];
        for(tU32 u32Idx=0; u32Idx<8; ++u32Idx) {
            aoSw[u32Idx].Id.enType     = rvc_fi_tcl_e8_AVMph3_SwitchId    ::FI_EN_NONE;
            aoSw[u32Idx].Status.enType = rvc_fi_tcl_e8_AVMph3_SwitchStatus::FI_EN_NORMAL;    
        }
        if (!_bDiagVideoActive) {
            // put in the data we received from MCAN
            vRemapRxSwitchStatesToFiMsg((tU8)_oRxParam_Disp_SW_08AVM.eSW1_Status.enType, (tU8)_oRxParam_Disp_SW_08AVM.eSW1.enType, & aoSw[0]);
            vRemapRxSwitchStatesToFiMsg((tU8)_oRxParam_Disp_SW_08AVM.eSW2_Status.enType, (tU8)_oRxParam_Disp_SW_08AVM.eSW2.enType, & aoSw[0]);
            vRemapRxSwitchStatesToFiMsg((tU8)_oRxParam_Disp_SW_08AVM.eSW3_Status.enType, (tU8)_oRxParam_Disp_SW_08AVM.eSW3.enType, & aoSw[0]);
            vRemapRxSwitchStatesToFiMsg((tU8)_oRxParam_Disp_SW_08AVM.eSW4_Status.enType, (tU8)_oRxParam_Disp_SW_08AVM.eSW4.enType, & aoSw[0]);
            vRemapRxSwitchStatesToFiMsg((tU8)_oRxParam_Disp_SW_08AVM.eSW5_Status.enType, (tU8)_oRxParam_Disp_SW_08AVM.eSW5.enType, & aoSw[0]);
            vRemapRxSwitchStatesToFiMsg((tU8)_oRxParam_Disp_SW_08AVM.eSW6_Status.enType, (tU8)_oRxParam_Disp_SW_08AVM.eSW6.enType, & aoSw[0]);
            vRemapRxSwitchStatesToFiMsg((tU8)_oRxParam_Disp_SW_08AVM.eSW7_Status.enType, (tU8)_oRxParam_Disp_SW_08AVM.eSW7.enType, & aoSw[0]);
            vRemapRxSwitchStatesToFiMsg((tU8)_oRxParam_Disp_SW_08AVM.eSW8_Status.enType, (tU8)_oRxParam_Disp_SW_08AVM.eSW8.enType, & aoSw[0]);
            // add the BCI state we received from VCAN
            vRemapRxSwitchStatesToFiMsg(     _u8BciSwitchId,                                  _u8BciSwitchStatus,                  & aoSw[0]);
        } // else keep FI_EN_NONE / FI_EN_NORMAL for all buttons (as set above per default) to keep all buttons unavailable

        ETG_TRACE_USR4(("  Pattern = %u", ETG_ENUM(DISPVIDCTRL_E8_AVMPH3_VIEWPATTERN, oViewPattern.enType)));
        ETG_TRACE_USR4(("  Caution = %u", ETG_ENUM(DISPVIDCTRL_E8_AVMPH3_CAUTIONID,   oCautionId.enType)));
        for(tU32 u32Idx=0; u32Idx<8; ++u32Idx) {
            ETG_TRACE_USR4(("  SW%u.... = %u:%u", u32Idx+1, ETG_ENUM(DISPVIDCTRL_E8_AVMPH3_SWITCHID,     aoSw[u32Idx].Id.enType),
                                                            ETG_ENUM(DISPVIDCTRL_E8_AVMPH3_SWITCHSTATUS, aoSw[u32Idx].Status.enType) ));
        }
        ETG_TRACE_USR4(("  Icon... = %u", ETG_ENUM(DISPVIDCTRL_E8_AVMPH3_ICONID,      oIconId.enType)));
        ETG_TRACE_USR4(("  Buzzer. = %u", ETG_ENUM(DISPVIDCTRL_E8_AVMPH3_BUZZERSTATUS,oBuzzerStatus.enType)));

        // on the way, send a MOD/SONAR key press beep if necessary:        
        if (0x00!=_u8BeepTriggerSwitchId && aoSw[1].Id.enType==_u8BeepTriggerSwitchId) {
           vSendNormalBeepReq(TRUE);
        }
        _u8BeepTriggerSwitchId = 0x00;

        (tVoid)_pServiceRvc->sendAVM3_ViewSetupStatus(oViewPattern, oCautionId,
           aoSw[0],aoSw[1],aoSw[2],aoSw[3],aoSw[4],aoSw[5],aoSw[6],aoSw[7],  oIconId, oBuzzerStatus);

        // then send the supplementary properties, depending on the situation in which this message was called
        if (bSendDispStat) {  // in case this method gets called because of a View_Change_08AVM.Status
            rvc_fi_tcl_e8_AVMph3_DispStatus   oDispStatus;    // View_Change_08AVM: parameter for cam/non-cam screen (not sure it it's really needed on CCA at all, but anyway)
            oDispStatus.enType   = (rvc_fi_tcl_e8_AVMph3_DispStatus  ::tenType)_oRxParam_Disp_Status.eDisp_Status.enType;
            (tVoid)_pServiceRvc->sendAVM3_DispStatusStatus  (oDispStatus  );
        }  
        if (bSendErrMsg) {  // in case this method gets called because of a Blanking_less_Change_08AVM.Indication
            rvc_fi_tcl_e8_AVMph3_ErrorMessage oErrorMessage;  // Blanking_less_Change_08AVM: parameter for error beeps and showing/removing popups
            oErrorMessage.enType = (rvc_fi_tcl_e8_AVMph3_ErrorMessage::tenType)_oRxParam_Error_Message.eError_Message.enType;
            (tVoid)_pServiceRvc->sendAVM3_ErrorMessageStatus(oErrorMessage);
        }
    }
}


tVoid dispvidctrl_tclMCanClientAvm::vRemapRxSwitchStatesToFiMsg(tU8 u8SwitchId, tU8 u8SwitchStatus, rvc_fi_tcl_AVMph3_SwitchDescriptor poSw[])
{
    tS32 s32FiObjIdx = -1;
    switch (u8SwitchId)
    {
        case tcl_ITM_Camera_System_e32_SW1_Status::FI_EN_VIEW_SWITCHING_SW:    // view switching switch is the only switch in this "slot"
            s32FiObjIdx = 0;
            break;
        case tcl_ITM_Camera_System_e32_SW1_Status::FI_EN_MOD_SONAR_IND_ON_SW:  // these switches are mutually exclusive and share the same "slot":
        case tcl_ITM_Camera_System_e32_SW1_Status::FI_EN_MOD_SONAR_IND_OFF_SW:
        case tcl_ITM_Camera_System_e32_SW1_Status::FI_EN_MOD_IND_ON_SW:
        case tcl_ITM_Camera_System_e32_SW1_Status::FI_EN_MOD_IND_OFF_SW:
        case tcl_ITM_Camera_System_e32_SW1_Status::FI_EN_SONAR_IND_ON_SW:
        case tcl_ITM_Camera_System_e32_SW1_Status::FI_EN_SONAR_IND_OFF_SW:
            s32FiObjIdx = 1;
            break;
        case rvc_fi_tcl_e8_AVMph3_SwitchId::FI_EN_BCI_IND_ON:
        case rvc_fi_tcl_e8_AVMph3_SwitchId::FI_EN_BCI_IND_OFF:
            // "BCI IND OFF" and "BCI IND ON" are mutually exclusive and share the same "slot"        
            // (note: these switch IDs come in via VCAN, but we "abuse" the FI for them, using these two "invented" switch IDs)        
            s32FiObjIdx = 2;
            break;
        case tcl_ITM_Camera_System_e32_SW1_Status::FI_EN_PARKING_GUIDE_SW:      // parking guide switch is the only switch in this "slot"
            s32FiObjIdx = 3;
            break;
        case tcl_ITM_Camera_System_e32_SW1_Status::FI_EN_POINT_REGISTRATION_SW: // save-auto-display-point switch is the only switch in this "slot"
            s32FiObjIdx = 4;
            break;
        case tcl_ITM_Camera_System_e32_SW1_Status::FI_EN_POINT_ERASE_SW:        // delete-auto-display-point switch is the only switch in this "slot"
            s32FiObjIdx = 5;
            break;
        default:
            break;
    }
    if ((-1 != s32FiObjIdx) && (rvc_fi_tcl_e8_AVMph3_SwitchId::FI_EN_NONE == poSw[s32FiObjIdx].Id.enType))
    {   // if we found the index of the parameter position for the FI message, and if this slot is still unused, fill it:
        poSw[s32FiObjIdx].Id.enType     = (rvc_fi_tcl_e8_AVMph3_SwitchId    ::tenType)u8SwitchId;
        poSw[s32FiObjIdx].Status.enType = (rvc_fi_tcl_e8_AVMph3_SwitchStatus::tenType)u8SwitchStatus;
    }
}


tVoid dispvidctrl_tclMCanClientAvm::vSendBuzzerStatusToServer(tVoid)
{
    if (_pServiceRvc) {
        ETG_TRACE_USR4( ( "dispvidctrl_tclMCanClientAvm::vSendBuzzerStatusToServer() called") );

        rvc_fi_tcl_e8_AVMph3_BuzzerStatus oBuzzerStatus;
        oBuzzerStatus.enType = (rvc_fi_tcl_e8_AVMph3_BuzzerStatus::tenType)_oRxParam_Buzzer_Status_2.eBuzzer_Status.enType;
        (tVoid)_pServiceRvc->sendAVM3_SonarBuzzerStatusStatus(oBuzzerStatus);
    }
}


tVoid dispvidctrl_tclMCanClientAvm::vSendPrimarySettingsToServer(tVoid)
{
    if (_pServiceRvc) {
        ETG_TRACE_USR4( ( "dispvidctrl_tclMCanClientAvm::vSendPrimarySettingsToServer() called") );
        
        rvc_fi_tcl_e8_AVMph3_SettingOptionState  oAvmSonarBuzzer; 
        tBool                                    bDetailsSettingsAvail;
        tBool                                    bImageQualitySettingAvail;

        oAvmSonarBuzzer.enType    = (rvc_fi_tcl_e8_AVMph3_SettingOptionState::tenType)_oRxParam_Primary_Setting.eAVM_Sonar.enType;
        bDetailsSettingsAvail     = (tcl_ITM_Camera_System_e32_Detail_Setting::FI_EN_NO_PARTICULARITY_SETTING_FUNCTION  != _oRxParam_Primary_Setting.eDetail_Setting.enType) ? TRUE : FALSE;
        bImageQualitySettingAvail = (tcl_ITM_Camera_System_e32_Image_Quality::FI_EN_NO_PICTURE_QUALITY_SETTING_FUNCTION != _oRxParam_Primary_Setting.eImage_Quality.enType)   ? TRUE : FALSE;
        
        (tVoid)_pServiceRvc->sendAVM3_Settings_PrimaryStatus(oAvmSonarBuzzer, bDetailsSettingsAvail, bImageQualitySettingAvail);
    }
}


tVoid dispvidctrl_tclMCanClientAvm::vSendDetailSettingsToServer(tVoid)
{
    if (_pServiceRvc) {
        ETG_TRACE_USR4( ( "dispvidctrl_tclMCanClientAvm::vSendDetailSettingsToServer() called") );
        
        rvc_fi_tcl_e8_AVMph3_Setting_PrioView        oPriorityView;
        rvc_fi_tcl_e8_AVMph3_Setting_PrioWide        oPriorityWide;
        rvc_fi_tcl_e8_AVMph3_Setting_AutoCamPos      oAutoCamPos;
        
        rvc_fi_tcl_AVMph3_Setting_CornerSonarSensLvl rCornerSonarSensLvl;
        rvc_fi_tcl_AVMph3_Setting_SonarSensLvl       rSonarSensLvl;
        rvc_fi_tcl_AVMph3_Setting_BuzzerSoundLvl     rBuzzerSoundLvl;
                
        oPriorityView.enType = (rvc_fi_tcl_e8_AVMph3_Setting_PrioView::tenType)  _oRxParam_Camera_08AVM.ePriority_View.enType;
        oPriorityWide.enType = (rvc_fi_tcl_e8_AVMph3_Setting_PrioWide::tenType)  _oRxParam_Camera_08AVM.ePriority_Wide.enType;
        oAutoCamPos.enType   = (rvc_fi_tcl_e8_AVMph3_Setting_AutoCamPos::tenType)_oRxParam_Camera_08AVM.eAuto_Cam_Position.enType;
        ETG_TRACE_USR4((" PriorityView..... : %u", ETG_ENUM(DISPVIDCTRL_E8_AVMPH3_SETTING_PRIOVIEW,oPriorityView.enType)));
        ETG_TRACE_USR4((" PriorityWide..... : %u", ETG_ENUM(DISPVIDCTRL_E8_AVMPH3_SETTING_PRIOWIDE,oPriorityWide.enType)));
        ETG_TRACE_USR4((" AutoCamPos....... : %u", ETG_ENUM(DISPVIDCTRL_E8_AVMPH3_SETTING_AUTOCAMPOS,oAutoCamPos.enType)));
        
        rCornerSonarSensLvl.bAvail         = (tBool)                                           _oRxParam_Corner_Sonar_Level.eCorner_Sonar_Sensitivity_Setting.enType;
        rCornerSonarSensLvl.e8Level.enType = (rvc_fi_tcl_e8_AVMph3_CornerSonarSensLvl::tenType)_oRxParam_Corner_Sonar_Level.eCorner_Sonar_Sensitivity_Level.enType;
        ETG_TRACE_USR4((" CornerSonarSensLvl: Avail=%u Level=%u", ETG_ENUM(DISPVIDCTRL_Bool,rCornerSonarSensLvl.bAvail), ETG_ENUM(DISPVIDCTRL_E8_AVMPH3_CORNERSONARSENSLVL,rCornerSonarSensLvl.e8Level.enType)));
        
        rBuzzerSoundLvl.bAvail             = (tBool)                                           _oRxParam_Sonar_Level.eSonar_Buzzer_Volume_Setting.enType;
        rBuzzerSoundLvl.e8Level.enType     = (rvc_fi_tcl_e8_AVMph3_BuzzerSoundLvl::tenType)    _oRxParam_Sonar_Level.eSonar_Buzzer_Volume_Level.enType;
        ETG_TRACE_USR4((" BuzzerSoundLvl... : Avail=%u Level=%u", ETG_ENUM(DISPVIDCTRL_Bool,rBuzzerSoundLvl.bAvail),     ETG_ENUM(DISPVIDCTRL_E8_AVMPH3_BUZZERSOUNDLVL,rBuzzerSoundLvl.e8Level.enType)));
        
        rSonarSensLvl.bAvail               = (tBool)                                           _oRxParam_Sonar_Level.eSonar_Sensitivity_Setting.enType;
        rSonarSensLvl.e8Level.enType       = (rvc_fi_tcl_e8_AVMph3_SonarSensLvl::tenType)      _oRxParam_Sonar_Level.eSonar_Sensitivity_Level.enType;
        ETG_TRACE_USR4((" SonarSensLvl..... : Avail=%u Level=%u", ETG_ENUM(DISPVIDCTRL_Bool,rSonarSensLvl.bAvail),       ETG_ENUM(DISPVIDCTRL_E8_AVMPH3_SONARSENSLVL,rSonarSensLvl.e8Level.enType)));
      
        ETG_TRACE_USR4((" SettingsOptions.. :"));
        DISPVIDCTRL_TY_VECTOR(rvc_fi_tcl_AVMph3_Setting_Option) arSettingsOptions;
        rvc_fi_tcl_AVMph3_Setting_Option                        oOption;
        #define APPEND_RVCFI_OPTION_STATE_OBJECT_TO_VECTOR(FiIdName,McanParamName)  \
        oOption.e8ItemId.enType    =  rvc_fi_tcl_e8_AVMph3_SettingItemId::FiIdName;  \
        oOption.e8ItemState.enType = (rvc_fi_tcl_e8_AVMph3_SettingOptionState::tenType)_oRxParam_Camera_08AVM.McanParamName.enType;  \
        arSettingsOptions.push_back(oOption)
        APPEND_RVCFI_OPTION_STATE_OBJECT_TO_VECTOR(FI_EN_VEHICLE_SPEED   , eVehicle_Speed   );
        APPEND_RVCFI_OPTION_STATE_OBJECT_TO_VECTOR(FI_EN_VIEW_LINE       , eView_Line       );
        APPEND_RVCFI_OPTION_STATE_OBJECT_TO_VECTOR(FI_EN_MASK_EMPHASIS   , eMask_Emphasis   );
        APPEND_RVCFI_OPTION_STATE_OBJECT_TO_VECTOR(FI_EN_SIDE_SONAR_DISP , eSide_Sonar_Disp );
        APPEND_RVCFI_OPTION_STATE_OBJECT_TO_VECTOR(FI_EN_ADJUST_TOPVIEW  , eAdjust_Topview  );
        APPEND_RVCFI_OPTION_STATE_OBJECT_TO_VECTOR(FI_EN_VOLUME_VOICE    , eVolume_Voice    );
        APPEND_RVCFI_OPTION_STATE_OBJECT_TO_VECTOR(FI_EN_SONAR_BUZZER    , eSonar_Buzzer    );
        APPEND_RVCFI_OPTION_STATE_OBJECT_TO_VECTOR(FI_EN_REAR_WIDE_VIEW  , eRear_Wide_View  );
        APPEND_RVCFI_OPTION_STATE_OBJECT_TO_VECTOR(FI_EN_SONAR_ON_OFF    , eSonar_ON_OFF    );
        APPEND_RVCFI_OPTION_STATE_OBJECT_TO_VECTOR(FI_EN_MOD_INTERRUPT   , eMOD_Interrupt   );
        APPEND_RVCFI_OPTION_STATE_OBJECT_TO_VECTOR(FI_EN_SONAR_INTERRUPT , eSonar_Interrupt );
        APPEND_RVCFI_OPTION_STATE_OBJECT_TO_VECTOR(FI_EN_MOD_FUNCTION    , eMOD_Function    );
        APPEND_RVCFI_OPTION_STATE_OBJECT_TO_VECTOR(FI_EN_MOD_NIGHT_USE   , eMOD_Night_Use   );
        APPEND_RVCFI_OPTION_STATE_OBJECT_TO_VECTOR(FI_EN_BCP_FUNCTION    , eBCP_Function    );
        APPEND_RVCFI_OPTION_STATE_OBJECT_TO_VECTOR(FI_EN_FRONT_SONAR_ONLY, eFront_Sonar_Only);        
        #undef APPEND_RVCFI_OPTION_STATE_OBJECT_TO_VECTOR
        for (tU32 u32Idx=0; u32Idx<arSettingsOptions.size(); ++u32Idx) {
            ETG_TRACE_USR4((" . [%u] Id=%u: State=%u", u32Idx, ETG_ENUM(DISPVIDCTRL_E8_AVMPH3_SETTINGITEMID, arSettingsOptions[u32Idx].e8ItemId.enType), ETG_ENUM(DISPVIDCTRL_E8_AVMPH3_SETTINGOPTIONSTATE, arSettingsOptions[u32Idx].e8ItemState.enType)));
        }

        (tVoid)_pServiceRvc->sendAVM3_Settings_DetailedStatus(oPriorityView,oPriorityWide,oAutoCamPos,rCornerSonarSensLvl,rSonarSensLvl,rBuzzerSoundLvl,arSettingsOptions);
    }
}

tVoid dispvidctrl_tclMCanClientAvm::vSendConfigurationInfoToServer(tVoid)
{
    if (_pServiceRvc) {
        tU8 u8UnitId     = _oRxParam_UnitConfiguration.u8Unit_ID;
        tU8 u8UnitId_VAR = DISPVIDCTRL_AVM_UNIT_ID_STR  (u8UnitId);
        tU8 u8UnitId_LHD = DISPVIDCTRL_AVM_UNIT_ID_LHRH (u8UnitId);
        tU8 u8UnitId_SON = DISPVIDCTRL_AVM_UNIT_ID_Sonar(u8UnitId);        
        ETG_TRACE_USR4( ("dispvidctrl_tclMCanClientAvm::vSendConfigurationInfoToServer() called: Unit_ID=0x%02X: Variant=%u LeftHandDrive=%u WithSonar=%u",
                         u8UnitId, ETG_ENUM(DISPVIDCTRL_E8_AVMPH3_VARIANT, u8UnitId_VAR), u8UnitId_LHD, u8UnitId_SON) );
    
        rvc_fi_tcl_e8_AVMph3_ConfigurationStatus oConfigStatus;
        rvc_fi_tcl_AVMph3_Unit_ID                oUnit_ID;
        rvc_fi_tcl_AVMph3_VersionInfo            oMsgSetVersion;

        oConfigStatus.enType = rvc_fi_tcl_e8_AVMph3_ConfigurationStatus::FI_EN_VALID;  // fixed ...

        oMsgSetVersion.u8Upper    = _oRxParam_UnitConfiguration.u8MsgVersHigh;
        oMsgSetVersion.u8Middle   = _oRxParam_UnitConfiguration.u8MsgVersMid;
        oMsgSetVersion.u8Lower    = _oRxParam_UnitConfiguration.u8MsgVersLow;

        oUnit_ID.u8Unit_ID        =                                        u8UnitId;
        oUnit_ID.e8Variant.enType = (rvc_fi_tcl_e8_AVMph3_Variant::tenType)u8UnitId_VAR;
        oUnit_ID.bLeftHandDrive   = (tBool)                                u8UnitId_LHD;
        oUnit_ID.bWithSonar       = (tBool)                                u8UnitId_SON;
        
        (tVoid)_pServiceRvc->sendAVM3_ConfigurationStatus(oConfigStatus, oUnit_ID, oMsgSetVersion);
    }
}

#define SETUP_FI_VERSION_INFO_OBJ(FiObjName,McanParamName) \
        rvc_fi_tcl_AVMph3_VersionInfo FiObjName;\
        FiObjName.u8Upper  = (tU8)_oRxParam_##McanParamName.uiVersion__Large_ .u32GetData();\
        FiObjName.u8Middle = (tU8)_oRxParam_##McanParamName.uiVersion__Middle_.u32GetData();\
        FiObjName.u8Lower  = (tU8)_oRxParam_##McanParamName.uiVersion__Small_ .u32GetData()
tVoid dispvidctrl_tclMCanClientAvm::vSendSoftwareVersionInfoToServer(tVoid)
{
    if (_pServiceRvc) {
        SETUP_FI_VERSION_INFO_OBJ(oSW_Version_AVM,   Software_Version);
        SETUP_FI_VERSION_INFO_OBJ(oSW_Version_Sonar, Sonar_Soft_Ver  );
        ETG_TRACE_USR4( ( "dispvidctrl_tclMCanClientAvm::vSendSoftwareVersionInfoToServer(): oSW_Version_AVM = %u.%u.%u",   oSW_Version_AVM.u8Upper,   oSW_Version_AVM.u8Middle,   oSW_Version_AVM.u8Lower) );
        ETG_TRACE_USR4( ( "dispvidctrl_tclMCanClientAvm::vSendSoftwareVersionInfoToServer(): oSW_Version_Sonar = %u.%u.%u", oSW_Version_Sonar.u8Upper, oSW_Version_Sonar.u8Middle, oSW_Version_Sonar.u8Lower) );
        (tVoid)_pServiceRvc->sendAVM3_Software_VersionStatus(oSW_Version_AVM, oSW_Version_Sonar);
    }
}

tVoid dispvidctrl_tclMCanClientAvm::vSendHardwareVersionInfoToServer(tVoid)
{
    if (_pServiceRvc) {
        SETUP_FI_VERSION_INFO_OBJ(oHW_Version_AVM,   Hardware_Version);
        SETUP_FI_VERSION_INFO_OBJ(oHW_Version_Sonar, Sonar_Hard_Ver  );
        ETG_TRACE_USR4( ( "dispvidctrl_tclMCanClientAvm::vSendHardwareVersionInfoToServer(): oHW_Version_AVM = %u.%u.%u",   oHW_Version_AVM.u8Upper,   oHW_Version_AVM.u8Middle,   oHW_Version_AVM.u8Lower) );
        ETG_TRACE_USR4( ( "dispvidctrl_tclMCanClientAvm::vSendHardwareVersionInfoToServer(): oHW_Version_Sonar = %u.%u.%u", oHW_Version_Sonar.u8Upper, oHW_Version_Sonar.u8Middle, oHW_Version_Sonar.u8Lower) );
        (tVoid)_pServiceRvc->sendAVM3_Hardware_VersionStatus(oHW_Version_AVM, oHW_Version_Sonar);
    }
}
#undef SETUP_FI_VERSION_INFO_OBJ

tVoid dispvidctrl_tclMCanClientAvm::vSendMcanCommErrorInfoToServer(tVoid)
{
    if (_pServiceRvc) {
        ETG_TRACE_USR4( ( "dispvidctrl_tclMCanClientAvm::vSendMcanCommErrorInfoToServer() called") );
        
        rvc_fi_tcl_AVMph3_MCAN_CommunicationErrors oCommErrors;
        
        // the MCAN message set spec lists each error parameter as one byte, whereas in the generated MCAN_FI classes,
        // each of these parameter bytes is represented as two sub-parameters, a 2-bit fault status plus a 6-bit fault counter
        // The following macro assembles the two subparameters into a single 1-byte parameter again:
        #define MAKE_MCAN_COMM_ERR_PARAM_BYTE(VarName,McanParamName)  \
           (tU8)( (((tU8)VarName.e##McanParamName##_Status.enType) << 6) | ((tU8)VarName.ui##McanParamName##_FaultCounter.u32GetData() & 0x3F) )
        oCommErrors.u8BusOff         = MAKE_MCAN_COMM_ERR_PARAM_BYTE( _oRxParam_MCAN_Communication_Error, BusOff                 );
        oCommErrors.u8TxCmfToMaster  = MAKE_MCAN_COMM_ERR_PARAM_BYTE( _oRxParam_MCAN_Communication_Error, Send_CMF_to_Master     );
        oCommErrors.u8RxCmfFromSonar = MAKE_MCAN_COMM_ERR_PARAM_BYTE( _oRxParam_MCAN_Communication_Error, Receive_CMF_From_Sonar );
        oCommErrors.u8TxMpdtToSonar  = MAKE_MCAN_COMM_ERR_PARAM_BYTE( _oRxParam_MCAN_Communication_Error, Send_MPDT_to_Sonar     );
        #undef MAKE_MCAN_COMM_ERR_PARAM_BYTE

        (tVoid)_pServiceRvc->sendAVM3_CommunicationErrorsStatus(oCommErrors);
    }
}


/////// methods for incoming CCA messages

tVoid dispvidctrl_tclMCanClientAvm::onAVM3_SetSwitchMStart(tU8 u8SwitchId)
{
    vSendSwitchInputToFsm(u8SwitchId);
}

tVoid dispvidctrl_tclMCanClientAvm::onAVM3_SetSonarBuzzerStatusMStart(tU8 u8BuzzerStatus)
{
    vFillAndSendMsg_AVM_Sonar_Buzzer_Set(u8BuzzerStatus);
}

tVoid dispvidctrl_tclMCanClientAvm::onAVM3_Settings_Primary_SendReqMStart(tU8 u8RequestType, tU8 u8AVM_Sonar, tBool bDetail_Setting, tBool bImage_Quality)
{
    if (rvc_fi_tcl_e8_AVMph3_RequestType::FI_EN_GET == u8RequestType) {
        vFillAndSendMsg_Camera_Primary_Setting_Get();
    } else {
        vFillAndSendMsg_Camera_Primary_Setting_Set(u8AVM_Sonar,bDetail_Setting,bImage_Quality);
    }
}

tVoid dispvidctrl_tclMCanClientAvm::onAVM3_Settings_Detailed_SendReqMStart(tU8 u8RequestType, DISPVIDCTRL_TY_VECTOR(tstSettingsItem) arChangedItems)
{
     if (rvc_fi_tcl_e8_AVMph3_RequestType::FI_EN_GET == u8RequestType) {
         vFillAndSendMsg_Camera_Setting_08AVM_Get();
     } else {
         vFillAndSendMsg_Camera_Setting_08AVM_Set(arChangedItems);
     }
}

tVoid dispvidctrl_tclMCanClientAvm::onAVM3_GetVersionInfoMStart(tU8 u8VersionType)
{
    switch (u8VersionType) {
        case rvc_fi_tcl_e8_AVMph3_VersionInfoType::FI_EN_SW_VERSION:
            vFillAndSendMsg_Software_Version_Get();
            break;
        case rvc_fi_tcl_e8_AVMph3_VersionInfoType::FI_EN_HW_VERSION:
            vFillAndSendMsg_Hardware_Version_Get();
            break;
        case rvc_fi_tcl_e8_AVMph3_VersionInfoType::FI_EN_HW_SW_VERSION:
            vFillAndSendMsg_Software_Version_Get();
            vFillAndSendMsg_Hardware_Version_Get();
            break;
        default:
            break;
    }
}

tVoid dispvidctrl_tclMCanClientAvm::onAVM3_GetCommunicationErrorsMStart(tVoid)
{
    vFillAndSendMsg_MCAN_Communication_Error_Get();
}

tVoid dispvidctrl_tclMCanClientAvm::onAVM3_ClearCommunicationErrorsMStart(tVoid)
{
    vFillAndSendMsg_MCAN_Communication_Error_Clear_Set();
}

tVoid dispvidctrl_tclMCanClientAvm::onAVM3_CameraStateRequest(tBool bReqState)
{
    if (TRUE == bReqState) {
        vSendSwitchInputToFsm(rvc_fi_tcl_e8_AVMph3_SwitchId::FI_EN_CAMERA);
    } else {
        vFillAndSendMsg_Direct_Camera_Off_Indication();
    }
}

tVoid dispvidctrl_tclMCanClientAvm::vHandleBciState(tU8 u8BciState, tBool bBciStateValid)
{
    // set default values: no button
    _u8BciSwitchId     = (tU8)rvc_fi_tcl_e8_AVMph3_SwitchId::FI_EN_NONE;
    _u8BciSwitchStatus = (tU8)rvc_fi_tcl_e8_AVMph3_SwitchStatus::FI_EN_NORMAL;
    // overwrite default values, depending on BCI state
    if (bBciStateValid)
    {
        switch (u8BciState)
        {
            case DISPVIDCTRL_AVM3_BCISTATE_ON:
                _u8BciSwitchId     = (tU8)rvc_fi_tcl_e8_AVMph3_SwitchId::FI_EN_BCI_IND_ON;
                break;
            case DISPVIDCTRL_AVM3_BCISTATE_TEMP_OFF:
                _u8BciSwitchId     = (tU8)rvc_fi_tcl_e8_AVMph3_SwitchId::FI_EN_BCI_IND_OFF;
                break;
            case DISPVIDCTRL_AVM3_BCISTATE_OFF:
            case DISPVIDCTRL_AVM3_BCISTATE_TEMP_FAIL:
            case DISPVIDCTRL_AVM3_BCISTATE_SYS_FAIL:
                _u8BciSwitchId     = (tU8)rvc_fi_tcl_e8_AVMph3_SwitchId::FI_EN_BCI_IND_OFF;
                _u8BciSwitchStatus = (tU8)rvc_fi_tcl_e8_AVMph3_SwitchStatus::FI_EN_MASK;
                break;
            default:
                break;
        }
    }
    vSendViewContentToServer(FALSE,FALSE);  // "FALSE,FALSE": send only the "core" CCA property which holds (amongst others) the states of the switches
}


tBool dispvidctrl_tclMCanClientAvm::bSetTimer_BciSwitchReset(OSAL_tMSecond msTimeout)
{
    tBool bSuccess = TRUE;
    if ( OSAL_C_INVALID_HANDLE != _hTimerHandle_BciSwitchReset ) {
       if ( OSAL_s32TimerSetTime( _hTimerHandle_BciSwitchReset, msTimeout, 0 ) != OSAL_OK ) {
           bSuccess = FALSE;
       }
    }
    return(bSuccess);
}

OSAL_tpfCallback dispvidctrl_tclMCanClientAvm::pfCallbackTimer_BciSwitchReset(tVoid* pArg)
{
    ETG_TRACE_USR4(("dispvidctrl_tclMCanClientAvm:pfCallbackTimer_BciSwitchReset() called"));

    dispvidctrl_tclMCanClientAvm* po_tclClient_Avm = (dispvidctrl_tclMCanClientAvm*)pArg;
    if (po_tclClient_Avm && po_tclClient_Avm->_cpoMain && po_tclClient_Avm->_cpoMain->theServer()) {
        po_tclClient_Avm->_cpoMain->theServer()->vPostMsgAvm3SwitchInput("I_dispvidctrl_tclMCanClientAvmFsm", DISPVIDCTRL_AVM3_RESET_BCI_TEMP_SW);
    }
    return 0;
}

tVoid dispvidctrl_tclMCanClientAvm::vSendBciSwitch(tU32 u32SwitchId)
{
    ETG_TRACE_USR4(("dispvidctrl_tclMCanClientAvm:vSendBciSwitch() called, switchId=0x%04X", u32SwitchId));
    
    I_dispvidctrl_tclClientVcan* pVcan = dynamic_cast<I_dispvidctrl_tclClientVcan*>(_cpoMain->getHandler("I_dispvidctrl_tclClientVcan"));
    if (pVcan) {
        tU8 u8SigVal;
        if (DISPVIDCTRL_AVM3_RESET_BCI_TEMP_SW == u32SwitchId) {
            u8SigVal = DISPVIDCTRL_AVM3_DRVASSISTSW_SIGVAL_NO_OP;
        } else {
            u8SigVal = DISPVIDCTRL_AVM3_DRVASSISTSW_SIGVAL_BCI_TEMP_SW;
            bSetTimer_BciSwitchReset(DISPVIDCTRL_AVM3_DRVASSISTSW_RESET_TIME_MS);
        }
        ETG_TRACE_USR4(("dispvidctrl_tclMCanClientAvm:vSendBciSwitch(): sending value 0x%02X to CAN", u8SigVal));
        pVcan->vWriteDriver_Assistance_SW_flag(u8SigVal);
    }
}

// dispvidctrl_tclMCanClientAvm::ClassImplementation: user specific code end
//EOF
