/**
  * @swcomponent   Life Cycle Management
  * @{
  * @file          Idispvidctrl_ClientAvm.h
  * @PROJECT:      CMD project
  * @SW-COMPONENT: dispvidctrl
  * @Template:     IMCanClient.h.tpl
  * ----------------------------------------------------------------------------
  *
  * @brief         generated file
  *                Csm client interface
  *
  *                Do here client specific implementation
  *                Changes possible only inside tags
  *
  *                //......................: user specific code start 
  *                //......................: user specific code end
  *
  * ----------------------------------------------------------------------------
  * @copyright     (c) 2018 Robert Bosch GmbH.
  *                The reproduction, distribution and utilization of this file as well as the
  *                communication of its contents to others without express authorization is prohibited.
  *                Offenders will be held liable for the payment of damages.
  *                All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#ifndef _I_AVMMCAN_CLIENT_H_
#define _I_AVMMCAN_CLIENT_H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

//include base class
#include "dispvidctrl_AppMain.h"

#include "Idispvidctrl_ClientAvmAdaptor.h"


class I_dispvidctrl_tclMCanClientAvm : public dispvidctrl_tclBaseIf
{
public:
   typedef enum {
       eOnChange = 0,
       eForce    = 1,
       eIgnore   = 2
   } ESendMode;
   
   I_dispvidctrl_tclMCanClientAvm(dispvidctrl_tclAppMain* poMainAppl): dispvidctrl_tclBaseIf(poMainAppl) {;}
   virtual ~I_dispvidctrl_tclMCanClientAvm() {;}

   virtual const tChar* getIfName() const { return "I_dispvidctrl_tclMCanClientAvm"; };

   virtual tVoid vConnectionUp() = 0;
   
   virtual tVoid addMsgToSequenceWoBlocking(tU16 u16MsgId, tU8  u8MsgOpcode) = 0;
   virtual tVoid addMsgToSequence(tU16 u16MsgId, tU8  u8MsgOpcode) = 0;   
   virtual tVoid clearMsgSequences() = 0;   
   
    virtual tVoid setSoftware_VersionGetOutUpdate(tVoid) = 0;

    virtual tVoid setHardware_VersionGetOutUpdate(tVoid) = 0;

    virtual tVoid setSW_SignalIndicationOutSW_Status(const tcl_ITM_Camera_System_SW_Status& oSW_Status, ESendMode eSendMode = eOnChange) = 0;
    virtual const tcl_ITM_Camera_System_SW_Status& getSW_SignalIndicationOutSW_Status() = 0;

    virtual tVoid setSW_SignalIndicationOutDisp_Status(const tcl_ITM_Camera_System_Disp_Status& oDisp_Status, ESendMode eSendMode = eOnChange) = 0;
    virtual const tcl_ITM_Camera_System_Disp_Status& getSW_SignalIndicationOutDisp_Status() = 0;

    virtual tBool sendSW_SignalIndicationOut(const tcl_ITM_Camera_System_SW_Status& oSW_Status, const tcl_ITM_Camera_System_Disp_Status& oDisp_Status) = 0;

    virtual tVoid setView_Change_08AVMStatusOutInvalid_Parameter(const tcl_ITM_Camera_System_Invalid_Parameter& oInvalid_Parameter, ESendMode eSendMode = eOnChange) = 0;
    virtual const tcl_ITM_Camera_System_Invalid_Parameter& getView_Change_08AVMStatusOutInvalid_Parameter() = 0;

    virtual tVoid setView_Change_08AVMStatusOutDisp_Status(const tcl_ITM_Camera_System_Disp_Status& oDisp_Status, ESendMode eSendMode = eOnChange) = 0;
    virtual const tcl_ITM_Camera_System_Disp_Status& getView_Change_08AVMStatusOutDisp_Status() = 0;

    virtual tVoid setView_Change_08AVMStatusOutView_Pattern(const tcl_ITM_Camera_System_View_Pattern& oView_Pattern, ESendMode eSendMode = eOnChange) = 0;
    virtual const tcl_ITM_Camera_System_View_Pattern& getView_Change_08AVMStatusOutView_Pattern() = 0;

    virtual tVoid setView_Change_08AVMStatusOutCaution(const tcl_ITM_Camera_System_Caution& oCaution, ESendMode eSendMode = eOnChange) = 0;
    virtual const tcl_ITM_Camera_System_Caution& getView_Change_08AVMStatusOutCaution() = 0;

    virtual tVoid setView_Change_08AVMStatusOutDisp_SW_08AVM(const tcl_ITM_Camera_System_Disp_SW_08AVM& oDisp_SW_08AVM, ESendMode eSendMode = eOnChange) = 0;
    virtual const tcl_ITM_Camera_System_Disp_SW_08AVM& getView_Change_08AVMStatusOutDisp_SW_08AVM() = 0;

    virtual tVoid setView_Change_08AVMStatusOutIcon(const tcl_ITM_Camera_System_Icon& oIcon, ESendMode eSendMode = eOnChange) = 0;
    virtual const tcl_ITM_Camera_System_Icon& getView_Change_08AVMStatusOutIcon() = 0;

    virtual tVoid setView_Change_08AVMStatusOutBuzzer_Status(const tcl_ITM_Camera_System_Buzzer_Status& oBuzzer_Status, ESendMode eSendMode = eOnChange) = 0;
    virtual const tcl_ITM_Camera_System_Buzzer_Status& getView_Change_08AVMStatusOutBuzzer_Status() = 0;

    virtual tBool sendView_Change_08AVMStatusOut(const tcl_ITM_Camera_System_Invalid_Parameter& oInvalid_Parameter, const tcl_ITM_Camera_System_Disp_Status& oDisp_Status, const tcl_ITM_Camera_System_View_Pattern& oView_Pattern, const tcl_ITM_Camera_System_Caution& oCaution, const tcl_ITM_Camera_System_Disp_SW_08AVM& oDisp_SW_08AVM, const tcl_ITM_Camera_System_Icon& oIcon, const tcl_ITM_Camera_System_Buzzer_Status& oBuzzer_Status) = 0;

    virtual tVoid setDirect_Camera_OFFIndicationOutUpdate(tVoid) = 0;

    virtual tVoid setAVM_Sonar_BuzzerSetOutBuzzer_Status(const tcl_ITM_Camera_System_Buzzer_Status& oBuzzer_Status, ESendMode eSendMode = eOnChange) = 0;
    virtual const tcl_ITM_Camera_System_Buzzer_Status& getAVM_Sonar_BuzzerSetOutBuzzer_Status() = 0;

    virtual tBool sendAVM_Sonar_BuzzerSetOut(const tcl_ITM_Camera_System_Buzzer_Status& oBuzzer_Status) = 0;

    virtual tVoid setCamera_Setting_08AVMSetOutCamera_08AVM(const tcl_ITM_Camera_System_Camera_08AVM& oCamera_08AVM, ESendMode eSendMode = eOnChange) = 0;
    virtual const tcl_ITM_Camera_System_Camera_08AVM& getCamera_Setting_08AVMSetOutCamera_08AVM() = 0;

    virtual tVoid setCamera_Setting_08AVMSetOutCorner_Sonar_Level(const tcl_ITM_Camera_System_Corner_Sonar_Level& oCorner_Sonar_Level, ESendMode eSendMode = eOnChange) = 0;
    virtual const tcl_ITM_Camera_System_Corner_Sonar_Level& getCamera_Setting_08AVMSetOutCorner_Sonar_Level() = 0;

    virtual tVoid setCamera_Setting_08AVMSetOutSonar_Level(const tcl_ITM_Camera_System_Sonar_Level& oSonar_Level, ESendMode eSendMode = eOnChange) = 0;
    virtual const tcl_ITM_Camera_System_Sonar_Level& getCamera_Setting_08AVMSetOutSonar_Level() = 0;

    virtual tBool sendCamera_Setting_08AVMSetOut(const tcl_ITM_Camera_System_Camera_08AVM& oCamera_08AVM, const tcl_ITM_Camera_System_Corner_Sonar_Level& oCorner_Sonar_Level, const tcl_ITM_Camera_System_Sonar_Level& oSonar_Level) = 0;

    virtual tVoid setCamera_Setting_08AVMGetOutUpdate(tVoid) = 0;

    virtual tVoid setCamera_Primary_SettingSetOutPrimary_Setting(const tcl_ITM_Camera_System_Primary_Setting& oPrimary_Setting, ESendMode eSendMode = eOnChange) = 0;
    virtual const tcl_ITM_Camera_System_Primary_Setting& getCamera_Primary_SettingSetOutPrimary_Setting() = 0;

    virtual tBool sendCamera_Primary_SettingSetOut(const tcl_ITM_Camera_System_Primary_Setting& oPrimary_Setting) = 0;

    virtual tVoid setCamera_Primary_SettingGetOutUpdate(tVoid) = 0;

    virtual tVoid setMCAN_Communication_ErrorGetOutUpdate(tVoid) = 0;

    virtual tVoid setMCAN_Communication_Error_ClearSetOutUpdate(tVoid) = 0;

    virtual tVoid setCamera_Diag_SensorSetOutUpdate(tVoid) = 0;

    virtual tVoid setCamera_Diag_SensorGetOutUpdate(tVoid) = 0;


   // I_dispvidctrl_tclMCanClientAvm::ClassImplementation: user specific code start
   typedef enum {
       eSetUnitConfig,
       eNormalBeep,
       eErrorBeep,
       eSendSwitchToAvm,
       eSendBciSwitch,
       
       eVisOn_BlankOn,
       eVisOn_BlankOff,
       eVisChg_BlankOn,
       eVisChg_BlankOff,
       eVisOff_BlankOn,
       eVisOff_BlankOff,
       
       eHandleCommLost,
       eHandleCommEstablished,
   } tenFsmOutputEvent;

   typedef enum {
       eHmiReqShowRvc,
       eHmiReqViewSetup,
       eHmiReqDirectCamOff,
       eDiagReqShowVideo,
       eServiceReqShowVideo,
   } tenControlOutputEvent;
   
   typedef enum {
       eIndBciState,
   } tenDataEvent;
   
   typedef struct {
       tU8 u8Id;
       tU8 u8State;
   } tstSettingsItem;

   typedef struct {
       tU8 u8Unit_ID;
       tU8 u8MsgVersHigh;
       tU8 u8MsgVersMid;
       tU8 u8MsgVersLow;
   } tstUnitConfiguration;
   // some helper macros to disassemble the value u8Unit_ID:
   #define DISPVIDCTRL_AVM_UNIT_ID_STR(x)       (tU8)((x & 0xC0) >> 6)
   #define DISPVIDCTRL_AVM_UNIT_ID_Gear(x)      (tU8)((x & 0x20) >> 5) // currently not used
   #define DISPVIDCTRL_AVM_UNIT_ID_SIDEVIEW(x)  (tU8)((x & 0x10) >> 4) // currently not used
   #define DISPVIDCTRL_AVM_UNIT_ID_LHRH(x)      (tU8)((x & 0x08) >> 3)
   #define DISPVIDCTRL_AVM_UNIT_ID_Sonar(x)     (tU8)((x & 0x04) >> 2)
   #define DISPVIDCTRL_AVM_UNIT_ID_RearWide(x)  (tU8)((x & 0x02) >> 1) // currently not used
   #define DISPVIDCTRL_AVM_UNIT_ID_FrontWide(x) (tU8)((x & 0x01) >> 0) // currently not used
    
   
   virtual tBool bIsAvmPhase3Configured(tVoid) = 0;
   virtual tVoid vHandleFsmOutput(tenFsmOutputEvent eEvent, const void* pvData) = 0;
   virtual tVoid vHandleControlOutput(tenControlOutputEvent eEvent, tU32 u32Data=0) = 0;
   virtual tVoid vHandleDataEvent(tenDataEvent eEvent, tU32 u32Data1=0, tU32 u32Data2=0) = 0;
   
   virtual tVoid onAVM3_SetSwitchMStart(tU8 u8SwitchId) = 0;
   virtual tVoid onAVM3_SetSonarBuzzerStatusMStart(tU8 u8BuzzerStatus) = 0;
   virtual tVoid onAVM3_Settings_Primary_SendReqMStart(tU8 u8RequestType, tU8 u8AVM_Sonar, tBool bDetail_Setting, tBool bImage_Quality) = 0;
   virtual tVoid onAVM3_Settings_Detailed_SendReqMStart(tU8 u8RequestType, std::vector<tstSettingsItem, std::allocator<tstSettingsItem> > arChangedItems) = 0;
   virtual tVoid onAVM3_GetVersionInfoMStart(tU8 u8VersionType) = 0;
   virtual tVoid onAVM3_GetCommunicationErrorsMStart(tVoid) = 0;
   virtual tVoid onAVM3_ClearCommunicationErrorsMStart(tVoid) = 0;
   virtual tVoid onAVM3_CameraStateRequest(tBool) = 0;
   
   #define DISPVIDCTRL_AVM3_RESET_BCI_TEMP_SW   0xBC00  // used as switch ID in the timer-controlled reset of the BCI on/off switch signal on VCAN

   // I_dispvidctrl_tclMCanClientAvm::ClassImplementation: user specific code end
};

#endif // _I_AVMCAN_CLIENT_H_
