/**
  * @swcomponent   Life Cycle Management
  * @{
  * @file          dispvidctrl_ClientDimming_trace.cpp
  * @PROJECT:      CMD project
  * @SW-COMPONENT: dispvidctrl
  * @Template:     client_trace.cpp.tpl
  * ----------------------------------------------------------------------------
  *
  * @brief         generated file
  *                application trace interface
  *
  *                Do here client specific implementation
  *                Changes possible only inside tags
  *         
  *                //......................: user specific code start 
  *                //......................: user specific code end
  *
  * ----------------------------------------------------------------------------
  * @copyright     (c) 2018 Robert Bosch GmbH.
  *                The reproduction, distribution and utilization of this file as well as the
  *                communication of its contents to others without express authorization is prohibited.
  *                Offenders will be held liable for the payment of damages.
  *                All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

#include "dispvidctrl_ClientDimming.h"

#include "dispvidctrl_AppMain_Trace.h"


// TR_CLASS_DISPVIDCTRL_CLIENT_DIMMING_traceInclude: user specific code start

#include "dispvidctrl_ServiceDimmingIf.h"
#include "dispvidctrl_ClientVcan.h"
#include "I_dispvidctrl_tclConfigMgr.h"

#ifdef VARIANT_S_FTR_ENABLE_AIVI_NPIVI
#include "dispvidctrl_tclSecondDisp.h"
#endif
// TR_CLASS_DISPVIDCTRL_CLIENT_DIMMING_traceInclude: user specific code end


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DISPVIDCTRL_CLIENT_DIMMING
#include "trcGenProj/Header/dispvidctrl_ClientDimming_trace.cpp.trc.h"
#endif

tVoid dispvidctrl_tclClientDimming::vHandleTraceMessage(const tUChar* puchData) {
    tU32 u32MsgCode = (puchData[1]<<8) | puchData[2];
    
    ETG_TRACE_USR1(("dispvidctrl_tclClientDimming::vHandleTraceMessage(): process command: %d.", u32MsgCode));
    
    switch (u32MsgCode) {

    case DISPVIDCTRL_DISPVIDCTRL_CMDDIMMING_COMPONENT_STATUS:
        {
            // 
            tU32 param1 = ((tU32)puchData[3]<<24) | ((tU32)puchData[4]<<16) | ((tU32)puchData[5] << 8) | (tU32)puchData[6];
            tU8 param2 = puchData[7];
    

            // dispvidctrl_DISPVIDCTRL_CMDCOMPONENT_STATUS: user specific code start
            // dispvidctrl_DISPVIDCTRL_CMDCOMPONENT_STATUS: user specific code end
            onCOMPONENT_STATUS((::dimming_inc_fi::EApplicationStatus)param1, param2);
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_CMDDIMMING_REJECT:
        {
            // 
            tU32 param1 = ((tU32)puchData[3]<<24) | ((tU32)puchData[4]<<16) | ((tU32)puchData[5] << 8) | (tU32)puchData[6];
            tU8 param2 = puchData[7];
    

            // dispvidctrl_DISPVIDCTRL_CMDREJECT: user specific code start
            // dispvidctrl_DISPVIDCTRL_CMDREJECT: user specific code end
            onREJECT((::dimming_inc_fi::ERejectReason)param1, param2);
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_CMDDISPLAY_REQ:
        {
            // 
            tU32 param1 = ((tU32)puchData[3]<<24) | ((tU32)puchData[4]<<16) | ((tU32)puchData[5] << 8) | (tU32)puchData[6];
    

            // dispvidctrl_DISPVIDCTRL_CMDDISPLAY_REQ: user specific code start
            // dispvidctrl_DISPVIDCTRL_CMDDISPLAY_REQ: user specific code end
            onDISPLAY_REQ((::dimming_inc_fi::EDisplayRequest)param1);
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_CMDDISPLAY_READY:
        {
            // 
            tU32 param1 = ((tU32)puchData[3]<<24) | ((tU32)puchData[4]<<16) | ((tU32)puchData[5] << 8) | (tU32)puchData[6];
    

            // dispvidctrl_DISPVIDCTRL_CMDDISPLAY_READY: user specific code start
            // dispvidctrl_DISPVIDCTRL_CMDDISPLAY_READY: user specific code end
            onDISPLAY_READY((::dimming_inc_fi::EDisplayReady)param1);
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_CMDDISP_SET_BRIGHTNESS_LEVEL:
        {
            // 
            tU8 param1 = puchData[3];
            tU8 param2 = puchData[4];
    

            // dispvidctrl_DISPVIDCTRL_CMDDISP_SET_BRIGHTNESS_LEVEL: user specific code start
            // dispvidctrl_DISPVIDCTRL_CMDDISP_SET_BRIGHTNESS_LEVEL: user specific code end
            onDISP_SET_BRIGHTNESS_LEVEL(param1, param2);
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_CMDDISP_SET_DIMMING:
        {
            // 
            tU32 param1 = ((tU32)puchData[3]<<24) | ((tU32)puchData[4]<<16) | ((tU32)puchData[5] << 8) | (tU32)puchData[6];
            tU8 param2 = puchData[7];
    

            // dispvidctrl_DISPVIDCTRL_CMDDISP_SET_DIMMING: user specific code start
            // dispvidctrl_DISPVIDCTRL_CMDDISP_SET_DIMMING: user specific code end
            onDISP_SET_DIMMING(param1, param2);
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_CMDINFO_SET_DIMMINGMODE_CONFIG:
        {
            // 
            tU32 param1 = ((tU32)puchData[3]<<24) | ((tU32)puchData[4]<<16) | ((tU32)puchData[5] << 8) | (tU32)puchData[6];
    

            // dispvidctrl_DISPVIDCTRL_CMDINFO_SET_DIMMINGMODE_CONFIG: user specific code start
            // dispvidctrl_DISPVIDCTRL_CMDINFO_SET_DIMMINGMODE_CONFIG: user specific code end
            onINFO_SET_DIMMINGMODE_CONFIG((::dimming_inc_fi::EDimmingMode)param1);
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_CMDINFO_GET_DIMMINGMODE_STATE:
        {
            // 
            tU32 param1 = ((tU32)puchData[3]<<24) | ((tU32)puchData[4]<<16) | ((tU32)puchData[5] << 8) | (tU32)puchData[6];
            tU8 param2 = puchData[7];
    

            // dispvidctrl_DISPVIDCTRL_CMDINFO_GET_DIMMINGMODE_STATE: user specific code start
            // dispvidctrl_DISPVIDCTRL_CMDINFO_GET_DIMMINGMODE_STATE: user specific code end
            onINFO_GET_DIMMINGMODE_STATE((::dimming_inc_fi::EDimmingModeStatus)param1, param2);
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_CMDDIAG_DISP_READ_BRIGHT_VAL:
        {
            // 
            tU8 param1 = puchData[3];
    

            // dispvidctrl_DISPVIDCTRL_CMDDIAG_DISP_READ_BRIGHT_VAL: user specific code start
            // dispvidctrl_DISPVIDCTRL_CMDDIAG_DISP_READ_BRIGHT_VAL: user specific code end
            onDIAG_DISP_READ_BRIGHT_VAL(param1);
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_CMDDIAG_KEYB_READ_BRIGHT_VAL:
        {
            // 
            tU8 param1 = puchData[3];
    

            // dispvidctrl_DISPVIDCTRL_CMDDIAG_KEYB_READ_BRIGHT_VAL: user specific code start
            // dispvidctrl_DISPVIDCTRL_CMDDIAG_KEYB_READ_BRIGHT_VAL: user specific code end
            onDIAG_KEYB_READ_BRIGHT_VAL(param1);
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_CMDDIAG_KEYB_SET_DIMMING:
        {
            // 
            tU8 param1 = puchData[3];
    

            // dispvidctrl_DISPVIDCTRL_CMDDIAG_KEYB_SET_DIMMING: user specific code start
            // dispvidctrl_DISPVIDCTRL_CMDDIAG_KEYB_SET_DIMMING: user specific code end
            onDIAG_KEYB_SET_DIMMING(param1);
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_CMDDIAG_SESSION:
        {
            // 
            tU32 param1 = ((tU32)puchData[3]<<24) | ((tU32)puchData[4]<<16) | ((tU32)puchData[5] << 8) | (tU32)puchData[6];
    

            // dispvidctrl_DISPVIDCTRL_CMDDIAG_SESSION: user specific code start
            // dispvidctrl_DISPVIDCTRL_CMDDIAG_SESSION: user specific code end
            onDIAG_SESSION((::dimming_inc_fi::ESessionType)param1);
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_CMDDIAG_READ_BRIGHTNESS_VAL:
        {
            // 
            tU32 param1 = ((tU32)puchData[3]<<24) | ((tU32)puchData[4]<<16) | ((tU32)puchData[5] << 8) | (tU32)puchData[6];
            tU16 param2 = (((tU16)puchData[7] << 8) | (tU16)puchData[8]);
    

            // dispvidctrl_DISPVIDCTRL_CMDDIAG_READ_BRIGHTNESS_VAL: user specific code start
            // dispvidctrl_DISPVIDCTRL_CMDDIAG_READ_BRIGHTNESS_VAL: user specific code end
            onDIAG_READ_BRIGHTNESS_VAL((::dimming_inc_fi::EDeviceType)param1, param2);
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_CMDDIAG_SET_BRIGHTNESS_VAL:
        {
            // 
            tU32 param1 = ((tU32)puchData[3]<<24) | ((tU32)puchData[4]<<16) | ((tU32)puchData[5] << 8) | (tU32)puchData[6];
            tU16 param2 = (((tU16)puchData[7] << 8) | (tU16)puchData[8]);
    

            // dispvidctrl_DISPVIDCTRL_CMDDIAG_SET_BRIGHTNESS_VAL: user specific code start
            // dispvidctrl_DISPVIDCTRL_CMDDIAG_SET_BRIGHTNESS_VAL: user specific code end
            onDIAG_SET_BRIGHTNESS_VAL((::dimming_inc_fi::EDeviceType)param1, param2);
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_CMDGET_DIMMING_INFO_PRJ:
        {
            // 
            tU32 param1 = ((tU32)puchData[3]<<24) | ((tU32)puchData[4]<<16) | ((tU32)puchData[5] << 8) | (tU32)puchData[6];
    

            // dispvidctrl_DISPVIDCTRL_CMDGET_DIMMING_INFO_PRJ: user specific code start
            // dispvidctrl_DISPVIDCTRL_CMDGET_DIMMING_INFO_PRJ: user specific code end
            onGET_DIMMING_INFO_PRJ(param1);
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_CMDSECOND_DISP_GET_HW_VERSION:
        {
            // 
            tU32 param1 = ((tU32)puchData[3]<<24) | ((tU32)puchData[4]<<16) | ((tU32)puchData[5] << 8) | (tU32)puchData[6];
    

            // dispvidctrl_DISPVIDCTRL_CMDSECOND_DISP_GET_HW_VERSION: user specific code start
	#ifdef VARIANT_S_FTR_ENABLE_AIVI_NPIVI //PIVI Second Screen Display
            if(_poSecondDispIfRef != NULL)
            {
            	_poSecondDispIfRef->requestV850_HWVersionInfo();
            }
	#endif


            // dispvidctrl_DISPVIDCTRL_CMDSECOND_DISP_GET_HW_VERSION: user specific code end
						/* ENABLE TO BELOW FUNCTION TO SEND DATA FROM TTfis TO HMI */
         //   onSECOND_DISP_GET_HW_VERSION(param1);
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_CMDSECOND_DISP_GET_SW_VERSION:
        {
            // 
            tU32 param1 = ((tU32)puchData[3]<<24) | ((tU32)puchData[4]<<16) | ((tU32)puchData[5] << 8) | (tU32)puchData[6];
    

            // dispvidctrl_DISPVIDCTRL_CMDSECOND_DISP_GET_SW_VERSION: user specific code start
		#ifdef VARIANT_S_FTR_ENABLE_AIVI_NPIVI //PIVI Second Screen Display
				if(_poSecondDispIfRef != NULL)
				{
					_poSecondDispIfRef->requestV850_SWVersionInfo();
				}
		#endif

          
            // dispvidctrl_DISPVIDCTRL_CMDSECOND_DISP_GET_SW_VERSION: user specific code end
		//CID: 90910
		//commenting the below function as this is a dead code and also the func is aivi specific. 
		//onSECOND_DISP_GET_SW_VERSION(param1);
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_CMDSECOND_DISP_SET_DISPLAY_PARAMETERS:
        {
            // 
            tU16 param1 = (((tU16)puchData[3] << 8) | (tU16)puchData[4]);
            tU16 param2 = (((tU16)puchData[5] << 8) | (tU16)puchData[6]);
            tU8 param3 = puchData[7];
    

            // dispvidctrl_DISPVIDCTRL_CMDSECOND_DISP_SET_DISPLAY_PARAMETERS: user specific code start
		#ifdef VARIANT_S_FTR_ENABLE_AIVI_NPIVI //PIVI Second Screen Display
				if(_poSecondDispIfRef != NULL)
				{
					_poSecondDispIfRef->requestV850_setDisplayParam(param1, param2);
				}
		#endif

            // dispvidctrl_DISPVIDCTRL_CMDSECOND_DISP_SET_DISPLAY_PARAMETERS: user specific code end
						/* ENABLE TO BELOW FUNCTION TO SEND DATA FROM TTfis TO HMI */
         //   onSECOND_DISP_SET_DISPLAY_PARAMETERS(param1, param2, param3);
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_CMDSECOND_DISP_GET_DIMMING_PARAMETERS:
        {
            // 
            tU8 param1 = puchData[3];
            tU8 param2 = puchData[4];
            tU8 param3 = puchData[5];
            tU8 param4 = puchData[6];
            tU8 param5 = puchData[7];
            tU16 param6 = (((tU16)puchData[8] << 8) | (tU16)puchData[9]);
    

            // dispvidctrl_DISPVIDCTRL_CMDSECOND_DISP_GET_DIMMING_PARAMETERS: user specific code start
		#ifdef VARIANT_S_FTR_ENABLE_AIVI_NPIVI //PIVI Second Screen Display
				if(_poSecondDispIfRef != NULL)
				{
					_poSecondDispIfRef->requestV850_AllDisplayParam();
				}
		#endif

            // if (this)   // a way to say "if(1)" without upsetting lint (hopefully) ;-), so that we can ...
                // break;  // ... suppress the call below as it directly sends data from ttfis to hmi
				
            // dispvidctrl_DISPVIDCTRL_CMDSECOND_DISP_GET_DIMMING_PARAMETERS: user specific code end
						/* ENABLE TO BELOW FUNCTION TO SEND DATA FROM TTfis TO HMI */
        //    onSECOND_DISP_GET_DIMMING_PARAMETERS(param1, param2, param3, param4, param5, param6);
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_CMDSEND_POWERMODE_TO_V850:
        {
            // 
            tU8 param1 = puchData[3];
            tU8 param2 = puchData[4];
    

            // dispvidctrl_DISPVIDCTRL_CMDSEND_POWERMODE_TO_V850: user specific code start
            // dispvidctrl_DISPVIDCTRL_CMDSEND_POWERMODE_TO_V850: user specific code end
            onSEND_POWERMODE_TO_V850(param1, param2);
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_CMDSECOND_DISP_GET_SELF_DIAGNOSTIC_RESULT:
        {
            // 
            tU16 param1 = (((tU16)puchData[3] << 8) | (tU16)puchData[4]);
    

            // dispvidctrl_DISPVIDCTRL_CMDSECOND_DISP_GET_SELF_DIAGNOSTIC_RESULT: user specific code start
		#ifdef VARIANT_S_FTR_ENABLE_AIVI_NPIVI //PIVI Second Screen Display
				if(_poSecondDispIfRef != NULL)
				{
					_poSecondDispIfRef->requestV850_SelfDiagResult();
				}
		#endif

            // dispvidctrl_DISPVIDCTRL_CMDSECOND_DISP_GET_SELF_DIAGNOSTIC_RESULT: user specific code end
			/* ENABLE TO BELOW FUNCTION TO SEND DATA FROM TTfis TO HMI */
//            onSECOND_DISP_GET_SELF_DIAGNOSTIC_RESULT(param1);
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_CMD_C_DIAG_SESSION:
        {
            // Send the INC message SCC_DIMMING_C_DIAG_SESSION to V850.
            tU32 param1 = ((tU32)puchData[3]<<24) | ((tU32)puchData[4]<<16) | ((tU32)puchData[5] << 8) | (tU32)puchData[6];
    

            // dispvidctrl_DISPVIDCTRL_CMD_C_DIAG_SESSION: user specific code start
            if (TRUE == sendDIAG_SESSION((::dimming_inc_fi::ESessionType)param1))
            {
                ETG_TRACE_FATAL(("dispvidctrl_tclClientDimming::vHandleTraceMessage(): DispVidCtrl_DISPVIDCTRL_CMD_C_DIAG_SESSION %u successful.", ETG_ENUM(DISPVIDCTRL_DIMMING_SESSIONTYPE, param1) ));
            }
            else
            {
                ETG_TRACE_FATAL(("dispvidctrl_tclClientDimming::vHandleTraceMessage(): DispVidCtrl_DISPVIDCTRL_CMD_C_DIAG_SESSION %u failed!", ETG_ENUM(DISPVIDCTRL_DIMMING_SESSIONTYPE, param1) ));
            }
            // dispvidctrl_DISPVIDCTRL_CMD_C_DIAG_SESSION: user specific code end
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_CMD_C_DIAG_READ_BRIGHTNESS_VAL:
        {
            // Send the INC message SCC_DIMMING_C_DIAG_READ_BRIGHTNESS_VAL to V850.
            tU32 param1 = ((tU32)puchData[3]<<24) | ((tU32)puchData[4]<<16) | ((tU32)puchData[5] << 8) | (tU32)puchData[6];
    

            // dispvidctrl_DISPVIDCTRL_CMD_C_DIAG_READ_BRIGHTNESS_VAL: user specific code start
            if (TRUE == sendDIAG_READ_BRIGHTNESS_VAL((::dimming_inc_fi::EDeviceType)param1))
            {
                ETG_TRACE_FATAL(("dispvidctrl_tclClientDimming::vHandleTraceMessage(): DispVidCtrl_DISPVIDCTRL_CMD_C_DIAG_READ_BRIGHTNESS_VAL %u successful.", ETG_ENUM(DISPVIDCTRL_DIMMING_DEVICETYPE, param1) ));
            }
            else
            {
                ETG_TRACE_FATAL(("dispvidctrl_tclClientDimming::vHandleTraceMessage(): DispVidCtrl_DISPVIDCTRL_CMD_C_DIAG_READ_BRIGHTNESS_VAL %u failed!", ETG_ENUM(DISPVIDCTRL_DIMMING_DEVICETYPE, param1) ));
            }
            // dispvidctrl_DISPVIDCTRL_CMD_C_DIAG_READ_BRIGHTNESS_VAL: user specific code end
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_CMD_C_DIAG_SET_BRIGHTNESS_VAL:
        {
            // Send the INC message SCC_DIMMING_C_DIAG_SET_BRIGHTNESS_VAL to V850.
            tU32 param1 = ((tU32)puchData[3]<<24) | ((tU32)puchData[4]<<16) | ((tU32)puchData[5] << 8) | (tU32)puchData[6];
            tU16 param2 = (((tU16)puchData[7] << 8) | (tU16)puchData[8]);
    

            // dispvidctrl_DISPVIDCTRL_CMD_C_DIAG_SET_BRIGHTNESS_VAL: user specific code start
            if (TRUE == sendDIAG_SET_BRIGHTNESS_VAL((::dimming_inc_fi::EDeviceType)param1, param2))
            {
                ETG_TRACE_FATAL(("dispvidctrl_tclClientDimming::vHandleTraceMessage(): DispVidCtrl_DISPVIDCTRL_CMD_C_DIAG_SET_BRIGHTNESS_VAL %u %d successful.", ETG_ENUM(DISPVIDCTRL_DIMMING_DEVICETYPE, param1), param2 ));
            }
            else
            {
                ETG_TRACE_FATAL(("dispvidctrl_tclClientDimming::vHandleTraceMessage(): DispVidCtrl_DISPVIDCTRL_CMD_C_DIAG_SET_BRIGHTNESS_VAL %u %d failed!", ETG_ENUM(DISPVIDCTRL_DIMMING_DEVICETYPE, param1), param2 ));
            }
            // dispvidctrl_DISPVIDCTRL_CMD_C_DIAG_SET_BRIGHTNESS_VAL: user specific code end
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_CMD_C_GET_DIMMING_INFO_PRJ:
        {
            // Send the INC message SCC_DIMMING_C_GET_DIMMING_INFO_PRJ to V850.
    

            // dispvidctrl_DISPVIDCTRL_CMD_C_GET_DIMMING_INFO_PRJ: user specific code start
            if (TRUE == sendGET_DIMMING_INFO_PRJ())
            {
                ETG_TRACE_FATAL(("dispvidctrl_tclClientDimming::vHandleTraceMessage(): DispVidCtrl_DISPVIDCTRL_CMD_C_GET_DIMMING_INFO_PRJ successful." ));
            }
            else
            {
                ETG_TRACE_FATAL(("dispvidctrl_tclClientDimming::vHandleTraceMessage(): DispVidCtrl_DISPVIDCTRL_CMD_C_GET_DIMMING_INFO_PRJ failed!" ));
            }
            // dispvidctrl_DISPVIDCTRL_CMD_C_GET_DIMMING_INFO_PRJ: user specific code end
        }
        break;
    case DISPVIDCTRL_DIMMING_CMD_SET_CALIBRATION_VALUE:
        {
            // select Brightness value based on DISPVIDCTRL_CmdSET_BRIGHTNESS_OFFSET [row] [col] and send to V850.
            tU8 param1 = puchData[3];
            tU8 param2 = puchData[4];
    

            // dispvidctrl_DIMMING_CMD_SET_CALIBRATION_VALUE: user specific code start

   #ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1
            ETG_TRACE_USR4(("dispvidctrl_tclClientDimming::vHandleTraceMessage(): DISPVIDCTRL_DIMMING_CMD_SET_CALIBRATION_VALUE [%d][%d]", param1,param2));
            vSendDimBrightnessValToV850(param1, param2);

            /*tBool bproperty = 0;
            tU16 u16error = 0;

            dispvidctrl_tclServiceDimmingIf* m_poServerIf = dynamic_cast<dispvidctrl_tclServiceDimmingIf*>(_cpoMain->getHandler("dispvidctrl_tclServiceDimmingIf"));
             DISPVIDCTRL_NULL_POINTER_CHECK(m_poServerIf);
             m_poServerIf->onDIM_DISP_DAY_LUMINOSITY_OFFSETSet(param1,bproperty,u16error);

             dispvidctrl_tclClientVcan* m_poCANClientIf = dynamic_cast<dispvidctrl_tclClientVcan*>(_cpoMain->getHandler("dispvidctrl_tclClientVcan"));
              DISPVIDCTRL_NULL_POINTER_CHECK(m_poCANClientIf);
             m_poCANClientIf->onDayRheostatedLightMaxPercentTTFIsTrigger(param2);*/


   #else
            (tVoid) param1;
            (tVoid) param2;
   #endif

            // dispvidctrl_DIMMING_CMD_SET_CALIBRATION_VALUE: user specific code end
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_CMD_UPLOAD_USER_CONFIG_DAY_TABLE:
        {
            // Upload User Config Data from Python Tool , over TTFIS using Cmd DISPVIDCTRL_Cmd_UPLOAD_USER_CONFIG_DAY_TABLE (ROW_No, Row_u16ArrayData[21])
            tU8 param1 = puchData[3];
    

            // dispvidctrl_DISPVIDCTRL_CMD_UPLOAD_USER_CONFIG_DAY_TABLE: user specific code start
   #ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1
            ETG_TRACE_USR4((" :DISPVIDCTRL_DISPVIDCTRL_CMD_UPLOAD_USER_CONFIG_DAY_TABLE -> Enter"));
            int i,j;
            tU16 u16BrightnessVal = 0;
            if(param1 < 21)
            {
				for( (i = 0,j = 4); i<21; (i++, j++) )
				{
				   u16BrightnessVal = tU16((puchData[i+j]<<8) | puchData[i+j+1]);
				   vSetDayMatrixCellValue(param1,i, u16BrightnessVal);
				}
            }
            else
            {
            	ETG_TRACE_ERR((" :DISPVIDCTRL_DISPVIDCTRL_CMD_UPLOAD_USER_CONFIG_DAY_TABLE: Row[%d] Out of Range (0..20)",  param1));
            }
            //when last row is send just print whole arrays
            if(param1 == 20)
            {
               vStoreDayMatrixToDatapool();//store Day matrix to Persistence Storage
            }
   #else
            (tVoid) param1;
   #endif
            // dispvidctrl_DISPVIDCTRL_CMD_UPLOAD_USER_CONFIG_DAY_TABLE: user specific code end
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_CMD_UPLOAD_USER_CONFIG_NIGHT_TABLE:
        {
            // Upload User Config Data from Python Tool , over TTFIS using Cmd DISPVIDCTRL_Cmd_UPLOAD_USER_CONFIG_NIGHT_TABLE (ROW_No, Row_u16ArrayData[21])
            tU8 param1 = puchData[3];
    

            // dispvidctrl_DISPVIDCTRL_CMD_UPLOAD_USER_CONFIG_NIGHT_TABLE: user specific code start
   #ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1
            ETG_TRACE_USR4((" :DISPVIDCTRL_DISPVIDCTRL_CMD_UPLOAD_USER_CONFIG_NIGHT_TABLE -> Enter"));
            int i,j;
            tU16 u16BrightnessVal = 0;
            if(param1 < 21)
            {
				for( (i = 0,j = 4); i<21; (i++, j++) )
				{
				   u16BrightnessVal = tU16((puchData[i+j]<<8) | puchData[i+j+1]);
				   vSetNightMatrixCellValue(param1,i, u16BrightnessVal);
				}
            }
            else
            {
               //Display Error
               ETG_TRACE_ERR((" :DISPVIDCTRL_DISPVIDCTRL_CMD_UPLOAD_USER_CONFIG_NIGHT_TABLE: Row[%d] Out of Range (0..20)",  param1));
            }
            //when last row is send just store whole arrays
            if(param1 == 20)
            {
            	vStoreNightMatrixToDatapool(); //store Night matrix to Persistence Storage
            }
   #else
            (tVoid) param1;
   #endif
            // dispvidctrl_DISPVIDCTRL_CMD_UPLOAD_USER_CONFIG_NIGHT_TABLE: user specific code end
        }
        break;
    case DISPVIDCTRL_DIMMING_CMD_SET_KEY_ILLUM_OFFSET:
        {
            // Send DISPVIDCTRL_CmdSET_BRIGHTNESS_OFFSET value [index] to V850.
            tU8 param1 = puchData[3];
    

            // dispvidctrl_DIMMING_CMD_SET_KEY_ILLUM_OFFSET: user specific code start
#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1
            if(param1 <=21){
            	ETG_TRACE_FATAL(("DISPVIDCTRL_DIMMING_CMD_SET_KEY_ILLUM_OFFSET -> %d send to V850",param1));
            	vUpdateOffsetKeyBrightnessLevel(param1);
            }
            else {
            	ETG_TRACE_ERR((":DISPVIDCTRL_DIMMING_CMD_SET_KEY_ILLUM_OFFSET -> KeyOffset Out of Range"));
            }
#endif
            // dispvidctrl_DIMMING_CMD_SET_KEY_ILLUM_OFFSET: user specific code end
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_CMD_UPLOAD_USER_CONFIG_KEY_ILLUM_TABLE:
        {
            // Upload User Config Data from Python Tool , over TTFIS using Cmd DISPVIDCTRL_Cmd_UPLOAD_USER_CONFIG_KEY_ILLUM_TABLE (Row_u16ArrayData[21])
    

            // dispvidctrl_DISPVIDCTRL_CMD_UPLOAD_USER_CONFIG_KEY_ILLUM_TABLE: user specific code start
#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1
        	tU16* pU16KeyValues = (tU16*)&puchData[3];
        	ETG_TRACE_FATAL((":\tDISPVIDCTRL_DISPVIDCTRL_CMD_UPLOAD_USER_CONFIG_KEY_ILLUM_TABLE List:"));
        	int j = 3;
        	for(int i=0; i<21; i++, j++)
        	{
        		if(pU16KeyValues != NULL) {
        			_aKeyIllumBrightnessArray[i] = tU16((puchData[i+j]<<8) | puchData[i+j+1]);
        		}
        	}
        	vStoreKeyArrayToDatapool();
#endif
            // dispvidctrl_DISPVIDCTRL_CMD_UPLOAD_USER_CONFIG_KEY_ILLUM_TABLE: user specific code end
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_CMD_DOWNLOAD_USER_CONFIG_DISP_TABLE:
        {
            // Download User Config Data from Python Tool , over TTFIS using Cmd DISPVIDCTRL_Cmd_DOWNLOAD_USER_CONFIG_TABLE 
    

            // dispvidctrl_DISPVIDCTRL_CMD_DOWNLOAD_USER_CONFIG_DISP_TABLE: user specific code start
#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1
        	vUpdateDayBrightnessMatrix();
        	vUpdateNightBrightnessMatrix();
        	vPrintCalibrationMatrix(0);//Print Day Matrix
        	vPrintCalibrationMatrix(1);//Print Night Matrix
#endif
            // dispvidctrl_DISPVIDCTRL_CMD_DOWNLOAD_USER_CONFIG_DISP_TABLE: user specific code end
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_CMD_DOWNLOAD_USER_CONFIG_KEY_ILLUM_TABLE:
        {
            // Download User Config Data from Python Tool , over TTFIS using Cmd DISPVIDCTRL_Cmd_DOWNLOAD_USER_CONFIG_KEY_ILLUM_TABLE 
    

            // dispvidctrl_DISPVIDCTRL_CMD_DOWNLOAD_USER_CONFIG_KEY_ILLUM_TABLE: user specific code start
#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1
        	tU16 KeyIllumArray[21] = {0};
        	getKeyIllumMatrix(KeyIllumArray, 21);
        	ETG_TRACE_FATAL((":\tKeyIllumArray ---------->Print Start"));
        	ETG_TRACE_FATAL((":\tKeyIllumArray[21]={ %*d. }",
        							    ETG_LIST_LEN(21), ETG_LIST_PTR_T16(&KeyIllumArray[0])));
        	ETG_TRACE_FATAL((":\tKeyIllumArray ---------->Print END"));

        	//Printing T4VS Config Params
        	tU16 T4VSKeyIllumArray[3] = {0};
        	getT4VSKeyIllumConfigParam(T4VSKeyIllumArray);
        	ETG_TRACE_FATAL((":\tT4VSKeyIllumArray ---------->Print Start"));
        	ETG_TRACE_FATAL((":\tT4VSKeyIllumArray[3]={ %*d. }",
        							    ETG_LIST_LEN(3), ETG_LIST_PTR_T16(&T4VSKeyIllumArray[0])));
        	ETG_TRACE_FATAL((":\tT4VSKeyIllumArray ---------->Print END"));
#endif
            // dispvidctrl_DISPVIDCTRL_CMD_DOWNLOAD_USER_CONFIG_KEY_ILLUM_TABLE: user specific code end
        }
        break;
    case DISPVIDCTRL_DISPVIDCTRL_CMDTOOL_SET_T4VS_KEY_ILLUM_PARAM:
        {
            // Upload User values to PDD Datapool for Key Illum T4VS
            tU8 param1 = puchData[3];
            tU8 param2 = puchData[4];
            tU8 param3 = puchData[5];
    

            // dispvidctrl_DISPVIDCTRL_CMDTOOL_SET_T4VS_KEY_ILLUM_PARAM: user specific code start
#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1
            setT4VSKeyIllumConfigParam(param1, param2, param3);
#endif
            // dispvidctrl_DISPVIDCTRL_CMDTOOL_SET_T4VS_KEY_ILLUM_PARAM: user specific code end
        }
        break;

    // dispvidctrl_tclClientDimmingFunction_vHandleTraceMessageCase: user specific code start
    case DISPVIDCTRL_DIMMING_GETGENERALSTATUSINFO:
        {
            // Get the general dimming status information.
         vHandleTraceCmd_DIMMING_GETGENERALSTATUSINFO();
        }
        break;
    // dispvidctrl_tclClientDimmingFunction_vHandleTraceMessageCase: user specific code end

    default:
        ETG_TRACE_USR4(("dispvidctrl_tclClientDimming::vHandleTraceMessage(): unknown command %d.", u32MsgCode));
        break;
    }
    // dispvidctrl_tclClientDimmingFunction_vHandleTraceMessage: user specific code start
    // dispvidctrl_tclClientDimmingFunction_vHandleTraceMessage: user specific code end
    
    return;
}
// TR_CLASS_DISPVIDCTRL_CLIENT_DIMMING_trace: user specific code start
// TR_CLASS_DISPVIDCTRL_CLIENT_DIMMING_trace: user specific code end

