#ifndef _DIMMINGINCPROXY_H_
#define _DIMMINGINCPROXY_H_

/*****************************************************************************
* FILE:         dispvidctrl_ClientDimming.h
* PROJECT:      G3G project
* SW-COMPONENT: dispvidctrl
* Template:     incProxy.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  
*               Generated file
*               Do here INC handler specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2018 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/
#include <list>

// Dimming_incProxy_tclMainIncludes: user specific code start
#include "I_dispvidctrl_ServiceDimmingIf.h"
#include "I_dispvidctrl_tclDisplaySettings.h"
#include "I_dispvidctrl_tclSyncHandler.h"
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_generic_if.h"

#ifdef VARIANT_S_FTR_ENABLE_AIVI_NPIVI
//For P-IVI Second Screen Display
class I_dispvidctrl_tclSecondDispIf;
#endif

//Class Forward Declaration
class dispvidctrl_tclServiceDimmingIf;
class dispvidctrl_tclClientVcan;
class I_dispvidctrl_tclTouchDriverControl;
// Dimming_incProxy_tclMainIncludes: user specific code end

//include base class
#include "Idispvidctrl_ClientDimming.h"
#include "dispvidctrl_ClientDimmingIncFiDef.h"
#include "I_dispvidctrl_ClientDimmingIncAdaptor.h"
#include "Dimming_incCallbackIf.h"


class dispvidctrl_tclClientDimming : public I_dispvidctrl_tclClientDimming, public DimmingIncCallbackIf
{
private: 
   I_dispvidctrl_tclClientDimmingIncAdaptor*     _poThermalInc;
   tBool    _bAvailable;
   tU8 _u8DimMode_State;
   tU8 _u8prevDimMode_State;
public:
   dispvidctrl_tclClientDimming(dispvidctrl_tclAppMain* poMainAppl);
   virtual ~dispvidctrl_tclClientDimming();

   virtual const tChar* getName() const { return "dispvidctrl_tclClientDimming"; };
   
   virtual tVoid vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();

   virtual tBool bIsServiceAvailable() {return _bAvailable;};

   // DimmingIncCallbackIf interface
   virtual void onCOMPONENT_STATUS(::dimming_inc_fi::EApplicationStatus ApplicationStatus, tU8 ApplicationVersion);
   virtual void onREJECT(::dimming_inc_fi::ERejectReason RejectReason, tU8 RejectedMsgID);
   virtual void onDISPLAY_REQ(::dimming_inc_fi::EDisplayRequest DisplayRequest);
   virtual void onDISPLAY_READY(::dimming_inc_fi::EDisplayReady DisplayReady);
   virtual void onDISP_SET_BRIGHTNESS_LEVEL(tU8 DimmingModeAndDispBrightnessLevel, tU8 errorCode);
   virtual void onDISP_SET_DIMMING(tU32 DispBrightness, tU8 errorCode);
   virtual void onINFO_SET_DIMMINGMODE_CONFIG(::dimming_inc_fi::EDimmingMode DimmingMode);
   virtual void onINFO_GET_DIMMINGMODE_STATE(::dimming_inc_fi::EDimmingModeStatus DimmingMode, tS8 DispBrightnessOffset);
   virtual void onDIAG_DISP_READ_BRIGHT_VAL(tU8 DispBrightness);
   virtual void onDIAG_KEYB_READ_BRIGHT_VAL(tU8 KeyB_Brightness);
   virtual void onDIAG_KEYB_SET_DIMMING(tU8 KeyB_Brightness);
   virtual void onDIAG_SESSION(::dimming_inc_fi::ESessionType Session_Type);
   virtual void onDIAG_READ_BRIGHTNESS_VAL(::dimming_inc_fi::EDeviceType Device_Type, tU16 Brightness);
   virtual void onDIAG_SET_BRIGHTNESS_VAL(::dimming_inc_fi::EDeviceType Device_Type, tU16 Brightness);
   virtual void onGET_DIMMING_INFO_PRJ(tU32 DimInfoPrj);
   virtual void onSECOND_DISP_GET_HW_VERSION(tU32 HWVersion);
   virtual void onSECOND_DISP_GET_SW_VERSION(tU32 SWVersion);
   virtual void onSECOND_DISP_SET_DISPLAY_PARAMETERS(tU16 u16FunctionId, tU16 u16ParameterValue, tU8 u8ErrorCode);
   virtual void onSECOND_DISP_GET_DIMMING_PARAMETERS(tU8 u8BlackLevel, tU8 u8Brightness, tU8 u8Color, tU8 u8Contrast, tU8 u8Tint, tU16 u8GammaLevel);
   virtual void onSEND_POWERMODE_TO_V850(tU8 u8PowerState, tU8 u8ErrorCode);
   virtual void onSECOND_DISP_GET_SELF_DIAGNOSTIC_RESULT(tU16 u16SelfDiagResult );

   // I_dispvidctrl_tclClientDimming interface (to send INC messages)
   virtual tBool sendCOMPONENT_STATUS(::dimming_inc_fi::EApplicationStatus ApplicationStatus = ::dimming_inc_fi::eACTIVE, tU8 ApplicationVersion = 1);
   virtual tBool sendREJECT(::dimming_inc_fi::ERejectReason RejectReason, tU8 RejectedMsgID);
   virtual tBool sendDISPLAY_REQ(::dimming_inc_fi::EDisplayRequest DisplayRequest);
   virtual tBool sendDISPLAY_READY(::dimming_inc_fi::EDisplayReady DisplayReady);
   virtual tBool sendDISP_SET_BRIGHTNESS_LEVEL(tU8 DimmingModeAndDispBrightnessLevel);
   virtual tBool sendDISP_SET_DIMMING(tU32 DispBrightness);
   virtual tBool sendKEY_SET_BRIGHTNESS_LEVEL(tU8 KeyBrightnessLevel);
   virtual tBool sendINFO_SET_DIMMINGMODE_CONFIG(::dimming_inc_fi::EDimmingMode DimmingMode);
   virtual tBool sendINFO_GET_DIMMINGMODE_STATE();
   virtual tBool sendDIAG_DISP_READ_BRIGHT_VAL();
   virtual tBool sendDIAG_KEYB_READ_BRIGHT_VAL();
   virtual tBool sendDIAG_KEYB_SET_DIMMING(tU8 KeyB_Brightness);
   virtual tBool sendDIAG_SESSION(::dimming_inc_fi::ESessionType Session_Type);
   virtual tBool sendDIAG_READ_BRIGHTNESS_VAL(::dimming_inc_fi::EDeviceType Device_Type);
   virtual tBool sendDIAG_SET_BRIGHTNESS_VAL(::dimming_inc_fi::EDeviceType Device_Type, tU16 Brightness);
   virtual tBool sendGET_DIMMING_INFO_PRJ();
   virtual tBool sendSECOND_DISP_GET_HW_VERSION();
   virtual tBool sendSECOND_DISP_GET_SW_VERSION();
   virtual tBool sendSECOND_DISP_SET_DISPLAY_PARAMETERS(::dimming_inc_fi::ESecondDisplayParamID e16SecondDisplayParamID, tU16 u16ParameterValue);
   virtual tBool sendSECOND_DISP_GET_DIMMING_PARAMETERS();
   virtual tBool sendSEND_POWERMODE_TO_V850(tU8 u8PowerMode);
   virtual tBool sendSECOND_DISP_GET_SELF_DIAGNOSTIC_RESULT();
    // dispvidctrl_tclClientDimmingAddClassPart: user specific code start
   virtual tS32 s32ResetDimming(tVoid);
   virtual tBool bGetDimState(tVoid) const;
   virtual tU8 u8ReturnDimmingStatus();
#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1
   virtual void vSendDimBrightnessValToV850(tU8 u8RowOffset, tU8 u8ColOffset);
   virtual void vHandleDarkModeReq(tBool bStatus);
   virtual tU8  sUnitType(tVoid);
   virtual tU8 u8DimmingStrategy(tVoid);
   virtual tU8  u8GetLastDimmingMode_INCValue(tVoid);
   virtual tVoid vLoadDataFromMeter(tU8 u8CANOffsetValue);
   virtual tVoid vLoadDataFromHMI(tU8 u8HMIOffsetValue);
   virtual tVoid vLoadDataFromHMICockpitSlider(tU8 u8CockpitOffsetValue);
   virtual tVoid vUpdateINCforBrightness();
   virtual tVoid vReadDatapool();			//Reads datapool values and stores into member variables on profile change trigger

   //Functions to Populate the arrays (Brightness Matrix)
   virtual tVoid vSetDayMatrixCellValue(tS32 Row, tS32 Col, tU16 u16BrightnessVal);
   virtual tVoid vSetNightMatrixCellValue(tS32 Row, tS32 Col, tU16 u16BrightnessVal);
   virtual tVoid vPrintCalibrationMatrix(tU8 u8DayNightMode);

   virtual tVoid vUpdateDayBrightnessMatrix();
   virtual tVoid vUpdateNightBrightnessMatrix();
   virtual tVoid  vUpdateOffsetKeyBrightnessLevel(tU8 u8KeyBrightnessLevel);

   //Set of Interfaces to Updat Internal Matrix to Datapool
   virtual tVoid vStoreDayMatrixToDatapool();
   virtual tVoid vStoreNightMatrixToDatapool();
   virtual tVoid vStoreKeyArrayToDatapool();

   virtual tU8 u8GetDayOrNightSliderVal(tU8& DimmMode_Mode_Out)
   {
	   DimmMode_Mode_Out = u8GetLastDimmingMode_INCValue();
		/*	        INVALID = 0
		*	        DAY = 1
		*	        NIGHT = 2
		*	        AUTO_DAY = 3
		*	        AUTO_NIGHT = 4
		*/
	   return m_u8OffsetFromDayorNightHMISlider;
   }

   virtual tU8 u8GetHMICockpitSliderVal()
   {
	   return  m_u8OffsetFromHMICockpitSlider;
   }

#endif

   // NCG3D-13847: queue DIAG_SESSION
   virtual tBool qsendDIAG_SESSION(::dimming_inc_fi::ESessionType Session_Type);
   // NCG3D-13847: queue DIAG_SET_BRIGHTNESS_VAL
   virtual tBool qsendDIAG_SET_BRIGHTNESS_VAL(::dimming_inc_fi::EDeviceType Device_Type, tU16 Brightness);

private:
   // NCG3D-13847: data structure of queued dimming diagnosis messages
   struct tDiagDimMsg
   {
	   ::dimming_inc_fi::EMessageIds enMsgID;
	   ::dimming_inc_fi::EMessageIds enResMsgID;
	   union
	   {
		   struct tDIAG_SESSION
		   { // for eSCC_DIMMING_C_DIAG_SESSION
			   ::dimming_inc_fi::ESessionType Session_Type;
		   }DIAG_SESSION;
		   struct tDIAG_SET_BRIGHTNESS_VAL
		   { // for message eSCC_DIMMING_C_DIAG_SET_BRIGHTNESS_VAL
			   ::dimming_inc_fi::EDeviceType Device_Type;
			   tU16 Brightness;
		   }DIAG_SET_BRIGHTNESS_VAL;
	   }Data;
   } m_arrDiagDimMsg[10];
   tU16 m_u16DiagDimMsgWriteIdx;
   tU16 m_u16DiagDimMsgReadIdx;
   OSAL_tSemHandle m_hDiagDimMsgSemaphore;
   tBool bDiagDimMsgEmpty(tVoid) const;
   tBool bDiagDimMsgFull(tVoid) const;
   tU16 u16DiagDimMsgGetNextIdx(tU16 u16Idx) const;
   tU16 u16DiagDimMsgPush2Send(const tDiagDimMsg& pushMsg);
   tU16 u16DiagDimMsgPop2Send(const tDiagDimMsg& popMsg);
   tBool bDiagDimMsgSend(const tDiagDimMsg& tosendMsg);
   tBool bDiagDimMsgLock(tVoid) const;
   tVoid bDiagDimMsgUnlock(tVoid) const;
   // converting of CCA brightness level extended BLEX to CCA brightness level BL
   inline tU8 u8ConvertBlex2Bl(tU8 u8BLEX) const {
	   // Idx = BLEX / 8
	   tU16 _u16Idx = ((tU16)u8BLEX >> 3);
	   // Rest = BLEX % 8
	   tU16 _u16Rest = ((tU16)u8BLEX - (_u16Idx << 3));
	   if (4 < _u16Rest)
		   ++_u16Idx;
	   return (tU8)(_u16Idx + 1);
   };
   // handle trace command DIMMING_GETGENERALSTATUSINFO
   tVoid vHandleTraceCmd_DIMMING_GETGENERALSTATUSINFO(tVoid) const;

   // NCG3D-24831 ... handle new back light states
   tBool bHandleBacklightState(tenBackLightState eStates);

   // reference of own CCA service handler object
   Idispvidctrl_tclServiceDimmingIf* _poDimSrv;
   I_dispvidctrl_tclDisplaySettings* _poDisplaySettings;
   I_dispvidctrl_tclSyncHandler*     _poSyncHandler;
   I_dispvidctrl_tclTouchDriverControl* m_poTouchDriverControl;

   // NCG3D-24831 ... requested back light states
   tenBackLightState m_enBacklightState_SPM;
   tenBackLightState m_enBacklightState_CVM;
   tenBackLightState m_enBacklightState_HMI;
   tenBackLightState m_enBacklightState_BERR;
   tenBackLightState m_enBacklightState_HC;
   tenBackLightState m_enBacklightState_RVC;

   // NCG3D-26251 related NCG3D-24250
   ::dimming_inc_fi::EDimmingModeStatus m_enLast_DimmingMode;
   tS8 m_s8Last_DispBrightnessOffset;
   tU8 m_u8CountEqual_onINFO_GET_DIMMINGMODE_STATE;

   tU8   _u8DispBrightness;
   tU8   _u8KeybBrightness;
   tU8   _u8IllBrightness;
   tBool _bIllActive : 1;
   tBool _bMR_OUTPUT : 1;

   tBool _bDimState : 1;
   tBool _bCrVoltage : 1;
   tBool _bUseNewCatalog : 1;
   tBool _bMethodEmulationModeSetPending : 1;
   tBool _bMethodKeyBrightnessSetPending : 1;
   tBool _bMethodKeyPwmBrightnessSetPending : 1;
   tBool _bMethodDispBrightnessSetPending : 1;
   tBool _bMethodIcuBrightnessGetPending : 1;
   tBool _bReadBrightnessValKeybPending : 1;
   tBool _bReadBrightnessValDispPending : 1;
   tBool _bReadBrightnessValICUPending : 1;
   tBool m_bTouchDriverStarted : 1;

#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1
   //Array for Day and Night to be Populated from internal Datapool
   tU16 _aDayDispBrightnessMatrix[21][21];
   tU16 _aNightDispBrightnessMatrix[21][21];
   tU16 _aKeyIllumBrightnessArray[21];
   tU8   m_u8OffsetFromCAN;
   tU8   m_u8OffsetFromDayorNightHMISlider;
   tU8   m_u8OffsetFromHMICockpitSlider;
   tU8   m_u8DimmingStrategy;
   tBool m_bIsDarkModeEnabled;					//Alok
#endif

   //Private Member Functions
#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1
   tVoid getKeyIllumMatrix(tU16* KeyIllumArray, tU8 length);//Read and print TDataPoolScc_BRIGTHNESS_BACKLIGHT_NIGHTBUTTONS_ON
   tVoid setKeyIllumMatrix(tU16* KeyIllumArray, tU8 length);
   tVoid setT4VSKeyIllumConfigParam(tU16 u16Day_Day1, tU16 u16Day_Night1, tU16 u16Night_Night1);
   tVoid getT4VSKeyIllumConfigParam(tU16 (&KeyIllumArray)[3]);//Read and print TDataPoolScc_BRIGTHNESS_BACKLIGHT_NIGHTBUTTONS_ON
   tVoid vReset_Disp_SliderOffsetDatapoolElements(tU8 u8DefaultValue);
#endif

#ifdef VARIANT_S_FTR_ENABLE_AIVI_NPIVI
   I_dispvidctrl_tclSecondDispIf* _poSecondDispIfRef;
#endif
    // dispvidctrl_tclClientDimmingAddClassPart: user specific code end
};

#endif // _VEDA_THERMAL_H_

