
/*****************************************************************************
* FILE:         dispvidctrl_ClientVideomanagerIf.cpp
* PROJECT:      G3G project
* SW-COMPONENT: dispvidctrl
* Template:     ClientIf.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2018 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

// dispvidctrl_tclClientVideomanagerIfIncludes: user specific code start
// dispvidctrl_tclClientVideomanagerIfIncludes: user specific code end

#include "dispvidctrl_ClientVideomanagerIf.h"
#include "Idispvidctrl_ClientVideomanager.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DISPVIDCTRL_CLIENT_VIDEOMANAGER
#include "trcGenProj/Header/dispvidctrl_ClientVideomanagerIf.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: dispvidctrl_tclClientVideomanagerIf::
*             dispvidctrl_tclClientVideomanagerIf(dispvidctrl_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
dispvidctrl_tclClientVideomanagerIf::dispvidctrl_tclClientVideomanagerIf(dispvidctrl_tclAppMain* poMainAppl) : 
Idispvidctrl_tclClientVideomanagerIf(poMainAppl)
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientVideomanagerIf() entered."));
   _poClientRef = OSAL_NULL;

   // dispvidctrl_tclClientVideomanagerIfConstructor: user specific code start
   // dispvidctrl_tclClientVideomanagerIfConstructor: user specific code end

   //__PRPPERTY_PARAM_INIT__
}

/*******************************************************************************
*
* FUNCTION: dispvidctrl_tclClientVideomanagerIf::
*             ~dispvidctrl_tclClientVideomanagerIf(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
dispvidctrl_tclClientVideomanagerIf::~dispvidctrl_tclClientVideomanagerIf(tVoid)
{
   ETG_TRACE_USR4(("~dispvidctrl_tclClientVideomanagerIf() entered."));
   _poClientRef = OSAL_NULL;

   // dispvidctrl_tclClientVideomanagerIfDestructor: user specific code start
   // dispvidctrl_tclClientVideomanagerIfDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientVideomanagerIf::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'dispvidctrl_ClientVideomanagerIf.h':
*     Add forward declaration:
*         class Idispvidctrl_tclObject2Get;
*
*     Add declaration of object reference:
*         Idispvidctrl_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Idispvidctrl_tclObject2Get*>(_cpoMain->getHandler("Idispvidctrl_tclObject2Get"));
*     VIDEOMANAGER_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientVideomanagerIf::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientVideomanagerIf::vGetReferences() entered."));

   _poClientRef = dynamic_cast<Idispvidctrl_tclClientVideomanager*>(_cpoMain->getHandler("Idispvidctrl_tclClientVideomanager"));

   DISPVIDCTRL_NULL_POINTER_CHECK(_poClientRef);

   _poClientRef->vSetCallbackIf(this);

   //set callback interface

   // dispvidctrl_tclClientVideomanagerIfvGetReferences: user specific code start
   // dispvidctrl_tclClientVideomanagerIfvGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientVideomanagerIf::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientVideomanagerIf::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientVideomanagerIf::vStartCommunication() entered."));
   // dispvidctrl_tclClientVideomanagerIfvStartCommunication: user specific code start
   // dispvidctrl_tclClientVideomanagerIfvStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientVideomanagerIf::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   dispvidctrl_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientVideomanagerIf::vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientVideomanagerIf::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(dispvidctrl_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   
   // dispvidctrl_tclClientVideomanagerIfvHandleMessage: user specific code start
   // dispvidctrl_tclClientVideomanagerIfvHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientVideomanagerIf::vHandleTraceMessage()
*
* DESCRIPTION: Handle trace message.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientVideomanagerIf::vHandleTraceMessage(const tUChar* puchData)
{
   DISPVIDCTRL_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("dispvidctrl_tclClientVideomanagerIf::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // dispvidctrl_tclClientVideomanagerIfvHandleTraceMessage: user specific code start
   // dispvidctrl_tclClientVideomanagerIfvHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientVideomanagerIf::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientVideomanagerIf::vTraceInfo()
{
   // dispvidctrl_tclClientVideomanagerIfvTraceInfo: user specific code start
   // dispvidctrl_tclClientVideomanagerIfvTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientVideomanagerIf::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid dispvidctrl_tclClientVideomanagerIf::onServiceAvailable()
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientVideomanagerIf::onServiceAvailable() entered."));

   // dispvidctrl_tclClientVideomanagerIfvOnServiceAvailable: user specific code start
   // dispvidctrl_tclClientVideomanagerIfvOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientVideomanagerIf::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid dispvidctrl_tclClientVideomanagerIf::onServiceUnavailable()
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientVideomanagerIf::onServiceUnavailable() entered."));

   // dispvidctrl_tclClientVideomanagerIfvOnServiceUnavailable: user specific code start
   // dispvidctrl_tclClientVideomanagerIfvOnServiceUnavailable: user specific code end
}

tVoid dispvidctrl_tclClientVideomanagerIf::onRVCAStatus(videomanager_fi_tcl_e8_vdmSourceState RVCA_StateInfo) {
   ETG_TRACE_USR1( ( "dispvidctrl_tclClientVideomanagerIf::onRVCAStatus(): CALLED" ) );

   // onRVCAStatus: user specific code start
   // onRVCAStatus: user specific code end
}
tVoid dispvidctrl_tclClientVideomanagerIf::onRVCDStatus(videomanager_fi_tcl_e8_vdmSourceState RVCD_StateInfo) {
   ETG_TRACE_USR1( ( "dispvidctrl_tclClientVideomanagerIf::onRVCDStatus(): CALLED" ) );

   // onRVCDStatus: user specific code start
   // onRVCDStatus: user specific code end
}

tVoid dispvidctrl_tclClientVideomanagerIf::onRequestVideoSourceStateMResult(tBool bSourceChangeGranted) {
   ETG_TRACE_USR1( ( "dispvidctrl_tclClientVideomanagerIf::onRequestVideoSourceStateMResult(): CALLED" ) );

   // onRequestVideoSourceStateMResult: user specific code start
   // onRequestVideoSourceStateMResult: user specific code end
}



// dispvidctrl_tclClientVideomanagerIfdispvidctrl_ClientVideomanagerIf: user specific code start
// dispvidctrl_tclClientVideomanagerIfdispvidctrl_ClientVideomanagerIf: user specific code end

//EOF
