
/*****************************************************************************
* FILE:         dispvidctrl_ClientSpmIf.cpp
* PROJECT:      G3G project
* SW-COMPONENT: dispvidctrl
* Template:     ClientIf.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2018 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

// dispvidctrl_tclClientSpmIfIncludes: user specific code start
#include "dispvidctrl_datapool.h"
#include "dispvidctrl_tclControl.h"
#include "dispvidctrl_tclControl_Avm.h"
#include "dispvidctrl_tclControl_Rvc.h"
#include "dispvidctrl_tclControl_Mvc.h"
#include "dispvidctrl_tclControl_Video.h"
#include "Idispvidctrl_ClientVcan.h"

#include "dispvidctrl_tclTypes.h"
#include "dispvidctrl_ClientDimming.h"
// dispvidctrl_tclClientSpmIfIncludes: user specific code end

#include "dispvidctrl_ClientSpmIf.h"
#include "Idispvidctrl_ClientSpm.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DISPVIDCTRL_CLIENT_SPM
#include "trcGenProj/Header/dispvidctrl_ClientSpmIf.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: dispvidctrl_tclClientSpmIf::
*             dispvidctrl_tclClientSpmIf(dispvidctrl_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
dispvidctrl_tclClientSpmIf::dispvidctrl_tclClientSpmIf(dispvidctrl_tclAppMain* poMainAppl) : 
Idispvidctrl_tclClientSpmIf(poMainAppl)
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientSpmIf() entered."));
   _poClientRef = OSAL_NULL;

   // dispvidctrl_tclClientSpmIfConstructor: user specific code start
   m_poControl     = OSAL_NULL;
   m_poControl_Avm = OSAL_NULL;
   m_poControl_Rvc = OSAL_NULL;
   m_poControl_Mvc = OSAL_NULL;
   m_poControl_Video = OSAL_NULL;
   m_poClientVcan  = OSAL_NULL; 
   m_poClientDimming = OSAL_NULL;
   m_enSysPwrMode  = spm_fi_tcl_SPM_e32_SYSPWRMODE::FI_EN_SPM_U32_SYSPWRMODE_UNDEFINED;
   m_enCvmEvent    = (spm_fi_tcl_SPM_e32_CVM_EVENT::tenType) 0xffffffff;
   m_bIgnitionActive = FALSE;
   m_bAccActive      = FALSE;
   m_bDarkModeStatus	 = FALSE;
   // dispvidctrl_tclClientSpmIfConstructor: user specific code end

   //__PRPPERTY_PARAM_INIT__
}

/*******************************************************************************
*
* FUNCTION: dispvidctrl_tclClientSpmIf::
*             ~dispvidctrl_tclClientSpmIf(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
dispvidctrl_tclClientSpmIf::~dispvidctrl_tclClientSpmIf(tVoid)
{
   ETG_TRACE_USR4(("~dispvidctrl_tclClientSpmIf() entered."));
   _poClientRef = OSAL_NULL;

   // dispvidctrl_tclClientSpmIfDestructor: user specific code start
   m_poControl     = OSAL_NULL;
   m_poControl_Avm = OSAL_NULL;
   m_poControl_Rvc = OSAL_NULL;
   m_poControl_Mvc = OSAL_NULL;
   m_poControl_Video = OSAL_NULL;
   m_poClientVcan  = OSAL_NULL;
   m_poClientDimming = OSAL_NULL;
   // dispvidctrl_tclClientSpmIfDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientSpmIf::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'dispvidctrl_ClientSpmIf.h':
*     Add forward declaration:
*         class Idispvidctrl_tclObject2Get;
*
*     Add declaration of object reference:
*         Idispvidctrl_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Idispvidctrl_tclObject2Get*>(_cpoMain->getHandler("Idispvidctrl_tclObject2Get"));
*     SPM_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientSpmIf::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientSpmIf::vGetReferences() entered."));

   _poClientRef = dynamic_cast<Idispvidctrl_tclClientSpm*>(_cpoMain->getHandler("Idispvidctrl_tclClientSpm"));

   DISPVIDCTRL_NULL_POINTER_CHECK(_poClientRef);

   _poClientRef->vSetCallbackIf(this);

   //set callback interface

   // dispvidctrl_tclClientSpmIfvGetReferences: user specific code start
   m_poControl_Avm = dynamic_cast<dispvidctrl_tclControl_Avm*>(_cpoMain->getHandler("dispvidctrl_tclControl_Avm"));
   DISPVIDCTRL_NULL_POINTER_CHECK(m_poControl_Avm);

   m_poControl_Rvc = dynamic_cast<dispvidctrl_tclControl_Rvc*>(_cpoMain->getHandler("dispvidctrl_tclControl_Rvc"));
   DISPVIDCTRL_NULL_POINTER_CHECK(m_poControl_Rvc);
   
   m_poControl_Mvc = dynamic_cast<dispvidctrl_tclControl_Mvc*>(_cpoMain->getHandler("dispvidctrl_tclControl_Mvc"));
   DISPVIDCTRL_NULL_POINTER_CHECK(m_poControl_Mvc);

   m_poControl_Video = dynamic_cast<dispvidctrl_tclControl_Video*>(_cpoMain->getHandler("dispvidctrl_tclControl_Video"));
   DISPVIDCTRL_NULL_POINTER_CHECK(m_poControl_Video);

   m_poControl = dynamic_cast<dispvidctrl_tclControl*>(_cpoMain->getHandler("dispvidctrl_tclControl"));
   DISPVIDCTRL_NULL_POINTER_CHECK(m_poControl);

   m_poClientVcan = dynamic_cast<I_dispvidctrl_tclClientVcan*>(_cpoMain->getHandler("I_dispvidctrl_tclClientVcan"));
   DISPVIDCTRL_NULL_POINTER_CHECK(m_poClientVcan);

   m_poClientDimming = dynamic_cast<I_dispvidctrl_tclClientDimming*>(_cpoMain->getHandler("I_dispvidctrl_tclClientDimming"));
   DISPVIDCTRL_NULL_POINTER_CHECK(m_poClientDimming);
   // dispvidctrl_tclClientSpmIfvGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientSpmIf::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientSpmIf::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientSpmIf::vStartCommunication() entered."));
   // dispvidctrl_tclClientSpmIfvStartCommunication: user specific code start
   // dispvidctrl_tclClientSpmIfvStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientSpmIf::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   dispvidctrl_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientSpmIf::vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientSpmIf::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(dispvidctrl_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   
   switch (pMsg->eCmd)
   {
	    case dispvidctrl_tclBaseIf::eReverseOnDebounced:
			ETG_TRACE_USR4(("dispvidctrl_tclClientSpmIf::Setting RVC Substate as True"));
			sendOnOffTriggerMStart(spm_fi_tcl_SPM_e32_SubStateType::FI_EN_SPM_U32_SUBSTATE_RCV_CONNECTED,TRUE);
			break;

		case dispvidctrl_tclBaseIf::eReverseOff:
			ETG_TRACE_USR4(("dispvidctrl_tclClientSpmIf::Setting RVC Substate as False"));
			sendOnOffTriggerMStart(spm_fi_tcl_SPM_e32_SubStateType::FI_EN_SPM_U32_SUBSTATE_RCV_CONNECTED,FALSE);
			break;
			default:
         break;
   }
   // dispvidctrl_tclClientSpmIfvHandleMessage: user specific code start
   // dispvidctrl_tclClientSpmIfvHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientSpmIf::vHandleTraceMessage()
*
* DESCRIPTION: Handle trace message.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientSpmIf::vHandleTraceMessage(const tUChar* puchData)
{
   DISPVIDCTRL_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("dispvidctrl_tclClientSpmIf::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // dispvidctrl_tclClientSpmIfvHandleTraceMessage: user specific code start
   // dispvidctrl_tclClientSpmIfvHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientSpmIf::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid dispvidctrl_tclClientSpmIf::vTraceInfo()
{
   // dispvidctrl_tclClientSpmIfvTraceInfo: user specific code start
   // dispvidctrl_tclClientSpmIfvTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientSpmIf::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid dispvidctrl_tclClientSpmIf::onServiceAvailable()
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientSpmIf::onServiceAvailable() entered."));

   // dispvidctrl_tclClientSpmIfvOnServiceAvailable: user specific code start
   // dispvidctrl_tclClientSpmIfvOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid dispvidctrl_tclClientSpmIf::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid dispvidctrl_tclClientSpmIf::onServiceUnavailable()
{
   ETG_TRACE_USR4(("dispvidctrl_tclClientSpmIf::onServiceUnavailable() entered."));

   // dispvidctrl_tclClientSpmIfvOnServiceUnavailable: user specific code start
   // dispvidctrl_tclClientSpmIfvOnServiceUnavailable: user specific code end
}

tVoid dispvidctrl_tclClientSpmIf::onActiveOnOffTriggerStatus(std::vector<spm_fi_tcl_SPM_e32_SubStateType, std::allocator<spm_fi_tcl_SPM_e32_SubStateType> > tOnOffTriggerList) {
   ETG_TRACE_USR1( ( "dispvidctrl_tclClientSpmIf::onActiveOnOffTriggerStatus(): CALLED" ) );

   // onActiveOnOffTriggerStatus: user specific code start
   tBool bAccessory = FALSE;
   tBool bIgnition  = FALSE;
   tBool bChanged   = FALSE;
   tBool bDarkModeStatus = FALSE;

   std::vector<spm_fi_tcl_SPM_e32_SubStateType, std::allocator<spm_fi_tcl_SPM_e32_SubStateType> > ::iterator it;
   for (it = tOnOffTriggerList.begin(); it != tOnOffTriggerList.end();it++) {
      if (it->enType == spm_fi_tcl_SPM_e32_SubStateType::FI_EN_SPM_U32_SUBSTATE_S_CONTACT) {
         ETG_TRACE_USR1( ( "dispvidctrl_tclClientSpmIf::onActiveOnOffTriggerStatus(): ACC active" ) );
         bAccessory = TRUE;
      }
      if (it->enType == spm_fi_tcl_SPM_e32_SubStateType::FI_EN_SPM_U32_SUBSTATE_IGNITION) {
         ETG_TRACE_USR1( ( "dispvidctrl_tclClientSpmIf::onActiveOnOffTriggerStatus(): IGN active" ) );
         bIgnition = TRUE;
      }

      if (it->enType == spm_fi_tcl_SPM_e32_SubStateType::FI_EN_SPM_U32_SUBSTATE_DARK_SCREEN_REQ)
      {
          ETG_TRACE_USR1( ( "dispvidctrl_tclClientSpmIf::onActiveOnOffTriggerStatus(): DarkMode State(%d)", it->enType ) );
          bDarkModeStatus = TRUE;
      }

      ETG_TRACE_USR1( ( "dispvidctrl_tclClientSpmIf::onActiveOnOffTriggerStatus(): SPM State(%d)", it->enType ) );
   }
   //
   if(m_bDarkModeStatus != bDarkModeStatus)
   {
	   m_bDarkModeStatus = bDarkModeStatus;
#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1
	   if(m_poClientDimming != NULL)
	   {
		   m_poClientDimming->vHandleDarkModeReq(m_bDarkModeStatus);
		   ETG_TRACE_USR4( ( "dispvidctrl_tclClientSpmIf:vHandleDarkModeReq() is called " ) );
	   }
#endif
   }

   if (m_bAccActive != bAccessory) {
      ETG_TRACE_FATAL( ( "dispvidctrl_tclClientSpmIf::onActiveOnOffTriggerStatus(): ACC changed!" ) );
      m_bAccActive = bAccessory;
      bChanged = TRUE;
      _cpoMain->theServer()->vPostMsgAccChanged("", m_bAccActive);
   }

   if (m_bIgnitionActive != bIgnition) {
      ETG_TRACE_FATAL( ( "dispvidctrl_tclClientSpmIf::onActiveOnOffTriggerStatus(): IGN changed!" ) );
      m_bIgnitionActive = bIgnition;
      bChanged = TRUE;
      _cpoMain->theServer()->vPostMsgIgnChanged("", m_bIgnitionActive);
   }

   if (bChanged)
   {
      if (m_bAccActive && m_bIgnitionActive)
      {
         if (m_poClientVcan)
         {
            m_poClientVcan->vHandleControl(I_dispvidctrl_tclClientVcan::EN_CONTROL_CLIENT_CSM__SYSPWRMODE_RUN, (tU32) TRUE);
         }
      }
      else
      {
         if (m_poClientVcan)
         {
            m_poClientVcan->vHandleControl(I_dispvidctrl_tclClientVcan::EN_CONTROL_CLIENT_CSM__SYSPWRMODE_RUN, (tU32) FALSE);
         }
      }
   }
   // onActiveOnOffTriggerStatus: user specific code end
}
tVoid dispvidctrl_tclClientSpmIf::onSysPwrModeStatus(spm_fi_tcl_SPM_e32_SYSPWRMODE SysPwrMode) {
   ETG_TRACE_USR1( ( "dispvidctrl_tclClientSpmIf::onSysPwrModeStatus(): CALLED" ) );

   // onSysPwrModeStatus: user specific code start
   ETG_TRACE_USR1( ( " CL-SPM  :: onSysPwrModeStatus(): CALLED with %u", (tU32) SysPwrMode.enType) );
   if ( m_enSysPwrMode != SysPwrMode.enType )
   {
      m_enSysPwrMode = SysPwrMode.enType;
      if (    (spm_fi_tcl_SPM_e32_SYSPWRMODE::FI_EN_SPM_U32_SYSPWRMODE_RUN == m_enSysPwrMode)
            ||(spm_fi_tcl_SPM_e32_SYSPWRMODE::FI_EN_SPM_U32_SYSPWRMODE_CRANK == m_enSysPwrMode)
			||(spm_fi_tcl_SPM_e32_SYSPWRMODE::FI_EN_SPM_U32_SYSPWRMODE_ACCESSORY == SysPwrMode.enType))
      {
         ETG_TRACE_USR4((" CL-SPM  :: onSysPwrModeStatus()  IGNITION ON"));
         // forward to all assistants which need the info
         if (m_poControl_Avm)
         {
            m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__IGNITION, (tU32) TRUE );
         }
         if (m_poControl_Rvc)
         {
            m_poControl_Rvc->vHandleControl(EN_CONTROL_RVC__IGNITION, (tU32) TRUE );
         }
         if (m_poControl_Mvc)
         {
            m_poControl_Mvc->vHandleControl(EN_CONTROL_MVC__IGNITION, (tU32) TRUE );
         }
         if (m_poControl_Video)
         {
            m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__IGNITION, (tU32) TRUE);
         }
      }
   }
   // onSysPwrModeStatus: user specific code end
}
tVoid dispvidctrl_tclClientSpmIf::onCvmEventStatus(spm_fi_tcl_SPM_e32_CVM_EVENT CvmEvent) {
   ETG_TRACE_USR1( ( "dispvidctrl_tclClientSpmIf::onCvmEventStatus(): CALLED" ) );

   // onCvmEventStatus: user specific code start
// todo
   // use FI direct in ETG_CENUM
   //ETG_TRACE_USR1(( " CL-SPM  :: onCvmEventStatus(): cvm state = %d, last known cvm state = %d", ETG_CENUM(spm_fi_tcl_SPM_e32_CVM_EVENT::tenType, CvmEvent.enType), ETG_CENUM(spm_fi_tcl_SPM_e32_CVM_EVENT::tenType, m_enCvmEvent) ));
   ETG_TRACE_USR1(( " CL-SPM  :: onCvmEventStatus(): cvm state = %d, last known cvm state = %d", ETG_CENUM(tenCvmEvent, (tenCvmEvent) CvmEvent.enType), ETG_CENUM(tenCvmEvent, (tenCvmEvent) m_enCvmEvent) ));
   tU32 tU32VoltageLevel = (tU32) EN_LEVEL__NORMAL;
   tU32 tU32ControlEvent = (tU32) EN_CONTROL__NONE;
   tBool  bValid = TRUE;
   
   if ( m_enCvmEvent != CvmEvent.enType) 
   {
       bValid = bMapCvmEventStatus(CvmEvent, tU32ControlEvent, tU32VoltageLevel);
       if (bValid)
       {
           m_enCvmEvent = CvmEvent.enType;
           ETG_TRACE_USR4((" CL-SPM  :: onCvmEventStatus(): eControlEvent =%d, enVoltageLevel = %d", tU32ControlEvent, tU32VoltageLevel));
           if (m_poControl)
           {
               m_poControl->vHandleControl((tenControl) tU32ControlEvent, tU32VoltageLevel);
           }
       }
   }   
   if (CvmEvent.enType == spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_CRITICAL_LOW_VOLTAGE_START) {
       tChar strIfName[] = "I_dispvidctrl_tclClientDimming";
       _cpoMain->theServer()->vPostMsgDimCrLowVoltage(strIfName);
   } else if (CvmEvent.enType == spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_HIGH_VOLTAGE_START) {
       tChar strIfName[] = "I_dispvidctrl_tclClientDimming";
       _cpoMain->theServer()->vPostMsgDimHighVoltage(strIfName);
   } else if (
          (CvmEvent.enType == spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_HIGH_VOLTAGE_END) 
       || (CvmEvent.enType == spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_LOW_VOLTAGE_END) 
       )
   {
       tChar strIfName[] = "I_dispvidctrl_tclClientDimming";
       _cpoMain->theServer()->vPostMsgDimNormalVoltage(strIfName);
   }
   // onCvmEventStatus: user specific code end
}
tVoid dispvidctrl_tclClientSpmIf::onHmiStateStatus(spm_fi_tcl_SPM_e32_HMI_STATE HmiState) {
   ETG_TRACE_USR1( ( "dispvidctrl_tclClientSpmIf::onHmiStateStatus(): CALLED" ) );

   // onHmiStateStatus: user specific code start
   if(HmiState == spm_fi_tcl_SPM_e32_HMI_STATE::FI_EN_SPM_U32_HMISTATE_INACTIVE)
   {
	    ETG_TRACE_USR1( ( "dispvidctrl_tclClientSpmIf::onHmiStatus HU is in HMISTATE_INACTIVE and hence setting Safe state to true" ) );
            _cpoMain->theServer()->SetSafeState(TRUE);
   }
  /* else if(HmiState == spm_fi_tcl_SPM_e32_HMI_STATE::FI_EN_SPM_U32_HMISTATE_SHOW_HMI_HOUR_MODE)
   {
	    ETG_TRACE_USR1( ( "dispvidctrl_tclClientSpmIf::onHmiStatus HU is in Hour logic mode and hence setting Safe state to true" ) );
            _cpoMain->theServer()->SetSafeState(TRUE);
   }*/
   else
   {
	   ETG_TRACE_USR1( ( "dispvidctrl_tclClientSpmIf::onHmiStatus HU is in NON_HMISTATE_INACTIVE and hence setting safe state to false" ) );
           _cpoMain->theServer()->SetSafeState(FALSE);
   }
   if((HmiState == spm_fi_tcl_SPM_e32_HMI_STATE::FI_EN_SPM_U32_HMISTATE_SHOW_OFF) || (HmiState == spm_fi_tcl_SPM_e32_HMI_STATE::FI_EN_SPM_U32_HMISTATE_SHOW_HMI_HOUR_MODE)
	    || (HmiState == spm_fi_tcl_SPM_e32_HMI_STATE::FI_EN_SPM_U32_HMISTATE_SHOW_INFOTAINMENT_OFF) || (HmiState == spm_fi_tcl_SPM_e32_HMI_STATE::FI_EN_SPM_U32_HMISTATE_INACTIVE))
   {
	    ETG_TRACE_USR1( ( "dispvidctrl_tclClientSpmIf::onHmiStatus Ignition OFF" ) );
         if (m_poControl_Avm)
         {
            m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__IGNITION, (tU32) FALSE );
         }
         if (m_poControl_Rvc)
         {
            m_poControl_Rvc->vHandleControl(EN_CONTROL_RVC__IGNITION, (tU32) FALSE );
         }
         if (m_poControl_Mvc)
         {
            m_poControl_Mvc->vHandleControl(EN_CONTROL_MVC__IGNITION, (tU32) FALSE );
         }
         if (m_poControl_Video)
         {
            m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__IGNITION, (tU32) FALSE);
         }
   }
   else
   {
          ETG_TRACE_USR1( ( "dispvidctrl_tclClientSpmIf::onHmiStatus Ignition ON" ) );
          if (m_poControl_Avm)
         {
            m_poControl_Avm->vHandleControl(EN_CONTROL_AVM__IGNITION, (tU32) TRUE );
         }
         if (m_poControl_Rvc)
         {
            m_poControl_Rvc->vHandleControl(EN_CONTROL_RVC__IGNITION, (tU32) TRUE );
         }
         if (m_poControl_Mvc)
         {
            m_poControl_Mvc->vHandleControl(EN_CONTROL_MVC__IGNITION, (tU32)TRUE);
         }
         if (m_poControl_Video)
         {
            m_poControl_Video->vHandleControl(EN_CONTROL_VIDEO__IGNITION, (tU32)TRUE);
         }
        if((TRUE == _cpoMain->theServer()->getReverseGearStatusfromCMA()) || (TRUE == _cpoMain->theServer()->getReverseGearStatusfromCAN()) || (TRUE == _cpoMain->theServer()->getReverseCamRequest())){
	       m_poControl_Video->setGraphicslayerVisibility(1);
		   tChar strIfName[] = "";
			_cpoMain->theServer()->vPostMsgReverseOnDebounced(strIfName);
		}// get reversegearstatus
  }
   // onHmiStateStatus: user specific code end
}
tVoid dispvidctrl_tclClientSpmIf::onDimmingStateStatus(spm_fi_tcl_SPM_b32_DIM_STATE DimState) {
   ETG_TRACE_USR1( ( "dispvidctrl_tclClientSpmIf::onDimmingStateStatus(): CALLED" ) );

   // onDimmingStateStatus: user specific code start
   tU32 u32Data = (tU32) eBackLight_Spm_Off;
   if (DimState.bSPM_U32_DIMMINGSTATE_BACKLIGHT() || DimState.bSPM_U32DIMMINGSTATE_ALL_ON()) {
       u32Data = (tU32) eBackLight_Spm_On;
   }
   tChar strIfName[] = "I_dispvidctrl_tclClientDimming";
   _cpoMain->theServer()->vPostMsgDimStateChanged(strIfName, u32Data);
   // onDimmingStateStatus: user specific code end
}

tVoid dispvidctrl_tclClientSpmIf::onOnOffTriggerMResult() {
   ETG_TRACE_USR1( ( "dispvidctrl_tclClientSpmIf::onOnOffTriggerMResult(): CALLED" ) );

   // onOnOffTriggerMResult: user specific code start
   // onOnOffTriggerMResult: user specific code end
}



// dispvidctrl_tclClientSpmIfdispvidctrl_ClientSpmIf: user specific code start

tBool dispvidctrl_tclClientSpmIf::bMapCvmEventStatus(spm_fi_tcl_SPM_e32_CVM_EVENT CvmEvent, tU32& tU32ControlEvent, tU32& tU32VoltageLevel) {
   tBool bValid = TRUE;
   switch (CvmEvent.enType)
   {
      //Enter "critical low" range from "low" voltage level
      case spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_CRITICAL_LOW_VOLTAGE_START:
         tU32VoltageLevel = (tU32) EN_LEVEL__LOW_CRITICAL;
         tU32ControlEvent = (tU32) EN_CONTROL__CRITICAL_VOLTAGE_START;
         break;
      //Enter "low" range from "critical low" or "normal" voltage level
      case spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_CRITICAL_LOW_VOLTAGE_END:
      case spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_LOW_VOLTAGE_START:
         tU32VoltageLevel = (tU32) EN_LEVEL__LOW;
         tU32ControlEvent = (tU32) EN_CONTROL__CRITICAL_VOLTAGE_END;
         break;
      //Enter "normal" range from "high" or "low" voltage level
      case spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_LOW_VOLTAGE_END:
      case spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_NO_EVENT:
      case spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_HIGH_VOLTAGE_END:
         tU32VoltageLevel = (tU32) EN_LEVEL__NORMAL;
         tU32ControlEvent = (tU32) EN_CONTROL__CRITICAL_VOLTAGE_END;
         break;
      //Enter "high" range from "normal" or "critical high" voltage level
      case spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_HIGH_VOLTAGE_START:
      case spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_CRITICAL_HIGH_VOLTAGE_END:
         tU32VoltageLevel = (tU32) EN_LEVEL__HIGH;
         //tU32ControlEvent = (tU32) EN_CONTROL__CRITICAL_VOLTAGE_END;
         //In this project "critical high" voltage already starts with "high" voltage level
         tU32ControlEvent = (tU32) EN_CONTROL__CRITICAL_VOLTAGE_START;
         break;
      //Enter "critical high" from "high" voltage level
      case spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_CRITICAL_HIGH_VOLTAGE_START:
         tU32VoltageLevel = (tU32) EN_LEVEL__HIGH_CRITICAL;
         tU32ControlEvent = (tU32) EN_CONTROL__CRITICAL_VOLTAGE_START;
         break;
      default:
         ETG_TRACE_USR4((" CL-SPM  :: Error onCvmEventStatus. (unsupported cvm state = %d)", (tU32) CvmEvent.enType));
         bValid = FALSE;
         break;
   }
   return bValid;
}

tBool dispvidctrl_tclClientSpmIf::bIsCriticalVoltageActive() const
{
    tBool bRetVal = FALSE;

    switch (m_enCvmEvent)
    {
       //Enter critical low/high voltage
       case spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_CRITICAL_LOW_VOLTAGE_START:
       case spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_CRITICAL_HIGH_VOLTAGE_START:
          bRetVal = TRUE;
          break;

       //Exit or within "low/high/normal" voltage range
       case spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_CRITICAL_LOW_VOLTAGE_END:
       case spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_LOW_VOLTAGE_START:
       case spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_LOW_VOLTAGE_END:
       case spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_NO_EVENT:
       case spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_HIGH_VOLTAGE_END:
       case spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_HIGH_VOLTAGE_START:
       case spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_CRITICAL_HIGH_VOLTAGE_END:
          bRetVal = FALSE;
          break;

       default:
          ETG_TRACE_USR4((" CL-SPM  :: Error onCvmEventStatus. (unsupported cvm state = %d)", (tU32) m_enCvmEvent));
          bRetVal = FALSE;
          break;
    }

    return bRetVal;
}
// dispvidctrl_tclClientSpmIfdispvidctrl_ClientSpmIf: user specific code end

//EOF
